const clsMesModel = require("../MES/mes.model")
const clsApiMesModel = require("../model/mes_api.model")
const apiMesModel = new clsApiMesModel()
const mesModel = new clsMesModel()
const globalData = require("../global/globalData")
const path = require("path")
const NetworkLogs = require("../global/network.logger")
const Mutex = require('async-mutex').Mutex;
const mutex = new Mutex();
const mesValidation = require('../validation/MES/mes.Schema')
exports.generateToken = (req, res) => {
    const obj = {}
    NetworkLogs(req)
    mesModel.generateToken(req.body).then((data) => {
        res.set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req, res, data)
        res.send(data)
    }).catch(err => {
        res.statusCode = 500;
        res.set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req, res, err)
        res.send(err)
    })
}

exports.getMessage = async (req, res) => {
    const obj = {};
    try {
        const release = await mutex.acquire();

        NetworkLogs(req);

        const data = await mesModel.getMsg(req.body);

        res.set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            const tokenID = globalData.generatedToken[0];
            res.setHeader("token", tokenID);
        }

        NetworkLogs(req, res, data);

        res.send(data);

        release();
    } catch (err) {
        res.status(500).set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            const tokenID = globalData.generatedToken[0];
            res.setHeader("token", tokenID);
        }
        NetworkLogs(req, res, err);
        res.send(err);
        // release();
    }
};

exports.getMessageBalance = (req, res) => {
    const obj = {}
    NetworkLogs(req)
    mesModel.getMessageBalance(req.body).then((data) => {
        res.set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req, res, data)
        res.send(data)
    }).catch(err => {
        res.statusCode = 500;
        res.set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req, res, err)
        res.send(err)
    })
}

exports.acknowledge = (req, res) => {
    NetworkLogs(req)
    console.log(req.body);
    // const obj = {}
    // mesModel.acknowledge().then( (data) => {
    //     res.set('Content-Type', 'application/xml');
    //     if (globalData.generatedToken.length !== 0) {
    //         var tokenID = globalData.generatedToken[0]
    //         res.setHeader("token", tokenID)
    //     }
    //      NetworkLogs(req,res,responseObj)
    //     res.send(data)
    // }).catch(err => {
    //     res.statusCode = 500;
    //     res.set('Content-Type', 'application/xml');
    //     if (globalData.generatedToken.length !== 0) {
    //         var tokenID = globalData.generatedToken[0]
    //         res.setHeader("token", tokenID)
    //     }
    // NetworkLogs(req,res,responseObj)
    //     res.send(err)
    // })
}

exports.ackReceive = (req, res) => {
    const obj = {}
    NetworkLogs(req)
    mesModel.ackReceive(req.body).then((data) => {
        res.statusCode = 200
        // res.set('Content-Type', 'application/xml');
        // if (globalData.generatedToken.length !== 0) {
        //     var tokenID = globalData.generatedToken[0]
        //     res.setHeader("token", tokenID)
        // }
        NetworkLogs(req, res, data)
        res.send(data)
    }).catch(err => {
        res.statusCode = 500;
        res.set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req, res, err)
        res.send(err)
    })
}

exports.postMessage = (req, res) => {
    const obj = {}
    NetworkLogs(req)
    mesModel.postMessage1(req.body).then((data) => {
        res.set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req, res, data)
        res.send(data)
    }).catch(err => {
        res.statusCode = 500;
        res.set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req, res, err)
        res.send(err)
    })
}

exports.saveMesDataInCubical = (req, res) => {
    const obj = {}
    NetworkLogs(req)
    mesModel.postMessage1(req.body).then((data) => {
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req, res, data)
        res.send(data)
    }).catch(err => {
        res.statusCode = 500;
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req, res, err)
        res.send(err)
    })
}

exports.postToMes = (req, res) => {
    const obj = {}
    NetworkLogs(req)
    mesModel.postToMES(req.body).then((data) => {
        res.set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req, res, data)
        res.send(data)
    }).catch(err => {
        res.statusCode = 500;
        res.set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req, res, err)
        res.send(err)
    })
}

exports.postFailed = (req, res) => {
    const obj = {}
    NetworkLogs(req)
    mesModel.postFail(req.body).then((data) => {
        res.set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req, res, data)
        res.send(data)
    }).catch(err => {
        res.statusCode = 500;
        res.set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req, res, err)
        res.send(err)
    })
}

exports.postToManual = (req, res) => {
    const obj = {}
    NetworkLogs(req)
    mesModel.postToManual(req.body).then((data) => {
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req, res, data)
        res.send(data)
    }).catch(err => {
        res.statusCode = 500;
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req, res, err)
        res.send(err)
    })
}
exports.scanManual = (req, res) => {
    const obj = {}
    NetworkLogs(req)
    mesModel.scanManual(req.body).then((data) => {
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req, res, data)
        res.send(data)
    }).catch(err => {
        res.statusCode = 500;
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req, res, err)
        res.send(err)
    })
}

exports.batchEnd = (req, res) => {
    const obj = {}
    const {error, value} = mesValidation.ValidateBatchEnd().validate(req.body)
    NetworkLogs(req)
    if (error) {
        res.statusCode = 400
        res.send({
            status: "fail",
            message: error.message.replace(/"/g, "")
        })
    }
    apiMesModel.batchEnd(req.body).then( (data) => {
        NetworkLogs(req,res, data)
        res.send(data)
    }).catch(err => {
        res.statusCode = 500;
        NetworkLogs(req,res, err)
        res.send({
            status: "fail",
            message: "Internal Server Error"
        })
    })
}