//packages
const requestIp = require('request-ip');
const Joi = require('joi')

//models
const menuRequestModel = require('../model/Menu/MenuRequest.model');
const menuSchema = require('../validation/menu/menu.Schema');
const NetworkLogs = require("../global/network.logger")

//instance of respective classes
const objMenuRequestModel = new menuRequestModel();

// exports.getMenu = (req, res) => {
//     let responseObj = {};
//     NetworkLogs(req)
//     const { err, value } = menuSchema.ValidateGetMenu().validate(req.body);
//     if (err) {
//         res.statusCode = 400;
//         Object.assign(responseObj, {
//             status: 'fail',
//             message: err.details[0].message.replace(/"/g, "")
//         })
//         NetworkLogs(req,res,responseObj)
//         res.send(responseObj);
//     } else {
//         objMenuRequestModel.getMenu(req.body).then(ModelRes => {
//             res.statusCode = 200;
//             NetworkLogs(req,res,ModelRes)
//             res.send(ModelRes);
//         }).catch(err => {
//             console.log(err)
//             res.statusCode = 500;
//             let responseObj = {}
//             Object.assign(responseObj, {
//                 status: 'fail',
//                 message: 'Internal server error'
//             })
//             NetworkLogs(req,res,responseObj)
//             res.send(responseObj);
//         })
//     }
// }



// For MES
exports.getMenu = (req, res) => {
    var Ip = requestIp.getClientIp(req);
    let responseObj = {};
    // NetworkLogs(req)
    const { error, value } = menuSchema.ValidateGetMenu().validate(req);
    if (error) {
        res.statusCode = 400;
        Object.assign(responseObj, {
            status: 'fail',
            message: error.details[0].message.replace(/"/g, "")
        })
        // NetworkLogs(req, res, responseObj)
        // res.send(responseObj);
    } else {
        objMenuRequestModel.sendMenu(req, Ip).then(ModelRes => {
            res.statusCode = 200;
            NetworkLogs(req, res, ModelRes)
            res.send(ModelRes);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail',
                message: 'Internal server error'
            })
            // NetworkLogs(req, res, responseObj)
            // res.send(responseObj);
        })
    }
}

// exports.subGetMenu = (req, res) => {
//     let responseObj = {};
//     NetworkLogs(req)
//     Joi.validate(req.body, menuSchema.ValidatesubGetMenu(), (err, value) => {
//         if (err) {
//             res.statusCode = 400;
//             Object.assign(responseObj, {
//                 status: 'fail',
//                 message: err.details[0].message.replace(/"/g, "")
//             })
//             NetworkLogs(req, res, responseObj)
//             res.send(responseObj);
//         } else {
//             objMenuRequestModel.subGetMenu(req.body).then(ModelRes => {
//                 res.statusCode = 200;
//                 NetworkLogs(req, res, ModelRes)
//                 res.send(ModelRes);
//             }).catch(err => {
//                 console.log(err)
//                 res.statusCode = 500;
//                 let responseObj = {}
//                 Object.assign(responseObj, {
//                     status: 'fail',
//                     message: 'Internal server error'
//                 })
//                 NetworkLogs(req, res, responseObj)
//                 res.send(responseObj);
//             })
//         }
//     })
// }

exports.onMenuStart = (req, res) => {
    let responseObj = {};
    NetworkLogs(req)
    // const { error, value } = menuSchema.ValidateGetMenu().validate(req.body);
    const { error, value } = menuSchema.ValidateOnMenuStart().validate(req.body);
    if (error) {
        res.statusCode = 400;
        Object.assign(responseObj, {
            status: 'fail',
            message: error.details[0].message.replace(/"/g, "")
        })
        NetworkLogs(req, res, responseObj)
        res.send(responseObj);
    } else {
        objMenuRequestModel.onMenuStart(value).then(ModelRes => {
            res.statusCode = 200;
            NetworkLogs(req, res, ModelRes)
            res.send(ModelRes);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            Object.assign(responseObj, {
                status: 'fail',
                message: 'Internal server error'
            })
            NetworkLogs(req, res, responseObj)
            res.send(responseObj);
        })
    }
}

exports.getBarcodeData = (req, res) => {
    let responseObj = {};
    NetworkLogs(req)
    const { error, value } = menuSchema.ValidateGetBarcodeData().validate(req.body);
    if (error) {
        res.statusCode = 400;
        Object.assign(responseObj, {
            status: 'fail',
            message: error.details[0].message.replace(/"/g, "")
        })
        NetworkLogs(req, res, responseObj)
        res.send(responseObj);
    } else {
        objMenuRequestModel.getBarcodeData(value).then(ModelRes => {
            res.statusCode = 200;
            NetworkLogs(req, res, ModelRes)
            res.send(ModelRes);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            Object.assign(responseObj, {
                status: 'fail',
                message: 'Internal server error'
            })
            NetworkLogs(req, res, responseObj)
            res.send(responseObj);
        })
    }
}