//packages
const requestIp = require('request-ip');
const Joi = require('joi');
//modules
const LoginSchema = require('../validation/login/login.Schema');
const LoginModal = require('../model/Login/login.model');
const globalData = require('../global/globalData');
//instances of respective classes
const objLoginModal = new LoginModal();
const NetworkLogs = require("../global/network.logger")

exports.loginApi = (req, res) => {
    NetworkLogs(req)
    const { error, value } = LoginSchema.ValidateApiLogin().validate(req.body);
    if (error) {
        res.statusCode = 400;
        let responseObj = { status: 'Bad Request', message: error.details[0].message.replace(/\"/g, "") }
        NetworkLogs(req, res, responseObj)
        res.send(responseObj);
    }
    else {
        objLoginModal.loginApi(req.body)
            .then(result => {
                NetworkLogs(req, res, result)
                if (result.status === 'success') {
                    res.statusCode = 200;
                    res.json(result)
                }
                else {
                    res.statusCode = 200;
                    res.json(result)
                }
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail',
                    message: 'Internal server error'
                })
                NetworkLogs(req, res, responseObj)
                res.send(responseObj);
            });
    }
}

exports.logout = (req, res) => {
    var responseObj = {}
    NetworkLogs(req)
    const { error, value } = LoginSchema.ValidateUserLogout().validate(req.body);
    if (error) {
        res.statusCode = 400;
        Object.assign(responseObj, { status: 'Bad Request' }, { message: error.details[0].message.replace(/\"/g, "") })
        NetworkLogs(req, res, responseObj)
        res.send(responseObj);
    }
    else {
        objLoginModal.logout(req.body)
            .then(result => {
                res.statusCode = 200
                NetworkLogs(req, res, result)
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                Object.assign(responseObj, { status: 'fail' }, { message: 'Internal Server Error' })
                NetworkLogs(req, res, responseObj)
                res.send(responseObj);
            })
    }
}
// exports.logOutUser = (req, res) => {
//     Joi.validate(req.body, LoginSchema.ValidateUserLogout(), (err, value) => {
//         if (err) {
//             res.statusCode = 400;
//             let responseObj = {}
//             Object.assign(responseObj, {
//                 status: 'fail',
//                 message: err.details[0].message.replace(/"/g, "")
//             })
//             res.send(responseObj);
//         } else {
//             objLoginModal.logOut(value).then(ModelRes => {
//                 res.statusCode = 200;
//                 res.send(ModelRes);
//             }).catch(err => {
//                 console.log(err)
//                 res.statusCode = 500;
//                 let responseObj = {}
//                 Object.assign(responseObj, {
//                     status: 'fail',
//                     message: 'Internal server error'
//                 })
//                 res.send(responseObj);
//             })      }
//     })
// }

exports.powerBackup = (req, res) => {
    NetworkLogs(req)
    const { error, value } = LoginSchema.ValidatepowerBackup().validate(req.body);
    if (error) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail',
            message: error.details[0].message.replace(/"/g, "")
        })
        NetworkLogs(req, res, responseObj)
        res.send(responseObj);
    } else {
        objLoginModal.powerbackupcheck(value)
            .then((result) => {
                NetworkLogs(req, res, result)
                if (result.status === 'success') {
                    res.statusCode = 200;
                    res.json(result)
                } else {
                    res.statusCode = 200;
                    res.json(result)
                }
            }).catch((err) => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail',
                    message: 'Internal server error'
                })
                NetworkLogs(req, res, responseObj)
                res.send(responseObj);
            });
    }
}

//uncomment for powerbackup Rupali
// exports.ApiLogin = (req, res) => {
exports.powerBackupData = (req, res) => {
    NetworkLogs(req)
    const { error, value } = LoginSchema.ValidatepowerBackup().validate(req.body);
    if (error) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail',
            message: error.details[0].message.replace(/"/g, "")
        })
        NetworkLogs(req, res, responseObj)
        res.send(responseObj);
    } else {

        objLoginModal.powerbackup(value)
            .then((result) => {
                NetworkLogs(req, res, result)
                if (result.status === 'success') {
                    res.statusCode = 200;
                    res.json(result)
                } else {
                    res.statusCode = 200;
                    res.json(result)
                }
            }).catch((err) => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail',
                    message: 'Internal server error'
                })
                NetworkLogs(req, res, responseObj)
                res.send(responseObj);
            });
    }

}
exports.loginMain = (req, res) => {
    NetworkLogs(req)
    let Ip = requestIp.getClientIp(req);
    // Joi.validate(req.body, LoginSchema.ValidateUserCredential(), (err, value) => {
    //     if (err) {
    //         res.statusCode = 400;
    //         let responseObj = {}
    //         Object.assign(responseObj, {
    //             status: 'fail',
    //             message: err.details[0].message.replace(/"/g, "")
    //         })
    //         res.send(responseObj);
    //     } else {

    //     }



    // })


    objLoginModal.loginMain(req.body.userId, req.body.userPass, req.body.source, Ip, req.body.Hmi)
        .then((result) => {
            // if (result.status === 'success') {

            // } else {
            //     res.statusCode = 200;
            //     res.json(result)
            // }
            res.statusCode = 200;
            NetworkLogs(req, res, result)
            res.json(result)
        }).catch((err) => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail',
                message: 'Internal server error'
            })
            NetworkLogs(req, res, responseObj)
            res.send(responseObj);
        });
}

exports.changePassword = (req, res) => {
    let responseObj = {}
    let Ip = requestIp.getClientIp(req);
    NetworkLogs(req)
    Joi.validate(req.body, LoginSchema.ValidateChangePassword(), (err, value) => {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail',
                message: err.details[0].message.replace(/"/g, "")
            })
            NetworkLogs(req, res, responseObj)
            res.send(responseObj);
        } else {
            objLoginModal.changePasswordRequest(req.body)
                .then((result) => {
                    NetworkLogs(req, res, result)
                    if (result.status === 'success') {
                        res.statusCode = 200;
                        res.json(result)
                    } else {
                        res.statusCode = 200;
                        res.json(result)
                    }
                    // loggers.LoginApiLogger.info(JSON.stringify({ apiCalled: 'changePassword', objectSendByAndriod: req.body, resObj: result }));
                }).catch((err) => {
                    console.log(err)
                    res.statusCode = 500;
                    let responseObj = {}
                    Object.assign(responseObj, { status: 'fail' }, { message: 'Internal server error' })
                    NetworkLogs(req, res, responseObj)
                    res.send(responseObj);
                })
        }
    })
}

exports.passwordComplexity = (req, res) => {
    let responseObj = {}
    let Ip = requestIp.getClientIp(req);
    NetworkLogs(req)
    objLoginModal.passwordComplexity()
        .then((result) => {
            NetworkLogs(req, res, result)
            if (result.status === 'success') {
                res.statusCode = 200;
                res.json(result)
            } else {
                res.statusCode = 200;
                res.json(result)
            }
            // loggers.LoginApiLogger.info(JSON.stringify({ apiCalled: 'changePassword',  resObj: result }));
        }).catch((err) => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { message: 'Internal server error' })
            NetworkLogs(req, res, responseObj)
            res.send(responseObj);
        })
}

exports.powerBackup = (req, res) => {
    NetworkLogs(req)
    const { err, value } = LoginSchema.ValidatepowerBackup().validate(req.body);
    if (err) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail',
            message: err.details[0].message.replace(/"/g, "")
        })
        NetworkLogs(req, res, responseObj)
        res.send(responseObj);
    } else {
        objLoginModal.powerbackupcheck(value)
            .then((result) => {
                NetworkLogs(req, res, result)
                if (result.status === 'success') {
                    res.statusCode = 200;
                    res.json(result)
                } else {
                    res.statusCode = 200;
                    res.json(result)
                }
            }).catch((err) => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail',
                    message: 'Internal server error'
                })
                NetworkLogs(req, res, responseObj)
                res.send(responseObj);
            });
    }
}

exports.getIDS = (req, res) => {
    let responseObj = {}
    let Ip = requestIp.getClientIp(req);
    NetworkLogs(req)
    objLoginModal.getIDS(req)
        .then((result) => {
            NetworkLogs(req, res, result)
            if (result.status === 'success') {
                res.statusCode = 200;
                res.json(result)
            } else {
                res.statusCode = 200;
                res.json(result)
            }
            // loggers.LoginApiLogger.info(JSON.stringify({ apiCalled: 'changePassword',  resObj: result }));
        }).catch((err) => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { message: 'Internal server error' })
            NetworkLogs(req, res, responseObj)
            res.send(responseObj);
        })
}

exports.communicationoff = (req, res) => {
    let responseObj = {}
    let Ip = requestIp.getClientIp(req);
    NetworkLogs(req)
    objLoginModal.communicationOff(req.body)
        .then((result) => {
            NetworkLogs(req, res, result)
            if (result.status === 'success') {
                res.statusCode = 200;
                res.json(result)
            } else {
                res.statusCode = 200;
                res.json(result)
            }
            // loggers.LoginApiLogger.info(JSON.stringify({ apiCalled: 'changePassword',  resObj: result }));
        }).catch((err) => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { message: 'Internal server error' })
            NetworkLogs(req, res, responseObj)
            res.send(responseObj);
        })
}

exports.discardPowerBackup = (req, res) => {
    NetworkLogs(req)
    const { err, value } = LoginSchema.ValidateDiscardPowerBackup().validate(req.body);
    if (err) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail',
            message: err.details[0].message.replace(/"/g, "")
        })
        NetworkLogs(req, res, responseObj)
        res.send(responseObj);
    } else {

        objLoginModal.discardPowerBackup(value)
            .then((result) => {
                NetworkLogs(req, res, result)
                if (result.status === 'success') {
                    res.statusCode = 200;
                    res.json(result)
                } else {
                    res.statusCode = 200;
                    res.json(result)
                }
            }).catch((err) => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail',
                    message: 'Internal server error'
                })
                NetworkLogs(req, res, responseObj)
                res.send(responseObj);
            });
    }
}

exports.getDSList = (req, res) => {
    var Ip = requestIp.getClientIp(req);
    NetworkLogs(req)
    objLoginModal.getDSList(req)
        .then(result => {
            NetworkLogs(req, res, result)
            if (result.status === 'success') {
                res.statusCode = 200;
                res.json(result)
            }
            else {
                res.statusCode = 200;
                res.json(result)
            }
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail',
                message: 'Internal server error'
            })
            NetworkLogs(req, res, responseObj)
            res.send(responseObj);
        });
}

exports.getDSInfo = (req, res) => {
    NetworkLogs(req)
    const { error, value } = LoginSchema.ValidateGetDSInfo().validate(req.body);
    if (error) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail',
            message: error.details[0].message.replace(/"/g, "")
        })
        NetworkLogs(req, res, responseObj)
        res.send(responseObj);
    } else {
        objLoginModal.getDSInfo(req)
            .then((result) => {
                NetworkLogs(req, res, result)
                if (result.status === 'success') {
                    res.statusCode = 200;
                    res.json(result)
                } else {
                    res.statusCode = 200;
                    res.json(result)
                }
                // loggers.LoginApiLogger.info(JSON.stringify({ apiCalled: 'changePassword',  resObj: result }));
            }).catch((err) => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { message: 'Internal server error' })
                NetworkLogs(req, res, responseObj)
                res.send(responseObj);
            })
    }
}

exports.unbindDS = (req, res) => {
    NetworkLogs(req)
    const { error, value } = LoginSchema.ValidateUnbindDS().validate(req.body);
    if (error) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail',
            message: error.details[0].message.replace(/"/g, "")
        })
        NetworkLogs(req, res, responseObj)
        res.send(responseObj);
    } else {
        objLoginModal.unbindDS(req)
            .then((result) => {
                NetworkLogs(req, res, result)
                if (result.status === 'success') {
                    res.statusCode = 200;
                    res.json(result)
                } else {
                    res.statusCode = 200;
                    res.json(result)
                }
                // loggers.LoginApiLogger.info(JSON.stringify({ apiCalled: 'changePassword',  resObj: result }));
            }).catch((err) => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { message: 'Internal server error' })
                NetworkLogs(req, res, responseObj)
                res.send(responseObj);
            })
    }
}
exports.getResponsefromids = (req, res) => {
    NetworkLogs(req)
    const { error, value } = LoginSchema.ValidateResponseDS().validate(req.body);
    if (error) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail',
            message: error.details[0].message.replace(/"/g, "")
        })
        NetworkLogs(req, res, responseObj)
        res.send(responseObj);
    } else {
        objLoginModal.getResponsefromids(req)
            .then((result) => {
                NetworkLogs(req, res, result)
                if (result.status === 'success') {
                    res.statusCode = 200;
                    res.json(result)
                } else {
                    res.statusCode = 200;
                    res.json(result)
                }
                // loggers.LoginApiLogger.info(JSON.stringify({ apiCalled: 'changePassword',  resObj: result }));
            }).catch((err) => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { message: 'Internal server error' })
                NetworkLogs(req, res, responseObj)
                res.send(responseObj);
            })
    }
}

