const clsAckModel = require("../MES/ack.model")
const ackModel = new clsAckModel()
const globalData = require("../global/globalData")
const path = require("path")
const NetworkLogs = require("../global/network.logger")

exports.generateToken = (req, res) => {
    const obj = {}
    NetworkLogs(req)
    ackModel.generateToken(req.body).then( (data) => {
        res.set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req,res,data)
        res.send(data)
    }).catch(err => {
        res.statusCode = 500;
        res.set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req,res,err)
        res.send(err)
    })
}

exports.getMessage = (req, res) => {
    const obj = {}
    NetworkLogs(req)
    ackModel.getMsg(req.body).then( (data) => {
        res.set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req,res,data)
         res.send(data)
    }).catch(err => {
        res.statusCode = 500;
        res.set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req,res,err)
        res.send(err)
    })
}

exports.getMessageBalance = (req, res) => {
    const obj = {}
    NetworkLogs(req)
    ackModel.getMessageBalance(req.body).then( (data) => {
        res.set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req,res,data)
        res.send(data)
    }).catch(err => {
        res.statusCode = 500;
        res.set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req,res,err)
        res.send(err)
    })
}

exports.acknowledge = (req, res) => {
    NetworkLogs(req)
    console.log(req.body);
}

exports.postMessage = (req, res) => {
    const obj = {}
    NetworkLogs(req)
    ackModel.postMessage(req.body).then( (data) => {
        res.set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req,res,data)
        res.send(data)
    }).catch(err => {
        res.statusCode = 500;
        res.set('Content-Type', 'application/xml');
        if (globalData.generatedToken.length !== 0) {
            var tokenID = globalData.generatedToken[0]
            res.setHeader("token", tokenID)
        }
        NetworkLogs(req,res,err)
        res.send(err)
    })
}