const { create } = require("xmlbuilder2");
const oAuth2 = require('jsonwebtoken');
const { models } = require("../../config/dbConnection")
const moment = require("moment")
const crypto = require('crypto');
const globalData = require("../global/globalData")
const clsCommonWeightment = require("../model/Product/clsCommonWeightment");
const serverConfig = require('../../../IncrencyV4DRLTSHConfig.json')
// const date = require("date-and-time");
const clsActivityLog = require("../model/clsActivityLog.model");
const { Op, where } = require("sequelize");
const menuRequestModel = require('../model/Menu/MenuRequest.model');
const { sequelize } = require('../../config/dbConnection')
const date = require('date-and-time');
const clsIpqc = require('../model/IPQC/ipqc.model');
const GLOBAL_NOMENCLATURE = require("../global/GLOBAL_NOMENCLATURE");
const MqttModel = require('../model/Mqtt/mqttSender.class');
const clsCommonInsertOperationClass = require('../model/Product/clsCommonInsertOperation.model');
const tbl_calibration_positional_master_failed = require("../../../IncrencyV4_DRL_Model/models/Report/Calibration/Balance/Periodic/Positional/tbl_calibration_positional_master_failed");
const tbl_product_tablet = require("../../../IncrencyV4_DRL_Model/models/Master/Product/Tablet/tbl_product_tablet");
const { exceptions } = require("winston");
const mqttSender = new MqttModel();
const clsCommonInsertOperationObj = new clsCommonInsertOperationClass();
const objCommonOperation = new clsCommonWeightment();
const axios = require("axios");
const maths = require('mathjs');
const momentObj = require("moment");
const { fail } = require("assert");

//instances
const objIpqc = new clsIpqc();
const objActivityLog = new clsActivityLog();
const objMenuRequestModel = new menuRequestModel();
const objCommonWeightment = new clsCommonWeightment();



// update the flag as true when MES has configured as ack mode
let ackMode = true
let isProcessing = false
const systemId = (serverConfig.plant == 'FT03') ? GLOBAL_NOMENCLATURE.SystemIdFT03 : GLOBAL_NOMENCLATURE.SystemIdPU1;

class mesModel {
  constructor() { }

  async getMsg(req) {
    var mesData = globalData.MESArray.find(k => k.isPosted == false && k.isCompleted == true)
    // // if(isProcessing) {
    //   console.log("GetNextMessage is already processing request");
    //   var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    //   // return rootXml
    // // }
    // isProcessing = true;
    if (mesData) {
      let isManualPosting = (!mesData?.portNo) ? true : false
      mesData.isManualPosting = isManualPosting;
    }
    if (!mesData) {
      var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
      isProcessing = false
      return rootXml
    }

    console.log('mesData: ', mesData);
    // if (postMessageData.MoistureEquipmentId && postMessageData.isLOD) {
    if (!mesData.RptType && GLOBAL_NOMENCLATURE.LODMenu == mesData.menuName) {
      const data = await this.getMessageLOD(mesData)
      isProcessing = false
      return data
    } else if (!mesData.RptType && GLOBAL_NOMENCLATURE.LeakTestMenu == mesData.menuName) {
      const data = await this.getMessageLeakTest(mesData)
      isProcessing = false
      return data
    } else if (!mesData.RptType && GLOBAL_NOMENCLATURE.GroupMenu == mesData.menuName && mesData.Area != 'Coating') {
      const data = await this.getMessageCompressionGroup(mesData)
      isProcessing = false
      return data
    } else if (mesData.Area == 'Coating' && GLOBAL_NOMENCLATURE.GroupMenu == mesData.menuName) {
      const data = await this.getMessageCoatingGroup(mesData)
      isProcessing = false
      return data
    } else if (!mesData.RptType && GLOBAL_NOMENCLATURE.IndividualMenu == mesData.menuName) {
      const data = await this.getMessageCompressionInd(mesData)
      isProcessing = false
      return data
    } else if (!mesData.RptType && GLOBAL_NOMENCLATURE.HardnessMenu == mesData.menuName) {
      const data = await this.getMessageCompressionHardness(mesData)
      isProcessing = false
      return data
    } else if (mesData.RptType != undefined) {
      const data = await this.getMessageCompressionStartup(mesData)
      isProcessing = false
      return data
    } else if (mesData.RptType != undefined) {
      const data = await this.getMessageCompressionStartup(mesData)
      isProcessing = false
      return data
    } else {
      var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
      isProcessing = false
      return rootXml;
    }
  }

  async getMessageLOD(req) {
    var table = "tbl_lodmaster"
    var maxRepSerNo = await models[table].max("RepSerNo")
    var tableData = await models[table].findAll({
      where: {
        RepSerNo: req?.RepSerNo ?? maxRepSerNo
      }
    })


    var mid = crypto.randomUUID()

    var currentMESObj = req
    let lot = tableData[0].Lot
    if (tableData.length !== 0) {
      tableData = tableData[0]
      var LODInfo = await models.tbl_otherequipment.findAll({
        where: {
          Eqp_ID: req.instrumentId,
          Eqp_Type: GLOBAL_NOMENCLATURE.MoistureAnalyzer
        }
      })
      LODInfo = LODInfo[0]
      let batchId = currentMESObj.batchId
      let srNo = currentMESObj.Repetition
      let EquipmentId = currentMESObj.instrumentId

      var tableData = req?.payload?.[0]?.['data']?.value;

      var serialNo = tableData['SNR']
      var Temp = tableData['Drying Temp']
      var ProductName = tableData["Product Name"]
      var endtime = tableData["Measurement end"]
      var switchOff = tableData["Switch Off"]
      var DryingProgram = tableData["Drying Prog"]
      var InitalWt = tableData["Start Weight"]
      var FinalWt = tableData["Dry Weight"]
      var totalTime = tableData["Total time"]
      var LodValue = tableData["End Result"]

      if (!batchId || !srNo || !EquipmentId || currentMESObj.isPosted == true || !req) {
        var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
        return rootXml;
      }
      let messageId = (serverConfig.plant == "PUI") ? "Granulation_IPQC_LOD_Receive_BO" : "Granulation/Wurster_IPQC_LOD_Receive_BO";

      let root = create()
        .ele("MsiMessageContainer", { "xmlns:xsi": `http://www.w3.org/2001/XMLSchema-instance`, 'xmlns:xsd': `http://www.w3.org/2001/XMLSchema` })
        .ele("messageInstanceId").txt(crypto.randomUUID()).up()
        .ele("direction").txt("SF_TO_MES").up()
        .ele("systemId").txt(systemId).up()
        .ele("messageType").txt("MsiOrderParameterMessage").up()
        .ele("messageContext").txt("5203998621").up()
        .ele("message")
        .ele("MsiOrderParameterMessage")
        .ele("messageInstanceId").txt(crypto.randomUUID()).up()
        .ele("direction").txt("SF_TO_MES").up()
        .ele("messageId").txt(messageId).up()
        .ele("supplierId").txt("DRL").up()
        .ele("deviceTypeId").txt("DRL_MSI").up()
        .ele("supplierVersion").txt("1.0").up()
        .ele("functionalId").txt("QA Parameter").up()
        .ele("orderContext").txt("5219341842").up()
        .ele("creationTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up()

        .ele("parameter")
        .ele("name").txt("MPR").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(req.Mpn).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("BID").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(batchId).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("SID").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(req.sfoId).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("EID").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(EquipmentId).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("RT").up()
        .ele("dataType").txt("Long").up()
        .ele("value").txt(srNo).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("HT").up()
        .ele("dataType").txt("Double").up()
        .ele("value").txt(Temp).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("MN").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(ProductName).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("SOM").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(switchOff).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("MK").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(LODInfo.Eqp_Make).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("MD").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(LODInfo.Eqp_Model).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("SN").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(serialNo).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("DP").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(DryingProgram).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("ET").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(endtime).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("LN").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(lot).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("IW").up()
        .ele("dataType").txt("Double").up()
        .ele("value").txt(Number(InitalWt.split(' ')[0])).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("DW").up()
        .ele("dataType").txt("Double").up()
        .ele("value").txt(Number(FinalWt.split(' ')[0])).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("TDT").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(totalTime).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("LOD").up()
        .ele("dataType").txt("Double").up()
        .ele("value").txt(Number(LodValue.split(' ')[0])).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("MID").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(mid).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up().up().up().up()

      let xml = root.end({ prettyPrint: true });

      if (!ackMode) {
        globalData.MESArray.splice(globalData.MESArray.findIndex(k => k.isPosted == false && k.isCompleted == true && k.DsNo == req.DsNo && k.menuName == req.menuName && k.TabIp == req.TabIp), 1)
        await models.tbl_lodmaster.update({ IsPosted: 1, ismid: mid, ackMode: Number(ackMode) }, { where: { RepSerNo: mesData.RepSerNo } })
        await models.tbl_mes_data.destroy({ where: { DS_Number: req.selectedDSNo, isSetInCubical: 1 } });

        mqttSender.sendData(req.DsNo, `Port ${req.portNo}:${GLOBAL_NOMENCLATURE.DisplayMessage} ${GLOBAL_NOMENCLATURE.MESDataPosted}`);
        if (req.mqttProtocol) {
          setTimeout(() => mqttSender.sendData(req.DsNo, req.mqttProtocol), 1000);
        }
      } else {
        console.log("--------------------Global Array LOD -------------");
        console.log(globalData.MESArray);
        let mesArr = globalData.MESArray.find(k => k.isPosted == false && k.isCompleted == true && k.DsNo == req.DsNo && k.menuName == req.menuName && k.TabIp == req.TabIp)
        if (mesArr) {
          // let mesArr = globalData.MESArray.find(k => k.isPosted == false && k.isCompleted == true && k.DsNo == req.DsNo && k.menuName == req.menuName && k.TabIp == req.TabIp)
          mesArr.mid = mid
          mesArr.isPosted = true
          // req.mid = mid
          // req.isPosted = true
          console.log("--------------------Global Array LOD Set MId In ARR-------------");
          console.log(globalData.MESArray);
          await models.tbl_lodmaster.update({ IsPosted: 1, ackMode: Number(ackMode) }, { where: { RepSerNo: req.RepSerNo } })
        } else {
          console.log("No MES Data Found ")
        }
      }

      return xml;
    }

  }

  async getMessageCompressionGroup(req) {
    var messageId = "Compression_Operation_Receive_BO"
    // var obj = globalData.postMessageData
    // var currentMESObj = globalData.MESArray
    // if (Object.keys(obj).length === 0) {
    //   var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    //   return rootXml;
    // }
    // if (Object.keys(globalData.req.data).length === 0) {
    //   var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    //   return rootXml;
    // }
    // for (let key in obj) {
    //   if (obj[key].length == 0 || obj[key] == null || obj[key] == undefined) {
    //     var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    //     return rootXml;
    //   }
    // }

    var mesData = await models.tbl_mes_data.findAll({
      where: {
        DS_Number: req.selectedDSNo,
        BatchID: req.batchId,
        SFOID: req.sfoId,
        isSetInCubical: 1
      }
    })


    if (mesData.length === 0) {
      var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
      return rootXml;
    }

    mesData = mesData[0]

    if (mesData.AWBID && mesData.AWBID !== 'NA' && mesData.AWBID !== 'NUll') {
      var balanceInfo = await models.tbl_balance.findAll({
        where: {
          Bal_ID: mesData.AWBID
        }
      })
    }
    if (mesData.HTID && mesData.HTID !== 'NA' && mesData !== "NULL") {
      var hardnessInfo = await models.tbl_otherequipment.findAll({
        where: {
          Eqp_ID: mesData.HTID,
          Eqp_Type: GLOBAL_NOMENCLATURE.Hardness
        }
      })
    }


    var isPending = false;
    var currentValue;
    var sampleNumber;

    // for (let e in globalData.MESArray.data) {
    //   if (globalData.MESArray.data[e].isChecked === false) {
    //     currentValue = globalData.MESArray.data[e].actualWt;
    //     isPending = true;
    //     sampleNumber = Number(e) + 1
    //     break;
    //   }
    // }

    // if ((!(Number(obj.IndWtLow) <= Number(currentValue) && Number(currentValue) <= Number(obj.IndWtHigh))) && isPending == true) {
    //   const rootException = create({ version: '1.0' })
    //     .ele("MsiMessageContainer")
    //     .ele("messageInstanceId").txt(crypto.randomUUID()).up()
    //     .ele("direction").txt("SF_TO_MES").up()
    //     .ele("systemId").txt(2015).up()
    //     .ele("messageType").txt("MsiExceptionMessage").up()
    //     .ele("message")
    //     .ele("MsiExceptionMessage")
    //     .ele("messageInstanceId").txt(crypto.randomUUID()).up()
    //     .ele("creationTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
    //     .ele("exception")
    //     .ele("causedAt").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
    //     .ele("exceptionType").txt("MSI exception received from external system").up()
    //     .ele("user").txt("PASXAdmin").up()
    //     .ele("systemDescription").txt(`Repeation:${obj.Repetition}, Sample Number:${sampleNumber}, "Individual Weight" value out of limit(${obj.IndWtLow}-${obj.IndWtHigh}) = ${currentValue}`).up()
    //     .ele("userDescription").txt().up()
    //     .ele("manufacturingOrderID").txt().up()
    //     // .ele("deviationNumber").txt(1).up()
    //     .ele("sfoID").txt(obj.SFOID).up()
    //     .ele("batchNumber").txt(obj.BatchId).up()
    //     .ele("productionUnit").txt("productionUnit").up()
    //     .ele("equipmentID").txt().up()
    //     .ele("operationID").txt().up()
    //     .ele("stepID").txt().up().up().up().up().up()
    //   for (let e in globalData.MESArray.data) {
    //     if (globalData.MESArray.data[e].isChecked === false) {
    //       globalData.MESArray.data[e].isChecked = true
    //       break;
    //     }
    //   }
    //   let xml = rootException.end({ prettyPrint: true });
    //   return xml;
    // }
    // if (currentMESObj.isCompleted === false || isPending === true) {
    //   for (let e in globalData.MESArray.data) {
    //     if (globalData.MESArray.data[e].isChecked === false) {
    //       globalData.MESArray.data[e].isChecked = true
    //       break;
    //     }
    //   }
    //   var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    //   return rootXml;
    // }


    var mid = crypto.randomUUID()
    var data = req.payload.data[0].value;
    // globalData.MESArray.data.forEach(e => data += e.actualWt + "\n")
    const root = create({ version: '1.0' })
      .ele("MsiMessageContainer", { "xmlns:xsi": "http://www.w3.org/2001/XMLSchema-instance", "xmlns:xsd": "http://www.w3.org/2001/XMLSchema" })
      .ele("messageInstanceId").txt(crypto.randomUUID()).up()
      .ele("direction").txt("SF_TO_MES").up()
      .ele("systemId").txt(systemId).up()
      .ele("messageType").txt("MsiOrderParameterMessage").up()
      .ele("messageContext").txt("5203998621").up()
      .ele("message")
      .ele("MsiOrderParameterMessage")
      .ele("messageInstanceId").txt(crypto.randomUUID()).up()
      .ele("direction").txt("SF_TO_MES").up()
      .ele("messageId").txt(messageId).up()
      .ele("supplierId").txt("DRL").up()
      .ele("deviceTypeId").txt("DRL_MSI").up()
      .ele("supplierVersion").txt("1.0").up()
      .ele("functionalId").txt("QA Parameter").up()
      .ele("orderContext").txt("5203998621").up()
      .ele("creationTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()


      .ele("parameter")
      .ele("name").txt("MPR").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mesData.MPN).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("BID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mesData.BatchID).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("SID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mesData.SFOID).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("RT").up()
      .ele("dataType").txt("Long").up()
      .ele("value").txt(mesData.Repetition).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("TT").up()
      .ele("dataType").txt("String").up()
      // .ele("value").txt(mesData.TestType).up()
      .ele("value").txt(mesData.MesTestType).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("TSD").up()
      .ele("dataType").txt("String").up()
      // .ele("value").txt(mesData.Side).up()
      .ele("value").txt(mesData.MesSide).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("TSC").up()
      .ele("dataType").txt("Long").up()
      .ele("value").txt(mesData.SampleCount).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("TGSC").up()
      .ele("dataType").txt("Long").up()
      .ele("value").txt(mesData.GroupSampleCount).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("AID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mesData?.AWBID || "NA").up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("AMK").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(!balanceInfo || balanceInfo.length === 0 ? "NA" : balanceInfo[0]?.Bal_Make).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("AMD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(!balanceInfo || balanceInfo.length === 0 ? "NA" : balanceInfo[0].Bal_Model).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("GW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(data).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("IW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("IAW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("ISD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("IRSDP").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("ITTW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("IMW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("IMXW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("IDW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HTID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mesData?.HTID || "NA").up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HTTMK").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(!hardnessInfo || hardnessInfo.length === 0 ? "NA" : hardnessInfo[0]?.Eqp_Make).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HTMD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(!hardnessInfo || hardnessInfo.length === 0 ? "NA" : hardnessInfo[0]?.Eqp_Model).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HDH").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HDL").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HDR").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HDA").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HDSD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HDRSDP").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("TH").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("THH").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("THMX").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("THR").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("THA").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("THSD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("THRSD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("MID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mid).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .up()
      .up().up()

    let xml = root.end({ prettyPrint: true });

    if (!ackMode) {
      globalData.MESArray.splice(globalData.MESArray.findIndex(k => k.isPosted == false && k.isCompleted == true && k.DsNo == req.DsNo && k.menuName == req.menuName && k.TabIp == req.TabIp), 1)
      mqttSender.sendData(req.DsNo, `Port ${req.portNo}:${GLOBAL_NOMENCLATURE.DisplayMessage}: ${GLOBAL_NOMENCLATURE.MESDataPosted}`);
      if (req.mqttProtocol) {
        setTimeout(() => mqttSender.sendData(req.DsNo, req.mqttProtocol), 1000);
      }
    } else {
      mesData.mid = mid
      mesData.isPosted = true
    }

    return xml;

  }
  async getMessageCoatingGroup(req) {
    var messageId = serverConfig.plant == "PUI" ? "Coating_IPQC_Receive_BO" : "Coating_IPQC_Receive_BO_Dev";
    let mesData;
    if (!req.isManualPosting) {
      mesData = await models.tbl_mes_data.findAll({
        where: {
          DS_Number: req.selectedDSNo,
          BatchID: req.batchId,
          SFOID: req.sfoId,
          isSetInCubical: 1
        }
      })

      if (mesData.length === 0) {
        var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
        return rootXml;
      }

      mesData = mesData[0]

      if (mesData.AWBID && mesData.AWBID !== 'None' && mesData.AWBID !== 'NUll') {
        var balanceInfo = await models.tbl_balance.findAll({
          where: {
            Bal_ID: mesData.AWBID
          }
        })
      }
    } else {
      var masterData = await models.tbl_tab_master2.findAll({
        where: {
          RepSerNo: req.RepSerNo
        }
      })


      mesData = masterData[0]
      mesData.MPN = mesData.MPN_Code
      mesData.BatchID = mesData.BatchNo
      mesData.SFOID = mesData.SFOID
      mesData.LotNo = mesData.Lot
      // mesData.MesTestType = (mesData.RptType == 0) ? 'Inprocess' : 'Startup'
      mesData.MesSide = mesData.Side == 'NULL' ? 'NA' : mesData.Side
      mesData.SampleCount = mesData.Qty
      mesData.GroupSampleCount = mesData.GrpQty
      if (mesData.BalanceId && mesData.BalanceId !== 'None' && mesData.BalanceId !== 'NUll') {
        var balanceInfo = await models.tbl_balance.findAll({
          where: {
            Bal_ID: mesData.BalanceId
          }
        })
      }
    }

    let groupData = '';
    if (req.payload[GLOBAL_NOMENCLATURE.GroupMenu]) {
      req.payload[GLOBAL_NOMENCLATURE.GroupMenu].TestData.forEach(k => groupData += k.data.value + '\n')
      let groupCalcData = req.payload[GLOBAL_NOMENCLATURE.GroupMenu].TestInfo;

      averageWeightGrp = groupCalcData.averageWeight;
      maxWeightGrp = groupCalcData.maxWeight;
      minWeightGrp = groupCalcData.minWeight;
      rstdWeightGrp = groupCalcData.rstdWeight
      stdWeightGrp = groupCalcData.stdWeight;
      totalweightGrp = groupCalcData.totalweight;
    }

    var AWBID = mesData?.AWBID
    if (req.isManualPosting) {
      AWBID = (!clsCommonInsertOperationObj.isNullOrStringNull(mesData?.BalanceId)) ? mesData?.BalanceId : 'NA';
    }

    var mid = crypto.randomUUID()
    let root;
    if ((serverConfig.plant != "FT03")) {
      // Receive XML As PER the Receive XML
      root = create({ version: '1.0' })
        .ele("MsiMessageContainer", { "xmlns:xsi": "http://www.w3.org/2001/XMLSchema-instance", "xmlns:xsd": "http://www.w3.org/2001/XMLSchema" })
        .ele("messageInstanceId").txt(crypto.randomUUID()).up()
        .ele("direction").txt("SF_TO_MES").up()
        .ele("systemId").txt(systemId).up()
        .ele("messageType").txt("MsiOrderParameterMessage").up()
        .ele("messageContext").txt("5203998621").up()
        .ele("message")
        .ele("MsiOrderParameterMessage")
        .ele("messageInstanceId").txt(crypto.randomUUID()).up()
        .ele("direction").txt("SF_TO_MES").up()
        .ele("messageId").txt("Coating_IPQC_Receive_BO").up()
        .ele("supplierId").txt("DRL").up()
        .ele("deviceTypeId").txt("DRL_MSI").up()
        .ele("supplierVersion").txt("1.0").up()
        .ele("functionalId").txt("QA Parameter").up()
        .ele("orderContext").txt("5203998621").up()
        .ele("creationTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()


        .ele("parameter")
        .ele("name").txt("MPR").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(mesData.MPN).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("BID").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(mesData.BatchID).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("SID").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(mesData.SFOID).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("LN").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(mesData.LotNo).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("RT").up()
        .ele("dataType").txt("Long").up()
        .ele("value").txt(mesData.Repetition).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("TT").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(mesData.MesTestType).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("TSC").up()
        .ele("dataType").txt("Long").up()
        .ele("value").txt(mesData.SampleCount).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("AID").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(AWBID).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("AMK").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(!balanceInfo || balanceInfo.length === 0 ? "NA" : balanceInfo[0]?.Bal_Make).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("AMD").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(!balanceInfo || balanceInfo.length === 0 ? "NA" : balanceInfo[0].Bal_Model).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("GW").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt((req?.payload?.[0]?.['data']?.value == '') ? 'NA' : (Number(req?.payload?.[0]?.['data']?.value.split(' ')[0]) + ' g')).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("MID").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(mid).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .up()
        .up().up()
    }
    else {
      root = create({ version: '1.0' })
        .ele("MsiMessageContainer", { "xmlns:xsi": "http://www.w3.org/2001/XMLSchema-instance", "xmlns:xsd": "http://www.w3.org/2001/XMLSchema" })
        .ele("messageInstanceId").txt(crypto.randomUUID()).up()
        .ele("direction").txt("SF_TO_MES").up()
        .ele("systemId").txt(systemId).up()
        .ele("messageType").txt("MsiOrderParameterMessage").up()
        .ele("messageContext").txt("5203998621").up()
        .ele("message")
        .ele("MsiOrderParameterMessage")
        .ele("messageInstanceId").txt(crypto.randomUUID()).up()
        .ele("direction").txt("SF_TO_MES").up()
        .ele("messageId").txt(messageId).up()
        .ele("supplierId").txt("DRL").up()
        .ele("deviceTypeId").txt("DRL_MSI").up()
        .ele("supplierVersion").txt("1.0").up()
        .ele("functionalId").txt("QA Parameter").up()
        .ele("orderContext").txt("5203998621").up()
        .ele("creationTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()


        .ele("parameter")
        .ele("name").txt("MPR").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(mesData.MPN).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("BID").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(mesData.BatchID).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("SID").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(mesData.SFOID).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("LN").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(mesData.LotNo).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("RT").up()
        .ele("dataType").txt("Long").up()
        .ele("value").txt(mesData.Repetition).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("TT").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(mesData.MesTestType).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("TSC").up()
        .ele("dataType").txt("Long").up()
        .ele("value").txt(mesData.SampleCount).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("AID").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(AWBID).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("AMK").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(!balanceInfo || balanceInfo.length === 0 ? "NA" : balanceInfo[0]?.Bal_Make).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("AMD").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(!balanceInfo || balanceInfo.length === 0 ? "NA" : balanceInfo[0].Bal_Model).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("GW1").up()
        .ele("dataType").txt("Double").up()
        .ele("value").txt((req?.payload?.[0]?.['data']?.value == '') ? 'NA' : Number(req?.payload?.[0]?.['data']?.value.split(' ')[0])).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("GW2").up()
        .ele("dataType").txt("Double").up()
        .ele("value").txt((req?.payload?.[1]?.['data']?.value == '') ? 'NA' : Number(req?.payload?.[1]?.['data']?.value.split(' ')[0])).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("GW3").up()
        .ele("dataType").txt("Double").up()
        .ele("value").txt((req?.payload?.[2]?.['data']?.value == '') ? 'NA' : Number(req?.payload?.[2]?.['data']?.value.split(' ')[0])).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("AWPWT").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(`${req?.avg} `).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .ele("parameter")
        .ele("name").txt("MID").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(mid).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

        .up()
        .up().up()
    }

    var xml = root.end({ prettyPrint: true });
    if (!ackMode) {
      globalData.MESArray.splice(globalData.MESArray.findIndex(k => k.isPosted == false && k.isCompleted == true && k.DsNo == req.DsNo && k.menuName == req.menuName && k.TabIp == req.TabIp), 1)
      await models.tbl_tab_master2.update({ IsPosted: 1, ismid: mid, ackMode: Number(ackMode) }, { where: { RepSerNo: req.RepSerNo } })
      // await models.tbl_tab_initialmaster.update({ ismid: mid }, { where: { RepSerNo: mesData.RepSerNo } })
      await models.tbl_mes_data.destroy({ where: { DS_Number: req.selectedDSNo, isSetInCubical: 1 } });
      if (!req.isManualPosting) {
        mqttSender.sendData(req.DsNo, `Port ${req.portNo}:${GLOBAL_NOMENCLATURE.DisplayMessage} ${GLOBAL_NOMENCLATURE.MESDataPosted}`);
        if (req.mqttProtocol) {
          setTimeout(() => mqttSender.sendData(req.DsNo, req.mqttProtocol), 1000);
        }
      }
    } else {
      let mesArr = globalData.MESArray.find(k => k.isPosted == false && k.isCompleted == true && k.DsNo == req.DsNo && k.menuName == req.menuName && k.TabIp == req.TabIp)
      if (mesArr) {
        mesArr.mid = mid
        mesArr.isPosted = true
        mesData.mid = mid
        mesData.isPosted = true
        await models.tbl_tab_master2.update({ IsPosted: 1, ackMode: Number(ackMode) }, { where: { RepSerNo: req.RepSerNo } })
        // await models.tbl_mes_data.destroy({ where: { DS_Number: req.selectedDSNo } });
      }
      else {
        console.log(`No MES Data Found `)
      }
    }


    return xml;

  }


  async getMessageCompressionInd(req) {
    var messageId = "Compression_Operation_Receive_BO"
    // var obj = globalData.postMessageData
    // var currentMESObj = globalData.MESArray
    // if (Object.keys(obj).length === 0) {
    //   var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    //   return rootXml;
    // }
    // if (Object.keys(globalData.req.data).length === 0) {
    //   var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    //   return rootXml;
    // }
    // for (let key in obj) {
    //   if (obj[key].length == 0 || obj[key] == null || obj[key] == undefined) {
    //     var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    //     return rootXml;
    //   }
    // }

    var mesData = await models.tbl_mes_data.findAll({
      where: {
        DS_Number: req.selectedDSNo,
        BatchID: req.batchId,
        SFOID: req.sfoId,
        isSetInCubical: 1
      }
    })


    if (mesData.length === 0) {
      var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
      return rootXml;
    }

    mesData = mesData[0]

    if (mesData.AWBID && mesData.AWBID !== 'NA' && mesData.AWBID !== 'NUll') {
      var balanceInfo = await models.tbl_balance.findAll({
        where: {
          Bal_ID: mesData.AWBID
        }
      })
    }
    if (mesData.HTID && mesData.HTID !== 'NA' && mesData !== "NULL") {
      var hardnessInfo = await models.tbl_otherequipment.findAll({
        where: {
          Eqp_ID: mesData.HTID,
          Eqp_Type: GLOBAL_NOMENCLATURE.Hardness
        }
      })
    }


    var isPending = false;
    var currentValue;
    var sampleNumber;

    // for (let e in globalData.MESArray.data) {
    //   if (globalData.MESArray.data[e].isChecked === false) {
    //     currentValue = globalData.MESArray.data[e].actualWt;
    //     isPending = true;
    //     sampleNumber = Number(e) + 1
    //     break;
    //   }
    // }

    // if ((!(Number(obj.IndWtLow) <= Number(currentValue) && Number(currentValue) <= Number(obj.IndWtHigh))) && isPending == true) {
    //   const rootException = create({ version: '1.0' })
    //     .ele("MsiMessageContainer")
    //     .ele("messageInstanceId").txt(crypto.randomUUID()).up()
    //     .ele("direction").txt("SF_TO_MES").up()
    //     .ele("systemId").txt(2015).up()
    //     .ele("messageType").txt("MsiExceptionMessage").up()
    //     .ele("message")
    //     .ele("MsiExceptionMessage")
    //     .ele("messageInstanceId").txt(crypto.randomUUID()).up()
    //     .ele("creationTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
    //     .ele("exception")
    //     .ele("causedAt").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
    //     .ele("exceptionType").txt("MSI exception received from external system").up()
    //     .ele("user").txt("PASXAdmin").up()
    //     .ele("systemDescription").txt(`Repeation:${obj.Repetition}, Sample Number:${sampleNumber}, "Individual Weight" value out of limit(${obj.IndWtLow}-${obj.IndWtHigh}) = ${currentValue}`).up()
    //     .ele("userDescription").txt().up()
    //     .ele("manufacturingOrderID").txt().up()
    //     // .ele("deviationNumber").txt(1).up()
    //     .ele("sfoID").txt(obj.SFOID).up()
    //     .ele("batchNumber").txt(obj.BatchId).up()
    //     .ele("productionUnit").txt("productionUnit").up()
    //     .ele("equipmentID").txt().up()
    //     .ele("operationID").txt().up()
    //     .ele("stepID").txt().up().up().up().up().up()
    //   for (let e in globalData.MESArray.data) {
    //     if (globalData.MESArray.data[e].isChecked === false) {
    //       globalData.MESArray.data[e].isChecked = true
    //       break;
    //     }
    //   }
    //   let xml = rootException.end({ prettyPrint: true });
    //   return xml;
    // }
    // if (currentMESObj.isCompleted === false || isPending === true) {
    //   for (let e in globalData.MESArray.data) {
    //     if (globalData.MESArray.data[e].isChecked === false) {
    //       globalData.MESArray.data[e].isChecked = true
    //       break;
    //     }
    //   }
    //   var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    //   return rootXml;
    // }


    var mid = crypto.randomUUID()
    var data = ''
    req.payload.forEach(k => data += k.data.value + '\n');
    // globalData.MESArray.data.forEach(e => data += e.actualWt + "\n")
    const root = create({ version: '1.0' })
      .ele("MsiMessageContainer", { "xmlns:xsi": "http://www.w3.org/2001/XMLSchema-instance", "xmlns:xsd": "http://www.w3.org/2001/XMLSchema" })
      .ele("messageInstanceId").txt(crypto.randomUUID()).up()
      .ele("direction").txt("SF_TO_MES").up()
      .ele("systemId").txt(systemId).up()
      .ele("messageType").txt("MsiOrderParameterMessage").up()
      .ele("messageContext").txt("5203998621").up()
      .ele("message")
      .ele("MsiOrderParameterMessage")
      .ele("messageInstanceId").txt(crypto.randomUUID()).up()
      .ele("direction").txt("SF_TO_MES").up()
      .ele("messageId").txt(messageId).up()
      .ele("supplierId").txt("DRL").up()
      .ele("deviceTypeId").txt("DRL_MSI").up()
      .ele("supplierVersion").txt("1.0").up()
      .ele("functionalId").txt("QA Parameter").up()
      .ele("orderContext").txt("5203998621").up()
      .ele("creationTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()


      .ele("parameter")
      .ele("name").txt("MPR").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mesData.MPN).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("BID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mesData.BatchID).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("SID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mesData.SFOID).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("RT").up()
      .ele("dataType").txt("Long").up()
      .ele("value").txt(mesData.Repetition).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("TT").up()
      .ele("dataType").txt("String").up()
      // .ele("value").txt(mesData.TestType).up()
      .ele("value").txt(mesData.MesTestType).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("TSD").up()
      .ele("dataType").txt("String").up()
      // .ele("value").txt(mesData.Side).up()
      .ele("value").txt(mesData.MesSide).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("TSC").up()
      .ele("dataType").txt("Long").up()
      .ele("value").txt(mesData.SampleCount).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("TGSC").up()
      .ele("dataType").txt("Long").up()
      .ele("value").txt(mesData.GroupSampleCount).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("AID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mesData?.AWBID || "NA").up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("AMK").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(!balanceInfo || balanceInfo.length === 0 ? "NA" : balanceInfo[0]?.Bal_Make).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("AMD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(!balanceInfo || balanceInfo.length === 0 ? "NA" : balanceInfo[0].Bal_Model).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("GW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt('NA').up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("IW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(data).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("IAW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(req.cal_data.averageWeight).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("ISD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(req.cal_data.stdWeight).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("IRSDP").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(req.cal_data.rstdWeight).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("ITTW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(req.cal_data.totalweight).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("IMW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(req.cal_data.minWeight).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("IMXW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(req.cal_data.maxWeight).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("IDW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HTID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mesData?.HTID || "NA").up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HTTMK").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(!hardnessInfo || hardnessInfo.length === 0 ? "NA" : hardnessInfo[0]?.Eqp_Make).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HTMD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(!hardnessInfo || hardnessInfo.length === 0 ? "NA" : hardnessInfo[0]?.Eqp_Model).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HDH").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HDL").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HDR").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HDA").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HDSD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HDRSDP").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("TH").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("THM").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("THMX").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("THR").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("THA").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("THSD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("THRSD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("MID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mid).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .up()
      .up().up()

    let xml = root.end({ prettyPrint: true });

    if (!ackMode) {
      globalData.MESArray.splice(globalData.MESArray.findIndex(k => k.isPosted == false && k.isCompleted == true && k.DsNo == req.DsNo && k.menuName == req.menuName && k.TabIp == req.TabIp), 1)
      mqttSender.sendData(req.DsNo, `Port ${req.portNo}:${GLOBAL_NOMENCLATURE.DisplayMessage}: ${GLOBAL_NOMENCLATURE.MESDataPosted}`);
      if (req.mqttProtocol) {
        setTimeout(() => mqttSender.sendData(req.DsNo, req.mqttProtocol), 1000);
      }
    } else {
      mesData.mid = mid
      mesData.isPosted = true
    }

    return xml;

  }

  async getMessageCompressionHardness(req) {
    var messageId = "Compression_Operation_Receive_BO"
    // var obj = globalData.postMessageData
    // var currentMESObj = globalData.MESArray
    // if (Object.keys(obj).length === 0) {
    //   var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    //   return rootXml;
    // }
    // if (Object.keys(globalData.req.data).length === 0) {
    //   var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    //   return rootXml;
    // }
    // for (let key in obj) {
    //   if (obj[key].length == 0 || obj[key] == null || obj[key] == undefined) {
    //     var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    //     return rootXml;
    //   }
    // }

    var mesData = await models.tbl_mes_data.findAll({
      where: {
        DS_Number: req.selectedDSNo,
        BatchID: req.batchId,
        SFOID: req.sfoId,
        isSetInCubical: 1
      }
    })


    if (mesData.length === 0) {
      var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
      return rootXml;
    }

    mesData = mesData[0]

    if (mesData.AWBID && mesData.AWBID !== 'NA' && mesData.AWBID !== 'NUll') {
      var balanceInfo = await models.tbl_balance.findAll({
        where: {
          Bal_ID: mesData.AWBID
        }
      })
    }
    if (mesData.HTID && mesData.HTID !== 'NA' && mesData !== "NULL") {
      var hardnessInfo = await models.tbl_otherequipment.findAll({
        where: {
          Eqp_ID: mesData.HTID,
          Eqp_Type: GLOBAL_NOMENCLATURE.Hardness
        }
      })
    }


    var isPending = false;
    var currentValue;
    var sampleNumber;


    // check if any exception pending to send
    // if found then send exception and update exception table flag (isPosted)
    // if not found then send all data to mes. and send data posted successfully message.

    // for (let e in globalData.MESArray.data) {
    //   if (globalData.MESArray.data[e].isChecked === false) {
    //     currentValue = globalData.MESArray.data[e].actualWt;
    //     isPending = true;
    //     sampleNumber = Number(e) + 1
    //     break;
    //   }
    // }

    // if ((!(Number(obj.IndWtLow) <= Number(currentValue) && Number(currentValue) <= Number(obj.IndWtHigh))) && isPending == true) {
    //   const rootException = create({ version: '1.0' })
    //     .ele("MsiMessageContainer")
    //     .ele("messageInstanceId").txt(crypto.randomUUID()).up()
    //     .ele("direction").txt("SF_TO_MES").up()
    //     .ele("systemId").txt(2015).up()
    //     .ele("messageType").txt("MsiExceptionMessage").up()
    //     .ele("message")
    //     .ele("MsiExceptionMessage")
    //     .ele("messageInstanceId").txt(crypto.randomUUID()).up()
    //     .ele("creationTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
    //     .ele("exception")
    //     .ele("causedAt").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
    //     .ele("exceptionType").txt("MSI exception received from external system").up()
    //     .ele("user").txt("PASXAdmin").up()
    //     .ele("systemDescription").txt(`Repeation:${obj.Repetition}, Sample Number:${sampleNumber}, "Individual Weight" value out of limit(${obj.IndWtLow}-${obj.IndWtHigh}) = ${currentValue}`).up()
    //     .ele("userDescription").txt().up()
    //     .ele("manufacturingOrderID").txt().up()
    //     // .ele("deviationNumber").txt(1).up()
    //     .ele("sfoID").txt(obj.SFOID).up()
    //     .ele("batchNumber").txt(obj.BatchId).up()
    //     .ele("productionUnit").txt("productionUnit").up()
    //     .ele("equipmentID").txt().up()
    //     .ele("operationID").txt().up()
    //     .ele("stepID").txt().up().up().up().up().up()
    //   for (let e in globalData.MESArray.data) {
    //     if (globalData.MESArray.data[e].isChecked === false) {
    //       globalData.MESArray.data[e].isChecked = true
    //       break;
    //     }
    //   }
    //   let xml = rootException.end({ prettyPrint: true });
    //   return xml;
    // }
    // if (currentMESObj.isCompleted === false || isPending === true) {
    //   for (let e in globalData.MESArray.data) {
    //     if (globalData.MESArray.data[e].isChecked === false) {
    //       globalData.MESArray.data[e].isChecked = true
    //       break;
    //     }
    //   }
    //   var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    //   return rootXml;
    // }


    var mid = crypto.randomUUID()
    var hardData = ''
    var thickData = ''
    var indData = ''
    req.payload.data.forEach(k => hardData += (k.H.value || k.H) + '\n')
    req.payload.data.forEach(k => thickData += (k.T.value || k.T) + '\n')
    req.payload.data.forEach(k => indData += (k.W.value || k.W) + '\n')
    // globalData.MESArray.data.forEach(e => data += e.actualWt + "\n")
    const root = create({ version: '1.0' })
      .ele("MsiMessageContainer", { "xmlns:xsi": "http://www.w3.org/2001/XMLSchema-instance", "xmlns:xsd": "http://www.w3.org/2001/XMLSchema" })
      .ele("messageInstanceId").txt(crypto.randomUUID()).up()
      .ele("direction").txt("SF_TO_MES").up()
      .ele("systemId").txt(systemId).up()
      .ele("messageType").txt("MsiOrderParameterMessage").up()
      .ele("messageContext").txt("5203998621").up()
      .ele("message")
      .ele("MsiOrderParameterMessage")
      .ele("messageInstanceId").txt(crypto.randomUUID()).up()
      .ele("direction").txt("SF_TO_MES").up()
      .ele("messageId").txt(messageId).up()
      .ele("supplierId").txt("DRL").up()
      .ele("deviceTypeId").txt("DRL_MSI").up()
      .ele("supplierVersion").txt("1.0").up()
      .ele("functionalId").txt("QA Parameter").up()
      .ele("orderContext").txt("5203998621").up()
      .ele("creationTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()


      .ele("parameter")
      .ele("name").txt("MPR").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mesData.MPN).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("BID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mesData.BatchID).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("SID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mesData.SFOID).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("RT").up()
      .ele("dataType").txt("Long").up()
      .ele("value").txt(mesData.Repetition).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("TT").up()
      .ele("dataType").txt("String").up()
      // .ele("value").txt(mesData.TestType).up()
      .ele("value").txt(mesData.MesTestType).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("TSD").up()
      .ele("dataType").txt("String").up()
      // .ele("value").txt(mesData.Side).up()
      .ele("value").txt(mesData.MesSide).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("TSC").up()
      .ele("dataType").txt("Long").up()
      .ele("value").txt(mesData.SampleCount).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("TGSC").up()
      .ele("dataType").txt("Long").up()
      .ele("value").txt(mesData.GroupSampleCount).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("AID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mesData?.AWBID || "NA").up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("AMK").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(!balanceInfo || balanceInfo.length === 0 ? "NA" : balanceInfo[0]?.Bal_Make).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("AMD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(!balanceInfo || balanceInfo.length === 0 ? "NA" : balanceInfo[0].Bal_Model).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("GW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("IW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(indData).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("IAW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("ISD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("IRSDP").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("ITTW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("IMW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("IMXW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("IDW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HTID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mesData?.HTID || "NA").up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HTTMK").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(!hardnessInfo || hardnessInfo.length === 0 ? "NA" : hardnessInfo[0]?.Eqp_Make).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HTMD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(!hardnessInfo || hardnessInfo.length === 0 ? "NA" : hardnessInfo[0]?.Eqp_Model).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(hardData).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HDH").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(req.payload.testInfo?.MaxWeightHard).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HDL").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(req.payload.testInfo?.MinWeightHard).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HDR").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HDA").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(req.payload.testInfo?.AvgHard).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HDSD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(req.payload.testInfo?.StdDevHard).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("HDRSDP").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(req.payload.testInfo?.rstdHardDeviation).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("TH").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(thickData).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("THM").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(req.payload.testInfo?.MinWeightThick).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("THMX").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(req.payload.testInfo?.MaxWeightThick).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("THR").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("THA").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(req.payload.testInfo?.AvgThick).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("THSD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(req.payload.testInfo?.StdDevThick).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("THRSD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(req.payload.testInfo?.rstdThickDeviation).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("MID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mid).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .up()
      .up().up()

    let xml = root.end({ prettyPrint: true });

    if (!ackMode) {
      globalData.MESArray.splice(globalData.MESArray.findIndex(k => k.isPosted == false && k.isCompleted == true && k.DsNo == req.DsNo && k.menuName == req.menuName && k.TabIp == req.TabIp), 1)
      mqttSender.sendData(req.DsNo, `Port ${req.portNo}:${GLOBAL_NOMENCLATURE.DisplayMessage} ${GLOBAL_NOMENCLATURE.MESDataPosted}`);
      if (req.mqttProtocol) {
        setTimeout(() => mqttSender.sendData(req.DsNo, req.mqttProtocol), 1000);
      }
    } else {
      mesData.mid = mid
      mesData.isPosted = true
    }

    return xml;

  }

  async getMessageCompressionStartup(req) {
    // var messageId = "Compression_Operation_Receive_BO"
    var messageId = (serverConfig.plant != "FT03") ? "Compression_IPQC_Receive_BF_R1" : "Compression_Operation_Receive_BO"
    // var obj = globalData.postMessageData
    // var currentMESObj = globalData.MESArray
    // if (Object.keys(obj).length === 0) {
    //   var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    //   return rootXml;
    // }
    // if (Object.keys(globalData.req.data).length === 0) {
    //   var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    //   return rootXml;
    // }
    // for (let key in obj) {
    //   if (obj[key].length == 0 || obj[key] == null || obj[key] == undefined) {
    //     var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    //     return rootXml;
    //   }
    // }
    let mesData;
    if (!req.isManualPosting) {
      mesData = await models.tbl_mes_data.findAll({
        where: {
          DS_Number: req.selectedDSNo,
          BatchID: req.batchId,
          SFOID: req.sfoId,
          isSetInCubical: 1
        }
      })

      if (mesData.length === 0) {
        var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
        return rootXml;
      }

      mesData = mesData[0];

      if (mesData.AWBID && mesData.AWBID !== 'None' && mesData.AWBID !== 'NUll') {
        var balanceInfo = await models.tbl_balance.findAll({
          where: {
            Bal_ID: mesData.AWBID
          }
        })
      }
      if (mesData.HTID && mesData.HTID !== 'None' && mesData !== "NULL") {
        var hardnessInfo = await models.tbl_otherequipment.findAll({
          where: {
            Eqp_ID: mesData.HTID,
            Eqp_Type: {
              [Op.or]: [GLOBAL_NOMENCLATURE.Hardness, GLOBAL_NOMENCLATURE.MultiTester],
            },
          }
        })
      }
    } else {
      let masterTable = req.Area == 'Capsule Filling' ? 'tbl_cap_initialmaster' : 'tbl_tab_initialmaster'
      var masterData = await models[masterTable].findAll({
        where: {
          RepSerNo: req.RepSerNo
        }
      })


      mesData = masterData[0]

      if (mesData.ProductType == 2) { messageId = 'CapsuleFilling_IPQC_Receive_BO_Dev' }

      mesData.MPN = mesData.MPN_Code
      mesData.BatchID = mesData.BatchNo
      mesData.SFOID = mesData.SFOID
      // mesData.MesTestType = (mesData.RptType == 0) ? 'Inprocess' : 'Startup'
      mesData.MesSide = mesData.Side == 'NULL' ? 'NA' : mesData.Side
      mesData.SampleCount = mesData.Qty
      mesData.GroupSampleCount = (!req.isManualPosting) ? mesData.GrpQty : (serverConfig.plant == "PUI") ? mesData.GrpQty : mesData.Qty;
      mesData.StartSampleCount = mesData.StartSampleCount;
      if (mesData.BalanceId && mesData.BalanceId !== 'None' && mesData.BalanceId !== 'NUll') {
        var balanceInfo = await models.tbl_balance.findAll({
          where: {
            Bal_ID: mesData.BalanceId
          }
        })
      }
      if (mesData.HardnessID && mesData.HardnessID !== 'None' && mesData !== "NULL") {
        var hardnessInfo = await models.tbl_otherequipment.findAll({
          where: {
            Eqp_ID: mesData.HardnessID,
            Eqp_Type: {
              [Op.or]: [GLOBAL_NOMENCLATURE.Hardness, GLOBAL_NOMENCLATURE.MultiTester],
            },
          }
        })
      }
    }


    var isPending = false;
    var currentValue;
    var sampleNumber;

    // for (let e in globalData.MESArray.data) {
    //   if (globalData.MESArray.data[e].isChecked === false) {
    //     currentValue = globalData.MESArray.data[e].actualWt;
    //     isPending = true;
    //     sampleNumber = Number(e) + 1
    //     break;
    //   }
    // }

    // if ((!(Number(obj.IndWtLow) <= Number(currentValue) && Number(currentValue) <= Number(obj.IndWtHigh))) && isPending == true) {
    //   const rootException = create({ version: '1.0' })
    //     .ele("MsiMessageContainer")
    //     .ele("messageInstanceId").txt(crypto.randomUUID()).up()
    //     .ele("direction").txt("SF_TO_MES").up()
    //     .ele("systemId").txt(2015).up()
    //     .ele("messageType").txt("MsiExceptionMessage").up()
    //     .ele("message")
    //     .ele("MsiExceptionMessage")
    //     .ele("messageInstanceId").txt(crypto.randomUUID()).up()
    //     .ele("creationTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
    //     .ele("exception")
    //     .ele("causedAt").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
    //     .ele("exceptionType").txt("MSI exception received from external system").up()
    //     .ele("user").txt("PASXAdmin").up()
    //     .ele("systemDescription").txt(`Repeation:${obj.Repetition}, Sample Number:${sampleNumber}, "Individual Weight" value out of limit(${obj.IndWtLow}-${obj.IndWtHigh}) = ${currentValue}`).up()
    //     .ele("userDescription").txt().up()
    //     .ele("manufacturingOrderID").txt().up()
    //     // .ele("deviationNumber").txt(1).up()
    //     .ele("sfoID").txt(obj.SFOID).up()
    //     .ele("batchNumber").txt(obj.BatchId).up()
    //     .ele("productionUnit").txt("productionUnit").up()
    //     .ele("equipmentID").txt().up()
    //     .ele("operationID").txt().up()
    //     .ele("stepID").txt().up().up().up().up().up()
    //   for (let e in globalData.MESArray.data) {
    //     if (globalData.MESArray.data[e].isChecked === false) {
    //       globalData.MESArray.data[e].isChecked = true
    //       break;
    //     }
    //   }
    //   let xml = rootException.end({ prettyPrint: true });
    //   return xml;
    // }
    // if (currentMESObj.isCompleted === false || isPending === true) {
    //   for (let e in globalData.MESArray.data) {
    //     if (globalData.MESArray.data[e].isChecked === false) {
    //       globalData.MESArray.data[e].isChecked = true
    //       break;
    //     }
    //   }
    //   var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    //   return rootXml;
    // }

    let individualData = '';
    let groupData = '';
    let hardData = '';
    let thickData = '';
    let hardIndData = '';
    let friabBeforeWt = 'NA';
    let friabAfterWt = 'NA';
    let actualPer = 'NA';
    let dtTime = 'NA';
    let emptyGrpData = '';
    let NetContentData = '';

    let averageWeightInd = 'NA';
    let maxWeightInd = 'NA';
    let minWeightInd = 'NA';
    let rstdWeightInd = 'NA'
    let stdWeightInd = 'NA';
    let totalweightInd = 'NA';

    let averageWeightGrp = 'NA';
    let maxWeightGrp = 'NA';
    let minWeightGrp = 'NA';
    let rstdWeightGrp = 'NA'
    let stdWeightGrp = 'NA';
    let totalweightGrp = 'NA';

    let averageWeightEmpGrp = 'NA';
    let maxWeightEmpGrp = 'NA';
    let minWeightEmpGrp = 'NA';
    let rstdWeightEmpGrp = 'NA'
    let stdWeightEmpGrp = 'NA';
    let totalweightEmpGrp = 'NA';

    let averageWeightNet = 'NA';
    let maxWeightNet = 'NA';
    let minWeightNet = 'NA';
    let rstdWeightNet = 'NA'
    let stdWeightNet = 'NA';
    let totalweightNet = 'NA';
    let diff_net = 'NA';


    let averageWeightHrd = 'NA';
    let maxWeightHrd = 'NA';
    let minWeightHrd = 'NA';
    let rstdWeightHrd = 'NA'
    let stdWeightHrd = 'NA';
    let totalweightHrd = 'NA';
    let rangeHrd = 'NA';

    let averageWeightThick = 'NA';
    let maxWeightThick = 'NA';
    let minWeightThick = 'NA';
    let rstdWeightThick = 'NA'
    let stdWeightThick = 'NA';
    let totalweightThick = 'NA';
    let rangeThick = 'NA';
    let ind_Diff = 'NA';

    if (req.payload[GLOBAL_NOMENCLATURE.Friability]) {
      friabBeforeWt = req.payload[GLOBAL_NOMENCLATURE.Friability][0].data.BeforeValue;
      friabAfterWt = req.payload[GLOBAL_NOMENCLATURE.Friability][0].data.AfterValue;
      actualPer = req.payload[GLOBAL_NOMENCLATURE.Friability][0].data.NetValue;
    }
    if (req.payload[GLOBAL_NOMENCLATURE.DTMenu]) { dtTime = req.payload[GLOBAL_NOMENCLATURE.DTMenu][0].data.value }

    if (req.payload[GLOBAL_NOMENCLATURE.IndividualMenu]) {
      req.payload[GLOBAL_NOMENCLATURE.IndividualMenu].TestData.forEach(k => individualData += k.data.value + '\n')
      let individualCalcData = req.payload[GLOBAL_NOMENCLATURE.IndividualMenu].TestInfo

      averageWeightInd = individualCalcData.averageWeight;
      maxWeightInd = individualCalcData.maxWeight;
      minWeightInd = individualCalcData.minWeight;
      rstdWeightInd = individualCalcData.rstdWeight
      stdWeightInd = individualCalcData.stdWeight;
      totalweightInd = individualCalcData.totalweight;
      ind_Diff = individualCalcData.indDifference
    }

    if (req.payload[GLOBAL_NOMENCLATURE.GroupMenu]) {
      req.payload[GLOBAL_NOMENCLATURE.GroupMenu].TestData.forEach(k => groupData += k.data.value + '\n')
      let groupCalcData = req.payload[GLOBAL_NOMENCLATURE.GroupMenu].TestInfo;

      averageWeightGrp = groupCalcData.averageWeight;
      maxWeightGrp = groupCalcData.maxWeight;
      minWeightGrp = groupCalcData.minWeight;
      rstdWeightGrp = groupCalcData.rstdWeight
      stdWeightGrp = groupCalcData.stdWeight;
      totalweightGrp = groupCalcData.totalweight;

    }

    if (req.payload[GLOBAL_NOMENCLATURE.HardnessMenu]) {

      req.payload[GLOBAL_NOMENCLATURE.HardnessMenu].TestData.forEach(k => hardData += (k.H.value || k.H) + '\n')
      console.log(hardData);
    }
    if (req.payload[GLOBAL_NOMENCLATURE.HardnessMenu]) {
      req.payload[GLOBAL_NOMENCLATURE.HardnessMenu].TestData.forEach(k => thickData += (k.T.value || k.T) + '\n')
      let hardnessCalcData = req.payload[GLOBAL_NOMENCLATURE.Hardness].TestInfo
      averageWeightHrd = hardnessCalcData.averageWeight;
      maxWeightHrd = hardnessCalcData.maxWeight;
      minWeightHrd = hardnessCalcData.minWeight;
      rstdWeightHrd = hardnessCalcData.rstdWeight
      stdWeightHrd = hardnessCalcData.stdWeight;
      totalweightHrd = hardnessCalcData.totalweight;
      rangeHrd = hardnessCalcData.hardrange;

      averageWeightThick = hardnessCalcData.averageWeightThick;
      maxWeightThick = hardnessCalcData.maxWeightThick;
      minWeightThick = hardnessCalcData.minWeightThick;
      rstdWeightThick = hardnessCalcData.rstdWeightThick
      stdWeightThick = hardnessCalcData.stdWeightThick;
      totalweightThick = hardnessCalcData.totalweightThick;
      rangeThick = hardnessCalcData.Thickrange;
    }
    if (req.payload[GLOBAL_NOMENCLATURE.MultiTesterHardness]) {
      req.payload.MultiTesterHardness.TestData.forEach(k => individualData += k.data.value + '\n')
      let multiTesterCalcData = req.payload[GLOBAL_NOMENCLATURE.MultiTesterHardness].TestInfo;

      averageWeightInd = multiTesterCalcData.averageWeight;
      maxWeightInd = multiTesterCalcData.maxWeight;
      minWeightInd = multiTesterCalcData.minWeight;
      rstdWeightInd = multiTesterCalcData.rstdWeight
      stdWeightInd = multiTesterCalcData.stdWeight;
      totalweightInd = multiTesterCalcData.totalweight;
      ind_Diff = multiTesterCalcData.indDifference;
    }

    if (req.payload[GLOBAL_NOMENCLATURE.EmptyGroupMenu]) {
      req.payload[GLOBAL_NOMENCLATURE.EmptyGroupMenu].TestData.forEach(k => emptyGrpData += k.data.value + '\n')
      let empCalData = req.payload[GLOBAL_NOMENCLATURE.EmptyGroupMenu].TestInfo;

      averageWeightEmpGrp = empCalData.averageWeight;
      maxWeightEmpGrp = empCalData.maxWeight;
      minWeightEmpGrp = empCalData.minWeight;
      rstdWeightEmpGrp = empCalData.rstdWeight
      stdWeightEmpGrp = empCalData.stdWeight;
      totalweightEmpGrp = empCalData.totalweight;

    }
    if (req.payload[GLOBAL_NOMENCLATURE.Differential]) {
      req.payload[GLOBAL_NOMENCLATURE.Differential].TestData.forEach(k => NetContentData += k.data.value + '\n')
      let netCalData = req.payload[GLOBAL_NOMENCLATURE.Differential].TestInfo;

      averageWeightNet = netCalData.averageWeight;
      maxWeightNet = netCalData.maxWeight;
      minWeightNet = netCalData.minWeight;
      rstdWeightNet = netCalData.rstdWeight
      stdWeightNet = netCalData.stdWeight;
      totalweightNet = netCalData.totalweight;
      diff_net = netCalData.indDifference
    }


    var AWBID = mesData?.AWBID
    var HTID = mesData?.HTID
    var FTID = mesData?.FTID
    var DTID = mesData?.DTID
    if (req.isManualPosting) {
      AWBID = (!clsCommonInsertOperationObj.isNullOrStringNull(mesData?.BalanceId)) ? mesData?.BalanceId : 'NA';
      HTID = (!clsCommonInsertOperationObj.isNullOrStringNull(mesData?.HardnessID)) ? mesData?.HardnessID : 'NA';
      FTID = (!clsCommonInsertOperationObj.isNullOrStringNull(mesData?.FriabilityID)) ? mesData?.FriabilityID : 'NA';
      DTID = (!clsCommonInsertOperationObj.isNullOrStringNull(mesData?.DTID)) ? mesData?.DTID : 'NA';
    }

    var mid = crypto.randomUUID()
    // var data = req.payload.data[0].value;
    // globalData.MESArray.data.forEach(e => data += e.actualWt + "\n")


    const root = create({ version: '1.0' })
      .ele("MsiMessageContainer", { "xmlns:xsi": "http://www.w3.org/2001/XMLSchema-instance", "xmlns:xsd": "http://www.w3.org/2001/XMLSchema" })
      .ele("messageInstanceId").txt(crypto.randomUUID()).up()
      .ele("direction").txt("SF_TO_MES").up()
      .ele("systemId").txt(systemId).up()
      .ele("messageType").txt("MsiOrderParameterMessage").up()
      .ele("messageContext").txt("5203998621").up()
      .ele("message")
      .ele("MsiOrderParameterMessage")
      .ele("messageInstanceId").txt(crypto.randomUUID()).up()
      .ele("direction").txt("SF_TO_MES").up()
      .ele("messageId").txt(messageId).up()
      .ele("supplierId").txt("DRL").up()
      .ele("deviceTypeId").txt("DRL_MSI").up()
      .ele("supplierVersion").txt("1.0").up()
      .ele("functionalId").txt("QA Parameter").up()
      .ele("orderContext").txt("5203998621").up()
      .ele("creationTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up()

    const element = root
    element.ele("parameter")
      .ele("name").txt("MPR").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mesData.MPN).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

    element.ele("parameter")
      .ele("name").txt("BID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mesData.BatchID).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

    element.ele("parameter")
      .ele("name").txt("SID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mesData.SFOID).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

    element.ele("parameter")
      .ele("name").txt("RT").up()
      .ele("dataType").txt("Long").up()
      .ele("value").txt(mesData.Repetition).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

    element.ele("parameter")
      .ele("name").txt("TT").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mesData.MesTestType).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

    element.ele("parameter")
      .ele("name").txt("TSD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mesData.MesSide).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()



    if (mesData.ProductType == 2) {

      //Empty capsule group weight
      element.ele("parameter")
        .ele("name").txt("ECGW").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt((emptyGrpData == '') ? 'NA' : emptyGrpData).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("ECGWSC").up()
        .ele("dataType").txt("Long").up()
        .ele("value").txt(mesData.EGSampleCount).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()


      element.ele("parameter")
        .ele("name").txt("NCIAW").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(averageWeightNet).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()


      element.ele("parameter")
        .ele("name").txt("NCIW").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt((NetContentData == '') ? 'NA' : NetContentData).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("NCISD").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(stdWeightNet).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("NCIMW").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(minWeightNet).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("NCIMXW").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(maxWeightNet).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("NCIDW").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(diff_net).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()



      element.ele("parameter")
        .ele("name").txt("NCITTW").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(totalweightNet).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("CIWSC").up()
        .ele("dataType").txt("Long").up()
        .ele("value").txt(mesData.CISampleCount).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()


    } else {

      element.ele("parameter")
        .ele("name").txt(serverConfig.plant == 'PUI' ? "GWSC" : 'TSC').up()
        .ele("dataType").txt("Long").up()
        .ele("value").txt(mesData.SampleCount).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt(serverConfig.plant == 'PUI' ? 'IWSC' : 'TISC').up()
        .ele("dataType").txt("Long").up()
        .ele("value").txt(mesData.GroupSampleCount).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      if (serverConfig.plant == "PUI") {
        element.ele("parameter")
          .ele("name").txt("HTSC").up()
          .ele("dataType").txt("Long").up()
          .ele("value").txt(mesData.StartSampleCount).up() // need to take from the tbl_initialmaster's new colum (hardnessCount)
          .ele("isQualifier").txt(true).up()
          .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
      }

      element.ele("parameter")
        .ele("name").txt("IRSDP").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(rstdWeightInd).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()


      element.ele("parameter")
        .ele("name").txt("HTID").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(HTID).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("HTTMK").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(!hardnessInfo || hardnessInfo.length === 0 ? "NA" : hardnessInfo[0]?.Eqp_Make).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("HTMD").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(!hardnessInfo || hardnessInfo.length === 0 ? "NA" : hardnessInfo[0]?.Eqp_Model).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("HD").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt((hardData == '') ? 'NA' : hardData).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("HDH").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(maxWeightHrd).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("HDL").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(minWeightHrd).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("HDR").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(rangeHrd).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("HDA").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(averageWeightHrd).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("HDSD").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(stdWeightHrd).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("HDRSDP").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(rstdWeightHrd).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("TH").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt((thickData == '') ? 'NA' : thickData).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("THM").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(minWeightThick).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("THMX").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(maxWeightThick).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("THR").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(rangeThick).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("THA").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(averageWeightThick).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("THSD").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(stdWeightThick).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("THRSD").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(rstdWeightThick).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("FTID").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(FTID).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("FBW").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(friabBeforeWt).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("FAW").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(friabAfterWt).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      element.ele("parameter")
        .ele("name").txt("FAP").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(actualPer).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

    }

    element.ele("parameter")
      .ele("name").txt("AID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(AWBID).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

    element.ele("parameter")
      .ele("name").txt("AMK").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(!balanceInfo || balanceInfo.length === 0 ? "NA" : balanceInfo[0]?.Bal_Make).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

    element.ele("parameter")
      .ele("name").txt("AMD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(!balanceInfo || balanceInfo.length === 0 ? "NA" : balanceInfo[0].Bal_Model).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

    element.ele("parameter")
      .ele("name").txt(mesData.ProductType == 2 ? "FCGWSC" : "GW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt((groupData == '') ? 'NA' : groupData).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

    element.ele("parameter")
      .ele("name").txt(mesData.ProductType == 2 ? "FCIW" : "IW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt((individualData == '') ? 'NA' : individualData).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

    element.ele("parameter")
      .ele("name").txt(mesData.ProductType == 2 ? "FCIAW" : "IAW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(averageWeightInd).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

    element.ele("parameter")
      .ele("name").txt(mesData.ProductType == 2 ? "FCISD" : "ISD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(stdWeightInd).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()



    element.ele("parameter")
      .ele("name").txt(mesData.ProductType == 2 ? "FCITTW" : "ITTW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(totalweightInd).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

    element.ele("parameter")
      .ele("name").txt(mesData.ProductType == 2 ? "FCIMW" : "IMW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(minWeightInd).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

    element.ele("parameter")
      .ele("name").txt(mesData.ProductType == 2 ? "FCIMXW" : "IMXW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(maxWeightInd).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

    element.ele("parameter")
      .ele("name").txt(mesData.ProductType == 2 ? "FCIDW" : "IDW").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(ind_Diff).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()



    element.ele("parameter")
      .ele("name").txt("DTID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(DTID).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

    element.ele("parameter")
      .ele("name").txt("DAT").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(dtTime).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

    element.ele("parameter")
      .ele("name").txt("MID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mid).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .up()
      .up().up()
    var xml = root.end({ prettyPrint: true });





    // if (!req.isPosted) {
    var exceptionXml = await this.getExceptionSamples(req, mesData)

    if (exceptionXml.status === "success") {

      let getExceptionSampleCount = await models.tbl_exception_sample_initial.count({ where: { RepSerNo: req.RepSerNo, IsPosted: 0, isTerminated: 0 } })
      let getExceptionSampleHtdCount = await models.tbl_exception_samplehtd_initial.count({ where: { RepSerNo: req.RepSerNo, IsPosted: 0, isTerminated: 0 } })

      if (getExceptionSampleCount > 0 || getExceptionSampleHtdCount > 0) {
        let res = await models.tbl_exception_sample_initial.update({ IsPosted: 1 }, { where: { RepSerNo: req.RepSerNo, id: { [Op.in]: exceptionXml.id } } })
        let reshtd = await models.tbl_exception_samplehtd_initial.update({ IsPosted: 1 }, { where: { RepSerNo: req.RepSerNo, id: { [Op.in]: exceptionXml.id } } })
        console.log(exceptionXml.xml);
        if (serverConfig.plant == 'PUI' && mesData.MesTestType == 'Pre-Startup') {
          return {}
        }
        return exceptionXml.xml
      }
    }

    // let isRemarkPending = false;
    if (exceptionXml.status === "fail") {
      let res = await models.tbl_exception_sample_initial.count({ where: { RepSerNo: req.RepSerNo, IsPosted: 0, isTerminated: 0 } })
      let remarkCountPending = await models.tbl_exception_samplehtd_initial.count({ where: { RepSerNo: req.RepSerNo, IsPosted: 0, isTerminated: 0 } })
      if (remarkCountPending > 0 || res > 0) {
        // isRemarkPending = true
        var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
        return rootXml;
      }
    }
    // }



    if (!ackMode) {
      globalData.MESArray.splice(globalData.MESArray.findIndex(k => k.isPosted == false && k.isCompleted == true && k.DsNo == req.DsNo && k.menuName == req.menuName && k.TabIp == req.TabIp), 1)
      await models.tbl_tab_initialmaster.update({ IsPosted: 1, ismid: mid, ackMode: Number(ackMode) }, { where: { RepSerNo: req.RepSerNo } })

      // //Lod
      // await models.tbl_lodmaster.update({ IsPosted: 1 , ismid: mid, ackMode: Number(ackMode) } , {where: {RepSerNO: req.RepSerNo} })

      // await models.tbl_tab_initialmaster.update({ ismid: mid }, { where: { RepSerNo: mesData.RepSerNo } })
      await models.tbl_mes_data.destroy({ where: { DS_Number: req.selectedDSNo, isSetInCubical: 1 } });
      if (!req.isManualPosting) {
        mqttSender.sendData(req.DsNo, `Port ${req.portNo}:${GLOBAL_NOMENCLATURE.DisplayMessage} ${GLOBAL_NOMENCLATURE.MESDataPosted}`);
        if (req.mqttProtocol) {
          setTimeout(() => mqttSender.sendData(req.DsNo, req.mqttProtocol), 1000);
        }
      }
    } else {
      console.log("------------Global Array Compression-----------")
      console.log(globalData.MESArray);
      let mesArr = globalData.MESArray.find(k => k.isPosted == false && k.isCompleted == true && k.DsNo == req.DsNo && k.menuName == req.menuName && k.TabIp == req.TabIp)
      if (mesArr) {
        mesArr.mid = mid
        mesArr.isPosted = true
        mesData.mid = mid
        mesData.isPosted = true
        await models.tbl_tab_initialmaster.update({ IsPosted: 1, ackMode: Number(ackMode) }, { where: { RepSerNo: req.RepSerNo } })
        // await models.tbl_mes_data.destroy({ where: { DS_Number: req.selectedDSNo } });
        console.log("------------Global Array Compression set MID in ARR-----------")
        console.log(globalData.MESArray);
      } else {
        console.log(`No MES Data Found ${req.RepSerNo}`)
      }
    }



    // } else {
    //   if (!ackMode) {
    //     globalData.MESArray.splice(globalData.MESArray.findIndex(k => k.isPosted == false && k.isCompleted == true && k.DsNo == req.DsNo && k.menuName == req.menuName && k.TabIp == req.TabIp), 1)
    //     await models.tbl_tab_initialmaster.update({ IsPosted: 1, ismid: mid }, { where: { RepSerNo: req.RepSerNo } })
    //     await models.tbl_mes_data.destroy({ where: { DS_Number: req.selectedDSNo } });
    //     var right = await axios.post(`http://${serverConfig.hostApi}:${serverConfig.port}/api/MesPosting`, {
    //       RepSerNo: "NA",
    //       ReportOption: "NA",
    //       Status: "Success"

    //     });
    //     mqttSender.sendData(req.DsNo, `Port ${req.portNo}:${GLOBAL_NOMENCLATURE.DisplayMessage} ${GLOBAL_NOMENCLATURE.MESDataPosted}`);
    //     if (req.mqttProtocol) {
    //       setTimeout(() => mqttSender.sendData(req.DsNo, req.mqttProtocol), 1000);
    //     }
    //   }
    // }
    // mesData = globalData.MESArray.find(k => k.isPosted == false && k.isCompleted == true)
    //   if (mesData == undefined) {
    //     mesData = globalData.MESArray.find(k => k.isPosted == true && k.isCompleted == true)
    //   }
    //   mesData.mid = mid
    //   mesData.isPosted = true 

    return xml;

  }


  async getExceptionSamples(req, mesData) {
    try {
      var messageId = "MsiExceptionMessage"

      // var mesData = await models.tbl_mes_data.findAll({
      //   where: {
      //     DS_Number: req.select edDSNo,
      //     BatchID: req.batchId,
      //     SFOID: req.sfoId,
      //   }
      // })

      var cubicInfo = await models.tbl_cubical.findAll(
        {
          where: {
            Sys_DSNumber: req.selectedDSNo,
            // BatchID: req.batchId,
            // SFOID: req.sfoId,
          }
        }
      )
      let HardnessInstrumentRes
      if (cubicInfo[0].Sys_HardID) {
        HardnessInstrumentRes = await objMenuRequestModel.getDetailOfBulkInstrumentModel(
          cubicInfo[0].Sys_HardID
        );
      }

      let isFTP = HardnessInstrumentRes?.Eqp_Make == 'Pharmatest' ? true : false
      // if (mesData.length === 0) { return { status: "fail" } }

      let getException = await models.tbl_exception_sample_initial.findAll({
        where: {
          RepSerNo: req.RepSerNo,
          BatchNo: (mesData.BatchNo || mesData.BatchID),
          IsPosted: 0,
          isTerminated: 0
        }
      })

      let hardnessException = await models.tbl_exception_samplehtd_initial.findAll({
        where: {
          RepSerNo: req.RepSerNo,
          BatchNo: (mesData.BatchNo || mesData.BatchID),
          IsPosted: 0,
          Remark: { [Op.ne]: 'NA' },
          isTerminated: 0
        }
      })
      let keys = req.payload
      let exceptionArr = []


      // getException.forEach(item => {
      //   const { MenuName, ...rest } = item;
      //   if(!exceptionArr[MenuName]) {
      //     exceptionArr[MenuName] = []
      //   }
      //   exceptionArr[MenuName].push(...rest)

      // })
      if (req.payload.MultiTesterHardness) {
        let getIndividualRecNo = getException.filter(e => e.MenuName == GLOBAL_NOMENCLATURE.IndividualMenu).map(e => e.id);
        if (getIndividualRecNo.length > 0) {
          let res = await models.tbl_exception_sample_initial.update({ IsPosted: 1 }, { where: { RepSerNo: req.RepSerNo, id: { [Op.in]: getIndividualRecNo } } })
          // let result = await models.tbl_exception_sample_initial.update({ isPosted: 1 }, { where: {id: { [Op.in]: getIndividualRecNo} , RepSerNo: req.RepSerNo} } );
          getException = getException.filter(e => e.MenuName != GLOBAL_NOMENCLATURE.IndividualMenu)
        }
      }
      if (req.payload.Individual && isFTP) {
        let getException = await models.tbl_exception_sample_initial.findAll({
          where: {
            RepSerNo: req.RepSerNo,
            IsPosted: 0,
            isTerminated: 0
          }
        })
        let getIndividualRecNo = getException.filter(e => e.MenuName == GLOBAL_NOMENCLATURE.IndividualMenu).map(e => e.id);
        if (getIndividualRecNo.length != 0) {
          getException = getException.filter(e => e.MenuName == GLOBAL_NOMENCLATURE.IndividualMenu)
        }
      }

      if (getException.length == 0 && hardnessException.length == 0) { return { status: 'fail' } }

      if (getException.length > 0 || hardnessException.length > 0) {

        for (let i = 0; i < getException.length; i++) {
          let msg;
          let getUnitFlag = clsCommonInsertOperationObj.isNullOrStringNull(getException[i].DataValueUnit);
          let unit = (!getUnitFlag) ? getException[i].DataValueUnit : '';
          if (getException[i].MenuName == GLOBAL_NOMENCLATURE.Friability || getException[i].MenuName == GLOBAL_NOMENCLATURE.DTMenu) {
            var id = getException[i].id;
            msg = `Test Type: ${mesData.MesTestType}, Repetition: ${mesData.Repetition},Sample Number :1, ${getException[i].MenuName} Test found out of limit: ${getException[i].DataValue} ${unit}, Remarks: ${getException[i].Remark} \n`;
          } else if (getException[i].MenuName == GLOBAL_NOMENCLATURE.IndividualMenu && isFTP && (mesData?.MesTestType.includes('Startup') || mesData?.RptType == 1)) {
            var id = getException[i].id;
            if (i == getException.length - 1 || getException[i + 1].MenuName != GLOBAL_NOMENCLATURE.IndividualMenu) {
              msg = `Test Type: ${mesData.MesTestType}, Repetition: ${mesData.Repetition},Sample Number :${getException[i].SampleNo}, ${getException[i].MenuName} Test found out of limit: ${getException[i].DataValue} ${unit}, Set Range(${getException[i].T1NegTol} - ${getException[i].T1PosTol}) ${unit},  Remarks: ${getException[i].Remark} \n`;
            } else {
              msg = `Test Type: ${mesData.MesTestType}, Repetition: ${mesData.Repetition},Sample Number :${getException[i].SampleNo}, ${getException[i].MenuName} Test found out of limit: ${getException[i].DataValue} ${unit}`;
            }
          }
          else {
            let hrdunit = getUnit(getException[i].MenuName, req.isManualPosting)
            var id = getException[i].id;
            msg = `Test Type: ${mesData.MesTestType}, Repetition: ${mesData.Repetition},Sample Number :${getException[i].SampleNo}, ${getException[i].MenuName} Test found out of limit: ${getException[i].DataValue} ${unit}, Set Range(${getException[i].T1NegTol} - ${getException[i].T1PosTol}) ${mesData[hrdunit]}, Remarks: ${getException[i].Remark} \n`;
          }

          exceptionArr.push({ id: id, msg: msg });
        }

        for (let i = 0; i < hardnessException.length; i++) {
          let id = hardnessException[i].id;
          let msg = `Test Type: ${mesData.MesTestType}, Repetition: ${mesData.Repetition},Sample Number :${hardnessException[i].SampleNo},${hardnessException[i].MenuName} Test found out of limit: `;
          if (hardnessException[i].DataValueHard != 99999) {
            msg += `${hardnessException[i].DataValueHard} ${hardnessException[i].HardUnit}, Set Range(${hardnessException[i].T1NegTolHard} - ${hardnessException[i].T1PosTolHard}) ${hardnessException[i].HardUnit},`;
          }
          if (hardnessException[i].DataValueThick != 99999) {
            msg += `${hardnessException[i].DataValueThick} ${hardnessException[i].ThickUnit}, Set Range(${hardnessException[i].T1NegTolThick} - ${hardnessException[i].T1PosTolThick}) ${hardnessException[i].ThickUnit},`;
          }
          if (hardnessException[i].DataValueBL != 99999 && hardnessException[i].DataValueBL != 'NULL') {
            msg += `${hardnessException[i].DataValueBL} ${hardnessException[i].BLUnit}, Set Range(${hardnessException[i].T1NegTolBL} - ${hardnessException[i].T1PosTolBL}) ${hardnessException[i].BLUnit},`;
          }
          if (isFTP == true) {
            if (hardnessException.length - 1 == i) {
              msg += `Remarks: ${hardnessException[i].Remark} \n`
            }
          } else {
            msg += `Remarks: ${hardnessException[i].Remark} \n`
          }


          // let msg = `Test Type: ${mesData.MesTestType}, Repetition: ${mesData.Repetition},Sample Number :${hardnessException[i].SampleNo}, ${hardnessException[i].MenuName} Test found out of limit: ${hardnessException[i].DataValueHard} ${hardnessException[i].HardUnit}, Set Range(${hardnessException[i].T1NegTolHard} - ${hardnessException[i].T1PosTolHard}) ${hardnessException[i].HardUnit}, ${hardnessException[i].DataValueThick} ${hardnessException[i].ThickUnit}, Set Range(${hardnessException[i].T1NegTolThick} - ${hardnessException[i].T1PosTolThick}) ${hardnessException[i].ThickUnit}, ${hardnessException[i].DataValueBL} ${hardnessException[i].BLUnit}, Set Range(${hardnessException[i].T1NegTolBL} - ${hardnessException[i].T1PosTolBL}) ${hardnessException[i].BLUnit}, Remarks: ${hardnessException[i].Remark} \n`;
          // let msg = `Test Type: ${mesData.MesTestType}, Repetition: ${mesData.Repetition},Sample Number :${hardnessException[i].SampleNo}, ${hardnessException[i].MenuName} Test found out of limit: ${hardnessException[i].DataValueHard} ${hardnessException[i].HardUnit}, Set Range(${mesData.HardnessLow} - ${mesData.HardnessHigh}) ${mesData.HardUnit}, ${hardnessException[i].DataValueThick} ${hardnessException[i].ThickUnit}, Set Range(${mesData.ThicknessLow} - ${mesData.ThicknessHigh}) ${mesData.ThicknessUnit}, ${hardnessException[i].DataValueBL} ${hardnessException[i].BLUnit}, Set Range(${mesData.IndWtLow} - ${mesData.IndWtHigh}) ${hardnessException[i].BLUnit}, Remarks: ${hardnessException[i].Remark} \n`;
          exceptionArr.push({ id: id, msg: msg });
        }

        console.log(exceptionArr);

        let idArr = [];
        let exceptionArrAccToNoOfChar = [];
        let totalLength = 0;
        let totalNoOfChar = 1000;
        let string = "";
        let extractExceptionCount = 0;
        let flag = false;
        let indexCount = 0;
        for (let i = 0; i < exceptionArr.length; i++) {
          totalLength = totalLength + exceptionArr[i].msg.length;
          if (totalLength > totalNoOfChar) {
            string = "";
            totalLength = 0;
            flag = true;
            idArr = [];
            indexCount = exceptionArrAccToNoOfChar.length;
          } else {
            flag = false
          }
          string += exceptionArr[i].msg;
          idArr.push(exceptionArr[i].id)
          if (exceptionArrAccToNoOfChar.length == 0 || flag) {
            exceptionArrAccToNoOfChar.push({ string: string, id: idArr });
          } else {
            exceptionArrAccToNoOfChar[indexCount].string = string;
            exceptionArrAccToNoOfChar[indexCount].id = idArr;
          }
        }

        console.log(exceptionArrAccToNoOfChar);

        let xml = this.createExceptionXml(mesData, cubicInfo, exceptionArrAccToNoOfChar[0].string);

        // let singleLineException = exceptionArr.join('\n')
        // let xml = this.createExceptionXml(mesData, cubicInfo, singleLineException);
        // console.log(`-----Exception Length ------> ${singleLineException.length}"`);

        return {
          status: "success",
          xml: xml,
          id: exceptionArrAccToNoOfChar[0].id
          // exceptionArrAccToNoOfChar: exceptionArrAccToNoOfChar
        }


        // Test Type: IP GRP TEST, Repetition:3, Sample Number:4, Individual Test found out of limit: 266 Kp, Set Range(250-265)Kp, Remarks: Testing
        // Test Type: IP GRP TEST, Repetition:3, Sample Number:5, Individual Test found out of limit: 266 Kp, Set Range(250-265)Kp, Remarks: Testing   
        // Test Type: IP GRP TEST, Repetition:3, Sample Number:6, Multitester -Hardnesss Test found out of limit: 266 Kp, Set Range(250-265)Kp, Remarks: Testing  
        // Test Type: IP GRP TEST, Repetition:3, Sample Number:6, Multitester -Individual Test found out of limit: 411mg, Set Range(250-265)Kp, Remarks: Testing   
      }

      function getUnit(menuName, isManual) {
        switch (menuName) {
          case GLOBAL_NOMENCLATURE.GroupMenu:
            return (isManual) ? 'Param2_Unit' : 'GrpUnit'
            break;
          case GLOBAL_NOMENCLATURE.IndividualMenu:
            return (isManual) ? 'Param1_Unit' : 'IndUnit'
            break;

          default:
            break;
        }
      }

    } catch (err) {
      console.log(err)

    }
    // console.log(req)

  }

  createExceptionXml(mesData, cubicInfo, singleLineException) {
    try {
      const root = create({ version: '1.0' })
        .ele("MsiMessageContainer", { "xmlns:xsi": "http://www.w3.org/2001/XMLSchema-instance", "xmlns:xsd": "http://www.w3.org/2001/XMLSchema" })
        .ele("messageInstanceId").txt(crypto.randomUUID()).up()
        .ele("direction").txt("SF_TO_MES").up()
        .ele("systemId").txt(systemId).up()
        .ele("messageType").txt("MsiExceptionMessage").up()
        // .ele("messageContext").txt("5203998621").up()
        .ele("message")
        // .ele("MsiOrderParameterMessage")
        // .ele("messageInstanceId").txt(crypto.randomUUID()).up()
        // .ele("direction").txt("SF_TO_MES").up()
        // .ele("messageId").txt(messageId).up()
        // .ele("supplierId").txt("DRL").up()
        // .ele("deviceTypeId").txt("DRL_MSI").up()
        // .ele("supplierVersion").txt("1.0").up()
        // .ele("functionalId").txt("QA Parameter").up()
        // .ele("orderContext").txt("5203998621").up()
        // .ele("creationTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
        .ele("MsiExceptionMessage")
        .ele("messageInstanceId").txt(crypto.randomUUID()).up()
        .ele("creationTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
        .ele('exception')
        .ele('causedAt').txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
        .ele('exceptionType').txt('MSI exception received from external system').up()
        .ele('user').txt('PASXAdmin').up()
        .ele('systemDescription').txt(singleLineException).up()

        .ele('sfoID').txt(mesData.SFOID).up()
        .ele('batchNumber').txt(mesData.BatchID).up()
        .ele('equipmentID').txt(cubicInfo[0].Sys_MachineCode).up()
        .ele('operationID').txt('COMPRESSION').up()
        .ele('stepID').txt('SENDBF').up()

        .up().up()
        .up().up()

      let xml = root.end({ prettyPrint: true });

      return xml
    } catch (err) {

    }
  }


  async getMessageBalance(req) {
    var messageId = "Exception_Recieve_Hardness1"
    var obj = globalData.postMessageData
    var currentMESObj = globalData.MESArray
    if (Object.keys(obj).length === 0) {
      var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
      return rootXml;
    }
    if (Object.keys(globalData.MESArray.data).length === 0) {
      var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
      return rootXml;
    }
    for (let key in obj) {
      if (obj[key].length == 0 || obj[key] == null || obj[key] == undefined) {
        var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
        return rootXml;
      }
    }
    var isPending = false;
    var currentValue;
    var sampleNumber;
    for (let e in globalData.MESArray.data) {
      if (globalData.MESArray.data[e].isChecked === false) {
        currentValue = globalData.MESArray.data[e].actualWt;
        isPending = true;
        sampleNumber = Number(e) + 1
        break;
      }
    }
    if ((!(Number(obj.IndWtLow) <= Number(currentValue) && Number(currentValue) <= Number(obj.IndWtHigh))) && isPending == true) {
      const rootException = create({ version: '1.0' })
        .ele("MsiMessageContainer")
        .ele("messageInstanceId").txt(crypto.randomUUID()).up()
        .ele("direction").txt("SF_TO_MES").up()
        .ele("systemId").txt(systemId).up()
        .ele("messageType").txt("MsiExceptionMessage").up()
        .ele("message")
        .ele("MsiExceptionMessage")
        .ele("messageInstanceId").txt(crypto.randomUUID()).up()
        .ele("creationTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
        .ele("exception")
        .ele("causedAt").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
        .ele("exceptionType").txt("MSI exception received from external system").up()
        .ele("user").txt("PASXAdmin").up()
        .ele("systemDescription").txt(`Repeation:${obj.Repetition}, Sample Number:${sampleNumber}, "Individual Weight" value out of limit(${obj.IndWtLow}-${obj.IndWtHigh}) = ${currentValue}`).up()
        .ele("userDescription").txt().up()
        .ele("manufacturingOrderID").txt().up()
        // .ele("deviationNumber").txt(1).up()
        .ele("sfoID").txt(obj.SFOID).up()
        .ele("batchNumber").txt(obj.BatchId).up()
        .ele("productionUnit").txt("productionUnit").up()
        .ele("equipmentID").txt().up()
        .ele("operationID").txt().up()
        .ele("stepID").txt().up().up().up().up().up()
      for (let e in globalData.MESArray.data) {
        if (globalData.MESArray.data[e].isChecked === false) {
          globalData.MESArray.data[e].isChecked = true
          break;
        }
      }
      let xml = rootException.end({ prettyPrint: true });
      return xml;
    }
    if (currentMESObj.isCompleted === false || isPending === true) {
      for (let e in globalData.MESArray.data) {
        if (globalData.MESArray.data[e].isChecked === false) {
          globalData.MESArray.data[e].isChecked = true
          break;
        }
      }
      var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
      return rootXml;
    }
    var data = '';
    globalData.MESArray.data.forEach(e => data += e.actualWt + "\n")
    const root = create({ version: '1.0' })
      .ele("MsiMessageContainer", { "xmlns:xsi": "http://www.w3.org/2001/XMLSchema-instance", "xmlns:xsd": "http://www.w3.org/2001/XMLSchema" })
      .ele("messageInstanceId").txt(crypto.randomUUID()).up()
      .ele("direction").txt("SF_TO_MES").up()
      .ele("systemId").txt(systemId).up()
      .ele("messageType").txt("MsiOrderParameterMessage").up()
      .ele("messageContext").txt("5203998621").up()
      .ele("message")
      .ele("MsiOrderParameterMessage")
      .ele("messageInstanceId").txt(crypto.randomUUID()).up()
      .ele("direction").txt("SF_TO_MES").up()
      .ele("messageId").txt(messageId).up()
      .ele("supplierId").txt("DRL").up()
      .ele("deviceTypeId").txt("DRL_MSI").up()
      .ele("supplierVersion").txt("1.0").up()
      .ele("functionalId").txt("QA Parameter").up()
      .ele("orderContext").txt("5203998621").up()
      .ele("creationTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
      .ele("parameter")
      .ele("name").txt("BatchID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(obj.BatchId).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
      .ele("parameter")
      .ele("name").txt("EquipmentId").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(obj.IndWtEqmID).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
      .ele("parameter")
      .ele("name").txt("SFOID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(obj.SFOID).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
      .ele("parameter")
      .ele("name").txt("Repetition").up()
      .ele("dataType").txt("Long").up()
      .ele("value").txt(obj.Repetition).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
      .ele("parameter")
      .ele("name").txt("TestType").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(obj.TestType).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
      .ele("parameter")
      .ele("name").txt("IndWt").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(data).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
      .ele("parameter")
      .ele("name").txt("GrpWt").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
      .ele("parameter")
      .ele("name").txt("Hardness").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
      .ele("parameter")
      .ele("name").txt("Thickness").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
      .up().up()
      .up().up()
    currentMESObj.data = []
    currentMESObj.isCompleted = false
    let xml = root.end({ prettyPrint: true });
    return xml;

  }

  async getMessage(req) { }

  async getMessageLeakTest(mesData) {
    // ackMode = false;
    var messageId = "Packing_Leak_Test_Receive_BO"
    // var currentMESObj = globalData.findIndex(k => k.menuName == GLOBAL_NOMENCLATURE.LeakTestMenu && k.isPosted == false && k.isCompleted == true)
    // var obj = globalData.postMessageData

    if (Object.keys(mesData).length === 0) {
      var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
      return rootXml;
    }
    // if (Object.keys(globalData.MESArray.data).length === 0) {
    //   var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    //   return rootXml;
    // }

    const leakTestPayloadData = mesData?.payload?.data;
    if (!leakTestPayloadData) {
      var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
      return rootXml;
    }

    const testType = leakTestPayloadData?.ReportType == 0 ? "Regular" : "Startup"

    if (!(leakTestPayloadData?.MPN_Code && leakTestPayloadData?.BatchNo && leakTestPayloadData?.SFOID && testType && leakTestPayloadData?.LeakTestID)) {
      var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
      return rootXml;
    }


    // for (let key in obj) {
    //   if (obj[key].length == 0 || obj[key] == null || obj[key] == undefined) {
    //     var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    //     return rootXml;
    //   }
    // }
    // var isPending = false;
    // var currentValue;
    // var sampleNumber;
    // for (let e in globalData.MESArray.data) {
    //   if (globalData.MESArray.data[e].isChecked === false) {
    //     currentValue = globalData.MESArray.data[e].actualWt;
    //     isPending = true;
    //     sampleNumber = Number(e) + 1
    //     break;
    //   }
    // }

    // if ((!(Number(obj.IndWtLow) <= Number(currentValue) && Number(currentValue) <= Number(obj.IndWtHigh))) && isPending == true) {
    //   const rootException = create({ version: '1.0' })
    //     .ele("MsiMessageContainer")
    //     .ele("messageInstanceId").txt(crypto.randomUUID()).up()
    //     .ele("direction").txt("SF_TO_MES").up()
    //     .ele("systemId").txt(2000).up()
    //     .ele("messageType").txt("MsiExceptionMessage").up()
    //     .ele("message")
    //     .ele("MsiExceptionMessage")
    //     .ele("messageInstanceId").txt(crypto.randomUUID()).up()
    //     .ele("creationTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
    //     .ele("exception")
    //     .ele("causedAt").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
    //     .ele("exceptionType").txt("MSI exception received from external system").up()
    //     .ele("user").txt("PASXAdmin").up()
    //     .ele("systemDescription").txt(`Repeation:${obj.Repetition}, Sample Number:${sampleNumber}, "Individual Weight" value out of limit(${obj.IndWtLow}-${obj.IndWtHigh}) = ${currentValue}`).up()
    //     .ele("userDescription").txt().up()
    //     .ele("manufacturingOrderID").txt().up()
    //     // .ele("deviationNumber").txt(1).up()
    //     .ele("sfoID").txt(obj.SFOID).up()
    //     .ele("batchNumber").txt(obj.BatchId).up()
    //     .ele("productionUnit").txt("productionUnit").up()
    //     .ele("equipmentID").txt().up()
    //     .ele("operationID").txt().up()
    //     .ele("stepID").txt().up().up().up().up().up()
    //   for (let e in globalData.MESArray.data) {
    //     if (globalData.MESArray.data[e].isChecked === false) {
    //       globalData.MESArray.data[e].isChecked = true
    //       break;
    //     }
    //   }
    //   let xml = rootException.end({ prettyPrint: true });
    //   return xml;
    // }
    // if (currentMESObj.isCompleted === false || isPending === true) {
    //   for (let e in globalData.MESArray.data) {
    //     if (globalData.MESArray.data[e].isChecked === false) {
    //       globalData.MESArray.data[e].isChecked = true
    //       break;
    //     }
    //   }
    //   var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    //   return rootXml;
    // }
    // var data = '';
    // globalData.MESArray.data.forEach(e => data += e.actualWt + "\n")

    var mid = crypto.randomUUID()
    console.log(mid);

    const root = create({ version: '1.0' })
      .ele("MsiMessageContainer", { "xmlns:xsi": `http://www.w3.org/2001/XMLSchema-instance`, 'xmlns:xsd': `http://www.w3.org/2001/XMLSchema` })
      .ele("messageInstanceId").txt(crypto.randomUUID()).up()
      .ele("direction").txt("SF_TO_MES").up()
      .ele("systemId").txt(systemId).up()
      .ele("messageType").txt("MsiOrderParameterMessage").up()
      .ele("messageContext").txt("5203998621").up()
      .ele("message")
      .ele("MsiOrderParameterMessage")
      .ele("messageInstanceId").txt(crypto.randomUUID()).up()
      .ele("direction").txt("SF_TO_MES").up()
      .ele("messageId").txt(messageId).up()
      .ele("supplierId").txt("DRL").up()
      .ele("deviceTypeId").txt("DRL_MSI").up()
      .ele("supplierVersion").txt("1.0").up()
      .ele("functionalId").txt("QA Parameter").up()
      .ele("orderContext").txt("5203998621").up()
      .ele("creationTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up()

      .ele("parameter")
      .ele("name").txt("MPR").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.MPN_Code).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("BatchID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.BatchNo).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("SFOID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.SFOID).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("TestType").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.BatchStatus).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("LTID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.LeakTestID).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("MAKE").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.Make).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("MODEL").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.Model).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("TESTID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.TestID).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()


      .ele("parameter")
      .ele("name").txt("TSTATUS").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.TestStatus).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("EVL").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.EORTVacLevel).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("VBT").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.VacBuildTm).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()


      .ele("parameter")
      .ele("name").txt("VRT").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.VacReleaseTm).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("MN").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.MtdName).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()


      .ele("parameter")
      .ele("name").txt("VL").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.VacLevel).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("VacRT").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.VacRetentionTm).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("VPT").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.VacPenetrationTm).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("NP").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.NoOfPackages).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("DS").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.DesicatorSize).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("PT").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.PackageType).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("DF").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.DosageForm).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("DU").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.DosageUnit).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("PN").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.ProductName).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("PD").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.ProductDescription).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("VI").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(leakTestPayloadData.Remark).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      .ele("parameter")
      .ele("name").txt("MID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(mid).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()


    // .ele("parameter")

    // currentMESObj.data = []
    // currentMESObj.isCompleted = false

    // mesData.isPosted = true;

    let xml = root.end({ prettyPrint: true });
    if (!ackMode) {
      globalData.MESArray.splice(globalData.MESArray.findIndex(k => k.isPosted == false && k.isCompleted == true), 1)
      await models.tbl_leakedtest_master.update({ IsPosted: 1, ismid: mid, ackMode: Number(ackMode) }, { where: { RepSerNo: mesData.RepSerNo } })
      await models.tbl_mes_data.destroy({ where: { DS_Number: mesData.DsNo, isSetInCubical: 1 } });
      if (!mesData.isManualPosting) {
        mqttSender.sendData(mesData.DsNo, `Port ${mesData.portNo}:${GLOBAL_NOMENCLATURE.DisplayMessage} ${GLOBAL_NOMENCLATURE.MESDataPosted}`);
        if (mesData.mqttProtocol) {
          setTimeout(() => mqttSender.sendData(mesData.DsNo, mqttProtocol), 1000);
        }
      }
    } else {
      let mesArr = globalData.MESArray.find(k => k.isPosted == false && mesData.isCompleted == true && k.DsNo == mesData.DsNo && k.menuName == mesData.menuName && k.TabIp == mesData.TabIp)
      if (mesArr) {
        mesArr.mid = mid
        mesArr.isPosted = true
        // mesData.mid = mid
        // mesData.isPosted = true
        await models.tbl_leakedtest_master.update({ IsPosted: 1, ackMode: Number(ackMode) }, { where: { RepSerNo: mesData.RepSerNo } })

      } else {
        console.log("No MES Data Found")
      }
    }

    return xml;

  }


  async postMessage1(req) {
    try {
      let resObj = {};
      let mesEntryRes;

      let objActivity = {};
      let isReqFromXml = (req.Sys_Batch != undefined && req.Sys_RptType != undefined) ? false : true;

      const root = create().ele("TransferResult").ele("Error").ele("code").txt(0).up().ele("text").txt("").up().up().ele("Success").txt(true).up().up()
      let xml = root.end({ prettyPrint: true });

      if (isReqFromXml) {
        objActivity.strUserId = "Received from MES";
        objActivity.strUserName = "Received from MES";
        let obj = await this.handleMesRequest(req, objActivity, xml);
        if (obj.status == "fail") { console.log(obj.message); return obj.data }
        objActivity.batch = obj.data?.BatchID ? obj.data.BatchID : "";
        mesEntryRes = await this.createMESEntry(obj.data, objActivity)
        if (mesEntryRes.status == 'fail') { console.log(mesEntryRes.message); return xml }
        let checkPendingMes = await this.checkIfAnyMesRequestPresent(mesEntryRes);
        if (checkPendingMes) {
          mesEntryRes = checkPendingMes;
        }
      } else {
        objActivity.strUserId = req.userid;
        objActivity.strUserName = req.username;
        objActivity.batch = req.Sys_Batch;
        mesEntryRes = await this.checkIfAnyMesRequestPresent(req);
        if (mesEntryRes) {
          mesEntryRes = mesEntryRes;
          let checkIfANyBatchIsAlreadySet = await models.tbl_mes_data.findAll({
            where: {
              BatchID: req.Sys_Batch,
              // isSetInCubical: 1
            }
          })


          if (checkIfANyBatchIsAlreadySet.length > 0) {

            let handleChangeMode = await this.handleChangeMode(resObj, req, objActivity);
            // let currentMode = req.NewData.split(":")[1].split(',')[0];
            // let previousMode = req.OldData.split(":")[1].split(',')[0];
            // objActivity.activity = `Mode Change for Batch ${req.Sys_Batch}, ${previousMode} to ${currentMode}.For ${currentMode}`;
            // await objActivityLog.ActivityLogEntry(objActivity);
          }
        }
      }

      if (mesEntryRes) {
        let validatePortSetting = await objCommonWeightment.validatePortSetting(mesEntryRes, objActivity);
        if (validatePortSetting.instrumentFound) {
          let cubicalData = validatePortSetting.data;
          if (isReqFromXml) {
            await models.tbl_mes_data.update({
              CubicleArea: cubicalData.Sys_Area,
              CubicleType: cubicalData.Sys_CubType,
              DS_Number: cubicalData.Sys_DSNumber,
            }, {
              where: {
                BatchID: mesEntryRes.BatchID,
                TestType: mesEntryRes.TestType,
                Repetition: mesEntryRes.Repetition,
                MesTestType: mesEntryRes.MesTestType,
                MesSide: mesEntryRes.MesSide
              }
            })
          }
        }

        if (validatePortSetting.status == "fail") {
          console.log(validatePortSetting.message);
          if (isReqFromXml) {
            return xml
          } else {
            resObj.status = validatePortSetting.status;
            resObj.message = validatePortSetting.message
            return resObj;
          }
        }
        const length = Object.values(validatePortSetting.data).length;
        if (length > 0) {
          let cubicalData = validatePortSetting.data;
          let checkWeighMentStatus = await this.checkWeighMentStatus(cubicalData, objActivity, req, mesEntryRes.BatchID, isReqFromXml);
          if (checkWeighMentStatus.status == 'fail') {
            console.log(checkWeighMentStatus.message);
            if (!isReqFromXml) {
              resObj.status = checkWeighMentStatus.status;
              resObj.message = checkWeighMentStatus.message
              return resObj;
            }
          }

          let updateCubicalFlag = false;
          let batch = (isReqFromXml) ? cubicalData.Sys_Batch : req.Sys_Batch;
          let rptType = (isReqFromXml) ? cubicalData.Sys_RptType : req.Sys_RptType;
          let mesTestType = (isReqFromXml) ? cubicalData.MesTestType : req.Sys_Batch_Status;

          let LOD_Found = mesEntryRes?.MAID != 'NA' && mesEntryRes?.MAID != undefined ? true : false;
          let LeakTest_Found = mesEntryRes?.LTID != 'NA' && mesEntryRes?.LTID != undefined ? true : false;

          let dta = await models.tbl_mes_data.findAll({
            where: {
              BatchID: mesEntryRes.BatchID,
              TestType: mesEntryRes.TestType,
              DS_Number: cubicalData.Sys_DSNumber,
              // Repetition: mesEntryRes.Repetition,
              // MesTestType: mesEntryRes.MesTestType,
              // MesSide: mesEntryRes.MesSide,
              isSetInCubical: 1
            }
          })
          if (dta.length == 0 && cubicalData.Sys_Batch == mesEntryRes.BatchID) {
            updateCubicalFlag = true
          }

          if (!checkWeighMentStatus.isTestOngoing && LOD_Found && batch == mesEntryRes.BatchID && rptType == mesEntryRes.TestType) {
            updateCubicalFlag = true;
          }
          if (!checkWeighMentStatus.isTestOngoing && LeakTest_Found && batch == mesEntryRes.BatchID && rptType == mesEntryRes.TestType && mesTestType == mesEntryRes.MesTestType) {
            updateCubicalFlag = true;
          }


          if (!LOD_Found && !LeakTest_Found) {
            if (!checkWeighMentStatus.isTestOngoing && batch == mesEntryRes.BatchID && rptType == mesEntryRes.TestType && dta.length == 0) {
              updateCubicalFlag = true;
            }
          }

          // if(!checkWeighMentStatus.isTestOngoing && req.Sys_Batch == mesEntryRes.BatchID && req.switchMode) {
          //   updateCubicalFlag = true;
          // }    

          if (!checkWeighMentStatus.isTestOngoing && updateCubicalFlag) {
            if (LeakTest_Found) {
              // Update cubical DS number
              await objCommonWeightment.updateCubical1(mesEntryRes, cubicalData);
            } else {
              let checkProductData = await objCommonWeightment.checkProductData(mesEntryRes, objActivity);
              await objCommonWeightment.updateCubical1(mesEntryRes, cubicalData);
              await objCommonWeightment.updateSampleNo(cubicalData.Sys_CubicNo, mesEntryRes)
            }
            // Update CubicleArea CubicleType
            if (updateCubicalFlag) {

              await models.tbl_mes_data.update({
                CubicleArea: req.Sys_Area ? req.Sys_Area : cubicalData.Sys_Area,
                CubicleType: req.Sys_CubType ? req.Sys_CubType : cubicalData.Sys_CubType,
                DS_Number: req.Sys_DSNumber ? req.Sys_DSNumber == "NA" ? null : req.Sys_DSNumber : cubicalData.Sys_DSNumber,
                isSetInCubical: 1
              }, {
                where: {
                  BatchID: mesEntryRes.BatchID,
                  TestType: mesEntryRes.TestType,
                  Repetition: mesEntryRes.Repetition,
                  MesTestType: mesEntryRes.MesTestType,
                  MesSide: mesEntryRes.MesSide
                }
              })
            }

            if (!LOD_Found || !LeakTest_Found) {
              let handleIPQC = objCommonWeightment.handleIPQC(cubicalData)
            }
          }

          if (isReqFromXml) {
            const checkPendingRequest = globalData.PendingRequest.find(k => k.DsNo == cubicalData.Sys_DSNumber);
            if (checkPendingRequest) {
              const menuObj = {
                dsNo: cubicalData.Sys_DSNumber,
                tabIp: checkPendingRequest.TabIp,
                userId: checkPendingRequest.userId
              }
              objMenuRequestModel.sendMenu(menuObj)
            }
            return xml;
          } else {
            resObj.status = 'success';
            resObj.message = 'Batch Saved Successfully'
            return resObj
          }
        }
      } else {
        if (isReqFromXml) {
          return xml;
        } else {
          resObj.status = 'success';
          resObj.message = 'Set Batch'
          return resObj
        }
      }


    } catch (err) {
      console.log('err: ', err);
    }
  }

  async createMESEntry(obj, objActivity) {
    try {
      let indFound = false;
      let grpFound = false;
      let EgrpFound = false;
      let diffFound = false;
      let hardFound = false;
      let thicknessFound = false;
      let friabFound = false;
      let DTFound = false;
      let diameterFound = false;
      let lengthFound = false;
      let lockedLengthFound = false;
      let MAFound = false;
      let verFound = false;
      let LeakFound = false;

      // Individual Test
      if ((obj?.AWBID) && ((obj?.IndWtLow || obj?.IndWtLow == 0) && !isNaN(obj?.IndWtLow)) && ((obj?.IndWtHigh || obj?.IndWtHigh == 0) && !isNaN(obj?.IndWtHigh)) && (obj?.IndUnit)) {
        indFound = true;
      }
      // Group Test
      if ((obj?.AWBID) && ((obj?.GrpWtLow || obj?.GrpWtLow == 0) && !isNaN(obj?.GrpWtLow)) && ((obj?.GrpWtHigh || obj?.GrpWtHigh == 0) && !isNaN(obj?.GrpWtHigh)) && (obj?.GrpUnit)) {
        grpFound = true;
      }
      // Empty Group Test
      if ((obj?.AWBID) && ((obj?.EmptGrpWtLow || obj?.EmptGrpWtLow == 0) && !isNaN(obj?.EmptGrpWtLow)) && ((obj?.EmptGrpWtHigh || obj?.EmptGrpWtHigh == 0) && !isNaN(obj?.EmptGrpWtHigh)) && (obj?.EmptGrpUnit)) {
        EgrpFound = true;
      }
      // Differential Test
      if ((obj?.AWBID) && ((obj?.DiffWtLow || obj?.DiffWtLow == 0) && !isNaN(obj?.DiffWtLow)) && ((obj?.DiffWtHigh || obj?.DiffWtHigh == 0) && !isNaN(obj?.DiffWtHigh)) && (obj?.DiffWtUnit)) {
        diffFound = true;
      }
      // Hardness Test
      if ((obj?.HTID) && ((obj?.HardnessLow || obj?.HardnessLow == 0) && !isNaN(obj?.HardnessLow)) && ((obj?.HardnessHigh || obj?.HardnessHigh == 0) && !isNaN(obj?.HardnessHigh)) && (obj?.HardUnit)) {
        hardFound = true;
      }
      // Thickness Test
      if (((obj?.ThicknessLow || obj?.ThicknessLow == 0) && !isNaN(obj?.ThicknessLow)) && ((obj?.ThicknessHigh || obj?.ThicknessHigh == 0) && !isNaN(obj?.ThicknessHigh))) {
        thicknessFound = true;
      }
      // Friability Test
      if ((obj?.FTID) && (obj.FriabilityRange) && (obj.FriabilitySetRPM)) {
        friabFound = true;
      }
      // Disintegration Test
      if ((obj?.DTID) && (obj?.DisintegrationRange)) {
        DTFound = true;
      }
      // Diameter
      if (((obj?.DiameterHigh || obj?.DiameterHigh == 0) && !isNaN(obj?.DiameterHigh)) && ((obj?.DiameterLow || obj?.DiameterLow == 0) && !isNaN(obj?.DiameterLow))) {
        diameterFound = true;
      }
      // Length
      if (((obj.LengthHigh || obj.LengthHigh == 0) && !isNaN(obj?.LengthHigh)) && ((obj.LengthLow || obj.LengthLow == 0) && !isNaN(obj?.LengthLow))) {
        lengthFound = true;
      }
      // Locked Length
      if (((obj.LockedLengthHigh || obj.LockedLengthHigh == 0) && !isNaN(obj?.LockedLengthHigh)) && ((obj.LockedLengthLow || obj.LockedLengthLow == 0) && !isNaN(obj?.LockedLengthLow))) {
        lockedLengthFound = true;
      }
      // Vernier
      if (obj?.VerId) {
        verFound = true;
      }
      // LOD
      if (obj?.MAID) {
        MAFound = true;
      }
      // Leak Test
      if (obj.LTID) {
        LeakFound = true;
      }

      // const currentDateTimeString = moment(new Date()).format('YYYY-MM-DD HH:mm:ss');
      const currentDateTime = date.format(new Date(), 'YYYY-MM-DD HH:mm:ss');
      let createMesEntry = false;
      let isEntryPresentInMaster = [];
      if (LeakFound) {
        createMesEntry = true;
      } else {
        let mesWhereCondition = {
          BatchID: obj.BatchID,
          TestType: obj.TestType,
          Repetition: obj?.Repetition
        }

        if (!MAFound && !LeakFound) {
          mesWhereCondition.Repetition = obj?.Repetition
          if (obj?.MesSide) { mesWhereCondition.MesSide = obj?.MesSide }
          mesWhereCondition.TestType = obj.MesTestType

          let masterWhereCondition = {
            BatchNo: obj.BatchID,
            Repetition: obj.Repetition,
            ReportType: obj.TestType,
            MesTestType: obj.MesTestType
          }
          if (obj?.MesSide) { masterWhereCondition.MesSide = obj?.MesSide }
          let masterTableName = (obj?.MesSide) ? "tbl_tab_initialmaster" : (obj?.productType == '2') ? "tbl_cap_initialmaster" : "tbl_tab_master2"
          isEntryPresentInMaster = await models[masterTableName].findAll({
            where: masterWhereCondition
          })
        }

        // let isEntryPresentInMaster = [];
        if (MAFound) {
          isEntryPresentInMaster = await models.tbl_lodmaster.findAll({
            where: {
              BatchNo: obj.BatchID,
              Repetition: obj.Repetition,
              ReportType: obj.TestType,
              Lot: obj.LotNo
            }
          })
        } else {
          let masterWhereCondition = {
            BatchNo: obj.BatchID,
            Repetition: obj.Repetition,
            ReportType: obj.TestType,
            MesTestType: obj.MesTestType
          }
          if (obj?.MesSide) { masterWhereCondition.MesSide = obj?.MesSide }
          let masterTableName = (obj?.productType == '2') ? 'tbl_cap_initialmaster' : ((obj?.MesSide) ? "tbl_tab_initialmaster" : "tbl_tab_master2")
          isEntryPresentInMaster = await models[masterTableName].findAll({
            where: masterWhereCondition
          })
        }

        let mesData = await models.tbl_mes_data.findAll({ where: mesWhereCondition })
        if (mesData.length == 0 && isEntryPresentInMaster.length == 0) { createMesEntry = true }
      }

      // let initialData = await models.tbl_tab_initialmaster.findAll({ where : mesWhereCondition })
      if (createMesEntry) {
        const mesRes = await models.tbl_mes_data.create({
          isManual:0,
          prDate: currentDateTime,
          BatchID: obj.BatchID,
          SFOID: obj.SFOID,
          Repetition: obj.Repetition,
          TestType: obj.TestType,
          MPN: obj.MPN,
          // ProductId: obj.ProductId,
          // ProductName: obj.ProductName,
          ProductType: obj.productType,
          Side: obj.Side,
          Container: obj.Container,
          // DS_Number: cubicDSNumber, // DS_Number
          SampleCount: (obj?.TabletSampleCount) ? obj.TabletSampleCount : 0,
          GroupSampleCount: (obj?.GroupSampleCount) ? obj.GroupSampleCount : 0,
          StartSampleCount: (obj?.StartSampleCount) ? obj.StartSampleCount : 0,
          CISampleCount: obj.CISampleCount ? obj.CISampleCount : 0,
          EGSampleCount: obj.EGSampleCount ? obj.EGSampleCount : 0,
          // Balance ID
          AWBID: (obj?.AWBID) ? obj.AWBID : "NA",
          // Vernier ID
          VerId: (obj?.VerId) ? obj.VerId : "NA",
          // LOD (Moisture Analyzer) (No parameter for LOD Test)
          MAID: (obj?.MAID) ? obj.MAID : "NA",

          // Individual
          IndWtLow: (indFound) ? obj.IndWtLow : 99999,
          IndWtHigh: (indFound) ? obj.IndWtHigh : 99999,
          IndUnit: (indFound) ? obj.IndUnit : "NULL",

          // Group
          GrpWtLow: (grpFound) ? obj.GrpWtLow : 99999,
          GrpWtHigh: (grpFound) ? obj.GrpWtHigh : 99999,
          GrpUnit: (grpFound) ? obj.GrpUnit : "NULL",

          // Empty Group
          EmptGrpWtLow: (EgrpFound) ? obj.EmptGrpWtLow : 99999,
          EmptGrpWtHigh: (EgrpFound) ? obj.EmptGrpWtHigh : 99999,
          EmptGrpUnit: (EgrpFound) ? obj.EmptGrpUnit : 99999,

          // Differential 
          DiffWtLow: (diffFound) ? obj.DiffWtLow : 99999,
          DiffWtHigh: (diffFound) ? obj.DiffWtHigh : 99999,
          DiffUnit: (diffFound) ? obj.DiffUnit : "NULL",

          // Hardness
          HTID: (hardFound) ? obj.HTID : "NA",
          HardnessLow: (hardFound) ? obj.HardnessLow : 99999,
          HardnessHigh: (hardFound) ? obj.HardnessHigh : 99999,
          HardUnit: (hardFound) ? obj.HardUnit : "NULL",

          // Thickness
          ThicknessLow: (thicknessFound) ? obj.ThicknessLow : 99999,
          ThicknessHigh: (thicknessFound) ? obj.ThicknessHigh : 99999,
          ThicknessUnit: (thicknessFound) ? obj.ThicknessUnit : "NULL",

          // Diameter
          DiameterLow: (diameterFound) ? obj.DiameterLow : 99999,
          DiameterHigh: (diameterFound) ? obj.DiameterHigh : 99999,
          DiameterUnit: (diameterFound) ? obj.DiameterUnit : "NULL",

          // Length
          LengthLow: (lengthFound) ? obj.LengthLow : 99999,
          LengthHigh: (lengthFound) ? obj.LengthHigh : 99999,
          LengthUnit: (lengthFound) ? obj.LengthUnit : "NULL",

          // Locked Length
          LengthLow: (lockedLengthFound) ? obj.LockedLengthLow : 99999,
          LengthHigh: (lockedLengthFound) ? obj.LockedLengthHigh : 99999,
          LengthUnit: (lockedLengthFound) ? obj.LockedLengthUnit : "NULL",

          // Disintegration Test
          DTID: (DTFound) ? obj.DTID : "NA",
          // DisintegrationLow: (DTFound) ? obj.DisintegrationLow : 99999,
          // DisintegrationHigh: (DTFound) ? obj.DisintegrationHigh : 99999,
          DisintegrationRange: (DTFound) ? obj.DisintegrationRange : 99999,

          // Friability Test
          FTID: (friabFound) ? obj.FTID : "NA",
          // FriabilityLow: (friabFound) ? obj.FriabilityLow : 99999,
          // FriabilityHigh: (friabFound) ? obj.FriabilityHigh : 99999,
          FriabilityRange: (friabFound) ? obj.FriabilityRange : 99999, // NMT 0.14 RPM
          FriabilityRPM: (friabFound) ? obj.FriabilitySetRPM : 99999,
          FriabUnit: (friabFound) ? obj.FriabUnit : "NULL",

          // Leak Test
          LTID: (obj?.LTID) ? obj.LTID : "NA",

          MesTestType: (obj?.MesTestType) ? obj.MesTestType : '',
          MesSide: (obj?.MesSide) ? obj?.MesSide : '',

          // LOD Test
          LODHigh: (obj?.LODR) ? obj.LODR : 99999,

          // GrpWtEqmID: (grpFound) ? obj.GrpWtEqmID : "NA",

          // Coating
          LotNo: (obj?.LotNo) ? obj.LotNo : "NA",
          SprayPeriod: (obj?.SprayPeriod) ? obj.SprayPeriod : "NA",
          TOC: (obj?.TOC) ? obj.TOC : "NA",
          AWPWT: (obj?.AWPWT) ? obj.AWPWT : "NA"
        })

        objActivity.batch = obj?.BatchID ? obj.BatchID : "";
        let msgMESReq = `New MES Request found `;
        if (obj?.LTID != undefined && obj?.LTID != 'NA') {
          // msgMESReq = `for Mode ${obj?.MesTestType}`;
          msgMESReq = `Auto Mode- Test in progress`
        } else if (obj?.MAID != undefined && obj?.MAID != 'NA') {
          // msgMESReq += `for Repetition No ${obj.Repetition}`;
          msgMESReq = `Auto Mode- Test in progress`
        } else {
          msgMESReq += `for Test Type ${obj.MesTestType} and Repetition No ${obj.Repetition}`;
        }
        objActivity.activity = msgMESReq
        await objActivityLog.ActivityLogEntry(objActivity);

        return mesRes.dataValues;
      } else {
        console.log("Invalid data received from MES");
        let resobj = { status: 'fail', message: 'Invalid Mes Request' };
        objActivity.batch = obj?.BatchID ? obj.BatchID : "";
        objActivity.activity = "Invalid data received from MES"
        await objActivityLog.ActivityLogEntry(objActivity);
        return resobj;
      }

    } catch (error) {
      console.log('error: ', error);
    }
  }

  async handleMesRequest(req, objActivity, xml) {
    try {
      let obj = {};
      let result = {};
      let MPNdata;
      // if (req.msimessagecontainer.systemid[0] != GLOBAL_NOMENCLATURE.SystemIdFT03) {
      //   console.log('SystemID Not Matched----', req.msimessagecontainer.systemid[0])
      //   return { status: 'fail' }
      // }
      req.msimessagecontainer.message[0].msiorderparametermessage[0].parameter.forEach(param => {
        // req.msiinterfacedescription.message[0].msiorderparametermessage[0].parameter.forEach(param => {
        // req.msiinterfacedescription.parameter.forEach(param => {
        // req.msiorderparametermessage.parameter.forEach(param => {
        console.log(param);
        switch (param.name[0]) {
          case "BatchID":
          case "BatchId":
          case "BID":
            obj.BatchID = param.value[0]
            break;
          case "SFOID":
          case "SID":
            obj.SFOID = param.value[0]
            break;
          case "Repetition":
          case "RT":
            obj.Repetition = param.value[0]
            break;
          case "TestType":
          case "TT":
            obj.TestType = param.value[0]
            obj.MesTestType = param.value[0]
            break;
          case "ProductId":
          case "MCode":
          case "MPR":
          case "MPN":
            obj.MPN = param.value[0]
            MPNdata = param.value[0];
            break;
          case "ProductName":
            obj.ProductName = param.value[0]
            break;
          case "ProductType":
            obj.ProductType = param.value[0]
            break;
          case "Side":
          case "TSD":
            obj.Side = param.value[0]
            obj.MesSide = param.value[0]
            break;
          case "Container":
            obj.Container = param.value[0]
            break;
          case "TSC":
          case "GWSC":
          case "FCGWSC":
            // obj.SampleCount = param.value[0]
            obj.TabletSampleCount = param.value[0]
            break;
          case "ECGWSC":
            // obj.SampleCount = param.value[0]
            obj.EGSampleCount = param.value[0]
            break;
          case "CIWSC":
            obj.CISampleCount = param.value[0]
            break;
          // StartSampleCount is for (Initial Test)
          // case "StartSampleCount":
          case "HTSC":
            obj.StartSampleCount = param.value[0]
            break;
          // Group [GroupSampleCount is for (Initial Test)]
          // case "GroupSampleCount":

          // TGSC has been Changed to TISC
          case "TISC":
          case "TGSC":
          case "IWSC":
          case "FCIWSC":
            obj.GroupSampleCount = param.value[0]
            break;

          case "AWBID":
          case "AID":
            obj.AWBID = param.value[0]
            break;
          case "GrpWtLow":
          case "GL":
            obj.GrpWtLow = param.value[0]
            break;
          case "GrpWtHigh":
          case "GH":
            obj.GrpWtHigh = param.value[0]
            break;
          case "GrpUnit":
            obj.Unit = param.value[0]
            break;
          // Individual
          case "IndWtHigh":
          case "IH":
            obj.IndWtHigh = param.value[0]
            break;
          case "IndWtLow":
          case "IL":
            obj.IndWtLow = param.value[0]
            break;
          case "EGH":
            obj.EmptGrpWtHigh = param.value[0]
            break;
          case "EGL":
            obj.EmptGrpWtLow = param.value[0]
            break;
          case "IndUnit":
            obj.Unit = param.value[0]
            break;
          // Differential
          case "DiffWtHigh":
          case "CIH":
            obj.DiffWtHigh = param.value[0]
            break;
          case "DiffWtLow":
          case "CIL":
            obj.DiffWtLow = param.value[0]
            break;
          case "DiffUnit":
            obj.Unit = param.value[0]
            break;
          // Hardness
          case "HTID":
            obj.HTID = param.value[0]
            break;
          case "HardnessLow":
          case "HL":
            obj.HardnessLow = param.value[0]
            break;
          case "HardnessHigh":
          case "HH":
            obj.HardnessHigh = param.value[0]
            break;
          case "HardUnit":
            obj.HardUnit = param.value[0]
            break;
          // Thickness
          case "ThicknessLow":
          case "TL":
            obj.ThicknessLow = param.value[0]
            break;
          case "ThicknessHigh":
          case "TH":
            obj.ThicknessHigh = param.value[0]
            break;
          case "ThicknessUnit":
            obj.ThicknessUnit = param.value[0]
            break;
          // Friability
          case "FTID":
            obj.FTID = param.value[0]
            break;
          case "FSR":
            obj.FriabilitySetRPM = param.value[0]
            break;
          case "FR":
            obj.FriabilityRange = param.value[0]
            break;
          case "FriabilityLow":
            obj.FriabilityLow = param.value[0]
            break;
          case "FriabilityHigh":
            obj.FriabilityHigh = param.value[0]
            break;
          case "FriabUnit":
            obj.FriabUnit = param.value[0]
            break;
          // DT
          case "DTID":
            obj.DTID = param.value[0]
            break;
          case "DR":
            obj.DisintegrationRange = param.value[0]
            break;
          case "DisintegrationLow":
            obj.DisintegrationLow = param.value[0]
            break;
          case "DisintegrationHigh":
            obj.DisintegrationHigh = param.value[0]
            break;
          // Diameter
          case "DiameterLow":
            obj.DiameterLow = param.value[0]
            break;
          case "DiameterHigh":
            obj.DiameterHigh = param.value[0]
            break;
          case "DiameterUnit":
            obj.DiameterUnit = param.value[0]
            break;
          // Length
          case "LengthLow":
            obj.LengthLow = param.value[0]
            break;
          case "LengthHigh":
            obj.LengthHigh = param.value[0]
            break;
          case "LengthUnit":
            obj.LengthUnit = param.value[0]
            break;
          case "LL":
            obj.LockedLengthLow = param.value[0]
            break;
          case "LH":
            obj.LockedLengthHigh = param.value[0]
            break;
          case "LLUnit":
            obj.LengthUnit = param.value[0]
            break;
          case "VerId":
            obj.VerId = param.value[0]
            break;
          // LOD Test (Moisture Analyzer)
          case "EquipmentId":
          case "EID":
            obj.MAID = param.value[0]
            break;
          case "LODR":
            obj.LODR = param.value[0]
            break;
          // Leak Test
          case "LTID":
            obj.LTID = param.value[0]
            break;
          case "LN":
            obj.LotNo = param.value[0]
            break;
          case "SP":
            obj.SprayPeriod = param.value[0]
            break;
          case "TOC":
            obj.TOC = param.value[0]
            break;
          case "AWPWT":
            obj.AWPWT = param.value[0]
            break;
        }
      })


      let productData
      let ProdData
      if (!obj.productType) {
        productData = await models.tbl_product_master.findOne({
          where: {
            MPN_Code: obj.MPN
          }
        })
        
      }

      if(productData){
        obj.productType = productData?.ProductType
        const prodTable = obj.productType == 2 ? 'tbl_product_capsule' : 'tbl_product_tablet'
       ProdData = await models[prodTable].findOne({
        where: {
          MPN_Code: MPNdata
        }
      })
      }
      
      if (obj?.FriabilityRange) {
        const friabRange = obj.FriabilityRange.match(/\d+(\.\d+)?/g);
        obj.FriabilityRange = friabRange ? friabRange[0] : 99999
      }

      if (serverConfig.plant != "PUI") {

        if (obj.IndWtHigh && obj.IndWtLow && obj?.IndWtHigh.split(" ")[1]) {
          obj.IndUnit = obj?.IndWtHigh.split(" ")[1]
          obj.IndWtHigh = obj?.IndWtHigh.split(" ")[0]
          obj.IndWtLow = obj?.IndWtLow.split(" ")[0]
        } else {
          console.log("Individual limits is missing, cannot find unit");
        }

        if (obj.LockedLengthHigh && obj.LockedLengthLow && obj?.LockedLengthHigh.split(" ")[1]) {
          obj.LockedLengthUnit = obj?.LockedLengthHigh.split(" ")[1]
          obj.LockedLengthHigh = obj?.LockedLengthHigh.split(" ")[0]
          obj.LockedLengthLow = obj?.LockedLengthLow.split(" ")[0]
        } else {
          console.log("Locked Length limits is missing, cannot find unit");
        }

        if (obj.DiffWtHigh && obj.DiffWtLow && obj?.DiffWtHigh.split(" ")[1]) {
          obj.DiffWtUnit = obj?.DiffWtHigh.split(" ")[1]
          obj.DiffWtHigh = obj?.DiffWtHigh.split(" ")[0]
          obj.DiffWtLow = obj?.DiffWtLow.split(" ")[0]
        } else {
          console.log("Net Content limits are missing, cannot find unit");
        }

        if (obj.EmptGrpWtHigh && obj.EmptGrpWtLow && obj?.EmptGrpWtHigh.split(" ")[1]) {
          obj.EmptGrpUnit = obj?.EmptGrpWtHigh.split(" ")[1]
          obj.EmptGrpWtLow = obj?.EmptGrpWtLow.split(" ")[0]
          obj.EmptGrpWtHigh = obj?.EmptGrpWtHigh.split(" ")[0]
        } else {
          console.log("Empty Group limits are missing, cannot find unit");
        }

        if (obj.GrpWtHigh && obj.GrpWtLow && obj?.GrpWtHigh.split(" ")[1]) {
          obj.GrpUnit = obj?.GrpWtHigh.split(" ")[1]
          obj.GrpWtLow = obj?.GrpWtLow.split(" ")[0]
          obj.GrpWtHigh = obj?.GrpWtHigh.split(" ")[0]
        } else {
          console.log("Group limits are missing, cannot find unit");
        }

        if (obj.ThicknessHigh && obj.ThicknessLow && obj?.ThicknessHigh.split(" ")[1]) {
          obj.ThicknessUnit = obj?.ThicknessHigh.split(" ")[1]
          obj.ThicknessLow = obj?.ThicknessLow.split(" ")[0]
          obj.ThicknessHigh = obj?.ThicknessHigh.split(" ")[0]
        } else {
          console.log("Thickness limits are missing, cannot find unit");
        }

        if (obj.HardnessHigh && obj.HardnessLow && obj?.HardnessHigh.split(" ")[1]) {
          obj.HardUnit = obj?.HardnessHigh.split(" ")[1]
          obj.HardnessLow = obj?.HardnessLow.split(" ")[0]
          obj.HardnessHigh = obj?.HardnessHigh.split(" ")[0]
        } else {
          console.log("Hardness limits are missing, cannot find unit");
        }

      } else {

        if (obj.DiffWtHigh && obj.DiffWtLow && obj?.DiffWtHigh.split(" ")[1]) {
          obj.DiffWtUnit = obj?.DiffWtHigh.split(" ")[1] || ProdData.Param3_Unit
          obj.DiffWtHigh = obj?.DiffWtHigh.split(" ")[0]
          obj.DiffWtLow = obj?.DiffWtLow.split(" ")[0]
        } else {
          console.log("Net Content limits are missing, cannot find unit");
        }

        if (obj.EmptGrpWtHigh && obj.EmptGrpWtLow && obj?.EmptGrpWtHigh.split(" ")[1]) {
          obj.EmptGrpUnit = obj?.EmptGrpWtHigh.split(" ")[1] || ProdData.Param19_Unit
          obj.EmptGrpWtLow = obj?.EmptGrpWtLow.split(" ")[0]
          obj.EmptGrpWtHigh = obj?.EmptGrpWtHigh.split(" ")[0]
        } else {
          console.log("Empty Group limits are missing, cannot find unit");
        }


        if (obj.LockedLengthHigh && obj.LockedLengthLow && obj?.LockedLengthHigh.split(" ")[1]) {
          obj.LockedLengthUnit = obj?.LockedLengthHigh.split(" ")[1] || ProdData.Param5_Unit
          obj.LockedLengthHigh = obj?.LockedLengthHigh.split(" ")[0]
          obj.LockedLengthLow = obj?.LockedLengthLow.split(" ")[0]
        } else {
          console.log("Locked Length limits is missing, cannot find unit");
        }


        if (obj.IndWtHigh && obj.IndWtLow) {
          obj.IndUnit = obj?.IndWtHigh.split(" ")[1] || ProdData.Param1_Unit
          obj.IndWtHigh = obj?.IndWtHigh.split(" ")[0]
          obj.IndWtLow = obj?.IndWtLow.split(" ")[0]
        } else {
          console.log("Individual limits are missing, cannot find unit");
        }

        if (obj.GrpWtHigh && obj.GrpWtLow) {
          obj.GrpUnit = obj?.GrpWtHigh.split(" ")[1] || ProdData.Param2_Unit
          obj.GrpWtLow = obj?.GrpWtLow.split(" ")[0]
          obj.GrpWtHigh = obj?.GrpWtHigh.split(" ")[0]
        } else {
          console.log("Group limits are missing, cannot find unit");
        }

        if (obj.ThicknessHigh && obj.ThicknessLow) {
          obj.ThicknessUnit = obj?.ThicknessHigh.split(" ")[1] || ProdData.Param3_Unit
          obj.ThicknessLow = obj?.ThicknessLow.split(" ")[0]
          obj.ThicknessHigh = obj?.ThicknessHigh.split(" ")[0]
        } else {
          console.log("Thickness limits are missing, cannot find unit");
        }

        if (obj.HardnessHigh && obj.HardnessLow) {
          obj.HardUnit = obj?.HardnessHigh.split(" ")[1] || ProdData.Param7_Unit
          obj.HardnessLow = obj?.HardnessLow.split(" ")[0]
          obj.HardnessHigh = obj?.HardnessHigh.split(" ")[0]
        } else {
          console.log("Hardness limts are missing, cannot find unit");
        }

      }
      // Insert MES data in tbl_mes_data_history
      await objCommonWeightment.createMESDataHistory(obj);

      if (obj?.LTID) {
        if (!((obj?.MPN) && (obj?.BatchID) && (obj?.SFOID) && (obj.TestType))) {
          result.status = "fail";
          result.message = "Invalid data received from MES and the Instrument is LTID";
          result.data = xml;
          objActivity.batch = obj?.BatchID ? obj.BatchID : "";
          objActivity.activity = "Invalid data received from MES"
          await objActivityLog.ActivityLogEntry(objActivity);
          return result;
        }
      } else if (obj?.MAID) {
        if (!((obj?.BatchID) && (obj?.MAID) && (obj?.Repetition))) {
          result.status = "fail";
          result.message = "Invalid data received from MES and the Instrument is MAID";
          result.data = xml;
          objActivity.batch = obj?.BatchID ? obj.BatchID : "";
          objActivity.activity = "Invalid data received from MES"
          await objActivityLog.ActivityLogEntry(objActivity);
          return result;
        }
      } else if (!obj?.MPN) {
        result.status = "fail";
        result.message = "Product is not received from MES";
        result.data = xml;
        objActivity.batch = obj?.BatchID ? obj.BatchID : "";
        objActivity.activity = "Invalid data received from MES"
        await objActivityLog.ActivityLogEntry(objActivity);
        return result;
      } else {
        if (!((obj?.BatchID) && (obj?.SFOID) && (obj?.Repetition || obj?.Repetition == 0) && (obj?.TestType) && (obj?.MPN) && ((obj?.Side || obj?.LotNo || obj.productType == 2)))) {
          result.status = "fail";
          result.message = "Invalid data received from MES and Instrument is not MAID or LTID";
          result.data = xml
          objActivity.batch = obj?.BatchID ? obj.BatchID : "";
          objActivity.activity = "Invalid data received from MES"
          await objActivityLog.ActivityLogEntry(objActivity);
          return result;
        }
      }

      // if (obj.MesTestType == undefined) { //for LOD
      //   obj.MesTestType = 'Inprocess'
      //   obj.TestType = 0;
      // }
      // let testTypeFormat = (obj.TestType) ? obj.TestType.toLowerCase() : obj.TestType
      if (obj.TestType) {
        if (obj.TestType.toLowerCase().includes("startup") || obj.TestType.toLowerCase().includes("Start Up") || obj.TestType == "Initial" || (obj.TestType.includes("Pre") && !(obj.TestType.toLowerCase().includes("pre-warming")))) {

          obj.TestType = 1
        } else {
          // If testType is not startup it's always going to be "Inprocess"
          obj.TestType = 0
        }
      } else {
        // for LOD
        obj.TestType = 0;
        obj.MesTestType = 'Inprocess'
      }


      result.status = "success";
      result.data = obj

      return result;

    } catch (err) {
      console.log('err: ', err);
      return err;
    }
  }

  async checkIfAnyMesRequestPresent(req) {
    try {
      let testType = (req?.TestType) ? req.TestType : req?.Sys_RptType
      let isSetInCubical = (req?.ToggleSample == 1) ? 1:0 
      let getMesRequest = await models.tbl_mes_data.findOne({
        where: {
          BatchID: req?.Sys_Batch || req?.BatchID,
          TestType: testType,
          isSetInCubical: isSetInCubical
        }
      });

      // if (getMesRequest.length > 0) {
      //   getMesRequest = getMesRequest[0]
      // }

      return getMesRequest

    } catch (err) {
      console.log('err: ', err);
    }
  }

  async checkWeighMentStatus(cubicalData, objActivity, req, mesBatchID, isReqFromXml) {
    try {
      let resObj = {};
      let isTestOngoing = false;

      // if(req.switchMode) {
      //   let currentMode = req.NewData.split(":")[0];
      //   let previousMode = req.OldData.split(":")[0];
      //   resObj.status = 'success';
      //   resObj.message = 'Batch can be set';
      //   resObj.isTestOngoing = false;
      //   await models.tbl_mes_data.update({ isSetInCubical: 0}, { where : { DS_Number: cubicalData.Sys_DSNumber, isSetInCubical: 1 } })
      //   let data = await models.tbl_menu_sequence.findAll({ where : { DS_Number: cubicalData.Sys_DSNumber } });
      //   if(data.length > 0) {
      //     await models.tbl_tab_initialmaster_incomplete.update({ Inprocess: 0 }, { where: { RepSerNo: data[0].RepSerNo }})
      //     await models.tbl_menu_sequence.destroy({ DS_Number: cubicalData.Sys_DSNumber })
      //   }
      //   objActivity.activity = `Mode Change for Batch ${cubicalData.Sys_Batch}, ${previousMode} to ${currentMode},even though all test not completed for mode ${previousMode}`;
      //   await objActivityLog.ActivityLogEntry(objActivity);
      //   return resObj;
      // }

      // Check for test status
      const testStatus = await models.tbl_system_weighingstatus.findOne({
        where: {
          CubicleNo: cubicalData.Sys_CubicNo,
          Status: 1
        }
      })

      if (testStatus) {
        isTestOngoing = true
        let mode = (cubicalData.isManual == 1) ? 'Manual Mode - ' : 'Auto Mode - '
        console.log("Test is ongoing, MES Post Message");
        objActivity.activity = `${mode} Test is running`;
        resObj.status = 'fail';
        resObj.message = 'Test In Process';
        resObj.isTestOngoing = isTestOngoing
        await objActivityLog.ActivityLogEntry(objActivity);
        if (isReqFromXml) {
          mqttSender.sendData(cubicalData.Sys_DSNumber, `${GLOBAL_NOMENCLATURE.MesRequestNotification} New MES Request found For Batch ${mesBatchID}`)
        }
        return resObj
      }

      let checkAnyBatchSetInMes = await models.tbl_mes_data.findAll({
        where: {
          isSetInCubical: 1,
          DS_Number: cubicalData.Sys_DSNumber
        }
      })

      if (checkAnyBatchSetInMes.length > 0) {
        // let currentMode = req.NewData.split(":")[0].split(',')[0];
        // let previousMode = req.OldData.split(":")[0].split(',')[0];
        if (checkAnyBatchSetInMes[0].TestType != cubicalData.Sys_RptType) {
          let handleChangeMode = await this.handleChangeMode(resObj, cubicalData, objActivity);
          isTestOngoing = false
          resObj.status = 'success';
          resObj.message = 'All Tests not completed';
          resObj.isTestOngoing = isTestOngoing
          return resObj;
        }

      }

      resObj.status = 'success';
      resObj.message = 'Batch can be set';
      resObj.isTestOngoing = false;

      return resObj;

    } catch (err) {
      console.log('err: ', err);
      throw new Error(err)
    }
  }

  async handleChangeMode(resObj, req, objActivity) {
    try {
      let currentMode = req.NewData?.split(":")[1].split(',')[0];
      let previousMode = req.OldData?.split(":")[1].split(',')[0];
      await models.tbl_mes_data.update({ isSetInCubical: 0 }, { where: { DS_Number: req.Sys_DSNumber, isSetInCubical: 1 } })
      let data = await models.tbl_menu_sequence.findAll({ where: { DS_Number: req.Sys_DSNumber } });
      if (data.length > 0) {
        await models.tbl_powerbackup.destroy({ where: { Incomp_RepSerNo: data[0].RepSerNo } })
        await models.tbl_tab_initialmaster_incomplete.update({
          Inprocess: 0,
          IntervalStopTm: moment().format('YYYY-MM-DD HH:mm:ss')
        }, {
          where: { RepSerNo: data[0].RepSerNo }
        })
        await models.tbl_menu_sequence.destroy({ where: { DS_Number: req.Sys_DSNumber, RepSerNo: data[0].RepSerNo } })
      }
      resObj.status = 'success';
      resObj.message = 'Batch can be set';
      objActivity.activity = `Mode Change for Batch ${req.Sys_Batch}, ${previousMode} to ${currentMode}`;
      await objActivityLog.ActivityLogEntry(objActivity);
      return resObj
    } catch (err) {
      console.log('err: ', err);
      throw new Error(err)
    }
  }

  // async postMessage(req) {
  //   try {
  //     var obj = {};
  //     // -------- isReqFromXml > true --------
  //     req.msimessagecontainer.message[0].msiorderparametermessage[0].parameter.forEach(param => {
  //     // req.msiinterfacedescription.message[0].msiorderparametermessage[0].parameter.forEach(param => {
  //     // req.msiinterfacedescription.parameter.forEach(param => {
  //     // req.msiorderparametermessage.parameter.forEach(param => {
  //       console.log(param);
  //       switch (param.name[0]) {
  //         case "BatchID":
  //         case "BatchId":
  //         case "BID":
  //           obj.BatchID = param.value[0]
  //           break;
  //         case "SFOID":
  //         case "SID":
  //           obj.SFOID = param.value[0]
  //           break;
  //         case "Repetition":
  //         case "RT":
  //           obj.Repetition = param.value[0]
  //           break;
  //         case "TestType":
  //         case "TT":
  //           obj.TestType = param.value[0]
  //           obj.MesTestType = param.value[0]
  //           break;
  //         case "ProductId":
  //         case "MCode":
  //         case "MPR":
  //         case "MPN":
  //           obj.MPN = param.value[0]
  //           break;
  //         case "ProductName":
  //           obj.ProductName = param.value[0]
  //           break;
  //         case "ProductType":
  //           obj.ProductType = param.value[0]
  //           break;
  //         case "Side":
  //         case "TSD":
  //           obj.Side = param.value[0]
  //           obj.MesSide = param.value[0]
  //           break;
  //         case "Container":
  //           obj.Container = param.value[0]
  //           break;
  //         case "SampleCount":
  //         case "TSC":
  //           obj.SampleCount = param.value[0]
  //           obj.StartSampleCount = param.value[0]
  //           break;
  //         // StartSampleCount is for (Initial Test)
  //         // case "StartSampleCount":
  //         // case "TSC":
  //         //   obj.StartSampleCount = param.value[0]
  //         //   break;
  //         // Group [GroupSampleCount is for (Initial Test)]
  //         // case "GroupSampleCount":
  //         case "TISC":
  //           obj.GroupSampleCount = param.value[0]
  //           break;
  //         // TGSC has been Changed to TISC
  //         case "TGSC":
  //           obj.GroupSampleCount = param.value[0]
  //           break;
  //         case "AWBID":
  //         case "AID":
  //           obj.AWBID = param.value[0]
  //           break;
  //         case "GrpWtLow":
  //         case "GL":
  //           obj.GrpWtLow = param.value[0]
  //           break;
  //         case "GrpWtHigh":
  //         case "GH":
  //           obj.GrpWtHigh = param.value[0]
  //           break;
  //         case "GrpUnit":
  //           obj.Unit = param.value[0]
  //           break;
  //         // Individual
  //         case "IndWtHigh":
  //         case "IH":
  //           obj.IndWtHigh = param.value[0]
  //           break;
  //         case "IndWtLow":
  //         case "IL":
  //           obj.IndWtLow = param.value[0]
  //           break;
  //         case "IndUnit":
  //           obj.Unit = param.value[0]
  //           break;
  //         // Differential
  //         case "DiffWtHigh":
  //           obj.DiffWtHigh = param.value[0]
  //           break;
  //         case "DiffWtLow":
  //           obj.DiffWtLow = param.value[0]
  //           break;
  //         case "DiffUnit":
  //           obj.Unit = param.value[0]
  //           break;
  //         // Hardness
  //         case "HTID":
  //           obj.HTID = param.value[0]
  //           break;
  //         case "HardnessLow":
  //         case "HL":
  //           obj.HardnessLow = param.value[0]
  //           break;
  //         case "HardnessHigh":
  //         case "HH":
  //           obj.HardnessHigh = param.value[0]
  //           break;
  //         case "HardUnit":
  //           obj.HardUnit = param.value[0]
  //           break;
  //         // Thickness
  //         case "ThicknessLow":
  //         case "TL":
  //           obj.ThicknessLow = param.value[0]
  //           break;
  //         case "ThicknessHigh":
  //         case "TH":
  //           obj.ThicknessHigh = param.value[0]
  //           break;
  //         case "ThicknessUnit":
  //           obj.ThicknessUnit = param.value[0]
  //           break;
  //         // Friability
  //         case "FTID":
  //           obj.FTID = param.value[0]
  //           break;
  //         case "FSR":
  //           obj.FriabilitySetRPM = param.value[0]
  //           break;
  //         case "FR":
  //           obj.FriabilityRange = param.value[0]
  //           break;
  //         case "FriabilityLow":
  //           obj.FriabilityLow = param.value[0]
  //           break;
  //         case "FriabilityHigh":
  //           obj.FriabilityHigh = param.value[0]
  //           break;
  //         case "FriabUnit":
  //           obj.FriabUnit = param.value[0]
  //           break;
  //         // DT
  //         case "DTID":
  //           obj.DTID = param.value[0]
  //           break;
  //         case "DR":
  //           obj.DisintegrationRange = param.value[0]
  //           break;
  //         case "DisintegrationLow":
  //           obj.DisintegrationLow = param.value[0]
  //           break;
  //         case "DisintegrationHigh":
  //           obj.DisintegrationHigh = param.value[0]
  //           break;
  //         // Diameter
  //         case "DiameterLow":
  //           obj.DiameterLow = param.value[0]
  //           break;
  //         case "DiameterHigh":
  //           obj.DiameterHigh = param.value[0]
  //           break;
  //         case "DiameterUnit":
  //           obj.DiameterUnit = param.value[0]
  //           break;
  //         // Length
  //         case "LengthLow":
  //           obj.LengthLow = param.value[0]
  //           break;
  //         case "LengthHigh":
  //           obj.LengthHigh = param.value[0]
  //           break;
  //         case "LengthUnit":
  //           obj.LengthUnit = param.value[0]
  //           break;
  //         case "LockedLengthLow":
  //           obj.LockedLengthLow = param.value[0]
  //           break;
  //         case "LockedLengthHigh":
  //           obj.LockedLengthHigh = param.value[0]
  //           break;
  //         case "LockedLengthUnit":
  //           obj.LengthUnit = param.value[0]
  //           break;
  //         case "VerId":
  //           obj.VerId = param.value[0]
  //           break;
  //         // LOD Test (Moisture Analyzer)
  //         case "EquipmentId":
  //         case "EID":
  //           obj.MAID = param.value[0]
  //           break;
  //         case "LODR":
  //           obj.LODR = param.value[0]
  //           break;
  //         // Leak Test
  //         case "LTID":
  //           obj.LTID = param.value[0]
  //           break;
  //       }
  //     })

  //     // if (!obj?.MPN) {
  //     //   obj.MPN = "MPN_1"
  //     // }
  //     // obj.Side = "Double" // "Single" OR "Double"
  //     // obj.Container = "20"
  //     // obj.VerId = "D-Vernier-4263" // Vernier
  //     // obj.MAID = "D-Moisture-5221" // (Moisture Analyzer) LOD

  //     // Unit
  //     obj.IndUnit = "mg"
  //     obj.GrpUnit = "gm"
  //     obj.DiffUnit = "mg"
  //     obj.HardUnit = "N"
  //     obj.ThicknessUnit = "mm"
  //     obj.FriabUnit = "gm"
  //     obj.DiameterUnit = "mm"
  //     obj.LengthUnit = "mm"
  //     obj.LockedLengthUnit = "mm"

  //     if (obj?.DisintegrationRange) {
  //       // obj.DisintegrationRange = obj.DisintegrationRange.trim().split(" ")[1]
  //       obj.DisintegrationRange = obj.DisintegrationRange
  //     }

  //     if (obj?.FriabilityRange) {
  //       const friabRange = obj.FriabilityRange.match(/\d+(\.\d+)?/g);
  //       obj.FriabilityRange = friabRange ? friabRange[0] : 99999
  //     }

  //     if (obj?.FriabilitySetRPM) {
  //       obj.FriabilitySetRPM = obj.FriabilitySetRPM
  //     }

  //     /*
  //     // length parameters
  //     obj.LengthHigh = "1.96"
  //     obj.LengthLow = "0.54"
  //     */

  //     if (obj.IndWtHigh && obj.IndWtLow && obj?.IndWtHigh.split(" ")[1]) {
  //       obj.IndUnit = obj?.IndWtHigh.split(" ")[1]
  //       obj.IndWtHigh = obj?.IndWtHigh.split(" ")[0]
  //       obj.IndWtLow = obj?.IndWtLow.split(" ")[0]
  //     } else {
  //       console.log("Individual weight is missing, cannot find unit");
  //     }

  //     if (obj.GrpWtHigh && obj.GrpWtLow && obj?.GrpWtHigh.split(" ")[1]) {
  //       obj.GrpUnit = obj?.GrpWtHigh.split(" ")[1]
  //       obj.GrpWtLow = obj?.GrpWtLow.split(" ")[0]
  //       obj.GrpWtHigh = obj?.GrpWtHigh.split(" ")[0]
  //     } else {
  //       console.log("Group weight is missing, cannot find unit");
  //     }

  //     if (obj.ThicknessHigh && obj.ThicknessLow && obj?.ThicknessHigh.split(" ")[1]) {
  //       obj.ThicknessUnit = obj?.ThicknessHigh.split(" ")[1]
  //       obj.ThicknessLow = obj?.ThicknessLow.split(" ")[0]
  //       obj.ThicknessHigh = obj?.ThicknessHigh.split(" ")[0]
  //     } else {
  //       console.log("Thickness weight is missing, cannot find unit");
  //     }

  //     if (obj.HardnessHigh && obj.HardnessLow && obj?.HardnessHigh.split(" ")[1]) {
  //       obj.HardUnit = obj?.HardnessHigh.split(" ")[1]
  //       obj.HardnessLow = obj?.HardnessLow.split(" ")[0]
  //       obj.HardnessHigh = obj?.HardnessHigh.split(" ")[0]
  //     } else {
  //       console.log("Hardness weight is missing, cannot find unit");
  //     }

  //     // let initialdata = await models.tbl_tab_initialmaster.findAll({
  //     //   // attributes: [[sequelize.fn('max', sequelize.col('Repetition')), 'Repetition']],
  //     //   where: {
  //     //     BatchNo: obj.BatchID,
  //     //     SFOID: obj.SFOID,
  //     //     MPN_Code: obj.MPN,
  //     //     // Repetition: obj.Repetition
  //     //     //  / DsNo: DsNo
  //     //   }
  //     // })

  //     // let repetitionArr = initialdata.map(e => e.Repetition)

  //     const objActivity = {
  //       strUserId: "Received from MES",
  //       strUserName: "Received from MES",
  //       batch: obj?.BatchID ? obj.BatchID : "",
  //       activity: ""
  //     };

  //     const root = create().ele("TransferResult").ele("Error").ele("code").txt(0).up().ele("text").txt("").up().up().ele("Success").txt(true).up().up()
  //     let xml = root.end({ prettyPrint: true });

  //     // Insert MES data in tbl_mes_data_history
  //     await this.createMESDataHistory(obj);

  //     // if (initialdata.length > 0) {
  //     //   if (repetitionArr.includes(parseInt(obj?.Repetition))) {
  //     //     console.log("Repetition No already exist");
  //     //     objActivity.activity = "Repetition No already exist"
  //     //     await objActivityLog.ActivityLogEntry(objActivity);
  //     //     return xml;
  //     //   }
  //     // }

  //     if (obj?.LTID) {
  //       if (!((obj?.MPN) && (obj?.BatchID) && (obj?.SFOID) && (obj.TestType))) {
  //         console.log("Invalid data received from MES and the Instrument is LTID");
  //         objActivity.activity = "Invalid data received from MES"
  //         await objActivityLog.ActivityLogEntry(objActivity);
  //         return xml;
  //       }
  //     } else if (obj?.MAID) {
  //       if (!((obj?.BatchID) && (obj?.MAID) && (obj?.Repetition))) {
  //         console.log("Invalid data received from MES and the Instrument is MAID");
  //         objActivity.activity = "Invalid data received from MES"
  //         await objActivityLog.ActivityLogEntry(objActivity);
  //         return;
  //       }
  //     } else {
  //       if (!((obj?.BatchID) && (obj?.SFOID) && (obj?.Repetition || obj?.Repetition == 0) && (obj?.TestType) && (obj?.MPN) && (obj?.Side))) {
  //         console.log("Invalid data received from MES and Instrument is not MAID or LTID");
  //         objActivity.activity = "Invalid data received from MES"
  //         await objActivityLog.ActivityLogEntry(objActivity);
  //         return;
  //       }
  //     }

  //     // if (obj.TestType == "Startup" || obj.TestType == "Initial") {
  //     //   obj.TestType = 1
  //     // } else if (obj.TestType == "Regular" || obj.TestType == "Inprocess") {
  //     //   obj.TestType = 0
  //     // }
  //     // obj.MesTestType = obj.TestType;
  //     // obj.MesSide = obj.Side
  //     if (obj.TestType == undefined) {//for LOD
  //       obj.TestType = 'Inprocess'
  //     }
  //     if (obj.TestType.includes("Startup") || obj.TestType == "Initial") {
  //       obj.TestType = 1
  //     } else if (obj.LTID) {
  //       obj.TestType
  //     } else {
  //       // If testType is not startup it's always going to be "Inprocess"
  //       obj.TestType = 0
  //     }


  //     let cubicalRes = null;
  //     // For LTID
  //     if (obj?.LTID) {
  //       cubicalRes = await models.tbl_cubical.findOne({
  //         where: {
  //           Sys_LeakID: (obj?.LTID) ? obj.LTID : "",
  //           // Sys_CubType: { [Op.ne]: "IPQC" }
  //         }
  //       })

  //       if (!cubicalRes) {
  //         console.log("Instrument is not set in cubical, MES Post Message");
  //         objActivity.activity = "Instrument is not set in cubical"
  //         await objActivityLog.ActivityLogEntry(objActivity);
  //         return xml
  //       }

  //       // Get DS number from cubical
  //       const cubicDSNumber = cubicalRes.Sys_DSNumber;

  //       // Check for test status
  //       const testStatus = await models.tbl_system_weighingstatus.findOne({
  //         where: {
  //           CubicleNo: cubicalRes.Sys_CubicNo,
  //           Status: 1
  //         }
  //       })

  //       if (testStatus) {
  //         console.log("Test is ongoing, MES Post Message");
  //         objActivity.activity = "Test is running";
  //         await objActivityLog.ActivityLogEntry(objActivity);
  //         return xml;
  //       }

  //       // Check if mes data is present in mes table
  //       let mesRes = await models.tbl_mes_data.findAll({
  //         where: {
  //           DS_Number: cubicDSNumber
  //         },
  //       });

  //       if (mesRes.length > 0) {
  //         mesRes = mesRes[0]
  //       }

  //       // Destory particular data from mes table
  //       if (mesRes) {
  //         await models.tbl_mes_data.destroy({
  //           where: {
  //             DS_Number: cubicDSNumber,

  //           }
  //         });
  //       }



  //       // Create new entry in tbl_mes_data
  //       const mesEntryRes = await this.createMESEntry(obj, cubicDSNumber)

  //       // Update cubical DS number
  //       await this.updateCubical(cubicDSNumber, mesEntryRes, obj);

  //       // Update CubicleArea CubicleType
  //       await models.tbl_mes_data.update({
  //         CubicleArea: cubicalRes.Sys_Area,
  //         CubicleType: cubicalRes.Sys_CubType,
  //       }, {
  //         where: {
  //           DS_Number: cubicDSNumber
  //         }
  //       })

  //       const checkPendingRequest = globalData.PendingRequest.find(k => k.DsNo == cubicDSNumber);
  //       if (checkPendingRequest) {
  //         const menuObj = {
  //           dsNo: cubicDSNumber,
  //           tabIp: checkPendingRequest.TabIp,
  //           userId: checkPendingRequest.userId
  //         }
  //         objMenuRequestModel.sendMenu(menuObj)
  //       }
  //       return xml;
  //       // End of Leak Test
  //     } else if (obj?.MAID) {
  //       // For LOD
  //       cubicalRes = await models.tbl_cubical.findOne({
  //         where: {
  //           Sys_MoistID: (obj?.MAID) ? obj.MAID : "",
  //           // Sys_CubType: { [Op.ne]: "IPQC" }
  //         }
  //       })

  //       if (!cubicalRes) {
  //         console.log("Instrument is not set in cubical, MES Post Message");
  //         objActivity.activity = "Instrument is not set in cubical"
  //         await objActivityLog.ActivityLogEntry(objActivity);
  //         return xml
  //       }

  //       // Get DS number from cubical
  //       const cubicDSNumber = cubicalRes.Sys_DSNumber;

  //       // Check for test status
  //       const testStatus = await models.tbl_system_weighingstatus.findOne({
  //         where: {
  //           CubicleNo: cubicalRes.Sys_CubicNo,
  //           Status: 1
  //         }
  //       })

  //       if (testStatus) {
  //         console.log("Test is ongoing, MES Post Message");
  //         objActivity.activity = "Test is running";
  //         await objActivityLog.ActivityLogEntry(objActivity);
  //         return xml;
  //       }

  //       // Check if mes data is present in mes table
  //       let mesRes = await models.tbl_mes_data.findAll({
  //         where: {
  //           DS_Number: cubicDSNumber
  //         },
  //       });

  //       if (mesRes.length > 0) {
  //         mesRes = mesRes[0]

  //         await models.tbl_mes_data.destroy({
  //           where: {
  //             DS_Number: cubicDSNumber
  //           }
  //         });
  //       }

  //       // Destory particular data from mes table
  //       // if (mesRes) {
  //       //   await models.tbl_mes_data.destroy({
  //       //     where: {
  //       //       DS_Number: cubicDSNumber
  //       //     }
  //       //   });
  //       // }

  //       // Create new entry in tbl_mes_data
  //       const mesEntryRes = await this.createMESEntry(obj, cubicDSNumber)

  //       // Update cubical DS number
  //       await this.updateCubical(cubicDSNumber, mesEntryRes, obj);

  //       const checkPendingRequest = globalData.PendingRequest.find(k => k.DsNo == cubicDSNumber);
  //       if (checkPendingRequest) {
  //         const menuObj = {
  //           dsNo: cubicDSNumber,
  //           tabIp: checkPendingRequest.TabIp,
  //           userId: checkPendingRequest.userId
  //         }
  //         objMenuRequestModel.sendMenu(menuObj)
  //       }
  //       return xml;
  //       // End of LOD
  //     } else {
  //       // For other tests, we have to check for product limits
  //       if (!obj?.MPN) {
  //         console.log("Product is not received from MES");
  //         objActivity.activity = "Invalid data received from MES"
  //         await objActivityLog.ActivityLogEntry(objActivity);
  //         return xml;
  //       }

  //       cubicalRes = await models.tbl_cubical.findAll({
  //         where: {
  //           [Op.or]: [
  //             { Sys_BalID: (obj?.AWBID) ? obj.AWBID : "" },
  //             // { Sys_BalID2: (obj?.GrpWtEqmID) ? obj.GrpWtEqmID : (obj?.IndWtEqmID) ? obj.IndWtEqmID : "" },
  //             { Sys_HardID: (obj?.HTID) ? obj.HTID : "" },
  //             { Sys_MoistID: (obj?.MAID) ? obj.MAID : "" },
  //             { Sys_VernierID: (obj?.VerId) ? obj.VerId : "" },
  //             { Sys_FriabID: (obj?.FTID) ? obj.FTID : "" },
  //             { Sys_DTID: (obj?.DTID) ? obj.DTID : "" },
  //           ],
  //           // Sys_Batch: obj.BatchID,
  //           // Sys_CubType: { [Op.ne]: "IPQC" }
  //         }
  //       })
  //       if (cubicalRes.length > 0) {
  //         cubicalRes = cubicalRes[0]
  //       }

  //       if (cubicalRes.length == 0) {
  //         console.log("Instrument is not found in area, MES Post Message");
  //         objActivity.activity = "Instrument is not found in area"
  //         await objActivityLog.ActivityLogEntry(objActivity);
  //         return xml;
  //       }
  //       const cubicDSNumber = cubicalRes.Sys_DSNumber;

  //       const testStatus = await models.tbl_system_weighingstatus.findOne({
  //         where: {
  //           Sys_CubicName: cubicalRes.Sys_CubicName,
  //           BatchNo: cubicalRes.Sys_Batch,
  //           Status: 1
  //         }
  //       })

  //       if (testStatus) {
  //         console.log("Test is ongoing, MES Post Message");
  //         objActivity.activity = "Test is running";
  //         await objActivityLog.ActivityLogEntry(objActivity);
  //         // mqttSender.sendData(cubicDSNumber, `${GLOBAL_NOMENCLATURE.DisplayMessage} ${'Request In Queue'}`);
  //         return xml;
  //       }

  //       let mesRes = await models.tbl_mes_data.findAll({
  //         where: {
  //           DS_Number: cubicDSNumber
  //         },
  //       });

  //       if (mesRes.length > 0) {
  //         // mesRes = mesRes[0];

  //         await models.tbl_mes_data.destroy({
  //           where: {
  //             DS_Number: cubicDSNumber
  //           }
  //         });
  //       }

  //       // if (mesRes) {
  //       //   await models.tbl_mes_data.destroy({
  //       //     where: {
  //       //       DS_Number: cubicDSNumber
  //       //     }
  //       //   });
  //       // }

  //       let mesEntryRes = await this.createMESEntry(obj, cubicDSNumber)

  //       const productMasterRes = await models.tbl_product_master.findOne({
  //         where: {
  //           MPN_Code: obj.MPN,
  //         }
  //       })

  //       if (!productMasterRes) {
  //         console.log("No product set in product master, MES Post Message");
  //         objActivity.activity = "Product is not set"

  //         await objActivityLog.ActivityLogEntry(objActivity);
  //         return xml;
  //       }

  //       const productType = productMasterRes.ProductType;
  //       let productTypeTableName = "tbl_product_tablet";
  //       let productTypeTableNameTemp = "tbl_product_tablet_temp";

  //       if (productType == 2) {
  //         productTypeTableName = "tbl_product_capsule"
  //         productTypeTableNameTemp = "tbl_product_capsule_temp"
  //       }

  //       const productLimitRes = await models[productTypeTableName].findOne({
  //         where: {
  //           MPN_Code: obj.MPN,
  //         }
  //       });

  //       if (!productLimitRes) {
  //         console.log(`Product limit not found in ${productTypeTableName}`);
  //         return xml;
  //       }

  //       const productTabletTempRes = await models[productTypeTableNameTemp].findOne({
  //         where: {
  //           MPN_Code: obj.MPN,
  //         }
  //       })

  //       if (!productTabletTempRes) {
  //         if (productType == 1) {
  //           // tablet
  //           await models[productTypeTableNameTemp].create({
  //             MPN_Code: obj.MPN,
  //             // Individual
  //             Param1_T2Neg: (Number(obj.IndWtLow) && !isNaN(obj.IndWtLow)) ? Number(obj.IndWtLow) : 99999,
  //             Param1_T2Pos: (Number(obj.IndWtHigh) && !isNaN(obj.IndWtLow)) ? Number(obj.IndWtHigh) : 99999,
  //             Param1_Unit: obj.IndUnit,
  //             // Group
  //             Param2_T2Neg: (Number(obj.GrpWtLow) && !isNaN(obj.GrpWtLow)) ? Number(obj.GrpWtLow) : 99999,
  //             Param2_T2Pos: (Number(obj.GrpWtHigh) && !isNaN(obj.GrpWtHigh)) ? Number(obj.GrpWtHigh) : 99999,
  //             Param2_Unit: obj.GrpUnit,
  //             // Thickness
  //             Param3_T2Neg: (Number(obj.ThicknessLow) && !isNaN(obj.ThicknessLow)) ? Number(obj.ThicknessLow) : 99999,
  //             Param3_T2Pos: (Number(obj.ThicknessHigh) && !isNaN(obj.ThicknessHigh)) ? Number(obj.ThicknessHigh) : 99999,
  //             Param3_Unit: obj.ThicknessUnit,
  //             // Diameter
  //             Param6_T2Pos: (Number(obj.DiameterLow) && !isNaN(obj.DiameterLow)) ? Number(obj.DiameterLow) : 99999,
  //             Param6_T2Neg: (Number(obj.DiameterHigh) && !isNaN(obj.DiameterHigh)) ? Number(obj.DiameterHigh) : 99999,
  //             Param6_Unit: obj.DiameterUnit,
  //             // Length
  //             Param5_T2Neg: (Number(obj.LengthLow) && !isNaN(obj.LengthLow)) ? Number(obj.LengthLow) : 99999,
  //             Param5_T2Pos: (Number(obj.LengthHigh) && !isNaN(obj.LengthHigh)) ? Number(obj.LengthHigh) : 99999,
  //             Param5_Unit: obj.LengthUnit,
  //             // Hardness
  //             Param7_T2Neg: (Number(obj.HardnessLow) && !isNaN(obj.HardnessLow)) ? Number(obj.HardnessLow) : 99999,
  //             Param7_T2Pos: (Number(obj.HardnessHigh) && !isNaN(obj.HardnessHigh)) ? Number(obj.HardnessHigh) : 99999,
  //             Param7_Unit: obj.HardUnit,
  //             // Friability
  //             // Param8_T1Neg: (Number(obj.FriabilityLow) && !isNaN(obj.FriabilityLow)) ? Number(obj.FriabilityLow) : 99999,
  //             // Param8_T1Pos: (Number(obj.FriabilityHigh) && !isNaN(obj.FriabilityHigh)) ? Number(obj.FriabilityHigh) : 99999,
  //             Param8_Nom: (obj?.FriabilityRange) ? obj.FriabilityRange : "NA", // NMT 0.10 %
  //             // Param8_T1Pos: (obj?.FriabilitySetRPM) ? obj?.FriabilitySetRPM : "NA", // RPM 00:04:00
  //             Param8_LimitOn: (obj?.FriabilityRange) ? 1 : "NA", // for percentage
  //             Param8_Unit: obj.FriabUnit,
  //             // DT
  //             // Param13_T1Neg: (Number(obj.DisintegrationLow) && isNaN(obj.DisintegrationLow)) ? Number(obj.DisintegrationLow) : 99999,
  //             // Param13_T1Pos: (Number(obj.DisintegrationHigh) && isNaN(obj.DisintegrationHigh)) ? Number(obj.DisintegrationHigh) : 99999,
  //             Param13_Nom: (obj.DisintegrationRange) ? obj.DisintegrationRange : "NA",
  //             // LOD
  //             // Param16_T1Neg: Number(obj.InitialWeight) ? Number(obj.InitialWeight) : 99999,
  //             // Param16_T1Pos: Number(obj.FinalWeight) ? Number(obj.FinalWeight) : 99999,
  //             // Param16_Unit: "",
  //           })
  //         } else {
  //           // capsule
  //           await models[productTypeTableNameTemp].create({
  //             MPN_Code: obj.MPN,
  //             // Individual
  //             Param1_T2Neg: (Number(obj.IndWtLow) && !isNaN(obj.IndWtLow)) ? Number(obj.IndWtLow) : 99999,
  //             Param1_T2Pos: (Number(obj.IndWtHigh) && !isNaN(obj.IndWtLow)) ? Number(obj.IndWtHigh) : 99999,
  //             Param1_Unit: obj.IndUnit,
  //             // Group
  //             Param2_T2Neg: (Number(obj.GrpWtLow) && !isNaN(obj.GrpWtLow)) ? Number(obj.GrpWtLow) : 99999,
  //             Param2_T2Pos: (Number(obj.GrpWtHigh) && !isNaN(obj.GrpWtHigh)) ? Number(obj.GrpWtHigh) : 99999,
  //             Param2_Unit: obj.GrpUnit,
  //             // Differential
  //             Param3_T2Neg: (Number(obj.GrpWtLow) && !isNaN(obj.GrpWtLow)) ? Number(obj.GrpWtLow) : 99999,
  //             Param3_T2Pos: (Number(obj.GrpWtHigh) && !isNaN(obj.GrpWtHigh)) ? Number(obj.GrpWtHigh) : 99999,
  //             Param3_Unit: obj.GrpUnit,
  //             // Locked Length
  //             Param5_T2Neg: (Number(obj.LockedLengthLow) && !isNaN(obj.LockedLengthLow)) ? Number(obj.LockedLengthLow) : 99999,
  //             Param5_T2Pos: (Number(obj.LockedLengthHigh) && !isNaN(obj.LockedLengthHigh)) ? Number(obj.LockedLengthHigh) : 99999,
  //             Param5_Unit: obj.LengthUnit,
  //             // DT
  //             // Param6_T1Neg: (Number(obj.DisintegrationLow) && isNaN(obj.DisintegrationLow)) ? Number(obj.DisintegrationLow) : 99999,
  //             // Param6_T1Pos: (Number(obj.DisintegrationHigh) && isNaN(obj.DisintegrationHigh)) ? Number(obj.DisintegrationHigh) : 99999,
  //             Param6_Nom: (obj.DisintegrationRange) ? obj.DisintegrationRange : "NA",
  //           })
  //         }
  //       } else {
  //         // Check product limit and create audit of it and if product limit change upadte it to temp table
  //         const productLimitStatus = await this.createAuditAndCheckLimit(productLimitRes, mesEntryRes, productType)
  //         if (productLimitStatus) {
  //           await models.tbl_product_master.update({
  //             isLimitChanged: 1
  //           }, {
  //             where: {
  //               MPN_Code: obj.MPN,
  //             }
  //           })
  //         } else {
  //           await models.tbl_product_master.update({
  //             isLimitChanged: 0
  //           }, {
  //             where: {
  //               MPN_Code: obj.MPN,
  //             }
  //           })
  //         }
  //       }

  //       await this.updateCubical(cubicDSNumber, mesEntryRes, obj)
  //       await this.updateSampleNo(cubicalRes.Sys_CubicNo, mesEntryRes)

  //       if (productType == 1) {
  //         // update tablet unit
  //         await models[productTypeTableName].update({
  //           Param1_Unit: (obj?.IndUnit) ? obj.IndUnit : "",
  //           Param2_Unit: (obj?.GrpUnit) ? obj.GrpUnit : "",
  //           Param3_Unit: (obj?.ThicknessUnit) ? obj.ThicknessUnit : "",
  //           Param5_Unit: (obj?.LengthUnit) ? obj.LengthUnit : "",
  //           Param6_Unit: (obj?.DiameterUnit) ? obj.DiameterUnit : "",
  //           Param7_Unit: (obj?.HardUnit) ? obj.HardUnit : "",
  //           Param8_Unit: (obj?.FriabUnit) ? obj.FriabUnit : "",
  //           // Param13_Unit: "", DT
  //           // Param16_Unit: "", LOD
  //           Param17_Unit: (obj?.FriabUnit) ? obj.FriabUnit : "",
  //         }, {
  //           where: {
  //             MPN_Code: obj.MPN
  //           }
  //         })
  //       } else {
  //         // update capsule unit
  //         await models[productTypeTableName].update({
  //           Param1_Unit: (obj?.IndUnit) ? obj.IndUnit : "",
  //           Param2_Unit: (obj?.GrpUnit) ? obj.GrpUnit : "",
  //           Param3_Unit: (obj?.DiffUnit) ? obj.DiffUnit : "",
  //           Param5_Unit: (obj?.LockedLengthUnit) ? obj.LockedLengthUnit : "",
  //         }, {
  //           where: {
  //             MPN_Code: obj.MPN
  //           }
  //         })
  //       }


  //       // Update CubicleArea CubicleType
  //       await models.tbl_mes_data.update({
  //         CubicleArea: cubicalRes.Sys_Area,
  //         CubicleType: cubicalRes.Sys_CubType,
  //       }, {
  //         where: {
  //           DS_Number: cubicDSNumber
  //         }
  //       })

  //       const IPQCList = globalData.IPQCList.find((k) => k.area == cubicalRes.Sys_Area);
  //       if (IPQCList) {
  //         const batchFound = IPQCList.bathces.findIndex((k) => k.batch == cubicalRes.Sys_Batch)
  //         if (!batchFound || batchFound < 0) {
  //           IPQCList.bathces.push({
  //             batch: cubicalRes.Sys_Batch,
  //             dsNo: cubicalRes.Sys_DSNumber
  //           })
  //         }

  //         let resObj = {
  //           status: 'success',
  //           Area: IPQCList.area,
  //           batch: IPQCList.bathces,
  //           tabIp: IPQCList.tabIp,
  //           isUpdated: true
  //         }

  //         console.log("Menu has been send through MQTT. ", JSON.stringify(resObj));
  //         mqttSender.sendData(IPQCList.dsNo, `onAreaSelectionGetBatch:${JSON.stringify(resObj)}`)
  //       }

  //       // End of other Test
  //     }

  //     const checkPendingRequest = globalData.PendingRequest.find(k => k.DsNo == cubicalRes.Sys_DSNumber);
  //     if (checkPendingRequest) {
  //       const menuObj = {
  //         dsNo: cubicalRes.Sys_DSNumber,
  //         tabIp: checkPendingRequest.TabIp,
  //         userId: checkPendingRequest.userId
  //       }
  //       objMenuRequestModel.sendMenu(menuObj)
  //     }
  //     return xml;
  //   } catch (err) {
  //     console.log('err: ', err);
  //   }
  // }

  // async createMESDataHistory(obj) {
  //   try {
  //     const currentDateTime = date.format(new Date(), 'YYYY-MM-DD HH:mm:ss');

  //     const mesHistoryRes = await models.tbl_mes_data_history.create({
  //       prDate: currentDateTime,
  //       BatchID: obj.BatchID,
  //       SFOID: obj.SFOID,
  //       Repetition: obj.Repetition,
  //       TestType: obj.TestType,
  //       MPN: obj.MPN,
  //       // ProductId: obj.ProductId,
  //       // ProductName: obj.ProductName,
  //       // ProductType: obj.ProductType,
  //       Side: obj.Side,
  //       Container: obj.Container,
  //       SampleCount: (obj?.SampleCount) ? obj.SampleCount : 0,
  //       GroupSampleCount: (obj?.GroupSampleCount) ? obj.GroupSampleCount : 0,
  //       StartSampleCount: (obj?.StartSampleCount) ? obj.StartSampleCount : 0,

  //       // Balance ID
  //       AWBID: (obj?.AWBID) ? obj.AWBID : "NA",
  //       // Vernier ID
  //       VerId: (obj?.VerId) ? obj.VerId : "NA",
  //       // LOD (Moisture Analyzer) (No parameter for LOD Test)
  //       MAID: (obj?.MAID) ? obj.MAID : "NA",

  //       // Individual
  //       IndWtLow: ((obj?.IndWtLow || obj?.IndWtLow == 0) && obj?.IndWtLow != 'NA') ? obj.IndWtLow : 99999,
  //       IndWtHigh: ((obj?.IndWtHigh || obj?.IndWtHigh == 0) && obj?.IndWtHigh != 'NA') ? obj.IndWtHigh : 99999,
  //       IndUnit: (obj?.IndUnit) ? obj.IndUnit : "",

  //       // Group
  //       GrpWtLow: ((obj?.GrpWtLow || obj?.GrpWtLow == 0) && obj?.GrpWtLow != 'NA') ? obj.GrpWtLow : 99999,
  //       GrpWtHigh: ((obj?.GrpWtHigh || obj.GrpWtHigh == 0) && obj?.GrpWtHigh != 'NA') ? obj.GrpWtHigh : 99999,
  //       GrpUnit: (obj?.GrpUnit) ? obj.GrpUnit : "",

  //       // Differential
  //       DiffWtLow: ((obj?.DiffWtLow || obj?.DiffWtLow == 0) && obj?.DiffWtLow != 'NA') ? obj.DiffWtLow : 99999,
  //       DiffWtHigh: ((obj?.DiffWtHigh || obj?.DiffWtHigh == 0) && obj?.DiffWtHigh != 'NA') ? obj.DiffWtHigh : 99999,
  //       DiffUnit: (obj?.DiffUnit) ? obj.DiffUnit : "",

  //       // Hardness
  //       HTID: (obj?.HTID) ? obj.HTID : "NA",
  //       HardnessLow: ((obj?.HardnessLow || obj?.HardnessLow == 0) && obj?.HardnessLow != 'NA') ? obj.HardnessLow : 99999,
  //       HardnessHigh: ((obj?.HardnessHigh || obj?.HardnessHigh == 0) && obj?.HardnessHigh != 'NA') ? obj.HardnessHigh : 99999,
  //       HardUnit: (obj?.HardUnit) ? obj.HardUnit : "",

  //       // Thickness 
  //       ThicknessLow: ((obj?.ThicknessLow || obj?.ThicknessLow == 0) && obj?.ThicknessLow != 'NA') ? obj.ThicknessLow : 99999,
  //       ThicknessHigh: ((obj?.ThicknessHigh || obj?.ThicknessHigh == 0) && obj?.ThicknessHigh != 'NA') ? obj.ThicknessHigh : 99999,
  //       ThicknessUnit: (obj?.ThicknessUnit) ? obj.ThicknessUnit : "",

  //       // Diameter 
  //       DiameterLow: ((obj?.DiameterLow || obj?.DiameterLow == 0) && obj?.DiameterLow != 'NA') ? obj.DiameterLow : 99999,
  //       DiameterHigh: ((obj?.DiameterHigh || obj?.DiameterHigh == 0) && obj?.DiameterHigh != 'NA') ? obj.DiameterHigh : 99999,
  //       DiameterUnit: (obj?.DiameterUnit) ? obj.DiameterUnit : "",

  //       // Length 
  //       LengthLow: ((obj?.LengthLow || obj?.LengthLow == 0) && obj?.LengthLow != 'NA') ? obj.LengthLow : 99999,
  //       LengthHigh: ((obj?.LengthHigh || obj?.LengthHigh == 0) && obj?.LengthHigh != 'NA') ? obj.LengthHigh : 99999,
  //       LengthUnit: (obj?.LengthUnit) ? obj.LengthUnit : "",

  //       // Locked Length 
  //       LockedLengthLow: ((obj?.LockedLengthLow || obj?.LockedLengthLow == 0) && obj?.LockedLengthLow != 'NA') ? obj.LockedLengthLow : 99999,
  //       LockedLengthHigh: ((obj?.LockedLengthHigh || obj?.LockedLengthHigh == 0) && obj?.LockedLengthHigh != 'NA') ? obj.LockedLengthHigh : 99999,
  //       LockedLengthUnit: (obj?.LockedLengthUnit) ? obj.LockedLengthUnit : "",

  //       // Disintegration Test
  //       DTID: (obj?.DTID) ? obj.DTID : "NA",
  //       // DisintegrationLow: (obj?.DisintegrationLow) ? obj.DisintegrationLow : 99999,
  //       // DisintegrationHigh: (obj.DisintegrationHigh) ? obj.DisintegrationHigh : 99999,
  //       DisintegrationRange: (obj.DisintegrationRange) ? obj.DisintegrationRange : "NA",

  //       // Friability Test
  //       FTID: (obj?.FTID) ? obj.FTID : "NA",
  //       // FriabilityLow: (obj?.FriabilityLow) ? obj.FriabilityLow : 99999,
  //       // FriabilityHigh: (obj?.FriabilityHigh) ? obj.FriabilityHigh : 99999,
  //       FriabilityRange: (obj?.FriabilityRange) ? obj.FriabilityRange : 99999,
  //       FriabilityRPM: (obj?.FriabilitySetRPM && obj?.FriabilitySetRPM != 'NA') ? obj.FriabilitySetRPM : 99999,
  //       FriabUnit: (obj?.FriabUnit) ? obj.FriabUnit : "",

  //       LTID: (obj?.LTID) ? obj.LTID : "NA",

  //       MesTestType: (obj?.MesTestType) ? obj.MesTestType : '',
  //       MesSide: (obj?.MesSide) ? obj?.MesSide : '',

  //       Remark: "MES data received"
  //       // GrpWtEqmID: (obj?.GrpWtEqmID) ? obj.GrpWtEqmID : "",
  //     })

  //     return mesHistoryRes
  //   } catch (error) {
  //     console.log('error: ', error);
  //   }
  // }

  // async createMESEntry(obj, cubicDSNumber) {
  //   try {
  //     let indFound = false;
  //     let grpFound = false;
  //     let diffFound = false;
  //     let hardFound = false;
  //     let thicknessFound = false;
  //     let friabFound = false;
  //     let DTFound = false;
  //     let diameterFound = false;
  //     let lengthFound = false;
  //     let lockedLengthFound = false;
  //     let MAFound = false;
  //     let verFound = false;
  //     let LeakFound = false;

  //     // Individual Test
  //     if ((obj?.AWBID) && ((obj?.IndWtLow || obj?.IndWtLow == 0) && !isNaN(obj?.IndWtLow)) && ((obj?.IndWtHigh || obj?.IndWtHigh == 0) && !isNaN(obj?.IndWtHigh)) && (obj?.IndUnit)) {
  //       indFound = true;
  //     }
  //     // Group Test
  //     if ((obj?.AWBID) && ((obj?.GrpWtLow || obj?.GrpWtLow == 0) && !isNaN(obj?.GrpWtLow)) && ((obj?.GrpWtHigh || obj?.GrpWtHigh == 0) && !isNaN(obj?.GrpWtHigh)) && (obj?.GrpUnit)) {
  //       grpFound = true;
  //     }
  //     // Differential Test
  //     if ((obj?.AWBID) && ((obj?.DiffWtLow || obj?.DiffWtLow == 0) && !isNaN(obj?.DiffWtLow)) && ((obj?.DiffWtHigh || obj?.DiffWtHigh == 0) && !isNaN(obj?.DiffWtHigh)) && (obj?.DiffUnit)) {
  //       diffFound = true;
  //     }
  //     // Hardness Test
  //     if ((obj?.HTID) && ((obj?.HardnessLow || obj?.HardnessLow == 0) && !isNaN(obj?.HardnessLow)) && ((obj?.HardnessHigh || obj?.HardnessHigh == 0) && !isNaN(obj?.HardnessHigh)) && (obj?.HardUnit)) {
  //       hardFound = true;
  //     }
  //     // Thickness Test
  //     if (((obj?.ThicknessLow || obj?.ThicknessLow == 0) && !isNaN(obj?.ThicknessLow)) && ((obj?.ThicknessHigh || obj?.ThicknessHigh == 0) && !isNaN(obj?.ThicknessHigh))) {
  //       thicknessFound = true;
  //     }
  //     // Friability Test
  //     if ((obj?.FTID) && (obj.FriabilityRange) && (obj.FriabilitySetRPM)) {
  //       friabFound = true;
  //     }
  //     // Disintegration Test
  //     if ((obj?.DTID) && (obj?.DisintegrationRange)) {
  //       DTFound = true;
  //     }
  //     // Diameter
  //     if (((obj.DiameterHigh || obj.DiameterHigh == 0) && !isNaN(obj?.DiameterHigh)) && ((obj?.DiameterLow || obj?.DiameterLow == 0) && !isNaN(obj?.DiameterLow))) {
  //       diameterFound = true;
  //     }
  //     // Length
  //     if (((obj.LengthHigh || obj.LengthHigh == 0) && !isNaN(obj?.LengthHigh)) && ((obj.LengthLow || obj.LengthLow == 0) && !isNaN(obj?.LengthLow))) {
  //       lengthFound = true;
  //     }
  //     // Locked Length
  //     if (((obj.LockedLengthHigh || obj.LockedLengthHigh == 0) && !isNaN(obj?.LockedLengthHigh)) && ((obj.LockedLengthLow || obj.LockedLengthLow == 0) && !isNaN(obj?.LockedLengthLow))) {
  //       lockedLengthFound = true;
  //     }
  //     // Vernier
  //     if (obj?.VerId) {
  //       verFound = true;
  //     }
  //     // LOD
  //     if (obj?.MAID) {
  //       MAFound = true;
  //     }
  //     // Leak Test
  //     if (obj.LTID) {
  //       LeakFound = true;
  //     }

  //     // const currentDateTimeString = moment(new Date()).format('YYYY-MM-DD HH:mm:ss');
  //     const currentDateTime = date.format(new Date(), 'YYYY-MM-DD HH:mm:ss');

  //     let mesWhereCondition = {
  //       BatchID: obj.BatchID,
  //       TestType: obj.TestType,
  //       MesTestType: obj.MesTestType,
  //       isSetInCubical: 0
  //     }

  //     if(MAFound) {
  //       mesWhereCondition.MesTestType = obj.MesTestType
  //       // mesWhereCondition.Repetition = obj?.Repetition
  //     } else if(!MAFound && !LeakFound) {
  //       mesWhereCondition.Repetition = obj?.Repetition
  //       mesWhereCondition.MesSide = obj?.MesSide
  //     }

  //     let mesData = await models.tbl_mes_data.findAll({ where: mesWhereCondition })

  //     // let initialData = await models.tbl_tab_initialmaster.findAll({ where : mesWhereCondition })
  //     if(mesData.length == 0) {
  //       const mesRes = await models.tbl_mes_data.create({
  //         prDate: currentDateTime,
  //         BatchID: obj.BatchID,
  //         SFOID: obj.SFOID,
  //         Repetition: obj.Repetition,
  //         TestType: obj.TestType,
  //         MPN: obj.MPN,
  //         // ProductId: obj.ProductId,
  //         // ProductName: obj.ProductName,
  //         // ProductType: obj.ProductType,
  //         Side: obj.Side,
  //         Container: obj.Container,
  //         DS_Number: cubicDSNumber, // DS_Number
  //         SampleCount: (obj?.SampleCount) ? obj.SampleCount : 0,
  //         GroupSampleCount: (obj?.GroupSampleCount) ? obj.GroupSampleCount : 0,
  //         StartSampleCount: (obj?.StartSampleCount) ? obj.StartSampleCount : 0,

  //         // Balance ID
  //         AWBID: (obj?.AWBID) ? obj.AWBID : "NA",
  //         // Vernier ID
  //         VerId: (obj?.VerId) ? obj.VerId : "NA",
  //         // LOD (Moisture Analyzer) (No parameter for LOD Test)
  //         MAID: (obj?.MAID) ? obj.MAID : "NA",

  //         // Individual
  //         IndWtLow: (indFound) ? obj.IndWtLow : 99999,
  //         IndWtHigh: (indFound) ? obj.IndWtHigh : 99999,
  //         IndUnit: (indFound) ? obj.IndUnit : "",

  //         // Group
  //         GrpWtLow: (grpFound) ? obj.GrpWtLow : 99999,
  //         GrpWtHigh: (grpFound) ? obj.GrpWtHigh : 99999,
  //         GrpUnit: (grpFound) ? obj.GrpUnit : "",

  //         // Differential 
  //         DiffWtLow: (diffFound) ? obj.DiffWtLow : 99999,
  //         DiffWtHigh: (diffFound) ? obj.DiffWtHigh : 99999,
  //         DiffUnit: (diffFound) ? obj.DiffUnit : "",

  //         // Hardness
  //         HTID: (hardFound) ? obj.HTID : "NA",
  //         HardnessLow: (hardFound) ? obj.HardnessLow : 99999,
  //         HardnessHigh: (hardFound) ? obj.HardnessHigh : 99999,
  //         HardUnit: (hardFound) ? obj.HardUnit : "",

  //         // Thickness
  //         ThicknessLow: (thicknessFound) ? obj.ThicknessLow : 99999,
  //         ThicknessHigh: (thicknessFound) ? obj.ThicknessHigh : 99999,
  //         ThicknessUnit: (thicknessFound) ? obj.ThicknessUnit : "",

  //         // Diameter
  //         DiameterLow: (diameterFound) ? obj.DiameterLow : 99999,
  //         DiameterHigh: (diameterFound) ? obj.DiameterHigh : 99999,
  //         DiameterUnit: (diameterFound) ? obj.DiameterUnit : "",

  //         // Length
  //         LengthLow: (lengthFound) ? obj.LengthLow : 99999,
  //         LengthHigh: (lengthFound) ? obj.LengthHigh : 99999,
  //         LengthUnit: (lengthFound) ? obj.LengthUnit : "",

  //         // Locked Length
  //         LockedLengthLow: (lockedLengthFound) ? obj.LockedLengthLow : 99999,
  //         LockedLengthHigh: (lockedLengthFound) ? obj.LockedLengthHigh : 99999,
  //         LockedLengthUnit: (lockedLengthFound) ? obj.LockedLengthUnit : "",

  //         // Disintegration Test
  //         DTID: (DTFound) ? obj.DTID : "NA",
  //         // DisintegrationLow: (DTFound) ? obj.DisintegrationLow : 99999,
  //         // DisintegrationHigh: (DTFound) ? obj.DisintegrationHigh : 99999,
  //         DisintegrationRange: (DTFound) ? obj.DisintegrationRange : 99999,

  //         // Friability Test
  //         FTID: (friabFound) ? obj.FTID : "NA",
  //         // FriabilityLow: (friabFound) ? obj.FriabilityLow : 99999,
  //         // FriabilityHigh: (friabFound) ? obj.FriabilityHigh : 99999,
  //         FriabilityRange: (friabFound) ? obj.FriabilityRange : 99999, // NMT 0.14 RPM
  //         FriabilityRPM: (friabFound) ? obj.FriabilitySetRPM : 99999,
  //         FriabUnit: (friabFound) ? obj.FriabUnit : "",

  //         // Leak Test
  //         LTID: (obj?.LTID) ? obj.LTID : "NA",

  //         MesTestType: (obj?.MesTestType) ? obj.MesTestType : '',
  //         MesSide: (obj?.MesSide) ? obj?.MesSide : '',

  //         // LOD Test
  //         LODHigh: (obj?.LODR) ? obj.LODR : 99999,

  //         // GrpWtEqmID: (grpFound) ? obj.GrpWtEqmID : "NA",
  //       })

  //       return mesRes.dataValues;
  //     } else {
  //       let resobj = { status: 'fail', message: 'Invalid Mes Request' };
  //       return resobj;
  //     }

  //   } catch (error) {
  //     console.log('error: ', error);
  //   }
  // }

  // async createAuditAndCheckLimit(productLimitRes, mesEntryRes, productType) {
  //   let isLimitChanged = false
  //   const tblProductTabletTempObj = {}

  //   // Individual
  //   if (Number(mesEntryRes.IndWtLow) != 99999 && (Number(mesEntryRes.IndWtHigh) != 99999)) {
  //     // Individual Low
  //     if ((Number(productLimitRes.Param1_T2Neg) != Number(mesEntryRes.IndWtLow))) {
  //       if (Number(productLimitRes.Param1_T2Neg) != 99999) {
  //         isLimitChanged = true
  //         tblProductTabletTempObj.Param1_T2Neg = Number(mesEntryRes.IndWtLow);
  //       }
  //     }

  //     // Individual High
  //     if ((Number(productLimitRes.Param1_T2Pos) != Number(mesEntryRes.IndWtHigh))) {
  //       if (Number(productLimitRes.Param1_T2Pos) != 99999) {
  //         isLimitChanged = true
  //         tblProductTabletTempObj.Param1_T2Pos = Number(mesEntryRes.IndWtHigh);
  //       }
  //     }
  //   }

  //   // Group
  //   if (Number(mesEntryRes.GrpWtLow) != 99999 && (Number(mesEntryRes.GrpWtHigh) != 99999)) {
  //     // Group Low
  //     if ((Number(productLimitRes.Param2_T2Neg) != Number(mesEntryRes.GrpWtLow))) {
  //       if (Number(productLimitRes.Param2_T2Neg) != 99999) {
  //         isLimitChanged = true
  //         tblProductTabletTempObj.Param2_T2Neg = Number(mesEntryRes.GrpWtLow);
  //       }
  //     }

  //     // Group High
  //     if ((Number(productLimitRes.Param2_T2Pos) != Number(mesEntryRes.GrpWtHigh))) {
  //       if (Number(productLimitRes.Param2_T2Pos) != 99999) {
  //         isLimitChanged = true
  //         tblProductTabletTempObj.Param2_T2Pos = Number(mesEntryRes.GrpWtHigh);
  //       }
  //     }
  //   }

  //   // Differential
  //   if (Number(mesEntryRes.DiffWtLow) != 99999 && (Number(mesEntryRes.DiffWtHigh) != 99999) && productType == 2) {
  //     // Differential Low
  //     if ((Number(productLimitRes.Param3_T2Neg) != Number(mesEntryRes.DiffWtLow))) {
  //       if (Number(productLimitRes.Param3_T2Neg) != 99999) {
  //         isLimitChanged = true
  //         tblProductTabletTempObj.Param3_T2Neg = Number(mesEntryRes.DiffWtLow);
  //       }
  //     }

  //     // Differential High
  //     if ((Number(productLimitRes.Param3_T2Pos) != Number(mesEntryRes.DiffWtHigh))) {
  //       if (Number(productLimitRes.Param3_T2Pos) != 99999) {
  //         isLimitChanged = true
  //         tblProductTabletTempObj.Param3_T2Pos = Number(mesEntryRes.DiffWtHigh);
  //       }
  //     }
  //   }

  //   // Hardness
  //   if ((Number(mesEntryRes.HardnessLow) != 99999) && (Number(mesEntryRes.HardnessLow) != 99999) && productType == 1) {
  //     // Hardness Low
  //     if ((Number(productLimitRes.Param7_T2Neg) != Number(mesEntryRes.HardnessLow))) {
  //       if (Number(productLimitRes.Param7_T2Neg) != 99999) {
  //         isLimitChanged = true
  //         tblProductTabletTempObj.Param7_T2Neg = Number(mesEntryRes.HardnessLow);
  //       }
  //     }

  //     // Hardness High
  //     if ((Number(productLimitRes.Param7_T2Pos) != Number(mesEntryRes.HardnessHigh))) {
  //       if (Number(productLimitRes.Param7_T2Pos) != 99999) {
  //         isLimitChanged = true
  //         tblProductTabletTempObj.Param7_T2Pos = Number(mesEntryRes.HardnessHigh);
  //       }
  //     }
  //   }

  //   // Thickness
  //   if ((Number(mesEntryRes.ThicknessLow) != 99999) && (Number(mesEntryRes.ThicknessHigh) != 99999) && productType == 1) {
  //     // Thickness Low
  //     if ((Number(productLimitRes.Param3_T2Neg) != Number(mesEntryRes.ThicknessLow))) {
  //       if (Number(productLimitRes.Param3_T2Neg) != 99999) {
  //         isLimitChanged = true
  //         tblProductTabletTempObj.Param3_T2Neg = Number(mesEntryRes.ThicknessLow);
  //       }
  //     }

  //     // Thickness High
  //     if ((Number(productLimitRes.Param3_T2Pos) != Number(mesEntryRes.ThicknessHigh))) {
  //       if (Number(productLimitRes.Param3_T2Pos) != 99999) {
  //         isLimitChanged = true
  //         tblProductTabletTempObj.Param3_T2Pos = Number(mesEntryRes.ThicknessHigh);
  //       }
  //     }
  //   }

  //   // Friability
  //   if (mesEntryRes.FriabilityRange != 99999) {
  //     // 1.04%
  //     if (productLimitRes.Param8_Nom != mesEntryRes.FriabilityRange) {
  //       isLimitChanged = true
  //       tblProductTabletTempObj.Param8_Nom = Number(mesEntryRes.FriabilityRange);
  //     }
  //   }


  //   // Friability
  //   // if ((Number(mesEntryRes.FriabilityLow) != 99999) && (Number(mesEntryRes.FriabilityHigh) != 99999) && productType == 1) {
  //   //   // Friability Low
  //   //   if ((Number(productLimitRes.Param8_T1Neg) != Number(mesEntryRes.FriabilityLow))) {
  //   //     if (Number(productLimitRes.Param8_T1Neg) != 99999) {
  //   //       isLimitChanged = true
  //   //       tblProductTabletTempObj.Param8_T1Neg = Number(mesEntryRes.FriabilityLow);
  //   //     }
  //   //   }

  //   //   // Friability High
  //   //   if ((Number(productLimitRes.Param8_T1Pos) != Number(mesEntryRes.FriabilityHigh))) {
  //   //     if (Number(productLimitRes.Param8_T1Pos) != 99999) {
  //   //       isLimitChanged = true
  //   //       tblProductTabletTempObj.Param8_T1Pos = Number(mesEntryRes.FriabilityHigh);
  //   //     }
  //   //   }
  //   // }

  //   // Disintegration
  //   // if (mesEntryRes.DisintegrationRange != 99999) {
  //   //   let range = "Param13_Nom"; // For tablet
  //   //   if (productType == 2) {
  //   //     range = "Param6_Nom"; // For capsule
  //   //   }

  //   //   if (mesEntryRes.DisintegrationRange != productLimitRes[range]) {
  //   //     if (productLimitRes[range] != "NA" && productLimitRes[range] != "NULL") {
  //   //       isLimitChanged = true
  //   //       tblProductTabletTempObj[range] = mesEntryRes.DisintegrationRange;
  //   //     }
  //   //   }
  //   // }

  //   /*
  //   if (Number(mesEntryRes.DisintegrationLow) != 99999 && (Number(mesEntryRes.DisintegrationHigh) != 99999) && productType == 1) {
  //     // Disintegration Low
  //     let posT1 = "Param13_T1Pos"; // For tablet
  //     let negT1 = "Param13_T1Neg"; // For tablet
  //     if (productType == 2) {
  //       posT1 = "Param6_T1Pos"; // For capsule
  //       negT1 = "Param6_T1Neg"; // For capsule
  //     }
  //     if ((Number(productLimitRes[negT1]) != Number(mesEntryRes.DisintegrationLow))) {
  //       if (Number(productLimitRes[negT1]) != 99999) {
  //         isLimitChanged = true
  //         tblProductTabletTempObj[negT1] = Number(mesEntryRes.DisintegrationLow);
  //       }
  //     }

  //     // Disintegration High
  //     if ((Number(productLimitRes[posT1]) != Number(mesEntryRes.DisintegrationHigh))) {
  //       if (Number(productLimitRes[posT1]) != 99999) {
  //         isLimitChanged = true
  //         tblProductTabletTempObj[posT1] = Number(mesEntryRes.DisintegrationHigh);
  //       }
  //     }
  //   }
  //   */

  //   // Length
  //   if (Number(mesEntryRes.LengthLow) != 99999 && (Number(mesEntryRes.LengthHigh) != 99999)) {
  //     // Length Low
  //     if ((Number(productLimitRes.Param5_T2Neg) != Number(mesEntryRes.LengthLow))) {
  //       if (Number(productLimitRes.Param5_T2Neg) != 99999) {
  //         isLimitChanged = true
  //         tblProductTabletTempObj.Param5_T2Neg = Number(mesEntryRes.LengthLow);
  //       }
  //     }

  //     // Length High
  //     if ((Number(productLimitRes.Param5_T2Pos) != Number(mesEntryRes.LengthHigh))) {
  //       if (Number(productLimitRes.Param5_T2Pos) != 99999) {
  //         isLimitChanged = true
  //         tblProductTabletTempObj.Param5_T2Pos = Number(mesEntryRes.LengthHigh);
  //       }
  //     }
  //   }

  //   // Locked Length
  //   if (Number(mesEntryRes.LockedLengthLow) != 99999 && (Number(mesEntryRes.LockedLengthHigh) != 99999)) {
  //     // Length Low
  //     if ((Number(productLimitRes.Param5_T2Neg) != Number(mesEntryRes.LockedLengthLow))) {
  //       if (Number(productLimitRes.Param5_T2Neg) != 99999) {
  //         isLimitChanged = true
  //         tblProductTabletTempObj.Param5_T2Neg = Number(mesEntryRes.LockedLengthLow);
  //       }
  //     }

  //     // Length High
  //     if ((Number(productLimitRes.Param5_T2Pos) != Number(mesEntryRes.LockedLengthHigh))) {
  //       if (Number(productLimitRes.Param5_T2Pos) != 99999) {
  //         isLimitChanged = true
  //         tblProductTabletTempObj.Param5_T2Pos = Number(mesEntryRes.LockedLengthHigh);
  //       }
  //     }
  //   }

  //   // Diameter
  //   if ((Number(mesEntryRes.DiameterLow) != 99999) && (Number(mesEntryRes.DiameterHigh) != 99999) && productType == 1) {
  //     // Diameter Low
  //     if ((Number(productLimitRes.Param4_T2Neg) != Number(mesEntryRes.DiameterLow))) {
  //       if (Number(productLimitRes.Param4_T2Neg) != 99999) {
  //         isLimitChanged = true
  //         tblProductTabletTempObj.Param4_T2Neg = Number(mesEntryRes.DiameterLow);
  //       }
  //     }

  //     // Diameter High
  //     if ((Number(productLimitRes.Param4_T2Pos) != Number(mesEntryRes.DiameterHigh))) {
  //       if (Number(productLimitRes.Param4_T2Pos) != 99999) {
  //         isLimitChanged = true
  //         tblProductTabletTempObj.Param4_T2Pos = Number(mesEntryRes.DiameterHigh);
  //       }
  //     }
  //   }

  //   // LOD
  //   // if (Number(mesEntryRes.InitialWeight) != 99999 && (Number(mesEntryRes.FinalWeight) != 99999)) {
  //   //   // LOD Low
  //   //   if ((Number(productLimitRes.Param16_T1Neg) != Number(mesEntryRes.InitialWeight))) {
  //   //     if (Number(productLimitRes.Param16_T1Neg) != 99999) {
  //   //       isLimitChanged = true
  //   //       oldValueComp += `Group - Lower Limit: ${productLimitRes.Param16_T1Neg},`
  //   //     } else {
  //   //       if (oldValueComp == 'NA' || oldValueComp == '') {
  //   //         oldValueComp = 'NA';
  //   //       }
  //   //     }
  //   //     newValueComp += `Group - Lower Limit: ${mesEntryRes.InitialWeight},`
  //   //   }

  //   //   // LOD High
  //   //   if ((Number(productLimitRes.Param16_T1Pos) != Number(mesEntryRes.FinalWeight))) {
  //   //     if (Number(productLimitRes.Param16_T1Pos) != 99999) {
  //   //       isLimitChanged = true
  //   //       oldValueComp += `Upper Limit: ${productLimitRes.Param16_T1Pos},`
  //   //     } else {
  //   //       if (oldValueComp == 'NA' || oldValueComp == '') {
  //   //         oldValueComp = 'NA';
  //   //       }
  //   //     }
  //   //     newValueComp += `Upper Limit: ${mesEntryRes.FinalWeight},`
  //   //   }
  //   // }

  //   let tempTable = "tbl_product_tablet_temp"
  //   if (productType == 2) {
  //     tempTable = "tbl_product_capsule_temp"
  //   }

  //   if (isLimitChanged) {
  //     console.log("Product limits has been changed. Limits received from MES");
  //     tblProductTabletTempObj.Remark = ""
  //     await models[tempTable].update(tblProductTabletTempObj, {
  //       where: {
  //         // ProductId: productLimitRes.ProductId,
  //         // ProductName: productLimitRes.ProductName
  //         MPN_Code: productLimitRes.MPN_Code
  //       }
  //     })
  //   }

  //   return isLimitChanged;
  // }

  // async checkProductLimits(productLimitRes, mesEntryRes) {
  //   let isLimitChanged = false
  //   // Individual
  //   if ((Number(productLimitRes.Param1_T2Neg) != Number(mesEntryRes.IndWtLow)) && (Number(productLimitRes.Param1_T2Neg) != 99999) || (Number(productLimitRes.Param1_T2Pos) != Number(mesEntryRes.IndWtHigh)) && (Number(productLimitRes.Param1_T2Pos) != 99999)) {
  //     isLimitChanged = true
  //   }
  //   // Group
  //   else if ((Number(productLimitRes.Param2_T2Neg) != Number(mesEntryRes.GrpWtLow)) && (Number(productLimitRes.Param2_T2Neg) != 99999) || (Number(productLimitRes.Param2_T2Pos) != Number(mesEntryRes.GrpWtHigh)) && (Number(productLimitRes.Param2_T2Pos) != 99999)) {
  //     isLimitChanged = true
  //   }
  //   // Thickness
  //   else if ((Number(productLimitRes.Param3_T2Neg) != Number(mesEntryRes.ThicknessLow)) && (Number(productLimitRes.Param3_T2Neg) != 99999) || (Number(productLimitRes.Param3_T2Pos) != Number(mesEntryRes.ThicknessHigh)) && (Number(productLimitRes.Param3_T2Pos) != 99999)) {
  //     isLimitChanged = true
  //   }
  //   // Diameter
  //   else if ((Number(productLimitRes.Param6_T2Neg) != Number(mesEntryRes.HardDiameterLow)) && (Number(productLimitRes.Param6_T2Neg) != 99999) || (Number(productLimitRes.Param6_T2Pos) != Number(mesEntryRes.HardDiameterHigh)) && (Number(productLimitRes.Param6_T2Pos) != 99999)) {
  //     isLimitChanged = true
  //   }
  //   // Length
  //   else if ((Number(productLimitRes.Param5_T2Neg) != Number(mesEntryRes.HardLengthLow)) && (Number(productLimitRes.Param5_T2Neg) != 99999) || (Number(productLimitRes.Param5_T2Pos) != Number(mesEntryRes.HardLengthHigh)) && (Number(productLimitRes.Param5_T2Pos) != 99999)) {
  //     isLimitChanged = true
  //   }
  //   // Hardness
  //   else if ((Number(productLimitRes.Param7_T2Neg) != Number(mesEntryRes.HardnessLow)) && (Number(productLimitRes.Param7_T2Neg) != 99999) || (Number(productLimitRes.Param7_T2Pos) != Number(mesEntryRes.HardnessHigh)) && (Number(productLimitRes.Param7_T2Pos) != 99999)) {
  //     isLimitChanged = true
  //   }
  //   // LOD
  //   else if ((Number(productLimitRes.Param16_T1Neg) != Number(mesEntryRes.InitialWeight)) && (Number(productLimitRes.Param16_T1Neg) != 99999) || (Number(productLimitRes.FinalWeight) != Number(mesEntryRes.FinalWeight)) && (Number(productLimitRes.Param16_T1Pos) != 99999)) {
  //     isLimitChanged = true
  //   }

  //   return isLimitChanged
  // }

  // async updateProductLimits(productMasterRes, mesEntryRes) {
  //   // console.log('mesEntryRes: ', mesEntryRes);

  //   try {
  //     await models.tbl_product_tablet.update(
  //       {
  //         // Individual
  //         Param1_T2Neg: Number(mesEntryRes.IndWtLow) != 99999 ? Number(mesEntryRes.IndWtLow) : 99999,
  //         Param1_T2Pos: Number(mesEntryRes.IndWtHigh) != 99999 ? Number(mesEntryRes.IndWtHigh) : 99999,
  //         Param1_Unit: mesEntryRes.IndUnit,
  //         // Group
  //         Param2_T2Neg: Number(mesEntryRes.GrpWtLow) != 99999 ? Number(mesEntryRes.GrpWtLow) : 99999,
  //         Param2_T2Pos: Number(mesEntryRes.GrpWtHigh) != 99999 ? Number(mesEntryRes.GrpWtHigh) : 99999,
  //         Param2_Unit: mesEntryRes.GrpUnit,
  //         // Thickness
  //         Param3_T2Neg: Number(mesEntryRes.ThicknessLow) != 99999 ? Number(mesEntryRes.ThicknessLow) : 99999,
  //         Param3_T2Pos: Number(mesEntryRes.ThicknessHigh) != 99999 ? Number(mesEntryRes.ThicknessHigh) : 99999,
  //         Param3_Unit: mesEntryRes.ThicknessUnit,
  //         // Diameter
  //         Param6_T2Pos: Number(mesEntryRes.DiameterLow) != 99999 ? Number(mesEntryRes.DiameterLow) : 99999,
  //         Param6_T2Neg: Number(mesEntryRes.DiameterHigh) != 99999 ? Number(mesEntryRes.DiameterHigh) : 99999,
  //         Param6_Unit: mesEntryRes.DiameterUnit,
  //         // Length
  //         Param5_T2Neg: Number(mesEntryRes.LengthLow) != 99999 ? Number(mesEntryRes.LengthLow) : 99999,
  //         Param5_T2Pos: Number(mesEntryRes.LengthHigh) != 99999 ? Number(mesEntryRes.LengthHigh) : 99999,
  //         Param5_Unit: mesEntryRes.LengthUnit,
  //         // Hardness
  //         Param7_T2Neg: Number(mesEntryRes.HardnessLow) != 99999 ? Number(mesEntryRes.HardnessLow) : 99999,
  //         Param7_T2Pos: Number(mesEntryRes.HardnessHigh) != 99999 ? Number(mesEntryRes.HardnessHigh) : 99999,
  //         Param7_Unit: mesEntryRes.HardUnit,
  //         // Friability
  //         Param8_T1Neg: Number(mesEntryRes.FriabilityLow) != 99999 ? Number(mesEntryRes.FriabilityLow) : 99999,
  //         Param8_T1Pos: Number(mesEntryRes.FriabilityHigh) != 99999 ? Number(mesEntryRes.FriabilityHigh) : 99999,
  //         Param8_Unit: mesEntryRes.FriabUnit,
  //         // DT
  //         Param13_T1Neg: Number(mesEntryRes.DisintegrationLow) != 99999 ? Number(mesEntryRes.DisintegrationLow) : 99999,
  //         Param13_T1Pos: Number(mesEntryRes.DisintegrationHigh) != 99999 ? Number(mesEntryRes.DisintegrationHigh) : 99999,
  //         // LOD
  //         // Param16_T1Neg: Number(mesEntryRes.InitialWeight) != 99999 ? Number(mesEntryRes.InitialWeight) : 99999,
  //         // Param16_T1Pos: Number(mesEntryRes.FinalWeight) != 99999 ? Number(mesEntryRes.FinalWeight) : 99999,
  //         // Param16_Unit: "",
  //       }, {
  //       where: {
  //         [Op.or]: [
  //           { ProductId: productMasterRes.ProductId },
  //           // { MPN_Code: productMasterRes.MPN_Code }
  //         ],
  //         ProductName: productMasterRes.ProductName,
  //       }
  //     });
  //   } catch (error) {
  //     console.log('error: ', error);
  //   }
  // }

  // async updateCubical(DSNumber, mesEntryRes, obj) {
  //   try {
  //     let dbObj = null;
  //     let productData = await models.tbl_product_tablet.findOne({
  //       where: {
  //         MPN_Code: mesEntryRes.MPN,
  //         // SFOID: mesEntryRes.SFOID
  //       }
  //     })

  //     if (obj?.LTID) {
  //       dbObj = {
  //         Sys_Batch: mesEntryRes.BatchID,
  //         Sys_RptType: 0,
  //         Sys_SFOID: mesEntryRes.SFOID,
  //         Sys_MPNCode: mesEntryRes.MPN,
  //         Sys_Batch_Status: mesEntryRes.TestType,
  //         isManual: false,
  //         MesTestType: mesEntryRes.MesTestType,
  //         MesSide: mesEntryRes.MesSide,
  //         // Sys_BFGCode: productData.ProductId,
  //         Sys_ProductName: productData?.ProductName??'NA'
  //       }
  //     } else if (obj?.MAID) {
  //       dbObj = {
  //         Sys_Batch: mesEntryRes.BatchID,
  //         Sys_Repetition: mesEntryRes.Repetition,
  //         Sys_SFOID: mesEntryRes.SFOID,
  //         Sys_MPNCode: mesEntryRes.MPN,
  //         isManual: false,
  //         MesTestType: mesEntryRes.MesTestType,
  //         MesSide: mesEntryRes.MesSide,
  //         // Sys_BFGCode: productData.ProductId,
  //             Sys_ProductName: productData?.ProductName??'NA'
  //       }
  //     } else {
  //       dbObj = {
  //         Sys_Batch: mesEntryRes.BatchID,
  //         // Sys_BFGCode: mesEntryRes.ProductId,
  //         // Sys_ProductName: mesEntryRes.ProductName,
  //         Sys_RptType: mesEntryRes.TestType,
  //         Sys_SFOID: mesEntryRes.SFOID,
  //         Sys_Repetition: mesEntryRes.Repetition,
  //         Sys_RotaryType: mesEntryRes.Side,
  //         Sys_MPNCode: mesEntryRes.MPN,
  //         isManual: false,
  //         MesTestType: mesEntryRes.MesTestType,
  //         MesSide: mesEntryRes.MesSide,
  //         Sys_BFGCode: productData.ProductId,
  //         Sys_ProductName: productData.ProductName
  //       }
  //     }

  //     await models.tbl_cubical.update(
  //       dbObj,
  //       {
  //         where: {
  //           Sys_DSNumber: DSNumber,
  //         },
  //       }
  //     );
  //   } catch (error) {
  //     console.log('error: ', error);
  //   }
  // }

  // async updateSampleNo(cubicNo, mesEntryRes) {
  //   try {
  //     let individualSampleCount = (mesEntryRes.GroupSampleCount) ? mesEntryRes.GroupSampleCount : 0;
  //     let commonSampleCount = (mesEntryRes.StartSampleCount) ? mesEntryRes.StartSampleCount : 0;

  //     // if (mesEntryRes.TestType == 0) {
  //     //   commonSampleCount = mesEntryRes.SampleCount;
  //     // } else {
  //     //   commonSampleCount = mesEntryRes.StartSampleCount;
  //     //   grpSampleCount = mesEntryRes.GroupSampleCount;
  //     // }

  //     // await models.tbl_cubicle_product_sample.update({
  //     //   Individual: commonSampleCount,
  //     //   Group: (mesEntryRes.TestType == 0) ? commonSampleCount : grpSampleCount,
  //     //   Hardness: commonSampleCount,
  //     //   Thickness: commonSampleCount,
  //     //   Diameter: commonSampleCount,
  //     //   Length: commonSampleCount,
  //     //   Friability: commonSampleCount,
  //     //   DT: commonSampleCount,
  //     // }, {
  //     //   where: {
  //     //     Sys_CubicNo: cubicNo,
  //     //   }
  //     // });


  //     // if (mesEntryRes.TestType == 0) {
  //     //   commonSampleCount = mesEntryRes.SampleCount;
  //     // } else {
  //     //   commonSampleCount = mesEntryRes.StartSampleCount;
  //     //   grpSampleCount = mesEntryRes.GroupSampleCount;
  //     // }

  //     await models.tbl_cubicle_product_sample.update({
  //       Individual: individualSampleCount,
  //       Group: commonSampleCount,
  //       Hardness: commonSampleCount,
  //       Thickness: commonSampleCount,
  //       Diameter: commonSampleCount,
  //       Length: commonSampleCount,
  //       Friability: 'NLT 6.5 g',
  //       DT: 6,
  //     }, {
  //       where: {
  //         Sys_CubicNo: cubicNo,
  //       }
  //     });
  //   } catch (error) {
  //     console.log('error: ', error);

  //   }
  // }

  async acknowledge(req) {

  }
  async ackReceive(req) {
    try {
      var mid = req.mid
      globalData.generatedToken = []
      // req.msiinterfacedescription.parameter.forEach(param => {
      //   switch (param.name[0].toLowerCase()) {
      //     case "mid":
      //       mid = param.value[0]
      //       break;
      //   }
      // })
      console.log("MID Received", mid)

      console.log(globalData.MESArray)
      var mesData = globalData.MESArray.find(k => k.isPosted === true && k.isCompleted === true && k.mid === mid);

      console.log(mesData);

      if (ackMode === true && mesData) {
        // const rootres = create()
        // .ele("MsiOrderParameterMessageResponse", { "xmlns:xsi": `http://www.w3.org/2001/XMLSchema-instance`, 'xmlns:xsd': `http://www.w3.org/2001/XMLSchema` })
        // .ele("messageInstanceId").txt(crypto.randomUUID()).up()
        // .ele("messageContext").txt("5203998621").up()
        // .ele("message")
        // .ele("MsiOrderParameterMessageResponse")
        // .ele("creationTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up().up().up()
        // let xmlres = rootres.end({ prettyPrint: true });

        globalData.generatedToken.push(mesData.mid)
        await models.tbl_mes_data.destroy({ where: { DS_Number: mesData.DsNo, isSetInCubical: 1 } });
        if (mesData.RepSerNo && mesData.Area == "Coating") {
          let updts = await models.tbl_tab_master2.update({
            ackReceive: 1,
            ismid: mid
          }, {
            where: {
              RepSerNo: mesData.RepSerNo,
              // BatchNo: mesData.BatchId
            }
          })
        } else if ((mesData.RepSerNo && mesData.Area == "Granulation") || (mesData.RepSerNo && mesData.Area == "IPQA Granulation")) {
          let updts = await models.tbl_lodmaster.update({
            ackReceive: 1,
            ismid: mid
          }, {
            where: {
              RepSerNo: mesData.RepSerNo,
              // BatchNo: mesData.BatchId
            }
          })
        } else if (mesData.RepSerNo && mesData.Area == "IPQA Packing") {
          let updts = await models.tbl_leakedtest_master.update({
            ackReceive: 1,
            ismid: mid
          }, {
            where: {
              RepSerNo: mesData.RepSerNo,
              // BatchNo: mesData.BatchId
            }
          })
        } else if (mesData.RepSerNo) {
          let updts = await models.tbl_tab_initialmaster.update({
            ackReceive: 1,
            ismid: mid
          }, {
            where: {
              RepSerNo: mesData.RepSerNo,
              // BatchNo: mesData.BatchId
            }
          })
        }

        if (!mesData.isManualPosting) {
          mqttSender.sendData(mesData.DsNo, `Port ${mesData.portNo}:${GLOBAL_NOMENCLATURE.DisplayMessage} ${GLOBAL_NOMENCLATURE.MESDataPosted}`);
        }
        globalData.MESArray.splice(globalData.MESArray.findIndex(k => k.isPosted == true && k.isCompleted == true && k.DsNo == mesData.DsNo && k.mid == mid && k.TabIp == mesData.TabIp), 1)

        console.log(globalData.MESArray);
        // return xml
        // return xmlres
        return {}
      }


    } catch (err) {
      console.log(err)
    }
  }



  async generateToken(req) {

    const { username, password } = req;

    let user = "werumsez"
    let tokenID = oAuth2.sign({ username }, password, { expiresIn: '1h', algorithm: 'none' });

    // Send the token, token_type, and expiry time in the response
    var expiresIn = new Date();
    expiresIn.setHours(expiresIn.getHours() + 1);
    expiresIn = Date.parse(expiresIn) / 1000

    if (globalData.generatedToken.length != 0) {
      globalData.generatedToken.splice(0, 1, tokenID)
    } else {
      globalData.generatedToken.push(tokenID)
    }

    console.log("token generated", username)

    return ({
      access_token: tokenID,
      token_type: 'Bearer',
      expires_in: expiresIn,
    });

  }

  async postFail(req) {
    try {
      let responseObj = {};
      globalData.MESArray.splice(globalData.MESArray.findIndex(k => k.isPosted == false && k.isCompleted == true && k.DsNo == req.dsNo && k.menuName == req.menuName && k.TabIp == req.TabIp), 1)
      console.log(globalData.MESArray)
      await models.tbl_menu_sequence.destroy({ where: { DS_Number: req.dsNo } });
      await models.tbl_mes_data.destroy({ where: { DS_Number: req.dsNo, isSetInCubical: 1 } });
      Object.assign(responseObj, {
        status: 'fail',
        message: 'Data not posted to MES'
      })
      return responseObj
    } catch (error) {
      console.log(error)
    }
  }

  async postToMES(data) {
    try {
      var repSerNo = data.RepSerNo;
      var reportType = data.ReportOption;
      var status = data.Status
      if (status == 'Success') return GLOBAL_NOMENCLATURE.MESDataPosted

      let payloadObj = {}


      if (reportType == "LOD") {

        var dbData = await models.tbl_lodmaster.findAll({
          where: {
            RepSerNo: repSerNo
          }
        })

        dbData = dbData[0]

        var tableData = {}
        tableData['SNR'] = dbData['SerialNo']
        tableData['Drying Temp'] = dbData['Temp']
        tableData["Product Name"] = dbData['ProductName']
        tableData["Measurement end"] = momentObj(dbData['PrEndDate']).format('DD.MM.YYYY') + ' ' + momentObj(dbData['PrEndTime']).format('HH:mm')
        tableData["Switch Off"] = dbData['SwitchOff']
        tableData["Drying Prog"] = dbData['DryingProgram']
        tableData["Start Weight"] = dbData['InitalWt']
        tableData["Dry Weight"] = dbData['FinalWt']
        tableData["Total time"] = dbData['Duration']
        tableData["End Result"] = dbData['NetWt']

        var lodData__ = {
          payload: [{ data: { value: tableData, isMesChecked: false } }],
          DsNo: dbData.DsNo,
          TabIp: dbData.TabIp,
          selectedDSNo: dbData.DsNo,
          // portNo: 1,
          RptType: dbData.ReportType,
          isCompleted: true,
          isPosted: false,
          mqttProtocol: null,
          batchId: dbData.BatchNo,
          Repetition: dbData.Repetition,
          instrumentId: dbData.LODID,
          sfoId: dbData.SFOID,
          RepSerNo: repSerNo,
          Mpn: dbData.MPN_Code,
          menuName: "Loss on Dry",
          Area: dbData.Area
        }
        console.log({ apipostmessage: globalData.MESArray.push(lodData__) })
        return GLOBAL_NOMENCLATURE.MESDataPosted
      } else if (reportType == "Vacuum Leak Test") {
        var dbData = await models.tbl_leakedtest_master.findAll({
          where: {
            RepSerNo: repSerNo
          }
        })

        dbData = dbData[0]

        let data = {
          menuName: GLOBAL_NOMENCLATURE.LeakTestMenu,
          payload: { data: dbData },
          DsNo: dbData.DsNo,
          tabIp: dbData.TabIp,
          // portNo: 1,
          isCompleted: true,
          isPosted: false,
          RepSerNo: repSerNo
        }
        globalData.MESArray.push(data)
        return GLOBAL_NOMENCLATURE.MESDataPosted
      }

      if (data.Area == 'Coating') {
        let master2 = await models.tbl_tab_master2.findOne({
          where: {
            RepSerNo: repSerNo
          }
        })

        if (master2) {
          let obj = {}
          obj.Area = master2.Area;
          obj.batchId = master2.BatchNo;
          obj.DsNo = master2.Idsno;
          obj.isPosted = false;
          obj.menuName = reportType;
          obj.isCompleted = true;
          obj.RepSerNo = data.RepSerNo;
          obj.avg = master2.avgwt2

          let detail2 = await models.tbl_tab_detail2.findOne({
            where: {
              RepSerNo: repSerNo
            }
          })

          let payload = [];
          let value
          for (let i = 0; i < 3; i++) {
            if (i == 0 && !isNaN(detail2.DataValue)) {
              value = detail2[`DataValue`]
              payload.push({ data: { value: value, isMesChecked: false } });
            } else if (!isNaN(detail2[`DataValue${i}`])) {
              payload.push({ data: { value: detail2[`DataValue${i}`], isMesChecked: false } });
            }

          }
          obj.payload = payload;
          console.log(obj);
          console.log({ 'globalData.MESArray': globalData.MESArray.push(obj) })
          return GLOBAL_NOMENCLATURE.MESDataPosted

        }
      }


      let MasterTable = data.Area == 'Capsule Filling' ? 'tbl_cap_initialmaster' : 'tbl_tab_initialmaster'
      var masterData = await models[MasterTable].findAll({
        where: {
          RepSerNo: repSerNo
        }
      })

      var messageId = "Compression_IPQC_Receive_BO"

      var mesData = masterData[0]
      globalData.MESArray.splice(globalData.MESArray.findIndex(k => k.DsNo == mesData.DsNo && k.RepSerNo == mesData.RepSerNo), 1)
      if (mesData.BalanceId && mesData.BalanceId !== 'None' && mesData.BalanceId !== 'NULL') {
        var balanceInfo = await models.tbl_balance.findAll({
          where: {
            Bal_ID: mesData.BalanceId
          }
        })
      }
      if (mesData.HardnessID && mesData.HardnessID !== 'None' && mesData.HardnessID !== "NULL") {
        var hardnessInfo = await models.tbl_otherequipment.findAll({
          where: {
            Eqp_ID: mesData.HardnessID,
            Eqp_Type: GLOBAL_NOMENCLATURE.Hardness
          }
        })
      }

      let bal = 0, hrd = 0, dt = 0, multitester = false, VER = 0
      bal = (!clsCommonInsertOperationObj.isNullOrStringNull(mesData.BalanceId)) ? 1 : 0;
      hrd = (!clsCommonInsertOperationObj.isNullOrStringNull(mesData.HardnessID)) ? 1 : 0;
      dt = (!clsCommonInsertOperationObj.isNullOrStringNull(mesData.DTID)) ? 1 : 0;
      VER = (!clsCommonInsertOperationObj.isNullOrStringNull(mesData.VernierId)) ? 1 : 0;

      let eqpModel;
      if (hrd == 1) {
        let data_eqp = await models.tbl_otherequipment.findAll({
          where: {
            Eqp_ID: mesData.HardnessID
          }
        })
        eqpModel = data_eqp[0].Eqp_Make;
        if (eqpModel == 'Pharmatest') { multitester = true }
      }

      var menuSequenceTable = {
        "IND": multitester ? hrd : bal,
        "GRP": bal,
        "EGRP": bal,
        "HARD": hrd,
        "FRIAB": bal,
        "DT": dt,
        "LEN": VER,
        "NET": bal,
        "RepSerNo": repSerNo

      }
      if (mesData.ProductType == 1) {
        delete menuSequenceTable.EGRP;
        delete menuSequenceTable.LEN;
        delete menuSequenceTable.NET;
      }
      if (mesData.ProductType == 2) {
        delete menuSequenceTable.FRIAB;
        delete menuSequenceTable.HARD;
      }
      // let data_ = { menuName: strMenuName, RptType: cubicalObj.Sys_RptType, payload: { data: [{ value: finalactualWt, isMesChecked: false }] }, DsNo: strDsNo, TabIp: strTabIp, selectedDSNo: selectedDSNo, portNo: ProtocolPortNo, isCompleted: true, isPosted: false, batchId: cubicalObj.Sys_Batch, sfoId: SFOID, mqttProtocol: cubicalObj.Sys_RotaryType == 'Double' && side == 'LHS' ? `Port ${ProtocolPortNo}:${GLOBAL_NOMENCLATURE.DisplayMessage}Side Changes to RHS` : null }
      // globalData.MESArray.push(data_)

      for (let keys in menuSequenceTable) {
        let testInfo;
        let friabUnit;
        // let eqpModel;
        if (menuSequenceTable[keys] == 1) {
          let menuName = objCommonWeightment.getMenuNmFromMenuSeq(keys);
          let getTableName = this.getTableName(mesData, menuName)
          // let detailTableIncomplete = getTableName.detailTable
          let detailTable = getTableName.detailTable;
          // if (menuName != GLOBAL_NOMENCLATURE.Friability) {
          // var detailIncompData = await models[detailTableIncomplete].findOne({ attributes: { exclude: ["RepSerNo", "RecNo", "isException", "Remark"] } })
          // detailIncompData = Object.keys(detailIncompData).toString();

          // var str_Query = `INSERT INTO ${detailTable} (${detailIncompData}) OUTPUT inserted.RecNo SELECT ${detailIncompData} FROM ${detailTableIncomplete} where RepSerNo = ${repSerNo} AND isException = 0`
          // let result = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

          var detailMasterData = [mesData]
          let masterData = mesData;
          let menuNotInclude = [GLOBAL_NOMENCLATURE.Hardness, GLOBAL_NOMENCLATURE.DTMenu, GLOBAL_NOMENCLATURE.Friability]
          if (!menuNotInclude.includes(menuName)) {
            var detailIncompData = await models[detailTable].findAll({ attributes: [['DataValue', 'value']], where: { RepSerNo: repSerNo } })
          }
          let multiTesterUnit;

          if (menuName == GLOBAL_NOMENCLATURE.GroupMenu) {
            let data_ = { menuName: menuName, RptType: mesData.ReportType, payload: { data: [{ value: detailIncompData.length == 0 ? 'NA' : detailIncompData, isMesChecked: false }] }, DsNo: mesData.DsNo, TabIp: mesData.TabIp, selectedDSNo: mesData.TabIp, portNo: 'NA', isCompleted: true, isPosted: false, batchId: mesData.BatchNo, sfoId: mesData.SFOID, mqttProtocol: null }
            // globalData.MESArray.push(data_)

          }

          // if (menuName == GLOBAL_NOMENCLATURE.Hardness) {
          //   let data_eqp = await models.tbl_otherequipment.findAll({
          //     where: {
          //       Eqp_ID: mesData.HardnessID
          //     }
          //   })
          //   eqpModel = data_eqp[0].Eqp_Make
          // }
          // if (eqpModel == 'Pharmatest' && menuName == GLOBAL_NOMENCLATURE.Hardness) {
          //   payloadObj = await this.handleMultiTesterData(mesData, menuName, payloadObj, repSerNo, masterData)
          //   multiTesterUnit = payloadObj.MultiTesterHardness.TestInfo.Unit
          // }

          let menuNotIncludeCalcArr = [GLOBAL_NOMENCLATURE.DTMenu, GLOBAL_NOMENCLATURE.Friability]
          let typeValue = (getTableName.typeValue == 'htd') ? 7 : getTableName.typeValue;
          let getLimitsObj = this.getLimitsObj(typeValue, mesData.ReportType);
          if (!menuNotIncludeCalcArr.includes(menuName)) {
            let unit = masterData[getLimitsObj.Unit]
            testInfo = {
              unit: (masterData[getLimitsObj.Unit]) ? masterData[getLimitsObj.Unit] : '',
              averageWeight: `${masterData[getLimitsObj.AvgWeight]} ${unit}`,
              maxWeight: `${masterData[getLimitsObj.MaxWeight]} ${unit}`,
              minWeight: `${masterData[getLimitsObj.MinWeight]} ${unit}`,
              stdWeight: `${masterData[getLimitsObj.StdDev]} ${unit}`,
              rstdWeight: `${masterData[getLimitsObj.RStdDev]} ${unit}`,
              totalweight: `${masterData[getLimitsObj.TotalWeight]} ${unit}`,
            }
            if (menuName == GLOBAL_NOMENCLATURE.Hardness) {
              testInfo.stdWeight = `${masterData[getLimitsObj.StdDev]} ${'%'}`;
              let hardranges = masterData[getLimitsObj.MaxWeight] - masterData[getLimitsObj.MinWeight]
              testInfo.hardrange = `${Number(hardranges).toFixed(2)} ${unit}`

            }

            if (menuName == GLOBAL_NOMENCLATURE.IndividualMenu || menuName == GLOBAL_NOMENCLATURE.Differential) {
              let indDifference = masterData[getLimitsObj.MaxWeight] - masterData[getLimitsObj.MinWeight]
              indDifference = Number(indDifference).toFixed(3)
              testInfo.indDifference = `${indDifference} ${unit}`
            }
            if (menuName == GLOBAL_NOMENCLATURE.IndividualMenu) {
              if (detailIncompData.length > 0) {
                let unit = clsCommonInsertOperationObj.isNullOrStringNull(testInfo.unit);
                if (!unit) {
                  detailIncompData = detailIncompData.map(e => ({
                    ...e,
                    value: `${e.value} ${testInfo.unit}`
                  }))
                }
                detailIncompData = detailIncompData.map(e => ({ data: { ...e, isMesChecked: false } }))
                payloadObj.TestInfo = testInfo
              }
              let data_ = { menuName: menuName, RptType: mesData.ReportType, payload: { data: [{ value: detailIncompData, isMesChecked: false }] }, DsNo: mesData.DsNo, TabIp: mesData.TabIp, selectedDSNo: mesData.TabIp, portNo: 'NA', isCompleted: true, isPosted: false, batchId: mesData.BatchNo, sfoId: mesData.SFOID, mqttProtocol: null }
              // globalData.MESArray.push(data_)

            }

            if (menuName == GLOBAL_NOMENCLATURE.Hardness) {
              let getLimitsObj = this.getLimitsObj(3, mesData.ReportType);
              testInfo.unitThick = (masterData[getLimitsObj.Unit]) ? masterData[getLimitsObj.Unit] : '';
              testInfo.averageWeightThick = `${masterData[getLimitsObj.AvgWeight]} ${testInfo.unitThick}`
              testInfo.maxWeightThick = `${masterData[getLimitsObj.MaxWeight]} ${testInfo.unitThick}`
              testInfo.minWeightThick = `${masterData[getLimitsObj.MinWeight]} ${testInfo.unitThick}`
              testInfo.stdWeightThick = `${masterData[getLimitsObj.StdDev]} ${testInfo.unitThick}`
              testInfo.rstdWeightThick = `${masterData[getLimitsObj.RStdDev]} ${testInfo.unitThick}`
              testInfo.totalweightThick = `${masterData[getLimitsObj.TotalWeight]} ${testInfo.unitThick}`
              let thirange = masterData[getLimitsObj.MaxWeight] - masterData[getLimitsObj.MinWeight]
              testInfo.Thickrange = `${Number(thirange).toFixed(2)} ${testInfo.unitThick}`
            }
          } else {
            // let getLimitsObj = objCommonWeightment.getLimitsObj(typeValue, cubicObj.Sys_RptType);
            friabUnit = masterData[getLimitsObj.Unit]
            // friabUnit = 'gm';
          }

          // var exceptionData = await models[detailTableIncomplete].findAll({ where: { RepSerNo: repSerNo, isException: 1 } })
          // if (exceptionData.length > 0) {
          //   let exceptionResult = await objWeighmentDataTransfer.moveToExceptionTable(masterRepNo, menuName, detailMasterData[0], exceptionData, cubicObj.Sys_RptType)
          // }

          // if (result[0].length > 0) {
          //   let recNoArr = result[0].map(e => e.RecNo)
          //   await models[detailTable].update({ RepSerNo: masterRepNo }, { where: { RecNo: { [Op.in]: recNoArr } }, RepSerNo: masterRepNo })
          //   await models[detailTableIncomplete].destroy({ where: { RepSerNo: repSerNo } })
          // }
          // }

          // // In Group, we don't store data in detail incomplete table
          // if (menuName == GLOBAL_NOMENCLATURE.GroupMenu) {
          //   // await models[detailTable].update({ RepSerNo: masterRepNo }, { where: { RepSerNo: repSerNo } })
          //   await models.tbl_exception_sample_initial.update({ RepSerNo: masterRepNo }, { where: { RepSerNo: repSerNo, MenuName: menuName } })
          // }

          // if (menuName == GLOBAL_NOMENCLATURE.Hardness) {
          //   await models.tbl_exception_samplehtd_initial.update({ RepSerNo: masterRepNo }, { where: { RepSerNo: repSerNo } })
          // }

          if (mesData != undefined) {
            let menuObj = {};
            let attributes;
            switch (menuName) {
              case GLOBAL_NOMENCLATURE.Hardness:
                attributes = [['DataValueHard', 'H'], ['DataValueThick', 'T'], ['DataValueDiam', 'D'], ['DataValueBL', 'BL']]
                break;

              case GLOBAL_NOMENCLATURE.Friability:
                attributes = ['NetValue', 'BeforeValue', 'AfterValue']
                break;

              default:
                attributes = [['DataValue', 'value']];
                break;
            }

            // let attributes = menuName == 'Hardness' ? ['DataValueHard', 'DataValueThick', 'DataValueDiam', 'DataValueBL'] : [['DataValue', 'value']];
            let actualWtData = await models[detailTable].findAll({ attributes: attributes, where: { RepSerNo: repSerNo } })
            if (actualWtData.length > 0) {
              // Appending Unit According to Menu
              if (testInfo) {
                let isUnitValid = clsCommonInsertOperationObj.isNullOrStringNull(testInfo.unit);
                if (menuName == GLOBAL_NOMENCLATURE.Hardness) {
                  if (!isUnitValid) {
                    actualWtData = actualWtData.map(e => ({
                      ...e,
                      H: (testInfo.unit) ? `${e.H} ${testInfo.unit}` : `${e.H}`,
                      T: (testInfo.unitThick) ? `${e.T} ${testInfo.unitThick}` : `${e.T}`,
                      BL: (multiTesterUnit) ? `${e?.BL} ${multiTesterUnit} ` : `${e?.BL}`
                    }))
                  }
                }
                if (menuName != GLOBAL_NOMENCLATURE.Hardness) {
                  if (!isUnitValid) {
                    actualWtData = actualWtData.map(e => ({
                      ...e,
                      value: `${e.value} ${testInfo.unit}`
                    }))
                  }
                }
              }

              if (menuName == GLOBAL_NOMENCLATURE.Friability) {
                actualWtData = actualWtData.map(e => ({
                  ...e,
                  NetValue: (friabUnit) ? `${e.NetValue} % ` : `${e.NetValue} %`,
                  BeforeValue: (friabUnit) ? `${e.BeforeValue} ${friabUnit}` : `${e.BeforeValue}`,
                  AfterValue: (friabUnit) ? `${e.AfterValue} ${friabUnit}` : `${e.AfterValue}`,
                }))
              }
              if (menuName != GLOBAL_NOMENCLATURE.Hardness) {
                actualWtData = actualWtData.map(e => ({ data: { ...e, isMesChecked: false } }))
              }
              if (testInfo) {
                menuObj[menuName] = { 'TestData': actualWtData }
                menuObj[menuName].TestInfo = testInfo
              } else {
                menuObj[menuName] = actualWtData
              }
              payloadObj = Object.assign(payloadObj, menuObj)
            }
          }
        }
      }

      // Update IsPosted to 0 if any Exception has been posted before
      await models.tbl_exception_sample_initial.update({ IsPosted: 0 }, { where: { RepSerNo: repSerNo, isTerminated: 0 } })
      await models.tbl_exception_samplehtd_initial.update({ IsPosted: 0 }, { where: { RepSerNo: repSerNo, isTerminated: 0 } })

      let data__ = {
        payload: payloadObj,
        DsNo: mesData.DsNo,
        TabIp: mesData.TabIp,
        selectedDSNo: mesData.DsNo,
        // portNo: 'NA',
        RptType: mesData.ReportType,
        isCompleted: true,
        isPosted: false,
        mqttProtocol: null,
        batchId: mesData.BatchNo,
        sfoId: mesData.SFOID,
        RepSerNo: repSerNo,
        Area: mesData.Area
      }
      console.log({ apipostmessage: globalData.MESArray.push(data__) })
      return GLOBAL_NOMENCLATURE.MESDataPosted
      // if (req.payload[GLOBAL_NOMENCLATURE.Friability]) {
      //   friabBeforeWt = req.payload[GLOBAL_NOMENCLATURE.Friability][0].data.BeforeValue;
      //   friabAfterWt = req.payload[GLOBAL_NOMENCLATURE.Friability][0].data.AfterValue;
      //   actualPer = req.payload[GLOBAL_NOMENCLATURE.Friability][0].data.NetValue;
      // }
      // if (req.payload[GLOBAL_NOMENCLATURE.DTMenu]) { dtTime = req.payload[GLOBAL_NOMENCLATURE.DTMenu][0].data.value }

      // if (req.payload[GLOBAL_NOMENCLATURE.IndividualMenu]) {
      //   req.payload[GLOBAL_NOMENCLATURE.IndividualMenu].TestData.forEach(k => individualData += k.data.value + '\n')
      //   let individualCalcData = req.payload[GLOBAL_NOMENCLATURE.IndividualMenu].TestInfo

      //   averageWeightInd = individualCalcData.averageWeight;
      //   maxWeightInd = individualCalcData.maxWeight;
      //   minWeightInd = individualCalcData.minWeight;
      //   rstdWeightInd = individualCalcData.rstdWeight
      //   stdWeightInd = individualCalcData.stdWeight;
      //   totalweightInd = individualCalcData.totalweight;
      //   ind_Diff = individualCalcData.indDifference
      // }

      // if (req.payload[GLOBAL_NOMENCLATURE.GroupMenu]) {
      //   req.payload[GLOBAL_NOMENCLATURE.GroupMenu].TestData.forEach(k => groupData += k.data.value + '\n')
      //   let groupCalcData = req.payload[GLOBAL_NOMENCLATURE.GroupMenu].TestInfo;

      //   averageWeightGrp = groupCalcData.averageWeight;
      //   maxWeightGrp = groupCalcData.maxWeight;
      //   minWeightGrp = groupCalcData.minWeight;
      //   rstdWeightGrp = groupCalcData.rstdWeight
      //   stdWeightGrp = groupCalcData.stdWeight;
      //   totalweightGrp = groupCalcData.totalweight;

      // }

      // if (req.payload[GLOBAL_NOMENCLATURE.HardnessMenu]) {
      //   req.payload[GLOBAL_NOMENCLATURE.HardnessMenu].TestData.forEach(k => hardData += (k.H.value || k.H) + '\n')
      //   console.log(hardData);
      // }
      // if (req.payload[GLOBAL_NOMENCLATURE.HardnessMenu]) {
      //   req.payload[GLOBAL_NOMENCLATURE.HardnessMenu].TestData.forEach(k => thickData += (k.T.value || k.T) + '\n')
      //   let hardnessCalcData = req.payload[GLOBAL_NOMENCLATURE.Hardness].TestInfo
      //   averageWeightHrd = hardnessCalcData.averageWeight;
      //   maxWeightHrd = hardnessCalcData.maxWeight;
      //   minWeightHrd = hardnessCalcData.minWeight;
      //   rstdWeightHrd = hardnessCalcData.rstdWeight
      //   stdWeightHrd = hardnessCalcData.stdWeight;
      //   totalweightHrd = hardnessCalcData.totalweight;
      //   rangeHrd = hardnessCalcData.hardrange;

      //   averageWeightThick = hardnessCalcData.averageWeightThick;
      //   maxWeightThick = hardnessCalcData.maxWeightThick;
      //   minWeightThick = hardnessCalcData.minWeightThick;
      //   rstdWeightThick = hardnessCalcData.rstdWeightThick
      //   stdWeightThick = hardnessCalcData.stdWeightThick;
      //   totalweightThick = hardnessCalcData.totalweightThick;
      //   rangeThick = hardnessCalcData.Thickrange;
      // }
      // if (req.payload[GLOBAL_NOMENCLATURE.MultiTesterHardness]) {
      //   req.payload.MultiTesterHardness.TestData.forEach(k => individualData += k.data.value + '\n')
      //   let multiTesterCalcData = req.payload[GLOBAL_NOMENCLATURE.MultiTesterHardness].TestInfo;

      //   averageWeightInd = multiTesterCalcData.averageWeight;
      //   maxWeightInd = multiTesterCalcData.maxWeight;
      //   minWeightInd = multiTesterCalcData.minWeight;
      //   rstdWeightInd = multiTesterCalcData.rstdWeight
      //   stdWeightInd = multiTesterCalcData.stdWeight;
      //   totalweightInd = multiTesterCalcData.totalweight;
      //   ind_Diff = multiTesterCalcData.indDifference;
      // }

      // let AWBID = mesData?.AWBID == 'None' ? 'NA' : mesData?.AWBID
      // let HTID = mesData?.HTID == 'None' ? 'NA' : mesData?.HTID
      // let FTID = mesData?.FTID == 'None' ? 'NA' : mesData?.FTID
      // let DTID = mesData?.DTID == 'None' ? 'NA' : mesData?.DTID


      // var mid = crypto.randomUUID()
      // // var data = req.payload.data[0].value;
      // // globalData.MESArray.data.forEach(e => data += e.actualWt + "\n")
      // const root = create({ version: '1.0' })
      //   .ele("MsiMessageContainer", { "xmlns:xsi": "http://www.w3.org/2001/XMLSchema-instance", "xmlns:xsd": "http://www.w3.org/2001/XMLSchema" })
      //   .ele("messageInstanceId").txt(crypto.randomUUID()).up()
      //   .ele("direction").txt("SF_TO_MES").up()
      //   .ele("systemId").txt("2003").up()
      //   .ele("messageType").txt("MsiOrderParameterMessage").up()
      //   .ele("messageContext").txt("5203998621").up()
      //   .ele("message")
      //   .ele("MsiOrderParameterMessage")
      //   .ele("messageInstanceId").txt(crypto.randomUUID()).up()
      //   .ele("direction").txt("SF_TO_MES").up()
      //   .ele("messageId").txt(messageId).up()
      //   .ele("supplierId").txt("DRL").up()
      //   .ele("deviceTypeId").txt("DRL_MSI").up()
      //   .ele("supplierVersion").txt("1.0").up()
      //   .ele("functionalId").txt("QA Parameter").up()
      //   .ele("orderContext").txt("5203998621").up()
      //   .ele("creationTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()


      //   .ele("parameter")
      //   .ele("name").txt("MPR").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(mesData.MPN).up()
      //   .ele("isQualifier").txt(true).up()
      //   .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("BID").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(mesData.BatchID).up()
      //   .ele("isQualifier").txt(true).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("SID").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(mesData.SFOID).up()
      //   .ele("isQualifier").txt(true).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("RT").up()
      //   .ele("dataType").txt("Long").up()
      //   .ele("value").txt(mesData.Repetition).up()
      //   .ele("isQualifier").txt(true).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("TT").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(mesData.MesTestType).up()
      //   .ele("isQualifier").txt(true).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("TSD").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(mesData.MesSide).up()
      //   .ele("isQualifier").txt(true).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("TSC").up()
      //   .ele("dataType").txt("Long").up()
      //   .ele("value").txt(mesData.SampleCount).up()
      //   .ele("isQualifier").txt(true).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("TGSC").up()
      //   .ele("dataType").txt("Long").up()
      //   .ele("value").txt(mesData.GroupSampleCount).up()
      //   .ele("isQualifier").txt(true).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("AID").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(AWBID).up()
      //   .ele("isQualifier").txt(true).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("AMK").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(!balanceInfo || balanceInfo.length === 0 ? "NA" : balanceInfo[0]?.Bal_Make).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("AMD").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(!balanceInfo || balanceInfo.length === 0 ? "NA" : balanceInfo[0].Bal_Model).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("GW").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt((groupData == '') ? 'NA' : groupData).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("IW").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt((individualData == '') ? 'NA' : individualData).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("IAW").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(averageWeightInd).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("ISD").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(stdWeightInd).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("IRSDP").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(rstdWeightInd).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("ITTW").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(totalweightInd).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("IMW").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(minWeightInd).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("IMXW").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(maxWeightInd).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("IDW").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(ind_Diff).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("HTID").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(HTID).up()
      //   .ele("isQualifier").txt(true).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("HTTMK").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(!hardnessInfo || hardnessInfo.length === 0 ? "NA" : hardnessInfo[0]?.Eqp_Make).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("HTMD").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(!hardnessInfo || hardnessInfo.length === 0 ? "NA" : hardnessInfo[0]?.Eqp_Model).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("HD").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt((hardData == '') ? 'NA' : hardData).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("HDH").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(maxWeightHrd).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("HDL").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(minWeightHrd).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("HDR").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(rangeHrd).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("HDA").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(averageWeightHrd).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("HDSD").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(stdWeightHrd).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("HDRSDP").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(rstdWeightHrd).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("TH").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt((thickData == '') ? 'NA' : thickData).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("THM").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(minWeightThick).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("THMX").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(maxWeightThick).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("THR").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(rangeThick).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("THA").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(averageWeightThick).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("THSD").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(stdWeightThick).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("THRSD").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(rstdWeightThick).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("FTID").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(FTID).up()
      //   .ele("isQualifier").txt(true).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("FBW").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(friabBeforeWt).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("FAW").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(friabAfterWt).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("FAP").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(actualPer).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("DTID").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(DTID).up()
      //   .ele("isQualifier").txt(true).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("DAT").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(dtTime).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .ele("parameter")
      //   .ele("name").txt("MID").up()
      //   .ele("dataType").txt("String").up()
      //   .ele("value").txt(mid).up()
      //   .ele("isQualifier").txt(false).up()
      //   .ele("acquisitionTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()

      //   .up()
      //   .up().up()

      // var xml = root.end({ prettyPrint: true });

      // var exceptionXml = await this.getExceptionSamples(req)

      // if (exceptionXml.status === "success") {
      //   let getExceptionSampleCount = await models.tbl_exception_sample_initial.count({ where: { RepSerNo: req.RepSerNo, IsPosted: 1 } })
      //   let getExceptionSampleHtdCount = await models.tbl_exception_samplehtd_initial.count({ where: { RepSerNo: req.RepSerNo, IsPosted: 1 } })

      //   if (getExceptionSampleCount == 0 && getExceptionSampleHtdCount == 0) {
      //     let res = await models.tbl_exception_sample_initial.update({ IsPosted: 1 }, { where: { RepSerNo: req.RepSerNo } })
      //     let reshtd = await models.tbl_exception_samplehtd_initial.update({ IsPosted: 1 }, { where: { RepSerNo: req.RepSerNo } })
      //     return exceptionXml.xml
      //   }
      // }

      // if (!ackMode) {
      //   globalData.MESArray.splice(globalData.MESArray.findIndex(k => k.isPosted == false && k.isCompleted == true && k.DsNo == req.DsNo && k.menuName == req.menuName && k.TabIp == req.TabIp), 1)
      //   mqttSender.sendData(req.DsNo, `Port ${req.portNo}:${GLOBAL_NOMENCLATURE.DisplayMessage} ${GLOBAL_NOMENCLATURE.MESDataPosted}`);
      //   if (req.mqttProtocol) {
      //     setTimeout(() => mqttSender.sendData(req.DsNo, req.mqttProtocol), 1000);
      //   }
      // } else {
      //   mesData.mid = mid
      //   mesData.isPosted = true
      // }

      // return xml;

    } catch (error) {
      console.log(error)
    }
  }
  getTableName(cubicObj, menuName, dsNo, tabIp) {
    try {
      let cubType = cubicObj.CubicleType;
      let rptType = cubicObj.ReportType;
      let ipqcType = cubicObj.IPQCType;
      let prdType;
      // if (cubicObj.ProductType) {
      //   prdType = prdType
      // } else {
      // let productMasterDetail = globalData.arrProductTypeArray.find(e => e.DsNo == dsNo && e.TabIp == tabIp);
      // if (productMasterDetail) {
      prdType = cubicObj.ProductType
      // }
      // }
      let productType = (prdType == 2) ? 'cap' : 'tab';
      let typeValue = objCommonWeightment.getTypeValue(menuName)

      let masterTable, detailTable;
      if (rptType != undefined) {
        masterTable = `tbl_${productType}_initialmaster`;
        detailTable = `tbl_${productType}_initialdetail${typeValue}`
      } else {
        masterTable = `tbl_${productType}_master${typeValue}`
        detailTable = `tbl_${productType}_detail${typeValue}`
      }

      let masterTableIncomplete = masterTable.concat("_incomplete");
      let detailTableIncomplete = detailTable.concat("_incomplete");
      let batchSummaryMasterTable = `tbl_batchsummary_master${typeValue}`;
      let batchSummaryDetailTable = `tbl_batchsummary_detail${typeValue}`;

      let obj = {
        masterTable: masterTable,
        detailTable: detailTable,
        masterTableIncomplete: masterTableIncomplete,
        batchSummaryMasterTable: batchSummaryMasterTable,
        detailTableIncomplete: detailTableIncomplete,
        batchSummaryDetailTable: batchSummaryDetailTable,
        typeValue: typeValue
      }

      return obj

    } catch (err) {
      throw new Error(err);
    }
  }
  getLimitsObj(typeValue, rptType) {
    try {
      let obj = {};

      // let str = `Param${typeValue}_`;
      let str = (rptType != undefined) ? `Param${typeValue}_` : '';
      // if (typeValue == 2 && rptType != undefined) {
      //   obj.AvgWeight = 'AvgGrpWeight'
      //   obj.MinWeight = 'MinGrpWeight';
      //   obj.MaxWeight = 'MaxGrpWeight';
      // } else {
      obj.AvgWeight = (rptType != undefined) ? `${str}AvgNet` : 'AvgWeight';
      obj.MinWeight = `${str}MinWeight`;
      obj.MaxWeight = `${str}MaxWeight`;
      // }

      obj.Nom = `${str}Nom`;
      obj.T2NegTol = `${str}T2NegTol`;
      obj.T2PosTol = `${str}T2PosTol`;
      obj.Diff = `${str}Diff`;
      obj.StdDev = `${str}StdDev`;
      obj.RStdDev = `${str}RStdDev`;
      obj.Remark = `${str}Remark`;
      obj.FailRemark = `${str}FailRemark`;
      obj.Unit = `${str}Unit`;
      obj.PrDate = `${str}PrDate`;
      obj.PrEndDate = `${str}PrEndDate`;
      obj.PrTime = `${str}PrTime`;
      obj.PrEndTime = `${str}PrEndTime`;
      obj.DecimalPoint = `${str}DecimalPoint`
      obj.NoOfAbove1 = `${str}NoOfAbove1`
      obj.NoOfBelow1 = `${str}NoOfBelow1`
      obj.NoOfAbove2 = `${str}NoOfAbove2`
      obj.NoOfBelow2 = `${str}NoOfBelow2`;
      obj.TotalWeight = `${str}TotalWeight`

      return obj;

    } catch (err) {
      throw new Error(err);
    }
  }
  async handleMultiTesterData(cubicObj, menuName, payloadObj, repSerNo, masterData) {
    try {
      let getTableName = this.getTableName(cubicObj, GLOBAL_NOMENCLATURE.IndividualMenu)
      let detailTableIncomplete = getTableName.detail
      let detailTable = getTableName.detailTable;

      // var detailIncompData = await models[detailTableIncomplete].findOne({ attributes: { exclude: ["RepSerNo", "RecNo", "isException", "Remark"] } })
      // detailIncompData = Object.keys(detailIncompData).toString();

      // var str_Query = `INSERT INTO ${detailTable} (${detailIncompData}) OUTPUT inserted.RecNo SELECT ${detailIncompData} FROM ${detailTableIncomplete} where RepSerNo = ${repSerNo} AND isException = 0`
      // let result = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

      let getLimitsObj = this.getLimitsObj(getTableName.typeValue, cubicObj.ReportType);
      let unit = masterData[getLimitsObj.Unit]
      let indDifference = masterData[getLimitsObj.MaxWeight] - masterData[getLimitsObj.MinWeight]
      let testInfo = {
        unit: masterData[getLimitsObj.Unit],
        averageWeight: `${masterData[getLimitsObj.AvgWeight]} ${unit}`,
        maxWeight: `${masterData[getLimitsObj.MaxWeight]} ${unit}`,
        minWeight: `${masterData[getLimitsObj.MinWeight]} ${unit}`,
        stdWeight: `${masterData[getLimitsObj.StdDev]} ${unit}`,
        rstdWeight: `${masterData[getLimitsObj.RStdDev]} ${unit}`,
        totalweight: `${masterData[getLimitsObj.TotalWeight]} ${unit}`,
        indDifference: `${indDifference} ${unit}`
      }

      // if (result[0].length > 0) {
      //   let recNoArr = result[0].map(e => e.RecNo)
      //   await models[detailTable].update({ RepSerNo: masterRepNo }, { where: { RecNo: { [Op.in]: recNoArr } }, RepSerNo: masterRepNo })
      //   await models[detailTableIncomplete].destroy({ where: { RepSerNo: repSerNo } })
      // }

      let multiTesterIndividualData = await models[detailTable].findAll({ attributes: [['DataValue', 'value']], where: { RepSerNo: repSerNo } })
      if (multiTesterIndividualData.length > 0) {
        let unit = clsCommonInsertOperationObj.isNullOrStringNull(testInfo.unit);
        if (!unit) {
          multiTesterIndividualData = multiTesterIndividualData.map(e => ({
            ...e,
            value: `${e.value} ${testInfo.unit}`
          }))
        }
        multiTesterIndividualData = multiTesterIndividualData.map(e => ({ data: { ...e, isMesChecked: false } }))
        payloadObj.MultiTesterHardness = { 'TestData': multiTesterIndividualData }
        payloadObj.MultiTesterHardness.TestInfo = testInfo
      }

      return payloadObj

    } catch (err) {
      throw new Error(err)
    }
  }
  async postToManual(Data) {
    try {
      var SFOID = Data.SFOID;
      var DsNo = Data.DsNo;
      // var BatchID = Data.BatchID;
      var Repetition = Data.repetition;
      var MPN = Data.MPN;
      var productname = Data.productName
      var productcode = Data.productCode
      var Side = Data.side
      // var Container = Data.container
      var tabletIndividualSampleCount = Data.sampleCount // Tablet Individual Sample Count
      var sampleCount  // Tablet Sample Count group
      var htSampleCount
      var testType = Data.testType
      // var GroupSampleCount = Data.grpSampleCount
      // var TestType = Data.TestType;
      var findBatch = await models.tbl_cubical.findAll({
        where: {
          Sys_DSNumber: DsNo,
          // Sys_SFOID : SFOID,
          // Sys_Repetition:Repetition
        }
      })
      findBatch = findBatch[0]
      // if (SampleCount == StartSampleCount) {
      //   findBatch.Sys_RptType = 0
      // } else {
      //   findBatch.Sys_RptType = 1
      // }
      if (findBatch != undefined && findBatch.Sys_Batch == "NULL") {
        return { "status": "fail", "result": 'Batch Id Not Assign' }
      } else {

        Data.TestType = (testType?.includes('Startup') || testType?.includes('Pre')) ? 1 : 0

        var findMesdata = await models.tbl_mes_data.findAll({
          where: {
            SFOID: Data.SFOID,
            BatchID: findBatch.Sys_Batch,
            ...(Repetition !== 'NA' ? { Repetition } : {}),
            MPN: MPN,
            TestType: findBatch.Sys_RptType,
            isSetInCubical: 0
          }
        })
        findMesdata = findMesdata[0]

        if (findMesdata == undefined) {
          var productMaster = await models.tbl_product_master.findAll({
            where: {
              // SFOID: Data.SFOID,
              MPN_Code: MPN,
              ProductName: productname,
              ProductId: productcode
            }
          })

          sampleCount = ((serverConfig.plant != "FT03" && productMaster[0].ProductType == 1) && findBatch.Sys_Area != "Coating") ? Data.grpSampleCount : Data.stSampleCount // Tablet Sample Count ByDefault
          htSampleCount = (serverConfig.plant != "FT03" && productMaster[0].ProductType == 1) ? Data.hrdSampleCount : Data.stSampleCount;

          var tableName = productMaster[0]?.ProductType == 1 ? 'tbl_product_tablet' : 'tbl_product_capsule';
          var masterTable = productMaster[0]?.ProductType == 1 ? 'tbl_tab_initialmaster' : 'tbl_cap_initialmaster';
          var findLimit = await models[tableName].findAll({
            where: {
              // SFOID: Data.SFOID,
              MPN_Code: MPN,
              ProductName: productname,
              ProductId: productcode,

            }
          })
          findLimit = findLimit[0]
          var repeat = await models.tbl_cubical.findAll({
            where: {
              Sys_Batch: findBatch.Sys_Batch,

              // Sys_MPNCode: MPN,
              Sys_DSNumber: DsNo
            }
          })
          var arr = []
          if (repeat.length != 0) {
            var initialdata;
            if (findBatch.Sys_Area != "Granulation") {
              initialdata = await models[masterTable].findAll({
                // attributes: [[sequelize.fn('max', sequelize.col('Repetition')), 'Repetition']],
                where: {
                  BatchNo: findBatch.Sys_Batch,
                  SFOID: SFOID,
                  MPN_Code: MPN,
                  ...(Repetition !== 'NA' ? { Repetition } : {}),
                  ...(findBatch.Sys_Area != "Coating" ? { Side } : {}),
                  MesTestType: findBatch.MesTestType,
                  ReportType: findBatch.Sys_RptType,
                  // MesTestType:findBatch.MesTestType
                  //  / DsNo: DsNo
                }
              })


              if (initialdata.length != 0) {
                for (let obj in initialdata) {
                  if (initialdata[obj].Repetition != null) {
                    if (arr.length != 0) {
                      arr.push(initialdata[obj].Repetition)
                    } else {
                      if (!arr.includes(initialdata[obj].Repetition))
                        arr.push(initialdata[obj].Repetition)
                    }
                  }
                }
                console.log(arr)
                var lastrepeat = maths.max(arr)
                initialdata = initialdata[0].Repetition
              }
            } else {
              let lodmaster = await models.tbl_lodmaster.findOne({
                where: {
                  BatchNo: findBatch.Sys_Batch,
                  ReportType: findBatch.Sys_RptType,
                  Repetition: Data.repetition,
                  Lot: Data.LotNo
                  // [Op.or]: [
                  //   {Repetition: Data.repetition, },
                  //   {Lot: findBatch.Sys_LotNo}
                  // ],
                }
              })

              if (lodmaster) {
                if (lodmaster.Repetition == Data.repetition && lodmaster.Lot == Data.LotNo) {
                  return {
                    status: "fail",
                    message: `This Repetition Number and Lot Number is Already used.`
                  }
                }
                // else if(lodmaster.Lot == Data.LotNo){
                // }
                // arr.push(lodmaster.Repetition)
              }

            }


            if (arr != undefined) {
              if (arr.length != 0) {
                if (arr.includes(Number(Repetition))) {
                  return {
                    status: "fail",
                    message: `This Repetition Number is Already used.`
                  }
                }
              }
            }
            // if(Repetition<= repeat[0].Sys_Repetition){
            //   return {
            //     status:"success",
            //     result:`Repetition Number is Invalid Put greater then ${repeat[0].Sys_Repetition}`
            //   }
            // }
          }

          if (findLimit != undefined) {
            var lod = 'NA'
            if (findLimit.Param16_T1Neg != 99999) {
              if (findLimit.Param16_Nom != 99999) {
                lod = `(${findLimit.Param16_T1Neg}-${findLimit.Param16_T1Pos}) % w/w (Target of ${findLimit.Param16_Nom}% w/w)`
              } else {
                lod = `(${findLimit.Param16_T1Neg}-${findLimit.Param16_T1Pos}) % w/w`
              }
            } else if (findLimit.Param16_T1Pos != 99999) {
              if (findLimit.Param16_Nom != 99999) {
                lod = `NMT ${findLimit.Param16_T1Pos} % w/w (Target of ${findLimit.Param16_Nom}% w/w)`
              } else {
                lod = `NMT ${findLimit.Param16_T1Pos} % w/w`
              }
            }
            const currentDateTime = date.format(new Date(), 'YYYY-MM-DD HH:mm:ss');
            const mesRes = await models.tbl_mes_data.create({
              isManual:1,
              prDate: currentDateTime,
              BatchID: findBatch.Sys_Batch,
              SFOID: Data.SFOID,
              Repetition: Data.repetition,
              TestType: serverConfig.plant == 'FT03' ? findBatch.Sys_RptType : (findBatch.Sys_Area == "Coating") ? 0 : Data.TestType,
              MPN: MPN,
              ProductId: productMaster[0]?.ProductId,
              ProductName: productMaster[0]?.ProductName,
              ProductType: productMaster[0]?.ProductType,
              Side: Side,
              // Container: Container,
              DS_Number: DsNo, // DS_Number
              SampleCount: (sampleCount) ? sampleCount : 0,
              GroupSampleCount: (tabletIndividualSampleCount) ? tabletIndividualSampleCount : 0,
              StartSampleCount: (htSampleCount) ? htSampleCount : 0,
              CISampleCount: 20,
              EGSampleCount: 50,
              // Balance I
              AWBID: (findBatch.Sys_BalID && findBatch.Sys_BalID != "None") ? findBatch.Sys_BalID : "NA",
              // Vernier ID
              VerId: (findBatch.Sys_VernierID && findBatch.Sys_VernierID != "None") ? findBatch.Sys_VernierID : "NA",
              // LOD (Moisture Analyzer) (No parameter for LOD Test)
              MAID: (findBatch.Sys_MoistID && findBatch.Sys_MoistID != "None") ? findBatch.Sys_MoistID : "NA",

              // Individual
              IndWtLow: (findLimit.Param1_T2Neg) ? findLimit.Param1_T2Neg : 99999,
              IndWtHigh: (findLimit.Param1_T2Pos) ? findLimit.Param1_T2Pos : 99999,
              IndUnit: (findLimit.Param1_Unit) ? findLimit.Param1_Unit : "",

              // Group
              GrpWtLow: (findLimit.Param2_T2Neg) ? findLimit.Param2_T2Neg : 99999,
              GrpWtHigh: (findLimit.Param2_T2Pos) ? findLimit.Param2_T2Pos : 99999,
              GrpUnit: (findLimit.Param2_Unit) ? findLimit.Param2_Unit : "",

              //Empty Group
              EmptGrpWtLow: (findLimit.Param2_T2Neg) ? findLimit.Param19_T2Neg : 99999,
              EmptGrpWtHigh: (findLimit.Param2_T2Pos) ? findLimit.Param19_T2Pos : 99999,
              EmptGrpUnit: (findLimit.Param2_Unit) ? findLimit.Param19_Unit : "",

              // Differential 
              DiffWtLow: (findLimit.Param3_T2Neg) ? findLimit.Param3_T2Neg : 99999,
              DiffWtHigh: (findLimit.Param3_T2Pos) ? findLimit.Param3_T2Pos : 99999,
              DiffUnit: (findLimit.Param3_Unit) ? findLimit.Param3_Unit : "",
              // Hardness

              HTID: (findBatch.Sys_HardID && findBatch.Sys_HardID != "None") ? findBatch.Sys_HardID : "NA",
              HardnessLow: (findLimit.Param7_T2Neg) ? findLimit.Param7_T2Neg : 99999,
              HardnessHigh: (findLimit.Param7_T2Pos) ? findLimit.Param7_T2Pos : 99999,
              HardUnit: (findLimit.Param7_Unit) ? findLimit.Param7_Unit : "",

              // Thickness
              ThicknessLow: (findLimit.Param3_T2Neg) ? findLimit.Param3_T2Neg : 99999,
              ThicknessHigh: (findLimit.Param3_T2Pos) ? findLimit.Param3_T2Pos : 99999,
              ThicknessUnit: (findLimit.Param3_Unit) ? findLimit.Param3_Unit : "",

              // Diameter
              DiameterLow: (findLimit.Param6_T2Neg) ? findLimit.Param6_T2Neg : 99999,
              DiameterHigh: (findLimit.Param6_T2Pos) ? findLimit.Param6_T2Pos : 99999,
              DiameterUnit: (findLimit.Param6_Unit) ? findLimit.Param6_Unit : "",

              // Length
              LengthLow: (findLimit.Param5_T2Neg) ? findLimit.Param5_T2Neg : 99999,
              LengthHigh: (findLimit.Param5_T2Pos) ? findLimit.Param5_T2Pos : 99999,
              LengthUnit: (findLimit.Param5_Unit) ? findLimit.Param5_Unit : "",

              // Locked Length
              LockedLengthLow: (findLimit.Param5_T2Neg) ? findLimit.Param5_T2Neg : 99999,
              LockedLengthHigh: (findLimit.Param5_T2Pos) ? findLimit.Param5_T2Pos : 99999,
              LockedLengthUnit: (findLimit.Param5_Unit) ? findLimit.Param5_Unit : "",

              // Disintegration Test
              DTID: (findBatch.Sys_DTID && findBatch.Sys_DTID != "None") ? findBatch.Sys_DTID : "NA",
              // DisintegrationLow: (DTFound) ? obj.DisintegrationLow : 99999,
              // DisintegrationHigh: (DTFound) ? obj.DisintegrationHigh : 99999,
              DisintegrationRange: (findLimit.Param13_Nom) ? findLimit.Param13_Nom : 99999,

              // Friability Test
              FTID: (findBatch.Sys_FriabID && findBatch.Sys_FriabID != "None") ? findBatch.Sys_FriabID : "NA",
              // FriabilityLow: (friabFound) ? obj.FriabilityLow : 99999,
              // FriabilityHigh: (friabFound) ? obj.FriabilityHigh : 99999,
              FriabilityRange: (findLimit.Param8__Nom) ? findLimit.Param8__Nom : 99999, // NMT 0.14 RPM
              FriabilityRPM: "00:01:00",
              FriabUnit: (findLimit.Param1_Unit) ? findLimit.Param1_Unit : "",

              // Leak Test
              LTID: (findBatch.Sys_LeakID) == 'NULL' ? "None" : (findBatch.Sys_LeakID),

              LODHigh: (findLimit.Param16_T1Pos) ? lod : 99999,

              // LODHigh: (findLimit.Param16_T1Pos) ? `NMT ${findLimit.Param16_T1Pos} % w/w (Target of ${findLimit.Param16_Nom}% w/w)` : 99999,

              MesTestType: testType,
              MesSide: testType,
              isSetInCubical: 1,

              // GrpWtEqmID: (grpFound) ? obj.GrpWtEqmID : "None",

              // Coating
              AWPWT: Data.AvgWeight ? Data.AvgWeight : 'NA',
              SprayPeriod: Data.SprayPeriod ? Data.SprayPeriod : 'NA',
              LotNo: Data.LotNo ? Data.LotNo : 'NA',
              TOC: Data.TypeOfCoating ? Data.TypeOfCoating : 'NA',

            })
            await models.tbl_cubicle_product_sample.update({
              Individual: tabletIndividualSampleCount,
              Group: sampleCount,
              Hardness: htSampleCount,
              Thickness: htSampleCount,
              Diameter: sampleCount,
              Length: sampleCount,
              Friability: 'NLT 6.5 g',
              DT: 6,
              Differential: tabletIndividualSampleCount
            }, {
              where: {
                Sys_CubicNo: findBatch.Sys_CubicNo,
              }
            });
            await models.tbl_cubical.update({
              // Sys_BFGCode: productId,
              // Sys_ProductName: productName,
              Sys_Repetition: Repetition !== 'NA' ? Repetition : null,
              Sys_MPNCode: MPN,
              MPN: MPN,
              Sys_SFOID: SFOID,
              isManual: 1,
              Sys_ProductName: Data.productName,
              Sys_BFGCode: Data.productCode,
              Sys_RotaryType: Side,
              MesTestType: testType,
              MesSide: testType,
              Sys_LotNo: Data.LotNo,
              MesAWPWT: Data.AvgWeight ? Data.AvgWeight : 'NA',
              SprayPeriod: Data.SprayPeriod ? Data.SprayPeriod : 'NA',
              TOC: Data.TypeOfCoating ? Data.TypeOfCoating : 'NA'
            }, {
              where: {
                Sys_Batch: findBatch.Sys_Batch,
                // Sys_SFOID: SFOID,
                // Sys_MPNCode: MPN,
                Sys_DSNumber: DsNo
              }
            });
            var objActivity = {}
            Object.assign(
              objActivity,
              { strUserId: Data.userId },
              { strUserName: Data.userName },
              { batch: findBatch.Sys_Batch, },
              { activity: 'Manual Mode- Test in progress' }
            );

            await objActivityLog.ActivityLogEntry(objActivity);

            return {
              status: "success",
              result: 'Data Stored Successfully'
            }
          } else {
            return { "Status": "fail", "message": 'Product limit not Found' }
          }

        }

      }


      // return mesRes.dataValues;
    } catch (error) {
      console.log('error: ', error);
    }
  }
  async scanManual(Data) {
    try {
      var MPN = Data.MPN;
      var dsNo = Data.dsNo;
      var tabIp = Data.tabIp


      let GroupsampleCount1, IndividualSampleCount1, HardnessThicknessSampleCount1;

      var findDataCubical = await models.tbl_cubical.findAll({
        where: {
          Sys_DSNumber: dsNo,
        }
      })

      var dataCubical = await models.tbl_cubical.findAll({
        where: {
          Sys_DSNumber: dsNo,
          [Op.or]: [
            { Sys_Port1: { [Op.ne]: 'None' } },
            { Sys_Port2: { [Op.ne]: 'None' } },
            { Sys_Port3: { [Op.ne]: 'None' } },
            { Sys_Port4: { [Op.ne]: 'None' } }
          ],
          [Op.or]: [
            { Sys_BalID: { [Op.ne]: 'None' } },
            { Sys_FriabID: { [Op.ne]: 'None' } },
            { Sys_LeakID: { [Op.ne]: 'NULL' } },
            { Sys_MoistID: { [Op.ne]: 'None' } },
            { Sys_HardID: { [Op.ne]: 'None' } },
            { Sys_VernierID: { [Op.ne]: 'None' } },
            { Sys_DTID: { [Op.ne]: 'None' } }
          ],

        }
      })
      if (dataCubical.length == 0) {
        let obj1 = {
          status: "fail",
          result: 'Instrument Not Set'
        }
        return obj1

      }

      let finddataMpn = await objCommonOperation.checkProductAccordingArea(MPN, findDataCubical[0].Sys_Area);
      var obj = {}
      if (finddataMpn.length != 0) {
        let Product_table = finddataMpn[0]?.ProductType == 1 ? 'tbl_product_tablet' : 'tbl_product_capsule'
        let ProductTable = await models[Product_table].findOne({
          where: {
            MPN_Code: finddataMpn[0].MPN_Code
          }
        })

        var findDataMachine = await models.tbl_machine.findAll({
          where: {
            Machine_ID: findDataCubical[0].Sys_MachineCode,
          }
        })
        if (findDataMachine.length != 0) {
          var Machine_Rotary = findDataMachine[0].Machine_Rotary
          findDataMachine = findDataMachine[0].Machine_Sample
          var side = (Machine_Rotary == 'Double' && finddataMpn[0].ProductType != 2) ? ['LHS', 'RHS'] : ['NA']
        }
        var individualSampleCount
        var sampleCount
        if (findDataCubical.length != 0) {
          var data = findDataCubical[0].Sys_RptType
          var batch = findDataCubical[0].Sys_Batch
          var areaName = findDataCubical[0].Sys_Area
          var cubicTestType;
          if (findDataCubical[0].Sys_Area == "IPQA Packing" || findDataCubical[0].Sys_Area == "Nasal Filling") {
            cubicTestType = findDataCubical[0].Sys_Batch_Status
          } else {
            cubicTestType = findDataCubical[0].isPreStart == 1 ? 'Pre-Startup' : findDataCubical[0].Sys_RptType == 1 ? 'Startup' : 'Inprocess'
          }
          var areaName = findDataCubical[0].Sys_Area
          // data = data == 1 ? false :true
          if (data == 1) {
            // individualSampleCount = findDataMachine ? findDataMachine : 10
            individualSampleCount = (findDataCubical[0].isPreStart && 20) || (findDataMachine ? findDataMachine : 10)
            sampleCount = 10
          } else {
            individualSampleCount = 10
            sampleCount = 10
          }
        }

        var arr = []

        for (let data in finddataMpn) {
          arr.push({
            productCode: finddataMpn[data].ProductId,
            productName: finddataMpn[data].ProductName
          })

        }
        obj = {
          "status": "success",
          Side: side,
          testtype: true,
          batch: batch,
          individualSampleCount: individualSampleCount,
          sampleCount: sampleCount,
          result: arr,
          area: areaName,
          cubicTestType: cubicTestType


        }
        if (serverConfig.plant != "FT03") {
          if (finddataMpn[0].IsCompress == 1 && finddataMpn[0].ProductType == 1) {
            Object.assign(obj, {
              GroupsampleCount:
                (ProductTable.Param2_Nom != 99999 && ProductTable.Param2_Nom !== '') &&
                  (ProductTable.Param2_T2Neg != 99999 && ProductTable.Param2_T2Neg !== '') &&
                  (ProductTable.Param2_T2Pos != 99999 && ProductTable.Param2_T2Pos !== '') &&
                  (findDataCubical[0].Sys_BalID !== 'None') ? true : false,

              IndividualSampleCount1:
                (ProductTable.Param1_Nom != 99999 && ProductTable.Param1_Nom !== '') &&
                  (ProductTable.Param1_T2Neg != 99999 && ProductTable.Param1_T2Neg !== '') &&
                  (ProductTable.Param1_T2Pos != 99999 && ProductTable.Param1_T2Pos !== '') &&
                  (findDataCubical[0].Sys_BalID !== 'None') ? true : false,

              HardnessThicknessSampleCount1:
                (ProductTable.Param7_Nom != 99999 && ProductTable.Param7_Nom !== '') &&
                  (ProductTable.Param7_T2Neg != 99999 && ProductTable.Param7_T2Neg !== '') &&
                  (ProductTable.Param7_T2Pos != 99999 && ProductTable.Param7_T2Pos !== '') &&
                  (ProductTable.Param3_Nom != 99999 && ProductTable.Param3_Nom !== '') &&
                  (ProductTable.Param3_T2Neg != 99999 && ProductTable.Param3_T2Neg !== '') &&
                  (ProductTable.Param3_T2Pos != 99999 && ProductTable.Param3_T2Pos !== '') &&
                  (findDataCubical[0].Sys_HardID !== 'None') ? true : false
            });
          }
        }

        console.log(obj)
      } else {
        obj = {
          status: "fail",
          Side: side,
          testtype: true,
          batch: batch,
          individualSampleCount: individualSampleCount,
          sampleCount: sampleCount,
          area: areaName,
          result: 'Invalid MPR Number'


        }

      }
      return obj

    } catch (error) {
      console.log('error: ', error);
    }
  }







}

module.exports = mesModel;
