const { create } = require("xmlbuilder2");
const oAuth2 = require('jsonwebtoken');
const { models } = require("../../config/dbConnection")
const moment = require("moment")
const crypto = require('crypto');
const globalData = require("../global/globalData")
// const date = require("date-and-time");
const clsActivityLog = require("../model/clsActivityLog.model");
const { Op } = require("sequelize");
const menuRequestModel = require('../model/Menu/MenuRequest.model');
const { sequelize } = require('../../config/dbConnection')
const MqttModel = require('../model/Mqtt/mqttSender.class');
const GLOBAL_NOMENCLATURE = require("../global/GLOBAL_NOMENCLATURE");
const date = require('date-and-time');
const tbl_product_tablet_temp = require("../../../IncrencyV4_DRL_Model/models/Master/Product/Tablet/tbl_product_tablet_temp");
const clsIpqc = require('../model/IPQC/ipqc.model');
const axios = require('axios');
const { ackReceive } = require("../controller/mes.Controller");
const mqttSender = new MqttModel();
//instances
const objIpqc = new clsIpqc();
const objActivityLog = new clsActivityLog();
const objMenuRequestModel = new menuRequestModel();
const serverConfig = require('../global/serverConfig')


class ackModel {
  constructor() { }

  async getMsg(req) {
    var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
    return rootXml;
  }

  async getMessageLOD(req) {
    var table = "tbl_lodmaster"
    var maxRepSerNo = await models[table].max("RepSerNo")
    var tableData = await models[table].findAll({
      where: {
        RepSerNo: maxRepSerNo
      }
    })
    var currentMESObj = globalData.postMessageData
    if (tableData.length !== 0) {
      tableData = tableData[0]
      let batchId = currentMESObj.BatchId
      let srNo = currentMESObj.Repetition
      let EquipmentId = currentMESObj.MoistureEquipmentId

      const root = create()
        .ele("MsiMessageContainer", { "xmlns:xsi": `http://www.w3.org/2001/XMLSchema-instance`, 'xmlns:xsd': `http://www.w3.org/2001/XMLSchema` })
        .ele("messageInstanceId").txt(crypto.randomUUID()).up()
        .ele("direction").txt("SF_TO_MES").up()
        .ele("systemId").txt("2000").up()
        .ele("messageType").txt("MsiOrderParameterMessage").up()
        .ele("messageContext").txt("5203998621").up()
        .ele("message")
        .ele("MsiOrderParameterMessage")
        .ele("messageInstanceId").txt(crypto.randomUUID()).up()
        .ele("direction").txt("SF_TO_MES").up()
        .ele("messageId").txt("Recieve_MoistureAnalyser2").up()
        .ele("supplierId").txt("DRL").up()
        .ele("deviceTypeId").txt("DRL_MSI").up()
        .ele("supplierVersion").txt("1.0").up()
        .ele("functionalId").txt("QA Parameter").up()
        .ele("orderContext").txt("5203998621").up()
        .ele("creationTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
        .ele("parameter")
        .ele("name").txt("BatchId").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(batchId).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
        .ele("parameter")
        .ele("name").txt("MoistureEquipmentId").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(EquipmentId).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
        .ele("parameter")
        .ele("name").txt("Repetition").up()
        .ele("dataType").txt("Long").up()
        .ele("value").txt(srNo).up()
        .ele("isQualifier").txt(true).up()
        .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
        .ele("parameter")
        .ele("name").txt("HeatingTemperature").up()
        .ele("dataType").txt("Double").up()
        .ele("value").txt(tableData.SetTemp).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
        .ele("parameter")
        .ele("name").txt("InitialWeight").up()
        .ele("dataType").txt("Double").up()
        .ele("value").txt(tableData.InitialWeight).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
        .ele("parameter")
        .ele("name").txt("FinalWeight").up()
        .ele("dataType").txt("Double").up()
        .ele("value").txt(tableData.FinalWeight).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
        .ele("parameter")
        .ele("name").txt("TotalTime").up()
        .ele("dataType").txt("String").up()
        .ele("value").txt(tableData.TotalTime).up()
        .ele("isQualifier").txt(false).up()
        .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up().up().up().up()
      let xml = root.end({ prettyPrint: true });
      return xml;
    }

  }

  async getMessageBalance(req) {
    var messageId = "Exception_Recieve_Hardness1"
    var obj = globalData.postMessageData
    var currentMESObj = globalData.MESArray
    if (Object.keys(obj).length === 0) {
      var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
      return rootXml;
    }
    if (Object.keys(globalData.MESArray.data).length === 0) {
      var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
      return rootXml;
    }
    for (let key in obj) {
      if (obj[key].length == 0 || obj[key] == null || obj[key] == undefined) {
        var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
        return rootXml;
      }
    }
    var isPending = false;
    var currentValue;
    var sampleNumber;
    for (let e in globalData.MESArray.data) {
      if (globalData.MESArray.data[e].isChecked === false) {
        currentValue = globalData.MESArray.data[e].actualWt;
        isPending = true;
        sampleNumber = Number(e) + 1
        break;
      }
    }
    if ((!(Number(obj.IndWtLow) <= Number(currentValue) && Number(currentValue) <= Number(obj.IndWtHigh))) && isPending == true) {
      const rootException = create({ version: '1.0' })
        .ele("MsiMessageContainer")
        .ele("messageInstanceId").txt(crypto.randomUUID()).up()
        .ele("direction").txt("SF_TO_MES").up()
        .ele("systemId").txt(2000).up()
        .ele("messageType").txt("MsiExceptionMessage").up()
        .ele("message")
        .ele("MsiExceptionMessage")
        .ele("messageInstanceId").txt(crypto.randomUUID()).up()
        .ele("creationTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
        .ele("exception")
        .ele("causedAt").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
        .ele("exceptionType").txt("MSI exception received from external system").up()
        .ele("user").txt("PASXAdmin").up()
        .ele("systemDescription").txt(`Repeation:${obj.Repetition}, Sample Number:${sampleNumber}, "Individual Weight" value out of limit(${obj.IndWtLow}-${obj.IndWtHigh}) = ${currentValue}`).up()
        .ele("userDescription").txt().up()
        .ele("manufacturingOrderID").txt().up()
        // .ele("deviationNumber").txt(1).up()
        .ele("sfoID").txt(obj.SFOID).up()
        .ele("batchNumber").txt(obj.BatchId).up()
        .ele("productionUnit").txt("productionUnit").up()
        .ele("equipmentID").txt().up()
        .ele("operationID").txt().up()
        .ele("stepID").txt().up().up().up().up().up()
      for (let e in globalData.MESArray.data) {
        if (globalData.MESArray.data[e].isChecked === false) {
          globalData.MESArray.data[e].isChecked = true
          break;
        }
      }
      let xml = rootException.end({ prettyPrint: true });
      return xml;
    }
    if (currentMESObj.isCompleted === false || isPending === true) {
      for (let e in globalData.MESArray.data) {
        if (globalData.MESArray.data[e].isChecked === false) {
          globalData.MESArray.data[e].isChecked = true
          break;
        }
      }
      var rootXml = create({ version: '1.0' }).end({ prettyPrint: true });
      return rootXml;
    }
    var data = '';
    globalData.MESArray.data.forEach(e => data += e.actualWt + "\n")
    const root = create({ version: '1.0' })
      .ele("MsiMessageContainer", { "xmlns:xsi": "http://www.w3.org/2001/XMLSchema-instance", "xmlns:xsd": "http://www.w3.org/2001/XMLSchema" })
      .ele("messageInstanceId").txt(crypto.randomUUID()).up()
      .ele("direction").txt("SF_TO_MES").up()
      .ele("systemId").txt("2000").up()
      .ele("messageType").txt("MsiOrderParameterMessage").up()
      .ele("messageContext").txt("5203998621").up()
      .ele("message")
      .ele("MsiOrderParameterMessage")
      .ele("messageInstanceId").txt(crypto.randomUUID()).up()
      .ele("direction").txt("SF_TO_MES").up()
      .ele("messageId").txt(messageId).up()
      .ele("supplierId").txt("DRL").up()
      .ele("deviceTypeId").txt("DRL_MSI").up()
      .ele("supplierVersion").txt("1.0").up()
      .ele("functionalId").txt("QA Parameter").up()
      .ele("orderContext").txt("5203998621").up()
      .ele("creationTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
      .ele("parameter")
      .ele("name").txt("BatchID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(obj.BatchId).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
      .ele("parameter")
      .ele("name").txt("EquipmentId").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(obj.IndWtEqmID).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
      .ele("parameter")
      .ele("name").txt("SFOID").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(obj.SFOID).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
      .ele("parameter")
      .ele("name").txt("Repetition").up()
      .ele("dataType").txt("Long").up()
      .ele("value").txt(obj.Repetition).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
      .ele("parameter")
      .ele("name").txt("TestType").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(obj.TestType).up()
      .ele("isQualifier").txt(true).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
      .ele("parameter")
      .ele("name").txt("IndWt").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt(data).up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
      .ele("parameter")
      .ele("name").txt("GrpWt").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
      .ele("parameter")
      .ele("name").txt("Hardness").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up()
      .ele("parameter")
      .ele("name").txt("Thickness").up()
      .ele("dataType").txt("String").up()
      .ele("value").txt("NA").up()
      .ele("isQualifier").txt(false).up()
      .ele("acquisitionTime").txt(moment().format("YYYY-MM-DD HH:mm:ss,SSS")).up()
      .up().up()
      .up().up()
    currentMESObj.data = []
    currentMESObj.isCompleted = false
    let xml = root.end({ prettyPrint: true });
    return xml;

  }

  async postMessage(req) {
    try {
      // var mesData = globalData.MESArray.find(k => k.isPosted == false && k.isCompleted == true)
      // if (mesData == undefined) {
      // var mesData = globalData.MESArray.find(k => k.isPosted == true && k.isCompleted == true)
      // }
      const root = create().ele("TransferResult").ele("Error").ele("code").txt(0).up().ele("text").txt("").up().up().ele("Success").txt(true).up().up()
      let xmlres = root.end({ prettyPrint: true });

      var mid
      // if (req.msimessagecontainer.systemid[0] != GLOBAL_NOMENCLATURE.ackReceiveSysID) {
      //   console.log(`Invalid System Id ${req.msimessagecontainer.systemid[0]}`);
      //   return { status: 'fail' }
      // }
      req.msimessagecontainer.message[0].msiorderparametermessage[0].parameter.forEach(param => {
      // req.msiinterfacedescription.parameter.forEach(param => {
        switch (param.name[0].toLowerCase()) {
          case "mid":
            mid = param.value[0]
            break;
        }
      })

      console.log("mid receive", mid)
      var dataCompression = await models.tbl_tab_initialmaster.findAll({ where: { ismid: mid } });
      var dataCoating = await models.tbl_tab_master2.findAll({ where: { ismid: mid } });
      if (dataCompression.length != 0 || dataCoating.length != 0) {
        console.log("rec")
      }

      // const rootres = create()
      //   .ele("MsiOrderParameterMessageResponse", { "xmlns:xsi": `http://www.w3.org/2001/XMLSchema-instance`, 'xmlns:xsd': `http://www.w3.org/2001/XMLSchema` })
      //   .ele("messageInstanceId").txt(crypto.randomUUID()).up()
      //   .ele("messageContext").txt("5203998621").up()
      //   .ele("message")
      //   .ele("MsiOrderParameterMessageResponse")
      //   .ele("creationTime").txt(moment().utc().format("YYYY-MM-DD HH:mm:ss,SSS")).up().up().up().up()
      // let xlm = root.end({ prettyPrint: true });




      if (mid) {
        const ackRec = await axios.post(`http://${serverConfig.HOST_IP}:${serverConfig.MESPort}/api/messages/MsiSystem/ackReceive`, { mid: mid }).then(data => data)
        if (ackRec.status == 200) {
          // return ackRec.data
        }
      }

      return xmlres

      //   if( mid === mesData.mid){

      //   // const ackRec = await axios.post(`http://${serverConfig.HOST_IP}:${serverConfig.MESPort}/api/messages/MsiSystem/ackReceive`, {mid: mid})
      //   // console.log(`http://${serverConfig.HOST_IP}:${serverConfig.MESPortAck}/api/messages/MsiSystem/ackReceive`)
      //   // if (ackRec.statusCode == 200){
      //       //  if (!ackMode) {
      //     globalData.MESArray.splice(globalData.MESArray.findIndex(k => k.isPosted == false && k.isCompleted == true && k.DsNo == req.DsNo && k.menuName == req.menuName && k.TabIp == req.TabIp), 1)
      //     // await models.tbl_tab_initialmaster.update({ IsPosted: 1 }, { where: { RepSerNo: mesData.RepSerNo } })
      //     // await models.tbl_mesl) {
      //       setTimeout(() => mqttSender.sendData(mesData.DsNo, mesData.mqttProtocol), 1000);
      //     }
      //   // } else {
      //     // mesData.mid = mid
      //     // mesData.isPosted = true
      //     // await models.tbl_tab_data.destroy({ where: { DS_Number: mesData.selectedDSNo } });
      //     mqttSender.sendData(mesData.DsNo, `Port ${mesData.portNo}:${GLOBAL_NOMENCLATURE.DisplayMessage} ${GLOBAL_NOMENCLATURE.MESDataPosted}`);
      //     if (mesData.mqttProtoco_initialmaster.update({ IsPosted: 1 }, { where: { RepSerNo: mesData.RepSerNo } })
      //     // await models.tbl_mes_data.destroy({ where: { DS_Number: mesData.selectedDSNo } });
      //   // }



      // // } else {
      // //   if (!ackMode) {
      // //     globalData.MESArray.splice(globalData.MESArray.findIndex(k => k.isPosted == false && k.isCompleted == true && k.DsNo == req.DsNo && k.menuName == req.menuName && k.TabIp == req.TabIp), 1)
      // //     await models.tbl_tab_initialmaster.update({ IsPosted: 1 }, { where: { RepSerNo: req.RepSerNo } })
      // //     await models.tbl_mes_data.destroy({ where: { DS_Number: req.selectedDSNo } });
      // //     var right = await axios.post(`http://${serverConfig.hostApi}:${serverConfig.port}/api/MesPosting`, {
      // //       RepSerNo: "NA",
      // //       ReportOption: "NA",
      // //       Status: "Success"

      // //     });
      // //     mqttSender.sendData(req.DsNo, `Port ${req.portNo}:${GLOBAL_NOMENCLATURE.DisplayMessage} ${GLOBAL_NOMENCLATURE.MESDataPosted}`);
      // //     if (req.mqttProtocol) {
      // //       setTimeout(() => mqttSender.sendData(req.DsNo, req.mqttProtocol), 1000);
      // //     }
      // //   }
      // // }
      //     console.log("acknowledge is successful", mid)
      //   } else {
      //     console.log("something failed while acknowledge mid", mid)
      //   }

    } catch (error) {
      console.log('error: ', error);
    }
  }

  async createMESEntry(obj, cubicDSNumber) {
    try {
      let indFound = false;
      let grpFound = false;
      let hardFound = false;
      let thicknessFound = false;
      let friabFound = false;
      let DTFound = false;
      let diameterFound = false;
      let lengthFound = false;
      let MAFound = false;
      let verFound = false;

      // Individual Test
      if ((obj?.AWBID) && ((obj?.IndWtLow || obj?.IndWtLow == 0) && !isNaN(obj?.IndWtLow)) && ((obj?.IndWtHigh || obj?.IndWtHigh == 0) && !isNaN(obj?.IndWtHigh)) && (obj?.IndUnit)) {
        indFound = true;
      }
      // Group Test
      if ((obj?.AWBID) && ((obj?.GrpWtLow || obj?.GrpWtLow == 0) && !isNaN(obj?.GrpWtLow)) && ((obj?.GrpWtHigh || obj?.GrpWtHigh == 0) && !isNaN(obj?.GrpWtHigh)) && (obj?.GrpUnit)) {
        grpFound = true;
      }
      // Hardness Test
      if ((obj?.HTID) && ((obj?.HardnessLow || obj?.HardnessLow == 0) && !isNaN(obj?.HardnessLow)) && ((obj?.HardnessHigh || obj?.HardnessHigh == 0) && !isNaN(obj?.HardnessHigh)) && (obj?.HardUnit)) {
        hardFound = true;
      }
      // Thickness Test
      if (((obj?.ThicknessLow || obj?.ThicknessLow == 0) && !isNaN(obj?.ThicknessLow)) && ((obj?.ThicknessHigh || obj?.ThicknessHigh == 0) && !isNaN(obj?.ThicknessHigh))) {
        thicknessFound = true;
      }
      // Friability Test
      if ((obj?.FTID) && ((obj?.FriabilityLow || obj?.FriabilityLow == 0) && !isNaN(obj?.FriabilityLow)) && ((obj.FriabilityHigh || obj.FriabilityHigh == 0) && !isNaN(obj?.FriabilityHigh)) && (obj?.FriabUnit)) {
        friabFound = true;
      }
      // Disintegration Test
      if ((obj?.DTID) && ((obj?.DisintegrationLow || obj?.DisintegrationLow == 0) && !isNaN(obj?.DisintegrationLow)) && ((obj.DisintegrationHigh || obj.DisintegrationHigh == 0) && !isNaN(obj?.DisintegrationHigh))) {
        DTFound = true;
      }
      // Diameter
      if (((obj.DiameterHigh || obj.DiameterHigh == 0) && !isNaN(obj?.DiameterHigh)) && ((obj?.DiameterLow || obj?.DiameterLow == 0) && !isNaN(obj?.DiameterLow))) {
        diameterFound = true;
      }
      // Length
      if (((obj.LengthHigh || obj.LengthHigh == 0) && !isNaN(obj?.LengthHigh)) && ((obj.LengthLow || obj.LengthLow == 0) && !isNaN(obj?.LengthLow))) {
        lengthFound = true;
      }
      // Vernier
      if (obj?.VerId) {
        verFound = true;
      }
      // LOD
      if (obj?.MAID) {
        MAFound = true;
      }

      // const currentDateTimeString = moment(new Date()).format('YYYY-MM-DD HH:mm:ss');
      const currentDateTime = date.format(new Date(), 'YYYY-MM-DD HH:mm:ss');

      const mesRes = await models.tbl_mes_data.create({
        prDate: currentDateTime,
        BatchID: obj.BatchID,
        SFOID: obj.SFOID,
        Repetition: obj.Repetition,
        TestType: obj.TestType,
        MPN: obj.MPN,
        ProductId: obj.ProductId,
        ProductName: obj.ProductName,
        ProductType: obj.ProductType,
        Side: obj.Side,
        Container: obj.Container,
        DS_Number: cubicDSNumber, // DS_Number
        SampleCount: (obj?.SampleCount) ? obj.SampleCount : 0,
        GroupSampleCount: (obj?.GroupSampleCount) ? obj.GroupSampleCount : 0,
        StartSampleCount: (obj?.StartSampleCount) ? obj.StartSampleCount : 0,

        // Balance ID
        AWBID: (obj?.AWBID) ? obj.AWBID : "None",
        // Vernier ID
        VerId: (obj?.VerId) ? obj.VerId : "None",
        // LOD (Moisture Analyzer) (No parameter for LOD Test)
        MAID: (obj?.MAID) ? obj.MAID : "None",

        // Individual
        IndWtLow: (indFound) ? obj.IndWtLow : 99999,
        IndWtHigh: (indFound) ? obj.IndWtHigh : 99999,
        IndUnit: (indFound) ? obj.IndUnit : "",

        // Group
        GrpWtLow: (grpFound) ? obj.GrpWtLow : 99999,
        GrpWtHigh: (grpFound) ? obj.GrpWtHigh : 99999,
        GrpUnit: (grpFound) ? obj.GrpUnit : "",

        // Hardness
        HTID: (hardFound) ? obj.HTID : "None",
        HardnessLow: (hardFound) ? obj.HardnessLow : 99999,
        HardnessHigh: (hardFound) ? obj.HardnessHigh : 99999,
        HardUnit: (hardFound) ? obj.HardUnit : "",

        // Thickness
        ThicknessLow: (thicknessFound) ? obj.ThicknessLow : 99999,
        ThicknessHigh: (thicknessFound) ? obj.ThicknessHigh : 99999,
        ThicknessUnit: (thicknessFound) ? obj.ThicknessUnit : "",

        // Diameter
        DiameterLow: (diameterFound) ? obj.DiameterLow : 99999,
        DiameterHigh: (diameterFound) ? obj.DiameterHigh : 99999,
        DiameterUnit: (diameterFound) ? obj.DiameterUnit : "",

        // Length
        LengthLow: (lengthFound) ? obj.LengthLow : 99999,
        LengthHigh: (lengthFound) ? obj.LengthHigh : 99999,
        LengthUnit: (lengthFound) ? obj.LengthUnit : "",

        // Disintegration Test
        DTID: (DTFound) ? obj.DTID : "None",
        DisintegrationLow: (DTFound) ? obj.DisintegrationLow : 99999,
        DisintegrationHigh: (DTFound) ? obj.DisintegrationHigh : 99999,

        // Friability Test
        FTID: (friabFound) ? obj.FTID : "None",
        FriabilityLow: (friabFound) ? obj.FriabilityLow : 99999,
        FriabilityHigh: (friabFound) ? obj.FriabilityHigh : 99999,
        FriabUnit: (friabFound) ? obj.FriabUnit : "",

        // GrpWtEqmID: (grpFound) ? obj.GrpWtEqmID : "None",
      })

      return mesRes.dataValues;
    } catch (error) {
      console.log('error: ', error);
    }
  }

  async createAuditAndCheckLimit(productLimitRes, mesEntryRes) {
    let oldValueComp = '', newValueComp = '', isLimitChanged = false
    const tblProductTabletTempObj = {}

    // Individual
    if (Number(mesEntryRes.IndWtLow) != 99999 && (Number(mesEntryRes.IndWtHigh) != 99999)) {
      // Individual Low
      if ((Number(productLimitRes.Param1_T2Neg) != Number(mesEntryRes.IndWtLow))) {
        if (Number(productLimitRes.Param1_T2Neg) != 99999) {
          isLimitChanged = true
          oldValueComp += `Individual - Lower Limit: ${productLimitRes.Param1_T2Neg},`
          tblProductTabletTempObj.Param1_T2Neg = Number(mesEntryRes.IndWtLow);
        } else {
          if (oldValueComp == 'NA' || oldValueComp == '') {
            oldValueComp = 'NA';
          }
        }
        newValueComp += `Individual - Lower Limit: ${mesEntryRes.IndWtLow},`
      }

      // Individual High
      if ((Number(productLimitRes.Param1_T2Pos) != Number(mesEntryRes.IndWtHigh))) {
        if (Number(productLimitRes.Param1_T2Pos) != 99999) {
          isLimitChanged = true
          oldValueComp += `Upper Limit: ${productLimitRes.Param1_T2Pos},`
          tblProductTabletTempObj.Param1_T2Pos = Number(mesEntryRes.IndWtHigh);
        } else {
          if (oldValueComp == 'NA' || oldValueComp == '') {
            oldValueComp = 'NA';
          }
        }
        newValueComp += `Upper Limit: ${mesEntryRes.IndWtHigh},`
      }
    }

    // Group
    if (Number(mesEntryRes.GrpWtLow) != 99999 && (Number(mesEntryRes.GrpWtHigh) != 99999)) {
      // Group Low
      if ((Number(productLimitRes.Param2_T2Neg) != Number(mesEntryRes.GrpWtLow))) {
        if (Number(productLimitRes.Param2_T2Neg) != 99999) {
          isLimitChanged = true
          oldValueComp += `Group - Lower Limit: ${productLimitRes.Param2_T2Neg},`
          tblProductTabletTempObj.Param2_T2Neg = Number(mesEntryRes.GrpWtLow);
        } else {
          if (oldValueComp == 'NA' || oldValueComp == '') {
            oldValueComp = 'NA';
          }
        }
        newValueComp += `Group - Lower Limit: ${mesEntryRes.GrpWtLow},`
      }

      // Group High
      if ((Number(productLimitRes.Param2_T2Pos) != Number(mesEntryRes.GrpWtHigh))) {
        if (Number(productLimitRes.Param2_T2Pos) != 99999) {
          isLimitChanged = true
          oldValueComp += `Upper Limit: ${productLimitRes.Param2_T2Pos},`
          tblProductTabletTempObj.Param2_T2Pos = Number(mesEntryRes.GrpWtHigh);
        } else {
          if (oldValueComp == 'NA' || oldValueComp == '') {
            oldValueComp = 'NA';
          }
        }
        newValueComp += `Upper Limit: ${mesEntryRes.GrpWtHigh},`
      }
    }

    // Hardness
    if (Number(mesEntryRes.HardnessLow) != 99999 && (Number(mesEntryRes.HardnessLow) != 99999)) {
      // Hardness Low
      if ((Number(productLimitRes.Param7_T2Neg) != Number(mesEntryRes.HardnessLow))) {
        if (Number(productLimitRes.Param7_T2Neg) != 99999) {
          isLimitChanged = true
          oldValueComp += `Group - Lower Limit: ${productLimitRes.Param7_T2Neg},`
          tblProductTabletTempObj.Param7_T2Neg = Number(mesEntryRes.HardnessLow);
        } else {
          if (oldValueComp == 'NA' || oldValueComp == '') {
            oldValueComp = 'NA';
          }
        }
        newValueComp += `Group - Lower Limit: ${mesEntryRes.HardnessLow},`
      }

      // Hardness High
      if ((Number(productLimitRes.Param7_T2Pos) != Number(mesEntryRes.HardnessHigh))) {
        if (Number(productLimitRes.Param7_T2Pos) != 99999) {
          isLimitChanged = true
          oldValueComp += `Upper Limit: ${productLimitRes.Param7_T2Pos},`
          tblProductTabletTempObj.Param7_T2Pos = Number(mesEntryRes.HardnessHigh);
        } else {
          if (oldValueComp == 'NA' || oldValueComp == '') {
            oldValueComp = 'NA';
          }
        }
        newValueComp += `Upper Limit: ${mesEntryRes.HardnessHigh},`
      }
    }

    // Thickness
    if (Number(mesEntryRes.Param3_T2Neg) != 99999 && (Number(mesEntryRes.ThicknessHigh) != 99999)) {
      // Thickness Low
      if ((Number(productLimitRes.Param3_T2Neg) != Number(mesEntryRes.ThicknessLow))) {
        if (Number(productLimitRes.Param3_T2Neg) != 99999) {
          isLimitChanged = true
          oldValueComp += `Group - Lower Limit: ${productLimitRes.Param3_T2Neg},`
          tblProductTabletTempObj.Param3_T2Neg = Number(mesEntryRes.Param3_T2Neg);
        } else {
          if (oldValueComp == 'NA' || oldValueComp == '') {
            oldValueComp = 'NA';
          }
        }
        newValueComp += `Group - Lower Limit: ${mesEntryRes.ThicknessLow},`
      }

      // Thickness High
      if ((Number(productLimitRes.Param3_T2Pos) != Number(mesEntryRes.ThicknessHigh))) {
        if (Number(productLimitRes.Param3_T2Pos) != 99999) {
          isLimitChanged = true
          oldValueComp += `Upper Limit: ${productLimitRes.Param3_T2Pos},`
          tblProductTabletTempObj.Param3_T2Pos = Number(mesEntryRes.ThicknessHigh);
        } else {
          if (oldValueComp == 'NA' || oldValueComp == '') {
            oldValueComp = 'NA';
          }
        }
        newValueComp += `Upper Limit: ${mesEntryRes.ThicknessHigh},`
      }
    }

    // Friability
    if (Number(mesEntryRes.FriabilityLow) != 99999 && (Number(mesEntryRes.FriabilityHigh) != 99999)) {
      // Friability Low
      if ((Number(productLimitRes.Param8_T1Neg) != Number(mesEntryRes.FriabilityLow))) {
        if (Number(productLimitRes.Param8_T1Neg) != 99999) {
          isLimitChanged = true
          oldValueComp += `Friability - Lower Limit: ${productLimitRes.Param8_T1Neg},`
          tblProductTabletTempObj.Param8_T1Neg = Number(mesEntryRes.FriabilityLow);
        } else {
          if (oldValueComp == 'NA' || oldValueComp == '') {
            oldValueComp = 'NA';
          }
        }
        newValueComp += `Friability - Lower Limit: ${mesEntryRes.FriabilityLow},`
      }

      // Friability High
      if ((Number(productLimitRes.Param8_T1Pos) != Number(mesEntryRes.FriabilityHigh))) {
        if (Number(productLimitRes.Param8_T1Pos) != 99999) {
          isLimitChanged = true
          oldValueComp += `Upper Limit: ${productLimitRes.Param8_T1Pos},`
          tblProductTabletTempObj.Param8_T1Pos = Number(mesEntryRes.FriabilityHigh);
        } else {
          if (oldValueComp == 'NA' || oldValueComp == '') {
            oldValueComp = 'NA';
          }
        }
        newValueComp += `Upper Limit: ${mesEntryRes.FriabilityHigh},`
      }
    }

    // Disintegration
    if (Number(mesEntryRes.DisintegrationLow) != 99999 && (Number(mesEntryRes.DisintegrationHigh) != 99999)) {
      // Disintegration Low
      if ((Number(productLimitRes.Param13_T1Neg) != Number(mesEntryRes.DisintegrationLow))) {
        if (Number(productLimitRes.Param13_T1Neg) != 99999) {
          isLimitChanged = true
          oldValueComp += `DT - Lower Limit: ${productLimitRes.Param13_T1Neg},`
          tblProductTabletTempObj.Param13_T1Neg = Number(mesEntryRes.DisintegrationLow);
        } else {
          if (oldValueComp == 'NA' || oldValueComp == '') {
            oldValueComp = 'NA';
          }
        }
        newValueComp += `DT - Lower Limit: ${mesEntryRes.DisintegrationLow},`
      }

      // Disintegration High
      if ((Number(productLimitRes.Param13_T1Pos) != Number(mesEntryRes.DisintegrationHigh))) {
        if (Number(productLimitRes.Param13_T1Pos) != 99999) {
          isLimitChanged = true
          oldValueComp += `Upper Limit: ${productLimitRes.Param13_T1Pos},`
          tblProductTabletTempObj.Param13_T1Pos = Number(mesEntryRes.DisintegrationHigh);
        } else {
          if (oldValueComp == 'NA' || oldValueComp == '') {
            oldValueComp = 'NA';
          }
        }
        newValueComp += `Upper Limit: ${mesEntryRes.DisintegrationHigh},`
      }
    }

    // Length
    if (Number(mesEntryRes.LengthLow) != 99999 && (Number(mesEntryRes.LengthHigh) != 99999)) {
      // Length Low
      if ((Number(productLimitRes.Param5_T2Neg) != Number(mesEntryRes.LengthLow))) {
        if (Number(productLimitRes.Param5_T2Neg) != 99999) {
          isLimitChanged = true
          oldValueComp += `Group - Lower Limit: ${productLimitRes.Param5_T2Neg},`
          tblProductTabletTempObj.Param5_T2Neg = Number(mesEntryRes.LengthLow);
        } else {
          if (oldValueComp == 'NA' || oldValueComp == '') {
            oldValueComp = 'NA';
          }
        }
        newValueComp += `Group - Lower Limit: ${mesEntryRes.LengthLow},`
      }

      // Length High
      if ((Number(productLimitRes.Param5_T2Pos) != Number(mesEntryRes.LengthHigh))) {
        if (Number(productLimitRes.Param5_T2Pos) != 99999) {
          isLimitChanged = true
          oldValueComp += `Upper Limit: ${productLimitRes.Param5_T2Pos},`
          tblProductTabletTempObj.Param5_T2Pos = Number(mesEntryRes.LengthHigh);
        } else {
          if (oldValueComp == 'NA' || oldValueComp == '') {
            oldValueComp = 'NA';
          }
        }
        newValueComp += `Upper Limit: ${mesEntryRes.LengthHigh},`
      }
    }

    // Diameter
    if (Number(mesEntryRes.DiameterLow) != 99999 && (Number(mesEntryRes.DiameterHigh) != 99999)) {
      // Diameter Low
      if ((Number(productLimitRes.Param4_T2Neg) != Number(mesEntryRes.DiameterLow))) {
        if (Number(productLimitRes.Param4_T2Neg) != 99999) {
          isLimitChanged = true
          oldValueComp += `Group - Lower Limit: ${productLimitRes.Param4_T2Neg},`
          tblProductTabletTempObj.Param4_T2Neg = Number(mesEntryRes.DiameterLow);
        } else {
          if (oldValueComp == 'NA' || oldValueComp == '') {
            oldValueComp = 'NA';
          }
        }
        newValueComp += `Group - Lower Limit: ${mesEntryRes.DiameterLow},`
      }

      // Diameter High
      if ((Number(productLimitRes.Param4_T2High) != Number(mesEntryRes.DiameterHigh))) {
        if (Number(productLimitRes.Param4_T2High) != 99999) {
          isLimitChanged = true
          oldValueComp += `Upper Limit: ${productLimitRes.Param4_T2High},`
          tblProductTabletTempObj.Param4_T2High = Number(mesEntryRes.DiameterHigh);
        } else {
          if (oldValueComp == 'NA' || oldValueComp == '') {
            oldValueComp = 'NA';
          }
        }
        newValueComp += `Upper Limit: ${mesEntryRes.DiameterHigh},`
      }
    }

    // LOD
    // if (Number(mesEntryRes.InitialWeight) != 99999 && (Number(mesEntryRes.FinalWeight) != 99999)) {
    //   // LOD Low
    //   if ((Number(productLimitRes.Param16_T1Neg) != Number(mesEntryRes.InitialWeight))) {
    //     if (Number(productLimitRes.Param16_T1Neg) != 99999) {
    //       isLimitChanged = true
    //       oldValueComp += `Group - Lower Limit: ${productLimitRes.Param16_T1Neg},`
    //     } else {
    //       if (oldValueComp == 'NA' || oldValueComp == '') {
    //         oldValueComp = 'NA';
    //       }
    //     }
    //     newValueComp += `Group - Lower Limit: ${mesEntryRes.InitialWeight},`
    //   }

    //   // LOD High
    //   if ((Number(productLimitRes.Param16_T1Pos) != Number(mesEntryRes.FinalWeight))) {
    //     if (Number(productLimitRes.Param16_T1Pos) != 99999) {
    //       isLimitChanged = true
    //       oldValueComp += `Upper Limit: ${productLimitRes.Param16_T1Pos},`
    //     } else {
    //       if (oldValueComp == 'NA' || oldValueComp == '') {
    //         oldValueComp = 'NA';
    //       }
    //     }
    //     newValueComp += `Upper Limit: ${mesEntryRes.FinalWeight},`
    //   }
    // }

    let tempNewValueComp = ""
    if (newValueComp != '') tempNewValueComp = newValueComp.slice(0, newValueComp.length - 1)

    if (newValueComp != "") {
      await models.tbl_audit_product.create({
        ProductId: mesEntryRes.ProductId,
        ProductName: mesEntryRes.ProductName,
        OldValueComp: oldValueComp,
        NewValueComp: tempNewValueComp,
        DT: moment().format('YYYY-MM-DD'),
        TM: moment().format('HH:mm:ss.SSSSSSS'),
        userd: "",
        username: "",
        ACT: "Update from MES",
        Remark: "",
      });
    }

    if (isLimitChanged) {
      await models.tbl_product_tablet_temp.update(tblProductTabletTempObj, {
        where: {
          ProductId: productLimitRes.ProductId,
          ProductName: productLimitRes.ProductName
        }
      })
    }

    return isLimitChanged;
  }

  // async checkProductLimits(productLimitRes, mesEntryRes) {
  //   let isLimitChanged = false
  //   // Individual
  //   if ((Number(productLimitRes.Param1_T2Neg) != Number(mesEntryRes.IndWtLow)) && (Number(productLimitRes.Param1_T2Neg) != 99999) || (Number(productLimitRes.Param1_T2Pos) != Number(mesEntryRes.IndWtHigh)) && (Number(productLimitRes.Param1_T2Pos) != 99999)) {
  //     isLimitChanged = true
  //   }
  //   // Group
  //   else if ((Number(productLimitRes.Param2_T2Neg) != Number(mesEntryRes.GrpWtLow)) && (Number(productLimitRes.Param2_T2Neg) != 99999) || (Number(productLimitRes.Param2_T2Pos) != Number(mesEntryRes.GrpWtHigh)) && (Number(productLimitRes.Param2_T2Pos) != 99999)) {
  //     isLimitChanged = true
  //   }
  //   // Thickness
  //   else if ((Number(productLimitRes.Param3_T2Neg) != Number(mesEntryRes.ThicknessLow)) && (Number(productLimitRes.Param3_T2Neg) != 99999) || (Number(productLimitRes.Param3_T2Pos) != Number(mesEntryRes.ThicknessHigh)) && (Number(productLimitRes.Param3_T2Pos) != 99999)) {
  //     isLimitChanged = true
  //   }
  //   // Diameter
  //   else if ((Number(productLimitRes.Param6_T2Neg) != Number(mesEntryRes.HardDiameterLow)) && (Number(productLimitRes.Param6_T2Neg) != 99999) || (Number(productLimitRes.Param6_T2Pos) != Number(mesEntryRes.HardDiameterHigh)) && (Number(productLimitRes.Param6_T2Pos) != 99999)) {
  //     isLimitChanged = true
  //   }
  //   // Length
  //   else if ((Number(productLimitRes.Param5_T2Neg) != Number(mesEntryRes.HardLengthLow)) && (Number(productLimitRes.Param5_T2Neg) != 99999) || (Number(productLimitRes.Param5_T2Pos) != Number(mesEntryRes.HardLengthHigh)) && (Number(productLimitRes.Param5_T2Pos) != 99999)) {
  //     isLimitChanged = true
  //   }
  //   // Hardness
  //   else if ((Number(productLimitRes.Param7_T2Neg) != Number(mesEntryRes.HardnessLow)) && (Number(productLimitRes.Param7_T2Neg) != 99999) || (Number(productLimitRes.Param7_T2Pos) != Number(mesEntryRes.HardnessHigh)) && (Number(productLimitRes.Param7_T2Pos) != 99999)) {
  //     isLimitChanged = true
  //   }
  //   // LOD
  //   else if ((Number(productLimitRes.Param16_T1Neg) != Number(mesEntryRes.InitialWeight)) && (Number(productLimitRes.Param16_T1Neg) != 99999) || (Number(productLimitRes.FinalWeight) != Number(mesEntryRes.FinalWeight)) && (Number(productLimitRes.Param16_T1Pos) != 99999)) {
  //     isLimitChanged = true
  //   }

  //   return isLimitChanged
  // }

  async updateProductLimits(productMasterRes, mesEntryRes) {
    // console.log('mesEntryRes: ', mesEntryRes);

    try {
      await models.tbl_product_tablet.update(
        {
          // Individual
          Param1_T2Neg: Number(mesEntryRes.IndWtLow) != 99999 ? Number(mesEntryRes.IndWtLow) : 99999,
          Param1_T2Pos: Number(mesEntryRes.IndWtHigh) != 99999 ? Number(mesEntryRes.IndWtHigh) : 99999,
          Param1_Unit: mesEntryRes.IndUnit,
          // Group
          Param2_T2Neg: Number(mesEntryRes.GrpWtLow) != 99999 ? Number(mesEntryRes.GrpWtLow) : 99999,
          Param2_T2Pos: Number(mesEntryRes.GrpWtHigh) != 99999 ? Number(mesEntryRes.GrpWtHigh) : 99999,
          Param2_Unit: mesEntryRes.GrpUnit,
          // Thickness
          Param3_T2Neg: Number(mesEntryRes.ThicknessLow) != 99999 ? Number(mesEntryRes.ThicknessLow) : 99999,
          Param3_T2Pos: Number(mesEntryRes.ThicknessHigh) != 99999 ? Number(mesEntryRes.ThicknessHigh) : 99999,
          Param3_Unit: mesEntryRes.ThicknessUnit,
          // Diameter
          Param6_T2Pos: Number(mesEntryRes.DiameterLow) != 99999 ? Number(mesEntryRes.DiameterLow) : 99999,
          Param6_T2Neg: Number(mesEntryRes.DiameterHigh) != 99999 ? Number(mesEntryRes.DiameterHigh) : 99999,
          Param6_Unit: mesEntryRes.DiameterUnit,
          // Length
          Param5_T2Neg: Number(mesEntryRes.LengthLow) != 99999 ? Number(mesEntryRes.LengthLow) : 99999,
          Param5_T2Pos: Number(mesEntryRes.LengthHigh) != 99999 ? Number(mesEntryRes.LengthHigh) : 99999,
          Param5_Unit: mesEntryRes.LengthUnit,
          // Hardness
          Param7_T2Neg: Number(mesEntryRes.HardnessLow) != 99999 ? Number(mesEntryRes.HardnessLow) : 99999,
          Param7_T2Pos: Number(mesEntryRes.HardnessHigh) != 99999 ? Number(mesEntryRes.HardnessHigh) : 99999,
          Param7_Unit: mesEntryRes.HardUnit,
          // Friability
          Param8_T1Neg: Number(mesEntryRes.FriabilityLow) != 99999 ? Number(mesEntryRes.FriabilityLow) : 99999,
          Param8_T1Pos: Number(mesEntryRes.FriabilityHigh) != 99999 ? Number(mesEntryRes.FriabilityHigh) : 99999,
          Param8_Unit: mesEntryRes.FriabUnit,
          // DT
          Param13_T1Neg: Number(mesEntryRes.DisintegrationLow) != 99999 ? Number(mesEntryRes.DisintegrationLow) : 99999,
          Param13_T1Pos: Number(mesEntryRes.DisintegrationHigh) != 99999 ? Number(mesEntryRes.DisintegrationHigh) : 99999,
          // LOD
          // Param16_T1Neg: Number(mesEntryRes.InitialWeight) != 99999 ? Number(mesEntryRes.InitialWeight) : 99999,
          // Param16_T1Pos: Number(mesEntryRes.FinalWeight) != 99999 ? Number(mesEntryRes.FinalWeight) : 99999,
          // Param16_Unit: "",
        }, {
        where: {
          [Op.or]: [
            { ProductId: productMasterRes.ProductId },
            // { MPN_Code: productMasterRes.MPN_Code }
          ],
          ProductName: productMasterRes.ProductName,
        }
      });
    } catch (error) {
      console.log('error: ', error);
    }
  }

  async updateCubical(DSNumber, mesEntryRes) {
    try {
      let testType = 0;
      if (mesEntryRes.TestType == "Initial") {
        testType = 1;
      }

      await models.tbl_cubical.update(
        {
          Sys_Batch: mesEntryRes.BatchID,
          Sys_BFGCode: mesEntryRes.ProductId,
          Sys_ProductName: mesEntryRes.ProductName,
          Sys_RptType: testType,
          Sys_SFOID: mesEntryRes.SFOID,
          Sys_Repetition: mesEntryRes.Repetition,
          Sys_RotaryType: mesEntryRes.Side
        },
        {
          where: {
            Sys_DSNumber: DSNumber,
          },
        }
      );
    } catch (error) {
      console.log('error: ', error);
    }

  }

  async updateSampleNo(cubicNo, mesEntryRes) {
    let commonSampleCount = 0;
    let grpSampleCount = 0;
    if (mesEntryRes.TestType == "Inprocess") {
      commonSampleCount = mesEntryRes.SampleCount;
    } else {
      commonSampleCount = mesEntryRes.StartSampleCount;
      grpSampleCount = mesEntryRes.GroupSampleCount;
    }

    try {
      await models.tbl_cubicle_product_sample.update({
        Individual: commonSampleCount,
        Group: (mesEntryRes.TestType == "Inprocess") ? commonSampleCount : grpSampleCount,
        Hardness: commonSampleCount,
        Thickness: commonSampleCount,
        Diameter: commonSampleCount,
        Length: commonSampleCount,
        Friability: commonSampleCount,
      }, {
        where: {
          Sys_CubicNo: cubicNo,
        }
      });
    } catch (error) {
      console.log('error: ', error);
    }
  }

  async acknowledge(req) {

  }

  async generateToken(req) {

    const { username, password } = req;

    let user = "werumsez"
    let tokenID = oAuth2.sign({ username }, password, { expiresIn: '1h', algorithm: 'none' });

    // Send the token, token_type, and expiry time in the response
    var expiresIn = new Date();
    expiresIn.setHours(expiresIn.getHours() + 1);
    expiresIn = Date.parse(expiresIn) / 1000

    if (globalData.generatedToken.length != 0) {
      globalData.generatedToken.splice(0, 1, tokenID)
    } else {
      globalData.generatedToken.push(tokenID)
    }

    console.log("token generated", username)

    return ({
      access_token: tokenID,
      token_type: 'Bearer',
      expires_in: expiresIn,
    });

  }

}

module.exports = ackModel;
