/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import javax.net.ssl.SSLSocket;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;
import oracle.net.ns.NetException;

public class TcpsConfigure {
    static final boolean DEBUG = false;
    public static final String[] VALID_SSL_VERSION_STRINGS = new String[]{"0", "undetermined", "2", "2.0", "version 2", "3", "3.0", "version 3 only", "1", "1.0", "version 1 only", "1 or 3", "1.0 or 3.0", "version 1 or version 3"};
    public static final String[][] TABLE_ENABLED_SSL_PROTOCOLS = new String[][]{{"TLSv1", "SSLv3", "SSLv2Hello"}, {"SSLv2Hello"}, {"SSLv3"}, {"TLSv1"}, {"TLSv1", "SSLv3"}};
    public static final int[] VALID_SSL_STRING_TO_PROTOCOLS_MAP = new int[]{0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};

    private TcpsConfigure() {
    }

    public static void configureVersion(SSLSocket sSLSocket, String string) throws NetException, IOException {
        Object object;
        if (string == null) {
            string = System.getProperty("oracle.net.ssl_version");
        }
        int n = 0;
        if (string != null) {
            string = string.startsWith("(") && string.endsWith(")") ? "(ssl_version=" + string.substring(1) : "(ssl_version=" + string + ")";
            try {
                object = new NVFactory().createNVPair(string);
                String string2 = ((NVPair)object).getAtom();
                for (int i = 0; i < VALID_SSL_VERSION_STRINGS.length; ++i) {
                    if (!string2.equalsIgnoreCase(VALID_SSL_VERSION_STRINGS[i])) continue;
                    n = i;
                    break;
                }
            }
            catch (NLException nLException) {
                throw new NetException(400, string);
            }
        }
        if (n >= VALID_SSL_VERSION_STRINGS.length) {
            throw new NetException(400);
        }
        object = TABLE_ENABLED_SSL_PROTOCOLS[VALID_SSL_STRING_TO_PROTOCOLS_MAP[n]];
        try {
            sSLSocket.setEnabledProtocols((String[])object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new NetException(401, illegalArgumentException.toString());
        }
    }

    public static void configureCipherSuites(SSLSocket sSLSocket, String string) throws NetException, IOException {
        if (string == null) {
            string = System.getProperty("oracle.net.ssl_cipher_suites");
        }
        if (string == null) {
            return;
        }
        string = string.startsWith("(") && string.endsWith(")") ? "(cipher_suites=" + string + ")" : "(cipher_suites=(" + string + "))";
        try {
            NVPair nVPair = new NVFactory().createNVPair(string);
            String[] stringArray = new String[nVPair.getListSize()];
            if (nVPair.getRHSType() == NVPair.LIST_COMMASEP || nVPair.getRHSType() == NVPair.RHS_LIST) {
                for (int i = 0; i < nVPair.getListSize(); ++i) {
                    stringArray[i] = nVPair.getListElement(i).getName();
                }
            } else {
                throw new NetException(403, string);
            }
            sSLSocket.setEnabledCipherSuites(stringArray);
        }
        catch (NLException nLException) {
            throw new NetException(403, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new NetException(404, illegalArgumentException.toString());
        }
    }

    public static boolean matchServerDN(String string, String string2, boolean bl) {
        if ((string = TcpsConfigure.normalizeDN(string)) == null) {
            return false;
        }
        if (bl) {
            if ((string2 = TcpsConfigure.normalizeDN(string2)) == null) {
                return false;
            }
            if (string2.equals(string)) {
                return true;
            }
            return string2.equals(string = TcpsConfigure.reverseDN(string));
        }
        int n = string.indexOf("CN=");
        return n != -1 && string2.equals(string = string.indexOf(44, n) != -1 ? string.substring(n, string.indexOf(44, n)) : string.substring(n));
    }

    public static String normalizeDN(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        String string3 = null;
        int n = 0;
        int n2 = 0;
        string = string.trim();
        while ((n = string.indexOf(61, n)) != -1) {
            string2 = string.substring(n2, n);
            string2 = string2.trim();
            stringBuffer.append(string2.toUpperCase());
            stringBuffer.append('=');
            n2 = n;
            if (n2 >= string.length() - 1) {
                return null;
            }
            if ((n = string.indexOf(44, n)) == -1) {
                string3 = string.substring(n2 + 1);
                stringBuffer.append(string3.trim());
                break;
            }
            string3 = string.substring(n2 + 1, n);
            stringBuffer.append(string3.trim());
            stringBuffer.append(',');
            if (n >= string.length() - 1) {
                return null;
            }
            n2 = n + 1;
        }
        return stringBuffer.toString();
    }

    public static String reverseDN(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        int n2 = n = string.length();
        do {
            if ((n = string.lastIndexOf(44, n)) == -1) {
                stringBuffer.append(string.substring(0, n2));
                break;
            }
            string2 = string.substring(n + 1, n2);
            stringBuffer.append(string2);
            stringBuffer.append(',');
            n2 = n--;
        } while (n != -1);
        return stringBuffer.toString();
    }
}

