/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.ColumnValuesIterator;
import net.sf.jasperreports.data.cache.ValueTransformer;

public class TransformedColumnValues
implements ColumnValues,
Serializable {
    private static final long serialVersionUID = 10200L;
    private ColumnValues rawValues;
    private ValueTransformer transformer;

    public TransformedColumnValues(ColumnValues rawValues, ValueTransformer transformer) {
        this.rawValues = rawValues;
        this.transformer = transformer;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUnshared(this.rawValues);
        out.writeObject(this.transformer);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.rawValues = (ColumnValues)in.readUnshared();
        this.transformer = (ValueTransformer)in.readObject();
    }

    @Override
    public int size() {
        return this.rawValues.size();
    }

    @Override
    public ColumnValuesIterator iterator() {
        return new TransformedIterator();
    }

    protected class TransformedIterator
    implements ColumnValuesIterator {
        private final ColumnValuesIterator rawIterator;

        public TransformedIterator() {
            this.rawIterator = TransformedColumnValues.this.rawValues.iterator();
        }

        @Override
        public void moveFirst() {
            this.rawIterator.moveFirst();
        }

        @Override
        public boolean next() {
            return this.rawIterator.next();
        }

        @Override
        public Object get() {
            Object rawValue = this.rawIterator.get();
            return TransformedColumnValues.this.transformer.get(rawValue);
        }
    }
}

