/**
 * math.js
 * https://github.com/josdejong/mathjs
 *
 * Math.js is an extensive math library for JavaScript and Node.js,
 * It features real and complex numbers, units, matrices, a large set of
 * mathematical functions, and a flexible expression parser.
 *
 * @version 7.6.0
 * @date    2020-11-02
 *
 * @license
 * Copyright (C) 2013-2020 Jos de Jong <wjosdejong@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.math=t():e.math=t()}(this,function(){return n={},i.m=r=[function(e,t,r){"use strict";r.d(t,"a",function(){return n}),r.d(t,"b",function(){return i}),r.d(t,"c",function(){return o});r(2);var a=r(3);function n(r,n,i,e){function t(e){var t=Object(a.j)(e,n.map(o));return function(e,t,r){if(!t.filter(function(e){return!((e=e)&&"?"===e[0])}).every(function(e){return void 0!==r[e]})){t=t.filter(function(e){return void 0===r[e]});throw new Error('Cannot create function "'.concat(e,'", ')+"some dependencies are missing: ".concat(t.map(function(e){return'"'.concat(e,'"')}).join(", "),"."))}}(r,n,e),i(t)}return t.isFactory=!0,t.fn=r,t.dependencies=n.slice().sort(),e&&(t.meta=e),t}function i(e){return"function"==typeof e&&"string"==typeof e.fn&&Array.isArray(e.dependencies)}function o(e){return e&&"?"===e[0]?e.slice(1):e}},function(e,t,r){"use strict";function n(e){return(n="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function i(e){return"number"==typeof e}function a(e){return e&&!0===e.constructor.prototype.isBigNumber||!1}function o(e){return e&&"object"===n(e)&&!0===Object.getPrototypeOf(e).isComplex||!1}function s(e){return e&&"object"===n(e)&&!0===Object.getPrototypeOf(e).isFraction||!1}function u(e){return e&&!0===e.constructor.prototype.isUnit||!1}function c(e){return"string"==typeof e}r.d(t,"y",function(){return i}),r.d(t,"e",function(){return a}),r.d(t,"j",function(){return o}),r.d(t,"o",function(){return s}),r.d(t,"L",function(){return u}),r.d(t,"I",function(){return c}),r.d(t,"b",function(){return f}),r.d(t,"v",function(){return l}),r.d(t,"i",function(){return p}),r.d(t,"n",function(){return m}),r.d(t,"H",function(){return h}),r.d(t,"D",function(){return d}),r.d(t,"t",function(){return y}),r.d(t,"g",function(){return g}),r.d(t,"G",function(){return b}),r.d(t,"s",function(){return v}),r.d(t,"p",function(){return x}),r.d(t,"m",function(){return w}),r.d(t,"F",function(){return N}),r.d(t,"z",function(){return O}),r.d(t,"x",function(){return M}),r.d(t,"K",function(){return j}),r.d(t,"a",function(){return E}),r.d(t,"c",function(){return S}),r.d(t,"d",function(){return A}),r.d(t,"f",function(){return C}),r.d(t,"k",function(){return _}),r.d(t,"l",function(){return T}),r.d(t,"q",function(){return q}),r.d(t,"r",function(){return I}),r.d(t,"u",function(){return B}),r.d(t,"w",function(){return k}),r.d(t,"A",function(){return z}),r.d(t,"B",function(){return D}),r.d(t,"C",function(){return R}),r.d(t,"E",function(){return U}),r.d(t,"J",function(){return P}),r.d(t,"h",function(){return F}),r.d(t,"M",function(){return L});var f=Array.isArray;function l(e){return e&&!0===e.constructor.prototype.isMatrix||!1}function p(e){return Array.isArray(e)||l(e)}function m(e){return e&&e.isDenseMatrix&&!0===e.constructor.prototype.isMatrix||!1}function h(e){return e&&e.isSparseMatrix&&!0===e.constructor.prototype.isMatrix||!1}function d(e){return e&&!0===e.constructor.prototype.isRange||!1}function y(e){return e&&!0===e.constructor.prototype.isIndex||!1}function g(e){return"boolean"==typeof e}function b(e){return e&&!0===e.constructor.prototype.isResultSet||!1}function v(e){return e&&!0===e.constructor.prototype.isHelp||!1}function x(e){return"function"==typeof e}function w(e){return e instanceof Date}function N(e){return e instanceof RegExp}function O(e){return!(!e||"object"!==n(e)||e.constructor!==Object||o(e)||s(e))}function M(e){return null===e}function j(e){return void 0===e}function E(e){return e&&!0===e.isAccessorNode&&!0===e.constructor.prototype.isNode||!1}function S(e){return e&&!0===e.isArrayNode&&!0===e.constructor.prototype.isNode||!1}function A(e){return e&&!0===e.isAssignmentNode&&!0===e.constructor.prototype.isNode||!1}function C(e){return e&&!0===e.isBlockNode&&!0===e.constructor.prototype.isNode||!1}function _(e){return e&&!0===e.isConditionalNode&&!0===e.constructor.prototype.isNode||!1}function T(e){return e&&!0===e.isConstantNode&&!0===e.constructor.prototype.isNode||!1}function q(e){return e&&!0===e.isFunctionAssignmentNode&&!0===e.constructor.prototype.isNode||!1}function I(e){return e&&!0===e.isFunctionNode&&!0===e.constructor.prototype.isNode||!1}function B(e){return e&&!0===e.isIndexNode&&!0===e.constructor.prototype.isNode||!1}function k(e){return e&&!0===e.isNode&&!0===e.constructor.prototype.isNode||!1}function z(e){return e&&!0===e.isObjectNode&&!0===e.constructor.prototype.isNode||!1}function D(e){return e&&!0===e.isOperatorNode&&!0===e.constructor.prototype.isNode||!1}function R(e){return e&&!0===e.isParenthesisNode&&!0===e.constructor.prototype.isNode||!1}function U(e){return e&&!0===e.isRangeNode&&!0===e.constructor.prototype.isNode||!1}function P(e){return e&&!0===e.isSymbolNode&&!0===e.constructor.prototype.isNode||!1}function F(e){return e&&!0===e.constructor.prototype.isChain||!1}function L(e){var t=n(e);return"object"===t?null===e?"null":Array.isArray(e)?"Array":e instanceof Date?"Date":e instanceof RegExp?"RegExp":a(e)?"BigNumber":o(e)?"Complex":s(e)?"Fraction":l(e)?"Matrix":u(e)?"Unit":y(e)?"Index":d(e)?"Range":b(e)?"ResultSet":k(e)?e.type:F(e)?"Chain":v(e)?"Help":"Object":"function"===t?"Function":t}},function(e,t,r){"use strict";r.d(t,"a",function(){return s}),r.d(t,"p",function(){return c}),r.d(t,"q",function(){return f}),r.d(t,"m",function(){return l}),r.d(t,"l",function(){return p}),r.d(t,"n",function(){return m}),r.d(t,"o",function(){return h}),r.d(t,"e",function(){return d}),r.d(t,"k",function(){return y}),r.d(t,"f",function(){return g}),r.d(t,"c",function(){return b}),r.d(t,"d",function(){return v}),r.d(t,"j",function(){return x}),r.d(t,"i",function(){return w}),r.d(t,"g",function(){return N}),r.d(t,"h",function(){return O}),r.d(t,"b",function(){return M});var n=r(4),i=r(1),a=r(5),u=r(6),o=r(9);function s(e){for(var t=[];Array.isArray(e);)t.push(e.length),e=e[0];return t}function c(e,t){if(0===t.length){if(Array.isArray(e))throw new u.a(e.length,0)}else!function e(t,r,n){var i=t.length;if(i!==r[n])throw new u.a(i,r[n]);if(n<r.length-1)for(var a=n+1,o=0;o<i;o++){var s=t[o];if(!Array.isArray(s))throw new u.a(r.length-1,r.length,"<");e(t[o],r,a)}else for(o=0;o<i;o++)if(Array.isArray(t[o]))throw new u.a(r.length+1,r.length,">")}(e,t,0)}function f(e,t){if(!Object(i.y)(e)||!Object(n.i)(e))throw new TypeError("Index must be an integer (value: "+e+")");if(e<0||"number"==typeof t&&t<=e)throw new o.a(e,t)}function l(e,t,r){if(!Array.isArray(e)||!Array.isArray(t))throw new TypeError("Array expected");if(0===t.length)throw new Error("Resizing to scalar is not supported");return t.forEach(function(e){if(!Object(i.y)(e)||!Object(n.i)(e)||e<0)throw new TypeError("Invalid size, must contain positive integers (size: "+Object(a.d)(t)+")")}),function e(t,r,n,i){var a;var o;var s=t.length;var u=r[n];var c=Math.min(s,u);t.length=u;if(n<r.length-1){var f=n+1;for(a=0;a<c;a++)o=t[a],Array.isArray(o)||(o=[o],t[a]=o),e(o,r,f,i);for(a=c;a<u;a++)o=[],t[a]=o,e(o,r,f,i)}else{for(a=0;a<c;a++)for(;Array.isArray(t[a]);)t[a]=t[a][0];for(a=c;a<u;a++)t[a]=i}}(e,t,0,void 0!==r?r:0),e}function p(t,r){var e,n=d(t);function i(e){return e.reduce(function(e,t){return e*t})}if(!Array.isArray(t)||!Array.isArray(r))throw new TypeError("Array expected");if(0===r.length)throw new u.a(0,i(s(t)),"!=");for(var a=1,o=0;o<r.length;o++)a*=r[o];if(n.length!==a)throw new u.a(i(r),i(s(t)),"!=");try{e=function(e,t){for(var r,n=e,i=t.length-1;0<i;i--){var a=t[i];r=[];for(var o=n.length/a,s=0;s<o;s++)r.push(n.slice(s*a,(s+1)*a));n=r}return n}(n,r)}catch(e){if(e instanceof u.a)throw new u.a(i(r),i(s(t)),"!=");throw e}return e}function m(e,t){for(var r=t||s(e);Array.isArray(e)&&1===e.length;)e=e[0],r.shift();for(var n=r.length;1===r[n-1];)n--;return n<r.length&&(e=function e(t,r,n){var i,a;if(n<r){var o=n+1;for(i=0,a=t.length;i<a;i++)t[i]=e(t[i],r,o)}else for(;Array.isArray(t);)t=t[0];return t}(e,n,0),r.length=n),e}function h(e,t,r,n){var i=n||s(e);if(r)for(var a=0;a<r;a++)e=[e],i.unshift(1);for(e=function e(t,r,n){var i,a;if(Array.isArray(t)){var o=n+1;for(i=0,a=t.length;i<a;i++)t[i]=e(t[i],r,o)}else for(var s=n;s<r;s++)t=[t];return t}(e,t,0);i.length<t;)i.push(1);return e}function d(e){if(!Array.isArray(e))return e;var r=[];return e.forEach(function e(t){Array.isArray(t)?t.forEach(e):r.push(t)}),r}function y(e,t){return Array.prototype.map.call(e,t)}function g(e,t){Array.prototype.forEach.call(e,t)}function b(e,t){if(1!==s(e).length)throw new Error("Only one dimensional matrices supported");return Array.prototype.filter.call(e,t)}function v(e,t){if(1!==s(e).length)throw new Error("Only one dimensional matrices supported");return Array.prototype.filter.call(e,function(e){return t.test(e)})}function x(e,t){return Array.prototype.join.call(e,t)}function w(e){if(!Array.isArray(e))throw new TypeError("Array input expected");if(0===e.length)return e;var t=[],r=0;t[0]={value:e[0],identifier:0};for(var n=1;n<e.length;n++)e[n]===e[n-1]?r++:r=0,t.push({value:e[n],identifier:r});return t}function N(e){if(!Array.isArray(e))throw new TypeError("Array input expected");if(0===e.length)return e;for(var t=[],r=0;r<e.length;r++)t.push(e[r].value);return t}function O(e,t){for(var r,n=0,i=0;i<e.length;i++){var a=e[i],o=Array.isArray(a);if(0===i&&o&&(n=a.length),o&&a.length!==n)return;a=o?O(a,t):t(a);if(void 0===r)r=a;else if(r!==a)return"mixed"}return r}function M(e,t){return-1!==e.indexOf(t)}},function(e,t,r){"use strict";r.d(t,"a",function(){return i}),r.d(t,"i",function(){return o}),r.d(t,"e",function(){return s}),r.d(t,"b",function(){return u}),r.d(t,"d",function(){return c}),r.d(t,"c",function(){return f}),r.d(t,"h",function(){return l}),r.d(t,"f",function(){return p}),r.d(t,"g",function(){return m}),r.d(t,"j",function(){return h}),r.d(t,"k",function(){return d});var n=r(1);function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function i(e){var t=a(e);if("number"===t||"string"===t||"boolean"===t||null==e)return e;if("function"==typeof e.clone)return e.clone();if(Array.isArray(e))return e.map(i);if(e instanceof Date)return new Date(e.valueOf());if(Object(n.e)(e))return e;if(e instanceof RegExp)throw new TypeError("Cannot clone "+e);return o(e,i)}function o(e,t){var r,n={};for(r in e)p(e,r)&&(n[r]=t(e[r]));return n}function s(e,t){for(var r in t)p(t,r)&&(e[r]=t[r]);return e}function u(e,t){if(Array.isArray(t))throw new TypeError("Arrays are not supported by deepExtend");for(var r in t)if(p(t,r)&&!(r in Object.prototype)&&!(r in Function.prototype))if(t[r]&&t[r].constructor===Object)void 0===e[r]&&(e[r]={}),e[r]&&e[r].constructor===Object?u(e[r],t[r]):e[r]=t[r];else{if(Array.isArray(t[r]))throw new TypeError("Arrays are not supported by deepExtend");e[r]=t[r]}return e}function c(e,t){var r,n,i;if(Array.isArray(e)){if(!Array.isArray(t))return!1;if(e.length!==t.length)return!1;for(n=0,i=e.length;n<i;n++)if(!c(e[n],t[n]))return!1;return!0}if("function"==typeof e)return e===t;if(e instanceof Object){if(Array.isArray(t)||!(t instanceof Object))return!1;for(r in e)if(!(r in t&&c(e[r],t[r])))return!1;for(r in t)if(!(r in e&&c(e[r],t[r])))return!1;return!0}return e===t}function f(e){var t={};return function e(t,r){for(var n in t){var i;p(t,n)&&("object"===a(i=t[n])&&null!==i?e(i,r):r[n]=i)}}(e,t),t}function l(e,t,r){var n,i=!0;Object.defineProperty(e,t,{get:function(){return i&&(n=r(),i=!1),n},set:function(e){n=e,i=!1},configurable:!0,enumerable:!0})}function p(e,t){return e&&Object.hasOwnProperty.call(e,t)}function m(e){return e&&"function"==typeof e.factory}function h(e,t){for(var r={},n=0;n<t.length;n++){var i=t[n],a=e[i];void 0!==a&&(r[i]=a)}return r}function d(t){return Object.keys(t).map(function(e){return t[e]})}},function(e,t,r){"use strict";r.d(t,"i",function(){return n}),r.d(t,"n",function(){return i}),r.d(t,"l",function(){return a}),r.d(t,"j",function(){return o}),r.d(t,"k",function(){return s}),r.d(t,"d",function(){return u}),r.d(t,"g",function(){return c}),r.d(t,"h",function(){return l}),r.d(t,"q",function(){return m}),r.d(t,"f",function(){return g}),r.d(t,"m",function(){return v}),r.d(t,"a",function(){return x}),r.d(t,"b",function(){return w}),r.d(t,"c",function(){return N}),r.d(t,"e",function(){return O}),r.d(t,"o",function(){return M}),r.d(t,"p",function(){return j});var f=r(1);function n(e){return"boolean"==typeof e||!!isFinite(e)&&e===Math.round(e)}var i=Math.sign||function(e){return 0<e?1:e<0?-1:0},a=Math.log2||function(e){return Math.log(e)/Math.LN2},o=Math.log10||function(e){return Math.log(e)/Math.LN10},s=Math.log1p||function(e){return Math.log(e+1)},u=Math.cbrt||function(e){if(0===e)return e;var t,r=e<0;return r&&(e=-e),t=isFinite(e)?(e/((t=Math.exp(Math.log(e)/3))*t)+2*t)/3:e,r?-t:t},c=Math.expm1||function(e){return 2e-4<=e||e<=-2e-4?Math.exp(e)-1:e+e*e/2+e*e*e/6};function l(e,t){if("function"==typeof t)return t(e);if(e===1/0)return"Infinity";if(e===-1/0)return"-Infinity";if(isNaN(e))return"NaN";var r,n="auto";switch(t&&(t.notation&&(n=t.notation),Object(f.y)(t)?r=t:Object(f.y)(t.precision)&&(r=t.precision)),n){case"fixed":return m(e,r);case"exponential":return h(e,r);case"engineering":return function(e,t){if(isNaN(e)||!isFinite(e))return String(e);var r=d(p(e),t),n=r.exponent,i=r.coefficients,a=n%3==0?n:n<0?n-3-n%3:n-n%3;if(Object(f.y)(t))for(;t>i.length||n-a+1>i.length;)i.push(0);else for(var o=Math.abs(n-a)-(i.length-1),s=0;s<o;s++)i.push(0);var u=Math.abs(n-a),c=1;for(;0<u;)c++,u--;e=i.slice(c).join(""),e=Object(f.y)(t)&&e.length||e.match(/[1-9]/)?"."+e:"",e=i.slice(0,c).join("")+e+"e"+(0<=n?"+":"")+a.toString();return r.sign+e}(e,r);case"auto":return function(e,t,r){if(isNaN(e)||!isFinite(e))return String(e);var n=r&&void 0!==r.lowerExp?r.lowerExp:-3,i=r&&void 0!==r.upperExp?r.upperExp:5,r=p(e),r=t?d(r,t):r;{if(r.exponent<n||r.exponent>=i)return h(e,t);i=r.coefficients,e=r.exponent;i.length<t&&(i=i.concat(y(t-i.length))),i=i.concat(y(e-i.length+1+(i.length<t?t-i.length:0))),i=y(-e).concat(i);e=0<e?e:0;return e<i.length-1&&i.splice(e+1,0,"."),r.sign+i.join("")}}(e,r,t&&t).replace(/((\.\d*?)(0+))($|e)/,function(){var e=arguments[2],t=arguments[4];return"."!==e?e+t:t});default:throw new Error('Unknown notation "'+n+'". Choose "auto", "exponential", or "fixed".')}}function p(e){var t=String(e).toLowerCase().match(/^0*?(-?)(\d+\.?\d*)(e([+-]?\d+))?$/);if(!t)throw new SyntaxError("Invalid number "+e);var r=t[1],e=t[2],n=parseFloat(t[4]||"0"),t=e.indexOf(".");n+=-1!==t?t-1:e.length-1;e=e.replace(".","").replace(/^0*/,function(e){return n-=e.length,""}).replace(/0*$/,"").split("").map(function(e){return parseInt(e)});return 0===e.length&&(e.push(0),n++),{sign:r,coefficients:e,exponent:n}}function m(e,t){if(isNaN(e)||!isFinite(e))return String(e);var r=p(e),n="number"==typeof t?d(r,r.exponent+1+t):r,e=n.coefficients,r=n.exponent+1,t=r+(t||0);return e.length<t&&(e=e.concat(y(t-e.length))),r<0&&(e=y(1-r).concat(e),r=1),r<e.length&&e.splice(r,0,0===r?"0.":"."),n.sign+e.join("")}function h(e,t){if(isNaN(e)||!isFinite(e))return String(e);var r=p(e),n=t?d(r,t):r,e=n.coefficients,r=n.exponent;e.length<t&&(e=e.concat(y(t-e.length)));t=e.shift();return n.sign+t+(0<e.length?"."+e.join(""):"")+"e"+(0<=r?"+":"")+r}function d(e,t){for(var r={sign:e.sign,coefficients:e.coefficients,exponent:e.exponent},n=r.coefficients;t<=0;)n.unshift(0),r.exponent++,t++;if(n.length>t&&5<=n.splice(t,n.length-t)[0]){var i=t-1;for(n[i]++;10===n[i];)n.pop(),0===i&&(n.unshift(0),r.exponent++,i++),n[--i]++}return r}function y(e){for(var t=[],r=0;r<e;r++)t.push(0);return t}function g(e){return e.toExponential().replace(/e.*$/,"").replace(/^0\.?0*|\./,"").length}var b=Number.EPSILON||2220446049250313e-31;function v(e,t,r){if(null==r)return e===t;if(e===t)return!0;if(isNaN(e)||isNaN(t))return!1;if(isFinite(e)&&isFinite(t)){var n=Math.abs(e-t);return n<b||n<=Math.max(Math.abs(e),Math.abs(t))*r}return!1}var x=Math.acosh||function(e){return Math.log(Math.sqrt(e*e-1)+e)},w=Math.asinh||function(e){return Math.log(Math.sqrt(e*e+1)+e)},N=Math.atanh||function(e){return Math.log((1+e)/(1-e))/2},O=Math.cosh||function(e){return(Math.exp(e)+Math.exp(-e))/2},M=Math.sinh||function(e){return(Math.exp(e)-Math.exp(-e))/2},j=Math.tanh||function(e){e=Math.exp(2*e);return(e-1)/(e+1)}},function(e,t,r){"use strict";r.d(t,"b",function(){return u}),r.d(t,"d",function(){return c}),r.d(t,"e",function(){return f}),r.d(t,"c",function(){return l}),r.d(t,"a",function(){return p});var n=r(1),i=r(4);function a(e,t){if("function"==typeof t)return t(e);if(!e.isFinite())return e.isNaN()?"NaN":e.gt(0)?"Infinity":"-Infinity";var r,n="auto";switch(void 0!==t&&(t.notation&&(n=t.notation),"number"==typeof t?r=t:t.precision&&(r=t.precision)),n){case"fixed":return o=r,e.toFixed(o);case"exponential":return s(e,r);case"engineering":return function(e,t){var r=e.e,n=r%3==0?r:r<0?r-3-r%3:r-r%3,e=e.mul(Math.pow(10,-n)),t=e.toPrecision(t);-1!==t.indexOf("e")&&(t=e.toString());return t+"e"+(0<=r?"+":"")+n.toString()}(e,r);case"auto":var i=t&&void 0!==t.lowerExp?t.lowerExp:-3,a=t&&void 0!==t.upperExp?t.upperExp:5;if(e.isZero())return"0";var o=e.toSignificantDigits(r),t=o.e;return(i<=t&&t<a?o.toFixed():s(e,r)).replace(/((\.\d*?)(0+))($|e)/,function(){var e=arguments[2],t=arguments[4];return"."!==e?e+t:t});default:throw new Error('Unknown notation "'+n+'". Choose "auto", "exponential", or "fixed".')}}function s(e,t){return void 0!==t?e.toExponential(t-1):e.toExponential()}function o(e){return(o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function u(e,t){var r=e.length-t.length,n=e.length;return e.substring(r,n)===t}function c(t,r){return"number"==typeof t?Object(i.h)(t,r):Object(n.e)(t)?a(t,r):(e=t)&&"object"===o(e)&&"number"==typeof e.s&&"number"==typeof e.n&&"number"==typeof e.d||!1?r&&"decimal"===r.fraction?t.toString():t.s*t.n+"/"+t.d:Array.isArray(t)?function e(t,r){{if(Array.isArray(t)){for(var n="[",i=t.length,a=0;a<i;a++)0!==a&&(n+=", "),n+=e(t[a],r);return n+="]"}return c(t,r)}}(t,r):Object(n.I)(t)?'"'+t+'"':"function"==typeof t?t.syntax?String(t.syntax):"function":t&&"object"===o(t)?"function"==typeof t.format?t.format(r):t&&t.toString(r)!=={}.toString()?t.toString(r):"{"+Object.keys(t).map(function(e){return'"'+e+'": '+c(t[e],r)}).join(", ")+"}":String(t);var e}function f(e){for(var t=String(e),r="",n=0;n<t.length;){var i=t.charAt(n);"\\"===i?(r+=i,n++,""!==(i=t.charAt(n))&&-1!=='"\\/bfnrtu'.indexOf(i)||(r+="\\"),r+=i):r+='"'===i?'\\"':i,n++}return'"'+r+'"'}function l(e){return String(e).replace(/&/g,"&amp;").replace(/"/g,"&quot;").replace(/'/g,"&#39;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}function p(e,t){if(!Object(n.I)(e))throw new TypeError("Unexpected type of argument in function compareText (expected: string or Array or Matrix, actual: "+Object(n.M)(e)+", index: 0)");if(!Object(n.I)(t))throw new TypeError("Unexpected type of argument in function compareText (expected: string or Array or Matrix, actual: "+Object(n.M)(t)+", index: 1)");return e===t?0:t<e?1:-1}},function(e,t,r){"use strict";function n(e,t,r){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");this.actual=e,this.expected=t,this.relation=r,this.message="Dimension mismatch ("+(Array.isArray(e)?"["+e.join(", ")+"]":e)+" "+(this.relation||"!=")+" "+(Array.isArray(t)?"["+t.join(", ")+"]":t)+")",this.stack=(new Error).stack}r.d(t,"a",function(){return n}),(n.prototype=new RangeError).constructor=RangeError,n.prototype.name="DimensionError",n.prototype.isDimensionError=!0},,function(e,t,r){var a;
/**
 * @license Complex.js v2.0.11 11/02/2016
 *
 * Copyright (c) 2016, Robert Eisele (robert@xarg.org)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 **/
!function(){"use strict";function n(e){return.5*(Math.exp(e)+Math.exp(-e))}function i(e){return.5*(Math.exp(e)-Math.exp(-e))}function u(){throw SyntaxError("Invalid Param")}function o(e,t){var r=Math.abs(e),n=Math.abs(t);return 0===e?Math.log(n):0===t?Math.log(r):r<3e3&&n<3e3?.5*Math.log(e*e+t*t):Math.log(e/Math.cos(Math.atan2(t,e)))}var r=function(e,t){var r={re:0,im:0};if(null==e)r.re=r.im=0;else if(void 0!==t)r.re=e,r.im=t;else switch(typeof e){case"object":if("im"in e&&"re"in e)r.re=e.re,r.im=e.im;else if("abs"in e&&"arg"in e){if(!Number.isFinite(e.abs)&&Number.isFinite(e.arg))return c.INFINITY;r.re=e.abs*Math.cos(e.arg),r.im=e.abs*Math.sin(e.arg)}else if("r"in e&&"phi"in e){if(!Number.isFinite(e.r)&&Number.isFinite(e.phi))return c.INFINITY;r.re=e.r*Math.cos(e.phi),r.im=e.r*Math.sin(e.phi)}else 2===e.length?(r.re=e[0],r.im=e[1]):u();break;case"string":r.im=r.re=0;var n=e.match(/\d+\.?\d*e[+-]?\d+|\d+\.?\d*|\.\d+|./g),i=1,a=0;null===n&&u();for(var o=0;o<n.length;o++){var s=n[o];" "===s||"\t"===s||"\n"===s||("+"===s?i++:"-"===s?a++:i=a=("i"===s||"I"===s?(i+a===0&&u()," "===n[o+1]||isNaN(n[o+1])?r.im+=parseFloat((a%2?"-":"")+"1"):(r.im+=parseFloat((a%2?"-":"")+n[o+1]),o++)):(i+a!==0&&!isNaN(s)||u(),"i"===n[o+1]||"I"===n[o+1]?(r.im+=parseFloat((a%2?"-":"")+s),o++):r.re+=parseFloat((a%2?"-":"")+s)),0))}0<i+a&&u();break;case"number":r.im=0,r.re=e;break;default:u()}return isNaN(r.re)||isNaN(r.im),r};function c(e,t){if(!(this instanceof c))return new c(e,t);t=r(e,t);this.re=t.re,this.im=t.im}c.prototype={re:0,im:0,sign:function(){var e=this.abs();return new c(this.re/e,this.im/e)},add:function(e,t){t=new c(e,t);return this.isInfinite()&&t.isInfinite()?c.NAN:this.isInfinite()||t.isInfinite()?c.INFINITY:new c(this.re+t.re,this.im+t.im)},sub:function(e,t){t=new c(e,t);return this.isInfinite()&&t.isInfinite()?c.NAN:this.isInfinite()||t.isInfinite()?c.INFINITY:new c(this.re-t.re,this.im-t.im)},mul:function(e,t){t=new c(e,t);return this.isInfinite()&&t.isZero()||this.isZero()&&t.isInfinite()?c.NAN:this.isInfinite()||t.isInfinite()?c.INFINITY:0===t.im&&0===this.im?new c(this.re*t.re,0):new c(this.re*t.re-this.im*t.im,this.re*t.im+this.im*t.re)},div:function(e,t){var r=new c(e,t);if(this.isZero()&&r.isZero()||this.isInfinite()&&r.isInfinite())return c.NAN;if(this.isInfinite()||r.isZero())return c.INFINITY;if(this.isZero()||r.isInfinite())return c.ZERO;e=this.re,t=this.im;var n,i,a=r.re,r=r.im;return 0===r?new c(e/a,t/a):Math.abs(a)<Math.abs(r)?new c((e*(i=a/r)+t)/(n=a*i+r),(t*i-e)/n):new c((e+t*(i=r/a))/(n=r*i+a),(t-e*i)/n)},pow:function(e,t){var r=new c(e,t);if(e=this.re,t=this.im,r.isZero())return c.ONE;if(0===r.im){if(0===t&&0<=e)return new c(Math.pow(e,r.re),0);if(0===e)switch((r.re%4+4)%4){case 0:return new c(Math.pow(t,r.re),0);case 1:return new c(0,Math.pow(t,r.re));case 2:return new c(-Math.pow(t,r.re),0);case 3:return new c(0,-Math.pow(t,r.re))}}if(0===e&&0===t&&0<r.re&&0<=r.im)return c.ZERO;var n=Math.atan2(t,e),i=o(e,t);return e=Math.exp(r.re*i-r.im*n),t=r.im*i+r.re*n,new c(e*Math.cos(t),e*Math.sin(t))},sqrt:function(){var e,t=this.re,r=this.im,n=this.abs();if(0<=t){if(0===r)return new c(Math.sqrt(t),0);e=.5*Math.sqrt(2*(n+t))}else e=Math.abs(r)/Math.sqrt(2*(n-t));return t=t<=0?.5*Math.sqrt(2*(n-t)):Math.abs(r)/Math.sqrt(2*(n+t)),new c(e,r<0?-t:t)},exp:function(){var e=Math.exp(this.re);return this.im,new c(e*Math.cos(this.im),e*Math.sin(this.im))},expm1:function(){var e=this.re,t=this.im;return new c(Math.expm1(e)*Math.cos(t)+function(e){var t=Math.PI/4;if(e<-t||t<e)return Math.cos(e)-1;e*=e;return e*(e*(1/24+e*(-1/720+e*(1/40320+e*(-1/3628800+e*(1/4790014600+e*(-1/87178291200+1/20922789888e3*e))))))-.5)}(t),Math.exp(e)*Math.sin(t))},log:function(){var e=this.re,t=this.im;return new c(o(e,t),Math.atan2(t,e))},abs:function(){return e=this.re,t=this.im,r=Math.abs(e),n=Math.abs(t),r<3e3&&n<3e3?Math.sqrt(r*r+n*n):(n=r<n?(r=n,e/t):t/e,r*Math.sqrt(1+n*n));var e,t,r,n},arg:function(){return Math.atan2(this.im,this.re)},sin:function(){var e=this.re,t=this.im;return new c(Math.sin(e)*n(t),Math.cos(e)*i(t))},cos:function(){var e=this.re,t=this.im;return new c(Math.cos(e)*n(t),-Math.sin(e)*i(t))},tan:function(){var e=2*this.re,t=2*this.im,r=Math.cos(e)+n(t);return new c(Math.sin(e)/r,i(t)/r)},cot:function(){var e=2*this.re,t=2*this.im,r=Math.cos(e)-n(t);return new c(-Math.sin(e)/r,i(t)/r)},sec:function(){var e=this.re,t=this.im,r=.5*n(2*t)+.5*Math.cos(2*e);return new c(Math.cos(e)*n(t)/r,Math.sin(e)*i(t)/r)},csc:function(){var e=this.re,t=this.im,r=.5*n(2*t)-.5*Math.cos(2*e);return new c(Math.sin(e)*n(t)/r,-Math.cos(e)*i(t)/r)},asin:function(){var e=this.re,t=this.im,r=new c(t*t-e*e+1,-2*e*t).sqrt(),e=new c(r.re-t,r.im+e).log();return new c(e.im,-e.re)},acos:function(){var e=this.re,t=this.im,r=new c(t*t-e*e+1,-2*e*t).sqrt(),e=new c(r.re-t,r.im+e).log();return new c(Math.PI/2-e.im,e.re)},atan:function(){var e=this.re,t=this.im;if(0===e){if(1===t)return new c(0,1/0);if(-1===t)return new c(0,-1/0)}var r=e*e+(1-t)*(1-t),r=new c((1-t*t-e*e)/r,-2*e/r).log();return new c(-.5*r.im,.5*r.re)},acot:function(){var e=this.re,t=this.im;if(0===t)return new c(Math.atan2(1,e),0);var r=e*e+t*t;return(0!=r?new c(e/r,-t/r):new c(0!==e?e/0:0,0!==t?-t/0:0)).atan()},asec:function(){var e=this.re,t=this.im;if(0===e&&0===t)return new c(0,1/0);var r=e*e+t*t;return(0!=r?new c(e/r,-t/r):new c(0!==e?e/0:0,0!==t?-t/0:0)).acos()},acsc:function(){var e=this.re,t=this.im;if(0===e&&0===t)return new c(Math.PI/2,1/0);var r=e*e+t*t;return(0!=r?new c(e/r,-t/r):new c(0!==e?e/0:0,0!==t?-t/0:0)).asin()},sinh:function(){var e=this.re,t=this.im;return new c(i(e)*Math.cos(t),n(e)*Math.sin(t))},cosh:function(){var e=this.re,t=this.im;return new c(n(e)*Math.cos(t),i(e)*Math.sin(t))},tanh:function(){var e=2*this.re,t=2*this.im,r=n(e)+Math.cos(t);return new c(i(e)/r,Math.sin(t)/r)},coth:function(){var e=2*this.re,t=2*this.im,r=n(e)-Math.cos(t);return new c(i(e)/r,-Math.sin(t)/r)},csch:function(){var e=this.re,t=this.im,r=Math.cos(2*t)-n(2*e);return new c(-2*i(e)*Math.cos(t)/r,2*n(e)*Math.sin(t)/r)},sech:function(){var e=this.re,t=this.im,r=Math.cos(2*t)+n(2*e);return new c(2*n(e)*Math.cos(t)/r,-2*i(e)*Math.sin(t)/r)},asinh:function(){var e=this.im;this.im=-this.re,this.re=e;var t=this.asin();return this.re=-this.im,this.im=e,e=t.re,t.re=-t.im,t.im=e,t},acosh:function(){var e,t=this.acos();return t.im<=0?(e=t.re,t.re=-t.im,t.im=e):(e=t.im,t.im=-t.re,t.re=e),t},atanh:function(){var e=this.re,t=this.im,r=1<e&&0===t,n=1-e,i=1+e,a=n*n+t*t,e=0!=a?new c((i*n-t*t)/a,(t*n+i*t)/a):new c(-1!==e?e/0:0,0!==t?t/0:0),t=e.re;return e.re=o(e.re,e.im)/2,e.im=Math.atan2(e.im,t)/2,r&&(e.im=-e.im),e},acoth:function(){var e=this.re,t=this.im;if(0===e&&0===t)return new c(0,Math.PI/2);var r=e*e+t*t;return(0!=r?new c(e/r,-t/r):new c(0!==e?e/0:0,0!==t?-t/0:0)).atanh()},acsch:function(){var e=this.re,t=this.im;if(0===t)return new c(0!==e?Math.log(e+Math.sqrt(e*e+1)):1/0,0);var r=e*e+t*t;return(0!=r?new c(e/r,-t/r):new c(0!==e?e/0:0,0!==t?-t/0:0)).asinh()},asech:function(){var e=this.re,t=this.im;if(this.isZero())return c.INFINITY;var r=e*e+t*t;return(0!=r?new c(e/r,-t/r):new c(0!==e?e/0:0,0!==t?-t/0:0)).acosh()},inverse:function(){if(this.isZero())return c.INFINITY;if(this.isInfinite())return c.ZERO;var e=this.re,t=this.im,r=e*e+t*t;return new c(e/r,-t/r)},conjugate:function(){return new c(this.re,-this.im)},neg:function(){return new c(-this.re,-this.im)},ceil:function(e){return e=Math.pow(10,e||0),new c(Math.ceil(this.re*e)/e,Math.ceil(this.im*e)/e)},floor:function(e){return e=Math.pow(10,e||0),new c(Math.floor(this.re*e)/e,Math.floor(this.im*e)/e)},round:function(e){return e=Math.pow(10,e||0),new c(Math.round(this.re*e)/e,Math.round(this.im*e)/e)},equals:function(e,t){t=new c(e,t);return Math.abs(t.re-this.re)<=c.EPSILON&&Math.abs(t.im-this.im)<=c.EPSILON},clone:function(){return new c(this.re,this.im)},toString:function(){var e=this.re,t=this.im,r="";return this.isNaN()?"NaN":this.isZero()?"0":this.isInfinite()?"Infinity":(0!==e&&(r+=e),0!==t&&(0!==e?r+=t<0?" - ":" + ":t<0&&(r+="-"),1!==(t=Math.abs(t))&&(r+=t),r+="i"),r||"0")},toVector:function(){return[this.re,this.im]},valueOf:function(){return 0===this.im?this.re:null},isNaN:function(){return isNaN(this.re)||isNaN(this.im)},isZero:function(){return!(0!==this.re&&-0!==this.re||0!==this.im&&-0!==this.im)},isFinite:function(){return isFinite(this.re)&&isFinite(this.im)},isInfinite:function(){return!(this.isNaN()||this.isFinite())}},c.ZERO=new c(0,0),c.ONE=new c(1,0),c.I=new c(0,1),c.PI=new c(Math.PI,0),c.E=new c(Math.E,0),c.INFINITY=new c(1/0,1/0),c.NAN=new c(NaN,NaN),c.EPSILON=1e-16,void 0===(a=function(){return c}.apply(t,[]))||(e.exports=a)}()},function(e,t,r){"use strict";function n(e,t,r){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");this.index=e,arguments.length<3?(this.min=0,this.max=t):(this.min=t,this.max=r),void 0!==this.min&&this.index<this.min?this.message="Index out of range ("+this.index+" < "+this.min+")":void 0!==this.max&&this.index>=this.max?this.message="Index out of range ("+this.index+" > "+(this.max-1)+")":this.message="Index out of range ("+this.index+")",this.stack=(new Error).stack}r.d(t,"a",function(){return n}),(n.prototype=new RangeError).constructor=RangeError,n.prototype.name="IndexError",n.prototype.isIndexError=!0},function(n,i,e){var a;
/**
 * @license Fraction.js v4.0.12 09/09/2015
 * http://www.xarg.org/2014/03/rational-numbers-in-javascript/
 *
 * Copyright (c) 2015, Robert Eisele (robert@xarg.org)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 **/
!function(){"use strict";var d={s:1,n:0,d:1};function e(t){function e(){var e=Error.apply(this,arguments);e.name=this.name=t,this.stack=e.stack,this.message=e.message}function r(){}return r.prototype=Error.prototype,e.prototype=new r,e}var y=c.DivisionByZero=e("DivisionByZero"),t=c.InvalidParameter=e("InvalidParameter");function g(e,t){return isNaN(e=parseInt(e,10))&&b(),e*t}function b(){throw new t}var r=function(e,t){var r,n=0,i=1,a=1,o=0,s=0,u=0,c=1,f=1,l=0,p=1,m=1,h=1;if(null!=e)if(void 0!==t)a=(n=e)*(i=t);else switch(typeof e){case"object":"d"in e&&"n"in e?(n=e.n,i=e.d,"s"in e&&(n*=e.s)):0 in e?(n=e[0],1 in e&&(i=e[1])):b(),a=n*i;break;case"number":if(e<0&&(e=-(a=e)),e%1==0)n=e;else if(0<e){for(1<=e&&(e/=f=Math.pow(10,Math.floor(1+Math.log(e)/Math.LN10)));p<=1e7&&h<=1e7;){if(e===(r=(l+m)/(p+h))){i=p+h<=1e7?(n=l+m,p+h):p<h?(n=m,h):(n=l,p);break}r<e?(l+=m,p+=h):(m+=l,h+=p),i=1e7<p?(n=m,h):(n=l,p)}n*=f}else(isNaN(e)||isNaN(t))&&(i=n=NaN);break;case"string":if(null===(p=e.match(/\d+|./g))&&b(),"-"===p[l]?(a=-1,l++):"+"===p[l]&&l++,p.length===l+1?s=g(p[l++],a):"."===p[l+1]||"."===p[l]?("."!==p[l]&&(o=g(p[l++],a)),(++l+1===p.length||"("===p[l+1]&&")"===p[l+3]||"'"===p[l+1]&&"'"===p[l+3])&&(s=g(p[l],a),c=Math.pow(10,p[l].length),l++),("("===p[l]&&")"===p[l+2]||"'"===p[l]&&"'"===p[l+2])&&(u=g(p[l+1],a),f=Math.pow(10,p[l+1].length)-1,l+=3)):"/"===p[l+1]||":"===p[l+1]?(s=g(p[l],a),c=g(p[l+2],1),l+=3):"/"===p[l+3]&&" "===p[l+1]&&(o=g(p[l],a),s=g(p[l+2],a),c=g(p[l+4],1),l+=5),p.length<=l){a=n=u+(i=c*f)*o+f*s;break}default:b()}if(0===i)throw new y;d.s=a<0?-1:1,d.n=Math.abs(n),d.d=Math.abs(i)};function s(e,t,r){for(var n=1,i=function(e,t,r){for(var n=1;0<t;e=e*e%r,t>>=1)1&t&&(n=n*e%r);return n}(10,r,t),a=0;a<300;a++){if(n===i)return a;n=10*n%t,i=10*i%t}return 0}function u(e,t){if(!e)return t;if(!t)return e;for(;;){if(!(e%=t))return t;if(!(t%=e))return e}}function c(e,t){if(!(this instanceof c))return new c(e,t);r(e,t),e=c.REDUCE?u(d.d,d.n):1,this.s=d.s,this.n=d.n/e,this.d=d.d/e}c.REDUCE=1,c.prototype={s:1,n:0,d:1,abs:function(){return new c(this.n,this.d)},neg:function(){return new c(-this.s*this.n,this.d)},add:function(e,t){return r(e,t),new c(this.s*this.n*d.d+d.s*this.d*d.n,this.d*d.d)},sub:function(e,t){return r(e,t),new c(this.s*this.n*d.d-d.s*this.d*d.n,this.d*d.d)},mul:function(e,t){return r(e,t),new c(this.s*d.s*this.n*d.n,this.d*d.d)},div:function(e,t){return r(e,t),new c(this.s*d.s*this.n*d.d,this.d*d.n)},clone:function(){return new c(this)},mod:function(e,t){return isNaN(this.n)||isNaN(this.d)?new c(NaN):void 0===e?new c(this.s*this.n%this.d,1):(r(e,t),0===d.n&&0===this.d&&c(0,0),new c(this.s*(d.d*this.n)%(d.n*this.d),d.d*this.d))},gcd:function(e,t){return r(e,t),new c(u(d.n,this.n)*u(d.d,this.d),d.d*this.d)},lcm:function(e,t){return r(e,t),0===d.n&&0===this.n?new c:new c(d.n*this.n,u(d.n,this.n)*u(d.d,this.d))},ceil:function(e){return e=Math.pow(10,e||0),isNaN(this.n)||isNaN(this.d)?new c(NaN):new c(Math.ceil(e*this.s*this.n/this.d),e)},floor:function(e){return e=Math.pow(10,e||0),isNaN(this.n)||isNaN(this.d)?new c(NaN):new c(Math.floor(e*this.s*this.n/this.d),e)},round:function(e){return e=Math.pow(10,e||0),isNaN(this.n)||isNaN(this.d)?new c(NaN):new c(Math.round(e*this.s*this.n/this.d),e)},inverse:function(){return new c(this.s*this.d,this.n)},pow:function(e){return e<0?new c(Math.pow(this.s*this.d,-e),Math.pow(this.n,-e)):new c(Math.pow(this.s*this.n,e),Math.pow(this.d,e))},equals:function(e,t){return r(e,t),this.s*this.n*d.d==d.s*d.n*this.d},compare:function(e,t){r(e,t);t=this.s*this.n*d.d-d.s*d.n*this.d;return(0<t)-(t<0)},simplify:function(e){if(isNaN(this.n)||isNaN(this.d))return this;var t=this.abs().toContinued();e=e||.001;for(var r=0;r<t.length;r++){var n=function e(t){return 1===t.length?new c(t[0]):e(t.slice(1)).inverse().add(t[0])}(t.slice(0,r+1));if(n.sub(this.abs()).abs().valueOf()<e)return n.mul(this.s)}return this},divisible:function(e,t){return r(e,t),!(!(d.n*this.d)||this.n*d.d%(d.n*this.d))},valueOf:function(){return this.s*this.n/this.d},toFraction:function(e){var t,r="",n=this.n,i=this.d;return this.s<0&&(r+="-"),1===i?r+=n:(e&&0<(t=Math.floor(n/i))&&(r+=t,r+=" ",n%=i),r+=n,r+="/",r+=i),r},toLatex:function(e){var t,r="",n=this.n,i=this.d;return this.s<0&&(r+="-"),1===i?r+=n:(e&&0<(t=Math.floor(n/i))&&(r+=t,n%=i),r+="\\frac{",r+=n,r+="}{",r+=i,r+="}"),r},toContinued:function(){var e,t=this.n,r=this.d,n=[];if(isNaN(this.n)||isNaN(this.d))return n;for(;n.push(Math.floor(t/r)),e=t%r,t=r,r=e,1!==t;);return n},toString:function(e){var t=this.n,r=this.d;if(isNaN(t)||isNaN(r))return"NaN";c.REDUCE||(t/=i=u(t,r),r/=i),e=e||15;var n=function(e){for(;e%2==0;e/=2);for(;e%5==0;e/=5);if(1===e)return 0;for(var t=10%e,r=1;1!==t;r++)if(t=10*t%e,2e3<r)return 0;return r}(r),i=s(0,r,n),a=-1===this.s?"-":"";if(a+=t/r|0,t%=r,(t*=10)&&(a+="."),n){for(var o=i;o--;)a+=t/r|0,t%=r,t*=10;a+="(";for(o=n;o--;)a+=t/r|0,t%=r,t*=10;a+=")"}else for(o=e;t&&o--;)a+=t/r|0,t%=r,t*=10;return a}},void 0===(a=function(){return c}.apply(i,[]))||(n.exports=a)}()},function(e,t){e.exports=function t(e,r){"use strict";function n(e){return t.insensitive&&(""+e).toLowerCase()||""+e}var i,a,o=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,s=/(^[ ]*|[ ]*$)/g,u=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,c=/^0x[0-9a-f]+$/i,f=/^0/,e=n(e).replace(s,"")||"",s=n(r).replace(s,"")||"",l=e.replace(o,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),p=s.replace(o,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),e=parseInt(e.match(c),16)||1!==l.length&&e.match(u)&&Date.parse(e),s=parseInt(s.match(c),16)||e&&s.match(u)&&Date.parse(s)||null;if(s){if(e<s)return-1;if(s<e)return 1}for(var m=0,h=Math.max(l.length,p.length);m<h;m++){if(i=!(l[m]||"").match(f)&&parseFloat(l[m])||l[m]||0,a=!(p[m]||"").match(f)&&parseFloat(p[m])||p[m]||0,isNaN(i)!==isNaN(a))return isNaN(i)?1:-1;if(typeof i!=typeof a&&(i+="",a+=""),i<a)return-1;if(a<i)return 1}return 0}},function(t,De,Re){var Ue;!function(){"use strict";var f,C,a,o=9e15,h=1e9,d="0123456789abcdef",n="2.3025850929940456840179914546843642076011014886287729760333279009675726096773524802359972050895982983419677840422862486334095254650828067566662873690987816894829072083255546808437998948262331985283935053089653777326288461633662222876982198867465436674744042432743651550489343149393914796194044002221051017141748003688084012647080685567743216228355220114804663715659121373450747856947683463616792101806445070648000277502684916746550586856935673420670581136429224554405758925724208241314695689016758940256776311356919292033376587141660230105703089634572075440370847469940168269282808481184289314848524948644871927809676271275775397027668605952496716674183485704422507197965004714951050492214776567636938662976979522110718264549734772662425709429322582798502585509785265383207606726317164309505995087807523710333101197857547331541421808427543863591778117054309827482385045648019095610299291824318237525357709750539565187697510374970888692180205189339507238539205144634197265287286965110862571492198849978748873771345686209167058",i="3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679821480865132823066470938446095505822317253594081284811174502841027019385211055596446229489549303819644288109756659334461284756482337867831652712019091456485669234603486104543266482133936072602491412737245870066063155881748815209209628292540917153643678925903600113305305488204665213841469519415116094330572703657595919530921861173819326117931051185480744623799627495673518857527248912279381830119491298336733624406566430860213949463952247371907021798609437027705392171762931767523846748184676694051320005681271452635608277857713427577896091736371787214684409012249534301465495853710507922796892589235420199561121290219608640344181598136297747713099605187072113499999983729780499510597317328160963185950244594553469083026425223082533446850352619311881710100031378387528865875332083814206171776691473035982534904287554687311595628638823537875937519577818577805321712268066130019278766111959092164201989380952572010654858632789",s={precision:20,rounding:4,modulo:1,toExpNeg:-7,toExpPos:21,minE:-o,maxE:o,crypto:!1},v=!0,u="[DecimalError] ",y=u+"Invalid argument: ",c=u+"Precision limit exceeded",l=u+"crypto unavailable",_=Math.floor,g=Math.pow,p=/^0b([01]+(\.[01]*)?|\.[01]+)(p[+-]?\d+)?$/i,m=/^0x([0-9a-f]+(\.[0-9a-f]*)?|\.[0-9a-f]+)(p[+-]?\d+)?$/i,b=/^0o([0-7]+(\.[0-7]*)?|\.[0-7]+)(p[+-]?\d+)?$/i,x=/^(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i,T=1e7,q=7,w=n.length-1,N=i.length-1,O={name:"[object Decimal]"};function M(e){var t,r,n,i=e.length-1,a="",o=e[0];if(0<i){for(a+=o,t=1;t<i;t++)n=e[t]+"",(r=q-n.length)&&(a+=L(r)),a+=n;o=e[t],(r=q-(n=o+"").length)&&(a+=L(r))}else if(0===o)return"0";for(;o%10==0;)o/=10;return a+o}function j(e,t,r){if(e!==~~e||e<t||r<e)throw Error(y+e)}function E(e,t,r,n){for(var i,a,o=e[0];10<=o;o/=10)--t;return--t<0?(t+=q,i=0):(i=Math.ceil((t+1)/q),t%=q),o=g(10,q-t),a=e[i]%o|0,null==n?t<3?(0==t?a=a/100|0:1==t&&(a=a/10|0),r<4&&99999==a||3<r&&49999==a||5e4==a||0==a):(r<4&&a+1==o||3<r&&a+1==o/2)&&(e[i+1]/o/100|0)==g(10,t-2)-1||(a==o/2||0==a)&&0==(e[i+1]/o/100|0):t<4?(0==t?a=a/1e3|0:1==t?a=a/100|0:2==t&&(a=a/10|0),(n||r<4)&&9999==a||!n&&3<r&&4999==a):((n||r<4)&&a+1==o||!n&&3<r&&a+1==o/2)&&(e[i+1]/o/1e3|0)==g(10,t-3)-1}function S(e,t,r){for(var n,i,a=[0],o=0,s=e.length;o<s;){for(i=a.length;i--;)a[i]*=t;for(a[0]+=d.indexOf(e.charAt(o++)),n=0;n<a.length;n++)a[n]>r-1&&(void 0===a[n+1]&&(a[n+1]=0),a[n+1]+=a[n]/r|0,a[n]%=r)}return a.reverse()}O.absoluteValue=O.abs=function(){var e=new this.constructor(this);return e.s<0&&(e.s=1),z(e)},O.ceil=function(){return z(new this.constructor(this),this.e+1,2)},O.comparedTo=O.cmp=function(e){var t,r,n=this,i=n.d,a=(e=new n.constructor(e)).d,o=n.s,s=e.s;if(!i||!a)return o&&s?o!==s?o:i===a?0:!i^o<0?1:-1:NaN;if(!i[0]||!a[0])return i[0]?o:a[0]?-s:0;if(o!==s)return o;if(n.e!==e.e)return n.e>e.e^o<0?1:-1;for(t=0,r=(n=i.length)<(e=a.length)?n:e;t<r;++t)if(i[t]!==a[t])return i[t]>a[t]^o<0?1:-1;return n===e?0:e<n^o<0?1:-1},O.cosine=O.cos=function(){var e,t,r=this,n=r.constructor;return r.d?r.d[0]?(e=n.precision,t=n.rounding,n.precision=e+Math.max(r.e,r.sd())+q,n.rounding=1,r=function(e,t){var r,n=t.d.length;n=n<32?(r=Math.ceil(n/3),(1/Y(4,r)).toString()):(r=16,"2.3283064365386962890625e-10");e.precision+=r,t=W(e,1,t.times(n),new e(1));for(var i=r;i--;){var a=t.times(t);t=a.times(a).minus(a).times(8).plus(1)}return e.precision-=r,t}(n,X(n,r)),n.precision=e,n.rounding=t,z(2==a||3==a?r.neg():r,e,t,!0)):new n(1):new n(NaN)},O.cubeRoot=O.cbrt=function(){var e,t,r,n,i,a,o,s,u,c,f=this,l=f.constructor;if(!f.isFinite()||f.isZero())return new l(f);for(v=!1,(a=f.s*g(f.s*f,1/3))&&Math.abs(a)!=1/0?n=new l(a.toString()):(r=M(f.d),(a=((e=f.e)-r.length+1)%3)&&(r+=1==a||-2==a?"0":"00"),a=g(r,1/3),e=_((e+1)/3)-(e%3==(e<0?-1:2)),(n=new l(r=a==1/0?"5e"+e:(r=a.toExponential()).slice(0,r.indexOf("e")+1)+e)).s=f.s),o=(e=l.precision)+3;;)if(c=(u=(s=n).times(s).times(s)).plus(f),n=A(c.plus(f).times(s),c.plus(u),o+2,1),M(s.d).slice(0,o)===(r=M(n.d)).slice(0,o)){if("9999"!=(r=r.slice(o-3,o+1))&&(i||"4999"!=r)){+r&&(+r.slice(1)||"5"!=r.charAt(0))||(z(n,e+1,1),t=!n.times(n).times(n).eq(f));break}if(!i&&(z(s,e+1,0),s.times(s).times(s).eq(f))){n=s;break}o+=4,i=1}return v=!0,z(n,e,l.rounding,t)},O.decimalPlaces=O.dp=function(){var e,t=this.d,r=NaN;if(t){if(r=((e=t.length-1)-_(this.e/q))*q,e=t[e])for(;e%10==0;e/=10)r--;r<0&&(r=0)}return r},O.dividedBy=O.div=function(e){return A(this,new this.constructor(e))},O.dividedToIntegerBy=O.divToInt=function(e){var t=this.constructor;return z(A(this,new t(e),0,1,1),t.precision,t.rounding)},O.equals=O.eq=function(e){return 0===this.cmp(e)},O.floor=function(){return z(new this.constructor(this),this.e+1,3)},O.greaterThan=O.gt=function(e){return 0<this.cmp(e)},O.greaterThanOrEqualTo=O.gte=function(e){e=this.cmp(e);return 1==e||0===e},O.hyperbolicCosine=O.cosh=function(){var e,t,r,n,i=this,a=i.constructor,o=new a(1);if(!i.isFinite())return new a(i.s?1/0:NaN);if(i.isZero())return o;t=a.precision,r=a.rounding,a.precision=t+Math.max(i.e,i.sd())+4,a.rounding=1,n=(n=i.d.length)<32?(1/Y(4,e=Math.ceil(n/3))).toString():(e=16,"2.3283064365386962890625e-10"),i=W(a,1,i.times(n),new a(1),!0);for(var s,u=e,c=new a(8);u--;)s=i.times(i),i=o.minus(s.times(c.minus(s.times(c))));return z(i,a.precision=t,a.rounding=r,!0)},O.hyperbolicSine=O.sinh=function(){var e,t,r,n,i=this,a=i.constructor;if(!i.isFinite()||i.isZero())return new a(i);if(t=a.precision,r=a.rounding,a.precision=t+Math.max(i.e,i.sd())+4,a.rounding=1,(n=i.d.length)<3)i=W(a,2,i,i,!0);else{e=16<(e=1.4*Math.sqrt(n))?16:0|e,i=W(a,2,i=i.times(1/Y(5,e)),i,!0);for(var o,s=new a(5),u=new a(16),c=new a(20);e--;)o=i.times(i),i=i.times(s.plus(o.times(u.times(o).plus(c))))}return z(i,a.precision=t,a.rounding=r,!0)},O.hyperbolicTangent=O.tanh=function(){var e,t,r=this,n=r.constructor;return r.isFinite()?r.isZero()?new n(r):(e=n.precision,t=n.rounding,n.precision=e+7,n.rounding=1,A(r.sinh(),r.cosh(),n.precision=e,n.rounding=t)):new n(r.s)},O.inverseCosine=O.acos=function(){var e=this,t=e.constructor,r=e.abs().cmp(1),n=t.precision,i=t.rounding;return-1!==r?0===r?e.isNeg()?P(t,n,i):new t(0):new t(NaN):e.isZero()?P(t,n+4,i).times(.5):(t.precision=n+6,t.rounding=1,e=e.asin(),r=P(t,n+4,i).times(.5),t.precision=n,t.rounding=i,r.minus(e))},O.inverseHyperbolicCosine=O.acosh=function(){var e,t,r=this,n=r.constructor;return r.lte(1)?new n(r.eq(1)?0:NaN):r.isFinite()?(e=n.precision,t=n.rounding,n.precision=e+Math.max(Math.abs(r.e),r.sd())+4,n.rounding=1,v=!1,r=r.times(r).minus(1).sqrt().plus(r),v=!0,n.precision=e,n.rounding=t,r.ln()):new n(r)},O.inverseHyperbolicSine=O.asinh=function(){var e,t,r=this,n=r.constructor;return!r.isFinite()||r.isZero()?new n(r):(e=n.precision,t=n.rounding,n.precision=e+2*Math.max(Math.abs(r.e),r.sd())+6,n.rounding=1,v=!1,r=r.times(r).plus(1).sqrt().plus(r),v=!0,n.precision=e,n.rounding=t,r.ln())},O.inverseHyperbolicTangent=O.atanh=function(){var e,t,r,n=this,i=n.constructor;return n.isFinite()?0<=n.e?new i(n.abs().eq(1)?n.s/0:n.isZero()?n:NaN):(e=i.precision,t=i.rounding,r=n.sd(),Math.max(r,e)<2*-n.e-1?z(new i(n),e,t,!0):(i.precision=r=r-n.e,n=A(n.plus(1),new i(1).minus(n),r+e,1),i.precision=e+4,i.rounding=1,n=n.ln(),i.precision=e,i.rounding=t,n.times(.5))):new i(NaN)},O.inverseSine=O.asin=function(){var e,t,r,n=this,i=n.constructor;return n.isZero()?new i(n):(e=n.abs().cmp(1),t=i.precision,r=i.rounding,-1!==e?0===e?((e=P(i,t+4,r).times(.5)).s=n.s,e):new i(NaN):(i.precision=t+6,i.rounding=1,n=n.div(new i(1).minus(n.times(n)).sqrt().plus(1)).atan(),i.precision=t,i.rounding=r,n.times(2)))},O.inverseTangent=O.atan=function(){var e,t,r,n,i,a,o,s,u,c=this,f=c.constructor,l=f.precision,p=f.rounding;if(c.isFinite()){if(c.isZero())return new f(c);if(c.abs().eq(1)&&l+4<=N)return(o=P(f,l+4,p).times(.25)).s=c.s,o}else{if(!c.s)return new f(NaN);if(l+4<=N)return(o=P(f,l+4,p).times(.5)).s=c.s,o}for(f.precision=s=l+10,f.rounding=1,e=r=Math.min(28,s/q+2|0);e;--e)c=c.div(c.times(c).plus(1).sqrt().plus(1));for(v=!1,t=Math.ceil(s/q),n=1,u=c.times(c),o=new f(c),i=c;-1!==e;)if(i=i.times(u),a=o.minus(i.div(n+=2)),i=i.times(u),void 0!==(o=a.plus(i.div(n+=2))).d[t])for(e=t;o.d[e]===a.d[e]&&e--;);return r&&(o=o.times(2<<r-1)),v=!0,z(o,f.precision=l,f.rounding=p,!0)},O.isFinite=function(){return!!this.d},O.isInteger=O.isInt=function(){return!!this.d&&_(this.e/q)>this.d.length-2},O.isNaN=function(){return!this.s},O.isNegative=O.isNeg=function(){return this.s<0},O.isPositive=O.isPos=function(){return 0<this.s},O.isZero=function(){return!!this.d&&0===this.d[0]},O.lessThan=O.lt=function(e){return this.cmp(e)<0},O.lessThanOrEqualTo=O.lte=function(e){return this.cmp(e)<1},O.logarithm=O.log=function(e){var t,r,n,i,a,o,s,u,c=this,f=c.constructor,l=f.precision,p=f.rounding;if(null==e)e=new f(10),t=!0;else{if(r=(e=new f(e)).d,e.s<0||!r||!r[0]||e.eq(1))return new f(NaN);t=e.eq(10)}if(r=c.d,c.s<0||!r||!r[0]||c.eq(1))return new f(r&&!r[0]?-1/0:1!=c.s?NaN:r?0:1/0);if(t)if(1<r.length)a=!0;else{for(i=r[0];i%10==0;)i/=10;a=1!==i}if(v=!1,o=V(c,s=l+5),n=t?U(f,s+10):V(e,s),E((u=A(o,n,s,1)).d,i=l,p))do{if(o=V(c,s+=10),n=t?U(f,s+10):V(e,s),u=A(o,n,s,1),!a){+M(u.d).slice(i+1,i+15)+1==1e14&&(u=z(u,l+1,0));break}}while(E(u.d,i+=10,p));return v=!0,z(u,l,p)},O.minus=O.sub=function(e){var t,r,n,i,a,o,s,u,c,f,l,p=this,m=p.constructor;if(e=new m(e),!p.d||!e.d)return p.s&&e.s?p.d?e.s=-e.s:e=new m(e.d||p.s!==e.s?p:NaN):e=new m(NaN),e;if(p.s!=e.s)return e.s=-e.s,p.plus(e);if(c=p.d,l=e.d,s=m.precision,u=m.rounding,!c[0]||!l[0]){if(l[0])e.s=-e.s;else{if(!c[0])return new m(3===u?-0:0);e=new m(p)}return v?z(e,s,u):e}if(r=_(e.e/q),p=_(p.e/q),c=c.slice(),a=p-r){for(o=(f=a<0)?(t=c,a=-a,l.length):(t=l,r=p,c.length),(n=Math.max(Math.ceil(s/q),o)+2)<a&&(a=n,t.length=1),t.reverse(),n=a;n--;)t.push(0);t.reverse()}else{for((f=(n=c.length)<(o=l.length))&&(o=n),n=0;n<o;n++)if(c[n]!=l[n]){f=c[n]<l[n];break}a=0}for(f&&(t=c,c=l,l=t,e.s=-e.s),o=c.length,n=l.length-o;0<n;--n)c[o++]=0;for(n=l.length;a<n;){if(c[--n]<l[n]){for(i=n;i&&0===c[--i];)c[i]=T-1;--c[i],c[n]+=T}c[n]-=l[n]}for(;0===c[--o];)c.pop();for(;0===c[0];c.shift())--r;return c[0]?(e.d=c,e.e=R(c,r),v?z(e,s,u):e):new m(3===u?-0:0)},O.modulo=O.mod=function(e){var t,r=this,n=r.constructor;return e=new n(e),!r.d||!e.s||e.d&&!e.d[0]?new n(NaN):!e.d||r.d&&!r.d[0]?z(new n(r),n.precision,n.rounding):(v=!1,9==n.modulo?(t=A(r,e.abs(),0,3,1)).s*=e.s:t=A(r,e,0,n.modulo,1),t=t.times(e),v=!0,r.minus(t))},O.naturalExponential=O.exp=function(){return G(this)},O.naturalLogarithm=O.ln=function(){return V(this)},O.negated=O.neg=function(){var e=new this.constructor(this);return e.s=-e.s,z(e)},O.plus=O.add=function(e){var t,r,n,i,a,o,s,u,c=this,f=c.constructor;if(e=new f(e),!c.d||!e.d)return c.s&&e.s?c.d||(e=new f(e.d||c.s===e.s?c:NaN)):e=new f(NaN),e;if(c.s!=e.s)return e.s=-e.s,c.minus(e);if(s=c.d,u=e.d,a=f.precision,o=f.rounding,!s[0]||!u[0])return u[0]||(e=new f(c)),v?z(e,a,o):e;if(f=_(c.e/q),c=_(e.e/q),s=s.slice(),n=f-c){for((i=(i=n<0?(r=s,n=-n,u.length):(r=u,c=f,s.length))<(f=Math.ceil(a/q))?f+1:i+1)<n&&(n=i,r.length=1),r.reverse();n--;)r.push(0);r.reverse()}for((i=s.length)-(n=u.length)<0&&(n=i,r=u,u=s,s=r),t=0;n;)t=(s[--n]=s[n]+u[n]+t)/T|0,s[n]%=T;for(t&&(s.unshift(t),++c),i=s.length;0==s[--i];)s.pop();return e.d=s,e.e=R(s,c),v?z(e,a,o):e},O.precision=O.sd=function(e){var t;if(void 0!==e&&e!==!!e&&1!==e&&0!==e)throw Error(y+e);return this.d?(t=F(this.d),e&&this.e+1>t&&(t=this.e+1)):t=NaN,t},O.round=function(){var e=this.constructor;return z(new e(this),this.e+1,e.rounding)},O.sine=O.sin=function(){var e,t,r=this,n=r.constructor;return r.isFinite()?r.isZero()?new n(r):(e=n.precision,t=n.rounding,n.precision=e+Math.max(r.e,r.sd())+q,n.rounding=1,r=function(e,t){var r,n=t.d.length;if(n<3)return W(e,2,t,t);r=16<(r=1.4*Math.sqrt(n))?16:0|r,t=t.times(1/Y(5,r)),t=W(e,2,t,t);for(var i,a=new e(5),o=new e(16),s=new e(20);r--;)i=t.times(t),t=t.times(a.plus(i.times(o.times(i).minus(s))));return t}(n,X(n,r)),n.precision=e,n.rounding=t,z(2<a?r.neg():r,e,t,!0)):new n(NaN)},O.squareRoot=O.sqrt=function(){var e,t,r,n,i,a,o=this,s=o.d,u=o.e,c=o.s,f=o.constructor;if(1!==c||!s||!s[0])return new f(!c||c<0&&(!s||s[0])?NaN:s?o:1/0);for(v=!1,n=0==(c=Math.sqrt(+o))||c==1/0?(((t=M(s)).length+u)%2==0&&(t+="0"),c=Math.sqrt(t),u=_((u+1)/2)-(u<0||u%2),new f(t=c==1/0?"5e"+u:(t=c.toExponential()).slice(0,t.indexOf("e")+1)+u)):new f(c.toString()),r=(u=f.precision)+3;;)if(n=(a=n).plus(A(o,a,r+2,1)).times(.5),M(a.d).slice(0,r)===(t=M(n.d)).slice(0,r)){if("9999"!=(t=t.slice(r-3,r+1))&&(i||"4999"!=t)){+t&&(+t.slice(1)||"5"!=t.charAt(0))||(z(n,u+1,1),e=!n.times(n).eq(o));break}if(!i&&(z(a,u+1,0),a.times(a).eq(o))){n=a;break}r+=4,i=1}return v=!0,z(n,u,f.rounding,e)},O.tangent=O.tan=function(){var e,t,r=this,n=r.constructor;return r.isFinite()?r.isZero()?new n(r):(e=n.precision,t=n.rounding,n.precision=e+10,n.rounding=1,(r=r.sin()).s=1,r=A(r,new n(1).minus(r.times(r)).sqrt(),e+10,0),n.precision=e,n.rounding=t,z(2==a||4==a?r.neg():r,e,t,!0)):new n(NaN)},O.times=O.mul=function(e){var t,r,n,i,a,o,s,u,c,f=this.constructor,l=this.d,p=(e=new f(e)).d;if(e.s*=this.s,!(l&&l[0]&&p&&p[0]))return new f(!e.s||l&&!l[0]&&!p||p&&!p[0]&&!l?NaN:l&&p?0*e.s:e.s/0);for(r=_(this.e/q)+_(e.e/q),(u=l.length)<(c=p.length)&&(a=l,l=p,p=a,o=u,u=c,c=o),a=[],n=o=u+c;n--;)a.push(0);for(n=c;0<=--n;){for(t=0,i=u+n;n<i;)s=a[i]+p[n]*l[i-n-1]+t,a[i--]=s%T|0,t=s/T|0;a[i]=(a[i]+t)%T|0}for(;!a[--o];)a.pop();return t?++r:a.shift(),e.d=a,e.e=R(a,r),v?z(e,f.precision,f.rounding):e},O.toBinary=function(e,t){return r(this,2,e,t)},O.toDecimalPlaces=O.toDP=function(e,t){var r=this.constructor,n=new r(this);return void 0===e?n:(j(e,0,h),void 0===t?t=r.rounding:j(t,0,8),z(n,e+n.e+1,t))},O.toExponential=function(e,t){var r=this,n=r.constructor,e=void 0===e?D(r,!0):(j(e,0,h),void 0===t?t=n.rounding:j(t,0,8),D(r=z(new n(r),e+1,t),!0,e+1));return r.isNeg()&&!r.isZero()?"-"+e:e},O.toFixed=function(e,t){var r=this,n=r.constructor,i=void 0===e?D(r):(j(e,0,h),void 0===t?t=n.rounding:j(t,0,8),D(i=z(new n(r),e+r.e+1,t),!1,e+i.e+1));return r.isNeg()&&!r.isZero()?"-"+i:i},O.toFraction=function(e){var t,r,n,i,a,o,s,u,c,f,l=this,p=l.d,m=l.constructor;if(!p)return new m(l);if(u=r=new m(1),n=s=new m(0),c=(a=(t=new m(n)).e=F(p)-l.e-1)%q,t.d[0]=g(10,c<0?q+c:c),null==e)e=0<a?t:u;else{if(!(o=new m(e)).isInt()||o.lt(u))throw Error(y+o);e=o.gt(t)?0<a?t:u:o}for(v=!1,o=new m(M(p)),c=m.precision,m.precision=a=p.length*q*2;f=A(o,t,0,1,1),1!=(i=r.plus(f.times(n))).cmp(e);)r=n,n=i,i=u,u=s.plus(f.times(i)),s=i,i=t,t=o.minus(f.times(i)),o=i;return i=A(e.minus(r),n,0,1,1),s=s.plus(i.times(u)),r=r.plus(i.times(n)),s.s=u.s=l.s,l=A(u,n,a,1).minus(l).abs().cmp(A(s,r,a,1).minus(l).abs())<1?[u,n]:[s,r],m.precision=c,v=!0,l},O.toHexadecimal=O.toHex=function(e,t){return r(this,16,e,t)},O.toNearest=function(e,t){var r=(n=this).constructor,n=new r(n);if(null==e){if(!n.d)return n;e=new r(1),t=r.rounding}else{if(e=new r(e),void 0===t?t=r.rounding:j(t,0,8),!n.d)return e.s?n:e;if(!e.d)return e.s&&(e.s=n.s),e}return e.d[0]?(v=!1,n=A(n,e,0,t,1).times(e),v=!0,z(n)):(e.s=n.s,n=e),n},O.toNumber=function(){return+this},O.toOctal=function(e,t){return r(this,8,e,t)},O.toPower=O.pow=function(e){var t,r,n,i,a,o,s=this,u=s.constructor,c=+(e=new u(e));if(!(s.d&&e.d&&s.d[0]&&e.d[0]))return new u(g(+s,c));if((s=new u(s)).eq(1))return s;if(n=u.precision,a=u.rounding,e.eq(1))return z(s,n,a);if((t=_(e.e/q))>=e.d.length-1&&(r=c<0?-c:c)<=9007199254740991)return i=H(u,s,r,n),e.s<0?new u(1).div(i):z(i,n,a);if((o=s.s)<0){if(t<e.d.length-1)return new u(NaN);if(0==(1&e.d[t])&&(o=1),0==s.e&&1==s.d[0]&&1==s.d.length)return s.s=o,s}return(t=0!=(r=g(+s,c))&&isFinite(r)?new u(r+"").e:_(c*(Math.log("0."+M(s.d))/Math.LN10+s.e+1)))>u.maxE+1||t<u.minE-1?new u(0<t?o/0:0):(v=!1,u.rounding=s.s=1,r=Math.min(12,(t+"").length),(i=G(e.times(V(s,n+r)),n)).d&&E((i=z(i,n+5,1)).d,n,a)&&(t=n+10,+M((i=z(G(e.times(V(s,t+r)),t),t+5,1)).d).slice(n+1,n+15)+1==1e14&&(i=z(i,n+1,0))),i.s=o,v=!0,z(i,n,u.rounding=a))},O.toPrecision=function(e,t){var r=this,n=r.constructor,e=void 0===e?D(r,r.e<=n.toExpNeg||r.e>=n.toExpPos):(j(e,1,h),void 0===t?t=n.rounding:j(t,0,8),D(r=z(new n(r),e,t),e<=r.e||r.e<=n.toExpNeg,e));return r.isNeg()&&!r.isZero()?"-"+e:e},O.toSignificantDigits=O.toSD=function(e,t){var r=this.constructor;return void 0===e?(e=r.precision,t=r.rounding):(j(e,1,h),void 0===t?t=r.rounding:j(t,0,8)),z(new r(this),e,t)},O.toString=function(){var e=this,t=e.constructor,t=D(e,e.e<=t.toExpNeg||e.e>=t.toExpPos);return e.isNeg()&&!e.isZero()?"-"+t:t},O.truncated=O.trunc=function(){return z(new this.constructor(this),this.e+1,1)},O.valueOf=O.toJSON=function(){var e=this,t=e.constructor,t=D(e,e.e<=t.toExpNeg||e.e>=t.toExpPos);return e.isNeg()?"-"+t:t};var A=function(e,t,r,n,i,a){var o,s,u,c,f,l,p,m,h,d,y,g,b,v,x,w,N,O,M,j=e.constructor,E=e.s==t.s?1:-1,S=e.d,A=t.d;if(!(S&&S[0]&&A&&A[0]))return new j(e.s&&t.s&&(S?!A||S[0]!=A[0]:A)?S&&0==S[0]||!A?0*E:E/0:NaN);for(s=a?(f=1,e.e-t.e):(a=T,f=q,_(e.e/f)-_(t.e/f)),O=A.length,w=S.length,h=(E=new j(E)).d=[],u=0;A[u]==(S[u]||0);u++);if(A[u]>(S[u]||0)&&s--,null==r?(b=r=j.precision,n=j.rounding):b=i?r+(e.e-t.e)+1:r,b<0)h.push(1),l=!0;else{if(b=b/f+2|0,u=0,1==O){for(A=A[c=0],b++;(u<w||c)&&b--;u++)v=c*a+(S[u]||0),h[u]=v/A|0,c=v%A|0;l=c||u<w}else{for(1<(c=a/(A[0]+1)|0)&&(A=I(A,c,a),S=I(S,c,a),O=A.length,w=S.length),x=O,y=(d=S.slice(0,O)).length;y<O;)d[y++]=0;for(M=A.slice(),M.unshift(0),N=A[0],A[1]>=a/2&&++N;c=0,(o=B(A,d,O,y))<0?(g=d[0],O!=y&&(g=g*a+(d[1]||0)),1<(c=g/N|0)?(a<=c&&(c=a-1),1==(o=B(p=I(A,c,a),d,m=p.length,y=d.length))&&(c--,k(p,O<m?M:A,m,a))):(0==c&&(o=c=1),p=A.slice()),(m=p.length)<y&&p.unshift(0),k(d,p,y,a),-1==o&&(o=B(A,d,O,y=d.length))<1&&(c++,k(d,O<y?M:A,y,a)),y=d.length):0===o&&(c++,d=[0]),h[u++]=c,o&&d[0]?d[y++]=S[x]||0:(d=[S[x]],y=1),(x++<w||void 0!==d[0])&&b--;);l=void 0!==d[0]}h[0]||h.shift()}if(1==f)E.e=s,C=l;else{for(u=1,c=h[0];10<=c;c/=10)u++;E.e=u+s*f-1,z(E,i?r+E.e+1:r,n,l)}return E};function I(e,t,r){var n,i=0,a=e.length;for(e=e.slice();a--;)n=e[a]*t+i,e[a]=n%r|0,i=n/r|0;return i&&e.unshift(i),e}function B(e,t,r,n){var i,a;if(r!=n)a=n<r?1:-1;else for(i=a=0;i<r;i++)if(e[i]!=t[i]){a=e[i]>t[i]?1:-1;break}return a}function k(e,t,r,n){for(var i=0;r--;)e[r]-=i,i=e[r]<t[r]?1:0,e[r]=i*n+e[r]-t[r];for(;!e[0]&&1<e.length;)e.shift()}function z(e,t,r,n){var i,a,o,s,u,c,f,l,p=e.constructor;e:if(null!=t){if(!(f=e.d))return e;for(i=1,s=f[0];10<=s;s/=10)i++;if((a=t-i)<0)a+=q,o=t,u=(c=f[l=0])/g(10,i-o-1)%10|0;else if(l=Math.ceil((a+1)/q),(s=f.length)<=l){if(!n)break e;for(;s++<=l;)f.push(0);c=u=0,o=(a%=q)-q+(i=1)}else{for(c=s=f[l],i=1;10<=s;s/=10)i++;u=(o=(a%=q)-q+i)<0?0:c/g(10,i-o-1)%10|0}if(n=n||t<0||void 0!==f[l+1]||(o<0?c:c%g(10,i-o-1)),u=r<4?(u||n)&&(0==r||r==(e.s<0?3:2)):5<u||5==u&&(4==r||n||6==r&&(0<a?0<o?c/g(10,i-o):0:f[l-1])%10&1||r==(e.s<0?8:7)),t<1||!f[0])return f.length=0,u?(t-=e.e+1,f[0]=g(10,(q-t%q)%q),e.e=-t||0):f[0]=e.e=0,e;if(0==a?(f.length=l,s=1,l--):(f.length=l+1,s=g(10,q-a),f[l]=0<o?(c/g(10,i-o)%g(10,o)|0)*s:0),u)for(;;){if(0==l){for(a=1,o=f[0];10<=o;o/=10)a++;for(o=f[0]+=s,s=1;10<=o;o/=10)s++;a!=s&&(e.e++,f[0]==T&&(f[0]=1));break}if(f[l]+=s,f[l]!=T)break;f[l--]=0,s=1}for(a=f.length;0===f[--a];)f.pop()}return v&&(e.e>p.maxE?(e.d=null,e.e=NaN):e.e<p.minE&&(e.e=0,e.d=[0])),e}function D(e,t,r){if(!e.isFinite())return Z(e);var n,i=e.e,a=M(e.d),o=a.length;return t?(r&&0<(n=r-o)?a=a.charAt(0)+"."+a.slice(1)+L(n):1<o&&(a=a.charAt(0)+"."+a.slice(1)),a=a+(e.e<0?"e":"e+")+e.e):i<0?(a="0."+L(-i-1)+a,r&&0<(n=r-o)&&(a+=L(n))):o<=i?(a+=L(i+1-o),r&&0<(n=r-i-1)&&(a=a+"."+L(n))):((n=i+1)<o&&(a=a.slice(0,n)+"."+a.slice(n)),r&&0<(n=r-o)&&(i+1===o&&(a+="."),a+=L(n))),a}function R(e,t){var r=e[0];for(t*=q;10<=r;r/=10)t++;return t}function U(e,t,r){if(w<t)throw v=!0,r&&(e.precision=r),Error(c);return z(new e(n),t,1,!0)}function P(e,t,r){if(N<t)throw Error(c);return z(new e(i),t,r,!0)}function F(e){var t=e.length-1,r=t*q+1;if(t=e[t]){for(;t%10==0;t/=10)r--;for(t=e[0];10<=t;t/=10)r++}return r}function L(e){for(var t="";e--;)t+="0";return t}function H(e,t,r,n){var i,a=new e(1),o=Math.ceil(n/q+4);for(v=!1;;){if(r%2&&Q((a=a.times(t)).d,o)&&(i=!0),0===(r=_(r/2))){r=a.d.length-1,i&&0===a.d[r]&&++a.d[r];break}Q((t=t.times(t)).d,o)}return v=!0,a}function $(e){return 1&e.d[e.d.length-1]}function e(e,t,r){for(var n,i=new e(t[0]),a=0;++a<t.length;){if(!(n=new e(t[a])).s){i=n;break}i[r](n)&&(i=n)}return i}function G(e,t){var r,n,i,a,o,s,u,c=0,f=0,l=0,p=e.constructor,m=p.rounding,h=p.precision;if(!e.d||!e.d[0]||17<e.e)return new p(e.d?e.d[0]?e.s<0?0:1/0:1:e.s?e.s<0?0:e:NaN);for(u=null==t?(v=!1,h):t,s=new p(.03125);-2<e.e;)e=e.times(s),l+=5;for(u+=n=Math.log(g(2,l))/Math.LN10*2+5|0,r=a=o=new p(1),p.precision=u;;){if(a=z(a.times(e),u,1),r=r.times(++f),M((s=o.plus(A(a,r,u,1))).d).slice(0,u)===M(o.d).slice(0,u)){for(i=l;i--;)o=z(o.times(o),u,1);if(null!=t)return p.precision=h,o;if(!(c<3&&E(o.d,u-n,m,c)))return z(o,p.precision=h,m,v=!0);p.precision=u+=10,r=a=s=new p(1),f=0,c++}o=s}}function V(e,t){var r,n,i,a,o,s,u,c,f,l,p,m=1,h=e,d=h.d,y=h.constructor,g=y.rounding,b=y.precision;if(h.s<0||!d||!d[0]||!h.e&&1==d[0]&&1==d.length)return new y(d&&!d[0]?-1/0:1!=h.s?NaN:d?0:h);if(f=null==t?(v=!1,b):t,y.precision=f+=10,n=(r=M(d)).charAt(0),!(Math.abs(a=h.e)<15e14))return c=U(y,f+2,b).times(a+""),h=V(new y(n+"."+r.slice(1)),f-10).plus(c),y.precision=b,null==t?z(h,b,g,v=!0):h;for(;n<7&&1!=n||1==n&&3<r.charAt(1);)n=(r=M((h=h.times(e)).d)).charAt(0),m++;for(a=h.e,1<n?(h=new y("0."+r),a++):h=new y(n+"."+r.slice(1)),u=o=h=A((l=h).minus(1),h.plus(1),f,1),p=z(h.times(h),f,1),i=3;;){if(o=z(o.times(p),f,1),M((c=u.plus(A(o,new y(i),f,1))).d).slice(0,f)===M(u.d).slice(0,f)){if(u=u.times(2),0!==a&&(u=u.plus(U(y,f+2,b).times(a+""))),u=A(u,new y(m),f,1),null!=t)return y.precision=b,u;if(!E(u.d,f-10,g,s))return z(u,y.precision=b,g,v=!0);y.precision=f+=10,c=o=h=A(l.minus(1),l.plus(1),f,1),p=z(h.times(h),f,1),i=s=1}u=c,i+=2}}function Z(e){return String(e.s*e.s/0)}function J(e,t){var r,n,i;for(-1<(r=t.indexOf("."))&&(t=t.replace(".","")),0<(n=t.search(/e/i))?(r<0&&(r=n),r+=+t.slice(n+1),t=t.substring(0,n)):r<0&&(r=t.length),n=0;48===t.charCodeAt(n);n++);for(i=t.length;48===t.charCodeAt(i-1);--i);if(t=t.slice(n,i)){if(i-=n,e.e=r=r-n-1,e.d=[],n=(r+1)%q,r<0&&(n+=q),n<i){for(n&&e.d.push(+t.slice(0,n)),i-=q;n<i;)e.d.push(+t.slice(n,n+=q));t=t.slice(n),n=q-t.length}else n-=i;for(;n--;)t+="0";e.d.push(+t),v&&(e.e>e.constructor.maxE?(e.d=null,e.e=NaN):e.e<e.constructor.minE&&(e.e=0,e.d=[0]))}else e.e=0,e.d=[0];return e}function W(e,t,r,n,i){var a,o,s,u,c=e.precision,f=Math.ceil(c/q);for(v=!1,u=r.times(r),s=new e(n);;){if(o=A(s.times(u),new e(t++*t++),c,1),s=i?n.plus(o):n.minus(o),n=A(o.times(u),new e(t++*t++),c,1),void 0!==(o=s.plus(n)).d[f]){for(a=f;o.d[a]===s.d[a]&&a--;);if(-1==a)break}a=s,s=n,n=o,o=a,0}return v=!0,o.d.length=f+1,o}function Y(e,t){for(var r=e;--t;)r*=e;return r}function X(e,t){var r=t.s<0,n=P(e,e.precision,1),i=n.times(.5);if((t=t.abs()).lte(i))return a=r?4:1,t;if((e=t.divToInt(n)).isZero())a=r?3:2;else{if((t=t.minus(e.times(n))).lte(i))return a=$(e)?r?2:3:r?4:1,t;a=$(e)?r?1:4:r?3:2}return t.minus(n).abs()}function r(e,t,r,n){var i,a,o,s,u,c,f,l,p=e.constructor,m=void 0!==r;if(m?(j(r,1,h),void 0===n?n=p.rounding:j(n,0,8)):(r=p.precision,n=p.rounding),e.isFinite()){for(m?(i=2,16==t?r=4*r-3:8==t&&(r=3*r-2)):i=t,0<=(o=(c=D(e)).indexOf("."))&&(c=c.replace(".",""),(l=new p(1)).e=c.length-o,l.d=S(D(l),10,i),l.e=l.d.length),a=s=(f=S(c,10,i)).length;0==f[--s];)f.pop();if(f[0]){if(o<0?a--:((e=new p(e)).d=f,e.e=a,f=(e=A(e,l,r,n,0,i)).d,a=e.e,u=C),o=f[r],l=i/2,u=u||void 0!==f[r+1],u=n<4?(void 0!==o||u)&&(0===n||n===(e.s<0?3:2)):l<o||o===l&&(4===n||u||6===n&&1&f[r-1]||n===(e.s<0?8:7)),f.length=r,u)for(;++f[--r]>i-1;)f[r]=0,r||(++a,f.unshift(1));for(s=f.length;!f[s-1];--s);for(o=0,c="";o<s;o++)c+=d.charAt(f[o]);if(m){if(1<s)if(16==t||8==t){for(o=16==t?4:3,--s;s%o;s++)c+="0";for(s=(f=S(c,i,t)).length;!f[s-1];--s);for(o=1,c="1.";o<s;o++)c+=d.charAt(f[o])}else c=c.charAt(0)+"."+c.slice(1);c=c+(a<0?"p":"p+")+a}else if(a<0){for(;++a;)c="0"+c;c="0."+c}else if(++a>s)for(a-=s;a--;)c+="0";else a<s&&(c=c.slice(0,a)+"."+c.slice(a))}else c=m?"0p+0":"0";c=(16==t?"0x":2==t?"0b":8==t?"0o":"")+c}else c=Z(e);return e.s<0?"-"+c:c}function Q(e,t){return e.length>t&&(e.length=t,1)}function K(e){return new this(e).abs()}function ee(e){return new this(e).acos()}function te(e){return new this(e).acosh()}function re(e,t){return new this(e).plus(t)}function ne(e){return new this(e).asin()}function ie(e){return new this(e).asinh()}function ae(e){return new this(e).atan()}function oe(e){return new this(e).atanh()}function se(e,t){e=new this(e),t=new this(t);var r,n=this.precision,i=this.rounding,a=n+4;return e.s&&t.s?e.d||t.d?!t.d||e.isZero()?(r=t.s<0?P(this,n,i):new this(0)).s=e.s:!e.d||t.isZero()?(r=P(this,a,1).times(.5)).s=e.s:r=t.s<0?(this.precision=a,this.rounding=1,r=this.atan(A(e,t,a,1)),t=P(this,a,1),this.precision=n,this.rounding=i,e.s<0?r.minus(t):r.plus(t)):this.atan(A(e,t,a,1)):(r=P(this,a,1).times(0<t.s?.25:.75)).s=e.s:r=new this(NaN),r}function ue(e){return new this(e).cbrt()}function ce(e){return z(e=new this(e),e.e+1,2)}function fe(e){if(!e||"object"!=typeof e)throw Error(u+"Object expected");for(var t,r,n=!0===e.defaults,i=["precision",1,h,"rounding",0,8,"toExpNeg",-o,0,"toExpPos",0,o,"maxE",0,o,"minE",-o,0,"modulo",0,9],a=0;a<i.length;a+=3)if(t=i[a],n&&(this[t]=s[t]),void 0!==(r=e[t])){if(!(_(r)===r&&i[a+1]<=r&&r<=i[a+2]))throw Error(y+t+": "+r);this[t]=r}if(t="crypto",n&&(this[t]=s[t]),void 0!==(r=e[t])){if(!0!==r&&!1!==r&&0!==r&&1!==r)throw Error(y+t+": "+r);if(r){if("undefined"==typeof crypto||!crypto||!crypto.getRandomValues&&!crypto.randomBytes)throw Error(l);this[t]=!0}else this[t]=!1}return this}function le(e){return new this(e).cos()}function pe(e){return new this(e).cosh()}function me(e,t){return new this(e).div(t)}function he(e){return new this(e).exp()}function de(e){return z(e=new this(e),e.e+1,3)}function ye(){var e,t,r=new this(0);for(v=!1,e=0;e<arguments.length;)if((t=new this(arguments[e++])).d)r.d&&(r=r.plus(t.times(t)));else{if(t.s)return v=!0,new this(1/0);r=t}return v=!0,r.sqrt()}function ge(e){return e instanceof f||e&&"[object Decimal]"===e.name||!1}function be(e){return new this(e).ln()}function ve(e,t){return new this(e).log(t)}function xe(e){return new this(e).log(2)}function we(e){return new this(e).log(10)}function Ne(){return e(this,arguments,"lt")}function Oe(){return e(this,arguments,"gt")}function Me(e,t){return new this(e).mod(t)}function je(e,t){return new this(e).mul(t)}function Ee(e,t){return new this(e).pow(t)}function Se(e){var t,r,n,i,a=0,o=new this(1),s=[];if(void 0===e?e=this.precision:j(e,1,h),n=Math.ceil(e/q),this.crypto)if(crypto.getRandomValues)for(t=crypto.getRandomValues(new Uint32Array(n));a<n;)429e7<=(i=t[a])?t[a]=crypto.getRandomValues(new Uint32Array(1))[0]:s[a++]=i%1e7;else{if(!crypto.randomBytes)throw Error(l);for(t=crypto.randomBytes(n*=4);a<n;)214e7<=(i=t[a]+(t[a+1]<<8)+(t[a+2]<<16)+((127&t[a+3])<<24))?crypto.randomBytes(4).copy(t,a):(s.push(i%1e7),a+=4);a=n/4}else for(;a<n;)s[a++]=1e7*Math.random()|0;for(n=s[--a],e%=q,n&&e&&(i=g(10,q-e),s[a]=(n/i|0)*i);0===s[a];a--)s.pop();if(a<0)s=[r=0];else{for(r=-1;0===s[0];r-=q)s.shift();for(n=1,i=s[0];10<=i;i/=10)n++;n<q&&(r-=q-n)}return o.e=r,o.d=s,o}function Ae(e){return z(e=new this(e),e.e+1,this.rounding)}function Ce(e){return(e=new this(e)).d?e.d[0]?e.s:0*e.s:e.s||NaN}function _e(e){return new this(e).sin()}function Te(e){return new this(e).sinh()}function qe(e){return new this(e).sqrt()}function Ie(e,t){return new this(e).sub(t)}function Be(e){return new this(e).tan()}function ke(e){return new this(e).tanh()}function ze(e){return z(e=new this(e),e.e+1,1)}(f=function e(t){var r,n,i;function a(e){var t,r,n,i=this;if(!(i instanceof a))return new a(e);if(e instanceof(i.constructor=a))return i.s=e.s,void(v?!e.d||e.e>a.maxE?(i.e=NaN,i.d=null):e.e<a.minE?(i.e=0,i.d=[0]):(i.e=e.e,i.d=e.d.slice()):(i.e=e.e,i.d=e.d&&e.d.slice()));if("number"==(n=typeof e)){if(0===e)return i.s=1/e<0?-1:1,i.e=0,void(i.d=[0]);if(e<0?(e=-e,i.s=-1):i.s=1,e===~~e&&e<1e7){for(t=0,r=e;10<=r;r/=10)t++;return void(v?a.maxE<t?(i.e=NaN,i.d=null):t<a.minE?(i.e=0,i.d=[0]):(i.e=t,i.d=[e]):(i.e=t,i.d=[e]))}return 0*e!=0?(e||(i.s=NaN),i.e=NaN,void(i.d=null)):J(i,e.toString())}if("string"!=n)throw Error(y+e);return 45===(r=e.charCodeAt(0))?(e=e.slice(1),i.s=-1):(43===r&&(e=e.slice(1)),i.s=1),(x.test(e)?J:function(e,t){var r,n,i,a,o,s,u,c;if("Infinity"===t||"NaN"===t)return+t||(e.s=NaN),e.e=NaN,e.d=null,e;if(m.test(t))c=16,t=t.toLowerCase();else if(p.test(t))c=2;else{if(!b.test(t))throw Error(y+t);c=8}for(a=0<=(i=(t=0<(i=t.search(/p/i))?(s=+t.slice(i+1),t.substring(2,i)):t.slice(2)).indexOf(".")),r=e.constructor,a&&(i=(o=(t=t.replace(".","")).length)-i,n=H(r,new r(c),i,2*i)),i=c=(u=S(t,c,T)).length-1;0===u[i];--i)u.pop();return i<0?new r(0*e.s):(e.e=R(u,c),e.d=u,v=!1,a&&(e=A(e,n,4*o)),s&&(e=e.times(Math.abs(s)<54?g(2,s):f.pow(2,s))),v=!0,e)})(i,e)}if(a.prototype=O,a.ROUND_UP=0,a.ROUND_DOWN=1,a.ROUND_CEIL=2,a.ROUND_FLOOR=3,a.ROUND_HALF_UP=4,a.ROUND_HALF_DOWN=5,a.ROUND_HALF_EVEN=6,a.ROUND_HALF_CEIL=7,a.ROUND_HALF_FLOOR=8,a.EUCLID=9,a.config=a.set=fe,a.clone=e,a.isDecimal=ge,a.abs=K,a.acos=ee,a.acosh=te,a.add=re,a.asin=ne,a.asinh=ie,a.atan=ae,a.atanh=oe,a.atan2=se,a.cbrt=ue,a.ceil=ce,a.cos=le,a.cosh=pe,a.div=me,a.exp=he,a.floor=de,a.hypot=ye,a.ln=be,a.log=ve,a.log10=we,a.log2=xe,a.max=Ne,a.min=Oe,a.mod=Me,a.mul=je,a.pow=Ee,a.random=Se,a.round=Ae,a.sign=Ce,a.sin=_e,a.sinh=Te,a.sqrt=qe,a.sub=Ie,a.tan=Be,a.tanh=ke,a.trunc=ze,void 0===t&&(t={}),t&&!0!==t.defaults)for(i=["precision","rounding","toExpNeg","toExpPos","maxE","minE","modulo","crypto"],r=0;r<i.length;)t.hasOwnProperty(n=i[r++])||(t[n]=this[n]);return a.config(t),a}(s)).default=f.Decimal=f,n=new f(n),i=new f(i),void 0===(Ue=function(){return f}.call(De,Re,De,t))||(t.exports=Ue)}()},function(e,t,r){"use strict";function i(e,t,r,n){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator");this.fn=e,this.count=t,this.min=r,this.max=n,this.message="Wrong number of arguments in function "+e+" ("+t+" provided, "+r+(null!=n?"-"+n:"")+" expected)",this.stack=(new Error).stack}r.d(t,"a",function(){return i}),(i.prototype=new Error).constructor=Error,i.prototype.name="ArgumentsError",i.prototype.isArgumentsError=!0},function(e,t,r){"use strict";var n,i;n=[],void 0===(i="function"==typeof(i=function(){function B(){return true}function re(){return false}function ne(){return undefined}function k(){var e=[{name:"number",test:function(e){return typeof e==="number"}},{name:"string",test:function(e){return typeof e==="string"}},{name:"boolean",test:function(e){return typeof e==="boolean"}},{name:"Function",test:function(e){return typeof e==="function"}},{name:"Array",test:Array.isArray},{name:"Date",test:function(e){return e instanceof Date}},{name:"RegExp",test:function(e){return e instanceof RegExp}},{name:"Object",test:function(e){return typeof e==="object"&&e!==null&&e.constructor===Object}},{name:"null",test:function(e){return e===null}},{name:"undefined",test:function(e){return e===undefined}}];var n={name:"any",test:B};var t=[];var r=[];var F={types:e,conversions:r,ignore:t};function u(t){var e=ee(F.types,function(e){return e.name===t});if(e)return e;if(t==="any")return n;var r=ee(F.types,function(e){return e.name.toLowerCase()===t.toLowerCase()});throw new TypeError('Unknown type "'+t+'"'+(r?'. Did you mean "'+r.name+'"?':""))}function c(e){if(e===n)return 999;return F.types.indexOf(e)}function p(t){var e=ee(F.types,function(e){return e.test(t)});if(e)return e.name;throw new TypeError("Value has unknown type. Value: "+t)}function i(e,t){if(!e.signatures)throw new TypeError("Function is no typed-function");var r;if(typeof t==="string"){r=t.split(",");for(var n=0;n<r.length;n++)r[n]=r[n].trim()}else if(Array.isArray(t))r=t;else throw new TypeError("String array or a comma separated string expected");var i=r.join(",");var a=e.signatures[i];if(a)return a;throw new TypeError("Signature not found (signature: "+(e.name||"unnamed")+"("+r.join(", ")+"))")}function a(e,t){var r=p(e);if(t===r)return e;for(var n=0;n<F.conversions.length;n++){var i=F.conversions[n];if(i.from===r&&i.to===t)return i.convert(e)}throw new Error("Cannot convert from "+r+" to "+t)}function L(e){return e.map(function(e){var t=e.types.map(l);return(e.restParam?"...":"")+t.join("|")}).join(",")}function o(e,r){var t=e.indexOf("...")===0;var n=!t?e:e.length>3?e.slice(3):"any";var i=n.split("|").map(O).filter(M).filter(N);var a=v(r,i);var o=i.map(function(e){var t=u(e);return{name:e,typeIndex:c(t),test:t.test,conversion:null,conversionIndex:-1}});var s=a.map(function(e){var t=u(e.from);return{name:e.from,typeIndex:c(t),test:t.test,conversion:e,conversionIndex:r.indexOf(e)}});return{types:o.concat(s),restParam:t}}function H(e,t,i){var r=[];if(e.trim()!=="")r=e.split(",").map(O).map(function(e,t,r){var n=o(e,i);if(n.restParam&&t!==r.length-1)throw new SyntaxError('Unexpected rest parameter "'+e+'": '+"only allowed for the last parameter");return n});if(r.some(j))return null;return{params:r,fn:t}}function $(e){var t=S(e);return t?t.restParam:false}function s(e){return e.types.some(function(e){return e.conversion!=null})}function G(e){if(!e||e.types.length===0)return B;else if(e.types.length===1)return u(e.types[0].name).test;else if(e.types.length===2){var r=u(e.types[0].name).test;var n=u(e.types[1].name).test;return function e(t){return r(t)||n(t)}}else{var i=e.types.map(function(e){return u(e.name).test});return function e(t){for(var r=0;r<i.length;r++)if(i[r](t))return true;return false}}}function V(e){var n,r,i;if($(e)){n=E(e).map(G);var a=n.length;var o=G(S(e));var s=function(e){for(var t=a;t<e.length;t++)if(!o(e[t]))return false;return true};return function e(t){for(var r=0;r<n.length;r++)if(!n[r](t[r]))return false;return s(t)&&t.length>=a+1}}else if(e.length===0)return function e(t){return t.length===0};else if(e.length===1){r=G(e[0]);return function e(t){return r(t[0])&&t.length===1}}else if(e.length===2){r=G(e[0]);i=G(e[1]);return function e(t){return r(t[0])&&i(t[1])&&t.length===2}}else{n=e.map(G);return function e(t){for(var r=0;r<n.length;r++)if(!n[r](t[r]))return false;return t.length===n.length}}}function m(e,t){return t<e.params.length?e.params[t]:$(e.params)?S(e.params):null}function f(e,t,r){var n=m(e,t);var i=n?r?n.types.filter(h):n.types:[];return i.map(l)}function l(e){return e.name}function h(e){return e.conversion===null||e.conversion===undefined}function d(e,t){var r=T(te(e,function(e){return f(e,t,false)}));return r.indexOf("any")!==-1?["any"]:r}function Z(e,r,t){var n,i;var a=e||"unnamed";var o=t;var s;for(s=0;s<r.length;s++){var u=o.filter(function(e){var t=G(m(e,s));return(s<e.params.length||$(e.params))&&t(r[s])});if(u.length===0){i=d(o,s);if(i.length>0){var c=p(r[s]);n=new TypeError("Unexpected type of argument in function "+a+" (expected: "+i.join(" or ")+", actual: "+c+", index: "+s+")");n.data={category:"wrongType",fn:a,index:s,actual:c,expected:i};return n}}else o=u}var f=o.map(function(e){return $(e.params)?Infinity:e.params.length});if(r.length<Math.min.apply(null,f)){i=d(o,s);n=new TypeError("Too few arguments in function "+a+" (expected: "+i.join(" or ")+", index: "+r.length+")");n.data={category:"tooFewArgs",fn:a,index:r.length,expected:i};return n}var l=Math.max.apply(null,f);if(r.length>l){n=new TypeError("Too many arguments in function "+a+" (expected: "+l+", actual: "+r.length+")");n.data={category:"tooManyArgs",fn:a,index:r.length,expectedLength:l};return n}n=new TypeError('Arguments of type "'+r.join(", ")+'" do not match any of the defined signatures of function '+a+".");n.data={category:"mismatch",actual:r.map(p)};return n}function y(e){var t=999;for(var r=0;r<e.types.length;r++)if(h(e.types[r]))t=Math.min(t,e.types[r].typeIndex);return t}function g(e){var t=999;for(var r=0;r<e.types.length;r++)if(!h(e.types[r]))t=Math.min(t,e.types[r].conversionIndex);return t}function b(e,t){var r;r=e.restParam-t.restParam;if(r!==0)return r;r=s(e)-s(t);if(r!==0)return r;r=y(e)-y(t);if(r!==0)return r;return g(e)-g(t)}function J(e,t){var r=Math.min(e.params.length,t.params.length);var n;var i;i=e.params.some(s)-t.params.some(s);if(i!==0)return i;for(n=0;n<r;n++){i=s(e.params[n])-s(t.params[n]);if(i!==0)return i}for(n=0;n<r;n++){i=b(e.params[n],t.params[n]);if(i!==0)return i}return e.params.length-t.params.length}function v(e,t){var r={};e.forEach(function(e){if(t.indexOf(e.from)===-1&&t.indexOf(e.to)!==-1&&!r[e.from])r[e.from]=e});return Object.keys(r).map(function(e){return r[e]})}function W(e,i){var t=i;if(e.some(s)){var a=$(e);var o=e.map(x);t=function e(){var t=[];var r=a?arguments.length-1:arguments.length;for(var n=0;n<r;n++)t[n]=o[n](arguments[n]);if(a)t[r]=arguments[r].map(o[r]);return i.apply(this,t)}}var r=t;if($(e)){var n=e.length-1;r=function e(){return t.apply(this,A(arguments,0,n).concat([A(arguments,n)]))}}return r}function x(e){var r,n,i,a;var o=[];var s=[];e.types.forEach(function(e){if(e.conversion){o.push(u(e.conversion.from).test);s.push(e.conversion.convert)}});switch(s.length){case 0:return function e(t){return t};case 1:r=o[0];i=s[0];return function e(t){if(r(t))return i(t);return t};case 2:r=o[0];n=o[1];i=s[0];a=s[1];return function e(t){if(r(t))return i(t);if(n(t))return a(t);return t};default:return function e(t){for(var r=0;r<s.length;r++)if(o[r](t))return s[r](t);return t}}}function Y(e){var r={};e.forEach(function(t){if(!t.params.some(s))X(t.params,true).forEach(function(e){r[L(e)]=t.fn})});return r}function X(e,u){function c(r,t,n){if(t<r.length){var e=r[t];var i=u?e.types.filter(h):e.types;var a;if(e.restParam){var o=i.filter(h);a=o.length<i.length?[o,i]:[i]}else a=i.map(function(e){return[e]});return te(a,function(e){return c(r,t+1,n.concat([e]))})}else{var s=n.map(function(e,t){return{types:e,restParam:t===r.length-1&&$(r)}});return[s]}}return c(e,0,[])}function Q(e,t){var r=Math.max(e.params.length,t.params.length);for(var n=0;n<r;n++){var i=f(e,n,true);var a=f(t,n,true);if(!_(i,a))return false}var o=e.params.length;var s=t.params.length;var u=$(e.params);var c=$(t.params);return u?c?o===s:s>=o:c?o>=s:o===s}function w(r,t){if(Object.keys(t).length===0)throw new SyntaxError("No signatures provided");var n=[];Object.keys(t).map(function(e){return H(e,t[e],F.conversions)}).filter(K).forEach(function(t){var e=ee(n,function(e){return Q(e,t)});if(e)throw new TypeError('Conflicting signatures "'+L(e.params)+'" and "'+L(t.params)+'".');n.push(t)});var i=te(n,function(t){var e=t?X(t.params,false):[];return e.map(function(e){return{params:e,fn:t.fn}})}).filter(K);i.sort(J);var e=i[0]&&i[0].params.length<=2&&!$(i[0].params);var a=i[1]&&i[1].params.length<=2&&!$(i[1].params);var o=i[2]&&i[2].params.length<=2&&!$(i[2].params);var s=i[3]&&i[3].params.length<=2&&!$(i[3].params);var u=i[4]&&i[4].params.length<=2&&!$(i[4].params);var c=i[5]&&i[5].params.length<=2&&!$(i[5].params);var f=e&&a&&o&&s&&u&&c;var l=i.map(function(e){return V(e.params)});var p=e?G(i[0].params[0]):re;var m=a?G(i[1].params[0]):re;var h=o?G(i[2].params[0]):re;var d=s?G(i[3].params[0]):re;var y=u?G(i[4].params[0]):re;var g=c?G(i[5].params[0]):re;var b=e?G(i[0].params[1]):re;var v=a?G(i[1].params[1]):re;var x=o?G(i[2].params[1]):re;var w=s?G(i[3].params[1]):re;var N=u?G(i[4].params[1]):re;var O=c?G(i[5].params[1]):re;var M=i.map(function(e){return W(e.params,e.fn)});var j=e?M[0]:ne;var E=a?M[1]:ne;var S=o?M[2]:ne;var A=s?M[3]:ne;var C=u?M[4]:ne;var _=c?M[5]:ne;var T=e?i[0].params.length:-1;var q=a?i[1].params.length:-1;var I=o?i[2].params.length:-1;var B=s?i[3].params.length:-1;var k=u?i[4].params.length:-1;var z=c?i[5].params.length:-1;var D=f?6:0;var R=i.length;var U=function e(){"use strict";for(var t=D;t<R;t++)if(l[t](arguments))return M[t].apply(this,arguments);throw Z(r,arguments,i)};var P=function e(t,r){"use strict";if(arguments.length===T&&p(t)&&b(r))return j.apply(e,arguments);if(arguments.length===q&&m(t)&&v(r))return E.apply(e,arguments);if(arguments.length===I&&h(t)&&x(r))return S.apply(e,arguments);if(arguments.length===B&&d(t)&&w(r))return A.apply(e,arguments);if(arguments.length===k&&y(t)&&N(r))return C.apply(e,arguments);if(arguments.length===z&&g(t)&&O(r))return _.apply(e,arguments);return U.apply(e,arguments)};try{Object.defineProperty(P,"name",{value:r})}catch(e){}P.signatures=Y(i);return P}function N(e){return F.ignore.indexOf(e)===-1}function O(e){return e.trim()}function M(e){return!!e}function K(e){return e!==null}function j(e){return e.types.length===0}function E(e){return e.slice(0,e.length-1)}function S(e){return e[e.length-1]}function A(e,t,r){return Array.prototype.slice.call(e,t,r)}function C(e,t){return e.indexOf(t)!==-1}function _(e,t){for(var r=0;r<e.length;r++)if(C(t,e[r]))return true;return false}function ee(e,t){for(var r=0;r<e.length;r++)if(t(e[r]))return e[r];return undefined}function T(e){var t={};for(var r=0;r<e.length;r++)t[e[r]]=true;return Object.keys(t)}function te(e,t){return Array.prototype.concat.apply([],e.map(t))}function q(e){var t="";for(var r=0;r<e.length;r++){var n=e[r];if((typeof n.signatures==="object"||typeof n.signature==="string")&&n.name!=="")if(t==="")t=n.name;else if(t!==n.name){var i=new Error("Function names do not match (expected: "+t+", actual: "+n.name+")");i.data={actual:n.name,expected:t};throw i}}return t}function I(e){var r;var n={};function t(e,t){if(n.hasOwnProperty(e)&&t!==n[e]){r=new Error('Signature "'+e+'" is defined twice');r.data={signature:e};throw r}}for(var i=0;i<e.length;i++){var a=e[i];if(typeof a.signatures==="object"){for(var o in a.signatures)if(a.signatures.hasOwnProperty(o)){t(o,a.signatures[o]);n[o]=a.signatures[o]}}else if(typeof a.signature==="string"){t(a.signature,a);n[a.signature]=a}else{r=new TypeError("Function is no typed-function (index: "+i+")");r.data={index:i};throw r}}return n}F=w("typed",{"string, Object":w,Object:function(e){var t=[];for(var r in e)if(e.hasOwnProperty(r))t.push(e[r]);var n=q(t);return w(n,e)},"...Function":function(e){return w(q(e),I(e))},"string, ...Function":function(e,t){return w(e,I(t))}});F.create=k;F.types=e;F.conversions=r;F.ignore=t;F.convert=a;F.find=i;F.addType=function(e,t){if(!e||typeof e.name!=="string"||typeof e.test!=="function")throw new TypeError("Object with properties {name: string, test: function} expected");if(t!==false)for(var r=0;r<F.types.length;r++)if(F.types[r].name==="Object"){F.types.splice(r,0,e);return}F.types.push(e)};F.addConversion=function(e){if(!e||typeof e.from!=="string"||typeof e.to!=="string"||typeof e.convert!=="function")throw new TypeError("Object with properties {from: string, to: string, convert: function} expected");F.conversions.push(e)};return F}return k()})?i.apply(t,n):i)||(e.exports=i)},function(m,e,t){"use strict";(function(e){var s=256,i=[],a=void 0===e?window:e,o=Math.pow(s,6),u=Math.pow(2,52),c=2*u,t=Math.random;function f(e){var t,r=e.length,o=this,n=0,i=o.i=o.j=0,a=o.S=[];for(r||(e=[r++]);n<s;)a[n]=n++;for(n=0;n<s;n++)a[n]=a[i=255&i+e[n%r]+(t=a[n])],a[i]=t;(o.g=function(e){for(var t,r=0,n=o.i,i=o.j,a=o.S;e--;)t=a[n=255&n+1],r=r*s+a[255&(a[n]=a[i=255&i+t])+(a[i]=t)];return o.i=n,o.j=i,r})(s)}function l(e,t){for(var r,n=e+"",i=0;i<n.length;)t[255&i]=255&(r^=19*t[255&i])+n.charCodeAt(i++);return p(t)}function p(e){return String.fromCharCode.apply(0,e)}m.exports=function(e,t){if(t&&!0===t.global)return t.global=!1,Math.random=m.exports(e,t),t.global=!0,Math.random;var r=[],n=(l(function e(t,r){var n,i=[],a=(typeof t)[0];if(r&&"o"==a)for(n in t)try{i.push(e(t[n],r-1))}catch(e){}return i.length?i:"s"==a?t:t+"\0"}(t&&t.entropy||!1?[e,p(i)]:0 in arguments?e:function(e){try{return a.crypto.getRandomValues(e=new Uint8Array(s)),p(e)}catch(e){return[+new Date,a,a.navigator&&a.navigator.plugins,a.screen,p(i)]}}(),3),r),new f(r));return l(p(n.S),i),function(){for(var e=n.g(6),t=o,r=0;e<u;)e=(e+r)*s,t*=s,r=n.g(1);for(;c<=e;)e/=2,t/=2,r>>>=1;return(e+r)/t}},m.exports.resetGlobal=function(){Math.random=t},l(Math.random(),i)}).call(this,t(19))},function(e,t,r){"use strict";function s(e,t){return u({},e,t)}var u=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var r,n=arguments[t];for(r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},c={"{":"\\{","}":"\\}","\\":"\\textbackslash{}","#":"\\#",$:"\\$","%":"\\%","&":"\\&","^":"\\textasciicircum{}",_:"\\_","~":"\\textasciitilde{}"},f={"–":"\\--","—":"\\---"," ":"~","\t":"\\qquad{}","\r\n":"\\newline{}","\n":"\\newline{}"};e.exports=function(e){for(var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},r=t.preserveFormatting,r=void 0!==r&&r,t=t.escapeMapFn,t=void 0===t?s:t,n=String(e),i="",a=t(u({},c),r?u({},f):{}),o=Object.keys(a);n;)!function(){var r=!1;o.forEach(function(e,t){r||n.length>=e.length&&n.slice(0,e.length)===e&&(i+=a[o[t]],n=n.slice(e.length,n.length),r=!0)}),r||(i+=n.slice(0,1),n=n.slice(1,n.length))}();return i}},function(e,t){function r(){}r.prototype={on:function(e,t,r){var n=this.e||(this.e={});return(n[e]||(n[e]=[])).push({fn:t,ctx:r}),this},once:function(e,t,r){var n=this;function i(){n.off(e,i),t.apply(r,arguments)}return i._=t,this.on(e,i,r)},emit:function(e){for(var t=[].slice.call(arguments,1),r=((this.e||(this.e={}))[e]||[]).slice(),n=0,i=r.length;n<i;n++)r[n].fn.apply(r[n].ctx,t);return this},off:function(e,t){var r=this.e||(this.e={}),n=r[e],i=[];if(n&&t)for(var a=0,o=n.length;a<o;a++)n[a].fn!==t&&n[a].fn._!==t&&i.push(n[a]);return i.length?r[e]=i:delete r[e],this}},e.exports=r,e.exports.TinyEmitter=r},function(e,t,r){var n=r(20),n=(0,r(21).create)(n);e.exports=n},function(e,t){var r=function(){return this}();try{r=r||new Function("return this")()}catch(e){"object"==typeof window&&(r=window)}e.exports=r},function(e,t,r){"use strict";r.r(t),r.d(t,"createTyped",function(){return s}),r.d(t,"createResultSet",function(){return l}),r.d(t,"createBigNumberClass",function(){return h}),r.d(t,"createComplexClass",function(){return g}),r.d(t,"createFractionClass",function(){return v}),r.d(t,"createRangeClass",function(){return x}),r.d(t,"createMatrixClass",function(){return w}),r.d(t,"createDenseMatrixClass",function(){return O}),r.d(t,"createClone",function(){return M}),r.d(t,"createIsInteger",function(){return B}),r.d(t,"createIsNegative",function(){return P}),r.d(t,"createIsNumeric",function(){return L}),r.d(t,"createHasNumericValue",function(){return $}),r.d(t,"createIsPositive",function(){return V}),r.d(t,"createIsZero",function(){return J}),r.d(t,"createIsNaN",function(){return W}),r.d(t,"createTypeOf",function(){return Y}),r.d(t,"createEqualScalar",function(){return K}),r.d(t,"createSparseMatrixClass",function(){return ee}),r.d(t,"createNumber",function(){return te}),r.d(t,"createString",function(){return re}),r.d(t,"createBoolean",function(){return se}),r.d(t,"createBignumber",function(){return ue}),r.d(t,"createComplex",function(){return ce}),r.d(t,"createFraction",function(){return fe}),r.d(t,"createMatrix",function(){return le}),r.d(t,"createSplitUnit",function(){return me}),r.d(t,"createUnaryMinus",function(){return De}),r.d(t,"createUnaryPlus",function(){return Ue}),r.d(t,"createAbs",function(){return Pe}),r.d(t,"createApply",function(){return Fe}),r.d(t,"createAddScalar",function(){return $e}),r.d(t,"createCbrt",function(){return Ge}),r.d(t,"createCeil",function(){return Ye}),r.d(t,"createCube",function(){return Xe}),r.d(t,"createExp",function(){return Qe}),r.d(t,"createExpm1",function(){return Ke}),r.d(t,"createFix",function(){return et}),r.d(t,"createFloor",function(){return nt}),r.d(t,"createGcd",function(){return ut}),r.d(t,"createLcm",function(){return lt}),r.d(t,"createLog10",function(){return pt}),r.d(t,"createLog2",function(){return mt}),r.d(t,"createMod",function(){return gt}),r.d(t,"createMultiplyScalar",function(){return bt}),r.d(t,"createMultiply",function(){return xt}),r.d(t,"createNthRoot",function(){return Nt}),r.d(t,"createSign",function(){return Ot}),r.d(t,"createSqrt",function(){return Mt}),r.d(t,"createSquare",function(){return jt}),r.d(t,"createSubtract",function(){return St}),r.d(t,"createXgcd",function(){return Ct}),r.d(t,"createDotMultiply",function(){return qt}),r.d(t,"createBitAnd",function(){return Jt}),r.d(t,"createBitNot",function(){return Wt}),r.d(t,"createBitOr",function(){return Yt}),r.d(t,"createBitXor",function(){return Qt}),r.d(t,"createArg",function(){return Kt}),r.d(t,"createConj",function(){return er}),r.d(t,"createIm",function(){return tr}),r.d(t,"createRe",function(){return rr}),r.d(t,"createNot",function(){return sr}),r.d(t,"createOr",function(){return ur}),r.d(t,"createXor",function(){return cr}),r.d(t,"createConcat",function(){return fr}),r.d(t,"createColumn",function(){return lr}),r.d(t,"createCross",function(){return pr}),r.d(t,"createDiag",function(){return mr}),r.d(t,"createFilter",function(){return gr}),r.d(t,"createFlatten",function(){return xr}),r.d(t,"createForEach",function(){return Nr}),r.d(t,"createGetMatrixDataType",function(){return jr}),r.d(t,"createIdentity",function(){return Sr}),r.d(t,"createKron",function(){return Ar}),r.d(t,"createMap",function(){return Cr}),r.d(t,"createDiff",function(){return Tr}),r.d(t,"createOnes",function(){return qr}),r.d(t,"createRange",function(){return zr}),r.d(t,"createReshape",function(){return Rr}),r.d(t,"createResize",function(){return Pr}),r.d(t,"createRotate",function(){return Fr}),r.d(t,"createRotationMatrix",function(){return Hr}),r.d(t,"createRow",function(){return $r}),r.d(t,"createSize",function(){return Gr}),r.d(t,"createSqueeze",function(){return Zr}),r.d(t,"createSubset",function(){return rn}),r.d(t,"createTranspose",function(){return un}),r.d(t,"createCtranspose",function(){return fn}),r.d(t,"createZeros",function(){return ln}),r.d(t,"createErf",function(){return pn}),r.d(t,"createMode",function(){return bn}),r.d(t,"createProd",function(){return xn}),r.d(t,"createFormat",function(){return wn}),r.d(t,"createBin",function(){return Mn}),r.d(t,"createOct",function(){return jn}),r.d(t,"createHex",function(){return En}),r.d(t,"createPrint",function(){return Sn}),r.d(t,"createTo",function(){return Cn}),r.d(t,"createIsPrime",function(){return Tn}),r.d(t,"createNumeric",function(){return qn}),r.d(t,"createDivideScalar",function(){return Bn}),r.d(t,"createPow",function(){return kn}),r.d(t,"createRound",function(){return Pn}),r.d(t,"createLog",function(){return Ln}),r.d(t,"createLog1p",function(){return Hn}),r.d(t,"createNthRoots",function(){return Gn}),r.d(t,"createDotPow",function(){return Vn}),r.d(t,"createDotDivide",function(){return Jn}),r.d(t,"createLsolve",function(){return Yn}),r.d(t,"createUsolve",function(){return Xn}),r.d(t,"createLsolveAll",function(){return ti}),r.d(t,"createUsolveAll",function(){return ai}),r.d(t,"createLeftShift",function(){return ui}),r.d(t,"createRightArithShift",function(){return fi}),r.d(t,"createRightLogShift",function(){return pi}),r.d(t,"createAnd",function(){return mi}),r.d(t,"createCompare",function(){return di}),r.d(t,"createCompareNatural",function(){return bi}),r.d(t,"createCompareText",function(){return xi}),r.d(t,"createEqual",function(){return Ni}),r.d(t,"createEqualText",function(){return Mi}),r.d(t,"createSmaller",function(){return Ei}),r.d(t,"createSmallerEq",function(){return Ai}),r.d(t,"createLarger",function(){return _i}),r.d(t,"createLargerEq",function(){return qi}),r.d(t,"createDeepEqual",function(){return Bi}),r.d(t,"createUnequal",function(){return zi}),r.d(t,"createPartitionSelect",function(){return Ri}),r.d(t,"createSort",function(){return Ui}),r.d(t,"createMax",function(){return Pi}),r.d(t,"createMin",function(){return Fi}),r.d(t,"createImmutableDenseMatrixClass",function(){return Li}),r.d(t,"createIndexClass",function(){return Hi}),r.d(t,"createFibonacciHeapClass",function(){return $i}),r.d(t,"createSpaClass",function(){return Gi}),r.d(t,"createUnitClass",function(){return ta}),r.d(t,"createUnitFunction",function(){return ra}),r.d(t,"createSparse",function(){return na}),r.d(t,"createCreateUnit",function(){return aa}),r.d(t,"createAcos",function(){return oa}),r.d(t,"createAcosh",function(){return Oa}),r.d(t,"createAcot",function(){return Ma}),r.d(t,"createAcoth",function(){return ja}),r.d(t,"createAcsc",function(){return Ea}),r.d(t,"createAcsch",function(){return Sa}),r.d(t,"createAsec",function(){return Aa}),r.d(t,"createAsech",function(){return Ca}),r.d(t,"createAsin",function(){return _a}),r.d(t,"createAsinh",function(){return Ta}),r.d(t,"createAtan",function(){return qa}),r.d(t,"createAtan2",function(){return Ia}),r.d(t,"createAtanh",function(){return Ba}),r.d(t,"createCos",function(){return ka}),r.d(t,"createCosh",function(){return za}),r.d(t,"createCot",function(){return Da}),r.d(t,"createCoth",function(){return Ra}),r.d(t,"createCsc",function(){return Ua}),r.d(t,"createCsch",function(){return Pa}),r.d(t,"createSec",function(){return Fa}),r.d(t,"createSech",function(){return La}),r.d(t,"createSin",function(){return Ha}),r.d(t,"createSinh",function(){return $a}),r.d(t,"createTan",function(){return Ga}),r.d(t,"createTanh",function(){return Va}),r.d(t,"createSetCartesian",function(){return Ja}),r.d(t,"createSetDifference",function(){return Ya}),r.d(t,"createSetDistinct",function(){return Qa}),r.d(t,"createSetIntersect",function(){return eo}),r.d(t,"createSetIsSubset",function(){return ro}),r.d(t,"createSetMultiplicity",function(){return io}),r.d(t,"createSetPowerset",function(){return oo}),r.d(t,"createSetSize",function(){return uo}),r.d(t,"createSetSymDifference",function(){return fo}),r.d(t,"createSetUnion",function(){return po}),r.d(t,"createAdd",function(){return mo}),r.d(t,"createHypot",function(){return ho}),r.d(t,"createNorm",function(){return yo}),r.d(t,"createDot",function(){return go}),r.d(t,"createTrace",function(){return bo}),r.d(t,"createIndex",function(){return vo}),r.d(t,"createNode",function(){return No}),r.d(t,"createAccessorNode",function(){return Eo}),r.d(t,"createArrayNode",function(){return So}),r.d(t,"createAssignmentNode",function(){return Io}),r.d(t,"createBlockNode",function(){return Bo}),r.d(t,"createConditionalNode",function(){return ko}),r.d(t,"createConstantNode",function(){return Ho}),r.d(t,"createFunctionAssignmentNode",function(){return $o}),r.d(t,"createIndexNode",function(){return Zo}),r.d(t,"createObjectNode",function(){return Wo}),r.d(t,"createOperatorNode",function(){return Yo}),r.d(t,"createParenthesisNode",function(){return Xo}),r.d(t,"createRangeNode",function(){return Qo}),r.d(t,"createRelationalNode",function(){return Ko}),r.d(t,"createSymbolNode",function(){return es}),r.d(t,"createFunctionNode",function(){return ns}),r.d(t,"createParse",function(){return as}),r.d(t,"createCompile",function(){return ss}),r.d(t,"createEvaluate",function(){return cs}),r.d(t,"createParserClass",function(){return fs}),r.d(t,"createParser",function(){return ls}),r.d(t,"createLup",function(){return ps}),r.d(t,"createQr",function(){return hs}),r.d(t,"createSlu",function(){return Ms}),r.d(t,"createLusolve",function(){return Ss}),r.d(t,"createHelpClass",function(){return As}),r.d(t,"createChainClass",function(){return Cs}),r.d(t,"createHelp",function(){return Ts}),r.d(t,"createChain",function(){return qs}),r.d(t,"createDet",function(){return Is}),r.d(t,"createInv",function(){return Bs}),r.d(t,"createEigs",function(){return ks}),r.d(t,"createExpm",function(){return zs}),r.d(t,"createSqrtm",function(){return Ds}),r.d(t,"createDivide",function(){return Rs}),r.d(t,"createDistance",function(){return Ps}),r.d(t,"createIntersect",function(){return Fs}),r.d(t,"createSum",function(){return Ls}),r.d(t,"createMean",function(){return Hs}),r.d(t,"createMedian",function(){return $s}),r.d(t,"createMad",function(){return Gs}),r.d(t,"createVariance",function(){return Js}),r.d(t,"createQuantileSeq",function(){return Ws}),r.d(t,"createStd",function(){return Ys}),r.d(t,"createCombinations",function(){return eu}),r.d(t,"createCombinationsWithRep",function(){return nu}),r.d(t,"createGamma",function(){return uu}),r.d(t,"createFactorial",function(){return fu}),r.d(t,"createKldivergence",function(){return pu}),r.d(t,"createMultinomial",function(){return hu}),r.d(t,"createPermutations",function(){return yu}),r.d(t,"createPickRandom",function(){return wu}),r.d(t,"createRandom",function(){return Mu}),r.d(t,"createRandomInt",function(){return Eu}),r.d(t,"createStirlingS2",function(){return Au}),r.d(t,"createBellNumbers",function(){return _u}),r.d(t,"createCatalan",function(){return qu}),r.d(t,"createComposition",function(){return Bu}),r.d(t,"createSimplify",function(){return Pu}),r.d(t,"createDerivative",function(){return Fu}),r.d(t,"createRationalize",function(){return Hu}),r.d(t,"createReviver",function(){return $u}),r.d(t,"createReplacer",function(){return Gu}),r.d(t,"createE",function(){return rc}),r.d(t,"createUppercaseE",function(){return pc}),r.d(t,"createFalse",function(){return Yu}),r.d(t,"createI",function(){return fc}),r.d(t,"createInfinity",function(){return Qu}),r.d(t,"createLN10",function(){return ac}),r.d(t,"createLN2",function(){return ic}),r.d(t,"createLOG10E",function(){return sc}),r.d(t,"createLOG2E",function(){return oc}),r.d(t,"createNaN",function(){return Ku}),r.d(t,"createNull",function(){return Xu}),r.d(t,"createPhi",function(){return nc}),r.d(t,"createPi",function(){return ec}),r.d(t,"createUppercasePi",function(){return lc}),r.d(t,"createSQRT1_2",function(){return uc}),r.d(t,"createSQRT2",function(){return cc}),r.d(t,"createTau",function(){return tc}),r.d(t,"createTrue",function(){return Wu}),r.d(t,"createVersion",function(){return mc}),r.d(t,"createAtomicMass",function(){return $c}),r.d(t,"createAvogadro",function(){return Gc}),r.d(t,"createBohrMagneton",function(){return Mc}),r.d(t,"createBohrRadius",function(){return _c}),r.d(t,"createBoltzmann",function(){return Vc}),r.d(t,"createClassicalElectronRadius",function(){return Tc}),r.d(t,"createConductanceQuantum",function(){return jc}),r.d(t,"createCoulomb",function(){return Nc}),r.d(t,"createDeuteronMass",function(){return Dc}),r.d(t,"createEfimovFactor",function(){return Hc}),r.d(t,"createElectricConstant",function(){return xc}),r.d(t,"createElectronMass",function(){return qc}),r.d(t,"createElementaryCharge",function(){return Oc}),r.d(t,"createFaraday",function(){return Zc}),r.d(t,"createFermiCoupling",function(){return Ic}),r.d(t,"createFineStructure",function(){return Bc}),r.d(t,"createFirstRadiation",function(){return Jc}),r.d(t,"createGasConstant",function(){return Yc}),r.d(t,"createGravitationConstant",function(){return yc}),r.d(t,"createGravity",function(){return of}),r.d(t,"createHartreeEnergy",function(){return kc}),r.d(t,"createInverseConductanceQuantum",function(){return Ec}),r.d(t,"createKlitzing",function(){return Cc}),r.d(t,"createLoschmidt",function(){return Wc}),r.d(t,"createMagneticConstant",function(){return vc}),r.d(t,"createMagneticFluxQuantum",function(){return Sc}),r.d(t,"createMolarMass",function(){return nf}),r.d(t,"createMolarMassC12",function(){return af}),r.d(t,"createMolarPlanckConstant",function(){return Xc}),r.d(t,"createMolarVolume",function(){return Qc}),r.d(t,"createNeutronMass",function(){return Rc}),r.d(t,"createNuclearMagneton",function(){return Ac}),r.d(t,"createPlanckCharge",function(){return ff}),r.d(t,"createPlanckConstant",function(){return gc}),r.d(t,"createPlanckLength",function(){return sf}),r.d(t,"createPlanckMass",function(){return uf}),r.d(t,"createPlanckTemperature",function(){return lf}),r.d(t,"createPlanckTime",function(){return cf}),r.d(t,"createProtonMass",function(){return zc}),r.d(t,"createQuantumOfCirculation",function(){return Uc}),r.d(t,"createReducedPlanckConstant",function(){return bc}),r.d(t,"createRydberg",function(){return Pc}),r.d(t,"createSackurTetrode",function(){return Kc}),r.d(t,"createSecondRadiation",function(){return ef}),r.d(t,"createSpeedOfLight",function(){return dc}),r.d(t,"createStefanBoltzmann",function(){return tf}),r.d(t,"createThomsonCrossSection",function(){return Fc}),r.d(t,"createVacuumImpedance",function(){return wc}),r.d(t,"createWeakMixingAngle",function(){return Lc}),r.d(t,"createWienDisplacement",function(){return rf}),r.d(t,"createApplyTransform",function(){return hf}),r.d(t,"createColumnTransform",function(){return df}),r.d(t,"createFilterTransform",function(){return gf}),r.d(t,"createForEachTransform",function(){return vf}),r.d(t,"createIndexTransform",function(){return xf}),r.d(t,"createMapTransform",function(){return wf}),r.d(t,"createMaxTransform",function(){return Of}),r.d(t,"createMeanTransform",function(){return Mf}),r.d(t,"createMinTransform",function(){return jf}),r.d(t,"createRangeTransform",function(){return Ef}),r.d(t,"createRowTransform",function(){return Sf}),r.d(t,"createSubsetTransform",function(){return Af}),r.d(t,"createConcatTransform",function(){return Cf}),r.d(t,"createDiffTransform",function(){return _f}),r.d(t,"createStdTransform",function(){return Tf}),r.d(t,"createSumTransform",function(){return qf}),r.d(t,"createVarianceTransform",function(){return Bf});var ie=r(1),n=r(14),i=r.n(n),N=r(4),a=r(0),o=function(){return o=i.a.create,i.a},t=["?BigNumber","?Complex","?DenseMatrix","?Fraction"],s=Object(a.a)("typed",t,function(e){var r=e.BigNumber,n=e.Complex,t=e.DenseMatrix,i=e.Fraction,e=o();return e.types=[{name:"number",test:ie.y},{name:"Complex",test:ie.j},{name:"BigNumber",test:ie.e},{name:"Fraction",test:ie.o},{name:"Unit",test:ie.L},{name:"string",test:ie.I},{name:"Chain",test:ie.h},{name:"Array",test:ie.b},{name:"Matrix",test:ie.v},{name:"DenseMatrix",test:ie.n},{name:"SparseMatrix",test:ie.H},{name:"Range",test:ie.D},{name:"Index",test:ie.t},{name:"boolean",test:ie.g},{name:"ResultSet",test:ie.G},{name:"Help",test:ie.s},{name:"function",test:ie.p},{name:"Date",test:ie.m},{name:"RegExp",test:ie.F},{name:"null",test:ie.x},{name:"undefined",test:ie.K},{name:"AccessorNode",test:ie.a},{name:"ArrayNode",test:ie.c},{name:"AssignmentNode",test:ie.d},{name:"BlockNode",test:ie.f},{name:"ConditionalNode",test:ie.k},{name:"ConstantNode",test:ie.l},{name:"FunctionNode",test:ie.r},{name:"FunctionAssignmentNode",test:ie.q},{name:"IndexNode",test:ie.u},{name:"Node",test:ie.w},{name:"ObjectNode",test:ie.A},{name:"OperatorNode",test:ie.B},{name:"ParenthesisNode",test:ie.C},{name:"RangeNode",test:ie.E},{name:"SymbolNode",test:ie.J},{name:"Object",test:ie.z}],e.conversions=[{from:"number",to:"BigNumber",convert:function(e){if(r||u(e),15<Object(N.f)(e))throw new TypeError("Cannot implicitly convert a number with >15 significant digits to BigNumber (value: "+e+"). Use function bignumber(x) to convert to BigNumber.");return new r(e)}},{from:"number",to:"Complex",convert:function(e){return n||c(e),new n(e,0)}},{from:"number",to:"string",convert:function(e){return e+""}},{from:"BigNumber",to:"Complex",convert:function(e){return n||c(e),new n(e.toNumber(),0)}},{from:"Fraction",to:"BigNumber",convert:function(){throw new TypeError("Cannot implicitly convert a Fraction to BigNumber or vice versa. Use function bignumber(x) to convert to BigNumber or fraction(x) to convert to Fraction.")}},{from:"Fraction",to:"Complex",convert:function(e){return n||c(e),new n(e.valueOf(),0)}},{from:"number",to:"Fraction",convert:function(e){i||f(e);var t=new i(e);if(t.valueOf()!==e)throw new TypeError("Cannot implicitly convert a number to a Fraction when there will be a loss of precision (value: "+e+"). Use function fraction(x) to convert to Fraction.");return t}},{from:"string",to:"number",convert:function(e){var t=Number(e);if(isNaN(t))throw new Error('Cannot convert "'+e+'" to a number');return t}},{from:"string",to:"BigNumber",convert:function(t){r||u(t);try{return new r(t)}catch(e){throw new Error('Cannot convert "'+t+'" to BigNumber')}}},{from:"string",to:"Fraction",convert:function(t){i||f(t);try{return new i(t)}catch(e){throw new Error('Cannot convert "'+t+'" to Fraction')}}},{from:"string",to:"Complex",convert:function(t){n||c(t);try{return new n(t)}catch(e){throw new Error('Cannot convert "'+t+'" to Complex')}}},{from:"boolean",to:"number",convert:function(e){return+e}},{from:"boolean",to:"BigNumber",convert:function(e){return r||u(e),new r(+e)}},{from:"boolean",to:"Fraction",convert:function(e){return i||f(e),new i(+e)}},{from:"boolean",to:"string",convert:function(e){return String(e)}},{from:"Array",to:"Matrix",convert:function(e){return t||function(){throw new Error("Cannot convert array into a Matrix: no class 'DenseMatrix' provided")}(),new t(e)}},{from:"Matrix",to:"Array",convert:function(e){return e.valueOf()}}],e});function u(e){throw new Error("Cannot convert value ".concat(e," into a BigNumber: no class 'BigNumber' provided"))}function c(e){throw new Error("Cannot convert value ".concat(e," into a Complex number: no class 'Complex' provided"))}function f(e){throw new Error("Cannot convert value ".concat(e," into a Fraction, no class 'Fraction' provided."))}var n=[],l=Object(a.a)("ResultSet",n,function(){function t(e){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");this.entries=e||[]}return t.prototype.type="ResultSet",t.prototype.isResultSet=!0,t.prototype.valueOf=function(){return this.entries},t.prototype.toString=function(){return"["+this.entries.join(", ")+"]"},t.prototype.toJSON=function(){return{mathjs:"ResultSet",entries:this.entries}},t.fromJSON=function(e){return new t(e.entries)},t},{isClass:!0}),p=r(12),m=r.n(p),t=["?on","config"],h=Object(a.a)("BigNumber",t,function(e){var t=e.on,e=e.config,r=m.a.clone({precision:e.precision,modulo:9});return r.prototype.type="BigNumber",r.prototype.isBigNumber=!0,r.prototype.toJSON=function(){return{mathjs:"BigNumber",value:this.toString()}},r.fromJSON=function(e){return new r(e.value)},t&&t("config",function(e,t){e.precision!==t.precision&&r.config({precision:e.precision})}),r},{isClass:!0}),n=r(8),d=r.n(n);function y(e){return(y="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var t=[],g=Object(a.a)("Complex",t,function(){return d.a.prototype.type="Complex",d.a.prototype.isComplex=!0,d.a.prototype.toJSON=function(){return{mathjs:"Complex",re:this.re,im:this.im}},d.a.prototype.toPolar=function(){return{r:this.abs(),phi:this.arg()}},d.a.prototype.format=function(e){var t=this.im,r=this.re,n=Object(N.h)(this.re,e),i=Object(N.h)(this.im,e),e=Object(ie.y)(e)?e:e?e.precision:null;return null!==e&&(e=Math.pow(10,-e),Math.abs(r/t)<e&&(r=0),Math.abs(t/r)<e&&(t=0)),0===t?n:0===r?1===t?"i":-1===t?"-i":i+"i":t<0?-1===t?n+" - i":n+" - "+i.substring(1)+"i":1===t?n+" + i":n+" + "+i+"i"},d.a.fromPolar=function(e){switch(arguments.length){case 1:var t=e;if("object"===y(t))return d()(t);throw new TypeError("Input has to be an object with r and phi keys.");case 2:t=e,e=arguments[1];if(Object(ie.y)(t)){if(Object(ie.L)(e)&&e.hasBase("ANGLE")&&(e=e.toNumber("rad")),Object(ie.y)(e))return new d.a({r:t,phi:e});throw new TypeError("Phi is not a number nor an angle unit.")}throw new TypeError("Radius r is not a number.");default:throw new SyntaxError("Wrong number of arguments in function fromPolar")}},d.a.prototype.valueOf=d.a.prototype.toString,d.a.fromJSON=function(e){return new d.a(e)},d.a.compare=function(e,t){return e.re>t.re?1:e.re<t.re?-1:e.im>t.im?1:e.im<t.im?-1:0},d.a},{isClass:!0}),n=r(10),b=r.n(n),t=[],v=Object(a.a)("Fraction",t,function(){return b.a.prototype.type="Fraction",b.a.prototype.isFraction=!0,b.a.prototype.toJSON=function(){return{mathjs:"Fraction",n:this.s*this.n,d:this.d}},b.a.fromJSON=function(e){return new b.a(e)},b.a},{isClass:!0}),n=[],x=Object(a.a)("Range",n,function(){function o(e,t,r){if(!(this instanceof o))throw new SyntaxError("Constructor must be called with the new operator");var n=null!=e,i=null!=t,a=null!=r;if(n)if(Object(ie.e)(e))e=e.toNumber();else if("number"!=typeof e)throw new TypeError("Parameter start must be a number");if(i)if(Object(ie.e)(t))t=t.toNumber();else if("number"!=typeof t)throw new TypeError("Parameter end must be a number");if(a)if(Object(ie.e)(r))r=r.toNumber();else if("number"!=typeof r)throw new TypeError("Parameter step must be a number");this.start=n?parseFloat(e):0,this.end=i?parseFloat(t):0,this.step=a?parseFloat(r):1}return o.prototype.type="Range",o.prototype.isRange=!0,o.parse=function(e){if("string"!=typeof e)return null;e=e.split(":").map(function(e){return parseFloat(e)});if(e.some(function(e){return isNaN(e)}))return null;switch(e.length){case 2:return new o(e[0],e[1]);case 3:return new o(e[0],e[2],e[1]);default:return null}},o.prototype.clone=function(){return new o(this.start,this.end,this.step)},o.prototype.size=function(){var e=0,t=this.start,r=this.step,t=this.end-t;return Object(N.n)(r)===Object(N.n)(t)?e=Math.ceil(t/r):0==t&&(e=0),isNaN(e)&&(e=0),[e]},o.prototype.min=function(){var e=this.size()[0];if(0<e)return 0<this.step?this.start:this.start+(e-1)*this.step},o.prototype.max=function(){var e=this.size()[0];if(0<e)return 0<this.step?this.start+(e-1)*this.step:this.start},o.prototype.forEach=function(e){var t=this.start,r=this.step,n=this.end,i=0;if(0<r)for(;t<n;)e(t,[i],this),t+=r,i++;else if(r<0)for(;n<t;)e(t,[i],this),t+=r,i++},o.prototype.map=function(n){var i=[];return this.forEach(function(e,t,r){i[t[0]]=n(e,t,r)}),i},o.prototype.toArray=function(){var r=[];return this.forEach(function(e,t){r[t[0]]=e}),r},o.prototype.valueOf=function(){return this.toArray()},o.prototype.format=function(e){var t=Object(N.h)(this.start,e);return 1!==this.step&&(t+=":"+Object(N.h)(this.step,e)),t+=":"+Object(N.h)(this.end,e)},o.prototype.toString=function(){return this.format()},o.prototype.toJSON=function(){return{mathjs:"Range",start:this.start,end:this.end,step:this.step}},o.fromJSON=function(e){return new o(e.start,e.end,e.step)},o},{isClass:!0}),t=[],w=Object(a.a)("Matrix",t,function(){function e(){if(!(this instanceof e))throw new SyntaxError("Constructor must be called with the new operator")}return e.prototype.type="Matrix",e.prototype.isMatrix=!0,e.prototype.storage=function(){throw new Error("Cannot invoke storage on a Matrix interface")},e.prototype.datatype=function(){throw new Error("Cannot invoke datatype on a Matrix interface")},e.prototype.create=function(e,t){throw new Error("Cannot invoke create on a Matrix interface")},e.prototype.subset=function(e,t,r){throw new Error("Cannot invoke subset on a Matrix interface")},e.prototype.get=function(e){throw new Error("Cannot invoke get on a Matrix interface")},e.prototype.set=function(e,t,r){throw new Error("Cannot invoke set on a Matrix interface")},e.prototype.resize=function(e,t){throw new Error("Cannot invoke resize on a Matrix interface")},e.prototype.reshape=function(e,t){throw new Error("Cannot invoke reshape on a Matrix interface")},e.prototype.clone=function(){throw new Error("Cannot invoke clone on a Matrix interface")},e.prototype.size=function(){throw new Error("Cannot invoke size on a Matrix interface")},e.prototype.map=function(e,t){throw new Error("Cannot invoke map on a Matrix interface")},e.prototype.forEach=function(e){throw new Error("Cannot invoke forEach on a Matrix interface")},e.prototype.toArray=function(){throw new Error("Cannot invoke toArray on a Matrix interface")},e.prototype.valueOf=function(){throw new Error("Cannot invoke valueOf on a Matrix interface")},e.prototype.format=function(e){throw new Error("Cannot invoke format on a Matrix interface")},e.prototype.toString=function(){throw new Error("Cannot invoke toString on a Matrix interface")},e},{isClass:!0}),E=r(2),Z=r(5),ae=r(3),I=r(6),n=["Matrix"],O=Object(a.a)("DenseMatrix",n,function(e){e=e.Matrix;function p(e,t){if(!(this instanceof p))throw new SyntaxError("Constructor must be called with the new operator");if(t&&!Object(ie.I)(t))throw new Error("Invalid datatype: "+t);if(Object(ie.v)(e))"DenseMatrix"===e.type?(this._data=Object(ae.a)(e._data),this._size=Object(ae.a)(e._size)):(this._data=e.toArray(),this._size=e.size()),this._datatype=t||e._datatype;else if(e&&Object(ie.b)(e.data)&&Object(ie.b)(e.size))this._data=e.data,this._size=e.size,Object(E.p)(this._data,this._size),this._datatype=t||e.datatype;else if(Object(ie.b)(e))this._data=function e(t){for(var r=0,n=t.length;r<n;r++){var i=t[r];Object(ie.b)(i)?t[r]=e(i):i&&!0===i.isMatrix&&(t[r]=e(i.valueOf()))}return t}(e),this._size=Object(E.a)(this._data),Object(E.p)(this._data,this._size),this._datatype=t;else{if(e)throw new TypeError("Unsupported type of data ("+Object(ie.M)(e)+")");this._data=[],this._size=[0],this._datatype=t}}function s(e,t,r){if(0!==t.length)return e._size=t.slice(0),e._data=Object(E.m)(e._data,e._size,r),e;for(var n=e._data;Object(ie.b)(n);)n=n[0];return n}function c(e,t,r){for(var n=e._size.slice(0),i=!1;n.length<t.length;)n.push(0),i=!0;for(var a=0,o=t.length;a<o;a++)t[a]>n[a]&&(n[a]=t[a],i=!0);i&&s(e,n,r)}return(p.prototype=new e).createDenseMatrix=function(e,t){return new p(e,t)},p.prototype.type="DenseMatrix",p.prototype.isDenseMatrix=!0,p.prototype.getDataType=function(){return Object(E.h)(this._data,ie.M)},p.prototype.storage=function(){return"dense"},p.prototype.datatype=function(){return this._datatype},p.prototype.create=function(e,t){return new p(e,t)},p.prototype.subset=function(e,t,r){switch(arguments.length){case 1:return function(e,t){if(!Object(ie.t)(t))throw new TypeError("Invalid index");{if(t.isScalar())return e.get(t.min());var r=t.size();if(r.length!==e._size.length)throw new I.a(r.length,e._size.length);for(var n=t.min(),i=t.max(),a=0,o=e._size.length;a<o;a++)Object(E.q)(n[a],e._size[a]),Object(E.q)(i[a],e._size[a]);return new p(function t(r,n,i,a){var e=a===i-1;var o=n.dimension(a);return(e?o.map(function(e){return Object(E.q)(e,r.length),r[e]}):o.map(function(e){Object(E.q)(e,r.length);var e=r[e];return t(e,n,i,a+1)})).valueOf()}(e._data,t,r.length,0),e._datatype)}}(this,e);case 2:case 3:return function(e,t,r,n){if(!t||!0!==t.isIndex)throw new TypeError("Invalid index");var i,a=t.size(),o=t.isScalar();Object(ie.v)(r)?(i=r.size(),r=r.valueOf()):i=Object(E.a)(r);if(o){if(0!==i.length)throw new TypeError("Scalar expected");e.set(t.min(),r,n)}else{if(a.length<e._size.length)throw new I.a(a.length,e._size.length,"<");if(i.length<a.length){for(var s=0,u=0;1===a[s]&&1===i[s];)s++;for(;1===a[s];)u++,s++;r=Object(E.o)(r,a.length,u,i)}if(!Object(ae.d)(a,i))throw new I.a(a,i,">");o=t.max().map(function(e){return e+1});c(e,o,n);n=a.length;!function r(n,i,a,o,s){var e=s===o-1;var t=i.dimension(s);e?t.forEach(function(e,t){Object(E.q)(e),n[e]=a[t[0]]}):t.forEach(function(e,t){Object(E.q)(e),r(n[e],i,a[t[0]],o,s+1)})}(e._data,t,r,n,0)}return e}(this,e,t,r);default:throw new SyntaxError("Wrong number of arguments")}},p.prototype.get=function(e){if(!Object(ie.b)(e))throw new TypeError("Array expected");if(e.length!==this._size.length)throw new I.a(e.length,this._size.length);for(var t=0;t<e.length;t++)Object(E.q)(e[t],this._size[t]);for(var r=this._data,n=0,i=e.length;n<i;n++){var a=e[n];Object(E.q)(a,r.length),r=r[a]}return r},p.prototype.set=function(e,t,r){if(!Object(ie.b)(e))throw new TypeError("Array expected");if(e.length<this._size.length)throw new I.a(e.length,this._size.length,"<");var n;c(this,e.map(function(e){return e+1}),r);for(var i=this._data,a=0,o=e.length-1;a<o;a++)n=e[a],Object(E.q)(n,i.length),i=i[n];return n=e[e.length-1],Object(E.q)(n,i.length),i[n]=t,this},p.prototype.resize=function(e,t,r){if(!Object(ie.i)(e))throw new TypeError("Array or Matrix expected");e=e.valueOf().map(function(e){return Array.isArray(e)&&1===e.length?e[0]:e});return s(r?this.clone():this,e,t)},p.prototype.reshape=function(e,t){t=t?this.clone():this;return t._data=Object(E.l)(t._data,e),t._size=e.slice(0),t},p.prototype.clone=function(){return new p({data:Object(ae.a)(this._data),size:Object(ae.a)(this._size),datatype:this._datatype})},p.prototype.size=function(){return this._size.slice(0)},p.prototype.map=function(t){var i=this,e=function r(e,n){return Object(ie.b)(e)?e.map(function(e,t){return r(e,n.concat(t))}):t(e,n,i)}(this._data,[]);return new p(e,void 0!==this._datatype?Object(E.h)(e,ie.M):void 0)},p.prototype.forEach=function(t){var i=this;(function r(e,n){Object(ie.b)(e)?e.forEach(function(e,t){r(e,n.concat(t))}):t(e,n,i)})(this._data,[])},p.prototype.toArray=function(){return Object(ae.a)(this._data)},p.prototype.valueOf=function(){return this._data},p.prototype.format=function(e){return Object(Z.d)(this._data,e)},p.prototype.toString=function(){return Object(Z.d)(this._data)},p.prototype.toJSON=function(){return{mathjs:"DenseMatrix",data:this._data,size:this._size,datatype:this._datatype}},p.prototype.diagonal=function(e){if(e){if(Object(ie.e)(e)&&(e=e.toNumber()),!Object(ie.y)(e)||!Object(N.i)(e))throw new TypeError("The parameter k must be an integer number")}else e=0;for(var t=0<e?e:0,r=e<0?-e:0,n=this._size[0],e=this._size[1],i=Math.min(n-r,e-t),a=[],o=0;o<i;o++)a[o]=this._data[o+r][o+t];return new p({data:a,size:[i],datatype:this._datatype})},p.diagonal=function(e,t,r,n){if(!Object(ie.b)(e))throw new TypeError("Array expected, size parameter");if(2!==e.length)throw new Error("Only two dimensions matrix are supported");if(e=e.map(function(e){if(Object(ie.e)(e)&&(e=e.toNumber()),!Object(ie.y)(e)||!Object(N.i)(e)||e<1)throw new Error("Size values must be positive integers");return e}),r){if(Object(ie.e)(r)&&(r=r.toNumber()),!Object(ie.y)(r)||!Object(N.i)(r))throw new TypeError("The parameter k must be an integer number")}else r=0;var i,a=0<r?r:0,o=r<0?-r:0,s=e[0],u=e[1],c=Math.min(s-o,u-a);if(Object(ie.b)(t)){if(t.length!==c)throw new Error("Invalid value array length");i=function(e){return t[e]}}else if(Object(ie.v)(t)){r=t.size();if(1!==r.length||r[0]!==c)throw new Error("Invalid matrix length");i=function(e){return t.get([e])}}else i=function(){return t};n=n||(Object(ie.e)(i(0))?i(0).mul(0):0);var f=[];if(0<e.length){f=Object(E.m)(f,e,n);for(var l=0;l<c;l++)f[l+o][l+a]=i(l)}return new p({data:f,size:[s,u]})},p.fromJSON=function(e){return new p(e)},p.prototype.swapRows=function(e,t){if(!(Object(ie.y)(e)&&Object(N.i)(e)&&Object(ie.y)(t)&&Object(N.i)(t)))throw new Error("Row index must be positive integers");if(2!==this._size.length)throw new Error("Only two dimensional matrix is supported");return Object(E.q)(e,this._size[0]),Object(E.q)(t,this._size[0]),p._swapRows(e,t,this._data),this},p._swapRows=function(e,t,r){var n=r[e];r[e]=r[t],r[t]=n},p},{isClass:!0}),t=["typed"],M=Object(a.a)("clone",t,function(e){return(0,e.typed)("clone",{any:ae.a})}),j=r(9);function S(e){for(var t=0;t<e.length;t++)if(Object(ie.i)(e[t]))return 1}function A(e,t){Object(ie.v)(e)&&(e=e.valueOf());for(var r=0,n=e.length;r<n;r++){var i=e[r];Array.isArray(i)?A(i,t):t(i)}}function oe(e,t,r){return e&&"function"==typeof e.map?e.map(function(e){return oe(e,t,r)}):t(e)}function C(e,t,r){var n=Array.isArray(e)?Object(E.a)(e):e.size();if(t<0||t>=n.length)throw new j.a(t,n.length);return Object(ie.v)(e)?e.create(_(e.valueOf(),t,r)):_(e,t,r)}function _(e,t,r){var n,i,a,o;if(t<=0){if(Array.isArray(e[0])){for(o=function(e){var t,r,n=e.length,i=e[0].length,a=[];for(r=0;r<i;r++){var o=[];for(t=0;t<n;t++)o.push(e[t][r]);a.push(o)}return a}(e),i=[],n=0;n<o.length;n++)i[n]=_(o[n],t-1,r);return i}for(a=e[0],n=1;n<e.length;n++)a=r(a,e[n]);return a}for(i=[],n=0;n<e.length;n++)i[n]=_(e[n],t-1,r);return i}function T(e,t,r,n,i,a,o,s,u,c,f){var l,p,m,h,d=e._values,y=e._index,e=e._ptr;if(n)for(p=e[t],m=e[t+1],l=p;l<m;l++)r[h=y[l]]!==a?(r[h]=a,o.push(h),c?(n[h]=u?s(d[l],f):s(f,d[l]),i[h]=a):n[h]=d[l]):(n[h]=u?s(d[l],n[h]):s(n[h],d[l]),i[h]=a);else for(p=e[t],m=e[t+1],l=p;l<m;l++)r[h=y[l]]!==a?(r[h]=a,o.push(h)):i[h]=a}var q="isInteger",n=["typed"],B=Object(a.a)(q,n,function(e){return(0,e.typed)(q,{number:N.i,BigNumber:function(e){return e.isInt()},Fraction:function(e){return 1===e.d&&isFinite(e.n)},"Array | Matrix":function(e){return oe(e,this)}})}),t="number";function k(e){return e<0}function z(e){return 0<e}function D(e){return 0===e}function R(e){return Number.isNaN(e)}R.signature=D.signature=z.signature=k.signature=t;var U="isNegative",n=["typed"],P=Object(a.a)(U,n,function(e){return(0,e.typed)(U,{number:k,BigNumber:function(e){return e.isNeg()&&!e.isZero()&&!e.isNaN()},Fraction:function(e){return e.s<0},Unit:function(e){return this(e.value)},"Array | Matrix":function(e){return oe(e,this)}})}),F="isNumeric",t=["typed"],L=Object(a.a)(F,t,function(e){return(0,e.typed)(F,{"number | BigNumber | Fraction | boolean":function(){return!0},"Complex | Unit | string | null | undefined | Node":function(){return!1},"Array | Matrix":function(e){return oe(e,this)}})}),H="hasNumericValue",n=["typed","isNumeric"],$=Object(a.a)(H,n,function(e){var t=e.typed,r=e.isNumeric;return t(H,{string:function(e){return 0<e.trim().length&&!isNaN(Number(e))},any:function(e){return r(e)}})}),G="isPositive",t=["typed"],V=Object(a.a)(G,t,function(e){return(0,e.typed)(G,{number:z,BigNumber:function(e){return!e.isNeg()&&!e.isZero()&&!e.isNaN()},Fraction:function(e){return 0<e.s&&0<e.n},Unit:function(e){return this(e.value)},"Array | Matrix":function(e){return oe(e,this)}})}),n=["typed"],J=Object(a.a)("isZero",n,function(e){return(0,e.typed)("isZero",{number:D,BigNumber:function(e){return e.isZero()},Complex:function(e){return 0===e.re&&0===e.im},Fraction:function(e){return 1===e.d&&0===e.n},Unit:function(e){return this(e.value)},"Array | Matrix":function(e){return oe(e,this)}})}),t=["typed"],W=Object(a.a)("isNaN",t,function(e){return(0,e.typed)("isNaN",{number:R,BigNumber:function(e){return e.isNaN()},Fraction:function(){return!1},Complex:function(e){return e.isNaN()},Unit:function(e){return Number.isNaN(e.value)},"Array | Matrix":function(e){return oe(e,Number.isNaN)}})}),n=["typed"],Y=Object(a.a)("typeOf",n,function(e){return(0,e.typed)("typeOf",{any:ie.M})});function X(e,t,r){if(null==r)return e.eq(t);if(e.eq(t))return!0;if(e.isNaN()||t.isNaN())return!1;if(e.isFinite()&&t.isFinite()){var n=e.minus(t).abs();if(n.isZero())return!0;t=e.constructor.max(e.abs(),t.abs());return n.lte(t.times(r))}return!1}var Q="equalScalar",t=["typed","config"],K=Object(a.a)(Q,t,function(e){var t=e.typed,n=e.config;return t(Q,{"boolean, boolean":function(e,t){return e===t},"number, number":function(e,t){return Object(N.m)(e,t,n.epsilon)},"BigNumber, BigNumber":function(e,t){return e.eq(t)||X(e,t,n.epsilon)},"Fraction, Fraction":function(e,t){return e.equals(t)},"Complex, Complex":function(e,t){return r=e,e=t,t=n.epsilon,Object(N.m)(r.re,e.re,t)&&Object(N.m)(r.im,e.im,t);var r},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return this(e.value,t.value)}})}),n=(Object(a.a)(Q,["typed","config"],function(e){var t=e.typed,r=e.config;return t(Q,{"number, number":function(e,t){return Object(N.m)(e,t,r.epsilon)}})}),["typed","equalScalar","Matrix"]),ee=Object(a.a)("SparseMatrix",n,function(e){var O=e.typed,M=e.equalScalar,e=e.Matrix;function j(e,t){if(!(this instanceof j))throw new SyntaxError("Constructor must be called with the new operator");if(t&&!Object(ie.I)(t))throw new Error("Invalid datatype: "+t);if(Object(ie.v)(e))r=this,i=t,"SparseMatrix"===(n=e).type?(r._values=n._values?Object(ae.a)(n._values):void 0,r._index=Object(ae.a)(n._index),r._ptr=Object(ae.a)(n._ptr),r._size=Object(ae.a)(n._size),r._datatype=i||n._datatype):a(r,n.valueOf(),i||n._datatype);else if(e&&Object(ie.b)(e.index)&&Object(ie.b)(e.ptr)&&Object(ie.b)(e.size))this._values=e.values,this._index=e.index,this._ptr=e.ptr,this._size=e.size,this._datatype=t||e.datatype;else if(Object(ie.b)(e))a(this,e,t);else{if(e)throw new TypeError("Unsupported type of data ("+Object(ie.M)(e)+")");this._values=[],this._index=[],this._ptr=[0],this._size=[0,0],this._datatype=t}var r,n,i}function a(e,t,r){e._values=[],e._index=[],e._ptr=[],e._datatype=r;var n=t.length,i=0,a=M,o=0;if(Object(ie.I)(r)&&(a=O.find(M,[r,r])||M,o=O.convert(0,r)),0<n){var s=0;do{e._ptr.push(e._index.length);for(var u=0;u<n;u++){var c,f=t[u];Object(ie.b)(f)?(0===s&&i<f.length&&(i=f.length),s<f.length&&(a(c=f[s],o)||(e._values.push(c),e._index.push(u)))):(0===s&&i<1&&(i=1),a(f,o)||(e._values.push(f),e._index.push(u)))}}while(++s<i)}e._ptr.push(e._index.length),e._size=[n,i]}function y(e,t,r,n){if(r-t==0)return r;for(var i=t;i<r;i++)if(n[i]===e)return i;return t}function g(e,t,r,n,i,a,o){i.splice(e,0,n),a.splice(e,0,t);for(var s=r+1;s<o.length;s++)o[s]++}function u(e,t,r,n){var i=n||0,a=M,n=0;Object(ie.I)(e._datatype)&&(a=O.find(M,[e._datatype,e._datatype])||M,n=O.convert(0,e._datatype),i=O.convert(i,e._datatype));var o=!a(i,n),s=e._size[0],u=e._size[1];if(u<r){for(f=u;f<r;f++)if(e._ptr[f]=e._values.length,o)for(p=0;p<s;p++)e._values.push(i),e._index.push(p);e._ptr[r]=e._values.length}else r<u&&(e._ptr.splice(r+1,u-r),e._values.splice(e._ptr[r],e._values.length),e._index.splice(e._ptr[r],e._index.length));if(u=r,s<t){if(o){for(var c=0,f=0;f<u;f++){e._ptr[f]=e._ptr[f]+c,y=e._ptr[f+1]+c;for(var l=0,p=s;p<t;p++,l++)e._values.splice(y+l,0,i),e._index.splice(y+l,0,p),c++}e._ptr[u]=e._values.length}}else if(t<s){var m=0;for(f=0;f<u;f++){e._ptr[f]=e._ptr[f]-m;for(var h=e._ptr[f],d=e._ptr[f+1]-m,y=h;y<d;y++)t-1<(p=e._index[y])&&(e._values.splice(y,1),e._index.splice(y,1),m++)}e._ptr[f]=e._values.length}return e._size[0]=t,e._size[1]=r,e}function t(e,t,r,n,i){for(var a,o=n[0],s=n[1],u=[],c=0;c<o;c++)for(u[c]=[],a=0;a<s;a++)u[c][a]=0;for(a=0;a<s;a++)for(var f=r[a],l=r[a+1],p=f;p<l;p++)u[c=t[p]][a]=e?i?Object(ae.a)(e[p]):e[p]:1;return u}return(j.prototype=new e).createSparseMatrix=function(e,t){return new j(e,t)},j.prototype.type="SparseMatrix",j.prototype.isSparseMatrix=!0,j.prototype.getDataType=function(){return Object(E.h)(this._values,ie.M)},j.prototype.storage=function(){return"sparse"},j.prototype.datatype=function(){return this._datatype},j.prototype.create=function(e,t){return new j(e,t)},j.prototype.density=function(){var e=this._size[0],t=this._size[1];return 0!==e&&0!==t?this._index.length/(e*t):0},j.prototype.subset=function(e,t,r){if(!this._values)throw new Error("Cannot invoke subset on a Pattern only matrix");switch(arguments.length){case 1:return function(e,t){if(!Object(ie.t)(t))throw new TypeError("Invalid index");if(t.isScalar())return e.get(t.min());var r,n,i,a,o=t.size();if(o.length!==e._size.length)throw new I.a(o.length,e._size.length);var s=t.min(),u=t.max();for(r=0,n=e._size.length;r<n;r++)Object(E.q)(s[r],e._size[r]),Object(E.q)(u[r],e._size[r]);var c=e._values,f=e._index,l=e._ptr,p=t.dimension(0),t=t.dimension(1),m=[],h=[];p.forEach(function(e,t){h[e]=t[0],m[e]=!0});var d=c?[]:void 0,y=[],g=[];return t.forEach(function(e){for(g.push(y.length),i=l[e],a=l[e+1];i<a;i++)r=f[i],!0===m[r]&&(y.push(h[r]),d&&d.push(c[i]))}),g.push(y.length),new j({values:d,index:y,ptr:g,size:o,datatype:e._datatype})}(this,e);case 2:case 3:return function(e,t,r,n){if(!t||!0!==t.isIndex)throw new TypeError("Invalid index");var i,a=t.size(),o=t.isScalar();Object(ie.v)(r)?(i=r.size(),r=r.toArray()):i=Object(E.a)(r);if(o){if(0!==i.length)throw new TypeError("Scalar expected");e.set(t.min(),r,n)}else{if(1!==a.length&&2!==a.length)throw new I.a(a.length,e._size.length,"<");if(i.length<a.length){for(var s=0,u=0;1===a[s]&&1===i[s];)s++;for(;1===a[s];)u++,s++;r=Object(E.o)(r,a.length,u,i)}if(!Object(ae.d)(a,i))throw new I.a(a,i,">");for(var c=t.min()[0],f=t.min()[1],l=i[0],p=i[1],m=0;m<l;m++)for(var h=0;h<p;h++){var d=r[m][h];e.set([m+c,h+f],d,n)}}return e}(this,e,t,r);default:throw new SyntaxError("Wrong number of arguments")}},j.prototype.get=function(e){if(!Object(ie.b)(e))throw new TypeError("Array expected");if(e.length!==this._size.length)throw new I.a(e.length,this._size.length);if(!this._values)throw new Error("Cannot invoke get on a Pattern only matrix");var t=e[0],r=e[1];Object(E.q)(t,this._size[0]),Object(E.q)(r,this._size[1]);e=y(t,this._ptr[r],this._ptr[r+1],this._index);return e<this._ptr[r+1]&&this._index[e]===t?this._values[e]:0},j.prototype.set=function(e,t,r){if(!Object(ie.b)(e))throw new TypeError("Array expected");if(e.length!==this._size.length)throw new I.a(e.length,this._size.length);if(!this._values)throw new Error("Cannot invoke set on a Pattern only matrix");var n=e[0],i=e[1],a=this._size[0],o=this._size[1],s=M,e=0;Object(ie.I)(this._datatype)&&(s=O.find(M,[this._datatype,this._datatype])||M,e=O.convert(0,this._datatype)),(a-1<n||o-1<i)&&(u(this,Math.max(n+1,a),Math.max(i+1,o),r),a=this._size[0],o=this._size[1]),Object(E.q)(n,a),Object(E.q)(i,o);o=y(n,this._ptr[i],this._ptr[i+1],this._index);return o<this._ptr[i+1]&&this._index[o]===n?s(t,e)?function(e,t,r,n,i){r.splice(e,1),n.splice(e,1);for(var a=t+1;a<i.length;a++)i[a]--}(o,i,this._values,this._index,this._ptr):this._values[o]=t:g(o,n,i,t,this._values,this._index,this._ptr),this},j.prototype.resize=function(e,t,r){if(!Object(ie.i)(e))throw new TypeError("Array or Matrix expected");var n=e.valueOf().map(function(e){return Array.isArray(e)&&1===e.length?e[0]:e});if(2!==n.length)throw new Error("Only two dimensions matrix are supported");return n.forEach(function(e){if(!Object(ie.y)(e)||!Object(N.i)(e)||e<0)throw new TypeError("Invalid size, must contain positive integers (size: "+Object(Z.d)(n)+")")}),u(r?this.clone():this,n[0],n[1],t)},j.prototype.reshape=function(t,e){if(!Object(ie.b)(t))throw new TypeError("Array expected");if(2!==t.length)throw new Error("Sparse matrices can only be reshaped in two dimensions");if(t.forEach(function(e){if(!Object(ie.y)(e)||!Object(N.i)(e)||e<0)throw new TypeError("Invalid size, must contain positive integers (size: "+Object(Z.d)(t)+")")}),this._size[0]*this._size[1]!=t[0]*t[1])throw new Error("Reshaping sparse matrix will result in the wrong number of elements");var r=e?this.clone():this;if(this._size[0]===t[0]&&this._size[1]===t[1])return r;for(var n=[],i=0;i<r._ptr.length;i++)for(var a=0;a<r._ptr[i+1]-r._ptr[i];a++)n.push(i);for(var o=r._values.slice(),s=r._index.slice(),u=0;u<r._index.length;u++){var c=s[u],f=n[u],f=c*r._size[1]+f;n[u]=f%t[1],s[u]=Math.floor(f/t[1])}r._values.length=0,r._index.length=0,r._ptr.length=t[1]+1,r._size=t.slice();for(var l=0;l<r._ptr.length;l++)r._ptr[l]=0;for(var p=0;p<o.length;p++){var m=s[p],h=n[p],d=o[p];g(y(m,r._ptr[h],r._ptr[h+1],r._index),m,h,d,r._values,r._index,r._ptr)}return r},j.prototype.clone=function(){return new j({values:this._values?Object(ae.a)(this._values):void 0,index:Object(ae.a)(this._index),ptr:Object(ae.a)(this._ptr),size:Object(ae.a)(this._size),datatype:this._datatype})},j.prototype.size=function(){return this._size.slice(0)},j.prototype.map=function(n,e){if(!this._values)throw new Error("Cannot invoke map on a Pattern only matrix");var i=this;return function(e,t,r,n,i,a,o){var s=[],u=[],c=[],f=M,l=0;Object(ie.I)(e._datatype)&&(f=O.find(M,[e._datatype,e._datatype])||M,l=O.convert(0,e._datatype));for(var p=function(e,t,r){e=a(e,t,r),f(e,l)||(s.push(e),u.push(t))},m=n;m<=i;m++){c.push(s.length);var h=e._ptr[m],d=e._ptr[m+1];if(o)for(var y=h;y<d;y++){var g=e._index[y];t<=g&&g<=r&&p(e._values[y],g-t,m-n)}else{for(var b={},v=h;v<d;v++){var x=e._index[v];b[x]=e._values[v]}for(var w=t;w<=r;w++){var N=w in b?b[w]:0;p(N,w-t,m-n)}}}return c.push(s.length),new j({values:s,index:u,ptr:c,size:[r-t+1,i-n+1]})}(this,0,this._size[0]-1,0,this._size[1]-1,function(e,t,r){return n(e,[t,r],i)},e)},j.prototype.forEach=function(e,t){if(!this._values)throw new Error("Cannot invoke forEach on a Pattern only matrix");for(var r=this._size[0],n=this._size[1],i=0;i<n;i++){var a=this._ptr[i],o=this._ptr[i+1];if(t)for(var s=a;s<o;s++){var u=this._index[s];e(this._values[s],[u,i],this)}else{for(var c={},f=a;f<o;f++)c[this._index[f]]=this._values[f];for(var l=0;l<r;l++)e(l in c?c[l]:0,[l,i],this)}}},j.prototype.toArray=function(){return t(this._values,this._index,this._ptr,this._size,!0)},j.prototype.valueOf=function(){return t(this._values,this._index,this._ptr,this._size,!1)},j.prototype.format=function(e){for(var t=this._size[0],r=this._size[1],n=this.density(),i="Sparse Matrix ["+Object(Z.d)(t,e)+" x "+Object(Z.d)(r,e)+"] density: "+Object(Z.d)(n,e)+"\n",a=0;a<r;a++)for(var o=this._ptr[a],s=this._ptr[a+1],u=o;u<s;u++){var c=this._index[u];i+="\n    ("+Object(Z.d)(c,e)+", "+Object(Z.d)(a,e)+") ==> "+(this._values?Object(Z.d)(this._values[u],e):"X")}return i},j.prototype.toString=function(){return Object(Z.d)(this.toArray())},j.prototype.toJSON=function(){return{mathjs:"SparseMatrix",values:this._values,index:this._index,ptr:this._ptr,size:this._size,datatype:this._datatype}},j.prototype.diagonal=function(e){if(e){if(Object(ie.e)(e)&&(e=e.toNumber()),!Object(ie.y)(e)||!Object(N.i)(e))throw new TypeError("The parameter k must be an integer number")}else e=0;var t=0<e?e:0,r=e<0?-e:0,e=this._size[0],n=this._size[1],i=Math.min(e-r,n-t),a=[],o=[],e=[];e[0]=0;for(var s=t;s<n&&a.length<i;s++)for(var u=this._ptr[s],c=this._ptr[s+1],f=u;f<c;f++){var l=this._index[f];if(l===s-t+r){a.push(this._values[f]),o[a.length-1]=l-r;break}}return e.push(a.length),new j({values:a,index:o,ptr:e,size:[i,1]})},j.fromJSON=function(e){return new j(e)},j.diagonal=function(e,t,r,n,i){if(!Object(ie.b)(e))throw new TypeError("Array expected, size parameter");if(2!==e.length)throw new Error("Only two dimensions matrix are supported");if(e=e.map(function(e){if(Object(ie.e)(e)&&(e=e.toNumber()),!Object(ie.y)(e)||!Object(N.i)(e)||e<1)throw new Error("Size values must be positive integers");return e}),r){if(Object(ie.e)(r)&&(r=r.toNumber()),!Object(ie.y)(r)||!Object(N.i)(r))throw new TypeError("The parameter k must be an integer number")}else r=0;var a=M,o=0;Object(ie.I)(i)&&(a=O.find(M,[i,i])||M,o=O.convert(0,i));var s,u=0<r?r:0,c=r<0?-r:0,r=e[0],f=e[1],l=Math.min(r-c,f-u);if(Object(ie.b)(t)){if(t.length!==l)throw new Error("Invalid value array length");s=function(e){return t[e]}}else if(Object(ie.v)(t)){e=t.size();if(1!==e.length||e[0]!==l)throw new Error("Invalid matrix length");s=function(e){return t.get([e])}}else s=function(){return t};for(var p=[],m=[],h=[],d=0;d<f;d++){h.push(p.length);var y,g=d-u;0<=g&&g<l&&(a(y=s(g),o)||(m.push(g+c),p.push(y)))}return h.push(p.length),new j({values:p,index:m,ptr:h,size:[r,f]})},j.prototype.swapRows=function(e,t){if(!(Object(ie.y)(e)&&Object(N.i)(e)&&Object(ie.y)(t)&&Object(N.i)(t)))throw new Error("Row index must be positive integers");if(2!==this._size.length)throw new Error("Only two dimensional matrix is supported");return Object(E.q)(e,this._size[0]),Object(E.q)(t,this._size[0]),j._swapRows(e,t,this._size[1],this._values,this._index,this._ptr),this},j._forEachRow=function(e,t,r,n,i){for(var a=n[e],o=n[e+1],s=a;s<o;s++)i(r[s],t[s])},j._swapRows=function(e,t,r,n,i,a){for(var o=0;o<r;o++){var s,u=a[o],c=a[o+1],f=y(e,u,c,i),u=y(t,u,c,i);f<c&&u<c&&i[f]===e&&i[u]===t?n&&(s=n[f],n[f]=n[u],n[u]=s):f<c&&i[f]===e&&(c<=u||i[u]!==t)?(s=n?n[f]:void 0,i.splice(u,0,t),n&&n.splice(u,0,s),i.splice(u<=f?f+1:f,1),n&&n.splice(u<=f?f+1:f,1)):u<c&&i[u]===t&&(c<=f||i[f]!==e)&&(c=n?n[u]:void 0,i.splice(f,0,e),n&&n.splice(f,0,c),i.splice(f<=u?u+1:u,1),n&&n.splice(f<=u?u+1:u,1))}},j},{isClass:!0}),t=["typed"],te=Object(a.a)("number",t,function(e){e=(0,e.typed)("number",{"":function(){return 0},number:function(e){return e},string:function(e){if("NaN"===e)return NaN;var t=Number(e);if(isNaN(t))throw new SyntaxError('String "'+e+'" is no valid number');if(["0b","0o","0x"].includes(e.substring(0,2))){if(t>Math.pow(2,32)-1)throw new SyntaxError('String "'.concat(e,'" is out of range'));2147483648&t&&(t=-1*~(t-1))}return t},BigNumber:function(e){return e.toNumber()},Fraction:function(e){return e.valueOf()},Unit:function(){throw new Error("Second argument with valueless unit expected")},null:function(){return 0},"Unit, string | Unit":function(e,t){return e.toNumber(t)},"Array | Matrix":function(e){return oe(e,this)}});return e.fromJSON=function(e){return parseFloat(e.value)},e}),n=["typed"],re=Object(a.a)("string",n,function(e){return(0,e.typed)("string",{"":function(){return""},number:N.h,null:function(){return"null"},boolean:function(e){return e+""},string:function(e){return e},"Array | Matrix":function(e){return oe(e,this)},any:function(e){return String(e)}})}),ne="boolean",t=["typed"],se=Object(a.a)(ne,t,function(e){return(0,e.typed)(ne,{"":function(){return!1},boolean:function(e){return e},number:function(e){return!!e},null:function(){return!1},BigNumber:function(e){return!e.isZero()},string:function(e){var t=e.toLowerCase();if("true"===t)return!0;if("false"===t)return!1;t=Number(e);if(""!==e&&!isNaN(t))return!!t;throw new Error('Cannot convert "'+e+'" to a boolean')},"Array | Matrix":function(e){return oe(e,this)}})}),n=["typed","BigNumber"],ue=Object(a.a)("bignumber",n,function(e){var t=e.typed,r=e.BigNumber;return t("bignumber",{"":function(){return new r(0)},number:function(e){return new r(e+"")},string:function(e){return new r(e)},BigNumber:function(e){return e},Fraction:function(e){return new r(e.n).div(e.d).times(e.s)},null:function(){return new r(0)},"Array | Matrix":function(e){return oe(e,this)}})}),t=["typed","Complex"],ce=Object(a.a)("complex",t,function(e){var t=e.typed,r=e.Complex;return t("complex",{"":function(){return r.ZERO},number:function(e){return new r(e,0)},"number, number":function(e,t){return new r(e,t)},"BigNumber, BigNumber":function(e,t){return new r(e.toNumber(),t.toNumber())},Fraction:function(e){return new r(e.valueOf(),0)},Complex:function(e){return e.clone()},string:function(e){return r(e)},null:function(){return r(0)},Object:function(e){if("re"in e&&"im"in e)return new r(e.re,e.im);if("r"in e&&"phi"in e||"abs"in e&&"arg"in e)return new r(e);throw new Error("Expected object with properties (re and im) or (r and phi) or (abs and arg)")},"Array | Matrix":function(e){return oe(e,this)}})}),n=["typed","Fraction"],fe=Object(a.a)("fraction",n,function(e){var t=e.typed,r=e.Fraction;return t("fraction",{number:function(e){if(!isFinite(e)||isNaN(e))throw new Error(e+" cannot be represented as a fraction");return new r(e)},string:function(e){return new r(e)},"number, number":function(e,t){return new r(e,t)},null:function(){return new r(0)},BigNumber:function(e){return new r(e.toString())},Fraction:function(e){return e},Object:function(e){return new r(e)},"Array | Matrix":function(e){return oe(e,this)}})}),t=["typed","Matrix","DenseMatrix","SparseMatrix"],le=Object(a.a)("matrix",t,function(e){var t=e.typed,n=(e.Matrix,e.DenseMatrix),i=e.SparseMatrix;return t("matrix",{"":function(){return r([])},string:function(e){return r([],e)},"string, string":function(e,t){return r([],e,t)},Array:function(e){return r(e)},Matrix:function(e){return r(e,e.storage())},"Array | Matrix, string":r,"Array | Matrix, string, string":r});function r(e,t,r){if("dense"===t||"default"===t||void 0===t)return new n(e,r);if("sparse"===t)return new i(e,r);throw new TypeError("Unknown matrix type "+JSON.stringify(t)+".")}}),pe="splitUnit",n=["typed"],me=Object(a.a)(pe,n,function(e){return(0,e.typed)(pe,{"Unit, Array":function(e,t){return e.splitUnit(t)}})}),t="number",n="number, number";function he(e){return Math.abs(e)}function de(e,t){return e+t}function ye(e,t){return e*t}function ge(e){return-e}function be(e){return e}function ve(e){return Object(N.d)(e)}function xe(e){return Math.ceil(e)}function we(e){return e*e*e}function Ne(e){return Math.exp(e)}function Oe(e){return Object(N.g)(e)}function Me(e,t){if(!Object(N.i)(e)||!Object(N.i)(t))throw new Error("Parameters in function gcd must be integer numbers");for(var r;0!==t;)r=e%t,e=t,t=r;return e<0?-e:e}function je(e,t){if(!Object(N.i)(e)||!Object(N.i)(t))throw new Error("Parameters in function lcm must be integer numbers");if(0===e||0===t)return 0;for(var r,n=e*t;0!==t;)t=e%(r=t),e=r;return Math.abs(n/e)}function Ee(e){return Math.log(e)}function Se(e){return Object(N.j)(e)}function Ae(e){return Object(N.l)(e)}function Ce(e,t){if(0<t)return e-t*Math.floor(e/t);if(0===t)return e;throw new Error("Cannot calculate mod for a negative divisor")}function _e(e,t){var r=t<0;if(r&&(t=-t),0===t)throw new Error("Root must be non-zero");if(e<0&&Math.abs(t)%2!=1)throw new Error("Root must be odd when a is negative.");if(0===e)return r?1/0:0;if(!isFinite(e))return r?0:e;t=Math.pow(Math.abs(e),1/t),t=e<0?-t:t;return r?1/t:t}function Te(e){return Object(N.n)(e)}function qe(e){return e*e}function Ie(e,t){var r,n,i,a=0,o=1,s=1,u=0;if(!Object(N.i)(e)||!Object(N.i)(t))throw new Error("Parameters in function xgcd must be integer numbers");for(;t;)i=e-(n=Math.floor(e/t))*t,a=o-n*(r=a),o=r,s=u-n*(r=s),u=r,e=t,t=i;return e<0?[-e,-o,-u]:[e,e?o:0,u]}function Be(e,t){return e*e<1&&t===1/0||1<e*e&&t===-1/0?0:Math.pow(e,t)}function ke(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0;return parseFloat(Object(N.q)(e,t))}he.signature=t,ye.signature=de.signature=n,Oe.signature=Ne.signature=we.signature=xe.signature=ve.signature=be.signature=ge.signature=t,je.signature=Me.signature=n,Ae.signature=Se.signature=Ee.signature=t,_e.signature=Ce.signature=n,qe.signature=Te.signature=t,ke.signature=Be.signature=Ie.signature=n;var ze="unaryMinus",t=["typed"],De=Object(a.a)(ze,t,function(e){return(0,e.typed)(ze,{number:ge,Complex:function(e){return e.neg()},BigNumber:function(e){return e.neg()},Fraction:function(e){return e.neg()},Unit:function(e){var t=e.clone();return t.value=this(e.value),t},"Array | Matrix":function(e){return oe(e,this,!0)}})}),Re="unaryPlus",n=["typed","config","BigNumber"],Ue=Object(a.a)(Re,n,function(e){var t=e.typed,r=e.config,n=e.BigNumber;return t(Re,{number:be,Complex:function(e){return e},BigNumber:function(e){return e},Fraction:function(e){return e},Unit:function(e){return e.clone()},"Array | Matrix":function(e){return oe(e,this,!0)},"boolean | string":function(e){return"BigNumber"===r.number?new n(+e):+e}})}),t=["typed"],Pe=Object(a.a)("abs",t,function(e){return(0,e.typed)("abs",{number:he,Complex:function(e){return e.abs()},BigNumber:function(e){return e.abs()},Fraction:function(e){return e.abs()},"Array | Matrix":function(e){return oe(e,this,!0)},Unit:function(e){return e.abs()}})}),n=["typed","isInteger"],Fe=Object(a.a)("apply",n,function(e){var t=e.typed,i=e.isInteger;return t("apply",{"Array | Matrix, number | BigNumber, function":function(e,t,r){if(!i(t))throw new TypeError("Integer number expected for dimension");var n=Array.isArray(e)?Object(E.a)(e):e.size();if(t<0||t>=n.length)throw new j.a(t,n.length);return Object(ie.v)(e)?e.create(Le(e.valueOf(),t,r)):Le(e,t,r)}})});function Le(e,t,r){var n,i,a;if(t<=0){if(Array.isArray(e[0])){for(a=function(e){var t,r,n=e.length,i=e[0].length,a=[];for(r=0;r<i;r++){var o=[];for(t=0;t<n;t++)o.push(e[t][r]);a.push(o)}return a}(e),i=[],n=0;n<a.length;n++)i[n]=Le(a[n],t-1,r);return i}return r(e)}for(i=[],n=0;n<e.length;n++)i[n]=Le(e[n],t-1,r);return i}var He="addScalar",t=["typed"],$e=Object(a.a)(He,t,function(e){return(0,e.typed)(He,{"number, number":de,"Complex, Complex":function(e,t){return e.add(t)},"BigNumber, BigNumber":function(e,t){return e.plus(t)},"Fraction, Fraction":function(e,t){return e.add(t)},"Unit, Unit":function(e,t){if(null===e.value||void 0===e.value)throw new Error("Parameter x contains a unit with undefined value");if(null===t.value||void 0===t.value)throw new Error("Parameter y contains a unit with undefined value");if(!e.equalBase(t))throw new Error("Units do not match");e=e.clone();return e.value=this(e.value,t.value),e.fixPrefix=!1,e}})}),n=["config","typed","isNegative","unaryMinus","matrix","Complex","BigNumber","Fraction"],Ge=Object(a.a)("cbrt",n,function(e){var i=e.config,t=e.typed,n=e.isNegative,a=e.unaryMinus,o=e.matrix,s=e.Complex,u=e.BigNumber,c=e.Fraction;return t("cbrt",{number:ve,Complex:f,"Complex, boolean":f,BigNumber:function(e){return e.cbrt()},Unit:function(e){{if(e.value&&Object(ie.j)(e.value)){var t=e.clone();return t.value=1,(t=t.pow(1/3)).value=f(e.value),t}var r=n(e.value);r&&(e.value=a(e.value)),t=Object(ie.e)(e.value)?new u(1).div(3):Object(ie.o)(e.value)?new c(1,3):1/3;t=e.pow(t);return r&&(t.value=a(t.value)),t}},"Array | Matrix":function(e){return oe(e,this,!0)}});function f(e,t){var r=e.arg()/3,n=e.abs(),e=new s(ve(n),0).mul(new s(0,r).exp());if(t){r=[e,new s(ve(n),0).mul(new s(0,r+2*Math.PI/3).exp()),new s(ve(n),0).mul(new s(0,r-2*Math.PI/3).exp())];return"Array"===i.matrix?r:o(r)}return e}}),t=["typed","equalScalar"],Ve=Object(a.a)("algorithm11",t,function(e){var M=e.typed,j=e.equalScalar;return function(e,t,r,n){var i=e._values,a=e._index,o=e._ptr,s=e._size,u=e._datatype;if(!i)throw new Error("Cannot perform operation on Pattern Sparse Matrix and Scalar value");var c,f=s[0],l=s[1],p=j,m=0,h=r;"string"==typeof u&&(c=u,p=M.find(j,[c,c]),m=M.convert(0,c),t=M.convert(t,c),h=M.find(r,[c,c]));for(var d=[],y=[],g=[],b=0;b<l;b++){g[b]=y.length;for(var v=o[b],x=o[b+1],w=v;w<x;w++){var N=a[w],O=n?h(t,i[w]):h(i[w],t);p(O,m)||(y.push(N),d.push(O))}}return g[l]=y.length,e.createSparseMatrix({values:d,index:y,ptr:g,size:[f,l],datatype:c})}}),n=["typed"],Ze=Object(a.a)("algorithm14",n,function(e){var c=e.typed;return function(e,t,r,n){var i,a=e._data,o=e._size,s=e._datatype,u=r;"string"==typeof s&&(i=s,t=c.convert(t,i),u=c.find(r,[i,i]));n=0<o.length?function e(t,r,n,i,a,o,s){var u=[];if(r===n.length-1)for(var c=0;c<i;c++)u[c]=s?t(o,a[c]):t(a[c],o);else for(var f=0;f<i;f++)u[f]=e(t,r+1,n,n[r+1],a[f],o,s);return u}(u,0,o,o[0],a,t,n):[];return e.createDenseMatrix({data:n,size:Object(ae.a)(o),datatype:i})}});function Je(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){if("undefined"==typeof Symbol||!(Symbol.iterator in Object(e)))return;var r=[],n=!0,i=!1,a=void 0;try{for(var o,s=e[Symbol.iterator]();!(n=(o=s.next()).done)&&(r.push(o.value),!t||r.length!==t);n=!0);}catch(e){i=!0,a=e}finally{try{n||null==s.return||s.return()}finally{if(i)throw a}}return r}(e,t)||function(e,t){if(!e)return;if("string"==typeof e)return We(e,t);var r=Object.prototype.toString.call(e).slice(8,-1);"Object"===r&&e.constructor&&(r=e.constructor.name);if("Map"===r||"Set"===r)return Array.from(e);if("Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r))return We(e,t)}(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function We(e,t){(null==t||t>e.length)&&(t=e.length);for(var r=0,n=new Array(t);r<t;r++)n[r]=e[r];return n}var t=["typed","config","round","matrix","equalScalar"],Ye=Object(a.a)("ceil",t,function(e){var t=e.typed,i=e.config,a=e.round,r=e.matrix,e=e.equalScalar,n=Ve({typed:t,equalScalar:e}),o=Ze({typed:t});return t("ceil",{number:function(e){return(Object(N.m)(e,a(e),i.epsilon)?a:xe)(e)},"number, number":function(e,t){if(Object(N.m)(e,a(e,t),i.epsilon))return a(e,t);var r=Je("".concat(e,"e").split("e"),2),n=r[0],e=r[1],r=Math.ceil(Number("".concat(n,"e").concat(Number(e)+t))),r=Je("".concat(r,"e").split("e"),2),n=r[0],e=r[1];return Number("".concat(n,"e").concat(Number(e)-t))},Complex:function(e){return e.ceil()},"Complex, number":function(e,t){return e.ceil(t)},BigNumber:function(e){return X(e,a(e),i.epsilon)?a(e):e.ceil()},"BigNumber, BigNumber":function(e,t){return X(e,a(e,t),i.epsilon)?a(e,t):e.toDecimalPlaces(t.toNumber(),p.Decimal.ROUND_CEIL)},Fraction:function(e){return e.ceil()},"Fraction, number":function(e,t){return e.ceil(t)},"Array | Matrix":function(e){return oe(e,this,!0)},"Array | Matrix, number":function(e,t){var r=this;return oe(e,function(e){return r(e,t)},!0)},"SparseMatrix, number | BigNumber":function(e,t){return n(e,t,this,!1)},"DenseMatrix, number | BigNumber":function(e,t){return o(e,t,this,!1)},"number | Complex | BigNumber, Array":function(e,t){return o(r(t),e,this,!0).valueOf()}})}),n=["typed"],Xe=Object(a.a)("cube",n,function(e){return(0,e.typed)("cube",{number:we,Complex:function(e){return e.mul(e).mul(e)},BigNumber:function(e){return e.times(e).times(e)},Fraction:function(e){return e.pow(3)},"Array | Matrix":function(e){return oe(e,this,!0)},Unit:function(e){return e.pow(3)}})}),t=["typed"],Qe=Object(a.a)("exp",t,function(e){return(0,e.typed)("exp",{number:Ne,Complex:function(e){return e.exp()},BigNumber:function(e){return e.exp()},"Array | Matrix":function(e){return oe(e,this)}})}),n=["typed","Complex"],Ke=Object(a.a)("expm1",n,function(e){var t=e.typed,r=e.Complex;return t("expm1",{number:Oe,Complex:function(e){var t=Math.exp(e.re);return new r(t*Math.cos(e.im)-1,t*Math.sin(e.im))},BigNumber:function(e){return e.exp().minus(1)},"Array | Matrix":function(e){return oe(e,this)}})}),t=["typed","Complex","matrix","ceil","floor"],et=Object(a.a)("fix",t,function(e){var t=e.typed,r=e.Complex,n=e.matrix,i=e.ceil,a=e.floor,o=Ze({typed:t});return t("fix",{number:function(e){return(0<e?a:i)(e)},"number, number | BigNumber":function(e,t){return(0<e?a:i)(e,t)},Complex:function(e){return new r(0<e.re?Math.floor(e.re):Math.ceil(e.re),0<e.im?Math.floor(e.im):Math.ceil(e.im))},"Complex, number | BigNumber":function(e,t){return new r((0<e.re?a:i)(e.re,t),(0<e.im?a:i)(e.im,t))},BigNumber:function(e){return(e.isNegative()?i:a)(e)},"BigNumber, number | BigNumber":function(e,t){return(e.isNegative()?i:a)(e,t)},Fraction:function(e){return e.s<0?e.ceil():e.floor()},"Fraction, number | BigNumber":function(e,t){return e.s<0?e.ceil(t):e.floor(t)},"Array | Matrix":function(e){return oe(e,this,!0)},"Array | Matrix, number | BigNumber":function(e,t){var r=this;return oe(e,function(e){return r(e,t)},!0)},"number | Complex | BigNumber, Array":function(e,t){return o(n(t),e,this,!0).valueOf()}})});function tt(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){if("undefined"==typeof Symbol||!(Symbol.iterator in Object(e)))return;var r=[],n=!0,i=!1,a=void 0;try{for(var o,s=e[Symbol.iterator]();!(n=(o=s.next()).done)&&(r.push(o.value),!t||r.length!==t);n=!0);}catch(e){i=!0,a=e}finally{try{n||null==s.return||s.return()}finally{if(i)throw a}}return r}(e,t)||function(e,t){if(!e)return;if("string"==typeof e)return rt(e,t);var r=Object.prototype.toString.call(e).slice(8,-1);"Object"===r&&e.constructor&&(r=e.constructor.name);if("Map"===r||"Set"===r)return Array.from(e);if("Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r))return rt(e,t)}(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function rt(e,t){(null==t||t>e.length)&&(t=e.length);for(var r=0,n=new Array(t);r<t;r++)n[r]=e[r];return n}var n=["typed","config","round","matrix","equalScalar"],nt=Object(a.a)("floor",n,function(e){var t=e.typed,i=e.config,a=e.round,r=e.matrix,e=e.equalScalar,n=Ve({typed:t,equalScalar:e}),o=Ze({typed:t});return t("floor",{number:function(e){return Object(N.m)(e,a(e),i.epsilon)?a(e):Math.floor(e)},"number, number":function(e,t){if(Object(N.m)(e,a(e,t),i.epsilon))return a(e,t);var r=tt("".concat(e,"e").split("e"),2),n=r[0],e=r[1],r=Math.floor(Number("".concat(n,"e").concat(Number(e)+t))),r=tt("".concat(r,"e").split("e"),2),n=r[0],e=r[1];return Number("".concat(n,"e").concat(Number(e)-t))},Complex:function(e){return e.floor()},"Complex, number":function(e,t){return e.floor(t)},BigNumber:function(e){return X(e,a(e),i.epsilon)?a(e):e.floor()},"BigNumber, BigNumber":function(e,t){return X(e,a(e,t),i.epsilon)?a(e,t):e.toDecimalPlaces(t.toNumber(),p.Decimal.ROUND_FLOOR)},Fraction:function(e){return e.floor()},"Fraction, number":function(e,t){return e.floor(t)},"Array | Matrix":function(e){return oe(e,this,!0)},"Array | Matrix, number":function(e,t){var r=this;return oe(e,function(e){return r(e,t)},!0)},"SparseMatrix, number | BigNumber":function(e,t){return n(e,t,this,!1)},"DenseMatrix, number | BigNumber":function(e,t){return o(e,t,this,!1)},"number | Complex | BigNumber, Array":function(e,t){return o(r(t),e,this,!0).valueOf()}})}),t=["typed"],it=Object(a.a)("algorithm01",t,function(e){var O=e.typed;return function(e,t,r,n){var i=e._data,a=e._size,o=e._datatype,s=t._values,u=t._index,c=t._ptr,f=t._size,t=t._datatype;if(a.length!==f.length)throw new I.a(a.length,f.length);if(a[0]!==f[0]||a[1]!==f[1])throw new RangeError("Dimension mismatch. Matrix A ("+a+") must match Matrix B ("+f+")");if(!s)throw new Error("Cannot perform operation on Dense Matrix and Pattern Sparse Matrix");for(var l=a[0],p=a[1],o="string"==typeof o&&o===t?o:void 0,m=o?O.find(r,[o,o]):r,h=[],d=0;d<l;d++)h[d]=[];for(var y=[],g=[],b=0;b<p;b++){for(var v=b+1,x=c[b],w=c[b+1],N=x;N<w;N++)y[d=u[N]]=n?m(s[N],i[d][b]):m(i[d][b],s[N]),g[d]=v;for(d=0;d<l;d++)g[d]===v?h[d][b]=y[d]:h[d][b]=i[d][b]}return e.createDenseMatrix({data:h,size:[l,p],datatype:o})}}),n=["typed","equalScalar"],at=Object(a.a)("algorithm04",n,function(e){var T=e.typed,q=e.equalScalar;return function(e,t,r){var n=e._values,i=e._index,a=e._ptr,o=e._size,s=e._datatype,u=t._values,c=t._index,f=t._ptr,l=t._size,t=t._datatype;if(o.length!==l.length)throw new I.a(o.length,l.length);if(o[0]!==l[0]||o[1]!==l[1])throw new RangeError("Dimension mismatch. Matrix A ("+o+") must match Matrix B ("+l+")");var p,l=o[0],m=o[1],h=q,d=0,y=r;"string"==typeof s&&s===t&&(p=s,h=T.find(q,[p,p]),d=T.convert(0,p),y=T.find(r,[p,p]));for(var g=n&&u?[]:void 0,b=[],v=[],x=n&&u?[]:void 0,w=n&&u?[]:void 0,N=[],O=[],M=0;M<m;M++){v[M]=b.length;for(var j,E,S=M+1,A=a[M],C=a[M+1],_=A;_<C;_++)E=i[_],b.push(E),N[E]=S,x&&(x[E]=n[_]);for(A=f[M],C=f[M+1],_=A;_<C;_++)N[E=c[_]]===S?x&&(h(j=y(x[E],u[_]),d)?N[E]=null:x[E]=j):(b.push(E),O[E]=S,w&&(w[E]=u[_]));if(x&&w)for(_=v[M];_<b.length;)N[E=b[_]]===S?(g[_]=x[E],_++):O[E]===S?(g[_]=w[E],_++):b.splice(_,1)}return v[m]=b.length,e.createSparseMatrix({values:g,index:b,ptr:v,size:[l,m],datatype:p})}}),t=["typed","DenseMatrix"],ot=Object(a.a)("algorithm10",t,function(e){var N=e.typed,O=e.DenseMatrix;return function(e,t,r,n){var i=e._values,a=e._index,o=e._ptr,s=e._size,e=e._datatype;if(!i)throw new Error("Cannot perform operation on Pattern Sparse Matrix and Scalar value");var u,c=s[0],f=s[1],l=r;"string"==typeof e&&(u=e,t=N.convert(t,u),l=N.find(r,[u,u]));for(var p=[],m=[],h=[],d=0;d<f;d++){for(var y=d+1,g=o[d],b=o[d+1],v=g;v<b;v++){var x=a[v];m[x]=i[v],h[x]=y}for(var w=0;w<c;w++)0===d&&(p[w]=[]),h[w]===y?p[w][d]=n?l(t,m[w]):l(m[w],t):p[w][d]=t}return new O({data:p,size:[c,f],datatype:u})}}),n=["typed"],st=Object(a.a)("algorithm13",n,function(e){var p=e.typed;return function(e,t,r){var n=e._data,i=e._size,a=e._datatype,o=t._data,s=t._size,u=t._datatype,c=[];if(i.length!==s.length)throw new I.a(i.length,s.length);for(var f,l=0;l<i.length;l++){if(i[l]!==s[l])throw new RangeError("Dimension mismatch. Matrix A ("+i+") must match Matrix B ("+s+")");c[l]=i[l]}t=r;"string"==typeof a&&a===u&&(f=a,t=p.find(r,[f,f]));o=0<c.length?function e(t,r,n,i,a,o){var s=[];if(r===n.length-1)for(var u=0;u<i;u++)s[u]=t(a[u],o[u]);else for(var c=0;c<i;c++)s[c]=e(t,r+1,n,n[r+1],a[c],o[c]);return s}(t,0,c,c[0],n,o):[];return e.createDenseMatrix({data:o,size:c,datatype:f})}}),t=["typed","matrix","equalScalar","BigNumber","DenseMatrix"],ut=Object(a.a)("gcd",t,function(e){var t=e.typed,r=e.matrix,n=e.equalScalar,i=e.BigNumber,e=e.DenseMatrix,a=it({typed:t}),o=at({typed:t,equalScalar:n}),s=ot({typed:t,DenseMatrix:e}),u=st({typed:t}),c=Ze({typed:t});return t("gcd",{"number, number":Me,"BigNumber, BigNumber":function(e,t){if(!e.isInt()||!t.isInt())throw new Error("Parameters in function gcd must be integer numbers");var r=new i(0);for(;!t.isZero();){var n=e.mod(t);e=t,t=n}return e.lt(r)?e.neg():e},"Fraction, Fraction":function(e,t){return e.gcd(t)},"SparseMatrix, SparseMatrix":function(e,t){return o(e,t,this)},"SparseMatrix, DenseMatrix":function(e,t){return a(t,e,this,!0)},"DenseMatrix, SparseMatrix":function(e,t){return a(e,t,this,!1)},"DenseMatrix, DenseMatrix":function(e,t){return u(e,t,this)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"SparseMatrix, number | BigNumber":function(e,t){return s(e,t,this,!1)},"DenseMatrix, number | BigNumber":function(e,t){return c(e,t,this,!1)},"number | BigNumber, SparseMatrix":function(e,t){return s(t,e,this,!0)},"number | BigNumber, DenseMatrix":function(e,t){return c(t,e,this,!0)},"Array, number | BigNumber":function(e,t){return c(r(e),t,this,!1).valueOf()},"number | BigNumber, Array":function(e,t){return c(r(t),e,this,!0).valueOf()},"Array | Matrix | number | BigNumber, Array | Matrix | number | BigNumber, ...Array | Matrix | number | BigNumber":function(e,t,r){for(var n=this(e,t),i=0;i<r.length;i++)n=this(n,r[i]);return n}})}),n=["typed","equalScalar"],ct=Object(a.a)("algorithm02",n,function(e){var j=e.typed,E=e.equalScalar;return function(e,t,r,n){var i=e._data,a=e._size,o=e._datatype,s=t._values,u=t._index,c=t._ptr,f=t._size,e=t._datatype;if(a.length!==f.length)throw new I.a(a.length,f.length);if(a[0]!==f[0]||a[1]!==f[1])throw new RangeError("Dimension mismatch. Matrix A ("+a+") must match Matrix B ("+f+")");if(!s)throw new Error("Cannot perform operation on Dense Matrix and Pattern Sparse Matrix");var l,f=a[0],p=a[1],m=E,h=0,d=r;"string"==typeof o&&o===e&&(l=o,m=j.find(E,[l,l]),h=j.convert(0,l),d=j.find(r,[l,l]));for(var y=[],g=[],b=[],v=0;v<p;v++){b[v]=g.length;for(var x=c[v],w=c[v+1],N=x;N<w;N++){var O=u[N],M=n?d(s[N],i[O][v]):d(i[O][v],s[N]);m(M,h)||(g.push(O),y.push(M))}}return b[p]=g.length,t.createSparseMatrix({values:y,index:g,ptr:b,size:[f,p],datatype:l})}}),t=["typed","equalScalar"],ft=Object(a.a)("algorithm06",t,function(e){var E=e.typed,S=e.equalScalar;return function(e,t,r){var n=e._values,i=e._size,a=e._datatype,o=t._values,s=t._size,u=t._datatype;if(i.length!==s.length)throw new I.a(i.length,s.length);if(i[0]!==s[0]||i[1]!==s[1])throw new RangeError("Dimension mismatch. Matrix A ("+i+") must match Matrix B ("+s+")");var c,s=i[0],f=i[1],l=S,p=0,m=r;"string"==typeof a&&a===u&&(c=a,l=E.find(S,[c,c]),p=E.convert(0,c),m=E.find(r,[c,c]));for(var h=n&&o?[]:void 0,d=[],y=[],g=h?[]:void 0,b=[],v=[],x=0;x<f;x++){y[x]=d.length;var w=x+1;if(T(e,x,b,g,v,w,d,m),T(t,x,b,g,v,w,d,m),g)for(var N=y[x];N<d.length;){var O,M=d[N];v[M]!==w||l(O=g[M],p)?d.splice(N,1):(h.push(O),N++)}else for(var j=y[x];j<d.length;)v[d[j]]!==w?d.splice(j,1):j++}return y[f]=d.length,e.createSparseMatrix({values:h,index:d,ptr:y,size:[s,f],datatype:c})}}),n=["typed","matrix","equalScalar"],lt=Object(a.a)("lcm",n,function(e){var t=e.typed,r=e.matrix,e=e.equalScalar,n=ct({typed:t,equalScalar:e}),i=ft({typed:t,equalScalar:e}),a=Ve({typed:t,equalScalar:e}),o=st({typed:t}),s=Ze({typed:t});return t("lcm",{"number, number":je,"BigNumber, BigNumber":function(e,t){if(!e.isInt()||!t.isInt())throw new Error("Parameters in function lcm must be integer numbers");if(e.isZero())return e;if(t.isZero())return t;var r=e.times(t);for(;!t.isZero();){var n=t;t=e.mod(n),e=n}return r.div(e).abs()},"Fraction, Fraction":function(e,t){return e.lcm(t)},"SparseMatrix, SparseMatrix":function(e,t){return i(e,t,this)},"SparseMatrix, DenseMatrix":function(e,t){return n(t,e,this,!0)},"DenseMatrix, SparseMatrix":function(e,t){return n(e,t,this,!1)},"DenseMatrix, DenseMatrix":function(e,t){return o(e,t,this)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"SparseMatrix, number | BigNumber":function(e,t){return a(e,t,this,!1)},"DenseMatrix, number | BigNumber":function(e,t){return s(e,t,this,!1)},"number | BigNumber, SparseMatrix":function(e,t){return a(t,e,this,!0)},"number | BigNumber, DenseMatrix":function(e,t){return s(t,e,this,!0)},"Array, number | BigNumber":function(e,t){return s(r(e),t,this,!1).valueOf()},"number | BigNumber, Array":function(e,t){return s(r(t),e,this,!0).valueOf()},"Array | Matrix | number | BigNumber, Array | Matrix | number | BigNumber, ...Array | Matrix | number | BigNumber":function(e,t,r){for(var n=this(e,t),i=0;i<r.length;i++)n=this(n,r[i]);return n}})}),t=["typed","config","Complex"],pt=Object(a.a)("log10",t,function(e){var t=e.typed,r=e.config,n=e.Complex;return t("log10",{number:function(e){return 0<=e||r.predictable?Se(e):new n(e,0).log().div(Math.LN10)},Complex:function(e){return new n(e).log().div(Math.LN10)},BigNumber:function(e){return!e.isNegative()||r.predictable?e.log():new n(e.toNumber(),0).log().div(Math.LN10)},"Array | Matrix":function(e){return oe(e,this)}})}),n=["typed","config","Complex"],mt=Object(a.a)("log2",n,function(e){var t=e.typed,r=e.config,n=e.Complex;return t("log2",{number:function(e){return 0<=e||r.predictable?Ae(e):i(new n(e,0))},Complex:i,BigNumber:function(e){return!e.isNegative()||r.predictable?e.log(2):i(new n(e.toNumber(),0))},"Array | Matrix":function(e){return oe(e,this)}});function i(e){var t=Math.sqrt(e.re*e.re+e.im*e.im);return new n(Math.log2?Math.log2(t):Math.log(t)/Math.LN2,Math.atan2(e.im,e.re)/Math.LN2)}}),t=["typed"],ht=Object(a.a)("algorithm03",t,function(e){var S=e.typed;return function(e,t,r,n){var i=e._data,a=e._size,o=e._datatype,s=t._values,u=t._index,c=t._ptr,f=t._size,t=t._datatype;if(a.length!==f.length)throw new I.a(a.length,f.length);if(a[0]!==f[0]||a[1]!==f[1])throw new RangeError("Dimension mismatch. Matrix A ("+a+") must match Matrix B ("+f+")");if(!s)throw new Error("Cannot perform operation on Dense Matrix and Pattern Sparse Matrix");var l,p=a[0],m=a[1],h=0,d=r;"string"==typeof o&&o===t&&(l=o,h=S.convert(0,l),d=S.find(r,[l,l]));for(var y=[],g=0;g<p;g++)y[g]=[];for(var b=[],v=[],x=0;x<m;x++){for(var w=x+1,N=c[x],O=c[x+1],M=N;M<O;M++){var j=u[M];b[j]=n?d(s[M],i[j][x]):d(i[j][x],s[M]),v[j]=w}for(var E=0;E<p;E++)v[E]===w?y[E][x]=b[E]:y[E][x]=n?d(h,i[E][x]):d(i[E][x],h)}return e.createDenseMatrix({data:y,size:[p,m],datatype:l})}}),n=["typed","equalScalar"],dt=Object(a.a)("algorithm05",n,function(e){var T=e.typed,q=e.equalScalar;return function(e,t,r){var n=e._values,i=e._index,a=e._ptr,o=e._size,s=e._datatype,u=t._values,c=t._index,f=t._ptr,l=t._size,t=t._datatype;if(o.length!==l.length)throw new I.a(o.length,l.length);if(o[0]!==l[0]||o[1]!==l[1])throw new RangeError("Dimension mismatch. Matrix A ("+o+") must match Matrix B ("+l+")");var p,l=o[0],m=o[1],h=q,d=0,y=r;"string"==typeof s&&s===t&&(p=s,h=T.find(q,[p,p]),d=T.convert(0,p),y=T.find(r,[p,p]));for(var g,b=n&&u?[]:void 0,v=[],x=[],w=b?[]:void 0,N=b?[]:void 0,O=[],M=[],j=0;j<m;j++){x[j]=v.length;for(var E=j+1,S=a[j],A=a[j+1];S<A;S++)g=i[S],v.push(g),O[g]=E,w&&(w[g]=n[S]);for(S=f[j],A=f[j+1];S<A;S++)O[g=c[S]]!==E&&v.push(g),M[g]=E,N&&(N[g]=u[S]);if(b)for(S=x[j];S<v.length;){var C=O[g=v[S]],_=M[g];C!==E&&_!==E||(h(_=y(C===E?w[g]:d,_===E?N[g]:d),d)?v.splice(S,1):(b.push(_),S++))}}return x[m]=v.length,e.createSparseMatrix({values:b,index:v,ptr:x,size:[l,m],datatype:p})}}),t=["typed","DenseMatrix"],yt=Object(a.a)("algorithm12",t,function(e){var N=e.typed,O=e.DenseMatrix;return function(e,t,r,n){var i=e._values,a=e._index,o=e._ptr,s=e._size,e=e._datatype;if(!i)throw new Error("Cannot perform operation on Pattern Sparse Matrix and Scalar value");var u,c=s[0],f=s[1],l=r;"string"==typeof e&&(u=e,t=N.convert(t,u),l=N.find(r,[u,u]));for(var p=[],m=[],h=[],d=0;d<f;d++){for(var y=d+1,g=o[d],b=o[d+1],v=g;v<b;v++){var x=a[v];m[x]=i[v],h[x]=y}for(var w=0;w<c;w++)0===d&&(p[w]=[]),h[w]===y?p[w][d]=n?l(t,m[w]):l(m[w],t):p[w][d]=n?l(t,0):l(0,t)}return new O({data:p,size:[c,f],datatype:u})}}),n=["typed","matrix","equalScalar","DenseMatrix"],gt=Object(a.a)("mod",n,function(e){var t=e.typed,r=e.matrix,n=e.equalScalar,e=e.DenseMatrix,i=ct({typed:t,equalScalar:n}),a=ht({typed:t}),o=dt({typed:t,equalScalar:n}),s=Ve({typed:t,equalScalar:n}),u=yt({typed:t,DenseMatrix:e}),c=st({typed:t}),f=Ze({typed:t});return t("mod",{"number, number":Ce,"BigNumber, BigNumber":function(e,t){if(t.isNeg())throw new Error("Cannot calculate mod for a negative divisor");return t.isZero()?e:e.mod(t)},"Fraction, Fraction":function(e,t){if(t.compare(0)<0)throw new Error("Cannot calculate mod for a negative divisor");return(0<=e.compare(0)?e:e.mod(t).add(t)).mod(t)},"SparseMatrix, SparseMatrix":function(e,t){return o(e,t,this,!1)},"SparseMatrix, DenseMatrix":function(e,t){return i(t,e,this,!0)},"DenseMatrix, SparseMatrix":function(e,t){return a(e,t,this,!1)},"DenseMatrix, DenseMatrix":function(e,t){return c(e,t,this)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"SparseMatrix, any":function(e,t){return s(e,t,this,!1)},"DenseMatrix, any":function(e,t){return f(e,t,this,!1)},"any, SparseMatrix":function(e,t){return u(t,e,this,!0)},"any, DenseMatrix":function(e,t){return f(t,e,this,!0)},"Array, any":function(e,t){return f(r(e),t,this,!1).valueOf()},"any, Array":function(e,t){return f(r(t),e,this,!0).valueOf()}})}),t=["typed"],bt=Object(a.a)("multiplyScalar",t,function(e){return(0,e.typed)("multiplyScalar",{"number, number":ye,"Complex, Complex":function(e,t){return e.mul(t)},"BigNumber, BigNumber":function(e,t){return e.times(t)},"Fraction, Fraction":function(e,t){return e.mul(t)},"number | Fraction | BigNumber | Complex, Unit":function(e,t){t=t.clone();return t.value=null===t.value?t._normalize(e):this(t.value,e),t},"Unit, number | Fraction | BigNumber | Complex":function(e,t){e=e.clone();return e.value=null===e.value?e._normalize(t):this(e.value,t),e},"Unit, Unit":function(e,t){return e.multiply(t)}})}),vt="multiply",n=["typed","matrix","addScalar","multiplyScalar","equalScalar","dot"],xt=Object(a.a)(vt,n,function(e){var B=e.typed,r=e.matrix,k=e.addScalar,z=e.multiplyScalar,I=e.equalScalar,i=e.dot,n=Ve({typed:B,equalScalar:I}),a=Ze({typed:B});function o(e,t){switch(e.length){case 1:switch(t.length){case 1:if(e[0]!==t[0])throw new RangeError("Dimension mismatch in multiplication. Vectors must have the same length");break;case 2:if(e[0]!==t[0])throw new RangeError("Dimension mismatch in multiplication. Vector length ("+e[0]+") must match Matrix rows ("+t[0]+")");break;default:throw new Error("Can only multiply a 1 or 2 dimensional matrix (Matrix B has "+t.length+" dimensions)")}break;case 2:switch(t.length){case 1:if(e[1]!==t[0])throw new RangeError("Dimension mismatch in multiplication. Matrix columns ("+e[1]+") must match Vector length ("+t[0]+")");break;case 2:if(e[1]!==t[0])throw new RangeError("Dimension mismatch in multiplication. Matrix A columns ("+e[1]+") must match Matrix B rows ("+t[0]+")");break;default:throw new Error("Can only multiply a 1 or 2 dimensional matrix (Matrix B has "+t.length+" dimensions)")}break;default:throw new Error("Can only multiply a 1 or 2 dimensional matrix (Matrix A has "+e.length+" dimensions)")}}function s(e,t){if("dense"!==t.storage())throw new Error("Support for SparseMatrix not implemented");return function(e,t){var r,n=e._data,i=e._size,a=e._datatype,o=t._data,s=t._size,t=t._datatype,u=i[0],c=s[1],f=k,l=z;a&&t&&a===t&&"string"==typeof a&&(r=a,f=B.find(k,[r,r]),l=B.find(z,[r,r]));for(var p=[],m=0;m<c;m++){for(var h=l(n[0],o[0][m]),d=1;d<u;d++)h=f(h,l(n[d],o[d][m]));p[m]=h}return e.createDenseMatrix({data:p,size:[c],datatype:r})}(e,t)}var u=B("_multiplyMatrixVector",{"DenseMatrix, any":function(e,t){var r,n=e._data,i=e._size,a=e._datatype,o=t._data,t=t._datatype,s=i[0],u=i[1],c=k,f=z;a&&t&&a===t&&"string"==typeof a&&(r=a,c=B.find(k,[r,r]),f=B.find(z,[r,r]));for(var l=[],p=0;p<s;p++){for(var m=n[p],h=f(m[0],o[0]),d=1;d<u;d++)h=c(h,f(m[d],o[d]));l[p]=h}return e.createDenseMatrix({data:l,size:[s],datatype:r})},"SparseMatrix, any":function(e,t){var r=e._values,n=e._index,i=e._ptr,a=e._datatype;if(!r)throw new Error("Cannot multiply Pattern only Matrix times Dense Matrix");var o,s=t._data,u=t._datatype,c=e._size[0],f=t._size[0],l=[],p=[],t=[],m=k,h=z,d=I,y=0;a&&u&&a===u&&"string"==typeof a&&(o=a,m=B.find(k,[o,o]),h=B.find(z,[o,o]),d=B.find(I,[o,o]),y=B.convert(0,o));for(var g=[],b=[],v=t[0]=0;v<f;v++){var x=s[v];if(!d(x,y))for(var w=i[v],N=i[v+1],O=w;O<N;O++){var M=n[O];b[M]?g[M]=m(g[M],h(x,r[O])):(b[M]=!0,p.push(M),g[M]=h(x,r[O]))}}for(var j=p.length,E=0;E<j;E++){var S=p[E];l[E]=g[S]}return t[1]=p.length,e.createSparseMatrix({values:l,index:p,ptr:t,size:[c,1],datatype:o})}}),c=B("_multiplyMatrixMatrix",{"DenseMatrix, DenseMatrix":function(e,t){var r,n=e._data,i=e._size,a=e._datatype,o=t._data,s=t._size,t=t._datatype,u=i[0],c=i[1],f=s[1],l=k,p=z;a&&t&&a===t&&"string"==typeof a&&(r=a,l=B.find(k,[r,r]),p=B.find(z,[r,r]));for(var m=[],h=0;h<u;h++){var d=n[h];m[h]=[];for(var y=0;y<f;y++){for(var g=p(d[0],o[0][y]),b=1;b<c;b++)g=l(g,p(d[b],o[b][y]));m[h][y]=g}}return e.createDenseMatrix({data:m,size:[u,f],datatype:r})},"DenseMatrix, SparseMatrix":function(e,t){var r=e._data,n=e._size,i=e._datatype,a=t._values,o=t._index,s=t._ptr,u=t._size,e=t._datatype;if(!a)throw new Error("Cannot multiply Dense Matrix times Pattern only Matrix");var c=n[0],f=u[1],l=k,p=z,m=I,h=0;i&&e&&i===e&&"string"==typeof i&&(b=i,l=B.find(k,[b,b]),p=B.find(z,[b,b]),m=B.find(I,[b,b]),h=B.convert(0,b));for(var d=[],y=[],g=[],b=t.createSparseMatrix({values:d,index:y,ptr:g,size:[c,f],datatype:b}),v=0;v<f;v++){g[v]=y.length;var x=s[v],w=s[v+1];if(x<w)for(var N=0,O=0;O<c;O++){for(var M=O+1,j=void 0,E=x;E<w;E++){var S=o[E];N!==M?(j=p(r[O][S],a[E]),N=M):j=l(j,p(r[O][S],a[E]))}N!==M||m(j,h)||(y.push(O),d.push(j))}}return g[f]=y.length,b},"SparseMatrix, DenseMatrix":function(e,t){var r=e._values,n=e._index,i=e._ptr,a=e._datatype;if(!r)throw new Error("Cannot multiply Pattern only Matrix times Dense Matrix");var o=t._data,s=t._datatype,u=e._size[0],c=t._size[0],f=t._size[1],l=k,p=z,m=I,h=0;a&&s&&a===s&&"string"==typeof a&&(b=a,l=B.find(k,[b,b]),p=B.find(z,[b,b]),m=B.find(I,[b,b]),h=B.convert(0,b));for(var d=[],y=[],g=[],b=e.createSparseMatrix({values:d,index:y,ptr:g,size:[u,f],datatype:b}),v=[],x=[],w=0;w<f;w++){g[w]=y.length;for(var N=w+1,O=0;O<c;O++){var M=o[O][w];if(!m(M,h))for(var j=i[O],E=i[O+1],S=j;S<E;S++){var A=n[S];x[A]!==N?(x[A]=N,y.push(A),v[A]=p(M,r[S])):v[A]=l(v[A],p(M,r[S]))}}for(var C=g[w],_=y.length,T=C;T<_;T++){var q=y[T];d[T]=v[q]}}return g[f]=y.length,b},"SparseMatrix, SparseMatrix":function(e,t){var r=e._values,n=e._index,i=e._ptr,a=e._datatype,o=t._values,s=t._index,u=t._ptr,c=t._datatype,f=e._size[0],l=t._size[1],p=r&&o,m=k,h=z;a&&c&&a===c&&"string"==typeof a&&(j=a,m=B.find(k,[j,j]),h=B.find(z,[j,j]));for(var d,y,g,b,v,x,w,N=p?[]:void 0,O=[],M=[],j=e.createSparseMatrix({values:N,index:O,ptr:M,size:[f,l],datatype:j}),E=p?[]:void 0,S=[],A=0;A<l;A++){M[A]=O.length;var C=A+1;for(_=u[A],v=u[A+1],b=_;b<v;b++)if(w=s[b],p)for(y=i[w],g=i[w+1],d=y;d<g;d++)x=n[d],S[x]!==C?(S[x]=C,O.push(x),E[x]=h(o[b],r[d])):E[x]=m(E[x],h(o[b],r[d]));else for(y=i[w],g=i[w+1],d=y;d<g;d++)x=n[d],S[x]!==C&&(S[x]=C,O.push(x));if(p)for(var _=M[A],T=O.length,q=_;q<T;q++){var I=O[q];N[q]=E[I]}}return M[l]=O.length,j}});return B(vt,Object(ae.e)({"Array, Array":function(e,t){o(Object(E.a)(e),Object(E.a)(t));t=this(r(e),r(t));return Object(ie.v)(t)?t.valueOf():t},"Matrix, Matrix":function(e,t){var r=e.size(),n=t.size();return o(r,n),1===r.length?1===n.length?function(e,t,r){if(0===r)throw new Error("Cannot multiply two empty vectors");return i(e,t)}(e,t,r[0]):s(e,t):(1===n.length?u:c)(e,t)},"Matrix, Array":function(e,t){return this(e,r(t))},"Array, Matrix":function(e,t){return this(r(e,t.storage()),t)},"SparseMatrix, any":function(e,t){return n(e,t,z,!1)},"DenseMatrix, any":function(e,t){return a(e,t,z,!1)},"any, SparseMatrix":function(e,t){return n(t,e,z,!0)},"any, DenseMatrix":function(e,t){return a(t,e,z,!0)},"Array, any":function(e,t){return a(r(e),t,z,!1).valueOf()},"any, Array":function(e,t){return a(r(t),e,z,!0).valueOf()},"any, any":z,"any, any, ...any":function(e,t,r){for(var n=this(e,t),i=0;i<r.length;i++)n=this(n,r[i]);return n}},z.signatures))}),wt="nthRoot",t=["typed","matrix","equalScalar","BigNumber"],Nt=Object(a.a)(wt,t,function(e){var t=e.typed,r=e.matrix,n=e.equalScalar,s=e.BigNumber,i=it({typed:t}),a=ct({typed:t,equalScalar:n}),o=ft({typed:t,equalScalar:n}),u=Ve({typed:t,equalScalar:n}),c=st({typed:t}),f=Ze({typed:t}),l="Complex number not supported in function nthRoot. Use nthRoots instead.";return t(wt,{number:function(e){return _e(e,2)},"number, number":_e,BigNumber:function(e){return p(e,new s(2))},Complex:function(){throw new Error(l)},"Complex, number":function(){throw new Error(l)},"BigNumber, BigNumber":p,"Array | Matrix":function(e){return this(e,2)},"SparseMatrix, SparseMatrix":function(e,t){if(1===t.density())return o(e,t,this);throw new Error("Root must be non-zero")},"SparseMatrix, DenseMatrix":function(e,t){return a(t,e,this,!0)},"DenseMatrix, SparseMatrix":function(e,t){if(1===t.density())return i(e,t,this,!1);throw new Error("Root must be non-zero")},"DenseMatrix, DenseMatrix":function(e,t){return c(e,t,this)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"SparseMatrix, number | BigNumber":function(e,t){return u(e,t,this,!1)},"DenseMatrix, number | BigNumber":function(e,t){return f(e,t,this,!1)},"number | BigNumber, SparseMatrix":function(e,t){if(1===t.density())return u(t,e,this,!0);throw new Error("Root must be non-zero")},"number | BigNumber, DenseMatrix":function(e,t){return f(t,e,this,!0)},"Array, number | BigNumber":function(e,t){return this(r(e),t).valueOf()},"number | BigNumber, Array":function(e,t){return this(e,r(t)).valueOf()}});function p(e,t){var r=s.precision,n=s.clone({precision:r+2}),i=new s(0),a=new n(1),o=t.isNegative();if(o&&(t=t.neg()),t.isZero())throw new Error("Root must be non-zero");if(e.isNegative()&&!t.abs().mod(2).equals(1))throw new Error("Root must be odd when a is negative.");if(e.isZero())return o?new n(1/0):0;if(!e.isFinite())return o?i:e;t=e.abs().pow(a.div(t)),t=e.isNeg()?t.neg():t;return new s((o?a.div(t):t).toPrecision(r))}}),n=["typed","BigNumber","Fraction","complex"],Ot=Object(a.a)("sign",n,function(e){var t=e.typed,r=e.BigNumber,n=e.complex,i=e.Fraction;return t("sign",{number:Te,Complex:function(e){return 0===e.im?n(Te(e.re)):e.sign()},BigNumber:function(e){return new r(e.cmp(0))},Fraction:function(e){return new i(e.s,1)},"Array | Matrix":function(e){return oe(e,this,!0)},Unit:function(e){return this(e.value)}})}),t=["config","typed","Complex"],Mt=Object(a.a)("sqrt",t,function(e){var t=e.config,r=e.typed,n=e.Complex;return r("sqrt",{number:i,Complex:function(e){return e.sqrt()},BigNumber:function(e){return!e.isNegative()||t.predictable?e.sqrt():i(e.toNumber())},"Array | Matrix":function(e){return oe(e,this,!0)},Unit:function(e){return e.pow(.5)}});function i(e){return isNaN(e)?NaN:0<=e||t.predictable?Math.sqrt(e):new n(e,0).sqrt()}}),n=["typed"],jt=Object(a.a)("square",n,function(e){return(0,e.typed)("square",{number:qe,Complex:function(e){return e.mul(e)},BigNumber:function(e){return e.times(e)},Fraction:function(e){return e.mul(e)},"Array | Matrix":function(e){return oe(e,this,!0)},Unit:function(e){return e.pow(2)}})}),Et="subtract",t=["typed","matrix","equalScalar","addScalar","unaryMinus","DenseMatrix"],St=Object(a.a)(Et,t,function(e){var t=e.typed,r=e.matrix,n=e.equalScalar,i=e.addScalar,a=e.unaryMinus,e=e.DenseMatrix,o=it({typed:t}),s=ht({typed:t}),u=dt({typed:t,equalScalar:n}),c=ot({typed:t,DenseMatrix:e}),f=st({typed:t}),l=Ze({typed:t});return t(Et,{"number, number":function(e,t){return e-t},"Complex, Complex":function(e,t){return e.sub(t)},"BigNumber, BigNumber":function(e,t){return e.minus(t)},"Fraction, Fraction":function(e,t){return e.sub(t)},"Unit, Unit":function(e,t){if(null===e.value)throw new Error("Parameter x contains a unit with undefined value");if(null===t.value)throw new Error("Parameter y contains a unit with undefined value");if(!e.equalBase(t))throw new Error("Units do not match");e=e.clone();return e.value=this(e.value,t.value),e.fixPrefix=!1,e},"SparseMatrix, SparseMatrix":function(e,t){return At(e,t),u(e,t,this)},"SparseMatrix, DenseMatrix":function(e,t){return At(e,t),s(t,e,this,!0)},"DenseMatrix, SparseMatrix":function(e,t){return At(e,t),o(e,t,this,!1)},"DenseMatrix, DenseMatrix":function(e,t){return At(e,t),f(e,t,this)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"SparseMatrix, any":function(e,t){return c(e,a(t),i)},"DenseMatrix, any":function(e,t){return l(e,t,this)},"any, SparseMatrix":function(e,t){return c(t,e,this,!0)},"any, DenseMatrix":function(e,t){return l(t,e,this,!0)},"Array, any":function(e,t){return l(r(e),t,this,!1).valueOf()},"any, Array":function(e,t){return l(r(t),e,this,!0).valueOf()}})});function At(e,t){e=e.size(),t=t.size();if(e.length!==t.length)throw new I.a(e.length,t.length)}var n=["typed","config","matrix","BigNumber"],Ct=Object(a.a)("xgcd",n,function(e){var t=e.typed,l=e.config,p=e.matrix,m=e.BigNumber;return t("xgcd",{"number, number":function(e,t){t=Ie(e,t);return"Array"===l.matrix?t:p(t)},"BigNumber, BigNumber":function(e,t){var r,n,i,a=new m(0),o=new m(1),s=a,u=o,c=o,f=a;if(!e.isInt()||!t.isInt())throw new Error("Parameters in function xgcd must be integer numbers");for(;!t.isZero();)n=e.div(t).floor(),i=e.mod(t),r=s,s=u.minus(n.times(s)),u=r,r=c,c=f.minus(n.times(c)),f=r,e=t,t=i;a=e.lt(a)?[e.neg(),u.neg(),f.neg()]:[e,e.isZero()?0:u,f];return"Array"===l.matrix?a:p(a)}})}),t=["typed","equalScalar"],_t=Object(a.a)("algorithm09",t,function(e){var C=e.typed,_=e.equalScalar;return function(e,t,r){var n=e._values,i=e._index,a=e._ptr,o=e._size,s=e._datatype,u=t._values,c=t._index,f=t._ptr,l=t._size,t=t._datatype;if(o.length!==l.length)throw new I.a(o.length,l.length);if(o[0]!==l[0]||o[1]!==l[1])throw new RangeError("Dimension mismatch. Matrix A ("+o+") must match Matrix B ("+l+")");var p,l=o[0],m=o[1],h=_,d=0,y=r;"string"==typeof s&&s===t&&(p=s,h=C.find(_,[p,p]),d=C.convert(0,p),y=C.find(r,[p,p]));for(var g,b,v,x=n&&u?[]:void 0,w=[],N=[],O=x?[]:void 0,M=[],j=0;j<m;j++){N[j]=w.length;var E=j+1;if(O)for(b=f[j],v=f[j+1],g=b;g<v;g++)M[A=c[g]]=E,O[A]=u[g];for(b=a[j],v=a[j+1],g=b;g<v;g++){var S,A=i[g];O?(S=M[A]===E?O[A]:d,h(S=y(n[g],S),d)||(w.push(A),x.push(S))):w.push(A)}}return N[m]=w.length,e.createSparseMatrix({values:x,index:w,ptr:N,size:[l,m],datatype:p})}}),Tt="dotMultiply",n=["typed","matrix","equalScalar","multiplyScalar"],qt=Object(a.a)(Tt,n,function(e){var t=e.typed,r=e.matrix,n=e.equalScalar,i=e.multiplyScalar,a=ct({typed:t,equalScalar:n}),o=_t({typed:t,equalScalar:n}),s=Ve({typed:t,equalScalar:n}),u=st({typed:t}),c=Ze({typed:t});return t(Tt,{"any, any":i,"SparseMatrix, SparseMatrix":function(e,t){return o(e,t,i,!1)},"SparseMatrix, DenseMatrix":function(e,t){return a(t,e,i,!0)},"DenseMatrix, SparseMatrix":function(e,t){return a(e,t,i,!1)},"DenseMatrix, DenseMatrix":function(e,t){return u(e,t,i)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"SparseMatrix, any":function(e,t){return s(e,t,i,!1)},"DenseMatrix, any":function(e,t){return c(e,t,i,!1)},"any, SparseMatrix":function(e,t){return s(t,e,i,!0)},"any, DenseMatrix":function(e,t){return c(t,e,i,!0)},"Array, any":function(e,t){return c(r(e),t,i,!1).valueOf()},"any, Array":function(e,t){return c(r(t),e,i,!0).valueOf()}})});function It(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Integers expected in function bitAnd");var r=e.constructor;if(e.isNaN()||t.isNaN())return new r(NaN);if(e.isZero()||t.eq(-1)||e.eq(t))return e;if(t.isZero()||e.eq(-1))return t;if(!e.isFinite()||!t.isFinite()){if(!e.isFinite()&&!t.isFinite())return e.isNegative()===t.isNegative()?e:new r(0);if(!e.isFinite())return t.isNegative()?e:e.isNegative()?new r(0):t;if(!t.isFinite())return e.isNegative()?t:t.isNegative()?new r(0):e}return zt(e,t,function(e,t){return e&t})}function Bt(e){if(e.isFinite()&&!e.isInteger())throw new Error("Integer expected in function bitNot");var t=e.constructor,r=t.precision;t.config({precision:1e9});e=e.plus(new t(1));return e.s=-e.s||null,t.config({precision:r}),e}function kt(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Integers expected in function bitOr");var r=e.constructor;if(e.isNaN()||t.isNaN())return new r(NaN);r=new r(-1);return e.isZero()||t.eq(r)||e.eq(t)?t:t.isZero()||e.eq(r)?e:e.isFinite()&&t.isFinite()?zt(e,t,function(e,t){return e|t}):!e.isFinite()&&!e.isNegative()&&t.isNegative()||e.isNegative()&&!t.isNegative()&&!t.isFinite()?r:e.isNegative()&&t.isNegative()?e.isFinite()?e:t:e.isFinite()?t:e}function zt(e,t,r){var n,i,a,o,s,u=e.constructor,c=+(e.s<0),f=+(t.s<0);if(c){n=Dt(Bt(e));for(var l=0;l<n.length;++l)n[l]^=1}else n=Dt(e);if(f){i=Dt(Bt(t));for(var p=0;p<i.length;++p)i[p]^=1}else i=Dt(t);s=n.length<=i.length?(a=n,o=i,c):(a=i,o=n,f);var m=a.length,h=o.length,d=1^r(c,f),y=new u(1^d),g=new u(1),b=new u(2),f=u.precision;for(u.config({precision:1e9});0<m;)r(a[--m],o[--h])===d&&(y=y.plus(g)),g=g.times(b);for(;0<h;)r(s,o[--h])===d&&(y=y.plus(g)),g=g.times(b);return u.config({precision:f}),0==d&&(y.s=-y.s),y}function Dt(e){for(var t=e.d,r=t[0]+"",n=1;n<t.length;++n){for(var i=t[n]+"",a=7-i.length;a--;)i="0"+i;r+=i}for(var o=r.length;"0"===r.charAt(o);)o--;var s=e.e,u=r.slice(0,o+1||1),e=u.length;if(0<s)if(++s>e)for(s-=e;s--;)u+="0";else s<e&&(u=u.slice(0,s)+"."+u.slice(s));for(var c=[0],f=0;f<u.length;){for(var l=c.length;l--;)c[l]*=10;c[0]+=parseInt(u.charAt(f++));for(var p=0;p<c.length;++p)1<c[p]&&(null!==c[p+1]&&void 0!==c[p+1]||(c[p+1]=0),c[p+1]+=c[p]>>1,c[p]&=1)}return c.reverse()}function Rt(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Integers expected in function bitXor");var r=e.constructor;if(e.isNaN()||t.isNaN())return new r(NaN);if(e.isZero())return t;if(t.isZero())return e;if(e.eq(t))return new r(0);var n=new r(-1);return e.eq(n)?Bt(t):t.eq(n)?Bt(e):e.isFinite()&&t.isFinite()?zt(e,t,function(e,t){return e^t}):e.isFinite()||t.isFinite()?new r(e.isNegative()===t.isNegative()?1/0:-1/0):n}function Ut(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Integers expected in function leftShift");var r=e.constructor;return e.isNaN()||t.isNaN()||t.isNegative()&&!t.isZero()?new r(NaN):e.isZero()||t.isZero()?e:e.isFinite()||t.isFinite()?t.lt(55)?e.times(Math.pow(2,t.toNumber())+""):e.times(new r(2).pow(t)):new r(NaN)}function Pt(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Integers expected in function rightArithShift");var r=e.constructor;return e.isNaN()||t.isNaN()||t.isNegative()&&!t.isZero()?new r(NaN):e.isZero()||t.isZero()?e:t.isFinite()?(t.lt(55)?e.div(Math.pow(2,t.toNumber())+""):e.div(new r(2).pow(t))).floor():e.isNegative()?new r(-1):e.isFinite()?new r(0):new r(NaN)}t="number, number";function Ft(e,t){if(!Object(N.i)(e)||!Object(N.i)(t))throw new Error("Integers expected in function bitAnd");return e&t}function Lt(e){if(!Object(N.i)(e))throw new Error("Integer expected in function bitNot");return~e}function Ht(e,t){if(!Object(N.i)(e)||!Object(N.i)(t))throw new Error("Integers expected in function bitOr");return e|t}function $t(e,t){if(!Object(N.i)(e)||!Object(N.i)(t))throw new Error("Integers expected in function bitXor");return e^t}function Gt(e,t){if(!Object(N.i)(e)||!Object(N.i)(t))throw new Error("Integers expected in function leftShift");return e<<t}function Vt(e,t){if(!Object(N.i)(e)||!Object(N.i)(t))throw new Error("Integers expected in function rightArithShift");return e>>t}function Zt(e,t){if(!Object(N.i)(e)||!Object(N.i)(t))throw new Error("Integers expected in function rightLogShift");return e>>>t}Ft.signature=t,Lt.signature="number",Zt.signature=Vt.signature=Gt.signature=$t.signature=Ht.signature=t;var n=["typed","matrix","equalScalar"],Jt=Object(a.a)("bitAnd",n,function(e){var t=e.typed,r=e.matrix,e=e.equalScalar,n=ct({typed:t,equalScalar:e}),i=ft({typed:t,equalScalar:e}),a=Ve({typed:t,equalScalar:e}),o=st({typed:t}),s=Ze({typed:t});return t("bitAnd",{"number, number":Ft,"BigNumber, BigNumber":It,"SparseMatrix, SparseMatrix":function(e,t){return i(e,t,this,!1)},"SparseMatrix, DenseMatrix":function(e,t){return n(t,e,this,!0)},"DenseMatrix, SparseMatrix":function(e,t){return n(e,t,this,!1)},"DenseMatrix, DenseMatrix":function(e,t){return o(e,t,this)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"SparseMatrix, any":function(e,t){return a(e,t,this,!1)},"DenseMatrix, any":function(e,t){return s(e,t,this,!1)},"any, SparseMatrix":function(e,t){return a(t,e,this,!0)},"any, DenseMatrix":function(e,t){return s(t,e,this,!0)},"Array, any":function(e,t){return s(r(e),t,this,!1).valueOf()},"any, Array":function(e,t){return s(r(t),e,this,!0).valueOf()}})}),t=["typed"],Wt=Object(a.a)("bitNot",t,function(e){return(0,e.typed)("bitNot",{number:Lt,BigNumber:Bt,"Array | Matrix":function(e){return oe(e,this)}})}),n=["typed","matrix","equalScalar","DenseMatrix"],Yt=Object(a.a)("bitOr",n,function(e){var t=e.typed,r=e.matrix,n=e.equalScalar,e=e.DenseMatrix,i=it({typed:t}),a=at({typed:t,equalScalar:n}),o=ot({typed:t,DenseMatrix:e}),s=st({typed:t}),u=Ze({typed:t});return t("bitOr",{"number, number":Ht,"BigNumber, BigNumber":kt,"SparseMatrix, SparseMatrix":function(e,t){return a(e,t,this)},"SparseMatrix, DenseMatrix":function(e,t){return i(t,e,this,!0)},"DenseMatrix, SparseMatrix":function(e,t){return i(e,t,this,!1)},"DenseMatrix, DenseMatrix":function(e,t){return s(e,t,this)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"SparseMatrix, any":function(e,t){return o(e,t,this,!1)},"DenseMatrix, any":function(e,t){return u(e,t,this,!1)},"any, SparseMatrix":function(e,t){return o(t,e,this,!0)},"any, DenseMatrix":function(e,t){return u(t,e,this,!0)},"Array, any":function(e,t){return u(r(e),t,this,!1).valueOf()},"any, Array":function(e,t){return u(r(t),e,this,!0).valueOf()}})}),t=["typed","DenseMatrix"],Xt=Object(a.a)("algorithm07",t,function(e){var N=e.typed,O=e.DenseMatrix;return function(e,t,r){var n=e._size,i=e._datatype,a=t._size,o=t._datatype;if(n.length!==a.length)throw new I.a(n.length,a.length);if(n[0]!==a[0]||n[1]!==a[1])throw new RangeError("Dimension mismatch. Matrix A ("+n+") must match Matrix B ("+a+")");var s,u=n[0],c=n[1],f=0,l=r;"string"==typeof i&&i===o&&(s=i,f=N.convert(0,s),l=N.find(r,[s,s]));for(var p=[],m=0;m<u;m++)p[m]=[];for(var h=[],d=[],y=[],g=[],b=0;b<c;b++){var v=b+1;for(M(e,b,y,h,v),M(t,b,g,d,v),m=0;m<u;m++){var x=y[m]===v?h[m]:f,w=g[m]===v?d[m]:f;p[m][b]=l(x,w)}}return new O({data:p,size:[u,c],datatype:s})};function M(e,t,r,n,i){for(var a=e._values,o=e._index,e=e._ptr,s=e[t],u=e[t+1];s<u;s++){var c=o[s];r[c]=i,n[c]=a[s]}}}),n=["typed","matrix","DenseMatrix"],Qt=Object(a.a)("bitXor",n,function(e){var t=e.typed,r=e.matrix,e=e.DenseMatrix,n=ht({typed:t}),i=Xt({typed:t,DenseMatrix:e}),a=yt({typed:t,DenseMatrix:e}),o=st({typed:t}),s=Ze({typed:t});return t("bitXor",{"number, number":$t,"BigNumber, BigNumber":Rt,"SparseMatrix, SparseMatrix":function(e,t){return i(e,t,this)},"SparseMatrix, DenseMatrix":function(e,t){return n(t,e,this,!0)},"DenseMatrix, SparseMatrix":function(e,t){return n(e,t,this,!1)},"DenseMatrix, DenseMatrix":function(e,t){return o(e,t,this)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"SparseMatrix, any":function(e,t){return a(e,t,this,!1)},"DenseMatrix, any":function(e,t){return s(e,t,this,!1)},"any, SparseMatrix":function(e,t){return a(t,e,this,!0)},"any, DenseMatrix":function(e,t){return s(t,e,this,!0)},"Array, any":function(e,t){return s(r(e),t,this,!1).valueOf()},"any, Array":function(e,t){return s(r(t),e,this,!0).valueOf()}})}),t=["typed"],Kt=Object(a.a)("arg",t,function(e){return(0,e.typed)("arg",{number:function(e){return Math.atan2(0,e)},BigNumber:function(e){return e.constructor.atan2(0,e)},Complex:function(e){return e.arg()},"Array | Matrix":function(e){return oe(e,this)}})}),n=["typed"],er=Object(a.a)("conj",n,function(e){return(0,e.typed)("conj",{number:function(e){return e},BigNumber:function(e){return e},Complex:function(e){return e.conjugate()},"Array | Matrix":function(e){return oe(e,this)}})}),t=["typed"],tr=Object(a.a)("im",t,function(e){return(0,e.typed)("im",{number:function(){return 0},BigNumber:function(e){return e.mul(0)},Complex:function(e){return e.im},"Array | Matrix":function(e){return oe(e,this)}})}),n=["typed"],rr=Object(a.a)("re",n,function(e){return(0,e.typed)("re",{number:function(e){return e},BigNumber:function(e){return e},Complex:function(e){return e.re},"Array | Matrix":function(e){return oe(e,this)}})}),t="number, number";function nr(e){return!e}function ir(e,t){return!(!e&&!t)}function ar(e,t){return!!e!=!!t}function or(e,t){return!(!e||!t)}nr.signature="number",or.signature=ar.signature=ir.signature=t;var n=["typed"],sr=Object(a.a)("not",n,function(e){return(0,e.typed)("not",{number:nr,Complex:function(e){return 0===e.re&&0===e.im},BigNumber:function(e){return e.isZero()||e.isNaN()},Unit:function(e){return null===e.value||this(e.value)},"Array | Matrix":function(e){return oe(e,this)}})}),t=["typed","matrix","equalScalar","DenseMatrix"],ur=Object(a.a)("or",t,function(e){var t=e.typed,r=e.matrix,n=e.equalScalar,e=e.DenseMatrix,i=ht({typed:t}),a=dt({typed:t,equalScalar:n}),o=yt({typed:t,DenseMatrix:e}),s=st({typed:t}),u=Ze({typed:t});return t("or",{"number, number":ir,"Complex, Complex":function(e,t){return 0!==e.re||0!==e.im||0!==t.re||0!==t.im},"BigNumber, BigNumber":function(e,t){return!e.isZero()&&!e.isNaN()||!t.isZero()&&!t.isNaN()},"Unit, Unit":function(e,t){return this(e.value||0,t.value||0)},"SparseMatrix, SparseMatrix":function(e,t){return a(e,t,this)},"SparseMatrix, DenseMatrix":function(e,t){return i(t,e,this,!0)},"DenseMatrix, SparseMatrix":function(e,t){return i(e,t,this,!1)},"DenseMatrix, DenseMatrix":function(e,t){return s(e,t,this)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"SparseMatrix, any":function(e,t){return o(e,t,this,!1)},"DenseMatrix, any":function(e,t){return u(e,t,this,!1)},"any, SparseMatrix":function(e,t){return o(t,e,this,!0)},"any, DenseMatrix":function(e,t){return u(t,e,this,!0)},"Array, any":function(e,t){return u(r(e),t,this,!1).valueOf()},"any, Array":function(e,t){return u(r(t),e,this,!0).valueOf()}})}),n=["typed","matrix","DenseMatrix"],cr=Object(a.a)("xor",n,function(e){var t=e.typed,r=e.matrix,e=e.DenseMatrix,n=ht({typed:t}),i=Xt({typed:t,DenseMatrix:e}),a=yt({typed:t,DenseMatrix:e}),o=st({typed:t}),s=Ze({typed:t});return t("xor",{"number, number":ar,"Complex, Complex":function(e,t){return(0!==e.re||0!==e.im)!=(0!==t.re||0!==t.im)},"BigNumber, BigNumber":function(e,t){return(!e.isZero()&&!e.isNaN())!=(!t.isZero()&&!t.isNaN())},"Unit, Unit":function(e,t){return this(e.value||0,t.value||0)},"SparseMatrix, SparseMatrix":function(e,t){return i(e,t,this)},"SparseMatrix, DenseMatrix":function(e,t){return n(t,e,this,!0)},"DenseMatrix, SparseMatrix":function(e,t){return n(e,t,this,!1)},"DenseMatrix, DenseMatrix":function(e,t){return o(e,t,this)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"SparseMatrix, any":function(e,t){return a(e,t,this,!1)},"DenseMatrix, any":function(e,t){return s(e,t,this,!1)},"any, SparseMatrix":function(e,t){return a(t,e,this,!0)},"any, DenseMatrix":function(e,t){return s(t,e,this,!0)},"Array, any":function(e,t){return s(r(e),t,this,!1).valueOf()},"any, Array":function(e,t){return s(r(t),e,this,!0).valueOf()}})}),t=["typed","matrix","isInteger"],fr=Object(a.a)("concat",t,function(e){var t=e.typed,f=e.matrix,l=e.isInteger;return t("concat",{"...Array | Matrix | number | BigNumber":function(e){for(var t,r=e.length,n=-1,i=!1,a=[],o=0;o<r;o++){var s=e[o];if(Object(ie.v)(s)&&(i=!0),Object(ie.y)(s)||Object(ie.e)(s)){if(o!==r-1)throw new Error("Dimension must be specified as last argument");if(t=n,n=s.valueOf(),!l(n))throw new TypeError("Integer number expected for dimension");if(n<0||0<o&&t<n)throw new j.a(n,t+1)}else{var u=Object(ae.a)(s).valueOf(),s=Object(E.a)(u);if(a[o]=u,t=n,n=s.length-1,0<o&&n!==t)throw new I.a(t+1,n+1)}}if(0===a.length)throw new SyntaxError("At least one matrix expected");for(var c=a.shift();a.length;)c=function e(t,r,n,i){{if(i<n){if(t.length!==r.length)throw new I.a(t.length,r.length);for(var a=[],o=0;o<t.length;o++)a[o]=e(t[o],r[o],n,i+1);return a}return t.concat(r)}}(c,a.shift(),n,0);return i?f(c):c},"...string":function(e){return e.join("")}})});var n=["typed","Index","matrix","range"],lr=Object(a.a)("column",n,function(e){var t=e.typed,n=e.Index,r=e.matrix,i=e.range;return t("column",{"Matrix, number":a,"Array, number":function(e,t){return a(r(Object(ae.a)(e)),t).valueOf()}});function a(e,t){if(2!==e.size().length)throw new Error("Only two dimensional matrix is supported");Object(E.q)(t,e.size()[1]);var r=i(0,e.size()[0]),t=new n(r,t);return e.subset(t)}}),t=["typed","matrix","subtract","multiply"],pr=Object(a.a)("cross",t,function(e){var t=e.typed,r=e.matrix,a=e.subtract,o=e.multiply;return t("cross",{"Matrix, Matrix":function(e,t){return r(n(e.toArray(),t.toArray()))},"Matrix, Array":function(e,t){return r(n(e.toArray(),t))},"Array, Matrix":function(e,t){return r(n(e,t.toArray()))},"Array, Array":n});function n(e,t){var r=Math.max(Object(E.a)(e).length,Object(E.a)(t).length);e=Object(E.n)(e),t=Object(E.n)(t);var n=Object(E.a)(e),i=Object(E.a)(t);if(1!==n.length||1!==i.length||3!==n[0]||3!==i[0])throw new RangeError("Vectors with length 3 expected (Size A = ["+n.join(", ")+"], B = ["+i.join(", ")+"])");t=[a(o(e[1],t[2]),o(e[2],t[1])),a(o(e[2],t[0]),o(e[0],t[2])),a(o(e[0],t[1]),o(e[1],t[0]))];return 1<r?[t]:t}}),n=["typed","matrix","DenseMatrix","SparseMatrix"],mr=Object(a.a)("diag",n,function(e){var t=e.typed,c=e.matrix,o=e.DenseMatrix,s=e.SparseMatrix;return t("diag",{Array:function(e){return n(e,0,Object(E.a)(e),null)},"Array, number":function(e,t){return n(e,t,Object(E.a)(e),null)},"Array, BigNumber":function(e,t){return n(e,t.toNumber(),Object(E.a)(e),null)},"Array, string":function(e,t){return n(e,0,Object(E.a)(e),t)},"Array, number, string":function(e,t,r){return n(e,t,Object(E.a)(e),r)},"Array, BigNumber, string":function(e,t,r){return n(e,t.toNumber(),Object(E.a)(e),r)},Matrix:function(e){return n(e,0,e.size(),e.storage())},"Matrix, number":function(e,t){return n(e,t,e.size(),e.storage())},"Matrix, BigNumber":function(e,t){return n(e,t.toNumber(),e.size(),e.storage())},"Matrix, string":function(e,t){return n(e,0,e.size(),t)},"Matrix, number, string":function(e,t,r){return n(e,t,e.size(),r)},"Matrix, BigNumber, string":function(e,t,r){return n(e,t.toNumber(),e.size(),r)}});function n(e,t,r,n){if(!Object(N.i)(t))throw new TypeError("Second parameter in function diag must be an integer");var i=0<t?t:0,a=t<0?-t:0;switch(r.length){case 1:return function(e,t,r,n,i,a){a=[n+i,n+a];if(r&&"sparse"!==r&&"dense"!==r)throw new TypeError("Unknown matrix type ".concat(r,'"'));t=("sparse"===r?s:o).diagonal(a,e,t);return null!==r?t:t.valueOf()}(e,t,n,r[0],a,i);case 2:return function(e,t,r,n,i,a){if(Object(ie.v)(e)){t=e.diagonal(t);return null!==r?r!==t.storage()?c(t,r):t:t.valueOf()}for(var o=Math.min(n[0]-i,n[1]-a),s=[],u=0;u<o;u++)s[u]=e[u+i][u+a];return null!==r?c(s):s}(e,t,n,r,a,i)}throw new RangeError("Matrix for function diag must be 2 dimensional")}});function hr(e){return(hr="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function dr(i,a){return function e(){"object"!==hr(e.cache)&&(e.cache={});for(var t=[],r=0;r<arguments.length;r++)t[r]=arguments[r];var n=a?a(t):JSON.stringify(t);return n in e.cache||(e.cache[n]=i.apply(i,t)),e.cache[n]}}function yr(e){return Object.keys(e.signatures||{}).reduce(function(e,t){t=(t.match(/,/g)||[]).length+1;return Math.max(e,t)},-1)}var t=["typed"],gr=Object(a.a)("filter",t,function(e){return(0,e.typed)("filter",{"Array, function":br,"Matrix, function":function(e,t){return e.create(br(e.toArray(),t))},"Array, RegExp":E.d,"Matrix, RegExp":function(e,t){return e.create(Object(E.d)(e.toArray(),t))}})});function br(e,n){var i=yr(n);return Object(E.c)(e,function(e,t,r){return 1===i?n(e):2===i?n(e,[t]):n(e,[t],r)})}var vr="flatten",n=["typed","matrix"],xr=Object(a.a)(vr,n,function(e){var t=e.typed,r=e.matrix;return t(vr,{Array:function(e){return Object(E.e)(Object(ae.a)(e))},Matrix:function(e){e=Object(E.e)(Object(ae.a)(e.toArray()));return r(e)}})}),wr="forEach",t=["typed"],Nr=Object(a.a)(wr,t,function(e){return(0,e.typed)(wr,{"Array, function":Or,"Matrix, function":function(e,t){return e.forEach(t)}})});function Or(t,i){var a=yr(i);(function r(e,n){Array.isArray(e)?Object(E.f)(e,function(e,t){r(e,n.concat(t))}):1===a?i(e):2===a?i(e,n):i(e,n,t)})(t,[])}var Mr="getMatrixDataType",n=["typed"],jr=Object(a.a)(Mr,n,function(e){return(0,e.typed)(Mr,{Array:function(e){return Object(E.h)(e,ie.M)},Matrix:function(e){return e.getDataType()}})}),Er="identity",t=["typed","config","matrix","BigNumber","DenseMatrix","SparseMatrix"],Sr=Object(a.a)(Er,t,function(e){var t=e.typed,r=e.config,n=e.matrix,c=e.BigNumber,f=e.DenseMatrix,l=e.SparseMatrix;return t(Er,{"":function(){return"Matrix"===r.matrix?n([]):[]},string:function(e){return n(e)},"number | BigNumber":function(e){return a(e,e,"Matrix"===r.matrix?"dense":void 0)},"number | BigNumber, string":function(e,t){return a(e,e,t)},"number | BigNumber, number | BigNumber":function(e,t){return a(e,t,"Matrix"===r.matrix?"dense":void 0)},"number | BigNumber, number | BigNumber, string":a,Array:function(e){return i(e)},"Array, string":i,Matrix:function(e){return i(e.valueOf(),e.storage())},"Matrix, string":function(e,t){return i(e.valueOf(),t)}});function i(e,t){switch(e.length){case 0:return t?n(t):[];case 1:return a(e[0],e[0],t);case 2:return a(e[0],e[1],t);default:throw new Error("Vector containing two values expected")}}function a(e,t,r){var n=Object(ie.e)(e)||Object(ie.e)(t)?c:null;if(Object(ie.e)(e)&&(e=e.toNumber()),Object(ie.e)(t)&&(t=t.toNumber()),!Object(N.i)(e)||e<1)throw new Error("Parameters in function identity must be positive integers");if(!Object(N.i)(t)||t<1)throw new Error("Parameters in function identity must be positive integers");var i=n?new c(1):1,a=n?new n(0):0,n=[e,t];if(r){if("sparse"===r)return l.diagonal(n,i,0,a);if("dense"===r)return f.diagonal(n,i,0,a);throw new TypeError('Unknown matrix type "'.concat(r,'"'))}for(var o=Object(E.m)([],n,a),s=e<t?e:t,u=0;u<s;u++)o[u][u]=i;return o}}),n=["typed","matrix","multiplyScalar"],Ar=Object(a.a)("kron",n,function(e){var t=e.typed,r=e.matrix,a=e.multiplyScalar;return t("kron",{"Matrix, Matrix":function(e,t){return r(n(e.toArray(),t.toArray()))},"Matrix, Array":function(e,t){return r(n(e.toArray(),t))},"Array, Matrix":function(e,t){return r(n(e,t.toArray()))},"Array, Array":n});function n(e,r){if(1===Object(E.a)(e).length&&(e=[e]),1===Object(E.a)(r).length&&(r=[r]),2<Object(E.a)(e).length||2<Object(E.a)(r).length)throw new RangeError("Vectors with dimensions greater then 2 are not supported expected (Size x = "+JSON.stringify(e.length)+", y = "+JSON.stringify(r.length)+")");var n=[],i=[];return e.map(function(t){return r.map(function(e){return i=[],n.push(i),t.map(function(t){return e.map(function(e){return i.push(a(t,e))})})})})&&n}}),t=["typed"],Cr=Object(a.a)("map",t,function(e){return(0,e.typed)("map",{"Array, function":_r,"Matrix, function":function(e,t){return e.map(t)}})});function _r(t,i){var a=yr(i);return function r(e,n){return Array.isArray(e)?e.map(function(e,t){return r(e,n.concat(t))}):1===a?i(e):2===a?i(e,n):i(e,n,t)}(t,[])}var n=["typed","matrix","subtract","number"],Tr=Object(a.a)("diff",n,function(e){var t=e.typed,r=e.matrix,i=e.subtract,n=e.number;return t("diff",{"Array | Matrix":function(e){return Object(ie.v)(e)?r(o(e.toArray())):o(e)},"Array | Matrix, number":function(e,t){if(!Object(N.i)(t))throw new RangeError("Dimension must be a whole number");return Object(ie.v)(e)?r(a(e.toArray(),t)):a(e,t)},"Array | Matrix, BigNumber":function(e,t){return this(e,n(t))}});function a(e,t){if(Object(ie.v)(e)&&(e=e.toArray()),!Array.isArray(e))throw RangeError("Array/Matrix does not have that many dimensions");if(0<t){var r=[];return e.forEach(function(e){r.push(a(e,t-1))}),r}if(0===t)return o(e);throw RangeError("Cannot have negative dimension")}function o(e){var t=[],r=e.length;if(r<2)return e;for(var n=1;n<r;n++)t.push(s(e[n-1],e[n]));return t}function s(e,t){Object(ie.v)(e)&&(e=e.toArray()),Object(ie.v)(t)&&(t=t.toArray());var r=Array.isArray(e),n=Array.isArray(t);if(r&&n)return function(e,t){if(e.length!==t.length)throw RangeError("Not all sub-arrays have the same length");for(var r=[],n=e.length,i=0;i<n;i++)r.push(s(e[i],t[i]));return r}(e,t);if(!r&&!n)return i(t,e);throw TypeError("Cannot calculate difference between 1 array and 1 non-array")}}),t=["typed","config","matrix","BigNumber"],qr=Object(a.a)("ones",t,function(e){var t=e.typed,r=e.config,a=e.matrix,o=e.BigNumber;return t("ones",{"":function(){return"Array"===r.matrix?n([]):n([],"default")},"...number | BigNumber | string":function(e){if("string"!=typeof e[e.length-1])return"Array"===r.matrix?n(e):n(e,"default");var t=e.pop();return n(e,t)},Array:n,Matrix:function(e){var t=e.storage();return n(e.valueOf(),t)},"Array | Matrix, string":function(e,t){return n(e.valueOf(),t)}});function n(e,t){var n,r=(n=!1,e.forEach(function(e,t,r){Object(ie.e)(e)&&(n=!0,r[t]=e.toNumber())}),n)?new o(1):1;if(e.forEach(function(e){if("number"!=typeof e||!Object(N.i)(e)||e<0)throw new Error("Parameters in function ones must be positive integers")}),t){var i=a(t);return 0<e.length?i.resize(e,r):i}i=[];return 0<e.length?Object(E.m)(i,e,r):i}});function Ir(){throw new Error('No "bignumber" implementation available')}function Br(){throw new Error('No "fraction" implementation available')}function kr(){throw new Error('No "matrix" implementation available')}var n=["typed","config","?matrix","?bignumber","smaller","smallerEq","larger","largerEq"],zr=Object(a.a)("range",n,function(e){var t=e.typed,n=e.config,r=e.matrix,o=e.bignumber,s=e.smaller,u=e.smallerEq,c=e.larger,f=e.largerEq;return t("range",{string:a,"string, boolean":a,"number, number":function(e,t){return i(l(e,t,1))},"number, number, number":function(e,t,r){return i(l(e,t,r))},"number, number, boolean":function(e,t,r){return i((r?p:l)(e,t,1))},"number, number, number, boolean":function(e,t,r,n){return i((n?p:l)(e,t,r))},"BigNumber, BigNumber":function(e,t){return i(m(e,t,new e.constructor(1)))},"BigNumber, BigNumber, BigNumber":function(e,t,r){return i(m(e,t,r))},"BigNumber, BigNumber, boolean":function(e,t,r){var n=e.constructor;return i((r?h:m)(e,t,new n(1)))},"BigNumber, BigNumber, BigNumber, boolean":function(e,t,r,n){return i((n?h:m)(e,t,r))}});function i(e){return"Matrix"===n.matrix?r?r(e):kr():e}function a(e,t){var r=function(e){e=e.split(":").map(function(e){return Number(e)});if(e.some(function(e){return isNaN(e)}))return null;switch(e.length){case 2:return{start:e[0],end:e[1],step:1};case 3:return{start:e[0],end:e[2],step:e[1]};default:return null}}(e);if(!r)throw new SyntaxError('String "'+e+'" is no valid range');return"BigNumber"===n.number?(void 0===o&&Ir(),i((t?h:m)(o(r.start),o(r.end),o(r.step)))):i((t?p:l)(r.start,r.end,r.step))}function l(e,t,r){var n=[],i=e;if(0<r)for(;s(i,t);)n.push(i),i+=r;else if(r<0)for(;c(i,t);)n.push(i),i+=r;return n}function p(e,t,r){var n=[],i=e;if(0<r)for(;u(i,t);)n.push(i),i+=r;else if(r<0)for(;f(i,t);)n.push(i),i+=r;return n}function m(e,t,r){var n=o(0),i=[],a=e;if(r.gt(n))for(;s(a,t);)i.push(a),a=a.plus(r);else if(r.lt(n))for(;c(a,t);)i.push(a),a=a.plus(r);return i}function h(e,t,r){var n=o(0),i=[],a=e;if(r.gt(n))for(;u(a,t);)i.push(a),a=a.plus(r);else if(r.lt(n))for(;f(a,t);)i.push(a),a=a.plus(r);return i}}),Dr="reshape",t=["typed","isInteger","matrix"],Rr=Object(a.a)(Dr,t,function(e){var t=e.typed,r=e.isInteger,n=e.matrix;return t(Dr,{"Matrix, Array":function(e,t){return e.reshape?e.reshape(t):n(Object(E.l)(e.valueOf(),t))},"Array, Array":function(e,t){return t.forEach(function(e){if(!r(e))throw new TypeError("Invalid size for dimension: "+e)}),Object(E.l)(e,t)}})}),Ur=r(13),n=["config","matrix"],Pr=Object(a.a)("resize",n,function(e){var i=e.config,a=e.matrix;return function(e,t,r){if(2!==arguments.length&&3!==arguments.length)throw new Ur.a("resize",arguments.length,2,3);if(Object(ie.v)(t)&&(t=t.valueOf()),Object(ie.e)(t[0])&&(t=t.map(function(e){return Object(ie.e)(e)?e.toNumber():e})),Object(ie.v)(e))return e.resize(t,r,!0);if("string"==typeof e)return function(e,t,r){if(void 0!==r){if("string"!=typeof r||1!==r.length)throw new TypeError("Single character expected as defaultValue")}else r=" ";if(1!==t.length)throw new I.a(t.length,1);var n=t[0];if("number"!=typeof n||!Object(N.i)(n))throw new TypeError("Invalid size, must contain positive integers (size: "+Object(Z.d)(t)+")");{if(e.length>n)return e.substring(0,n);if(e.length<n){for(var i=e,a=0,o=n-e.length;a<o;a++)i+=r;return i}return e}}(e,t,r);var n=!Array.isArray(e)&&"Array"!==i.matrix;if(0===t.length){for(;Array.isArray(e);)e=e[0];return Object(ae.a)(e)}Array.isArray(e)||(e=[e]),e=Object(ae.a)(e);r=Object(E.m)(e,t,r);return n?a(r):r}}),t=["typed","multiply","rotationMatrix"],Fr=Object(a.a)("rotate",t,function(e){var t=e.typed,n=e.multiply,i=e.rotationMatrix;return t("rotate",{"Array , number | BigNumber | Complex | Unit":function(e,t){return a(e,2),n(i(t),e).toArray()},"Matrix , number | BigNumber | Complex | Unit":function(e,t){return a(e,2),n(i(t),e)},"Array, number | BigNumber | Complex | Unit, Array | Matrix":function(e,t,r){return a(e,3),n(i(t,r),e)},"Matrix, number | BigNumber | Complex | Unit, Array | Matrix":function(e,t,r){return a(e,3),n(i(t,r),e)}});function a(e,t){e=Array.isArray(e)?Object(E.a)(e):e.size();if(2<e.length)throw new RangeError("Vector must be of dimensions 1x".concat(t));if(2===e.length&&1!==e[1])throw new RangeError("Vector must be of dimensions 1x".concat(t));if(e[0]!==t)throw new RangeError("Vector must be of dimensions 1x".concat(t))}}),Lr="rotationMatrix",n=["typed","config","multiplyScalar","addScalar","unaryMinus","norm","matrix","BigNumber","DenseMatrix","SparseMatrix","cos","sin"],Hr=Object(a.a)(Lr,n,function(e){var t=e.typed,n=e.config,i=e.multiplyScalar,c=e.addScalar,f=e.unaryMinus,l=e.norm,p=e.BigNumber,a=e.matrix,r=e.DenseMatrix,o=e.SparseMatrix,m=e.cos,h=e.sin;return t(Lr,{"":function(){return"Matrix"===n.matrix?a([]):[]},string:function(e){return a(e)},"number | BigNumber | Complex | Unit":function(e){return s(e,"Matrix"===n.matrix?"dense":void 0)},"number | BigNumber | Complex | Unit, string":s,"number | BigNumber | Complex | Unit, Array":function(e,t){t=a(t);return u(t),g(e,t,void 0)},"number | BigNumber | Complex | Unit, Matrix":function(e,t){u(t);var r=t.storage()||("Matrix"===n.matrix?"dense":void 0);return g(e,t,r)},"number | BigNumber | Complex | Unit, Array, string":function(e,t,r){t=a(t);return u(t),g(e,t,r)},"number | BigNumber | Complex | Unit, Matrix, string":function(e,t,r){return u(t),g(e,t,r)}});function s(e,t){var r=Object(ie.e)(e)?new p(-1):-1,n=m(e),e=h(e);return y([[n,i(r,e)],[e,n]],t)}function u(e){e=e.size();if(e.length<1||3!==e[0])throw new RangeError("Vector must be of dimensions 1x3")}function d(e){return e.reduce(function(e,t){return i(e,t)})}function y(e,t){if(t){if("sparse"===t)return new o(e);if("dense"===t)return new r(e);throw new TypeError('Unknown matrix type "'.concat(t,'"'))}return e}function g(e,t,r){var n=l(t);if(0===n)throw new RangeError("Rotation around zero vector");var i=Object(ie.e)(e)?p:null,a=i?new i(1):1,o=i?new i(-1):-1,s=i?new i(t.get([0])/n):t.get([0])/n,u=i?new i(t.get([1])/n):t.get([1])/n,t=i?new i(t.get([2])/n):t.get([2])/n,n=m(e),a=c(a,f(n)),e=h(e);return y([[c(n,d([s,s,a])),c(d([s,u,a]),d([o,t,e])),c(d([s,t,a]),d([u,e]))],[c(d([s,u,a]),d([t,e])),c(n,d([u,u,a])),c(d([u,t,a]),d([o,s,e]))],[c(d([s,t,a]),d([o,u,e])),c(d([u,t,a]),d([s,e])),c(n,d([t,t,a]))]],r)}}),t=["typed","Index","matrix","range"],$r=Object(a.a)("row",t,function(e){var t=e.typed,n=e.Index,r=e.matrix,i=e.range;return t("row",{"Matrix, number":a,"Array, number":function(e,t){return a(r(Object(ae.a)(e)),t).valueOf()}});function a(e,t){if(2!==e.size().length)throw new Error("Only two dimensional matrix is supported");Object(E.q)(t,e.size()[0]);var r=i(0,e.size()[1]),r=new n(t,r);return e.subset(r)}}),n=["typed","config","?matrix"],Gr=Object(a.a)("size",n,function(e){var t=e.typed,r=e.config,n=e.matrix;return t("size",{Matrix:function(e){return e.create(e.size())},Array:E.a,string:function(e){return"Array"===r.matrix?[e.length]:n([e.length])},"number | Complex | BigNumber | Unit | boolean | null":function(){return"Array"===r.matrix?[]:n?n([]):kr()}})}),Vr="squeeze",t=["typed","matrix"],Zr=Object(a.a)(Vr,t,function(e){var t=e.typed,r=e.matrix;return t(Vr,{Array:function(e){return Object(E.n)(Object(ae.a)(e))},Matrix:function(e){e=Object(E.n)(e.toArray());return Array.isArray(e)?r(e):e},any:function(e){return Object(ae.a)(e)}})});function Jr(e){return(Jr="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function Wr(e,t){if(Kr(e)&&Xr(e,t))return e[t];if("function"==typeof e[t]&&Qr(e,t))throw new Error('Cannot access method "'+t+'" as a property');throw new Error('No access to property "'+t+'"')}function Yr(e,t,r){if(Kr(e)&&Xr(e,t))return e[t]=r;throw new Error('No access to property "'+t+'"')}function Xr(e,t){return e&&"object"===Jr(e)&&(Object(ae.f)(en,t)||!(t in Object.prototype)&&!(t in Function.prototype))}function Qr(e,t){return null!=e&&"function"==typeof e[t]&&(!(Object(ae.f)(e,t)&&Object.getPrototypeOf&&t in Object.getPrototypeOf(e))&&(Object(ae.f)(tn,t)||!(t in Object.prototype)&&!(t in Function.prototype)))}function Kr(e){return"object"===Jr(e)&&e&&e.constructor===Object}var en={length:!0,name:!0},tn={toString:!0,valueOf:!0,toLocaleString:!0},n=["typed","matrix"],rn=Object(a.a)("subset",n,function(e){var t=e.typed,i=e.matrix;return t("subset",{"Array, Index":function(e,t){e=i(e).subset(t);return t.isScalar()?e:e.valueOf()},"Matrix, Index":function(e,t){return e.subset(t)},"Object, Index":on,"string, Index":nn,"Array, Index, any":function(e,t,r){return i(Object(ae.a)(e)).subset(t,r,void 0).valueOf()},"Array, Index, any, any":function(e,t,r,n){return i(Object(ae.a)(e)).subset(t,r,n).valueOf()},"Matrix, Index, any":function(e,t,r){return e.clone().subset(t,r)},"Matrix, Index, any, any":function(e,t,r,n){return e.clone().subset(t,r,n)},"string, Index, string":an,"string, Index, string, string":an,"Object, Index, any":sn})});function nn(t,e){if(!Object(ie.t)(e))throw new TypeError("Index expected");if(1!==e.size().length)throw new I.a(e.size().length,1);var r=t.length;Object(E.q)(e.min()[0],r),Object(E.q)(e.max()[0],r);var e=e.dimension(0),n="";return e.forEach(function(e){n+=t.charAt(e)}),n}function an(e,t,r,n){if(!t||!0!==t.isIndex)throw new TypeError("Index expected");if(1!==t.size().length)throw new I.a(t.size().length,1);if(void 0!==n){if("string"!=typeof n||1!==n.length)throw new TypeError("Single character expected as defaultValue")}else n=" ";var i=t.dimension(0);if(i.size()[0]!==r.length)throw new I.a(i.size()[0],r.length);var a=e.length;Object(E.q)(t.min()[0]),Object(E.q)(t.max()[0]);for(var o=[],s=0;s<a;s++)o[s]=e.charAt(s);if(i.forEach(function(e,t){o[e]=r.charAt(t[0])}),o.length>a)for(var u=a-1,c=o.length;u<c;u++)o[u]||(o[u]=n);return o.join("")}function on(e,t){if(1!==t.size().length)throw new I.a(t.size(),1);t=t.dimension(0);if("string"!=typeof t)throw new TypeError("String expected as index to retrieve an object property");return Wr(e,t)}function sn(e,t,r){if(1!==t.size().length)throw new I.a(t.size(),1);t=t.dimension(0);if("string"!=typeof t)throw new TypeError("String expected as index to retrieve an object property");e=Object(ae.a)(e);return Yr(e,t,r),e}var t=["typed","matrix"],un=Object(a.a)("transpose",t,function(e){var t=e.typed,r=e.matrix;return t("transpose",{Array:function(e){return this(r(e)).valueOf()},Matrix:function(e){var t,r=e.size();switch(r.length){case 1:t=e.clone();break;case 2:var n=r[0],i=r[1];if(0===i)throw new RangeError("Cannot transpose a 2D matrix with no columns (size: "+Object(Z.d)(r)+")");switch(e.storage()){case"dense":t=function(e,t,r){for(var n,i=e._data,a=[],o=0;o<r;o++){n=a[o]=[];for(var s=0;s<t;s++)n[s]=Object(ae.a)(i[s][o])}return e.createDenseMatrix({data:a,size:[r,t],datatype:e._datatype})}(e,n,i);break;case"sparse":t=function(e,t,r){for(var n,i,a,o=e._values,s=e._index,u=e._ptr,c=o?[]:void 0,f=[],l=[],p=[],m=0;m<t;m++)p[m]=0;for(n=0,i=s.length;n<i;n++)p[s[n]]++;for(var h=0,d=0;d<t;d++)l.push(h),h+=p[d],p[d]=l[d];for(l.push(h),a=0;a<r;a++)for(var y=u[a],g=u[a+1],b=y;b<g;b++){var v=p[s[b]]++;f[v]=a,o&&(c[v]=Object(ae.a)(o[b]))}return e.createSparseMatrix({values:c,index:f,ptr:l,size:[r,t],datatype:e._datatype})}(e,n,i)}break;default:throw new RangeError("Matrix must be a vector or two dimensional (size: "+Object(Z.d)(this._size)+")")}return t},any:function(e){return Object(ae.a)(e)}})}),cn="ctranspose",n=["typed","transpose","conj"],fn=Object(a.a)(cn,n,function(e){var t=e.typed,r=e.transpose,n=e.conj;return t(cn,{any:function(e){return n(r(e))}})}),t=["typed","config","matrix","BigNumber"],ln=Object(a.a)("zeros",t,function(e){var t=e.typed,r=e.config,a=e.matrix,o=e.BigNumber;return t("zeros",{"":function(){return"Array"===r.matrix?n([]):n([],"default")},"...number | BigNumber | string":function(e){if("string"!=typeof e[e.length-1])return"Array"===r.matrix?n(e):n(e,"default");var t=e.pop();return n(e,t)},Array:n,Matrix:function(e){var t=e.storage();return n(e.valueOf(),t)},"Array | Matrix, string":function(e,t){return n(e.valueOf(),t)}});function n(e,t){var n,r=(n=!1,e.forEach(function(e,t,r){Object(ie.e)(e)&&(n=!0,r[t]=e.toNumber())}),n)?new o(0):0;if(e.forEach(function(e){if("number"!=typeof e||!Object(N.i)(e)||e<0)throw new Error("Parameters in function zeros must be positive integers")}),t){var i=a(t);return 0<e.length?i.resize(e,r):i}i=[];return 0<e.length?Object(E.m)(i,e,r):i}}),n=["typed"],pn=Object(a.a)("erf",n,function(e){return(0,e.typed)("name",{number:function(e){var t=Math.abs(e);return gn<=t?Object(N.n)(e):t<=mn?Object(N.n)(e)*function(e){var t,r=e*e,n=dn[0][4]*r,i=r;for(t=0;t<3;t+=1)n=(n+dn[0][t])*r,i=(i+yn[0][t])*r;return e*(n+dn[0][3])/(i+yn[0][3])}(t):t<=4?Object(N.n)(e)*(1-function(e){var t,r=dn[1][8]*e,n=e;for(t=0;t<7;t+=1)r=(r+dn[1][t])*e,n=(n+yn[1][t])*e;var i=(r+dn[1][7])/(n+yn[1][7]),a=parseInt(16*e)/16,o=(e-a)*(e+a);return Math.exp(-a*a)*Math.exp(-o)*i}(t)):Object(N.n)(e)*(1-function(e){var t,r=1/(e*e),n=dn[2][5]*r,i=r;for(t=0;t<4;t+=1)n=(n+dn[2][t])*r,i=(i+yn[2][t])*r;var a=r*(n+dn[2][4])/(i+yn[2][4]);a=(hn-a)/e,r=parseInt(16*e)/16;e=(e-r)*(e+r);return Math.exp(-r*r)*Math.exp(-e)*a}(t))},"Array | Matrix":function(e){return oe(e,this)}})}),mn=.46875,hn=.5641895835477563,dn=[[3.1611237438705655,113.86415415105016,377.485237685302,3209.3775891384694,.18577770618460315],[.5641884969886701,8.883149794388377,66.11919063714163,298.6351381974001,881.952221241769,1712.0476126340707,2051.0783778260716,1230.3393547979972,2.1531153547440383e-8],[.30532663496123236,.36034489994980445,.12578172611122926,.016083785148742275,.0006587491615298378,.016315387137302097]],yn=[[23.601290952344122,244.02463793444417,1282.6165260773723,2844.236833439171],[15.744926110709835,117.6939508913125,537.1811018620099,1621.3895745666903,3290.7992357334597,4362.619090143247,3439.3676741437216,1230.3393548037495],[2.568520192289822,1.8729528499234604,.5279051029514285,.06051834131244132,.0023352049762686918]],gn=Math.pow(2,53),t=["typed","isNaN","isNumeric"],bn=Object(a.a)("mode",t,function(e){var t=e.typed,o=e.isNaN,s=e.isNumeric;return t("mode",{"Array | Matrix":r,"...":r});function r(e){if(0===(e=Object(E.e)(e.valueOf())).length)throw new Error("Cannot calculate mode of an empty array");for(var t={},r=[],n=0,i=0;i<e.length;i++){var a=e[i];if(s(a)&&o(a))throw new Error("Cannot calculate mode of an array containing NaN values");a in t||(t[a]=0),t[a]++,t[a]===n?r.push(a):t[a]>n&&(n=t[a],r=[a])}return r}});function vn(e,t,r){var n;return-1!==String(e).indexOf("Unexpected type")?(n=2<arguments.length?" (type: "+Object(ie.M)(r)+", value: "+JSON.stringify(r)+")":" (type: "+e.data.actual+")",new TypeError("Cannot calculate "+t+", unexpected type of argument"+n)):-1!==String(e).indexOf("complex numbers")?(n=2<arguments.length?" (type: "+Object(ie.M)(r)+", value: "+JSON.stringify(r)+")":"",new TypeError("Cannot calculate "+t+", no ordering relation is defined for complex numbers"+n)):e}var n=["typed","config","multiplyScalar","numeric"],xn=Object(a.a)("prod",n,function(e){var t=e.typed,n=e.config,i=e.multiplyScalar,a=e.numeric;return t("prod",{"Array | Matrix":r,"Array | Matrix, number | BigNumber":function(){throw new Error("prod(A, dim) is not yet supported")},"...":r});function r(e){var r;if(A(e,function(t){try{r=void 0===r?t:i(r,t)}catch(e){throw vn(e,"prod",t)}}),"string"==typeof r&&(r=a(r,n.number)),void 0===r)throw new Error("Cannot calculate prod of an empty array");return r}}),t=["typed"],wn=Object(a.a)("format",t,function(e){return(0,e.typed)("format",{any:Z.d,"any, Object | function | number":Z.d})});var Nn=["typed"];function On(n,i){return Object(a.a)(n,Nn,function(e){var t,r;return(0,e.typed)(n,{number:(r={2:"0b",8:"0o",16:"0x"}[t=i],function(e){if(e>Math.pow(2,31)-1||e<-Math.pow(2,31))throw new Error("Value must be in range [-2^31, 2^31-1]");if(!Object(N.i)(e))throw new Error("Value must be an integer");return e<0&&(e+=Math.pow(2,32)),"".concat(r).concat(e.toString(t))})})})}var Mn=On("bin",2),jn=On("oct",8),En=On("hex",16),n=["typed"],Sn=Object(a.a)("print",n,function(e){return(0,e.typed)("print",{"string, Object | Array":An,"string, Object | Array, number | Object":An})});function An(e,a,o){return e.replace(/\$([\w.]+)/g,function(e,t){for(var r=t.split("."),n=a[r.shift()];r.length&&void 0!==n;)var i=r.shift(),n=i?n[i]:n+".";return void 0!==n?Object(ie.I)(n)?n:Object(Z.d)(n,o):e})}var t=["typed","matrix"],Cn=Object(a.a)("to",t,function(e){var t=e.typed,r=e.matrix,n=st({typed:t}),i=Ze({typed:t});return t("to",{"Unit, Unit | string":function(e,t){return e.to(t)},"Matrix, Matrix":function(e,t){return n(e,t,this)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"Matrix, any":function(e,t){return i(e,t,this,!1)},"any, Matrix":function(e,t){return i(t,e,this,!0)},"Array, any":function(e,t){return i(r(e),t,this,!1).valueOf()},"any, Array":function(e,t){return i(r(t),e,this,!0).valueOf()}})}),_n="isPrime",n=["typed"],Tn=Object(a.a)(_n,n,function(e){return(0,e.typed)(_n,{number:function(e){if(0*e!=0)return!1;if(e<=3)return 1<e;if(e%2==0||e%3==0)return!1;for(var t=5;t*t<=e;t+=6)if(e%t==0||e%(t+2)==0)return!1;return!0},BigNumber:function(e){if(0*e.toNumber()!=0)return!1;if(e.lte(3))return e.gt(1);if(e.mod(2).eq(0)||e.mod(3).eq(0))return!1;for(var t=5;e.gte(t*t);t+=6)if(e.mod(t).eq(0)||e.mod(t+2).eq(0))return!1;return!0},"Array | Matrix":function(e){return oe(e,this)}})}),t=["number","?bignumber","?fraction"],qn=Object(a.a)("numeric",t,function(e){var t=e.number,r=e.bignumber,n=e.fraction,i={string:!0,number:!0,BigNumber:!0,Fraction:!0},a={number:function(e){return t(e)},BigNumber:r?function(e){return r(e)}:Ir,Fraction:n?function(e){return n(e)}:Br};return function(e,t){var r=Object(ie.M)(e);if(!(r in i))throw new TypeError("Cannot convert "+e+' of type "'+r+'"; valid input types are '+Object.keys(i).join(", "));if(!(t in a))throw new TypeError("Cannot convert "+e+' to type "'+t+'"; valid output types are '+Object.keys(a).join(", "));return t===r?e:a[t](e)}}),In="divideScalar",n=["typed","numeric"],Bn=Object(a.a)(In,n,function(e){var t=e.typed,i=e.numeric;return t(In,{"number, number":function(e,t){return e/t},"Complex, Complex":function(e,t){return e.div(t)},"BigNumber, BigNumber":function(e,t){return e.div(t)},"Fraction, Fraction":function(e,t){return e.div(t)},"Unit, number | Fraction | BigNumber":function(e,t){var r=e.clone(),e=i(1,Object(ie.M)(t));return r.value=this(null===r.value?r._normalize(e):r.value,t),r},"number | Fraction | BigNumber, Unit":function(e,t){var r=(r=t.clone()).pow(-1),n=i(1,Object(ie.M)(e));return r.value=this(e,null===t.value?t._normalize(n):t.value),r},"Unit, Unit":function(e,t){return e.divide(t)}})}),t=["typed","config","identity","multiply","matrix","fraction","number","Complex"],kn=Object(a.a)("pow",t,function(e){var t=e.typed,i=e.config,a=e.identity,o=e.multiply,r=e.matrix,s=e.number,u=e.fraction,c=e.Complex;return t("pow",{"number, number":n,"Complex, Complex":function(e,t){return e.pow(t)},"BigNumber, BigNumber":function(e,t){return t.isInteger()||0<=e||i.predictable?e.pow(t):new c(e.toNumber(),0).pow(t.toNumber(),0)},"Fraction, Fraction":function(e,t){if(1===t.d)return e.pow(t);if(i.predictable)throw new Error("Function pow does not support non-integer exponents for fractions.");return n(e.valueOf(),t.valueOf())},"Array, number":f,"Array, BigNumber":function(e,t){return f(e,t.toNumber())},"Matrix, number":l,"Matrix, BigNumber":function(e,t){return l(e,t.toNumber())},"Unit, number | BigNumber":function(e,t){return e.pow(t)}});function n(e,t){if(i.predictable&&!Object(N.i)(t)&&e<0)try{var r=u(t),n=s(r);if((t===n||Math.abs((t-n)/t)<1e-14)&&r.d%2==1)return(r.n%2==0?1:-1)*Math.pow(-e,t)}catch(e){}return i.predictable&&(e<-1&&t===1/0||-1<e&&e<0&&t===-1/0)?NaN:Object(N.i)(t)||0<=e||i.predictable?Be(e,t):e*e<1&&t===1/0||1<e*e&&t===-1/0?0:new c(e,0).pow(t,0)}function f(e,t){if(!Object(N.i)(t)||t<0)throw new TypeError("For A^b, b must be a positive integer (value is "+t+")");var r=Object(E.a)(e);if(2!==r.length)throw new Error("For A^b, A must be 2 dimensional (A has "+r.length+" dimensions)");if(r[0]!==r[1])throw new Error("For A^b, A must be square (size is "+r[0]+"x"+r[1]+")");for(var n=a(r[0]).valueOf(),i=e;1<=t;)1==(1&t)&&(n=o(i,n)),t>>=1,i=o(i,i);return n}function l(e,t){return r(f(e.valueOf(),t))}});function zn(t,e){var r,n=Object.keys(t);return Object.getOwnPropertySymbols&&(r=Object.getOwnPropertySymbols(t),e&&(r=r.filter(function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable})),n.push.apply(n,r)),n}function Dn(n){for(var e=1;e<arguments.length;e++){var i=null!=arguments[e]?arguments[e]:{};e%2?zn(Object(i),!0).forEach(function(e){var t,r;t=n,e=i[r=e],r in t?Object.defineProperty(t,r,{value:e,enumerable:!0,configurable:!0,writable:!0}):t[r]=e}):Object.getOwnPropertyDescriptors?Object.defineProperties(n,Object.getOwnPropertyDescriptors(i)):zn(Object(i)).forEach(function(e){Object.defineProperty(n,e,Object.getOwnPropertyDescriptor(i,e))})}return n}var Rn="Number of decimals in function round must be an integer",Un="round",n=["typed","matrix","equalScalar","zeros","BigNumber","DenseMatrix"],Pn=Object(a.a)(Un,n,function(e){var t=e.typed,r=e.matrix,n=e.equalScalar,i=e.zeros,a=e.BigNumber,e=e.DenseMatrix,o=Ve({typed:t,equalScalar:n}),s=yt({typed:t,DenseMatrix:e}),u=Ze({typed:t});return t(Un,Dn(Dn({},Fn),{},{Complex:function(e){return e.round()},"Complex, number":function(e,t){if(t%1)throw new TypeError(Rn);return e.round(t)},"Complex, BigNumber":function(e,t){if(!t.isInteger())throw new TypeError(Rn);t=t.toNumber();return e.round(t)},"number, BigNumber":function(e,t){if(!t.isInteger())throw new TypeError(Rn);return new a(e).toDecimalPlaces(t.toNumber())},BigNumber:function(e){return e.toDecimalPlaces(0)},"BigNumber, BigNumber":function(e,t){if(!t.isInteger())throw new TypeError(Rn);return e.toDecimalPlaces(t.toNumber())},Fraction:function(e){return e.round()},"Fraction, number":function(e,t){if(t%1)throw new TypeError(Rn);return e.round(t)},"Array | Matrix":function(e){return oe(e,this,!0)},"SparseMatrix, number | BigNumber":function(e,t){return o(e,t,this,!1)},"DenseMatrix, number | BigNumber":function(e,t){return u(e,t,this,!1)},"number | Complex | BigNumber, SparseMatrix":function(e,t){return n(e,0)?i(t.size(),t.storage()):s(t,e,this,!0)},"number | Complex | BigNumber, DenseMatrix":function(e,t){return n(e,0)?i(t.size(),t.storage()):u(t,e,this,!0)},"Array, number | BigNumber":function(e,t){return u(r(e),t,this,!1).valueOf()},"number | Complex | BigNumber, Array":function(e,t){return u(r(t),e,this,!0).valueOf()}}))}),Fn={number:ke,"number, number":function(e,t){if(!Object(N.i)(t))throw new TypeError(Rn);if(t<0||15<t)throw new Error("Number of decimals in function round must be in te range of 0-15");return ke(e,t)}},t=["config","typed","divideScalar","Complex"],Ln=Object(a.a)("log",t,function(e){var t=e.typed,r=e.config,n=e.divideScalar,i=e.Complex;return t("log",{number:function(e){return 0<=e||r.predictable?Ee(e):new i(e,0).log()},Complex:function(e){return e.log()},BigNumber:function(e){return!e.isNegative()||r.predictable?e.ln():new i(e.toNumber(),0).log()},"Array | Matrix":function(e){return oe(e,this)},"any, any":function(e,t){return n(this(e),this(t))}})}),n=["typed","config","divideScalar","log","Complex"],Hn=Object(a.a)("log1p",n,function(e){var t=e.typed,r=e.config,n=e.divideScalar,i=e.log,a=e.Complex;return t("log1p",{number:function(e){return-1<=e||r.predictable?Object(N.k)(e):o(new a(e,0))},Complex:o,BigNumber:function(e){var t=e.plus(1);return!t.isNegative()||r.predictable?t.ln():o(new a(e.toNumber(),0))},"Array | Matrix":function(e){return oe(e,this)},"any, any":function(e,t){return n(this(e),i(t))}});function o(e){var t=e.re+1;return new a(Math.log(Math.sqrt(t*t+e.im*e.im)),Math.atan2(e.im,t))}}),$n="nthRoots",t=["config","typed","divideScalar","Complex"],Gn=Object(a.a)($n,t,function(e){var t=e.typed,c=(e.config,e.divideScalar,e.Complex),f=[function(e){return new c(e,0)},function(e){return new c(0,e)},function(e){return new c(-e,0)},function(e){return new c(0,-e)}];function r(e,t){if(t<0)throw new Error("Root must be greater than zero");if(0===t)throw new Error("Root must be non-zero");if(t%1!=0)throw new Error("Root must be an integer");if(0===e||0===e.abs())return[new c(0,0)];var r,n="number"==typeof e;!n&&0!==e.re&&0!==e.im||(r=n?2*(e<0):0===e.im?2*(e.re<0):2*(e.im<0)+1);for(var i=e.arg(),e=e.abs(),a=[],o=Math.pow(e,1/t),s=0;s<t;s++){var u=(r+4*s)/t;u!==Math.round(u)?a.push(new c({r:o,phi:(i+2*Math.PI*s)/t})):a.push(f[u%4](o))}return a}return t($n,{Complex:function(e){return r(e,2)},"Complex, number":r})}),n=["typed","equalScalar","matrix","pow","DenseMatrix"],Vn=Object(a.a)("dotPow",n,function(e){var t=e.typed,r=e.equalScalar,n=e.matrix,i=e.pow,e=e.DenseMatrix,a=ht({typed:t}),o=Xt({typed:t,DenseMatrix:e}),s=Ve({typed:t,equalScalar:r}),u=yt({typed:t,DenseMatrix:e}),c=st({typed:t}),f=Ze({typed:t});return t("dotPow",{"any, any":i,"SparseMatrix, SparseMatrix":function(e,t){return o(e,t,i,!1)},"SparseMatrix, DenseMatrix":function(e,t){return a(t,e,i,!0)},"DenseMatrix, SparseMatrix":function(e,t){return a(e,t,i,!1)},"DenseMatrix, DenseMatrix":function(e,t){return c(e,t,i)},"Array, Array":function(e,t){return this(n(e),n(t)).valueOf()},"Array, Matrix":function(e,t){return this(n(e),t)},"Matrix, Array":function(e,t){return this(e,n(t))},"SparseMatrix, any":function(e,t){return s(e,t,this,!1)},"DenseMatrix, any":function(e,t){return f(e,t,this,!1)},"any, SparseMatrix":function(e,t){return u(t,e,this,!0)},"any, DenseMatrix":function(e,t){return f(t,e,this,!0)},"Array, any":function(e,t){return f(n(e),t,this,!1).valueOf()},"any, Array":function(e,t){return f(n(t),e,this,!0).valueOf()}})}),Zn="dotDivide",t=["typed","matrix","equalScalar","divideScalar","DenseMatrix"],Jn=Object(a.a)(Zn,t,function(e){var t=e.typed,r=e.matrix,n=e.equalScalar,i=e.divideScalar,e=e.DenseMatrix,a=ct({typed:t,equalScalar:n}),o=ht({typed:t}),s=Xt({typed:t,DenseMatrix:e}),u=Ve({typed:t,equalScalar:n}),c=yt({typed:t,DenseMatrix:e}),f=st({typed:t}),l=Ze({typed:t});return t(Zn,{"any, any":i,"SparseMatrix, SparseMatrix":function(e,t){return s(e,t,i,!1)},"SparseMatrix, DenseMatrix":function(e,t){return a(t,e,i,!0)},"DenseMatrix, SparseMatrix":function(e,t){return o(e,t,i,!1)},"DenseMatrix, DenseMatrix":function(e,t){return f(e,t,i)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"SparseMatrix, any":function(e,t){return u(e,t,i,!1)},"DenseMatrix, any":function(e,t){return l(e,t,i,!1)},"any, SparseMatrix":function(e,t){return c(t,e,i,!0)},"any, DenseMatrix":function(e,t){return l(t,e,i,!0)},"Array, any":function(e,t){return l(r(e),t,i,!1).valueOf()},"any, Array":function(e,t){return l(r(t),e,i,!0).valueOf()}})});function Wn(e){var y=e.DenseMatrix;return function(e,t,r){e=e.size();if(2!==e.length)throw new RangeError("Matrix must be two dimensional (size: "+Object(Z.d)(e)+")");var n=e[0];if(n!==e[1])throw new RangeError("Matrix must be square (size: "+Object(Z.d)(e)+")");var i=[];if(Object(ie.v)(t)){var e=t.size(),a=t._data;if(1===e.length){if(e[0]!==n)throw new RangeError("Dimension mismatch. Matrix columns must match vector length.");for(var o=0;o<n;o++)i[o]=[a[o]];return new y({data:i,size:[n,1],datatype:t._datatype})}if(2===e.length){if(e[0]!==n||1!==e[1])throw new RangeError("Dimension mismatch. Matrix columns must match vector length.");if(Object(ie.n)(t)){if(r){i=[];for(var s=0;s<n;s++)i[s]=[a[s][0]];return new y({data:i,size:[n,1],datatype:t._datatype})}return t}if(Object(ie.H)(t)){for(var u=0;u<n;u++)i[u]=[0];for(var c=t._values,f=t._index,l=t._ptr,p=l[1],m=l[0];m<p;m++)i[f[m]][0]=c[m];return new y({data:i,size:[n,1],datatype:t._datatype})}}throw new RangeError("Dimension mismatch. The right side has to be either 1- or 2-dimensional vector.")}if(Object(ie.b)(t)){l=Object(E.a)(t);if(1===l.length){if(l[0]!==n)throw new RangeError("Dimension mismatch. Matrix columns must match vector length.");for(var h=0;h<n;h++)i[h]=[t[h]];return new y({data:i,size:[n,1]})}if(2!==l.length)throw new RangeError("Dimension mismatch. The right side has to be either 1- or 2-dimensional vector.");if(l[0]!==n||1!==l[1])throw new RangeError("Dimension mismatch. Matrix columns must match vector length.");for(var d=0;d<n;d++)i[d]=[t[d][0]];return new y({data:i,size:[n,1]})}}}var n=["typed","matrix","divideScalar","multiplyScalar","subtract","equalScalar","DenseMatrix"],Yn=Object(a.a)("lsolve",n,function(e){var t=e.typed,r=e.matrix,w=e.divideScalar,N=e.multiplyScalar,O=e.subtract,M=e.equalScalar,j=e.DenseMatrix,E=Wn({DenseMatrix:j});return t("lsolve",{"SparseMatrix, Array | Matrix":function(e,t){for(var r=(t=E(e,t,!0))._data,t=e._size[0],n=e._size[1],i=e._values,a=e._index,o=e._ptr,s=[],u=0;u<n;u++){var c=r[u][0]||0;if(M(c,0))s[u]=[0];else{for(var f=0,l=[],p=[],m=o[u],h=o[u+1],d=m;d<h;d++){var y=a[d];y===u?f=i[d]:u<y&&(l.push(i[d]),p.push(y))}if(M(f,0))throw new Error("Linear system cannot be solved since matrix is singular");for(var g=w(c,f),b=0,v=p.length;b<v;b++){var x=p[b];r[x]=[O(r[x][0]||0,N(g,l[b]))]}s[u]=[g]}}return new j({data:s,size:[t,1]})},"DenseMatrix, Array | Matrix":n,"Array, Array | Matrix":function(e,t){return n(r(e),t).valueOf()}});function n(e,t){for(var r=(t=E(e,t,!0))._data,n=e._size[0],i=e._size[1],a=[],o=e._data,s=0;s<i;s++){var u=r[s][0]||0,c=void 0;if(M(u,0))c=0;else{var f=o[s][s];if(M(f,0))throw new Error("Linear system cannot be solved since matrix is singular");c=w(u,f);for(var l=s+1;l<n;l++)r[l]=[O(r[l][0]||0,N(c,o[l][s]))]}a[s]=[c]}return new j({data:a,size:[n,1]})}}),t=["typed","matrix","divideScalar","multiplyScalar","subtract","equalScalar","DenseMatrix"],Xn=Object(a.a)("usolve",t,function(e){var t=e.typed,r=e.matrix,x=e.divideScalar,w=e.multiplyScalar,N=e.subtract,O=e.equalScalar,M=e.DenseMatrix,j=Wn({DenseMatrix:M});return t("usolve",{"SparseMatrix, Array | Matrix":function(e,t){for(var r=(t=j(e,t,!0))._data,n=e._size[0],t=e._size[1],i=e._values,a=e._index,o=e._ptr,s=[],u=t-1;0<=u;u--){var c=r[u][0]||0;if(O(c,0))s[u]=[0];else{for(var f=0,l=[],p=[],m=o[u],h=o[u+1]-1;m<=h;h--){var d=a[h];d===u?f=i[h]:d<u&&(l.push(i[h]),p.push(d))}if(O(f,0))throw new Error("Linear system cannot be solved since matrix is singular");for(var y=x(c,f),g=0,b=p.length;g<b;g++){var v=p[g];r[v]=[N(r[v][0],w(y,l[g]))]}s[u]=[y]}}return new M({data:s,size:[n,1]})},"DenseMatrix, Array | Matrix":n,"Array, Array | Matrix":function(e,t){return n(r(e),t).valueOf()}});function n(e,t){for(var r=(t=j(e,t,!0))._data,n=e._size[0],t=e._size[1],i=[],a=e._data,o=t-1;0<=o;o--){var s=r[o][0]||0,u=void 0;if(O(s,0))u=0;else{var c=a[o][o];if(O(c,0))throw new Error("Linear system cannot be solved since matrix is singular");u=x(s,c);for(var f=o-1;0<=f;f--)r[f]=[N(r[f][0]||0,w(u,a[f][o]))]}i[o]=[u]}return new M({data:i,size:[n,1]})}});function Qn(e){return function(e){if(Array.isArray(e))return Kn(e)}(e)||function(e){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(e))return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return Kn(e,t);var r=Object.prototype.toString.call(e).slice(8,-1);"Object"===r&&e.constructor&&(r=e.constructor.name);if("Map"===r||"Set"===r)return Array.from(e);if("Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r))return Kn(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function Kn(e,t){(null==t||t>e.length)&&(t=e.length);for(var r=0,n=new Array(t);r<t;r++)n[r]=e[r];return n}var ei="lsolveAll",n=["typed","matrix","divideScalar","multiplyScalar","subtract","equalScalar","DenseMatrix"],ti=Object(a.a)(ei,n,function(e){var t=e.typed,r=e.matrix,E=e.divideScalar,S=e.multiplyScalar,A=e.subtract,C=e.equalScalar,_=e.DenseMatrix,T=Wn({DenseMatrix:_});return t(ei,{"SparseMatrix, Array | Matrix":function(e,t){for(var r=[T(e,t,!0)._data.map(function(e){return e[0]})],n=e._size[0],i=e._size[1],a=e._values,o=e._index,s=e._ptr,u=0;u<i;u++)for(var c=r.length,f=0;f<c;f++){for(var l=r[f],p=[],m=[],h=s[u],d=s[u+1],y=0,g=h;g<d;g++){var b=o[g];b===u?y=a[g]:u<b&&(p.push(a[g]),m.push(b))}if(C(y,0))if(C(l[u],0)){if(0===f){var v=Qn(l);v[u]=1;for(var x=0,w=m.length;x<w;x++){var N=m[x];v[N]=A(v[N],p[x])}r.push(v)}}else{if(0===f)return[];r.splice(f,1),--f,--c}else{l[u]=E(l[u],y);for(var O=0,M=m.length;O<M;O++){var j=m[O];l[j]=A(l[j],S(l[u],p[O]))}}}return r.map(function(e){return new _({data:e.map(function(e){return[e]}),size:[n,1]})})},"DenseMatrix, Array | Matrix":n,"Array, Array | Matrix":function(e,t){return n(r(e),t).map(function(e){return e.valueOf()})}});function n(e,t){for(var r=[T(e,t,!0)._data.map(function(e){return e[0]})],n=e._data,i=e._size[0],a=e._size[1],o=0;o<a;o++)for(var s=r.length,u=0;u<s;u++){var c=r[u];if(C(n[o][o],0))if(C(c[o],0)){if(0===u){for(var f=Qn(c),l=o+(f[o]=1);l<a;l++)f[l]=A(f[l],n[l][o]);r.push(f)}}else{if(0===u)return[];r.splice(u,1),--u,--s}else{c[o]=E(c[o],n[o][o]);for(var p=o+1;p<a;p++)c[p]=A(c[p],S(c[o],n[p][o]))}}return r.map(function(e){return new _({data:e.map(function(e){return[e]}),size:[i,1]})})}});function ri(e){return function(e){if(Array.isArray(e))return ni(e)}(e)||function(e){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(e))return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return ni(e,t);var r=Object.prototype.toString.call(e).slice(8,-1);"Object"===r&&e.constructor&&(r=e.constructor.name);if("Map"===r||"Set"===r)return Array.from(e);if("Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r))return ni(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function ni(e,t){(null==t||t>e.length)&&(t=e.length);for(var r=0,n=new Array(t);r<t;r++)n[r]=e[r];return n}var ii="usolveAll",t=["typed","matrix","divideScalar","multiplyScalar","subtract","equalScalar","DenseMatrix"],ai=Object(a.a)(ii,t,function(e){var t=e.typed,r=e.matrix,j=e.divideScalar,E=e.multiplyScalar,S=e.subtract,A=e.equalScalar,C=e.DenseMatrix,_=Wn({DenseMatrix:C});return t(ii,{"SparseMatrix, Array | Matrix":function(e,t){for(var r=[_(e,t,!0)._data.map(function(e){return e[0]})],n=e._size[0],t=e._size[1],i=e._values,a=e._index,o=e._ptr,s=t-1;0<=s;s--)for(var u=r.length,c=0;c<u;c++){for(var f=r[c],l=[],p=[],m=o[s],h=o[s+1],d=0,y=h-1;m<=y;y--){var g=a[y];g===s?d=i[y]:g<s&&(l.push(i[y]),p.push(g))}if(A(d,0))if(A(f[s],0)){if(0===c){var b=ri(f);b[s]=1;for(var v=0,x=p.length;v<x;v++){var w=p[v];b[w]=S(b[w],l[v])}r.push(b)}}else{if(0===c)return[];r.splice(c,1),--c,--u}else{f[s]=j(f[s],d);for(var N=0,O=p.length;N<O;N++){var M=p[N];f[M]=S(f[M],E(f[s],l[N]))}}}return r.map(function(e){return new C({data:e.map(function(e){return[e]}),size:[n,1]})})},"DenseMatrix, Array | Matrix":n,"Array, Array | Matrix":function(e,t){return n(r(e),t).map(function(e){return e.valueOf()})}});function n(e,t){for(var r=[_(e,t,!0)._data.map(function(e){return e[0]})],n=e._data,i=e._size[0],a=e._size[1]-1;0<=a;a--)for(var o=r.length,s=0;s<o;s++){var u=r[s];if(A(n[a][a],0))if(A(u[a],0)){if(0===s){for(var c=ri(u),f=a-(c[a]=1);0<=f;f--)c[f]=S(c[f],n[f][a]);r.push(c)}}else{if(0===s)return[];r.splice(s,1),--s,--o}else{u[a]=j(u[a],n[a][a]);for(var l=a-1;0<=l;l--)u[l]=S(u[l],E(u[a],n[l][a]))}}return r.map(function(e){return new C({data:e.map(function(e){return[e]}),size:[i,1]})})}}),n=["typed","equalScalar"],oi=Object(a.a)("algorithm08",n,function(e){var C=e.typed,_=e.equalScalar;return function(e,t,r){var n=e._values,i=e._index,a=e._ptr,o=e._size,s=e._datatype,u=t._values,c=t._index,f=t._ptr,l=t._size,t=t._datatype;if(o.length!==l.length)throw new I.a(o.length,l.length);if(o[0]!==l[0]||o[1]!==l[1])throw new RangeError("Dimension mismatch. Matrix A ("+o+") must match Matrix B ("+l+")");if(!n||!u)throw new Error("Cannot perform operation on Pattern Sparse Matrices");var p,l=o[0],m=o[1],h=_,d=0,y=r;"string"==typeof s&&s===t&&(p=s,h=C.find(_,[p,p]),d=C.convert(0,p),y=C.find(r,[p,p]));for(var g,b=[],v=[],x=[],w=[],N=[],O=0;O<m;O++){x[O]=v.length;for(var M=O+1,j=a[O],E=a[O+1],S=j;S<E;S++)N[g=i[S]]=M,w[g]=n[S],v.push(g);for(j=f[O],E=f[O+1],S=j;S<E;S++)N[g=c[S]]===M&&(w[g]=y(w[g],u[S]));for(S=x[O];S<v.length;){var A=w[g=v[S]];h(A,d)?v.splice(S,1):(b.push(A),S++)}}return x[m]=v.length,e.createSparseMatrix({values:b,index:v,ptr:x,size:[l,m],datatype:p})}}),si="leftShift",t=["typed","matrix","equalScalar","zeros","DenseMatrix"],ui=Object(a.a)(si,t,function(e){var t=e.typed,r=e.matrix,n=e.equalScalar,i=e.zeros,e=e.DenseMatrix,a=it({typed:t}),o=ct({typed:t,equalScalar:n}),s=oi({typed:t,equalScalar:n}),u=ot({typed:t,DenseMatrix:e}),c=Ve({typed:t,equalScalar:n}),f=st({typed:t}),l=Ze({typed:t});return t(si,{"number, number":Gt,"BigNumber, BigNumber":Ut,"SparseMatrix, SparseMatrix":function(e,t){return s(e,t,this,!1)},"SparseMatrix, DenseMatrix":function(e,t){return o(t,e,this,!0)},"DenseMatrix, SparseMatrix":function(e,t){return a(e,t,this,!1)},"DenseMatrix, DenseMatrix":function(e,t){return f(e,t,this)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"SparseMatrix, number | BigNumber":function(e,t){return n(t,0)?e.clone():c(e,t,this,!1)},"DenseMatrix, number | BigNumber":function(e,t){return n(t,0)?e.clone():l(e,t,this,!1)},"number | BigNumber, SparseMatrix":function(e,t){return n(e,0)?i(t.size(),t.storage()):u(t,e,this,!0)},"number | BigNumber, DenseMatrix":function(e,t){return n(e,0)?i(t.size(),t.storage()):l(t,e,this,!0)},"Array, number | BigNumber":function(e,t){return this(r(e),t).valueOf()},"number | BigNumber, Array":function(e,t){return this(e,r(t)).valueOf()}})}),ci="rightArithShift",n=["typed","matrix","equalScalar","zeros","DenseMatrix"],fi=Object(a.a)(ci,n,function(e){var t=e.typed,r=e.matrix,n=e.equalScalar,i=e.zeros,e=e.DenseMatrix,a=it({typed:t}),o=ct({typed:t,equalScalar:n}),s=oi({typed:t,equalScalar:n}),u=ot({typed:t,DenseMatrix:e}),c=Ve({typed:t,equalScalar:n}),f=st({typed:t}),l=Ze({typed:t});return t(ci,{"number, number":Vt,"BigNumber, BigNumber":Pt,"SparseMatrix, SparseMatrix":function(e,t){return s(e,t,this,!1)},"SparseMatrix, DenseMatrix":function(e,t){return o(t,e,this,!0)},"DenseMatrix, SparseMatrix":function(e,t){return a(e,t,this,!1)},"DenseMatrix, DenseMatrix":function(e,t){return f(e,t,this)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"SparseMatrix, number | BigNumber":function(e,t){return n(t,0)?e.clone():c(e,t,this,!1)},"DenseMatrix, number | BigNumber":function(e,t){return n(t,0)?e.clone():l(e,t,this,!1)},"number | BigNumber, SparseMatrix":function(e,t){return n(e,0)?i(t.size(),t.storage()):u(t,e,this,!0)},"number | BigNumber, DenseMatrix":function(e,t){return n(e,0)?i(t.size(),t.storage()):l(t,e,this,!0)},"Array, number | BigNumber":function(e,t){return this(r(e),t).valueOf()},"number | BigNumber, Array":function(e,t){return this(e,r(t)).valueOf()}})}),li="rightLogShift",t=["typed","matrix","equalScalar","zeros","DenseMatrix"],pi=Object(a.a)(li,t,function(e){var t=e.typed,r=e.matrix,n=e.equalScalar,i=e.zeros,e=e.DenseMatrix,a=it({typed:t}),o=ct({typed:t,equalScalar:n}),s=oi({typed:t,equalScalar:n}),u=ot({typed:t,DenseMatrix:e}),c=Ve({typed:t,equalScalar:n}),f=st({typed:t}),l=Ze({typed:t});return t(li,{"number, number":Zt,"SparseMatrix, SparseMatrix":function(e,t){return s(e,t,this,!1)},"SparseMatrix, DenseMatrix":function(e,t){return o(t,e,this,!0)},"DenseMatrix, SparseMatrix":function(e,t){return a(e,t,this,!1)},"DenseMatrix, DenseMatrix":function(e,t){return f(e,t,this)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"SparseMatrix, number | BigNumber":function(e,t){return n(t,0)?e.clone():c(e,t,this,!1)},"DenseMatrix, number | BigNumber":function(e,t){return n(t,0)?e.clone():l(e,t,this,!1)},"number | BigNumber, SparseMatrix":function(e,t){return n(e,0)?i(t.size(),t.storage()):u(t,e,this,!0)},"number | BigNumber, DenseMatrix":function(e,t){return n(e,0)?i(t.size(),t.storage()):l(t,e,this,!0)},"Array, number | BigNumber":function(e,t){return this(r(e),t).valueOf()},"number | BigNumber, Array":function(e,t){return this(e,r(t)).valueOf()}})}),n=["typed","matrix","equalScalar","zeros","not"],mi=Object(a.a)("and",n,function(e){var t=e.typed,r=e.matrix,n=e.equalScalar,i=e.zeros,a=e.not,o=ct({typed:t,equalScalar:n}),s=ft({typed:t,equalScalar:n}),u=Ve({typed:t,equalScalar:n}),c=st({typed:t}),f=Ze({typed:t});return t("and",{"number, number":or,"Complex, Complex":function(e,t){return!(0===e.re&&0===e.im||0===t.re&&0===t.im)},"BigNumber, BigNumber":function(e,t){return!(e.isZero()||t.isZero()||e.isNaN()||t.isNaN())},"Unit, Unit":function(e,t){return this(e.value||0,t.value||0)},"SparseMatrix, SparseMatrix":function(e,t){return s(e,t,this,!1)},"SparseMatrix, DenseMatrix":function(e,t){return o(t,e,this,!0)},"DenseMatrix, SparseMatrix":function(e,t){return o(e,t,this,!1)},"DenseMatrix, DenseMatrix":function(e,t){return c(e,t,this)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"SparseMatrix, any":function(e,t){return a(t)?i(e.size(),e.storage()):u(e,t,this,!1)},"DenseMatrix, any":function(e,t){return a(t)?i(e.size(),e.storage()):f(e,t,this,!1)},"any, SparseMatrix":function(e,t){return a(e)?i(e.size(),e.storage()):u(t,e,this,!0)},"any, DenseMatrix":function(e,t){return a(e)?i(e.size(),e.storage()):f(t,e,this,!0)},"Array, any":function(e,t){return this(r(e),t).valueOf()},"any, Array":function(e,t){return this(e,r(t)).valueOf()}})}),hi="compare",t=["typed","config","matrix","equalScalar","BigNumber","Fraction","DenseMatrix"],di=Object(a.a)(hi,t,function(e){var t=e.typed,r=e.config,n=e.equalScalar,i=e.matrix,a=e.BigNumber,o=e.Fraction,e=e.DenseMatrix,s=ht({typed:t}),u=dt({typed:t,equalScalar:n}),c=yt({typed:t,DenseMatrix:e}),f=st({typed:t}),l=Ze({typed:t});return t(hi,{"boolean, boolean":function(e,t){return e===t?0:t<e?1:-1},"number, number":function(e,t){return Object(N.m)(e,t,r.epsilon)?0:t<e?1:-1},"BigNumber, BigNumber":function(e,t){return X(e,t,r.epsilon)?new a(0):new a(e.cmp(t))},"Fraction, Fraction":function(e,t){return new o(e.compare(t))},"Complex, Complex":function(){throw new TypeError("No ordering relation is defined for complex numbers")},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return this(e.value,t.value)},"SparseMatrix, SparseMatrix":function(e,t){return u(e,t,this)},"SparseMatrix, DenseMatrix":function(e,t){return s(t,e,this,!0)},"DenseMatrix, SparseMatrix":function(e,t){return s(e,t,this,!1)},"DenseMatrix, DenseMatrix":function(e,t){return f(e,t,this)},"Array, Array":function(e,t){return this(i(e),i(t)).valueOf()},"Array, Matrix":function(e,t){return this(i(e),t)},"Matrix, Array":function(e,t){return this(e,i(t))},"SparseMatrix, any":function(e,t){return c(e,t,this,!1)},"DenseMatrix, any":function(e,t){return l(e,t,this,!1)},"any, SparseMatrix":function(e,t){return c(t,e,this,!0)},"any, DenseMatrix":function(e,t){return l(t,e,this,!0)},"Array, any":function(e,t){return l(i(e),t,this,!1).valueOf()},"any, Array":function(e,t){return l(i(t),e,this,!0).valueOf()}})}),n=r(11),yi=r.n(n),gi="compareNatural",t=["typed","compare"],bi=Object(a.a)(gi,t,function(e){var t=e.typed,a=e.compare,o=a.signatures["boolean,boolean"];return t(gi,{"any, any":function(e,t){var r,n=Object(ie.M)(e),i=Object(ie.M)(t);if(!("number"!==n&&"BigNumber"!==n&&"Fraction"!==n||"number"!==i&&"BigNumber"!==i&&"Fraction"!==i))return"0"!==(r=a(e,t)).toString()?0<r?1:-1:yi()(n,i);if("Array"===n||"Matrix"===n||"Array"===i||"Matrix"===i)return 0!==(r=function e(t,r,n){if(Object(ie.H)(r)&&Object(ie.H)(n))return u(t,r.toJSON().values,n.toJSON().values);if(Object(ie.H)(r))return e(t,r.toArray(),n);if(Object(ie.H)(n))return e(t,r,n.toArray());if(Object(ie.n)(r))return e(t,r.toJSON().data,n);if(Object(ie.n)(n))return e(t,r,n.toJSON().data);if(!Array.isArray(r))return e(t,[r],n);if(!Array.isArray(n))return e(t,r,[n]);return u(t,r,n)}(this,e,t))?r:yi()(n,i);if(n!==i)return yi()(n,i);if("Complex"===n)return function(e,t){if(e.re>t.re)return 1;if(e.re<t.re)return-1;if(e.im>t.im)return 1;if(e.im<t.im)return-1;return 0}(e,t);if("Unit"===n)return e.equalBase(t)?this(e.value,t.value):u(this,e.formatUnits(),t.formatUnits());if("boolean"===n)return o(e,t);if("string"===n)return yi()(e,t);if("Object"===n)return function(e,t,r){var n=Object.keys(t),i=Object.keys(r);n.sort(yi.a),i.sort(yi.a);var a=u(e,n,i);if(0!==a)return a;for(var o=0;o<n.length;o++){var s=e(t[n[o]],r[i[o]]);if(0!==s)return s}return 0}(this,e,t);if("null"===n)return 0;if("undefined"===n)return 0;throw new TypeError('Unsupported type of value "'+n+'"')}});function u(e,t,r){for(var n=0,i=Math.min(t.length,r.length);n<i;n++){var a=e(t[n],r[n]);if(0!==a)return a}return t.length>r.length?1:t.length<r.length?-1:0}});var vi="compareText",n=["typed","matrix"],xi=Object(a.a)(vi,n,function(e){var t=e.typed,r=e.matrix,n=st({typed:t}),i=Ze({typed:t});return t(vi,{"any, any":Z.a,"DenseMatrix, DenseMatrix":function(e,t){return n(e,t,Z.a)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"DenseMatrix, any":function(e,t){return i(e,t,Z.a,!1)},"any, DenseMatrix":function(e,t){return i(t,e,Z.a,!0)},"Array, any":function(e,t){return i(r(e),t,Z.a,!1).valueOf()},"any, Array":function(e,t){return i(r(t),e,Z.a,!0).valueOf()}})}),wi="equal",t=["typed","matrix","equalScalar","DenseMatrix"],Ni=Object(a.a)(wi,t,function(e){var t=e.typed,r=e.matrix,n=e.equalScalar,e=e.DenseMatrix,i=ht({typed:t}),a=Xt({typed:t,DenseMatrix:e}),o=yt({typed:t,DenseMatrix:e}),s=st({typed:t}),u=Ze({typed:t});return t(wi,{"any, any":function(e,t){return null===e?null===t:null===t?null===e:void 0===e?void 0===t:void 0===t?void 0===e:n(e,t)},"SparseMatrix, SparseMatrix":function(e,t){return a(e,t,n)},"SparseMatrix, DenseMatrix":function(e,t){return i(t,e,n,!0)},"DenseMatrix, SparseMatrix":function(e,t){return i(e,t,n,!1)},"DenseMatrix, DenseMatrix":function(e,t){return s(e,t,n)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"SparseMatrix, any":function(e,t){return o(e,t,n,!1)},"DenseMatrix, any":function(e,t){return u(e,t,n,!1)},"any, SparseMatrix":function(e,t){return o(t,e,n,!0)},"any, DenseMatrix":function(e,t){return u(t,e,n,!0)},"Array, any":function(e,t){return u(r(e),t,n,!1).valueOf()},"any, Array":function(e,t){return u(r(t),e,n,!0).valueOf()}})}),Oi=(Object(a.a)(wi,["typed","equalScalar"],function(e){var t=e.typed,r=e.equalScalar;return t(wi,{"any, any":function(e,t){return null===e?null===t:null===t?null===e:void 0===e?void 0===t:void 0===t?void 0===e:r(e,t)}})}),"equalText"),n=["typed","compareText","isZero"],Mi=Object(a.a)(Oi,n,function(e){var t=e.typed,r=e.compareText,n=e.isZero;return t(Oi,{"any, any":function(e,t){return n(r(e,t))}})}),ji="smaller",t=["typed","config","matrix","DenseMatrix"],Ei=Object(a.a)(ji,t,function(e){var t=e.typed,r=e.config,n=e.matrix,e=e.DenseMatrix,i=ht({typed:t}),a=Xt({typed:t,DenseMatrix:e}),o=yt({typed:t,DenseMatrix:e}),s=st({typed:t}),u=Ze({typed:t});return t(ji,{"boolean, boolean":function(e,t){return e<t},"number, number":function(e,t){return e<t&&!Object(N.m)(e,t,r.epsilon)},"BigNumber, BigNumber":function(e,t){return e.lt(t)&&!X(e,t,r.epsilon)},"Fraction, Fraction":function(e,t){return-1===e.compare(t)},"Complex, Complex":function(){throw new TypeError("No ordering relation is defined for complex numbers")},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return this(e.value,t.value)},"SparseMatrix, SparseMatrix":function(e,t){return a(e,t,this)},"SparseMatrix, DenseMatrix":function(e,t){return i(t,e,this,!0)},"DenseMatrix, SparseMatrix":function(e,t){return i(e,t,this,!1)},"DenseMatrix, DenseMatrix":function(e,t){return s(e,t,this)},"Array, Array":function(e,t){return this(n(e),n(t)).valueOf()},"Array, Matrix":function(e,t){return this(n(e),t)},"Matrix, Array":function(e,t){return this(e,n(t))},"SparseMatrix, any":function(e,t){return o(e,t,this,!1)},"DenseMatrix, any":function(e,t){return u(e,t,this,!1)},"any, SparseMatrix":function(e,t){return o(t,e,this,!0)},"any, DenseMatrix":function(e,t){return u(t,e,this,!0)},"Array, any":function(e,t){return u(n(e),t,this,!1).valueOf()},"any, Array":function(e,t){return u(n(t),e,this,!0).valueOf()}})}),Si="smallerEq",n=["typed","config","matrix","DenseMatrix"],Ai=Object(a.a)(Si,n,function(e){var t=e.typed,r=e.config,n=e.matrix,e=e.DenseMatrix,i=ht({typed:t}),a=Xt({typed:t,DenseMatrix:e}),o=yt({typed:t,DenseMatrix:e}),s=st({typed:t}),u=Ze({typed:t});return t(Si,{"boolean, boolean":function(e,t){return e<=t},"number, number":function(e,t){return e<=t||Object(N.m)(e,t,r.epsilon)},"BigNumber, BigNumber":function(e,t){return e.lte(t)||X(e,t,r.epsilon)},"Fraction, Fraction":function(e,t){return 1!==e.compare(t)},"Complex, Complex":function(){throw new TypeError("No ordering relation is defined for complex numbers")},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return this(e.value,t.value)},"SparseMatrix, SparseMatrix":function(e,t){return a(e,t,this)},"SparseMatrix, DenseMatrix":function(e,t){return i(t,e,this,!0)},"DenseMatrix, SparseMatrix":function(e,t){return i(e,t,this,!1)},"DenseMatrix, DenseMatrix":function(e,t){return s(e,t,this)},"Array, Array":function(e,t){return this(n(e),n(t)).valueOf()},"Array, Matrix":function(e,t){return this(n(e),t)},"Matrix, Array":function(e,t){return this(e,n(t))},"SparseMatrix, any":function(e,t){return o(e,t,this,!1)},"DenseMatrix, any":function(e,t){return u(e,t,this,!1)},"any, SparseMatrix":function(e,t){return o(t,e,this,!0)},"any, DenseMatrix":function(e,t){return u(t,e,this,!0)},"Array, any":function(e,t){return u(n(e),t,this,!1).valueOf()},"any, Array":function(e,t){return u(n(t),e,this,!0).valueOf()}})}),Ci="larger",t=["typed","config","matrix","DenseMatrix"],_i=Object(a.a)(Ci,t,function(e){var t=e.typed,r=e.config,n=e.matrix,e=e.DenseMatrix,i=ht({typed:t}),a=Xt({typed:t,DenseMatrix:e}),o=yt({typed:t,DenseMatrix:e}),s=st({typed:t}),u=Ze({typed:t});return t(Ci,{"boolean, boolean":function(e,t){return t<e},"number, number":function(e,t){return t<e&&!Object(N.m)(e,t,r.epsilon)},"BigNumber, BigNumber":function(e,t){return e.gt(t)&&!X(e,t,r.epsilon)},"Fraction, Fraction":function(e,t){return 1===e.compare(t)},"Complex, Complex":function(){throw new TypeError("No ordering relation is defined for complex numbers")},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return this(e.value,t.value)},"SparseMatrix, SparseMatrix":function(e,t){return a(e,t,this)},"SparseMatrix, DenseMatrix":function(e,t){return i(t,e,this,!0)},"DenseMatrix, SparseMatrix":function(e,t){return i(e,t,this,!1)},"DenseMatrix, DenseMatrix":function(e,t){return s(e,t,this)},"Array, Array":function(e,t){return this(n(e),n(t)).valueOf()},"Array, Matrix":function(e,t){return this(n(e),t)},"Matrix, Array":function(e,t){return this(e,n(t))},"SparseMatrix, any":function(e,t){return o(e,t,this,!1)},"DenseMatrix, any":function(e,t){return u(e,t,this,!1)},"any, SparseMatrix":function(e,t){return o(t,e,this,!0)},"any, DenseMatrix":function(e,t){return u(t,e,this,!0)},"Array, any":function(e,t){return u(n(e),t,this,!1).valueOf()},"any, Array":function(e,t){return u(n(t),e,this,!0).valueOf()}})}),Ti="largerEq",n=["typed","config","matrix","DenseMatrix"],qi=Object(a.a)(Ti,n,function(e){var t=e.typed,r=e.config,n=e.matrix,e=e.DenseMatrix,i=ht({typed:t}),a=Xt({typed:t,DenseMatrix:e}),o=yt({typed:t,DenseMatrix:e}),s=st({typed:t}),u=Ze({typed:t});return t(Ti,{"boolean, boolean":function(e,t){return t<=e},"number, number":function(e,t){return t<=e||Object(N.m)(e,t,r.epsilon)},"BigNumber, BigNumber":function(e,t){return e.gte(t)||X(e,t,r.epsilon)},"Fraction, Fraction":function(e,t){return-1!==e.compare(t)},"Complex, Complex":function(){throw new TypeError("No ordering relation is defined for complex numbers")},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return this(e.value,t.value)},"SparseMatrix, SparseMatrix":function(e,t){return a(e,t,this)},"SparseMatrix, DenseMatrix":function(e,t){return i(t,e,this,!0)},"DenseMatrix, SparseMatrix":function(e,t){return i(e,t,this,!1)},"DenseMatrix, DenseMatrix":function(e,t){return s(e,t,this)},"Array, Array":function(e,t){return this(n(e),n(t)).valueOf()},"Array, Matrix":function(e,t){return this(n(e),t)},"Matrix, Array":function(e,t){return this(e,n(t))},"SparseMatrix, any":function(e,t){return o(e,t,this,!1)},"DenseMatrix, any":function(e,t){return u(e,t,this,!1)},"any, SparseMatrix":function(e,t){return o(t,e,this,!0)},"any, DenseMatrix":function(e,t){return u(t,e,this,!0)},"Array, any":function(e,t){return u(n(e),t,this,!1).valueOf()},"any, Array":function(e,t){return u(n(t),e,this,!0).valueOf()}})}),Ii="deepEqual",t=["typed","equal"],Bi=Object(a.a)(Ii,t,function(e){var t=e.typed,a=e.equal;return t(Ii,{"any, any":function(e,t){return function e(t,r){{if(Array.isArray(t)){if(Array.isArray(r)){var n=t.length;if(n!==r.length)return!1;for(var i=0;i<n;i++)if(!e(t[i],r[i]))return!1;return!0}return!1}return!Array.isArray(r)&&a(t,r)}}(e.valueOf(),t.valueOf())}})}),ki="unequal",n=["typed","config","equalScalar","matrix","DenseMatrix"],zi=Object(a.a)(ki,n,function(e){var t=e.typed,r=(e.config,e.equalScalar),n=e.matrix,e=e.DenseMatrix,i=ht({typed:t}),a=Xt({typed:t,DenseMatrix:e}),o=yt({typed:t,DenseMatrix:e}),s=st({typed:t}),u=Ze({typed:t});return t("unequal",{"any, any":function(e,t){return null===e?null!==t:null===t?null!==e:void 0===e?void 0!==t:void 0===t?void 0!==e:c(e,t)},"SparseMatrix, SparseMatrix":function(e,t){return a(e,t,c)},"SparseMatrix, DenseMatrix":function(e,t){return i(t,e,c,!0)},"DenseMatrix, SparseMatrix":function(e,t){return i(e,t,c,!1)},"DenseMatrix, DenseMatrix":function(e,t){return s(e,t,c)},"Array, Array":function(e,t){return this(n(e),n(t)).valueOf()},"Array, Matrix":function(e,t){return this(n(e),t)},"Matrix, Array":function(e,t){return this(e,n(t))},"SparseMatrix, any":function(e,t){return o(e,t,c,!1)},"DenseMatrix, any":function(e,t){return u(e,t,c,!1)},"any, SparseMatrix":function(e,t){return o(t,e,c,!0)},"any, DenseMatrix":function(e,t){return u(t,e,c,!0)},"Array, any":function(e,t){return u(n(e),t,c,!1).valueOf()},"any, Array":function(e,t){return u(n(t),e,c,!0).valueOf()}});function c(e,t){return!r(e,t)}}),Di=(Object(a.a)(ki,["typed","equalScalar"],function(e){var t=e.typed,r=e.equalScalar;return t(ki,{"any, any":function(e,t){return null===e?null!==t:null===t?null!==e:void 0===e?void 0!==t:void 0===t?void 0!==e:!r(e,t)}})}),"partitionSelect"),t=["typed","isNumeric","isNaN","compare"],Ri=Object(a.a)(Di,t,function(e){function n(e,t){return-r(e,t)}var t=e.typed,f=e.isNumeric,l=e.isNaN,r=e.compare,i=r;return t(Di,{"Array | Matrix, number":function(e,t){return a(e,t,i)},"Array | Matrix, number, string":function(e,t,r){if("asc"===r)return a(e,t,i);if("desc"===r)return a(e,t,n);throw new Error('Compare string must be "asc" or "desc"')},"Array | Matrix, number, function":a});function a(e,t,r){if(!Object(N.i)(t)||t<0)throw new Error("k must be a non-negative integer");if(Object(ie.v)(e)){if(1<e.size().length)throw new Error("Only one dimensional matrices supported");return o(e.valueOf(),t,r)}if(Array.isArray(e))return o(e,t,r)}function o(e,t,r){if(t>=e.length)throw new Error("k out of bounds");for(var n=0;n<e.length;n++)if(f(e[n])&&l(e[n]))return e[n];for(var i=0,a=e.length-1;i<a;){for(var o,s=i,u=a,c=e[Math.floor(Math.random()*(a-i+1))+i];s<u;)0<=r(e[s],c)?(o=e[u],e[u]=e[s],e[s]=o,--u):++s;0<r(e[s],c)&&--s,t<=s?a=s:i=s+1}return e[t]}}),n=["typed","matrix","compare","compareNatural"],Ui=Object(a.a)("sort",n,function(e){function t(e,t){return-i(e,t)}var r=e.typed,n=e.matrix,i=e.compare,a=e.compareNatural,o=i;return r("sort",{Array:function(e){return u(e),e.sort(o)},Matrix:function(e){return c(e),n(e.toArray().sort(o),e.storage())},"Array, function":function(e,t){return u(e),e.sort(t)},"Matrix, function":function(e,t){return c(e),n(e.toArray().sort(t),e.storage())},"Array, string":function(e,t){return u(e),e.sort(s(t))},"Matrix, string":function(e,t){return c(e),n(e.toArray().sort(s(t)),e.storage())}});function s(e){if("asc"===e)return o;if("desc"===e)return t;if("natural"===e)return a;throw new Error('String "asc", "desc", or "natural" expected')}function u(e){if(1!==Object(E.a)(e).length)throw new Error("One dimensional array expected")}function c(e){if(1!==e.size().length)throw new Error("One dimensional matrix expected")}}),t=["typed","config","numeric","larger"],Pi=Object(a.a)("max",t,function(e){var t=e.typed,n=e.config,i=e.numeric,a=e.larger;return t("max",{"Array | Matrix":o,"Array | Matrix, number | BigNumber":function(e,t){return C(e,t.valueOf(),r)},"...":function(e){if(S(e))throw new TypeError("Scalar values expected in function max");return o(e)}});function r(e,t){try{return a(e,t)?e:t}catch(e){throw vn(e,"max",t)}}function o(e){var r;if(A(e,function(t){try{isNaN(t)&&"number"==typeof t?r=NaN:void 0!==r&&!a(t,r)||(r=t)}catch(e){throw vn(e,"max",t)}}),void 0===r)throw new Error("Cannot calculate max of an empty array");return"string"==typeof r&&(r=i(r,n.number)),r}}),n=["typed","config","numeric","smaller"],Fi=Object(a.a)("min",n,function(e){var t=e.typed,n=e.config,i=e.numeric,a=e.smaller;return t("min",{"Array | Matrix":o,"Array | Matrix, number | BigNumber":function(e,t){return C(e,t.valueOf(),r)},"...":function(e){if(S(e))throw new TypeError("Scalar values expected in function min");return o(e)}});function r(e,t){try{return a(e,t)?e:t}catch(e){throw vn(e,"min",t)}}function o(e){var r;if(A(e,function(t){try{isNaN(t)&&"number"==typeof t?r=NaN:void 0!==r&&!a(t,r)||(r=t)}catch(e){throw vn(e,"min",t)}}),void 0===r)throw new Error("Cannot calculate min of an empty array");return"string"==typeof r&&(r=i(r,n.number)),r}}),t=["smaller","DenseMatrix"],Li=Object(a.a)("ImmutableDenseMatrix",t,function(e){var r=e.smaller,n=e.DenseMatrix;function i(e,t){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator");if(t&&!Object(ie.I)(t))throw new Error("Invalid datatype: "+t);if(Object(ie.v)(e)||Object(ie.b)(e)){var r=new n(e,t);this._data=r._data,this._size=r._size,this._datatype=r._datatype,this._min=null,this._max=null}else if(e&&Object(ie.b)(e.data)&&Object(ie.b)(e.size))this._data=e.data,this._size=e.size,this._datatype=e.datatype,this._min=void 0!==e.min?e.min:null,this._max=void 0!==e.max?e.max:null;else{if(e)throw new TypeError("Unsupported type of data ("+Object(ie.M)(e)+")");this._data=[],this._size=[0],this._datatype=t,this._min=null,this._max=null}}return(i.prototype=new n).type="ImmutableDenseMatrix",i.prototype.isImmutableDenseMatrix=!0,i.prototype.subset=function(e){switch(arguments.length){case 1:e=n.prototype.subset.call(this,e);return Object(ie.v)(e)?new i({data:e._data,size:e._size,datatype:e._datatype}):e;case 2:case 3:throw new Error("Cannot invoke set subset on an Immutable Matrix instance");default:throw new SyntaxError("Wrong number of arguments")}},i.prototype.set=function(){throw new Error("Cannot invoke set on an Immutable Matrix instance")},i.prototype.resize=function(){throw new Error("Cannot invoke resize on an Immutable Matrix instance")},i.prototype.reshape=function(){throw new Error("Cannot invoke reshape on an Immutable Matrix instance")},i.prototype.clone=function(){return new i({data:Object(ae.a)(this._data),size:Object(ae.a)(this._size),datatype:this._datatype})},i.prototype.toJSON=function(){return{mathjs:"ImmutableDenseMatrix",data:this._data,size:this._size,datatype:this._datatype}},i.fromJSON=function(e){return new i(e)},i.prototype.swapRows=function(){throw new Error("Cannot invoke swapRows on an Immutable Matrix instance")},i.prototype.min=function(){var t;return null===this._min&&(t=null,this.forEach(function(e){null!==t&&!r(e,t)||(t=e)}),this._min=null!==t?t:void 0),this._min},i.prototype.max=function(){var t;return null===this._max&&(t=null,this.forEach(function(e){null!==t&&!r(t,e)||(t=e)}),this._max=null!==t?t:void 0),this._max},i},{isClass:!0}),n=["ImmutableDenseMatrix"],Hi=Object(a.a)("Index",n,function(e){var n=e.ImmutableDenseMatrix;function a(e){if(!(this instanceof a))throw new SyntaxError("Constructor must be called with the new operator");this._dimensions=[],this._isScalar=!0;for(var t=0,r=arguments.length;t<r;t++){var n=arguments[t];if(Object(ie.D)(n))this._dimensions.push(n),this._isScalar=!1;else if(Array.isArray(n)||Object(ie.v)(n)){var i=o(n.valueOf());this._dimensions.push(i);i=i.size();1===i.length&&1===i[0]||(this._isScalar=!1)}else if("number"==typeof n)this._dimensions.push(o([n]));else{if("string"!=typeof n)throw new TypeError("Dimension must be an Array, Matrix, number, string, or Range");this._dimensions.push(n)}}}function o(e){for(var t=0,r=e.length;t<r;t++)if("number"!=typeof e[t]||!Object(N.i)(e[t]))throw new TypeError("Index parameters must be positive integer numbers");return new n(e)}return a.prototype.type="Index",a.prototype.isIndex=!0,a.prototype.clone=function(){var e=new a;return e._dimensions=Object(ae.a)(this._dimensions),e._isScalar=this._isScalar,e},a.create=function(e){var t=new a;return a.apply(t,e),t},a.prototype.size=function(){for(var e=[],t=0,r=this._dimensions.length;t<r;t++){var n=this._dimensions[t];e[t]="string"==typeof n?1:n.size()[0]}return e},a.prototype.max=function(){for(var e=[],t=0,r=this._dimensions.length;t<r;t++){var n=this._dimensions[t];e[t]="string"==typeof n?n:n.max()}return e},a.prototype.min=function(){for(var e=[],t=0,r=this._dimensions.length;t<r;t++){var n=this._dimensions[t];e[t]="string"==typeof n?n:n.min()}return e},a.prototype.forEach=function(e){for(var t=0,r=this._dimensions.length;t<r;t++)e(this._dimensions[t],t,this)},a.prototype.dimension=function(e){return this._dimensions[e]||null},a.prototype.isObjectProperty=function(){return 1===this._dimensions.length&&"string"==typeof this._dimensions[0]},a.prototype.getObjectProperty=function(){return this.isObjectProperty()?this._dimensions[0]:null},a.prototype.isScalar=function(){return this._isScalar},a.prototype.valueOf=a.prototype.toArray=function(){for(var e=[],t=0,r=this._dimensions.length;t<r;t++){var n=this._dimensions[t];e.push("string"==typeof n?n:n.toArray())}return e},a.prototype.toString=function(){for(var e=[],t=0,r=this._dimensions.length;t<r;t++){var n=this._dimensions[t];"string"==typeof n?e.push(JSON.stringify(n)):e.push(n.toString())}return"["+e.join(", ")+"]"},a.prototype.toJSON=function(){return{mathjs:"Index",dimensions:this._dimensions}},a.fromJSON=function(e){return a.create(e.dimensions)},a},{isClass:!0}),t=["smaller","larger"],$i=Object(a.a)("FibonacciHeap",t,function(e){var l=e.smaller,p=e.larger,m=1/Math.log((1+Math.sqrt(5))/2);function t(){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");this._minimum=null,this._size=0}function i(e,t,r){t.left.right=t.right,t.right.left=t.left,r.degree--,r.child===t&&(r.child=t.right),0===r.degree&&(r.child=null),t.left=e,t.right=e.right,((e.right=t).right.left=t).parent=null,t.mark=!1}t.prototype.type="FibonacciHeap",t.prototype.isFibonacciHeap=!0,t.prototype.insert=function(e,t){var r={key:e,value:t,degree:0};return this._minimum?(t=this._minimum,r.left=t,r.right=t.right,(t.right=r).right.left=r,l(e,t.key)&&(this._minimum=r)):((r.left=r).right=r,this._minimum=r),this._size++,r},t.prototype.size=function(){return this._size},t.prototype.clear=function(){this._minimum=null,this._size=0},t.prototype.isEmpty=function(){return 0===this._size},t.prototype.extractMinimum=function(){var e=this._minimum;if(null===e)return e;for(var t=this._minimum,r=e.degree,n=e.child;0<r;){var i=n.right;n.left.right=n.right,n.right.left=n.left,n.left=t,n.right=t.right,((t.right=n).right.left=n).parent=null,n=i,r--}return e.left.right=e.right,e.right.left=e.left,t=e===e.right?null:function(e,t){var r,n=Math.floor(Math.log(t)*m)+1,i=new Array(n),a=0,o=e;if(o)for(a++,o=o.right;o!==e;)a++,o=o.right;for(;0<a;){for(var s,u=o.degree,c=o.right;r=i[u];)p(o.key,r.key)&&(s=r,r=o,o=s),h(r,o),i[u]=null,u++;i[u]=o,o=c,a--}e=null;for(var f=0;f<n;f++)(r=i[f])&&(e?(r.left.right=r.right,r.right.left=r.left,r.left=e,r.right=e.right,(e.right=r).right.left=r,l(r.key,e.key)&&(e=r)):e=r);return e}(t=e.right,this._size),this._size--,this._minimum=t,e},t.prototype.remove=function(e){this._minimum=function(e,t,r){t.key=r;r=t.parent;r&&l(t.key,r.key)&&(i(e,t,r),function e(t,r){var n=r.parent;if(!n)return;r.mark?(i(t,r,n),e(n)):r.mark=!0}(e,r));l(t.key,e.key)&&(e=t);return e}(this._minimum,e,-1),this.extractMinimum()};var h=function(e,t){e.left.right=e.right,e.right.left=e.left,(e.parent=t).child?(e.left=t.child,e.right=t.child.right,(t.child.right=e).right.left=e):((t.child=e).right=e).left=e,t.degree++,e.mark=!1};return t},{isClass:!0}),n=["addScalar","equalScalar","FibonacciHeap"],Gi=Object(a.a)("Spa",n,function(e){var n=e.addScalar,c=e.equalScalar,t=e.FibonacciHeap;function r(){if(!(this instanceof r))throw new SyntaxError("Constructor must be called with the new operator");this._values=[],this._heap=new t}return r.prototype.type="Spa",r.prototype.isSpa=!0,r.prototype.set=function(e,t){this._values[e]?this._values[e].value=t:(t=this._heap.insert(e,t),this._values[e]=t)},r.prototype.get=function(e){e=this._values[e];return e?e.value:0},r.prototype.accumulate=function(e,t){var r=this._values[e];r?r.value=n(r.value,t):(r=this._heap.insert(e,t),this._values[e]=r)},r.prototype.forEach=function(e,t,r){var n=this._heap,i=this._values,a=[];for((s=n.extractMinimum())&&a.push(s);s&&s.key<=t;)s.key>=e&&(c(s.value,0)||r(s.key,s.value,this)),(s=n.extractMinimum())&&a.push(s);for(var o=0;o<a.length;o++){var s,u=a[o];i[(s=n.insert(u.key,u.value)).key]=s}},r.prototype.swap=function(e,t){var r=this._values[e],n=this._values[t];!r&&n?(r=this._heap.insert(e,n.value),this._heap.remove(n),this._values[e]=r,this._values[t]=void 0):r&&!n?(n=this._heap.insert(t,r.value),this._heap.remove(r),this._values[t]=n,this._values[e]=void 0):r&&n&&(e=r.value,r.value=n.value,n.value=e)},r},{isClass:!0}),Vi=dr(function(e){return new e(1).exp()},Yi),Zi=dr(function(e){return new e(1).plus(new e(5).sqrt()).div(2)},Yi),Ji=dr(function(e){return e.acos(-1)},Yi),Wi=dr(function(e){return Ji(e).times(2)},Yi);function Yi(e){return e[0].precision}function Xi(e){return(Xi="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function Qi(){return(Qi=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var r,n=arguments[t];for(r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e}).apply(this,arguments)}function Ki(t,e){var r,n=Object.keys(t);return Object.getOwnPropertySymbols&&(r=Object.getOwnPropertySymbols(t),e&&(r=r.filter(function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable})),n.push.apply(n,r)),n}function ea(n){for(var e=1;e<arguments.length;e++){var i=null!=arguments[e]?arguments[e]:{};e%2?Ki(Object(i),!0).forEach(function(e){var t,r;t=n,e=i[r=e],r in t?Object.defineProperty(t,r,{value:e,enumerable:!0,configurable:!0,writable:!0}):t[r]=e}):Object.getOwnPropertyDescriptors?Object.defineProperties(n,Object.getOwnPropertyDescriptors(i)):Ki(Object(i)).forEach(function(e){Object.defineProperty(n,e,Object.getOwnPropertyDescriptor(i,e))})}return n}var t=["?on","config","addScalar","subtract","multiplyScalar","divideScalar","pow","abs","fix","round","equal","isNumeric","format","number","Complex","BigNumber","Fraction"],ta=Object(a.a)("Unit",t,function(e){var d,y,N,t=e.on,g=e.config,u=e.addScalar,c=e.subtract,f=e.multiplyScalar,l=e.divideScalar,p=e.pow,m=e.abs,h=e.fix,b=e.round,v=e.equal,n=e.isNumeric,a=e.format,r=e.number,i=e.Complex,x=e.BigNumber,w=e.Fraction,o=r;function O(e,t){if(!(this instanceof O))throw new Error("Constructor must be called with the new operator");if(null!=e&&!n(e)&&!Object(ie.j)(e))throw new TypeError("First parameter in Unit constructor must be number, BigNumber, Fraction, Complex, or undefined");if(void 0!==t&&("string"!=typeof t||""===t))throw new TypeError("Second parameter in Unit constructor must be a string");if(void 0!==t){t=O.parse(t);this.units=t.units,this.dimensions=t.dimensions}else{this.units=[{unit:k,prefix:T.NONE,power:0}],this.dimensions=[];for(var r=0;r<I.length;r++)this.dimensions[r]=0}this.value=null!=e?this._normalize(e):null,this.fixPrefix=!1,this.skipAutomaticSimplification=!0}function M(){for(;" "===N||"\t"===N;)E()}function j(e){return"0"<=e&&e<="9"}function E(){y++,N=d.charAt(y)}function s(e){y=e,N=d.charAt(y)}function S(){var e="",t=y;if("+"===N?E():"-"===N&&(e+=N,E()),!("0"<=(r=N)&&r<="9"||"."===r))return s(t),null;if("."===N){if(e+=N,E(),!j(N))return s(t),null}else{for(;j(N);)e+=N,E();"."===N&&(e+=N,E())}for(;j(N);)e+=N,E();if("E"===N||"e"===N){var r="",t=y;if(r+=N,E(),"+"!==N&&"-"!==N||(r+=N,E()),!j(N))return s(t),e;for(e+=r;j(N);)e+=N,E()}return e}function A(e){return N===e&&(E(),e)}function C(e){if(Object(ae.f)(z,e)){var t=z[e];return{unit:t,prefix:t.prefixes[""]}}for(var r in z)if(Object(ae.f)(z,r)&&Object(Z.b)(e,r)){var n=z[r],i=e.length-r.length,i=e.substring(0,i),i=Object(ae.f)(n.prefixes,i)?n.prefixes[i]:void 0;if(void 0!==i)return{unit:n,prefix:i}}return null}function _(e){return e.equalBase(B.NONE)&&null!==e.value&&!g.predictable?e.value:e}O.prototype.type="Unit",O.prototype.isUnit=!0,O.parse=function(e,t){if(t=t||{},y=-1,N="","string"!=typeof(d=e))throw new TypeError("Invalid argument in Unit.parse, string expected");var r=new O,n=1,i=!(r.units=[]);E(),M();var a=S(),o=null;if(a){if("BigNumber"===g.number)o=new x(a);else if("Fraction"===g.number)try{o=new w(a)}catch(e){o=parseFloat(a)}else o=parseFloat(a);M(),A("*")?(n=1,i=!0):A("/")&&(n=-1,i=!0)}for(var s=[],u=1;;){for(M();"("===N;)s.push(n),u*=n,n=1,E(),M();var c=void 0;if(!N)break;var f=N;if(null===(c=function(){for(var e="";j(N)||O.isValidAlpha(N);)e+=N,E();var t=e.charAt(0);return O.isValidAlpha(t)?e:null}()))throw new SyntaxError('Unexpected "'+f+'" in "'+d+'" at index '+y.toString());var l=C(c);if(null===l)throw new SyntaxError('Unit "'+c+'" not found.');var p=n*u;if(M(),A("^")){M();var m=S();if(null===m)throw new SyntaxError('In "'+e+'", "^" must be followed by a floating-point number');p*=m}r.units.push({unit:l.unit,prefix:l.prefix,power:p});for(var h=0;h<I.length;h++)r.dimensions[h]+=(l.unit.dimensions[h]||0)*p;for(M();")"===N;){if(0===s.length)throw new SyntaxError('Unmatched ")" in "'+d+'" at index '+y.toString());u/=s.pop(),E(),M()}i=!1,A("*")?(n=1,i=!0):A("/")?(n=-1,i=!0):n=1,l.unit.base&&(m=l.unit.base.key,U.auto[m]={unit:l.unit,prefix:l.prefix})}if(M(),N)throw new SyntaxError('Could not parse: "'+e+'"');if(i)throw new SyntaxError('Trailing characters: "'+e+'"');if(0!==s.length)throw new SyntaxError('Unmatched "(" in "'+d+'"');if(0===r.units.length&&!t.allowNoUnits)throw new SyntaxError('"'+e+'" contains no units');return r.value=void 0!==o?r._normalize(o):null,r},O.prototype.clone=function(){var e=new O;e.fixPrefix=this.fixPrefix,e.skipAutomaticSimplification=this.skipAutomaticSimplification,e.value=Object(ae.a)(this.value),e.dimensions=this.dimensions.slice(0),e.units=[];for(var t=0;t<this.units.length;t++)for(var r in e.units[t]={},this.units[t])Object(ae.f)(this.units[t],r)&&(e.units[t][r]=this.units[t][r]);return e},O.prototype._isDerived=function(){return 0!==this.units.length&&(1<this.units.length||1e-15<Math.abs(this.units[0].power-1))},O.prototype._normalize=function(e){var t,r,n,i;if(null==e||0===this.units.length)return e;if(this._isDerived()){for(var a=e,o=O._getNumberConverter(Object(ie.M)(e)),s=0;s<this.units.length;s++)t=o(this.units[s].unit.value),i=o(this.units[s].prefix.value),n=o(this.units[s].power),a=f(a,p(f(t,i),n));return a}return t=(o=O._getNumberConverter(Object(ie.M)(e)))(this.units[0].unit.value),r=o(this.units[0].unit.offset),i=o(this.units[0].prefix.value),f(u(e,r),f(t,i))},O.prototype._denormalize=function(e,t){var r,n,i,a;if(null==e||0===this.units.length)return e;if(this._isDerived()){for(var o=e,s=O._getNumberConverter(Object(ie.M)(e)),u=0;u<this.units.length;u++)r=s(this.units[u].unit.value),a=s(this.units[u].prefix.value),i=s(this.units[u].power),o=l(o,p(f(r,a),i));return o}return r=(s=O._getNumberConverter(Object(ie.M)(e)))(this.units[0].unit.value),a=s(this.units[0].prefix.value),n=s(this.units[0].unit.offset),c(l(l(e,r),null==t?a:t),n)},O.isValuelessUnit=function(e){return null!==C(e)},O.prototype.hasBase=function(e){if("string"==typeof e&&(e=B[e]),!e)return!1;for(var t=0;t<I.length;t++)if(1e-12<Math.abs((this.dimensions[t]||0)-(e.dimensions[t]||0)))return!1;return!0},O.prototype.equalBase=function(e){for(var t=0;t<I.length;t++)if(1e-12<Math.abs((this.dimensions[t]||0)-(e.dimensions[t]||0)))return!1;return!0},O.prototype.equals=function(e){return this.equalBase(e)&&v(this.value,e.value)},O.prototype.multiply=function(e){for(var t=this.clone(),r=0;r<I.length;r++)t.dimensions[r]=(this.dimensions[r]||0)+(e.dimensions[r]||0);for(var n,i,a=0;a<e.units.length;a++){var o=ea({},e.units[a]);t.units.push(o)}return null!==this.value||null!==e.value?(n=null===this.value?this._normalize(1):this.value,i=null===e.value?e._normalize(1):e.value,t.value=f(n,i)):t.value=null,t.skipAutomaticSimplification=!1,_(t)},O.prototype.divide=function(e){for(var t=this.clone(),r=0;r<I.length;r++)t.dimensions[r]=(this.dimensions[r]||0)-(e.dimensions[r]||0);for(var n,i,a=0;a<e.units.length;a++){var o=ea(ea({},e.units[a]),{},{power:-e.units[a].power});t.units.push(o)}return null!==this.value||null!==e.value?(n=null===this.value?this._normalize(1):this.value,i=null===e.value?e._normalize(1):e.value,t.value=l(n,i)):t.value=null,t.skipAutomaticSimplification=!1,_(t)},O.prototype.pow=function(e){for(var t=this.clone(),r=0;r<I.length;r++)t.dimensions[r]=(this.dimensions[r]||0)*e;for(var n=0;n<t.units.length;n++)t.units[n].power*=e;return null!==t.value?t.value=p(t.value,e):t.value=null,t.skipAutomaticSimplification=!1,_(t)},O.prototype.abs=function(){var e,t=this.clone();for(e in t.value=null!==t.value?m(t.value):null,t.units)"VA"!==t.units[e].unit.name&&"VAR"!==t.units[e].unit.name||(t.units[e].unit=z.W);return t},O.prototype.to=function(e){var t,r=null===this.value?this._normalize(1):this.value;if("string"==typeof e){if(t=O.parse(e),!this.equalBase(t))throw new Error("Units do not match ('".concat(t.toString(),"' != '").concat(this.toString(),"')"));if(null!==t.value)throw new Error("Cannot convert to a unit with a value");return t.value=Object(ae.a)(r),t.fixPrefix=!0,t.skipAutomaticSimplification=!0,t}if(Object(ie.L)(e)){if(!this.equalBase(e))throw new Error("Units do not match ('".concat(e.toString(),"' != '").concat(this.toString(),"')"));if(null!==e.value)throw new Error("Cannot convert to a unit with a value");return(t=e.clone()).value=Object(ae.a)(r),t.fixPrefix=!0,t.skipAutomaticSimplification=!0,t}throw new Error("String or Unit expected as parameter")},O.prototype.toNumber=function(e){return o(this.toNumeric(e))},O.prototype.toNumeric=function(e){e=e?this.to(e):this.clone();return e._isDerived()||0===e.units.length?e._denormalize(e.value):e._denormalize(e.value,e.units[0].prefix.value)},O.prototype.toString=function(){return this.format()},O.prototype.toJSON=function(){return{mathjs:"Unit",value:this._denormalize(this.value),unit:this.formatUnits(),fixPrefix:this.fixPrefix}},O.fromJSON=function(e){var t=new O(e.value,e.unit);return t.fixPrefix=e.fixPrefix||!1,t},O.prototype.valueOf=O.prototype.toString,O.prototype.simplify=function(){var e,t,r,n=this.clone(),i=[];for(t in H)if(Object(ae.f)(H,t)&&n.hasBase(B[t])){e=t;break}if("NONE"===e)n.units=[];else if(e&&Object(ae.f)(H,e)&&(r=H[e]),r)n.units=[{unit:r.unit,prefix:r.prefix,power:1}];else{for(var a=!1,o=0;o<I.length;o++){var s=I[o];1e-12<Math.abs(n.dimensions[o]||0)&&(Object(ae.f)(H,s)?i.push({unit:H[s].unit,prefix:H[s].prefix,power:n.dimensions[o]||0}):a=!0)}i.length<n.units.length&&!a&&(n.units=i)}return n},O.prototype.toSI=function(){for(var e=this.clone(),t=[],r=0;r<I.length;r++){var n=I[r];if(1e-12<Math.abs(e.dimensions[r]||0)){if(!Object(ae.f)(U.si,n))throw new Error("Cannot express custom unit "+n+" in SI units");t.push({unit:U.si[n].unit,prefix:U.si[n].prefix,power:e.dimensions[r]||0})}}return e.units=t,e.fixPrefix=!0,e.skipAutomaticSimplification=!0,e},O.prototype.formatUnits=function(){for(var e="",t="",r=0,n=0,i=0;i<this.units.length;i++)0<this.units[i].power?(r++,e+=" "+this.units[i].prefix.name+this.units[i].unit.name,1e-15<Math.abs(this.units[i].power-1)&&(e+="^"+this.units[i].power)):this.units[i].power<0&&n++;if(0<n)for(var a=0;a<this.units.length;a++)this.units[a].power<0&&(0<r?(t+=" "+this.units[a].prefix.name+this.units[a].unit.name,1e-15<Math.abs(this.units[a].power+1)&&(t+="^"+-this.units[a].power)):(t+=" "+this.units[a].prefix.name+this.units[a].unit.name,t+="^"+this.units[a].power));e=e.substr(1),t=t.substr(1),1<r&&0<n&&(e="("+e+")"),1<n&&0<r&&(t="("+t+")");var o=e;return 0<r&&0<n&&(o+=" / "),o+=t},O.prototype.format=function(e){var t,r=this.skipAutomaticSimplification||null===this.value?this.clone():this.simplify(),n=!1;for(t in void 0!==r.value&&null!==r.value&&Object(ie.j)(r.value)&&(n=Math.abs(r.value.re)<1e-14),r.units)Object(ae.f)(r.units,t)&&r.units[t].unit&&("VA"===r.units[t].unit.name&&n?r.units[t].unit=z.VAR:"VAR"!==r.units[t].unit.name||n||(r.units[t].unit=z.VA));1!==r.units.length||r.fixPrefix||Math.abs(r.units[0].power-Math.round(r.units[0].power))<1e-14&&(r.units[0].prefix=r._bestPrefix());var i=r._denormalize(r.value),i=null!==r.value?a(i,e||{}):"",e=r.formatUnits();return r.value&&Object(ie.j)(r.value)&&(i="("+i+")"),0<e.length&&0<i.length&&(i+=" "),i+=e},O.prototype._bestPrefix=function(){if(1!==this.units.length)throw new Error("Can only compute the best prefix for single units with integer powers, like kg, s^2, N^-1, and so forth!");if(1e-14<=Math.abs(this.units[0].power-Math.round(this.units[0].power)))throw new Error("Can only compute the best prefix for single units with integer powers, like kg, s^2, N^-1, and so forth!");var e=null!==this.value?m(this.value):0,t=m(this.units[0].unit.value),r=this.units[0].prefix;if(0===e)return r;var n=this.units[0].power,i=Math.log(e/Math.pow(r.value*t,n))/Math.LN10-1.2;if(-2.200001<i&&i<1.800001)return r;i=Math.abs(i);var a,o,s,u=this.units[0].unit.prefixes;for(a in u)Object(ae.f)(u,a)&&(!(o=u[a]).scientific||((s=Math.abs(Math.log(e/Math.pow(o.value*t,n))/Math.LN10-1.2))<i||s===i&&o.name.length<r.name.length)&&(r=o,i=s));return r};var T={NONE:{"":{name:"",value:1,scientific:!0}},SHORT:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:10,scientific:!(O.prototype.splitUnit=function(e){for(var t=this.clone(),r=[],n=0;n<e.length&&(t=t.to(e[n]),n!==e.length-1);n++){var i=t.toNumeric(),a=b(i),a=new O(v(a,i)?a:h(t.toNumeric()),e[n].toString());r.push(a),t=c(t,a)}for(var o=0,s=0;s<r.length;s++)o=u(o,r[s].value);return v(o,this.value)&&(t.value=0),r.push(t),r})},h:{name:"h",value:100,scientific:!1},k:{name:"k",value:1e3,scientific:!0},M:{name:"M",value:1e6,scientific:!0},G:{name:"G",value:1e9,scientific:!0},T:{name:"T",value:1e12,scientific:!0},P:{name:"P",value:1e15,scientific:!0},E:{name:"E",value:1e18,scientific:!0},Z:{name:"Z",value:1e21,scientific:!0},Y:{name:"Y",value:1e24,scientific:!0},d:{name:"d",value:.1,scientific:!1},c:{name:"c",value:.01,scientific:!1},m:{name:"m",value:.001,scientific:!0},u:{name:"u",value:1e-6,scientific:!0},n:{name:"n",value:1e-9,scientific:!0},p:{name:"p",value:1e-12,scientific:!0},f:{name:"f",value:1e-15,scientific:!0},a:{name:"a",value:1e-18,scientific:!0},z:{name:"z",value:1e-21,scientific:!0},y:{name:"y",value:1e-24,scientific:!0}},LONG:{"":{name:"",value:1,scientific:!0},deca:{name:"deca",value:10,scientific:!1},hecto:{name:"hecto",value:100,scientific:!1},kilo:{name:"kilo",value:1e3,scientific:!0},mega:{name:"mega",value:1e6,scientific:!0},giga:{name:"giga",value:1e9,scientific:!0},tera:{name:"tera",value:1e12,scientific:!0},peta:{name:"peta",value:1e15,scientific:!0},exa:{name:"exa",value:1e18,scientific:!0},zetta:{name:"zetta",value:1e21,scientific:!0},yotta:{name:"yotta",value:1e24,scientific:!0},deci:{name:"deci",value:.1,scientific:!1},centi:{name:"centi",value:.01,scientific:!1},milli:{name:"milli",value:.001,scientific:!0},micro:{name:"micro",value:1e-6,scientific:!0},nano:{name:"nano",value:1e-9,scientific:!0},pico:{name:"pico",value:1e-12,scientific:!0},femto:{name:"femto",value:1e-15,scientific:!0},atto:{name:"atto",value:1e-18,scientific:!0},zepto:{name:"zepto",value:1e-21,scientific:!0},yocto:{name:"yocto",value:1e-24,scientific:!0}},SQUARED:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:100,scientific:!1},h:{name:"h",value:1e4,scientific:!1},k:{name:"k",value:1e6,scientific:!0},M:{name:"M",value:1e12,scientific:!0},G:{name:"G",value:1e18,scientific:!0},T:{name:"T",value:1e24,scientific:!0},P:{name:"P",value:1e30,scientific:!0},E:{name:"E",value:1e36,scientific:!0},Z:{name:"Z",value:1e42,scientific:!0},Y:{name:"Y",value:1e48,scientific:!0},d:{name:"d",value:.01,scientific:!1},c:{name:"c",value:1e-4,scientific:!1},m:{name:"m",value:1e-6,scientific:!0},u:{name:"u",value:1e-12,scientific:!0},n:{name:"n",value:1e-18,scientific:!0},p:{name:"p",value:1e-24,scientific:!0},f:{name:"f",value:1e-30,scientific:!0},a:{name:"a",value:1e-36,scientific:!0},z:{name:"z",value:1e-42,scientific:!0},y:{name:"y",value:1e-48,scientific:!0}},CUBIC:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:1e3,scientific:!1},h:{name:"h",value:1e6,scientific:!1},k:{name:"k",value:1e9,scientific:!0},M:{name:"M",value:1e18,scientific:!0},G:{name:"G",value:1e27,scientific:!0},T:{name:"T",value:1e36,scientific:!0},P:{name:"P",value:1e45,scientific:!0},E:{name:"E",value:1e54,scientific:!0},Z:{name:"Z",value:1e63,scientific:!0},Y:{name:"Y",value:1e72,scientific:!0},d:{name:"d",value:.001,scientific:!1},c:{name:"c",value:1e-6,scientific:!1},m:{name:"m",value:1e-9,scientific:!0},u:{name:"u",value:1e-18,scientific:!0},n:{name:"n",value:1e-27,scientific:!0},p:{name:"p",value:1e-36,scientific:!0},f:{name:"f",value:1e-45,scientific:!0},a:{name:"a",value:1e-54,scientific:!0},z:{name:"z",value:1e-63,scientific:!0},y:{name:"y",value:1e-72,scientific:!0}},BINARY_SHORT_SI:{"":{name:"",value:1,scientific:!0},k:{name:"k",value:1e3,scientific:!0},M:{name:"M",value:1e6,scientific:!0},G:{name:"G",value:1e9,scientific:!0},T:{name:"T",value:1e12,scientific:!0},P:{name:"P",value:1e15,scientific:!0},E:{name:"E",value:1e18,scientific:!0},Z:{name:"Z",value:1e21,scientific:!0},Y:{name:"Y",value:1e24,scientific:!0}},BINARY_SHORT_IEC:{"":{name:"",value:1,scientific:!0},Ki:{name:"Ki",value:1024,scientific:!0},Mi:{name:"Mi",value:Math.pow(1024,2),scientific:!0},Gi:{name:"Gi",value:Math.pow(1024,3),scientific:!0},Ti:{name:"Ti",value:Math.pow(1024,4),scientific:!0},Pi:{name:"Pi",value:Math.pow(1024,5),scientific:!0},Ei:{name:"Ei",value:Math.pow(1024,6),scientific:!0},Zi:{name:"Zi",value:Math.pow(1024,7),scientific:!0},Yi:{name:"Yi",value:Math.pow(1024,8),scientific:!0}},BINARY_LONG_SI:{"":{name:"",value:1,scientific:!0},kilo:{name:"kilo",value:1e3,scientific:!0},mega:{name:"mega",value:1e6,scientific:!0},giga:{name:"giga",value:1e9,scientific:!0},tera:{name:"tera",value:1e12,scientific:!0},peta:{name:"peta",value:1e15,scientific:!0},exa:{name:"exa",value:1e18,scientific:!0},zetta:{name:"zetta",value:1e21,scientific:!0},yotta:{name:"yotta",value:1e24,scientific:!0}},BINARY_LONG_IEC:{"":{name:"",value:1,scientific:!0},kibi:{name:"kibi",value:1024,scientific:!0},mebi:{name:"mebi",value:Math.pow(1024,2),scientific:!0},gibi:{name:"gibi",value:Math.pow(1024,3),scientific:!0},tebi:{name:"tebi",value:Math.pow(1024,4),scientific:!0},pebi:{name:"pebi",value:Math.pow(1024,5),scientific:!0},exi:{name:"exi",value:Math.pow(1024,6),scientific:!0},zebi:{name:"zebi",value:Math.pow(1024,7),scientific:!0},yobi:{name:"yobi",value:Math.pow(1024,8),scientific:!0}},BTU:{"":{name:"",value:1,scientific:!0},MM:{name:"MM",value:1e6,scientific:!0}}};T.SHORTLONG=Qi({},T.SHORT,T.LONG),T.BINARY_SHORT=Qi({},T.BINARY_SHORT_SI,T.BINARY_SHORT_IEC),T.BINARY_LONG=Qi({},T.BINARY_LONG_SI,T.BINARY_LONG_IEC);var q,I=["MASS","LENGTH","TIME","CURRENT","TEMPERATURE","LUMINOUS_INTENSITY","AMOUNT_OF_SUBSTANCE","ANGLE","BIT"],B={NONE:{dimensions:[0,0,0,0,0,0,0,0,0]},MASS:{dimensions:[1,0,0,0,0,0,0,0,0]},LENGTH:{dimensions:[0,1,0,0,0,0,0,0,0]},TIME:{dimensions:[0,0,1,0,0,0,0,0,0]},CURRENT:{dimensions:[0,0,0,1,0,0,0,0,0]},TEMPERATURE:{dimensions:[0,0,0,0,1,0,0,0,0]},LUMINOUS_INTENSITY:{dimensions:[0,0,0,0,0,1,0,0,0]},AMOUNT_OF_SUBSTANCE:{dimensions:[0,0,0,0,0,0,1,0,0]},FORCE:{dimensions:[1,1,-2,0,0,0,0,0,0]},SURFACE:{dimensions:[0,2,0,0,0,0,0,0,0]},VOLUME:{dimensions:[0,3,0,0,0,0,0,0,0]},ENERGY:{dimensions:[1,2,-2,0,0,0,0,0,0]},POWER:{dimensions:[1,2,-3,0,0,0,0,0,0]},PRESSURE:{dimensions:[1,-1,-2,0,0,0,0,0,0]},ELECTRIC_CHARGE:{dimensions:[0,0,1,1,0,0,0,0,0]},ELECTRIC_CAPACITANCE:{dimensions:[-1,-2,4,2,0,0,0,0,0]},ELECTRIC_POTENTIAL:{dimensions:[1,2,-3,-1,0,0,0,0,0]},ELECTRIC_RESISTANCE:{dimensions:[1,2,-3,-2,0,0,0,0,0]},ELECTRIC_INDUCTANCE:{dimensions:[1,2,-2,-2,0,0,0,0,0]},ELECTRIC_CONDUCTANCE:{dimensions:[-1,-2,3,2,0,0,0,0,0]},MAGNETIC_FLUX:{dimensions:[1,2,-2,-1,0,0,0,0,0]},MAGNETIC_FLUX_DENSITY:{dimensions:[1,0,-2,-1,0,0,0,0,0]},FREQUENCY:{dimensions:[0,0,-1,0,0,0,0,0,0]},ANGLE:{dimensions:[0,0,0,0,0,0,0,1,0]},BIT:{dimensions:[0,0,0,0,0,0,0,0,1]}};for(q in B)Object(ae.f)(B,q)&&(B[q].key=q);var k={name:"",base:{},value:1,offset:0,dimensions:I.map(function(e){return 0})},z={meter:{name:"meter",base:B.LENGTH,prefixes:T.LONG,value:1,offset:0},inch:{name:"inch",base:B.LENGTH,prefixes:T.NONE,value:.0254,offset:0},foot:{name:"foot",base:B.LENGTH,prefixes:T.NONE,value:.3048,offset:0},yard:{name:"yard",base:B.LENGTH,prefixes:T.NONE,value:.9144,offset:0},mile:{name:"mile",base:B.LENGTH,prefixes:T.NONE,value:1609.344,offset:0},link:{name:"link",base:B.LENGTH,prefixes:T.NONE,value:.201168,offset:0},rod:{name:"rod",base:B.LENGTH,prefixes:T.NONE,value:5.0292,offset:0},chain:{name:"chain",base:B.LENGTH,prefixes:T.NONE,value:20.1168,offset:0},angstrom:{name:"angstrom",base:B.LENGTH,prefixes:T.NONE,value:1e-10,offset:0},m:{name:"m",base:B.LENGTH,prefixes:T.SHORT,value:1,offset:0},in:{name:"in",base:B.LENGTH,prefixes:T.NONE,value:.0254,offset:0},ft:{name:"ft",base:B.LENGTH,prefixes:T.NONE,value:.3048,offset:0},yd:{name:"yd",base:B.LENGTH,prefixes:T.NONE,value:.9144,offset:0},mi:{name:"mi",base:B.LENGTH,prefixes:T.NONE,value:1609.344,offset:0},li:{name:"li",base:B.LENGTH,prefixes:T.NONE,value:.201168,offset:0},rd:{name:"rd",base:B.LENGTH,prefixes:T.NONE,value:5.02921,offset:0},ch:{name:"ch",base:B.LENGTH,prefixes:T.NONE,value:20.1168,offset:0},mil:{name:"mil",base:B.LENGTH,prefixes:T.NONE,value:254e-7,offset:0},m2:{name:"m2",base:B.SURFACE,prefixes:T.SQUARED,value:1,offset:0},sqin:{name:"sqin",base:B.SURFACE,prefixes:T.NONE,value:64516e-8,offset:0},sqft:{name:"sqft",base:B.SURFACE,prefixes:T.NONE,value:.09290304,offset:0},sqyd:{name:"sqyd",base:B.SURFACE,prefixes:T.NONE,value:.83612736,offset:0},sqmi:{name:"sqmi",base:B.SURFACE,prefixes:T.NONE,value:2589988.110336,offset:0},sqrd:{name:"sqrd",base:B.SURFACE,prefixes:T.NONE,value:25.29295,offset:0},sqch:{name:"sqch",base:B.SURFACE,prefixes:T.NONE,value:404.6873,offset:0},sqmil:{name:"sqmil",base:B.SURFACE,prefixes:T.NONE,value:6.4516e-10,offset:0},acre:{name:"acre",base:B.SURFACE,prefixes:T.NONE,value:4046.86,offset:0},hectare:{name:"hectare",base:B.SURFACE,prefixes:T.NONE,value:1e4,offset:0},m3:{name:"m3",base:B.VOLUME,prefixes:T.CUBIC,value:1,offset:0},L:{name:"L",base:B.VOLUME,prefixes:T.SHORT,value:.001,offset:0},l:{name:"l",base:B.VOLUME,prefixes:T.SHORT,value:.001,offset:0},litre:{name:"litre",base:B.VOLUME,prefixes:T.LONG,value:.001,offset:0},cuin:{name:"cuin",base:B.VOLUME,prefixes:T.NONE,value:16387064e-12,offset:0},cuft:{name:"cuft",base:B.VOLUME,prefixes:T.NONE,value:.028316846592,offset:0},cuyd:{name:"cuyd",base:B.VOLUME,prefixes:T.NONE,value:.764554857984,offset:0},teaspoon:{name:"teaspoon",base:B.VOLUME,prefixes:T.NONE,value:5e-6,offset:0},tablespoon:{name:"tablespoon",base:B.VOLUME,prefixes:T.NONE,value:15e-6,offset:0},drop:{name:"drop",base:B.VOLUME,prefixes:T.NONE,value:5e-8,offset:0},gtt:{name:"gtt",base:B.VOLUME,prefixes:T.NONE,value:5e-8,offset:0},minim:{name:"minim",base:B.VOLUME,prefixes:T.NONE,value:6.161152e-8,offset:0},fluiddram:{name:"fluiddram",base:B.VOLUME,prefixes:T.NONE,value:36966911e-13,offset:0},fluidounce:{name:"fluidounce",base:B.VOLUME,prefixes:T.NONE,value:2957353e-11,offset:0},gill:{name:"gill",base:B.VOLUME,prefixes:T.NONE,value:.0001182941,offset:0},cc:{name:"cc",base:B.VOLUME,prefixes:T.NONE,value:1e-6,offset:0},cup:{name:"cup",base:B.VOLUME,prefixes:T.NONE,value:.0002365882,offset:0},pint:{name:"pint",base:B.VOLUME,prefixes:T.NONE,value:.0004731765,offset:0},quart:{name:"quart",base:B.VOLUME,prefixes:T.NONE,value:.0009463529,offset:0},gallon:{name:"gallon",base:B.VOLUME,prefixes:T.NONE,value:.003785412,offset:0},beerbarrel:{name:"beerbarrel",base:B.VOLUME,prefixes:T.NONE,value:.1173478,offset:0},oilbarrel:{name:"oilbarrel",base:B.VOLUME,prefixes:T.NONE,value:.1589873,offset:0},hogshead:{name:"hogshead",base:B.VOLUME,prefixes:T.NONE,value:.238481,offset:0},fldr:{name:"fldr",base:B.VOLUME,prefixes:T.NONE,value:36966911e-13,offset:0},floz:{name:"floz",base:B.VOLUME,prefixes:T.NONE,value:2957353e-11,offset:0},gi:{name:"gi",base:B.VOLUME,prefixes:T.NONE,value:.0001182941,offset:0},cp:{name:"cp",base:B.VOLUME,prefixes:T.NONE,value:.0002365882,offset:0},pt:{name:"pt",base:B.VOLUME,prefixes:T.NONE,value:.0004731765,offset:0},qt:{name:"qt",base:B.VOLUME,prefixes:T.NONE,value:.0009463529,offset:0},gal:{name:"gal",base:B.VOLUME,prefixes:T.NONE,value:.003785412,offset:0},bbl:{name:"bbl",base:B.VOLUME,prefixes:T.NONE,value:.1173478,offset:0},obl:{name:"obl",base:B.VOLUME,prefixes:T.NONE,value:.1589873,offset:0},g:{name:"g",base:B.MASS,prefixes:T.SHORT,value:.001,offset:0},gram:{name:"gram",base:B.MASS,prefixes:T.LONG,value:.001,offset:0},ton:{name:"ton",base:B.MASS,prefixes:T.SHORT,value:907.18474,offset:0},t:{name:"t",base:B.MASS,prefixes:T.SHORT,value:1e3,offset:0},tonne:{name:"tonne",base:B.MASS,prefixes:T.LONG,value:1e3,offset:0},grain:{name:"grain",base:B.MASS,prefixes:T.NONE,value:6479891e-11,offset:0},dram:{name:"dram",base:B.MASS,prefixes:T.NONE,value:.0017718451953125,offset:0},ounce:{name:"ounce",base:B.MASS,prefixes:T.NONE,value:.028349523125,offset:0},poundmass:{name:"poundmass",base:B.MASS,prefixes:T.NONE,value:.45359237,offset:0},hundredweight:{name:"hundredweight",base:B.MASS,prefixes:T.NONE,value:45.359237,offset:0},stick:{name:"stick",base:B.MASS,prefixes:T.NONE,value:.115,offset:0},stone:{name:"stone",base:B.MASS,prefixes:T.NONE,value:6.35029318,offset:0},gr:{name:"gr",base:B.MASS,prefixes:T.NONE,value:6479891e-11,offset:0},dr:{name:"dr",base:B.MASS,prefixes:T.NONE,value:.0017718451953125,offset:0},oz:{name:"oz",base:B.MASS,prefixes:T.NONE,value:.028349523125,offset:0},lbm:{name:"lbm",base:B.MASS,prefixes:T.NONE,value:.45359237,offset:0},cwt:{name:"cwt",base:B.MASS,prefixes:T.NONE,value:45.359237,offset:0},s:{name:"s",base:B.TIME,prefixes:T.SHORT,value:1,offset:0},min:{name:"min",base:B.TIME,prefixes:T.NONE,value:60,offset:0},h:{name:"h",base:B.TIME,prefixes:T.NONE,value:3600,offset:0},second:{name:"second",base:B.TIME,prefixes:T.LONG,value:1,offset:0},sec:{name:"sec",base:B.TIME,prefixes:T.LONG,value:1,offset:0},minute:{name:"minute",base:B.TIME,prefixes:T.NONE,value:60,offset:0},hour:{name:"hour",base:B.TIME,prefixes:T.NONE,value:3600,offset:0},day:{name:"day",base:B.TIME,prefixes:T.NONE,value:86400,offset:0},week:{name:"week",base:B.TIME,prefixes:T.NONE,value:604800,offset:0},month:{name:"month",base:B.TIME,prefixes:T.NONE,value:2629800,offset:0},year:{name:"year",base:B.TIME,prefixes:T.NONE,value:31557600,offset:0},decade:{name:"decade",base:B.TIME,prefixes:T.NONE,value:315576e3,offset:0},century:{name:"century",base:B.TIME,prefixes:T.NONE,value:315576e4,offset:0},millennium:{name:"millennium",base:B.TIME,prefixes:T.NONE,value:315576e5,offset:0},hertz:{name:"Hertz",base:B.FREQUENCY,prefixes:T.LONG,value:1,offset:0,reciprocal:!0},Hz:{name:"Hz",base:B.FREQUENCY,prefixes:T.SHORT,value:1,offset:0,reciprocal:!0},rad:{name:"rad",base:B.ANGLE,prefixes:T.SHORT,value:1,offset:0},radian:{name:"radian",base:B.ANGLE,prefixes:T.LONG,value:1,offset:0},deg:{name:"deg",base:B.ANGLE,prefixes:T.SHORT,value:null,offset:0},degree:{name:"degree",base:B.ANGLE,prefixes:T.LONG,value:null,offset:0},grad:{name:"grad",base:B.ANGLE,prefixes:T.SHORT,value:null,offset:0},gradian:{name:"gradian",base:B.ANGLE,prefixes:T.LONG,value:null,offset:0},cycle:{name:"cycle",base:B.ANGLE,prefixes:T.NONE,value:null,offset:0},arcsec:{name:"arcsec",base:B.ANGLE,prefixes:T.NONE,value:null,offset:0},arcmin:{name:"arcmin",base:B.ANGLE,prefixes:T.NONE,value:null,offset:0},A:{name:"A",base:B.CURRENT,prefixes:T.SHORT,value:1,offset:0},ampere:{name:"ampere",base:B.CURRENT,prefixes:T.LONG,value:1,offset:0},K:{name:"K",base:B.TEMPERATURE,prefixes:T.NONE,value:1,offset:0},degC:{name:"degC",base:B.TEMPERATURE,prefixes:T.NONE,value:1,offset:273.15},degF:{name:"degF",base:B.TEMPERATURE,prefixes:T.NONE,value:1/1.8,offset:459.67},degR:{name:"degR",base:B.TEMPERATURE,prefixes:T.NONE,value:1/1.8,offset:0},kelvin:{name:"kelvin",base:B.TEMPERATURE,prefixes:T.NONE,value:1,offset:0},celsius:{name:"celsius",base:B.TEMPERATURE,prefixes:T.NONE,value:1,offset:273.15},fahrenheit:{name:"fahrenheit",base:B.TEMPERATURE,prefixes:T.NONE,value:1/1.8,offset:459.67},rankine:{name:"rankine",base:B.TEMPERATURE,prefixes:T.NONE,value:1/1.8,offset:0},mol:{name:"mol",base:B.AMOUNT_OF_SUBSTANCE,prefixes:T.SHORT,value:1,offset:0},mole:{name:"mole",base:B.AMOUNT_OF_SUBSTANCE,prefixes:T.LONG,value:1,offset:0},cd:{name:"cd",base:B.LUMINOUS_INTENSITY,prefixes:T.SHORT,value:1,offset:0},candela:{name:"candela",base:B.LUMINOUS_INTENSITY,prefixes:T.LONG,value:1,offset:0},N:{name:"N",base:B.FORCE,prefixes:T.SHORT,value:1,offset:0},newton:{name:"newton",base:B.FORCE,prefixes:T.LONG,value:1,offset:0},dyn:{name:"dyn",base:B.FORCE,prefixes:T.SHORT,value:1e-5,offset:0},dyne:{name:"dyne",base:B.FORCE,prefixes:T.LONG,value:1e-5,offset:0},lbf:{name:"lbf",base:B.FORCE,prefixes:T.NONE,value:4.4482216152605,offset:0},poundforce:{name:"poundforce",base:B.FORCE,prefixes:T.NONE,value:4.4482216152605,offset:0},kip:{name:"kip",base:B.FORCE,prefixes:T.LONG,value:4448.2216,offset:0},J:{name:"J",base:B.ENERGY,prefixes:T.SHORT,value:1,offset:0},joule:{name:"joule",base:B.ENERGY,prefixes:T.SHORT,value:1,offset:0},erg:{name:"erg",base:B.ENERGY,prefixes:T.NONE,value:1e-7,offset:0},Wh:{name:"Wh",base:B.ENERGY,prefixes:T.SHORT,value:3600,offset:0},BTU:{name:"BTU",base:B.ENERGY,prefixes:T.BTU,value:1055.05585262,offset:0},eV:{name:"eV",base:B.ENERGY,prefixes:T.SHORT,value:1602176565e-28,offset:0},electronvolt:{name:"electronvolt",base:B.ENERGY,prefixes:T.LONG,value:1602176565e-28,offset:0},W:{name:"W",base:B.POWER,prefixes:T.SHORT,value:1,offset:0},watt:{name:"watt",base:B.POWER,prefixes:T.LONG,value:1,offset:0},hp:{name:"hp",base:B.POWER,prefixes:T.NONE,value:745.6998715386,offset:0},VAR:{name:"VAR",base:B.POWER,prefixes:T.SHORT,value:i.I,offset:0},VA:{name:"VA",base:B.POWER,prefixes:T.SHORT,value:1,offset:0},Pa:{name:"Pa",base:B.PRESSURE,prefixes:T.SHORT,value:1,offset:0},psi:{name:"psi",base:B.PRESSURE,prefixes:T.NONE,value:6894.75729276459,offset:0},atm:{name:"atm",base:B.PRESSURE,prefixes:T.NONE,value:101325,offset:0},bar:{name:"bar",base:B.PRESSURE,prefixes:T.SHORTLONG,value:1e5,offset:0},torr:{name:"torr",base:B.PRESSURE,prefixes:T.NONE,value:133.322,offset:0},mmHg:{name:"mmHg",base:B.PRESSURE,prefixes:T.NONE,value:133.322,offset:0},mmH2O:{name:"mmH2O",base:B.PRESSURE,prefixes:T.NONE,value:9.80665,offset:0},cmH2O:{name:"cmH2O",base:B.PRESSURE,prefixes:T.NONE,value:98.0665,offset:0},coulomb:{name:"coulomb",base:B.ELECTRIC_CHARGE,prefixes:T.LONG,value:1,offset:0},C:{name:"C",base:B.ELECTRIC_CHARGE,prefixes:T.SHORT,value:1,offset:0},farad:{name:"farad",base:B.ELECTRIC_CAPACITANCE,prefixes:T.LONG,value:1,offset:0},F:{name:"F",base:B.ELECTRIC_CAPACITANCE,prefixes:T.SHORT,value:1,offset:0},volt:{name:"volt",base:B.ELECTRIC_POTENTIAL,prefixes:T.LONG,value:1,offset:0},V:{name:"V",base:B.ELECTRIC_POTENTIAL,prefixes:T.SHORT,value:1,offset:0},ohm:{name:"ohm",base:B.ELECTRIC_RESISTANCE,prefixes:T.SHORTLONG,value:1,offset:0},henry:{name:"henry",base:B.ELECTRIC_INDUCTANCE,prefixes:T.LONG,value:1,offset:0},H:{name:"H",base:B.ELECTRIC_INDUCTANCE,prefixes:T.SHORT,value:1,offset:0},siemens:{name:"siemens",base:B.ELECTRIC_CONDUCTANCE,prefixes:T.LONG,value:1,offset:0},S:{name:"S",base:B.ELECTRIC_CONDUCTANCE,prefixes:T.SHORT,value:1,offset:0},weber:{name:"weber",base:B.MAGNETIC_FLUX,prefixes:T.LONG,value:1,offset:0},Wb:{name:"Wb",base:B.MAGNETIC_FLUX,prefixes:T.SHORT,value:1,offset:0},tesla:{name:"tesla",base:B.MAGNETIC_FLUX_DENSITY,prefixes:T.LONG,value:1,offset:0},T:{name:"T",base:B.MAGNETIC_FLUX_DENSITY,prefixes:T.SHORT,value:1,offset:0},b:{name:"b",base:B.BIT,prefixes:T.BINARY_SHORT,value:1,offset:0},bits:{name:"bits",base:B.BIT,prefixes:T.BINARY_LONG,value:1,offset:0},B:{name:"B",base:B.BIT,prefixes:T.BINARY_SHORT,value:8,offset:0},bytes:{name:"bytes",base:B.BIT,prefixes:T.BINARY_LONG,value:8,offset:0}},D={meters:"meter",inches:"inch",feet:"foot",yards:"yard",miles:"mile",links:"link",rods:"rod",chains:"chain",angstroms:"angstrom",lt:"l",litres:"litre",liter:"litre",liters:"litre",teaspoons:"teaspoon",tablespoons:"tablespoon",minims:"minim",fluiddrams:"fluiddram",fluidounces:"fluidounce",gills:"gill",cups:"cup",pints:"pint",quarts:"quart",gallons:"gallon",beerbarrels:"beerbarrel",oilbarrels:"oilbarrel",hogsheads:"hogshead",gtts:"gtt",grams:"gram",tons:"ton",tonnes:"tonne",grains:"grain",drams:"dram",ounces:"ounce",poundmasses:"poundmass",hundredweights:"hundredweight",sticks:"stick",lb:"lbm",lbs:"lbm",kips:"kip",acres:"acre",hectares:"hectare",sqfeet:"sqft",sqyard:"sqyd",sqmile:"sqmi",sqmiles:"sqmi",mmhg:"mmHg",mmh2o:"mmH2O",cmh2o:"cmH2O",seconds:"second",secs:"second",minutes:"minute",mins:"minute",hours:"hour",hr:"hour",hrs:"hour",days:"day",weeks:"week",months:"month",years:"year",decades:"decade",centuries:"century",millennia:"millennium",hertz:"hertz",radians:"radian",degrees:"degree",gradians:"gradian",cycles:"cycle",arcsecond:"arcsec",arcseconds:"arcsec",arcminute:"arcmin",arcminutes:"arcmin",BTUs:"BTU",watts:"watt",joules:"joule",amperes:"ampere",coulombs:"coulomb",volts:"volt",ohms:"ohm",farads:"farad",webers:"weber",teslas:"tesla",electronvolts:"electronvolt",moles:"mole",bit:"bits",byte:"bytes"};function R(e){"BigNumber"===e.number?(e=Ji(x),z.rad.value=new x(1),z.deg.value=e.div(180),z.grad.value=e.div(200),z.cycle.value=e.times(2),z.arcsec.value=e.div(648e3),z.arcmin.value=e.div(10800)):(z.rad.value=1,z.deg.value=Math.PI/180,z.grad.value=Math.PI/200,z.cycle.value=2*Math.PI,z.arcsec.value=Math.PI/648e3,z.arcmin.value=Math.PI/10800),z.radian.value=z.rad.value,z.degree.value=z.deg.value,z.gradian.value=z.grad.value}R(g),t&&t("config",function(e,t){e.number!==t.number&&R(e)});var U={si:{NONE:{unit:k,prefix:T.NONE[""]},LENGTH:{unit:z.m,prefix:T.SHORT[""]},MASS:{unit:z.g,prefix:T.SHORT.k},TIME:{unit:z.s,prefix:T.SHORT[""]},CURRENT:{unit:z.A,prefix:T.SHORT[""]},TEMPERATURE:{unit:z.K,prefix:T.SHORT[""]},LUMINOUS_INTENSITY:{unit:z.cd,prefix:T.SHORT[""]},AMOUNT_OF_SUBSTANCE:{unit:z.mol,prefix:T.SHORT[""]},ANGLE:{unit:z.rad,prefix:T.SHORT[""]},BIT:{unit:z.bits,prefix:T.SHORT[""]},FORCE:{unit:z.N,prefix:T.SHORT[""]},ENERGY:{unit:z.J,prefix:T.SHORT[""]},POWER:{unit:z.W,prefix:T.SHORT[""]},PRESSURE:{unit:z.Pa,prefix:T.SHORT[""]},ELECTRIC_CHARGE:{unit:z.C,prefix:T.SHORT[""]},ELECTRIC_CAPACITANCE:{unit:z.F,prefix:T.SHORT[""]},ELECTRIC_POTENTIAL:{unit:z.V,prefix:T.SHORT[""]},ELECTRIC_RESISTANCE:{unit:z.ohm,prefix:T.SHORT[""]},ELECTRIC_INDUCTANCE:{unit:z.H,prefix:T.SHORT[""]},ELECTRIC_CONDUCTANCE:{unit:z.S,prefix:T.SHORT[""]},MAGNETIC_FLUX:{unit:z.Wb,prefix:T.SHORT[""]},MAGNETIC_FLUX_DENSITY:{unit:z.T,prefix:T.SHORT[""]},FREQUENCY:{unit:z.Hz,prefix:T.SHORT[""]}}};U.cgs=JSON.parse(JSON.stringify(U.si)),U.cgs.LENGTH={unit:z.m,prefix:T.SHORT.c},U.cgs.MASS={unit:z.g,prefix:T.SHORT[""]},U.cgs.FORCE={unit:z.dyn,prefix:T.SHORT[""]},U.cgs.ENERGY={unit:z.erg,prefix:T.NONE[""]},U.us=JSON.parse(JSON.stringify(U.si)),U.us.LENGTH={unit:z.ft,prefix:T.NONE[""]},U.us.MASS={unit:z.lbm,prefix:T.NONE[""]},U.us.TEMPERATURE={unit:z.degF,prefix:T.NONE[""]},U.us.FORCE={unit:z.lbf,prefix:T.NONE[""]},U.us.ENERGY={unit:z.BTU,prefix:T.BTU[""]},U.us.POWER={unit:z.hp,prefix:T.NONE[""]},U.us.PRESSURE={unit:z.psi,prefix:T.NONE[""]},U.auto=JSON.parse(JSON.stringify(U.si));var P,F,L,H=U.auto;for(P in O.setUnitSystem=function(e){if(!Object(ae.f)(U,e))throw new Error("Unit system "+e+" does not exist. Choices are: "+Object.keys(U).join(", "));H=U[e]},O.getUnitSystem=function(){for(var e in U)if(Object(ae.f)(U,e)&&U[e]===H)return e},O.typeConverters={BigNumber:function(e){return new x(e+"")},Fraction:function(e){return new w(e)},Complex:function(e){return e},number:function(e){return e}},O._getNumberConverter=function(e){if(!O.typeConverters[e])throw new TypeError('Unsupported type "'+e+'"');return O.typeConverters[e]},z)Object(ae.f)(z,P)&&((F=z[P]).dimensions=F.base.dimensions);for(L in D)if(Object(ae.f)(D,L)){var $,G=z[D[L]],V={};for($ in G)Object(ae.f)(G,$)&&(V[$]=G[$]);V.name=L,z[L]=V}return O.isValidAlpha=function(e){return/^[a-zA-Z]$/.test(e)},O.createUnit=function(e,t){if("object"!==Xi(e))throw new TypeError("createUnit expects first parameter to be of type 'Object'");if(t&&t.override)for(var r in e)if(Object(ae.f)(e,r)&&O.deleteUnit(r),e[r].aliases)for(var n=0;n<e[r].aliases.length;n++)O.deleteUnit(e[r].aliases[n]);var i,a;for(a in e)Object(ae.f)(e,a)&&(i=O.createUnitSingle(a,e[a]));return i},O.createUnitSingle=function(t,e,r){if(null==e&&(e={}),"string"!=typeof t)throw new TypeError("createUnitSingle expects first parameter to be of type 'string'");if(Object(ae.f)(z,t))throw new Error('Cannot create unit "'+t+'": a unit with that name already exists');!function(e){for(var t=0;t<e.length;t++){if(N=e.charAt(t),0===t&&!O.isValidAlpha(N))throw new Error('Invalid unit name (must begin with alpha character): "'+e+'"');if(0<t&&!O.isValidAlpha(N)&&!j(N))throw new Error('Invalid unit name (only alphanumeric characters are allowed): "'+e+'"')}}(t);var n,i,a,o=null,s=[],u=0;if(e&&"Unit"===e.type)o=e.clone();else if("string"==typeof e)""!==e&&(n=e);else{if("object"!==Xi(e))throw new TypeError('Cannot create unit "'+t+'" from "'+e.toString()+'": expecting "string" or "Unit" or "Object"');n=e.definition,i=e.prefixes,u=e.offset,a=e.baseName,e.aliases&&(s=e.aliases.valueOf())}if(s)for(var c=0;c<s.length;c++)if(Object(ae.f)(z,s[c]))throw new Error('Cannot create alias "'+s[c]+'": a unit with that name already exists');if(n&&"string"==typeof n&&!o)try{o=O.parse(n,{allowNoUnits:!0})}catch(e){throw e.message='Could not create unit "'+t+'" from "'+n+'": '+e.message,e}else n&&"Unit"===n.type&&(o=n.clone());s=s||[],u=u||0,i=i&&i.toUpperCase&&T[i.toUpperCase()]||T.NONE;var f={};if(o){var l,p=!(f={name:t,value:o.value,dimensions:o.dimensions.slice(0),prefixes:i,offset:u});for(l in B)if(Object(ae.f)(B,l)){for(var m=!0,h=0;h<I.length;h++)if(1e-12<Math.abs((f.dimensions[h]||0)-(B[l].dimensions[h]||0))){m=!1;break}if(m){p=!0,f.base=B[l];break}}p||(a=a||t+"_STUFF",(e={dimensions:o.dimensions.slice(0)}).key=a,B[a]=e,H[a]={unit:f,prefix:T.NONE[""]},f.base=B[a])}else{if(a=a||t+"_STUFF",0<=I.indexOf(a))throw new Error('Cannot create new base unit "'+t+'": a base unit with that name already exists (and cannot be overridden)');for(var d in I.push(a),B)Object(ae.f)(B,d)&&(B[d].dimensions[I.length-1]=0);for(var y={dimensions:[]},g=0;g<I.length;g++)y.dimensions[g]=0;y.dimensions[I.length-1]=1,y.key=a,B[a]=y,f={name:t,value:1,dimensions:B[a].dimensions.slice(0),prefixes:i,offset:u,base:B[a]},H[a]={unit:f,prefix:T.NONE[""]}}O.UNITS[t]=f;for(var b=0;b<s.length;b++){var v,x=s[b],w={};for(v in f)Object(ae.f)(f,v)&&(w[v]=f[v]);w.name=x,O.UNITS[x]=w}return new O(null,t)},O.deleteUnit=function(e){delete O.UNITS[e]},O.PREFIXES=T,O.BASE_DIMENSIONS=I,O.BASE_UNITS=B,O.UNIT_SYSTEMS=U,O.UNITS=z,O},{isClass:!0}),n=["typed","Unit"],ra=Object(a.a)("unit",n,function(e){var t=e.typed,r=e.Unit;return t("unit",{Unit:function(e){return e.clone()},string:function(e){return r.isValuelessUnit(e)?new r(null,e):r.parse(e,{allowNoUnits:!0})},"number | BigNumber | Fraction | Complex, string":function(e,t){return new r(e,t)},"Array | Matrix":function(e){return oe(e,this)}})}),t=["typed","SparseMatrix"],na=Object(a.a)("sparse",t,function(e){var t=e.typed,r=e.SparseMatrix;return t("sparse",{"":function(){return new r([])},string:function(e){return new r([],e)},"Array | Matrix":function(e){return new r(e)},"Array | Matrix, string":function(e,t){return new r(e,t)}})}),ia="createUnit",n=["typed","Unit"],aa=Object(a.a)(ia,n,function(e){var t=e.typed,i=e.Unit;return t(ia,{"Object, Object":function(e,t){return i.createUnit(e,t)},Object:function(e){return i.createUnit(e,{})},"string, Unit | string | Object, Object":function(e,t,r){var n={};return n[e]=t,i.createUnit(n,r)},"string, Unit | string | Object":function(e,t){var r={};return r[e]=t,i.createUnit(r,{})},string:function(e){var t={};return t[e]={},i.createUnit(t,{})}})}),t=["typed","config","Complex"],oa=Object(a.a)("acos",t,function(e){var t=e.typed,r=e.config,n=e.Complex;return t("acos",{number:function(e){return-1<=e&&e<=1||r.predictable?Math.acos(e):new n(e,0).acos()},Complex:function(e){return e.acos()},BigNumber:function(e){return e.acos()},"Array | Matrix":function(e){return oe(e,this)}})}),n="number";function sa(e){return Object(N.a)(e)}function ua(e){return Math.atan(1/e)}function ca(e){return isFinite(e)?(Math.log((e+1)/e)+Math.log(e/(e-1)))/2:0}function fa(e){return Math.asin(1/e)}function la(e){e=1/e;return Math.log(e+Math.sqrt(e*e+1))}function pa(e){return Math.acos(1/e)}function ma(e){var t=1/e,e=Math.sqrt(t*t-1);return Math.log(e+t)}function ha(e){return Object(N.b)(e)}function da(e){return Object(N.c)(e)}function ya(e){return 1/Math.tan(e)}function ga(e){e=Math.exp(2*e);return(e+1)/(e-1)}function ba(e){return 1/Math.sin(e)}function va(e){return 0===e?Number.POSITIVE_INFINITY:Math.abs(2/(Math.exp(e)-Math.exp(-e)))*Object(N.n)(e)}function xa(e){return 1/Math.cos(e)}function wa(e){return 2/(Math.exp(e)+Math.exp(-e))}function Na(e){return Object(N.o)(e)}Na.signature=wa.signature=xa.signature=va.signature=ba.signature=ga.signature=ya.signature=da.signature=ha.signature=ma.signature=pa.signature=la.signature=fa.signature=ca.signature=ua.signature=sa.signature=n;var t=["typed","config","Complex"],Oa=Object(a.a)("acosh",t,function(e){var t=e.typed,r=e.config,n=e.Complex;return t("acosh",{number:function(e){return 1<=e||r.predictable?sa(e):e<=-1?new n(Math.log(Math.sqrt(e*e-1)-e),Math.PI):new n(e,0).acosh()},Complex:function(e){return e.acosh()},BigNumber:function(e){return e.acosh()},"Array | Matrix":function(e){return oe(e,this)}})}),n=["typed","BigNumber"],Ma=Object(a.a)("acot",n,function(e){var t=e.typed,r=e.BigNumber;return t("acot",{number:ua,Complex:function(e){return e.acot()},BigNumber:function(e){return new r(1).div(e).atan()},"Array | Matrix":function(e){return oe(e,this)}})}),t=["typed","config","Complex","BigNumber"],ja=Object(a.a)("acoth",t,function(e){var t=e.typed,r=e.config,n=e.Complex,i=e.BigNumber;return t("acoth",{number:function(e){return 1<=e||e<=-1||r.predictable?ca(e):new n(e,0).acoth()},Complex:function(e){return e.acoth()},BigNumber:function(e){return new i(1).div(e).atanh()},"Array | Matrix":function(e){return oe(e,this)}})}),n=["typed","config","Complex","BigNumber"],Ea=Object(a.a)("acsc",n,function(e){var t=e.typed,r=e.config,n=e.Complex,i=e.BigNumber;return t("acsc",{number:function(e){return e<=-1||1<=e||r.predictable?fa(e):new n(e,0).acsc()},Complex:function(e){return e.acsc()},BigNumber:function(e){return new i(1).div(e).asin()},"Array | Matrix":function(e){return oe(e,this)}})}),t=["typed","BigNumber"],Sa=Object(a.a)("acsch",t,function(e){var t=e.typed,r=e.BigNumber;return t("acsch",{number:la,Complex:function(e){return e.acsch()},BigNumber:function(e){return new r(1).div(e).asinh()},"Array | Matrix":function(e){return oe(e,this)}})}),n=["typed","config","Complex","BigNumber"],Aa=Object(a.a)("asec",n,function(e){var t=e.typed,r=e.config,n=e.Complex,i=e.BigNumber;return t("asec",{number:function(e){return e<=-1||1<=e||r.predictable?pa(e):new n(e,0).asec()},Complex:function(e){return e.asec()},BigNumber:function(e){return new i(1).div(e).acos()},"Array | Matrix":function(e){return oe(e,this)}})}),t=["typed","config","Complex","BigNumber"],Ca=Object(a.a)("asech",t,function(e){var t=e.typed,n=e.config,i=e.Complex,r=e.BigNumber;return t("asech",{number:function(e){if(e<=1&&-1<=e||n.predictable){var t=1/e;if(0<t||n.predictable)return ma(e);var r=Math.sqrt(t*t-1);return new i(Math.log(r-t),Math.PI)}return new i(e,0).asech()},Complex:function(e){return e.asech()},BigNumber:function(e){return new r(1).div(e).acosh()},"Array | Matrix":function(e){return oe(e,this)}})}),n=["typed","config","Complex"],_a=Object(a.a)("asin",n,function(e){var t=e.typed,r=e.config,n=e.Complex;return t("asin",{number:function(e){return-1<=e&&e<=1||r.predictable?Math.asin(e):new n(e,0).asin()},Complex:function(e){return e.asin()},BigNumber:function(e){return e.asin()},"Array | Matrix":function(e){return oe(e,this,!0)}})}),t=["typed"],Ta=Object(a.a)("asinh",t,function(e){return(0,e.typed)("asinh",{number:ha,Complex:function(e){return e.asinh()},BigNumber:function(e){return e.asinh()},"Array | Matrix":function(e){return oe(e,this,!0)}})}),n=["typed"],qa=Object(a.a)("atan",n,function(e){return(0,e.typed)("atan",{number:function(e){return Math.atan(e)},Complex:function(e){return e.atan()},BigNumber:function(e){return e.atan()},"Array | Matrix":function(e){return oe(e,this,!0)}})}),t=["typed","matrix","equalScalar","BigNumber","DenseMatrix"],Ia=Object(a.a)("atan2",t,function(e){var t=e.typed,r=e.matrix,n=e.equalScalar,i=e.BigNumber,e=e.DenseMatrix,a=ct({typed:t,equalScalar:n}),o=ht({typed:t}),s=_t({typed:t,equalScalar:n}),u=Ve({typed:t,equalScalar:n}),c=yt({typed:t,DenseMatrix:e}),f=st({typed:t}),l=Ze({typed:t});return t("atan2",{"number, number":Math.atan2,"BigNumber, BigNumber":function(e,t){return i.atan2(e,t)},"SparseMatrix, SparseMatrix":function(e,t){return s(e,t,this,!1)},"SparseMatrix, DenseMatrix":function(e,t){return a(t,e,this,!0)},"DenseMatrix, SparseMatrix":function(e,t){return o(e,t,this,!1)},"DenseMatrix, DenseMatrix":function(e,t){return f(e,t,this)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"SparseMatrix, number | BigNumber":function(e,t){return u(e,t,this,!1)},"DenseMatrix, number | BigNumber":function(e,t){return l(e,t,this,!1)},"number | BigNumber, SparseMatrix":function(e,t){return c(t,e,this,!0)},"number | BigNumber, DenseMatrix":function(e,t){return l(t,e,this,!0)},"Array, number | BigNumber":function(e,t){return l(r(e),t,this,!1).valueOf()},"number | BigNumber, Array":function(e,t){return l(r(t),e,this,!0).valueOf()}})}),n=["typed","config","Complex"],Ba=Object(a.a)("atanh",n,function(e){var t=e.typed,r=e.config,n=e.Complex;return t("atanh",{number:function(e){return e<=1&&-1<=e||r.predictable?da(e):new n(e,0).atanh()},Complex:function(e){return e.atanh()},BigNumber:function(e){return e.atanh()},"Array | Matrix":function(e){return oe(e,this,!0)}})}),t=["typed"],ka=Object(a.a)("cos",t,function(e){return(0,e.typed)("cos",{number:Math.cos,Complex:function(e){return e.cos()},BigNumber:function(e){return e.cos()},Unit:function(e){if(!e.hasBase(e.constructor.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cos is no angle");return this(e.value)},"Array | Matrix":function(e){return oe(e,this)}})}),n=["typed"],za=Object(a.a)("cosh",n,function(e){return(0,e.typed)("cosh",{number:N.e,Complex:function(e){return e.cosh()},BigNumber:function(e){return e.cosh()},Unit:function(e){if(!e.hasBase(e.constructor.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cosh is no angle");return this(e.value)},"Array | Matrix":function(e){return oe(e,this)}})}),t=["typed","BigNumber"],Da=Object(a.a)("cot",t,function(e){var t=e.typed,r=e.BigNumber;return t("cot",{number:ya,Complex:function(e){return e.cot()},BigNumber:function(e){return new r(1).div(e.tan())},Unit:function(e){if(!e.hasBase(e.constructor.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cot is no angle");return this(e.value)},"Array | Matrix":function(e){return oe(e,this)}})}),n=["typed","BigNumber"],Ra=Object(a.a)("coth",n,function(e){var t=e.typed,r=e.BigNumber;return t("coth",{number:ga,Complex:function(e){return e.coth()},BigNumber:function(e){return new r(1).div(e.tanh())},Unit:function(e){if(!e.hasBase(e.constructor.BASE_UNITS.ANGLE))throw new TypeError("Unit in function coth is no angle");return this(e.value)},"Array | Matrix":function(e){return oe(e,this)}})}),t=["typed","BigNumber"],Ua=Object(a.a)("csc",t,function(e){var t=e.typed,r=e.BigNumber;return t("csc",{number:ba,Complex:function(e){return e.csc()},BigNumber:function(e){return new r(1).div(e.sin())},Unit:function(e){if(!e.hasBase(e.constructor.BASE_UNITS.ANGLE))throw new TypeError("Unit in function csc is no angle");return this(e.value)},"Array | Matrix":function(e){return oe(e,this)}})}),n=["typed","BigNumber"],Pa=Object(a.a)("csch",n,function(e){var t=e.typed,r=e.BigNumber;return t("csch",{number:va,Complex:function(e){return e.csch()},BigNumber:function(e){return new r(1).div(e.sinh())},Unit:function(e){if(!e.hasBase(e.constructor.BASE_UNITS.ANGLE))throw new TypeError("Unit in function csch is no angle");return this(e.value)},"Array | Matrix":function(e){return oe(e,this)}})}),t=["typed","BigNumber"],Fa=Object(a.a)("sec",t,function(e){var t=e.typed,r=e.BigNumber;return t("sec",{number:xa,Complex:function(e){return e.sec()},BigNumber:function(e){return new r(1).div(e.cos())},Unit:function(e){if(!e.hasBase(e.constructor.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sec is no angle");return this(e.value)},"Array | Matrix":function(e){return oe(e,this)}})}),n=["typed","BigNumber"],La=Object(a.a)("sech",n,function(e){var t=e.typed,r=e.BigNumber;return t("sech",{number:wa,Complex:function(e){return e.sech()},BigNumber:function(e){return new r(1).div(e.cosh())},Unit:function(e){if(!e.hasBase(e.constructor.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sech is no angle");return this(e.value)},"Array | Matrix":function(e){return oe(e,this)}})}),t=["typed"],Ha=Object(a.a)("sin",t,function(e){return(0,e.typed)("sin",{number:Math.sin,Complex:function(e){return e.sin()},BigNumber:function(e){return e.sin()},Unit:function(e){if(!e.hasBase(e.constructor.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sin is no angle");return this(e.value)},"Array | Matrix":function(e){return oe(e,this,!0)}})}),n=["typed"],$a=Object(a.a)("sinh",n,function(e){return(0,e.typed)("sinh",{number:Na,Complex:function(e){return e.sinh()},BigNumber:function(e){return e.sinh()},Unit:function(e){if(!e.hasBase(e.constructor.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sinh is no angle");return this(e.value)},"Array | Matrix":function(e){return oe(e,this,!0)}})}),t=["typed"],Ga=Object(a.a)("tan",t,function(e){return(0,e.typed)("tan",{number:Math.tan,Complex:function(e){return e.tan()},BigNumber:function(e){return e.tan()},Unit:function(e){if(!e.hasBase(e.constructor.BASE_UNITS.ANGLE))throw new TypeError("Unit in function tan is no angle");return this(e.value)},"Array | Matrix":function(e){return oe(e,this,!0)}})}),n=["typed"],Va=Object(a.a)("tanh",n,function(e){return(0,e.typed)("tanh",{number:N.p,Complex:function(e){return e.tanh()},BigNumber:function(e){return e.tanh()},Unit:function(e){if(!e.hasBase(e.constructor.BASE_UNITS.ANGLE))throw new TypeError("Unit in function tanh is no angle");return this(e.value)},"Array | Matrix":function(e){return oe(e,this,!0)}})}),Za="setCartesian",t=["typed","size","subset","compareNatural","Index","DenseMatrix"],Ja=Object(a.a)(Za,t,function(e){var t=e.typed,s=e.size,u=e.subset,c=e.compareNatural,f=e.Index,l=e.DenseMatrix;return t(Za,{"Array | Matrix, Array | Matrix":function(e,t){var r=[];if(0!==u(s(e),new f(0))&&0!==u(s(t),new f(0)))for(var n=Object(E.e)(Array.isArray(e)?e:e.toArray()).sort(c),i=Object(E.e)(Array.isArray(t)?t:t.toArray()).sort(c),r=[],a=0;a<n.length;a++)for(var o=0;o<i.length;o++)r.push([n[a],i[o]]);return Array.isArray(e)&&Array.isArray(t)?r:new l(r)}})}),Wa="setDifference",n=["typed","size","subset","compareNatural","Index","DenseMatrix"],Ya=Object(a.a)(Wa,n,function(e){var t=e.typed,u=e.size,c=e.subset,f=e.compareNatural,l=e.Index,p=e.DenseMatrix;return t(Wa,{"Array | Matrix, Array | Matrix":function(e,t){if(0===c(u(e),new l(0)))a=[];else{if(0===c(u(t),new l(0)))return Object(E.e)(e.toArray());for(var r,n=Object(E.i)(Object(E.e)(Array.isArray(e)?e:e.toArray()).sort(f)),i=Object(E.i)(Object(E.e)(Array.isArray(t)?t:t.toArray()).sort(f)),a=[],o=0;o<n.length;o++){r=!1;for(var s=0;s<i.length;s++)if(0===f(n[o].value,i[s].value)&&n[o].identifier===i[s].identifier){r=!0;break}r||a.push(n[o])}}return Array.isArray(e)&&Array.isArray(t)?Object(E.g)(a):new p(Object(E.g)(a))}})}),Xa="setDistinct",t=["typed","size","subset","compareNatural","Index","DenseMatrix"],Qa=Object(a.a)(Xa,t,function(e){var t=e.typed,i=e.size,a=e.subset,o=e.compareNatural,s=e.Index,u=e.DenseMatrix;return t(Xa,{"Array | Matrix":function(e){if(0===a(i(e),new s(0)))t=[];else{var t,r=Object(E.e)(Array.isArray(e)?e:e.toArray()).sort(o);(t=[]).push(r[0]);for(var n=1;n<r.length;n++)0!==o(r[n],r[n-1])&&t.push(r[n])}return Array.isArray(e)?t:new u(t)}})}),Ka="setIntersect",n=["typed","size","subset","compareNatural","Index","DenseMatrix"],eo=Object(a.a)(Ka,n,function(e){var t=e.typed,s=e.size,u=e.subset,c=e.compareNatural,f=e.Index,l=e.DenseMatrix;return t(Ka,{"Array | Matrix, Array | Matrix":function(e,t){if(0===u(s(e),new f(0))||0===u(s(t),new f(0)))i=[];else for(var r=Object(E.i)(Object(E.e)(Array.isArray(e)?e:e.toArray()).sort(c)),n=Object(E.i)(Object(E.e)(Array.isArray(t)?t:t.toArray()).sort(c)),i=[],a=0;a<r.length;a++)for(var o=0;o<n.length;o++)if(0===c(r[a].value,n[o].value)&&r[a].identifier===n[o].identifier){i.push(r[a]);break}return Array.isArray(e)&&Array.isArray(t)?Object(E.g)(i):new l(Object(E.g)(i))}})}),to="setIsSubset",t=["typed","size","subset","compareNatural","Index"],ro=Object(a.a)(to,t,function(e){var t=e.typed,s=e.size,u=e.subset,c=e.compareNatural,f=e.Index;return t(to,{"Array | Matrix, Array | Matrix":function(e,t){if(0===u(s(e),new f(0)))return!0;if(0===u(s(t),new f(0)))return!1;for(var r,n=Object(E.i)(Object(E.e)(Array.isArray(e)?e:e.toArray()).sort(c)),i=Object(E.i)(Object(E.e)(Array.isArray(t)?t:t.toArray()).sort(c)),a=0;a<n.length;a++){r=!1;for(var o=0;o<i.length;o++)if(0===c(n[a].value,i[o].value)&&n[a].identifier===i[o].identifier){r=!0;break}if(!1===r)return!1}return!0}})}),no="setMultiplicity",n=["typed","size","subset","compareNatural","Index"],io=Object(a.a)(no,n,function(e){var t=e.typed,a=e.size,o=e.subset,s=e.compareNatural,u=e.Index;return t(no,{"number | BigNumber | Fraction | Complex, Array | Matrix":function(e,t){if(0===o(a(t),new u(0)))return 0;for(var r=Object(E.e)(Array.isArray(t)?t:t.toArray()),n=0,i=0;i<r.length;i++)0===s(r[i],e)&&n++;return n}})}),ao="setPowerset",t=["typed","size","subset","compareNatural","Index"],oo=Object(a.a)(ao,t,function(e){var t=e.typed,i=e.size,a=e.subset,o=e.compareNatural,s=e.Index;return t(ao,{"Array | Matrix":function(e){if(0===a(i(e),new s(0)))return[];for(var t=Object(E.e)(Array.isArray(e)?e:e.toArray()).sort(o),r=[],n=0;n.toString(2).length<=t.length;)r.push(function(e,t){for(var r=[],n=0;n<t.length;n++)"1"===t[n]&&r.push(e[n]);return r}(t,n.toString(2).split("").reverse())),n++;return function(e){for(var t=[],r=e.length-1;0<r;r--)for(var n=0;n<r;n++)e[n].length>e[n+1].length&&(t=e[n],e[n]=e[n+1],e[n+1]=t);return e}(r)}})}),so="setSize",n=["typed","compareNatural"],uo=Object(a.a)(so,n,function(e){var t=e.typed,a=e.compareNatural;return t(so,{"Array | Matrix":function(e){return(Array.isArray(e)?Object(E.e)(e):Object(E.e)(e.toArray())).length},"Array | Matrix, boolean":function(e,t){if(!1===t||0===e.length)return(Array.isArray(e)?Object(E.e)(e):Object(E.e)(e.toArray())).length;for(var r=Object(E.e)(Array.isArray(e)?e:e.toArray()).sort(a),n=1,i=1;i<r.length;i++)0!==a(r[i],r[i-1])&&n++;return n}})}),co="setSymDifference",t=["typed","size","concat","subset","setDifference","Index"],fo=Object(a.a)(co,t,function(e){var t=e.typed,r=e.size,n=e.concat,i=e.subset,a=e.setDifference,o=e.Index;return t(co,{"Array | Matrix, Array | Matrix":function(e,t){if(0===i(r(e),new o(0)))return Object(E.e)(t);if(0===i(r(t),new o(0)))return Object(E.e)(e);e=Object(E.e)(e),t=Object(E.e)(t);return n(a(e,t),a(t,e))}})}),lo="setUnion",n=["typed","size","concat","subset","setIntersect","setSymDifference","Index"],po=Object(a.a)(lo,n,function(e){var t=e.typed,r=e.size,n=e.concat,i=e.subset,a=e.setIntersect,o=e.setSymDifference,s=e.Index;return t(lo,{"Array | Matrix, Array | Matrix":function(e,t){if(0===i(r(e),new s(0)))return Object(E.e)(t);if(0===i(r(t),new s(0)))return Object(E.e)(e);e=Object(E.e)(e),t=Object(E.e)(t);return n(o(e,t),a(e,t))}})}),t=["typed","matrix","addScalar","equalScalar","DenseMatrix","SparseMatrix"],mo=Object(a.a)("add",t,function(e){var t=e.typed,r=e.matrix,n=e.addScalar,i=e.equalScalar,a=e.DenseMatrix,o=(e.SparseMatrix,it({typed:t})),s=at({typed:t,equalScalar:i}),u=ot({typed:t,DenseMatrix:a}),c=st({typed:t}),f=Ze({typed:t});return t("add",Object(ae.e)({"DenseMatrix, DenseMatrix":function(e,t){return c(e,t,n)},"DenseMatrix, SparseMatrix":function(e,t){return o(e,t,n,!1)},"SparseMatrix, DenseMatrix":function(e,t){return o(t,e,n,!0)},"SparseMatrix, SparseMatrix":function(e,t){return s(e,t,n)},"Array, Array":function(e,t){return this(r(e),r(t)).valueOf()},"Array, Matrix":function(e,t){return this(r(e),t)},"Matrix, Array":function(e,t){return this(e,r(t))},"DenseMatrix, any":function(e,t){return f(e,t,n,!1)},"SparseMatrix, any":function(e,t){return u(e,t,n,!1)},"any, DenseMatrix":function(e,t){return f(t,e,n,!0)},"any, SparseMatrix":function(e,t){return u(t,e,n,!0)},"Array, any":function(e,t){return f(r(e),t,n,!1).valueOf()},"any, Array":function(e,t){return f(r(t),e,n,!0).valueOf()},"any, any":n,"any, any, ...any":function(e,t,r){for(var n=this(e,t),i=0;i<r.length;i++)n=this(n,r[i]);return n}},n.signatures))}),n=["typed","abs","addScalar","divideScalar","multiplyScalar","sqrt","smaller","isPositive"],ho=Object(a.a)("hypot",n,function(e){var t=e.typed,a=e.abs,o=e.addScalar,s=e.divideScalar,u=e.multiplyScalar,c=e.sqrt,f=e.smaller,l=e.isPositive;return t("hypot",{"... number | BigNumber":function(e){for(var t=0,r=0,n=0;n<e.length;n++){var i=a(e[n]);f(r,i)?(t=u(t,u(s(r,i),s(r,i))),t=o(t,1),r=i):t=o(t,l(i)?u(s(i,r),s(i,r)):i)}return u(r,c(t))},Array:function(e){return this.apply(this,Object(E.e)(e))},Matrix:function(e){return this.apply(this,Object(E.e)(e.toArray()))}})}),t=["typed","abs","add","pow","conj","sqrt","multiply","equalScalar","larger","smaller","matrix","ctranspose","eigs"],yo=Object(a.a)("norm",t,function(e){var t=e.typed,s=e.abs,u=e.add,a=e.pow,c=e.conj,f=e.sqrt,l=e.multiply,o=e.equalScalar,p=e.larger,m=e.smaller,r=e.matrix,h=e.ctranspose,d=e.eigs;return t("norm",{number:Math.abs,Complex:function(e){return e.abs()},BigNumber:function(e){return e.abs()},boolean:function(e){return Math.abs(e)},Array:function(e){return y(r(e),2)},Matrix:function(e){return y(e,2)},"number | Complex | BigNumber | boolean, number | BigNumber | string":function(e){return this(e)},"Array, number | BigNumber | string":function(e,t){return y(r(e),t)},"Matrix, number | BigNumber | string":y});function n(e,t){if(t===Number.POSITIVE_INFINITY||"inf"===t)return r=0,e.forEach(function(e){e=s(e);p(e,r)&&(r=e)},!0),r;var r,n;if(t===Number.NEGATIVE_INFINITY||"-inf"===t)return e.forEach(function(e){e=s(e);n&&!m(e,n)||(n=e)},!0),n||0;if("fro"===t)return y(e,2);if("number"!=typeof t||isNaN(t))throw new Error("Unsupported parameter value");if(o(t,0))return Number.POSITIVE_INFINITY;var i=0;return e.forEach(function(e){i=u(a(s(e),t),i)},!0),a(i,1/t)}function i(e,t){if(1===t)return r=[],n=0,e.forEach(function(e,t){t=t[1],e=u(r[t]||0,s(e));p(e,n)&&(n=e),r[t]=e},!0),n;var r,n,i,a,o;if(t===Number.POSITIVE_INFINITY||"inf"===t)return i=[],a=0,e.forEach(function(e,t){t=t[0],e=u(i[t]||0,s(e));p(e,a)&&(a=e),i[t]=e},!0),a;if("fro"===t)return o=0,e.forEach(function(e,t){o=u(o,l(e,c(e)))}),s(f(o));if(2===t)return function(e){var t=e.size();if(t[0]!==t[1])throw new RangeError("Invalid matrix dimensions");return t=h(e),e=l(t,e),e=(e=d(e).values).get([e.size()[0]-1]),s(f(e))}(e);throw new Error("Unsupported parameter value "+t)}function y(e,t){var r=e.size();if(1===r.length)return n(e,t);if(2===r.length){if(r[0]&&r[1])return i(e,t);throw new RangeError("Invalid matrix dimensions")}}}),n=["typed","addScalar","multiplyScalar","conj","size"],go=Object(a.a)("dot",n,function(e){var g=e.typed,b=e.addScalar,v=e.multiplyScalar,x=e.conj,t=e.size;return g("dot",{"Array | DenseMatrix, Array | DenseMatrix":function(e,t){var r=w(e,t),n=Object(ie.v)(e)?e._data:e,i=Object(ie.v)(e)?e._datatype:void 0,a=Object(ie.v)(t)?t._data:t,o=Object(ie.v)(t)?t._datatype:void 0,e=2===N(e).length,t=2===N(t).length,s=b,u=v;i&&o&&i===o&&"string"==typeof i&&(i=i,s=g.find(b,[i,i]),u=g.find(v,[i,i]));if(!e&&!t){for(var c=u(x(n[0]),a[0]),f=1;f<r;f++)c=s(c,u(x(n[f]),a[f]));return c}if(!e&&t){for(var l=u(x(n[0]),a[0][0]),p=1;p<r;p++)l=s(l,u(x(n[p]),a[p][0]));return l}if(e&&!t){for(var m=u(x(n[0][0]),a[0]),h=1;h<r;h++)m=s(m,u(x(n[h][0]),a[h]));return m}if(e&&t){for(var d=u(x(n[0][0]),a[0][0]),y=1;y<r;y++)d=s(d,u(x(n[y][0]),a[y][0]));return d}},"SparseMatrix, SparseMatrix":function(e,t){w(e,t);var r=e._index,n=e._values,i=t._index,a=t._values,o=0,s=b,u=v,c=0,f=0;for(;c<r.length&&f<i.length;){var l=r[c],p=i[f];l<p?c++:p<l?f++:l===p&&(o=s(o,u(n[c],a[f])),c++,f++)}return o}});function w(e,t){var r,n,e=N(e),t=N(t);if(1===e.length)r=e[0];else{if(2!==e.length||1!==e[1])throw new RangeError("Expected a column vector, instead got a matrix of size ("+e.join(", ")+")");r=e[0]}if(1===t.length)n=t[0];else{if(2!==t.length||1!==t[1])throw new RangeError("Expected a column vector, instead got a matrix of size ("+t.join(", ")+")");n=t[0]}if(r!==n)throw new RangeError("Vectors must have equal length ("+r+" != "+n+")");if(0===r)throw new RangeError("Cannot calculate the dot product of empty vectors");return r}function N(e){return Object(ie.v)(e)?e.size():t(e)}}),t=["typed","matrix","add"],bo=Object(a.a)("trace",t,function(e){var t=e.typed,r=e.matrix,p=e.add;return t("trace",{Array:function(e){return n(r(e))},SparseMatrix:function(e){var t=e._values,r=e._index,n=e._ptr,i=e._size,e=i[0],a=i[1];if(e!==a)throw new RangeError("Matrix must be square (size: "+Object(Z.d)(i)+")");var o=0;if(0<t.length)for(var s=0;s<a;s++)for(var u=n[s],c=n[s+1],f=u;f<c;f++){var l=r[f];if(l===s){o=p(o,t[f]);break}if(s<l)break}return o},DenseMatrix:n,any:ae.a});function n(e){var t=e._size,r=e._data;switch(t.length){case 1:if(1===t[0])return Object(ae.a)(r[0]);throw new RangeError("Matrix must be square (size: "+Object(Z.d)(t)+")");case 2:var n=t[0];if(n!==t[1])throw new RangeError("Matrix must be square (size: "+Object(Z.d)(t)+")");for(var i=0,a=0;a<n;a++)i=p(i,r[a][a]);return i;default:throw new RangeError("Matrix must be two dimensional (size: "+Object(Z.d)(t)+")")}}}),n=["typed","Index"],vo=Object(a.a)("index",n,function(e){var t=e.typed,r=e.Index;return t("index",{"...number | string | BigNumber | Range | Array | Matrix":function(e){var t=e.map(function(e){return Object(ie.e)(e)?e.toNumber():Array.isArray(e)||Object(ie.v)(e)?e.map(function(e){return Object(ie.e)(e)?e.toNumber():e}):e}),e=new r;return r.apply(e,t),e}})}),xo={end:!0};function wo(e){return(wo="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var t=["mathWithTransform"],No=Object(a.a)("Node",t,function(e){var i=e.mathWithTransform;function t(){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator")}return t.prototype.evaluate=function(e){return this.compile().evaluate(e)},t.prototype.type="Node",t.prototype.isNode=!0,t.prototype.comment="",t.prototype.compile=function(){var t=this._compile(i,{}),r={},n=null;return{evaluate:function(e){return function(e){for(var t in e)if(Object(ae.f)(e,t)&&t in xo)throw new Error('Scope contains an illegal symbol, "'+t+'" is a reserved keyword')}(e=e||{}),t(e,r,n)}}},t.prototype._compile=function(e,t){throw new Error("Method _compile should be implemented by type "+this.type)},t.prototype.forEach=function(e){throw new Error("Cannot run forEach on a Node interface")},t.prototype.map=function(e){throw new Error("Cannot run map on a Node interface")},t.prototype._ifNode=function(e){if(!Object(ie.w)(e))throw new TypeError("Callback function must return a Node");return e},t.prototype.traverse=function(e){e(this,null,null),function n(e,i){e.forEach(function(e,t,r){i(e,t,r),n(e,i)})}(this,e)},t.prototype.transform=function(i){return function e(t,r,n){n=i(t,r,n);return n!==t?n:t.map(e)}(this,null,null)},t.prototype.filter=function(n){var i=[];return this.traverse(function(e,t,r){n(e,t,r)&&i.push(e)}),i},t.prototype.clone=function(){throw new Error("Cannot clone a Node interface")},t.prototype.cloneDeep=function(){return this.map(function(e){return e.cloneDeep()})},t.prototype.equals=function(e){return!!e&&Object(ae.d)(this,e)},t.prototype.toString=function(e){var t;if(e&&"object"===wo(e))switch(wo(e.handler)){case"object":case"undefined":break;case"function":t=e.handler(this,e);break;default:throw new TypeError("Object or function expected as callback")}return void 0!==t?t:this._toString(e)},t.prototype.toJSON=function(){throw new Error("Cannot serialize object: toJSON not implemented by "+this.type)},t.prototype.toHTML=function(e){var t;if(e&&"object"===wo(e))switch(wo(e.handler)){case"object":case"undefined":break;case"function":t=e.handler(this,e);break;default:throw new TypeError("Object or function expected as callback")}return void 0!==t?t:this.toHTML(e)},t.prototype._toString=function(){throw new Error("_toString not implemented for "+this.type)},t.prototype.toTex=function(e){var t;if(e&&"object"===wo(e))switch(wo(e.handler)){case"object":case"undefined":break;case"function":t=e.handler(this,e);break;default:throw new TypeError("Object or function expected as callback")}return void 0!==t?t:this._toTex(e)},t.prototype._toTex=function(e){throw new Error("_toTex not implemented for "+this.type)},t.prototype.getIdentifier=function(){return this.type},t.prototype.getContent=function(){return this},t},{isClass:!0,isNode:!0});function Oo(e){return e&&e.isIndexError?new j.a(e.index+1,e.min+1,void 0!==e.max?e.max+1:void 0):e}function Mo(e){return(Mo="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function jo(e){var r=e.subset;return function(e,t){try{if(Array.isArray(e))return r(e,t);if(e&&"function"==typeof e.subset)return e.subset(t);if("string"==typeof e)return r(e,t);if("object"!==Mo(e))throw new TypeError("Cannot apply index: unsupported type of object");if(!t.isObjectProperty())throw new TypeError("Cannot apply a numeric index as object property");return Wr(e,t.getObjectProperty())}catch(e){throw Oo(e)}}}var n=["subset","Node"],Eo=Object(a.a)("AccessorNode",n,function(e){var t=e.subset,e=e.Node,o=jo({subset:t});function r(e,t){if(!(this instanceof r))throw new SyntaxError("Constructor must be called with the new operator");if(!Object(ie.w)(e))throw new TypeError('Node expected for parameter "object"');if(!Object(ie.u)(t))throw new TypeError('IndexNode expected for parameter "index"');this.object=e||null,this.index=t,Object.defineProperty(this,"name",{get:function(){return this.index?this.index.isObjectProperty()?this.index.getObjectProperty():"":this.object.name||""}.bind(this),set:function(){throw new Error("Cannot assign a new name, name is read-only")}})}function n(e){return!(Object(ie.a)(e)||Object(ie.c)(e)||Object(ie.l)(e)||Object(ie.r)(e)||Object(ie.A)(e)||Object(ie.C)(e)||Object(ie.J)(e))}return(r.prototype=new e).type="AccessorNode",r.prototype.isAccessorNode=!0,r.prototype._compile=function(e,t){var n=this.object._compile(e,t),i=this.index._compile(e,t);if(this.index.isObjectProperty()){var a=this.index.getObjectProperty();return function(e,t,r){return Wr(n(e,t,r),a)}}return function(e,t,r){r=n(e,t,r),t=i(e,t,r);return o(r,t)}},r.prototype.forEach=function(e){e(this.object,"object",this),e(this.index,"index",this)},r.prototype.map=function(e){return new r(this._ifNode(e(this.object,"object",this)),this._ifNode(e(this.index,"index",this)))},r.prototype.clone=function(){return new r(this.object,this.index)},r.prototype._toString=function(e){var t=this.object.toString(e);return n(this.object)&&(t="("+t+")"),t+this.index.toString(e)},r.prototype.toHTML=function(e){var t=this.object.toHTML(e);return n(this.object)&&(t='<span class="math-parenthesis math-round-parenthesis">(</span>'+t+'<span class="math-parenthesis math-round-parenthesis">)</span>'),t+this.index.toHTML(e)},r.prototype._toTex=function(e){var t=this.object.toTex(e);return n(this.object)&&(t="\\left(' + object + '\\right)"),t+this.index.toTex(e)},r.prototype.toJSON=function(){return{mathjs:"AccessorNode",object:this.object,index:this.index}},r.fromJSON=function(e){return new r(e.object,e.index)},r},{isClass:!0,isNode:!0}),t=["Node"],So=Object(a.a)("ArrayNode",t,function(e){e=e.Node;function n(e){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if(this.items=e||[],!Array.isArray(this.items)||!this.items.every(ie.w))throw new TypeError("Array containing Nodes expected")}return(n.prototype=new e).type="ArrayNode",n.prototype.isArrayNode=!0,n.prototype._compile=function(t,r){var e=Object(E.k)(this.items,function(e){return e._compile(t,r)});if("Array"===t.config.matrix)return function(t,r,n){return Object(E.k)(e,function(e){return e(t,r,n)})};var i=t.matrix;return function(t,r,n){return i(Object(E.k)(e,function(e){return e(t,r,n)}))}},n.prototype.forEach=function(e){for(var t=0;t<this.items.length;t++)e(this.items[t],"items["+t+"]",this)},n.prototype.map=function(e){for(var t=[],r=0;r<this.items.length;r++)t[r]=this._ifNode(e(this.items[r],"items["+r+"]",this));return new n(t)},n.prototype.clone=function(){return new n(this.items.slice(0))},n.prototype._toString=function(t){return"["+this.items.map(function(e){return e.toString(t)}).join(", ")+"]"},n.prototype.toJSON=function(){return{mathjs:"ArrayNode",items:this.items}},n.fromJSON=function(e){return new n(e.items)},n.prototype.toHTML=function(t){return'<span class="math-parenthesis math-square-parenthesis">[</span>'+this.items.map(function(e){return e.toHTML(t)}).join('<span class="math-separator">,</span>')+'<span class="math-parenthesis math-square-parenthesis">]</span>'},n.prototype._toTex=function(t){var r="\\begin{bmatrix}";return this.items.forEach(function(e){e.items?r+=e.items.map(function(e){return e.toTex(t)}).join("&"):r+=e.toTex(t),r+="\\\\"}),r+="\\end{bmatrix}"},n},{isClass:!0,isNode:!0});function Ao(e){return(Ao="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var Co=[{AssignmentNode:{},FunctionAssignmentNode:{}},{ConditionalNode:{latexLeftParens:!1,latexRightParens:!1,latexParens:!1}},{"OperatorNode:or":{associativity:"left",associativeWith:[]}},{"OperatorNode:xor":{associativity:"left",associativeWith:[]}},{"OperatorNode:and":{associativity:"left",associativeWith:[]}},{"OperatorNode:bitOr":{associativity:"left",associativeWith:[]}},{"OperatorNode:bitXor":{associativity:"left",associativeWith:[]}},{"OperatorNode:bitAnd":{associativity:"left",associativeWith:[]}},{"OperatorNode:equal":{associativity:"left",associativeWith:[]},"OperatorNode:unequal":{associativity:"left",associativeWith:[]},"OperatorNode:smaller":{associativity:"left",associativeWith:[]},"OperatorNode:larger":{associativity:"left",associativeWith:[]},"OperatorNode:smallerEq":{associativity:"left",associativeWith:[]},"OperatorNode:largerEq":{associativity:"left",associativeWith:[]},RelationalNode:{associativity:"left",associativeWith:[]}},{"OperatorNode:leftShift":{associativity:"left",associativeWith:[]},"OperatorNode:rightArithShift":{associativity:"left",associativeWith:[]},"OperatorNode:rightLogShift":{associativity:"left",associativeWith:[]}},{"OperatorNode:to":{associativity:"left",associativeWith:[]}},{RangeNode:{}},{"OperatorNode:add":{associativity:"left",associativeWith:["OperatorNode:add","OperatorNode:subtract"]},"OperatorNode:subtract":{associativity:"left",associativeWith:[]}},{"OperatorNode:multiply":{associativity:"left",associativeWith:["OperatorNode:multiply","OperatorNode:divide","Operator:dotMultiply","Operator:dotDivide"]},"OperatorNode:divide":{associativity:"left",associativeWith:[],latexLeftParens:!1,latexRightParens:!1,latexParens:!1},"OperatorNode:dotMultiply":{associativity:"left",associativeWith:["OperatorNode:multiply","OperatorNode:divide","OperatorNode:dotMultiply","OperatorNode:doDivide"]},"OperatorNode:dotDivide":{associativity:"left",associativeWith:[]},"OperatorNode:mod":{associativity:"left",associativeWith:[]}},{"OperatorNode:unaryPlus":{associativity:"right"},"OperatorNode:unaryMinus":{associativity:"right"},"OperatorNode:bitNot":{associativity:"right"},"OperatorNode:not":{associativity:"right"}},{"OperatorNode:pow":{associativity:"right",associativeWith:[],latexRightParens:!1},"OperatorNode:dotPow":{associativity:"right",associativeWith:[]}},{"OperatorNode:factorial":{associativity:"left"}},{"OperatorNode:transpose":{associativity:"left"}}];function _o(e,t){var r=e;"keep"!==t&&(r=e.getContent());for(var n=r.getIdentifier(),i=0;i<Co.length;i++)if(n in Co[i])return i;return null}function To(e,t){var r=e;"keep"!==t&&(r=e.getContent());e=r.getIdentifier(),t=_o(r,t);if(null===t)return null;t=Co[t][e];if(Object(ae.f)(t,"associativity")){if("left"===t.associativity)return"left";if("right"===t.associativity)return"right";throw Error("'"+e+"' has the invalid associativity '"+t.associativity+"'.")}return null}function qo(e,t,r){var n="keep"!==r?e.getContent():e,e="keep"!==r?e.getContent():t,t=n.getIdentifier(),i=e.getIdentifier(),r=_o(n,r);if(null===r)return null;var a=Co[r][t];if(Object(ae.f)(a,"associativeWith")&&a.associativeWith instanceof Array){for(var o=0;o<a.associativeWith.length;o++)if(a.associativeWith[o]===i)return!0;return!1}return null}var n=["subset","?matrix","Node"],Io=Object(a.a)("AssignmentNode",n,function(e){var n,i,t=e.subset,r=e.matrix,e=e.Node,p=jo({subset:t}),m=(n=(r={subset:t,matrix:r}).subset,i=r.matrix,function(e,t,r){try{if(Array.isArray(e))return i(e).subset(t,r).valueOf();if(e&&"function"==typeof e.subset)return e.subset(t,r);if("string"==typeof e)return n(e,t,r);if("object"!==Ao(e))throw new TypeError("Cannot apply index: unsupported type of object");if(!t.isObjectProperty())throw TypeError("Cannot apply a numeric index as object property");return Yr(e,t.getObjectProperty(),r),e}catch(e){throw Oo(e)}});function a(e,t,r){if(!(this instanceof a))throw new SyntaxError("Constructor must be called with the new operator");if(this.object=e,this.index=r?t:null,this.value=r||t,!Object(ie.J)(e)&&!Object(ie.a)(e))throw new TypeError('SymbolNode or AccessorNode expected as "object"');if(Object(ie.J)(e)&&"end"===e.name)throw new Error('Cannot assign to symbol "end"');if(this.index&&!Object(ie.u)(this.index))throw new TypeError('IndexNode expected as "index"');if(!Object(ie.w)(this.value))throw new TypeError('Node expected as "value"');Object.defineProperty(this,"name",{get:function(){return this.index?this.index.isObjectProperty()?this.index.getObjectProperty():"":this.object.name||""}.bind(this),set:function(){throw new Error("Cannot assign a new name, name is read-only")}})}function o(e,t){var r=_o(e,t=t||"keep"),e=_o(e.value,t);return"all"===t||null!==e&&e<=r}return(a.prototype=new e).type="AssignmentNode",a.prototype.isAssignmentNode=!0,a.prototype._compile=function(e,t){var i=this.object._compile(e,t),s=this.index?this.index._compile(e,t):null,u=this.value._compile(e,t),a=this.object.name;if(this.index){if(this.index.isObjectProperty()){var o=this.index.getObjectProperty();return function(e,t,r){var n=i(e,t,r),r=u(e,t,r);return Yr(n,o,r)}}if(Object(ie.J)(this.object))return function(e,t,r){var n=i(e,t,r),r=u(e,t,r),t=s(e,t,n);return Yr(e,a,m(n,t,r)),r};var c=this.object.object._compile(e,t);if(this.object.index.isObjectProperty()){var f=this.object.index.getObjectProperty();return function(e,t,r){var n=c(e,t,r),i=Wr(n,f),a=s(e,t,i),r=u(e,t,r);return Yr(n,f,m(i,a,r)),r}}var l=this.object.index._compile(e,t);return function(e,t,r){var n=c(e,t,r),i=l(e,t,n),a=p(n,i),o=s(e,t,a),r=u(e,t,r);return m(n,i,m(a,o,r)),r}}if(!Object(ie.J)(this.object))throw new TypeError("SymbolNode expected as object");return function(e,t,r){return Yr(e,a,u(e,t,r))}},a.prototype.forEach=function(e){e(this.object,"object",this),this.index&&e(this.index,"index",this),e(this.value,"value",this)},a.prototype.map=function(e){return new a(this._ifNode(e(this.object,"object",this)),this.index?this._ifNode(e(this.index,"index",this)):null,this._ifNode(e(this.value,"value",this)))},a.prototype.clone=function(){return new a(this.object,this.index,this.value)},a.prototype._toString=function(e){var t=this.object.toString(e),r=this.index?this.index.toString(e):"",n=this.value.toString(e);return o(this,e&&e.parenthesis)&&(n="("+n+")"),t+r+" = "+n},a.prototype.toJSON=function(){return{mathjs:"AssignmentNode",object:this.object,index:this.index,value:this.value}},a.fromJSON=function(e){return new a(e.object,e.index,e.value)},a.prototype.toHTML=function(e){var t=this.object.toHTML(e),r=this.index?this.index.toHTML(e):"",n=this.value.toHTML(e);return o(this,e&&e.parenthesis)&&(n='<span class="math-paranthesis math-round-parenthesis">(</span>'+n+'<span class="math-paranthesis math-round-parenthesis">)</span>'),t+r+'<span class="math-operator math-assignment-operator math-variable-assignment-operator math-binary-operator">=</span>'+n},a.prototype._toTex=function(e){var t=this.object.toTex(e),r=this.index?this.index.toTex(e):"",n=this.value.toTex(e);return o(this,e&&e.parenthesis)&&(n="\\left(".concat(n,"\\right)")),t+r+":="+n},a},{isClass:!0,isNode:!0}),t=["ResultSet","Node"],Bo=Object(a.a)("BlockNode",t,function(e){var o=e.ResultSet,e=e.Node;function a(e){if(!(this instanceof a))throw new SyntaxError("Constructor must be called with the new operator");if(!Array.isArray(e))throw new Error("Array expected");this.blocks=e.map(function(e){var t=e&&e.node,e=!e||void 0===e.visible||e.visible;if(!Object(ie.w)(t))throw new TypeError('Property "node" must be a Node');if("boolean"!=typeof e)throw new TypeError('Property "visible" must be a boolean');return{node:t,visible:e}})}return(a.prototype=new e).type="BlockNode",a.prototype.isBlockNode=!0,a.prototype._compile=function(t,r){var e=Object(E.k)(this.blocks,function(e){return{evaluate:e.node._compile(t,r),visible:e.visible}});return function(r,n,i){var a=[];return Object(E.f)(e,function(e){var t=e.evaluate(r,n,i);e.visible&&a.push(t)}),new o(a)}},a.prototype.forEach=function(e){for(var t=0;t<this.blocks.length;t++)e(this.blocks[t].node,"blocks["+t+"].node",this)},a.prototype.map=function(e){for(var t=[],r=0;r<this.blocks.length;r++){var n=this.blocks[r],i=this._ifNode(e(n.node,"blocks["+r+"].node",this));t[r]={node:i,visible:n.visible}}return new a(t)},a.prototype.clone=function(){return new a(this.blocks.map(function(e){return{node:e.node,visible:e.visible}}))},a.prototype._toString=function(t){return this.blocks.map(function(e){return e.node.toString(t)+(e.visible?"":";")}).join("\n")},a.prototype.toJSON=function(){return{mathjs:"BlockNode",blocks:this.blocks}},a.fromJSON=function(e){return new a(e.blocks)},a.prototype.toHTML=function(t){return this.blocks.map(function(e){return e.node.toHTML(t)+(e.visible?"":'<span class="math-separator">;</span>')}).join('<span class="math-separator"><br /></span>')},a.prototype._toTex=function(t){return this.blocks.map(function(e){return e.node.toTex(t)+(e.visible?"":";")}).join("\\;\\;\n")},a},{isClass:!0,isNode:!0}),n=["Node"],ko=Object(a.a)("ConditionalNode",n,function(e){e=e.Node;function n(e,t,r){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if(!Object(ie.w)(e))throw new TypeError("Parameter condition must be a Node");if(!Object(ie.w)(t))throw new TypeError("Parameter trueExpr must be a Node");if(!Object(ie.w)(r))throw new TypeError("Parameter falseExpr must be a Node");this.condition=e,this.trueExpr=t,this.falseExpr=r}return(n.prototype=new e).type="ConditionalNode",n.prototype.isConditionalNode=!0,n.prototype._compile=function(e,t){var n=this.condition._compile(e,t),i=this.trueExpr._compile(e,t),a=this.falseExpr._compile(e,t);return function(e,t,r){return(function(e){if("number"==typeof e||"boolean"==typeof e||"string"==typeof e)return!!e;if(e){if(Object(ie.e)(e))return!e.isZero();if(Object(ie.j)(e))return!(!e.re&&!e.im);if(Object(ie.L)(e))return!!e.value}if(null!=e)throw new TypeError('Unsupported type of condition "'+Object(ie.M)(e)+'"');return!1}(n(e,t,r))?i:a)(e,t,r)}},n.prototype.forEach=function(e){e(this.condition,"condition",this),e(this.trueExpr,"trueExpr",this),e(this.falseExpr,"falseExpr",this)},n.prototype.map=function(e){return new n(this._ifNode(e(this.condition,"condition",this)),this._ifNode(e(this.trueExpr,"trueExpr",this)),this._ifNode(e(this.falseExpr,"falseExpr",this)))},n.prototype.clone=function(){return new n(this.condition,this.trueExpr,this.falseExpr)},n.prototype._toString=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=_o(this,t),n=this.condition.toString(e),i=_o(this.condition,t);("all"===t||"OperatorNode"===this.condition.type||null!==i&&i<=r)&&(n="("+n+")");var a=this.trueExpr.toString(e),i=_o(this.trueExpr,t);("all"===t||"OperatorNode"===this.trueExpr.type||null!==i&&i<=r)&&(a="("+a+")");i=this.falseExpr.toString(e),e=_o(this.falseExpr,t);return("all"===t||"OperatorNode"===this.falseExpr.type||null!==e&&e<=r)&&(i="("+i+")"),n+" ? "+a+" : "+i},n.prototype.toJSON=function(){return{mathjs:"ConditionalNode",condition:this.condition,trueExpr:this.trueExpr,falseExpr:this.falseExpr}},n.fromJSON=function(e){return new n(e.condition,e.trueExpr,e.falseExpr)},n.prototype.toHTML=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=_o(this,t),n=this.condition.toHTML(e),i=_o(this.condition,t);("all"===t||"OperatorNode"===this.condition.type||null!==i&&i<=r)&&(n='<span class="math-parenthesis math-round-parenthesis">(</span>'+n+'<span class="math-parenthesis math-round-parenthesis">)</span>');var a=this.trueExpr.toHTML(e),i=_o(this.trueExpr,t);("all"===t||"OperatorNode"===this.trueExpr.type||null!==i&&i<=r)&&(a='<span class="math-parenthesis math-round-parenthesis">(</span>'+a+'<span class="math-parenthesis math-round-parenthesis">)</span>');i=this.falseExpr.toHTML(e),e=_o(this.falseExpr,t);return("all"===t||"OperatorNode"===this.falseExpr.type||null!==e&&e<=r)&&(i='<span class="math-parenthesis math-round-parenthesis">(</span>'+i+'<span class="math-parenthesis math-round-parenthesis">)</span>'),n+'<span class="math-operator math-conditional-operator">?</span>'+a+'<span class="math-operator math-conditional-operator">:</span>'+i},n.prototype._toTex=function(e){return"\\begin{cases} {"+this.trueExpr.toTex(e)+"}, &\\quad{\\text{if }\\;"+this.condition.toTex(e)+"}\\\\{"+this.falseExpr.toTex(e)+"}, &\\quad{\\text{otherwise}}\\end{cases}"},n},{isClass:!0,isNode:!0}),t=r(16),zo=r.n(t),Do={Alpha:"A",alpha:"\\alpha",Beta:"B",beta:"\\beta",Gamma:"\\Gamma",gamma:"\\gamma",Delta:"\\Delta",delta:"\\delta",Epsilon:"E",epsilon:"\\epsilon",varepsilon:"\\varepsilon",Zeta:"Z",zeta:"\\zeta",Eta:"H",eta:"\\eta",Theta:"\\Theta",theta:"\\theta",vartheta:"\\vartheta",Iota:"I",iota:"\\iota",Kappa:"K",kappa:"\\kappa",varkappa:"\\varkappa",Lambda:"\\Lambda",lambda:"\\lambda",Mu:"M",mu:"\\mu",Nu:"N",nu:"\\nu",Xi:"\\Xi",xi:"\\xi",Omicron:"O",omicron:"o",Pi:"\\Pi",pi:"\\pi",varpi:"\\varpi",Rho:"P",rho:"\\rho",varrho:"\\varrho",Sigma:"\\Sigma",sigma:"\\sigma",varsigma:"\\varsigma",Tau:"T",tau:"\\tau",Upsilon:"\\Upsilon",upsilon:"\\upsilon",Phi:"\\Phi",phi:"\\phi",varphi:"\\varphi",Chi:"X",chi:"\\chi",Psi:"\\Psi",psi:"\\psi",Omega:"\\Omega",omega:"\\omega",true:"\\mathrm{True}",false:"\\mathrm{False}",i:"i",inf:"\\infty",Inf:"\\infty",infinity:"\\infty",Infinity:"\\infty",oo:"\\infty",lim:"\\lim",undefined:"\\mathbf{?}"},Ro={transpose:"^\\top",ctranspose:"^H",factorial:"!",pow:"^",dotPow:".^\\wedge",unaryPlus:"+",unaryMinus:"-",bitNot:"\\~",not:"\\neg",multiply:"\\cdot",divide:"\\frac",dotMultiply:".\\cdot",dotDivide:".:",mod:"\\mod",add:"+",subtract:"-",to:"\\rightarrow",leftShift:"<<",rightArithShift:">>",rightLogShift:">>>",equal:"=",unequal:"\\neq",smaller:"<",larger:">",smallerEq:"\\leq",largerEq:"\\geq",bitAnd:"\\&",bitXor:"\\underline{|}",bitOr:"|",and:"\\wedge",xor:"\\veebar",or:"\\vee"},Uo={abs:{1:"\\left|${args[0]}\\right|"},add:{2:"\\left(${args[0]}".concat(Ro.add,"${args[1]}\\right)")},cbrt:{1:"\\sqrt[3]{${args[0]}}"},ceil:{1:"\\left\\lceil${args[0]}\\right\\rceil"},cube:{1:"\\left(${args[0]}\\right)^3"},divide:{2:"\\frac{${args[0]}}{${args[1]}}"},dotDivide:{2:"\\left(${args[0]}".concat(Ro.dotDivide,"${args[1]}\\right)")},dotMultiply:{2:"\\left(${args[0]}".concat(Ro.dotMultiply,"${args[1]}\\right)")},dotPow:{2:"\\left(${args[0]}".concat(Ro.dotPow,"${args[1]}\\right)")},exp:{1:"\\exp\\left(${args[0]}\\right)"},expm1:"\\left(e".concat(Ro.pow,"{${args[0]}}-1\\right)"),fix:{1:"\\mathrm{${name}}\\left(${args[0]}\\right)"},floor:{1:"\\left\\lfloor${args[0]}\\right\\rfloor"},gcd:"\\gcd\\left(${args}\\right)",hypot:"\\hypot\\left(${args}\\right)",log:{1:"\\ln\\left(${args[0]}\\right)",2:"\\log_{${args[1]}}\\left(${args[0]}\\right)"},log10:{1:"\\log_{10}\\left(${args[0]}\\right)"},log1p:{1:"\\ln\\left(${args[0]}+1\\right)",2:"\\log_{${args[1]}}\\left(${args[0]}+1\\right)"},log2:"\\log_{2}\\left(${args[0]}\\right)",mod:{2:"\\left(${args[0]}".concat(Ro.mod,"${args[1]}\\right)")},multiply:{2:"\\left(${args[0]}".concat(Ro.multiply,"${args[1]}\\right)")},norm:{1:"\\left\\|${args[0]}\\right\\|",2:void 0},nthRoot:{2:"\\sqrt[${args[1]}]{${args[0]}}"},nthRoots:{2:"\\{y : $y^{args[1]} = {${args[0]}}\\}"},pow:{2:"\\left(${args[0]}\\right)".concat(Ro.pow,"{${args[1]}}")},round:{1:"\\left\\lfloor${args[0]}\\right\\rceil",2:void 0},sign:{1:"\\mathrm{${name}}\\left(${args[0]}\\right)"},sqrt:{1:"\\sqrt{${args[0]}}"},square:{1:"\\left(${args[0]}\\right)^2"},subtract:{2:"\\left(${args[0]}".concat(Ro.subtract,"${args[1]}\\right)")},unaryMinus:{1:"".concat(Ro.unaryMinus,"\\left(${args[0]}\\right)")},unaryPlus:{1:"".concat(Ro.unaryPlus,"\\left(${args[0]}\\right)")},bitAnd:{2:"\\left(${args[0]}".concat(Ro.bitAnd,"${args[1]}\\right)")},bitNot:{1:Ro.bitNot+"\\left(${args[0]}\\right)"},bitOr:{2:"\\left(${args[0]}".concat(Ro.bitOr,"${args[1]}\\right)")},bitXor:{2:"\\left(${args[0]}".concat(Ro.bitXor,"${args[1]}\\right)")},leftShift:{2:"\\left(${args[0]}".concat(Ro.leftShift,"${args[1]}\\right)")},rightArithShift:{2:"\\left(${args[0]}".concat(Ro.rightArithShift,"${args[1]}\\right)")},rightLogShift:{2:"\\left(${args[0]}".concat(Ro.rightLogShift,"${args[1]}\\right)")},bellNumbers:{1:"\\mathrm{B}_{${args[0]}}"},catalan:{1:"\\mathrm{C}_{${args[0]}}"},stirlingS2:{2:"\\mathrm{S}\\left(${args}\\right)"},arg:{1:"\\arg\\left(${args[0]}\\right)"},conj:{1:"\\left(${args[0]}\\right)^*"},im:{1:"\\Im\\left\\lbrace${args[0]}\\right\\rbrace"},re:{1:"\\Re\\left\\lbrace${args[0]}\\right\\rbrace"},and:{2:"\\left(${args[0]}".concat(Ro.and,"${args[1]}\\right)")},not:{1:Ro.not+"\\left(${args[0]}\\right)"},or:{2:"\\left(${args[0]}".concat(Ro.or,"${args[1]}\\right)")},xor:{2:"\\left(${args[0]}".concat(Ro.xor,"${args[1]}\\right)")},cross:{2:"\\left(${args[0]}\\right)\\times\\left(${args[1]}\\right)"},ctranspose:{1:"\\left(${args[0]}\\right)".concat(Ro.ctranspose)},det:{1:"\\det\\left(${args[0]}\\right)"},dot:{2:"\\left(${args[0]}\\cdot${args[1]}\\right)"},expm:{1:"\\exp\\left(${args[0]}\\right)"},inv:{1:"\\left(${args[0]}\\right)^{-1}"},sqrtm:{1:"{${args[0]}}".concat(Ro.pow,"{\\frac{1}{2}}")},trace:{1:"\\mathrm{tr}\\left(${args[0]}\\right)"},transpose:{1:"\\left(${args[0]}\\right)".concat(Ro.transpose)},combinations:{2:"\\binom{${args[0]}}{${args[1]}}"},combinationsWithRep:{2:"\\left(\\!\\!{\\binom{${args[0]}}{${args[1]}}}\\!\\!\\right)"},factorial:{1:"\\left(${args[0]}\\right)".concat(Ro.factorial)},gamma:{1:"\\Gamma\\left(${args[0]}\\right)"},equal:{2:"\\left(${args[0]}".concat(Ro.equal,"${args[1]}\\right)")},larger:{2:"\\left(${args[0]}".concat(Ro.larger,"${args[1]}\\right)")},largerEq:{2:"\\left(${args[0]}".concat(Ro.largerEq,"${args[1]}\\right)")},smaller:{2:"\\left(${args[0]}".concat(Ro.smaller,"${args[1]}\\right)")},smallerEq:{2:"\\left(${args[0]}".concat(Ro.smallerEq,"${args[1]}\\right)")},unequal:{2:"\\left(${args[0]}".concat(Ro.unequal,"${args[1]}\\right)")},erf:{1:"erf\\left(${args[0]}\\right)"},max:"\\max\\left(${args}\\right)",min:"\\min\\left(${args}\\right)",variance:"\\mathrm{Var}\\left(${args}\\right)",acos:{1:"\\cos^{-1}\\left(${args[0]}\\right)"},acosh:{1:"\\cosh^{-1}\\left(${args[0]}\\right)"},acot:{1:"\\cot^{-1}\\left(${args[0]}\\right)"},acoth:{1:"\\coth^{-1}\\left(${args[0]}\\right)"},acsc:{1:"\\csc^{-1}\\left(${args[0]}\\right)"},acsch:{1:"\\mathrm{csch}^{-1}\\left(${args[0]}\\right)"},asec:{1:"\\sec^{-1}\\left(${args[0]}\\right)"},asech:{1:"\\mathrm{sech}^{-1}\\left(${args[0]}\\right)"},asin:{1:"\\sin^{-1}\\left(${args[0]}\\right)"},asinh:{1:"\\sinh^{-1}\\left(${args[0]}\\right)"},atan:{1:"\\tan^{-1}\\left(${args[0]}\\right)"},atan2:{2:"\\mathrm{atan2}\\left(${args}\\right)"},atanh:{1:"\\tanh^{-1}\\left(${args[0]}\\right)"},cos:{1:"\\cos\\left(${args[0]}\\right)"},cosh:{1:"\\cosh\\left(${args[0]}\\right)"},cot:{1:"\\cot\\left(${args[0]}\\right)"},coth:{1:"\\coth\\left(${args[0]}\\right)"},csc:{1:"\\csc\\left(${args[0]}\\right)"},csch:{1:"\\mathrm{csch}\\left(${args[0]}\\right)"},sec:{1:"\\sec\\left(${args[0]}\\right)"},sech:{1:"\\mathrm{sech}\\left(${args[0]}\\right)"},sin:{1:"\\sin\\left(${args[0]}\\right)"},sinh:{1:"\\sinh\\left(${args[0]}\\right)"},tan:{1:"\\tan\\left(${args[0]}\\right)"},tanh:{1:"\\tanh\\left(${args[0]}\\right)"},to:{2:"\\left(${args[0]}".concat(Ro.to,"${args[1]}\\right)")},numeric:function(e){return e.args[0].toTex()},number:{0:"0",1:"\\left(${args[0]}\\right)",2:"\\left(\\left(${args[0]}\\right)${args[1]}\\right)"},string:{0:'\\mathtt{""}',1:"\\mathrm{string}\\left(${args[0]}\\right)"},bignumber:{0:"0",1:"\\left(${args[0]}\\right)"},complex:{0:"0",1:"\\left(${args[0]}\\right)",2:"\\left(\\left(${args[0]}\\right)+".concat(Do.i,"\\cdot\\left(${args[1]}\\right)\\right)")},matrix:{0:"\\begin{bmatrix}\\end{bmatrix}",1:"\\left(${args[0]}\\right)",2:"\\left(${args[0]}\\right)"},sparse:{0:"\\begin{bsparse}\\end{bsparse}",1:"\\left(${args[0]}\\right)"},unit:{1:"\\left(${args[0]}\\right)",2:"\\left(\\left(${args[0]}\\right)${args[1]}\\right)"}},Po={deg:"^\\circ"};function Fo(e){return zo()(e,{preserveFormatting:!0})}function Lo(e,t){return(t=void 0!==t&&t)?Object(ae.f)(Po,e)?Po[e]:"\\mathrm{"+Fo(e)+"}":Object(ae.f)(Do,e)?Do[e]:Fo(e)}var n=["Node"],Ho=Object(a.a)("ConstantNode",n,function(e){e=e.Node;function t(e){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");this.value=e}return(t.prototype=new e).type="ConstantNode",t.prototype.isConstantNode=!0,t.prototype._compile=function(e,t){var r=this.value;return function(){return r}},t.prototype.forEach=function(e){},t.prototype.map=function(e){return this.clone()},t.prototype.clone=function(){return new t(this.value)},t.prototype._toString=function(e){return Object(Z.d)(this.value,e)},t.prototype.toHTML=function(e){e=this._toString(e);switch(Object(ie.M)(this.value)){case"number":case"BigNumber":case"Fraction":return'<span class="math-number">'+e+"</span>";case"string":return'<span class="math-string">'+e+"</span>";case"boolean":return'<span class="math-boolean">'+e+"</span>";case"null":return'<span class="math-null-symbol">'+e+"</span>";case"undefined":return'<span class="math-undefined">'+e+"</span>";default:return'<span class="math-symbol">'+e+"</span>"}},t.prototype.toJSON=function(){return{mathjs:"ConstantNode",value:this.value}},t.fromJSON=function(e){return new t(e.value)},t.prototype._toTex=function(e){var t=this._toString(e);switch(Object(ie.M)(this.value)){case"string":return"\\mathtt{"+Fo(t)+"}";case"number":case"BigNumber":if(!isFinite(this.value))return this.value.valueOf()<0?"-\\infty":"\\infty";e=t.toLowerCase().indexOf("e");return-1!==e?t.substring(0,e)+"\\cdot10^{"+t.substring(e+1)+"}":t;case"Fraction":return this.value.toLatex();default:return t}},t},{isClass:!0,isNode:!0}),t=["typed","Node"],$o=Object(a.a)("FunctionAssignmentNode",t,function(e){var f=e.typed,e=e.Node;function n(e,t,r){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if("string"!=typeof e)throw new TypeError('String expected for parameter "name"');if(!Array.isArray(t))throw new TypeError('Array containing strings or objects expected for parameter "params"');if(!Object(ie.w)(r))throw new TypeError('Node expected for parameter "expr"');if(e in xo)throw new Error('Illegal function name, "'+e+'" is a reserved keyword');this.name=e,this.params=t.map(function(e){return e&&e.name||e}),this.types=t.map(function(e){return e&&e.type||"any"}),this.expr=r}function i(e,t){var r=_o(e,t),e=_o(e.expr,t);return"all"===t||null!==e&&e<=r}return(n.prototype=new e).type="FunctionAssignmentNode",n.prototype.isFunctionAssignmentNode=!0,n.prototype._compile=function(e,t){var r=Object.create(t);Object(E.f)(this.params,function(e){r[e]=!0});var a=this.expr._compile(e,r),o=this.name,s=this.params,u=Object(E.j)(this.types,","),c=o+"("+Object(E.j)(this.params,", ")+")";return function(r,n,i){var e={};e[u]=function(){for(var e=Object.create(n),t=0;t<s.length;t++)e[s[t]]=arguments[t];return a(r,e,i)};e=f(o,e);return e.syntax=c,Yr(r,o,e),e}},n.prototype.forEach=function(e){e(this.expr,"expr",this)},n.prototype.map=function(e){e=this._ifNode(e(this.expr,"expr",this));return new n(this.name,this.params.slice(0),e)},n.prototype.clone=function(){return new n(this.name,this.params.slice(0),this.expr)},n.prototype._toString=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",e=this.expr.toString(e);return i(this,t)&&(e="("+e+")"),this.name+"("+this.params.join(", ")+") = "+e},n.prototype.toJSON=function(){var r=this.types;return{mathjs:"FunctionAssignmentNode",name:this.name,params:this.params.map(function(e,t){return{name:e,type:r[t]}}),expr:this.expr}},n.fromJSON=function(e){return new n(e.name,e.params,e.expr)},n.prototype.toHTML=function(e){for(var t=e&&e.parenthesis?e.parenthesis:"keep",r=[],n=0;n<this.params.length;n++)r.push('<span class="math-symbol math-parameter">'+Object(Z.c)(this.params[n])+"</span>");e=this.expr.toHTML(e);return i(this,t)&&(e='<span class="math-parenthesis math-round-parenthesis">(</span>'+e+'<span class="math-parenthesis math-round-parenthesis">)</span>'),'<span class="math-function">'+Object(Z.c)(this.name)+'</span><span class="math-parenthesis math-round-parenthesis">(</span>'+r.join('<span class="math-separator">,</span>')+'<span class="math-parenthesis math-round-parenthesis">)</span><span class="math-operator math-assignment-operator math-variable-assignment-operator math-binary-operator">=</span>'+e},n.prototype._toTex=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",e=this.expr.toTex(e);return i(this,t)&&(e="\\left(".concat(e,"\\right)")),"\\mathrm{"+this.name+"}\\left("+this.params.map(Lo).join(",")+"\\right):="+e},n},{isClass:!0,isNode:!0});function Go(e){return function(e){if(Array.isArray(e))return Vo(e)}(e)||function(e){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(e))return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return Vo(e,t);var r=Object.prototype.toString.call(e).slice(8,-1);"Object"===r&&e.constructor&&(r=e.constructor.name);if("Map"===r||"Set"===r)return Array.from(e);if("Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r))return Vo(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function Vo(e,t){(null==t||t>e.length)&&(t=e.length);for(var r=0,n=new Array(t);r<t;r++)n[r]=e[r];return n}var n=["Range","Node","size"],Zo=Object(a.a)("IndexNode",n,function(e){var n=e.Range,t=e.Node,m=e.size;function i(e,t){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator");if(this.dimensions=e,this.dotNotation=t||!1,!Array.isArray(e)||!e.every(ie.w))throw new TypeError('Array containing Nodes expected for parameter "dimensions"');if(this.dotNotation&&!this.isObjectProperty())throw new Error("dotNotation only applicable for object properties")}function h(e,t,r){return new n(Object(ie.e)(e)?e.toNumber():e,Object(ie.e)(t)?t.toNumber():t,Object(ie.e)(r)?r.toNumber():r)}return(i.prototype=new t).type="IndexNode",i.prototype.isIndexNode=!0,i.prototype._compile=function(r,p){var i=Object(E.k)(this.dimensions,function(e,i){if(Object(ie.E)(e)){if(e.needsEnd()){var t=Object.create(p);t.end=!0;var a=e.start._compile(r,t),o=e.end._compile(r,t),s=e.step?e.step._compile(r,t):function(){return 1};return function(e,t,r){var n=m(r).valueOf(),t=Object.create(t);return t.end=n[i],h(a(e,t,r),o(e,t,r),s(e,t,r))}}var n=e.start._compile(r,p),u=e.end._compile(r,p),c=e.step?e.step._compile(r,p):function(){return 1};return function(e,t,r){return h(n(e,t,r),u(e,t,r),c(e,t,r))}}if(Object(ie.J)(e)&&"end"===e.name){t=Object.create(p);t.end=!0;var f=e._compile(r,t);return function(e,t,r){var n=m(r).valueOf(),t=Object.create(t);return t.end=n[i],f(e,t,r)}}var l=e._compile(r,p);return function(e,t,r){return l(e,t,r)}}),a=Wr(r,"index");return function(t,r,n){var e=Object(E.k)(i,function(e){return e(t,r,n)});return a.apply(void 0,Go(e))}},i.prototype.forEach=function(e){for(var t=0;t<this.dimensions.length;t++)e(this.dimensions[t],"dimensions["+t+"]",this)},i.prototype.map=function(e){for(var t=[],r=0;r<this.dimensions.length;r++)t[r]=this._ifNode(e(this.dimensions[r],"dimensions["+r+"]",this));return new i(t,this.dotNotation)},i.prototype.clone=function(){return new i(this.dimensions.slice(0),this.dotNotation)},i.prototype.isObjectProperty=function(){return 1===this.dimensions.length&&Object(ie.l)(this.dimensions[0])&&"string"==typeof this.dimensions[0].value},i.prototype.getObjectProperty=function(){return this.isObjectProperty()?this.dimensions[0].value:null},i.prototype._toString=function(e){return this.dotNotation?"."+this.getObjectProperty():"["+this.dimensions.join(", ")+"]"},i.prototype.toJSON=function(){return{mathjs:"IndexNode",dimensions:this.dimensions,dotNotation:this.dotNotation}},i.fromJSON=function(e){return new i(e.dimensions,e.dotNotation)},i.prototype.toHTML=function(e){for(var t=[],r=0;r<this.dimensions.length;r++)t[r]=this.dimensions[r].toHTML();return this.dotNotation?'<span class="math-operator math-accessor-operator">.</span><span class="math-symbol math-property">'+Object(Z.c)(this.getObjectProperty())+"</span>":'<span class="math-parenthesis math-square-parenthesis">[</span>'+t.join('<span class="math-separator">,</span>')+'<span class="math-parenthesis math-square-parenthesis">]</span>'},i.prototype._toTex=function(t){var e=this.dimensions.map(function(e){return e.toTex(t)});return this.dotNotation?"."+this.getObjectProperty():"_{"+e.join(",")+"}"},i},{isClass:!0,isNode:!0});function Jo(e){return(Jo="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var t=["Node"],Wo=Object(a.a)("ObjectNode",t,function(e){e=e.Node;function n(t){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if(this.properties=t||{},t&&("object"!==Jo(t)||!Object.keys(t).every(function(e){return Object(ie.w)(t[e])})))throw new TypeError("Object containing Nodes expected")}return(n.prototype=new e).type="ObjectNode",n.prototype.isObjectNode=!0,n.prototype._compile=function(e,t){var r,a={};for(r in this.properties)if(Object(ae.f)(this.properties,r)){var n=Object(Z.e)(r),n=JSON.parse(n);if(!Xr(this.properties,n))throw new Error('No access to property "'+n+'"');a[n]=this.properties[r]._compile(e,t)}return function(e,t,r){var n,i={};for(n in a)Object(ae.f)(a,n)&&(i[n]=a[n](e,t,r));return i}},n.prototype.forEach=function(e){for(var t in this.properties)Object(ae.f)(this.properties,t)&&e(this.properties[t],"properties["+Object(Z.e)(t)+"]",this)},n.prototype.map=function(e){var t,r={};for(t in this.properties)Object(ae.f)(this.properties,t)&&(r[t]=this._ifNode(e(this.properties[t],"properties["+Object(Z.e)(t)+"]",this)));return new n(r)},n.prototype.clone=function(){var e,t={};for(e in this.properties)Object(ae.f)(this.properties,e)&&(t[e]=this.properties[e]);return new n(t)},n.prototype._toString=function(e){var t,r=[];for(t in this.properties)Object(ae.f)(this.properties,t)&&r.push(Object(Z.e)(t)+": "+this.properties[t].toString(e));return"{"+r.join(", ")+"}"},n.prototype.toJSON=function(){return{mathjs:"ObjectNode",properties:this.properties}},n.fromJSON=function(e){return new n(e.properties)},n.prototype.toHTML=function(e){var t,r=[];for(t in this.properties)Object(ae.f)(this.properties,t)&&r.push('<span class="math-symbol math-property">'+Object(Z.c)(t)+'</span><span class="math-operator math-assignment-operator math-property-assignment-operator math-binary-operator">:</span>'+this.properties[t].toHTML(e));return'<span class="math-parenthesis math-curly-parenthesis">{</span>'+r.join('<span class="math-separator">,</span>')+'<span class="math-parenthesis math-curly-parenthesis">}</span>'},n.prototype._toTex=function(e){var t,r=[];for(t in this.properties)Object(ae.f)(this.properties,t)&&r.push("\\mathbf{"+t+":} & "+this.properties[t].toTex(e)+"\\\\");return"\\left\\{\\begin{array}{ll}".concat(r.join("\n"),"\\end{array}\\right\\}")},n},{isClass:!0,isNode:!0}),n=["Node"],Yo=Object(a.a)("OperatorNode",n,function(e){e=e.Node;function i(e,t,r,n){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator");if("string"!=typeof e)throw new TypeError('string expected for parameter "op"');if("string"!=typeof t)throw new TypeError('string expected for parameter "fn"');if(!Array.isArray(r)||!r.every(ie.w))throw new TypeError('Array containing Nodes expected for parameter "args"');this.implicit=!0===n,this.op=e,this.fn=t,this.args=r||[]}function c(n,i,e,t,r){var a,o=_o(n,i),s=To(n,i);if("all"===i||2<t.length&&"OperatorNode:add"!==n.getIdentifier()&&"OperatorNode:multiply"!==n.getIdentifier())return t.map(function(e){switch(e.getContent().type){case"ArrayNode":case"ConstantNode":case"SymbolNode":case"ParenthesisNode":return!1;default:return!0}});switch(t.length){case 0:a=[];break;case 1:var u=_o(t[0],i);if(r&&null!==u){var c="keep"===i?(m=t[0].getIdentifier(),n.getIdentifier()):(m=t[0].getContent().getIdentifier(),n.getContent().getIdentifier());if(!1===Co[o][c].latexLeftParens){a=[!1];break}if(!1===Co[u][m].latexParens){a=[!1];break}}if(null===u){a=[!1];break}if(u<=o){a=[!0];break}a=[!1];break;case 2:var f,l,p=_o(t[0],i),c=qo(n,t[0],i),m=null!==p&&(p===o&&"right"===s&&!c||p<o),u=_o(t[1],i),c=qo(n,t[1],i),c=null!==u&&(u===o&&"left"===s&&!c||u<o);r&&(r="keep"===i?(f=n.getIdentifier(),l=n.args[0].getIdentifier(),n.args[1].getIdentifier()):(f=n.getContent().getIdentifier(),l=n.args[0].getContent().getIdentifier(),n.args[1].getContent().getIdentifier()),null!==p&&(!1===Co[o][f].latexLeftParens&&(m=!1),!1===Co[p][l].latexParens&&(m=!1)),null!==u&&(!1===Co[o][f].latexRightParens&&(c=!1),!1===Co[u][r].latexParens&&(c=!1))),a=[m,c];break;default:"OperatorNode:add"!==n.getIdentifier()&&"OperatorNode:multiply"!==n.getIdentifier()||(a=t.map(function(e){var t=_o(e,i),r=qo(n,e,i),e=To(e,i);return null!==t&&(o===t&&s===e&&!r||t<o)}))}return 2<=t.length&&"OperatorNode:multiply"===n.getIdentifier()&&n.implicit&&"auto"===i&&"hide"===e&&(a=t.map(function(e,t){e="ParenthesisNode"===e.getIdentifier();return!(!a[t]&&!e)})),a}return(i.prototype=new e).type="OperatorNode",i.prototype.isOperatorNode=!0,i.prototype._compile=function(t,r){if("string"!=typeof this.fn||!Qr(t,this.fn))throw t[this.fn]?new Error('No access to function "'+this.fn+'"'):new Error("Function "+this.fn+' missing in provided namespace "math"');var i=Wr(t,this.fn),e=Object(E.k)(this.args,function(e){return e._compile(t,r)});if(1===e.length){var n=e[0];return function(e,t,r){return i(n(e,t,r))}}if(2!==e.length)return function(t,r,n){return i.apply(null,Object(E.k)(e,function(e){return e(t,r,n)}))};var a=e[0],o=e[1];return function(e,t,r){return i(a(e,t,r),o(e,t,r))}},i.prototype.forEach=function(e){for(var t=0;t<this.args.length;t++)e(this.args[t],"args["+t+"]",this)},i.prototype.map=function(e){for(var t=[],r=0;r<this.args.length;r++)t[r]=this._ifNode(e(this.args[r],"args["+r+"]",this));return new i(this.op,this.fn,t,this.implicit)},i.prototype.clone=function(){return new i(this.op,this.fn,this.args.slice(0),this.implicit)},i.prototype.isUnary=function(){return 1===this.args.length},i.prototype.isBinary=function(){return 2===this.args.length},i.prototype._toString=function(r){var e=r&&r.parenthesis?r.parenthesis:"keep",t=r&&r.implicit?r.implicit:"hide",n=this.args,i=c(this,e,t,n,!1);if(1===n.length){var e=To(this,e),a=n[0].toString(r);i[0]&&(a="("+a+")");var o=/[a-zA-Z]+/.test(this.op);return"right"===e?this.op+(o?" ":"")+a:"left"===e?a+(o?" ":"")+this.op:a+this.op}if(2===n.length){o=n[0].toString(r),a=n[1].toString(r);return i[0]&&(o="("+o+")"),i[1]&&(a="("+a+")"),this.implicit&&"OperatorNode:multiply"===this.getIdentifier()&&"hide"===t?o+" "+a:o+" "+this.op+" "+a}if(2<n.length&&("OperatorNode:add"===this.getIdentifier()||"OperatorNode:multiply"===this.getIdentifier())){n=n.map(function(e,t){return e=e.toString(r),i[t]&&(e="("+e+")"),e});return this.implicit&&"OperatorNode:multiply"===this.getIdentifier()&&"hide"===t?n.join(" "):n.join(" "+this.op+" ")}return this.fn+"("+this.args.join(", ")+")"},i.prototype.toJSON=function(){return{mathjs:"OperatorNode",op:this.op,fn:this.fn,args:this.args,implicit:this.implicit}},i.fromJSON=function(e){return new i(e.op,e.fn,e.args,e.implicit)},i.prototype.toHTML=function(r){var e=r&&r.parenthesis?r.parenthesis:"keep",t=r&&r.implicit?r.implicit:"hide",n=this.args,i=c(this,e,t,n,!1);if(1===n.length){var e=To(this,e),a=n[0].toHTML(r);return i[0]&&(a='<span class="math-parenthesis math-round-parenthesis">(</span>'+a+'<span class="math-parenthesis math-round-parenthesis">)</span>'),"right"===e?'<span class="math-operator math-unary-operator math-lefthand-unary-operator">'+Object(Z.c)(this.op)+"</span>"+a:a+'<span class="math-operator math-unary-operator math-righthand-unary-operator">'+Object(Z.c)(this.op)+"</span>"}if(2===n.length){var a=n[0].toHTML(r),o=n[1].toHTML(r);return i[0]&&(a='<span class="math-parenthesis math-round-parenthesis">(</span>'+a+'<span class="math-parenthesis math-round-parenthesis">)</span>'),i[1]&&(o='<span class="math-parenthesis math-round-parenthesis">(</span>'+o+'<span class="math-parenthesis math-round-parenthesis">)</span>'),this.implicit&&"OperatorNode:multiply"===this.getIdentifier()&&"hide"===t?a+'<span class="math-operator math-binary-operator math-implicit-binary-operator"></span>'+o:a+'<span class="math-operator math-binary-operator math-explicit-binary-operator">'+Object(Z.c)(this.op)+"</span>"+o}o=n.map(function(e,t){return e=e.toHTML(r),i[t]&&(e='<span class="math-parenthesis math-round-parenthesis">(</span>'+e+'<span class="math-parenthesis math-round-parenthesis">)</span>'),e});return 2<n.length&&("OperatorNode:add"===this.getIdentifier()||"OperatorNode:multiply"===this.getIdentifier())?this.implicit&&"OperatorNode:multiply"===this.getIdentifier()&&"hide"===t?o.join('<span class="math-operator math-binary-operator math-implicit-binary-operator"></span>'):o.join('<span class="math-operator math-binary-operator math-explicit-binary-operator">'+Object(Z.c)(this.op)+"</span>"):'<span class="math-function">'+Object(Z.c)(this.fn)+'</span><span class="math-paranthesis math-round-parenthesis">(</span>'+o.join('<span class="math-separator">,</span>')+'<span class="math-paranthesis math-round-parenthesis">)</span>'},i.prototype._toTex=function(r){var e=r&&r.parenthesis?r.parenthesis:"keep",t=r&&r.implicit?r.implicit:"hide",n=this.args,i=c(this,e,t,n,!0),a=void 0===(a=Ro[this.fn])?this.op:a;if(1===n.length){var o=To(this,e),s=n[0].toTex(r);return i[0]&&(s="\\left(".concat(s,"\\right)")),"right"===o?a+s:s+a}if(2===n.length){o=n[0],s=o.toTex(r);i[0]&&(s="\\left(".concat(s,"\\right)"));var u=n[1].toTex(r);switch(i[1]&&(u="\\left(".concat(u,"\\right)")),o=("keep"===e?o:o.getContent()).getIdentifier(),this.getIdentifier()){case"OperatorNode:divide":return a+"{"+s+"}{"+u+"}";case"OperatorNode:pow":switch(s="{"+s+"}",u="{"+u+"}",o){case"ConditionalNode":case"OperatorNode:divide":s="\\left(".concat(s,"\\right)")}break;case"OperatorNode:multiply":if(this.implicit&&"hide"===t)return s+"~"+u}return s+a+u}if(2<n.length&&("OperatorNode:add"===this.getIdentifier()||"OperatorNode:multiply"===this.getIdentifier())){u=n.map(function(e,t){return e=e.toTex(r),i[t]&&(e="\\left(".concat(e,"\\right)")),e});return"OperatorNode:multiply"===this.getIdentifier()&&this.implicit?u.join("~"):u.join(a)}return"\\mathrm{"+this.fn+"}\\left("+n.map(function(e){return e.toTex(r)}).join(",")+"\\right)"},i.prototype.getIdentifier=function(){return this.type+":"+this.fn},i},{isClass:!0,isNode:!0}),t=["Node"],Xo=Object(a.a)("ParenthesisNode",t,function(e){e=e.Node;function t(e){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if(!Object(ie.w)(e))throw new TypeError('Node expected for parameter "content"');this.content=e}return(t.prototype=new e).type="ParenthesisNode",t.prototype.isParenthesisNode=!0,t.prototype._compile=function(e,t){return this.content._compile(e,t)},t.prototype.getContent=function(){return this.content.getContent()},t.prototype.forEach=function(e){e(this.content,"content",this)},t.prototype.map=function(e){return new t(e(this.content,"content",this))},t.prototype.clone=function(){return new t(this.content)},t.prototype._toString=function(e){return!e||e&&!e.parenthesis||e&&"keep"===e.parenthesis?"("+this.content.toString(e)+")":this.content.toString(e)},t.prototype.toJSON=function(){return{mathjs:"ParenthesisNode",content:this.content}},t.fromJSON=function(e){return new t(e.content)},t.prototype.toHTML=function(e){return!e||e&&!e.parenthesis||e&&"keep"===e.parenthesis?'<span class="math-parenthesis math-round-parenthesis">(</span>'+this.content.toHTML(e)+'<span class="math-parenthesis math-round-parenthesis">)</span>':this.content.toHTML(e)},t.prototype._toTex=function(e){return!e||e&&!e.parenthesis||e&&"keep"===e.parenthesis?"\\left(".concat(this.content.toTex(e),"\\right)"):this.content.toTex(e)},t},{isClass:!0,isNode:!0}),n=["Node"],Qo=Object(a.a)("RangeNode",n,function(e){e=e.Node;function n(e,t,r){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if(!Object(ie.w)(e))throw new TypeError("Node expected");if(!Object(ie.w)(t))throw new TypeError("Node expected");if(r&&!Object(ie.w)(r))throw new TypeError("Node expected");if(3<arguments.length)throw new Error("Too many arguments");this.start=e,this.end=t,this.step=r||null}function i(e,t){var r=_o(e,t),n={},i=_o(e.start,t);n.start=null!==i&&i<=r||"all"===t,e.step&&(i=_o(e.step,t),n.step=null!==i&&i<=r||"all"===t);e=_o(e.end,t);return n.end=null!==e&&e<=r||"all"===t,n}return(n.prototype=new e).type="RangeNode",n.prototype.isRangeNode=!0,n.prototype.needsEnd=function(){return 0<this.filter(function(e){return Object(ie.J)(e)&&"end"===e.name}).length},n.prototype._compile=function(e,t){var n=e.range,i=this.start._compile(e,t),a=this.end._compile(e,t);if(this.step){var o=this.step._compile(e,t);return function(e,t,r){return n(i(e,t,r),a(e,t,r),o(e,t,r))}}return function(e,t,r){return n(i(e,t,r),a(e,t,r))}},n.prototype.forEach=function(e){e(this.start,"start",this),e(this.end,"end",this),this.step&&e(this.step,"step",this)},n.prototype.map=function(e){return new n(this._ifNode(e(this.start,"start",this)),this._ifNode(e(this.end,"end",this)),this.step&&this._ifNode(e(this.step,"step",this)))},n.prototype.clone=function(){return new n(this.start,this.end,this.step&&this.step)},n.prototype._toString=function(e){var t,r=i(this,e&&e.parenthesis?e.parenthesis:"keep"),n=this.start.toString(e);r.start&&(n="("+n+")"),t=n,this.step&&(n=this.step.toString(e),r.step&&(n="("+n+")"),t+=":"+n);e=this.end.toString(e);return r.end&&(e="("+e+")"),t+=":"+e},n.prototype.toJSON=function(){return{mathjs:"RangeNode",start:this.start,end:this.end,step:this.step}},n.fromJSON=function(e){return new n(e.start,e.end,e.step)},n.prototype.toHTML=function(e){var t,r=i(this,e&&e.parenthesis?e.parenthesis:"keep"),n=this.start.toHTML(e);r.start&&(n='<span class="math-parenthesis math-round-parenthesis">(</span>'+n+'<span class="math-parenthesis math-round-parenthesis">)</span>'),t=n,this.step&&(n=this.step.toHTML(e),r.step&&(n='<span class="math-parenthesis math-round-parenthesis">(</span>'+n+'<span class="math-parenthesis math-round-parenthesis">)</span>'),t+='<span class="math-operator math-range-operator">:</span>'+n);e=this.end.toHTML(e);return r.end&&(e='<span class="math-parenthesis math-round-parenthesis">(</span>'+e+'<span class="math-parenthesis math-round-parenthesis">)</span>'),t+='<span class="math-operator math-range-operator">:</span>'+e},n.prototype._toTex=function(e){var t,r=i(this,e&&e.parenthesis?e.parenthesis:"keep"),n=this.start.toTex(e);r.start&&(n="\\left(".concat(n,"\\right)")),this.step&&(t=this.step.toTex(e),r.step&&(t="\\left(".concat(t,"\\right)")),n+=":"+t);e=this.end.toTex(e);return r.end&&(e="\\left(".concat(e,"\\right)")),n+=":"+e},n},{isClass:!0,isNode:!0}),t=["Node"],Ko=Object(a.a)("RelationalNode",t,function(e){e=e.Node;function i(e,t){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator");if(!Array.isArray(e))throw new TypeError("Parameter conditionals must be an array");if(!Array.isArray(t))throw new TypeError("Parameter params must be an array");if(e.length!==t.length-1)throw new TypeError("Parameter params must contain exactly one more element than parameter conditionals");this.conditionals=e,this.params=t}return(i.prototype=new e).type="RelationalNode",i.prototype.isRelationalNode=!0,i.prototype._compile=function(o,t){var s=this,u=this.params.map(function(e){return e._compile(o,t)});return function(e,t,r){for(var n=u[0](e,t,r),i=0;i<s.conditionals.length;i++){var a=n,n=u[i+1](e,t,r);if(!Wr(o,s.conditionals[i])(a,n))return!1}return!0}},i.prototype.forEach=function(r){var n=this;this.params.forEach(function(e,t){return r(e,"params["+t+"]",n)},this)},i.prototype.map=function(r){var n=this;return new i(this.conditionals.slice(),this.params.map(function(e,t){return n._ifNode(r(e,"params["+t+"]",n))},this))},i.prototype.clone=function(){return new i(this.conditionals,this.params)},i.prototype._toString=function(n){for(var i=n&&n.parenthesis?n.parenthesis:"keep",a=_o(this,i),e=this.params.map(function(e,t){var r=_o(e,i);return"all"===i||null!==r&&r<=a?"("+e.toString(n)+")":e.toString(n)}),t={equal:"==",unequal:"!=",smaller:"<",larger:">",smallerEq:"<=",largerEq:">="},r=e[0],o=0;o<this.conditionals.length;o++)r+=" "+t[this.conditionals[o]]+" "+e[o+1];return r},i.prototype.toJSON=function(){return{mathjs:"RelationalNode",conditionals:this.conditionals,params:this.params}},i.fromJSON=function(e){return new i(e.conditionals,e.params)},i.prototype.toHTML=function(n){for(var i=n&&n.parenthesis?n.parenthesis:"keep",a=_o(this,i),e=this.params.map(function(e,t){var r=_o(e,i);return"all"===i||null!==r&&r<=a?'<span class="math-parenthesis math-round-parenthesis">(</span>'+e.toHTML(n)+'<span class="math-parenthesis math-round-parenthesis">)</span>':e.toHTML(n)}),t={equal:"==",unequal:"!=",smaller:"<",larger:">",smallerEq:"<=",largerEq:">="},r=e[0],o=0;o<this.conditionals.length;o++)r+='<span class="math-operator math-binary-operator math-explicit-binary-operator">'+Object(Z.c)(t[this.conditionals[o]])+"</span>"+e[o+1];return r},i.prototype._toTex=function(n){for(var i=n&&n.parenthesis?n.parenthesis:"keep",a=_o(this,i),e=this.params.map(function(e,t){var r=_o(e,i);return"all"===i||null!==r&&r<=a?"\\left("+e.toTex(n)+"\right)":e.toTex(n)}),t=e[0],r=0;r<this.conditionals.length;r++)t+=Ro[this.conditionals[r]]+e[r+1];return t},i},{isClass:!0,isNode:!0}),n=["math","?Unit","Node"],es=Object(a.a)("SymbolNode",n,function(e){var r=e.math,o=e.Unit,e=e.Node;function s(e){return!!o&&o.isValuelessUnit(e)}function t(e){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if("string"!=typeof e)throw new TypeError('String expected for parameter "name"');this.name=e}return(t.prototype=new e).type="SymbolNode",t.prototype.isSymbolNode=!0,t.prototype._compile=function(n,e){var i=this.name;if(!0===e[i])return function(e,t,r){return t[i]};if(i in n)return function(e,t,r){return i in e?Wr(e,i):Wr(n,i)};var a=s(i);return function(e,t,r){return i in e?Wr(e,i):a?new o(null,i):function(e){throw new Error("Undefined symbol "+e)}(i)}},t.prototype.forEach=function(e){},t.prototype.map=function(e){return this.clone()},t.prototype.clone=function(){return new t(this.name)},t.prototype._toString=function(e){return this.name},t.prototype.toHTML=function(e){var t=Object(Z.c)(this.name);return"true"===t||"false"===t?'<span class="math-symbol math-boolean">'+t+"</span>":"i"===t?'<span class="math-symbol math-imaginary-symbol">'+t+"</span>":"Infinity"===t?'<span class="math-symbol math-infinity-symbol">'+t+"</span>":"NaN"===t?'<span class="math-symbol math-nan-symbol">'+t+"</span>":"null"===t?'<span class="math-symbol math-null-symbol">'+t+"</span>":"undefined"===t?'<span class="math-symbol math-undefined-symbol">'+t+"</span>":'<span class="math-symbol">'+t+"</span>"},t.prototype.toJSON=function(){return{mathjs:"SymbolNode",name:this.name}},t.fromJSON=function(e){return new t(e.name)},t.prototype._toTex=function(e){var t=!1;void 0===r[this.name]&&s(this.name)&&(t=!0);t=Lo(this.name,t);return"\\"===t[0]?t:" "+t},t},{isClass:!0,isNode:!0});function ts(e){return(ts="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function rs(){return(rs=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var r,n=arguments[t];for(r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e}).apply(this,arguments)}var t=["math","Node","SymbolNode"],ns=Object(a.a)("FunctionNode",t,function(e){var i=e.math,t=e.Node,r=e.SymbolNode;function d(e,t){if(!(this instanceof d))throw new SyntaxError("Constructor must be called with the new operator");if("string"==typeof e&&(e=new r(e)),!Object(ie.w)(e))throw new TypeError('Node expected as parameter "fn"');if(!Array.isArray(t)||!t.every(ie.w))throw new TypeError('Array containing Nodes expected for parameter "args"');this.fn=e,this.args=t||[],Object.defineProperty(this,"name",{get:function(){return this.fn.name||""}.bind(this),set:function(){throw new Error("Cannot assign a new name, name is read-only")}})}(d.prototype=new t).type="FunctionNode",d.prototype.isFunctionNode=!0,d.prototype._compile=function(i,t){if(!(this instanceof d))throw new TypeError("No valid FunctionNode");var a=Object(E.k)(this.args,function(e){return e._compile(i,t)});if(Object(ie.J)(this.fn)){var o=this.fn.name,s=o in i?Wr(i,o):void 0;if("function"==typeof s&&!0===s.rawArgs){var r=this.args;return function(e,t){return(o in e?Wr(e,o):s)(r,i,rs({},e,t))}}if(1===a.length){var n=a[0];return function(e,t,r){return(o in e?Wr(e,o):s)(n(e,t,r))}}if(2!==a.length)return function(t,r,n){return(o in t?Wr(t,o):s).apply(null,Object(E.k)(a,function(e){return e(t,r,n)}))};var u=a[0],c=a[1];return function(e,t,r){return(o in e?Wr(e,o):s)(u(e,t,r),c(e,t,r))}}if(Object(ie.a)(this.fn)&&Object(ie.u)(this.fn.index)&&this.fn.index.isObjectProperty()){var f=this.fn.object._compile(i,t),l=this.fn.index.getObjectProperty(),p=this.args;return function(t,r,n){var e=f(t,r,n);return function(e,t){if(!Qr(e,t))throw new Error('No access to method "'+t+'"')}(e,l),e[l]&&e[l].rawArgs?e[l](p,i,rs({},t,r)):e[l].apply(e,Object(E.k)(a,function(e){return e(t,r,n)}))}}var m=this.fn._compile(i,t),h=this.args;return function(t,r,n){var e=m(t,r,n);return e&&e.rawArgs?e(h,i,rs({},t,r)):e.apply(e,Object(E.k)(a,function(e){return e(t,r,n)}))}},d.prototype.forEach=function(e){e(this.fn,"fn",this);for(var t=0;t<this.args.length;t++)e(this.args[t],"args["+t+"]",this)},d.prototype.map=function(e){for(var t=this._ifNode(e(this.fn,"fn",this)),r=[],n=0;n<this.args.length;n++)r[n]=this._ifNode(e(this.args[n],"args["+n+"]",this));return new d(t,r)},d.prototype.clone=function(){return new d(this.fn,this.args.slice(0))};var n=d.prototype.toString;function a(e,t,r){for(var n,i="",a=/\$(?:\{([a-z_][a-z_0-9]*)(?:\[([0-9]+)\])?\}|\$)/gi,o=0;null!==(n=a.exec(e));)if(i+=e.substring(o,n.index),o=n.index,"$$"===n[0])i+="$",o++;else{o+=n[0].length;var s=t[n[1]];if(!s)throw new ReferenceError("Template: Property "+n[1]+" does not exist.");if(void 0===n[2])switch(ts(s)){case"string":i+=s;break;case"object":if(Object(ie.w)(s))i+=s.toTex(r);else{if(!Array.isArray(s))throw new TypeError("Template: "+n[1]+" has to be a Node, String or array of Nodes");i+=s.map(function(e,t){if(Object(ie.w)(e))return e.toTex(r);throw new TypeError("Template: "+n[1]+"["+t+"] is not a Node.")}).join(",")}break;default:throw new TypeError("Template: "+n[1]+" has to be a Node, String or array of Nodes")}else{if(!Object(ie.w)(s[n[2]]&&s[n[2]]))throw new TypeError("Template: "+n[1]+"["+n[2]+"] is not a Node.");i+=s[n[2]].toTex(r)}}return i+=e.slice(o)}d.prototype.toString=function(e){var t,r=this.fn.toString(e);return e&&"object"===ts(e.handler)&&Object(ae.f)(e.handler,r)&&(t=e.handler[r](this,e)),void 0!==t?t:n.call(this,e)},d.prototype._toString=function(t){var e=this.args.map(function(e){return e.toString(t)});return(Object(ie.q)(this.fn)?"("+this.fn.toString(t)+")":this.fn.toString(t))+"("+e.join(", ")+")"},d.prototype.toJSON=function(){return{mathjs:"FunctionNode",fn:this.fn,args:this.args}},d.fromJSON=function(e){return new d(e.fn,e.args)},d.prototype.toHTML=function(t){var e=this.args.map(function(e){return e.toHTML(t)});return'<span class="math-function">'+Object(Z.c)(this.fn)+'</span><span class="math-paranthesis math-round-parenthesis">(</span>'+e.join('<span class="math-separator">,</span>')+'<span class="math-paranthesis math-round-parenthesis">)</span>'};var o=d.prototype.toTex;return d.prototype.toTex=function(e){var t;return e&&"object"===ts(e.handler)&&Object(ae.f)(e.handler,this.name)&&(t=e.handler[this.name](this,e)),void 0!==t?t:o.call(this,e)},d.prototype._toTex=function(t){var e,r,n=this.args.map(function(e){return e.toTex(t)});switch(Uo[this.name]&&(e=Uo[this.name]),!i[this.name]||"function"!=typeof i[this.name].toTex&&"object"!==ts(i[this.name].toTex)&&"string"!=typeof i[this.name].toTex||(e=i[this.name].toTex),ts(e)){case"function":r=e(this,t);break;case"string":r=a(e,this,t);break;case"object":switch(ts(e[n.length])){case"function":r=e[n.length](this,t);break;case"string":r=a(e[n.length],this,t)}}return void 0!==r?r:a("\\mathrm{${name}}\\left(${args}\\right)",this,t)},d.prototype.getIdentifier=function(){return this.type+":"+this.name},d},{isClass:!0,isNode:!0});function is(){return(is=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var r,n=arguments[t];for(r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e}).apply(this,arguments)}var n=["typed","numeric","config","AccessorNode","ArrayNode","AssignmentNode","BlockNode","ConditionalNode","ConstantNode","FunctionAssignmentNode","FunctionNode","IndexNode","ObjectNode","OperatorNode","ParenthesisNode","RangeNode","RelationalNode","SymbolNode"],as=Object(a.a)("parse",n,function(e){var t=e.typed,s=e.numeric,u=e.config,i=e.AccessorNode,c=e.ArrayNode,o=e.AssignmentNode,a=e.BlockNode,f=e.ConditionalNode,l=e.ConstantNode,p=e.FunctionAssignmentNode,m=e.FunctionNode,h=e.IndexNode,d=e.ObjectNode,y=e.OperatorNode,g=e.ParenthesisNode,n=e.RangeNode,b=e.RelationalNode,v=e.SymbolNode,x=t("parse",{string:function(e){return k(e,{})},"Array | Matrix":function(e){return r(e,{})},"string, Object":function(e,t){return k(e,void 0!==t.nodes?t.nodes:{})},"Array | Matrix, Object":r});function r(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},r=void 0!==t.nodes?t.nodes:{};return oe(e,function(e){if("string"!=typeof e)throw new TypeError("String expected");return k(e,r)})}var w={NULL:0,DELIMITER:1,NUMBER:2,SYMBOL:3,UNKNOWN:4},N={",":!0,"(":!0,")":!0,"[":!0,"]":!0,"{":!0,"}":!0,'"':!0,"'":!0,";":!0,"+":!0,"-":!0,"*":!0,".*":!0,"/":!0,"./":!0,"%":!0,"^":!0,".^":!0,"~":!0,"!":!0,"&":!0,"|":!0,"^|":!0,"=":!0,":":!0,"?":!0,"==":!0,"!=":!0,"<":!0,">":!0,"<=":!0,">=":!0,"<<":!0,">>":!0,">>>":!0},O={mod:!0,to:!0,in:!0,and:!0,xor:!0,or:!0,not:!0},M={true:!0,false:!1,null:null,undefined:void 0},j=["NaN","Infinity"];function E(e,t){return e.expression.substr(e.index,t)}function S(e){return E(e,1)}function A(e){e.index++}function C(e){return e.expression.charAt(e.index-1)}function _(e){return e.expression.charAt(e.index+1)}function T(e){for(e.tokenType=w.NULL,e.token="",e.comment="";x.isWhitespace(S(e),e.nestingLevel);)A(e);if("#"===S(e))for(;"\n"!==S(e)&&""!==S(e);)e.comment+=S(e),A(e);if(""!==S(e)){if("\n"===S(e)&&!e.nestingLevel)return e.tokenType=w.DELIMITER,e.token=S(e),void A(e);var t=S(e),r=E(e,2),n=E(e,3);if(3===n.length&&N[n])return e.tokenType=w.DELIMITER,e.token=n,A(e),A(e),void A(e);if(2===r.length&&N[r])return e.tokenType=w.DELIMITER,e.token=r,A(e),void A(e);if(N[t])return e.tokenType=w.DELIMITER,e.token=t,void A(e);if(x.isDigitDot(t)){e.tokenType=w.NUMBER;t=E(e,2);if("0b"!==t&&"0o"!==t&&"0x"!==t){if("."===S(e))e.token+=S(e),A(e),x.isDigit(S(e))||(e.tokenType=w.DELIMITER);else{for(;x.isDigit(S(e));)e.token+=S(e),A(e);x.isDecimalMark(S(e),_(e))&&(e.token+=S(e),A(e))}for(;x.isDigit(S(e));)e.token+=S(e),A(e);if("E"===S(e)||"e"===S(e))if(x.isDigit(_(e))||"-"===_(e)||"+"===_(e)){if(e.token+=S(e),A(e),"+"!==S(e)&&"-"!==S(e)||(e.token+=S(e),A(e)),!x.isDigit(S(e)))throw re(e,'Digit expected, got "'+S(e)+'"');for(;x.isDigit(S(e));)e.token+=S(e),A(e);if(x.isDecimalMark(S(e),_(e)))throw re(e,'Digit expected, got "'+S(e)+'"')}else if("."===_(e))throw A(e),re(e,'Digit expected, got "'+S(e)+'"')}else for(e.token+=S(e),A(e),e.token+=S(e),A(e);x.isHexDigit(S(e));)e.token+=S(e),A(e)}else{if(!x.isAlpha(S(e),C(e),_(e))){for(e.tokenType=w.UNKNOWN;""!==S(e);)e.token+=S(e),A(e);throw re(e,'Syntax error in part "'+e.token+'"')}for(;x.isAlpha(S(e),C(e),_(e))||x.isDigit(S(e));)e.token+=S(e),A(e);Object(ae.f)(O,e.token)?e.tokenType=w.DELIMITER:e.tokenType=w.SYMBOL}}else e.tokenType=w.DELIMITER}function q(e){for(;T(e),"\n"===e.token;);}function I(e){e.nestingLevel++}function B(e){e.nestingLevel--}function k(e,t){var r={extraNodes:{},expression:"",comment:"",index:0,token:"",tokenType:w.NULL,nestingLevel:0,conditionalLevel:null};is(r,{expression:e,extraNodes:t}),T(r);t=function(e){var t,r,n=[];""!==e.token&&"\n"!==e.token&&";"!==e.token&&((t=z(e)).comment=e.comment);for(;"\n"===e.token||";"===e.token;)0===n.length&&t&&(r=";"!==e.token,n.push({node:t,visible:r})),T(e),"\n"!==e.token&&";"!==e.token&&""!==e.token&&((t=z(e)).comment=e.comment,r=";"!==e.token,n.push({node:t,visible:r}));return 0<n.length?new a(n):(t||((t=new l(void 0)).comment=e.comment),t)}(r);if(""!==r.token)throw r.tokenType===w.DELIMITER?ne(r,"Unexpected operator "+r.token):re(r,'Unexpected part "'+r.token+'"');return t}function z(e){var t,r,n,i,a=function(e){var t=function(e){var t=D(e);for(;"or"===e.token;)q(e),t=new y("or","or",[t,D(e)]);return t}(e);for(;"?"===e.token;){var r=e.conditionalLevel;e.conditionalLevel=e.nestingLevel,q(e);var n=t,i=z(e);if(":"!==e.token)throw re(e,"False part of conditional expression expected");e.conditionalLevel=null,q(e);var a=z(e);t=new f(n,i,a),e.conditionalLevel=r}return t}(e);if("="!==e.token)return a;if(Object(ie.J)(a))return t=a.name,q(e),n=z(e),new o(new v(t),n);if(Object(ie.a)(a))return q(e),n=z(e),new o(a.object,a.index,n);if(Object(ie.r)(a)&&Object(ie.J)(a.fn)&&(i=!0,r=[],t=a.name,a.args.forEach(function(e,t){Object(ie.J)(e)?r[t]=e.name:i=!1}),i))return q(e),n=z(e),new p(t,r,n);throw re(e,"Invalid left hand side of assignment operator =")}function D(e){for(var t=R(e);"xor"===e.token;)q(e),t=new y("xor","xor",[t,R(e)]);return t}function R(e){for(var t=U(e);"and"===e.token;)q(e),t=new y("and","and",[t,U(e)]);return t}function U(e){for(var t=P(e);"|"===e.token;)q(e),t=new y("|","bitOr",[t,P(e)]);return t}function P(e){for(var t=F(e);"^|"===e.token;)q(e),t=new y("^|","bitXor",[t,F(e)]);return t}function F(e){for(var t=L(e);"&"===e.token;)q(e),t=new y("&","bitAnd",[t,L(e)]);return t}function L(e){for(var t=[H(e)],r=[],n={"==":"equal","!=":"unequal","<":"smaller",">":"larger","<=":"smallerEq",">=":"largerEq"};Object(ae.f)(n,e.token);){var i={name:e.token,fn:n[e.token]};r.push(i),q(e),t.push(H(e))}return 1===t.length?t[0]:2===t.length?new y(r[0].name,r[0].fn,t):new b(r.map(function(e){return e.fn}),t)}function H(e){for(var t,r,n,i=$(e),a={"<<":"leftShift",">>":"rightArithShift",">>>":"rightLogShift"};Object(ae.f)(a,e.token);)r=a[t=e.token],q(e),n=[i,$(e)],i=new y(t,r,n);return i}function $(e){for(var t,r,n,i=G(e),a={to:"to",in:"to"};Object(ae.f)(a,e.token);)r=a[t=e.token],q(e),i="in"===t&&""===e.token?new y("*","multiply",[i,new v("in")],!0):(n=[i,G(e)],new y(t,r,n));return i}function G(e){var t=[],r=":"===e.token?new l(1):V(e);if(":"===e.token&&e.conditionalLevel!==e.nestingLevel){for(t.push(r);":"===e.token&&t.length<3;)q(e),")"===e.token||"]"===e.token||","===e.token||""===e.token?t.push(new v("end")):t.push(V(e));r=3===t.length?new n(t[0],t[2],t[1]):new n(t[0],t[1])}return r}function V(e){for(var t,r,n,i=Z(e),a={"+":"add","-":"subtract"};Object(ae.f)(a,e.token);)r=a[t=e.token],q(e),n=[i,Z(e)],i=new y(t,r,n);return i}function Z(e){for(var t,r,n,i=J(e),a={"*":"multiply",".*":"dotMultiply","/":"divide","./":"dotDivide","%":"mod",mod:"mod"};Object(ae.f)(a,e.token);)r=a[t=e.token],q(e),n=J(e),i=new y(t,r,[i,n]);return i}function J(e){for(var t=W(e),r=t;e.tokenType===w.SYMBOL||"in"===e.token&&Object(ie.l)(t)||!(e.tokenType!==w.NUMBER||Object(ie.l)(r)||Object(ie.B)(r)&&"!"!==r.op)||"("===e.token;)r=W(e),t=new y("*","multiply",[t,r],!0);return t}function W(e){for(var t=Y(e),r=t,n=[];"/"===e.token&&Object(ie.l)(r);){if(n.push(is({},e)),q(e),e.tokenType!==w.NUMBER){is(e,n.pop());break}if(n.push(is({},e)),q(e),e.tokenType!==w.SYMBOL&&"("!==e.token){n.pop(),is(e,n.pop());break}is(e,n.pop()),n.pop(),r=Y(e),t=new y("/","divide",[t,r])}return t}function Y(e){var t,r,n={"-":"unaryMinus","+":"unaryPlus","~":"bitNot",not:"not"};return Object(ae.f)(n,e.token)?(r=n[e.token],t=e.token,q(e),n=[Y(e)],new y(t,r,n)):function(e){var t,r,n;t=function(e){var t,r,n;t=function(e){var t=[];if(e.tokenType===w.SYMBOL&&Object(ae.f)(e.extraNodes,e.token)){var r=e.extraNodes[e.token];if(T(e),"("===e.token){if(t=[],I(e),T(e),")"!==e.token)for(t.push(z(e));","===e.token;)T(e),t.push(z(e));if(")"!==e.token)throw re(e,"Parenthesis ) expected");B(e),T(e)}return new r(t)}return function(e){var t;if(e.tokenType===w.SYMBOL||e.tokenType===w.DELIMITER&&e.token in O)return t=e.token,T(e),t=Object(ae.f)(M,t)?new l(M[t]):-1!==j.indexOf(t)?new l(s(t,"number")):new v(t),t=X(e,t);return function(e){var t;return'"'!==e.token?function(e){var t;return"'"!==e.token?function(e){var t,r,n,i;if("["!==e.token)return function(e){if("{"!==e.token)return function(e){var t;return e.tokenType!==w.NUMBER?function(e){var t;if("("!==e.token)return function(e){throw""===e.token?re(e,"Unexpected end of expression"):re(e,"Value expected")}(e);if(I(e),T(e),t=z(e),")"===e.token)return B(e),T(e),t=new g(t),t=X(e,t);throw re(e,"Parenthesis ) expected")}(e):(t=e.token,T(e),new l(s(t,u.number)))}(e);var t;I(e);var r={};do{if(T(e),"}"!==e.token){if('"'===e.token)t=Q(e);else if("'"===e.token)t=K(e);else{if(!(e.tokenType===w.SYMBOL||e.tokenType===w.DELIMITER&&e.token in O))throw re(e,"Symbol or string expected as object key");t=e.token,T(e)}if(":"!==e.token)throw re(e,"Colon : expected after object key");T(e),r[t]=z(e)}}while(","===e.token);if("}"!==e.token)throw re(e,"Comma , or bracket } expected after object value");B(e),T(e);var n=new d(r);return n=X(e,n)}(e);if(I(e),T(e),"]"!==e.token){var a=ee(e);if(";"===e.token){for(n=1,r=[a];";"===e.token;)T(e),r[n]=ee(e),n++;if("]"!==e.token)throw re(e,"End of matrix ] expected");B(e),T(e),i=r[0].items.length;for(var o=1;o<n;o++)if(r[o].items.length!==i)throw ne(e,"Column dimensions mismatch ("+r[o].items.length+" !== "+i+")");t=new c(r)}else{if("]"!==e.token)throw re(e,"End of matrix ] expected");B(e),T(e),t=a}}else B(e),T(e),t=new c([]);return X(e,t)}(e):(t=K(e),t=new l(t),t=X(e,t))}(e):(t=Q(e),t=new l(t),t=X(e,t))}(e)}(e)}(e);var i={"!":"factorial","'":"ctranspose"};for(;Object(ae.f)(i,e.token);)r=e.token,n=i[r],T(e),t=new y(r,n,[t]),t=X(e,t);return t}(e),"^"!==e.token&&".^"!==e.token||(r=e.token,n="^"===r?"pow":"dotPow",q(e),e=[t,Y(e)],t=new y(r,n,e));return t}(e)}function X(e,t,r){for(var n;!("("!==e.token&&"["!==e.token&&"."!==e.token||r&&-1===r.indexOf(e.token));)if(n=[],"("===e.token){if(!Object(ie.J)(t)&&!Object(ie.a)(t))return t;if(I(e),T(e),")"!==e.token)for(n.push(z(e));","===e.token;)T(e),n.push(z(e));if(")"!==e.token)throw re(e,"Parenthesis ) expected");B(e),T(e),t=new m(t,n)}else if("["===e.token){if(I(e),T(e),"]"!==e.token)for(n.push(z(e));","===e.token;)T(e),n.push(z(e));if("]"!==e.token)throw re(e,"Parenthesis ] expected");B(e),T(e),t=new i(t,new h(n))}else{if(T(e),e.tokenType!==w.SYMBOL)throw re(e,"Property name expected after dot");n.push(new l(e.token)),T(e);t=new i(t,new h(n,!0))}return t}function Q(e){for(var t="";""!==S(e)&&'"'!==S(e);)"\\"===S(e)&&(t+=S(e),A(e)),t+=S(e),A(e);if(T(e),'"'!==e.token)throw re(e,'End of string " expected');return T(e),JSON.parse('"'+t+'"')}function K(e){for(var t="";""!==S(e)&&"'"!==S(e);)"\\"===S(e)&&(t+=S(e),A(e)),t+=S(e),A(e);if(T(e),"'"!==e.token)throw re(e,"End of string ' expected");return T(e),JSON.parse('"'+t+'"')}function ee(e){for(var t=[z(e)],r=1;","===e.token;)T(e),t[r]=z(e),r++;return new c(t)}function te(e){return e.index-e.token.length+1}function re(e,t){e=te(e),t=new SyntaxError(t+" (char "+e+")");return t.char=e,t}function ne(e,t){e=te(e),t=new SyntaxError(t+" (char "+e+")");return t.char=e,t}return x.isAlpha=function(e,t,r){return x.isValidLatinOrGreek(e)||x.isValidMathSymbol(e,r)||x.isValidMathSymbol(t,e)},x.isValidLatinOrGreek=function(e){return/^[a-zA-Z_$\u00C0-\u02AF\u0370-\u03FF\u2100-\u214F]$/.test(e)},x.isValidMathSymbol=function(e,t){return/^[\uD835]$/.test(e)&&/^[\uDC00-\uDFFF]$/.test(t)&&/^[^\uDC55\uDC9D\uDCA0\uDCA1\uDCA3\uDCA4\uDCA7\uDCA8\uDCAD\uDCBA\uDCBC\uDCC4\uDD06\uDD0B\uDD0C\uDD15\uDD1D\uDD3A\uDD3F\uDD45\uDD47-\uDD49\uDD51\uDEA6\uDEA7\uDFCC\uDFCD]$/.test(t)},x.isWhitespace=function(e,t){return" "===e||"\t"===e||"\n"===e&&0<t},x.isDecimalMark=function(e,t){return"."===e&&"/"!==t&&"*"!==t&&"^"!==t},x.isDigitDot=function(e){return"0"<=e&&e<="9"||"."===e},x.isDigit=function(e){return"0"<=e&&e<="9"},x.isHexDigit=function(e){return"0"<=e&&e<="9"||"a"<=e&&e<="f"||"A"<=e&&e<="F"},x}),os="compile",t=["typed","parse"],ss=Object(a.a)(os,t,function(e){var t=e.typed,r=e.parse;return t(os,{string:function(e){return r(e).compile()},"Array | Matrix":function(e){return oe(e,function(e){return r(e).compile()})}})}),us="evaluate",n=["typed","parse"],cs=Object(a.a)(us,n,function(e){var t=e.typed,r=e.parse;return t(us,{string:function(e){return r(e).compile().evaluate({})},"string, Object":function(e,t){return r(e).compile().evaluate(t)},"Array | Matrix":function(e){var t={};return oe(e,function(e){return r(e).compile().evaluate(t)})},"Array | Matrix, Object":function(e,t){return oe(e,function(e){return r(e).compile().evaluate(t)})}})}),t=["parse"],fs=Object(a.a)("Parser",t,function(e){var t=e.parse;function r(){if(!(this instanceof r))throw new SyntaxError("Constructor must be called with the new operator");this.scope={}}return r.prototype.type="Parser",r.prototype.isParser=!0,r.prototype.evaluate=function(e){return t(e).compile().evaluate(this.scope)},r.prototype.get=function(e){return e in this.scope?Wr(this.scope,e):void 0},r.prototype.getAll=function(){return Object(ae.e)({},this.scope)},r.prototype.set=function(e,t){return Yr(this.scope,e,t)},r.prototype.remove=function(e){delete this.scope[e]},r.prototype.clear=function(){for(var e in this.scope)Object(ae.f)(this.scope,e)&&delete this.scope[e]},r},{isClass:!0}),n=["typed","Parser"],ls=Object(a.a)("parser",n,function(e){var t=e.typed,r=e.Parser;return t("parser",{"":function(){return new r}})}),t=["typed","matrix","abs","addScalar","divideScalar","multiplyScalar","subtract","larger","equalScalar","unaryMinus","DenseMatrix","SparseMatrix","Spa"],ps=Object(a.a)("lup",t,function(e){var t=e.typed,r=e.matrix,E=e.abs,w=e.addScalar,S=e.divideScalar,A=e.multiplyScalar,N=e.subtract,C=e.larger,_=e.equalScalar,T=e.unaryMinus,O=e.DenseMatrix,q=e.SparseMatrix,I=e.Spa;return t("lup",{DenseMatrix:n,SparseMatrix:function(e){var c,f,l,p=e._size[0],t=e._size[1],r=Math.min(p,t),m=e._values,h=e._index,d=e._ptr,y=[],g=[],b=[],v=[p,r],x=[],w=[],N=[],O=[r,t],M=[],j=[];for(c=0;c<p;c++)M[c]=c,j[c]=c;function n(){var i=new I;f<p&&(b.push(y.length),y.push(1),g.push(f)),N.push(x.length);var e=d[f],t=d[f+1];for(l=e;l<t;l++)c=h[l],i.set(M[c],m[l]);0<f&&i.forEach(0,f-1,function(r,n){q._forEachRow(r,y,g,b,function(e,t){r<e&&i.accumulate(e,T(A(t,n)))})});var r,n,a,o=f,s=i.get(f),u=E(s);i.forEach(f+1,p-1,function(e,t){var r=E(t);C(r,u)&&(o=e,u=r,s=t)}),f!==o&&(q._swapRows(f,o,v[1],y,g,b),q._swapRows(f,o,O[1],x,w,N),i.swap(f,o),n=o,a=j[r=f],e=j[n],M[a]=n,M[e]=r,j[r]=e,j[n]=a),i.forEach(0,p-1,function(e,t){e<=f?(x.push(t),w.push(e)):(t=S(t,s),_(t,0)||(y.push(t),g.push(e)))})}for(f=0;f<t;f++)n();return N.push(x.length),b.push(y.length),{L:new q({values:y,index:g,ptr:b,size:v}),U:new q({values:x,index:w,ptr:N,size:O}),p:M,toString:function(){return"L: "+this.L.toString()+"\nU: "+this.U.toString()+"\nP: "+this.p}}},Array:function(e){e=n(r(e));return{L:e.L.valueOf(),U:e.U.valueOf(),p:e.p}}});function n(e){var t,r=e._size[0],n=e._size[1],i=Math.min(r,n),a=Object(ae.a)(e._data),o=[],s=[r,i],u=[],e=[i,n],c=[];for(y=0;y<r;y++)c[y]=y;for(t=0;t<n;t++){if(0<t)for(y=0;y<r;y++){for(var f=Math.min(y,t),l=0,p=0;p<f;p++)l=w(l,A(a[y][p],a[p][t]));a[y][t]=N(a[y][t],l)}for(var m=t,h=0,d=0,y=t;y<r;y++){var g=a[y][t],b=E(g);C(b,h)&&(m=y,h=b,d=g)}if(t!==m&&(c[t]=[c[m],c[m]=c[t]][0],O._swapRows(t,m,a)),t<r)for(y=t+1;y<r;y++){var v=a[y][t];_(v,0)||(a[y][t]=S(a[y][t],d))}}for(t=0;t<n;t++)for(y=0;y<r;y++)0===t&&(y<n&&(u[y]=[]),o[y]=[]),y<t?(y<n&&(u[y][t]=a[y][t]),t<r&&(o[y][t]=0)):y!==t?(y<n&&(u[y][t]=0),t<r&&(o[y][t]=a[y][t])):(y<n&&(u[y][t]=a[y][t]),t<r&&(o[y][t]=1));var s=new O({data:o,size:s}),e=new O({data:u,size:e}),x=[];for(y=0,i=c.length;y<i;y++)x[c[y]]=y;return{L:s,U:e,p:x,toString:function(){return"L: "+this.L.toString()+"\nU: "+this.U.toString()+"\nP: "+this.p}}}});function ms(){return(ms=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var r,n=arguments[t];for(r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e}).apply(this,arguments)}var n=["typed","matrix","zeros","identity","isZero","equal","sign","sqrt","conj","unaryMinus","addScalar","divideScalar","multiplyScalar","subtract","complex"],hs=Object(a.a)("qr",n,function(e){var t=e.typed,r=e.matrix,g=e.zeros,b=e.identity,v=e.isZero,x=e.equal,w=e.sign,N=e.sqrt,O=e.conj,M=e.unaryMinus,j=e.addScalar,E=e.divideScalar,S=e.multiplyScalar,A=e.subtract,o=e.complex;return ms(t("qr",{DenseMatrix:n,SparseMatrix:function(){throw new Error("qr not implemented for sparse matrices yet")},Array:function(e){e=n(r(e));return{Q:e.Q.valueOf(),R:e.R.valueOf()}}}),{_denseQRimpl:s});function s(e){for(var t=e._size[0],r=e._size[1],n=b([t],"dense"),i=n._data,e=e.clone(),a=e._data,o=g([t],""),s=0;s<Math.min(r,t);++s){var u=a[s][s],c=M(x(u,0)?1:w(u)),f=O(c),l=0;for(m=s;m<t;m++)l=j(l,S(a[m][s],O(a[m][s])));c=S(c,N(l));if(!v(c)){for(var p=A(u,c),m=s+(o[s]=1);m<t;m++)o[m]=E(a[m][s],p);for(var h=M(O(E(p,c))),d=void 0,y=s;y<r;y++){for(d=0,m=s;m<t;m++)d=j(d,S(O(o[m]),a[m][y]));for(d=S(d,h),m=s;m<t;m++)a[m][y]=S(A(a[m][y],S(o[m],d)),f)}for(m=0;m<t;m++){for(d=0,y=s;y<t;y++)d=j(d,S(i[m][y],o[y]));for(d=S(d,h),y=s;y<t;++y)i[m][y]=E(A(i[m][y],S(d,O(o[y]))),f)}}}return{Q:n,R:e,toString:function(){return"Q: "+this.Q.toString()+"\nR: "+this.R.toString()}}}function n(e){var t=s(e),r=t.R._data;if(0<e._data.length)for(var n="Complex"===r[0][0].type?o(0):0,i=0;i<r.length;++i)for(var a=0;a<i&&a<(r[0]||[]).length;++a)r[i][a]=n;return t}});function ds(e,t,r,n,i,a,o){var s=0;for(r[o]=e;0<=s;){var u=r[o+s],c=r[n+u];-1===c?(s--,a[t++]=u):(r[n+u]=r[i+c],r[o+ ++s]=c)}return t}var t=["add","multiply","transpose"],ys=Object(a.a)("csAmd",t,function(e){var X=e.add,Q=e.multiply,K=e.transpose;return function(e,t){if(!t||e<=0||3<e)return null;var r=t._size,n=r[0],i=r[1],a=0,r=Math.max(16,10*Math.sqrt(i)),n=function(e,t,r,n,i){var a=K(t);if(1===e&&n===r)return X(t,a);if(2!==e)return Q(a,t);for(var o=a._index,s=a._ptr,u=0,c=0;c<r;c++){var f=s[c];if(s[c]=u,!(s[c+1]-f>i))for(var l=s[c+1];f<l;f++)o[u++]=o[f]}return s[r]=u,t=K(a),Q(a,t)}(e,t,n,i,r=Math.min(i-2,r));!function(e,t,r){for(var n=e._values,i=e._index,a=e._ptr,o=e._size[1],s=0,u=0;u<o;u++){var c=a[u];for(a[u]=s;c<a[u+1];c++)t(i[c],u,n?n[c]:1,r)&&(i[s]=i[c],n&&(n[s]=n[c]),s++)}a[o]=s,i.splice(s,i.length-s),n&&n.splice(s,n.length-s)}(n,te,null);for(var o,s,u,c,f,l,p,m,h,d,y,g,b=n._index,v=n._ptr,x=v[i],w=[],N=[],O=i+1,M=2*(i+1),j=3*(i+1),E=4*(i+1),S=5*(i+1),A=6*(i+1),C=7*(i+1),_=w,T=function(e,t,r,n,i,a,o,s,u,c,f,l){for(var p=0;p<e;p++)r[n+p]=t[p+1]-t[p];for(var m=r[n+e]=0;m<=e;m++)r[i+m]=-1,a[m]=-1,r[o+m]=-1,r[s+m]=-1,r[u+m]=1,r[c+m]=1,r[f+m]=0,r[l+m]=r[n+m];var h=ee(0,0,r,c,e);return r[f+e]=-2,t[e]=-1,r[c+e]=0,h}(i,v,N,0,j,_,M,C,O,A,E,S),q=function(e,t,r,n,i,a,o,s,u,c,f){for(var l=0,p=0;p<e;p++){var m,h=r[n+p];0===h?(r[i+p]=-2,l++,t[p]=-1,r[a+p]=0):o<h?(r[s+p]=0,r[i+p]=-1,l++,t[p]=-e-2,r[s+e]++):(-1!==(m=r[u+h])&&(c[m]=p),r[f+p]=r[u+h],r[u+h]=p)}return l}(i,v,N,S,E,A,r,O,j,_,M),I=0;q<i;){for(s=-1;I<i&&-1===(s=N[j+I]);I++);-1!==N[M+s]&&(_[N[M+s]]=-1),N[j+I]=N[M+s];var B=N[E+s],k=N[O+s];q+=k;var z=0;N[O+s]=-k;for(var D,R,U=v[s],P=0===B?U:x,F=P,L=1;L<=B+1;L++){for(f=B<L?(c=U,N[0+(R=s)]-B):(c=v[R=b[U++]],N[0+R]),u=1;u<=f;u++)(l=N[O+(o=b[c++])])<=0||(z+=l,N[O+o]=-l,-1!==N[M+(b[F++]=o)]&&(_[N[M+o]]=_[o]),-1!==_[o]?N[M+_[o]]=N[M+o]:N[j+N[S+o]]=N[M+o]);R!==s&&(v[R]=-s-2,N[A+R]=0)}for(0!==B&&(x=F),N[S+s]=z,v[s]=P,N[0+s]=F-P,N[E+s]=-2,T=ee(T,a,N,A,i),p=P;p<F;p++)if(!((m=N[E+(o=b[p])])<=0))for(var H=T-(l=-N[O+o]),U=v[o],$=v[o]+m-1;U<=$;U++)N[A+(R=b[U])]>=T?N[A+R]-=l:0!==N[A+R]&&(N[A+R]=N[S+R]+H);for(p=P;p<F;p++){for(h=($=v[o=b[p]])+N[E+o]-1,g=y=0,U=d=$;U<=h;U++)0!==N[A+(R=b[U])]&&(0<(D=N[A+R]-T)?(g+=D,y+=b[d++]=R):(v[R]=-s-2,N[A+R]=0));N[E+o]=d-$+1;var G=d,V=$+N[0+o];for(U=1+h;U<V;U++){var Z=N[O+(W=b[U])];Z<=0||(g+=Z,y+=b[d++]=W)}0===g?(v[o]=-s-2,z-=l=-N[O+o],k+=l,q+=l,N[O+o]=0,N[E+o]=-1):(N[S+o]=Math.min(N[S+o],g),b[d]=b[G],b[G]=b[$],b[$]=s,N[0+o]=d-$+1,y=(y<0?-y:y)%i,N[M+o]=N[C+y],_[N[C+y]=o]=y)}for(N[S+s]=z,T=ee(T+(a=Math.max(a,z)),a,N,A,i),p=P;p<F;p++)if(!(0<=N[O+(o=b[p])]))for(o=N[C+(y=_[o])],N[C+y]=-1;-1!==o&&-1!==N[M+o];o=N[M+o],T++){for(f=N[0+o],m=N[E+o],U=v[o]+1;U<=v[o]+f-1;U++)N[A+b[U]]=T;for(var J=o,W=N[M+o];-1!==W;){var Y=N[0+W]===f&&N[E+W]===m;for(U=v[W]+1;Y&&U<=v[W]+f-1;U++)N[A+b[U]]!==T&&(Y=0);Y?(v[W]=-o-2,N[O+o]+=N[O+W],N[O+W]=0,N[E+W]=-1,W=N[M+W],N[M+J]=W):W=N[M+(J=W)]}}for(p=U=P;p<F;p++)(l=-N[O+(o=b[p])])<=0||(N[O+o]=l,g=N[S+o]+z-l,-1!==N[j+(g=Math.min(g,i-q-l))]&&(_[N[j+g]]=o),N[M+o]=N[j+g],_[o]=-1,N[j+g]=o,I=Math.min(I,g),N[S+o]=g,b[U++]=o);N[O+s]=k,0==(N[0+s]=U-P)&&(v[s]=-1,N[A+s]=0),0!==B&&(x=U)}for(o=0;o<i;o++)v[o]=-v[o]-2;for(W=0;W<=i;W++)N[j+W]=-1;for(W=i;0<=W;W--)0<N[O+W]||(N[M+W]=N[j+v[W]],N[j+v[W]]=W);for(R=i;0<=R;R--)N[O+R]<=0||-1!==v[R]&&(N[M+R]=N[j+v[R]],N[j+v[R]]=R);for(o=s=0;o<=i;o++)-1===v[o]&&(s=ds(o,s,N,j,M,w,A));return w.splice(w.length-1,1),w};function ee(e,t,r,n,i){if(e<2||e+t<0){for(var a=0;a<i;a++)0!==r[n+a]&&(r[n+a]=1);e=2}return e}function te(e,t){return e!==t}});var n=["transpose"],gs=Object(a.a)("csCounts",n,function(e){var j=e.transpose;return function(e,t,r,n){if(!e||!t||!r)return null;for(var i,a,o,s,u,c,f=e._size,l=f[0],p=f[1],m=4*p+(n?p+l+1:0),h=[],d=p,y=2*p,g=3*p,b=4*p,v=5*p+1,x=0;x<m;x++)h[x]=-1;var w=[],e=j(e),N=e._index,O=e._ptr;for(x=0;x<p;x++)for(w[a=r[x]]=-1===h[g+a]?1:0;-1!==a&&-1===h[g+a];a=t[a])h[g+a]=x;if(n){for(x=0;x<p;x++)h[r[x]]=x;for(i=0;i<l;i++){for(x=p,u=O[i],c=O[i+1],s=u;s<c;s++)x=Math.min(x,h[N[s]]);h[v+i]=h[b+x],h[b+x]=i}}for(i=0;i<p;i++)h[0+i]=i;for(x=0;x<p;x++){for(-1!==t[a=r[x]]&&w[t[a]]--,o=n?h[b+x]:a;-1!==o;o=n?h[v+o]:-1)for(s=O[o];s<O[o+1];s++){var M=function(e,t,r,n,i,a,o){var s,u,c,f=0;if(e<=t||r[n+t]<=r[i+e])return-1;if(r[i+e]=r[n+t],n=r[a+e],r[a+e]=t,-1===n)f=1,c=e;else{for(f=2,c=n;c!==r[o+c];c=r[o+c]);for(s=n;s!==c;s=u)u=r[o+s],r[o+s]=c}return{jleaf:f,q:c}}(i=N[s],a,h,g,d,y,0);1<=M.jleaf&&w[a]++,2===M.jleaf&&w[M.q]--}-1!==t[a]&&(h[0+a]=t[a])}for(a=0;a<p;a++)-1!==t[a]&&(w[t[a]]+=w[a]);return w}}),t=["add","multiply","transpose"],bs=Object(a.a)("csSqr",t,function(e){var t=e.add,r=e.multiply,e=e.transpose,s=ys({add:t,multiply:r,transpose:e}),u=gs({transpose:e});return function(e,t,r){var n,i=t._ptr,a=t._size[1],o={};if(o.q=s(e,t),e&&!o.q)return null;if(r){e=e?function(e,t,r,n){for(var i=e._values,a=e._index,o=e._ptr,s=e._size,u=e._datatype,c=s[0],f=s[1],l=n&&e._values?[]:null,p=[],m=[],h=0,d=0;d<f;d++){m[d]=h;for(var y=r?r[d]:d,g=o[y],b=o[y+1],v=g;v<b;v++){var x=t?t[a[v]]:a[v];p[h]=x,l&&(l[h]=i[v]),h++}}return m[f]=h,e.createSparseMatrix({values:l,index:p,ptr:m,size:[c,f],datatype:u})}(t,null,o.q,0):t;o.parent=function(e,t){if(!e)return null;var r,n=e._index,i=e._ptr,a=(e=e._size)[0],o=e[1],s=[],u=[],c=o;if(t)for(d=0;d<a;d++)u[c+d]=-1;for(var f=0;f<o;f++){s[f]=-1,u[0+f]=-1;for(var l=i[f],p=i[f+1],m=l;m<p;m++){for(var h=n[m],d=t?u[c+h]:h;-1!==d&&d<f;d=r)r=u[0+d],u[0+d]=f,-1===r&&(s[d]=f);t&&(u[c+h]=f)}}return s}(e,1);t=function(e,t){if(!e)return null;for(var r=0,n=[],i=[],a=t,o=2*t,s=0;s<t;s++)i[0+s]=-1;for(s=t-1;0<=s;s--)-1!==e[s]&&(i[a+s]=i[0+e[s]],i[0+e[s]]=s);for(s=0;s<t;s++)-1===e[s]&&(r=ds(s,r,i,0,a,n,o));return n}(o.parent,a);if(o.cp=u(e,o.parent,t,1),e&&o.parent&&o.cp&&function(e,t){var r=e._ptr,n=e._index,e=e._size,i=e[0],a=e[1];t.pinv=[],t.leftmost=[];var o,s,u,c,f,l=t.parent,p=t.pinv,m=t.leftmost,h=[],d=i,y=i+a,g=i+2*a;for(s=0;s<a;s++)h[d+s]=-1,h[y+s]=-1,h[g+s]=0;for(o=0;o<i;o++)m[o]=-1;for(s=a-1;0<=s;s--)for(c=r[s],f=r[s+1],u=c;u<f;u++)m[n[u]]=s;for(o=i-1;0<=o;o--)(p[o]=-1)!==(s=m[o])&&(0==h[g+s]++&&(h[y+s]=o),h[0+o]=h[d+s],h[d+s]=o);for(t.lnz=0,t.m2=i,s=0;s<a;s++){var b;o=h[d+s],t.lnz++,o<0&&(o=t.m2++),p[o]=s,--g[s]<=0||(t.lnz+=h[g+s],-1!==(b=l[s])&&(0===h[g+b]&&(h[y+b]=h[y+s]),h[0+h[y+s]]=h[d+b],h[d+b]=h[0+o],h[g+b]+=h[g+s]))}for(o=0;o<i;o++)p[o]<0&&(p[o]=s++);return!0}(e,o))for(n=o.unz=0;n<a;n++)o.unz+=o.cp[n]}else o.unz=4*i[a]+a,o.lnz=o.unz;return o}});function vs(e,t){e[t]=-e[t]-2}function xs(e){return e<0?-e-2:e}function ws(e,t,r,n,i){for(var a=e._ptr,o=e._size,s=t._index,t=t._ptr,u=o[1],c=u,o=t[r],f=t[r+1],l=o;l<f;l++){var p=s[l];a[p]<0||(c=function(e,t,r,n,i){var a,o=t._index,s=t._ptr,u=t._size[1],c=0;for(n[0]=e;0<=c;){e=n[c];var f=i?i[e]:e;s[e]<0||(vs(s,e),n[u+c]=f<0?0:xs(s[f]));for(var l=1,p=n[u+c],m=f<0?0:xs(s[f+1]);p<m;p++)if(!(s[a=o[p]]<0)){n[u+c]=p,n[++c]=a,l=0;break}l&&(c--,n[--r]=e)}return r}(p,e,c,n,i))}for(l=c;l<u;l++)vs(a,n[l]);return c}var n=["divideScalar","multiply","subtract"],Ns=Object(a.a)("csSpsolve",n,function(e){var N=e.divideScalar,O=e.multiply,M=e.subtract;return function(e,t,r,n,i,a,o){for(var s,u,c,f=e._values,l=e._index,p=e._ptr,m=e._size[1],h=t._values,d=t._index,y=t._ptr,t=ws(e,t,r,n,a),g=t;g<m;g++)i[n[g]]=0;for(s=y[r],u=y[r+1],g=s;g<u;g++)i[d[g]]=h[g];for(var b=t;b<m;b++){var v=n[b],x=a?a[v]:v;if(!(x<0))for(s=p[x],u=p[x+1],i[v]=N(i[v],f[o?s:u-1]),g=o?s+1:s,c=o?u:u-1;g<c;g++){var w=l[g];i[w]=M(i[w],O(f[g],i[v]))}}return t}}),t=["abs","divideScalar","multiply","subtract","larger","largerEq","SparseMatrix"],Os=Object(a.a)("csLu",t,function(e){var E=e.abs,S=e.divideScalar,A=e.multiply,t=e.subtract,C=e.larger,_=e.largerEq,T=e.SparseMatrix,q=Ns({divideScalar:S,multiply:A,subtract:t});return function(e,t,r){if(!e)return null;var n,i=e._size[1],a=100,o=100;t&&(n=t.q,a=t.lnz||a,o=t.unz||o);var s=[],u=[],c=[],f=new T({values:s,index:u,ptr:c,size:[i,i]}),l=[],p=[],m=[],t=new T({values:l,index:p,ptr:m,size:[i,i]}),h=[],d=[],y=[];for(v=0;v<i;v++)d[v]=0,h[v]=-1,c[v+1]=0;for(var g=o=a=0;g<i;g++){c[g]=a,m[g]=o;for(var b,v,x=n?n[g]:g,w=q(f,e,x,y,d,h,1),N=-1,O=-1,M=w;M<i;M++)h[v=y[M]]<0?(b=E(d[v]),C(b,O)&&(O=b,N=v)):(p[o]=h[v],l[o++]=d[v]);if(-1===N||O<=0)return null;h[x]<0&&_(E(d[x]),A(O,r))&&(N=x);var j=d[N];for(p[o]=g,l[o++]=j,h[N]=g,u[a]=N,s[a++]=1,M=w;M<i;M++)h[v=y[M]]<0&&(u[a]=v,s[a++]=S(d[v],j)),d[v]=0}for(c[i]=a,m[i]=o,M=0;M<a;M++)u[M]=h[u[M]];return s.splice(a,s.length-a),u.splice(a,u.length-a),l.splice(o,l.length-o),p.splice(o,p.length-o),{L:f,U:t,pinv:h}}}),n=["typed","abs","add","multiply","transpose","divideScalar","subtract","larger","largerEq","SparseMatrix"],Ms=Object(a.a)("slu",n,function(e){var t=e.typed,r=e.abs,n=e.add,i=e.multiply,a=e.transpose,o=e.divideScalar,s=e.subtract,u=e.larger,c=e.largerEq,e=e.SparseMatrix,f=bs({add:n,multiply:i,transpose:a}),l=Os({abs:r,divideScalar:o,multiply:i,subtract:s,larger:u,largerEq:c,SparseMatrix:e});return t("slu",{"SparseMatrix, number, number":function(e,t,r){if(!Object(N.i)(t)||t<0||3<t)throw new Error("Symbolic Ordering and Analysis order must be an integer number in the interval [0, 3]");if(r<0||1<r)throw new Error("Partial pivoting threshold must be a number from 0 to 1");t=f(t,e,!1),r=l(e,t,r);return{L:r.L,U:r.U,p:r.pinv,q:t.q,toString:function(){return"L: "+this.L.toString()+"\nU: "+this.U.toString()+"\np: "+this.p.toString()+(this.q?"\nq: "+this.q.toString():"")+"\n"}}}})});function js(e,t){var r,n=t.length,i=[];if(e)for(r=0;r<n;r++)i[e[r]]=t[r];else for(r=0;r<n;r++)i[r]=t[r];return i}var Es="lusolve",t=["typed","matrix","lup","slu","usolve","lsolve","DenseMatrix"],Ss=Object(a.a)(Es,t,function(e){var t=e.typed,r=e.matrix,n=e.lup,i=e.slu,a=e.usolve,o=e.lsolve,s=Wn({DenseMatrix:e.DenseMatrix});return t(Es,{"Array, Array | Matrix":function(e,t){e=r(e);e=n(e);return c(e.L,e.U,e.p,null,t).valueOf()},"DenseMatrix, Array | Matrix":function(e,t){e=n(e);return c(e.L,e.U,e.p,null,t)},"SparseMatrix, Array | Matrix":function(e,t){e=n(e);return c(e.L,e.U,e.p,null,t)},"SparseMatrix, Array | Matrix, number, number":function(e,t,r,n){n=i(e,r,n);return c(n.L,n.U,n.p,n.q,t)},"Object, Array | Matrix":function(e,t){return c(e.L,e.U,e.p,e.q,t)}});function u(e){if(Object(ie.v)(e))return e;if(Object(ie.b)(e))return r(e);throw new TypeError("Invalid Matrix LU decomposition")}function c(e,t,r,n,i){e=u(e),t=u(t),r&&((i=s(e,i,!0))._data=js(r,i._data));i=o(e,i),i=a(t,i);return n&&(i._data=js(n,i._data)),i}}),n=["parse"],As=Object(a.a)("Help",n,function(e){var o=e.parse;function n(e){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if(!e)throw new Error('Argument "doc" missing');this.doc=e}return n.prototype.type="Help",n.prototype.isHelp=!0,n.prototype.toString=function(){var e=this.doc||{},t="\n";if(e.name&&(t+="Name: "+e.name+"\n\n"),e.category&&(t+="Category: "+e.category+"\n\n"),e.description&&(t+="Description:\n    "+e.description+"\n\n"),e.syntax&&(t+="Syntax:\n    "+e.syntax.join("\n    ")+"\n\n"),e.examples){t+="Examples:\n";for(var r={},n=0;n<e.examples.length;n++){var i=e.examples[n];t+="    "+i+"\n";var a=void 0;try{a=o(i).compile().evaluate(r)}catch(e){a=e}void 0===a||Object(ie.s)(a)||(t+="        "+Object(Z.d)(a,{precision:14})+"\n")}t+="\n"}return e.seealso&&e.seealso.length&&(t+="See also: "+e.seealso.join(", ")+"\n"),t},n.prototype.toJSON=function(){var e=Object(ae.a)(this.doc);return e.mathjs="Help",e},n.fromJSON=function(t){var r={};return Object.keys(t).filter(function(e){return"mathjs"!==e}).forEach(function(e){r[e]=t[e]}),new n(r)},n.prototype.valueOf=n.prototype.toString,n},{isClass:!0}),t=["?on","math"],Cs=Object(a.a)("Chain",t,function(e){var t=e.on,e=e.math;function i(e){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator");Object(ie.h)(e)?this.value=e.value:this.value=e}function a(e,t){Object(ae.h)(i.prototype,e,function(){var e=t();if("function"==typeof e)return o(e)})}function o(r){return function(){for(var e=[this.value],t=0;t<arguments.length;t++)e[t+1]=arguments[t];return new i(r.apply(r,e))}}i.prototype.type="Chain",i.prototype.isChain=!0,i.prototype.done=function(){return this.value},i.prototype.valueOf=function(){return this.value},i.prototype.toString=function(){return Object(Z.d)(this.value)},i.prototype.toJSON=function(){return{mathjs:"Chain",value:this.value}},i.fromJSON=function(e){return new i(e.value)},i.createProxy=function(t,e){if("string"==typeof t)n=t,"function"==typeof(e=e)&&(i.prototype[n]=o(e));else for(var r in t)!function(e){Object(ae.f)(t,e)&&void 0===s[e]&&a(e,function(){return t[e]})}(r);var n};var s={expression:!0,docs:!0,type:!0,classes:!0,json:!0,error:!0,isChain:!0};return i.createProxy(e),t&&t("import",function(e,t,r){r||a(e,t)}),i},{isClass:!0}),n={name:"pi",category:"Constants",syntax:["pi"],description:"The number pi is a mathematical constant that is the ratio of a circle's circumference to its diameter, and is approximately equal to 3.14159",examples:["pi","sin(pi/2)"],seealso:["tau"]},t={name:"e",category:"Constants",syntax:["e"],description:"Euler's number, the base of the natural logarithm. Approximately equal to 2.71828",examples:["e","e ^ 2","exp(2)","log(e)"],seealso:["exp"]},_s={bignumber:{name:"bignumber",category:"Construction",syntax:["bignumber(x)"],description:"Create a big number from a number or string.",examples:["0.1 + 0.2","bignumber(0.1) + bignumber(0.2)",'bignumber("7.2")','bignumber("7.2e500")',"bignumber([0.1, 0.2, 0.3])"],seealso:["boolean","complex","fraction","index","matrix","string","unit"]},boolean:{name:"boolean",category:"Construction",syntax:["x","boolean(x)"],description:"Convert a string or number into a boolean.",examples:["boolean(0)","boolean(1)","boolean(3)",'boolean("true")','boolean("false")',"boolean([1, 0, 1, 1])"],seealso:["bignumber","complex","index","matrix","number","string","unit"]},complex:{name:"complex",category:"Construction",syntax:["complex()","complex(re, im)","complex(string)"],description:"Create a complex number.",examples:["complex()","complex(2, 3)",'complex("7 - 2i")'],seealso:["bignumber","boolean","index","matrix","number","string","unit"]},createUnit:{name:"createUnit",category:"Construction",syntax:["createUnit(definitions)","createUnit(name, definition)"],description:"Create a user-defined unit and register it with the Unit type.",examples:['createUnit("foo")','createUnit("knot", {definition: "0.514444444 m/s", aliases: ["knots", "kt", "kts"]})','createUnit("mph", "1 mile/hour")'],seealso:["unit","splitUnit"]},fraction:{name:"fraction",category:"Construction",syntax:["fraction(num)","fraction(num,den)"],description:"Create a fraction from a number or from a numerator and denominator.",examples:["fraction(0.125)","fraction(1, 3) + fraction(2, 5)"],seealso:["bignumber","boolean","complex","index","matrix","string","unit"]},index:{name:"index",category:"Construction",syntax:["[start]","[start:end]","[start:step:end]","[start1, start 2, ...]","[start1:end1, start2:end2, ...]","[start1:step1:end1, start2:step2:end2, ...]"],description:"Create an index to get or replace a subset of a matrix",examples:["[]","[1, 2, 3]","A = [1, 2, 3; 4, 5, 6]","A[1, :]","A[1, 2] = 50","A[0:2, 0:2] = ones(2, 2)"],seealso:["bignumber","boolean","complex","matrix,","number","range","string","unit"]},matrix:{name:"matrix",category:"Construction",syntax:["[]","[a1, b1, ...; a2, b2, ...]","matrix()",'matrix("dense")',"matrix([...])"],description:"Create a matrix.",examples:["[]","[1, 2, 3]","[1, 2, 3; 4, 5, 6]","matrix()","matrix([3, 4])",'matrix([3, 4; 5, 6], "sparse")','matrix([3, 4; 5, 6], "sparse", "number")'],seealso:["bignumber","boolean","complex","index","number","string","unit","sparse"]},number:{name:"number",category:"Construction",syntax:["x","number(x)","number(unit, valuelessUnit)"],description:"Create a number or convert a string or boolean into a number.",examples:["2","2e3","4.05","number(2)",'number("7.2")',"number(true)","number([true, false, true, true])",'number(unit("52cm"), "m")'],seealso:["bignumber","boolean","complex","fraction","index","matrix","string","unit"]},sparse:{name:"sparse",category:"Construction",syntax:["sparse()","sparse([a1, b1, ...; a1, b2, ...])",'sparse([a1, b1, ...; a1, b2, ...], "number")'],description:"Create a sparse matrix.",examples:["sparse()","sparse([3, 4; 5, 6])",'sparse([3, 0; 5, 0], "number")'],seealso:["bignumber","boolean","complex","index","number","string","unit","matrix"]},splitUnit:{name:"splitUnit",category:"Construction",syntax:["splitUnit(unit: Unit, parts: Unit[])"],description:"Split a unit in an array of units whose sum is equal to the original unit.",examples:['splitUnit(1 m, ["feet", "inch"])'],seealso:["unit","createUnit"]},string:{name:"string",category:"Construction",syntax:['"text"',"string(x)"],description:"Create a string or convert a value to a string",examples:['"Hello World!"',"string(4.2)","string(3 + 2i)"],seealso:["bignumber","boolean","complex","index","matrix","number","unit"]},unit:{name:"unit",category:"Construction",syntax:["value unit","unit(value, unit)","unit(string)"],description:"Create a unit.",examples:["5.5 mm","3 inch",'unit(7.1, "kilogram")','unit("23 deg")'],seealso:["bignumber","boolean","complex","index","matrix","number","string"]},e:t,E:t,false:{name:"false",category:"Constants",syntax:["false"],description:"Boolean value false",examples:["false"],seealso:["true"]},i:{name:"i",category:"Constants",syntax:["i"],description:"Imaginary unit, defined as i*i=-1. A complex number is described as a + b*i, where a is the real part, and b is the imaginary part.",examples:["i","i * i","sqrt(-1)"],seealso:[]},Infinity:{name:"Infinity",category:"Constants",syntax:["Infinity"],description:"Infinity, a number which is larger than the maximum number that can be handled by a floating point number.",examples:["Infinity","1 / 0"],seealso:[]},LN2:{name:"LN2",category:"Constants",syntax:["LN2"],description:"Returns the natural logarithm of 2, approximately equal to 0.693",examples:["LN2","log(2)"],seealso:[]},LN10:{name:"LN10",category:"Constants",syntax:["LN10"],description:"Returns the natural logarithm of 10, approximately equal to 2.302",examples:["LN10","log(10)"],seealso:[]},LOG2E:{name:"LOG2E",category:"Constants",syntax:["LOG2E"],description:"Returns the base-2 logarithm of E, approximately equal to 1.442",examples:["LOG2E","log(e, 2)"],seealso:[]},LOG10E:{name:"LOG10E",category:"Constants",syntax:["LOG10E"],description:"Returns the base-10 logarithm of E, approximately equal to 0.434",examples:["LOG10E","log(e, 10)"],seealso:[]},NaN:{name:"NaN",category:"Constants",syntax:["NaN"],description:"Not a number",examples:["NaN","0 / 0"],seealso:[]},null:{name:"null",category:"Constants",syntax:["null"],description:"Value null",examples:["null"],seealso:["true","false"]},pi:n,PI:n,phi:{name:"phi",category:"Constants",syntax:["phi"],description:"Phi is the golden ratio. Two quantities are in the golden ratio if their ratio is the same as the ratio of their sum to the larger of the two quantities. Phi is defined as `(1 + sqrt(5)) / 2` and is approximately 1.618034...",examples:["phi"],seealso:[]},SQRT1_2:{name:"SQRT1_2",category:"Constants",syntax:["SQRT1_2"],description:"Returns the square root of 1/2, approximately equal to 0.707",examples:["SQRT1_2","sqrt(1/2)"],seealso:[]},SQRT2:{name:"SQRT2",category:"Constants",syntax:["SQRT2"],description:"Returns the square root of 2, approximately equal to 1.414",examples:["SQRT2","sqrt(2)"],seealso:[]},tau:{name:"tau",category:"Constants",syntax:["tau"],description:"Tau is the ratio constant of a circle's circumference to radius, equal to 2 * pi, approximately 6.2832.",examples:["tau","2 * pi"],seealso:["pi"]},true:{name:"true",category:"Constants",syntax:["true"],description:"Boolean value true",examples:["true"],seealso:["false"]},version:{name:"version",category:"Constants",syntax:["version"],description:"A string with the version number of math.js",examples:["version"],seealso:[]},speedOfLight:{description:"Speed of light in vacuum",examples:["speedOfLight"]},gravitationConstant:{description:"Newtonian constant of gravitation",examples:["gravitationConstant"]},planckConstant:{description:"Planck constant",examples:["planckConstant"]},reducedPlanckConstant:{description:"Reduced Planck constant",examples:["reducedPlanckConstant"]},magneticConstant:{description:"Magnetic constant (vacuum permeability)",examples:["magneticConstant"]},electricConstant:{description:"Electric constant (vacuum permeability)",examples:["electricConstant"]},vacuumImpedance:{description:"Characteristic impedance of vacuum",examples:["vacuumImpedance"]},coulomb:{description:"Coulomb's constant",examples:["coulomb"]},elementaryCharge:{description:"Elementary charge",examples:["elementaryCharge"]},bohrMagneton:{description:"Borh magneton",examples:["bohrMagneton"]},conductanceQuantum:{description:"Conductance quantum",examples:["conductanceQuantum"]},inverseConductanceQuantum:{description:"Inverse conductance quantum",examples:["inverseConductanceQuantum"]},magneticFluxQuantum:{description:"Magnetic flux quantum",examples:["magneticFluxQuantum"]},nuclearMagneton:{description:"Nuclear magneton",examples:["nuclearMagneton"]},klitzing:{description:"Von Klitzing constant",examples:["klitzing"]},bohrRadius:{description:"Borh radius",examples:["bohrRadius"]},classicalElectronRadius:{description:"Classical electron radius",examples:["classicalElectronRadius"]},electronMass:{description:"Electron mass",examples:["electronMass"]},fermiCoupling:{description:"Fermi coupling constant",examples:["fermiCoupling"]},fineStructure:{description:"Fine-structure constant",examples:["fineStructure"]},hartreeEnergy:{description:"Hartree energy",examples:["hartreeEnergy"]},protonMass:{description:"Proton mass",examples:["protonMass"]},deuteronMass:{description:"Deuteron Mass",examples:["deuteronMass"]},neutronMass:{description:"Neutron mass",examples:["neutronMass"]},quantumOfCirculation:{description:"Quantum of circulation",examples:["quantumOfCirculation"]},rydberg:{description:"Rydberg constant",examples:["rydberg"]},thomsonCrossSection:{description:"Thomson cross section",examples:["thomsonCrossSection"]},weakMixingAngle:{description:"Weak mixing angle",examples:["weakMixingAngle"]},efimovFactor:{description:"Efimov factor",examples:["efimovFactor"]},atomicMass:{description:"Atomic mass constant",examples:["atomicMass"]},avogadro:{description:"Avogadro's number",examples:["avogadro"]},boltzmann:{description:"Boltzmann constant",examples:["boltzmann"]},faraday:{description:"Faraday constant",examples:["faraday"]},firstRadiation:{description:"First radiation constant",examples:["firstRadiation"]},loschmidt:{description:"Loschmidt constant at T=273.15 K and p=101.325 kPa",examples:["loschmidt"]},gasConstant:{description:"Gas constant",examples:["gasConstant"]},molarPlanckConstant:{description:"Molar Planck constant",examples:["molarPlanckConstant"]},molarVolume:{description:"Molar volume of an ideal gas at T=273.15 K and p=101.325 kPa",examples:["molarVolume"]},sackurTetrode:{description:"Sackur-Tetrode constant at T=1 K and p=101.325 kPa",examples:["sackurTetrode"]},secondRadiation:{description:"Second radiation constant",examples:["secondRadiation"]},stefanBoltzmann:{description:"Stefan-Boltzmann constant",examples:["stefanBoltzmann"]},wienDisplacement:{description:"Wien displacement law constant",examples:["wienDisplacement"]},molarMass:{description:"Molar mass constant",examples:["molarMass"]},molarMassC12:{description:"Molar mass constant of carbon-12",examples:["molarMassC12"]},gravity:{description:"Standard acceleration of gravity (standard acceleration of free-fall on Earth)",examples:["gravity"]},planckLength:{description:"Planck length",examples:["planckLength"]},planckMass:{description:"Planck mass",examples:["planckMass"]},planckTime:{description:"Planck time",examples:["planckTime"]},planckCharge:{description:"Planck charge",examples:["planckCharge"]},planckTemperature:{description:"Planck temperature",examples:["planckTemperature"]},derivative:{name:"derivative",category:"Algebra",syntax:["derivative(expr, variable)","derivative(expr, variable, {simplify: boolean})"],description:"Takes the derivative of an expression expressed in parser Nodes. The derivative will be taken over the supplied variable in the second parameter. If there are multiple variables in the expression, it will return a partial derivative.",examples:['derivative("2x^3", "x")','derivative("2x^3", "x", {simplify: false})','derivative("2x^2 + 3x + 4", "x")','derivative("sin(2x)", "x")','f = parse("x^2 + x")','x = parse("x")',"df = derivative(f, x)","df.evaluate({x: 3})"],seealso:["simplify","parse","evaluate"]},lsolve:{name:"lsolve",category:"Algebra",syntax:["x=lsolve(L, b)"],description:"Finds one solution of the linear system L * x = b where L is an [n x n] lower triangular matrix and b is a [n] column vector.",examples:["a = [-2, 3; 2, 1]","b = [11, 9]","x = lsolve(a, b)"],seealso:["lsolveAll","lup","lusolve","usolve","matrix","sparse"]},lsolveAll:{name:"lsolveAll",category:"Algebra",syntax:["x=lsolveAll(L, b)"],description:"Finds all solutions of the linear system L * x = b where L is an [n x n] lower triangular matrix and b is a [n] column vector.",examples:["a = [-2, 3; 2, 1]","b = [11, 9]","x = lsolve(a, b)"],seealso:["lsolve","lup","lusolve","usolve","matrix","sparse"]},lup:{name:"lup",category:"Algebra",syntax:["lup(m)"],description:"Calculate the Matrix LU decomposition with partial pivoting. Matrix A is decomposed in three matrices (L, U, P) where P * A = L * U",examples:["lup([[2, 1], [1, 4]])","lup(matrix([[2, 1], [1, 4]]))","lup(sparse([[2, 1], [1, 4]]))"],seealso:["lusolve","lsolve","usolve","matrix","sparse","slu","qr"]},lusolve:{name:"lusolve",category:"Algebra",syntax:["x=lusolve(A, b)","x=lusolve(lu, b)"],description:"Solves the linear system A * x = b where A is an [n x n] matrix and b is a [n] column vector.",examples:["a = [-2, 3; 2, 1]","b = [11, 9]","x = lusolve(a, b)"],seealso:["lup","slu","lsolve","usolve","matrix","sparse"]},simplify:{name:"simplify",category:"Algebra",syntax:["simplify(expr)","simplify(expr, rules)"],description:"Simplify an expression tree.",examples:['simplify("3 + 2 / 4")','simplify("2x + x")','f = parse("x * (x + 2 + x)")',"simplified = simplify(f)","simplified.evaluate({x: 2})"],seealso:["derivative","parse","evaluate"]},rationalize:{name:"rationalize",category:"Algebra",syntax:["rationalize(expr)","rationalize(expr, scope)","rationalize(expr, scope, detailed)"],description:"Transform a rationalizable expression in a rational fraction. If rational fraction is one variable polynomial then converts the numerator and denominator in canonical form, with decreasing exponents, returning the coefficients of numerator.",examples:['rationalize("2x/y - y/(x+1)")','rationalize("2x/y - y/(x+1)", true)'],seealso:["simplify"]},slu:{name:"slu",category:"Algebra",syntax:["slu(A, order, threshold)"],description:"Calculate the Matrix LU decomposition with full pivoting. Matrix A is decomposed in two matrices (L, U) and two permutation vectors (pinv, q) where P * A * Q = L * U",examples:["slu(sparse([4.5, 0, 3.2, 0; 3.1, 2.9, 0, 0.9; 0, 1.7, 3, 0; 3.5, 0.4, 0, 1]), 1, 0.001)"],seealso:["lusolve","lsolve","usolve","matrix","sparse","lup","qr"]},usolve:{name:"usolve",category:"Algebra",syntax:["x=usolve(U, b)"],description:"Finds one solution of the linear system U * x = b where U is an [n x n] upper triangular matrix and b is a [n] column vector.",examples:["x=usolve(sparse([1, 1, 1, 1; 0, 1, 1, 1; 0, 0, 1, 1; 0, 0, 0, 1]), [1; 2; 3; 4])"],seealso:["usolveAll","lup","lusolve","lsolve","matrix","sparse"]},usolveAll:{name:"usolveAll",category:"Algebra",syntax:["x=usolve(U, b)"],description:"Finds all solutions of the linear system U * x = b where U is an [n x n] upper triangular matrix and b is a [n] column vector.",examples:["x=usolve(sparse([1, 1, 1, 1; 0, 1, 1, 1; 0, 0, 1, 1; 0, 0, 0, 1]), [1; 2; 3; 4])"],seealso:["usolve","lup","lusolve","lsolve","matrix","sparse"]},qr:{name:"qr",category:"Algebra",syntax:["qr(A)"],description:"Calculates the Matrix QR decomposition. Matrix `A` is decomposed in two matrices (`Q`, `R`) where `Q` is an orthogonal matrix and `R` is an upper triangular matrix.",examples:["qr([[1, -1,  4], [1,  4, -2], [1,  4,  2], [1,  -1, 0]])"],seealso:["lup","slu","matrix"]},abs:{name:"abs",category:"Arithmetic",syntax:["abs(x)"],description:"Compute the absolute value.",examples:["abs(3.5)","abs(-4.2)"],seealso:["sign"]},add:{name:"add",category:"Operators",syntax:["x + y","add(x, y)"],description:"Add two values.",examples:["a = 2.1 + 3.6","a - 3.6","3 + 2i","3 cm + 2 inch",'"2.3" + "4"'],seealso:["subtract"]},cbrt:{name:"cbrt",category:"Arithmetic",syntax:["cbrt(x)","cbrt(x, allRoots)"],description:"Compute the cubic root value. If x = y * y * y, then y is the cubic root of x. When `x` is a number or complex number, an optional second argument `allRoots` can be provided to return all three cubic roots. If not provided, the principal root is returned",examples:["cbrt(64)","cube(4)","cbrt(-8)","cbrt(2 + 3i)","cbrt(8i)","cbrt(8i, true)","cbrt(27 m^3)"],seealso:["square","sqrt","cube","multiply"]},ceil:{name:"ceil",category:"Arithmetic",syntax:["ceil(x)"],description:"Round a value towards plus infinity. If x is complex, both real and imaginary part are rounded towards plus infinity.",examples:["ceil(3.2)","ceil(3.8)","ceil(-4.2)"],seealso:["floor","fix","round"]},cube:{name:"cube",category:"Arithmetic",syntax:["cube(x)"],description:"Compute the cube of a value. The cube of x is x * x * x.",examples:["cube(2)","2^3","2 * 2 * 2"],seealso:["multiply","square","pow"]},divide:{name:"divide",category:"Operators",syntax:["x / y","divide(x, y)"],description:"Divide two values.",examples:["a = 2 / 3","a * 3","4.5 / 2","3 + 4 / 2","(3 + 4) / 2","18 km / 4.5"],seealso:["multiply"]},dotDivide:{name:"dotDivide",category:"Operators",syntax:["x ./ y","dotDivide(x, y)"],description:"Divide two values element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","b = [2, 1, 1; 3, 2, 5]","a ./ b"],seealso:["multiply","dotMultiply","divide"]},dotMultiply:{name:"dotMultiply",category:"Operators",syntax:["x .* y","dotMultiply(x, y)"],description:"Multiply two values element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","b = [2, 1, 1; 3, 2, 5]","a .* b"],seealso:["multiply","divide","dotDivide"]},dotPow:{name:"dotPow",category:"Operators",syntax:["x .^ y","dotPow(x, y)"],description:"Calculates the power of x to y element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","a .^ 2"],seealso:["pow"]},exp:{name:"exp",category:"Arithmetic",syntax:["exp(x)"],description:"Calculate the exponent of a value.",examples:["exp(1.3)","e ^ 1.3","log(exp(1.3))","x = 2.4","(exp(i*x) == cos(x) + i*sin(x))   # Euler's formula"],seealso:["expm","expm1","pow","log"]},expm:{name:"expm",category:"Arithmetic",syntax:["exp(x)"],description:"Compute the matrix exponential, expm(A) = e^A. The matrix must be square. Not to be confused with exp(a), which performs element-wise exponentiation.",examples:["expm([[0,2],[0,0]])"],seealso:["exp"]},expm1:{name:"expm1",category:"Arithmetic",syntax:["expm1(x)"],description:"Calculate the value of subtracting 1 from the exponential value.",examples:["expm1(2)","pow(e, 2) - 1","log(expm1(2) + 1)"],seealso:["exp","pow","log"]},fix:{name:"fix",category:"Arithmetic",syntax:["fix(x)"],description:"Round a value towards zero. If x is complex, both real and imaginary part are rounded towards zero.",examples:["fix(3.2)","fix(3.8)","fix(-4.2)","fix(-4.8)"],seealso:["ceil","floor","round"]},floor:{name:"floor",category:"Arithmetic",syntax:["floor(x)"],description:"Round a value towards minus infinity.If x is complex, both real and imaginary part are rounded towards minus infinity.",examples:["floor(3.2)","floor(3.8)","floor(-4.2)"],seealso:["ceil","fix","round"]},gcd:{name:"gcd",category:"Arithmetic",syntax:["gcd(a, b)","gcd(a, b, c, ...)"],description:"Compute the greatest common divisor.",examples:["gcd(8, 12)","gcd(-4, 6)","gcd(25, 15, -10)"],seealso:["lcm","xgcd"]},hypot:{name:"hypot",category:"Arithmetic",syntax:["hypot(a, b, c, ...)","hypot([a, b, c, ...])"],description:"Calculate the hypotenusa of a list with values. ",examples:["hypot(3, 4)","sqrt(3^2 + 4^2)","hypot(-2)","hypot([3, 4, 5])"],seealso:["abs","norm"]},lcm:{name:"lcm",category:"Arithmetic",syntax:["lcm(x, y)"],description:"Compute the least common multiple.",examples:["lcm(4, 6)","lcm(6, 21)","lcm(6, 21, 5)"],seealso:["gcd"]},log:{name:"log",category:"Arithmetic",syntax:["log(x)","log(x, base)"],description:"Compute the logarithm of a value. If no base is provided, the natural logarithm of x is calculated. If base if provided, the logarithm is calculated for the specified base. log(x, base) is defined as log(x) / log(base).",examples:["log(3.5)","a = log(2.4)","exp(a)","10 ^ 4","log(10000, 10)","log(10000) / log(10)","b = log(1024, 2)","2 ^ b"],seealso:["exp","log1p","log2","log10"]},log2:{name:"log2",category:"Arithmetic",syntax:["log2(x)"],description:"Calculate the 2-base of a value. This is the same as calculating `log(x, 2)`.",examples:["log2(0.03125)","log2(16)","log2(16) / log2(2)","pow(2, 4)"],seealso:["exp","log1p","log","log10"]},log1p:{name:"log1p",category:"Arithmetic",syntax:["log1p(x)","log1p(x, base)"],description:"Calculate the logarithm of a `value+1`",examples:["log1p(2.5)","exp(log1p(1.4))","pow(10, 4)","log1p(9999, 10)","log1p(9999) / log(10)"],seealso:["exp","log","log2","log10"]},log10:{name:"log10",category:"Arithmetic",syntax:["log10(x)"],description:"Compute the 10-base logarithm of a value.",examples:["log10(0.00001)","log10(10000)","10 ^ 4","log(10000) / log(10)","log(10000, 10)"],seealso:["exp","log"]},mod:{name:"mod",category:"Operators",syntax:["x % y","x mod y","mod(x, y)"],description:"Calculates the modulus, the remainder of an integer division.",examples:["7 % 3","11 % 2","10 mod 4","isOdd(x) = x % 2","isOdd(2)","isOdd(3)"],seealso:["divide"]},multiply:{name:"multiply",category:"Operators",syntax:["x * y","multiply(x, y)"],description:"multiply two values.",examples:["a = 2.1 * 3.4","a / 3.4","2 * 3 + 4","2 * (3 + 4)","3 * 2.1 km"],seealso:["divide"]},norm:{name:"norm",category:"Arithmetic",syntax:["norm(x)","norm(x, p)"],description:"Calculate the norm of a number, vector or matrix.",examples:["abs(-3.5)","norm(-3.5)","norm(3 - 4i)","norm([1, 2, -3], Infinity)","norm([1, 2, -3], -Infinity)","norm([3, 4], 2)","norm([[1, 2], [3, 4]], 1)",'norm([[1, 2], [3, 4]], "inf")','norm([[1, 2], [3, 4]], "fro")']},nthRoot:{name:"nthRoot",category:"Arithmetic",syntax:["nthRoot(a)","nthRoot(a, root)"],description:'Calculate the nth root of a value. The principal nth root of a positive real number A, is the positive real solution of the equation "x^root = A".',examples:["4 ^ 3","nthRoot(64, 3)","nthRoot(9, 2)","sqrt(9)"],seealso:["nthRoots","pow","sqrt"]},nthRoots:{name:"nthRoots",category:"Arithmetic",syntax:["nthRoots(A)","nthRoots(A, root)"],description:'Calculate the nth roots of a value. An nth root of a positive real number A, is a positive real solution of the equation "x^root = A". This function returns an array of complex values.',examples:["nthRoots(1)","nthRoots(1, 3)"],seealso:["sqrt","pow","nthRoot"]},pow:{name:"pow",category:"Operators",syntax:["x ^ y","pow(x, y)"],description:"Calculates the power of x to y, x^y.",examples:["2^3","2*2*2","1 + e ^ (pi * i)"],seealso:["multiply","nthRoot","nthRoots","sqrt"]},round:{name:"round",category:"Arithmetic",syntax:["round(x)","round(x, n)"],description:"round a value towards the nearest integer.If x is complex, both real and imaginary part are rounded towards the nearest integer. When n is specified, the value is rounded to n decimals.",examples:["round(3.2)","round(3.8)","round(-4.2)","round(-4.8)","round(pi, 3)","round(123.45678, 2)"],seealso:["ceil","floor","fix"]},sign:{name:"sign",category:"Arithmetic",syntax:["sign(x)"],description:"Compute the sign of a value. The sign of a value x is 1 when x>1, -1 when x<0, and 0 when x=0.",examples:["sign(3.5)","sign(-4.2)","sign(0)"],seealso:["abs"]},sqrt:{name:"sqrt",category:"Arithmetic",syntax:["sqrt(x)"],description:"Compute the square root value. If x = y * y, then y is the square root of x.",examples:["sqrt(25)","5 * 5","sqrt(-1)"],seealso:["square","sqrtm","multiply","nthRoot","nthRoots","pow"]},sqrtm:{name:"sqrtm",category:"Arithmetic",syntax:["sqrtm(x)"],description:"Calculate the principal square root of a square matrix. The principal square root matrix `X` of another matrix `A` is such that `X * X = A`.",examples:["sqrtm([[1, 2], [3, 4]])"],seealso:["sqrt","abs","square","multiply"]},square:{name:"square",category:"Arithmetic",syntax:["square(x)"],description:"Compute the square of a value. The square of x is x * x.",examples:["square(3)","sqrt(9)","3^2","3 * 3"],seealso:["multiply","pow","sqrt","cube"]},subtract:{name:"subtract",category:"Operators",syntax:["x - y","subtract(x, y)"],description:"subtract two values.",examples:["a = 5.3 - 2","a + 2","2/3 - 1/6","2 * 3 - 3","2.1 km - 500m"],seealso:["add"]},unaryMinus:{name:"unaryMinus",category:"Operators",syntax:["-x","unaryMinus(x)"],description:"Inverse the sign of a value. Converts booleans and strings to numbers.",examples:["-4.5","-(-5.6)",'-"22"'],seealso:["add","subtract","unaryPlus"]},unaryPlus:{name:"unaryPlus",category:"Operators",syntax:["+x","unaryPlus(x)"],description:"Converts booleans and strings to numbers.",examples:["+true",'+"2"'],seealso:["add","subtract","unaryMinus"]},xgcd:{name:"xgcd",category:"Arithmetic",syntax:["xgcd(a, b)"],description:"Calculate the extended greatest common divisor for two values. The result is an array [d, x, y] with 3 entries, where d is the greatest common divisor, and d = x * a + y * b.",examples:["xgcd(8, 12)","gcd(8, 12)","xgcd(36163, 21199)"],seealso:["gcd","lcm"]},bitAnd:{name:"bitAnd",category:"Bitwise",syntax:["x & y","bitAnd(x, y)"],description:"Bitwise AND operation. Performs the logical AND operation on each pair of the corresponding bits of the two given values by multiplying them. If both bits in the compared position are 1, the bit in the resulting binary representation is 1, otherwise, the result is 0",examples:["5 & 3","bitAnd(53, 131)","[1, 12, 31] & 42"],seealso:["bitNot","bitOr","bitXor","leftShift","rightArithShift","rightLogShift"]},bitNot:{name:"bitNot",category:"Bitwise",syntax:["~x","bitNot(x)"],description:"Bitwise NOT operation. Performs a logical negation on each bit of the given value. Bits that are 0 become 1, and those that are 1 become 0.",examples:["~1","~2","bitNot([2, -3, 4])"],seealso:["bitAnd","bitOr","bitXor","leftShift","rightArithShift","rightLogShift"]},bitOr:{name:"bitOr",category:"Bitwise",syntax:["x | y","bitOr(x, y)"],description:"Bitwise OR operation. Performs the logical inclusive OR operation on each pair of corresponding bits of the two given values. The result in each position is 1 if the first bit is 1 or the second bit is 1 or both bits are 1, otherwise, the result is 0.",examples:["5 | 3","bitOr([1, 2, 3], 4)"],seealso:["bitAnd","bitNot","bitXor","leftShift","rightArithShift","rightLogShift"]},bitXor:{name:"bitXor",category:"Bitwise",syntax:["bitXor(x, y)"],description:"Bitwise XOR operation, exclusive OR. Performs the logical exclusive OR operation on each pair of corresponding bits of the two given values. The result in each position is 1 if only the first bit is 1 or only the second bit is 1, but will be 0 if both are 0 or both are 1.",examples:["bitOr(1, 2)","bitXor([2, 3, 4], 4)"],seealso:["bitAnd","bitNot","bitOr","leftShift","rightArithShift","rightLogShift"]},leftShift:{name:"leftShift",category:"Bitwise",syntax:["x << y","leftShift(x, y)"],description:"Bitwise left logical shift of a value x by y number of bits.",examples:["4 << 1","8 >> 1"],seealso:["bitAnd","bitNot","bitOr","bitXor","rightArithShift","rightLogShift"]},rightArithShift:{name:"rightArithShift",category:"Bitwise",syntax:["x >> y","rightArithShift(x, y)"],description:"Bitwise right arithmetic shift of a value x by y number of bits.",examples:["8 >> 1","4 << 1","-12 >> 2"],seealso:["bitAnd","bitNot","bitOr","bitXor","leftShift","rightLogShift"]},rightLogShift:{name:"rightLogShift",category:"Bitwise",syntax:["x >>> y","rightLogShift(x, y)"],description:"Bitwise right logical shift of a value x by y number of bits.",examples:["8 >>> 1","4 << 1","-12 >>> 2"],seealso:["bitAnd","bitNot","bitOr","bitXor","leftShift","rightArithShift"]},bellNumbers:{name:"bellNumbers",category:"Combinatorics",syntax:["bellNumbers(n)"],description:"The Bell Numbers count the number of partitions of a set. A partition is a pairwise disjoint subset of S whose union is S. `bellNumbers` only takes integer arguments. The following condition must be enforced: n >= 0.",examples:["bellNumbers(3)","bellNumbers(8)"],seealso:["stirlingS2"]},catalan:{name:"catalan",category:"Combinatorics",syntax:["catalan(n)"],description:"The Catalan Numbers enumerate combinatorial structures of many different types. catalan only takes integer arguments. The following condition must be enforced: n >= 0.",examples:["catalan(3)","catalan(8)"],seealso:["bellNumbers"]},composition:{name:"composition",category:"Combinatorics",syntax:["composition(n, k)"],description:"The composition counts of n into k parts. composition only takes integer arguments. The following condition must be enforced: k <= n.",examples:["composition(5, 3)"],seealso:["combinations"]},stirlingS2:{name:"stirlingS2",category:"Combinatorics",syntax:["stirlingS2(n, k)"],description:"he Stirling numbers of the second kind, counts the number of ways to partition a set of n labelled objects into k nonempty unlabelled subsets. `stirlingS2` only takes integer arguments. The following condition must be enforced: k <= n. If n = k or k = 1, then s(n,k) = 1.",examples:["stirlingS2(5, 3)"],seealso:["bellNumbers"]},config:{name:"config",category:"Core",syntax:["config()","config(options)"],description:"Get configuration or change configuration.",examples:["config()","1/3 + 1/4",'config({number: "Fraction"})',"1/3 + 1/4"],seealso:[]},import:{name:"import",category:"Core",syntax:["import(functions)","import(functions, options)"],description:"Import functions or constants from an object.",examples:["import({myFn: f(x)=x^2, myConstant: 32 })","myFn(2)","myConstant"],seealso:[]},typed:{name:"typed",category:"Core",syntax:["typed(signatures)","typed(name, signatures)"],description:"Create a typed function.",examples:['double = typed({ "number, number": f(x)=x+x })',"double(2)",'double("hello")'],seealso:[]},arg:{name:"arg",category:"Complex",syntax:["arg(x)"],description:"Compute the argument of a complex value. If x = a+bi, the argument is computed as atan2(b, a).",examples:["arg(2 + 2i)","atan2(3, 2)","arg(2 + 3i)"],seealso:["re","im","conj","abs"]},conj:{name:"conj",category:"Complex",syntax:["conj(x)"],description:"Compute the complex conjugate of a complex value. If x = a+bi, the complex conjugate is a-bi.",examples:["conj(2 + 3i)","conj(2 - 3i)","conj(-5.2i)"],seealso:["re","im","abs","arg"]},re:{name:"re",category:"Complex",syntax:["re(x)"],description:"Get the real part of a complex number.",examples:["re(2 + 3i)","im(2 + 3i)","re(-5.2i)","re(2.4)"],seealso:["im","conj","abs","arg"]},im:{name:"im",category:"Complex",syntax:["im(x)"],description:"Get the imaginary part of a complex number.",examples:["im(2 + 3i)","re(2 + 3i)","im(-5.2i)","im(2.4)"],seealso:["re","conj","abs","arg"]},evaluate:{name:"evaluate",category:"Expression",syntax:["evaluate(expression)","evaluate([expr1, expr2, expr3, ...])"],description:"Evaluate an expression or an array with expressions.",examples:['evaluate("2 + 3")','evaluate("sqrt(" + 4 + ")")'],seealso:[]},help:{name:"help",category:"Expression",syntax:["help(object)","help(string)"],description:"Display documentation on a function or data type.",examples:["help(sqrt)",'help("complex")'],seealso:[]},distance:{name:"distance",category:"Geometry",syntax:["distance([x1, y1], [x2, y2])","distance([[x1, y1], [x2, y2]])"],description:"Calculates the Euclidean distance between two points.",examples:["distance([0,0], [4,4])","distance([[0,0], [4,4]])"],seealso:[]},intersect:{name:"intersect",category:"Geometry",syntax:["intersect(expr1, expr2, expr3, expr4)","intersect(expr1, expr2, expr3)"],description:"Computes the intersection point of lines and/or planes.",examples:["intersect([0, 0], [10, 10], [10, 0], [0, 10])","intersect([1, 0, 1],  [4, -2, 2], [1, 1, 1, 6])"],seealso:[]},and:{name:"and",category:"Logical",syntax:["x and y","and(x, y)"],description:"Logical and. Test whether two values are both defined with a nonzero/nonempty value.",examples:["true and false","true and true","2 and 4"],seealso:["not","or","xor"]},not:{name:"not",category:"Logical",syntax:["not x","not(x)"],description:"Logical not. Flips the boolean value of given argument.",examples:["not true","not false","not 2","not 0"],seealso:["and","or","xor"]},or:{name:"or",category:"Logical",syntax:["x or y","or(x, y)"],description:"Logical or. Test if at least one value is defined with a nonzero/nonempty value.",examples:["true or false","false or false","0 or 4"],seealso:["not","and","xor"]},xor:{name:"xor",category:"Logical",syntax:["x xor y","xor(x, y)"],description:"Logical exclusive or, xor. Test whether one and only one value is defined with a nonzero/nonempty value.",examples:["true xor false","false xor false","true xor true","0 xor 4"],seealso:["not","and","or"]},concat:{name:"concat",category:"Matrix",syntax:["concat(A, B, C, ...)","concat(A, B, C, ..., dim)"],description:"Concatenate matrices. By default, the matrices are concatenated by the last dimension. The dimension on which to concatenate can be provided as last argument.",examples:["A = [1, 2; 5, 6]","B = [3, 4; 7, 8]","concat(A, B)","concat(A, B, 1)","concat(A, B, 2)"],seealso:["det","diag","identity","inv","ones","range","size","squeeze","subset","trace","transpose","zeros"]},cross:{name:"cross",category:"Matrix",syntax:["cross(A, B)"],description:"Calculate the cross product for two vectors in three dimensional space.",examples:["cross([1, 1, 0],  [0, 1, 1])","cross([3, -3, 1], [4, 9, 2])","cross([2, 3, 4],  [5, 6, 7])"],seealso:["multiply","dot"]},column:{name:"column",category:"Matrix",syntax:["column(x, index)"],description:"Return a column from a matrix or array.",examples:["A = [[1, 2], [3, 4]]","column(A, 1)","column(A, 2)"],seealso:["row"]},ctranspose:{name:"ctranspose",category:"Matrix",syntax:["x'","ctranspose(x)"],description:"Complex Conjugate and Transpose a matrix",examples:["a = [1, 2, 3; 4, 5, 6]","a'","ctranspose(a)"],seealso:["concat","det","diag","identity","inv","ones","range","size","squeeze","subset","trace","zeros"]},det:{name:"det",category:"Matrix",syntax:["det(x)"],description:"Calculate the determinant of a matrix",examples:["det([1, 2; 3, 4])","det([-2, 2, 3; -1, 1, 3; 2, 0, -1])"],seealso:["concat","diag","identity","inv","ones","range","size","squeeze","subset","trace","transpose","zeros"]},diag:{name:"diag",category:"Matrix",syntax:["diag(x)","diag(x, k)"],description:"Create a diagonal matrix or retrieve the diagonal of a matrix. When x is a vector, a matrix with the vector values on the diagonal will be returned. When x is a matrix, a vector with the diagonal values of the matrix is returned. When k is provided, the k-th diagonal will be filled in or retrieved, if k is positive, the values are placed on the super diagonal. When k is negative, the values are placed on the sub diagonal.",examples:["diag(1:3)","diag(1:3, 1)","a = [1, 2, 3; 4, 5, 6; 7, 8, 9]","diag(a)"],seealso:["concat","det","identity","inv","ones","range","size","squeeze","subset","trace","transpose","zeros"]},diff:{name:"diff",category:"Matrix",syntax:["diff(arr)","diff(arr, dim)"],description:["Create a new matrix or array with the difference of the passed matrix or array.","Dim parameter is optional and used to indicant the dimension of the array/matrix to apply the difference","If no dimension parameter is passed it is assumed as dimension 0","Dimension is zero-based in javascript and one-based in the parser","Arrays must be 'rectangular' meaning arrays like [1, 2]","If something is passed as a matrix it will be returned as a matrix but other than that all matrices are converted to arrays"],examples:["diff([1, 2, 4, 7, 0])","diff([1, 2, 4, 7, 0], 0)","diff(matrix([1, 2, 4, 7, 0]))","diff([[1, 2], [3, 4]])","diff([[1, 2], [3, 4]], 0)","diff([[1, 2], [3, 4]], 1)","diff([[1, 2], [3, 4]], bignumber(1))","diff(matrix([[1, 2], [3, 4]]), 1)","diff([[1, 2], matrix([3, 4])], 1)"],seealso:["subtract","partitionSelect"]},dot:{name:"dot",category:"Matrix",syntax:["dot(A, B)","A * B"],description:"Calculate the dot product of two vectors. The dot product of A = [a1, a2, a3, ..., an] and B = [b1, b2, b3, ..., bn] is defined as dot(A, B) = a1 * b1 + a2 * b2 + a3 * b3 + ... + an * bn",examples:["dot([2, 4, 1], [2, 2, 3])","[2, 4, 1] * [2, 2, 3]"],seealso:["multiply","cross"]},getMatrixDataType:{name:"getMatrixDataType",category:"Matrix",syntax:["getMatrixDataType(x)"],description:'Find the data type of all elements in a matrix or array, for example "number" if all items are a number and "Complex" if all values are complex numbers. If a matrix contains more than one data type, it will return "mixed".',examples:["getMatrixDataType([1, 2, 3])","getMatrixDataType([[5 cm], [2 inch]])",'getMatrixDataType([1, "text"])',"getMatrixDataType([1, bignumber(4)])"],seealso:["matrix","sparse","typeOf"]},identity:{name:"identity",category:"Matrix",syntax:["identity(n)","identity(m, n)","identity([m, n])"],description:"Returns the identity matrix with size m-by-n. The matrix has ones on the diagonal and zeros elsewhere.",examples:["identity(3)","identity(3, 5)","a = [1, 2, 3; 4, 5, 6]","identity(size(a))"],seealso:["concat","det","diag","inv","ones","range","size","squeeze","subset","trace","transpose","zeros"]},filter:{name:"filter",category:"Matrix",syntax:["filter(x, test)"],description:"Filter items in a matrix.",examples:["isPositive(x) = x > 0","filter([6, -2, -1, 4, 3], isPositive)","filter([6, -2, 0, 1, 0], x != 0)"],seealso:["sort","map","forEach"]},flatten:{name:"flatten",category:"Matrix",syntax:["flatten(x)"],description:"Flatten a multi dimensional matrix into a single dimensional matrix.",examples:["a = [1, 2, 3; 4, 5, 6]","size(a)","b = flatten(a)","size(b)"],seealso:["concat","resize","size","squeeze"]},forEach:{name:"forEach",category:"Matrix",syntax:["forEach(x, callback)"],description:"Iterates over all elements of a matrix/array, and executes the given callback function.",examples:["forEach([1, 2, 3], function(val) { console.log(val) })"],seealso:["map","sort","filter"]},inv:{name:"inv",category:"Matrix",syntax:["inv(x)"],description:"Calculate the inverse of a matrix",examples:["inv([1, 2; 3, 4])","inv(4)","1 / 4"],seealso:["concat","det","diag","identity","ones","range","size","squeeze","subset","trace","transpose","zeros"]},eigs:{name:"eigs",category:"Matrix",syntax:["eigs(x)"],description:"Calculate the eigenvalues and eigenvectors of a real symmetric matrix",examples:["eigs([[5, 2.3], [2.3, 1]])"],seealso:["inv"]},kron:{name:"kron",category:"Matrix",syntax:["kron(x, y)"],description:"Calculates the kronecker product of 2 matrices or vectors.",examples:["kron([[1, 0], [0, 1]], [[1, 2], [3, 4]])","kron([1,1], [2,3,4])"],seealso:["multiply","dot","cross"]},map:{name:"map",category:"Matrix",syntax:["map(x, callback)"],description:"Create a new matrix or array with the results of the callback function executed on each entry of the matrix/array.",examples:["map([1, 2, 3], square)"],seealso:["filter","forEach"]},ones:{name:"ones",category:"Matrix",syntax:["ones(m)","ones(m, n)","ones(m, n, p, ...)","ones([m])","ones([m, n])","ones([m, n, p, ...])"],description:"Create a matrix containing ones.",examples:["ones(3)","ones(3, 5)","ones([2,3]) * 4.5","a = [1, 2, 3; 4, 5, 6]","ones(size(a))"],seealso:["concat","det","diag","identity","inv","range","size","squeeze","subset","trace","transpose","zeros"]},partitionSelect:{name:"partitionSelect",category:"Matrix",syntax:["partitionSelect(x, k)","partitionSelect(x, k, compare)"],description:"Partition-based selection of an array or 1D matrix. Will find the kth smallest value, and mutates the input array. Uses Quickselect.",examples:["partitionSelect([5, 10, 1], 2)",'partitionSelect(["C", "B", "A", "D"], 1)'],seealso:["sort"]},range:{name:"range",category:"Type",syntax:["start:end","start:step:end","range(start, end)","range(start, end, step)","range(string)"],description:"Create a range. Lower bound of the range is included, upper bound is excluded.",examples:["1:5","3:-1:-3","range(3, 7)","range(0, 12, 2)",'range("4:10")',"a = [1, 2, 3, 4; 5, 6, 7, 8]","a[1:2, 1:2]"],seealso:["concat","det","diag","identity","inv","ones","size","squeeze","subset","trace","transpose","zeros"]},resize:{name:"resize",category:"Matrix",syntax:["resize(x, size)","resize(x, size, defaultValue)"],description:"Resize a matrix.",examples:["resize([1,2,3,4,5], [3])","resize([1,2,3], [5])","resize([1,2,3], [5], -1)","resize(2, [2, 3])",'resize("hello", [8], "!")'],seealso:["size","subset","squeeze","reshape"]},reshape:{name:"reshape",category:"Matrix",syntax:["reshape(x, sizes)"],description:"Reshape a multi dimensional array to fit the specified dimensions.",examples:["reshape([1, 2, 3, 4, 5, 6], [2, 3])","reshape([[1, 2], [3, 4]], [1, 4])","reshape([[1, 2], [3, 4]], [4])"],seealso:["size","squeeze","resize"]},rotate:{name:"rotate",category:"Matrix",syntax:["rotate(w, theta)","rotate(w, theta, v)"],description:"Returns a 2-D rotation matrix (2x2) for a given angle (in radians). Returns a 2-D rotation matrix (3x3) of a given angle (in radians) around given axis.",examples:["rotate([1, 0], math.pi / 2)",'rotate(matrix([1, 0]), unit("35deg"))','rotate([1, 0, 0], unit("90deg"), [0, 0, 1])','rotate(matrix([1, 0, 0]), unit("90deg"), matrix([0, 0, 1]))'],seealso:["matrix","rotationMatrix"]},rotationMatrix:{name:"rotationMatrix",category:"Matrix",syntax:["rotationMatrix(theta)","rotationMatrix(theta, v)","rotationMatrix(theta, v, format)"],description:"Returns a 2-D rotation matrix (2x2) for a given angle (in radians). Returns a 2-D rotation matrix (3x3) of a given angle (in radians) around given axis.",examples:["rotationMatrix(pi / 2)",'rotationMatrix(unit("45deg"), [0, 0, 1])','rotationMatrix(1, matrix([0, 0, 1]), "sparse")'],seealso:["cos","sin"]},row:{name:"row",category:"Matrix",syntax:["row(x, index)"],description:"Return a row from a matrix or array.",examples:["A = [[1, 2], [3, 4]]","row(A, 1)","row(A, 2)"],seealso:["column"]},size:{name:"size",category:"Matrix",syntax:["size(x)"],description:"Calculate the size of a matrix.",examples:["size(2.3)",'size("hello world")',"a = [1, 2; 3, 4; 5, 6]","size(a)","size(1:6)"],seealso:["concat","det","diag","identity","inv","ones","range","squeeze","subset","trace","transpose","zeros"]},sort:{name:"sort",category:"Matrix",syntax:["sort(x)","sort(x, compare)"],description:'Sort the items in a matrix. Compare can be a string "asc", "desc", "natural", or a custom sort function.',examples:["sort([5, 10, 1])",'sort(["C", "B", "A", "D"])',"sortByLength(a, b) = size(a)[1] - size(b)[1]",'sort(["Langdon", "Tom", "Sara"], sortByLength)','sort(["10", "1", "2"], "natural")'],seealso:["map","filter","forEach"]},squeeze:{name:"squeeze",category:"Matrix",syntax:["squeeze(x)"],description:"Remove inner and outer singleton dimensions from a matrix.",examples:["a = zeros(3,2,1)","size(squeeze(a))","b = zeros(1,1,3)","size(squeeze(b))"],seealso:["concat","det","diag","identity","inv","ones","range","size","subset","trace","transpose","zeros"]},subset:{name:"subset",category:"Matrix",syntax:["value(index)","value(index) = replacement","subset(value, [index])","subset(value, [index], replacement)"],description:"Get or set a subset of a matrix or string. Indexes are one-based. Both the ranges lower-bound and upper-bound are included.",examples:["d = [1, 2; 3, 4]","e = []","e[1, 1:2] = [5, 6]","e[2, :] = [7, 8]","f = d * e","f[2, 1]","f[:, 1]"],seealso:["concat","det","diag","identity","inv","ones","range","size","squeeze","trace","transpose","zeros"]},trace:{name:"trace",category:"Matrix",syntax:["trace(A)"],description:"Calculate the trace of a matrix: the sum of the elements on the main diagonal of a square matrix.",examples:["A = [1, 2, 3; -1, 2, 3; 2, 0, 3]","trace(A)"],seealso:["concat","det","diag","identity","inv","ones","range","size","squeeze","subset","transpose","zeros"]},transpose:{name:"transpose",category:"Matrix",syntax:["x'","transpose(x)"],description:"Transpose a matrix",examples:["a = [1, 2, 3; 4, 5, 6]","a'","transpose(a)"],seealso:["concat","det","diag","identity","inv","ones","range","size","squeeze","subset","trace","zeros"]},zeros:{name:"zeros",category:"Matrix",syntax:["zeros(m)","zeros(m, n)","zeros(m, n, p, ...)","zeros([m])","zeros([m, n])","zeros([m, n, p, ...])"],description:"Create a matrix containing zeros.",examples:["zeros(3)","zeros(3, 5)","a = [1, 2, 3; 4, 5, 6]","zeros(size(a))"],seealso:["concat","det","diag","identity","inv","ones","range","size","squeeze","subset","trace","transpose"]},combinations:{name:"combinations",category:"Probability",syntax:["combinations(n, k)"],description:"Compute the number of combinations of n items taken k at a time",examples:["combinations(7, 5)"],seealso:["combinationsWithRep","permutations","factorial"]},combinationsWithRep:{name:"combinationsWithRep",category:"Probability",syntax:["combinationsWithRep(n, k)"],description:"Compute the number of combinations of n items taken k at a time with replacements.",examples:["combinationsWithRep(7, 5)"],seealso:["combinations","permutations","factorial"]},factorial:{name:"factorial",category:"Probability",syntax:["n!","factorial(n)"],description:"Compute the factorial of a value",examples:["5!","5 * 4 * 3 * 2 * 1","3!"],seealso:["combinations","combinationsWithRep","permutations","gamma"]},gamma:{name:"gamma",category:"Probability",syntax:["gamma(n)"],description:"Compute the gamma function. For small values, the Lanczos approximation is used, and for large values the extended Stirling approximation.",examples:["gamma(4)","3!","gamma(1/2)","sqrt(pi)"],seealso:["factorial"]},kldivergence:{name:"kldivergence",category:"Probability",syntax:["kldivergence(x, y)"],description:"Calculate the Kullback-Leibler (KL) divergence  between two distributions.",examples:["kldivergence([0.7,0.5,0.4], [0.2,0.9,0.5])"],seealso:[]},multinomial:{name:"multinomial",category:"Probability",syntax:["multinomial(A)"],description:"Multinomial Coefficients compute the number of ways of picking a1, a2, ..., ai unordered outcomes from `n` possibilities. multinomial takes one array of integers as an argument. The following condition must be enforced: every ai > 0.",examples:["multinomial([1, 2, 1])"],seealso:["combinations","factorial"]},permutations:{name:"permutations",category:"Probability",syntax:["permutations(n)","permutations(n, k)"],description:"Compute the number of permutations of n items taken k at a time",examples:["permutations(5)","permutations(5, 3)"],seealso:["combinations","combinationsWithRep","factorial"]},pickRandom:{name:"pickRandom",category:"Probability",syntax:["pickRandom(array)","pickRandom(array, number)","pickRandom(array, weights)","pickRandom(array, number, weights)","pickRandom(array, weights, number)"],description:"Pick a random entry from a given array.",examples:["pickRandom(0:10)","pickRandom([1, 3, 1, 6])","pickRandom([1, 3, 1, 6], 2)","pickRandom([1, 3, 1, 6], [2, 3, 2, 1])","pickRandom([1, 3, 1, 6], 2, [2, 3, 2, 1])","pickRandom([1, 3, 1, 6], [2, 3, 2, 1], 2)"],seealso:["random","randomInt"]},random:{name:"random",category:"Probability",syntax:["random()","random(max)","random(min, max)","random(size)","random(size, max)","random(size, min, max)"],description:"Return a random number.",examples:["random()","random(10, 20)","random([2, 3])"],seealso:["pickRandom","randomInt"]},randomInt:{name:"randomInt",category:"Probability",syntax:["randomInt(max)","randomInt(min, max)","randomInt(size)","randomInt(size, max)","randomInt(size, min, max)"],description:"Return a random integer number",examples:["randomInt(10, 20)","randomInt([2, 3], 10)"],seealso:["pickRandom","random"]},compare:{name:"compare",category:"Relational",syntax:["compare(x, y)"],description:"Compare two values. Returns 1 when x > y, -1 when x < y, and 0 when x == y.",examples:["compare(2, 3)","compare(3, 2)","compare(2, 2)","compare(5cm, 40mm)","compare(2, [1, 2, 3])"],seealso:["equal","unequal","smaller","smallerEq","largerEq","compareNatural","compareText"]},compareNatural:{name:"compareNatural",category:"Relational",syntax:["compareNatural(x, y)"],description:"Compare two values of any type in a deterministic, natural way. Returns 1 when x > y, -1 when x < y, and 0 when x == y.",examples:["compareNatural(2, 3)","compareNatural(3, 2)","compareNatural(2, 2)","compareNatural(5cm, 40mm)",'compareNatural("2", "10")',"compareNatural(2 + 3i, 2 + 4i)","compareNatural([1, 2, 4], [1, 2, 3])","compareNatural([1, 5], [1, 2, 3])","compareNatural([1, 2], [1, 2])","compareNatural({a: 2}, {a: 4})"],seealso:["equal","unequal","smaller","smallerEq","largerEq","compare","compareText"]},compareText:{name:"compareText",category:"Relational",syntax:["compareText(x, y)"],description:"Compare two strings lexically. Comparison is case sensitive. Returns 1 when x > y, -1 when x < y, and 0 when x == y.",examples:['compareText("B", "A")','compareText("A", "B")','compareText("A", "A")','compareText("2", "10")','compare("2", "10")',"compare(2, 10)",'compareNatural("2", "10")','compareText("B", ["A", "B", "C"])'],seealso:["compare","compareNatural"]},deepEqual:{name:"deepEqual",category:"Relational",syntax:["deepEqual(x, y)"],description:"Check equality of two matrices element wise. Returns true if the size of both matrices is equal and when and each of the elements are equal.",examples:["deepEqual([1,3,4], [1,3,4])","deepEqual([1,3,4], [1,3])"],seealso:["equal","unequal","smaller","larger","smallerEq","largerEq","compare"]},equal:{name:"equal",category:"Relational",syntax:["x == y","equal(x, y)"],description:"Check equality of two values. Returns true if the values are equal, and false if not.",examples:["2+2 == 3","2+2 == 4","a = 3.2","b = 6-2.8","a == b","50cm == 0.5m"],seealso:["unequal","smaller","larger","smallerEq","largerEq","compare","deepEqual","equalText"]},equalText:{name:"equalText",category:"Relational",syntax:["equalText(x, y)"],description:"Check equality of two strings. Comparison is case sensitive. Returns true if the values are equal, and false if not.",examples:['equalText("Hello", "Hello")','equalText("a", "A")','equal("2e3", "2000")','equalText("2e3", "2000")','equalText("B", ["A", "B", "C"])'],seealso:["compare","compareNatural","compareText","equal"]},larger:{name:"larger",category:"Relational",syntax:["x > y","larger(x, y)"],description:"Check if value x is larger than y. Returns true if x is larger than y, and false if not.",examples:["2 > 3","5 > 2*2","a = 3.3","b = 6-2.8","(a > b)","(b < a)","5 cm > 2 inch"],seealso:["equal","unequal","smaller","smallerEq","largerEq","compare"]},largerEq:{name:"largerEq",category:"Relational",syntax:["x >= y","largerEq(x, y)"],description:"Check if value x is larger or equal to y. Returns true if x is larger or equal to y, and false if not.",examples:["2 >= 1+1","2 > 1+1","a = 3.2","b = 6-2.8","(a >= b)"],seealso:["equal","unequal","smallerEq","smaller","compare"]},smaller:{name:"smaller",category:"Relational",syntax:["x < y","smaller(x, y)"],description:"Check if value x is smaller than value y. Returns true if x is smaller than y, and false if not.",examples:["2 < 3","5 < 2*2","a = 3.3","b = 6-2.8","(a < b)","5 cm < 2 inch"],seealso:["equal","unequal","larger","smallerEq","largerEq","compare"]},smallerEq:{name:"smallerEq",category:"Relational",syntax:["x <= y","smallerEq(x, y)"],description:"Check if value x is smaller or equal to value y. Returns true if x is smaller than y, and false if not.",examples:["2 <= 1+1","2 < 1+1","a = 3.2","b = 6-2.8","(a <= b)"],seealso:["equal","unequal","larger","smaller","largerEq","compare"]},unequal:{name:"unequal",category:"Relational",syntax:["x != y","unequal(x, y)"],description:"Check unequality of two values. Returns true if the values are unequal, and false if they are equal.",examples:["2+2 != 3","2+2 != 4","a = 3.2","b = 6-2.8","a != b","50cm != 0.5m","5 cm != 2 inch"],seealso:["equal","smaller","larger","smallerEq","largerEq","compare","deepEqual"]},setCartesian:{name:"setCartesian",category:"Set",syntax:["setCartesian(set1, set2)"],description:"Create the cartesian product of two (multi)sets. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setCartesian([1, 2], [3, 4])"],seealso:["setUnion","setIntersect","setDifference","setPowerset"]},setDifference:{name:"setDifference",category:"Set",syntax:["setDifference(set1, set2)"],description:"Create the difference of two (multi)sets: every element of set1, that is not the element of set2. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setDifference([1, 2, 3, 4], [3, 4, 5, 6])","setDifference([[1, 2], [3, 4]], [[3, 4], [5, 6]])"],seealso:["setUnion","setIntersect","setSymDifference"]},setDistinct:{name:"setDistinct",category:"Set",syntax:["setDistinct(set)"],description:"Collect the distinct elements of a multiset. A multi-dimension array will be converted to a single-dimension array before the operation.",examples:["setDistinct([1, 1, 1, 2, 2, 3])"],seealso:["setMultiplicity"]},setIntersect:{name:"setIntersect",category:"Set",syntax:["setIntersect(set1, set2)"],description:"Create the intersection of two (multi)sets. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setIntersect([1, 2, 3, 4], [3, 4, 5, 6])","setIntersect([[1, 2], [3, 4]], [[3, 4], [5, 6]])"],seealso:["setUnion","setDifference"]},setIsSubset:{name:"setIsSubset",category:"Set",syntax:["setIsSubset(set1, set2)"],description:"Check whether a (multi)set is a subset of another (multi)set: every element of set1 is the element of set2. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setIsSubset([1, 2], [3, 4, 5, 6])","setIsSubset([3, 4], [3, 4, 5, 6])"],seealso:["setUnion","setIntersect","setDifference"]},setMultiplicity:{name:"setMultiplicity",category:"Set",syntax:["setMultiplicity(element, set)"],description:"Count the multiplicity of an element in a multiset. A multi-dimension array will be converted to a single-dimension array before the operation.",examples:["setMultiplicity(1, [1, 2, 2, 4])","setMultiplicity(2, [1, 2, 2, 4])"],seealso:["setDistinct","setSize"]},setPowerset:{name:"setPowerset",category:"Set",syntax:["setPowerset(set)"],description:"Create the powerset of a (multi)set: the powerset contains very possible subsets of a (multi)set. A multi-dimension array will be converted to a single-dimension array before the operation.",examples:["setPowerset([1, 2, 3])"],seealso:["setCartesian"]},setSize:{name:"setSize",category:"Set",syntax:["setSize(set)","setSize(set, unique)"],description:'Count the number of elements of a (multi)set. When the second parameter "unique" is true, count only the unique values. A multi-dimension array will be converted to a single-dimension array before the operation.',examples:["setSize([1, 2, 2, 4])","setSize([1, 2, 2, 4], true)"],seealso:["setUnion","setIntersect","setDifference"]},setSymDifference:{name:"setSymDifference",category:"Set",syntax:["setSymDifference(set1, set2)"],description:"Create the symmetric difference of two (multi)sets. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setSymDifference([1, 2, 3, 4], [3, 4, 5, 6])","setSymDifference([[1, 2], [3, 4]], [[3, 4], [5, 6]])"],seealso:["setUnion","setIntersect","setDifference"]},setUnion:{name:"setUnion",category:"Set",syntax:["setUnion(set1, set2)"],description:"Create the union of two (multi)sets. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setUnion([1, 2, 3, 4], [3, 4, 5, 6])","setUnion([[1, 2], [3, 4]], [[3, 4], [5, 6]])"],seealso:["setIntersect","setDifference"]},erf:{name:"erf",category:"Special",syntax:["erf(x)"],description:"Compute the erf function of a value using a rational Chebyshev approximations for different intervals of x",examples:["erf(0.2)","erf(-0.5)","erf(4)"],seealso:[]},mad:{name:"mad",category:"Statistics",syntax:["mad(a, b, c, ...)","mad(A)"],description:"Compute the median absolute deviation of a matrix or a list with values. The median absolute deviation is defined as the median of the absolute deviations from the median.",examples:["mad(10, 20, 30)","mad([1, 2, 3])"],seealso:["mean","median","std","abs"]},max:{name:"max",category:"Statistics",syntax:["max(a, b, c, ...)","max(A)","max(A, dim)"],description:"Compute the maximum value of a list of values.",examples:["max(2, 3, 4, 1)","max([2, 3, 4, 1])","max([2, 5; 4, 3])","max([2, 5; 4, 3], 1)","max([2, 5; 4, 3], 2)","max(2.7, 7.1, -4.5, 2.0, 4.1)","min(2.7, 7.1, -4.5, 2.0, 4.1)"],seealso:["mean","median","min","prod","std","sum","variance"]},mean:{name:"mean",category:"Statistics",syntax:["mean(a, b, c, ...)","mean(A)","mean(A, dim)"],description:"Compute the arithmetic mean of a list of values.",examples:["mean(2, 3, 4, 1)","mean([2, 3, 4, 1])","mean([2, 5; 4, 3])","mean([2, 5; 4, 3], 1)","mean([2, 5; 4, 3], 2)","mean([1.0, 2.7, 3.2, 4.0])"],seealso:["max","median","min","prod","std","sum","variance"]},median:{name:"median",category:"Statistics",syntax:["median(a, b, c, ...)","median(A)"],description:"Compute the median of all values. The values are sorted and the middle value is returned. In case of an even number of values, the average of the two middle values is returned.",examples:["median(5, 2, 7)","median([3, -1, 5, 7])"],seealso:["max","mean","min","prod","std","sum","variance","quantileSeq"]},min:{name:"min",category:"Statistics",syntax:["min(a, b, c, ...)","min(A)","min(A, dim)"],description:"Compute the minimum value of a list of values.",examples:["min(2, 3, 4, 1)","min([2, 3, 4, 1])","min([2, 5; 4, 3])","min([2, 5; 4, 3], 1)","min([2, 5; 4, 3], 2)","min(2.7, 7.1, -4.5, 2.0, 4.1)","max(2.7, 7.1, -4.5, 2.0, 4.1)"],seealso:["max","mean","median","prod","std","sum","variance"]},mode:{name:"mode",category:"Statistics",syntax:["mode(a, b, c, ...)","mode(A)","mode(A, a, b, B, c, ...)"],description:"Computes the mode of all values as an array. In case mode being more than one, multiple values are returned in an array.",examples:["mode(2, 1, 4, 3, 1)","mode([1, 2.7, 3.2, 4, 2.7])","mode(1, 4, 6, 1, 6)"],seealso:["max","mean","min","median","prod","std","sum","variance"]},prod:{name:"prod",category:"Statistics",syntax:["prod(a, b, c, ...)","prod(A)"],description:"Compute the product of all values.",examples:["prod(2, 3, 4)","prod([2, 3, 4])","prod([2, 5; 4, 3])"],seealso:["max","mean","min","median","min","std","sum","variance"]},quantileSeq:{name:"quantileSeq",category:"Statistics",syntax:["quantileSeq(A, prob[, sorted])","quantileSeq(A, [prob1, prob2, ...][, sorted])","quantileSeq(A, N[, sorted])"],description:"Compute the prob order quantile of a matrix or a list with values. The sequence is sorted and the middle value is returned. Supported types of sequence values are: Number, BigNumber, Unit Supported types of probablity are: Number, BigNumber. \n\nIn case of a (multi dimensional) array or matrix, the prob order quantile of all elements will be calculated.",examples:["quantileSeq([3, -1, 5, 7], 0.5)","quantileSeq([3, -1, 5, 7], [1/3, 2/3])","quantileSeq([3, -1, 5, 7], 2)","quantileSeq([-1, 3, 5, 7], 0.5, true)"],seealso:["mean","median","min","max","prod","std","sum","variance"]},std:{name:"std",category:"Statistics",syntax:["std(a, b, c, ...)","std(A)","std(A, normalization)"],description:'Compute the standard deviation of all values, defined as std(A) = sqrt(variance(A)). Optional parameter normalization can be "unbiased" (default), "uncorrected", or "biased".',examples:["std(2, 4, 6)","std([2, 4, 6, 8])",'std([2, 4, 6, 8], "uncorrected")','std([2, 4, 6, 8], "biased")',"std([1, 2, 3; 4, 5, 6])"],seealso:["max","mean","min","median","prod","sum","variance"]},sum:{name:"sum",category:"Statistics",syntax:["sum(a, b, c, ...)","sum(A)"],description:"Compute the sum of all values.",examples:["sum(2, 3, 4, 1)","sum([2, 3, 4, 1])","sum([2, 5; 4, 3])"],seealso:["max","mean","median","min","prod","std","sum","variance"]},variance:{name:"variance",category:"Statistics",syntax:["variance(a, b, c, ...)","variance(A)","variance(A, normalization)"],description:'Compute the variance of all values. Optional parameter normalization can be "unbiased" (default), "uncorrected", or "biased".',examples:["variance(2, 4, 6)","variance([2, 4, 6, 8])",'variance([2, 4, 6, 8], "uncorrected")','variance([2, 4, 6, 8], "biased")',"variance([1, 2, 3; 4, 5, 6])"],seealso:["max","mean","min","median","min","prod","std","sum"]},acos:{name:"acos",category:"Trigonometry",syntax:["acos(x)"],description:"Compute the inverse cosine of a value in radians.",examples:["acos(0.5)","acos(cos(2.3))"],seealso:["cos","atan","asin"]},acosh:{name:"acosh",category:"Trigonometry",syntax:["acosh(x)"],description:"Calculate the hyperbolic arccos of a value, defined as `acosh(x) = ln(sqrt(x^2 - 1) + x)`.",examples:["acosh(1.5)"],seealso:["cosh","asinh","atanh"]},acot:{name:"acot",category:"Trigonometry",syntax:["acot(x)"],description:"Calculate the inverse cotangent of a value.",examples:["acot(0.5)","acot(cot(0.5))","acot(2)"],seealso:["cot","atan"]},acoth:{name:"acoth",category:"Trigonometry",syntax:["acoth(x)"],description:"Calculate the hyperbolic arccotangent of a value, defined as `acoth(x) = (ln((x+1)/x) + ln(x/(x-1))) / 2`.",examples:["acoth(2)","acoth(0.5)"],seealso:["acsch","asech"]},acsc:{name:"acsc",category:"Trigonometry",syntax:["acsc(x)"],description:"Calculate the inverse cotangent of a value.",examples:["acsc(2)","acsc(csc(0.5))","acsc(0.5)"],seealso:["csc","asin","asec"]},acsch:{name:"acsch",category:"Trigonometry",syntax:["acsch(x)"],description:"Calculate the hyperbolic arccosecant of a value, defined as `acsch(x) = ln(1/x + sqrt(1/x^2 + 1))`.",examples:["acsch(0.5)"],seealso:["asech","acoth"]},asec:{name:"asec",category:"Trigonometry",syntax:["asec(x)"],description:"Calculate the inverse secant of a value.",examples:["asec(0.5)","asec(sec(0.5))","asec(2)"],seealso:["acos","acot","acsc"]},asech:{name:"asech",category:"Trigonometry",syntax:["asech(x)"],description:"Calculate the inverse secant of a value.",examples:["asech(0.5)"],seealso:["acsch","acoth"]},asin:{name:"asin",category:"Trigonometry",syntax:["asin(x)"],description:"Compute the inverse sine of a value in radians.",examples:["asin(0.5)","asin(sin(0.5))"],seealso:["sin","acos","atan"]},asinh:{name:"asinh",category:"Trigonometry",syntax:["asinh(x)"],description:"Calculate the hyperbolic arcsine of a value, defined as `asinh(x) = ln(x + sqrt(x^2 + 1))`.",examples:["asinh(0.5)"],seealso:["acosh","atanh"]},atan:{name:"atan",category:"Trigonometry",syntax:["atan(x)"],description:"Compute the inverse tangent of a value in radians.",examples:["atan(0.5)","atan(tan(0.5))"],seealso:["tan","acos","asin"]},atanh:{name:"atanh",category:"Trigonometry",syntax:["atanh(x)"],description:"Calculate the hyperbolic arctangent of a value, defined as `atanh(x) = ln((1 + x)/(1 - x)) / 2`.",examples:["atanh(0.5)"],seealso:["acosh","asinh"]},atan2:{name:"atan2",category:"Trigonometry",syntax:["atan2(y, x)"],description:"Computes the principal value of the arc tangent of y/x in radians.",examples:["atan2(2, 2) / pi","angle = 60 deg in rad","x = cos(angle)","y = sin(angle)","atan2(y, x)"],seealso:["sin","cos","tan"]},cos:{name:"cos",category:"Trigonometry",syntax:["cos(x)"],description:"Compute the cosine of x in radians.",examples:["cos(2)","cos(pi / 4) ^ 2","cos(180 deg)","cos(60 deg)","sin(0.2)^2 + cos(0.2)^2"],seealso:["acos","sin","tan"]},cosh:{name:"cosh",category:"Trigonometry",syntax:["cosh(x)"],description:"Compute the hyperbolic cosine of x in radians.",examples:["cosh(0.5)"],seealso:["sinh","tanh","coth"]},cot:{name:"cot",category:"Trigonometry",syntax:["cot(x)"],description:"Compute the cotangent of x in radians. Defined as 1/tan(x)",examples:["cot(2)","1 / tan(2)"],seealso:["sec","csc","tan"]},coth:{name:"coth",category:"Trigonometry",syntax:["coth(x)"],description:"Compute the hyperbolic cotangent of x in radians.",examples:["coth(2)","1 / tanh(2)"],seealso:["sech","csch","tanh"]},csc:{name:"csc",category:"Trigonometry",syntax:["csc(x)"],description:"Compute the cosecant of x in radians. Defined as 1/sin(x)",examples:["csc(2)","1 / sin(2)"],seealso:["sec","cot","sin"]},csch:{name:"csch",category:"Trigonometry",syntax:["csch(x)"],description:"Compute the hyperbolic cosecant of x in radians. Defined as 1/sinh(x)",examples:["csch(2)","1 / sinh(2)"],seealso:["sech","coth","sinh"]},sec:{name:"sec",category:"Trigonometry",syntax:["sec(x)"],description:"Compute the secant of x in radians. Defined as 1/cos(x)",examples:["sec(2)","1 / cos(2)"],seealso:["cot","csc","cos"]},sech:{name:"sech",category:"Trigonometry",syntax:["sech(x)"],description:"Compute the hyperbolic secant of x in radians. Defined as 1/cosh(x)",examples:["sech(2)","1 / cosh(2)"],seealso:["coth","csch","cosh"]},sin:{name:"sin",category:"Trigonometry",syntax:["sin(x)"],description:"Compute the sine of x in radians.",examples:["sin(2)","sin(pi / 4) ^ 2","sin(90 deg)","sin(30 deg)","sin(0.2)^2 + cos(0.2)^2"],seealso:["asin","cos","tan"]},sinh:{name:"sinh",category:"Trigonometry",syntax:["sinh(x)"],description:"Compute the hyperbolic sine of x in radians.",examples:["sinh(0.5)"],seealso:["cosh","tanh"]},tan:{name:"tan",category:"Trigonometry",syntax:["tan(x)"],description:"Compute the tangent of x in radians.",examples:["tan(0.5)","sin(0.5) / cos(0.5)","tan(pi / 4)","tan(45 deg)"],seealso:["atan","sin","cos"]},tanh:{name:"tanh",category:"Trigonometry",syntax:["tanh(x)"],description:"Compute the hyperbolic tangent of x in radians.",examples:["tanh(0.5)","sinh(0.5) / cosh(0.5)"],seealso:["sinh","cosh"]},to:{name:"to",category:"Units",syntax:["x to unit","to(x, unit)"],description:"Change the unit of a value.",examples:["5 inch to cm","3.2kg to g","16 bytes in bits"],seealso:[]},clone:{name:"clone",category:"Utils",syntax:["clone(x)"],description:"Clone a variable. Creates a copy of primitive variables,and a deep copy of matrices",examples:["clone(3.5)","clone(2 - 4i)","clone(45 deg)","clone([1, 2; 3, 4])",'clone("hello world")'],seealso:[]},format:{name:"format",category:"Utils",syntax:["format(value)","format(value, precision)"],description:"Format a value of any type as string.",examples:["format(2.3)","format(3 - 4i)","format([])","format(pi, 3)"],seealso:["print"]},bin:{name:"bin",category:"Utils",syntax:["bin(value)"],description:"Format a number as binary",examples:["bin(2)"],seealso:["oct","hex"]},oct:{name:"oct",category:"Utils",syntax:["oct(value)"],description:"Format a number as octal",examples:["oct(56)"],seealso:["bin","hex"]},hex:{name:"hex",category:"Utils",syntax:["hex(value)"],description:"Format a number as hexadecimal",examples:["hex(240)"],seealso:["bin","oct"]},isNaN:{name:"isNaN",category:"Utils",syntax:["isNaN(x)"],description:"Test whether a value is NaN (not a number)",examples:["isNaN(2)","isNaN(0 / 0)","isNaN(NaN)","isNaN(Infinity)"],seealso:["isNegative","isNumeric","isPositive","isZero"]},isInteger:{name:"isInteger",category:"Utils",syntax:["isInteger(x)"],description:"Test whether a value is an integer number.",examples:["isInteger(2)","isInteger(3.5)","isInteger([3, 0.5, -2])"],seealso:["isNegative","isNumeric","isPositive","isZero"]},isNegative:{name:"isNegative",category:"Utils",syntax:["isNegative(x)"],description:"Test whether a value is negative: smaller than zero.",examples:["isNegative(2)","isNegative(0)","isNegative(-4)","isNegative([3, 0.5, -2])"],seealso:["isInteger","isNumeric","isPositive","isZero"]},isNumeric:{name:"isNumeric",category:"Utils",syntax:["isNumeric(x)"],description:"Test whether a value is a numeric value. Returns true when the input is a number, BigNumber, Fraction, or boolean.",examples:["isNumeric(2)",'isNumeric("2")','hasNumericValue("2")',"isNumeric(0)","isNumeric(bignumber(500))","isNumeric(fraction(0.125))","isNumeric(2 + 3i)",'isNumeric([2.3, "foo", false])'],seealso:["isInteger","isZero","isNegative","isPositive","isNaN","hasNumericValue"]},hasNumericValue:{name:"hasNumericValue",category:"Utils",syntax:["hasNumericValue(x)"],description:"Test whether a value is an numeric value. In case of a string, true is returned if the string contains a numeric value.",examples:["hasNumericValue(2)",'hasNumericValue("2")','isNumeric("2")',"hasNumericValue(0)","hasNumericValue(bignumber(500))","hasNumericValue(fraction(0.125))","hasNumericValue(2 + 3i)",'hasNumericValue([2.3, "foo", false])'],seealso:["isInteger","isZero","isNegative","isPositive","isNaN","isNumeric"]},isPositive:{name:"isPositive",category:"Utils",syntax:["isPositive(x)"],description:"Test whether a value is positive: larger than zero.",examples:["isPositive(2)","isPositive(0)","isPositive(-4)","isPositive([3, 0.5, -2])"],seealso:["isInteger","isNumeric","isNegative","isZero"]},isPrime:{name:"isPrime",category:"Utils",syntax:["isPrime(x)"],description:"Test whether a value is prime: has no divisors other than itself and one.",examples:["isPrime(3)","isPrime(-2)","isPrime([2, 17, 100])"],seealso:["isInteger","isNumeric","isNegative","isZero"]},isZero:{name:"isZero",category:"Utils",syntax:["isZero(x)"],description:"Test whether a value is zero.",examples:["isZero(2)","isZero(0)","isZero(-4)","isZero([3, 0, -2, 0])"],seealso:["isInteger","isNumeric","isNegative","isPositive"]},typeOf:{name:"typeOf",category:"Utils",syntax:["typeOf(x)"],description:"Get the type of a variable.",examples:["typeOf(3.5)","typeOf(2 - 4i)","typeOf(45 deg)",'typeOf("hello world")'],seealso:["getMatrixDataType"]},numeric:{name:"numeric",category:"Utils",syntax:["numeric(x)"],description:"Convert a numeric input to a specific numeric type: number, BigNumber, or Fraction.",examples:['numeric("4")','numeric("4", "number")','numeric("4", "BigNumber")','numeric("4", "Fraction)','numeric(4, "Fraction")','numeric(fraction(2, 5), "number)'],seealso:["number","fraction","bignumber","string","format"]}},n=["typed","mathWithTransform","Help"],Ts=Object(a.a)("help",n,function(e){var t=e.typed,i=e.mathWithTransform,a=e.Help;return t("help",{any:function(e){var t,r=e;if("string"!=typeof e)for(t in i)if(Object(ae.f)(i,t)&&e===i[t]){r=t;break}var n=Wr(_s,r);if(n)return new a(n);n="function"==typeof r?r.name:r;throw new Error('No documentation found on "'+n+'"')}})}),n=["typed","Chain"],qs=Object(a.a)("chain",n,function(e){var t=e.typed,r=e.Chain;return t("chain",{"":function(){return new r},any:function(e){return new r(e)}})}),n=["typed","matrix","subtract","multiply","unaryMinus","lup"],Is=Object(a.a)("det",n,function(e){var t=e.typed,i=e.matrix,f=e.subtract,l=e.multiply,p=e.unaryMinus,m=e.lup;return t("det",{any:function(e){return Object(ae.a)(e)},"Array | Matrix":function(e){var t=Object(ie.v)(e)?e.size():Array.isArray(e)?(e=i(e)).size():[];switch(t.length){case 0:return Object(ae.a)(e);case 1:if(1===t[0])return Object(ae.a)(e.valueOf()[0]);throw new RangeError("Matrix must be square (size: "+Object(Z.d)(t)+")");case 2:var r=t[0],n=t[1];if(r===n)return function(e,t){{if(1===t)return Object(ae.a)(e[0][0]);if(2===t)return f(l(e[0][0],e[1][1]),l(e[1][0],e[0][1]));for(var r=m(e),n=r.U[0][0],i=1;i<t;i++)n=l(n,r.U[i][i]);for(var a=0,o=0,s=[];;){for(;s[o];)o++;if(t<=o)break;for(var u=o,c=0;!s[r.p[u]];)s[r.p[u]]=!0,u=r.p[u],c++;c%2==0&&a++}return a%2==0?n:p(n)}}(e.clone().valueOf(),r);throw new RangeError("Matrix must be square (size: "+Object(Z.d)(t)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+Object(Z.d)(t)+")")}}})}),n=["typed","matrix","divideScalar","addScalar","multiply","unaryMinus","det","identity","abs"],Bs=Object(a.a)("inv",n,function(e){var t=e.typed,i=e.matrix,g=e.divideScalar,b=e.addScalar,v=e.multiply,x=e.unaryMinus,w=e.det,N=e.identity,O=e.abs;return t("inv",{"Array | Matrix":function(e){var t=Object(ie.v)(e)?e.size():Object(E.a)(e);switch(t.length){case 1:if(1===t[0])return Object(ie.v)(e)?i([g(1,e.valueOf()[0])]):[g(1,e[0])];throw new RangeError("Matrix must be square (size: "+Object(Z.d)(t)+")");case 2:var r=t[0],n=t[1];if(r===n)return Object(ie.v)(e)?i(a(e.valueOf(),r,n),e.storage()):a(e,r,n);throw new RangeError("Matrix must be square (size: "+Object(Z.d)(t)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+Object(Z.d)(t)+")")}},any:function(e){return g(1,e)}});function a(e,t,r){var n,i,a;if(1===t){if(0===(o=e[0][0]))throw Error("Cannot calculate inverse, determinant is zero");return[[g(1,o)]]}if(2===t){var o=w(e);if(0===o)throw Error("Cannot calculate inverse, determinant is zero");return[[g(e[1][1],o),g(x(e[0][1]),o)],[g(x(e[1][0]),o),g(e[0][0],o)]]}var s=e.concat();for(p=0;p<t;p++)s[p]=s[p].concat();for(var u=N(t).valueOf(),c=0;c<r;c++){for(var f=O(s[c][c]),l=c,p=c+1;p<t;)O(s[p][c])>f&&(f=O(s[p][c]),l=p),p++;if(0===f)throw Error("Cannot calculate inverse, determinant is zero");(p=l)!==c&&(a=s[c],s[c]=s[p],s[p]=a,a=u[c],u[c]=u[p],u[p]=a);var m=s[c],h=u[c];for(p=0;p<t;p++){var d=s[p],y=u[p];if(p!==c){if(0!==d[c]){for(i=g(x(d[c]),m[c]),n=c;n<r;n++)d[n]=b(d[n],v(i,m[n]));for(n=0;n<r;n++)y[n]=b(y[n],v(i,h[n]))}}else{for(i=m[c],n=c;n<r;n++)d[n]=g(d[n],i);for(n=0;n<r;n++)y[n]=g(y[n],i)}}}return u}}),n=["config","typed","matrix","addScalar","equal","subtract","abs","atan","cos","sin","multiplyScalar","inv","bignumber","multiply","add"],ks=Object(a.a)("eigs",n,function(e){var h=e.config,t=e.typed,r=e.matrix,d=e.addScalar,y=e.subtract,o=e.equal,l=e.abs,p=e.atan,g=e.cos,b=e.sin,v=e.multiplyScalar,m=e.inv,x=e.bignumber,w=e.multiply,N=e.add;return t("eigs",{Array:function(e){var t=r(e),e=t.size();if(2!==e.length||e[0]!==e[1])throw new RangeError("Matrix must be square (size: "+Object(Z.d)(e)+")");e=n(t,e[0]);return{values:e[0],vectors:e[1]}},Matrix:function(e){var t=e.size();if(2!==t.length||t[0]!==t[1])throw new RangeError("Matrix must be square (size: "+Object(Z.d)(t)+")");t=n(e,t[0]);return{values:r(t[0]),vectors:r(t[1])}}});function n(e,t){var r=e.datatype();if(void 0===r&&(r=e.getDataType()),"number"!==r&&"BigNumber"!==r&&"Fraction"!==r)throw"mixed"===r?new TypeError("Mixed matrix element type is not supported"):new TypeError("Matrix element type not supported ("+r+")");if(!function(e,t){for(var r=0;r<t;r++)for(var n=r;n<t;n++)if(!o(e[r][n],e[n][r]))throw new TypeError("Input matrix is not symmetric")}(e.toArray(),t),"number"===r)return s(e.toArray());if("Fraction"!==r)return"BigNumber"===r?function(e){for(var t,r=e.length,n=l(h.epsilon/r),i=new Array(r),a=0;a<r;a++)i[a]=E(r,0),i[a][a]=1;var o=M(e);for(;l(o[1])>=l(n);){var s=o[0][0],u=o[0][1];t=function(e,t,r){e=y(t,e);return l(e)<=h.epsilon?x(-1).acos().div(4):v(.5,p(w(2,r,m(e))))}(e[s][s],e[u][u],e[s][u]),e=function(e,t,r,n){for(var i=e.length,a=x(g(t)),o=x(b(t)),s=v(a,a),u=v(o,o),c=E(i,x(0)),f=E(i,x(0)),l=w(x(2),a,o,e[r][n]),t=d(y(v(s,e[r][r]),l),v(u,e[n][n])),s=N(v(u,e[r][r]),l,v(s,e[n][n])),p=0;p<i;p++)c[p]=y(v(a,e[r][p]),v(o,e[n][p])),f[p]=d(v(o,e[r][p]),v(a,e[n][p]));e[r][r]=t,e[n][n]=s,e[r][n]=x(0),e[n][r]=x(0);for(var m=0;m<i;m++)m!==r&&m!==n&&(e[r][m]=c[m],e[m][r]=c[m],e[n][m]=f[m],e[m][n]=f[m]);return e}(e,t,s,u),i=function(e,t,r,n){for(var i=e.length,a=g(t),o=b(t),s=E(i,x(0)),u=E(i,x(0)),c=0;c<i;c++)s[c]=y(v(a,e[c][r]),v(o,e[c][n])),u[c]=d(v(o,e[c][r]),v(a,e[c][n]));for(var f=0;f<i;f++)e[f][r]=s[f],e[f][n]=u[f];return e}(i,t,s,u),o=M(e)}for(var c=E(r,0),f=0;f<r;f++)c[f]=e[f][f];return j(Object(ae.a)(c),Object(ae.a)(i))}(e.toArray()):void 0;for(var n=e.toArray(),i=0;i<t;i++)for(var a=i;a<t;a++)n[i][a]=n[i][a].valueOf(),n[a][i]=n[i][a];return s(e.toArray())}function s(e){for(var t=e.length,r=Math.abs(h.epsilon/t),n=new Array(t),i=0;i<t;i++)n[i]=E(t,0),n[i][i]=1;for(var a,o,s,u,c=O(e);Math.abs(c[1])>=Math.abs(r);){var f=c[0][0],l=c[0][1];a=e[f][f],o=e[l][l],s=e[f][l],u=void 0,u=o-a,e=function(e,t,r,n){for(var i=e.length,a=Math.cos(t),o=Math.sin(t),s=a*a,u=o*o,c=E(i,0),f=E(i,0),t=s*e[r][r]-2*a*o*e[r][n]+u*e[n][n],s=u*e[r][r]+2*a*o*e[r][n]+s*e[n][n],l=0;l<i;l++)c[l]=a*e[r][l]-o*e[n][l],f[l]=o*e[r][l]+a*e[n][l];e[r][r]=t,e[n][n]=s,e[r][n]=0;for(var p=e[n][r]=0;p<i;p++)p!==r&&p!==n&&(e[r][p]=c[p],e[p][r]=c[p],e[n][p]=f[p],e[p][n]=f[p]);return e}(e,a=Math.abs(u)<=h.epsilon?Math.PI/4:.5*Math.atan(2*s/(o-a)),f,l),n=function(e,t,r,n){for(var i=e.length,a=Math.cos(t),o=Math.sin(t),s=E(i,0),u=E(i,0),c=0;c<i;c++)s[c]=a*e[c][r]-o*e[c][n],u[c]=o*e[c][r]+a*e[c][n];for(var f=0;f<i;f++)e[f][r]=s[f],e[f][n]=u[f];return e}(n,a,f,l),c=O(e)}for(var p=E(t,0),m=0;m<t;m++)p[m]=e[m][m];return j(Object(ae.a)(p),Object(ae.a)(n))}function O(e){for(var t=e.length,r=0,n=[0,1],i=0;i<t;i++)for(var a=i+1;a<t;a++)Math.abs(r)<Math.abs(e[i][a])&&(r=Math.abs(e[i][a]),n=[i,a]);return[n,r]}function M(e){for(var t=e.length,r=0,n=[0,1],i=0;i<t;i++)for(var a=i+1;a<t;a++)l(r)<l(e[i][a])&&(r=l(e[i][a]),n=[i,a]);return[n,r]}function j(e,t){for(var r=e.length,n=Array(r),i=Array(r),a=0;a<r;a++)i[a]=Array(r);for(var o=0;o<r;o++){for(var s=0,u=e[0],c=0;c<e.length;c++)e[c]<u&&(u=e[s=c]);n[o]=e.splice(s,1)[0];for(var f=0;f<r;f++)i[f][o]=t[f][s],t[f].splice(s,1)}return[Object(ae.a)(n),Object(ae.a)(i)]}function E(e,t){for(var r=new Array(e),n=0;n<e;n++)r[n]=t;return r}}),n=["typed","abs","add","identity","inv","multiply"],zs=Object(a.a)("expm",n,function(e){var t=e.typed,h=e.abs,d=e.add,y=e.identity,g=e.inv,b=e.multiply;return t("expm",{Matrix:function(e){var t=e.size();if(2!==t.length||t[0]!==t[1])throw new RangeError("Matrix must be square (size: "+Object(Z.d)(t)+")");for(var r=t[0],t=function(e,t){for(var r=0;r<30;r++)for(var n=0;n<=r;n++){var i=r-n;if(function(e,t,r){for(var n=1,i=2;i<=t;i++)n*=i;for(var a=n,o=t+1;o<=2*t;o++)a*=o;var s=a*(2*t+1);return 8*Math.pow(e/Math.pow(2,r),2*t)*n*n/(a*s)}(e,n,i)<t)return{q:n,j:i}}throw new Error("Could not find acceptable parameters to compute the matrix exponential (try increasing maxSearchSize in expm.js)")}(function(e){for(var t=e.size()[0],r=0,n=0;n<t;n++){for(var i=0,a=0;a<t;a++)i+=h(e.get([n,a]));r=Math.max(i,r)}return r}(e),1e-15),n=t.q,i=t.j,a=b(e,Math.pow(2,-i)),o=y(r),s=y(r),u=1,c=a,f=-1,l=1;l<=n;l++)1<l&&(c=b(c,a),f=-f),o=d(o,b(u=u*(n-l+1)/((2*n-l+1)*l),c)),s=d(s,b(u*f,c));for(var p=b(g(s),o),m=0;m<i;m++)p=b(p,p);return Object(ie.H)(e)?e.createSparseMatrix(p):p}})}),n=["typed","abs","add","multiply","sqrt","subtract","inv","size","max","identity"],Ds=Object(a.a)("sqrtm",n,function(e){var t=e.typed,a=e.abs,o=e.add,s=e.multiply,r=e.sqrt,u=e.subtract,c=e.inv,f=e.size,l=e.max,p=e.identity;return t("sqrtm",{"Array | Matrix":function(e){var t=Object(ie.v)(e)?e.size():Object(E.a)(e);switch(t.length){case 1:if(1===t[0])return r(e);throw new RangeError("Matrix must be square (size: "+Object(Z.d)(t)+")");case 2:if(t[0]===t[1])return function(e){var t=0,r=e,n=p(f(e));do{var i=r,r=s(.5,o(i,c(n))),n=s(.5,o(n,c(i)));if(1e-6<(i=l(a(u(r,i))))&&1e3<++t)throw new Error("computing square root of matrix: iterative method could not converge")}while(1e-6<i);return r}(e);throw new RangeError("Matrix must be square (size: "+Object(Z.d)(t)+")");default:throw new RangeError("Matrix must be at most two dimensional (size: "+Object(Z.d)(t)+")")}}})}),n=["typed","matrix","multiply","equalScalar","divideScalar","inv"],Rs=Object(a.a)("divide",n,function(e){var t=e.typed,r=e.matrix,n=e.multiply,i=e.equalScalar,a=e.divideScalar,o=e.inv,s=Ve({typed:t,equalScalar:i}),u=Ze({typed:t});return t("divide",Object(ae.e)({"Array | Matrix, Array | Matrix":function(e,t){return n(e,o(t))},"DenseMatrix, any":function(e,t){return u(e,t,a,!1)},"SparseMatrix, any":function(e,t){return s(e,t,a,!1)},"Array, any":function(e,t){return u(r(e),t,a,!1).valueOf()},"any, Array | Matrix":function(e,t){return n(e,o(t))}},a.signatures))}),Us="distance",n=["typed","addScalar","subtract","divideScalar","multiplyScalar","unaryMinus","sqrt","abs"],Ps=Object(a.a)(Us,n,function(e){var t=e.typed,c=e.addScalar,f=e.subtract,l=e.multiplyScalar,p=e.divideScalar,i=e.unaryMinus,m=e.sqrt,a=e.abs;return t(Us,{"Array, Array, Array":function(e,t,r){if(2!==e.length||2!==t.length||2!==r.length)throw new TypeError("Invalid Arguments: Try again");if(!o(e))throw new TypeError("Array with 2 numbers or BigNumbers expected for first argument");if(!o(t))throw new TypeError("Array with 2 numbers or BigNumbers expected for second argument");if(!o(r))throw new TypeError("Array with 2 numbers or BigNumbers expected for third argument");var n=p(f(r[1],r[0]),f(t[1],t[0])),r=l(l(n,n),t[0]),n=i(l(n,t[0])),t=e[1];return d(e[0],e[1],r,n,t)},"Object, Object, Object":function(e,t,r){if(2!==Object.keys(e).length||2!==Object.keys(t).length||2!==Object.keys(r).length)throw new TypeError("Invalid Arguments: Try again");if(!o(e))throw new TypeError("Values of pointX and pointY should be numbers or BigNumbers");if(!o(t))throw new TypeError("Values of lineOnePtX and lineOnePtY should be numbers or BigNumbers");if(!o(r))throw new TypeError("Values of lineTwoPtX and lineTwoPtY should be numbers or BigNumbers");if("pointX"in e&&"pointY"in e&&"lineOnePtX"in t&&"lineOnePtY"in t&&"lineTwoPtX"in r&&"lineTwoPtY"in r){var n=p(f(r.lineTwoPtY,r.lineTwoPtX),f(t.lineOnePtY,t.lineOnePtX)),r=l(l(n,n),t.lineOnePtX),n=i(l(n,t.lineOnePtX)),t=e.pointX;return d(e.pointX,e.pointY,r,n,t)}throw new TypeError("Key names do not match")},"Array, Array":function(e,t){if(2===e.length&&3===t.length){if(!o(e))throw new TypeError("Array with 2 numbers or BigNumbers expected for first argument");if(!n(t))throw new TypeError("Array with 3 numbers or BigNumbers expected for second argument");return d(e[0],e[1],t[0],t[1],t[2])}if(3===e.length&&6===t.length){if(!n(e))throw new TypeError("Array with 3 numbers or BigNumbers expected for first argument");if(!u(t))throw new TypeError("Array with 6 numbers or BigNumbers expected for second argument");return y(e[0],e[1],e[2],t[0],t[1],t[2],t[3],t[4],t[5])}if(e.length===t.length&&0<e.length){if(!s(e))throw new TypeError("All values of an array should be numbers or BigNumbers");if(!s(t))throw new TypeError("All values of an array should be numbers or BigNumbers");return g(e,t)}throw new TypeError("Invalid Arguments: Try again")},"Object, Object":function(e,t){if(2===Object.keys(e).length&&3===Object.keys(t).length){if(!o(e))throw new TypeError("Values of pointX and pointY should be numbers or BigNumbers");if(!n(t))throw new TypeError("Values of xCoeffLine, yCoeffLine and constant should be numbers or BigNumbers");if("pointX"in e&&"pointY"in e&&"xCoeffLine"in t&&"yCoeffLine"in t&&"constant"in t)return d(e.pointX,e.pointY,t.xCoeffLine,t.yCoeffLine,t.constant);throw new TypeError("Key names do not match")}if(3===Object.keys(e).length&&6===Object.keys(t).length){if(!n(e))throw new TypeError("Values of pointX, pointY and pointZ should be numbers or BigNumbers");if(!u(t))throw new TypeError("Values of x0, y0, z0, a, b and c should be numbers or BigNumbers");if("pointX"in e&&"pointY"in e&&"x0"in t&&"y0"in t&&"z0"in t&&"a"in t&&"b"in t&&"c"in t)return y(e.pointX,e.pointY,e.pointZ,t.x0,t.y0,t.z0,t.a,t.b,t.c);throw new TypeError("Key names do not match")}if(2===Object.keys(e).length&&2===Object.keys(t).length){if(!o(e))throw new TypeError("Values of pointOneX and pointOneY should be numbers or BigNumbers");if(!o(t))throw new TypeError("Values of pointTwoX and pointTwoY should be numbers or BigNumbers");if("pointOneX"in e&&"pointOneY"in e&&"pointTwoX"in t&&"pointTwoY"in t)return g([e.pointOneX,e.pointOneY],[t.pointTwoX,t.pointTwoY]);throw new TypeError("Key names do not match")}if(3!==Object.keys(e).length||3!==Object.keys(t).length)throw new TypeError("Invalid Arguments: Try again");if(!n(e))throw new TypeError("Values of pointOneX, pointOneY and pointOneZ should be numbers or BigNumbers");if(!n(t))throw new TypeError("Values of pointTwoX, pointTwoY and pointTwoZ should be numbers or BigNumbers");if("pointOneX"in e&&"pointOneY"in e&&"pointOneZ"in e&&"pointTwoX"in t&&"pointTwoY"in t&&"pointTwoZ"in t)return g([e.pointOneX,e.pointOneY,e.pointOneZ],[t.pointTwoX,t.pointTwoY,t.pointTwoZ]);throw new TypeError("Key names do not match")},Array:function(e){if(!function(e){if(2===e[0].length&&r(e[0][0])&&r(e[0][1])){if(e.some(function(e){return 2!==e.length||!r(e[0])||!r(e[1])}))return!1}else{if(!(3===e[0].length&&r(e[0][0])&&r(e[0][1])&&r(e[0][2])))return!1;if(e.some(function(e){return 3!==e.length||!r(e[0])||!r(e[1])||!r(e[2])}))return!1}return!0}(e))throw new TypeError("Incorrect array format entered for pairwise distance calculation");return function(e){for(var t=[],r=[],n=[],i=0;i<e.length-1;i++)for(var a=i+1;a<e.length;a++)2===e[0].length?(r=[e[i][0],e[i][1]],n=[e[a][0],e[a][1]]):3===e[0].length&&(r=[e[i][0],e[i][1],e[i][2]],n=[e[a][0],e[a][1],e[a][2]]),t.push(g(r,n));return t}(e)}});function r(e){return"number"==typeof e||Object(ie.e)(e)}function o(e){return e.constructor!==Array&&(e=h(e)),r(e[0])&&r(e[1])}function n(e){return e.constructor!==Array&&(e=h(e)),r(e[0])&&r(e[1])&&r(e[2])}function s(e){return Array.isArray(e)||(e=h(e)),e.every(r)}function u(e){return e.constructor!==Array&&(e=h(e)),r(e[0])&&r(e[1])&&r(e[2])&&r(e[3])&&r(e[4])&&r(e[5])}function h(e){for(var t=Object.keys(e),r=[],n=0;n<t.length;n++)r.push(e[t[n]]);return r}function d(e,t,r,n,i){i=a(c(c(l(r,e),l(n,t)),i)),n=m(c(l(r,r),l(n,n)));return p(i,n)}function y(e,t,r,n,i,a,o,s,u){t=[f(l(f(i,t),u),l(f(a,r),s)),f(l(f(a,r),o),l(f(n,e),u)),f(l(f(n,e),s),l(f(i,t),o))],t=m(c(c(l(t[0],t[0]),l(t[1],t[1])),l(t[2],t[2]))),u=m(c(c(l(o,o),l(s,s)),l(u,u)));return p(t,u)}function g(e,t){for(var r,n=e.length,i=0,a=0;a<n;a++)r=f(e[a],t[a]),i=c(l(r,r),i);return m(i)}}),n=["typed","config","abs","add","addScalar","matrix","multiply","multiplyScalar","divideScalar","subtract","smaller","equalScalar"],Fs=Object(a.a)("intersect",n,function(e){var t=e.typed,g=e.config,b=e.abs,v=e.add,x=e.addScalar,i=e.matrix,w=e.multiply,N=e.multiplyScalar,O=e.divideScalar,M=e.subtract,j=e.smaller,E=e.equalScalar;return t("intersect",{"Array, Array, Array":function(e,t,r){if(!A(e))throw new TypeError("Array with 3 numbers or BigNumbers expected for first argument");if(!A(t))throw new TypeError("Array with 3 numbers or BigNumbers expected for second argument");if(!(4===(p=r).length&&m(p[0])&&m(p[1])&&m(p[2])&&m(p[3])))throw new TypeError("Array with 4 numbers expected as third argument");var n,i,a,o,s,u,c,f,l,p;return n=e[0],i=e[1],a=e[2],o=t[0],s=t[1],u=t[2],c=r[0],f=r[1],l=r[2],p=r[3],e=N(n,c),t=N(o,c),r=N(i,f),c=N(s,f),f=N(a,l),l=N(u,l),f=O(M(M(M(p,e),r),f),M(M(M(x(x(t,c),l),e),r),f)),n=x(n,N(f,M(o,n))),i=x(i,N(f,M(s,i))),a=x(a,N(f,M(u,a))),[n,i,a]},"Array, Array, Array, Array":function(e,t,r,n){if(2===e.length){if(!S(e))throw new TypeError("Array with 2 numbers or BigNumbers expected for first argument");if(!S(t))throw new TypeError("Array with 2 numbers or BigNumbers expected for second argument");if(!S(r))throw new TypeError("Array with 2 numbers or BigNumbers expected for third argument");if(!S(n))throw new TypeError("Array with 2 numbers or BigNumbers expected for fourth argument");return function(e,t,r,n){var i=e,a=r,o=M(i,t),s=M(a,n),e=M(N(o[0],s[1]),N(s[0],o[1]));if(j(b(e),g.epsilon))return null;r=N(s[0],i[1]),t=N(s[1],i[0]),n=N(s[0],a[1]),a=N(s[1],a[0]),e=O(x(M(M(r,t),n),a),e);return v(w(o,e),i)}(e,t,r,n)}if(3!==e.length)throw new TypeError("Arrays with two or thee dimensional points expected");if(!A(e))throw new TypeError("Array with 3 numbers or BigNumbers expected for first argument");if(!A(t))throw new TypeError("Array with 3 numbers or BigNumbers expected for second argument");if(!A(r))throw new TypeError("Array with 3 numbers or BigNumbers expected for third argument");if(!A(n))throw new TypeError("Array with 3 numbers or BigNumbers expected for fourth argument");return i=e[0],a=e[1],o=e[2],s=t[0],u=t[1],c=t[2],f=r[0],l=r[1],p=r[2],m=n[0],h=n[1],d=n[2],y=C(i,f,m,f,a,l,h,l,o,p,d,p),e=C(m,f,s,i,h,l,u,a,d,p,c,o),t=C(i,f,s,i,a,l,u,a,o,p,c,o),r=C(m,f,m,f,h,l,h,l,d,p,d,p),n=C(s,i,s,i,u,a,u,a,c,o,c,o),n=O(M(N(y,e),N(t,r)),M(N(n,r),N(e,e))),r=O(x(y,N(n,e)),r),i=x(i,N(n,M(s,i))),a=x(a,N(n,M(u,a))),o=x(o,N(n,M(c,o))),f=x(f,N(r,M(m,f))),l=x(l,N(r,M(h,l))),p=x(p,N(r,M(d,p))),E(i,f)&&E(a,l)&&E(o,p)?[i,a,o]:null;var i,a,o,s,u,c,f,l,p,m,h,d,y},"Matrix, Matrix, Matrix":function(e,t,r){return i(this(e.valueOf(),t.valueOf(),r.valueOf()))},"Matrix, Matrix, Matrix, Matrix":function(e,t,r,n){return i(this(e.valueOf(),t.valueOf(),r.valueOf(),n.valueOf()))}});function m(e){return"number"==typeof e||Object(ie.e)(e)}function S(e){return 2===e.length&&m(e[0])&&m(e[1])}function A(e){return 3===e.length&&m(e[0])&&m(e[1])&&m(e[2])}function C(e,t,r,n,i,a,o,s,u,c,f,l){n=N(M(e,t),M(r,n)),s=N(M(i,a),M(o,s)),l=N(M(u,c),M(f,l));return x(x(n,s),l)}}),n=["typed","config","add","numeric"],Ls=Object(a.a)("sum",n,function(e){var t=e.typed,n=e.config,i=e.add,a=e.numeric;return t("sum",{"Array | Matrix":r,"Array | Matrix, number | BigNumber":function(e,t){try{return C(e,t,i)}catch(e){throw vn(e,"sum")}},"...":function(e){if(S(e))throw new TypeError("Scalar values expected in function sum");return r(e)}});function r(e){var r;return A(e,function(t){try{r=void 0===r?t:i(r,t)}catch(e){throw vn(e,"sum",t)}}),void 0===r&&(r=a(0,n.number)),"string"==typeof r&&(r=a(r,n.number)),r}}),n=["typed","add","divide"],Hs=Object(a.a)("mean",n,function(e){var t=e.typed,i=e.add,a=e.divide;return t("mean",{"Array | Matrix":r,"Array | Matrix, number | BigNumber":function(e,t){try{var r=C(e,t,i),n=Array.isArray(e)?Object(E.a)(e):e.size();return a(r,n[t])}catch(e){throw vn(e,"mean")}},"...":function(e){if(S(e))throw new TypeError("Scalar values expected in function mean");return r(e)}});function r(e){var r,n=0;if(A(e,function(t){try{r=void 0===r?t:i(r,t),n++}catch(e){throw vn(e,"mean",t)}}),0===n)throw new Error("Cannot calculate the mean of an empty array");return a(r,n)}}),n=["typed","add","divide","compare","partitionSelect"],$s=Object(a.a)("median",n,function(e){var t=e.typed,r=e.add,n=e.divide,o=e.compare,s=e.partitionSelect;function i(e){try{var t=(e=Object(E.e)(e.valueOf())).length;if(0===t)throw new Error("Cannot calculate median of an empty array");if(t%2==0){for(var r=t/2-1,n=s(e,1+r),i=e[r],a=0;a<r;++a)0<o(e[a],i)&&(i=e[a]);return c(i,n)}t=s(e,(t-1)/2);return u(t)}catch(e){throw vn(e,"median")}}var u=t({"number | BigNumber | Complex | Unit":function(e){return e}}),c=t({"number | BigNumber | Complex | Unit, number | BigNumber | Complex | Unit":function(e,t){return n(r(e,t),2)}});return t("median",{"Array | Matrix":i,"Array | Matrix, number | BigNumber":function(){throw new Error("median(A, dim) is not yet supported")},"...":function(e){if(S(e))throw new TypeError("Scalar values expected in function median");return i(e)}})}),n=["typed","abs","map","median","subtract"],Gs=Object(a.a)("mad",n,function(e){var t=e.typed,r=e.abs,n=e.map,i=e.median,a=e.subtract;return t("mad",{"Array | Matrix":o,"...":o});function o(e){if(0===(e=Object(E.e)(e.valueOf())).length)throw new Error("Cannot calculate median absolute deviation (mad) of an empty array");try{var t=i(e);return i(n(e,function(e){return r(a(e,t))}))}catch(e){throw e instanceof TypeError&&-1!==e.message.indexOf("median")?new TypeError(e.message.replace("median","mad")):vn(e,"mad")}}}),Vs="unbiased",Zs="variance",n=["typed","add","subtract","multiply","divide","apply","isNaN"],Js=Object(a.a)(Zs,n,function(e){var t=e.typed,a=e.add,o=e.subtract,s=e.multiply,u=e.divide,n=e.apply,c=e.isNaN;return t(Zs,{"Array | Matrix":function(e){return i(e,Vs)},"Array | Matrix, string":i,"Array | Matrix, number | BigNumber":function(e,t){return r(e,t,Vs)},"Array | Matrix, number | BigNumber, string":r,"...":function(e){return i(e,Vs)}});function i(e,t){var r=0;if(0===e.length)throw new SyntaxError("Function variance requires one or more parameters (0 provided)");if(A(e,function(t){try{i=void 0===i?t:a(i,t),r++}catch(e){throw vn(e,"variance",t)}}),0===r)throw new Error("Cannot calculate variance of an empty array");var n=u(i,r),i=void 0;if(A(e,function(e){e=o(e,n);i=void 0===i?s(e,e):a(i,s(e,e))}),c(i))return i;switch(t){case"uncorrected":return u(i,r);case"biased":return u(i,r+1);case"unbiased":e=Object(ie.e)(i)?i.mul(0):0;return 1===r?e:u(i,r-1);default:throw new Error('Unknown normalization "'+t+'". Choose "unbiased" (default), "uncorrected", or "biased".')}}function r(e,t,r){try{if(0===e.length)throw new SyntaxError("Function variance requires one or more parameters (0 provided)");return n(e,t,function(e){return i(e,r)})}catch(e){throw vn(e,"variance")}}}),n=["typed","add","multiply","partitionSelect","compare"],Ws=Object(a.a)("quantileSeq",n,function(e){var t=e.typed,y=e.add,g=e.multiply,b=e.partitionSelect,v=e.compare;function h(e,t,r){var n=Object(E.e)(e),i=n.length;if(0===i)throw new Error("Cannot calculate quantile of an empty sequence");if(Object(ie.y)(t)){var a=t*(i-1),o=a%1;if(0==o){e=r?n[a]:b(n,a);return x(e),e}var s,u,c=Math.floor(a);if(r)s=n[c],u=n[c+1];else{u=b(n,c+1),s=n[c];for(var f=0;f<c;++f)0<v(n[f],s)&&(s=n[f])}return x(s),x(u),y(g(s,1-o),g(u,o))}i=t.times(i-1);if(i.isInteger()){i=i.toNumber();var l=r?n[i]:b(n,i);return x(l),l}var p,m,l=i.floor(),i=i.minus(l),h=l.toNumber();if(r)p=n[h],m=n[h+1];else{m=b(n,h+1),p=n[h];for(var d=0;d<h;++d)0<v(n[d],p)&&(p=n[d])}x(p),x(m);r=new i.constructor(1);return y(g(p,r.minus(i)),g(m,i))}var x=t({"number | BigNumber | Unit":function(e){return e}});return function(e,t,r){var n,i;if(arguments.length<2||3<arguments.length)throw new SyntaxError("Function quantileSeq requires two or three parameters");if(Object(ie.i)(e)){if("boolean"!=typeof(r=r||!1))throw new TypeError("Unexpected type of argument in function quantileSeq");if(n=e.valueOf(),Object(ie.y)(t)){if(t<0)throw new Error("N/prob must be non-negative");if(t<=1)return h(n,t,r);if(1<t){if(!Object(N.i)(t))throw new Error("N must be a positive integer");for(var a=t+1,o=new Array(t),s=0;s<t;)o[s]=h(n,++s/a,r);return o}}if(Object(ie.e)(t)){var u=t.constructor;if(t.isNegative())throw new Error("N/prob must be non-negative");if(i=new u(1),t.lte(i))return new u(h(n,t,r));if(t.gt(i)){if(!t.isInteger())throw new Error("N must be a positive integer");var c=t.toNumber();if(4294967295<c)throw new Error("N must be less than or equal to 2^32-1, as that is the maximum length of an Array");var f=new u(c+1);o=new Array(c);for(var l=0;l<c;)o[l]=new u(h(n,new u(++l).div(f),r));return o}}if(Array.isArray(t)){o=new Array(t.length);for(var p=0;p<o.length;++p){var m=t[p];if(Object(ie.y)(m)){if(m<0||1<m)throw new Error("Probability must be between 0 and 1, inclusive")}else{if(!Object(ie.e)(m))throw new TypeError("Unexpected type of argument in function quantileSeq");if(i=new m.constructor(1),m.isNegative()||m.gt(i))throw new Error("Probability must be between 0 and 1, inclusive")}o[p]=h(n,m,r)}return o}throw new TypeError("Unexpected type of argument in function quantileSeq")}throw new TypeError("Unexpected type of argument in function quantileSeq")}}),n=["typed","sqrt","variance"],Ys=Object(a.a)("std",n,function(e){var t=e.typed,r=e.sqrt,n=e.variance;return t("std",{"Array | Matrix":i,"Array | Matrix, string":i,"Array | Matrix, number | BigNumber":i,"Array | Matrix, number | BigNumber, string":i,"...":function(e){return i(e)}});function i(e,t){if(0===e.length)throw new SyntaxError("Function std requires one or more parameters (0 provided)");try{return r(n.apply(null,arguments))}catch(e){throw e instanceof TypeError&&-1!==e.message.indexOf(" variance")?new TypeError(e.message.replace(" variance"," std")):e}}});function Xs(e,t){if(t<e)return 1;if(t===e)return t;var r=t+e>>1;return Xs(e,r)*Xs(1+r,t)}function Qs(e,t){if(!Object(N.i)(e)||e<0)throw new TypeError("Positive integer value expected in function combinations");if(!Object(N.i)(t)||t<0)throw new TypeError("Positive integer value expected in function combinations");if(e<t)throw new TypeError("k must be less than or equal to n");var r=e-t;return t<r?Xs(1+r,e)/Xs(1,t):Xs(t+1,e)/Xs(1,r)}Qs.signature="number, number";var Ks="combinations",n=["typed"],eu=Object(a.a)(Ks,n,function(e){return(0,e.typed)(Ks,{"number, number":Qs,"BigNumber, BigNumber":function(e,t){var r,n,i=e.constructor,a=e.minus(t),o=new i(1);if(!tu(e)||!tu(t))throw new TypeError("Positive integer value expected in function combinations");if(t.gt(e))throw new TypeError("k must be less than n in function combinations");if(r=o,t.lt(a))for(n=o;n.lte(a);n=n.plus(o))r=r.times(t.plus(n)).dividedBy(n);else for(n=o;n.lte(t);n=n.plus(o))r=r.times(a.plus(n)).dividedBy(n);return r}})});function tu(e){return e.isInteger()&&e.gte(0)}var ru="combinationsWithRep",n=["typed"],nu=Object(a.a)(ru,n,function(e){return(0,e.typed)(ru,{"number, number":function(e,t){if(!Object(N.i)(e)||e<0)throw new TypeError("Positive integer value expected in function combinationsWithRep");if(!Object(N.i)(t)||t<0)throw new TypeError("Positive integer value expected in function combinationsWithRep");if(e<1)throw new TypeError("k must be less than or equal to n + k - 1");return t<e-1?Xs(e,e+t-1)/Xs(1,t):Xs(t+1,e+t-1)/Xs(1,e-1)},"BigNumber, BigNumber":function(e,t){var r,n,i=new e.constructor(1),a=e.minus(i);if(!iu(e)||!iu(t))throw new TypeError("Positive integer value expected in function combinationsWithRep");if(e.lt(i))throw new TypeError("k must be less than or equal to n + k - 1 in function combinationsWithRep");if(r=i,t.lt(a))for(n=i;n.lte(a);n=n.plus(i))r=r.times(t.plus(n)).dividedBy(n);else for(n=i;n.lte(t);n=n.plus(i))r=r.times(a.plus(n)).dividedBy(n);return r}})});function iu(e){return e.isInteger()&&e.gte(0)}function au(e){var t;if(Object(N.i)(e))return e<=0?isFinite(e)?1/0:NaN:171<e?1/0:Xs(1,e-1);if(e<.5)return Math.PI/(Math.sin(Math.PI*e)*au(1-e));if(171.35<=e)return 1/0;if(85<e){var r=e*e,n=r*e,i=n*e,a=i*e;return Math.sqrt(2*Math.PI/e)*Math.pow(e/Math.E,e)*(1+1/(12*e)+1/(288*r)-139/(51840*n)-571/(2488320*i)+163879/(209018880*a)+5246819/(75246796800*a*e))}--e,t=su[0];for(var o=1;o<su.length;++o)t+=su[o]/(e+o);a=e+ou+.5;return Math.sqrt(2*Math.PI)*Math.pow(a,e+.5)*Math.exp(-a)*t}au.signature="number";var ou=4.7421875,su=[.9999999999999971,57.15623566586292,-59.59796035547549,14.136097974741746,-.4919138160976202,3399464998481189e-20,4652362892704858e-20,-9837447530487956e-20,.0001580887032249125,-.00021026444172410488,.00021743961811521265,-.0001643181065367639,8441822398385275e-20,-26190838401581408e-21,36899182659531625e-22],n=["typed","config","multiplyScalar","pow","BigNumber","Complex"],uu=Object(a.a)("gamma",n,function(e){var t=e.typed,o=e.config,u=e.multiplyScalar,c=e.pow,s=e.BigNumber,f=e.Complex;return t("gamma",{number:au,Complex:function(e){if(0===e.im)return this(e.re);e=new f(e.re-1,e.im);for(var t=new f(su[0],0),r=1;r<su.length;++r){var n=e.re+r,i=n*n+e.im*e.im;0!=i?(t.re+=su[r]*n/i,t.im+=-(su[r]*e.im)/i):t.re=su[r]<0?-1/0:1/0}var a=new f(e.re+ou+.5,e.im),o=Math.sqrt(2*Math.PI);e.re+=.5;var s=c(a,e);0===s.im?s.re*=o:(0===s.re||(s.re*=o),s.im*=o);o=Math.exp(-a.re);return a.re=o*Math.cos(-a.im),a.im=o*Math.sin(-a.im),u(u(s,a),t)},BigNumber:function(e){if(e.isInteger())return e.isNegative()||e.isZero()?new s(1/0):function e(t){if(t<8)return new s([1,1,2,6,24,120,720,5040][t]);var r=o.precision+(0|Math.log(t.toNumber()));var r=s.clone({precision:r});if(t%2==1)return t.times(e(new s(t-1)));var n=t;var i=new r(t);var a=t.toNumber();for(;2<n;)a+=n-=2,i=i.times(a);return new s(i.toPrecision(s.precision))}(e.minus(1));if(!e.isFinite())return new s(e.isNegative()?NaN:1/0);throw new Error("Integer BigNumber expected")},"Array | Matrix":function(e){return oe(e,this)}})}),cu="factorial",n=["typed","gamma"],fu=Object(a.a)(cu,n,function(e){var t=e.typed,r=e.gamma;return t(cu,{number:function(e){if(e<0)throw new Error("Value must be non-negative");return r(e+1)},BigNumber:function(e){if(e.isNegative())throw new Error("Value must be non-negative");return r(e.plus(1))},"Array | Matrix":function(e){return oe(e,this)}})}),lu="kldivergence",n=["typed","matrix","divide","sum","multiply","dotDivide","log","isNumeric"],pu=Object(a.a)(lu,n,function(e){var t=e.typed,r=e.matrix,i=e.divide,a=e.sum,o=e.multiply,s=e.dotDivide,u=e.log,c=e.isNumeric;return t(lu,{"Array, Array":function(e,t){return n(r(e),r(t))},"Matrix, Array":function(e,t){return n(e,r(t))},"Array, Matrix":function(e,t){return n(r(e),t)},"Matrix, Matrix":n});function n(e,t){var r=t.size().length,n=e.size().length;if(1<r)throw new Error("first object must be one dimensional");if(1<n)throw new Error("second object must be one dimensional");if(r!==n)throw new Error("Length of two vectors must be equal");if(0===a(e))throw new Error("Sum of elements in first object must be non zero");if(0===a(t))throw new Error("Sum of elements in second object must be non zero");e=i(e,a(e)),t=i(t,a(t)),t=a(o(e,u(s(e,t))));return c(t)?t:Number.NaN}}),mu="multinomial",n=["typed","add","divide","multiply","factorial","isInteger","isPositive"],hu=Object(a.a)(mu,n,function(e){var t=e.typed,n=e.add,i=e.divide,a=e.multiply,o=e.factorial,s=e.isInteger,u=e.isPositive;return t(mu,{"Array | Matrix":function(e){var t=0,r=1;return A(e,function(e){if(!s(e)||!u(e))throw new TypeError("Positive integer value expected in function multinomial");t=n(t,e),r=a(r,o(e))}),i(o(t),r)}})}),du="permutations",n=["typed","factorial"],yu=Object(a.a)(du,n,function(e){var t=e.typed,e=e.factorial;return t(du,{"number | BigNumber":e,"number, number":function(e,t){if(!Object(N.i)(e)||e<0)throw new TypeError("Positive integer value expected in function permutations");if(!Object(N.i)(t)||t<0)throw new TypeError("Positive integer value expected in function permutations");if(e<t)throw new TypeError("second argument k must be less than or equal to first argument n");return Xs(e-t+1,e)},"BigNumber, BigNumber":function(e,t){if(!gu(e)||!gu(t))throw new TypeError("Positive integer value expected in function permutations");if(t.gt(e))throw new TypeError("second argument k must be less than or equal to first argument n");for(var r=e.mul(0).add(1),n=e.minus(t).plus(1);n.lte(e);n=n.plus(1))r=r.times(n);return r}})});function gu(e){return e.isInteger()&&e.gte(0)}var n=r(15),bu=r.n(n),vu=bu()();function xu(e){var t,r;return t=null===(r=e)?vu:bu()(String(r)),function(){return t()}}var n=["typed","config","?on"],wu=Object(a.a)("pickRandom",n,function(e){var t=e.typed,r=e.config,e=e.on,m=xu(r.randomSeed);return e&&e("config",function(e,t){e.randomSeed!==t.randomSeed&&(m=xu(e.randomSeed))}),t({"Array | Matrix":function(e){return n(e)},"Array | Matrix, number":function(e,t){return n(e,t,void 0)},"Array | Matrix, Array":function(e,t){return n(e,void 0,t)},"Array | Matrix, Array | Matrix, number":function(e,t,r){return n(e,r,t)},"Array | Matrix, number, Array | Matrix":n});function n(e,t,r){var n=void 0===t;n&&(t=1),e=Object(E.e)(e.valueOf()).valueOf();var i=0;if(void 0!==(r=r&&r.valueOf())){if(r.length!==e.length)throw new Error("Weights must have the same length as possibles");for(var a=0,o=r.length;a<o;a++){if(!Object(ie.y)(r[a])||r[a]<0)throw new Error("Weights must be an array of positive numbers");i+=r[a]}}var s=e.length;if(0===s)return[];if(s<=t)return 1<t?e:e[0];for(var u,c=[];c.length<t;){if(void 0===r)u=e[Math.floor(m()*s)];else for(var f=m()*i,l=0,p=e.length;l<p;l++)if((f-=r[l])<0){u=e[l];break}-1===c.indexOf(u)&&c.push(u)}return n?c[0]:c}});function Nu(e,t){var r=[];if(1<(e=e.slice(0)).length)for(var n=0,i=e.shift();n<i;n++)r.push(Nu(e,t));else for(var a=0,o=e.shift();a<o;a++)r.push(t());return r}var Ou="random",n=["typed","config","?on"],Mu=Object(a.a)(Ou,n,function(e){var t=e.typed,r=e.config,e=e.on,n=xu(r.randomSeed);return e&&e("config",function(e,t){e.randomSeed!==t.randomSeed&&(n=xu(e.randomSeed))}),t(Ou,{"":function(){return a(0,1)},number:function(e){return a(0,e)},"number, number":a,"Array | Matrix":function(e){return i(e,0,1)},"Array | Matrix, number":function(e,t){return i(e,0,t)},"Array | Matrix, number, number":i});function i(e,t,r){var n=Nu(e.valueOf(),function(){return a(t,r)});return Object(ie.v)(e)?e.create(n):n}function a(e,t){return e+n()*(t-e)}}),ju="randomInt",n=["typed","config","?on"],Eu=Object(a.a)(ju,n,function(e){var t=e.typed,r=e.config,e=e.on,n=xu(r.randomSeed);return e&&e("config",function(e,t){e.randomSeed!==t.randomSeed&&(n=xu(e.randomSeed))}),t(ju,{"":function(){return a(0,1)},number:function(e){return a(0,e)},"number, number":a,"Array | Matrix":function(e){return i(e,0,1)},"Array | Matrix, number":function(e,t){return i(e,0,t)},"Array | Matrix, number, number":i});function i(e,t,r){var n=Nu(e.valueOf(),function(){return a(t,r)});return Object(ie.v)(e)?e.create(n):n}function a(e,t){return Math.floor(e+n()*(t-e))}}),Su="stirlingS2",n=["typed","addScalar","subtract","multiplyScalar","divideScalar","pow","factorial","combinations","isNegative","isInteger","larger"],Au=Object(a.a)(Su,n,function(e){var t=e.typed,u=e.addScalar,c=e.subtract,f=e.multiplyScalar,l=e.divideScalar,p=e.pow,m=e.factorial,h=e.combinations,d=e.isNegative,y=e.isInteger,g=e.larger;return t(Su,{"number | BigNumber, number | BigNumber":function(e,t){if(!y(e)||d(e)||!y(t)||d(t))throw new TypeError("Non-negative integer value expected in function stirlingS2");if(g(t,e))throw new TypeError("k must be less than or equal to n in function stirlingS2");for(var r=m(t),n=0,i=0;i<=t;i++)var a=p(-1,c(t,i)),o=h(t,i),s=p(i,e),n=u(n,f(f(o,s),a));return l(n,r)}})}),Cu="bellNumbers",n=["typed","addScalar","isNegative","isInteger","stirlingS2"],_u=Object(a.a)(Cu,n,function(e){var t=e.typed,n=e.addScalar,i=e.isNegative,a=e.isInteger,o=e.stirlingS2;return t(Cu,{"number | BigNumber":function(e){if(!a(e)||i(e))throw new TypeError("Non-negative integer value expected in function bellNumbers");for(var t=0,r=0;r<=e;r++)t=n(t,o(e,r));return t}})}),Tu="catalan",n=["typed","addScalar","divideScalar","multiplyScalar","combinations","isNegative","isInteger"],qu=Object(a.a)(Tu,n,function(e){var t=e.typed,r=e.addScalar,n=e.divideScalar,i=e.multiplyScalar,a=e.combinations,o=e.isNegative,s=e.isInteger;return t(Tu,{"number | BigNumber":function(e){if(!s(e)||o(e))throw new TypeError("Non-negative integer value expected in function catalan");return n(a(i(e,2),e),r(e,1))}})}),Iu="composition",n=["typed","addScalar","combinations","isNegative","isPositive","isInteger","larger"],Bu=Object(a.a)(Iu,n,function(e){var t=e.typed,r=e.addScalar,n=e.combinations,i=e.isPositive,a=(e.isNegative,e.isInteger),o=e.larger;return t(Iu,{"number | BigNumber, number | BigNumber":function(e,t){if(!(a(e)&&i(e)&&a(t)&&i(t)))throw new TypeError("Positive integer value expected in function composition");if(o(t,e))throw new TypeError("k must be less than or equal to n in function composition");return n(r(e,-1),r(t,-1))}})}),n=["FunctionNode","OperatorNode","SymbolNode"],ku=Object(a.a)("simplifyUtil",n,function(e){var r=e.FunctionNode,n=e.OperatorNode,i=e.SymbolNode,a={add:!0,multiply:!0},o={add:!0,multiply:!0};function s(e,t){if(!Object(ie.B)(e))return!1;e=e.fn.toString();return t&&Object(ae.f)(t,e)&&Object(ae.f)(t[e],"associative")?t[e].associative:o[e]||!1}function u(e){function n(e){for(var t=0;t<e.args.length;t++){var r=e.args[t];Object(ie.B)(r)&&i===r.op?n(r):a.push(r)}}var i,a=[];return s(e)?(i=e.op,n(e),a):e.args}function c(t){return Object(ie.B)(t)?function(e){try{return new n(t.op,t.fn,e,t.implicit)}catch(e){return console.error(e),[]}}:function(e){return new r(new i(t.name),e)}}return{createMakeNodeFunction:c,isCommutative:function(e,t){return!Object(ie.B)(e)||(e=e.fn.toString(),t&&Object(ae.f)(t,e)&&Object(ae.f)(t[e],"commutative")?t[e].commutative:a[e]||!1)},isAssociative:s,flatten:function e(t){if(!t.args||0===t.args.length)return t;t.args=u(t);for(var r=0;r<t.args.length;r++)e(t.args[r])},allChildren:u,unflattenr:function e(t){if(t.args&&0!==t.args.length){for(var r=c(t),n=t.args.length,i=0;i<n;i++)e(t.args[i]);if(2<n&&s(t)){for(var a=t.args.pop();0<t.args.length;)a=r([t.args.pop(),a]);t.args=a.args}}},unflattenl:function e(t){if(t.args&&0!==t.args.length){for(var r=c(t),n=t.args.length,i=0;i<n;i++)e(t.args[i]);if(2<n&&s(t)){for(var a=t.args.shift();0<t.args.length;)a=r([a,t.args.shift()]);t.args=a.args}}}}}),n=["equal","isZero","add","subtract","multiply","divide","pow","ConstantNode","OperatorNode","FunctionNode","ParenthesisNode"],zu=Object(a.a)("simplifyCore",n,function(e){var s=e.equal,u=e.isZero,c=e.add,f=e.subtract,l=e.multiply,p=e.divide,m=e.pow,h=e.ConstantNode,d=e.OperatorNode,y=e.FunctionNode,g=e.ParenthesisNode,b=new h(0),v=new h(1);return function e(t){if(Object(ie.B)(t)&&t.isUnary()){var r=e(t.args[0]);if("+"===t.op)return r;if("-"===t.op){if(Object(ie.B)(r)){if(r.isUnary()&&"-"===r.op)return r.args[0];if(r.isBinary()&&"subtract"===r.fn)return new d("-","subtract",[r.args[1],r.args[0]])}return new d(t.op,t.fn,[r])}}else if(Object(ie.B)(t)&&t.isBinary()){var n=e(t.args[0]),i=e(t.args[1]);if("+"===t.op){if(Object(ie.l)(n)){if(u(n.value))return i;if(Object(ie.l)(i))return new h(c(n.value,i.value))}return Object(ie.l)(i)&&u(i.value)?n:Object(ie.B)(i)&&i.isUnary()&&"-"===i.op?new d("-","subtract",[n,i.args[0]]):new d(t.op,t.fn,i?[n,i]:[n])}if("-"===t.op){if(Object(ie.l)(n)&&i){if(Object(ie.l)(i))return new h(f(n.value,i.value));if(u(n.value))return new d("-","unaryMinus",[i])}if("subtract"===t.fn)return Object(ie.l)(i)&&u(i.value)?n:Object(ie.B)(i)&&i.isUnary()&&"-"===i.op?e(new d("+","add",[n,i.args[0]])):new d(t.op,t.fn,[n,i])}else{if("*"===t.op){if(Object(ie.l)(n)){if(u(n.value))return b;if(s(n.value,1))return i;if(Object(ie.l)(i))return new h(l(n.value,i.value))}if(Object(ie.l)(i)){if(u(i.value))return b;if(s(i.value,1))return n;if(Object(ie.B)(n)&&n.isBinary()&&n.op===t.op&&(r=n.args[0],Object(ie.l)(r))){var a=new h(l(r.value,i.value));return new d(t.op,t.fn,[a,n.args[1]],t.implicit)}return new d(t.op,t.fn,[i,n],t.implicit)}return new d(t.op,t.fn,[n,i],t.implicit)}if("/"===t.op){if(Object(ie.l)(n)){if(u(n.value))return b;if(Object(ie.l)(i)&&(s(i.value,1)||s(i.value,2)||s(i.value,4)))return new h(p(n.value,i.value))}return new d(t.op,t.fn,[n,i])}if("^"===t.op){if(Object(ie.l)(i)){if(u(i.value))return v;if(s(i.value,1))return n;if(Object(ie.l)(n))return new h(m(n.value,i.value));if(Object(ie.B)(n)&&n.isBinary()&&"^"===n.op&&(a=n.args[1],Object(ie.l)(a)))return new d(t.op,t.fn,[n.args[0],new h(l(a.value,i.value))])}return new d(t.op,t.fn,[n,i])}}}else{if(Object(ie.C)(t)){var o=e(t.content);return Object(ie.C)(o)||Object(ie.J)(o)||Object(ie.l)(o)?o:new g(o)}if(Object(ie.r)(t))return o=t.args.map(e).map(function(e){return Object(ie.C)(e)?e.content:e}),new y(e(t.fn),o)}return t}}),n=["typed","config","mathWithTransform","?fraction","?bignumber","ConstantNode","OperatorNode","FunctionNode","SymbolNode"],Du=Object(a.a)("simplifyConstant",n,function(e){var t=e.typed,r=e.config,l=e.mathWithTransform,n=e.fraction,i=e.bignumber,a=e.ConstantNode,o=e.OperatorNode,p=e.FunctionNode,e=e.SymbolNode,e=ku({FunctionNode:p,OperatorNode:o,SymbolNode:e}),m=e.isCommutative,h=e.isAssociative,d=e.allChildren,y=e.createMakeNodeFunction;function g(t,r,n){try{return v(l[t].apply(null,r),n)}catch(e){return r=r.map(function(e){return Object(ie.o)(e)?e.valueOf():e}),v(l[t].apply(null,r),n)}}var b=t({Fraction:function(e){var t=e.s*e.n;t=t<0?new o("-","unaryMinus",[new a(-t)]):new a(t);return 1!==e.d?new o("/","divide",[t,new a(e.d)]):t},number:function(e){return e<0?u(new a(-e)):new a(e)},BigNumber:function(e){return e<0?u(new a(-e)):new a(e)},Complex:function(){throw new Error("Cannot convert Complex number to Node")}});function s(e,t){if(t&&!1!==t.exactFractions&&isFinite(e)&&n){t=n(e);if(t.valueOf()===e)return t}return e}var v=t({"string, Object":function(e,t){return"BigNumber"===r.number?(void 0===i&&Ir(),i(e)):"Fraction"===r.number?(void 0===n&&Br(),n(e)):s(parseFloat(e),t)},"Fraction, Object":function(e){return e},"BigNumber, Object":function(e){return e},"number, Object":s,"Complex, Object":function(e,t){return 0!==e.im?e:s(e.re,t)}});function u(e){return new o("-","unaryMinus",[e])}function x(r,e,n,i){return e.reduce(function(e,t){if(Object(ie.w)(e)||Object(ie.w)(t))Object(ie.w)(e)?Object(ie.w)(t)||(t=b(t)):e=b(e);else{try{return g(r,[e,t],i)}catch(e){}e=b(e),t=b(t)}return n([e,t])})}return function(e,t){return t=function t(e,r){switch(e.type){case"SymbolNode":return e;case"ConstantNode":return"number"!=typeof e.value&&isNaN(e.value)?e:v(e.value,r);case"FunctionNode":if(l[e.name]&&l[e.name].rawArgs)return e;var n=["add","multiply"];if(-1===n.indexOf(e.name)){var i=e.args.map(function(e){return t(e,r)});if(!i.some(ie.w))try{return g(e.name,i,r)}catch(e){}return i=i.map(function(e){return Object(ie.w)(e)?e:b(e)}),new p(e.name,i)}case"OperatorNode":var a,o,s=e.fn.toString(),n=y(e);if(Object(ie.B)(e)&&e.isUnary())a=[t(e.args[0],r)],o=Object(ie.w)(a[0])?n(a):g(s,a,r);else if(h(e))if(a=(a=d(e)).map(function(e){return t(e,r)}),m(s)){for(var u=[],c=[],f=0;f<a.length;f++)(Object(ie.w)(a[f])?c:u).push(a[f]);o=1<u.length?(o=x(s,u,n,r),c.unshift(o),x(s,c,n,r)):x(s,a,n,r)}else o=x(s,a,n,r);else a=e.args.map(function(e){return t(e,r)}),o=x(s,a,n,r);return o;case"ParenthesisNode":return t(e.content,r);case"AccessorNode":case"ArrayNode":case"AssignmentNode":case"BlockNode":case"FunctionAssignmentNode":case"IndexNode":case"ObjectNode":case"RangeNode":case"ConditionalNode":default:throw new Error("Unimplemented node type in simplifyConstant: ".concat(e.type))}}(e,t),Object(ie.w)(t)?t:b(t)}}),n=["parse","FunctionNode","OperatorNode","ParenthesisNode"],Ru=Object(a.a)("resolve",n,function(e){var a=e.parse,o=e.FunctionNode,s=e.OperatorNode,u=e.ParenthesisNode;return function t(e,r){if(!r)return e;if(Object(ie.J)(e)){var n=r[e.name];if(Object(ie.w)(n))return t(n,r);if("number"==typeof n)return a(String(n))}else{if(Object(ie.B)(e)){var i=e.args.map(function(e){return t(e,r)});return new s(e.op,e.fn,i,e.implicit)}if(Object(ie.C)(e))return new u(t(e.content,r));if(Object(ie.r)(e))return i=e.args.map(function(e){return t(e,r)}),new o(e.name,i)}return e}});function Uu(e){return(Uu="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var n=["config","typed","parse","add","subtract","multiply","divide","pow","isZero","equal","?fraction","?bignumber","mathWithTransform","ConstantNode","FunctionNode","OperatorNode","ParenthesisNode","SymbolNode"],Pu=Object(a.a)("simplify",n,function(e){var t=e.config,r=e.typed,u=e.parse,n=e.add,i=e.subtract,a=e.multiply,o=e.divide,s=e.pow,c=e.isZero,l=e.equal,f=e.fraction,p=e.bignumber,m=e.mathWithTransform,h=e.ConstantNode,d=e.FunctionNode,y=e.OperatorNode,g=e.ParenthesisNode,b=e.SymbolNode,p=Du({typed:r,config:t,mathWithTransform:m,fraction:f,bignumber:p,ConstantNode:h,OperatorNode:y,FunctionNode:d,SymbolNode:b}),o=zu({equal:l,isZero:c,add:n,subtract:i,multiply:a,divide:o,pow:s,ConstantNode:h,OperatorNode:y,FunctionNode:d,ParenthesisNode:g}),v=Ru({parse:u,FunctionNode:d,OperatorNode:y,ParenthesisNode:g}),s=ku({FunctionNode:d,OperatorNode:y,SymbolNode:b}),x=s.isCommutative,w=s.isAssociative,N=s.flatten,O=s.unflattenr,M=s.unflattenl,j=s.createMakeNodeFunction,s=r("simplify",{string:function(e){return this(u(e),this.rules,{},{})},"string, Object":function(e,t){return this(u(e),this.rules,t,{})},"string, Object, Object":function(e,t,r){return this(u(e),this.rules,t,r)},"string, Array":function(e,t){return this(u(e),t,{},{})},"string, Array, Object":function(e,t,r){return this(u(e),t,r,{})},"string, Array, Object, Object":function(e,t,r,n){return this(u(e),t,r,n)},"Node, Object":function(e,t){return this(e,this.rules,t,{})},"Node, Object, Object":function(e,t,r){return this(e,this.rules,t,r)},Node:function(e){return this(e,this.rules,{},{})},"Node, Array":function(e,t){return this(e,t,{},{})},"Node, Array, Object":function(e,t,r){return this(e,t,r,{})},"Node, Array, Object, Object":function(e,t,r,n){t=function(e){for(var t=[],r=0;r<e.length;r++){var n,i=e[r],a=void 0,o=Uu(i);switch(o){case"string":var s=i.split("->");if(2!==s.length)throw SyntaxError("Could not parse rule: "+i);i={l:s[0],r:s[1]};case"object":a={l:E(u(i.l)),r:E(u(i.r))},i.context&&(a.evaluate=i.context),i.evaluate&&(a.evaluate=u(i.evaluate)),w(a.l)&&(n=j(a.l),s=new b("_p"+A++),a.expanded={},a.expanded.l=n([a.l.clone(),s]),N(a.expanded.l),O(a.expanded.l),a.expanded.r=n([a.r,s]));break;case"function":a=i;break;default:throw TypeError("Unsupported type of rule: "+o)}t.push(a)}return t}(t);for(var i=v(e,r),a={},o=(i=E(i)).toString({parenthesis:"all"});!a[o];){a[o]=!0;for(var s=A=0;s<t.length;s++)i="function"==typeof t[s]?t[s](i,n):(N(i),C(i,t[s])),M(i);o=i.toString({parenthesis:"all"})}return i}});function E(e){return e.transform(function(e,t,r){return Object(ie.C)(e)?E(e.content):e})}s.simplifyCore=o,s.resolve=v;var S={true:!0,false:!0,e:!0,i:!0,Infinity:!0,LN2:!0,LN10:!0,LOG2E:!0,LOG10E:!0,NaN:!0,phi:!0,pi:!0,SQRT1_2:!0,SQRT2:!0,tau:!0};s.rules=[o,{l:"log(e)",r:"1"},{l:"n-n1",r:"n+-n1"},{l:"-(c*v)",r:"(-c) * v"},{l:"-v",r:"(-1) * v"},{l:"n/n1^n2",r:"n*n1^-n2"},{l:"n/n1",r:"n*n1^-1"},{l:"(n ^ n1) ^ n2",r:"n ^ (n1 * n2)"},{l:"n*n",r:"n^2"},{l:"n * n^n1",r:"n^(n1+1)"},{l:"n^n1 * n^n2",r:"n^(n1+n2)"},{l:"n+n",r:"2*n"},{l:"n+-n",r:"0"},{l:"n1*n2 + n2",r:"(n1+1)*n2"},{l:"n1*n3 + n2*n3",r:"(n1+n2)*n3"},{l:"n1 + -1 * (n2 + n3)",r:"n1 + -1 * n2 + -1 * n3"},p,{l:"(-n)*n1",r:"-(n*n1)"},{l:"c+v",r:"v+c",context:{add:{commutative:!1}}},{l:"v*c",r:"c*v",context:{multiply:{commutative:!1}}},{l:"n+-n1",r:"n-n1"},{l:"n*(n1^-1)",r:"n/n1"},{l:"n*n1^-n2",r:"n/n1^n2"},{l:"n1^-1",r:"1/n1"},{l:"n*(n1/n2)",r:"(n*n1)/n2"},{l:"n-(n1+n2)",r:"n-n1-n2"},{l:"1*n",r:"n"},{l:"n1/(n2/n3)",r:"(n1*n3)/n2"}];var A=0;var C=r("applyRule",{"Node, Object":function(e,t){var r=e;if(r instanceof y||r instanceof d){if(r.args)for(var n=0;n<r.args.length;n++)r.args[n]=C(r.args[n],t)}else r instanceof g&&r.content&&(r.content=C(r.content,t));var i=t.r,a=q(t.l,r)[0];return!a&&t.expanded&&(i=t.expanded.r,a=q(t.expanded.l,r)[0]),a&&(e=r.implicit,r=i.clone(),e&&"implicit"in i&&(r.implicit=!0),r=r.transform(function(e){return e.isSymbolNode&&Object(ae.f)(a.placeholders,e.name)?a.placeholders[e.name].clone():e})),r}});function _(e,t){var r,n,i={placeholders:{}};if(!e.placeholders&&!t.placeholders)return i;if(!e.placeholders)return t;if(!t.placeholders)return e;for(r in e.placeholders)if(Object(ae.f)(e.placeholders,r)&&(i.placeholders[r]=e.placeholders[r],Object(ae.f)(t.placeholders,r)&&!function e(t,r){if(t instanceof h&&r instanceof h){if(!l(t.value,r.value))return!1}else if(t instanceof b&&r instanceof b){if(t.name!==r.name)return!1}else{if(!(t instanceof y&&r instanceof y||t instanceof d&&r instanceof d))return!1;if(t instanceof y){if(t.op!==r.op||t.fn!==r.fn)return!1}else if(t instanceof d&&t.name!==r.name)return!1;if(t.args.length!==r.args.length)return!1;for(var n=0;n<t.args.length;n++)if(!e(t.args[n],r.args[n]))return!1}return!0}(e.placeholders[r],t.placeholders[r])))return null;for(n in t.placeholders)Object(ae.f)(t.placeholders,n)&&(i.placeholders[n]=t.placeholders[n]);return i}function T(e,t){var r,n=[];if(0===e.length||0===t.length)return n;for(var i=0;i<e.length;i++)for(var a=0;a<t.length;a++)(r=_(e[i],t[a]))&&n.push(r);return n}function q(e,t,r){var n=[{placeholders:{}}];if(e instanceof y&&t instanceof y||e instanceof d&&t instanceof d){if(e instanceof y){if(e.op!==t.op||e.fn!==t.fn)return[]}else if(e instanceof d&&e.name!==t.name)return[];if((1!==t.args.length||1!==e.args.length)&&w(t)&&!r){if(2<=t.args.length&&2===e.args.length){for(var i=function(e,t){var r,n,i=[],a=j(e);if(x(e,t))for(var o=0;o<e.args.length;o++)(n=e.args.slice(0)).splice(o,1),r=1===n.length?n[0]:a(n),i.push(a([e.args[o],r]));else r=1===(n=e.args.slice(1)).length?n[0]:a(n),i.push(a([e.args[0],r]));return i}(t,e.context),a=[],o=0;o<i.length;o++)var s=q(e,i[o],!0),a=a.concat(s);return a}if(2<e.args.length)throw Error("Unexpected non-binary associative function: "+e.toString());return[]}for(var u=[],c=0;c<e.args.length;c++){var f=q(e.args[c],t.args[c]);if(0===f.length)return[];u.push(f)}n=function(e){if(0===e.length)return e;for(var t=e.reduce(T),r=[],n={},i=0;i<t.length;i++){var a=JSON.stringify(t[i]);n[a]||(n[a]=!0,r.push(t[i]))}return r}(u)}else if(e instanceof b){if(0===e.name.length)throw new Error("Symbol in rule has 0 length...!?");if(S[e.name]){if(e.name!==t.name)return[]}else if("n"===e.name[0]||"_p"===e.name.substring(0,2))n[0].placeholders[e.name]=t;else if("v"===e.name[0]){if(Object(ie.l)(t))return[];n[0].placeholders[e.name]=t}else{if("c"!==e.name[0])throw new Error("Invalid symbol in rule: "+e.name);if(!(t instanceof h))return[];n[0].placeholders[e.name]=t}}else{if(!(e instanceof h))return[];if(!l(e.value,t.value))return[]}return n}return s}),n=["typed","config","parse","simplify","equal","isZero","numeric","ConstantNode","FunctionNode","OperatorNode","ParenthesisNode","SymbolNode"],Fu=Object(a.a)("derivative",n,function(e){var t=e.typed,r=e.config,n=e.parse,i=e.simplify,o=e.equal,s=e.isZero,a=e.numeric,u=e.ConstantNode,c=e.FunctionNode,f=e.OperatorNode,l=e.ParenthesisNode,p=e.SymbolNode,e=t("derivative",{"Node, SymbolNode, Object":function(e,t,r){var n={};h(n,e,t.name);n=d(e,n);return r.simplify?i(n):n},"Node, SymbolNode":function(e,t){return this(e,t,{simplify:!0})},"string, SymbolNode":function(e,t){return this(n(e),t)},"string, SymbolNode, Object":function(e,t,r){return this(n(e),t,r)},"string, string":function(e,t){return this(n(e),n(t))},"string, string, Object":function(e,t,r){return this(n(e),n(t),r)},"Node, string":function(e,t){return this(e,n(t))},"Node, string, Object":function(e,t,r){return this(e,n(t),r)}});e._simplify=!0,e.toTex=function(e){return m.apply(null,e.args)};var m=t("_derivTex",{"Node, SymbolNode":function(e,t){return Object(ie.l)(e)&&"string"===Object(ie.M)(e.value)?m(n(e.value).toString(),t.toString(),1):m(e.toString(),t.toString(),1)},"Node, ConstantNode":function(e,t){if("string"===Object(ie.M)(t.value))return m(e,n(t.value));throw new Error("The second parameter to 'derivative' is a non-string constant")},"Node, SymbolNode, ConstantNode":function(e,t,r){return m(e.toString(),t.name,r.value)},"string, string, number":function(e,t,r){r=1===r?"{d\\over d"+t+"}":"{d^{"+r+"}\\over d"+t+"^{"+r+"}}";return r+"\\left[".concat(e,"\\right]")}}),h=t("constTag",{"Object, ConstantNode, string":function(e,t){return e[t]=!0},"Object, SymbolNode, string":function(e,t,r){return t.name!==r&&(e[t]=!0)},"Object, ParenthesisNode, string":function(e,t,r){return h(e,t.content,r)},"Object, FunctionAssignmentNode, string":function(e,t,r){return-1===t.params.indexOf(r)?e[t]=!0:h(e,t.expr,r)},"Object, FunctionNode | OperatorNode, string":function(e,t,r){if(0<t.args.length){for(var n=h(e,t.args[0],r),i=1;i<t.args.length;++i)n=h(e,t.args[i],r)&&n;if(n)return e[t]=!0}return!1}}),d=t("_derivative",{"ConstantNode, Object":function(){return y(0)},"SymbolNode, Object":function(e,t){return void 0!==t[e]?y(0):y(1)},"ParenthesisNode, Object":function(e,t){return new l(d(e.content,t))},"FunctionAssignmentNode, Object":function(e,t){return void 0!==t[e]?y(0):d(e.expr,t)},"FunctionNode, Object":function(e,t){if(1!==e.args.length&&function(e){if(("log"===e.name||"nthRoot"===e.name||"pow"===e.name)&&2===e.args.length)return;for(var t=0;t<e.args.length;++t)e.args[t]=y(0);throw e.compile().evaluate(),new Error("Expected TypeError, but none found")}(e),void 0!==t[e])return y(0);var r,n,i,a=e.args[0],o=!1,s=!1;switch(e.name){case"cbrt":o=!0,n=new f("*","multiply",[y(3),new f("^","pow",[a,new f("/","divide",[y(2),y(3)])])]);break;case"sqrt":case"nthRoot":if(1===e.args.length)o=!0,n=new f("*","multiply",[y(2),new c("sqrt",[a])]);else if(2===e.args.length)return t[r=new f("/","divide",[y(1),e.args[1]])]=t[e.args[1]],d(new f("^","pow",[a,r]),t);break;case"log10":r=y(10);case"log":if(r||1!==e.args.length){if(1===e.args.length&&r||2===e.args.length&&void 0!==t[e.args[1]])n=new f("*","multiply",[a.clone(),new c("log",[r||e.args[1]])]),o=!0;else if(2===e.args.length)return d(new f("/","divide",[new c("log",[a]),new c("log",[e.args[1]])]),t)}else n=a.clone(),o=!0;break;case"pow":return t[r]=t[e.args[1]],d(new f("^","pow",[a,e.args[1]]),t);case"exp":n=new c("exp",[a.clone()]);break;case"sin":n=new c("cos",[a.clone()]);break;case"cos":n=new f("-","unaryMinus",[new c("sin",[a.clone()])]);break;case"tan":n=new f("^","pow",[new c("sec",[a.clone()]),y(2)]);break;case"sec":n=new f("*","multiply",[e,new c("tan",[a.clone()])]);break;case"csc":s=!0,n=new f("*","multiply",[e,new c("cot",[a.clone()])]);break;case"cot":s=!0,n=new f("^","pow",[new c("csc",[a.clone()]),y(2)]);break;case"asin":o=!0,n=new c("sqrt",[new f("-","subtract",[y(1),new f("^","pow",[a.clone(),y(2)])])]);break;case"acos":s=o=!0,n=new c("sqrt",[new f("-","subtract",[y(1),new f("^","pow",[a.clone(),y(2)])])]);break;case"atan":o=!0,n=new f("+","add",[new f("^","pow",[a.clone(),y(2)]),y(1)]);break;case"asec":o=!0,n=new f("*","multiply",[new c("abs",[a.clone()]),new c("sqrt",[new f("-","subtract",[new f("^","pow",[a.clone(),y(2)]),y(1)])])]);break;case"acsc":s=o=!0,n=new f("*","multiply",[new c("abs",[a.clone()]),new c("sqrt",[new f("-","subtract",[new f("^","pow",[a.clone(),y(2)]),y(1)])])]);break;case"acot":s=o=!0,n=new f("+","add",[new f("^","pow",[a.clone(),y(2)]),y(1)]);break;case"sinh":n=new c("cosh",[a.clone()]);break;case"cosh":n=new c("sinh",[a.clone()]);break;case"tanh":n=new f("^","pow",[new c("sech",[a.clone()]),y(2)]);break;case"sech":s=!0,n=new f("*","multiply",[e,new c("tanh",[a.clone()])]);break;case"csch":s=!0,n=new f("*","multiply",[e,new c("coth",[a.clone()])]);break;case"coth":s=!0,n=new f("^","pow",[new c("csch",[a.clone()]),y(2)]);break;case"asinh":o=!0,n=new c("sqrt",[new f("+","add",[new f("^","pow",[a.clone(),y(2)]),y(1)])]);break;case"acosh":o=!0,n=new c("sqrt",[new f("-","subtract",[new f("^","pow",[a.clone(),y(2)]),y(1)])]);break;case"atanh":o=!0,n=new f("-","subtract",[y(1),new f("^","pow",[a.clone(),y(2)])]);break;case"asech":s=o=!0,n=new f("*","multiply",[a.clone(),new c("sqrt",[new f("-","subtract",[y(1),new f("^","pow",[a.clone(),y(2)])])])]);break;case"acsch":s=o=!0,n=new f("*","multiply",[new c("abs",[a.clone()]),new c("sqrt",[new f("+","add",[new f("^","pow",[a.clone(),y(2)]),y(1)])])]);break;case"acoth":s=o=!0,n=new f("-","subtract",[y(1),new f("^","pow",[a.clone(),y(2)])]);break;case"abs":n=new f("/","divide",[new c(new p("abs"),[a.clone()]),a.clone()]);break;case"gamma":default:throw new Error('Function "'+e.name+'" is not supported by derivative, or a wrong number of arguments is passed')}o=o?(i="/","divide"):(i="*","multiply");t=d(a,t);return s&&(t=new f("-","unaryMinus",[t])),new f(i,o,[t,n])},"OperatorNode, Object":function(e,r){if(void 0!==r[e])return y(0);if("+"===e.op)return new f(e.op,e.fn,e.args.map(function(e){return d(e,r)}));if("-"===e.op){if(e.isUnary())return new f(e.op,e.fn,[d(e.args[0],r)]);if(e.isBinary())return new f(e.op,e.fn,[d(e.args[0],r),d(e.args[1],r)])}if("*"===e.op){var t=e.args.filter(function(e){return void 0!==r[e]});if(0<t.length){var n=e.args.filter(function(e){return void 0===r[e]}),n=1===n.length?n[0]:new f("*","multiply",n),n=t.concat(d(n,r));return new f("*","multiply",n)}return new f("+","add",e.args.map(function(t){return new f("*","multiply",e.args.map(function(e){return e===t?d(e,r):e.clone()}))}))}if("/"===e.op&&e.isBinary()){var i=e.args[0],a=e.args[1];return void 0!==r[a]?new f("/","divide",[d(i,r),a]):void 0!==r[i]?new f("*","multiply",[new f("-","unaryMinus",[i]),new f("/","divide",[d(a,r),new f("^","pow",[a.clone(),y(2)])])]):new f("/","divide",[new f("-","subtract",[new f("*","multiply",[d(i,r),a.clone()]),new f("*","multiply",[i.clone(),d(a,r)])]),new f("^","pow",[a.clone(),y(2)])])}if("^"===e.op&&e.isBinary()){n=e.args[0],i=e.args[1];if(void 0!==r[n])return Object(ie.l)(n)&&(s(n.value)||o(n.value,1))?y(0):new f("*","multiply",[e,new f("*","multiply",[new c("log",[n.clone()]),d(i.clone(),r)])]);if(void 0===r[i])return new f("*","multiply",[new f("^","pow",[n.clone(),i.clone()]),new f("+","add",[new f("*","multiply",[d(n,r),new f("/","divide",[i.clone(),n.clone()])]),new f("*","multiply",[d(i,r),new c("log",[n.clone()])])])]);if(Object(ie.l)(i)){if(s(i.value))return y(0);if(o(i.value,1))return d(n,r)}a=new f("^","pow",[n.clone(),new f("-","subtract",[i,y(1)])]);return new f("*","multiply",[i.clone(),new f("*","multiply",[d(n,r),a])])}throw new Error('Operator "'+e.op+'" is not supported by derivative, or a wrong number of arguments is passed')}});function y(e,t){return new u(a(e,t||r.number))}return e}),Lu="rationalize",n=["config","typed","equal","isZero","add","subtract","multiply","divide","pow","parse","simplify","?bignumber","?fraction","mathWithTransform","ConstantNode","OperatorNode","FunctionNode","SymbolNode","ParenthesisNode"],Hu=Object(a.a)(Lu,n,function(e){var t=e.config,r=e.typed,n=e.equal,i=e.isZero,a=e.add,o=e.subtract,s=e.multiply,u=e.divide,c=e.pow,f=e.parse,p=e.simplify,l=e.fraction,m=e.bignumber,h=e.mathWithTransform,d=e.ConstantNode,y=e.OperatorNode,g=e.FunctionNode,b=e.SymbolNode,e=e.ParenthesisNode,v=Du({typed:r,config:t,mathWithTransform:h,fraction:l,bignumber:m,ConstantNode:d,OperatorNode:y,FunctionNode:g,SymbolNode:b}),x=zu({equal:n,isZero:i,add:a,subtract:o,multiply:s,divide:u,pow:c,ConstantNode:d,OperatorNode:y,FunctionNode:g,ParenthesisNode:e});return r(Lu,{string:function(e){return this(f(e),{},!1)},"string, boolean":function(e,t){return this(f(e),{},t)},"string, Object":function(e,t){return this(f(e),t,!1)},"string, Object, boolean":function(e,t,r){return this(f(e),t,r)},Node:function(e){return this(e,{},!1)},"Node, boolean":function(e,t){return this(e,{},t)},"Node, Object":function(e,t){return this(e,t,!1)},"Node, Object, boolean":function(e,t,r){var n,i,a=((l={}).firstRules=(o=[x,{l:"n+n",r:"2*n"},{l:"n+-n",r:"0"},v,{l:"n*(n1^-1)",r:"n/n1"},{l:"n*n1^-n2",r:"n/n1^n2"},{l:"n1^-1",r:"1/n1"},{l:"n*(n1/n2)",r:"(n*n1)/n2"},{l:"1*n",r:"n"}]).concat(s=[{l:"(-n1)/(-n2)",r:"n1/n2"},{l:"(-n1)*(-n2)",r:"n1*n2"},{l:"n1--n2",r:"n1+n2"},{l:"n1-n2",r:"n1+(-n2)"},{l:"(n1+n2)*n3",r:"(n1*n3 + n2*n3)"},{l:"n1*(n2+n3)",r:"(n1*n2+n1*n3)"},{l:"c1*n + c2*n",r:"(c1+c2)*n"},{l:"c1*n + n",r:"(c1+1)*n"},{l:"c1*n - c2*n",r:"(c1-c2)*n"},{l:"c1*n - n",r:"(c1-1)*n"},{l:"v/c",r:"(1/c)*v"},{l:"v/-c",r:"-(1/c)*v"},{l:"-v*-c",r:"c*v"},{l:"-v*c",r:"-c*v"},{l:"v*-c",r:"-c*v"},{l:"v*c",r:"c*v"},{l:"-(-n1*n2)",r:"(n1*n2)"},{l:"-(n1*n2)",r:"(-n1*n2)"},{l:"-(-n1+n2)",r:"(n1-n2)"},{l:"-(n1+n2)",r:"(-n1-n2)"},{l:"(n1^n2)^n3",r:"(n1^(n2*n3))"},{l:"-(-n1/n2)",r:"(n1/n2)"},{l:"-(n1/n2)",r:"(-n1/n2)"}],n=[{l:"(n1/(n2/n3))",r:"((n1*n3)/n2)"},{l:"(n1/n2/n3)",r:"(n1/(n2*n3))"}]),l.distrDivRules=[{l:"(n1/n2 + n3/n4)",r:"((n1*n4 + n3*n2)/(n2*n4))"},{l:"(n1/n2 + n3)",r:"((n1 + n3*n2)/n2)"},{l:"(n1 + n2/n3)",r:"((n1*n3 + n2)/n3)"}],l.sucDivRules=n,l.firstRulesAgain=o.concat(s),l.finalRules=[x,{l:"n*-n",r:"-n^2"},{l:"n*n",r:"n^2"},v,{l:"n*-n^n1",r:"-n^(n1+1)"},{l:"n*n^n1",r:"n^(n1+1)"},{l:"n^n1*-n^n2",r:"-n^(n1+n2)"},{l:"n^n1*n^n2",r:"n^(n1+n2)"},{l:"n^n1*-n",r:"-n^(n1+1)"},{l:"n^n1*n",r:"n^(n1+1)"},{l:"n^n1/-n",r:"-n^(n1-1)"},{l:"n^n1/n",r:"n^(n1-1)"},{l:"n/-n^n1",r:"-n^(1-n1)"},{l:"n/n^n1",r:"n^(1-n1)"},{l:"n^n1/-n^n2",r:"n^(n1-n2)"},{l:"n^n1/n^n2",r:"n^(n1-n2)"},{l:"n1+(-n2*n3)",r:"n1-n2*n3"},{l:"v*(-c)",r:"-c*v"},{l:"n1+-n2",r:"n1-n2"},{l:"v*c",r:"c*v"},{l:"(n1^n2)^n3",r:"(n1^(n2*n3))"}],l),o=function(e,t,r,n){var o=[],t=p(e,n,t,{exactFractions:!1}),s="+-*"+((r=!!r)?"/":"");!function e(t){var r=t.type;{if("FunctionNode"===r)throw new Error("There is an unsolved function call");if("OperatorNode"===r)if("^"===t.op){if("ConstantNode"!==t.args[1].type||!Object(N.i)(parseFloat(t.args[1].value)))throw new Error("There is a non-integer exponent");e(t.args[0])}else{if(-1===s.indexOf(t.op))throw new Error("Operator "+t.op+" invalid in polynomial expression");for(var n=0;n<t.args.length;n++)e(t.args[n])}else if("SymbolNode"===r){var i=t.name,a=o.indexOf(i);-1===a&&o.push(i)}else if("ParenthesisNode"===r)e(t.content);else if("ConstantNode"!==r)throw new Error("type "+r+" is not allowed in polynomial expression")}}(t);r={};return r.expression=t,r.variables=o,r}(e,t,!0,a.firstRules),s=o.variables.length;if(e=o.expression,1<=s){e=function e(t,r,n){var i=t.type;var a=1<arguments.length;{var o,s;"OperatorNode"===i&&t.isBinary()&&(o=!1,"^"===t.op&&("ParenthesisNode"!==t.args[0].type&&"OperatorNode"!==t.args[0].type||"ConstantNode"!==t.args[1].type||(s=parseFloat(t.args[1].value),o=2<=s&&Object(N.i)(s))),o&&(t=2<s?(o=t.args[0],s=new y("^","pow",[t.args[0].cloneDeep(),new d(s-1)]),new y("*","multiply",[o,s])):new y("*","multiply",[t.args[0],t.args[0].cloneDeep()]),a&&("content"===n?r.content=t:r.args[n]=t)))}if("ParenthesisNode"===i)e(t.content,t,"content");else if("ConstantNode"!==i&&"SymbolNode"!==i)for(var u=0;u<t.args.length;u++)e(t.args[u],t,u);if(!a)return t}(e);var u,c=!0,f=!1;for(e=p(e,a.firstRules,{},{exactFractions:!1});u=c?a.distrDivRules:a.sucDivRules,c=!c,(u=(e=p(e,u)).toString())!==i;)f=!0,i=u;f&&(e=p(e,a.firstRulesAgain,{},{exactFractions:!1})),e=p(e,a.finalRules,{},{exactFractions:!1})}var l=[],t={};return"OperatorNode"===e.type&&e.isBinary()&&"/"===e.op?(1===s&&(e.args[0]=w(e.args[0],l),e.args[1]=w(e.args[1])),r&&(t.numerator=e.args[0],t.denominator=e.args[1])):(1===s&&(e=w(e,l)),r&&(t.numerator=e,t.denominator=null)),r?(t.coefficients=l,t.variables=o.variables,t.expression=e,t):e}});function w(e,u){void 0===u&&(u=[]);var t={cte:1,oper:"+",fire:""},c=u[0]=0,f="";!function e(t,r,n){var i=t.type;{if("FunctionNode"===i)throw new Error("There is an unsolved function call");if("OperatorNode"===i){if(-1==="+-*^".indexOf(t.op))throw new Error("Operator "+t.op+" invalid");if(null!==r){if(("unaryMinus"===t.fn||"pow"===t.fn)&&"add"!==r.fn&&"subtract"!==r.fn&&"multiply"!==r.fn)throw new Error("Invalid "+t.op+" placing");if(("subtract"===t.fn||"add"===t.fn||"multiply"===t.fn)&&"add"!==r.fn&&"subtract"!==r.fn)throw new Error("Invalid "+t.op+" placing");if(("subtract"===t.fn||"add"===t.fn||"unaryMinus"===t.fn)&&0!==n.noFil)throw new Error("Invalid "+t.op+" placing")}"^"!==t.op&&"*"!==t.op||(n.fire=t.op);for(var a=0;a<t.args.length;a++)"unaryMinus"===t.fn&&(n.oper="-"),"+"!==t.op&&"subtract"!==t.fn||(n.fire="",n.cte=1,n.oper=0===a?"+":t.op),n.noFil=a,e(t.args[a],t,n)}else if("SymbolNode"===i){if(t.name!==f&&""!==f)throw new Error("There is more than one variable");if(f=t.name,null!==r){if("^"===r.op&&0!==n.noFil)throw new Error("In power the variable should be the first parameter");if("*"===r.op&&1!==n.noFil)throw new Error("In multiply the variable should be the second parameter");""!==n.fire&&"*"!==n.fire||(c<1&&(u[1]=0),u[1]+=n.cte*("+"===n.oper?1:-1),c=Math.max(1,c))}else u[1]=1}else{if("ConstantNode"!==i)throw new Error("Type "+i+" is not allowed");var o=parseFloat(t.value);if(null!==r){if("^"===r.op){if(1!==n.noFil)throw new Error("Constant cannot be powered");if(!Object(N.i)(o)||o<=0)throw new Error("Non-integer exponent is not allowed");for(var s=c+1;s<o;s++)u[s]=0;return c<o&&(u[o]=0),u[o]+=n.cte*("+"===n.oper?1:-1),void(c=Math.max(o,c))}n.cte=o,""===n.fire&&(u[0]+=n.cte*("+"===n.oper?1:-1))}else u[0]=o}}}(e,null,t);for(var r,n,i,a,o,s=!0,l=c=u.length-1;0<=l;l--)0!==u[l]&&(n=new d(s?u[l]:Math.abs(u[l])),i=u[l]<0?"-":"+",0<l&&(o=new b(f),1<l&&(a=new d(l),o=new y("^","pow",[o,a])),n=-1===u[l]&&s?new y("-","unaryMinus",[o]):1===Math.abs(u[l])?o:new y("*","multiply",[n,o])),r=s?n:"+"==i?new y("+","add",[r,n]):new y("-","subtract",[r,n]),s=!1);return s?new d(0):r}}),n=["classes"],$u=Object(a.a)("reviver",n,function(e){var n=e.classes;return function(e,t){var r=n[t&&t.mathjs];return r&&"function"==typeof r.fromJSON?r.fromJSON(t):t}}),n=[],Gu=Object(a.a)("replacer",n,function(){return function(e,t){return"number"!=typeof t||isFinite(t)&&!isNaN(t)?t:{mathjs:"number",value:String(t)}}}),Vu=Math.PI,Zu=2*Math.PI,Ju=Math.E,Wu=Object(a.a)("true",[],function(){return!0}),Yu=Object(a.a)("false",[],function(){return!1}),Xu=Object(a.a)("null",[],function(){return null}),Qu=hc("Infinity",["config","?BigNumber"],function(e){var t=e.config,e=e.BigNumber;return"BigNumber"===t.number?new e(1/0):1/0}),Ku=hc("NaN",["config","?BigNumber"],function(e){var t=e.config,e=e.BigNumber;return"BigNumber"===t.number?new e(NaN):NaN}),ec=hc("pi",["config","?BigNumber"],function(e){var t=e.config,e=e.BigNumber;return"BigNumber"===t.number?Ji(e):Vu}),tc=hc("tau",["config","?BigNumber"],function(e){var t=e.config,e=e.BigNumber;return"BigNumber"===t.number?Wi(e):Zu}),rc=hc("e",["config","?BigNumber"],function(e){var t=e.config,e=e.BigNumber;return"BigNumber"===t.number?Vi(e):Ju}),nc=hc("phi",["config","?BigNumber"],function(e){var t=e.config,e=e.BigNumber;return"BigNumber"===t.number?Zi(e):1.618033988749895}),ic=hc("LN2",["config","?BigNumber"],function(e){var t=e.config,e=e.BigNumber;return"BigNumber"===t.number?new e(2).ln():Math.LN2}),ac=hc("LN10",["config","?BigNumber"],function(e){var t=e.config,e=e.BigNumber;return"BigNumber"===t.number?new e(10).ln():Math.LN10}),oc=hc("LOG2E",["config","?BigNumber"],function(e){var t=e.config,e=e.BigNumber;return"BigNumber"===t.number?new e(1).div(new e(2).ln()):Math.LOG2E}),sc=hc("LOG10E",["config","?BigNumber"],function(e){var t=e.config,e=e.BigNumber;return"BigNumber"===t.number?new e(1).div(new e(10).ln()):Math.LOG10E}),uc=hc("SQRT1_2",["config","?BigNumber"],function(e){var t=e.config,e=e.BigNumber;return"BigNumber"===t.number?new e("0.5").sqrt():Math.SQRT1_2}),cc=hc("SQRT2",["config","?BigNumber"],function(e){var t=e.config,e=e.BigNumber;return"BigNumber"===t.number?new e(2).sqrt():Math.SQRT2}),fc=hc("i",["Complex"],function(e){return e.Complex.I}),lc=Object(a.a)("PI",["pi"],function(e){return e.pi}),pc=Object(a.a)("E",["e"],function(e){return e.e}),mc=Object(a.a)("version",[],function(){return"7.6.0"});function hc(e,t,r){return Object(a.a)(e,t,r,{recreateOnConfigChange:!0})}var dc=pf("speedOfLight","299792458","m s^-1"),yc=pf("gravitationConstant","6.67430e-11","m^3 kg^-1 s^-2"),gc=pf("planckConstant","6.62607015e-34","J s"),bc=pf("reducedPlanckConstant","1.0545718176461565e-34","J s"),vc=pf("magneticConstant","1.25663706212e-6","N A^-2"),xc=pf("electricConstant","8.8541878128e-12","F m^-1"),wc=pf("vacuumImpedance","376.730313667","ohm"),Nc=pf("coulomb","8.987551792261171e9","N m^2 C^-2"),Oc=pf("elementaryCharge","1.602176634e-19","C"),Mc=pf("bohrMagneton","9.2740100783e-24","J T^-1"),jc=pf("conductanceQuantum","7.748091729863649e-5","S"),Ec=pf("inverseConductanceQuantum","12906.403729652257","ohm"),Sc=pf("magneticFluxQuantum","2.0678338484619295e-15","Wb"),Ac=pf("nuclearMagneton","5.0507837461e-27","J T^-1"),Cc=pf("klitzing","25812.807459304513","ohm"),_c=pf("bohrRadius","5.29177210903e-11","m"),Tc=pf("classicalElectronRadius","2.8179403262e-15","m"),qc=pf("electronMass","9.1093837015e-31","kg"),Ic=pf("fermiCoupling","1.1663787e-5","GeV^-2"),Bc=mf("fineStructure",.0072973525693),kc=pf("hartreeEnergy","4.3597447222071e-18","J"),zc=pf("protonMass","1.67262192369e-27","kg"),Dc=pf("deuteronMass","3.3435830926e-27","kg"),Rc=pf("neutronMass","1.6749271613e-27","kg"),Uc=pf("quantumOfCirculation","3.6369475516e-4","m^2 s^-1"),Pc=pf("rydberg","10973731.568160","m^-1"),Fc=pf("thomsonCrossSection","6.6524587321e-29","m^2"),Lc=mf("weakMixingAngle",.2229),Hc=mf("efimovFactor",22.7),$c=pf("atomicMass","1.66053906660e-27","kg"),Gc=pf("avogadro","6.02214076e23","mol^-1"),Vc=pf("boltzmann","1.380649e-23","J K^-1"),Zc=pf("faraday","96485.33212331001","C mol^-1"),Jc=pf("firstRadiation","3.7417718521927573e-16","W m^2"),Wc=pf("loschmidt","2.686780111798444e25","m^-3"),Yc=pf("gasConstant","8.31446261815324","J K^-1 mol^-1"),Xc=pf("molarPlanckConstant","3.990312712893431e-10","J s mol^-1"),Qc=pf("molarVolume","0.022413969545014137","m^3 mol^-1"),Kc=mf("sackurTetrode",-1.16487052358),ef=pf("secondRadiation","0.014387768775039337","m K"),tf=pf("stefanBoltzmann","5.67037441918443e-8","W m^-2 K^-4"),rf=pf("wienDisplacement","2.897771955e-3","m K"),nf=pf("molarMass","0.99999999965e-3","kg mol^-1"),af=pf("molarMassC12","11.9999999958e-3","kg mol^-1"),of=pf("gravity","9.80665","m s^-2"),sf=pf("planckLength","1.616255e-35","m"),uf=pf("planckMass","2.176435e-8","kg"),cf=pf("planckTime","5.391245e-44","s"),ff=pf("planckCharge","1.87554603778e-18","C"),lf=pf("planckTemperature","1.416785e+32","K");function pf(e,n,i){return Object(a.a)(e,["config","Unit","BigNumber"],function(e){var t=e.config,r=e.Unit,e=e.BigNumber,e=new r("BigNumber"===t.number?new e(n):parseFloat(n),i);return e.fixPrefix=!0,e})}function mf(e,r){return Object(a.a)(e,["config","BigNumber"],function(e){var t=e.config,e=e.BigNumber;return"BigNumber"===t.number?new e(r):r})}var n=["typed","isInteger"],hf=Object(a.a)("apply",n,function(e){var t=e.typed,e=e.isInteger,r=Fe({typed:t,isInteger:e});return t("apply",{"...any":function(e){var t=e[1];Object(ie.y)(t)?e[1]=t-1:Object(ie.e)(t)&&(e[1]=t.minus(1));try{return r.apply(null,e)}catch(e){throw Oo(e)}}})},{isTransformFunction:!0}),n=["typed","Index","matrix","range"],df=Object(a.a)("column",n,function(e){var t=e.typed,r=e.Index,n=e.matrix,e=e.range,i=lr({typed:t,Index:r,matrix:n,range:e});return t("column",{"...any":function(e){var t=e.length-1,r=e[t];Object(ie.y)(r)&&(e[t]=r-1);try{return i.apply(null,e)}catch(e){throw Oo(e)}}})},{isTransformFunction:!0});function yf(e,t,r){var n=e.filter(function(e){return Object(ie.J)(e)&&!(e.name in t)&&!(e.name in r)})[0];if(!n)throw new Error('No undefined variable found in inline expression "'+e+'"');var i=n.name,a=Object.create(r),o=e.compile();return function(e){return a[i]=e,o.evaluate(a)}}var n=["typed"],gf=Object(a.a)("filter",n,function(e){e=e.typed;function t(e,t,r){var n,i;return e[0]&&(n=e[0].compile().evaluate(r)),e[1]&&(i=Object(ie.J)(e[1])||Object(ie.q)(e[1])?e[1].compile().evaluate(r):yf(e[1],t,r)),a(n,i)}t.rawArgs=!0;var a=e("filter",{"Array, function":bf,"Matrix, function":function(e,t){return e.create(bf(e.toArray(),t))},"Array, RegExp":E.d,"Matrix, RegExp":function(e,t){return e.create(Object(E.d)(e.toArray(),t))}});return t},{isTransformFunction:!0});function bf(e,n){var i=yr(n);return Object(E.c)(e,function(e,t,r){return 1===i?n(e):2===i?n(e,[t+1]):n(e,[t+1],r)})}var n=["typed"],vf=Object(a.a)("forEach",n,function(e){e=e.typed;function t(e,t,r){var n,i;return e[0]&&(n=e[0].compile().evaluate(r)),e[1]&&(i=Object(ie.J)(e[1])||Object(ie.q)(e[1])?e[1].compile().evaluate(r):yf(e[1],t,r)),a(n,i)}t.rawArgs=!0;var a=e("forEach",{"Array | Matrix, function":function(t,i){var a=yr(i);(function r(e,n){Array.isArray(e)?Object(E.f)(e,function(e,t){r(e,n.concat(t+1))}):1===a?i(e):2===a?i(e,n):i(e,n,t)})(t.valueOf(),[])}});return t},{isTransformFunction:!0}),n=["Index"],xf=Object(a.a)("index",n,function(e){var a=e.Index;return function(){for(var e=[],t=0,r=arguments.length;t<r;t++){var n=arguments[t];if(Object(ie.D)(n))n.start--,n.end-=0<n.step?0:2;else if(n&&!0===n.isSet)n=n.map(function(e){return e-1});else if(Object(ie.b)(n)||Object(ie.v)(n))n=n.map(function(e){return e-1});else if(Object(ie.y)(n))n--;else if(Object(ie.e)(n))n=n.toNumber()-1;else if("string"!=typeof n)throw new TypeError("Dimension must be an Array, Matrix, number, string, or Range");e[t]=n}var i=new a;return a.apply(i,e),i}},{isTransformFunction:!0}),n=["typed"],wf=Object(a.a)("map",n,function(e){e=e.typed;function t(e,t,r){var n,i;return e[0]&&(n=e[0].compile().evaluate(r)),e[1]&&(i=Object(ie.J)(e[1])||Object(ie.q)(e[1])?e[1].compile().evaluate(r):yf(e[1],t,r)),a(n,i)}t.rawArgs=!0;var a=e("map",{"Array, function":function(e,t){return Nf(e,t,e)},"Matrix, function":function(e,t){return e.create(Nf(e.valueOf(),t,e))}});return t},{isTransformFunction:!0});function Nf(e,t,i){var a=yr(t);return function r(e,n){return Array.isArray(e)?Object(E.k)(e,function(e,t){return r(e,n.concat(t+1))}):1===a?t(e):2===a?t(e,n):t(e,n,i)}(e,[])}var n=["typed","config","numeric","larger"],Of=Object(a.a)("max",n,function(e){var t=e.typed,r=e.config,n=e.numeric,e=e.larger,i=Pi({typed:t,config:r,numeric:n,larger:e});return t("max",{"...any":function(e){var t;2===e.length&&Object(ie.i)(e[0])&&(t=e[1],Object(ie.y)(t)?e[1]=t-1:Object(ie.e)(t)&&(e[1]=t.minus(1)));try{return i.apply(null,e)}catch(e){throw Oo(e)}}})},{isTransformFunction:!0}),n=["typed","add","divide"],Mf=Object(a.a)("mean",n,function(e){var t=e.typed,r=e.add,e=e.divide,n=Hs({typed:t,add:r,divide:e});return t("mean",{"...any":function(e){var t;2===e.length&&Object(ie.i)(e[0])&&(t=e[1],Object(ie.y)(t)?e[1]=t-1:Object(ie.e)(t)&&(e[1]=t.minus(1)));try{return n.apply(null,e)}catch(e){throw Oo(e)}}})},{isTransformFunction:!0}),n=["typed","config","numeric","smaller"],jf=Object(a.a)("min",n,function(e){var t=e.typed,r=e.config,n=e.numeric,e=e.smaller,i=Fi({typed:t,config:r,numeric:n,smaller:e});return t("min",{"...any":function(e){var t;2===e.length&&Object(ie.i)(e[0])&&(t=e[1],Object(ie.y)(t)?e[1]=t-1:Object(ie.e)(t)&&(e[1]=t.minus(1)));try{return i.apply(null,e)}catch(e){throw Oo(e)}}})},{isTransformFunction:!0}),n=["typed","config","?matrix","?bignumber","smaller","smallerEq","larger","largerEq"],Ef=Object(a.a)("range",n,function(e){var t=e.typed,r=e.config,n=e.matrix,i=e.bignumber,a=e.smaller,o=e.smallerEq,s=e.larger,e=e.largerEq,u=zr({typed:t,config:r,matrix:n,bignumber:i,smaller:a,smallerEq:o,larger:s,largerEq:e});return t("range",{"...any":function(e){return"boolean"!=typeof e[e.length-1]&&e.push(!0),u.apply(null,e)}})},{isTransformFunction:!0}),n=["typed","Index","matrix","range"],Sf=Object(a.a)("row",n,function(e){var t=e.typed,r=e.Index,n=e.matrix,e=e.range,i=$r({typed:t,Index:r,matrix:n,range:e});return t("row",{"...any":function(e){var t=e.length-1,r=e[t];Object(ie.y)(r)&&(e[t]=r-1);try{return i.apply(null,e)}catch(e){throw Oo(e)}}})},{isTransformFunction:!0}),n=["typed","matrix"],Af=Object(a.a)("subset",n,function(e){var t=e.typed,e=e.matrix,r=rn({typed:t,matrix:e});return t("subset",{"...any":function(e){try{return r.apply(null,e)}catch(e){throw Oo(e)}}})},{isTransformFunction:!0}),n=["typed","matrix","isInteger"],Cf=Object(a.a)("concat",n,function(e){var t=e.typed,r=e.matrix,e=e.isInteger,n=fr({typed:t,matrix:r,isInteger:e});return t("concat",{"...any":function(e){var t=e.length-1,r=e[t];Object(ie.y)(r)?e[t]=r-1:Object(ie.e)(r)&&(e[t]=r.minus(1));try{return n.apply(null,e)}catch(e){throw Oo(e)}}})},{isTransformFunction:!0}),n=["typed","matrix","subtract","number","bignumber"],_f=Object(a.a)("diff",n,function(e){var t=e.typed,r=e.matrix,n=e.subtract,i=e.number,e=e.bignumber,a=Tr({typed:t,matrix:r,subtract:n,number:i,bignumber:e});return t("diff",{"...any":function(e){var t;2===e.length&&Object(ie.i)(e[0])&&(t=e[1],Object(ie.y)(t)?e[1]=t-1:Object(ie.e)(t)&&(e[1]=t.minus(1)));try{return a.apply(null,e)}catch(e){throw Oo(e)}}})},{isTransformFunction:!0}),n=["typed","sqrt","variance"],Tf=Object(a.a)("std",n,function(e){var t=e.typed,r=e.sqrt,e=e.variance,n=Ys({typed:t,sqrt:r,variance:e});return t("std",{"...any":function(e){var t;2<=e.length&&Object(ie.i)(e[0])&&(t=e[1],Object(ie.y)(t)?e[1]=t-1:Object(ie.e)(t)&&(e[1]=t.minus(1)));try{return n.apply(null,e)}catch(e){throw Oo(e)}}})},{isTransformFunction:!0}),n=["typed","config","add","numeric"],qf=Object(a.a)("sum",n,function(e){var t=e.typed,r=e.config,n=e.add,e=e.numeric,i=Ls({typed:t,config:r,add:n,numeric:e});return t("sum",{"...any":function(e){var t;2===e.length&&Object(ie.i)(e[0])&&(t=e[1],Object(ie.y)(t)?e[1]=t-1:Object(ie.e)(t)&&(e[1]=t.minus(1)));try{return i.apply(null,e)}catch(e){throw Oo(e)}}})},{isTransformFunction:!0}),If="variance",n=["typed","add","subtract","multiply","divide","apply","isNaN"],Bf=Object(a.a)(If,n,function(e){var t=e.typed,r=e.add,n=e.subtract,i=e.multiply,a=e.divide,o=e.apply,e=e.isNaN,s=Js({typed:t,add:r,subtract:n,multiply:i,divide:a,apply:o,isNaN:e});return t(If,{"...any":function(e){var t;2<=e.length&&Object(ie.i)(e[0])&&(t=e[1],Object(ie.y)(t)?e[1]=t-1:Object(ie.e)(t)&&(e[1]=t.minus(1)));try{return s.apply(null,e)}catch(e){throw Oo(e)}}})},{isTransformFunction:!0})},function(e,t,r){"use strict";r.r(t),r.d(t,"create",function(){return j});var d=r(3),t=r(17),f=r.n(t);var y=r(1),g=r(0),b=r(2),v=r(13);function x(e){return(x="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function l(s,e,u,c){function f(e,t){t&&"function"==typeof t.transform?(u.expression.transform[e]=t.transform,r(e)&&(u.expression.mathWithTransform[e]=t.transform)):(delete u.expression.transform[e],r(e)&&(u.expression.mathWithTransform[e]=t))}function l(e){delete u.expression.transform[e],r(e)?u.expression.mathWithTransform[e]=u[e]:delete u.expression.mathWithTransform[e]}function p(e){return"function"==typeof e&&"object"===x(e.signatures)}function r(e){return!Object(d.f)(t,e)}function m(e){return!(-1!==e.fn.indexOf(".")||Object(d.f)(t,e.fn)||e.meta&&e.meta.isClass)}function h(e){return void 0!==e&&void 0!==e.meta&&!0===e.meta.isTransformFunction}var t={expression:!0,type:!0,docs:!0,error:!0,json:!0,chain:!0};return function(e,a){var t=arguments.length;if(1!==t&&2!==t)throw new v.a("import",t,1,2);a=a||{};var r,n,i={};for(r in!function t(r,e,n){if(Array.isArray(e))e.forEach(function(e){return t(r,e)});else if("object"===x(e))for(var i in e)Object(d.f)(e,i)&&t(r,e[i],i);else if(Object(g.b)(e)||void 0!==n){if(n=Object(g.b)(e)?h(e)?e.fn+".transform":e.fn:n,Object(d.f)(r,n)&&r[n]!==e&&!a.silent)throw new Error('Cannot import "'+n+'" twice');r[n]=e}else if(!a.silent)throw new TypeError("Factory, Object, or Array expected")}(i,e),i)if(Object(d.f)(i,r)){var o=i[r];if(Object(g.b)(o))!function(r,n){var i=2<arguments.length&&void 0!==arguments[2]?arguments[2]:r.fn;if(Object(b.b)(i,"."))throw new Error("Factory name should not contain a nested path. Name: "+JSON.stringify(i));function e(){var t={};r.dependencies.map(g.c).forEach(function(e){if(Object(b.b)(e,"."))throw new Error("Factory dependency should not contain a nested path. Name: "+JSON.stringify(e));"math"===e?t.math=u:"mathWithTransform"===e?t.mathWithTransform=u.expression.mathWithTransform:"classes"===e?t.classes=u:t[e]=u[e]});var e=r(t);if(e&&"function"==typeof e.transform)throw new Error('Transforms cannot be attached to factory functions. Please create a separate function for it with exports.path="expression.transform"');if(void 0===o||n.override)return e;if(p(o)&&p(e))return s(o,e);if(n.silent)return o;throw new Error('Cannot import "'+i+'": already exists')}var t=h(r)?u.expression.transform:u,a=i in u.expression.transform,o=Object(d.f)(t,i)?t[i]:void 0;r.meta&&!1===r.meta.lazy?t[i]=e():Object(d.h)(t,i,e),o&&a?l(i):(h(r)||m(r))&&Object(d.h)(u.expression.mathWithTransform,i,function(){return t[i]});c[i]=r,u.emit("import",i,e)}(o,a);else if("function"==typeof(n=o)||"number"==typeof n||"string"==typeof n||"boolean"==typeof n||null===n||Object(y.L)(n)||Object(y.j)(n)||Object(y.e)(n)||Object(y.o)(n)||Object(y.v)(n)||Array.isArray(n))!function(e,t,r){r.wrap&&"function"==typeof t&&(t=function(i){function e(){for(var e=[],t=0,r=arguments.length;t<r;t++){var n=arguments[t];e[t]=n&&n.valueOf()}return i.apply(u,e)}i.transform&&(e.transform=i.transform);return e}(t));!function(e){return"function"==typeof e&&"string"==typeof e.signature}(t)||(t=s(e,function(e,t,r){return t in e?Object.defineProperty(e,t,{value:r,enumerable:!0,configurable:!0,writable:!0}):e[t]=r,e}({},t.signature,t)));if(p(u[e])&&p(t))return t=r.override?s(e,t.signatures):s(u[e],t),u[e]=t,delete c[e],f(e,t),u.emit("import",e,function(){return t});if(void 0===u[e]||r.override)return u[e]=t,delete c[e],f(e,t),u.emit("import",e,function(){return t});if(!r.silent)throw new Error('Cannot import "'+e+'": already exists')}(r,o,a);else if(!a.silent)throw new TypeError("Factory, Object, or Array expected")}}}var p={epsilon:1e-12,matrix:"Matrix",number:"number",precision:64,predictable:!1,randomSeed:null},m=["Matrix","Array"],h=["number","BigNumber","Fraction"];function w(e,t,r){var n,i;void 0!==e[t]&&(n=r,i=e[t],-1===n.indexOf(i))&&console.warn('Warning: Unknown value "'+e[t]+'" for configuration option "'+t+'". Available options: '+r.map(function(e){return JSON.stringify(e)}).join(", ")+".")}var N=r(6),O=r(9);function M(){return(M=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var r,n=arguments[t];for(r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e}).apply(this,arguments)}function j(e,t){var r=M({},p,t);if("function"!=typeof Object.create)throw new Error("ES5 not supported by this JavaScript engine. Please load the es5-shim and es5-sham library for compatibility.");var n,i,a,o=(n={isNumber:y.y,isComplex:y.j,isBigNumber:y.e,isFraction:y.o,isUnit:y.L,isString:y.I,isArray:y.b,isMatrix:y.v,isCollection:y.i,isDenseMatrix:y.n,isSparseMatrix:y.H,isRange:y.D,isIndex:y.t,isBoolean:y.g,isResultSet:y.G,isHelp:y.s,isFunction:y.p,isDate:y.m,isRegExp:y.F,isObject:y.z,isNull:y.x,isUndefined:y.K,isAccessorNode:y.a,isArrayNode:y.c,isAssignmentNode:y.d,isBlockNode:y.f,isConditionalNode:y.k,isConstantNode:y.l,isFunctionAssignmentNode:y.q,isFunctionNode:y.r,isIndexNode:y.u,isNode:y.w,isObjectNode:y.A,isOperatorNode:y.B,isParenthesisNode:y.C,isRangeNode:y.E,isSymbolNode:y.J,isChain:y.h},t=new f.a,n.on=t.on.bind(t),n.off=t.off.bind(t),n.once=t.once.bind(t),n.emit=t.emit.bind(t),n);function s(e){if(e){var t=Object(d.i)(i,d.a);w(e,"matrix",m),w(e,"number",h),Object(d.b)(i,e);var r=Object(d.i)(i,d.a),e=Object(d.i)(e,d.a);return a("config",r,t,e),r}return Object(d.i)(i,d.a)}o.config=(i=r,a=o.emit,s.MATRIX_OPTIONS=m,s.NUMBER_OPTIONS=h,Object.keys(p).forEach(function(e){Object.defineProperty(s,e,{get:function(){return i[e]},enumerable:!0,configurable:!0})}),s),o.expression={transform:{},mathWithTransform:{config:o.config}};var u={};var c=l(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return o.typed.apply(o.typed,t)},0,o,u);return o.import=c,o.on("config",function(){Object(d.k)(u).forEach(function(e){e&&e.meta&&e.meta.recreateOnConfigChange&&c(e,{override:!0})})}),o.create=j.bind(null,e),o.factory=g.a,o.import(Object(d.k)(Object(d.c)(e))),o.ArgumentsError=v.a,o.DimensionError=N.a,o.IndexError=O.a,o}}],i.c=n,i.d=function(e,t,r){i.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:r})},i.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},i.t=function(t,e){if(1&e&&(t=i(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var r=Object.create(null);if(i.r(r),Object.defineProperty(r,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var n in t)i.d(r,n,function(e){return t[e]}.bind(null,n));return r},i.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return i.d(t,"a",t),t},i.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},i.p="",i(i.s=18);function i(e){if(n[e])return n[e].exports;var t=n[e]={i:e,l:!1,exports:{}};return r[e].call(t.exports,t,t.exports,i),t.l=!0,t.exports}var r,n});
//# sourceMappingURL=math.min.map