<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function typed

Create a typed-function which checks the types of the arguments and
can match them against multiple provided signatures. The typed-function
automatically converts inputs in order to find a matching signature.
Typed functions throw informative errors in case of wrong input arguments.

See the library [typed-function](https://github.com/josdejong/typed-function)
for detailed documentation.


## Syntax

```js
math.typed(name, signatures) : function
math.typed(signatures) : function
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`name` | string | Optional name for the typed-function
`signatures` | Object&lt;string, function&gt; | Object with one or multiple function signatures

### Returns

Type | Description
---- | -----------
function | The created typed-function.


## Examples

```js
// create a typed function with multiple types per argument (type union)
const fn2 = typed({
  'number | boolean': function (b) {
    return 'b is a number or boolean'
  },
  'string, number | boolean': function (a, b) {
    return 'a is a string, b is a number or boolean'
  }
})

// create a typed function with an any type argument
const log = typed({
  'string, any': function (event, data) {
    console.log('event: ' + event + ', data: ' + JSON.stringify(data))
  }
})
```


