<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function import

Import functions from an object or a module.

This function is only available on a mathjs instance created using `create`.


## Syntax

```js
math.import(functions)
math.import(functions, options)
```

### Where

- `functions: Object`
  An object with functions or factories to be imported.
- `options: Object` An object with import options. Available options:
  - `override: boolean`
    If true, existing functions will be overwritten. False by default.
  - `silent: boolean`
    If true, the function will not throw errors on duplicates or invalid
    types. False by default.
  - `wrap: boolean`
    If true, the functions will be wrapped in a wrapper function
    which converts data types like Matrix to primitive data types like Array.
    The wrapper is needed when extending math.js with libraries which do not
    support these data type. False by default.

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`functions` | Object &#124; Array | Object with functions to be imported.
`options` | Object | Import options.

## Examples

```js
import { create, all } from 'mathjs'
import * as numbers from 'numbers'

// create a mathjs instance
const math = create(all)

// define new functions and variables
math.import({
  myvalue: 42,
  hello: function (name) {
    return 'hello, ' + name + '!'
  }
})

// use the imported function and variable
math.myvalue * 2               // 84
math.hello('user')             // 'hello, user!'

// import the npm module 'numbers'
// (must be installed first with `npm install numbers`)
math.import(numbers, {wrap: true})

math.fibonacci(7) // returns 13
```


