const express = require('express');
const router = express.Router();
const role = require('../controller/roleController');

router.get('/getRoleName', role.getRoleName);
router.get('/getRight', role.getRight);
router.get('/getRole', role.getRole);
router.get('/getRoleGroup', role.getRoleGroup);
router.post('/getRoleRight', role.getRoleRight);
router.post('/storeRole', role.storeRole);
router.put('/updateRole', role.updateRole);
router.put('/updateLockStatus', role.updateLockStatus);
router.post('/getUserRights',role.getUserRights);
router.post('/storeTempRole',role.storeTempRole);
router.get('/getSuperAdminRights',role.getSuperAdminRights);

module.exports = router;