const express = require('express');
const router = express.Router();
const report = require('../controller/reportController');
const printers = require('../controller/printerController');
const path = require('path');
const multer = require('multer');

const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    cb(null, '\\\\192.168.1.152\\DRL Share File'); // Network path to the shared folder
  },
  filename: (req, file, cb) => {
    cb(null, Date.now() + path.extname(file.originalname)); // Custom naming for uniqueness
  }
});

const upload = multer({ storage: storage });
router.post('/GenerateReport', report.generateReport);
router.post('/generateExceptionReport', report.generateExceptionReport);
router.post('/auditActivityLog', report.rptActivityLog);
router.post('/rptAuditStage', report.rptAuditStage);
router.post('/GetPrinters', printers.getPrinterList);
router.post('/PrintReport', printers.printReport);
router.post('/auditAdminName', report.auditAdminName);
router.post('/auditpasswordComplexity', report.auditpasswordComplexity);
router.post('/auditAdminPasswordChange', report.auditAdminPassword);
router.post('/auditsetAllParameters', report.auditSetAllParam);
router.post('/auditUnauthorizedLogin', report.rptUnauthorizeLogin);
router.post('/rptAuditRoles', report.rptAuditRoles);
router.post('/rptAuditUser', report.rptAuditUser);
router.post('/rptDepartment', report.rptDepartment);
router.post('/rptCalibrationBox', report.rptCalibBox);
router.post('/rptAuditBalance', report.rptAuditBalnce);
router.post('/rptAuditVernier', report.rptAuditVernier);
router.post('/rptAuditotherEquipment', report.rptAuditOther);
router.post('/rptAuditMachine', report.rptAuditMachine);
router.post('/rptAuditMedia', report.rptAuditMedia);
router.post('/rptAuditProduct', report.rptAuditProduct);
router.post('/rptAuditArea', report.rptAuditArea);
router.post('/rptAuditPort', report.rptAuditPort);
router.post('/rptAuditContainer', report.rptAuditContainer);
router.post('/rptAuditBinStage', report.rptAuditBinStage);
router.post('/rptAuditCubicle', report.rptAuditCubicle);
router.post('/rptAuditCleaner', report.rptAuditCleaner);
router.post('/rptAuditRecalib', report.rptAuditRecalib);
router.post('/rptAuditAlert', report.rptAlertAudit);
router.post('/printcountupSummary', report.increasePrintCountSummary);
router.post('/printcountupBinSummary', report.increasePrintCountBinSummary);
router.post('/increasePrintCountUpBinLabel', report.increasePrintCountUpBinLabel);
router.post('/printReasonReportCalibration', report.printReasonReportCalibration);
router.post('/printCountUpCalibration', report.increasePrintCountCalibration);
router.post('/rptAuditPrecalibration', report.rptAuditPrecalibration);

router.post('/TestApi',upload.single('file'), report.TestApi);

module.exports = router;