/**
 * Coated
 */
var IterateObject = require('iterate-object');
serverConfig = require('../global/serverConfig').developerPanelData;
const Bln_Is_HardnessNMTNLT = (serverConfig.ProductMasterConf.find(x => x.Name === 'HardnessNMTNLT').Value == 1) ? true : false;

class ValidateProductCoated {
    constructor() {
        const objResult = {};
        this.objResult = objResult;
        this.strNullValue = "99999.00000";
        this.intNullValue = 99999;
        this.NMTValue = 99999;
    }

    validateIndividual(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objIndividual = {
                Individual: {
                    Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    LimitOn: { oldValue: "", newValue: "" },
                    ReportOn: { oldValue: "", newValue: "" },
                    Nomenclature: { oldValue: "", newValue: "" },
                    Unit:{ oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_IndStdCoat != "" && objProductNew.flt_IndStdCoat != undefined) {
                    objIndividual.Individual.Nom.oldValue = "NA";
                    objIndividual.Individual.Nom.newValue = objProductNew.flt_IndStdCoat;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.Nom.oldValue = false;
                    objIndividual.Individual.Nom.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param1_Nom === "" || objProductOld.Param1_Nom == this.strNullValue || objProductOld.Param1_Nom == undefined) {
                    objProductOld.Param1_Nom = null;
                }

                if (objProductNew.flt_IndStdCoat === "" || objProductNew.flt_IndStdCoat == this.strNullValue) {
                    objProductNew.flt_IndStdCoat = null;
                }
                
                if ((objProductOld.Param1_Nom !== null) && (objProductNew.flt_IndStdCoat !== null)) {
                    if (parseFloat(objProductOld.Param1_Nom).toFixed(objProductOld.Param1_DP) == parseFloat(objProductNew.flt_IndStdCoat).toFixed(objProductNew.int_IndCoatDp)) {
                        objIndividual.Individual.Nom.oldValue = false;
                        objIndividual.Individual.Nom.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objIndividual.Individual.Nom.oldValue = parseFloat(objProductOld.Param1_Nom).toFixed(objProductOld.Param1_DP);
                        objIndividual.Individual.Nom.newValue = objProductNew.flt_IndStdCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param1_Nom === null) && (objProductNew.flt_IndStdCoat !== null)) {
                        objIndividual.Individual.Nom.oldValue = "NA";
                        objIndividual.Individual.Nom.newValue = objProductNew.flt_IndStdCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param1_Nom !== null) && (objProductNew.flt_IndStdCoat === null)) {
                        objIndividual.Individual.Nom.oldValue = parseFloat(objProductOld.Param1_Nom).toFixed(objProductOld.Param1_DP);
                        objIndividual.Individual.Nom.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Individual NegT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_IndT1NegCoat != "" && objProductNew.flt_IndT1NegCoat != undefined) {
                    objIndividual.Individual.T1Neg.oldValue = "NA";
                    objIndividual.Individual.T1Neg.newValue = objProductNew.flt_IndT1NegCoat;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.T1Neg.oldValue = false;
                    objIndividual.Individual.T1Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_T1Neg === "" ||
                    objProductOld.Param1_T1Neg == this.strNullValue ||
                    objProductOld.Param1_T1Neg == undefined) {

                    objProductOld.Param1_T1Neg = null;
                }

                if (objProductNew.flt_IndT1NegCoat === "" || objProductNew.flt_IndT1NegCoat == this.strNullValue || objProductNew.flt_IndT1NegCoat == undefined) {
                    objProductNew.flt_IndT1NegCoat = null;
                }

                if ((objProductOld.Param1_T1Neg !== null) && (objProductNew.flt_IndT1NegCoat !== null)) {
                    if (parseFloat(objProductOld.Param1_T1Neg).toFixed(objProductOld.Param1_DP) == parseFloat(objProductNew.flt_IndT1NegCoat).toFixed(objProductNew.int_IndCoatDp)) {
                        objIndividual.Individual.T1Neg.oldValue = false;
                        objIndividual.Individual.T1Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objIndividual.Individual.T1Neg.oldValue = parseFloat(objProductOld.Param1_T1Neg).toFixed(objProductOld.Param1_DP);
                        objIndividual.Individual.T1Neg.newValue = objProductNew.flt_IndT1NegCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param1_T1Neg === null) && (objProductNew.flt_IndT1NegCoat !== null)) {
                        objIndividual.Individual.T1Neg.oldValue = "NA";
                        objIndividual.Individual.T1Neg.newValue = objProductNew.flt_IndT1NegCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param1_T1Neg !== null) && (objProductNew.flt_IndT1NegCoat === null)) {
                        objIndividual.Individual.T1Neg.oldValue = parseFloat(objProductOld.Param1_T1Neg).toFixed(objProductOld.Param1_DP);
                        objIndividual.Individual.T1Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Individual PosT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_IndT1PosCoat != "" && objProductNew.flt_IndT1PosCoat != undefined) {
                    objIndividual.Individual.T1Pos.oldValue = "NA";
                    objIndividual.Individual.T1Pos.newValue = objProductNew.flt_IndT1PosCoat;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.T1Pos.oldValue = false;
                    objIndividual.Individual.T1Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {

                if (objProductOld.Param1_T1Pos === "" ||
                    objProductOld.Param1_T1Pos == this.strNullValue ||
                    objProductOld.Param1_T1Pos == undefined) {
                    objProductOld.Param1_T1Pos = null;
                }

                if (objProductNew.flt_IndT1PosCoat === "" ||
                    objProductNew.flt_IndT1PosCoat == this.strNullValue ||
                    objProductNew.flt_IndT1PosCoat == undefined) {
                    objProductNew.flt_IndT1PosCoat = null;
                }

                if ((objProductOld.Param1_T1Pos !== null) && (objProductNew.flt_IndT1PosCoat !== null)) {
                    if (parseFloat(objProductOld.Param1_T1Pos).toFixed(objProductOld.Param1_DP) == parseFloat(objProductNew.flt_IndT1PosCoat).toFixed(objProductNew.int_IndCoatDp)) {
                        objIndividual.Individual.T1Pos.oldValue = false;
                        objIndividual.Individual.T1Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objIndividual.Individual.T1Pos.oldValue = parseFloat(objProductOld.Param1_T1Pos).toFixed(objProductOld.Param1_DP);
                        objIndividual.Individual.T1Pos.newValue = objProductNew.flt_IndT1PosCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param1_T1Pos === null) && (objProductNew.flt_IndT1PosCoat !== null)) {
                        objIndividual.Individual.T1Pos.oldValue = "NA";
                        objIndividual.Individual.T1Pos.newValue = objProductNew.flt_IndT1PosCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param1_T1Pos !== null) && (objProductNew.flt_IndT1PosCoat === null)) {
                        objIndividual.Individual.T1Pos.oldValue = parseFloat(objProductOld.Param1_T1Pos).toFixed(objProductOld.Param1_DP);
                        objIndividual.Individual.T1Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Individual NegT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_IndT2NegCoat != "" && objProductNew.flt_IndT2NegCoat != undefined) {
                    objIndividual.Individual.T2Neg.oldValue = "NA";
                    objIndividual.Individual.T2Neg.newValue = objProductNew.flt_IndT2NegCoat;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.T2Neg.oldValue = false;
                    objIndividual.Individual.T2Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_T2Neg === "" || objProductOld.Param1_T2Neg == this.strNullValue || objProductOld.Param1_T2Neg == undefined) {
                    objProductOld.Param1_T2Neg = null;
                }

                if (objProductNew.flt_IndT2NegCoat === "" || objProductNew.flt_IndT2NegCoat == this.strNullValue || objProductNew.flt_IndT2NegCoat == undefined) {
                    objProductNew.flt_IndT2NegCoat = null;
                }

                if ((objProductOld.Param1_T2Neg !== null) && (objProductNew.flt_IndT2NegCoat !== null)) {
                    if (parseFloat(objProductOld.Param1_T2Neg).toFixed(objProductOld.Param1_DP) == parseFloat(objProductNew.flt_IndT2NegCoat).toFixed(objProductNew.int_IndCoatDp)) {
                        objIndividual.Individual.T2Neg.oldValue = false;
                        objIndividual.Individual.T2Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objIndividual.Individual.T2Neg.oldValue = parseFloat(objProductOld.Param1_T2Neg).toFixed(objProductOld.Param1_DP);
                        objIndividual.Individual.T2Neg.newValue = objProductNew.flt_IndT2NegCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param1_T2Neg === null) && (objProductNew.flt_IndT2NegCoat !== null)) {
                        objIndividual.Individual.T2Neg.oldValue = "NA";
                        objIndividual.Individual.T2Neg.newValue = objProductNew.flt_IndT2NegCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param1_T2Neg !== null) && (objProductNew.flt_IndT2NegCoat === null)) {
                        objIndividual.Individual.T2Neg.oldValue = parseFloat(objProductOld.Param1_T2Neg).toFixed(objProductOld.Param1_DP);
                        objIndividual.Individual.T2Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Individual PosT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_IndT2PosCoat != "" && objProductNew.flt_IndT2PosCoat != undefined) {
                    objIndividual.Individual.T2Pos.oldValue = "NA";
                    objIndividual.Individual.T2Pos.newValue = objProductNew.flt_IndT2PosCoat;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.T2Pos.oldValue = false;
                    objIndividual.Individual.T2Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_T2Pos === "" || objProductOld.Param1_T2Pos == this.strNullValue || objProductOld.Param1_T2Pos == undefined) {
                    objProductOld.Param1_T2Pos = null;
                }

                if (objProductNew.flt_IndT2PosCoat === "" || objProductNew.flt_IndT2PosCoat == this.strNullValue || objProductNew.flt_IndT2PosCoat == undefined) {
                    objProductNew.flt_IndT2PosCoat = null;
                }

                if ((objProductOld.Param1_T2Pos !== null) && (objProductNew.flt_IndT2PosCoat !== null)) {
                    if (parseFloat(objProductOld.Param1_T2Pos).toFixed(objProductOld.Param1_DP) == parseFloat(objProductNew.flt_IndT2PosCoat).toFixed(objProductNew.int_IndCoatDp)) {
                        objIndividual.Individual.T2Pos.oldValue = false;
                        objIndividual.Individual.T2Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objIndividual.Individual.T2Pos.oldValue = parseFloat(objProductOld.Param1_T2Pos).toFixed(objProductOld.Param1_DP);
                        objIndividual.Individual.T2Pos.newValue = objProductNew.flt_IndT2PosCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param1_T2Pos === null) && (objProductNew.flt_IndT2PosCoat !== null)) {
                        objIndividual.Individual.T2Pos.oldValue = "NA";
                        objIndividual.Individual.T2Pos.newValue = objProductNew.flt_IndT2PosCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param1_T2Pos !== null) && (objProductNew.flt_IndT2PosCoat === null)) {
                        objIndividual.Individual.T2Pos.oldValue = parseFloat(objProductOld.Param1_T2Pos).toFixed(objProductOld.Param1_DP);
                        objIndividual.Individual.T2Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Individual NMT
            */
            if (OldEmpty) {
                if (objProductNew.int_IndNMTTabCntCoat != "" && objProductNew.int_IndNMTTabCntCoat != undefined) {
                    objIndividual.Individual.NMT.oldValue = "NA";
                    objIndividual.Individual.NMT.newValue = objProductNew.int_IndNMTTabCntCoat;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.NMT.oldValue = false;
                    objIndividual.Individual.NMT.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {

                if (objProductOld.Param1_NMTTab == 0 ||
                    objProductOld.Param1_NMTTab == this.intNullValue ||
                    objProductOld.Param1_NMTTab == undefined) {
                    objProductOld.Param1_NMTTab = null;
                }

                objProductNew.int_IndNMTTabCntCoat = objProductNew.int_IndNMTTabCntCoat === "" ? this.strNullValue : objProductNew.int_IndNMTTabCntCoat;

                if (objProductNew.int_IndNMTTabCntCoat == "0" ||
                    objProductNew.int_IndNMTTabCntCoat == this.intNullValue ||
                    objProductNew.int_IndNMTTabCntCoat == undefined) {
                    objProductNew.int_IndNMTTabCntCoat = null;
                }

                if (objProductOld.Param1_NMTTab == objProductNew.int_IndNMTTabCntCoat) {
                    objIndividual.Individual.NMT.oldValue = false;
                    objIndividual.Individual.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }
                else {
                    objIndividual.Individual.NMT.oldValue = objProductOld.Param1_NMTTab;
                    objIndividual.Individual.NMT.newValue = objProductNew.int_IndNMTTabCntCoat;
                    IsChanged = true;
                }
            }

            /**
             * For Individual Limits On Actual / Percent
             */
            if (OldEmpty) {
                if (objProductNew.str_IndLimitOnCoat != "" && objProductNew.flt_IndStdCoat != "" && objProductNew.str_IndLimitOnCoat != undefined && objProductNew.flt_IndStdCoat != undefined) {
                    objIndividual.Individual.LimitOn.oldValue = "NA";
                    objIndividual.Individual.LimitOn.newValue = objProductNew.str_IndLimitOnCoat;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.LimitOn.oldValue = false;
                    objIndividual.Individual.LimitOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_Nom === "" ||
                    objProductOld.Param1_Nom == this.strNullValue ||
                    objProductOld.Param1_Nom == undefined) 
                {
                    const strLimitOn1 = objProductOld.Param1_LimitOn == 0 ? "Actual" : "Percentage";
                    if(strLimitOn1 == objProductNew.str_IndLimitOnCoat){
                        objIndividual.Individual.LimitOn.oldValue = false;
                        objIndividual.Individual.LimitOn.newValue = false;
                        IsChanged = false;
                    }else{
                        objIndividual.Individual.LimitOn.oldValue = strLimitOn1;
                        objIndividual.Individual.LimitOn.newValue = objProductNew.str_IndLimitOnCoat;
                        IsChanged = true;
                    }
                }
                else {
                    const strLimitOn = objProductOld.Param1_LimitOn == 0 ? "Actual" : "Percentage";
                    if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStdCoat != null) { // new parameter added
                        objIndividual.Individual.LimitOn.oldValue = "NA";
                        objIndividual.Individual.LimitOn.newValue = objProductNew.str_IndLimitOnCoat;
                        IsChanged = true;
                    }
                    else if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStdCoat == null) // no parameter added
                    {
                        objIndividual.Individual.LimitOn.oldValue = false;
                        objIndividual.Individual.LimitOn.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        if (strLimitOn == objProductNew.str_IndLimitOnCoat) {
                            objIndividual.Individual.LimitOn.oldValue = false;
                            objIndividual.Individual.LimitOn.newValue = false;
                            IsChanged != true ? IsChanged = false : IsChanged = true;
                        }
                        else {
                            objIndividual.Individual.LimitOn.oldValue = strLimitOn;
                            objIndividual.Individual.LimitOn.newValue = objProductNew.str_IndLimitOnCoat;
                            IsChanged = true;
                        }
                    }
                }
            }

            /**
             * For Individual Limits On Standard / Avg
             */
            if (OldEmpty) {
                if (objProductNew.str_IndGraphOnCoat != "" && objProductNew.flt_IndStdCoat != "" && objProductNew.str_IndGraphOnCoat != undefined && objProductNew.flt_IndStdCoat != undefined) {
                    objIndividual.Individual.ReportOn.oldValue = "NA";
                    objIndividual.Individual.ReportOn.newValue = objProductNew.str_IndGraphOnCoat;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.ReportOn.oldValue = false;
                    objIndividual.Individual.ReportOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strGraphOn = objProductOld.Param1_IsOnStd == 0 ? "Standard" : "Average";
                if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStdCoat != null) { // new parameter added
                    objIndividual.Individual.ReportOn.oldValue = "NA";
                    objIndividual.Individual.ReportOn.newValue = objProductNew.str_IndGraphOnCoat;
                    IsChanged = true;
                }
                else if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStdCoat == null) // no parameter added
                {
                    objIndividual.Individual.ReportOn.oldValue = false;
                    objIndividual.Individual.ReportOn.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strGraphOn == objProductNew.str_IndGraphOnCoat) {
                        objIndividual.Individual.ReportOn.oldValue = false;
                        objIndividual.Individual.ReportOn.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividual.Individual.ReportOn.oldValue = strGraphOn;
                        objIndividual.Individual.ReportOn.newValue = objProductNew.str_IndGraphOnCoat;
                        IsChanged = true;
                    }
                }
            }

            /** Nominal Nomenclature */
            if (OldEmpty) {
                if (objProductNew.str_indCoat_nomNomnclature != "" && objProductNew.flt_IndStdCoat != "" && objProductNew.str_indCoat_nomNomnclature != undefined && objProductNew.flt_IndStdCoat != undefined) {
                    objIndividual.Individual.Nomenclature.oldValue = "NA";
                    objIndividual.Individual.Nomenclature.newValue = objProductNew.str_indCoat_nomNomnclature;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.Nomenclature.oldValue = false;
                    objIndividual.Individual.Nomenclature.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStdCoat != null) { // new parameter added
                    objIndividual.Individual.Nomenclature.oldValue = "NA";
                    objIndividual.Individual.Nomenclature.newValue = objProductNew.str_indCoat_nomNomnclature;
                    IsChanged = true;
                }
                else if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStdCoat == null) // no parameter added
                {
                    objIndividual.Individual.Nomenclature.oldValue = false;
                    objIndividual.Individual.Nomenclature.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param1_Nomenclature == objProductNew.str_indCoat_nomNomnclature) {
                        objIndividual.Individual.Nomenclature.oldValue = false;
                        objIndividual.Individual.Nomenclature.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividual.Individual.Nomenclature.oldValue = objProductOld.Param1_Nomenclature;
                        objIndividual.Individual.Nomenclature.newValue = objProductNew.str_indCoat_nomNomnclature;
                        IsChanged = true;
                    }
                }
            }

            if (OldEmpty) {
                if (objProductNew.str_indUnit != "" && objProductNew.flt_IndStdCoat != "" && objProductNew.str_indUnit != undefined && objProductNew.flt_IndStdCoat != undefined) {
                    objIndividual.Individual.Unit.oldValue = "NA";
                    objIndividual.Individual.Unit.newValue = objProductNew.str_indUnit;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.Unit.oldValue = false;
                    objIndividual.Individual.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param1_Unit == "NA" ? objProductOld.Param1_Unit = "gm" : objProductOld.Param1_Unit;
                if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStdCoat != null) { // new parameter added
                    objIndividual.Individual.Unit.oldValue = "gm";
                    objIndividual.Individual.Unit.newValue = objProductNew.str_indUnit;
                    IsChanged = true;
                }
                else if (objProductOld.Param1_Unit == null && objProductNew.str_indUnit == null) // no parameter added
                {
                    objIndividual.Individual.Unit.oldValue = false;
                    objIndividual.Individual.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param1_Unit == objProductNew.str_indUnit) {
                        objIndividual.Individual.Unit.oldValue = false;
                        objIndividual.Individual.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividual.Individual.Unit.oldValue = objProductOld.Param1_Unit;
                        objIndividual.Individual.Unit.newValue = objProductNew.str_indUnit;
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objIndividual);
            }
            resolve(IsChanged);
        });
    }

    validateGroup(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objGroup = {
                Group: {
                    Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    LimitOn: { oldValue: "", newValue: "" },
                    ReportOn: { oldValue: "", newValue: "" },
                    Unit: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Group Nom
             */
            if (OldEmpty) {
                if (objProductNew.flt_GrpStdCoat != "" && objProductNew.flt_GrpStdCoat != undefined) {
                    objGroup.Group.Nom.oldValue = "NA";
                    objGroup.Group.Nom.newValue = objProductNew.flt_GrpStdCoat;
                    IsChanged = true;
                } else {
                    objGroup.Group.Nom.oldValue = false;
                    objGroup.Group.Nom.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param2_Nom === "" || objProductOld.Param2_Nom == this.strNullValue || objProductOld.Param2_Nom == undefined) {
                    objProductOld.Param2_Nom = null;
                }

                if (objProductNew.flt_GrpStdCoat === "" || objProductNew.flt_GrpStdCoat == this.intNullValue || objProductNew.flt_GrpStdCoat == undefined) {
                    objProductNew.flt_GrpStdCoat = null;
                }

                if ((objProductOld.Param2_Nom !== null) && (objProductNew.flt_GrpStdCoat !== null)) {
                    if (parseFloat(objProductOld.Param2_Nom).toFixed(objProductOld.Param2_DP) == parseFloat(objProductNew.flt_GrpStdCoat).toFixed(objProductNew.int_GrpCoatDp)) {
                        objGroup.Group.Nom.oldValue = false;
                        objGroup.Group.Nom.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objGroup.Group.Nom.oldValue = parseFloat(objProductOld.Param2_Nom).toFixed(objProductOld.Param2_DP);
                        objGroup.Group.Nom.newValue = objProductNew.flt_GrpStdCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param2_Nom === null) && (objProductNew.flt_GrpStdCoat !== null)) {
                        objGroup.Group.Nom.oldValue = "NA";
                        objGroup.Group.Nom.newValue = objProductNew.flt_GrpStdCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param2_Nom !== null) && (objProductNew.flt_GrpStdCoat === null)) {
                        objGroup.Group.Nom.oldValue = parseFloat(objProductOld.Param2_Nom).toFixed(objProductOld.Param2_DP);
                        objGroup.Group.Nom.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            //For Group NegT1
            if (OldEmpty) {
                if (objProductNew.flt_GrpT1NegCoat != "" && objProductNew.flt_GrpT1NegCoat != undefined) {
                    objGroup.Group.T1Neg.oldValue = "NA";
                    objGroup.Group.T1Neg.newValue = objProductNew.flt_GrpT1NegCoat;
                    IsChanged = true;
                } else {
                    objGroup.Group.T1Neg.oldValue = false;
                    objGroup.Group.T1Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {

                if (objProductOld.Param2_T1Neg === "" || objProductOld.Param2_T1Neg == this.strNullValue || objProductOld.Param2_T1Neg == undefined) {
                    objProductOld.Param2_T1Neg = null;
                }

                if (objProductNew.flt_GrpT1NegCoat === "" || objProductNew.flt_GrpT1NegCoat == this.intNullValue || objProductNew.flt_GrpT1NegCoat == undefined) {
                    objProductNew.flt_GrpT1NegCoat = null;
                }

                if ((objProductOld.Param2_T1Neg !== null) && (objProductNew.flt_GrpT1NegCoat !== null)) {
                    if (parseFloat(objProductOld.Param2_T1Neg).toFixed(objProductOld.Param2_DP) == parseFloat(objProductNew.flt_GrpT1NegCoat).toFixed(objProductNew.int_GrpCoatDp)) {
                        objGroup.Group.T1Neg.oldValue = false;
                        objGroup.Group.T1Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objGroup.Group.T1Neg.oldValue = parseFloat(objProductOld.Param2_T1Neg).toFixed(objProductOld.Param2_DP);
                        objGroup.Group.T1Neg.newValue = objProductNew.flt_GrpT1NegCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param2_T1Neg === null) && (objProductNew.flt_GrpT1NegCoat !== null)) {
                        objGroup.Group.T1Neg.oldValue = "NA";
                        objGroup.Group.T1Neg.newValue = objProductNew.flt_GrpT1NegCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param2_T1Neg !== null) && (objProductNew.flt_GrpT1NegCoat === null)) {
                        objGroup.Group.T1Neg.oldValue = parseFloat(objProductOld.Param2_T1Neg).toFixed(objProductOld.Param2_DP);
                        objGroup.Group.T1Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            // For Group PosT1
            if (OldEmpty) {
                if (objProductNew.flt_GrpT1PosCoat != "" && objProductNew.flt_GrpT1PosCoat != undefined) {
                    objGroup.Group.T1Pos.oldValue = "NA";
                    objGroup.Group.T1Pos.newValue = objProductNew.flt_GrpT1PosCoat;
                    IsChanged = true;
                } else {
                    objGroup.Group.T1Pos.oldValue = false;
                    objGroup.Group.T1Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {

                if (objProductOld.Param2_T1Pos === "" || objProductOld.Param2_T1Pos == this.strNullValue || objProductOld.Param2_T1Pos == undefined) {
                    objProductOld.Param2_T1Pos = null;
                }

                if (objProductNew.flt_GrpT1PosCoat === "" || objProductNew.flt_GrpT1PosCoat == this.intNullValue || objProductNew.flt_GrpT1PosCoat == undefined) {
                    objProductNew.flt_GrpT1PosCoat = null;
                }

                if ((objProductOld.Param2_T1Pos !== null) && (objProductNew.flt_GrpT1PosCoat !== null)) {
                    if (parseFloat(objProductOld.Param2_T1Pos).toFixed(objProductOld.Param2_DP) == parseFloat(objProductNew.flt_GrpT1PosCoat).toFixed(objProductNew.int_GrpCoatDp)) {
                        objGroup.Group.T1Pos.oldValue = false;
                        objGroup.Group.T1Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objGroup.Group.T1Pos.oldValue = parseFloat(objProductOld.Param2_T1Pos).toFixed(objProductOld.Param2_DP);
                        objGroup.Group.T1Pos.newValue = objProductNew.flt_GrpT1PosCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param2_T1Pos === null) && (objProductNew.flt_GrpT1PosCoat !== null)) {
                        objGroup.Group.T1Pos.oldValue = "NA";
                        objGroup.Group.T1Pos.newValue = objProductNew.flt_GrpT1PosCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param2_T1Pos !== null) && (objProductNew.flt_GrpT1PosCoat === null)) {
                        objGroup.Group.T1Pos.oldValue = parseFloat(objProductOld.Param2_T1Pos).toFixed(objProductOld.Param2_DP);
                        objGroup.Group.T1Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
 
            /**
            * For Group NegT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_GrpT2NegCoat != "" && objProductNew.flt_GrpT2NegCoat != undefined) {
                    objGroup.Group.T2Neg.oldValue = "NA";
                    objGroup.Group.T2Neg.newValue = objProductNew.flt_GrpT2NegCoat;
                    IsChanged = true;
                } else {
                    objGroup.Group.T2Neg.oldValue = false;
                    objGroup.Group.T2Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {
                if (objProductOld.Param2_T2Neg === "" || objProductOld.Param2_T2Neg == this.strNullValue || objProductOld.Param2_T2Neg == undefined) {
                    objProductOld.Param2_T2Neg = null;
                }

                if (objProductNew.flt_GrpT2NegCoat === "" || objProductNew.flt_GrpT2NegCoat == this.intNullValue || objProductNew.flt_GrpT2NegCoat == undefined) {
                    objProductNew.flt_GrpT2NegCoat = null;
                }

                if ((objProductOld.Param2_T2Neg !== null) && (objProductNew.flt_GrpT2NegCoat !== null)) {
                    if (parseFloat(objProductOld.Param2_T2Neg).toFixed(objProductOld.Param2_DP) == parseFloat(objProductNew.flt_GrpT2NegCoat).toFixed(objProductNew.int_GrpCoatDp)) {
                        objGroup.Group.T2Neg.oldValue = false;
                        objGroup.Group.T2Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objGroup.Group.T2Neg.oldValue = parseFloat(objProductOld.Param2_T2Neg).toFixed(objProductOld.Param2_DP);
                        objGroup.Group.T2Neg.newValue = objProductNew.flt_GrpT2NegCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param2_T2Neg === null) && (objProductNew.flt_GrpT2NegCoat !== null)) {
                        objGroup.Group.T2Neg.oldValue = "NA";
                        objGroup.Group.T2Neg.newValue = objProductNew.flt_GrpT2NegCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param2_T2Neg !== null) && (objProductNew.flt_GrpT2NegCoat === null)) {
                        objGroup.Group.T2Neg.oldValue = parseFloat(objProductOld.Param2_T2Neg).toFixed(objProductOld.Param2_DP);
                        objGroup.Group.T2Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Group PosT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_GrpT2PosCoat != "" && objProductNew.flt_GrpT2PosCoat != undefined) {
                    objGroup.Group.T2Pos.oldValue = "NA";
                    objGroup.Group.T2Pos.newValue = objProductNew.flt_GrpT2PosCoat;
                    IsChanged = true;
                } else {
                    objGroup.Group.T2Pos.oldValue = false;
                    objGroup.Group.T2Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param2_T2Pos === "" || objProductOld.Param2_T2Pos == this.strNullValue || objProductOld.Param2_T2Pos == undefined) {
                    objProductOld.Param2_T2Pos = null;
                }

                if (objProductNew.flt_GrpT2PosCoat === "" || objProductNew.flt_GrpT2PosCoat == this.intNullValue || objProductNew.flt_GrpT2PosCoat == undefined) {
                    objProductNew.flt_GrpT2PosCoat = null;
                }

                if ((objProductOld.Param2_T2Pos !== null) && (objProductNew.flt_GrpT2PosCoat !== null)) {
                    if (parseFloat(objProductOld.Param2_T2Pos).toFixed(objProductOld.Param2_DP) == parseFloat(objProductNew.flt_GrpT2PosCoat).toFixed(objProductNew.int_GrpCoatDp)) {
                        objGroup.Group.T2Pos.oldValue = false;
                        objGroup.Group.T2Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objGroup.Group.T2Pos.oldValue = parseFloat(objProductOld.Param2_T2Pos).toFixed(objProductOld.Param2_DP);
                        objGroup.Group.T2Pos.newValue = objProductNew.flt_GrpT2PosCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param2_T2Pos === null) && (objProductNew.flt_GrpT2PosCoat !== null)) {
                        objGroup.Group.T2Pos.oldValue = "NA";
                        objGroup.Group.T2Pos.newValue = objProductNew.flt_GrpT2PosCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param2_T2Pos !== null) && (objProductNew.flt_GrpT2PosCoat === null)) {
                        objGroup.Group.T2Pos.oldValue = parseFloat(objProductOld.Param2_T2Pos).toFixed(objProductOld.Param2_DP);
                        objGroup.Group.T2Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            //For Group NMT
            if (OldEmpty) {
                if (objProductNew.int_GrpNMTTabCntCoat != "" && objProductNew.int_GrpNMTTabCntCoat != undefined) {
                    objGroup.Group.NMT.oldValue = "NA";
                    objGroup.Group.NMT.newValue = objProductNew.int_GrpNMTTabCntCoat;
                    IsChanged = true;
                } else {
                    objGroup.Group.NMT.oldValue = false;
                    objGroup.Group.NMT.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {
                if (objProductOld.Param2_NMTTab == 0 ||
                    objProductOld.Param2_NMTTab == this.intNullValue ||
                    objProductOld.Param2_NMTTab == undefined) {
                    objProductOld.Param2_NMTTab = null;
                }

                objProductNew.int_GrpNMTTabCntCoat = objProductNew.int_GrpNMTTabCntCoat === "" ? this.strNullValue : objProductNew.int_GrpNMTTabCntCoat;

                if (objProductNew.int_GrpNMTTabCntCoat == "0" ||
                    objProductNew.int_GrpNMTTabCntCoat == this.intNullValue ||
                    objProductNew.int_GrpNMTTabCntCoat == undefined) {
                    objProductNew.int_GrpNMTTabCntCoat = null;
                }

                if (objProductOld.Param2_NMTTab == objProductNew.int_GrpNMTTabCntCoat) {
                    objGroup.Group.NMT.oldValue = false;
                    objGroup.Group.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }
                else {
                    objGroup.Group.NMT.oldValue = objProductOld.Param2_NMTTab;
                    objGroup.Group.NMT.newValue = objProductNew.int_GrpNMTTabCntCoat;
                    IsChanged = true;
                }
            }

            /**
             * For Group Limits On Actual / Percent
             */
            if (OldEmpty) {
                if (objProductNew.str_GrpLimitOnCoat != "" && objProductNew.flt_GrpStdCoat != "" && objProductNew.str_GrpLimitOnCoat != undefined && objProductNew.flt_GrpStdCoat != undefined) {
                    objGroup.Group.LimitOn.oldValue = "NA";
                    objGroup.Group.LimitOn.newValue = objProductNew.str_GrpLimitOnCoat;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.LimitOn.oldValue = false;
                    objGroup.Group.LimitOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strLimitOn = objProductOld.Param2_LimitOn == 0 ? "Actual" : "Percentage";
                if (objProductOld.Param2_Nom == null && objProductNew.flt_GrpStdCoat != null) { // new parameter added
                    objGroup.Group.LimitOn.oldValue = "NA";
                    objGroup.Group.LimitOn.newValue = objProductNew.str_GrpLimitOnCoat;
                    IsChanged = true;
                }
                else if (objProductOld.Param2_Nom == null && objProductNew.flt_GrpStdCoat == null) // no parameter added
                {
                    objGroup.Group.LimitOn.oldValue = false;
                    objGroup.Group.LimitOn.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strLimitOn == objProductNew.str_GrpLimitOnCoat) {
                        objGroup.Group.LimitOn.oldValue = false;
                        objGroup.Group.LimitOn.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group.LimitOn.oldValue = strLimitOn;
                        objGroup.Group.LimitOn.newValue = objProductNew.str_GrpLimitOnCoat;
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Group Limits On Standard / Avg
             */
            if (OldEmpty) {
                if (objProductNew.str_GrpGraphOnCoat != "" && objProductNew.flt_GrpStdCoat != "" && objProductNew.str_GrpGraphOnCoat != undefined && objProductNew.flt_GrpStdCoat != undefined) {
                    objGroup.Group.ReportOn.oldValue = "NA";
                    objGroup.Group.ReportOn.newValue = objProductNew.str_GrpGraphOnCoat;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.ReportOn.oldValue = false;
                    objGroup.Group.ReportOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strGraphOn = objProductOld.Param2_IsOnStd == 0 ? "Standard" : "Average";
                if (objProductOld.Param2_Nom == null && objProductNew.flt_GrpStdCoat != null) { // new parameter added
                    objGroup.Group.ReportOn.oldValue = "NA";
                    objGroup.Group.ReportOn.newValue = objProductNew.str_GrpGraphOnCoat;
                    IsChanged = true;
                }
                else if (objProductOld.Param2_Nom == null && objProductNew.flt_GrpStdCoat == null) // no parameter added
                {
                    objGroup.Group.ReportOn.oldValue = false;
                    objGroup.Group.ReportOn.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strGraphOn == objProductNew.str_GrpGraphOnCoat) {
                        objGroup.Group.ReportOn.oldValue = false;
                        objGroup.Group.ReportOn.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group.ReportOn.oldValue = strGraphOn;
                        objGroup.Group.ReportOn.newValue = objProductNew.str_GrpGraphOnCoat;
                        IsChanged = true;
                    }
                }
            }

            if (OldEmpty) {
                if (objProductNew.str_groupUnit != "" && objProductNew.flt_GrpStdCoat != "" && objProductNew.str_groupUnit != undefined && objProductNew.flt_GrpStdCoat != undefined) {
                    objGroup.Group.Unit.oldValue = "NA";
                    objGroup.Group.Unit.newValue = objProductNew.str_groupUnit;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.Unit.oldValue = false;
                    objGroup.Group.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strGraphOn = objProductOld.Param2_Unit == 0 ? "gm" : objProductOld.Param2_Unit;
                if (objProductOld.Param2_Nom == null && objProductNew.flt_GrpStdCoat != null) { // new parameter added
                    objGroup.Group.Unit.oldValue = "NA";
                    objGroup.Group.Unit.newValue = objProductNew.str_groupUnit;
                    IsChanged = true;
                }
                else if (objProductOld.Param2_Unit == null && objProductNew.str_groupUnit == null) // no parameter added
                {
                    objGroup.Group.Unit.oldValue = false;
                    objGroup.Group.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strGraphOn == objProductNew.str_groupUnit) {
                        objGroup.Group.Unit.oldValue = false;
                        objGroup.Group.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group.Unit.oldValue = strGraphOn;
                        objGroup.Group.Unit.newValue = objProductNew.str_groupUnit;
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objGroup);
            }
            resolve(IsChanged);
        });
    }

    validateThickness(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objThickness = {
                Thickness: {
                    Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    T3Neg: { oldValue: "", newValue: "" },
                    T3Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    Unit:{ oldValue: "", newValue: "" }
                }
            };
            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Thickness Nom
             */
            if (OldEmpty) {
                if (objProductNew.flt_ThkStdCoat != "" && objProductNew.flt_ThkStdCoat != undefined) {
                    objThickness.Thickness.Nom.oldValue = "NA";
                    objThickness.Thickness.Nom.newValue = objProductNew.flt_ThkStdCoat;
                    IsChanged = true;
                } else {
                    objThickness.Thickness.Nom.oldValue = false;
                    objThickness.Thickness.Nom.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {
                if (objProductOld.Param3_Nom === "" || objProductOld.Param3_Nom == this.strNullValue || objProductOld.Param3_Nom == undefined) {
                    objProductOld.Param3_Nom = null;
                }

                if (objProductNew.flt_ThkStdCoat === "" || objProductNew.flt_ThkStdCoat == this.intNullValue || objProductNew.flt_ThkStdCoat == undefined) {
                    objProductNew.flt_ThkStdCoat = null;
                }

                if ((objProductOld.Param3_Nom !== null) && (objProductNew.flt_ThkStdCoat !== null)) {
                    if (parseFloat(objProductOld.Param3_Nom).toFixed(2) == parseFloat(objProductNew.flt_ThkStdCoat).toFixed(2)) {
                        objThickness.Thickness.Nom.oldValue = false;
                        objThickness.Thickness.Nom.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objThickness.Thickness.Nom.oldValue = parseFloat(objProductOld.Param3_Nom).toFixed(2);
                        objThickness.Thickness.Nom.newValue = objProductNew.flt_ThkStdCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_Nom === null) && (objProductNew.flt_ThkStdCoat !== null)) {
                        objThickness.Thickness.Nom.oldValue = "NA";
                        objThickness.Thickness.Nom.newValue = objProductNew.flt_ThkStdCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param3_Nom !== null) && (objProductNew.flt_ThkStdCoat === null)) {
                        objThickness.Thickness.Nom.oldValue = parseFloat(objProductOld.Param3_Nom).toFixed(2);
                        objThickness.Thickness.Nom.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Thickness NegT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_ThkT1NegCoat != "" && objProductNew.flt_ThkT1NegCoat != undefined) {
                    objThickness.Thickness.T1Neg.oldValue = "NA";
                    objThickness.Thickness.T1Neg.newValue = objProductNew.flt_ThkT1NegCoat;
                    IsChanged = true;
                } else {
                    objThickness.Thickness.T1Neg.oldValue = false;
                    objThickness.Thickness.T1Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {
                if (objProductOld.Param3_T1Neg === "" || objProductOld.Param3_T1Neg == this.strNullValue || objProductOld.Param3_T1Neg == undefined) {
                    objProductOld.Param3_T1Neg = null;
                }

                if (objProductNew.flt_ThkT1NegCoat === "" || objProductNew.flt_ThkT1NegCoat == this.intNullValue || objProductNew.flt_ThkT1NegCoat == undefined) {
                    objProductNew.flt_ThkT1NegCoat = null;
                }

                if ((objProductOld.Param3_T1Neg !== null) && (objProductNew.flt_ThkT1NegCoat !== null)) {
                    if (parseFloat(objProductOld.Param3_T1Neg).toFixed(2) == parseFloat(objProductNew.flt_ThkT1NegCoat).toFixed(2)) {
                        objThickness.Thickness.T1Neg.oldValue = false;
                        objThickness.Thickness.T1Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objThickness.Thickness.T1Neg.oldValue = parseFloat(objProductOld.Param3_T1Neg).toFixed(2);
                        objThickness.Thickness.T1Neg.newValue = objProductNew.flt_ThkT1NegCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_T1Neg === null) && (objProductNew.flt_ThkT1NegCoat !== null)) {
                        objThickness.Thickness.T1Neg.oldValue = "NA";
                        objThickness.Thickness.T1Neg.newValue = objProductNew.flt_ThkT1NegCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param3_T1Neg !== null) && (objProductNew.flt_ThkT1NegCoat === null)) {
                        objThickness.Thickness.T1Neg.oldValue = parseFloat(objProductOld.Param3_T1Neg).toFixed(2);
                        objThickness.Thickness.T1Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
                  * For Thickness PosT1
                  */
            if (OldEmpty) {
                if (objProductNew.flt_ThkT1PosCoat != "" && objProductNew.flt_ThkT1PosCoat != undefined) {
                    objThickness.Thickness.T1Pos.oldValue = "NA";
                    objThickness.Thickness.T1Pos.newValue = objProductNew.flt_ThkT1PosCoat;
                    IsChanged = true;
                } else {
                    objThickness.Thickness.T1Pos.oldValue = false;
                    objThickness.Thickness.T1Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {
                if (objProductOld.Param3_T1Pos === "" || objProductOld.Param3_T1Pos == this.strNullValue || objProductOld.Param3_T1Pos == undefined) {
                    objProductOld.Param3_T1Pos = null;
                }

                if (objProductNew.flt_ThkT1PosCoat === "" || objProductNew.flt_ThkT1PosCoat == this.strNullValue || objProductNew.flt_ThkT1PosCoat == undefined) {
                    objProductNew.flt_ThkT1PosCoat = null;
                }
                
                if ((objProductOld.Param3_T1Pos !== null) && (objProductNew.flt_ThkT1PosCoat !== null)) {
                    if (parseFloat(objProductOld.Param3_T1Pos).toFixed(2) == parseFloat(objProductNew.flt_ThkT1PosCoat).toFixed(2)) {
                        objThickness.Thickness.T1Pos.oldValue = false;
                        objThickness.Thickness.T1Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objThickness.Thickness.T1Pos.oldValue = parseFloat(objProductOld.Param3_T1Pos).toFixed(2);
                        objThickness.Thickness.T1Pos.newValue = objProductNew.flt_ThkT1PosCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_T1Pos === null) && (objProductNew.flt_ThkT1PosCoat !== null)) {
                        objThickness.Thickness.T1Pos.oldValue = "NA";
                        objThickness.Thickness.T1Pos.newValue = objProductNew.flt_ThkT1PosCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param3_T1Pos !== null) && (objProductNew.flt_ThkT1PosCoat === null)) {
                        objThickness.Thickness.T1Pos.oldValue = parseFloat(objProductOld.Param3_T1Pos).toFixed(2);
                        objThickness.Thickness.T1Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Thickness NegT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_ThkT2NegCoat != "" && objProductNew.flt_ThkT2NegCoat != undefined) {
                    objThickness.Thickness.T2Neg.oldValue = "NA";
                    objThickness.Thickness.T2Neg.newValue = objProductNew.flt_ThkT2NegCoat;
                    IsChanged = true;
                } else {
                    objThickness.Thickness.T2Neg.oldValue = false;
                    objThickness.Thickness.T2Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param3_T2Neg === "" || objProductOld.Param3_T2Neg == this.strNullValue || objProductOld.Param3_T2Neg == undefined) {
                    objProductOld.Param3_T2Neg = null;
                }

                if (objProductNew.flt_ThkT2NegCoat === "" || objProductNew.flt_ThkT2NegCoat == this.strNullValue || objProductNew.flt_ThkT2NegCoat == undefined) {
                    objProductNew.flt_ThkT2NegCoat = null;
                }

                if ((objProductOld.Param3_T2Neg !== null) && (objProductNew.flt_ThkT2NegCoat !== null)) {
                    if (parseFloat(objProductOld.Param3_T2Neg).toFixed(2) == parseFloat(objProductNew.flt_ThkT2NegCoat).toFixed(2)) {
                        objThickness.Thickness.T2Neg.oldValue = false;
                        objThickness.Thickness.T2Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objThickness.Thickness.T2Neg.oldValue = parseFloat(objProductOld.Param3_T2Neg).toFixed(2);
                        objThickness.Thickness.T2Neg.newValue = objProductNew.flt_ThkT2NegCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_T2Neg === null) && (objProductNew.flt_ThkT2NegCoat !== null)) {
                        objThickness.Thickness.T2Neg.oldValue = "NA";
                        objThickness.Thickness.T2Neg.newValue = objProductNew.flt_ThkT2NegCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param3_T2Neg !== null) && (objProductNew.flt_ThkT2NegCoat === null)) {
                        objThickness.Thickness.T2Neg.oldValue = parseFloat(objProductOld.Param3_T2Neg).toFixed(2);
                        objThickness.Thickness.T2Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Thickness PosT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_ThkT2PosCoat != "" && objProductNew.flt_ThkT2PosCoat != undefined) {
                    objThickness.Thickness.T2Pos.oldValue = "NA";
                    objThickness.Thickness.T2Pos.newValue = objProductNew.flt_ThkT2PosCoat;
                    IsChanged = true;
                } else {
                    objThickness.Thickness.T2Pos.oldValue = false;
                    objThickness.Thickness.T2Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {
                if (objProductOld.Param3_T2Pos === "" || objProductOld.Param3_T2Pos == this.strNullValue || objProductOld.Param3_T2Pos == undefined) {
                    objProductOld.Param3_T2Pos = null;
                }

                if (objProductNew.flt_ThkT2PosCoat === "" || objProductNew.flt_ThkT2PosCoat == this.strNullValue || objProductNew.flt_ThkT2PosCoat == undefined) {
                    objProductNew.flt_ThkT2PosCoat = null;
                }

                if ((objProductOld.Param3_T2Pos !== null) && (objProductNew.flt_ThkT2PosCoat !== null)) {
                    if (parseFloat(objProductOld.Param3_T2Pos).toFixed(2) == parseFloat(objProductNew.flt_ThkT2PosCoat).toFixed(2)) {
                        objThickness.Thickness.T2Pos.oldValue = false;
                        objThickness.Thickness.T2Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objThickness.Thickness.T2Pos.oldValue = parseFloat(objProductOld.Param3_T2Pos).toFixed(2);
                        objThickness.Thickness.T2Pos.newValue = objProductNew.flt_ThkT2PosCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_T2Pos === null) && (objProductNew.flt_ThkT2PosCoat !== null)) {
                        objThickness.Thickness.T2Pos.oldValue = "NA";
                        objThickness.Thickness.T2Pos.newValue = objProductNew.flt_ThkT2PosCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param3_T2Pos !== null) && (objProductNew.flt_ThkT2PosCoat === null)) {
                        objThickness.Thickness.T2Pos.oldValue = parseFloat(objProductOld.Param3_T2Pos).toFixed(2);
                        objThickness.Thickness.T2Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Thickness NegT3
            */
            if (OldEmpty) {
                if (objProductNew.flt_ThkT3NegCoat != "" && objProductNew.flt_ThkT3NegCoat != undefined) {
                    objThickness.Thickness.T3Neg.oldValue = "NA";
                    objThickness.Thickness.T3Neg.newValue = objProductNew.flt_ThkT3NegCoat;
                    IsChanged = true;
                } else {
                    objThickness.Thickness.T3Neg.oldValue = false;
                    objThickness.Thickness.T3Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param3_T3Neg === "" || objProductOld.Param3_T3Neg == this.strNullValue || objProductOld.Param3_T3Neg == undefined) {
                    objProductOld.Param3_T3Neg = null;
                }

                if (objProductNew.flt_ThkT3NegCoat === "" || objProductNew.flt_ThkT3NegCoat == this.strNullValue || objProductNew.flt_ThkT3NegCoat == undefined) {
                    objProductNew.flt_ThkT3NegCoat = null;
                }

                if ((objProductOld.Param3_T3Neg !== null) && (objProductNew.flt_ThkT3NegCoat !== null)) {
                    if (parseFloat(objProductOld.Param3_T3Neg).toFixed(2) == parseFloat(objProductNew.flt_ThkT3NegCoat).toFixed(2)) {
                        objThickness.Thickness.T3Neg.oldValue = false;
                        objThickness.Thickness.T3Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objThickness.Thickness.T3Neg.oldValue = parseFloat(objProductOld.Param3_T3Neg).toFixed(2);
                        objThickness.Thickness.T3Neg.newValue = objProductNew.flt_ThkT3NegCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_T3Neg === null) && (objProductNew.flt_ThkT3NegCoat !== null)) {
                        objThickness.Thickness.T3Neg.oldValue = "NA";
                        objThickness.Thickness.T3Neg.newValue = objProductNew.flt_ThkT3NegCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param3_T3Neg !== null) && (objProductNew.flt_ThkT3NegCoat === null)) {
                        objThickness.Thickness.T3Neg.oldValue = parseFloat(objProductOld.Param3_T3Neg).toFixed(2);
                        objThickness.Thickness.T3Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Thickness PosT3
            */
            if (OldEmpty) {
                if (objProductNew.flt_ThkT3PosCoat != "" && objProductNew.flt_ThkT3PosCoat != undefined) {
                    objThickness.Thickness.T3Pos.oldValue = "NA";
                    objThickness.Thickness.T3Pos.newValue = objProductNew.flt_ThkT3PosCoat;
                    IsChanged = true;
                } else {
                    objThickness.Thickness.T3Pos.oldValue = false;
                    objThickness.Thickness.T3Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {
                if (objProductOld.Param3_T3Pos === "" || objProductOld.Param3_T3Pos == this.strNullValue || objProductOld.Param3_T3Pos == undefined) {
                    objProductOld.Param3_T3Pos = null;
                }

                if (objProductNew.flt_ThkT3PosCoat === "" || objProductNew.flt_ThkT3PosCoat == this.strNullValue || objProductNew.flt_ThkT3PosCoat == undefined) {
                    objProductNew.flt_ThkT3PosCoat = null;
                }

                if ((objProductOld.Param3_T3Pos !== null) && (objProductNew.flt_ThkT3PosCoat !== null)) {
                    if (parseFloat(objProductOld.Param3_T3Pos).toFixed(2) == parseFloat(objProductNew.flt_ThkT3PosCoat).toFixed(2)) {
                        objThickness.Thickness.T3Pos.oldValue = false;
                        objThickness.Thickness.T3Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objThickness.Thickness.T3Pos.oldValue = parseFloat(objProductOld.Param3_T3Pos).toFixed(2);
                        objThickness.Thickness.T3Pos.newValue = objProductNew.flt_ThkT3PosCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_T3Pos === null) && (objProductNew.flt_ThkT3PosCoat !== null)) {
                        objThickness.Thickness.T3Pos.oldValue = "NA";
                        objThickness.Thickness.T3Pos.newValue = objProductNew.flt_ThkT3PosCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param3_T3Pos !== null) && (objProductNew.flt_ThkT3PosCoat === null)) {
                        objThickness.Thickness.T3Pos.oldValue = parseFloat(objProductOld.Param3_T3Pos).toFixed(2);
                        objThickness.Thickness.T3Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            // /**
            // * For Thickness NMT
            // */
            if (OldEmpty) {
                if (objProductNew.int_ThkNMTTabCntCoat != "") {
                    objThickness.Thickness.NMT.oldValue = "NA";
                    objThickness.Thickness.NMT.newValue = objProductNew.int_ThkNMTTabCntCoat;
                    IsChanged = true;
                } else {
                    objThickness.Thickness.NMT.oldValue = false;
                    objThickness.Thickness.NMT.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param3_NMTTab === 0 ||
                    objProductOld.Param3_NMTTab == this.intNullValue ||
                    objProductOld.Param3_NMTTab == undefined) {
                    objProductOld.Param3_NMTTab = null;
                }

                objProductNew.int_ThkNMTTabCntCoat = objProductNew.int_ThkNMTTabCntCoat === "" ? this.strNullValue : objProductNew.int_ThkNMTTabCntCoat;

                if (objProductNew.int_ThkNMTTabCntCoat == "0" ||
                    objProductNew.int_ThkNMTTabCntCoat == this.intNullValue ||
                    objProductNew.int_ThkNMTTabCntCoat == undefined) {
                    objProductNew.int_ThkNMTTabCntCoat = null;
                }

                if (objProductOld.Param3_NMTTab == objProductNew.int_ThkNMTTabCntCoat) {
                    objThickness.Thickness.NMT.oldValue = false;
                    objThickness.Thickness.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }
                else {
                    objThickness.Thickness.NMT.oldValue = objProductOld.Param3_NMTTab;
                    objThickness.Thickness.NMT.newValue = objProductNew.int_ThkNMTTabCntCoat;
                    IsChanged = true;
                }
            }

            if (OldEmpty) {
                if (objProductNew.str_verUnit != "" && objProductNew.flt_ThkStdCoat != "" && objProductNew.str_verUnit != undefined && objProductNew.flt_ThkStdCoat != undefined) {
                    objThickness.Thickness.Unit.oldValue = "NA";
                    objThickness.Thickness.Unit.newValue = objProductNew.str_verUnit;
                    IsChanged = true;
                }
                else {
                    objThickness.Thickness.Unit.oldValue = false;
                    objThickness.Thickness.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param3_Unit == "NA" ? objProductOld.Param3_Unit = "mm" : objProductOld.Param3_Unit;
                if (objProductOld.Param3_Nom == null && objProductNew.flt_ThkStdCoat != null) { // new parameter added
                    objThickness.Thickness.Unit.oldValue = "mm";
                    objThickness.Thickness.Unit.newValue = objProductNew.str_verUnit;
                    IsChanged = true;
                }
                else if (objProductOld.Param3_Unit == null && objProductNew.str_verUnit == null) // no parameter added
                {
                    objThickness.Thickness.Unit.oldValue = false;
                    objThickness.Thickness.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param3_Unit == objProductNew.str_verUnit) {
                        objThickness.Thickness.Unit.oldValue = false;
                        objThickness.Thickness.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objThickness.Thickness.Unit.oldValue = objProductOld.Param3_Unit;
                        objThickness.Thickness.Unit.newValue = objProductNew.str_verUnit;
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objThickness);
            }
            resolve(IsChanged);
        });
    }

    validateBreadth(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objBreadth = {
                Breadth: {
                    Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    Unit:{ oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Breadth Nom
             */
            if (OldEmpty) {
                if (objProductNew.flt_BrdStdCoat != "" && objProductNew.flt_BrdStdCoat != undefined) {
                    objBreadth.Breadth.Nom.oldValue = "NA";
                    objBreadth.Breadth.Nom.newValue = objProductNew.flt_BrdStdCoat;
                    IsChanged = true;
                } else {
                    objBreadth.Breadth.Nom.oldValue = false;
                    objBreadth.Breadth.Nom.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {
                if (objProductOld.Param4_Nom === "" || objProductOld.Param4_Nom == this.strNullValue || objProductOld.Param4_Nom == undefined) {
                    objProductOld.Param4_Nom = null;
                }

                if (objProductNew.flt_BrdStdCoat === "" || objProductNew.flt_BrdStdCoat == this.strNullValue || objProductNew.flt_BrdStdCoat == undefined) {
                    objProductNew.flt_BrdStdCoat = null;
                }

                if ((objProductOld.Param4_Nom !== null) && (objProductNew.flt_BrdStdCoat !== null)) {
                    if (parseFloat(objProductOld.Param4_Nom).toFixed(2) == parseFloat(objProductNew.flt_BrdStdCoat).toFixed(2)) {
                        objBreadth.Breadth.Nom.oldValue = false;
                        objBreadth.Breadth.Nom.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objBreadth.Breadth.Nom.oldValue = parseFloat(objProductOld.Param4_Nom).toFixed(2);
                        objBreadth.Breadth.Nom.newValue = objProductNew.flt_BrdStdCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param4_Nom === null) && (objProductNew.flt_BrdStdCoat !== null)) {
                        objBreadth.Breadth.Nom.oldValue = "NA";
                        objBreadth.Breadth.Nom.newValue = objProductNew.flt_BrdStdCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param4_Nom !== null) && (objProductNew.flt_BrdStdCoat === null)) {
                        objBreadth.Breadth.Nom.oldValue = parseFloat(objProductOld.Param4_Nom).toFixed(2);
                        objBreadth.Breadth.Nom.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Breadth NegT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_BrdT1NegCoat != "" && objProductNew.flt_BrdT1NegCoat != undefined) {
                    objBreadth.Breadth.T1Neg.oldValue = "NA";
                    objBreadth.Breadth.T1Neg.newValue = objProductNew.flt_BrdT1NegCoat;
                    IsChanged = true;
                } else {
                    objBreadth.Breadth.T1Neg.oldValue = false;
                    objBreadth.Breadth.T1Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param4_T1Neg === "" || objProductOld.Param4_T1Neg == this.strNullValue || objProductOld.Param4_T1Neg == undefined) {
                    objProductOld.Param4_T1Neg = null;
                }

                if (objProductNew.flt_BrdT1NegCoat === "" || objProductNew.flt_BrdT1NegCoat == this.strNullValue || objProductNew.flt_BrdT1NegCoat == undefined) {
                    objProductNew.flt_BrdT1NegCoat = null;
                }

                if ((objProductOld.Param4_T1Neg !== null) && (objProductNew.flt_BrdT1NegCoat !== null)) {
                    if (parseFloat(objProductOld.Param4_T1Neg).toFixed(2) == parseFloat(objProductNew.flt_BrdT1NegCoat).toFixed(2)) {
                        objBreadth.Breadth.T1Neg.oldValue = false;
                        objBreadth.Breadth.T1Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objBreadth.Breadth.T1Neg.oldValue = parseFloat(objProductOld.Param4_T1Neg).toFixed(2);
                        objBreadth.Breadth.T1Neg.newValue = objProductNew.flt_BrdT1NegCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param4_T1Neg === null) && (objProductNew.flt_BrdT1NegCoat !== null)) {
                        objBreadth.Breadth.T1Neg.oldValue = "NA";
                        objBreadth.Breadth.T1Neg.newValue = objProductNew.flt_BrdT1NegCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param4_T1Neg !== null) && (objProductNew.flt_BrdT1NegCoat === null)) {
                        objBreadth.Breadth.T1Neg.oldValue = parseFloat(objProductOld.Param4_T1Neg).toFixed(2);
                        objBreadth.Breadth.T1Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Breadth PosT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_BrdT1PosCoat != "" && objProductNew.flt_BrdT1PosCoat != undefined) {
                    objBreadth.Breadth.T1Pos.oldValue = "NA";
                    objBreadth.Breadth.T1Pos.newValue = objProductNew.flt_BrdT1PosCoat;
                    IsChanged = true;
                } else {
                    objBreadth.Breadth.T1Pos.oldValue = false;
                    objBreadth.Breadth.T1Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {
                if (objProductOld.Param4_T1Pos === "" || objProductOld.Param4_T1Pos == this.strNullValue || objProductOld.Param4_T1Pos == undefined) {
                    objProductOld.Param4_T1Pos = null;
                }

                if (objProductNew.flt_BrdT1PosCoat === "" || objProductNew.flt_BrdT1PosCoat == this.strNullValue || objProductNew.flt_BrdT1PosCoat == undefined) {
                    objProductNew.flt_BrdT1PosCoat = null;
                }

                if ((objProductOld.Param4_T1Pos !== null) && (objProductNew.flt_BrdT1PosCoat !== null)) {
                    if (parseFloat(objProductOld.Param4_T1Pos).toFixed(2) == parseFloat(objProductNew.flt_BrdT1PosCoat).toFixed(2)) {
                        objBreadth.Breadth.T1Pos.oldValue = false;
                        objBreadth.Breadth.T1Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objBreadth.Breadth.T1Pos.oldValue = parseFloat(objProductOld.Param4_T1Pos).toFixed(2);
                        objBreadth.Breadth.T1Pos.newValue = objProductNew.flt_BrdT1PosCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param4_T1Pos === null) && (objProductNew.flt_BrdT1PosCoat !== null)) {
                        objBreadth.Breadth.T1Pos.oldValue = "NA";
                        objBreadth.Breadth.T1Pos.newValue = objProductNew.flt_BrdT1PosCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param4_T1Pos !== null) && (objProductNew.flt_BrdT1PosCoat === null)) {
                        objBreadth.Breadth.T1Pos.oldValue = parseFloat(objProductOld.Param4_T1Pos).toFixed(2);
                        objBreadth.Breadth.T1Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Breadth NegT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_BrdT2NegCoat != "" && objProductNew.flt_BrdT2NegCoat != undefined) {
                    objBreadth.Breadth.T2Neg.oldValue = "NA";
                    objBreadth.Breadth.T2Neg.newValue = objProductNew.flt_BrdT2NegCoat;
                    IsChanged = true;
                } else {
                    objBreadth.Breadth.T2Neg.oldValue = false;
                    objBreadth.Breadth.T2Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {
                if (objProductOld.Param4_T2Neg === "" || objProductOld.Param4_T2Neg == this.strNullValue || objProductOld.Param4_T2Neg == undefined) {
                    objProductOld.Param4_T2Neg = null;
                }

                if (objProductNew.flt_BrdT2NegCoat === "" || objProductNew.flt_BrdT2NegCoat == this.strNullValue || objProductNew.flt_BrdT2NegCoat == undefined) {
                    objProductNew.flt_BrdT2NegCoat = null;
                }

                if ((objProductOld.Param4_T2Neg !== null) && (objProductNew.flt_BrdT2NegCoat !== null)) {
                    if (parseFloat(objProductOld.Param4_T2Neg).toFixed(2) == parseFloat(objProductNew.flt_BrdT2NegCoat).toFixed(2)) {
                        objBreadth.Breadth.T2Neg.oldValue = false;
                        objBreadth.Breadth.T2Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objBreadth.Breadth.T2Neg.oldValue = parseFloat(objProductOld.Param4_T2Neg).toFixed(2);
                        objBreadth.Breadth.T2Neg.newValue = objProductNew.flt_BrdT2NegCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param4_T2Neg === null) && (objProductNew.flt_BrdT2NegCoat !== null)) {
                        objBreadth.Breadth.T2Neg.oldValue = "NA";
                        objBreadth.Breadth.T2Neg.newValue = objProductNew.flt_BrdT2NegCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param4_T2Neg !== null) && (objProductNew.flt_BrdT2NegCoat === null)) {
                        objBreadth.Breadth.T2Neg.oldValue = parseFloat(objProductOld.Param4_T2Neg).toFixed(2);
                        objBreadth.Breadth.T2Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Breadth PosT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_BrdT2PosCoat != "" && objProductNew.flt_BrdT2PosCoat != undefined) {
                    objBreadth.Breadth.T2Pos.oldValue = "NA";
                    objBreadth.Breadth.T2Pos.newValue = objProductNew.flt_BrdT2PosCoat;
                    IsChanged = true;
                } else {
                    objBreadth.Breadth.T2Pos.oldValue = false;
                    objBreadth.Breadth.T2Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param4_T2Pos === "" || objProductOld.Param4_T2Pos == this.strNullValue || objProductOld.Param4_T2Pos == undefined) {
                    objProductOld.Param4_T2Pos = null;
                }

                if (objProductNew.flt_BrdT2PosCoat === "" || objProductNew.flt_BrdT2PosCoat == this.strNullValue || objProductNew.flt_BrdT2PosCoat == undefined) {
                    objProductNew.flt_BrdT2PosCoat = null;
                }

                if ((objProductOld.Param4_T2Pos !== null) && (objProductNew.flt_BrdT2PosCoat !== null)) {
                    if (parseFloat(objProductOld.Param4_T2Pos).toFixed(2) == parseFloat(objProductNew.flt_BrdT2PosCoat).toFixed(2)) {
                        objBreadth.Breadth.T2Pos.oldValue = false;
                        objBreadth.Breadth.T2Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objBreadth.Breadth.T2Pos.oldValue = objProductOld.Param4_T2Pos;
                        objBreadth.Breadth.T2Pos.newValue = objProductNew.flt_BrdT2PosCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param4_T2Pos === null) && (objProductNew.flt_BrdT2PosCoat !== null)) {
                        objBreadth.Breadth.T2Pos.oldValue = "NA";
                        objBreadth.Breadth.T2Pos.newValue = objProductNew.flt_BrdT2PosCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param4_T2Pos !== null) && (objProductNew.flt_BrdT2PosCoat === null)) {
                        objBreadth.Breadth.T2Pos.oldValue = objProductOld.Param4_T2Pos;
                        objBreadth.Breadth.T2Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Breadth NMT
            */
            if (OldEmpty) {
                if (objProductNew.int_BrdNMTTabCntCoat != "" && objProductNew.int_BrdNMTTabCntCoat != undefined) {
                    objBreadth.Breadth.NMT.oldValue = "NA";
                    objBreadth.Breadth.NMT.newValue = objProductNew.int_BrdNMTTabCntCoat;
                    IsChanged = true;
                } else {
                    objBreadth.Breadth.NMT.oldValue = false;
                    objBreadth.Breadth.NMT.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param4_NMTTab == 0 ||
                    objProductOld.Param4_NMTTab == this.intNullValue ||
                    objProductOld.Param4_NMTTab == undefined) {
                    objProductOld.Param4_NMTTab = null;
                }

                objProductNew.int_BrdNMTTabCntCoat = objProductNew.int_BrdNMTTabCntCoat === "" ? this.strNullValue : objProductNew.int_BrdNMTTabCntCoat;
                
                if (objProductNew.int_BrdNMTTabCntCoat == "0" || objProductNew.int_BrdNMTTabCntCoat == this.intNullValue || objProductNew.int_BrdNMTTabCntCoat == undefined) {
                    objProductNew.int_BrdNMTTabCntCoat = null;
                }

                if (objProductOld.Param4_NMTTab == objProductNew.int_BrdNMTTabCntCoat) {
                    objBreadth.Breadth.NMT.oldValue = false;
                    objBreadth.Breadth.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }
                else {
                    objBreadth.Breadth.NMT.oldValue = objProductOld.Param4_NMTTab;
                    objBreadth.Breadth.NMT.newValue = objProductNew.int_BrdNMTTabCntCoat;
                    IsChanged = true;
                }
            }

            if (OldEmpty) {
                if (objProductNew.str_verUnit != "" && objProductNew.flt_BrdStdCoat != "" && objProductNew.str_verUnit != undefined && objProductNew.flt_BrdStdCoat != undefined) {
                    objBreadth.Breadth.Unit.oldValue = "NA";
                    objBreadth.Breadth.Unit.newValue = objProductNew.str_verUnit;
                    IsChanged = true;
                }
                else {
                    objBreadth.Breadth.Unit.oldValue = false;
                    objBreadth.Breadth.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param4_Unit == "NA" ? objProductOld.Param4_Unit = "mm" : objProductOld.Param4_Unit;
                if (objProductOld.Param4_Nom == null && objProductNew.flt_BrdStdCoat != null) { // new parameter added
                    objBreadth.Breadth.Unit.oldValue = "mm";
                    objBreadth.Breadth.Unit.newValue = objProductNew.str_verUnit;
                    IsChanged = true;
                }
                else if (objProductOld.Param4_Unit == null && objProductNew.str_verUnit == null) // no parameter added
                {
                    objBreadth.Breadth.Unit.oldValue = false;
                    objBreadth.Breadth.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param4_Unit == objProductNew.str_verUnit) {
                        objBreadth.Breadth.Unit.oldValue = false;
                        objBreadth.Breadth.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objBreadth.Breadth.Unit.oldValue = objProductOld.Param4_Unit;
                        objBreadth.Breadth.Unit.newValue = objProductNew.str_verUnit;
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objBreadth);
            }
            resolve(IsChanged);
        });
    }

    validateLength(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objLength = {
                Length: {
                    Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    T3Neg: { oldValue: "", newValue: "" },
                    T3Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    Unit:{ oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Length Nom
             */
            if (OldEmpty) {
                if (objProductNew.flt_LenStdCoat != "" && objProductNew.flt_LenStdCoat != undefined) {
                    objLength.Length.Nom.oldValue = "NA";
                    objLength.Length.Nom.newValue = objProductNew.flt_LenStdCoat;
                    IsChanged = true;
                } else {
                    objLength.Length.Nom.oldValue = false;
                    objLength.Length.Nom.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param5_Nom === "" || objProductOld.Param5_Nom == this.strNullValue || objProductOld.Param5_Nom == undefined) {
                    objProductOld.Param5_Nom = null;
                }

                if (objProductNew.flt_LenStdCoat === "" || objProductNew.flt_LenStdCoat == this.strNullValue || objProductNew.flt_LenStdCoat == undefined) {
                    objProductNew.flt_LenStdCoat = null;
                }

                if ((objProductOld.Param5_Nom !== null) && (objProductNew.flt_LenStdCoat !== null)) {
                    if (parseFloat(objProductOld.Param5_Nom).toFixed(2) == parseFloat(objProductNew.flt_LenStdCoat).toFixed(2)) {
                        objLength.Length.Nom.oldValue = false;
                        objLength.Length.Nom.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objLength.Length.Nom.oldValue = parseFloat(objProductOld.Param5_Nom).toFixed(2);
                        objLength.Length.Nom.newValue = objProductNew.flt_LenStdCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param5_Nom === null) && (objProductNew.flt_LenStdCoat !== null)) {
                        objLength.Length.Nom.oldValue = "NA";
                        objLength.Length.Nom.newValue = objProductNew.flt_LenStdCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param5_Nom !== null) && (objProductNew.flt_LenStdCoat === null)) {
                        objLength.Length.Nom.oldValue = parseFloat(objProductOld.Param5_Nom).toFixed(2);
                        objLength.Length.Nom.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Length NegT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_LenT1NegCoat != "" && objProductNew.flt_LenT1NegCoat != undefined) {
                    objLength.Length.T1Neg.oldValue = "NA";
                    objLength.Length.T1Neg.newValue = objProductNew.flt_LenT1NegCoat;
                    IsChanged = true;
                } else {
                    objLength.Length.T1Neg.oldValue = false;
                    objLength.Length.T1Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param5_T1Neg === "" || objProductOld.Param5_T1Neg == this.strNullValue || objProductOld.Param5_T1Neg == undefined) {
                    objProductOld.Param5_T1Neg = null;
                }

                if (objProductNew.flt_LenT1NegCoat === "" || objProductNew.flt_LenT1NegCoat == this.strNullValue || objProductNew.flt_LenT1NegCoat == undefined) {
                    objProductNew.flt_LenT1NegCoat = null;
                }

                if ((objProductOld.Param5_T1Neg !== null) && (objProductNew.flt_LenT1NegCoat !== null)) {
                    if (parseFloat(objProductOld.Param5_T1Neg).toFixed(2) == parseFloat(objProductNew.flt_LenT1NegCoat).toFixed(2)) {
                        objLength.Length.T1Neg.oldValue = false;
                        objLength.Length.T1Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objLength.Length.T1Neg.oldValue = parseFloat(objProductOld.Param5_T1Neg).toFixed(2);
                        objLength.Length.T1Neg.newValue = objProductNew.flt_LenT1NegCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param5_T1Neg === null) && (objProductNew.flt_LenT1NegCoat !== null)) {
                        objLength.Length.T1Neg.oldValue = "NA";
                        objLength.Length.T1Neg.newValue = objProductNew.flt_LenT1NegCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param5_T1Neg !== null) && (objProductNew.flt_LenT1NegCoat === null)) {
                        objLength.Length.T1Neg.oldValue = parseFloat(objProductOld.Param5_T1Neg).toFixed(2);
                        objLength.Length.T1Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Length PosT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_LenT1PosCoat != "" && objProductNew.flt_LenT1PosCoat != undefined) {
                    objLength.Length.T1Pos.oldValue = "NA";
                    objLength.Length.T1Pos.newValue = objProductNew.flt_LenT1PosCoat;
                    IsChanged = true;
                } else {
                    objLength.Length.T1Pos.oldValue = false;
                    objLength.Length.T1Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {
                if (objProductOld.Param5_T1Pos === "" || objProductOld.Param5_T1Pos == this.strNullValue || objProductOld.Param5_T1Pos == undefined) {
                    objProductOld.Param5_T1Pos = null;
                }

                if (objProductNew.flt_LenT1PosCoat === "" || objProductNew.flt_LenT1PosCoat == this.strNullValue || objProductNew.flt_LenT1PosCoat == undefined) {
                    objProductNew.flt_LenT1PosCoat = null;
                }

                if ((objProductOld.Param5_T1Pos !== null) && (objProductNew.flt_LenT1PosCoat !== null)) {
                    if (parseFloat(objProductOld.Param5_T1Pos).toFixed(2) == parseFloat(objProductNew.flt_LenT1PosCoat).toFixed(2)) {
                        objLength.Length.T1Pos.oldValue = false;
                        objLength.Length.T1Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objLength.Length.T1Pos.oldValue = parseFloat(objProductOld.Param5_T1Pos).toFixed(2);
                        objLength.Length.T1Pos.newValue = objProductNew.flt_LenT1PosCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param5_T1Pos === null) && (objProductNew.flt_LenT1PosCoat !== null)) {
                        objLength.Length.T1Pos.oldValue = "NA";
                        objLength.Length.T1Pos.newValue = objProductNew.flt_LenT1PosCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param5_T1Pos !== null) && (objProductNew.flt_LenT1PosCoat === null)) {
                        objLength.Length.T1Pos.oldValue = parseFloat(objProductOld.Param5_T1Pos).toFixed(2);
                        objLength.Length.T1Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Length NegT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_LenT2NegCoat != "" && objProductNew.flt_LenT2NegCoat != undefined) {
                    objLength.Length.T2Neg.oldValue = "NA";
                    objLength.Length.T2Neg.newValue = objProductNew.flt_LenT2NegCoat;
                    IsChanged = true;
                } else {
                    objLength.Length.T2Neg.oldValue = false;
                    objLength.Length.T2Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param5_T2Neg === "" || objProductOld.Param5_T2Neg == this.strNullValue || objProductOld.Param5_T2Neg == undefined) {
                    objProductOld.Param5_T2Neg = null;
                }

                if (objProductNew.flt_LenT2NegCoat === "" || objProductNew.flt_LenT2NegCoat == this.strNullValue || objProductNew.flt_LenT2NegCoat == undefined) {
                    objProductNew.flt_LenT2NegCoat = null;
                }

                if ((objProductOld.Param5_T2Neg !== null) && (objProductNew.flt_LenT2NegCoat !== null)) {
                    if (parseFloat(objProductOld.Param5_T2Neg).toFixed(2) == parseFloat(objProductNew.flt_LenT2NegCoat).toFixed(2)) {
                        objLength.Length.T2Neg.oldValue = false;
                        objLength.Length.T2Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objLength.Length.T2Neg.oldValue = parseFloat(objProductOld.Param5_T2Neg).toFixed(2);
                        objLength.Length.T2Neg.newValue = objProductNew.flt_LenT2NegCoat;
                        IsChanged = true;
                    }
                    
                } else {

                    if ((objProductOld.Param5_T2Neg === null) && (objProductNew.flt_LenT2NegCoat !== null)) {
                        objLength.Length.T2Neg.oldValue = "NA";
                        objLength.Length.T2Neg.newValue = objProductNew.flt_LenT2NegCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param5_T2Neg !== null) && (objProductNew.flt_LenT2NegCoat === null)) {
                        objLength.Length.T2Neg.oldValue = parseFloat(objProductOld.Param5_T2Neg).toFixed(2);
                        objLength.Length.T2Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Length PosT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_LenT2PosCoat != "" && objProductNew.flt_LenT2PosCoat != undefined) {
                    objLength.Length.T2Pos.oldValue = "NA";
                    objLength.Length.T2Pos.newValue = objProductNew.flt_LenT2PosCoat;
                    IsChanged = true;
                } else {
                    objLength.Length.T2Pos.oldValue = false;
                    objLength.Length.T2Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param5_T2Pos === "" || objProductOld.Param5_T2Pos == this.strNullValue || objProductOld.Param5_T2Pos == undefined) {
                    objProductOld.Param5_T2Pos = null;
                }

                if (objProductNew.flt_LenT2PosCoat === "" || objProductNew.flt_LenT2PosCoat == this.strNullValue || objProductNew.flt_LenT2PosCoat == undefined) {
                    objProductNew.flt_LenT2PosCoat = null;
                }

                if ((objProductOld.Param5_T2Pos !== null) && (objProductNew.flt_LenT2PosCoat !== null)) {
                    if (parseFloat(objProductOld.Param5_T2Pos).toFixed(2) == parseFloat(objProductNew.flt_LenT2PosCoat).toFixed(2)) {
                        objLength.Length.T2Pos.oldValue = false;
                        objLength.Length.T2Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objLength.Length.T2Pos.oldValue = parseFloat(objProductOld.Param5_T2Pos).toFixed(2);
                        objLength.Length.T2Pos.newValue = objProductNew.flt_LenT2PosCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param5_T2Pos === null) && (objProductNew.flt_LenT2PosCoat !== null)) {
                        objLength.Length.T2Pos.oldValue = "NA";
                        objLength.Length.T2Pos.newValue = objProductNew.flt_LenT2PosCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param5_T2Pos !== null) && (objProductNew.flt_LenT2PosCoat === null)) {
                        objLength.Length.T2Pos.oldValue = parseFloat(objProductOld.Param5_T2Pos).toFixed(2);
                        objLength.Length.T2Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Length NegT3
            */
            if (OldEmpty) {
                if (objProductNew.flt_LenT3NegCoat != "" && objProductNew.flt_LenT3NegCoat != undefined) {
                    objLength.Length.T3Neg.oldValue = "NA";
                    objLength.Length.T3Neg.newValue = objProductNew.flt_LenT3NegCoat;
                    IsChanged = true;
                } else {
                    objLength.Length.T3Neg.oldValue = false;
                    objLength.Length.T3Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param5_T3Neg === "" || objProductOld.Param5_T3Neg == this.strNullValue || objProductOld.Param5_T3Neg == undefined) {
                    objProductOld.Param5_T3Neg = null;
                }

                if (objProductNew.flt_LenT3NegCoat === "" || objProductNew.flt_LenT3NegCoat == this.strNullValue || objProductNew.flt_LenT3NegCoat == undefined) {
                    objProductNew.flt_LenT3NegCoat = null;
                }

                if ((objProductOld.Param5_T3Neg !== null) && (objProductNew.flt_LenT3NegCoat !== null)) {
                    if (parseFloat(objProductOld.Param5_T3Neg).toFixed(2) == parseFloat(objProductNew.flt_LenT3NegCoat).toFixed(2)) {
                        objLength.Length.T3Neg.oldValue = false;
                        objLength.Length.T3Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objLength.Length.T3Neg.oldValue = parseFloat(objProductOld.Param5_T3Neg).toFixed(2);
                        objLength.Length.T3Neg.newValue = objProductNew.flt_LenT3NegCoat;
                        IsChanged = true;
                    }
                    
                } else {

                    if ((objProductOld.Param5_T3Neg === null) && (objProductNew.flt_LenT3NegCoat !== null)) {
                        objLength.Length.T3Neg.oldValue = "NA";
                        objLength.Length.T3Neg.newValue = objProductNew.flt_LenT3NegCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param5_T3Neg !== null) && (objProductNew.flt_LenT3NegCoat === null)) {
                        objLength.Length.T3Neg.oldValue = parseFloat(objProductOld.Param5_T3Neg).toFixed(2);
                        objLength.Length.T3Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Length PosT3
            */
            if (OldEmpty) {
                if (objProductNew.flt_LenT3PosCoat != "" && objProductNew.flt_LenT3PosCoat != undefined) {
                    objLength.Length.T3Pos.oldValue = "NA";
                    objLength.Length.T3Pos.newValue = objProductNew.flt_LenT3PosCoat;
                    IsChanged = true;
                } else {
                    objLength.Length.T3Pos.oldValue = false;
                    objLength.Length.T3Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param5_T3Pos === "" || objProductOld.Param5_T3Pos == this.strNullValue || objProductOld.Param5_T3Pos == undefined) {
                    objProductOld.Param5_T3Pos = null;
                }

                if (objProductNew.flt_LenT3PosCoat === "" || objProductNew.flt_LenT3PosCoat == this.strNullValue || objProductNew.flt_LenT3PosCoat == undefined) {
                    objProductNew.flt_LenT3PosCoat = null;
                }

                if ((objProductOld.Param5_T3Pos !== null) && (objProductNew.flt_LenT3PosCoat !== null)) {
                    if (parseFloat(objProductOld.Param5_T3Pos).toFixed(2) == parseFloat(objProductNew.flt_LenT3PosCoat).toFixed(2)) {
                        objLength.Length.T3Pos.oldValue = false;
                        objLength.Length.T3Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objLength.Length.T3Pos.oldValue = parseFloat(objProductOld.Param5_T3Pos).toFixed(2);
                        objLength.Length.T3Pos.newValue = objProductNew.flt_LenT3PosCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param5_T3Pos === null) && (objProductNew.flt_LenT3PosCoat !== null)) {
                        objLength.Length.T3Pos.oldValue = "NA";
                        objLength.Length.T3Pos.newValue = objProductNew.flt_LenT3PosCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param5_T3Pos !== null) && (objProductNew.flt_LenT3PosCoat === null)) {
                        objLength.Length.T3Pos.oldValue = parseFloat(objProductOld.Param5_T3Pos).toFixed(2);
                        objLength.Length.T3Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            // /**
            //     * For Length NMT
            //     */
            if (OldEmpty) {
                if (objProductNew.int_LenNMTTabCntCoat != "") {
                    objLength.Length.NMT.oldValue = "NA";
                    objLength.Length.NMT.newValue = objProductNew.int_LenNMTTabCntCoat;
                    IsChanged = true;
                } else {
                    objLength.Length.NMT.oldValue = false;
                    objLength.Length.NMT.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param5_NMTTab == 0 ||
                    objProductOld.Param5_NMTTab == this.intNullValue ||
                    objProductOld.Param5_NMTTab == undefined) {
                    objProductOld.Param5_NMTTab = null;
                }
                
                objProductNew.int_LenNMTTabCntCoat = objProductNew.int_LenNMTTabCntCoat === "" ? this.strNullValue : objProductNew.int_LenNMTTabCntCoat;

                if (objProductNew.int_LenNMTTabCntCoat == "0" || objProductNew.int_LenNMTTabCntCoat == this.intNullValue || objProductNew.int_LenNMTTabCntCoat == undefined) {
                    objProductNew.int_LenNMTTabCntCoat = null;
                }
                
                if (objProductOld.Param5_NMTTab == objProductNew.int_LenNMTTabCntCoat) {
                    objLength.Length.NMT.oldValue = false;
                    objLength.Length.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }
                else {
                    objLength.Length.NMT.oldValue = objProductOld.Param5_NMTTab;
                    objLength.Length.NMT.newValue = objProductNew.int_LenNMTTabCntCoat;
                    IsChanged = true;
                }
            }

            if (OldEmpty) {
                if (objProductNew.str_verUnit != "" && objProductNew.flt_LenStdCoat != "" && objProductNew.str_verUnit != undefined && objProductNew.flt_LenStdCoat != undefined) {
                    objLength.Length.Unit.oldValue = "NA";
                    objLength.Length.Unit.newValue = objProductNew.str_verUnit;
                    IsChanged = true;
                }
                else {
                    objLength.Length.Unit.oldValue = false;
                    objLength.Length.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param5_Unit == "NA" ? objProductOld.Param5_Unit = "mm" : objProductOld.Param5_Unit;
                if (objProductOld.Param5_Nom == null && objProductNew.flt_LenStdCoat != null) { // new parameter added
                    objLength.Length.Unit.oldValue = "mm";
                    objLength.Length.Unit.newValue = objProductNew.str_verUnit;
                    IsChanged = true;
                }
                else if (objProductOld.Param5_Unit == null && objProductNew.str_verUnit == null) // no parameter added
                {
                    objLength.Length.Unit.oldValue = false;
                    objLength.Length.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param5_Unit == objProductNew.str_verUnit) {
                        objLength.Length.Unit.oldValue = false;
                        objLength.Length.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objLength.Length.Unit.oldValue = objProductOld.Param5_Unit;
                        objLength.Length.Unit.newValue = objProductNew.str_verUnit;
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objLength);
            }
            resolve(IsChanged);
        });
    }

    validateDiameter(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objDiameter = {
                Diameter: {
                    Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    T3Neg: { oldValue: "", newValue: "" },
                    T3Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    Unit:{ oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Diameter Nom
             */
            if (OldEmpty) {
                if (objProductNew.flt_DiaStdCoat != "" && objProductNew.flt_DiaStdCoat != undefined) {
                    objDiameter.Diameter.Nom.oldValue = "NA";
                    objDiameter.Diameter.Nom.newValue = objProductNew.flt_DiaStdCoat;
                    IsChanged = true;
                } else {
                    objDiameter.Diameter.Nom.oldValue = false;
                    objDiameter.Diameter.Nom.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {
                if (objProductOld.Param6_Nom === "" || objProductOld.Param6_Nom == this.strNullValue || objProductOld.Param6_Nom == undefined) {
                    objProductOld.Param6_Nom = null;
                }

                if (objProductNew.flt_DiaStdCoat === "" || objProductNew.flt_DiaStdCoat == this.strNullValue || objProductNew.flt_DiaStdCoat == undefined) {
                    objProductNew.flt_DiaStdCoat = null;
                }

                if ((objProductOld.Param6_Nom !== null) && (objProductNew.flt_DiaStdCoat !== null)) {
                    if (parseFloat(objProductOld.Param6_Nom).toFixed(2) == parseFloat(objProductNew.flt_DiaStdCoat).toFixed(2)) {
                        objDiameter.Diameter.Nom.oldValue = false;
                        objDiameter.Diameter.Nom.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objDiameter.Diameter.Nom.oldValue = parseFloat(objProductOld.Param6_Nom).toFixed(2);
                        objDiameter.Diameter.Nom.newValue = objProductNew.flt_DiaStdCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_Nom === null) && (objProductNew.flt_DiaStdCoat !== null)) {
                        objDiameter.Diameter.Nom.oldValue = "NA";
                        objDiameter.Diameter.Nom.newValue = objProductNew.flt_DiaStdCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param6_Nom !== null) && (objProductNew.flt_DiaStdCoat === null)) {
                        objDiameter.Diameter.Nom.oldValue = parseFloat(objProductOld.Param6_Nom).toFixed(2);
                        objDiameter.Diameter.Nom.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Diameter NegT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_DiaT1NegCoat != "" && objProductNew.flt_DiaT1NegCoat != undefined) {
                    objDiameter.Diameter.T1Neg.oldValue = "NA";
                    objDiameter.Diameter.T1Neg.newValue = objProductNew.flt_DiaT1NegCoat;
                    IsChanged = true;
                } else {
                    objDiameter.Diameter.T1Neg.oldValue = false;
                    objDiameter.Diameter.T1Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param6_T1Neg === "" || objProductOld.Param6_T1Neg == this.strNullValue || objProductOld.Param6_T1Neg == undefined) {
                    objProductOld.Param6_T1Neg = null;
                }

                if (objProductNew.flt_DiaT1NegCoat === "" || objProductNew.flt_DiaT1NegCoat == this.strNullValue || objProductNew.flt_DiaT1NegCoat == undefined) {
                    objProductNew.flt_DiaT1NegCoat = null;
                }

                if ((objProductOld.Param6_T1Neg !== null) && (objProductNew.flt_DiaT1NegCoat !== null)) {
                    if (parseFloat(objProductOld.Param6_T1Neg).toFixed(2) == parseFloat(objProductNew.flt_DiaT1NegCoat).toFixed(2)) {
                        objDiameter.Diameter.T1Neg.oldValue = false;
                        objDiameter.Diameter.T1Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objDiameter.Diameter.T1Neg.oldValue = parseFloat(objProductOld.Param6_T1Neg).toFixed(2);
                        objDiameter.Diameter.T1Neg.newValue = objProductNew.flt_DiaT1NegCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_T1Neg === null) && (objProductNew.flt_DiaT1NegCoat !== null)) {
                        objDiameter.Diameter.T1Neg.oldValue = "NA";
                        objDiameter.Diameter.T1Neg.newValue = objProductNew.flt_DiaT1NegCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param6_T1Neg !== null) && (objProductNew.flt_DiaT1NegCoat === null)) {
                        objDiameter.Diameter.T1Neg.oldValue = parseFloat(objProductOld.Param6_T1Neg).toFixed(2);
                        objDiameter.Diameter.T1Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Diameter PosT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_DiaT1PosCoat != "" && objProductNew.flt_DiaT1PosCoat != undefined) {
                    objDiameter.Diameter.T1Pos.oldValue = "NA";
                    objDiameter.Diameter.T1Pos.newValue = objProductNew.flt_DiaT1PosCoat;
                    IsChanged = true;
                } else {
                    objDiameter.Diameter.T1Pos.oldValue = false;
                    objDiameter.Diameter.T1Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param6_T1Pos === "" || objProductOld.Param6_T1Pos == this.strNullValue || objProductOld.Param6_T1Pos == undefined) {
                    objProductOld.Param6_T1Pos = null;
                }

                if (objProductNew.flt_DiaT1PosCoat === "" || objProductNew.flt_DiaT1PosCoat == this.strNullValue || objProductNew.flt_DiaT1PosCoat == undefined) {
                    objProductNew.flt_DiaT1PosCoat = null;
                }

                if ((objProductOld.Param6_T1Pos !== null) && (objProductNew.flt_DiaT1PosCoat !== null)) {
                    if (parseFloat(objProductOld.Param6_T1Pos).toFixed(2) == parseFloat(objProductNew.flt_DiaT1PosCoat).toFixed(2)) {
                        objDiameter.Diameter.T1Pos.oldValue = false;
                        objDiameter.Diameter.T1Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objDiameter.Diameter.T1Pos.oldValue = parseFloat(objProductOld.Param6_T1Pos).toFixed(2);
                        objDiameter.Diameter.T1Pos.newValue = objProductNew.flt_DiaT1PosCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_T1Pos === null) && (objProductNew.flt_DiaT1PosCoat !== null)) {
                        objDiameter.Diameter.T1Pos.oldValue = "NA";
                        objDiameter.Diameter.T1Pos.newValue = objProductNew.flt_DiaT1PosCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param6_T1Pos !== null) && (objProductNew.flt_DiaT1PosCoat === null)) {
                        objDiameter.Diameter.T1Pos.oldValue = parseFloat(objProductOld.Param6_T1Pos).toFixed(2);
                        objDiameter.Diameter.T1Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Diameter NegT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_DiaT2NegCoat != "" && objProductNew.flt_DiaT2NegCoat != undefined) {
                    objDiameter.Diameter.T2Neg.oldValue = "NA";
                    objDiameter.Diameter.T2Neg.newValue = objProductNew.flt_DiaT2NegCoat;
                    IsChanged = true;
                } else {
                    objDiameter.Diameter.T2Neg.oldValue = false;
                    objDiameter.Diameter.T2Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param6_T2Neg === "" || objProductOld.Param6_T2Neg == this.strNullValue || objProductOld.Param6_T2Neg == undefined) {
                    objProductOld.Param6_T2Neg = null;
                }

                if (objProductNew.flt_DiaT2NegCoat === "" || objProductNew.flt_DiaT2NegCoat == this.strNullValue || objProductNew.flt_DiaT2NegCoat == undefined) {
                    objProductNew.flt_DiaT2NegCoat = null;
                }

                if ((objProductOld.Param6_T2Neg !== null) && (objProductNew.flt_DiaT2NegCoat !== null)) {
                    if (parseFloat(objProductOld.Param6_T2Neg).toFixed(2) == parseFloat(objProductNew.flt_DiaT2NegCoat).toFixed(2)) {
                        objDiameter.Diameter.T2Neg.oldValue = false;
                        objDiameter.Diameter.T2Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objDiameter.Diameter.T2Neg.oldValue = parseFloat(objProductOld.Param6_T2Neg).toFixed(2);
                        objDiameter.Diameter.T2Neg.newValue = objProductNew.flt_DiaT2NegCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_T2Neg === null) && (objProductNew.flt_DiaT2NegCoat !== null)) {
                        objDiameter.Diameter.T2Neg.oldValue = "NA";
                        objDiameter.Diameter.T2Neg.newValue = objProductNew.flt_DiaT2NegCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param6_T2Neg !== null) && (objProductNew.flt_DiaT2NegCoat === null)) {
                        objDiameter.Diameter.T2Neg.oldValue = parseFloat(objProductOld.Param6_T2Neg).toFixed(2);
                        objDiameter.Diameter.T2Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Diameter PosT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_DiaT2PosCoat != "" && objProductNew.flt_DiaT2PosCoat != undefined) {
                    objDiameter.Diameter.T2Pos.oldValue = "NA";
                    objDiameter.Diameter.T2Pos.newValue = objProductNew.flt_DiaT2PosCoat;
                    IsChanged = true;
                } else {
                    objDiameter.Diameter.T2Pos.oldValue = false;
                    objDiameter.Diameter.T2Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param6_T2Pos === "" || objProductOld.Param6_T2Pos == this.strNullValue || objProductOld.Param6_T2Pos == undefined) {
                    objProductOld.Param6_T2Pos = null;
                }

                if (objProductNew.flt_DiaT2PosCoat === "" || objProductNew.flt_DiaT2PosCoat == this.strNullValue || objProductNew.flt_DiaT2PosCoat == undefined) {
                    objProductNew.flt_DiaT2PosCoat = null;
                }

                if ((objProductOld.Param6_T2Pos !== null) && (objProductNew.flt_DiaT2PosCoat !== null)) {
                    if (parseFloat(objProductOld.Param6_T2Pos).toFixed(2) == parseFloat(objProductNew.flt_DiaT2PosCoat).toFixed(2)) {
                        objDiameter.Diameter.T2Pos.oldValue = false;
                        objDiameter.Diameter.T2Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objDiameter.Diameter.T2Pos.oldValue = parseFloat(objProductOld.Param6_T2Pos).toFixed(2);
                        objDiameter.Diameter.T2Pos.newValue = objProductNew.flt_DiaT2PosCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_T2Pos === null) && (objProductNew.flt_DiaT2PosCoat !== null)) {
                        objDiameter.Diameter.T2Pos.oldValue = "NA";
                        objDiameter.Diameter.T2Pos.newValue = objProductNew.flt_DiaT2PosCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param6_T2Pos !== null) && (objProductNew.flt_DiaT2PosCoat === null)) {
                        objDiameter.Diameter.T2Pos.oldValue = parseFloat(objProductOld.Param6_T2Pos).toFixed(2);
                        objDiameter.Diameter.T2Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Diameter NegT3
            */
            if (OldEmpty) {
                if (objProductNew.flt_DiaT3NegCoat != "" && objProductNew.flt_DiaT3NegCoat != undefined) {
                    objDiameter.Diameter.T3Neg.oldValue = "NA";
                    objDiameter.Diameter.T3Neg.newValue = objProductNew.flt_DiaT3NegCoat;
                    IsChanged = true;
                } else {
                    objDiameter.Diameter.T3Neg.oldValue = false;
                    objDiameter.Diameter.T3Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param6_T3Neg === "" || objProductOld.Param6_T3Neg == this.strNullValue || objProductOld.Param6_T3Neg == undefined) {
                    objProductOld.Param6_T3Neg = null;
                }

                if (objProductNew.flt_DiaT3NegCoat === "" || objProductNew.flt_DiaT3NegCoat == this.strNullValue || objProductNew.flt_DiaT3NegCoat == undefined) {
                    objProductNew.flt_DiaT3NegCoat = null;
                }

                if ((objProductOld.Param6_T3Neg !== null) && (objProductNew.flt_DiaT3NegCoat !== null)) {
                    if (parseFloat(objProductOld.Param6_T3Neg).toFixed(2) == parseFloat(objProductNew.flt_DiaT3NegCoat).toFixed(2)) {
                        objDiameter.Diameter.T3Neg.oldValue = false;
                        objDiameter.Diameter.T3Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objDiameter.Diameter.T3Neg.oldValue = parseFloat(objProductOld.Param6_T3Neg).toFixed(2);
                        objDiameter.Diameter.T3Neg.newValue = objProductNew.flt_DiaT3NegCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_T3Neg === null) && (objProductNew.flt_DiaT3NegCoat !== null)) {
                        objDiameter.Diameter.T3Neg.oldValue = "NA";
                        objDiameter.Diameter.T3Neg.newValue = objProductNew.flt_DiaT3NegCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param6_T3Neg !== null) && (objProductNew.flt_DiaT3NegCoat === null)) {
                        objDiameter.Diameter.T3Neg.oldValue = parseFloat(objProductOld.Param6_T3Neg).toFixed(2);
                        objDiameter.Diameter.T3Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Diameter PosT3
            */
            if (OldEmpty) {
                if (objProductNew.flt_DiaT3PosCoat != "" && objProductNew.flt_DiaT3PosCoat != undefined) {
                    objDiameter.Diameter.T3Pos.oldValue = "NA";
                    objDiameter.Diameter.T3Pos.newValue = objProductNew.flt_DiaT3PosCoat;
                    IsChanged = true;
                } else {
                    objDiameter.Diameter.T3Pos.oldValue = false;
                    objDiameter.Diameter.T3Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param6_T3Pos === "" || objProductOld.Param6_T3Pos == this.strNullValue || objProductOld.Param6_T3Pos == undefined) {
                    objProductOld.Param6_T3Pos = null;
                }

                if (objProductNew.flt_DiaT3PosCoat === "" || objProductNew.flt_DiaT3PosCoat == this.strNullValue || objProductNew.flt_DiaT3PosCoat == undefined) {
                    objProductNew.flt_DiaT3PosCoat = null;
                }

                if ((objProductOld.Param6_T3Pos !== null) && (objProductNew.flt_DiaT3PosCoat !== null)) {
                    if (parseFloat(objProductOld.Param6_T3Pos).toFixed(2) == parseFloat(objProductNew.flt_DiaT3PosCoat).toFixed(2)) {
                        objDiameter.Diameter.T3Pos.oldValue = false;
                        objDiameter.Diameter.T3Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objDiameter.Diameter.T3Pos.oldValue = parseFloat(objProductOld.Param6_T3Pos).toFixed(2);
                        objDiameter.Diameter.T3Pos.newValue = objProductNew.flt_DiaT3PosCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_T3Pos === null) && (objProductNew.flt_DiaT3PosCoat !== null)) {
                        objDiameter.Diameter.T3Pos.oldValue = "NA";
                        objDiameter.Diameter.T3Pos.newValue = objProductNew.flt_DiaT3PosCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param6_T3Pos !== null) && (objProductNew.flt_DiaT3PosCoat === null)) {
                        objDiameter.Diameter.T3Pos.oldValue = parseFloat(objProductOld.Param6_T3Pos).toFixed(2);
                        objDiameter.Diameter.T3Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            // /**
            // * For Diameter NMT
            // */
            if (OldEmpty) {
                if (objProductNew.int_DiaNMTTabCntCoat != "") {
                    objDiameter.Diameter.NMT.oldValue = "NA";
                    objDiameter.Diameter.NMT.newValue = objProductNew.int_DiaNMTTabCntCoat;
                    IsChanged = true;
                } else {
                    objDiameter.Diameter.NMT.oldValue = false;
                    objDiameter.Diameter.NMT.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param6_NMTTab == 0 ||
                    objProductOld.Param6_NMTTab == this.intNullValue ||
                    objProductOld.Param6_NMTTab == undefined) {
                    objProductOld.Param6_NMTTab = null;
                }

                objProductNew.int_DiaNMTTabCntCoat = objProductNew.int_DiaNMTTabCntCoat === "" ? this.strNullValue : objProductNew.int_DiaNMTTabCntCoat;

                if (objProductNew.int_DiaNMTTabCntCoat == "0" || objProductNew.int_DiaNMTTabCntCoat == this.intNullValue || objProductNew.int_DiaNMTTabCntCoat == undefined) {
                    objProductNew.int_DiaNMTTabCntCoat = null;
                }

                if (objProductOld.Param6_NMTTab == objProductNew.int_DiaNMTTabCntCoat) {
                    objDiameter.Diameter.NMT.oldValue = false;
                    objDiameter.Diameter.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }
                else {
                    objDiameter.Diameter.NMT.oldValue = objProductOld.Param6_NMTTab;
                    objDiameter.Diameter.NMT.newValue = objProductNew.int_DiaNMTTabCntCoat;
                    IsChanged = true;
                }
            }

            if (OldEmpty) {
                if (objProductNew.str_verUnit != "" && objProductNew.flt_DiaStdCoat != "" && objProductNew.str_verUnit != undefined && objProductNew.flt_DiaStdCoat != undefined) {
                    objDiameter.Diameter.Unit.oldValue = "NA";
                    objDiameter.Diameter.Unit.newValue = objProductNew.str_verUnit;
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter.Unit.oldValue = false;
                    objDiameter.Diameter.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param6_Unit == "NA" ? objProductOld.Param6_Unit = "mm" : objProductOld.Param6_Unit;
                if (objProductOld.Param6_Nom == null && objProductNew.flt_DiaStdCoat != null) { // new parameter added
                    objDiameter.Diameter.Unit.oldValue = "mm";
                    objDiameter.Diameter.Unit.newValue = objProductNew.str_verUnit;
                    IsChanged = true;
                }
                else if (objProductOld.Param6_Unit == null && objProductNew.str_verUnit == null) // no parameter added
                {
                    objDiameter.Diameter.Unit.oldValue = false;
                    objDiameter.Diameter.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param6_Unit == objProductNew.str_verUnit) {
                        objDiameter.Diameter.Unit.oldValue = false;
                        objDiameter.Diameter.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objDiameter.Diameter.Unit.oldValue = objProductOld.Param6_Unit;
                        objDiameter.Diameter.Unit.newValue = objProductNew.str_verUnit;
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objDiameter);
            }
            resolve(IsChanged);
        });
    }

    validateHardness(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            let str_Tol_1_Neg = (Bln_Is_HardnessNMTNLT == true) ? "NLT" : "T1Neg";
            let str_Tol_1_Pos = (Bln_Is_HardnessNMTNLT == true) ? "NMT" : "T1Pos";
            const objHardness = {
                Hardness: {
                    Nom: { oldValue: "", newValue: "" },
                    [str_Tol_1_Neg]: { oldValue: "", newValue: "" },
                    [str_Tol_1_Pos]: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    T3Neg: { oldValue: "", newValue: "" },
                    T3Pos: { oldValue: "", newValue: "" },
                    HrdUnit: { oldValue: "", newValue: "" },
                    ReportOn: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Hardness Nom
             */
            if (OldEmpty) {
                if (objProductNew.flt_HrdStdCoat != "" && objProductNew.flt_HrdStdCoat != undefined) {
                    objHardness.Hardness.Nom.oldValue = "NA";
                    objHardness.Hardness.Nom.newValue = objProductNew.flt_HrdStdCoat;
                    IsChanged = true;
                } else {
                    objHardness.Hardness.Nom.oldValue = false;
                    objHardness.Hardness.Nom.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }

            } else {
                if (objProductOld.Param7_Nom === "" || objProductOld.Param7_Nom == this.strNullValue ||
                    objProductOld.Param7_Nom == undefined) {
                    objProductOld.Param7_Nom = null;
                }

                if (objProductNew.flt_HrdStdCoat === "" || objProductNew.flt_HrdStdCoat == this.strNullValue ||
                    objProductNew.flt_HrdStdCoat == undefined) {
                    objProductNew.flt_HrdStdCoat = null;
                }

                if ((objProductOld.Param7_Nom !== null) && (objProductNew.flt_HrdStdCoat !== null)) {
                    if (parseFloat(objProductOld.Param7_Nom).toFixed(objProductOld.Param7_DP) == parseFloat(objProductNew.flt_HrdStdCoat).toFixed(objProductNew.int_HardDpCoat)) {
                        objHardness.Hardness.Nom.oldValue = false;
                        objHardness.Hardness.Nom.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objHardness.Hardness.Nom.oldValue = parseFloat(objProductOld.Param7_Nom).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness.Nom.newValue = objProductNew.flt_HrdStdCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param7_Nom === null) && (objProductNew.flt_HrdStdCoat !== null)) {
                        objHardness.Hardness.Nom.oldValue = "NA";
                        objHardness.Hardness.Nom.newValue = objProductNew.flt_HrdStdCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param7_Nom !== null) && (objProductNew.flt_HrdStdCoat === null)) {
                        objHardness.Hardness.Nom.oldValue = parseFloat(objProductOld.Param7_Nom).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness.Nom.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Hardness NegT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_HrdT1Coat != "" && objProductNew.flt_HrdT1Coat != undefined) {
                    objHardness.Hardness[str_Tol_1_Neg].oldValue = "NA";
                    objHardness.Hardness[str_Tol_1_Neg].newValue = objProductNew.flt_HrdT1Coat;
                    IsChanged = true;
                } else {
                    objHardness.Hardness[str_Tol_1_Neg].oldValue = false;
                    objHardness.Hardness[str_Tol_1_Neg].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param7_T1Neg === "" || objProductOld.Param7_T1Neg == this.strNullValue || objProductOld.Param7_T1Neg == undefined) {
                    objProductOld.Param7_T1Neg = null;
                }

                if (objProductNew.flt_HrdT1Coat === "" || objProductNew.flt_HrdT1Coat == this.strNullValue || objProductNew.flt_HrdT1Coat == undefined) {
                    objProductNew.flt_HrdT1Coat = null;
                }

                if ((objProductOld.Param7_T1Neg !== null) && (objProductNew.flt_HrdT1Coat !== null)) {
                    if (parseFloat(objProductOld.Param7_T1Neg).toFixed(objProductOld.Param7_DP) == parseFloat(objProductNew.flt_HrdT1Coat).toFixed(objProductNew.int_HardDpCoat)) {
                        objHardness.Hardness[str_Tol_1_Neg].oldValue = false;
                        objHardness.Hardness[str_Tol_1_Neg].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objHardness.Hardness[str_Tol_1_Neg].oldValue = parseFloat(objProductOld.Param7_T1Neg).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness[str_Tol_1_Neg].newValue = objProductNew.flt_HrdT1Coat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param7_T1Neg === null) && (objProductNew.flt_HrdT1Coat !== null)) {
                        objHardness.Hardness[str_Tol_1_Neg].oldValue = "NA";
                        objHardness.Hardness[str_Tol_1_Neg].newValue = objProductNew.flt_HrdT1Coat;
                        IsChanged = true;

                    } else if ((objProductOld.Param7_T1Neg !== null) && (objProductNew.flt_HrdT1Coat === null)) {
                        objHardness.Hardness[str_Tol_1_Neg].oldValue = parseFloat(objProductOld.Param7_T1Neg).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness[str_Tol_1_Neg].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Hardness PosT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_HrdT2Coat != "" && objProductNew.flt_HrdT2Coat != undefined) {
                    objHardness.Hardness[str_Tol_1_Pos].oldValue = "NA";
                    objHardness.Hardness[str_Tol_1_Pos].newValue = objProductNew.flt_HrdT2Coat;
                    IsChanged = true;
                } else {
                    objHardness.Hardness[str_Tol_1_Pos].oldValue = false;
                    objHardness.Hardness[str_Tol_1_Pos].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param7_T1Pos === "" || objProductOld.Param7_T1Pos == this.strNullValue || objProductOld.Param7_T1Pos == undefined) {
                    objProductOld.Param7_T1Pos = null;
                }

                if (objProductNew.flt_HrdT2Coat === "" || objProductNew.flt_HrdT2Coat == this.strNullValue || objProductNew.flt_HrdT2Coat == undefined) {
                    objProductNew.flt_HrdT2Coat = null;
                }

                if ((objProductOld.Param7_T1Pos !== null) && (objProductNew.flt_HrdT2Coat !== null)) {
                    if (parseFloat(objProductOld.Param7_T1Pos).toFixed(objProductOld.Param7_DP) == parseFloat(objProductNew.flt_HrdT2Coat).toFixed(objProductNew.int_HardDpCoat)) {
                        objHardness.Hardness[str_Tol_1_Pos].oldValue = false;
                        objHardness.Hardness[str_Tol_1_Pos].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objHardness.Hardness[str_Tol_1_Pos].oldValue = parseFloat(objProductOld.Param7_T1Pos).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness[str_Tol_1_Pos].newValue = objProductNew.flt_HrdT2Coat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param7_T1Pos === null) && (objProductNew.flt_HrdT2Coat !== null)) {
                        objHardness.Hardness[str_Tol_1_Pos].oldValue = "NA";
                        objHardness.Hardness[str_Tol_1_Pos].newValue = objProductNew.flt_HrdT2Coat;
                        IsChanged = true;

                    } else if ((objProductOld.Param7_T1Pos !== null) && (objProductNew.flt_HrdT2Coat === null)) {
                        objHardness.Hardness[str_Tol_1_Pos].oldValue = parseFloat(objProductOld.Param7_T1Pos).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness[str_Tol_1_Pos].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Hardness NegT2
             */
            if (OldEmpty) {
                if (objProductNew.flt_HrdT1_2Coat != "" && objProductNew.flt_HrdT1_2Coat != undefined) {
                    objHardness.Hardness.T2Neg.oldValue = "NA";
                    objHardness.Hardness.T2Neg.newValue = objProductNew.flt_HrdT1_2Coat;
                    IsChanged = true;
                } else {
                    objHardness.Hardness.T2Neg.oldValue = false;
                    objHardness.Hardness.T2Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param7_T2Neg === "" || objProductOld.Param7_T2Neg == this.strNullValue || objProductOld.Param7_T2Neg == undefined) {
                    objProductOld.Param7_T2Neg = null;
                }

                if (objProductNew.flt_HrdT1_2Coat === "" || objProductNew.flt_HrdT1_2Coat == this.strNullValue || objProductNew.flt_HrdT1_2Coat == undefined) {
                    objProductNew.flt_HrdT1_2Coat = null;
                }

                if ((objProductOld.Param7_T2Neg !== null) && (objProductNew.flt_HrdT1_2Coat !== null)) {
                    if (parseFloat(objProductOld.Param7_T2Neg).toFixed(objProductOld.Param7_DP) == parseFloat(objProductNew.flt_HrdT1_2Coat).toFixed(objProductNew.int_HardDpCoat)) {
                        objHardness.Hardness.T2Neg.oldValue = false;
                        objHardness.Hardness.T2Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objHardness.Hardness.T2Neg.oldValue = parseFloat(objProductOld.Param7_T2Neg).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness.T2Neg.newValue = objProductNew.flt_HrdT1_2Coat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param7_T2Neg === null) && (objProductNew.flt_HrdT1_2Coat !== null)) {
                        objHardness.Hardness.T2Neg.oldValue = "NA";
                        objHardness.Hardness.T2Neg.newValue = objProductNew.flt_HrdT1_2Coat;
                        IsChanged = true;

                    } else if ((objProductOld.Param7_T2Neg !== null) && (objProductNew.flt_HrdT1_2Coat === null)) {
                        objHardness.Hardness.T2Neg.oldValue = parseFloat(objProductOld.Param7_T2Neg).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness.T2Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Hardness PosT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_HrdT2_2Coat != "" && objProductNew.flt_HrdT2_2Coat != undefined) {
                    objHardness.Hardness.T2Pos.oldValue = "NA";
                    objHardness.Hardness.T2Pos.newValue = objProductNew.flt_HrdT2_2Coat;
                    IsChanged = true;
                } else {
                    objHardness.Hardness.T2Pos.oldValue = false;
                    objHardness.Hardness.T2Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param7_T2Pos === "" || objProductOld.Param7_T2Pos == this.strNullValue || objProductOld.Param7_T2Pos == undefined) {
                    objProductOld.Param7_T2Pos = null;
                }

                if (objProductNew.flt_HrdT2_2Coat === "" || objProductNew.flt_HrdT2_2Coat == this.strNullValue || objProductNew.flt_HrdT2_2Coat == undefined) {
                    objProductNew.flt_HrdT2_2Coat = null;
                }

                if ((objProductOld.Param7_T2Pos !== null) && (objProductNew.flt_HrdT2_2Coat !== null)) {
                    if (parseFloat(objProductOld.Param7_T2Pos).toFixed(objProductOld.Param7_DP) == parseFloat(objProductNew.flt_HrdT2_2Coat).toFixed(objProductNew.int_HardDpCoat)) {
                        objHardness.Hardness.T2Pos.oldValue = false;
                        objHardness.Hardness.T2Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objHardness.Hardness.T2Pos.oldValue = parseFloat(objProductOld.Param7_T2Pos).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness.T2Pos.newValue = objProductNew.flt_HrdT2_2Coat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param7_T2Pos === null) && (objProductNew.flt_HrdT2_2Coat !== null)) {
                        objHardness.Hardness.T2Pos.oldValue = "NA";
                        objHardness.Hardness.T2Pos.newValue = objProductNew.flt_HrdT2_2Coat;
                        IsChanged = true;

                    } else if ((objProductOld.Param7_T2Pos !== null) && (objProductNew.flt_HrdT2_2Coat === null)) {
                        objHardness.Hardness.T2Pos.oldValue = parseFloat(objProductOld.Param7_T2Pos).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness.T2Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Hardness NegT3
             */
            if (OldEmpty) {
                if (objProductNew.flt_HrdT1_3Coat != "" && objProductNew.flt_HrdT1_3Coat != undefined) {
                    objHardness.Hardness.T3Neg.oldValue = "NA";
                    objHardness.Hardness.T3Neg.newValue = objProductNew.flt_HrdT1_3Coat;
                    IsChanged = true;
                } else {
                    objHardness.Hardness.T3Neg.oldValue = false;
                    objHardness.Hardness.T3Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param7_T3Neg === "" || objProductOld.Param7_T3Neg == this.strNullValue || objProductOld.Param7_T3Neg == undefined) {
                    objProductOld.Param7_T3Neg = null;
                }

                if (objProductNew.flt_HrdT1_3Coat === "" || objProductNew.flt_HrdT1_3Coat == this.strNullValue || objProductNew.flt_HrdT1_3Coat == undefined) {
                    objProductNew.flt_HrdT1_3Coat = null;
                }

                if ((objProductOld.Param7_T3Neg !== null) && (objProductNew.flt_HrdT1_3Coat !== null)) {
                    if (parseFloat(objProductOld.Param7_T3Neg).toFixed(objProductOld.Param7_DP) == parseFloat(objProductNew.flt_HrdT1_3Coat).toFixed(objProductNew.int_HardDpCoat)) {
                        objHardness.Hardness.T3Neg.oldValue = false;
                        objHardness.Hardness.T3Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objHardness.Hardness.T3Neg.oldValue = parseFloat(objProductOld.Param7_T3Neg).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness.T3Neg.newValue = objProductNew.flt_HrdT1_3Coat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param7_T3Neg === null) && (objProductNew.flt_HrdT1_3Coat !== null)) {
                        objHardness.Hardness.T3Neg.oldValue = "NA";
                        objHardness.Hardness.T3Neg.newValue = objProductNew.flt_HrdT1_3Coat;
                        IsChanged = true;

                    } else if ((objProductOld.Param7_T3Neg !== null) && (objProductNew.flt_HrdT1_3Coat === null)) {
                        objHardness.Hardness.T3Neg.oldValue = parseFloat(objProductOld.Param7_T3Neg).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness.T3Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Hardness PosT3
            */
            if (OldEmpty) {
                if (objProductNew.flt_HrdT2_3Coat != "" && objProductNew.flt_HrdT2_3Coat != undefined) {
                    objHardness.Hardness.T3Pos.oldValue = "NA";
                    objHardness.Hardness.T3Pos.newValue = objProductNew.flt_HrdT2_3Coat;
                    IsChanged = true;
                } else {
                    objHardness.Hardness.T3Pos.oldValue = false;
                    objHardness.Hardness.T3Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            } else {

                if (objProductOld.Param7_T3Pos === "" || objProductOld.Param7_T3Pos == this.strNullValue || objProductOld.Param7_T3Pos == undefined) {
                    objProductOld.Param7_T3Pos = null;
                }

                if (objProductNew.flt_HrdT2_3Coat === "" || objProductNew.flt_HrdT2_3Coat == this.strNullValue || objProductNew.flt_HrdT2_3Coat == undefined) {
                    objProductNew.flt_HrdT2_3Coat = null;
                }

                if ((objProductOld.Param7_T3Pos !== null) && (objProductNew.flt_HrdT2_3Coat !== null)) {
                    if (parseFloat(objProductOld.Param7_T3Pos).toFixed(objProductOld.Param7_DP) == parseFloat(objProductNew.flt_HrdT2_3Coat).toFixed(objProductNew.int_HardDpCoat)) {
                        objHardness.Hardness.T3Pos.oldValue = false;
                        objHardness.Hardness.T3Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objHardness.Hardness.T3Pos.oldValue = parseFloat(objProductOld.Param7_T3Pos).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness.T3Pos.newValue = objProductNew.flt_HrdT2_3Coat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param7_T3Pos === null) && (objProductNew.flt_HrdT2_3Coat !== null)) {
                        objHardness.Hardness.T3Pos.oldValue = "NA";
                        objHardness.Hardness.T3Pos.newValue = objProductNew.flt_HrdT2_3Coat;
                        IsChanged = true;

                    } else if ((objProductOld.Param7_T3Pos !== null) && (objProductNew.flt_HrdT2_3Coat === null)) {
                        objHardness.Hardness.T3Pos.oldValue = parseFloat(objProductOld.Param7_T3Pos).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness.T3Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Hardness Unit
            */
            if (OldEmpty == true) {
                if (objProductNew.str_HrdUnitCoat != "" && objProductNew.flt_HrdStdCoat != "" && objProductNew.str_HrdUnitCoat != undefined && objProductNew.flt_HrdStdCoat != undefined) {
                    objHardness.Hardness.HrdUnit.oldValue = "NA";
                    objHardness.Hardness.HrdUnit.newValue = objProductNew.str_HrdUnitCoat;
                    IsChanged = true;
                }
                else {
                    objHardness.Hardness.HrdUnit.oldValue = false;
                    objHardness.Hardness.HrdUnit.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param7_Nom == null && objProductNew.flt_HrdStdCoat != null) { // new parameter added
                    objHardness.Hardness.HrdUnit.oldValue = "NA";
                    objHardness.Hardness.HrdUnit.newValue = objProductNew.str_HrdUnitCoat;
                    IsChanged = true;
                }
                else if (objProductOld.Param7_Nom == null && objProductNew.flt_HrdStdCoat == null) // no parameter added
                {
                    objHardness.Hardness.HrdUnit.oldValue = false;
                    objHardness.Hardness.HrdUnit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param7_Unit == objProductNew.str_HrdUnitCoat) {
                        objHardness.Hardness.HrdUnit.oldValue = false;
                        objHardness.Hardness.HrdUnit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objHardness.Hardness.HrdUnit.oldValue = objProductOld.Param7_Unit;
                        objHardness.Hardness.HrdUnit.newValue = objProductNew.str_HrdUnitCoat;
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Hardness Limits On Standard / Avg
             */
            var strGraphOn = "";
            if (OldEmpty) {
                strGraphOn = "Standard";
                if (strGraphOn == objProductNew.str_HrdGraphOnCoat && objProductNew.str_HrdGraphOnCoat != undefined) {
                    objHardness.Hardness.ReportOn.oldValue = false;
                    objHardness.Hardness.ReportOn.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged;
                }
                else {
                    objHardness.Hardness.ReportOn.oldValue = strGraphOn;
                    objHardness.Hardness.ReportOn.newValue = objProductNew.str_HrdGraphOnCoat;
                    IsChanged = true;
                }
            } else {
                strGraphOn = objProductOld.Param7_IsOnStd == 0 ? "Standard" : "Average";
                if (objProductOld.Param7_Nom == null && objProductNew.flt_HrdStdCoat != null) { // new parameter added
                    objHardness.Hardness.ReportOn.oldValue = "NA";
                    objHardness.Hardness.ReportOn.newValue = objProductNew.str_HrdGraphOnCoat;
                    IsChanged = true;
                }
                else if (objProductOld.Param7_Nom == null && objProductNew.flt_HrdStdCoat == null) // no parameter added
                {
                    objHardness.Hardness.ReportOn.oldValue = false;
                    objHardness.Hardness.ReportOn.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strGraphOn == objProductNew.str_HrdGraphOnCoat) {
                        objHardness.Hardness.ReportOn.oldValue = false;
                        objHardness.Hardness.ReportOn.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged;
                    }
                    else {
                        objHardness.Hardness.ReportOn.oldValue = strGraphOn;
                        objHardness.Hardness.ReportOn.newValue = objProductNew.str_HrdGraphOnCoat;
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objHardness);
            }
            resolve(IsChanged);
        });
    }

    validateDT(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objDT = {
                DT: {
                    DTTime: { oldValue: "", newValue: "" },
                    DTMinTemp: { oldValue: "", newValue: "" },
                    DTMaxTemp: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.int_DTMMTimeCoat != "" && objProductNew.int_DTMMTimeCoat != undefined) {
                    objDT.DT.DTTime.oldValue = "NA";
                    objDT.DT.DTTime.newValue = objProductNew.int_DTHHTimeCoat + ":" + objProductNew.int_DTMMTimeCoat + ":" + objProductNew.int_DTSSTimeCoat;
                    IsChanged = true;
                }
                else {
                    objDT.DT.DTTime.oldValue = false;
                    objDT.DT.DTTime.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param13_Nom === "" ||
                    objProductOld.Param13_Nom == this.strNullValue ||
                    objProductOld.Param13_Nom == undefined) {
                    objProductOld.Param13_Nom = null;
                }
    
                if (objProductNew.int_DTHHTimeCoat === "" ||
                    objProductNew.int_DTHHTimeCoat == this.strNullValue ||
                    objProductNew.int_DTHHTimeCoat == undefined) {
                    objProductNew.int_DTHHTimeCoat = null;
                }
    
                if (objProductNew.int_DTMMTimeCoat === "" ||
                    objProductNew.int_DTMMTimeCoat == this.strNullValue ||
                    objProductNew.int_DTMMTimeCoat == undefined) {
                    objProductNew.int_DTMMTimeCoat = null;
                }
    
                if (objProductNew.int_DTSSTimeCoat === "" ||
                    objProductNew.int_DTSSTimeCoat == this.strNullValue ||
                    objProductNew.int_DTSSTimeCoat == undefined) {
                    objProductNew.int_DTSSTimeCoat = null;
                }
    
                if ((objProductOld.Param13_Nom === null) && (objProductNew.int_DTHHTimeCoat === null) && 
                    (objProductNew.int_DTMMTimeCoat === null) && (objProductNew.int_DTSSTimeCoat === null)) {
                        objDT.DT.DTTime.oldValue = false;
                        objDT.DT.DTTime.newValue = false;
                        IsChanged = false;
                }
                else if (objProductOld.Param13_Nom == (objProductNew.int_DTHHTimeCoat + ":" + objProductNew.int_DTMMTimeCoat + ":" + objProductNew.int_DTSSTimeCoat)) {
                    objDT.DT.DTTime.oldValue = false;
                    objDT.DT.DTTime.newValue = false;
                    IsChanged = false;
                }
                else {
                    objDT.DT.DTTime.oldValue = objProductOld.Param13_Nom;
                    objDT.DT.DTTime.newValue = objProductNew.int_DTHHTimeCoat + ":" + objProductNew.int_DTMMTimeCoat + ":" + objProductNew.int_DTSSTimeCoat;
                    IsChanged = true;
                }
            }
    
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if ((objProductNew.flt_DTMinTempCoat != "") && (objProductNew.flt_DTMinTempCoat != 99999) && objProductNew.flt_DTMinTempCoat != undefined) {
                    objDT.DT.DTMinTemp.oldValue = "NA";
                    objDT.DT.DTMinTemp.newValue = objProductNew.flt_DTMinTempCoat;
                    IsChanged = true;
                }
                else {
                    objDT.DT.DTMinTemp.oldValue = false;
                    objDT.DT.DTMinTemp.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param13_T1Neg === "" ||
                    objProductOld.Param13_T1Neg == this.strNullValue ||
                    objProductOld.Param13_T1Neg == undefined) {
                    objProductOld.Param13_T1Neg = null;
                }
    
                if (objProductNew.flt_DTMinTempCoat === "" ||
                    objProductNew.flt_DTMinTempCoat == this.strNullValue ||
                    objProductNew.flt_DTMinTempCoat == undefined) {
                    objProductNew.flt_DTMinTempCoat = null;
                }
    
                if ((objProductOld.Param13_T1Neg !== null) && (objProductNew.flt_DTMinTempCoat !== null)) {
                    if (parseFloat(objProductOld.Param13_T1Neg).toFixed(objProductOld.Param13_DP) == parseFloat(objProductNew.flt_DTMinTempCoat).toFixed(objProductNew.int_DTDpCoat)) {
                        objDT.DT.DTMinTemp.oldValue = false;
                        objDT.DT.DTMinTemp.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
    
                    } else {
                        objDT.DT.DTMinTemp.oldValue = parseFloat(objProductOld.Param13_T1Neg).toFixed(objProductOld.Param13_DP);
                        objDT.DT.DTMinTemp.newValue = objProductNew.flt_DTMinTempCoat;
                        IsChanged = true;
                    }
    
                } else if((objProductOld.Param13_T1Neg == null) && (objProductNew.flt_DTMinTempCoat == '99999')) {
                    objDT.DT.DTMinTemp.oldValue = false;
                    objDT.DT.DTMinTemp.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
    
                } else {
    
                    if ((objProductOld.Param13_T1Neg === null) && (objProductNew.flt_DTMinTempCoat !== null)) {
                        objDT.DT.DTMinTemp.oldValue = "NA";
                        objDT.DT.DTMinTemp.newValue = objProductNew.flt_DTMinTempCoat;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param13_T1Neg !== null) && (objProductNew.flt_DTMinTempCoat === null)) {
                        objDT.DT.DTMinTemp.oldValue = parseFloat(objProductOld.Param13_T1Neg).toFixed(objProductOld.Param13_DP);
                        objDT.DT.DTMinTemp.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if ((objProductNew.flt_DTMaxTempCoat != "") && (objProductNew.flt_DTMaxTempCoat != 99999) && objProductNew.flt_DTMaxTempCoat != undefined) {
                    objDT.DT.DTMaxTemp.oldValue = "NA";
                    objDT.DT.DTMaxTemp.newValue = objProductNew.flt_DTMaxTempCoat;
                    IsChanged = true;
                }
                else {
                    objDT.DT.DTMaxTemp.oldValue = false;
                    objDT.DT.DTMaxTemp.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param13_T1Pos === "" ||
                    objProductOld.Param13_T1Pos == this.strNullValue ||
                    objProductOld.Param13_T1Pos == undefined) {
                    objProductOld.Param13_T1Pos = null;
                }
    
                if (objProductNew.flt_DTMaxTempCoat === "" ||
                    objProductNew.flt_DTMaxTempCoat == this.strNullValue ||
                    objProductNew.flt_DTMaxTempCoat == undefined) {
                    objProductNew.flt_DTMaxTempCoat = null;
                }
    
                if ((objProductOld.Param13_T1Pos !== null) && (objProductNew.flt_DTMaxTempCoat !== null)) {
                    if (parseFloat(objProductOld.Param13_T1Pos).toFixed(objProductOld.Param13_DP) == parseFloat(objProductNew.flt_DTMaxTempCoat).toFixed(objProductNew.int_DTDpCoat)) {
                        objDT.DT.DTMaxTemp.oldValue = false;
                        objDT.DT.DTMaxTemp.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
    
                    } else {
                        objDT.DT.DTMaxTemp.oldValue = parseFloat(objProductOld.Param13_T1Pos).toFixed(objProductOld.Param13_DP);
                        objDT.DT.DTMaxTemp.newValue = objProductNew.flt_DTMaxTempCoat;
                        IsChanged = true;
                    }
    
                } else if((objProductOld.Param13_T1Pos == null) && (objProductNew.flt_DTMaxTempCoat == '99999')){
                    objDT.DT.DTMaxTemp.oldValue = false;
                    objDT.DT.DTMaxTemp.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
    
                } else {
    
                    if ((objProductOld.Param13_T1Pos === null) && (objProductNew.flt_DTMaxTempCoat !== null)) {
                        objDT.DT.DTMaxTemp.oldValue = "NA";
                        objDT.DT.DTMaxTemp.newValue = objProductNew.flt_DTMaxTempCoat;
                        IsChanged = true;
    
                    } else if ((objProductOld.Param13_T1Pos !== null) && (objProductNew.flt_DTMaxTempCoat === null)) {
                        objDT.DT.DTMaxTemp.oldValue = parseFloat(objProductOld.Param13_T1Pos).toFixed(objProductOld.Param13_DP);
                        objDT.DT.DTMaxTemp.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            if (IsChanged == true) {
                Object.assign(this.objResult, objDT);
            }
            resolve(IsChanged);
        });
    }

    validateLOD(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objLOD = {
                LOD: {
                    MIN: { oldValue: "", newValue: "" },
                    MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_MAT1Coat != "" && objProductNew.flt_MAT1Coat != undefined) {
                    objLOD.LOD.MIN.oldValue = "NA";
                    objLOD.LOD.MIN.newValue = objProductNew.flt_MAT1Coat;
                    IsChanged = true;
                }
                else {
                    objLOD.LOD.MIN.oldValue = false;
                    objLOD.LOD.MIN.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param16_T1Neg === "" ||
                    objProductOld.Param16_T1Neg == this.strNullValue ||
                    objProductOld.Param16_T1Neg == undefined) {
                    objProductOld.Param16_T1Neg = null;
                }

                if (objProductNew.flt_MAT1Coat === "" ||
                    objProductNew.flt_MAT1Coat == this.strNullValue ||
                    objProductNew.flt_MAT1Coat == undefined) {
                    objProductNew.flt_MAT1Coat = null;
                }

                if ((objProductOld.Param16_T1Neg !== null) && (objProductNew.flt_MAT1Coat !== null)) {
                    if (parseFloat(objProductOld.Param16_T1Neg).toFixed(objProductOld.Param16_DP) == parseFloat(objProductNew.flt_MAT1Coat).toFixed(objProductNew.int_MADpCoat)) {
                        objLOD.LOD.MIN.oldValue = false;
                        objLOD.LOD.MIN.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objLOD.LOD.MIN.oldValue = parseFloat(objProductOld.Param16_T1Neg).toFixed(objProductOld.Param16_DP);
                        objLOD.LOD.MIN.newValue = objProductNew.flt_MAT1Coat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param16_T1Neg === null) && (objProductNew.flt_MAT1Coat !== null)) {
                        objLOD.LOD.MIN.oldValue = "NA";
                        objLOD.LOD.MIN.newValue = objProductNew.flt_MAT1Coat;
                        IsChanged = true;

                    } else if ((objProductOld.Param16_T1Neg !== null) && (objProductNew.flt_MAT1Coat === null)) {
                        objLOD.LOD.MIN.oldValue = parseFloat(objProductOld.Param16_T1Neg).toFixed(objProductOld.Param16_DP);
                        objLOD.LOD.MIN.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (OldEmpty == true) {
                if (objProductNew.flt_MAT1Coat != "" && objProductNew.flt_MAT1Coat != undefined) {
                    objLOD.LOD.MAX.oldValue = "NA";
                    objLOD.LOD.MAX.newValue = objProductNew.flt_MAT1Coat;
                    IsChanged = true;
                }
                else {
                    objLOD.LOD.MAX.oldValue = false;
                    objLOD.LOD.MAX.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param16_T1Pos === "" ||
                    objProductOld.Param16_T1Pos == this.strNullValue ||
                    objProductOld.Param16_T1Pos == undefined) {
                    objProductOld.Param16_T1Pos = null;
                }

                if (objProductNew.flt_MAT2Coat === "" ||
                    objProductNew.flt_MAT2Coat == this.strNullValue ||
                    objProductNew.flt_MAT2Coat == undefined) {
                    objProductNew.flt_MAT2Coat = null;
                }

                if ((objProductOld.Param16_T1Pos !== null) && (objProductNew.flt_MAT2Coat !== null)) {
                    if (parseFloat(objProductOld.Param16_T1Pos).toFixed(objProductOld.Param16_DP) == parseFloat(objProductNew.flt_MAT2Coat).toFixed(objProductNew.int_MADpCoat)) {
                        objLOD.LOD.MAX.oldValue = false;
                        objLOD.LOD.MAX.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objLOD.LOD.MAX.oldValue = parseFloat(objProductOld.Param16_T1Pos).toFixed(objProductOld.Param16_DP);
                        objLOD.LOD.MAX.newValue = objProductNew.flt_MAT2Coat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param16_T1Pos === null) && (objProductNew.flt_MAT2Coat !== null)) {
                        objLOD.LOD.MAX.oldValue = "NA";
                        objLOD.LOD.MAX.newValue = objProductNew.flt_MAT2Coat;
                        IsChanged = true;

                    } else if ((objProductOld.Param16_T1Pos !== null) && (objProductNew.flt_MAT2Coat === null)) {
                        objLOD.LOD.MAX.oldValue = parseFloat(objProductOld.Param16_T1Pos).toFixed(objProductOld.Param16_DP);
                        objLOD.LOD.MAX.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objLOD);
            }
            resolve(IsChanged);
        });
    }

    validateYield(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objYield = {
                Yield: {
                    TheroticalYield: { oldValue: "", newValue: "" },
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.TheroticalYield != "" && objProductNew.TheroticalYield != undefined) {
                    objYield.Yield.TheroticalYield.oldValue = "NA";
                    objYield.Yield.TheroticalYield.newValue = objProductNew.TheroticalYield;
                    IsChanged = true;
                }
                else {
                    objYield.Yield.TheroticalYield.oldValue = false;
                    objYield.Yield.TheroticalYield.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.TheroticalYield === "" ||
                    objProductOld.TheroticalYield == this.strNullValue ||
                    objProductOld.TheroticalYield == undefined) {
                    objProductOld.TheroticalYield = null;
                }

                if (objProductNew.TheroticalYield === "" ||
                    objProductNew.TheroticalYield == this.strNullValue) {
                    objProductNew.TheroticalYield = null;
                }

                if (parseFloat(objProductOld.TheroticalYield).toFixed(objProductOld.Yield_DP) ==
                    parseFloat(objProductNew.TheroticalYield).toFixed(objProductOld.Yield_DP)) {
                    objYield.Yield.TheroticalYield.oldValue = false;
                    objYield.Yield.TheroticalYield.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (parseFloat(objProductOld.TheroticalYield).toFixed(objProductOld.Yield_DP) === "NaN") {
                        objYield.Yield.TheroticalYield.oldValue = "NA";
                    }
                    else {
                        objYield.Yield.TheroticalYield.oldValue = parseFloat(objProductOld.TheroticalYield).toFixed(objProductOld.Yield_DP);
                    }
                    objYield.Yield.TheroticalYield.newValue = objProductNew.TheroticalYield;
                    IsChanged = true;
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objYield);
            }
            resolve(IsChanged);
        });
    }

    validateFriability(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFriability = {
                Friability: {
                    FriNMT: { oldValue: "", newValue: "" },
                    FriSetCnt: { oldValue: "", newValue: "" },
                    FriSetRPM: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FriNMTCoat != "" && objProductNew.flt_FriNMTCoat != undefined) {
                    objFriability.Friability.FriNMT.oldValue = "NA";
                    objFriability.Friability.FriNMT.newValue = objProductNew.flt_FriNMTCoat;
                    IsChanged = true;
                }
                else {
                    objFriability.Friability.FriNMT.oldValue = false;
                    objFriability.Friability.FriNMT.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param8_Nom === "" ||
                    objProductOld.Param8_Nom == this.NMTValue ||
                    objProductOld.Param8_Nom == undefined) {
                    objProductOld.Param8_Nom = null;
                }

                if (objProductNew.flt_FriNMTCoat === "" ||
                    objProductNew.flt_FriNMTCoat == this.NMTValue ||
                    objProductNew.flt_FriNMTCoat == undefined) {
                    objProductNew.flt_FriNMTCoat = null;
                }

                if ((objProductOld.Param8_Nom !== null) && (objProductNew.flt_FriNMTCoat !== null)) {
                    if (parseFloat(objProductOld.Param8_Nom).toFixed(objProductOld.Param8_DP) == parseFloat(objProductNew.flt_FriNMTCoat).toFixed(objProductNew.int_FriCoatDp)) {
                        objFriability.Friability.FriNMT.oldValue = false;
                        objFriability.Friability.FriNMT.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objFriability.Friability.FriNMT.oldValue = parseFloat(objProductOld.Param8_Nom).toFixed(objProductOld.Param8_DP);
                        objFriability.Friability.FriNMT.newValue = objProductNew.flt_FriNMTCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param8_Nom === null) && (objProductNew.flt_FriNMTCoat !== null)) {
                        objFriability.Friability.FriNMT.oldValue = "NA";
                        objFriability.Friability.FriNMT.newValue = objProductNew.flt_FriNMTCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param8_Nom !== null) && (objProductNew.flt_FriNMTCoat === null)) {
                        objFriability.Friability.FriNMT.oldValue = parseFloat(objProductOld.Param8_Nom).toFixed(objProductOld.Param8_DP);
                        objFriability.Friability.FriNMT.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
             * For Individual NegT1
             */
            if (OldEmpty == true) {
                if (objProductNew.int_FriSetCntCoat != "" && objProductNew.int_FriSetCntCoat != undefined) {
                    objFriability.Friability.FriSetCnt.oldValue = "NA";
                    objFriability.Friability.FriSetCnt.newValue = objProductNew.int_FriSetCntCoat;
                    IsChanged = true;
                }
                else {
                    objFriability.Friability.FriSetCnt.oldValue = false;
                    objFriability.Friability.FriSetCnt.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param8_T1Neg === "" ||
                    objProductOld.Param8_T1Neg == this.strNullValue ||
                    objProductOld.Param8_T1Neg == undefined) {
                    objProductOld.Param8_T1Neg = null;
                }

                if (objProductNew.int_FriSetCntCoat === "" ||
                    objProductNew.int_FriSetCntCoat == this.strNullValue ||
                    objProductNew.int_FriSetCntCoat == undefined) {
                    objProductNew.int_FriSetCntCoat = null;
                }

                if ((objProductOld.Param8_T1Neg !== null) && (objProductNew.int_FriSetCntCoat !== null)) {
                    if (parseFloat(objProductOld.Param8_T1Neg).toFixed(objProductOld.Param8_DP) == parseFloat(objProductNew.int_FriSetCntCoat).toFixed(objProductNew.int_FriCoatDp)) {
                        objFriability.Friability.FriSetCnt.oldValue = false;
                        objFriability.Friability.FriSetCnt.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objFriability.Friability.FriSetCnt.oldValue = parseFloat(objProductOld.Param8_T1Neg).toFixed(objProductOld.Param8_DP);
                        objFriability.Friability.FriSetCnt.newValue = objProductNew.int_FriSetCntCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param8_T1Neg === null) && (objProductNew.int_FriSetCntCoat !== null)) {
                        objFriability.Friability.FriSetCnt.oldValue = "NA";
                        objFriability.Friability.FriSetCnt.newValue = objProductNew.int_FriSetCntCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param8_T1Neg !== null) && (objProductNew.int_FriSetCntCoat === null)) {
                        objFriability.Friability.FriSetCnt.oldValue = parseFloat(objProductOld.Param8_T1Neg).toFixed(objProductOld.Param8_DP);
                        objFriability.Friability.FriSetCnt.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Individual PosT1
             */
            if (OldEmpty == true) {
                if (objProductNew.int_FriSetRPMCoat != "" && objProductNew.int_FriSetRPMCoat != undefined) {
                    objFriability.Friability.FriSetRPM.oldValue = "NA";
                    objFriability.Friability.FriSetRPM.newValue = objProductNew.int_FriSetRPMCoat;
                    IsChanged = true;
                }
                else {
                    objFriability.Friability.FriSetRPM.oldValue = false;
                    objFriability.Friability.FriSetRPM.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param8_T1Pos === "" ||
                    objProductOld.Param8_T1Pos == this.strNullValue ||
                    objProductOld.Param8_T1Pos == undefined) {
                    objProductOld.Param8_T1Pos = null;
                }

                if (objProductNew.int_FriSetRPMCoat === "" ||
                    objProductNew.int_FriSetRPMCoat == this.strNullValue ||
                    objProductNew.int_FriSetRPMCoat == undefined) {
                    objProductNew.int_FriSetRPMCoat = null;
                }

                if ((objProductOld.Param8_T1Pos !== null) && (objProductNew.int_FriSetRPMCoat !== null)) {
                    if (parseFloat(objProductOld.Param8_T1Pos).toFixed(objProductOld.Param8_DP) == parseFloat(objProductNew.int_FriSetRPMCoat).toFixed(objProductNew.int_FriCoatDp)) {
                        objFriability.Friability.FriSetRPM.oldValue = false;
                        objFriability.Friability.FriSetRPM.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objFriability.Friability.FriSetRPM.oldValue = parseFloat(objProductOld.Param8_T1Pos).toFixed(objProductOld.Param8_DP);
                        objFriability.Friability.FriSetRPM.newValue = objProductNew.int_FriSetRPMCoat;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param8_T1Pos === null) && (objProductNew.int_FriSetRPMCoat !== null)) {
                        objFriability.Friability.FriSetRPM.oldValue = "NA";
                        objFriability.Friability.FriSetRPM.newValue = objProductNew.int_FriSetRPMCoat;
                        IsChanged = true;

                    } else if ((objProductOld.Param8_T1Pos !== null) && (objProductNew.int_FriSetRPMCoat === null)) {
                        objFriability.Friability.FriSetRPM.oldValue = parseFloat(objProductOld.Param8_T1Pos).toFixed(objProductOld.Param8_DP);
                        objFriability.Friability.FriSetRPM.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objFriability);
            }
            resolve(IsChanged);
        });
    }


    async validateCoatedParams(objProductOld, objProductNew) {
        var Ind = await this.validateIndividual(objProductOld, objProductNew);
        var Grp = await this.validateGroup(objProductOld, objProductNew);
        var Thick = await this.validateThickness(objProductOld, objProductNew);
        var Brd = await this.validateBreadth(objProductOld, objProductNew);
        var Len = await this.validateLength(objProductOld, objProductNew);
        var Dia = await this.validateDiameter(objProductOld, objProductNew);
        var Hard = await this.validateHardness(objProductOld, objProductNew);
        var Fri = await this.validateFriability(objProductOld, objProductNew);
        var DT = await this.validateDT(objProductOld, objProductNew);
        var LOD = await this.validateLOD(objProductOld, objProductNew);

        
        if (Ind != true && Grp != true && Thick != true && Brd != true &&
            Len != true && Dia != true && Hard != true && DT != true && LOD != true && Fri != true) {
            return "No Change";
        }
        else {
            var strChanged = "";
            var strNewValue = "";

            //"Individual : Nominal : value,Group : Nominal : value"
            IterateObject(this.objResult, function (value, key1) {
                //console.log(key1);
                var obj = value;
                strChanged = strChanged + "|";
                strNewValue = strNewValue + "|";
                IterateObject(obj, (value, key) => {
                    if ((value.oldValue !== false) && ((value.oldValue !== "") && (value.newValue !== ""))) {
                        strChanged = strChanged + key1 + ":";
                        strChanged = strChanged + key + ":";
                        strChanged = strChanged + ((value.oldValue == null || value.oldValue == "NaN") ? "NA" : value.oldValue) + ", ";
                        if (strChanged.includes("null:null:null")) {
                            strChanged = strChanged.replace(/null/g, "NA");
                        }

                        strNewValue = strNewValue + key1 + "-";
                        strNewValue = strNewValue + key + ":";
                        strNewValue = strNewValue + ((value.newValue == null || value.newValue == "NaN") ? "NA" : value.newValue) + ", ";
                        if (strNewValue.includes("null:null:null")) {
                            strNewValue = strNewValue.replace(/null/g, "NA");
                        }
                    }

                });
            });

            return { oldData: strChanged.slice(1), newData: strNewValue.slice(1) };
        }
    }

}
module.exports = ValidateProductCoated;