var IterateObject = require("iterate-object");
var clsCompressValidation = require('./validateProductCompressed.class');

class ValidateCapsule extends clsCompressValidation {
    constructor() {
        super();
        const objResult = {};
        this.objResult = objResult;
        this.strNullValue = "99999.00000";
        this.NMTValue = 99999;
    }
    
    validateIndividual(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objIndividual = {
                Individual: {
                    Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    LimitOn: { oldValue: "", newValue: "" },
                    ReportOn: { oldValue: "", newValue: "" },
                    Nomenclature: { oldValue: "", newValue: "" },
                    Unit:{oldValue: "", newValue: ""},
                    
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */

            /**
             * Product with only granulation parameter while editing, open close any compressed parameter for that parameter null value is coming
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_IndStd != "" && objProductNew.flt_IndStd != undefined) {
                    objIndividual.Individual.Nom.oldValue = "NA";
                    objIndividual.Individual.Nom.newValue = objProductNew.flt_IndStd;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.Nom.oldValue = false;
                    objIndividual.Individual.Nom.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param1_Nom === "" ||
                    objProductOld.Param1_Nom == this.strNullValue ||
                    objProductOld.Param1_Nom == undefined) {
                    objProductOld.Param1_Nom = null
                }
                if (objProductNew.flt_IndStd === "" ||
                    objProductNew.flt_IndStd == this.strNullValue) {
                    objProductNew.flt_IndStd = null
                }

                if (parseFloat(objProductOld.Param1_Nom).toFixed(objProductOld.Param1_DP) == parseFloat(objProductNew.flt_IndStd).toFixed(objProductNew.int_IndDP)) {
                    objIndividual.Individual.Nom.oldValue = false;
                    objIndividual.Individual.Nom.newValue = false;
                    IsChanged = false;
                }
                else {

                    objIndividual.Individual.Nom.oldValue = objProductOld.Param1_Nom != null  ? parseFloat(objProductOld.Param1_Nom).toFixed(objProductOld.Param1_DP) : 'NA';
                    objIndividual.Individual.Nom.newValue = objProductNew.flt_IndStd != null  ? objProductNew.flt_IndStd : 'NA';
                    IsChanged = true;
                }
            }

            /**
             * For Individual NegT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_IndT1Neg != "" && objProductNew.flt_IndT1Neg != undefined) {
                    objIndividual.Individual.T1Neg.oldValue = "NA";
                    objIndividual.Individual.T1Neg.newValue = objProductNew.flt_IndT1Neg;
                    IsChanged = true;
                }
                else {

                    objIndividual.Individual.T1Neg.oldValue = false;
                    objIndividual.Individual.T1Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_T1Neg === "" ||
                    objProductOld.Param1_T1Neg == this.strNullValue ||
                    objProductOld.Param1_T1Neg == undefined) {

                    objProductOld.Param1_T1Neg = null;
                }
                if (objProductNew.flt_IndT1Neg === "" || objProductNew.flt_IndT1Neg == this.strNullValue || objProductNew.flt_IndT1Neg == undefined) {
                    objProductNew.flt_IndT1Neg = null;
                }

                if (parseFloat(objProductOld.Param1_T1Neg).toFixed(objProductOld.Param1_DP) == parseFloat(objProductNew.flt_IndT1Neg).toFixed(objProductNew.int_IndDP)) {
                    objIndividual.Individual.T1Neg.oldValue = false;
                    objIndividual.Individual.T1Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {

                    objIndividual.Individual.T1Neg.oldValue = objProductOld.Param1_T1Neg != null  ? parseFloat(objProductOld.Param1_T1Neg).toFixed(objProductOld.Param1_DP) : 'NA';
                    objIndividual.Individual.T1Neg.newValue = objProductNew.flt_IndT1Neg != null  ? objProductNew.flt_IndT1Neg: 'NA';
                    IsChanged = true;
                }
            }

            /**
             * For Individual PosT1
             */

            if (OldEmpty) {
                if (objProductNew.flt_IndT1Pos != "" && objProductNew.flt_IndT1Pos != undefined) {
                    objIndividual.Individual.T1Pos.oldValue = "NA";
                    objIndividual.Individual.T1Pos.newValue = objProductNew.flt_IndT1Pos;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.T1Pos.oldValue = false;
                    objIndividual.Individual.T1Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_T1Pos === "" ||
                    objProductOld.Param1_T1Pos == this.strNullValue ||
                    objProductOld.Param1_T1Pos == undefined) {
                    objProductOld.Param1_T1Pos = null;
                }

                if (objProductNew.flt_IndT1Pos === "" ||
                    objProductNew.flt_IndT1Pos == this.strNullValue ||
                    objProductNew.flt_IndT1Pos == undefined) {
                    objProductNew.flt_IndT1Pos = null
                }

                if (parseFloat(objProductOld.Param1_T1Pos).toFixed(objProductOld.Param1_DP) == parseFloat(objProductNew.flt_IndT1Pos).toFixed(objProductNew.int_IndDP)) {
                    objIndividual.Individual.T1Pos.oldValue = false;
                    objIndividual.Individual.T1Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {

                    objIndividual.Individual.T1Pos.oldValue = objProductOld.Param1_T1Pos != null  ? parseFloat(objProductOld.Param1_T1Pos).toFixed(objProductOld.Param1_DP) : 'NA';
                    objIndividual.Individual.T1Pos.newValue = objProductNew.flt_IndT1Pos != null  ? objProductNew.flt_IndT1Pos : 'NA';
                    IsChanged = true;
                }
            }

            /**
            * For Individual NegT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_IndT2Neg != "" && objProductNew.flt_IndT2Neg != undefined) {
                    objIndividual.Individual.T2Neg.oldValue = "NA";
                    objIndividual.Individual.T2Neg.newValue = objProductNew.flt_IndT2Neg;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.T2Neg.oldValue = false;
                    objIndividual.Individual.T2Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_T2Neg == "" ||
                    objProductOld.Param1_T2Neg == this.strNullValue ||
                    objProductOld.Param1_T2Neg == undefined) {
                    objProductOld.Param1_T2Neg = null;
                }

                if (objProductNew.flt_IndT2Neg == "" ||
                    objProductNew.flt_IndT2Neg == this.strNullValue ||
                    objProductNew.flt_IndT2Neg == undefined) {
                    objProductNew.flt_IndT2Neg = null
                }
                if (parseFloat(objProductOld.Param1_T2Neg).toFixed(objProductOld.Param1_DP) == parseFloat(objProductNew.flt_IndT2Neg).toFixed(objProductNew.int_IndDP)) {
                    objIndividual.Individual.T2Neg.oldValue = false;
                    objIndividual.Individual.T2Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {

                    objIndividual.Individual.T2Neg.oldValue = objProductOld.Param1_T2Neg != null  ? parseFloat(objProductOld.Param1_T2Neg).toFixed(objProductOld.Param1_DP) : 'NA';
                    objIndividual.Individual.T2Neg.newValue = objProductNew.flt_IndT2Neg != null  ? objProductNew.flt_IndT2Neg : 'NA';
                    IsChanged = true;
                }
            }

            /**
            * For Individual PosT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_IndT2Pos != "" && objProductNew.flt_IndT2Pos != undefined) {
                    objIndividual.Individual.T2Pos.oldValue = "NA";
                    objIndividual.Individual.T2Pos.newValue = objProductNew.flt_IndT2Pos;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.T2Pos.oldValue = false;
                    objIndividual.Individual.T2Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_T2Pos === "" ||
                    objProductOld.Param1_T2Pos == this.strNullValue ||
                    objProductOld.Param1_T2Pos == undefined) {
                    objProductOld.Param1_T2Pos = null;
                }

                if (objProductNew.flt_IndT2Pos === "" ||
                    objProductNew.flt_IndT2Pos == this.strNullValue ||
                    objProductNew.flt_IndT2Pos == undefined) {
                    objProductNew.flt_IndT2Pos = null
                }
                if (parseFloat(objProductOld.Param1_T2Pos).toFixed(objProductOld.Param1_DP) == parseFloat(objProductNew.flt_IndT2Pos).toFixed(objProductNew.int_IndDP)) {
                    objIndividual.Individual.T2Pos.oldValue = false;
                    objIndividual.Individual.T2Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {

                    objIndividual.Individual.T2Pos.oldValue = objProductOld.Param1_T2Neg != null  ? parseFloat(objProductOld.Param1_T2Pos).toFixed(objProductOld.Param1_DP) : 'NA';
                    objIndividual.Individual.T2Pos.newValue = objProductNew.flt_IndT2Pos != null  ? objProductNew.flt_IndT2Pos : 'NA';
                    IsChanged = true;
                }
            }

            /**
            * For Individual NMT
            */
            if (OldEmpty) {
                if (objProductNew.int_IndNMTTabCnt != "" && objProductNew.int_IndNMTTabCnt != undefined) {
                    objIndividual.Individual.NMT.oldValue = "NA";
                    objIndividual.Individual.NMT.newValue = objProductNew.int_IndNMTTabCnt;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.NMT.oldValue = false;
                    objIndividual.Individual.NMT.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_NMTTab == 0 ||
                    objProductOld.Param1_NMTTab == this.NMTValue ||
                    objProductOld.Param1_NMTTab == undefined) {
                    objProductOld.Param1_NMTTab = 0;
                }
                objProductNew.int_IndNMTTabCnt = objProductNew.int_IndNMTTabCnt == "" ? this.strNullValue : objProductNew.int_IndNMTTabCnt;
                if (objProductNew.int_IndNMTTabCnt == "0" ||
                    objProductNew.int_IndNMTTabCnt == this.NMTValue ||
                    objProductNew.int_IndNMTTabCnt == undefined) {
                    objProductNew.int_IndNMTTabCnt = 0
                }


                if (parseInt(objProductOld.Param1_NMTTab) == parseInt(objProductNew.int_IndNMTTabCnt)) {
                    objIndividual.Individual.NMT.oldValue = false;
                    objIndividual.Individual.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objIndividual.Individual.NMT.oldValue = objProductOld.Param1_NMTTab;
                    objIndividual.Individual.NMT.newValue = objProductNew.int_IndNMTTabCnt;
                    IsChanged = true;
                }

            }

            /**
             * For Individual Limits On Actual / Percent
             */
            if (OldEmpty) {
                if (objProductNew.str_IndLimitOn != "" && objProductNew.flt_IndStd != "" && objProductNew.flt_IndStd != undefined) {
                    objIndividual.Individual.LimitOn.oldValue = "NA";
                    objIndividual.Individual.LimitOn.newValue = objProductNew.str_IndLimitOn;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.LimitOn.oldValue = false;
                    objIndividual.Individual.LimitOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_Nom === "" ||
                    objProductOld.Param1_Nom == this.strNullValue ||
                    objProductOld.Param1_Nom == undefined) {
                    objIndividual.Individual.LimitOn.oldValue = "Actual";
                    objIndividual.Individual.LimitOn.newValue = objProductNew.str_IndLimitOn;
                    IsChanged = true;
                }
                else {
                    const strLimitOn = objProductOld.Param1_LimitOn == 0 ? "Actual" : "Percentage";
                    if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStd != null) { // new parameter added
                        objIndividual.Individual.LimitOn.oldValue = "NA";
                        objIndividual.Individual.LimitOn.newValue = objProductNew.str_IndLimitOn;
                        IsChanged = true;
                    }
                    else if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStd == null) // no parameter added
                    {
                        objIndividual.Individual.LimitOn.oldValue = false;
                        objIndividual.Individual.LimitOn.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        if (strLimitOn == objProductNew.str_IndLimitOn) {
                            objIndividual.Individual.LimitOn.oldValue = false;
                            objIndividual.Individual.LimitOn.newValue = false;
                            IsChanged != true ? IsChanged = false : IsChanged = true;
                        }
                        else {
                            objIndividual.Individual.LimitOn.oldValue = strLimitOn;
                            objIndividual.Individual.LimitOn.newValue = objProductNew.str_IndLimitOn;
                            IsChanged = true;
                        }
                    }

                }
            }


            /**
             * For Individual Limits On Standard / Avg
             */
            if (OldEmpty) {
                if (objProductNew.str_IndGraphOn != "" && objProductNew.flt_IndStd != ''&& objProductNew.flt_IndStd != undefined) {
                    objIndividual.Individual.ReportOn.oldValue = "NA";
                    objIndividual.Individual.ReportOn.newValue = objProductNew.str_IndGraphOn;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.ReportOn.oldValue = false;
                    objIndividual.Individual.ReportOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strGraphOn = objProductOld.Param1_IsOnStd == 0 ? "Standard" : "Average";
                if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStd != null) { // new parameter added
                    objIndividual.Individual.ReportOn.oldValue = "NA";
                    objIndividual.Individual.ReportOn.newValue = objProductNew.str_IndGraphOn;
                    IsChanged = true;
                }
                else if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStd == null) // no parameter added
                {
                    objIndividual.Individual.ReportOn.oldValue = false;
                    objIndividual.Individual.ReportOn.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strGraphOn == objProductNew.str_IndGraphOn) {
                        objIndividual.Individual.ReportOn.oldValue = false;
                        objIndividual.Individual.ReportOn.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividual.Individual.ReportOn.oldValue = strGraphOn;
                        objIndividual.Individual.ReportOn.newValue = objProductNew.str_IndGraphOn;
                        IsChanged = true;
                    }
                }


            }

            /** Nominal Nomenclature is Standard / Target  */
            if (OldEmpty) {
                if (objProductNew.str_ind_nomNomnclature != "" && objProductNew.flt_IndStd != '' && objProductNew.flt_IndStd != undefined) {
                    objIndividual.Individual.Nomenclature.oldValue = "NA";
                    objIndividual.Individual.Nomenclature.newValue = objProductNew.str_ind_nomNomnclature;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.Nomenclature.oldValue = false;
                    objIndividual.Individual.Nomenclature.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param1_Nomenclature == "NA" ? objProductOld.Param1_Nomenclature = "Standard" : objProductOld.Param1_Nomenclature;
                if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStd != null) { // new parameter added
                    objIndividual.Individual.Nomenclature.oldValue = "NA";
                    objIndividual.Individual.Nomenclature.newValue = objProductNew.str_ind_nomNomnclature;
                    IsChanged = true;
                }
                else if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStd == null) // no parameter added
                {
                    objIndividual.Individual.Nomenclature.oldValue = false;
                    objIndividual.Individual.Nomenclature.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param1_Nomenclature == objProductNew.str_ind_nomNomnclature) {
                        objIndividual.Individual.Nomenclature.oldValue = false;
                        objIndividual.Individual.Nomenclature.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividual.Individual.Nomenclature.oldValue = objProductOld.Param1_Nomenclature;
                        objIndividual.Individual.Nomenclature.newValue = objProductNew.str_ind_nomNomnclature;
                        IsChanged = true;
                    }
                }


            }

            //Unit
            if (OldEmpty) {
                if (objProductNew.str_indUnit != "" && objProductNew.flt_IndStd != ''  && objProductNew.flt_IndStd != undefined) {
                    objIndividual.Individual.Unit.oldValue = 'NA';
                    objIndividual.Individual.Unit.newValue = objProductNew.str_indUnit;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.Unit.oldValue = false;
                    objIndividual.Individual.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param1_Unit == "NA" ? objProductOld.Param1_Unit = "gm" : objProductOld.Param1_Unit;
                if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStd != null) { // new parameter added
                    objIndividual.Individual.Unit.oldValue = "NA";
                    objIndividual.Individual.Unit.newValue = objProductNew.str_indUnit;
                    IsChanged = true;
                }
                else if (objProductOld.Param1_Unit == null && objProductNew.str_indUnit == null) // no parameter added
                {
                    //Extra string null condition added when there exist compressed paramater but not this one than database will hold 'NULL'
                    objIndividual.Individual.Unit.oldValue = false;
                    objIndividual.Individual.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param1_Unit == objProductNew.str_indUnit) {
                        objIndividual.Individual.Unit.oldValue = false;
                        objIndividual.Individual.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividual.Individual.Unit.oldValue = objProductOld.Param1_Unit;
                        objIndividual.Individual.Unit.newValue = objProductNew.str_indUnit;
                        IsChanged = true;
                    }
                }


            }


            if (IsChanged == true) {
                Object.assign(this.objResult, objIndividual);
            }
            resolve(IsChanged);
        })


    }

    validateGourp(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objGroup = {
                Group: {
                    Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    LimitOn: { oldValue: "", newValue: "" },
                    ReportOn: { oldValue: "", newValue: "" },
                    Unit:{ oldValue: "", newValue: "" },
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            if (OldEmpty) {
                if (objProductNew.flt_GrpStd != "" && objProductNew.flt_GrpStd != undefined) {
                    objGroup.Group.Nom.oldValue = "NA";
                    objGroup.Group.Nom.newValue = objProductNew.flt_GrpStd;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.Nom.oldValue = false;
                    objGroup.Group.Nom.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {


                if (objProductOld.Param2_Nom === "" ||
                    objProductOld.Param2_Nom == this.strNullValue ||
                    objProductOld.Param2_Nom == undefined) {
                    objProductOld.Param2_Nom = null;
                }


                objProductNew.flt_GrpStd = objProductNew.flt_GrpStd == "" ? this.strNullValue : objProductNew.flt_GrpStd;

                if (objProductNew.flt_GrpStd === "" ||
                    objProductNew.flt_GrpStd == this.strNullValue ||
                    objProductNew.flt_GrpStd == undefined) {
                    objProductNew.flt_GrpStd = null;
                }
                if (parseFloat(objProductOld.Param2_Nom).toFixed(objProductOld.Param2_DP) == parseFloat(objProductNew.flt_GrpStd).toFixed(objProductNew.int_Grpdp)) {
                    objGroup.Group.Nom.oldValue = false;
                    objGroup.Group.Nom.newValue = false;
                    IsChanged = false;
                }
                else {

                    objGroup.Group.Nom.oldValue = objProductOld.Param2_Nom != null  ? parseFloat(objProductOld.Param2_Nom).toFixed(objProductOld.Param2_DP) : 'NA';
                    objGroup.Group.Nom.newValue = objProductNew.flt_GrpStd != null  ? objProductNew.flt_GrpStd : 'NA';
                    IsChanged = true;
                }
            }

            /**
             * For Individual NegT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_GrpT1Neg != "" && objProductNew.flt_GrpT1Neg != undefined) {
                    objGroup.Group.T1Neg.oldValue = "NA";
                    objGroup.Group.T1Neg.newValue = objProductNew.flt_GrpT1Neg;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.T1Neg.oldValue = false;
                    objGroup.Group.T1Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param2_T1Neg === "" ||
                    objProductOld.Param2_T1Neg == this.strNullValue ||
                    objProductOld.Param2_T1Neg == undefined) {
                    objProductOld.Param2_T1Neg = null;
                }

                if (objProductNew.flt_GrpT1Neg === "" ||
                    objProductNew.flt_GrpT1Neg == this.strNullValue ||
                    objProductNew.flt_GrpT1Neg == undefined) {
                    objProductNew.flt_GrpT1Neg = null;
                }
                if (parseFloat(objProductOld.Param2_T1Neg).toFixed(objProductOld.Param2_DP) == parseFloat(objProductNew.flt_GrpT1Neg).toFixed(objProductNew.int_Grpdp)) {
                    objGroup.Group.T1Neg.oldValue = false;
                    objGroup.Group.T1Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {

                    objGroup.Group.T1Neg.oldValue = objProductOld.Param2_T1Neg != null  ? parseFloat(objProductOld.Param2_T1Neg).toFixed(objProductOld.Param2_DP) : 'NA';
                    objGroup.Group.T1Neg.newValue = objProductNew.flt_GrpT1Neg != null  ? objProductNew.flt_GrpT1Neg : 'NA';
                    IsChanged = true;
                }
            }

            /**
             * For Individual PosT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_GrpT1Pos != "" && objProductNew.flt_GrpT1Pos != undefined) {
                    objGroup.Group.T1Pos.oldValue = "NA";
                    objGroup.Group.T1Pos.newValue = objProductNew.flt_GrpT1Pos;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.T1Pos.oldValue = false;
                    objGroup.Group.T1Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param2_T1Pos === "" ||
                    objProductOld.Param2_T1Pos == this.strNullValue ||
                    objProductOld.Param2_T1Pos == undefined) {
                    objProductOld.Param2_T1Pos = null;
                }

                if (objProductNew.flt_GrpT1Pos === "" ||
                    objProductNew.flt_GrpT1Pos == this.strNullValue ||
                    objProductNew.flt_GrpT1Pos == undefined) {
                    objProductNew.flt_GrpT1Pos = null;
                }

                if (parseFloat(objProductOld.Param2_T1Pos).toFixed(objProductOld.Param2_DP) == parseFloat(objProductNew.flt_GrpT1Pos).toFixed(objProductNew.int_Grpdp)) {
                    objGroup.Group.T1Pos.oldValue = false;
                    objGroup.Group.T1Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {

                    objGroup.Group.T1Pos.oldValue = objProductOld.Param2_T1Pos != null ? parseFloat(objProductOld.Param2_T1Pos).toFixed(objProductOld.Param2_DP) : 'NA';
                    objGroup.Group.T1Pos.newValue = objProductNew.flt_GrpT1Pos != null  ?  objProductNew.flt_GrpT1Pos : 'NA';
                    IsChanged = true;
                }

            }

            /**
            * For Individual NegT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_GrpT2Neg != "" && objProductNew.flt_GrpT2Neg != undefined) {
                    objGroup.Group.T2Neg.oldValue = "NA";
                    objGroup.Group.T2Neg.newValue = objProductNew.flt_GrpT2Neg;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.T2Neg.oldValue = false;
                    objGroup.Group.T2Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param2_T2Neg === "" ||
                    objProductOld.Param2_T2Neg == this.strNullValue ||
                    objProductOld.Param2_T2Neg == undefined) {
                    objProductOld.Param2_T2Neg = null;
                }

                if (objProductNew.flt_GrpT2Neg === "" ||
                    objProductNew.flt_GrpT2Neg == this.strNullValue ||
                    objProductNew.flt_GrpT2Neg == undefined) {
                    objProductNew.flt_GrpT2Neg = null;
                }
                if (parseFloat(objProductOld.Param2_T2Neg).toFixed(objProductOld.Param2_DP) == parseFloat(objProductNew.flt_GrpT2Neg).toFixed(objProductNew.int_Grpdp)) {
                    objGroup.Group.T2Neg.oldValue = false;
                    objGroup.Group.T2Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {

                    objGroup.Group.T2Neg.oldValue = objProductOld.Param2_T2Neg != null  ? parseFloat(objProductOld.Param2_T2Neg).toFixed(objProductOld.Param2_DP) : 'NA';
                    objGroup.Group.T2Neg.newValue = objProductNew.flt_GrpT2Neg != null  ? objProductNew.flt_GrpT2Neg : 'NA';
                    IsChanged = true;
                }
            }

            /**
            * For Individual PosT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_GrpT2Pos != "" && objProductNew.flt_GrpT2Pos != undefined) {
                    objGroup.Group.T2Pos.oldValue = "NA";
                    objGroup.Group.T2Pos.newValue = objProductNew.flt_GrpT2Pos;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.T2Pos.oldValue = false;
                    objGroup.Group.T2Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param2_T2Pos === "" ||
                    objProductOld.Param2_T2Pos == this.strNullValue ||
                    objProductOld.Param2_T2Pos == undefined) {
                    objProductOld.Param2_T2Pos = null;
                }

                if (objProductNew.flt_GrpT2Pos === "" ||
                    objProductNew.flt_GrpT2Pos == this.strNullValue ||
                    objProductNew.flt_GrpT2Pos == undefined) {
                    objProductNew.flt_GrpT2Pos = null;
                }
                if (parseFloat(objProductOld.Param2_T2Pos).toFixed(objProductOld.Param2_DP) == parseFloat(objProductNew.flt_GrpT2Pos).toFixed(objProductNew.int_Grpdp)) {
                    objGroup.Group.T2Pos.oldValue = false;
                    objGroup.Group.T2Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {

                    objGroup.Group.T2Pos.oldValue = objProductOld.Param2_T2Pos != null  ? parseFloat(objProductOld.Param2_T2Pos).toFixed(objProductOld.Param2_DP) : 'NA';
                    objGroup.Group.T2Pos.newValue = objProductNew.flt_GrpT2Pos != null  ? objProductNew.flt_GrpT2Pos : 'NA';
                    IsChanged = true;
                }
            }

            /**
            * For Individual NMT
            */
            if (OldEmpty) {
                if (objProductNew.int_GrpNMTTabCnt != "" && objProductNew.int_GrpNMTTabCnt != undefined) {
                    objGroup.Group.NMT.oldValue = "NA";
                    objGroup.Group.NMT.newValue = objProductNew.int_GrpNMTTabCnt;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.NMT.oldValue = false;
                    objGroup.Group.NMT.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param2_NMTTab == 0 ||
                    objProductOld.Param2_NMTTab == this.NMTValue ||
                    objProductOld.Param2_NMTTab == undefined) {
                    objProductOld.Param2_NMTTab = 0;
                }
                objProductNew.int_GrpNMTTabCnt = objProductNew.int_GrpNMTTabCnt == "" ? this.strNullValue : objProductNew.int_GrpNMTTabCnt;

                if (objProductNew.int_GrpNMTTabCnt == "0" ||
                    objProductNew.int_GrpNMTTabCnt == this.NMTValue ||
                    objProductNew.int_GrpNMTTabCnt == undefined) {
                    objProductNew.int_GrpNMTTabCnt = 0;
                }

                if (parseInt(objProductOld.Param2_NMTTab) == parseInt(objProductNew.int_GrpNMTTabCnt)) {
                    objGroup.Group.NMT.oldValue = false;
                    objGroup.Group.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objGroup.Group.NMT.oldValue = objProductOld.Param2_NMTTab;
                    objGroup.Group.NMT.newValue = objProductNew.int_GrpNMTTabCnt;
                    IsChanged = true;
                }


            }


            /**
             * For Individual Limits On Actual / Percent
             */
            if (OldEmpty) {
                if (objProductNew.str_GrpLimitOn != "" && objProductNew.flt_GrpStd != '' && objProductNew.flt_GrpStd != undefined) {
                    objGroup.Group.LimitOn.oldValue = "NA";
                    objGroup.Group.LimitOn.newValue = objProductNew.str_GrpLimitOn;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.LimitOn.oldValue = false;
                    objGroup.Group.LimitOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strLimitOn = objProductOld.Param2_LimitOn == 0 ? "Actual" : "Percentage";
                if (objProductOld.Param2_Nom == null && objProductNew.flt_GrpStd != null) { // new parameter added
                    objGroup.Group.LimitOn.oldValue = "NA";
                    objGroup.Group.LimitOn.newValue = objProductNew.str_GrpLimitOn;
                    IsChanged = true;
                }
                else if (objProductOld.Param2_Nom == null && objProductNew.flt_GrpStd == null) // no parameter added
                {
                    objGroup.Group.LimitOn.oldValue = false;
                    objGroup.Group.LimitOn.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strLimitOn == objProductNew.str_GrpLimitOn) {
                        objGroup.Group.LimitOn.oldValue = false;
                        objGroup.Group.LimitOn.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group.LimitOn.oldValue = strLimitOn;
                        objGroup.Group.LimitOn.newValue = objProductNew.str_GrpLimitOn;
                        IsChanged = true;
                    }
                }

            }


            /**
             * For Individual Limits On Standard / Avg
             */
            if (OldEmpty) {
                if (objProductNew.str_GrpGraphOn != "" && objProductNew.flt_GrpStd != '' && objProductNew.flt_GrpStd != undefined) {
                    objGroup.Group.ReportOn.oldValue = "NA";
                    objGroup.Group.ReportOn.newValue = objProductNew.str_GrpGraphOn;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.ReportOn.oldValue = false;
                    objGroup.Group.ReportOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strGraphOn = objProductOld.Param2_IsOnStd == 0 ? "Standard" : "Average";
                if (objProductOld.Param2_Nom == null && objProductNew.flt_GrpStd != null) { // new parameter added
                    objGroup.Group.ReportOn.oldValue = "NA";
                    objGroup.Group.ReportOn.newValue = objProductNew.str_GrpGraphOn;
                    IsChanged = true;
                }
                else if (objProductOld.Param2_Nom == null && objProductNew.flt_GrpStd == null) // no parameter added
                {
                    objGroup.Group.ReportOn.oldValue = false;
                    objGroup.Group.ReportOn.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strGraphOn == objProductNew.str_GrpGraphOn) {
                        objGroup.Group.ReportOn.oldValue = false;
                        objGroup.Group.ReportOn.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group.ReportOn.oldValue = strGraphOn;
                        objGroup.Group.ReportOn.newValue = objProductNew.str_GrpGraphOn;
                        IsChanged = true;
                    }
                }

            }

            /**
             * For Group
             */
             if (OldEmpty) {
                if (objProductNew.str_groupUnit != "" && objProductNew.flt_GrpStd != ''  && objProductNew.flt_GrpStd != undefined) {
                    objGroup.Group.Unit.oldValue = "NA";
                    objGroup.Group.Unit.newValue = objProductNew.str_groupUnit;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.Unit.oldValue = false;
                    objGroup.Group.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strGrpUnit = objProductOld.Param2_Unit == 0 ? "gm" : objProductOld.Param2_Unit;
                if (objProductOld.Param2_Nom == null && objProductNew.flt_GrpStd != null) { // new parameter added
                    objGroup.Group.Unit.oldValue = "NA";
                    objGroup.Group.Unit.newValue = objProductNew.str_groupUnit;
                    IsChanged = true;
                }
                else if (objProductOld.Param2_Unit == null && objProductNew.str_groupUnit == null) // no parameter added
                {
                    objGroup.Group.Unit.oldValue = false;
                    objGroup.Group.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strGrpUnit == objProductNew.str_groupUnit) {
                        objGroup.Group.Unit.oldValue = false;
                        objGroup.Group.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group.Unit.oldValue = strGrpUnit;
                        objGroup.Group.Unit.newValue = objProductNew.str_groupUnit;
                        IsChanged = true;
                    }
                }

            }


            if (IsChanged == true) {
                Object.assign(this.objResult, objGroup);
            }
            resolve(IsChanged);
        })
    }

    validateLength(objProductOld, objProductNew,int_tabCap) {
        return new Promise((resolve, reject) => {
            const objLength = {
                Length: {
                    Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    //GraphOn: { oldValue: "", newValue: "" }
                    Unit: { oldValue: "", newValue: "" },
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;

            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_LenStd != "" && objProductNew.flt_LenStd != undefined) {
                    objLength.Length.Nom.oldValue = "NA";
                    objLength.Length.Nom.newValue = objProductNew.flt_LenStd;
                    IsChanged = true;
                }
                else {
                    objLength.Length.Nom.oldValue = false;
                    objLength.Length.Nom.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param5_Nom === "" ||
                    objProductOld.Param5_Nom == this.strNullValue ||
                    objProductOld.Param5_Nom == undefined) {
                    objProductOld.Param5_Nom = null;
                }

                if (objProductNew.flt_LenStd === "" ||
                    objProductNew.flt_LenStd == this.strNullValue ||
                    objProductNew.flt_LenStd == undefined) {
                    objProductNew.flt_LenStd = null
                }
                if (parseFloat(objProductOld.Param5_Nom).toFixed(objProductOld.Param5_DP) == parseFloat(objProductNew.flt_LenStd).toFixed(objProductNew.int_LenDp)) {
                    objLength.Length.Nom.oldValue = false;
                    objLength.Length.Nom.newValue = false;
                    IsChanged = false;
                }
                else {

                    objLength.Length.Nom.oldValue = objProductOld.Param5_Nom ? parseFloat(objProductOld.Param5_Nom).toFixed(objProductOld.Param5_DP) : 'NA';
                    objLength.Length.Nom.newValue = objProductNew.flt_LenStd ? parseFloat(objProductNew.flt_LenStd).toFixed(objProductNew.int_LenDp) : 'NA';
                    IsChanged = true;
                }
            }

            /**
             * For Individual NegT1
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_LenT1Neg != "" && objProductNew.flt_LenT1Neg != undefined) {
                    objLength.Length.T1Neg.oldValue = "NA";
                    objLength.Length.T1Neg.newValue = objProductNew.flt_LenT1Neg;
                    IsChanged = true;
                }
                else {
                    objLength.Length.T1Neg.oldValue = false;
                    objLength.Length.T1Neg.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param5_T1Neg === "" ||
                    objProductOld.Param5_T1Neg == this.strNullValue ||
                    objProductOld.Param5_T1Neg == undefined) {
                    objProductOld.Param5_T1Neg = null;
                }

                if (objProductNew.flt_LenT1Neg === "" ||
                    objProductNew.flt_LenT1Neg == this.strNullValue ||
                    objProductNew.flt_LenT1Neg == undefined) {
                    objProductNew.flt_LenT1Neg = null
                }
                if (parseFloat(objProductOld.Param5_T1Neg).toFixed(objProductOld.Param5_DP) == parseFloat(objProductNew.flt_LenT1Neg).toFixed(objProductNew.int_LenDp)) {
                    objLength.Length.T1Neg.oldValue = false;
                    objLength.Length.T1Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {

                    objLength.Length.T1Neg.oldValue = objProductOld.Param5_T1Neg != null  ? parseFloat(objProductOld.Param5_T1Neg).toFixed(objProductOld.Param5_DP) : 'NA';
                    objLength.Length.T1Neg.newValue = objProductNew.flt_LenT1Neg != null  ? parseFloat(objProductNew.flt_LenT1Neg).toFixed(objProductNew.int_LenDp) : 'NA';
                    IsChanged = true;
                }
            }

            /**
             * For Individual PosT1
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_LenT1Pos != "" && objProductNew.flt_LenT1Pos != undefined) {
                    objLength.Length.T1Pos.oldValue = "NA";
                    objLength.Length.T1Pos.newValue = objProductNew.flt_LenT1Pos;
                    IsChanged = true;
                }
                else {
                    objLength.Length.T1Pos.oldValue = false;
                    objLength.Length.T1Pos.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param5_T1Pos === "" ||
                    objProductOld.Param5_T1Pos == this.strNullValue ||
                    objProductOld.Param5_T1Pos == undefined) {
                    objProductOld.Param5_T1Pos = null;
                }

                if (objProductNew.flt_LenT1Pos === "" ||
                    objProductNew.flt_LenT1Pos == this.strNullValue ||
                    objProductNew.flt_LenT1Pos == undefined) {
                    objProductNew.flt_LenT1Pos = null
                }
                if (parseFloat(objProductOld.Param5_T1Pos).toFixed(objProductOld.Param5_DP) == parseFloat(objProductNew.flt_LenT1Pos).toFixed(objProductNew.int_LenDp)) {
                    objLength.Length.T1Pos.oldValue = false;
                    objLength.Length.T1Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {

                    objLength.Length.T1Pos.oldValue = objProductOld.Param5_T1Pos != null  ? parseFloat(objProductOld.Param5_T1Pos).toFixed(objProductOld.Param5_DP) : 'NA';
                    objLength.Length.T1Pos.newValue = objProductNew.flt_LenT1Pos != null  ? parseFloat(objProductNew.flt_LenT1Pos).toFixed(objProductNew.int_LenDp) : 'NA';
                    IsChanged = true;
                }
            }

            /**
            * For Individual NegT2
            */
            if (OldEmpty == true) {
                if (objProductNew.flt_LenT2Neg != "" && objProductNew.flt_LenT2Neg != undefined) {
                    objLength.Length.T2Neg.oldValue = "NA";
                    objLength.Length.T2Neg.newValue = objProductNew.flt_LenT2Neg;
                    IsChanged = true;
                }
                else {
                    objLength.Length.T2Neg.oldValue = false;
                    objLength.Length.T2Neg.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param5_T2Neg === "" ||
                    objProductOld.Param5_T2Neg == this.strNullValue ||
                    objProductOld.Param5_T2Neg == undefined) {
                    objProductOld.Param5_T2Neg = null;
                }

                if (objProductNew.flt_LenT2Neg === "" ||
                    objProductNew.flt_LenT2Neg == this.strNullValue ||
                    objProductNew.flt_LenT2Neg == undefined) {
                    objProductNew.flt_LenT2Neg = null
                }
                if (parseFloat(objProductOld.Param5_T2Neg).toFixed(objProductOld.Param5_DP) == parseFloat(objProductNew.flt_LenT2Neg).toFixed(objProductNew.int_LenDp)) {
                    objLength.Length.T2Neg.oldValue = false;
                    objLength.Length.T2Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {

                    objLength.Length.T2Neg.oldValue = objProductOld.Param5_T2Neg != null  ? parseFloat(objProductOld.Param5_T2Neg).toFixed(objProductOld.Param5_DP) : 'NA';

                    objLength.Length.T2Neg.newValue = objProductNew.flt_LenT2Neg != null  ? parseFloat(objProductNew.flt_LenT2Neg).toFixed(objProductNew.int_LenDp) : 'NA';
                    IsChanged = true;
                }
            }

            /**
            * For Individual PosT2
            */
            if (OldEmpty == true) {
                if (objProductNew.flt_LenT2Pos != "" && objProductNew.flt_LenT2Pos != undefined) {
                    objLength.Length.T2Pos.oldValue = "NA";
                    objLength.Length.T2Pos.newValue = objProductNew.flt_LenT2Pos;
                    IsChanged = true;
                }
                else {
                    objLength.Length.T2Pos.oldValue = false;
                    objLength.Length.T2Pos.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param5_T2Pos === "" ||
                    objProductOld.Param5_T2Pos == this.strNullValue ||
                    objProductOld.Param5_T2Pos == undefined) {
                    objProductOld.Param5_T2Pos = null;
                }

                if (objProductNew.flt_LenT2Pos === "" ||
                    objProductNew.flt_LenT2Pos == this.strNullValue ||
                    objProductNew.flt_LenT2Pos == undefined) {
                    objProductNew.flt_LenT2Pos = null
                }
                if (parseFloat(objProductOld.Param5_T2Pos).toFixed(objProductOld.Param5_DP) == parseFloat(objProductNew.flt_LenT2Pos).toFixed(objProductNew.int_LenDp)) {
                    objLength.Length.T2Pos.oldValue = false;
                    objLength.Length.T2Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {

                    objLength.Length.T2Pos.oldValue = objProductOld.Param5_T2Pos != null ? parseFloat(objProductOld.Param5_T2Pos).toFixed(objProductOld.Param5_DP) : 'NA';

                    objLength.Length.T2Pos.newValue = objProductNew.flt_LenT2Pos != null  ? parseFloat(objProductNew.flt_LenT2Pos).toFixed(objProductNew.int_LenDp) : 'NA';
                    IsChanged = true;
                }
            }

            /**
            * For Individual NMT
            */
            if (OldEmpty == true) {
                if (objProductNew.int_LenNMTTabCnt != "" && objProductNew.int_LenNMTTabCnt != undefined) {
                    objLength.Length.NMT.oldValue = "NA";
                    objLength.Length.NMT.newValue = objProductNew.int_LenNMTTabCnt;
                    IsChanged = true;
                }
                else {
                    objLength.Length.NMT.oldValue = false;
                    objLength.Length.NMT.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param5_NMTTab == 0 ||
                    objProductOld.Param5_NMTTab == this.NMTValue ||
                    objProductOld.Param5_NMTTab == undefined) {
                    objProductOld.Param5_NMTTab = 0;
                }
                objProductNew.int_LenNMTTabCnt = objProductNew.int_LenNMTTabCnt == "" ? this.strNullValue : objProductNew.int_LenNMTTabCnt;
                if (objProductNew.int_LenNMTTabCnt == "0" ||
                    objProductNew.int_LenNMTTabCnt == this.NMTValue ||
                    objProductNew.int_LenNMTTabCnt == undefined) {
                    objProductNew.int_LenNMTTabCnt = 0
                }
                if (parseInt(objProductOld.Param5_NMTTab) == parseInt(objProductNew.int_LenNMTTabCnt)) {
                    objLength.Length.NMT.oldValue = false;
                    objLength.Length.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objLength.Length.NMT.oldValue = objProductOld.Param5_NMTTab;
                    objLength.Length.NMT.newValue = objProductNew.int_LenNMTTabCnt;
                    IsChanged = true;
                }
            }

            /**
             * For Individual Limits On Standard / Avg
             */
            // if (objProductOld.Param5_IsOnStd == objProductNew.str_LenGraphOn) {
            //     objLength.objLength.GraphOn.oldValue = false;
            //     objLength.objLength.GraphOn.newValue = false;
            //     IsChanged != true ? IsChanged = false : IsChanged=true;
            // }
            // else {
            //     objLength.objLength.GraphOn.oldValue = Param5_IsOnStd;
            //     objLength.objLength.GraphOn.newValue = str_LenGraphOn;
            //     IsChanged = true;
            // }

            if (OldEmpty) {
                if (objProductNew.str_verUnit != "" && objProductNew.flt_LenStd != "" && objProductNew.flt_LenStd != undefined) {
                    objLength.Length.Unit.oldValue = "NA";
                    objLength.Length.Unit.newValue = objProductNew.str_verUnit;
                    IsChanged = true;
                }
                else {
                    objLength.Length.Unit.oldValue = false;
                    objLength.Length.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param5_Unit == "NA" ? objProductOld.Param5_Unit = "mm" : objProductOld.Param5_Unit;
                if (objProductOld.Param5_Nom == null && objProductNew.flt_LenStd != null) { // new parameter added
                    objLength.Length.Unit.oldValue = "NA";
                    objLength.Length.Unit.newValue = objProductNew.str_verUnit;
                    IsChanged = true;
                }
                else if (objProductOld.Param5_Unit == null && objProductNew.str_verUnit == null) // no parameter added
                {
                    objLength.Length.Unit.oldValue = false;
                    objLength.Length.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param5_Unit == objProductNew.str_verUnit) {
                        objLength.Length.Unit.oldValue = false;
                        objLength.Length.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objLength.Length.Unit.oldValue = objProductOld.Param5_Unit;
                        objLength.Length.Unit.newValue = objProductNew.str_verUnit;
                        IsChanged = true;
                    }
                }
            }
            
            if (IsChanged == true) {
                Object.assign(this.objResult, objLength);
            }
            resolve(IsChanged);
        })
    }
    validateNet(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objNet = {
                Net: {
                    Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    // NMT: { oldValue: "", newValue: "" },
                    // LimitOn: { oldValue: "", newValue: "" },
                    // ReportOn: { oldValue: "", newValue: "" },
                    Unit: { oldValue: "", newValue: "" },
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Net Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_DiffNet != "" && objProductNew.flt_DiffNet != undefined) {
                    objNet.Net.Nom.oldValue = "NA";
                    objNet.Net.Nom.newValue = objProductNew.flt_DiffNet;
                    IsChanged = true;
                }
                else {
                    objNet.Net.Nom.oldValue = false;
                    objNet.Net.Nom.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param3_Nom === "" ||
                    objProductOld.Param3_Nom == this.strNullValue ||
                    objProductOld.Param3_Nom == undefined) {
                    objProductOld.Param3_Nom = null
                }

                if (objProductNew.flt_DiffNet === "" ||
                    objProductNew.flt_DiffNet == this.strNullValue) {
                    objProductNew.flt_DiffNet = null
                }

                if (parseFloat(objProductOld.Param3_Nom).toFixed(objProductOld.Param3_DP) ==
                    parseFloat(objProductNew.flt_DiffNet).toFixed(objProductNew.int_NetDp)) {
                    objNet.Net.Nom.oldValue = false;
                    objNet.Net.Nom.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (parseFloat(objProductOld.Param3_Nom).toFixed(objProductOld.Param3_DP) === "NaN")
                        objNet.Net.Nom.oldValue = "NA";
                    else {
                        objNet.Net.Nom.oldValue = parseFloat(objProductOld.Param3_Nom).toFixed(objProductOld.Param3_DP);
                    }
                    objNet.Net.Nom.newValue = objProductNew.flt_DiffNet;
                    IsChanged = true;
                }
            }

            /**
            * For Net NegT1
            */
            if (OldEmpty) {
                if (objProductNew.flt_DiffNetT1Neg != "" && objProductNew.flt_DiffNetT1Neg != undefined) {
                    objNet.Net.T1Neg.oldValue = "NA";
                    objNet.Net.T1Neg.newValue = objProductNew.flt_DiffNetT1Neg;
                    IsChanged = true;
                }
                else {

                    objNet.Net.T1Neg.oldValue = false;
                    objNet.Net.T1Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param3_T1Neg === "" ||
                    objProductOld.Param3_T1Neg == this.strNullValue ||
                    objProductOld.Param3_T1Neg == undefined) {

                    objProductOld.Param3_T1Neg = null;
                }
                if (objProductNew.flt_DiffNetT1Neg === "" ||
                    objProductNew.flt_DiffNetT1Neg == this.strNullValue ||
                    objProductNew.flt_DiffNetT1Neg == undefined) {
                    objProductNew.flt_DiffNetT1Neg = null;
                }

                if (parseFloat(objProductOld.Param3_T1Neg).toFixed(objProductOld.Param3_DP) == parseFloat(objProductNew.flt_DiffNetT1Neg).toFixed(objProductNew.int_NetDp)) {
                    objNet.Net.T1Neg.oldValue = false;
                    objNet.Net.T1Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param3_T1Neg).toFixed(objProductOld.Param3_DP) === "NaN") {
                        objNet.Net.T1Neg.oldValue = "NA";
                    }
                    else {
                        objNet.Net.T1Neg.oldValue = parseFloat(objProductOld.Param3_T1Neg).toFixed(objProductOld.Param3_DP);
                    }

                    objNet.Net.T1Neg.newValue = objProductNew.flt_DiffNetT1Neg;
                    IsChanged = true;
                }
            }

            /**
             * For Net PosT1
             */

            if (OldEmpty) {
                if (objProductNew.flt_DiffNetT1Pos != "" && objProductNew.flt_DiffNetT1Pos != undefined) {
                    objNet.Net.T1Pos.oldValue = "NA";
                    objNet.Net.T1Pos.newValue = objProductNew.flt_DiffNetT1Pos;
                    IsChanged = true;
                }
                else {
                    objNet.Net.T1Pos.oldValue = false;
                    objNet.Net.T1Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param3_T1Pos === "" ||
                    objProductOld.Param3_T1Pos == this.strNullValue ||
                    objProductOld.Param3_T1Pos == undefined) {
                    objProductOld.Param3_T1Pos = null;
                }

                if (objProductNew.flt_DiffNetT1Pos === "" ||
                    objProductNew.flt_DiffNetT1Pos == this.strNullValue ||
                    objProductNew.flt_DiffNetT1Pos == undefined) {
                    objProductNew.flt_DiffNetT1Pos = null
                }

                if (parseFloat(objProductOld.Param3_T1Pos).toFixed(objProductOld.Param3_DP) == parseFloat(objProductNew.flt_DiffNetT1Pos).toFixed(objProductNew.int_NetDp)) {
                    objNet.Net.T1Pos.oldValue = false;
                    objNet.Net.T1Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param3_T1Pos).toFixed(objProductOld.Param3_DP) === "NaN") {
                        objNet.Net.T1Pos.oldValue = "NA";
                    }
                    else {
                        objNet.Net.T1Pos.oldValue = parseFloat(objProductOld.Param3_T1Pos).toFixed(objProductOld.Param3_DP);
                    }
                    objNet.Net.T1Pos.newValue = objProductNew.flt_DiffNetT1Pos ? objProductNew.flt_DiffNetT1Pos : 'NA';
                    IsChanged = true;
                }
            }

            /**
            * For Net NegT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_DiffNetT2Neg != "" && objProductNew.flt_DiffNetT2Neg != undefined) {
                    objNet.Net.T2Neg.oldValue = "NA";
                    objNet.Net.T2Neg.newValue = objProductNew.flt_DiffNetT2Neg;
                    IsChanged = true;
                }
                else {
                    objNet.Net.T2Neg.oldValue = false;
                    objNet.Net.T2Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param3_T2Neg === "" ||
                    objProductOld.Param3_T2Neg == this.strNullValue ||
                    objProductOld.Param3_T2Neg == undefined) {
                    objProductOld.Param3_T2Neg = null;
                }

                if (objProductNew.flt_DiffNetT2Neg === "" ||
                    objProductNew.flt_DiffNetT2Neg == this.strNullValue ||
                    objProductNew.flt_DiffNetT2Neg == undefined) {
                    objProductNew.flt_DiffNetT2Neg = null
                }
                if (parseFloat(objProductOld.Param3_T2Neg).toFixed(objProductOld.Param3_DP) === parseFloat(objProductNew.flt_DiffNetT2Neg).toFixed(objProductNew.int_NetDp)) {
                    objNet.Net.T2Neg.oldValue = false;
                    objNet.Net.T2Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param3_T2Neg).toFixed(objProductOld.Param3_DP) === "NaN") {
                        objNet.Net.T2Neg.oldValue = "NA";
                    }
                    else {
                        objNet.Net.T2Neg.oldValue = parseFloat(objProductOld.Param3_T2Neg).toFixed(objProductOld.Param3_DP);
                    }

                    objNet.Net.T2Neg.newValue = objProductNew.flt_DiffNetT2Neg ? objProductNew.flt_DiffNetT2Neg : 'NA';
                    IsChanged = true;
                }
            }

            /**
            * For Net PosT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_DiffNetT2Pos != "" && objProductNew.flt_DiffNetT2Pos != undefined) {
                    objNet.Net.T2Pos.oldValue = "NA";
                    objNet.Net.T2Pos.newValue = objProductNew.flt_DiffNetT2Pos;
                    IsChanged = true;
                }
                else {
                    objNet.Net.T2Pos.oldValue = false;
                    objNet.Net.T2Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param3_T2Pos === "" ||
                    objProductOld.Param3_T2Pos == this.strNullValue ||
                    objProductOld.Param3_T2Pos == undefined) {
                    objProductOld.Param3_T2Pos = null;
                }

                if (objProductNew.flt_DiffNetT2Pos === "" ||
                    objProductNew.flt_DiffNetT2Pos == this.strNullValue ||
                    objProductNew.flt_DiffNetT2Pos == undefined) {
                    objProductNew.flt_DiffNetT2Pos = null
                }

                if (parseFloat(objProductOld.Param3_T2Pos).toFixed(objProductOld.Param3_DP) === parseFloat(objProductNew.flt_DiffNetT2Pos).toFixed(objProductNew.int_NetDp)) {
                    objNet.Net.T2Pos.oldValue = false;
                    objNet.Net.T2Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param3_T2Pos).toFixed(objProductOld.Param3_DP) === "NaN") {
                        objNet.Net.T2Pos.oldValue = "NA";
                    }
                    else {
                        objNet.Net.T2Pos.oldValue = parseFloat(objProductOld.Param3_T2Pos).toFixed(objProductOld.Param3_DP);
                    }
                    objNet.Net.T2Pos.newValue = objProductNew.flt_DiffNetT2Pos ? objProductNew.flt_DiffNetT2Pos : 'NA';
                    IsChanged = true;
                }
            }

            /**
            * For Net NMT
            */
            /*if (OldEmpty) {
                if (objProductNew.flt_DiffNetNMTCnt != "") {
                    objNet.Net.NMT.oldValue = "NA";
                    objNet.Net.NMT.newValue = objProductNew.flt_DiffNetNMTCnt;
                    IsChanged = true;
                }
                else {
                    objNet.Net.NMT.oldValue = false;
                    objNet.Net.NMT.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param3_NMTTab == 0 ||
                    objProductOld.Param3_NMTTab == this.NMTValue ||
                    objProductOld.Param3_NMTTab == undefined) {
                    objProductOld.Param3_NMTTab = 0;
                }
                objProductNew.flt_DiffNetNMTCnt = objProductNew.flt_DiffNetNMTCnt == "" ? this.strNullValue : objProductNew.flt_DiffNetNMTCnt;
                if (objProductNew.flt_DiffNetNMTCnt == "0" ||
                    objProductNew.flt_DiffNetNMTCnt == this.NMTValue ||
                    objProductNew.flt_DiffNetNMTCnt == undefined) {
                    objProductNew.flt_DiffNetNMTCnt = 0
                }

                if (parseInt(objProductOld.Param3_NMTTab) == parseInt(objProductNew.flt_DiffNetNMTCnt)) {
                    objNet.Net.NMT.oldValue = false;
                    objNet.Net.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objNet.Net.NMT.oldValue = objProductOld.Param3_NMTTab;
                    objNet.Net.NMT.newValue = objProductNew.flt_DiffNetNMTCnt;
                    IsChanged = true;
                }
            }
            objProductOld.Param3_NMTTab = objProductOld.Param3_NMTTab == ("" || this.NMTValue || undefined) ? null : objProductOld.Param3_NMTTab;
            objProductNew.int_IndNMTTabCnt = objProductNew.int_IndNMTTabCnt == ("" || undefined) ? null : objProductNew.int_IndNMTTabCnt;
            */


            /**
             * For Net Limits On Actual / Percent
             */
            /*if (OldEmpty) {
                if (objProductNew.flt_DiffNetLimitOn != "") {
                    objNet.Net.LimitOn.oldValue = "NA";
                    objNet.Net.LimitOn.newValue = objProductNew.flt_DiffNetLimitOn;
                    IsChanged = true;
                }
                else {
                    objNet.Net.LimitOn.oldValue = false;
                    objNet.Net.LimitOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strLimitOn = objProductOld.Param3_LimitOn.data[0] == 0 ? "Actual" : "Percentage";
                if (strLimitOn == objProductNew.flt_DiffNetLimitOn) {
                    objNet.Net.LimitOn.oldValue = false;
                    objNet.Net.LimitOn.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objNet.Net.LimitOn.oldValue = strLimitOn;
                    objNet.Net.LimitOn.newValue = objProductNew.flt_DiffNetLimitOn;
                    IsChanged = true;
                }
            }*/


            /**
             * For Net Limits On Standard / Avg
             */
            /*if (OldEmpty) {
                if (objProductNew.flt_DiffNetGraphOn != "") {
                    objNet.Net.ReportOn.oldValue = "NA";
                    objNet.Net.ReportOn.newValue = objProductNew.flt_DiffNetGraphOn;
                    IsChanged = true;
                }
                else {
                    objNet.Net.ReportOn.oldValue = false;
                    objNet.Net.ReportOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strGraphOn = objProductOld.Param3_IsOnStd == 0 ? "Standard" : "Average";
                if (strGraphOn == objProductNew.flt_DiffNetGraphOn) {
                    objNet.Net.ReportOn.oldValue = false;
                    objNet.Net.ReportOn.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objNet.Net.ReportOn.oldValue = strGraphOn;
                    objNet.Net.ReportOn.newValue = objProductNew.flt_DiffNetGraphOn;
                    IsChanged = true;
                }
            }
            */

            //unit
            if (OldEmpty) {
                if (objProductNew.str_indUnit != "" && objProductNew.flt_DiffNet != '' && objProductNew.flt_DiffNet != undefined) {
                    objNet.Net.Unit.oldValue = 'NA';
                    objNet.Net.Unit.newValue = objProductNew.str_indUnit;
                    IsChanged = true;
                }
                else {
                    objNet.Net.Unit.oldValue = false;
                    objNet.Net.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param3_Unit == "NA" ? objProductOld.Param3_Unit = "gm" : objProductOld.Param3_Unit;
                if (objProductOld.Param3_Nom == null && objProductNew.flt_DiffNet != null) { // new parameter added
                    objNet.Net.Unit.oldValue = "NA";
                    objNet.Net.Unit.newValue = objProductNew.str_indUnit;
                    IsChanged = true;
                }
                else if (objProductOld.Param3_Unit == null && objProductNew.str_indUnit == null) // no parameter added
                {
                    objNet.Net.Unit.oldValue = false;
                    objNet.Net.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param3_Unit == objProductNew.str_indUnit) {
                        objNet.Net.Unit.oldValue = false;
                        objNet.Net.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objNet.Net.Unit.oldValue = objProductOld.Param3_Unit;
                        objNet.Net.Unit.newValue = objProductNew.str_indUnit;
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objNet);
            }
            resolve(IsChanged);
        })


    }

    validateEmpty(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objEmpty = {
                Empty: {
                    Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    //LimitOn: { oldValue: "", newValue: "" },
                    ReportOn: { oldValue: "", newValue: "" },
                    // Nomenclature: { oldValue: "", newValue: "" },    
                    Unit: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Empty Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_Emptystd != "") {
                    objEmpty.Empty.Nom.oldValue = "NA";
                    objEmpty.Empty.Nom.newValue = objProductNew.flt_Emptystd;
                    IsChanged = true;
                }
                else {
                    objEmpty.Empty.Nom.oldValue = false;
                    objEmpty.Empty.Nom.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param0_Nom == "" ||
                    objProductOld.Param0_Nom == this.strNullValue ||
                    objProductOld.Param0_Nom == undefined) {
                    objProductOld.Param0_Nom = null
                }
                if (objProductNew.flt_Emptystd == "" ||
                    objProductNew.flt_Emptystd == this.strNullValue) {
                    objProductNew.flt_Emptystd = null
                }

                if (parseFloat(objProductOld.Param0_Nom).toFixed(objProductOld.Param0_DP) == parseFloat(objProductNew.flt_Emptystd).toFixed(objProductNew.int_EmptyDp)) {
                    objEmpty.Empty.Nom.oldValue = false;
                    objEmpty.Empty.Nom.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (parseFloat(objProductOld.Param0_Nom).toFixed(objProductOld.Param0_DP) === "NaN") {
                        objEmpty.Empty.Nom.oldValue = "NA";
                    }
                    else {
                        objEmpty.Empty.Nom.oldValue = parseFloat(objProductOld.Param0_Nom).toFixed(objProductOld.Param0_DP);
                    }

                    objEmpty.Empty.Nom.newValue = objProductNew.flt_Emptystd ? objProductNew.flt_Emptystd :'NA';
                    IsChanged = true;
                }
            }

            //objProductOld.Param0_Nom = objProductOld.Param0_Nom == ("" || this.nullValue || undefined) ? null : objProductOld.Param0_Nom;
            //objProductNew.flt_IndStd = objProductNew.flt_IndStd == ("" || undefined) ? null : objProductNew.flt_IndStd;




            /**
             * For Empty NegT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_EmptyT1Neg != "") {
                    objEmpty.Empty.T1Neg.oldValue = "NA";
                    objEmpty.Empty.T1Neg.newValue = objProductNew.flt_EmptyT1Neg;
                    IsChanged = true;
                }
                else {

                    objEmpty.Empty.T1Neg.oldValue = false;
                    objEmpty.Empty.T1Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param0_T1Neg == "" ||
                    objProductOld.Param0_T1Neg == this.strNullValue ||
                    objProductOld.Param0_T1Neg == undefined) {

                    objProductOld.Param0_T1Neg = null;
                }
                if (objProductNew.flt_EmptyT1Neg == "" || objProductNew.flt_EmptyT1Neg == this.strNullValue || objProductNew.flt_EmptyT1Neg == undefined) {
                    objProductNew.flt_EmptyT1Neg = null;
                }

                if (parseFloat(objProductOld.Param0_T1Neg).toFixed(objProductOld.Param0_DP) == parseFloat(objProductNew.flt_EmptyT1Neg).toFixed(objProductNew.int_EmptyDp)) {
                    objEmpty.Empty.T1Neg.oldValue = false;
                    objEmpty.Empty.T1Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param0_T1Neg).toFixed(objProductOld.Param0_DP) === "NaN") {
                        objEmpty.Empty.T1Neg.oldValue = "NA";
                    }
                    else {
                        objEmpty.Empty.T1Neg.oldValue = parseFloat(objProductOld.Param0_T1Neg).toFixed(objProductOld.Param0_DP);
                    }
                    objEmpty.Empty.T1Neg.newValue = objProductNew.flt_EmptyT1Neg ? objProductNew.flt_EmptyT1Neg : 'NA';
                    IsChanged = true;
                }
            }
            // objProductOld.Param0_T1Neg = objProductOld.Param0_T1Neg == ("" || this.nullValue || undefined) ? null : objProductOld.Param0_T1Neg;
            //objProductNew.flt_IndT1Neg = objProductNew.flt_IndT1Neg == ("" || undefined) ? null : objProductNew.flt_IndT1Neg;




            /**
             * For Empty PosT1
             */

            if (OldEmpty) {
                if (objProductNew.flt_EmptyT1Pos != "") {
                    objEmpty.Empty.T1Pos.oldValue = "NA";
                    objEmpty.Empty.T1Pos.newValue = objProductNew.flt_EmptyT1Pos;
                    IsChanged = true;
                }
                else {
                    objEmpty.Empty.T1Pos.oldValue = false;
                    objEmpty.Empty.T1Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param0_T1Pos == "" ||
                    objProductOld.Param0_T1Pos == this.strNullValue ||
                    objProductOld.Param0_T1Pos == undefined) {
                    objProductOld.Param0_T1Pos = null;
                }

                if (objProductNew.flt_EmptyT1Pos == "" ||
                    objProductNew.flt_EmptyT1Pos == this.strNullValue ||
                    objProductNew.flt_EmptyT1Pos == undefined) {
                    objProductNew.flt_EmptyT1Pos = null
                }

                if (parseFloat(objProductOld.Param0_T1Pos).toFixed(objProductOld.Param0_DP) == parseFloat(objProductNew.flt_EmptyT1Pos).toFixed(objProductNew.int_EmptyDp)) {
                    objEmpty.Empty.T1Pos.oldValue = false;
                    objEmpty.Empty.T1Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {

                    if (parseFloat(objProductOld.Param0_T1Pos).toFixed(objProductOld.Param0_DP) === "NaN") {
                        objEmpty.Empty.T1Pos.oldValue = "NA";
                    }
                    else {
                        objEmpty.Empty.T1Pos.oldValue = parseFloat(objProductOld.Param0_T1Pos).toFixed(objProductOld.Param0_DP);
                    }
                    objEmpty.Empty.T1Pos.newValue = objProductNew.flt_EmptyT1Pos ? objProductNew.flt_EmptyT1Pos : 'NA';
                    IsChanged = true;
                }
            }
            //objProductOld.Param0_T1Pos = objProductOld.Param0_T1Pos == ("" || this.nullValue || undefined) ? null : objProductOld.Param0_T1Pos;
            //objProductNew.flt_IndT1Pos = objProductNew.flt_IndT1Pos == ("" || undefined) ? null : objProductNew.flt_IndT1Pos;



            /**
            * For Empty NegT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_EmptyT2Neg != "") {
                    objEmpty.Empty.T2Neg.oldValue = "NA";
                    objEmpty.Empty.T2Neg.newValue = objProductNew.flt_EmptyT2Neg;
                    IsChanged = true;
                }
                else {
                    objEmpty.Empty.T2Neg.oldValue = false;
                    objEmpty.Empty.T2Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param0_T2Neg == "" ||
                    objProductOld.Param0_T2Neg == this.strNullValue ||
                    objProductOld.Param0_T2Neg == undefined) {
                    objProductOld.Param0_T2Neg = null;
                }

                if (objProductNew.flt_EmptyT2Neg == "" ||
                    objProductNew.flt_EmptyT2Neg == this.strNullValue ||
                    objProductNew.flt_EmptyT2Neg == undefined) {
                    objProductNew.flt_EmptyT2Neg = null
                }
                if (parseFloat(objProductOld.Param0_T2Neg).toFixed(objProductOld.Param0_DP) == parseFloat(objProductNew.flt_EmptyT2Neg).toFixed(objProductNew.int_EmptyDp)) {
                    objEmpty.Empty.T2Neg.oldValue = false;
                    objEmpty.Empty.T2Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param0_T2Neg).toFixed(objProductOld.Param0_DP) === "NaN") {
                        objEmpty.Empty.T2Neg.oldValue = "Na";
                    }
                    else {
                        objEmpty.Empty.T2Neg.oldValue = parseFloat(objProductOld.Param0_T2Neg).toFixed(objProductOld.Param0_DP);
                    }

                    objEmpty.Empty.T2Neg.newValue = objProductNew.flt_EmptyT2Neg ? objProductNew.flt_EmptyT2Neg : 'NA';
                    IsChanged = true;
                }
            }
            // objProductOld.Param0_T2Neg = objProductOld.Param0_T2Neg == ("" || this.nullValue || undefined) ? null : objProductOld.Param0_T2Neg;
            // objProductNew.flt_IndT2Neg = objProductNew.flt_IndT2Neg == ("" || undefined) ? null : objProductNew.flt_IndT2Neg;




            /**
            * For Empty PosT2
            */
            if (OldEmpty) {
                if (objProductNew.flt_EmptyT2Pos != "") {
                    objEmpty.Empty.T2Pos.oldValue = "NA";
                    objEmpty.Empty.T2Pos.newValue = objProductNew.flt_EmptyT2Pos;
                    IsChanged = true;
                }
                else {
                    objEmpty.Empty.T2Pos.oldValue = false;
                    objEmpty.Empty.T2Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param0_T2Pos == "" ||
                    objProductOld.Param0_T2Pos == this.strNullValue ||
                    objProductOld.Param0_T2Pos == undefined) {
                    objProductOld.Param0_T2Pos = null;
                }

                if (objProductNew.flt_EmptyT2Pos == "" ||
                    objProductNew.flt_EmptyT2Pos == this.strNullValue ||
                    objProductNew.flt_EmptyT2Pos == undefined) {
                    objProductNew.flt_EmptyT2Pos = null
                }
                if (parseFloat(objProductOld.Param0_T2Pos).toFixed(objProductOld.Param0_DP) == parseFloat(objProductNew.flt_EmptyT2Pos).toFixed(objProductNew.int_EmptyDp)) {
                    objEmpty.Empty.T2Pos.oldValue = false;
                    objEmpty.Empty.T2Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param0_T2Pos).toFixed(objProductOld.Param0_DP) === "NaN") {
                        objEmpty.Empty.T2Pos.oldValue = "NA";
                    }
                    else {
                        objEmpty.Empty.T2Pos.oldValue = parseFloat(objProductOld.Param0_T2Pos).toFixed(objProductOld.Param0_DP);
                    }
                    objEmpty.Empty.T2Pos.newValue = objProductNew.flt_EmptyT2Pos ? objProductNew.flt_EmptyT2Pos : 'NA';
                    IsChanged = true;
                }
            }
            // objProductOld.Param0_T2Pos = objProductOld.Param0_T2Pos == ("" || this.nullValue || undefined) ? null : objProductOld.Param0_T2Pos;
            // objProductNew.flt_IndT2Pos = objProductNew.flt_IndT2Pos == ("" || undefined) ? null : objProductNew.flt_IndT2Pos;



            /**
            * For Empty NMT
            */
            if (OldEmpty) {
                if (objProductNew.flt_EmptyNMTCnt != "") {
                    objEmpty.Empty.NMT.oldValue = "NA";
                    objEmpty.Empty.NMT.newValue = objProductNew.flt_EmptyNMTCnt;
                    IsChanged = true;
                }
                else {
                    objEmpty.Empty.NMT.oldValue = false;
                    objEmpty.Empty.NMT.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param0_NMTTab == 0 ||
                    objProductOld.Param0_NMTTab == this.NMTValue ||
                    objProductOld.Param0_NMTTab == undefined) {
                    objProductOld.Param0_NMTTab = 0;
                }
                objProductNew.flt_EmptyNMTCnt = objProductNew.flt_EmptyNMTCnt == "" ? this.strNullValue : objProductNew.flt_EmptyNMTCnt;
                if (objProductNew.flt_EmptyNMTCnt == "0" ||
                    objProductNew.flt_EmptyNMTCnt == this.NMTValue ||
                    objProductNew.flt_EmptyNMTCnt == undefined) {
                    objProductNew.flt_EmptyNMTCnt = 0
                }

                if (parseInt(objProductOld.Param0_NMTTab) == parseInt(objProductNew.flt_EmptyNMTCnt)) {
                    objEmpty.Empty.NMT.oldValue = false;
                    objEmpty.Empty.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objEmpty.Empty.NMT.oldValue = objProductOld.Param0_NMTTab;
                    objEmpty.Empty.NMT.newValue = objProductNew.flt_EmptyNMTCnt;
                    IsChanged = true;
                }
            }
            // objProductOld.Param0_NMTTab = objProductOld.Param0_NMTTab == ("" || this.NMTValue || undefined) ? null : objProductOld.Param0_NMTTab;
            // objProductNew.int_IndNMTTabCnt = objProductNew.int_IndNMTTabCnt == ("" || undefined) ? null : objProductNew.int_IndNMTTabCnt;



            /**
             * For Empty Limits On Actual / Percent
             */
            /*if (OldEmpty) {
                if (objProductNew.flt_EmptyLimitOn != "") {
                    objEmpty.Empty.LimitOn.oldValue = "NA";
                    objEmpty.Empty.LimitOn.newValue = objProductNew.flt_EmptyLimitOn;
                    IsChanged = true;
                }
                else {
                    objEmpty.Empty.LimitOn.oldValue = false;
                    objEmpty.Empty.LimitOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strLimitOn = objProductOld.Param0_LimitOn.data[0] == 0 ? "Actual" : "Percentage";
                if (strLimitOn == objProductNew.flt_EmptyLimitOn) {
                    objEmpty.Empty.LimitOn.oldValue = false;
                    objEmpty.Empty.LimitOn.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objEmpty.Empty.LimitOn.oldValue = strLimitOn;
                    objEmpty.Empty.LimitOn.newValue = objProductNew.flt_EmptyLimitOn;
                    IsChanged = true;
                }
            }*/


            /**
             * For Empty Limits On Standard / Avg
             */
            if (OldEmpty) {
                if (objProductNew.flt_EmptyGraphOn != "" && objProductNew.flt_Emptystd !='') {
                    objEmpty.Empty.ReportOn.oldValue = "NA";
                    objEmpty.Empty.ReportOn.newValue = objProductNew.flt_EmptyGraphOn;
                    IsChanged = true;
                }
                else {
                    objEmpty.Empty.ReportOn.oldValue = false;
                    objEmpty.Empty.ReportOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strGraphOn = objProductOld.Param0_IsOnStd == 0 ? "Standard" : "Average";
                if (strGraphOn == objProductNew.flt_EmptyGraphOn) {
                    objEmpty.Empty.ReportOn.oldValue = false;
                    objEmpty.Empty.ReportOn.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objEmpty.Empty.ReportOn.oldValue = strGraphOn;
                    objEmpty.Empty.ReportOn.newValue = objProductNew.flt_EmptyGraphOn;
                    IsChanged = true;
                }
            }


            //unit
            if (OldEmpty) {
                if (objProductNew.str_indUnit != ""  && objProductNew.flt_Emptystd !='') {
                    objEmpty.Empty.Unit.oldValue = 'NA';
                    objEmpty.Empty.Unit.newValue = objProductNew.str_indUnit;
                    IsChanged = true;
                }
                else {
                    objEmpty.Empty.Unit.oldValue = false;
                    objEmpty.Empty.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param0_Unit == "NA" ? objProductOld.Param0_Unit = "gm" : objProductOld.Param0_Unit;
                if (objProductOld.Param0_Nom == null && objProductNew.flt_Emptystd != null) { // new parameter added
                    objEmpty.Empty.Unit.oldValue = "NA";
                    objEmpty.Empty.Unit.newValue = objProductNew.str_indUnit;
                    IsChanged = true;
                }
                else if (objProductOld.Param0_Unit == null  && objProductNew.str_indUnit == null) // no parameter added
                {
                    objEmpty.Empty.Unit.oldValue = false;
                    objEmpty.Empty.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param0_Unit == objProductNew.str_indUnit) {
                        objEmpty.Empty.Unit.oldValue = false;
                        objEmpty.Empty.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objEmpty.Empty.Unit.oldValue = objProductOld.Param0_Unit;
                        objEmpty.Empty.Unit.newValue = objProductNew.str_indUnit;
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objEmpty);
            }
            resolve(IsChanged);
        })


    }

    validateDTCapsule(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objDT = {
                DT: {
                    DTTime: { oldValue: "", newValue: "" },
                    DTMinTemp: { oldValue: "", newValue: "" },
                    DTMaxTemp: { oldValue: "", newValue: "" }
                }
            };
            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.int_DTMMTime != "" && objProductNew.int_DTMMTime != undefined) {
                    objDT.DT.DTTime.oldValue = "NA";
                    objDT.DT.DTTime.newValue = objProductNew.int_DTHHTime + ":" + objProductNew.int_DTMMTime + ":" + objProductNew.int_DTSSTime;
                    IsChanged = true;
                }
                else {
                    objDT.DT.DTTime.oldValue = false;
                    objDT.DT.DTTime.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param6_Nom === "" ||
                    objProductOld.Param6_Nom == this.strNullValue ||
                    objProductOld.Param6_Nom == undefined) {
                    objProductOld.Param6_Nom = null;
                }

                if (objProductNew.int_DTHHTime === "" ||
                    objProductNew.int_DTHHTime == this.strNullValue ||
                    objProductNew.int_DTHHTime == undefined) {
                    objProductNew.int_DTHHTime = null;
                }

                if (objProductNew.int_DTMMTime === "" ||
                    objProductNew.int_DTMMTime == this.strNullValue ||
                    objProductNew.int_DTMMTime == undefined) {
                    objProductNew.int_DTMMTime = null;
                }

                if (objProductNew.int_DTSSTime === "" ||
                    objProductNew.int_DTSSTime == this.strNullValue ||
                    objProductNew.int_DTSSTime == undefined) {
                    objProductNew.int_DTSSTime = null;
                }
                if (objProductOld.Param6_Nom == (objProductNew.int_DTHHTime + ":" + objProductNew.int_DTMMTime + ":" + objProductNew.int_DTSSTime)) {
                    objDT.DT.DTTime.oldValue = false;
                    objDT.DT.DTTime.newValue = false;
                    IsChanged = false;
                }
                else {
                    objDT.DT.DTTime.oldValue = objProductOld.Param6_Nom;
                    objDT.DT.DTTime.newValue = objProductNew.int_DTHHTime + ":" + objProductNew.int_DTMMTime + ":" + objProductNew.int_DTSSTime;
                    IsChanged = true;
                }
            }

            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_DTMinTemp != "" && objProductNew.flt_DTMinTemp != undefined) {
                    objDT.DT.DTMinTemp.oldValue = "NA";
                    objDT.DT.DTMinTemp.newValue = objProductNew.flt_DTMinTemp;
                    IsChanged = true;
                }
                else {
                    objDT.DT.DTMinTemp.oldValue = false;
                    objDT.DT.DTMinTemp.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param6_T1Neg === "" ||
                    objProductOld.Param6_T1Neg == this.strNullValue ||
                    objProductOld.Param6_T1Neg == undefined) {
                    objProductOld.Param6_T1Neg = null;
                }

                if (objProductNew.flt_DTMinTemp === "" ||
                    objProductNew.flt_DTMinTemp == this.strNullValue ||
                    objProductNew.flt_DTMinTemp == undefined) {
                    objProductNew.flt_DTMinTemp = null
                }
                if (parseFloat(objProductOld.Param6_T1Neg).toFixed(objProductOld.Param6_DP) == parseFloat(objProductNew.flt_DTMinTemp).toFixed(objProductNew.int_DTDp)) {
                    objDT.DT.DTMinTemp.oldValue = false;
                    objDT.DT.DTMinTemp.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param6_T1Neg).toFixed(objProductOld.Param6_DP) === "NaN") {
                        objDT.DT.DTMinTemp.oldValue = "NA";
                    }
                    else {
                        objDT.DT.DTMinTemp.oldValue = parseFloat(objProductOld.Param6_T1Neg).toFixed(objProductOld.Param6_DP);
                    }

                    objDT.DT.DTMinTemp.newValue = objProductNew.flt_DTMinTemp;
                    IsChanged = true;
                }
            }

            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_DTMaxTemp != "" && objProductNew.flt_DTMaxTemp != undefined) {
                    objDT.DT.DTMaxTemp.oldValue = "NA";
                    objDT.DT.DTMaxTemp.newValue = objProductNew.flt_DTMaxTemp;
                    IsChanged = true;
                }
                else {
                    objDT.DT.DTMaxTemp.oldValue = false;
                    objDT.DT.DTMaxTemp.newValue = false;
                    IsChanged = false;
                }

            }
            else {
                if (objProductOld.Param6_T1Pos === "" ||
                    objProductOld.Param6_T1Pos == this.strNullValue ||
                    objProductOld.Param6_T1Pos == undefined) {
                    objProductOld.Param6_T1Pos = null;
                }

                if (objProductNew.flt_DTMaxTemp === "" ||
                    objProductNew.flt_DTMaxTemp == this.strNullValue ||
                    objProductNew.flt_DTMaxTemp == undefined) {
                    objProductNew.flt_DTMaxTemp = null
                }
                if (parseFloat(objProductOld.Param6_T1Pos).toFixed(objProductOld.Param6_DP) == parseFloat(objProductNew.flt_DTMaxTemp).toFixed(objProductNew.int_DTDp)) {
                    objDT.DT.DTMaxTemp.oldValue = false;
                    objDT.DT.DTMaxTemp.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param6_T1Pos).toFixed(objProductOld.Param6_DP) === "NaN") {
                        objDT.DT.DTMaxTemp.oldValue = "NA";
                    }
                    else {
                        objDT.DT.DTMaxTemp.oldValue = parseFloat(objProductOld.Param6_T1Pos).toFixed(objProductOld.Param6_DP);
                    }
                    objDT.DT.DTMaxTemp.newValue = objProductNew.flt_DTMaxTemp;
                    IsChanged = true;
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objDT);
            }
            resolve(IsChanged);
        })
    }

    validateDiameterCapsule(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const newValueDP = objProductNew.int_DiaDp;

            const objDiameter = {
                Diameter: {
                    Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    GraphOn: { oldValue: "", newValue: "" }
                }
            };
            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_DiaStd != "") {
                    objDiameter.Diameter.Nom.oldValue = "NA";
                    objDiameter.Diameter.Nom.newValue = objProductNew.flt_DiaStd;
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter.Nom.oldValue = false;
                    objDiameter.Diameter.Nom.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param4_Nom == "" ||
                    objProductOld.Param4_Nom == this.strNullValue ||
                    objProductOld.Param4_Nom == undefined) {
                    objProductOld.Param4_Nom = null;
                }

                if (objProductNew.flt_DiaStd == "" ||
                    objProductNew.flt_DiaStd == this.strNullValue ||
                    objProductNew.flt_DiaStd == undefined) {
                    objProductNew.flt_DiaStd = null
                }
                if (parseFloat(objProductOld.Param4_Nom).toFixed(objProductOld.Param4_DP) == parseFloat(objProductNew.flt_DiaStd).toFixed(newValueDP)) {
                    objDiameter.Diameter.Nom.oldValue = false;
                    objDiameter.Diameter.Nom.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (parseFloat(objProductOld.Param4_Nom).toFixed(2) === "NaN") {
                        objDiameter.Diameter.Nom.oldValue = "NA";
                    }
                    else {
                        objDiameter.Diameter.Nom.oldValue = parseFloat(objProductOld.Param4_Nom).toFixed(objProductOld.Param4_DP);
                    }

                    objDiameter.Diameter.Nom.newValue = objProductNew.flt_DiaStd ? parseFloat(objProductNew.flt_DiaStd).toFixed(newValueDP) : 'NA';
                    IsChanged = true;
                }
            }
            // objProductOld.Param4_Nom = (objProductOld.Param4_Nom == "" || this.nullValue || undefined) ? null : objProductOld.Param4_Nom;
            // objProductNew.flt_DiaStd = (objProductNew.flt_DiaStd == "" || undefined) ? null : objProductNew.flt_DiaStd;




            /**
             * For Individual NegT1
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_DiaT1Neg != "") {
                    objDiameter.Diameter.T1Neg.oldValue = "NA";
                    objDiameter.Diameter.T1Neg.newValue = objProductNew.flt_DiaT1Neg;
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter.T1Neg.oldValue = false;
                    objDiameter.Diameter.T1Neg.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param4_T1Neg == "" ||
                    objProductOld.Param4_T1Neg == this.strNullValue ||
                    objProductOld.Param4_T1Neg == undefined) {
                    objProductOld.Param4_T1Neg = null;
                }

                if (objProductNew.flt_DiaT1Neg == "" ||
                    objProductNew.flt_DiaT1Neg == this.strNullValue ||
                    objProductNew.flt_DiaT1Neg == undefined) {
                    objProductNew.flt_DiaT1Neg = null
                }
                if (parseFloat(objProductOld.Param4_T1Neg).toFixed(objProductOld.Param4_DP) == parseFloat(objProductNew.flt_DiaT1Neg).toFixed(newValueDP)) {
                    objDiameter.Diameter.T1Neg.oldValue = false;
                    objDiameter.Diameter.T1Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param4_T1Neg).toFixed(2) === "NaN") {
                        objDiameter.Diameter.T1Neg.oldValue = "NA";
                    }
                    else {
                        objDiameter.Diameter.T1Neg.oldValue = parseFloat(objProductOld.Param4_T1Neg).toFixed(objProductOld.Param4_DP);
                    }
                    objDiameter.Diameter.T1Neg.newValue = objProductNew.flt_DiaT1Neg ? parseFloat(objProductNew.flt_DiaT1Neg).toFixed(newValueDP) : 'NA';
                    IsChanged = true;
                }
            }
            // objProductOld.Param4_T1Neg = (objProductOld.Param4_T1Neg == "" || this.nullValue || undefined) ? null : objProductOld.Param4_T1Neg;
            // objProductNew.flt_DiaT1Neg = (objProductNew.flt_DiaT1Neg == "" || undefined) ? null : objProductNew.flt_DiaT1Neg;



            /**
             * For Individual PosT1
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_DiaT1Pos != "") {
                    objDiameter.Diameter.T1Pos.oldValue = "NA";
                    objDiameter.Diameter.T1Pos.newValue = objProductNew.flt_DiaT1Pos;
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter.T1Pos.oldValue = false;
                    objDiameter.Diameter.T1Pos.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param4_T1Pos == "" ||
                    objProductOld.Param4_T1Pos == this.strNullValue ||
                    objProductOld.Param4_T1Pos == undefined) {
                    objProductOld.Param4_T1Pos = null;
                }

                if (objProductNew.flt_DiaT1Pos == "" ||
                    objProductNew.flt_DiaT1Pos == this.strNullValue ||
                    objProductNew.flt_DiaT1Pos == undefined) {
                    objProductNew.flt_DiaT1Pos = null
                }
                if (parseFloat(objProductOld.Param4_T1Pos).toFixed(objProductOld.Param4_DP) == parseFloat(objProductNew.flt_DiaT1Pos).toFixed(newValueDP)) {
                    objDiameter.Diameter.T1Pos.oldValue = false;
                    objDiameter.Diameter.T1Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param4_T1Pos).toFixed(objProductOld.Param4_DP) === "NaN") {
                        objDiameter.Diameter.T1Pos.oldValue = "NA";
                    }
                    else {
                        objDiameter.Diameter.T1Pos.oldValue = parseFloat(objProductOld.Param4_T1Pos).toFixed(newValueDP);
                    }
                    objDiameter.Diameter.T1Pos.newValue = objProductNew.flt_DiaT1Pos ? parseFloat(objProductNew.flt_DiaT1Pos).toFixed(newValueDP) : 'NA';
                    IsChanged = true;
                }
            }
            // objProductOld.Param4_T1Pos = (objProductOld.Param4_T1Pos == "" || this.nullValue || undefined) ? null : objProductOld.Param4_T1Pos;
            // objProductNew.flt_DiaT1Pos = (objProductNew.flt_DiaT1Pos == "" || undefined) ? null : objProductNew.flt_DiaT1Pos;


            /**
            * For Individual NegT2
            */
            if (OldEmpty == true) {
                if (objProductNew.flt_DiaT2Neg != "") {
                    objDiameter.Diameter.T2Neg.oldValue = "NA";
                    objDiameter.Diameter.T2Neg.newValue = objProductNew.flt_DiaT2Neg;
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter.T2Neg.oldValue = false;
                    objDiameter.Diameter.T2Neg.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param4_T2Neg == "" ||
                    objProductOld.Param4_T2Neg == this.strNullValue ||
                    objProductOld.Param4_T2Neg == undefined) {
                    objProductOld.Param4_T2Neg = null;
                }

                if (objProductNew.flt_DiaT2Neg == "" ||
                    objProductNew.flt_DiaT2Neg == this.strNullValue ||
                    objProductNew.flt_DiaT2Neg == undefined) {
                    objProductNew.flt_DiaT2Neg = null
                }
                if (parseFloat(objProductOld.Param4_T2Neg).toFixed(objProductOld.Param4_DP) == parseFloat(objProductNew.flt_DiaT2Neg).toFixed(newValueDP)) {
                    objDiameter.Diameter.T2Neg.oldValue = false;
                    objDiameter.Diameter.T2Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param4_T2Neg).toFixed(2) === "NaN") {
                        objDiameter.Diameter.T2Neg.oldValue = "NA";
                    } else {
                        objDiameter.Diameter.T2Neg.oldValue = parseFloat(objProductOld.Param4_T2Neg).toFixed(newValueDP);
                    }
                    objDiameter.Diameter.T2Neg.newValue = objProductNew.flt_DiaT2Neg ? parseFloat(objProductNew.flt_DiaT2Neg).toFixed(newValueDP) : 'NA';
                    IsChanged = true;
                }
            }
            // objProductOld.Param4_T2Neg = (objProductOld.Param4_T2Neg == "" || this.nullValue || undefined) ? null : objProductOld.Param4_T2Neg;
            // objProductNew.flt_DiaT2Neg = (objProductNew.flt_DiaT2Neg == "" || undefined) ? null : objProductNew.flt_DiaT2Neg;



            /**
            * For Individual PosT2
            */
            if (OldEmpty == true) {
                if (objProductNew.flt_DiaT2Pos != "") {
                    objDiameter.Diameter.T2Pos.oldValue = "NA";
                    objDiameter.Diameter.T2Pos.newValue = objProductNew.flt_DiaT2Pos;
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter.T2Pos.oldValue = false;
                    objDiameter.Diameter.T2Pos.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param4_T2Pos == "" ||
                    objProductOld.Param4_T2Pos == this.strNullValue ||
                    objProductOld.Param4_T2Pos == undefined) {
                    objProductOld.Param4_T2Pos = null;
                }

                if (objProductNew.flt_DiaT2Pos == "" ||
                    objProductNew.flt_DiaT2Pos == this.strNullValue ||
                    objProductNew.flt_DiaT2Pos == undefined) {
                    objProductNew.flt_DiaT2Pos = null
                }
                if (parseFloat(objProductOld.Param4_T2Pos).toFixed(objProductOld.Param4_DP) == parseFloat(objProductNew.flt_DiaT2Pos).toFixed(newValueDP)) {
                    objDiameter.Diameter.T2Pos.oldValue = false;
                    objDiameter.Diameter.T2Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param4_T2Pos).toFixed(2) === "NaN") {
                        objDiameter.Diameter.T2Pos.oldValue = "NA";
                    }
                    else {
                        objDiameter.Diameter.T2Pos.oldValue = parseFloat(objProductOld.Param4_T2Pos).toFixed(objProductOld.Param4_DP);
                    }

                    objDiameter.Diameter.T2Pos.newValue = objProductNew.flt_DiaT2Pos ? parseFloat(objProductNew.flt_DiaT2Pos).toFixed(newValueDP) : 'NA';
                    IsChanged = true;
                }
            }
            // objProductOld.Param4_T2Pos = (objProductOld.Param4_T2Pos == "" || this.nullValue || undefined) ? null : objProductOld.Param4_T2Pos;
            // objProductNew.flt_DiaT2Pos = (objProductNew.flt_DiaT2Pos == "" || undefined) ? null : objProductNew.flt_DiaT2Pos;


            /**
            * For Individual NMT
            */
            if (OldEmpty == true) {
                if (objProductNew.int_DiaNMTTabCnt != "") {
                    objDiameter.Diameter.NMT.oldValue = "NA";
                    objDiameter.Diameter.NMT.newValue = objProductNew.int_DiaNMTTabCnt;
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter.NMT.oldValue = false;
                    objDiameter.Diameter.NMT.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param4_NMTTab == 0 ||
                    objProductOld.Param4_NMTTab == this.NMTValue ||
                    objProductOld.Param4_NMTTab == undefined) {
                    objProductOld.Param4_NMTTab = 0;
                }
                objProductNew.int_DiaNMTTabCnt = objProductNew.int_DiaNMTTabCnt == "" ? this.strNullValue : objProductNew.int_DiaNMTTabCnt;
                if (objProductNew.int_DiaNMTTabCnt == "0" ||
                    objProductNew.int_DiaNMTTabCnt == this.NMTValue ||
                    objProductNew.int_DiaNMTTabCnt == undefined) {
                    objProductNew.int_DiaNMTTabCnt = 0
                }
                if (parseInt(objProductOld.Param4_NMTTab) == parseInt(objProductNew.int_DiaNMTTabCnt)) {
                    objDiameter.Diameter.NMT.oldValue = false;
                    objDiameter.Diameter.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objDiameter.Diameter.NMT.oldValue = objProductOld.Param4_NMTTab;
                    objDiameter.Diameter.NMT.newValue = objProductNew.int_DiaNMTTabCnt;
                    IsChanged = true;
                }
            }
            // objProductOld.Param4_NMTTab = (objProductOld.Param4_NMTTab == "" || this.NMTValue || undefined) ? null : objProductOld.Param4_NMTTab;
            // objProductNew.int_DiaNMTTabCnt = (objProductNew.int_DiaNMTTabCnt == "" || undefined) ? null : objProductNew.int_DiaNMTTabCnt;



            /**
             * For Individual Limits On Standard / Avg
             */
            // if (objProductOld.Param4_IsOnStd == objProductNew.str_DiaGraphOn) {
            //     objDiameter.Diameter.GraphOn.oldValue = false;
            //     objDiameter.Diameter.GraphOn.newValue = false;
            //     IsChanged != true ? IsChanged = false : IsChanged=true;
            // }
            // else {
            //     objDiameter.Diameter.GraphOn.oldValue = Param4_IsOnStd;
            //     objDiameter.Diameter.GraphOn.newValue = str_DiaGraphOn;
            //     IsChanged = true;
            // }
            if (IsChanged == true) {
                Object.assign(this.objResult, objDiameter);
            }
            resolve(IsChanged);
        })
    }

    validateContent1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objContent1 = {
                Content1: {
                    Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    //LimitOn: { oldValue: "", newValue: "" },
                    ReportOn: { oldValue: "", newValue: "" },
                    Content1Type: { oldValue: "", newValue: "" },
                    Content1Name: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
            var OldContent1 = objProductOld == undefined ? true : false;
            /**
             * For Content1 Nom
             */
            if (OldContent1 == true) {
                if (objProductNew.flt_Content1Std != "") {
                    objContent1.Content1.Nom.oldValue = "NA";
                    objContent1.Content1.Nom.newValue = objProductNew.flt_Content1Std;
                    IsChanged = true;
                }
                else {
                    objContent1.Content1.Nom.oldValue = false;
                    objContent1.Content1.Nom.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param9_Nom == "" ||
                    objProductOld.Param9_Nom == this.strNullValue ||
                    objProductOld.Param9_Nom == undefined) {
                    objProductOld.Param9_Nom = null
                }
    
                if (objProductNew.flt_Content1Std == "" ||
                    objProductNew.flt_Content1Std == this.strNullValue) {
                    objProductNew.flt_Content1Std = null
                }
    
                if (parseFloat(objProductOld.Param9_Nom).toFixed(objProductOld.Param9_DP) ==
                    parseFloat(objProductNew.flt_Content1Std).toFixed(objProductNew.int_Content1DP)) {
                        objContent1.Content1.Nom.oldValue = false;
                        objContent1.Content1.Nom.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (parseFloat(objProductOld.Param9_Nom).toFixed(objProductOld.Param9_DP) === "NaN")
                        objContent1.Content1.Nom.oldValue = "NA";
                    else {
                        objContent1.Content1.Nom.oldValue = parseFloat(objProductOld.Param9_Nom).toFixed(objProductOld.Param9_DP);
                    }
                    objContent1.Content1.Nom.newValue = objProductNew.flt_Content1Std ? objProductNew.flt_Content1Std  : 'NA';
                    IsChanged = true;
                }
            }
    
            if (OldContent1) {
                if (objProductNew.flt_Content1T1Neg != "") {
                    objContent1.Content1.T1Neg.oldValue = "NA";
                    objContent1.Content1.T1Neg.newValue = objProductNew.flt_Content1T1Neg;
                    IsChanged = true;
                }
                else {
    
                    objContent1.Content1.T1Neg.oldValue = false;
                    objContent1.Content1.T1Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param9_T1Neg == "" ||
                    objProductOld.Param9_T1Neg == this.strNullValue ||
                    objProductOld.Param9_T1Neg == undefined) {
    
                    objProductOld.Param9_T1Neg = null;
                }
                if (objProductNew.flt_Content1T1Neg == "" ||
                    objProductNew.flt_Content1T1Neg == this.strNullValue ||
                    objProductNew.flt_Content1T1Neg == undefined) {
                    objProductNew.flt_Content1T1Neg = null;
                }
    
                if (parseFloat(objProductOld.Param9_T1Neg).toFixed(objProductOld.Param9_DP) == parseFloat(objProductNew.flt_Content1T1Neg).toFixed(objProductNew.int_Content1DP)) {
                    objContent1.Content1.T1Neg.oldValue = false;
                    objContent1.Content1.T1Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param9_T1Neg).toFixed(objProductOld.Param9_DP) === "NaN") {
                        objContent1.Content1.T1Neg.oldValue = "NA";
                    }
                    else {
                        objContent1.Content1.T1Neg.oldValue = parseFloat(objProductOld.Param9_T1Neg).toFixed(objProductOld.Param9_DP);
                    }
    
    
                    objContent1.Content1.T1Neg.newValue = objProductNew.flt_Content1T1Neg ? objProductNew.flt_Content1T1Neg : 'NA';
                    IsChanged = true;
                }
            }
        
    
            if (OldContent1) {
                if (objProductNew.flt_Content1T1Pos != "") {
                    objContent1.Content1.T1Pos.oldValue = "NA";
                    objContent1.Content1.T1Pos.newValue = objProductNew.flt_Content1T1Pos;
                    IsChanged = true;
                }
                else {
                    objContent1.Content1.T1Pos.oldValue = false;
                    objContent1.Content1.T1Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param9_T1Pos == "" ||
                    objProductOld.Param9_T1Pos == this.strNullValue ||
                    objProductOld.Param9_T1Pos == undefined) {
                    objProductOld.Param9_T1Pos = null;
                }
    
                if (objProductNew.flt_Content1T1Pos == "" ||
                    objProductNew.flt_Content1T1Pos == this.strNullValue ||
                    objProductNew.flt_Content1T1Pos == undefined) {
                    objProductNew.flt_Content1T1Pos = null
                }
    
                if (parseFloat(objProductOld.Param9_T1Pos).toFixed(objProductOld.Param9_DP) == parseFloat(objProductNew.flt_Content1T1Pos).toFixed(objProductNew.int_Content1DP)) {
                    objContent1.Content1.T1Pos.oldValue = false;
                    objContent1.Content1.T1Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param9_T1Pos).toFixed(objProductOld.Param9_DP) === "NaN") {
                        objContent1.Content1.T1Pos.oldValue = "NA";
                    }
                    else {
                        objContent1.Content1.T1Pos.oldValue = parseFloat(objProductOld.Param9_T1Pos).toFixed(objProductOld.Param9_DP);
                    }
                    objContent1.Content1.T1Pos.newValue = objProductNew.flt_Content1T1Pos ? objProductNew.flt_Content1T1Pos : 'NA';
                    IsChanged = true;
                }
            }
           
            if (OldContent1) {
                if (objProductNew.flt_Content1T2Neg != "") {
                    objContent1.Content1.T2Neg.oldValue = "NA";
                    objContent1.Content1.T2Neg.newValue = objProductNew.flt_Content1T2Neg;
                    IsChanged = true;
                }
                else {
                    objContent1.Content1.T2Neg.oldValue = false;
                    objContent1.Content1.T2Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param9_T2Neg == "" ||
                    objProductOld.Param9_T2Neg == this.strNullValue ||
                    objProductOld.Param9_T2Neg == undefined) {
                    objProductOld.Param9_T2Neg = null;
                }
    
                if (objProductNew.flt_Content1T2Neg == "" ||
                    objProductNew.flt_Content1T2Neg == this.strNullValue ||
                    objProductNew.flt_Content1T2Neg == undefined) {
                    objProductNew.flt_Content1T2Neg = null
                }
                if (parseFloat(objProductOld.Param9_T2Neg).toFixed(objProductOld.Param9_DP) == parseFloat(objProductNew.flt_Content1T2Neg).toFixed(objProductNew.int_Content1DP)) {
                    objContent1.Content1.T2Neg.oldValue = false;
                    objContent1.Content1.T2Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param9_T2Neg).toFixed(objProductOld.Param9_DP) === "NaN") {
                        objContent1.Content1.T2Neg.oldValue = "NA";
                    }
                    else {
                        objContent1.Content1.T2Neg.oldValue = parseFloat(objProductOld.Param9_T2Neg).toFixed(objProductOld.Param9_DP);
                    }
    
                    objContent1.Content1.T2Neg.newValue = objProductNew.flt_Content1T2Neg ? objProductNew.flt_Content1T2Neg : 'NA';
                    IsChanged = true;
                }
            }
           
            if (OldContent1) {
                if (objProductNew.flt_Content1T2Pos != "") {
                    objContent1.Content1.T2Pos.oldValue = "NA";
                    objContent1.Content1.T2Pos.newValue = objProductNew.flt_Content1T2Pos;
                    IsChanged = true;
                }
                else {
                    objContent1.Content1.T2Pos.oldValue = false;
                    objContent1.Content1.T2Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param9_T2Pos == "" ||
                    objProductOld.Param9_T2Pos == this.strNullValue ||
                    objProductOld.Param9_T2Pos == undefined) {
                    objProductOld.Param9_T2Pos = null;
                }
    
                if (objProductNew.flt_Content1T2Pos == "" ||
                    objProductNew.flt_Content1T2Pos == this.strNullValue ||
                    objProductNew.flt_Content1T2Pos == undefined) {
                    objProductNew.flt_Content1T2Pos = null
                }
    
                if (parseFloat(objProductOld.Param9_T2Pos).toFixed(objProductOld.Param9_DP) == parseFloat(objProductNew.flt_Content1T2Pos).toFixed(objProductNew.int_Content1DP)) {
                    objContent1.Content1.T2Pos.oldValue = false;
                    objContent1.Content1.T2Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param9_T2Pos).toFixed(objProductOld.Param9_DP) === "NaN") {
                        objContent1.Content1.T2Pos.oldValue = "NA";
                    }
                    else {
                        objContent1.Content1.T2Pos.oldValue = parseFloat(objProductOld.Param9_T2Pos).toFixed(objProductOld.Param9_DP);
                    }
                    objContent1.Content1.T2Pos.newValue = objProductNew.flt_Content1T2Pos ? objProductNew.flt_Content1T2Pos : 'NA';
                    IsChanged = true;
                }
            }
          
            if (OldContent1) {
                if (objProductNew.int_Content1NMTTabCnt != "") {
                    objContent1.Content1.NMT.oldValue = "NA";
                    objContent1.Content1.NMT.newValue = objProductNew.int_Content1NMTTabCnt;
                    IsChanged = true;
                }
                else {
                    objContent1.Content1.NMT.oldValue = false;
                    objContent1.Content1.NMT.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param9_NMTTab == 0 ||
                    objProductOld.Param9_NMTTab == this.NMTValue ||
                    objProductOld.Param9_NMTTab == undefined) {
                    objProductOld.Param9_NMTTab = 0;
                }
                objProductNew.int_Content1NMTTabCnt = objProductNew.int_Content1NMTTabCnt == "" ? this.strNullValue : objProductNew.int_Content1NMTTabCnt;
                if (objProductNew.int_Content1NMTTabCnt == "0" ||
                    objProductNew.int_Content1NMTTabCnt == this.NMTValue ||
                    objProductNew.int_Content1NMTTabCnt == undefined) {
                    objProductNew.int_Content1NMTTabCnt = 0
                }
    
                if (parseInt(objProductOld.Param9_NMTTab) == parseInt(objProductNew.int_Content1NMTTabCnt)) {
                    objContent1.Content1.NMT.oldValue = false;
                    objContent1.Content1.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if((objProductOld.Param9_NMTTab == undefined) || (objProductNew.int_Content1NMTTabCnt == undefined)){
                        IsChanged = false;
                    }else{
                        objContent1.Content1.NMT.oldValue = objProductOld.Param9_NMTTab;
                        objContent1.Content1.NMT.newValue = objProductNew.int_Content1NMTTabCnt;
                        IsChanged = true;
                    } 
                }
            }
          
            /*if (OldContent1) {
                if (objProductNew.str_Content1LimitOn != "") {
                    objContent1.Content1.LimitOn.oldValue = "NA";
                    objContent1.Content1.LimitOn.newValue = objProductNew.str_Content1LimitOn;
                    IsChanged = true;
                }
                else {
                    objContent1.Content1.LimitOn.oldValue = false;
                    objContent1.Content1.LimitOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strLimitOn = objProductOld.Param9_LimitOn.data[0] == 0 ? "Actual" : "Percentage";
                if (strLimitOn == objProductNew.str_Content1LimitOn) {
                    objContent1.Content1.LimitOn.oldValue = false;
                    objContent1.Content1.LimitOn.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if((strLimitOn == undefined) || (objProductNew.str_Content1LimitOn == undefined)){
                        IsChanged = false;
                    }else{
                        objContent1.Content1.LimitOn.oldValue = strLimitOn;
                        objContent1.Content1.LimitOn.newValue = objProductNew.str_Content1LimitOn;
                        IsChanged = true;
                    }
                    
                }
            }*/
    

            if (OldContent1) {
                if (objProductNew.str_Content1GraphOn != "" && objProductNew.flt_Content1Std != '') {
                    objContent1.Content1.ReportOn.oldValue = "NA";
                    objContent1.Content1.ReportOn.newValue = objProductNew.str_Content1GraphOn;
                    IsChanged = true;
                }
                else {
                    objContent1.Content1.ReportOn.oldValue = false;
                    objContent1.Content1.ReportOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strGraphOn = objProductOld.Param9_IsOnStd == 0 ? "Standard" : "Average";
                if (strGraphOn == objProductNew.str_Content1GraphOn) {
                    objContent1.Content1.ReportOn.oldValue = false;
                    objContent1.Content1.ReportOn.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if((strGraphOn == undefined) || (objProductNew.str_Content1GraphOn == undefined)){
                        IsChanged = false;
                    }else{
                        objContent1.Content1.ReportOn.oldValue = strGraphOn;
                        objContent1.Content1.ReportOn.newValue = objProductNew.str_Content1GraphOn;
                        IsChanged = true;
                    }
                    
                }
            }
    
            /**
             * For Content1 On Con1Type
             */
            if (OldContent1) {
                if (objProductNew.str_content1_type != "" && objProductNew.flt_Content1Std != '') {
                    objContent1.Content1.Content1Type.oldValue = "NA";
                    objContent1.Content1.Content1Type.newValue = objProductNew.str_content1_type;
                    IsChanged = true;
                }
                else {
                    objContent1.Content1.Content1Type.oldValue = false;
                    objContent1.Content1.Content1Type.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if(objProductNew.str_content1_type != ""){
                    const strContentType = objProductOld.Param9_ContentType == "" ? "NA" : objProductOld.Param9_ContentType;
                    if (strContentType == objProductNew.str_content1_type) {
                        objContent1.Content1.Content1Type.oldValue = false;
                        objContent1.Content1.Content1Type.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        if((strContentType == undefined) || (objProductNew.str_content1_type == undefined)){
                            IsChanged = false; 
                        }else{
                            objContent1.Content1.Content1Type.oldValue = strContentType;
                            objContent1.Content1.Content1Type.newValue = objProductNew.str_content1_type;
                            IsChanged = true;
                        }
                        
                    }
                }else{
                    IsChanged = false; 
                }
            }
    
            /**
             * For Content1 On Con1Name
             */
            if (OldContent1) {
                if (objProductNew.str_content1_Name != "" && objProductNew.flt_Content1Std != '') {
                    objContent1.Content1.Content1Name.oldValue = "NA";
                    objContent1.Content1.Content1Name.newValue = objProductNew.str_content1_Name;
                    IsChanged = true;
                }
                else {
                    objContent1.Content1.Content1Name.oldValue = false;
                    objContent1.Content1.Content1Name.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if(objProductNew.Content1Name != ""){
                    const strContentName = objProductOld.Param9_ContentDesc == "" ? "NA" : objProductOld.Param9_ContentDesc;
                    if (strContentName == objProductNew.str_content1_Name) {
                        objContent1.Content1.Content1Name.oldValue = false;
                        objContent1.Content1.Content1Name.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        if((strContentName == undefined)||(objProductNew.str_content1_Name == undefined)){
                            IsChanged = false; 
                        }else{
                            objContent1.Content1.Content1Name.oldValue = strContentName;
                            objContent1.Content1.Content1Name.newValue = objProductNew.str_content1_Name;
                            IsChanged = true;
                        }
                        
                    }
                }else{
                    IsChanged = false; 
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objContent1);
            }
            resolve(IsChanged);
        })
    
    
    }
    
    validateContent2(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objContent2 = {
                Content2: {
                    // Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    //LimitOn: { oldValue: "", newValue: "" },
                    ReportOn: { oldValue: "", newValue: "" },
                    Content2Type: { oldValue: "", newValue: "" },
                    Content2Name: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
            var OldContent2 = objProductOld == undefined ? true : false;
            /**
             * For Content2 Nom
             */
            /*if (OldContent2 == true) {
                if (objProductNew.flt_Content2Std != "") {
                    objContent2.Content2.Nom.oldValue = "NA";
                    objContent2.Content2.Nom.newValue = objProductNew.flt_Content2Std;
                    IsChanged = true;
                }
                else {
                    objContent2.Content2.Nom.oldValue = false;
                    objContent2.Content2.Nom.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param10_Nom == "" ||
                    objProductOld.Param10_Nom == this.strNullValue ||
                    objProductOld.Param10_Nom == undefined) {
                    objProductOld.Param10_Nom = null
                }
    
                if (objProductNew.flt_Content2Std == "" ||
                    objProductNew.flt_Content2Std == this.strNullValue) {
                    objProductNew.flt_Content2Std = null
                }
    
                if (parseFloat(objProductOld.Param10_Nom).toFixed(objProductOld.Param10_DP) ==
                    parseFloat(objProductNew.flt_Content2Std).toFixed(objProductNew.int_Content2DP)) {
                        objContent2.Content2.Nom.oldValue = false;
                        objContent2.Content2.Nom.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (parseFloat(objProductOld.Param10_Nom).toFixed(objProductOld.Param10_DP) === "NaN")
                        objContent2.Content2.Nom.oldValue = "NA";
                    else {
                        objContent2.Content2.Nom.oldValue = parseFloat(objProductOld.Param10_Nom).toFixed(objProductOld.Param10_DP);
                    }
                    objContent2.Content2.Nom.newValue = objProductNew.flt_Content2Std;
                    IsChanged = true;
                }
            }*/
    
            if (OldContent2) {
                if (objProductNew.flt_Content2T1Neg != "") {
                    objContent2.Content2.T1Neg.oldValue = "NA";
                    objContent2.Content2.T1Neg.newValue = objProductNew.flt_Content2T1Neg;
                    IsChanged = true;
                }
                else {
    
                    objContent2.Content2.T1Neg.oldValue = false;
                    objContent2.Content2.T1Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param10_T1Neg == "" ||
                    objProductOld.Param10_T1Neg == this.strNullValue ||
                    objProductOld.Param10_T1Neg == undefined) {
    
                    objProductOld.Param10_T1Neg = null;
                }
                if (objProductNew.flt_Content2T1Neg == "" ||
                    objProductNew.flt_Content2T1Neg == this.strNullValue ||
                    objProductNew.flt_Content2T1Neg == undefined) {
                    objProductNew.flt_Content2T1Neg = null;
                }
    
                if (parseFloat(objProductOld.Param10_T1Neg).toFixed(objProductOld.Param10_DP) == parseFloat(objProductNew.flt_Content2T1Neg).toFixed(objProductNew.int_Content2DP)) {
                    objContent2.Content2.T1Neg.oldValue = false;
                    objContent2.Content2.T1Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param10_T1Neg).toFixed(objProductOld.Param10_DP) === "NaN") {
                        objContent2.Content2.T1Neg.oldValue = "NA";
                    }
                    else {
                        objContent2.Content2.T1Neg.oldValue = parseFloat(objProductOld.Param10_T1Neg).toFixed(objProductOld.Param10_DP);
                    }
    
    
                    objContent2.Content2.T1Neg.newValue = objProductNew.flt_Content2T1Neg;
                    IsChanged = true;
                }
            }
        
    
            if (OldContent2) {
                if (objProductNew.flt_Content2T1Pos != "") {
                    objContent2.Content2.T1Pos.oldValue = "NA";
                    objContent2.Content2.T1Pos.newValue = objProductNew.flt_Content2T1Pos;
                    IsChanged = true;
                }
                else {
                    objContent2.Content2.T1Pos.oldValue = false;
                    objContent2.Content2.T1Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param10_T1Pos == "" ||
                    objProductOld.Param10_T1Pos == this.strNullValue ||
                    objProductOld.Param10_T1Pos == undefined) {
                    objProductOld.Param10_T1Pos = null;
                }
    
                if (objProductNew.flt_Content2T1Pos == "" ||
                    objProductNew.flt_Content2T1Pos == this.strNullValue ||
                    objProductNew.flt_Content2T1Pos == undefined) {
                    objProductNew.flt_Content2T1Pos = null
                }
    
                if (parseFloat(objProductOld.Param10_T1Pos).toFixed(objProductOld.Param10_DP) == parseFloat(objProductNew.flt_Content2T1Pos).toFixed(objProductNew.int_Content2DP)) {
                    objContent2.Content2.T1Pos.oldValue = false;
                    objContent2.Content2.T1Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param10_T1Pos).toFixed(objProductOld.Param10_DP) === "NaN") {
                        objContent2.Content2.T1Pos.oldValue = "NA";
                    }
                    else {
                        objContent2.Content2.T1Pos.oldValue = parseFloat(objProductOld.Param10_T1Pos).toFixed(objProductOld.Param10_DP);
                    }
                    objContent2.Content2.T1Pos.newValue = objProductNew.flt_Content2T1Pos;
                    IsChanged = true;
                }
            }
           
            if (OldContent2) {
                if (objProductNew.flt_Content2T2Neg != "") {
                    objContent2.Content2.T2Neg.oldValue = "NA";
                    objContent2.Content2.T2Neg.newValue = objProductNew.flt_Content2T2Neg;
                    IsChanged = true;
                }
                else {
                    objContent2.Content2.T2Neg.oldValue = false;
                    objContent2.Content2.T2Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param10_T2Neg == "" ||
                    objProductOld.Param10_T2Neg == this.strNullValue ||
                    objProductOld.Param10_T2Neg == undefined) {
                    objProductOld.Param10_T2Neg = null;
                }
    
                if (objProductNew.flt_Content2T2Neg == "" ||
                    objProductNew.flt_Content2T2Neg == this.strNullValue ||
                    objProductNew.flt_Content2T2Neg == undefined) {
                    objProductNew.flt_Content2T2Neg = null
                }
                if (parseFloat(objProductOld.Param10_T2Neg).toFixed(objProductOld.Param10_DP) == parseFloat(objProductNew.flt_Content2T2Neg).toFixed(objProductNew.int_Content2DP)) {
                    objContent2.Content2.T2Neg.oldValue = false;
                    objContent2.Content2.T2Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param10_T2Neg).toFixed(objProductOld.Param10_DP) === "NaN") {
                        objContent2.Content2.T2Neg.oldValue = "NA";
                    }
                    else {
                        objContent2.Content2.T2Neg.oldValue = parseFloat(objProductOld.Param10_T2Neg).toFixed(objProductOld.Param10_DP);
                    }
    
                    objContent2.Content2.T2Neg.newValue = objProductNew.flt_Content2T2Neg;
                    IsChanged = true;
                }
            }
           
            if (OldContent2) {
                if (objProductNew.flt_Content2T2Pos != "") {
                    objContent2.Content2.T2Pos.oldValue = "NA";
                    objContent2.Content2.T2Pos.newValue = objProductNew.flt_Content2T2Pos;
                    IsChanged = true;
                }
                else {
                    objContent2.Content2.T2Pos.oldValue = false;
                    objContent2.Content2.T2Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param10_T2Pos == "" ||
                    objProductOld.Param10_T2Pos == this.strNullValue ||
                    objProductOld.Param10_T2Pos == undefined) {
                    objProductOld.Param10_T2Pos = null;
                }
    
                if (objProductNew.flt_Content2T2Pos == "" ||
                    objProductNew.flt_Content2T2Pos == this.strNullValue ||
                    objProductNew.flt_Content2T2Pos == undefined) {
                    objProductNew.flt_Content2T2Pos = null
                }
    
                if (parseFloat(objProductOld.Param10_T2Pos).toFixed(objProductOld.Param10_DP) == parseFloat(objProductNew.flt_Content2T2Pos).toFixed(objProductNew.int_Content2DP)) {
                    objContent2.Content2.T2Pos.oldValue = false;
                    objContent2.Content2.T2Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param10_T2Pos).toFixed(objProductOld.Param10_DP) === "NaN") {
                        objContent2.Content2.T2Pos.oldValue = "NA";
                    }
                    else {
                        objContent2.Content2.T2Pos.oldValue = parseFloat(objProductOld.Param10_T2Pos).toFixed(objProductOld.Param10_DP);
                    }
                    objContent2.Content2.T2Pos.newValue = objProductNew.flt_Content2T2Pos;
                    IsChanged = true;
                }
            }
          
            if (OldContent2) {
                if (objProductNew.int_Content2NMTTabCnt != "") {
                    objContent2.Content2.NMT.oldValue = "NA";
                    objContent2.Content2.NMT.newValue = objProductNew.int_Content2NMTTabCnt;
                    IsChanged = true;
                }
                else {
                    objContent2.Content2.NMT.oldValue = false;
                    objContent2.Content2.NMT.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param10_NMTTab == 0 ||
                    objProductOld.Param10_NMTTab == this.NMTValue ||
                    objProductOld.Param10_NMTTab == undefined) {
                    objProductOld.Param10_NMTTab = 0;
                }
                objProductNew.int_Content2NMTTabCnt = objProductNew.int_Content2NMTTabCnt == "" ? this.strNullValue : objProductNew.int_Content2NMTTabCnt;
                if (objProductNew.int_Content2NMTTabCnt == "0" ||
                    objProductNew.int_Content2NMTTabCnt == this.NMTValue ||
                    objProductNew.int_Content2NMTTabCnt == undefined) {
                    objProductNew.int_Content2NMTTabCnt = 0
                }
    
                if (parseInt(objProductOld.Param10_NMTTab) == parseInt(objProductNew.int_Content2NMTTabCnt)) {
                    objContent2.Content2.NMT.oldValue = false;
                    objContent2.Content2.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if((objProductOld.Param10_NMTTab == undefined) || (objProductNew.int_Content2NMTTabCnt == undefined)){
                        IsChanged = false;
                    }else{
                        objContent2.Content2.NMT.oldValue = objProductOld.Param10_NMTTab;
                        objContent2.Content2.NMT.newValue = objProductNew.int_Content2NMTTabCnt;
                        IsChanged = true;
                    } 
                }
            }
          
            /*if (OldContent2) {
                if (objProductNew.str_Content2LimitOn != "") {
                    objContent2.Content2.LimitOn.oldValue = "NA";
                    objContent2.Content2.LimitOn.newValue = objProductNew.str_Content2LimitOn;
                    IsChanged = true;
                }
                else {
                    objContent2.Content2.LimitOn.oldValue = false;
                    objContent2.Content2.LimitOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strLimitOn = objProductOld.Param10_LimitOn.data[0] == 0 ? "Actual" : "Percentage";
                if (strLimitOn == objProductNew.str_Content2LimitOn) {
                    objContent2.Content2.LimitOn.oldValue = false;
                    objContent2.Content2.LimitOn.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if((strLimitOn == undefined) || (objProductNew.str_Content2LimitOn == undefined)){
                        IsChanged = false;
                    }else{
                        objContent2.Content2.LimitOn.oldValue = strLimitOn;
                        objContent2.Content2.LimitOn.newValue = objProductNew.str_Content2LimitOn;
                        IsChanged = true;
                    }
                    
                }
            }*/
    

            /*if (OldContent2) {
                if (objProductNew.str_Content2GraphOn != "") {
                    objContent2.Content2.ReportOn.oldValue = "NA";
                    objContent2.Content2.ReportOn.newValue = objProductNew.str_Content2GraphOn;
                    IsChanged = true;
                }
                else {
                    objContent2.Content2.ReportOn.oldValue = false;
                    objContent2.Content2.ReportOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strGraphOn = objProductOld.Param10_IsOnStd == 0 ? "Standard" : "Average";
                if (strGraphOn == objProductNew.str_Content2GraphOn) {
                    objContent2.Content2.ReportOn.oldValue = false;
                    objContent2.Content2.ReportOn.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if((strGraphOn == undefined) || (objProductNew.str_Content2GraphOn == undefined)){
                        IsChanged = false;
                    }else{
                        objContent2.Content2.ReportOn.oldValue = strGraphOn;
                        objContent2.Content2.ReportOn.newValue = objProductNew.str_Content2GraphOn;
                        IsChanged = true;
                    }
                    
                }
            }*/
    
            /**
             * For Content2 On Con1Type
             */
            /*if (OldContent2) {
                if (objProductNew.str_content2_type != "") {
                    objContent2.Content2.Content2Type.oldValue = "NA";
                    objContent2.Content2.Content2Type.newValue = objProductNew.str_content2_type;
                    IsChanged = true;
                }
                else {
                    objContent2.Content2.Content2Type.oldValue = false;
                    objContent2.Content2.Content2Type.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if(objProductNew.str_content2_type != ""){
                    const strContentType = objProductOld.Param10_ContentType == "" ? "NA" : objProductOld.Param10_ContentType;
                    if (strContentType == objProductNew.str_content2_type) {
                        objContent2.Content2.Content2Type.oldValue = false;
                        objContent2.Content2.Content2Type.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        if((strContentType == undefined) || (objProductNew.str_content2_type == undefined)){
                            IsChanged = false; 
                        }else{
                            objContent2.Content2.Content2Type.oldValue = strContentType;
                            objContent2.Content2.Content2Type.newValue = objProductNew.str_content2_type;
                            IsChanged = true;
                        }
                        
                    }
                }else{
                    IsChanged = false; 
                }
            }*/
    
            /**
             * For Content1 On Con1Name
             */
            /*if (OldContent2) {
                if (objProductNew.str_content2_Name != "") {
                    objContent2.Content2.Content2Name.oldValue = "NA";
                    objContent2.Content2.Content2Name.newValue = objProductNew.str_content2_Name;
                    IsChanged = true;
                }
                else {
                    objContent2.Content2.Content2Name.oldValue = false;
                    objContent2.Content2.Content2Name.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if(objProductNew.Content2Name != ""){
                    const strContentName = objProductOld.Param10_ContentDesc == "" ? "NA" : objProductOld.Param10_ContentDesc;
                    if (strContentName == objProductNew.str_content2_Name) {
                        objContent2.Content2.Content2Name.oldValue = false;
                        objContent2.Content2.Content2Name.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        if((strContentName == undefined)||(objProductNew.str_content2_Name == undefined)){
                            IsChanged = false; 
                        }else{
                            objContent2.Content2.Content2Name.oldValue = strContentName;
                            objContent2.Content2.Content2Name.newValue = objProductNew.str_content2_Name;
                            IsChanged = true;
                        }
                        
                    }
                }else{
                    IsChanged = false; 
                }
            }*/
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objContent2);
            }
            resolve(IsChanged);
        })
    
    
    }

    validateContent3(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objContent3 = {
                Content3: {
                    //Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    //LimitOn: { oldValue: "", newValue: "" },
                    ReportOn: { oldValue: "", newValue: "" },
                    Content3Type: { oldValue: "", newValue: "" },
                    Content3Name: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
            var OldContent3 = objProductOld == undefined ? true : false;
            /**
             * For Content3 Nom
             */
            /*if (OldContent3 == true) {
                if (objProductNew.flt_Content3Std != "") {
                    objContent3.Content3.Nom.oldValue = "NA";
                    objContent3.Content3.Nom.newValue = objProductNew.flt_Content3Std;
                    IsChanged = true;
                }
                else {
                    objContent3.Content3.Nom.oldValue = false;
                    objContent3.Content3.Nom.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param11_Nom == "" ||
                    objProductOld.Param11_Nom == this.strNullValue ||
                    objProductOld.Param11_Nom == undefined) {
                    objProductOld.Param11_Nom = null
                }
    
                if (objProductNew.flt_Content3Std == "" ||
                    objProductNew.flt_Content3Std == this.strNullValue) {
                    objProductNew.flt_Content3Std = null
                }
    
                if (parseFloat(objProductOld.Param11_Nom).toFixed(objProductOld.Param11_DP) ==
                    parseFloat(objProductNew.flt_Content3Std).toFixed(objProductNew.int_Content3DP)) {
                        objContent3.Content3.Nom.oldValue = false;
                        objContent3.Content3.Nom.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (parseFloat(objProductOld.Param11_Nom).toFixed(objProductOld.Param11_DP) === "NaN")
                        objContent3.Content3.Nom.oldValue = "NA";
                    else {
                        objContent3.Content3.Nom.oldValue = parseFloat(objProductOld.Param11_Nom).toFixed(objProductOld.Param11_DP);
                    }
                    objContent3.Content3.Nom.newValue = objProductNew.flt_Content3Std;
                    IsChanged = true;
                }
            }*/
    
            if (OldContent3) {
                if (objProductNew.flt_Content3T1Neg != "") {
                    objContent3.Content3.T1Neg.oldValue = "NA";
                    objContent3.Content3.T1Neg.newValue = objProductNew.flt_Content3T1Neg;
                    IsChanged = true;
                }
                else {
    
                    objContent3.Content3.T1Neg.oldValue = false;
                    objContent3.Content3.T1Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param11_T1Neg == "" ||
                    objProductOld.Param11_T1Neg == this.strNullValue ||
                    objProductOld.Param11_T1Neg == undefined) {
    
                    objProductOld.Param11_T1Neg = null;
                }
                if (objProductNew.flt_Content3T1Neg == "" ||
                    objProductNew.flt_Content3T1Neg == this.strNullValue ||
                    objProductNew.flt_Content3T1Neg == undefined) {
                    objProductNew.flt_Content3T1Neg = null;
                }
    
                if (parseFloat(objProductOld.Param11_T1Neg).toFixed(objProductOld.Param11_DP) == parseFloat(objProductNew.flt_Content3T1Neg).toFixed(objProductNew.int_Content3DP)) {
                    objContent3.Content3.T1Neg.oldValue = false;
                    objContent3.Content3.T1Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param11_T1Neg).toFixed(objProductOld.Param11_DP) === "NaN") {
                        objContent3.Content3.T1Neg.oldValue = "NA";
                    }
                    else {
                        objContent3.Content3.T1Neg.oldValue = parseFloat(objProductOld.Param11_T1Neg).toFixed(objProductOld.Param11_DP);
                    }
    
    
                    objContent3.Content3.T1Neg.newValue = objProductNew.flt_Content3T1Neg;
                    IsChanged = true;
                }
            }
        
    
            if (OldContent3) {
                if (objProductNew.flt_Content3T1Pos != "") {
                    objContent3.Content3.T1Pos.oldValue = "NA";
                    objContent3.Content3.T1Pos.newValue = objProductNew.flt_Content3T1Pos;
                    IsChanged = true;
                }
                else {
                    objContent3.Content3.T1Pos.oldValue = false;
                    objContent3.Content3.T1Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param11_T1Pos == "" ||
                    objProductOld.Param11_T1Pos == this.strNullValue ||
                    objProductOld.Param11_T1Pos == undefined) {
                    objProductOld.Param11_T1Pos = null;
                }
    
                if (objProductNew.flt_Content3T1Pos == "" ||
                    objProductNew.flt_Content3T1Pos == this.strNullValue ||
                    objProductNew.flt_Content3T1Pos == undefined) {
                    objProductNew.flt_Content3T1Pos = null
                }
    
                if (parseFloat(objProductOld.Param11_T1Pos).toFixed(objProductOld.Param11_DP) == parseFloat(objProductNew.flt_Content3T1Pos).toFixed(objProductNew.int_Content3DP)) {
                    objContent3.Content3.T1Pos.oldValue = false;
                    objContent3.Content3.T1Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param11_T1Pos).toFixed(objProductOld.Param11_DP) === "NaN") {
                        objContent3.Content3.T1Pos.oldValue = "NA";
                    }
                    else {
                        objContent3.Content3.T1Pos.oldValue = parseFloat(objProductOld.Param11_T1Pos).toFixed(objProductOld.Param11_DP);
                    }
                    objContent3.Content3.T1Pos.newValue = objProductNew.flt_Content3T1Pos;
                    IsChanged = true;
                }
            }
           
            if (OldContent3) {
                if (objProductNew.flt_Content3T2Neg != "") {
                    objContent3.Content3.T2Neg.oldValue = "NA";
                    objContent3.Content3.T2Neg.newValue = objProductNew.flt_Content3T2Neg;
                    IsChanged = true;
                }
                else {
                    objContent3.Content3.T2Neg.oldValue = false;
                    objContent3.Content3.T2Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param11_T2Neg == "" ||
                    objProductOld.Param11_T2Neg == this.strNullValue ||
                    objProductOld.Param11_T2Neg == undefined) {
                    objProductOld.Param11_T2Neg = null;
                }
    
                if (objProductNew.flt_Content3T2Neg == "" ||
                    objProductNew.flt_Content3T2Neg == this.strNullValue ||
                    objProductNew.flt_Content3T2Neg == undefined) {
                    objProductNew.flt_Content3T2Neg = null
                }
                if (parseFloat(objProductOld.Param11_T2Neg).toFixed(objProductOld.Param11_DP) == parseFloat(objProductNew.flt_Content3T2Neg).toFixed(objProductNew.int_Content3DP)) {
                    objContent3.Content3.T2Neg.oldValue = false;
                    objContent3.Content3.T2Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param11_T2Neg).toFixed(objProductOld.Param11_DP) === "NaN") {
                        objContent3.Content3.T2Neg.oldValue = "NA";
                    }
                    else {
                        objContent3.Content3.T2Neg.oldValue = parseFloat(objProductOld.Param11_T2Neg).toFixed(objProductOld.Param11_DP);
                    }
    
                    objContent3.Content3.T2Neg.newValue = objProductNew.flt_Content3T2Neg;
                    IsChanged = true;
                }
            }
           
            if (OldContent3) {
                if (objProductNew.flt_Content3T2Pos != "") {
                    objContent3.Content3.T2Pos.oldValue = "NA";
                    objContent3.Content3.T2Pos.newValue = objProductNew.flt_Content3T2Pos;
                    IsChanged = true;
                }
                else {
                    objContent3.Content3.T2Pos.oldValue = false;
                    objContent3.Content3.T2Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param11_T2Pos == "" ||
                    objProductOld.Param11_T2Pos == this.strNullValue ||
                    objProductOld.Param11_T2Pos == undefined) {
                    objProductOld.Param11_T2Pos = null;
                }
    
                if (objProductNew.flt_Content3T2Pos == "" ||
                    objProductNew.flt_Content3T2Pos == this.strNullValue ||
                    objProductNew.flt_Content3T2Pos == undefined) {
                    objProductNew.flt_Content3T2Pos = null
                }
    
                if (parseFloat(objProductOld.Param11_T2Pos).toFixed(objProductOld.Param11_DP) == parseFloat(objProductNew.flt_Content3T2Pos).toFixed(objProductNew.int_Content3DP)) {
                    objContent3.Content3.T2Pos.oldValue = false;
                    objContent3.Content3.T2Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param11_T2Pos).toFixed(objProductOld.Param11_DP) === "NaN") {
                        objContent3.Content3.T2Pos.oldValue = "NA";
                    }
                    else {
                        objContent3.Content3.T2Pos.oldValue = parseFloat(objProductOld.Param11_T2Pos).toFixed(objProductOld.Param11_DP);
                    }
                    objContent3.Content3.T2Pos.newValue = objProductNew.flt_Content3T2Pos;
                    IsChanged = true;
                }
            }
          
            if (OldContent3) {
                if (objProductNew.int_Content3NMTTabCnt != "") {
                    objContent3.Content3.NMT.oldValue = "NA";
                    objContent3.Content3.NMT.newValue = objProductNew.int_Content3NMTTabCnt;
                    IsChanged = true;
                }
                else {
                    objContent3.Content3.NMT.oldValue = false;
                    objContent3.Content3.NMT.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param11_NMTTab == 0 ||
                    objProductOld.Param11_NMTTab == this.NMTValue ||
                    objProductOld.Param11_NMTTab == undefined) {
                    objProductOld.Param11_NMTTab = 0;
                }
                objProductNew.int_Content3NMTTabCnt = objProductNew.int_Content3NMTTabCnt == "" ? this.strNullValue : objProductNew.int_Content3NMTTabCnt;
                if (objProductNew.int_Content3NMTTabCnt == "0" ||
                    objProductNew.int_Content3NMTTabCnt == this.NMTValue ||
                    objProductNew.int_Content3NMTTabCnt == undefined) {
                    objProductNew.int_Content3NMTTabCnt = 0
                }
    
                if (parseInt(objProductOld.Param11_NMTTab) == parseInt(objProductNew.int_Content3NMTTabCnt)) {
                    objContent3.Content3.NMT.oldValue = false;
                    objContent3.Content3.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if((objProductOld.Param11_NMTTab == undefined) || (objProductNew.int_Content3NMTTabCnt == undefined)){
                        IsChanged = false;
                    }else{
                        objContent3.Content3.NMT.oldValue = objProductOld.Param11_NMTTab;
                        objContent3.Content3.NMT.newValue = objProductNew.int_Content3NMTTabCnt;
                        IsChanged = true;
                    } 
                }
            }
          
            /*if (OldContent3) {
                if (objProductNew.str_Content3LimitOn != "") {
                    objContent3.Content3.LimitOn.oldValue = "NA";
                    objContent3.Content3.LimitOn.newValue = objProductNew.str_Content3LimitOn;
                    IsChanged = true;
                }
                else {
                    objContent3.Content3.LimitOn.oldValue = false;
                    objContent3.Content3.LimitOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strLimitOn = objProductOld.Param11_LimitOn.data[0] == 0 ? "Actual" : "Percentage";
                if (strLimitOn == objProductNew.str_Content3LimitOn) {
                    objContent3.Content3.LimitOn.oldValue = false;
                    objContent3.Content3.LimitOn.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if((strLimitOn == undefined) || (objProductNew.str_Content3LimitOn == undefined)){
                        IsChanged = false;
                    }else{
                        objContent3.Content3.LimitOn.oldValue = strLimitOn;
                        objContent3.Content3.LimitOn.newValue = objProductNew.str_Content3LimitOn;
                        IsChanged = true;
                    }
                    
                }
            }*/
    

            /*if (OldContent3) {
                if (objProductNew.str_Content3GraphOn != "") {
                    objContent3.Content3.ReportOn.oldValue = "NA";
                    objContent3.Content3.ReportOn.newValue = objProductNew.str_Content3GraphOn;
                    IsChanged = true;
                }
                else {
                    objContent3.Content3.ReportOn.oldValue = false;
                    objContent3.Content3.ReportOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strGraphOn = objProductOld.Param11_IsOnStd == 0 ? "Standard" : "Average";
                if (strGraphOn == objProductNew.str_Content3GraphOn) {
                    objContent3.Content3.ReportOn.oldValue = false;
                    objContent3.Content3.ReportOn.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if((strGraphOn == undefined) || (objProductNew.str_Content3GraphOn == undefined)){
                        IsChanged = false;
                    }else{
                        objContent3.Content3.ReportOn.oldValue = strGraphOn;
                        objContent3.Content3.ReportOn.newValue = objProductNew.str_Content3GraphOn;
                        IsChanged = true;
                    }
                    
                }
            }*/
    
            /**
             * For Content3 On Con1Type
             */
            /*if (OldContent3) {
                if (objProductNew.str_content3_type != "") {
                    objContent3.Content3.Content3Type.oldValue = "NA";
                    objContent3.Content3.Content3Type.newValue = objProductNew.str_content3_type;
                    IsChanged = true;
                }
                else {
                    objContent3.Content3.Content3Type.oldValue = false;
                    objContent3.Content3.Content3Type.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if(objProductNew.str_content3_type != ""){
                    const strContentType = objProductOld.Param11_ContentType == "" ? "NA" : objProductOld.Param11_ContentType;
                    if (strContentType == objProductNew.str_content3_type) {
                        objContent3.Content3.Content3Type.oldValue = false;
                        objContent3.Content3.Content3Type.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        if((strContentType == undefined) || (objProductNew.str_content3_type == undefined)){
                            IsChanged = false; 
                        }else{
                            objContent3.Content3.Content3Type.oldValue = strContentType;
                            objContent3.Content3.Content3Type.newValue = objProductNew.str_content3_type;
                            IsChanged = true;
                        }
                        
                    }
                }else{
                    IsChanged = false; 
                }
            }*/
    
            /**
             * For Content1 On Con1Name
             */
            /*if (OldContent3) {
                if (objProductNew.str_content3_Name != "") {
                    objContent3.Content3.Content3Name.oldValue = "NA";
                    objContent3.Content3.Content3Name.newValue = objProductNew.str_content3_Name;
                    IsChanged = true;
                }
                else {
                    objContent3.Content3.Content3Name.oldValue = false;
                    objContent3.Content3.Content3Name.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if(objProductNew.Content3Name != ""){
                    const strContentName = objProductOld.Param11_ContentDesc == "" ? "NA" : objProductOld.Param11_ContentDesc;
                    if (strContentName == objProductNew.str_content3_Name) {
                        objContent3.Content3.Content3Name.oldValue = false;
                        objContent3.Content3.Content3Name.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        if((strContentName == undefined)||(objProductNew.str_content3_Name == undefined)){
                            IsChanged = false; 
                        }else{
                            objContent3.Content3.Content3Name.oldValue = strContentName;
                            objContent3.Content3.Content3Name.newValue = objProductNew.str_content3_Name;
                            IsChanged = true;
                        }
                        
                    }
                }else{
                    IsChanged = false; 
                }
            }*/
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objContent3);
            }
            resolve(IsChanged);
        })
    
    
    }

    validateContent4(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objContent4 = {
                Content4: {
                    //Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    //LimitOn: { oldValue: "", newValue: "" },
                    ReportOn: { oldValue: "", newValue: "" },
                    Content4Type: { oldValue: "", newValue: "" },
                    Content4Name: { oldValue: "", newValue: "" }
                }
            };
    
            var IsChanged = false;
            var OldContent4 = objProductOld == undefined ? true : false;
            /**
             * For Content4 Nom
             */
            /*if (OldContent4 == true) {
                if (objProductNew.flt_Content4Std != "") {
                    objContent4.Content4.Nom.oldValue = "NA";
                    objContent4.Content4.Nom.newValue = objProductNew.flt_Content4Std;
                    IsChanged = true;
                }
                else {
                    objContent4.Content4.Nom.oldValue = false;
                    objContent4.Content4.Nom.newValue = false;
                    IsChanged = false;
                }
    
            }
            else {
                if (objProductOld.Param12_Nom == "" ||
                    objProductOld.Param12_Nom == this.strNullValue ||
                    objProductOld.Param12_Nom == undefined) {
                    objProductOld.Param12_Nom = null
                }
    
                if (objProductNew.flt_Content4Std == "" ||
                    objProductNew.flt_Content4Std == this.strNullValue) {
                    objProductNew.flt_Content4Std = null
                }
    
                if (parseFloat(objProductOld.Param12_Nom).toFixed(objProductOld.Param12_DP) ==
                    parseFloat(objProductNew.flt_Content4Std).toFixed(objProductNew.int_Content4DP)) {
                        objContent4.Content4.Nom.oldValue = false;
                        objContent4.Content4.Nom.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (parseFloat(objProductOld.Param12_Nom).toFixed(objProductOld.Param12_DP) === "NaN")
                        objContent4.Content4.Nom.oldValue = "NA";
                    else {
                        objContent4.Content4.Nom.oldValue = parseFloat(objProductOld.Param12_Nom).toFixed(objProductOld.Param12_DP);
                    }
                    objContent4.Content4.Nom.newValue = objProductNew.flt_Content4Std;
                    IsChanged = true;
                }
            }*/
    
            if (OldContent4) {
                if (objProductNew.flt_Content4T1Neg != "") {
                    objContent4.Content4.T1Neg.oldValue = "NA";
                    objContent4.Content4.T1Neg.newValue = objProductNew.flt_Content4T1Neg;
                    IsChanged = true;
                }
                else {
    
                    objContent4.Content4.T1Neg.oldValue = false;
                    objContent4.Content4.T1Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param12_T1Neg == "" ||
                    objProductOld.Param12_T1Neg == this.strNullValue ||
                    objProductOld.Param12_T1Neg == undefined) {
    
                    objProductOld.Param12_T1Neg = null;
                }
                if (objProductNew.flt_Content4T1Neg == "" ||
                    objProductNew.flt_Content4T1Neg == this.strNullValue ||
                    objProductNew.flt_Content4T1Neg == undefined) {
                    objProductNew.flt_Content4T1Neg = null;
                }
    
                if (parseFloat(objProductOld.Param12_T1Neg).toFixed(objProductOld.Param12_DP) == parseFloat(objProductNew.flt_Content4T1Neg).toFixed(objProductNew.int_Content4DP)) {
                    objContent4.Content4.T1Neg.oldValue = false;
                    objContent4.Content4.T1Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param12_T1Neg).toFixed(objProductOld.Param12_DP) === "NaN") {
                        objContent4.Content4.T1Neg.oldValue = "NA";
                    }
                    else {
                        objContent4.Content4.T1Neg.oldValue = parseFloat(objProductOld.Param12_T1Neg).toFixed(objProductOld.Param12_DP);
                    }
    
    
                    objContent4.Content4.T1Neg.newValue = objProductNew.flt_Content4T1Neg;
                    IsChanged = true;
                }
            }
        
    
            if (OldContent4) {
                if (objProductNew.flt_Content4T1Pos != "") {
                    objContent4.Content4.T1Pos.oldValue = "NA";
                    objContent4.Content4.T1Pos.newValue = objProductNew.flt_Content4T1Pos;
                    IsChanged = true;
                }
                else {
                    objContent4.Content4.T1Pos.oldValue = false;
                    objContent4.Content4.T1Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param12_T1Pos == "" ||
                    objProductOld.Param12_T1Pos == this.strNullValue ||
                    objProductOld.Param12_T1Pos == undefined) {
                    objProductOld.Param12_T1Pos = null;
                }
    
                if (objProductNew.flt_Content4T1Pos == "" ||
                    objProductNew.flt_Content4T1Pos == this.strNullValue ||
                    objProductNew.flt_Content4T1Pos == undefined) {
                    objProductNew.flt_Content4T1Pos = null
                }
    
                if (parseFloat(objProductOld.Param12_T1Pos).toFixed(objProductOld.Param12_DP) == parseFloat(objProductNew.flt_Content4T1Pos).toFixed(objProductNew.int_Content4DP)) {
                    objContent4.Content4.T1Pos.oldValue = false;
                    objContent4.Content4.T1Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param12_T1Pos).toFixed(objProductOld.Param12_DP) === "NaN") {
                        objContent4.Content4.T1Pos.oldValue = "NA";
                    }
                    else {
                        objContent4.Content4.T1Pos.oldValue = parseFloat(objProductOld.Param12_T1Pos).toFixed(objProductOld.Param12_DP);
                    }
                    objContent4.Content4.T1Pos.newValue = objProductNew.flt_Content4T1Pos;
                    IsChanged = true;
                }
            }
           
            if (OldContent4) {
                if (objProductNew.flt_Content4T2Neg != "") {
                    objContent4.Content4.T2Neg.oldValue = "NA";
                    objContent4.Content4.T2Neg.newValue = objProductNew.flt_Content4T2Neg;
                    IsChanged = true;
                }
                else {
                    objContent4.Content4.T2Neg.oldValue = false;
                    objContent4.Content4.T2Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param12_T2Neg == "" ||
                    objProductOld.Param12_T2Neg == this.strNullValue ||
                    objProductOld.Param12_T2Neg == undefined) {
                    objProductOld.Param12_T2Neg = null;
                }
    
                if (objProductNew.flt_Content4T2Neg == "" ||
                    objProductNew.flt_Content4T2Neg == this.strNullValue ||
                    objProductNew.flt_Content4T2Neg == undefined) {
                    objProductNew.flt_Content4T2Neg = null
                }
                if (parseFloat(objProductOld.Param12_T2Neg).toFixed(objProductOld.Param12_DP) == parseFloat(objProductNew.flt_Content4T2Neg).toFixed(objProductNew.int_Content4DP)) {
                    objContent4.Content4.T2Neg.oldValue = false;
                    objContent4.Content4.T2Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param12_T2Neg).toFixed(objProductOld.Param12_DP) === "NaN") {
                        objContent4.Content4.T2Neg.oldValue = "NA";
                    }
                    else {
                        objContent4.Content4.T2Neg.oldValue = parseFloat(objProductOld.Param12_T2Neg).toFixed(objProductOld.Param12_DP);
                    }
    
                    objContent4.Content4.T2Neg.newValue = objProductNew.flt_Content4T2Neg;
                    IsChanged = true;
                }
            }
           
            if (OldContent4) {
                if (objProductNew.flt_Content4T2Pos != "") {
                    objContent4.Content4.T2Pos.oldValue = "NA";
                    objContent4.Content4.T2Pos.newValue = objProductNew.flt_Content4T2Pos;
                    IsChanged = true;
                }
                else {
                    objContent4.Content4.T2Pos.oldValue = false;
                    objContent4.Content4.T2Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param12_T2Pos == "" ||
                    objProductOld.Param12_T2Pos == this.strNullValue ||
                    objProductOld.Param12_T2Pos == undefined) {
                    objProductOld.Param12_T2Pos = null;
                }
    
                if (objProductNew.flt_Content4T2Pos == "" ||
                    objProductNew.flt_Content4T2Pos == this.strNullValue ||
                    objProductNew.flt_Content4T2Pos == undefined) {
                    objProductNew.flt_Content4T2Pos = null
                }
    
                if (parseFloat(objProductOld.Param12_T2Pos).toFixed(objProductOld.Param12_DP) == parseFloat(objProductNew.flt_Content4T2Pos).toFixed(objProductNew.int_Content4DP)) {
                    objContent4.Content4.T2Pos.oldValue = false;
                    objContent4.Content4.T2Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.Param12_T2Pos).toFixed(objProductOld.Param12_DP) === "NaN") {
                        objContent4.Content4.T2Pos.oldValue = "NA";
                    }
                    else {
                        objContent4.Content4.T2Pos.oldValue = parseFloat(objProductOld.Param12_T2Pos).toFixed(objProductOld.Param12_DP);
                    }
                    objContent4.Content4.T2Pos.newValue = objProductNew.flt_Content4T2Pos;
                    IsChanged = true;
                }
            }
          
            if (OldContent4) {
                if (objProductNew.int_Content4NMTTabCnt != "") {
                    objContent4.Content4.NMT.oldValue = "NA";
                    objContent4.Content4.NMT.newValue = objProductNew.int_Content4NMTTabCnt;
                    IsChanged = true;
                }
                else {
                    objContent4.Content4.NMT.oldValue = false;
                    objContent4.Content4.NMT.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param12_NMTTab == 0 ||
                    objProductOld.Param12_NMTTab == this.NMTValue ||
                    objProductOld.Param12_NMTTab == undefined) {
                    objProductOld.Param12_NMTTab = 0;
                }
                objProductNew.int_Content4NMTTabCnt = objProductNew.int_Content4NMTTabCnt == "" ? this.strNullValue : objProductNew.int_Content4NMTTabCnt;
                if (objProductNew.int_Content4NMTTabCnt == "0" ||
                    objProductNew.int_Content4NMTTabCnt == this.NMTValue ||
                    objProductNew.int_Content4NMTTabCnt == undefined) {
                    objProductNew.int_Content4NMTTabCnt = 0
                }
    
                if (parseInt(objProductOld.Param12_NMTTab) == parseInt(objProductNew.int_Content4NMTTabCnt)) {
                    objContent4.Content4.NMT.oldValue = false;
                    objContent4.Content4.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if((objProductOld.Param12_NMTTab == undefined) || (objProductNew.int_Content4NMTTabCnt == undefined)){
                        IsChanged = false;
                    }else{
                        objContent4.Content4.NMT.oldValue = objProductOld.Param12_NMTTab;
                        objContent4.Content4.NMT.newValue = objProductNew.int_Content4NMTTabCnt;
                        IsChanged = true;
                    } 
                }
            }
          
            /*if (OldContent4) {
                if (objProductNew.str_Content4LimitOn != "") {
                    objContent4.Content4.LimitOn.oldValue = "NA";
                    objContent4.Content4.LimitOn.newValue = objProductNew.str_Content4LimitOn;
                    IsChanged = true;
                }
                else {
                    objContent4.Content4.LimitOn.oldValue = false;
                    objContent4.Content4.LimitOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strLimitOn = objProductOld.Param12_LimitOn.data[0] == 0 ? "Actual" : "Percentage";
                if (strLimitOn == objProductNew.str_Content4LimitOn) {
                    objContent4.Content4.LimitOn.oldValue = false;
                    objContent4.Content4.LimitOn.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if((strLimitOn == undefined) || (objProductNew.str_Content4LimitOn == undefined)){
                        IsChanged = false;
                    }else{
                        objContent4.Content4.LimitOn.oldValue = strLimitOn;
                        objContent4.Content4.LimitOn.newValue = objProductNew.str_Content4LimitOn;
                        IsChanged = true;
                    }
                    
                }
            }*/
    

            /*if (OldContent4) {
                if (objProductNew.str_Content4GraphOn != "") {
                    objContent4.Content4.ReportOn.oldValue = "NA";
                    objContent4.Content4.ReportOn.newValue = objProductNew.str_Content4GraphOn;
                    IsChanged = true;
                }
                else {
                    objContent4.Content4.ReportOn.oldValue = false;
                    objContent4.Content4.ReportOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strGraphOn = objProductOld.Param12_IsOnStd == 0 ? "Standard" : "Average";
                if (strGraphOn == objProductNew.str_Content4GraphOn) {
                    objContent4.Content4.ReportOn.oldValue = false;
                    objContent4.Content4.ReportOn.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if((strGraphOn == undefined) || (objProductNew.str_Content4GraphOn == undefined)){
                        IsChanged = false;
                    }else{
                        objContent4.Content4.ReportOn.oldValue = strGraphOn;
                        objContent4.Content4.ReportOn.newValue = objProductNew.str_Content4GraphOn;
                        IsChanged = true;
                    }
                    
                }
            }*/
    
            /**
             * For Content4 On Con1Type
             */
            /*if (OldContent4) {
                if (objProductNew.str_content4_type != "") {
                    objContent4.Content4.Content4Type.oldValue = "NA";
                    objContent4.Content4.Content4Type.newValue = objProductNew.str_content4_type;
                    IsChanged = true;
                }
                else {
                    objContent4.Content4.Content4Type.oldValue = false;
                    objContent4.Content4.Content4Type.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if(objProductNew.str_content4_type != ""){
                    const strContentType = objProductOld.Param12_ContentType == "" ? "NA" : objProductOld.Param12_ContentType;
                    if (strContentType == objProductNew.str_content4_type) {
                        objContent4.Content4.Content4Type.oldValue = false;
                        objContent4.Content4.Content4Type.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        if((strContentType == undefined) || (objProductNew.str_Content4_type == undefined)){
                            IsChanged = false; 
                        }else{
                            objContent4.Content4.Content4Type.oldValue = strContentType;
                            objContent4.Content4.Content4Type.newValue = objProductNew.str_content4_type;
                            IsChanged = true;
                        }
                        
                    }
                }else{
                    IsChanged = false; 
                }
            }*/
    
            /**
             * For Content4 On Con1Name
             */
            /*if (OldContent4) {
                if (objProductNew.str_content4_Name != "") {
                    objContent4.Content4.Content4Name.oldValue = "NA";
                    objContent4.Content4.Content4Name.newValue = objProductNew.str_content4_Name;
                    IsChanged = true;
                }
                else {
                    objContent4.Content4.Content4Name.oldValue = false;
                    objContent4.Content4.Content4Name.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if(objProductNew.Content4Name != ""){
                    const strContentName = objProductOld.Param12_ContentDesc == "" ? "NA" : objProductOld.Param12_ContentDesc;
                    if (strContentName == objProductNew.str_content4_Name) {
                        objContent4.Content4.Content4Name.oldValue = false;
                        objContent4.Content4.Content4Name.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        if((strContentName == undefined)||(objProductNew.str_content4_Name == undefined)){
                            IsChanged = false; 
                        }else{
                            objContent4.Content4.Content4Name.oldValue = strContentName;
                            objContent4.Content4.Content4Name.newValue = objProductNew.str_content4_Name;
                            IsChanged = true;
                        }
                        
                    }
                }else{
                    IsChanged = false; 
                }
            }*/
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objContent4);
            }
            resolve(IsChanged);
        })
    
    
    }



    async validateCapsuleParams(objProductOld, objProductNew) {
        var Ind = await this.validateIndividual(objProductOld, objProductNew);
        let Grp = await this.validateGourp(objProductOld, objProductNew);
        let Net = await this.validateNet(objProductOld, objProductNew);
        let Empty = await this.validateEmpty(objProductOld, objProductNew);
        let Len = await this.validateLength(objProductOld, objProductNew,2);
        let Dia = await this.validateDiameterCapsule(objProductOld, objProductNew);
        let DT = await this.validateDTCapsule(objProductOld, objProductNew);
        let Content1 = await this.validateContent1(objProductOld, objProductNew);
        let Content2 = await this.validateContent2(objProductOld, objProductNew);
        let Content3 = await this.validateContent3(objProductOld, objProductNew);
        let Content4 = await this.validateContent4(objProductOld, objProductNew);

        if (Ind != true && Grp != true && Net != true && Empty != true &&
            Len != true && DT != true && Dia != true && Content1 != true && Content2 != true && Content3 != true &&
            Content4 != true) {
            return "No Change";
        }
        else {
            var strChanged = "";
            var strNewValue = "";

            //"Individual : Nominal : value,Group : Nominal : value"
            IterateObject(this.objResult, function (value, key1) {
                //console.log(key1);
                strChanged = strChanged + "|";
                strNewValue = strNewValue + "|";
                key1 = (key1 === 'Net' ? 'Filled Content Weight' : ( key1 === 'Length' ? 'Seal Length' : key1));
                var obj = value;
                IterateObject(obj, (value, key) => {
                    if (value.oldValue !== false) {
                        strChanged = strChanged + key1 + "-";
                        strChanged = strChanged + key + ":";
                        //strChanged = strChanged + value.oldValue + ", ";
                        strChanged = strChanged + ((value.oldValue == null || value.oldValue == "NaN") ? "NA" : value.oldValue) + ", ";
                        ", ";
                        if (strChanged.includes("null:null:null")) {
                            strChanged = strChanged.replace(/null/g, "NA");
                        }

                        strNewValue = strNewValue + key1 + "-";
                        strNewValue = strNewValue + key + ":";
                        strNewValue = strNewValue + ((value.newValue == null || value.newValue == "NaN") ? "NA" : value.newValue) + ", ";
                        ", ";
                        if (strNewValue.includes("null:null:null")) {
                            strNewValue = strNewValue.replace(/null/g, "NA");
                        }
                    }

                })
            });

            return { oldData: strChanged.slice(1), newData: strNewValue.slice(1) };
        }
    }

}

module.exports = ValidateCapsule;