 Database = require('../database/clsQueryProcess');
const TranDatabase = require('../database/clsQueryTransactProcess');
const clsProduct = require('./clsProductTablet.class');
const clsUpdateProduct = require('./clsupdateProductTablet.class');
const clsUpdateCapsule = require('./clsProductUpdateCapsule.class');
const clsProductGranulation = require('./clsProductGranulation.class');
const midDateTimeFormat = require('../middleware/setTimeZone');
const readXlsxFile = require('read-excel-file/node');
//const midDateTimeFormat = require('../middleware/setTimeZone');
const database = new Database()
const objTranDatabase = new TranDatabase();
const objProduct = new clsProduct();
const objUpdateProduct = new clsUpdateProduct();
const objUpdateProductCapsule = new clsUpdateCapsule();
const objProductGranulation = new clsProductGranulation();
const clsTabletModel = require('./clsProductTabletModel');
const clsCapsuleModel = require('./clsProductCapsuleModel');
const objClsTabletModel = new clsTabletModel();
const objClsCapsuleModel = new clsCapsuleModel();
const dbcon = require('../../API/Utills/db');
const date = require('date-and-time');
let now = new Date();
const serverConfig = require('../../API/global/serverConfig')
var is_EditProductAfterBatchEnd = serverConfig.developerPanelData.IncrencyCommon.find(x => x.Name === 'EditProductAfterBatchEnd').Value;

const models = require("../dbConnection").models;
const seqTransaction = require("../dbConnection");

const sequelize = require('./../dbConnection').sequelize;
const { Op, where } = require("sequelize");
const { printReasonReportCalibVernier } = require('../validation/report/report.schema');
const { QueryTypes } = require('sequelize');
const { sendMessageToClient } = require('../WebServer/controller/socketHandler');

class ProductModel {

    /**
     *This function will return Product Master Data only 
     *if parameter is passed then it will return parameter specific or all data.
     * @param {string} [objProduct=""] object contains ProductId, ProductName, ProductVersion, Version and PrdType
     * @returns object matching to the condition from product master.
     * @memberof ProductModel
     */
    async getProductMasterData(objProduct = "") 
    {
        try 
        {
            var productObj,result;
            if(objProduct != "")
            {
                productObj = await models.tbl_product_master.findAll({
                    where: {
                        ProductId:objProduct.ProductId,
                        ProductName:objProduct.ProductName,
                        ProductVersion:objProduct.ProductVersion,
                        Version:objProduct.Version,
                        GenericName:objProduct.GenericName,
                        ProductType:objProduct.ProductType
                    }
                });
                result = productObj;
                // if(result.length > 0){
                //     return result;
                // }
            }
            else
            {
                productObj = await models.tbl_product_master.findAll({});
                result = productObj;
                if(result.length < 1){
                    return false;   
                }
            }
            
            return result;
        } 
        catch (err) 
        {
            console.log("getProductMasterData err",err);
            throw err;
        }

    }

    async checkInCubicle(req) {
        try {
            var responseObj = {};
            var productID = req.body.productID;
            var productname = req.body.productname;
            var productVersion = req.body.productVersion;
            var Version = req.body.Version;
            let intGenericName = serverConfig.developerPanelData.CubicleSetting.find(x => x.Name === 'GenericName').Value;
            var GenericName = req.body.GenericName;

            // let result = await dbcon.execute("select count(*) as cnt from tbl_cubical where Sys_BFGCode='" + productID
            //     + "' and Sys_ProductName='" + productname + "' and Sys_PVersion='"
            //     + productVersion + "' and Sys_Version='" + Version
            //     + "' and Sys_GenericName='" + GenericName + "'");
            //var intCount;
            let query = {
                where:{
                    Sys_BFGCode:productID,
                    Sys_ProductName:productname,
                    Sys_PVersion:productVersion,
                    Sys_Version:Version
                }
            }

            if(intGenericName == 1){
                Object(query,{Sys_GenericName:GenericName})
            }
            
            var result = await models.tbl_cubical.count(query);
            Object.assign(responseObj, { status: 'success' }, { cnt: result });
            return responseObj;
        }
        catch (error) {
            console.log(error);
            throw error;
        }
    }

    async getStatusCount(req) {
        try {
            var responseObj = {};
            var productname = req.body.productname;
            var productVersion = req.body.productVersion;
            var sfoid = req.body.SFOID;
            var productID = req.body.productID;
            var Version = req.body.Version;
            //console.log(`SELECT count(*) AS statuscount FROM tbl_batches WHERE Prod_ID = '${productID}' AND Prod_Name = '${productname}' AND Prod_Version = '${productVersion}' AND Version = '${Version}' AND (Status = 'R' OR Status = 'S')`);
            var result = await dbcon.execute(`SELECT count(*) AS statuscount FROM tbl_batches WHERE Prod_ID = '${productID}' AND Prod_Name = '${productname}' AND Prod_Version = '${productVersion}' AND Version = '${Version}' AND SFOID = '${sfoid}' AND (Status = 'R' OR Status = 'S')`);
            if (result[0].length > 0) {
                var statuscount = result[0][0].statuscount;
                Object.assign(responseObj, { status: 'success' }, { result: statuscount })
                return responseObj;
            } else {
                Object.assign(responseObj, { status: 'success' }, { result: "Data Not Found" })
                return responseObj;
            }

        } catch (error) {
            return error;
        }
    }

    /**
     *for activating product and audit entry.
     * @param {*} req request object 
     * @returns
     * @memberof ProductModel
     */
    async activateProduct(req) {
        try {
            let responseObj = {};
            let sendmsg = ''
            let checkDoneAlreadyCnd = {
                ProductId: req.body.productID,
                ProductName: req.body.productname,
                version: req.body.Version,
                ProductVersion: req.body.productVersion,
                MPN_Code: req.body.MPNCode
            }
            
            if(req.body.action == "Release Product"){
                Object.assign(checkDoneAlreadyCnd,{IsActive: 1});
                sendmsg = 'Product Already Released'
            }else if(req.body.action == "Block Product"){
                Object.assign(checkDoneAlreadyCnd,{IsActive: 2})
                sendmsg = 'Product Already Blocked'
            }else{
                Object.assign(checkDoneAlreadyCnd,{IsReject: 1})
                sendmsg = 'Product Already Rejected'
            }

            let prdDetail = await models.tbl_product_master.findAll({ where : { MPN_Code: req.body.MPNCode}});

            const checkDoneAlready = await models.tbl_product_master.findAll({
                where: checkDoneAlreadyCnd
            });

            if(checkDoneAlready.length > 0){
                Object.assign(responseObj, { status: 'success' }, { result: sendmsg })
                return responseObj;
            }

            if (req.body.action == "Release Product") {
   
                await models.tbl_product_master.update({'IsActive': 1,'ActivateChance':1,'IsReject':0},
                    {
                        where: {
                            ProductId: req.body.productID,
                            ProductName: req.body.productname,
                            version: req.body.Version,
                            ProductVersion: req.body.productVersion,
                            MPN_Code: req.body.MPNCode
                        }
                    });
                now = new Date();

                    await models.tbl_audit_product.create({
                    DT: date.format(now, 'YYYY-MM-DD'),
                    TM: date.format(now, 'HH:mm:ss'),
                    userid: req.body.userId,
                    username: req.body.userName,
                    ACT: req.body.action,
                    Remark: req.body.remark,
                    ProductId: req.body.MPNCode,
                    ProductName: "NA",
                    PrdVersion: "NA",
                    Version: "NA",
                    GenericName:"NA",
                    ProductType:req.body.productType,
                    OldValueComp: 'NA',
                    NewValueComp: 'NA',
                    OldValueGran: 'NA',
                    NewValueGran: 'NA',
                    OldValueCoat: 'NA',
                    NewValueCoat: 'NA',
                    SFOID: req.body.MPNCode,
                    type: 'NA'                      
                });

                Object.assign(responseObj, { status: 'success' }, { result: 'Product Released Successfully' })
                return responseObj;

            } else {
               let Obj_PrdDeact = (req.body.action == "Block Product") ? {'IsActive': 2,'IsReject':0,RejectRemark: req.body.remark} : {'IsActive': 0,'IsReject':1,RejectRemark: req.body.remark};
               let str_Message = "Product Reject Successfully";
               if (req.body.action === "Permanently Deactivate Product") {
                    Object.assign(Obj_PrdDeact, {'PerDeactivate' : 2 });
                    str_Message = "Product Permanently Deactivate Successfully";
               }

                 await models.tbl_product_master.update(
                    Obj_PrdDeact,
                    {
                        where: {
                            ProductId: req.body.productID,
                            ProductName: req.body.productname,
                            version: req.body.Version,
                            ProductVersion: req.body.productVersion,
                            MPN_Code: req.body.MPNCode
                        }
                    });
                now = new Date();
                 await models.tbl_audit_product.create({
                    DT: date.format(now, 'YYYY-MM-DD'),
                    TM: date.format(now, 'HH:mm:ss'),
                    userid: req.body.userId,
                    username: req.body.userName,
                    ACT: req.body.action,
                    Remark: req.body.remark,
                    ProductId: "NA",
                    ProductName: 'NA',
                    PrdVersion: 'NA',
                    Version: 'NA',
                    GenericName: 'NA',
                    ProductType: req.body.productType,
                    OldValueComp:'NA',
                    NewValueComp:'NA',
                    OldValueGran: 'NA',
                    NewValueGran: 'NA',
                    NewValueCoat: 'NA',
                    type: 'NA',
                    SFOID:req.body.MPNCode
                });
                if(req.body.action == "Reject Product"){
                    sendMessageToClient(`${prdDetail[0].RejectGroup}_notification`,{message: req.body.remark ,title: req.body.action})
                }
                Object.assign(responseObj, { status: 'success' }, { result: str_Message })
                return responseObj;
            }
        }
        catch (err) {
            throw err;
        }
    }
    /**
     *for verifying or rejecting product and audit entry.
     * @param {*} req request object 
     * @returns
     * @memberof ProductModel
     */
    async verifyOrRejectProduct(body) {
        try {
            let transactionRes = await seqTransaction.sequelize.transaction( async(t) => {
                let responseObj = 
                {};
                let sendmsg = ''
                let checkDoneAlreadyCnd = {
                    // ProductId: body.productID,
                    // ProductName: body.productname,
                    // version: body.Version,
                    // ProductVersion: body.productVersion,
                    MPN_Code: body.MPNCode
                }
                
                if(body.action == "Verify Product"){
                    Object.assign(checkDoneAlreadyCnd,{isLimitChanged: 0});
                    sendmsg = 'Product Already Verified'
                }else{
                    Object.assign(checkDoneAlreadyCnd,{IsReject: 1})
                    sendmsg = 'Product Already Rejected'
                }

                let prdDetail = await models.tbl_product_master.findAll({ where : { MPN_Code: body.MPNCode}});

                const checkDoneAlready = await models.tbl_product_master.findAll({
                    where: checkDoneAlreadyCnd
                });

                if(checkDoneAlready.length > 0){
                    Object.assign(responseObj, { status: 'success' }, { result: sendmsg })
                    return responseObj;
                }

                let isVerify = body.action == "Verify Product";
                    
                await models.tbl_product_master.update({
                    isLimitChanged: 0,
                    IsReject: isVerify ? 0 : 1,
                    isActivate: isVerify ? 1: 0,
                    IsActive: isVerify ? 1: 0,
                    RejectRemark: isVerify ? '' : body.remark
                },{
                    where: {
                        // ProductId: body.productID,
                        // ProductName: body.productname,
                        // version: body.Version,
                        // ProductVersion: body.productVersion,
                        MPN_Code: body.MPNCode
                    },
                    transaction: t
                });

                now = new Date();
                if (body.productType == "2") {
                    if(isVerify){
                        await this.updateProductCapsuleMES(body,t);
                    }
                }
                else {
                    if(isVerify){
                        await this.updateProductUncoatedMES(body,t);
                    }
                }

                await models.tbl_audit_product.create({
                    DT: date.format(now, 'YYYY-MM-DD'),
                    TM: date.format(now, 'HH:mm:ss'),
                    userid: body.userId,
                    username: body.userName,
                    ACT: body.action,
                    Remark: body.remark,
                    ProductId: body.MPNCode,
                    ProductName: "NA",
                    PrdVersion: "NA",
                    Version: "NA",
                    GenericName: "NA",
                    ProductType: body.productType,
                    OldValueComp: body.auditObject.result.result == 'No Change' ? 'NA' : (body.productType == '2' ? body.auditObject.result.Capsule.oldData : body.auditObject.result.Compressed.oldData),
                    NewValueComp: body.auditObject.result.result == 'No Change'  ? 'NA' : (body.productType == '2' ? body.auditObject.result.Capsule.newData : body.auditObject.result.Compressed.newData),
                    OldValueGran: 'NA',
                    NewValueGran: 'NA',
                    OldValueCoat: 'NA',
                    NewValueCoat: 'NA',
                    type: 'NA',
                    SFOID: body.MPNCode                    
                },{ transaction: t});

                if(!isVerify){
                    sendMessageToClient(`${prdDetail[0].RejectGroup}_notification`,{message: body.remark ,title: body.action})
                }
                Object.assign(responseObj, { status: 'success' }, { result: isVerify ? 'Product Verified Successfully' : 'Product Rejected Successfully' })
                return responseObj
                
            })
            return transactionRes
        }
        catch (err) {
            throw err;
        }
    }

    /**
     *For adding product uncoated as well as coated.
     * @param {*} req request object
     * @returns
     * @memberof ProductModel
     */
    async addProduct(req, int_prdType = 1) 
    {
        try 
        {
            const objResult = [];
            const checkProduct = await this.checkProductStatus(req);

            if(checkProduct.result == 'Product Details already exist') 
            {
                objResult.push(checkProduct);
                return objResult;
            }
            else 
            {
                //if Only Granulation is true others are false then add granulation product only
                if ((req.bln_TypeGrannualPrd == true) && (req.bln_TypeCompressed == false) &&
                    (req.bln_TypeCoatPrd == false) && (req.bln_TypeBiLayPrd == false) &&
                    (req.bln_TypeTriLayPrd == false) && (req.bln_IsBinWeiging == false)) 
                {
                    const productGranulationData = await this.addProductGranulation(req);
                    objResult.push(productGranulationData);
                    return objResult;
                }
                else 
                {
                    const uncoatedAdd = await this.addProductUncoated(req, req.bln_TypeCompressed);

                    //Capsule Granulation
                    if(int_prdType == 2 && req.bln_TypeGrannualPrd == true) 
                    {
                        objResult.push(uncoatedAdd);
                        const productGranulationAdd = await this.addProductGranulation(req);
                        objResult.push(productGranulationAdd);
                        return objResult;
                    }
                    else if(int_prdType == 2 && req.bln_TypeGrannualPrd == false) {//Capsule Capsulation
                        objResult.push(uncoatedAdd);
                        return objResult;
                    }
                    else if(req.bln_TypeCompressed == true && req.bln_TypeCoatPrd == false && req.bln_TypeGrannualPrd == false) // Compression
                    {
                        objResult.push(uncoatedAdd);
                        return objResult;
                    }
                    else if(req.bln_TypeCompressed == true && req.bln_TypeCoatPrd == true && req.bln_TypeGrannualPrd == false){
                        objResult.push(uncoatedAdd);
                        const coatedAdd = await this.addProductCoated(req);
                        objResult.push(coatedAdd);

                        return objResult;
                    }
                    else if(req.bln_TypeCoatPrd == false && req.bln_TypeGrannualPrd == false) // Compression 
                    {
                        objResult.push(uncoatedAdd);
                        return objResult;
                    }
                    else if(req.bln_TypeCoatPrd == false && req.bln_TypeGrannualPrd == true) // Granulation
                    {
                        objResult.push(uncoatedAdd);

                        const productGranulationAdd = await this.addProductGranulation(req);
                        objResult.push(productGranulationAdd);
                        return objResult;
                    }
                    else if(req.bln_TypeGrannualPrd == true && req.bln_TypeCoatPrd == true) //Granulation & Coated
                    {
                        const productGranulationAdd = await this.addProductGranulation(req);
                        objResult.push(productGranulationAdd);

                        const coatedAdd = await this.addProductCoated(req);
                        objResult.push(coatedAdd);

                        return objResult;
                    }
                    else if (req.bln_TypeCoatPrd == true && req.bln_TypeGrannualPrd == false) //Coated 
                    {
                        const coatedAdd = await this.addProductCoated(req);
                        objResult.push(coatedAdd);
                        return objResult;
                    }
                }
            }
        } catch (err) {

            console.log("addProduct err",err)
            throw err;
        }
    }

    /**
     *For adding product uncoated as well as coated.
     * @param {*} req request object
     * @returns
     * @memberof ProductModel
     */
    async updateProductCapsule(req) {
        try {
            const objResult = [];
            const uncoatedAdd = await this.updateProductCap(req);
            objResult.push(uncoatedAdd);
            return objResult;
        }
        catch (err) {
            return err;
        }
    }
    async updateProduct(req) {
        try {
            let transactionRes = await seqTransaction.sequelize.transaction(async (t) =>{
                const objResult = [];

                const deleteGranulationData = await this.deleteProduct(req,t);

                /**
                 * When there is only Granulation parameter in the product and no other parameter added or removed
                 */
                if ((req.bln_TypeGrannualPrd == true) && (req.bln_TypeCompressed == false) && (req.wasCompressed == false) &&
                    (req.bln_TypeCoatPrd == false) && (req.wasCoated == false) && (req.bln_TypeBiLayPrd == false) && 
                    ( req.wasTrilayer == false) && ( req.wasBilayer == false) && (req.bln_TypeTriLayPrd == false) && (req.bln_IsBinWeiging == false)) 
                {
                    const productUpdateGranulation = await this.updateProductGranulation(req,t);
                    objResult.push(productUpdateGranulation);
                    return objResult;
                }
                else {
                    const masterupdate = await this.updateMasterDataOnly(
                        req.bln_TypeCompressed, req.bln_TypeBiLayPrd, req.bln_TypeTriLayPrd,
                        req.bln_TypeCoatPrd, req.bln_TypeGrannualPrd, req,t
                    );
                    const uncoatedUpdate = await this.updateProductUncoated(req,t, req.bln_TypeCompressed);
                    
                    //Return when updating only compressed parameter 
                    if (req.bln_TypeCoatPrd == false && req.wasCoated == false &&  req.wasGrannual == false && req.bln_TypeGrannualPrd == false) {
                        if (uncoatedUpdate == undefined && uncoatedUpdate == "") {
                            objResult.push(masterupdate);
                        }
                        else {
                            objResult.push(masterupdate);
                        }

                        return objResult;
                    } //was condition is handle for audit entry when current product is not granulation but previous was
                    else if (req.bln_TypeCoatPrd == false && (req.bln_TypeGrannualPrd == true || req.wasGrannual == true)) {
                        // Return the result when there is Granulation along with compressed paramter but no coated parameter

                        const productUpdateGranulation = await this.updateProductGranulation(req,t);
                        //When user remove coating parameter from the product which has granulation also than audit entry for the coating should be done.
                        if(req.wasCoated == true){
                            await this.updateProductCoated(req,t);
                        }
                        
                        if (productUpdateGranulation != undefined && productUpdateGranulation != "") {
                            objResult.push(productUpdateGranulation);
                        } else {
                            objResult.push(uncoatedUpdate);
                        }

                        return objResult;
                    }
                    else if (req.bln_TypeGrannualPrd == true && req.bln_TypeCoatPrd == true) {
                        //return when there is all the parameter
                        const productUpdateGranulation = await this.updateProductGranulation(req,t);
                        if (productUpdateGranulation != undefined && productUpdateGranulation != "") {
                            objResult.push(productUpdateGranulation);
                        }
                        //objResult.push(productUpdateGranulation);

                        const coatedUpdate = await this.updateProductCoated(req,t);
                        if (coatedUpdate != undefined && coatedUpdate != "") {
                            objResult.push(coatedUpdate);
                        }

                        if (productUpdateGranulation == undefined && coatedUpdate == undefined) {
                            objResult.push(uncoatedUpdate);
                        }

                        return objResult;
                    } // //was condition is handle for audit entry when current product is not coating but previous was
                    else if ((req.bln_TypeCoatPrd == true || req.wasCoated == true) && req.bln_TypeGrannualPrd == false) {
                        // update when there is coated parameter along with compressed parameter but no granulation
                        const coatedUpdate = await this.updateProductCoated(req,t);
                        
                        //When user remove granulation parameter from the product which has coating also than audit entry for the granulation should be done.
                        if(req.wasGrannual == true){
                            await this.updateProductGranulation(req,t);
                        }

                        if (coatedUpdate != "" && coatedUpdate != undefined) {
                            objResult.push(coatedUpdate);
                        }
                        else {
                            objResult.push(masterupdate);
                        }

                        return objResult;
                    }
                    else if (req.bln_TypeCompressed == true && req.bln_TypeGrannualPrd == true) {
                        objResult.push(uncoatedUpdate);
                        const productUpdateGranulation = await this.updateProductGranulation(req,t);
                        objResult.push(productUpdateGranulation);
                        return objResult;
                    }
                    else if (req.bln_TypeCompressed == true && req.bln_TypeGrannualPrd == true && req.bln_TypeBiLayPrd == true) {
                        objResult.push(uncoatedUpdate);
                        const productUpdateGranulation = await this.updateProductGranulation(req,t);
                        objResult.push(productUpdateGranulation);
                        return objResult;
                    }
                    else if (req.bln_TypeCompressed == true && req.bln_TypeGrannualPrd == true && req.bln_TypeTriLayPrd == true) {
                        objResult.push(uncoatedUpdate);
                        const productUpdateGranulation = await this.updateProductGranulation(req,t);
                        objResult.push(productUpdateGranulation);
                        return objResult;
                    }
                    else if (req.bln_TypeCompressed == true && req.bln_TypeCoatPrd == true && req.bln_TypeBiLayPrd == true && req.bln_TypeTriLayPrd == true && req.bln_TypeGrannualPrd == false) {
                        objResult.push(uncoatedUpdate);
                        const coatedUpdate = await this.updateProductCoated(req,t);
                        objResult.push(coatedUpdate);
                        return objResult;
                    }

                }
            });
            return transactionRes;
        } catch (err) {
            console.log(err);
            throw  err;
        }
    }

    async deleteProduct(req,t) {
        try{
            const objResult = [];
            var deleteCompressed;
            var deleteCoated;
            var deleteGranulation;
            var deleteProductData;
                if (req.auditObject.result.ProductDetail.result != "No Change") {
                    // deleteProductData = await this.delFromProductMaster(req);
                    // objResult.push(deleteProductData); 
        
                    if (req.bln_TypeCompressed == true || req.bln_TypeBiLayPrd == true || req.bln_TypeTriLayPrd == true) {
                        deleteCompressed = await this.delProCompressedData(req, t);
                        objResult.push(deleteCompressed);
                    }
                    if (req.bln_TypeGrannualPrd == true) {
                        deleteGranulation = await this.delProGranData(req, t);
                        objResult.push(deleteGranulation);
                    }
                    if (req.bln_TypeCoatPrd == true) {
                        deleteCoated = await this.delProCoatedData(req, t);
                        objResult.push(deleteCoated);
                    }
                }
                /**
                 * Check this condition all the time because even when user change product detail or not
                 */
                if ((req.bln_TypeCompressed == false && req.wasCompressed == true) ||
                    (req.bln_TypeBiLayPrd == false && req.wasBilayer == true) ||
                    ( req.bln_TypeTriLayPrd == false && req.wasTrilayer == true)) {
                    //console.log('bln_TypeCoatPrd');
                    deleteCompressed = await this.delProCompressedData(req, t);
                    objResult.push(deleteCompressed);
    
                }

                if (req.bln_TypeCoatPrd == false && req.wasCoated == true) {
                    //console.log('bln_TypeGrannualPrd and bln_TypeCoatPrd');
                    //const deleteGranulation = await this.delProGranData(req);
                    deleteCoated = await this.delProCoatedData(req, t);
                    //objResult.push(deleteGranulation);
                    objResult.push(deleteCoated);
    
                }
            
                if (req.bln_TypeGrannualPrd == false && req.wasGrannual == true) {
                    //console.log('bln_TypeGrannualPrd');
                    deleteGranulation = await this.delProGranData(req, t);
                    objResult.push(deleteGranulation);
                }
            
            if (deleteCompressed != "" && deleteGranulation != "" && deleteCoated != "") { return objResult; }
        }catch(error){
            console.log(error);
            throw error;
        }
    }
    async delProGranData(req, trans) {
        try {
            var responseObj = {};
            var deleteData;
            if (req.intGenericName == 1) {
                deleteData = await models.tbl_product_gran.destroy({
                    where: {
                        ProductId: req.strOldBFG,
                        ProductName:req.strOldPrd,
                        ProductVersion:req.strOldPV,
                        Version:req.strOldV,
                        GenericName:req.strOldGName
                    },
                    transaction: trans
                });
            }
            else {
   
                deleteData = await models.tbl_product_gran.destroy({
                    where: {
                        ProductId: req.strOldBFG,
                        ProductName:req.strOldPrd,
                        ProductVersion:req.strOldPV,
                        Version:req.strOldV
                    },
                    transaction: trans
                });
            }


            now = new Date();
            var strGenericName = "";
            (req.intGenericName == 1) ? strGenericName = req.str_GenericName : strGenericName = "NA";

            /*const insertProductObj = await models.tbl_audit_product.create
            ({
                DT: date.format(now, 'YYYY-MM-DD'),
                TM: date.format(now, 'HH:mm:ss'),
                userid: req.loggedUserId,
                username: req.loggedUserName,
                ACT: req.action,
                Remark: req.remark,
                ProductId: req.str_BFGCode,
                ProductName: req.str_Prd,
                PrdVersion: req.str_PV,
                Version: req.str_V,
                GenericName: strGenericName,
                ProductType: req.int_prdType,
                OldValueComp: 'NA',
                NewValueComp: 'NA',
                OldValueGran: req.auditObject.result.Grannual.oldData,
                NewValueGran: req.auditObject.result.Grannual.newData,
                OldValueCoat: 'NA',
                NewValueCoat: 'NA'
                //oldProductId: req.strOldBFG ,
                //oldProductName: req.strOldPrd ,
                //oldPrdVersion: req.strOldPV ,
                //oldVersion: req.strOldV
            },
            {
                transaction: trans
            });*/
            Object.assign(responseObj, { status: 'success' }, { result: 'success' });
            return responseObj;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async delProCoatedData(req, trans) {
        try {
            let responseObj = {};
            var deleteData;
            if (req.intGenericName == 1) {

                deleteData = await models.tbl_product_tablet_coated.destroy({
                    where: {
                        ProductId: req.strOldBFG,
                        ProductName:req.strOldPrd,
                        ProductVersion:req.strOldPV,
                        Version:req.strOldV,
                        GenericName:req.strOldGName
                    },
                    transaction: trans
                });
                
            }
            else {
                deleteData = await models.tbl_product_tablet_coated.destroy({
                    where: {
                        ProductId: req.strOldBFG,
                        ProductName:req.strOldPrd,
                        ProductVersion:req.strOldPV,
                        Version:req.strOldV
                    },
                    transaction: trans
                });
            }


            now = new Date();

            var strGenericName = "";
            (req.intGenericName == 1) ? strGenericName = req.str_GenericName : strGenericName = "NA";

            var OldData = req.auditObject.result.Coated.oldData;
            var NewData = req.auditObject.result.Coated.newData;

            const auditUpdateProductCoatedObj = await models.tbl_audit_product.create
            ({
                DT: date.format(now, 'YYYY-MM-DD'),
                TM: date.format(now, 'HH:mm:ss'),
                userid: req.loggedUserId,
                username: req.loggedUserName,
                ACT: req.action,
                Remark: req.remark,
                ProductId: req.str_BFGCode.trim(),
                ProductName: req.str_Prd.trim(),
                PrdVersion: req.str_PV.trim(),
                Version: req.str_V.trim(),
                GenericName: strGenericName,
                ProductType: req.int_prdType,
                OldValueComp: 'NA',
                NewValueComp: 'NA',
                OldValueGran: 'NA',
                NewValueGran: 'NA',
                OldValueCoat: OldData,
                NewValueCoat: NewData 
                //oldProductId: req.strOldBFG,
                //oldProductName: req.strOldPrd,
                //oldPrdVersion: req.strOldPV,
                //oldVersion: req.strOldV

            },{
                transaction: trans
            });
            Object.assign(responseObj, { status: 'success' }, { result: 'success' });
            return responseObj;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async delProCompressedData(req, trans) {
        try {
            const arrObj = [];
            let responseObj = {};
            var deleteData;
            if (req.intGenericName == 1) {
                deleteData = await models.tbl_product_tablet.destroy({
                    where: {
                        ProductId: req.strOldBFG,
                        ProductName:req.strOldPrd,
                        ProductVersion:req.strOldPV,
                        Version:req.strOldV,
                        GenericName:req.strOldGName,
                        SFOID:req.strOldSFOID
                    },
                    transaction: trans
                });

            }
            else {
                deleteData = await models.tbl_product_tablet.destroy({
                    where: {
                        ProductId: req.strOldBFG,
                        ProductName:req.strOldPrd,
                        ProductVersion:req.strOldPV,
                        Version:req.strOldV,
                        SFOID:req.strOldSFOID
                    },
                    transaction: trans
                });
            }


            /**
             * This audit is only for our reference.
             */
            now = new Date();
            var strGenericName = "";
            (req.intGenericName == 1) ? strGenericName = req.str_GenericName : strGenericName = "NA";
            const auditProductObj = await models.tbl_audit_product.create({
                DT: date.format(now, 'YYYY-MM-DD'),
                TM: date.format(now, 'HH:mm:ss'),
                userid: req.loggedUserId,
                username: req.loggedUserName,
                ACT: req.action,
                Remark: req.remark,
                ProductId: req.str_BFGCode.trim(),
                ProductName: req.str_Prd.trim(),
                PrdVersion: req.str_PV.trim(),
                Version: req.str_V.trim(),
                GenericName: strGenericName,
                ProductType: req.int_prdType,
                OldValueComp: req.auditObject.result.Compressed.oldData,
                NewValueComp: req.auditObject.result.Compressed.newData,
                OldValueGran: 'NA',
                NewValueGran: 'NA',
                OldValueCoat: 'NA',
                NewValueCoat: 'NA'
            },
            {
                transaction: trans
            });
            Object.assign(responseObj, { status: 'success' }, { result: 'success' });
            return responseObj;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async checkProductStatus(req) {
        try {
            let responseObj = {};
            var productObj = {};
                if (req.intGenericName == 1) {
                   
                    productObj = await models.tbl_product_master.findAll({
                        where: {
                            ProductId:{[Op.eq]:[req.str_BFGCode.trim()]},
                            ProductName:{[Op.eq]:req.str_Prd.trim()},
                            ProductVersion:{[Op.eq]:req.str_PV.trim()},
                            Version:{[Op.ne]:req.str_V.trim()},
                            GenericName:{[Op.eq]:req.str_GenericName},
                            SFOID: req.str_sfoid
                        }
                    });
                }
                else {
                    productObj = await models.tbl_product_master.findAll({
                        where: {
                            ProductId:{[Op.eq]:[req.str_BFGCode.trim()]},
                            ProductName:{[Op.eq]:req.str_Prd.trim()},
                            ProductVersion:{[Op.eq]:req.str_PV.trim()},
                            Version:{[Op.eq]:req.str_V.trim()},
                            SFOID: req.str_sfoid
                        }
                    });
                }

            

            // let result = await database.select(productObj);
            if (productObj.length != 0) {
                Object.assign(responseObj, { status: 'success' }, { result: 'Product Details already exist' });
                return responseObj;
            }
            else {
                Object.assign(responseObj, { status: 'success' }, { result: 'success' });
                return responseObj;
            }
        }
        catch (error) {
            return error;
        }
    }


    async addProductUncoated(req, isCompressed = true) 
    {
        try 
        {
            let responseObj = {};

            let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                var IsBilayer, IsTrilayer, IsCoated, IsGrannulation, IsCompress, IsContent1, IsContent2, IsContent3, IsContent4;

                IsBilayer = req.bln_TypeBiLayPrd == true ? 1 : 0;
                IsTrilayer = req.bln_TypeTriLayPrd == true ? 1 : 0;
                IsCoated = req.bln_TypeCoatPrd == true ? 1 : 0;
                IsGrannulation = req.bln_TypeGrannualPrd == true ? 1 : 0;
                IsCompress = req.bln_TypeCompressed == true ? 1 : 0;
                IsContent1 = (req.flt_Content1Std == "" || req.flt_Content1Std == null) ? 0 : 1;
                IsContent2 = (req.flt_Content2Std == "" || req.flt_Content2Std == null) ? 0 : 1;
                IsContent3 = (req.flt_Content3Std == "" || req.flt_Content3Std == null) ? 0 : 1;
                IsContent4 = (req.flt_Content3Std == "" || req.flt_Content4Std == null) ? 0 : 1;
    
                var genericName = "", intPrdType = 1;
                (req.intGenericName == 0) ? genericName = "NA" : genericName = req.str_GenericName;
                (req.bln_TypeDosaDry == true) ? intPrdType = 5 : intPrdType = req.int_prdType;
                
                await models.tbl_product_master.create
                ({
                    ProductId: req.str_BFGCode.trim(),
                    ProductName: req.str_Prd.trim(),
                    ProductType: intPrdType,
                    ProductVersion: req.str_PV.trim(),
                    Version: req.str_V.trim(),
                    SFOID:req.str_sfoid.trim(),
                    GenericName: genericName,
                    IsActive: 0,
                    isBinWeighing: (req.bln_IsBinWeiging == undefined) ? 0 : req.bln_IsBinWeiging,
                    BatchSize: (req.flt_BatchSize == "NA" || req.flt_BatchSize == undefined) ? 0 : req.flt_BatchSize ,
                    BatchUnit: (req.flt_BatchSize == undefined) ? "Unit" : req.str_BatchUnit ,
                    IsBilayer: (IsBilayer == undefined) ? 0 : IsBilayer,
                    IsBilayerLbl: IsBilayer == 1 ? req.biLayerLabel : "NA",
                    IsTrilayer: (IsTrilayer == undefined) ? 0 : IsTrilayer,
                    IsTrilayerLbl: IsTrilayer == 1 ? req.triLayerLabel : "NA",
                    IsCoated:(IsCoated == undefined) ? 0 : IsCoated,
                    IsGranulation:(IsGrannulation == undefined) ? 0 : IsGrannulation,
                    IsCompress:IsCompress,
                    NominalNomenclature:"Standard",
                    userID:req.loggedUserId,
                    ISBfGChecked:req.int_chkBFG,
                    ISPrdVersionChecked:req.int_chkPrdVersion,
                    ISVersionChecked:req.int_chkVersion,
                    IsContent1:IsContent1,
                    IsContent2:IsContent2,
                    IsContent3:IsContent3,
                    IsContent4:IsContent4,
                    // Upper_Surface: req.str_UpperSurface.trim(),
                    // Lower_Surface: req.str_LowerSurface.trim(),
                    // Appearance_Desc: req.str_ApperanceDesc,
                    // Appearance_Desc_Coat: req.str_ApperanceDesc_Coat
                },{
                    transaction: t
                });
    
                if(isCompressed == true || IsBilayer == true || IsTrilayer == true) 
                {
                    
                    var str_query = 
                    {
                        ProductId: req.str_BFGCode.trim(),
                        ProductName: req.str_Prd.trim(),
                        ProductVersion: req.str_PV.trim(),
                        GenericName: genericName,
                        SFOID:req.str_sfoid.trim(),
                        Version: req.str_V.trim(),
                        isBinWeighing: (req.bln_IsBinWeiging == undefined) ? 0 : req.bln_IsBinWeiging ,
                        locked: 0 ,
                    }
                    var str_tableName;
                    if(req.int_prdType == 1) 
                    {
                        str_tableName = clsTabletModel.strDetailTableName;
                        str_query = objClsTabletModel.pushParamDetailsTablet(str_query, req);
                    }
                    else 
                    {
                        str_tableName = clsCapsuleModel.strDetailTableName;
                        str_query = objClsCapsuleModel.pushParamDetailsCapsule(str_query, req);
                    }
                    console.log(str_query);
                    let prdDetObj = await models[str_tableName].create(
                        str_query,
                        {
                            transaction: t
                    });
    
                    now = new Date();
    
                    if(req.int_prdType == 1) 
                    {
                        var newData = "";
                        // newData = "Upper Surface of Tablets : " + req.str_UpperSurface + "| "
                        // newData = newData + "Lower Surface of Tablets : " + req.str_LowerSurface + "| " 
                        // newData = newData + "Apperance Description (Compression) : " + req.str_ApperanceDesc + "| "                         
                        newData = newData + (IsBilayer == 1 ? "Layer1 Name : " + req.biLayerLabel + "|" : "")
                        newData = newData + (IsTrilayer == 1 ? "Layer2 Name : " + req.triLayerLabel + "|" : "")
                        newData = newData + req.auditObject.result.Compressed.newData;
                    }
                    else 
                    {
                        var newData = req.auditObject.result.Capsule.newData;
                    }
    
                    var auditProductObj;
                    var genericName = req.str_GenericName;
    
                    if (req.int_prdType == 1) 
                    {
                        auditProductObj = await models.tbl_audit_product.create({
                            DT: date.format(now, 'YYYY-MM-DD'),
                            TM: date.format(now, 'HH:mm:ss'),
                            userid: req.loggedUserId,
                            username: req.loggedUserName,
                            ProductId: req.str_BFGCode.trim(),
                            ProductName: req.str_Prd.trim(),
                            PrdVersion: req.str_PV.trim(),
                            GenericName: genericName,
                            SFOID:req.str_sfoid.trim(),
                            Version: req.str_V.trim(),
                            ProductType: req.int_prdType,
                            OldValueComp: 'NA',
                            NewValueComp: newData,
                            OldValueGran: 'NA',
                            NewValueGran: 'NA',
                            OldValueCoat: 'NA',
                            NewValueCoat: 'NA',
                            Remark: req.remark,
                            ACT: req.action,
                            type: 'Compressed'
                        },{
                            transaction: t
                        });
                    }
                    else 
                    {
                        auditProductObj = await models.tbl_audit_product_capsule.create({
                            DT: date.format(now, 'YYYY-MM-DD'),
                            TM: date.format(now, 'HH:mm:ss'),
                            userid: req.loggedUserId,
                            username: req.loggedUserName,
                            ACT: req.action,
                            Remark: req.remark,
                            ProductId: req.str_BFGCode.trim(),
                            ProductName: req.str_Prd.trim(),
                            PrdVersion: req.str_PV.trim(),
                            Version: req.str_V.trim(),
                            ProductType: req.int_prdType,
                            OldValueComp: 'NA',
                            NewValueComp: newData,
                            GenericName: genericName,
                            type: 'Capsule Filling'
                        },{
                            transaction: t
                        });
                    }
    
                    now = new Date();
    
                    const activityLogObj = await models.tbl_activity_log.create
                    ({
                        dt:date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: req.loggedUserId,
                        username: req.loggedUserName,
                        activity:"Product Added"
                    },{
                        transaction: t
                    });
    
                    Object.assign(responseObj, { status: 'success' }, { result: 'Product Added Successfully' });
    
                }
                else 
                {
                    now = new Date();
    
                    const activityLogObj = await models.tbl_activity_log.create({
                        dt:date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: req.loggedUserId,
                        username: req.loggedUserName,
                        activity:"Product Added"
                    },{
                        transaction: t
                    });
    
                    Object.assign(responseObj, { status: 'success' }, { result: 'Product Added Successfully' });
                }
            });

            return responseObj;
        } 
        catch (err) 
        {
            console.log("addProductUncoated err",err);
            throw err;
        }
    }

    async getProductDetails(objProduct) {
        try {
            var prdResult;
                /** 5 for dosa dry */
                if(objProduct.ProductType == "1" || objProduct.ProductType == "5"){
                    //
                    prdResult = await models.tbl_product_tablet.findAll({
                        where:{ 
                            ProductId: objProduct.ProductId,
                            ProductName: objProduct.ProductName,
                            ProductVersion: objProduct.ProductVersion,
                            Version: objProduct.Version,
                            GenericName: objProduct.GenericName
                        }
                    });
                }
                else{
                    prdResult = await models.tbl_product_capsule.findAll({
                        where:{ 
                            ProductId: objProduct.ProductId,
                            ProductName: objProduct.ProductName,
                            ProductVersion: objProduct.ProductVersion,
                            Version: objProduct.Version,
                            GenericName: objProduct.GenericName
                        }
                    });
                }
            // let prdResult = database.select(productObj);
            return prdResult[0];
        } catch (err) {
            return err;
        }


    }

    /** as per discussion-03/10/2020 only granulation product will be displayed in cubicle setting */
    async getProductDetailForGranulation(req) {
        try {
            let responseObj = {};
            var arr_prdDetail = [];
            var arr_prdDetailGranual = [];

            var str = "";
            /** get product from cubicle only compression and coating, capsule filling product */

            let resGran = await models.tbl_product_master.findAll({
                attributes: [sequelize.fn('DISTINCT', sequelize.col('ProductId')),
                        'ProductName',
                        'ProductVersion',
                        'Version',
                        'SFOID'
                    ],
                    where:{
                        IsGranulation:1,
                        IsActive:1
                    }
            })

            arr_prdDetail.push(resGran);

            Object.assign(responseObj, { status: 'success' }, { result: arr_prdDetail[0] });
            return responseObj;
        }
        catch (error) {
            throw error;
        }
    }

    async getProductDetailsCoated(objProduct) {
        try {
           var productObj = await models.tbl_product_tablet_coated.findAll({
                where:{ 
                    ProductId: objProduct.ProductId,
                    ProductName: objProduct.ProductName,
                    ProductVersion: objProduct.ProductVersion,
                    Version: objProduct.Version,
                    GenericName: objProduct.GenericName
                }
            });

            let prdResult = await database.select(productObj);
            return prdResult[0];
        }
        catch (err) {
            return (err);
        }

    }

    async getProductInfo(objProduct) {
        try {
            const objMasterData = await this.getProductMasterData(objProduct);
            const objUncoatedData = await this.getProductDetails(objProduct);
            const objCoatedDetails = await this.getProductDetailsCoated(objProduct);

            const productInfo = [];
            productInfo.push(...objMasterData, ...objUncoatedData, ...objCoatedDetails);

            return productInfo;
        } catch (err) {
            return err;
        }
    }


    async addProductCoated(req) 
    {
        try 
        {
            var responseObj = {};
            let transaction = await seqTransaction.sequelize.transaction(async (t) =>
            {
                let responseObj = {};
                var genericName = "";
    
                (req.intGenericName == 0) ? genericName = "NA" : genericName = req.str_GenericName;
    
                var str_query = 
                {
                    ProductId: req.str_BFGCode.trim(),
                    ProductName: req.str_Prd.trim(),
                    ProductVersion: req.str_PV.trim(),
                    GenericName: genericName,
                    Version: req.str_V.trim(),
                    isBinWeighing: (req.bln_IsBinWeiging == undefined) ? 0 : req.bln_IsBinWeiging 
                    // locked: 0 ,
                }
    
                Object.assign(str_query, { ...objProduct.getIndividualObject(req, true) });//1
                Object.assign(str_query, { ...objProduct.getGroupObject(req, true) });//2
                Object.assign(str_query, { ...objProduct.getThicknessObject(req, true)});//3
                Object.assign(str_query, { ...objProduct.getBreadthObject(req, true)});//4
                Object.assign(str_query, { ...objProduct.getLengthObject(req, true)});//5
                Object.assign(str_query, { ...objProduct.getDiameterObject(req, true)});//6
                Object.assign(str_query, { ...objProduct.getHardnessObject(req, true)});//7
                Object.assign(str_query, { ...objProduct.getFriabilityObject(req, true)}); //8
                Object.assign(str_query, { ...objProduct.getDTObject(req, true)});//13
                Object.assign(str_query, { ...objProduct.getMouistueObject(req, true)});//16
    
                await models.tbl_product_tablet_coated.create
                (
                    str_query,{
                        transaction: t
                    }
                );
    
                now = new Date();
                var newData = "";
                if ((req.bln_TypeGrannualPrd == false) && (req.bln_TypeCompressed == false) &&
                    (req.bln_TypeCoatPrd == true) && (req.bln_TypeBiLayPrd == false) &&
                    (req.bln_TypeTriLayPrd == false) && (req.bln_IsBinWeiging == false)) 
                {
                    newData = "Upper Surface of Tablets : " + req.str_UpperSurface + "| "
                    newData = newData + "Lower Surface of Tablets : " + req.str_LowerSurface + "| " 
                }
                newData = newData + "Apperance Description (Coating) : " + req.str_ApperanceDesc_Coat + "| " 
                newData = newData + (req.auditObject.result.Coated.newData == undefined ? "NA" : req.auditObject.result.Coated.newData);

                const auditProductCoatedObj = await models.tbl_audit_product.create
                ({
                    DT: date.format(now, 'YYYY-MM-DD'),
                    TM: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    ProductId: req.str_BFGCode.trim(),
                    ProductName: req.str_Prd.trim(),
                    PrdVersion: req.str_PV.trim(),
                    GenericName: genericName,
                    Version: req.str_V.trim(),
                    ProductType: req.int_prdType,
                    OldValueComp: 'NA',
                    NewValueComp: 'NA',
                    OldValueGran: 'NA',
                    NewValueGran: 'NA',
                    OldValueCoat: 'NA',
                    NewValueCoat:  newData,
                    Remark: req.remark,
                    ACT: req.action,
                    type:'Coated'
                },{
                    transaction: t
                });
    
                const activityLogObj = await models.tbl_activity_log.create
                ({
                    dt:date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    activity:"Product Added"
                },{
                    transaction: t
                });

                return 'success';
            });

            Object.assign(responseObj, { status: 'success' }, { result: 'ProductCoated Added Successfully' });
            return responseObj;
        }
        catch (err) 
        {
            console.log("addProductCoated err",err);
            throw err;
        }

    }

    async addProductGranulation(req) {
        try {
            if (req.int_prdType == '1') {
                if ((req.bln_TypeGrannualPrd == true) && (req.bln_TypeCompressed == false)
                    && (req.bln_TypeCoatPrd == false) && (req.bln_TypeBiLayPrd == false)
                    && (req.bln_TypeTriLayPrd == false) && (req.bln_IsBinWeiging == false)) {
                    const granulationDetail = await this.insertGranulationDetail(req);
                    return granulationDetail;
                }
                else {
                    const granulationPerticular = await this.insertGranulationPerticular(req);
                    return granulationPerticular;
                }
            }
            else {
                const granulationPerticular = await this.insertGranulationPerticular(req);
                return granulationPerticular;
            }

        } catch (err) {
            console.log(err);
            throw err;
        }
    }

    async insertGranulationDetail(req) {
        try {
            var responseObj = {};
            let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                var IsBilayer, IsTrilayer, IsCoated, IsGrannulation, IsCompress;
                IsBilayer = req.bln_TypeBiLayPrd == true ? 1 : 0;
                IsTrilayer = req.bln_TypeTriLayPrd == true ? 1 : 0;
                IsCoated = req.bln_TypeCoatPrd == true ? 1 : 0;
                IsCompress = req.bln_TypeCompressed == true ? 1 : 0;
                IsGrannulation = req.bln_TypeGrannualPrd == true ? 1 : 0;

                var genericName = "";

                (req.intGenericName == 0) ? genericName = "NA" : genericName = req.str_GenericName;

            
                const insertProductObj = await models.tbl_product_master.create
                    ({
                        ProductId: req.str_BFGCode.trim(),
                        ProductName: req.str_Prd.trim(),
                        ProductType: req.int_prdType,
                        ProductVersion: req.str_PV.trim(),
                        Version: req.str_V.trim(),
                        IsActive: 0 ,
                        isBinWeighing: req.bln_IsBinWeiging,
                        BatchSize: req.flt_BatchSize,
                        BatchUnit: req.str_BatchUnit,
                        IsBilayer: IsBilayer,
                        IsBilayerLbl: req.biLayerLabel,
                        IsTrilayer: IsTrilayer,
                        IsTrilayerLbl: req.triLayerLabel,
                        IsCoated: IsCoated,
                        IsGranulation: IsGrannulation,
                        IsCompress: IsCompress,
                        NominalNomenclature: "Standard",
                        userID: req.loggedUserId,
                        GenericName: genericName,
                        ISBfGChecked:req.int_chkBFG,
                        ISPrdVersionChecked: req.int_chkPrdVersion,
                        ISVersionChecked: req.int_chkVersion,
                        Upper_Surface: req.str_UpperSurface,
                        Lower_Surface: req.str_LowerSurface,
                        Appearance_Desc: req.str_ApperanceDesc,
                        Appearance_Desc_Coat: req.str_ApperanceDesc_Coat
                    },{
                        transaction: t
                });
                
                var str_query = 
                    {
                        ProductId: req.str_BFGCode.trim(),
                        ProductName: req.str_Prd.trim(),
                        ProductVersion: req.str_PV.trim(),
                        Version: req.str_V.trim(),
                        GenericName: genericName,
                        editCounter: 0,
                        locked: 0 ,
                    };

                Object.assign(str_query, {...objProductGranulation.getLodDry(req)});//1
                Object.assign(str_query, {...objProductGranulation.getTabDensity(req)});//2
                Object.assign(str_query, {...objProductGranulation.getBulkDensity(req)});//3
                Object.assign(str_query, {...objProductGranulation.getLodLayer1Dry(req)});//4
                Object.assign(str_query, {...objProductGranulation.getTabDensity_Lay_1(req)});//5
                Object.assign(str_query, {...objProductGranulation.getBulkDensity_Lay_1(req)});//6
                Object.assign(str_query, {...objProductGranulation.getLodLayer2Dry(req)});//7
                Object.assign(str_query, {...objProductGranulation.getTabDensity_Lay_2(req)});//8
                Object.assign(str_query, {...objProductGranulation.getBulkDensity_Lay_2(req)});//9

                Object.assign(str_query, {...objProductGranulation.getFine_blw_30(req)});//10
                Object.assign(str_query, {...objProductGranulation.getFine_blw_40(req)});//11
                Object.assign(str_query, {...objProductGranulation.getFine_blw_60(req)});//12
                Object.assign(str_query, {...objProductGranulation.getFine_blw_80(req)});//13
                Object.assign(str_query, {...objProductGranulation.getFine_blw_100(req)});//14
                Object.assign(str_query, {...objProductGranulation.getFine_abv_30(req)});//15
                Object.assign(str_query, {...objProductGranulation.getFine_abv_40(req)});//16
                Object.assign(str_query, {...objProductGranulation.getFine_abv_60(req)});//17
                Object.assign(str_query, {...objProductGranulation.getFine_abv_80(req)});//18
                Object.assign(str_query, {...objProductGranulation.getFine_abv_100(req)});//19
                Object.assign(str_query, {...objProductGranulation.getFine_Pan(req)});//20

                Object.assign(str_query, {...objProductGranulation.getFine_blw_30_Lay_1(req)});//21
                Object.assign(str_query, {...objProductGranulation.getFine_blw_40_Lay_1(req)});//22
                Object.assign(str_query, {...objProductGranulation.getFine_blw_60_Lay_1(req)});//23
                Object.assign(str_query, {...objProductGranulation.getFine_blw_80_Lay_1(req)});//24
                Object.assign(str_query, {...objProductGranulation.getFine_blw_100_Lay_1(req)});//25
                Object.assign(str_query, {...objProductGranulation.getFine_abv_30_Lay_1(req)});//26
                Object.assign(str_query, {...objProductGranulation.getFine_abv_40_Lay_1(req)});//27
                Object.assign(str_query, {...objProductGranulation.getFine_abv_60_Lay_1(req)});//28
                Object.assign(str_query, {...objProductGranulation.getFine_abv_80_Lay_1(req)});//29
                Object.assign(str_query, {...objProductGranulation.getFine_abv_100_Lay_1(req)});//30
                Object.assign(str_query, {...objProductGranulation.getFine_Pan_Lay_1(req)});//31

                Object.assign(str_query, {...objProductGranulation.getFine_blw_30_Lay_2(req)});//32
                Object.assign(str_query, {...objProductGranulation.getFine_blw_40_Lay_2(req)});//33
                Object.assign(str_query, {...objProductGranulation.getFine_blw_60_Lay_2(req)});//34
                Object.assign(str_query, {...objProductGranulation.getFine_blw_80_Lay_2(req)});//35
                Object.assign(str_query, {...objProductGranulation.getFine_blw_100_Lay_2(req)});//36
                Object.assign(str_query, {...objProductGranulation.getFine_abv_30_Lay_2(req)});//37
                Object.assign(str_query, {...objProductGranulation.getFine_abv_40_Lay_2(req)});//38
                Object.assign(str_query, {...objProductGranulation.getFine_abv_60_Lay_2(req)});//39
                Object.assign(str_query, {...objProductGranulation.getFine_abv_80_Lay_2(req)});//40
                Object.assign(str_query, {...objProductGranulation.getFine_abv_100_Lay_2(req)});//41
                Object.assign(str_query, {...objProductGranulation.getFine_Pan_Lay_2(req)});//42

                Object.assign(str_query, {...objProductGranulation.getLodLubricated(req)});//43
                Object.assign(str_query, {...objProductGranulation.getLodLayer1Lubricated(req)});//44
                Object.assign(str_query, {...objProductGranulation.getLodLayer2Lubricated(req)});//45
                Object.assign(str_query, {...objProductGranulation.getFine(req)});//46
                Object.assign(str_query, {...objProductGranulation.getParticleSeizing(req)});//47
                Object.assign(str_query, {...objProductGranulation.getFine_Lay_1(req)});//48
                Object.assign(str_query, {...objProductGranulation.getFine_Lay_2(req)});//49

                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution(req)});//50
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_20(req)});//51
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_40(req)});//52
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_60(req)});//53
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_80(req)});//54
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_100(req)});//55
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_blw_100(req)});//56

                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_Lay_1(req)});//57
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_20_Lay_1(req)});//58
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_40_Lay_1(req)});//59
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_60_Lay_1(req)});//60
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_80_Lay_1(req)});//61
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_100_Lay_1(req)});//62
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_blw_100_Lay_1(req)});//63
                Object.assign(str_query, {...objProductGranulation.getParticleSeizing_Lay_1(req)});//64
                Object.assign(str_query, {...objProductGranulation.getParticleSeizing_Lay_2(req)});//65

                // Check whether Tablet or Capsule needs to be saved 
                var objInsertGranulationData;
                if (req.int_prdType == 1) {
                    //objInsertGranulationData.str_tableName = 'tbl_product_gran';
                    objInsertGranulationData = await models.tbl_product_gran.create
                    (
                        str_query,{
                            transaction: t
                        }
                    );
                }
                else {
                    //objInsertGranulationData.str_tableName = 'tbl_product_gran_cap';
                    objInsertGranulationData = await models.tbl_product_gran_cap.create
                    (
                        str_query,{
                            transaction: t
                        }
                    );
                }
                let now = new Date();

                if(req.int_prdType == 1) 
                {
                    var newData = "";
                    newData = "Upper Surface of Tablets : " + req.str_UpperSurface + "| "
                    newData = newData + "Lower Surface of Tablets : " + req.str_LowerSurface + "| " 
                    newData = newData + req.auditObject.result.Grannual.newData;
                }
                else 
                {
                    var newData = req.auditObject.result.Grannual.newData;
                }
                
                const auditProductGranulationObj = await models.tbl_audit_product.create({
                    DT: date.format(now, 'YYYY-MM-DD'),
                    TM: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    ACT: req.action,
                    Remark: req.remark,
                    ProductId: req.str_BFGCode.trim(),
                    ProductName: req.str_Prd.trim(),
                    PrdVersion: req.str_PV.trim(),
                    Version: req.str_V.trim(),
                    GenericName: genericName,
                    ProductType: req.int_prdType,
                    OldValueComp: 'NA',
                    NewValueComp: 'NA',
                    OldValueGran: 'NA',
                    NewValueGran: newData,
                    OldValueCoat: 'NA',
                    NewValueCoat: 'NA',
                    type: 'Granulation' 
                },{
                    transaction: t
                });
                
                const activityLogObj = await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    activity: "Product Added", 
                },{
                    transaction: t
                });
                
                return 'success';
            });
            Object.assign(responseObj, { status: 'success' }, { result: 'ProductGranulation Added Successfully' });
            return responseObj;
        } catch (err) {
            console.log("get",err);
            throw err;
        }

    }

    async insertGranulationPerticular(req) {
        try {
            var responseObj = {};
            let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                var genericName = "";
                (req.intGenericName == 0) ? genericName = "NA" : genericName = req.str_GenericName;
                var str_query = 
                {
                    ProductId: req.str_BFGCode.trim(),
                    ProductName: req.str_Prd.trim(),
                    ProductVersion: req.str_PV.trim(),
                    Version: req.str_V.trim(),
                    GenericName: genericName,
                    editCounter: 0,
                    locked: 0,
                }

                Object.assign(str_query, {...objProductGranulation.getLodDry(req)});//1
                Object.assign(str_query, {...objProductGranulation.getTabDensity(req)});//2
                Object.assign(str_query, {...objProductGranulation.getBulkDensity(req)});//3
                Object.assign(str_query, {...objProductGranulation.getLodLayer1Dry(req)});//4
                Object.assign(str_query, {...objProductGranulation.getTabDensity_Lay_1(req)});//5
                Object.assign(str_query, {...objProductGranulation.getBulkDensity_Lay_1(req)});//6
                Object.assign(str_query, {...objProductGranulation.getLodLayer2Dry(req)});//7
                Object.assign(str_query, {...objProductGranulation.getTabDensity_Lay_2(req)});//8
                Object.assign(str_query, {...objProductGranulation.getBulkDensity_Lay_2(req)});//9

                Object.assign(str_query, {...objProductGranulation.getFine_blw_30(req)});//10
                Object.assign(str_query, {...objProductGranulation.getFine_blw_40(req)});//11
                Object.assign(str_query, {...objProductGranulation.getFine_blw_60(req)});//12
                Object.assign(str_query, {...objProductGranulation.getFine_blw_80(req)});//13
                Object.assign(str_query, {...objProductGranulation.getFine_blw_100(req)});//14
                Object.assign(str_query, {...objProductGranulation.getFine_abv_30(req)});//15
                Object.assign(str_query, {...objProductGranulation.getFine_abv_40(req)});//16
                Object.assign(str_query, {...objProductGranulation.getFine_abv_60(req)});//17
                Object.assign(str_query, {...objProductGranulation.getFine_abv_80(req)});//18
                Object.assign(str_query, {...objProductGranulation.getFine_abv_100(req)});//19
                Object.assign(str_query, {...objProductGranulation.getFine_Pan(req)});//20

                Object.assign(str_query, {...objProductGranulation.getFine_blw_30_Lay_1(req)});//21
                Object.assign(str_query, {...objProductGranulation.getFine_blw_40_Lay_1(req)});//22
                Object.assign(str_query, {...objProductGranulation.getFine_blw_60_Lay_1(req)});//23
                Object.assign(str_query, {...objProductGranulation.getFine_blw_80_Lay_1(req)});//24
                Object.assign(str_query, {...objProductGranulation.getFine_blw_100_Lay_1(req)});//25
                Object.assign(str_query, {...objProductGranulation.getFine_abv_30_Lay_1(req)});//26
                Object.assign(str_query, {...objProductGranulation.getFine_abv_40_Lay_1(req)});//27
                Object.assign(str_query, {...objProductGranulation.getFine_abv_60_Lay_1(req)});//28
                Object.assign(str_query, {...objProductGranulation.getFine_abv_80_Lay_1(req)});//29
                Object.assign(str_query, {...objProductGranulation.getFine_abv_100_Lay_1(req)});//30
                Object.assign(str_query, {...objProductGranulation.getFine_Pan_Lay_1(req)});//31

                Object.assign(str_query, {...objProductGranulation.getFine_blw_30_Lay_2(req)});//32
                Object.assign(str_query, {...objProductGranulation.getFine_blw_40_Lay_2(req)});//33
                Object.assign(str_query, {...objProductGranulation.getFine_blw_60_Lay_2(req)});//34
                Object.assign(str_query, {...objProductGranulation.getFine_blw_80_Lay_2(req)});//35
                Object.assign(str_query, {...objProductGranulation.getFine_blw_100_Lay_2(req)});//36
                Object.assign(str_query, {...objProductGranulation.getFine_abv_30_Lay_2(req)});//37
                Object.assign(str_query, {...objProductGranulation.getFine_abv_40_Lay_2(req)});//38
                Object.assign(str_query, {...objProductGranulation.getFine_abv_60_Lay_2(req)});//39
                Object.assign(str_query, {...objProductGranulation.getFine_abv_80_Lay_2(req)});//40
                Object.assign(str_query, {...objProductGranulation.getFine_abv_100_Lay_2(req)});//41
                Object.assign(str_query, {...objProductGranulation.getFine_Pan_Lay_2(req)});//42

                Object.assign(str_query, {...objProductGranulation.getLodLubricated(req)});//43
                Object.assign(str_query, {...objProductGranulation.getLodLayer1Lubricated(req)});//44
                Object.assign(str_query, {...objProductGranulation.getLodLayer2Lubricated(req)});//45
                Object.assign(str_query, {...objProductGranulation.getFine(req)});//46
                Object.assign(str_query, {...objProductGranulation.getParticleSeizing(req)});//47
                Object.assign(str_query, {...objProductGranulation.getFine_Lay_1(req)});//48
                Object.assign(str_query, {...objProductGranulation.getFine_Lay_2(req)});//49

                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution(req)});//50
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_20(req)});//51
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_40(req)});//52
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_60(req)});//53
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_80(req)});//54
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_100(req)});//55
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_blw_100(req)});//56

                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_Lay_1(req)});//57
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_20_Lay_1(req)});//58
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_40_Lay_1(req)});//59
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_60_Lay_1(req)});//60
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_80_Lay_1(req)});//61
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_100_Lay_1(req)});//62
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_blw_100_Lay_1(req)});//63
                Object.assign(str_query, {...objProductGranulation.getParticleSeizing_Lay_1(req)});//64
                Object.assign(str_query, {...objProductGranulation.getParticleSeizing_Lay_2(req)});//65

                var objInsertGranulationData;
                if (req.int_prdType == 1) {
                    objInsertGranulationData = await models.tbl_product_gran.create
                    (
                        str_query,{
                            transaction: t
                        }
                    );
                }
                else {
                    objInsertGranulationData = await models.tbl_product_gran_cap.create
                    (
                        str_query,{
                            transaction: t
                        }
                    );
                }
                let now = new Date();
                
                var auditProductGranulationObj = 
                {
                    DT: date.format(now, 'YYYY-MM-DD'),
                    TM: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    ACT: req.action,
                    Remark: req.remark,
                    ProductId: req.str_BFGCode.trim(),
                    ProductName: req.str_Prd.trim(),
                    PrdVersion: req.str_PV.trim(),
                    Version: req.str_V.trim(),
                    GenericName: genericName,
                    ProductType: req.int_prdType,
                    OldValueComp: 'NA',
                    NewValueComp: 'NA',
                    OldValueGran: 'NA',
                    NewValueGran: req.auditObject.result.Grannual.newData,
                    OldValueCoat: 'NA',
                    NewValueCoat: 'NA',
                    type: 'Granulation'
                }
                var auditProductGranulationResult;
                if (req.int_prdType == 1) {
                    auditProductGranulationResult = await models.tbl_audit_product.create
                    (
                        auditProductGranulationObj,{
                            transaction: t
                        }
                    );
                    
                }
                else {
                    auditProductGranulationResult = await models.tbl_audit_product_capsule.create
                    (
                        auditProductGranulationObj,{
                            transaction: t
                        }
                    );
                }

                const activityLogObj = await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    activity: "Product Added", 
                },{
                    transaction: t
                });

                return 'success';
            });
            
            Object.assign(responseObj, { status: 'success' }, { result: 'ProductGranulation Added Successfully' });
            return responseObj;
        }
        catch (err) {
            console.log(err);
            throw err;
        }
    }

    async getProductDetail(req) {
        try {
            let obj_response = {};
            var str_cubicletype = req.type;
            let type = '';
            (req.areaName == "Softshell") ? type = "Softshell" : (req.areaName == "Pellets-II") ? type = "Capsule Filling" : type = req.type;
            var areaName = req.areaName;
            var selectData;
            if (str_cubicletype == 'Compression') {
                selectData = await models.tbl_product_master.findAll({
                    where:{ 
                        IsActive: 1,
                        ProductType:1,
                        IsCompress:1
                    }
                });
            } else if (str_cubicletype == 'Coating' || str_cubicletype == 'MIC') {
                selectData = await models.tbl_product_master.findAll({
                    where:{ 
                        IsActive: 1,
                        ProductType:1,
                        IsCoated:1
                    }
                });
            } else if (str_cubicletype == 'Granulation') {
                selectData = await models.tbl_product_master.findAll({
                    where:{ 
                        IsActive: 1,
                        IsGranulation:1
                    }
                });
            } else if (str_cubicletype == 'Capsule Filling') {
                selectData = await models.tbl_product_master.findAll({
                    where:{ 
                        IsActive: 1,
                        ProductType:2
                    }
                });
            }else {  //for IPQC/IPQA Area
                let query = {
                    where: { IsActive:1 }
                }
                // selectData = {
                //     str_tableName: 'tbl_product_master',
                //     data: '*',
                //     condition: [
                //         { str_colName: 'IsActive', value: 1, comp: 'eq' },
                //     ]
                // }
                if (areaName == "Compression" || areaName == "Effervescent Compression") {
                    Object.assign(query.where,{
                        IsCompress:1,
                        ProductType:1
                    })
                    // selectData.condition.push({ str_colName: 'IsCompress', value: 1, comp: 'eq' });
                    // selectData.condition.push({ str_colName: 'ProductType', value: 1, comp: 'eq' });
                }
                else if (areaName == "Coating") {
                    Object.assign(query.where,{IsCoated:1});
                    // selectData.condition.push({ str_colName: 'IsCoated', value: 1, comp: 'eq' });
                }
                else if (areaName == "Pallet Coating" || areaName == "Capsule Filling" || areaName == "Pellet IPQC") { // capsule granulation
                    Object.assign(query.where,{ProductType:2});
                    // selectData.condition.push({ str_colName: 'ProductType', value: 2, comp: 'eq' });
                }
                else if (areaName == "Granulation" || areaName == "MFG-3 IPQC" || areaName == "MFG-8 IPQC") {
                    Object.assign(query.where,{IsGranulation:1});
                    // selectData.condition.push({ str_colName: 'IsGranulation', value: 1, comp: 'eq' });
                }
                else if (areaName == "Multihaler") {
                    Object.assign(query.where,{ProductType:3});
                    // selectData.condition.push({ str_colName: 'ProductType', value: 3, comp: 'eq' });
                }
                else
                {
                    Object.assign(query.where,{ProductType:0});
                    // selectData.condition.push({ str_colName: 'ProductType', value: 0, comp: 'eq' }); // for NA
                }
                selectData = await models.tbl_product_master.findAll(query);
            }

            /** Client requirement - coating - comp,coat,NA */
            if(req.areaName == "Coating" && type == "Compression")
            {
                selectData = await models.tbl_product_master.findAll({
                    where:{ 
                        IsActive: 1,
                        ProductType:1,
                        IsCoated:1,
                        IsCompress:1
                    }
                });
                // selectData.condition.push({ str_colName: 'IsCoated', value: 1, comp: 'eq' });
            }

            let result = selectData;
            Object.assign(obj_response, { status: 'success' }, { result: result });
            return obj_response;
        }
        catch (error) {
            console.log(error);
            return error;
        }
    }
    /**
     * @description Function checks if Weighment is started or not
     * @param value Contains Product combination (Id, Name, Version, ProductVersion)
     * @returns Promise<> Function return Response object holding `instrument name` and status i-e `true`
     * or `false`
     */
    async checkForCapMaster(value) {
        try {
            let data = [];
            let responseObj = {};
            var str1 = (is_EditProductAfterBatchEnd == 1) ? 
            `BatchComplete = 0 and CubicleType<>'IPQC' and CubicleType<>'IPQA' and BFGCode='${value.ProductId}' AND ProductName='${value.ProductName}' AND PVersion='${value.ProductVersion}' AND VERSION='${value.Version}'`
            :
            `CubicleType<>'IPQC' and CubicleType<>'IPQA' and BFGCode='${value.ProductId}' AND ProductName='${value.ProductName}' AND PVersion='${value.ProductVersion}' AND VERSION='${value.Version}'`;
            
            var result = await sequelize.query(
                `SELECT RepSerNo FROM tbl_cap_master1 WHERE ${str1}
                 UNION SELECT RepSerNo FROM tbl_cap_master1_archived WHERE ${str1}
                 UNION SELECT RepSerNo FROM tbl_cap_master2 WHERE ${str1}               
                 UNION SELECT RepSerNo FROM tbl_cap_master2_archived WHERE ${str1}               
                 UNION SELECT RepSerNo FROM tbl_cap_master3 WHERE ${str1}               
                 UNION SELECT RepSerNo FROM tbl_cap_master3_archived WHERE ${str1}`,
                {
                
                  type: QueryTypes.SELECT
                }
                );
            
            if (result.length != 0) {
                data.push({ 'Balance': true })
            } else {
                data.push({ 'Balance': false });
            }
                var result1 = await sequelize.query(
                    `SELECT RepSerNo FROM tbl_cap_master4 WHERE ${str1}
                    UNION SELECT RepSerNo FROM tbl_cap_master4_archived WHERE ${str1}
                    UNION SELECT RepSerNo FROM tbl_cap_master5 WHERE ${str1}
                    UNION SELECT RepSerNo FROM tbl_cap_master5_archived WHERE ${str1}`,
                    {
                    
                      type: QueryTypes.SELECT
                    }
                );
            if (result1.length != 0) {
                data.push({ 'Vernier': true })
            } else {
                data.push({ 'Vernier': false });
            }
                var result2 = await sequelize.query(
                    `SELECT RepSerNo FROM tbl_cap_master6 WHERE ${str1}
                    UNION SELECT RepSerNo FROM tbl_cap_master6_archived WHERE ${str1}`,
                    {
                    
                      type: QueryTypes.SELECT
                    }
                );
            if (result2.length != 0) {
                data.push({ 'DT': true })
            } else {
                data.push({ 'DT': false });
            }
            Object.assign(responseObj, { status: 'success' }, { result: data });
            return responseObj;
        }
        catch (error) {
            console.log(error);
            return error;
        }
    }
    /**
     * @description Function checks if Weighment is started or not
     * @param value Contains Product combination (Id, Name, Version, ProductVersion)
     * @returns Promise<> Function return Response object holding `instrument name` and status i-e `true`
     * or `false`
     */
    async checkForTabMaster(value) {
        try {
            let data = [];
            let responseObj = {};
            var str1 = (is_EditProductAfterBatchEnd == 1) ? 
            `BatchComplete = 0 and CubicleType<>'IPQC' and CubicleType<>'IPQA' and BFGCode='${value.ProductId}' AND ProductName='${value.ProductName}' AND PVersion='${value.ProductVersion}' AND VERSION='${value.Version}' AND SFOID='${value.SFOID}'`
            :
            `CubicleType<>'IPQC' and CubicleType<>'IPQA' and BFGCode='${value.ProductId}' AND ProductName='${value.ProductName}' AND PVersion='${value.ProductVersion}' AND VERSION='${value.Version}' AND SFOID='${value.SFOID}'`;
            
            var str2 = (is_EditProductAfterBatchEnd == 1) ? 
            `BatchComplete = 0 and  BFGCode='${value.ProductId}' AND ProductName='${value.ProductName}' AND PVersion='${value.ProductVersion}' AND VERSION='${value.Version}' AND SFOID='${value.SFOID}'`
            :
            `BFGCode='${value.ProductId}' AND ProductName='${value.ProductName}' AND PVersion='${value.ProductVersion}' AND VERSION='${value.Version}' AND SFOID='${value.SFOID}'`;
            
                var result = await sequelize.query(
                `SELECT RepSerNo FROM tbl_tab_master1 WHERE ${str1} 
                UNION SELECT RepSerNo FROM tbl_tab_master1_archived WHERE ${str1}
                UNION SELECT RepSerNo FROM tbl_tab_master2 WHERE  ${str1}
                UNION SELECT RepSerNo FROM tbl_tab_master2_archived WHERE  ${str1}
                `,
                {
                
                  type: QueryTypes.SELECT
                }
                );
                /**
                 * UNION SELECT RepSerNo FROM tbl_tab_master9 WHERE  ${str1}
                UNION SELECT RepSerNo FROM tbl_tab_master9_archived WHERE  ${str1}
                UNION SELECT RepSerNo FROM tbl_tab_master10 WHERE  ${str1}
                UNION SELECT RepSerNo FROM tbl_tab_master10_archived WHERE  ${str1}
                UNION SELECT RepSerNo FROM tbl_tab_master11 WHERE  ${str1}
                UNION SELECT RepSerNo FROM tbl_tab_master11_archived WHERE  ${str1}
                UNION SELECT RepSerNo FROM tbl_tab_master12 WHERE  ${str1}
                UNION SELECT RepSerNo FROM tbl_tab_master12_archived WHERE  ${str1}
                UNION SELECT RepSerNo FROM tbl_tab_master17 WHERE  ${str1}
                UNION SELECT RepSerNo FROM tbl_tab_master17_archived WHERE  ${str1}
                 */
            if (result.length != 0) {
                data.push({ 'Balance': true })
            } else {
                data.push({ 'Balance': false });
            }
            
            //     var result1 = await sequelize.query(
            //         `SELECT RepSerNo FROM tbl_tab_master6 WHERE ${str1}
            //         UNION SELECT RepSerNo FROM tbl_tab_master6_archived WHERE ${str1}
            //         UNION SELECT RepSerNo FROM tbl_tab_master3 WHERE ${str1}
            //         UNION SELECT RepSerNo FROM tbl_tab_master3_archived WHERE ${str1}
            //         UNION SELECT RepSerNo FROM tbl_tab_master4 WHERE ${str1}
            //         UNION SELECT RepSerNo FROM tbl_tab_master4_archived WHERE ${str1}
            //         UNION SELECT RepSerNo FROM tbl_tab_master3 WHERE ${str1}
            //         UNION SELECT RepSerNo FROM tbl_tab_master3_archived WHERE ${str1}`,
            //         {
                    
            //           type: QueryTypes.SELECT
            //         }
            //       );
            // if (result1.length != 0) {
            //     data.push({ 'Vernier': true })
            // } else {
                data.push({ 'Vernier': false });
            // }
            
            //     var result2 = await sequelize.query(
            //         `SELECT RepSerNo FROM tbl_tab_master13 WHERE ${str1}
            //         UNION SELECT RepSerNo FROM tbl_tab_master13_archived WHERE ${str1}`,
            //         {
                    
            //           type: QueryTypes.SELECT
            //         }
            //       );
            // if (result2.length != 0) {
            //     data.push({ 'DT': true })
            // } else {
                data.push({ 'DT': false });
            // }
            
            //     var result3 = await sequelize.query(
            //         `SELECT RepSerNo FROM tbl_tab_friability WHERE ${str1}
            //         UNION SELECT RepSerNo FROM tbl_tab_friability_archived WHERE ${str1}`,
            //         {
                    
            //           type: QueryTypes.SELECT
            //         }
            //       );
            // if (result3.length != 0) {
            //     data.push({ 'Friability': true })
            // } else {
                data.push({ 'Friability': false });
            // }
            // var result4 = await sequelize.query(
            //     `SELECT RepSerNo FROM tbl_tab_tapdensity WHERE ${str2}
            //     UNION SELECT RepSerNo FROM tbl_tab_tapdensity_archived WHERE ${str2}`,
            //     {
                
            //       type: QueryTypes.SELECT
            //     }
            //   );
           
            // if (result4.length != 0) {
            //     data.push({ 'TDT': true })
            // } else {
                data.push({ 'TDT': false });
            // }
           
            //     var result5 = await sequelize.query(
            //         `SELECT RepSerNo FROM tbl_tab_master7 WHERE ${str1}
            //         UNION SELECT RepSerNo FROM tbl_tab_master7_archived WHERE ${str1}`,
            //         {
                    
            //           type: QueryTypes.SELECT
            //         }
            //       );
            // if (result5.length != 0) {
            //     data.push({ 'Hardness': true })
            // } else {
                data.push({ 'Hardness': false });
            // }
            // var result6 = await sequelize.query(
            //     `SELECT RepSerNo FROM tbl_lodmaster WHERE ${str2}
            //     UNION SELECT RepSerNo FROM tbl_lodmaster_archived WHERE ${str2}`,
            //     {
                
            //       type: QueryTypes.SELECT
            //     }
            //   );
            // if(result6.length != 0) {
            //     data.push({ 'LOD': true })
            // } else {
                data.push({ 'LOD': false });
            // }
                var result7 = await sequelize.query(
                    `SELECT RepSerNo FROM tbl_tab_masterhtd WHERE ${str1}
                    UNION SELECT RepSerNo FROM tbl_tab_masterhtd_archived WHERE ${str1}`,
                    {
                    
                      type: QueryTypes.SELECT
                    }
                  );
            if (result7.length != 0) {
                data.push({ 'Htd': true })
            } else {
                data.push({ 'Htd': false });
            }
            Object.assign(responseObj, { status: 'success' }, { result: data });
            return responseObj;
        }
        catch (error) {
            console.log(error);
            return error;
        }


    }


    async updateProductCapGran(req,t) {
        try {
            if (req.bln_TypeGrannualPrd == true || req.wasGrannual == true) {
                const checkGranulation = await this.checkGranulationCap(req);
                    if (checkGranulation.result == 'Product Granulation already exist' && req.auditObject.result.Grannual.result != "No Change") {
                        const updateGranulationDetail = await this.updateGranulationDetailCap(req,t);
                        return updateGranulationDetail;
                    }
                    else if (checkGranulation.result != 'Product Granulation already exist') {
                        const granulationDetail = await this.insertUpdateGranulationDetailCap(req,t);
                        return granulationDetail;
                    }
            }
        } catch (error) {
            throw error;
        }
    }
    async updateProductCap(req) {
        try {
            let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
            var updateProductCapsuleObj = {};
            var ObjProductCapWhereCondition = {};
            var updateProductCapObj = {};
            var ObjProductCapWhereCondition1 = {};
            var oldPrdVal = "", newPrdVal = "", newPrdValComp = "", oldPrdValComp = "";
            // below function is created to check if data exist in tbl_product_capsule table
            var insertNewCapsuleData = await this.insertNewCapsuleData(req);
            
            //Note Product detail No change not handle because user cannot change product detail after it go save.
            //update audit  data only when compressed changed and there is not "No Change" result for capsule
            if ((req.bln_TypeCompressed == true || req.wasCompressed == true) && (req.auditObject.result.Capsule.result == undefined  || req.auditObject.result.Capsule.result != 'No Change')) {
                if (req.auditObject.result.ProductDetail.result != "No Change")//detail change
                {
                    ObjProductCapWhereCondition = { 
                        where:{
                            ProductName: req.strOldPrd ,
                            ProductId: req.strOldBFG ,
                            ProductVersion: req.strOldPV ,
                            Version: req.strOldV ,
                            GenericName: req.strOldGName,
                        },
                        transaction: t
                    }

                    if(req.wasCompressed == false && req.bln_TypeCompressed == true){
                        //removed was capsule data when user unchecked capsule and edited header information
                        await models.tbl_product_capsule.destroy(ObjProductCapWhereCondition);
                        await models.tbl_product_master.update({ IsCompress:0 },ObjProductCapWhereCondition);
                    }else{
                        updateProductCapsuleObj = {
                            isBinWeighing: req.bln_IsBinWeiging,
                            BatchSize: req.flt_BatchSize,
                            BatchUnit: req.str_BatchUnit,
                            ProductName: req.str_Prd.trim(),
                            ProductId: req.str_BFGCode.trim(),
                            ProductVersion: req.str_PV.trim(),
                            GenericName: req.str_GenericName,
                            Version: req.str_V.trim(),
                            locked: 0,
                            IsActive: 0
                    }
                    
                    await models.tbl_product_master.update(updateProductCapsuleObj,ObjProductCapWhereCondition);

                    updateProductCapObj = {
                        //str_tableName: 'tbl_product_capsule',
                        isBinWeighing: req.bln_IsBinWeiging ,
                        ProductName: req.str_Prd.trim(),
                        ProductId: req.str_BFGCode.trim(),
                        ProductVersion: req.str_PV.trim(),
                        GenericName: req.str_GenericName,
                        Version: req.str_V.trim(),
                    }
                    ObjProductCapWhereCondition1 = {
                        where: { 
                            ProductName: req.strOldPrd,
                            ProductId: req.strOldBFG,
                            ProductVersion: req.strOldPV,
                            Version: req.strOldV,
                            GenericName: req.strOldGName,
                        },
                        transaction: t
                    }   
                    
                    Object.assign(updateProductCapObj,objUpdateProductCapsule.getIndividualObject(req, false));
                    Object.assign(updateProductCapObj,objUpdateProductCapsule.getGroupObject(req, false));
                    Object.assign(updateProductCapObj,objUpdateProductCapsule.getNetObject(req, false));
                    Object.assign(updateProductCapObj,objUpdateProductCapsule.getEmptyObject(req, false));
                    Object.assign(updateProductCapObj,objUpdateProductCapsule.getLengthObject(req, false));
                    Object.assign(updateProductCapObj,objUpdateProductCapsule.getDiameterObject(req, false));
                    Object.assign(updateProductCapObj,objUpdateProductCapsule.getDTObject(req, false));
                    Object.assign(updateProductCapObj,objUpdateProductCapsule.getContent1Object(req, false));
                    Object.assign(updateProductCapObj,objUpdateProductCapsule.getContent2Object(req, false));
                    Object.assign(updateProductCapObj,objUpdateProductCapsule.getContent3Object(req, false));
                    Object.assign(updateProductCapObj,objUpdateProductCapsule.getContent4Object(req, false));

                    await models.tbl_product_capsule.update(updateProductCapObj,ObjProductCapWhereCondition1);
                    }
                }
                else {
                    //update existing capsule data for compress parameter only when capsule is checked;              
                    if(insertNewCapsuleData == 1 && req.bln_TypeCompressed == true){

                        updateProductCapsuleObj = {
                            isBinWeighing: req.bln_IsBinWeiging,
                            BatchSize: req.flt_BatchSize,
                            BatchUnit: req.str_BatchUnit,
                            IsActive: 0 ,
                        }
                            
                        ObjProductCapWhereCondition = { 
                            where:{
                                ProductName: req.str_Prd.trim(),
                                ProductId: req.str_BFGCode.trim(),
                                ProductVersion: req.str_PV.trim(),
                                GenericName: req.str_GenericName,
                                Version: req.str_V.trim(),
                            },
                            transaction: t
                        }
                        
                        await models.tbl_product_master.update(updateProductCapsuleObj,ObjProductCapWhereCondition);
                        updateProductCapObj = {
                            //str_tableName: 'tbl_product_capsule',
                            isBinWeighing: req.bln_IsBinWeiging,
                        }
                        ObjProductCapWhereCondition1 = {
                            where: { ProductId: req.str_BFGCode.trim(),
                                ProductName: req.str_Prd.trim(),
                                ProductVersion: req.str_PV.trim(),
                                Version: req.str_V.trim(),
                                GenericName: req.str_GenericName,
                            },
                            transaction: t
                        }    
                        Object.assign(updateProductCapObj,objUpdateProductCapsule.getIndividualObject(req, false));
                        Object.assign(updateProductCapObj,objUpdateProductCapsule.getGroupObject(req, false));
                        Object.assign(updateProductCapObj,objUpdateProductCapsule.getNetObject(req, false));
                        Object.assign(updateProductCapObj,objUpdateProductCapsule.getEmptyObject(req, false));
                        Object.assign(updateProductCapObj,objUpdateProductCapsule.getLengthObject(req, false));
                        Object.assign(updateProductCapObj,objUpdateProductCapsule.getDiameterObject(req, false));
                        Object.assign(updateProductCapObj,objUpdateProductCapsule.getDTObject(req, false));
                        Object.assign(updateProductCapObj,objUpdateProductCapsule.getContent1Object(req, false));
                        Object.assign(updateProductCapObj,objUpdateProductCapsule.getContent2Object(req, false));
                        Object.assign(updateProductCapObj,objUpdateProductCapsule.getContent3Object(req, false));
                        Object.assign(updateProductCapObj,objUpdateProductCapsule.getContent4Object(req, false));
                        //let result1 = await database.update(updateProductCapObj);
                        await models.tbl_product_capsule.update(updateProductCapObj,ObjProductCapWhereCondition1);

                    }else {
                        //to insert new data or delete when capsule is unchecked
                        var IsCompress = 0;
                        (req.bln_TypeCompressed == true ? IsCompress = 1: IsCompress = 0)
                        let IsContent1 = (req.flt_Content1Std == "" || req.flt_Content1Std == null) ? 0 : 1;
                        let IsContent2 = (req.flt_Content2Std == "" || req.flt_Content2Std == null) ? 0 : 1;
                        let IsContent3 = (req.flt_Content3Std == "" || req.flt_Content3Std == null) ? 0 : 1;
                        let IsContent4 = (req.flt_Content3Std == "" || req.flt_Content4Std == null) ? 0 : 1;
            

                        updateProductCapsuleObj = {
                            //str_tableName: 'tbl_product_master',
                                isBinWeighing: req.bln_IsBinWeiging,
                                BatchSize: req.flt_BatchSize,
                                BatchUnit: req.str_BatchUnit,
                                IsActive: 0,
                                IsCompress: IsCompress,
                                IsContent1: IsContent1,
                                IsContent2: IsContent2,
                                IsContent3: IsContent3,
                                IsContent4: IsContent4,
                        }
                        ObjProductCapWhereCondition = {    
                            where:{
                                ProductName: req.str_Prd.trim(),
                                ProductId: req.str_BFGCode.trim(),
                                ProductVersion: req.str_PV.trim(),
                                GenericName: req.str_GenericName,
                                Version: req.str_V.trim(),
                            },
                            transaction: t
                        }
                        
                        await models.tbl_product_master.update(updateProductCapsuleObj,ObjProductCapWhereCondition);

                        updateProductCapObj = {
                            //str_tableName: 'tbl_product_capsule',
                                ProductId: req.str_BFGCode.trim(),
                                Version: req.str_V.trim(),
                                ProductVersion: req.str_PV.trim(),
                                ProductName: req.str_Prd.trim(),
                        }
                        if(req.wasCompressed == true){
                            //delete when user unchecked the capsule parameter
                            await models.tbl_product_capsule.destroy({ where : updateProductCapObj,transaction: t});
                        }else{
                            //add new capsule parameter
                            Object.assign(updateProductCapObj, { locked: 0,editCounter: 0,isBinWeighing: req.bln_IsBinWeiging,GenericName: req.str_GenericName});
                            Object.assign(updateProductCapObj,objUpdateProductCapsule.getIndividualObject(req, false));
                            Object.assign(updateProductCapObj,objUpdateProductCapsule.getGroupObject(req, false));
                            Object.assign(updateProductCapObj,objUpdateProductCapsule.getNetObject(req, false));
                            Object.assign(updateProductCapObj,objUpdateProductCapsule.getEmptyObject(req, false));
                            Object.assign(updateProductCapObj,objUpdateProductCapsule.getLengthObject(req, false));
                            Object.assign(updateProductCapObj,objUpdateProductCapsule.getDiameterObject(req, false));
                            Object.assign(updateProductCapObj,objUpdateProductCapsule.getDTObject(req, false));
                            Object.assign(updateProductCapObj,objUpdateProductCapsule.getContent1Object(req));
                            Object.assign(updateProductCapObj,objUpdateProductCapsule.getContent2Object(req));
                            Object.assign(updateProductCapObj,objUpdateProductCapsule.getContent3Object(req));
                            Object.assign(updateProductCapObj,objUpdateProductCapsule.getContent4Object(req));
    
                            await models.tbl_product_capsule.create(
                                updateProductCapObj,{
                                transaction: t
                            });
                        }
                    }
                   
                }
                now = new Date();

                (req.auditObject.result.ProductDetail.newData == undefined) ? newPrdVal = "NA" : newPrdVal = req.auditObject.result.ProductDetail.newData;
                (req.auditObject.result.ProductDetail.oldData == undefined) ? oldPrdVal = "NA" : oldPrdVal = req.auditObject.result.ProductDetail.oldData;

                if((req.auditObject.result.ProductDetail.newData == undefined) && (req.auditObject.result.Capsule.newData != undefined)){
                    newPrdVal = req.auditObject.result.Capsule.newData;
                }else if((req.auditObject.result.ProductDetail.newData != undefined) && (req.auditObject.result.Capsule.newData == undefined)){
                    newPrdVal = req.auditObject.result.ProductDetail.newData;
                }
                  else {
                    newPrdVal = req.auditObject.result.ProductDetail.newData + ' | '+req.auditObject.result.Capsule.newData;
                }

                if((req.auditObject.result.ProductDetail.oldData == undefined) && (req.auditObject.result.Capsule.oldData != undefined)){
                    oldPrdVal = req.auditObject.result.Capsule.oldData;
                }else if((req.auditObject.result.ProductDetail.oldData != undefined) && (req.auditObject.result.Capsule.oldData == undefined)){
                    oldPrdVal = req.auditObject.result.ProductDetail.oldData;
                } else {
                    oldPrdVal = req.auditObject.result.ProductDetail.oldData+' | '+req.auditObject.result.Capsule.oldData;
                }

                if((req.auditObject.result.ProductDetail.newData != undefined) && (req.auditObject.result.Capsule.newData == undefined)){
                    newPrdValComp = req.auditObject.result.ProductDetail.newData;
                }else{
                    if((req.auditObject.result.ProductDetail.newData == undefined) && (req.auditObject.result.Capsule.newData != undefined)){
                        newPrdValComp = req.auditObject.result.Capsule.newData;
                    }else{
                        newPrdValComp = req.auditObject.result.ProductDetail.newData+' | '+req.auditObject.result.Capsule.newData;
                    }
                    
                }

                if((req.auditObject.result.ProductDetail.oldData != undefined) && (req.auditObject.result.Capsule.oldData == undefined)){
                    oldPrdValComp = req.auditObject.result.ProductDetail.oldData;
                }else{
                    if((req.auditObject.result.ProductDetail.oldData == undefined) && (req.auditObject.result.Capsule.oldData != undefined)){
                        oldPrdValComp = req.auditObject.result.Capsule.oldData;
                    }else{
                        oldPrdValComp = req.auditObject.result.ProductDetail.oldData + ' | '+req.auditObject.result.Capsule.oldData;
                    }
                    
                }

                await models.tbl_audit_product_capsule.create(
                        {
                        DT: date.format(now, 'YYYY-MM-DD'),
                        TM: date.format(now, 'HH:mm:ss'),
                        userid: req.loggedUserId,
                        username: req.loggedUserName,
                        ProductId: req.str_BFGCode.trim(),
                        ProductName: req.str_Prd.trim(),
                        PrdVersion: req.str_PV.trim(),
                        Version: req.str_V.trim(),
                        GenericName: req.str_GenericName,
                        ProductType: 2,
                        ACT: req.action,
                        Remark: req.remark,
                        OldValueComp:oldPrdValComp,
                        NewValueComp:newPrdValComp,
                        OldValueCoat: 'NA',
                        NewValueCoat: 'NA',
                        NewValueGran: "NA",
                        OldValueGran: "NA",
                        type: 'Capsule Filling',
                        NewValue: newPrdVal,
                        OldValue: oldPrdVal,
                        },{
                            transaction: t
                        } 
                );

                // let result7 = await models.tbl_audit_product_capsule.create(
                //     auditProductObj,{
                //     transaction: t
                // });
            }
            await this.updateProductCapGran(req,t);
            now = new Date();
            const activityLogObj = {
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    activity: "Product Updated",
            }
            let result8 = await models.tbl_activity_log.create(
                activityLogObj,{
                transaction: t
            });
        });
        var responseObj = {};
            Object.assign(responseObj, { status: 'success' }, { result: 'Product Updated Successfully' });
            return responseObj;

        } catch (error) {
            console.log(error);
            return error;
        }
    }

    async insertNewCapsuleData(req){
        try{
            
            const objCapsule = await models.tbl_product_capsule.findAll({
                where: {
                    ProductId:req.str_BFGCode.trim(),
                    ProductName:req.str_Prd.trim(),
                    ProductVersion:req.str_PV.trim(),
                    Version:req.str_V.trim() 
                }
            });
            var result = objCapsule;
            if(result.length > 0){
                return 1;
            }else{
                return 0;
            }
                
        }catch(error){
            return error;
        }
    }

    async updateProductUncoated(req, t, isCompressed = true) {
        try {
            /**
             * In the case when user change the bilayer option than checkProductUncoated will hold undefine value because we are deleting
             * data from the same table at the start and u cant fetch data on which opration is performed during transaction SQL>
             */
            let checkProductUncoated ;
            if(req.auditObject.result.ProductDetail.result != "No Change" || (req.bln_TypeCompressed == false && req.wasCompressed == true)){
                //when product is change setting default data to insert in the table.
                //avoiding 30 seconds delay for timeout query process during transaction.
                checkProductUncoated = { status: 'success' , result: 'success'};
            }else{
                checkProductUncoated = await this.checkProductUncoatedStatus(req);
            }
            if (checkProductUncoated.result == 'Product Uncoated already exist' &&
                req.auditObject.result.Compressed.result != "No Change") {
                const updateUnCoatedPro = await this.updateProductUncoatedValue(req, t, isCompressed);
                return updateUnCoatedPro;
            }
            else if (checkProductUncoated.result != 'Product Uncoated already exist') {
                const insertUnCoatedPro = await this.insertProductUncoatedValue(req, t, isCompressed);
                return insertUnCoatedPro;
            }
            else if (req.auditObject.result.ProductDetail.result != "No Change") {
                //This condition will never occur
                const updateUnCoatedPro = await this.updateProductUncoatedValue(req, t, isCompressed);
                return updateUnCoatedPro;
            }
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async insertProductUncoatedValue(req, t, isCompressed = true) {
        try {                
                var IsBilayer, IsTrilayer, IsCoated, IsGrannulation, IsCompress, IsDosaDry;
                IsBilayer = req.bln_TypeBiLayPrd == true ? 1 : 0;
                IsTrilayer = req.bln_TypeTriLayPrd == true ? 1 : 0;
                IsCoated = req.bln_TypeCoatPrd == true ? 1 : 0;
                IsGrannulation = req.bln_TypeGrannualPrd == true ? 1 : 0;
                IsCompress = req.bln_TypeCompressed == true ? 1 : 0;
                var mainData = {};
                var whereConditionData = {};
                var mainData1 = {};
                if (req.intGenericName == 1) {
                    IsDosaDry = req.bln_TypeDosaDry == true ? 5 : req.int_prdType;
                    mainData = {
                        ProductType: IsDosaDry,
                        isBinWeighing: req.bln_IsBinWeiging,
                        BatchSize: req.flt_BatchSize,
                        BatchUnit: req.str_BatchUnit,
                        IsBilayer: IsBilayer,
                        IsBilayerLbl: req.biLayerLabel,
                        IsTrilayer: IsTrilayer,
                        IsTrilayerLbl: req.triLayerLabel,
                        IsCoated: IsCoated,
                        IsGranulation: IsGrannulation,
                        IsCompress: IsCompress,
                        NominalNomenclature: "Standard",
                        userID: req.loggedUserId,
                        ProductName: req.str_Prd.trim(),
                        ProductId: req.str_BFGCode.trim(),
                        ProductVersion: req.str_PV.trim(),
                        GenericName: req.str_GenericName,
                        Version: req.str_V.trim(),
                        Upper_Surface : req.str_UpperSurface,
                        Lower_Surface : req.str_LowerSurface,
                        Appearance_Desc : req.str_ApperanceDesc,
                        Appearance_Desc_Coat: req.str_ApperanceDesc_Coat,
                        SFOID: req.str_sfoid
                    };
                    whereConditionData = {
                        where: {
                            ProductId: req.strOldBFG,
                            ProductName: req.strOldPrd,
                            ProductVersion: req.strOldPV,
                            Version: req.strOldV,
                            GenericName: req.strOldGName,
                            SFOID:req.strOldSFOID
                        },
                        transaction: t
                    };
                }
                else {
                    mainData = {
                        isBinWeighing: req.bln_IsBinWeiging,
                        BatchSize: req.flt_BatchSize,
                        BatchUnit: req.str_BatchUnit,
                        IsBilayer: IsBilayer,
                        IsBilayerLbl: req.biLayerLabel,
                        IsTrilayer: IsTrilayer,
                        IsTrilayerLbl: req.triLayerLabel,
                        IsCoated: IsCoated,
                        IsGranulation: IsGrannulation,
                        IsCompress: IsCompress,
                        NominalNomenclature: "Standard",
                        userID: req.loggedUserId,
                        ProductName: req.str_Prd.trim(),
                        ProductId: req.str_BFGCode.trim(),
                        ProductVersion: req.str_PV.trim(),
                        Version: req.str_V.trim(),
                        Upper_Surface : req.str_UpperSurface,
                        Lower_Surface : req.str_LowerSurface,
                        Appearance_Desc : req.str_ApperanceDesc,
                        Appearance_Desc_Coat: req.str_ApperanceDesc_Coat,
                        SFOID: req.str_sfoid
                    };
                    whereConditionData = {
                        where: {
                            ProductId: req.strOldBFG,
                            ProductName: req.strOldPrd,
                            ProductVersion: req.strOldPV,
                            Version: req.strOldV,
                            SFOID:req.strOldSFOID
                        },
                        transaction: t
                    };
                }

                await models.tbl_product_master.update(
                    mainData,
                    whereConditionData
                );

                if (isCompressed == true || IsBilayer == true || IsTrilayer == true) {
                    var insertProductTabObj = {
                        str_tableName: '',
                    };
                    if (req.intGenericName == 1) {
                        mainData1 = {
                            ProductId: req.str_BFGCode.trim(),
                            ProductName: req.str_Prd.trim(),
                            ProductVersion: req.str_PV.trim(),
                            Version: req.str_V.trim(),
                            GenericName: req.str_GenericName,
                            isBinWeighing: req.bln_IsBinWeiging,
                            SFOID:req.str_sfoid,
                            locked: 0
                        };
                    }
                    else {
                        mainData1 = {
                            ProductId: req.str_BFGCode.trim(),
                            ProductName: req.str_Prd.trim(),
                            ProductVersion: req.str_PV.trim(),
                            Version: req.str_V.trim(),
                            isBinWeighing: req.bln_IsBinWeiging,
                            SFOID:req.str_sfoid,
                            locked: 0
                        };
                    }

                    if (req.int_prdType == 1) {
                        insertProductTabObj.str_tableName = clsTabletModel.strDetailTableName;
                        mainData1 = objClsTabletModel.pushParamDetailsTablet(mainData1, req);
                    }
                    //console.log(insertProductTabObj);
                    let result1 = await models[''+insertProductTabObj.str_tableName].create(
                        mainData1,
                        { transaction: t }
                    );

                    now = new Date();
                    var oldPrdVal = "", newPrdVal = "", newPrdValComp = "", oldPrdValComp = "";
                    (req.auditObject.result.ProductDetail.newData == undefined) ? newPrdVal = "" : newPrdVal = req.auditObject.result.ProductDetail.newData + " | ";
                    (req.auditObject.result.ProductDetail.oldData == undefined) ? oldPrdVal = "" : oldPrdVal = req.auditObject.result.ProductDetail.oldData + " | ";
                    (req.auditObject.result.Compressed.newData == undefined) ? newPrdValComp = "" : newPrdValComp = req.auditObject.result.Compressed.newData;
                    (req.auditObject.result.Compressed.oldData == undefined) ? oldPrdValComp = "" : oldPrdValComp = req.auditObject.result.Compressed.oldData;

                    var strGenericName = "";
                    (req.intGenericName == 1) ? strGenericName = req.str_GenericName : strGenericName = "NA";
                    await models.tbl_audit_product.create({
                        DT: date.format(now, 'YYYY-MM-DD'),
                        TM: date.format(now, 'HH:mm:ss'),
                        userid: req.loggedUserId,
                        username: req.loggedUserName,
                        ACT: req.action,
                        Remark: req.remark,
                        ProductId: req.str_BFGCode.trim(),
                        ProductName: req.str_Prd.trim(),
                        PrdVersion: req.str_PV.trim(),
                        Version: req.str_V.trim(),
                        GenericName: strGenericName,
                        ProductType: req.int_prdType,
                        OldValueComp: oldPrdVal + oldPrdValComp,
                        NewValueComp: newPrdVal + newPrdValComp,
                        OldValueGran: 'NA',
                        NewValueGran: 'NA',
                        OldValueCoat: 'NA',
                        NewValueCoat: 'NA',
                        type: 'Compressed',
                        NewValue: newPrdVal,
                        OldValue: oldPrdVal,
                        SFOID: req.str_sfoid
                    },{
                        transaction: t
                    });
                    
                    await models.tbl_activity_log.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: req.loggedUserId,
                        username: req.loggedUserName,
                        activity: "Product Updated", 
                    },{
                        transaction: t
                    });
                    
                }
                else {
                    //audit entry when user uncheck any parameter while changing bilayer and trilayer
                    if((req.bln_TypeCompressed == false && req.wasCompressed == true) ||
                    (req.bln_TypeBiLayPrd == false && req.wasBilayer == true) ||
                    ( req.bln_TypeTriLayPrd == false && req.wasTrilayer == true)){
                        now = new Date();
                        var oldPrdVal = "", newPrdVal = "", newPrdValComp = "", oldPrdValComp = "";
                        (req.auditObject.result.ProductDetail.newData == undefined) ? newPrdVal = "" : newPrdVal = req.auditObject.result.ProductDetail.newData + " | ";
                        (req.auditObject.result.ProductDetail.oldData == undefined) ? oldPrdVal = "" : oldPrdVal = req.auditObject.result.ProductDetail.oldData + " | ";
                        (req.auditObject.result.Compressed.newData == undefined) ? newPrdValComp = "" : newPrdValComp = req.auditObject.result.Compressed.newData;
                        (req.auditObject.result.Compressed.oldData == undefined) ? oldPrdValComp = "" : oldPrdValComp = req.auditObject.result.Compressed.oldData;
    
                        var strGenericName = "";
                        (req.intGenericName == 1) ? strGenericName = req.str_GenericName : strGenericName = "NA";
                        await models.tbl_audit_product.create({
                            DT: date.format(now, 'YYYY-MM-DD'),
                            TM: date.format(now, 'HH:mm:ss'),
                            userid: req.loggedUserId,
                            username: req.loggedUserName,
                            ACT: req.action,
                            Remark: req.remark,
                            ProductId: req.str_BFGCode.trim(),
                            ProductName: req.str_Prd.trim(),
                            PrdVersion: req.str_PV.trim(),
                            Version: req.str_V.trim(),
                            GenericName: strGenericName,
                            ProductType: req.int_prdType,
                            OldValueComp: oldPrdVal + oldPrdValComp,
                            NewValueComp: newPrdVal + newPrdValComp,
                            OldValueGran: 'NA',
                            NewValueGran: 'NA',
                            OldValueCoat: 'NA',
                            NewValueCoat: 'NA',
                            type: 'Compressed',
                            NewValue: newPrdVal,
                            OldValue: oldPrdVal,
                            SFOID: req.str_sfoid
                        },{
                            transaction: t
                        });
                    }
                    now = new Date();
                    await models.tbl_activity_log.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: req.loggedUserId,
                        username: req.loggedUserName,
                        activity: "Product Updated", 
                    },{
                        transaction: t
                    });

                }

            var responseObj = {};
            Object.assign(responseObj, { status: 'success' }, { result: 'Product Updated Successfully' });
            return responseObj;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }
    
    async updateProductUncoatedValue(req, t, isCompressed = true) {
        try {

                var IsBilayer, IsTrilayer, IsCoated, IsGrannulation, IsCompress, IsDosaDry;
                var now = new Date();
                IsBilayer = req.bln_TypeBiLayPrd == true ? 1 : 0;
                IsTrilayer = req.bln_TypeTriLayPrd == true ? 1 : 0;
                IsCoated = req.bln_TypeCoatPrd == true ? 1 : 0;
                IsGrannulation = req.bln_TypeGrannualPrd == true ? 1 : 0;
                IsCompress = req.bln_TypeCompressed == true ? 1 : 0;
                var mainData = {};
                var whereConditionData = {};
                var mainData1 = {};
                var whereConditionData1 = {};
                if (req.intGenericName == 1) {
                    IsDosaDry = req.bln_TypeDosaDry == true ? 5 : req.int_prdType;
                    mainData = {
                        ProductType: IsDosaDry,
                        isBinWeighing: (req.bln_IsBinWeiging == undefined) ? 0 : req.bln_IsBinWeiging,
                        BatchSize: (req.flt_BatchSize == undefined) ? 0 : req.flt_BatchSize,
                        BatchUnit: (req.str_BatchUnit == undefined) ? "Unit" : req.str_BatchUnit,
                        IsBilayer: (IsBilayer == undefined) ? 0 : IsBilayer,
                        IsBilayerLbl: (req.biLayerLabel == undefined) ? "NA" : req.biLayerLabel,
                        IsTrilayer: (IsTrilayer == undefined) ? 0 : IsTrilayer,
                        IsTrilayerLbl: (req.triLayerLabel == undefined) ? "NA" : req.triLayerLabel,
                        IsCoated: (IsCoated == undefined) ? 0 : IsCoated,
                        IsGranulation: (IsGrannulation == undefined) ? 0 : IsGrannulation,
                        IsCompress: IsCompress ,
                        NominalNomenclature: "Standard",
                        userID: req.loggedUserId,
                        Upper_Surface : req.str_UpperSurface,
                        Lower_Surface : req.str_LowerSurface,
                        Appearance_Desc : req.str_ApperanceDesc,
                        Appearance_Desc_Coat: req.str_ApperanceDesc_Coat
                    };
                    whereConditionData = {
                        where:{
                            ProductName: req.str_Prd.trim(),
                            ProductId: req.str_BFGCode.trim(),
                            ProductVersion: req.str_PV.trim(),
                            Version: req.str_V.trim(),
                            GenericName:req.str_GenericName,
                            SFOID:req.str_sfoid.trim()
                        },
                        transaction: t
                    };
                }
                else {
                    mainData = {
                        isBinWeighing: (req.bln_IsBinWeiging == undefined) ? 0 : req.bln_IsBinWeiging,
                        BatchSize: (req.flt_BatchSize == undefined) ? 0 : req.flt_BatchSize,
                        BatchUnit: (req.str_BatchUnit == undefined) ? "Unit" : req.str_BatchUnit,
                        IsBilayer: (IsBilayer == undefined) ? 0 : IsBilayer,
                        IsBilayerLbl: (req.biLayerLabel == undefined) ? "NA" : req.biLayerLabel,
                        IsTrilayer: (IsTrilayer == undefined) ? 0 : IsTrilayer,
                        IsTrilayerLbl: (req.triLayerLabel == undefined) ? "NA" : req.triLayerLabel,
                        IsCoated: (IsCoated == undefined) ? 0 : IsCoated,
                        IsGranulation: (IsGrannulation == undefined) ? 0 : IsGrannulation,
                        IsCompress: IsCompress,
                        NominalNomenclature: "Standard",
                        Upper_Surface : req.str_UpperSurface,
                        Lower_Surface : req.str_LowerSurface,
                        Appearance_Desc : req.str_ApperanceDesc,
                        Appearance_Desc_Coat: req.str_ApperanceDesc_Coat
                        //userID', value: req.loggedUserId,     
                    };
                    whereConditionData = {
                        where: {
                            ProductName: req.str_Prd.trim(),
                            ProductId: req.str_BFGCode.trim(),
                            ProductVersion: req.str_PV.trim(),
                            Version: req.str_V.trim(),
                            SFOID:req.str_sfoid.trim()
                        },
                        transaction: t
                    };                        
                }

                await models.tbl_product_master.update
                (
                    mainData,
                    whereConditionData
                );

                if (isCompressed == true || IsBilayer == true || IsTrilayer == true) {
                    if (req.intGenericName == 1) {
                        mainData1 = {isBinWeighing: (req.bln_IsBinWeiging == undefined) ? 0 : req.bln_IsBinWeiging };
                        whereConditionData1 = {
                            where: {
                                ProductId: req.str_BFGCode.trim(),
                                ProductName: req.str_Prd.trim(),
                                ProductVersion: req.str_PV.trim(),
                                Version: req.str_V.trim(),
                                GenericName: req.str_GenericName,
                                SFOID:req.str_sfoid.trim()
                            },
                            transaction: t
                        };
                            
                    }
                    else {
                        mainData1 = {isBinWeighing: (req.bln_IsBinWeiging == undefined) ? 0 : req.bln_IsBinWeiging};
                        whereConditionData1 = {
                            where: {
                                ProductId: req.str_BFGCode.trim(),
                                ProductName: req.str_Prd.trim(),
                                ProductVersion: req.str_PV.trim(),
                                Version: req.str_V.trim(),
                                GenericName: req.str_GenericName,
                                SFOID:req.str_sfoid.trim()
                            },
                            transaction: t
                        };
                    }

                    Object.assign(mainData1,objUpdateProduct.getIndividualObject(req, false));//1
                    Object.assign(mainData1,objUpdateProduct.getGroupObject(req, false));//2

                    Object.assign(mainData1,objUpdateProduct.getThicknessObject(req, false));//3
                    Object.assign(mainData1,objUpdateProduct.getBreadthObject(req, false));//4
                    Object.assign(mainData1,objUpdateProduct.getLengthObject(req, false));//5
                    Object.assign(mainData1,objUpdateProduct.getDiameterObject(req, false));//6

                    Object.assign(mainData1,objUpdateProduct.getHardnessObject(req, false));//7
                    Object.assign(mainData1,objUpdateProduct.getFriabilityObject(req, false));//8

                    Object.assign(mainData1,objUpdateProduct.getIndividualLay1Object(req));//9
                    Object.assign(mainData1,objUpdateProduct.getGroupLay1Object(req));//10
                    Object.assign(mainData1,objUpdateProduct.getIndividualLay2Object(req));//11
                    Object.assign(mainData1,objUpdateProduct.getGroupLay2Object(req));//12

                    Object.assign(mainData1,objUpdateProduct.getDTObject(req, false));//13
                    Object.assign(mainData1,objUpdateProduct.getTabDenObject(req));//15
                    Object.assign(mainData1,objUpdateProduct.getMouistueObject(req, false));//16
                    Object.assign(mainData1,objUpdateProduct.getSivShakerObject(req));//17

                    Object.assign(mainData1,objUpdateProduct.getDTObject_Lay_1(req, false));//19
                    Object.assign(mainData1,objUpdateProduct.getDTObject_Lay_2(req, false));//20

                    //Object.assign(mainData1,...objUpdateProduct.getYieldObject(req,false));//17
                    console.log(mainData1);
                    await models.tbl_product_tablet.update(
                        mainData1,whereConditionData1
                    );

                    now = new Date();
                    var oldPrdVal = "", newPrdVal = "", oldPrdValComp = "", newPrdValComp = "";
                    (req.auditObject.result.ProductDetail.newData == undefined) ? newPrdVal = "" : newPrdVal = req.auditObject.result.ProductDetail.newData + " | ";
                    (req.auditObject.result.ProductDetail.oldData == undefined) ? oldPrdVal = "" : oldPrdVal = req.auditObject.result.ProductDetail.oldData + " | ";
                    (req.auditObject.result.Compressed.oldData == undefined) ? oldPrdValComp = "NA" : oldPrdValComp = req.auditObject.result.Compressed.oldData;
                    (req.auditObject.result.Compressed.newData == undefined) ? newPrdValComp = "NA" : newPrdValComp = req.auditObject.result.Compressed.newData;

                    var strGenericName = "";
                    (req.intGenericName == 1) ? strGenericName = req.str_GenericName : strGenericName = "NA";
                    now = new Date();
                    await models.tbl_audit_product.create({
                        DT: date.format(now, 'YYYY-MM-DD'),
                        TM: date.format(now, 'HH:mm:ss'),
                        userid: req.loggedUserId,
                        username: req.loggedUserName,
                        ACT: req.action,
                        Remark: req.remark,
                        ProductId: req.str_BFGCode.trim(),
                        ProductName: req.str_Prd.trim(),
                        PrdVersion: req.str_PV.trim(),
                        Version: req.str_V.trim(),
                        GenericName: strGenericName,
                        ProductType: req.int_prdType,
                        OldValueComp: oldPrdVal + oldPrdValComp,
                        NewValueComp: newPrdVal + newPrdValComp,
                        OldValueGran: 'NA',
                        NewValueGran: 'NA',
                        OldValueCoat: 'NA',
                        NewValueCoat: 'NA',
                        type: 'Compressed',
                        NewValue: newPrdVal == undefined ? newPrdValComp : newPrdVal,
                        OldValue: oldPrdVal == undefined ? oldPrdValComp : oldPrdVal,
                        SFOID: req.str_sfoid
                    },{
                        transaction: t
                    });
                    await models.tbl_activity_log.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: req.loggedUserId,
                        username: req.loggedUserName,
                        activity: "Product Updated", 
                    },{
                        transaction: t
                    });
                
                }
                else {
                    now = new Date();
                    await models.tbl_activity_log.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: req.loggedUserId,
                        username: req.loggedUserName,
                        activity: "Product Updated", 
                    },{
                        transaction: t
                    });
                }

            var responseObj = {};
            Object.assign(responseObj, { status: 'success' }, { result: 'Product Updated Successfully' });
            return responseObj;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async updateMasterDataOnly(IsCompressed, IsBilayer, IsTrilayer, IsCoated, IsGrannulation, req,t) {
        try {

                var mainData = {};
                var whereConditionData = {};
                /** if product detail change then update product data else update other field */
                if (req.auditObject.result.ProductDetail.result != "No Change")//detail change
                {
                    if (req.intGenericName == 1) {
                    
                        mainData = {
                            ProductName: req.str_Prd.trim(),
                            ProductId: req.str_BFGCode.trim(),
                            ProductVersion: req.str_PV.trim(),
                            Version: req.str_V.trim(),
                            GenericName: req.str_GenericName,
                            locked: 0 ,
                            Upper_Surface : req.str_UpperSurface,
                            Lower_Surface : req.str_LowerSurface,
                            Appearance_Desc : req.str_ApperanceDesc,
                            Appearance_Desc_Coat: req.str_ApperanceDesc_Coat,
                            SFOID: req.str_sfoid
                        };
                        whereConditionData = {
                            where:{
                                ProductName: req.strOldPrd.trim(),
                                ProductId: req.strOldBFG.trim(),
                                ProductVersion: req.strOldPV.trim(),
                                Version: req.strOldV.trim(),
                                GenericName: req.strOldGName,
                                SFOID: req.strOldSFOID
                            },
                            transaction: t
                        };
                    }
                    else {
                        
                        mainData = {
                            ProductName: req.str_Prd.trim(),
                            ProductId: req.str_BFGCode.trim(),
                            ProductVersion: req.str_PV.trim(),
                            Version: req.str_V.trim(),
                            locked: 0 ,
                            Upper_Surface : req.str_UpperSurface,
                            Lower_Surface : req.str_LowerSurface,
                            Appearance_Desc : req.str_ApperanceDesc,
                            Appearance_Desc_Coat: req.str_ApperanceDesc_Coat,
                            SFOID: req.str_sfoid
                        };
                        whereConditionData = {
                            where:{
                                ProductName: req.strOldPrd.trim(),
                                ProductId: req.strOldBFG.trim(),
                                ProductVersion: req.strOldPV.trim(),
                                Version: req.strOldV.trim(),
                                SFOID: req.strOldSFOID
                            },
                            transaction: t
                        };
                    }

                }
                else {
                    if (req.intGenericName == 1) {
                        
                        whereConditionData = {
                            where:{
                                ProductName: req.str_Prd.trim(),
                                ProductId: req.str_BFGCode.trim(),
                                ProductVersion: req.str_PV.trim(),
                                Version: req.str_V.trim(),
                                GenericName: req.str_GenericName,
                                SFOID:req.str_sfoid
                            },
                            transaction: t
                        };
                    }
                    else {
                        
                        whereConditionData = {
                            where:{
                                ProductName: req.str_Prd.trim(),
                                ProductId: req.str_BFGCode.trim(),
                                ProductVersion: req.str_PV.trim(),
                                Version: req.str_V.trim(),
                                GenericName: req.str_GenericName,
                                SFOID:req.str_sfoid
                            },
                            transaction: t
                        };
                    }
                }

                if (IsCompressed == false) {
                    Object.assign(mainData,{IsCompress: 0 });
                }
                else {
                    Object.assign(mainData,{IsCompress: 1});
                }

                if (IsBilayer == false || IsBilayer == undefined) {
                    Object.assign(mainData,{ IsBilayer: 0 },
                        {IsBilayerLbl: (req.biLayerLabel == undefined) ? "NA" : req.biLayerLabel });
                }
                else {
                    Object.assign(mainData,
                        { IsBilayer: 1},
                        { IsBilayerLbl: req.biLayerLabel});
                }

                if (IsTrilayer == false || IsTrilayer == undefined) {
                    Object.assign(mainData,{ IsTrilayer: 0 },
                        { IsTrilayerLbl: (req.triLayerLabel == undefined) ? "NA" : req.triLayerLabel });
                }
                else {
                    Object.assign(mainData,{IsTrilayer: 1},{ IsTrilayerLbl: req.triLayerLabel});
                }

                if (IsCoated == false || IsCoated == undefined) {
                    Object.assign(mainData,{IsCoated: 0});
                }
                else {
                    Object.assign(mainData,{ IsCoated: 1});
                }

                if (IsGrannulation == false || IsGrannulation == undefined) {
                    Object.assign(mainData,{ IsGranulation: 0});
                }
                else {
                    Object.assign(mainData,{IsGranulation: 1});
                }

                Object.assign(mainData,{ IsActive: 0});
                await models.tbl_product_master.update(
                    mainData,whereConditionData
                );
                
            var responseObj = {};
            Object.assign(responseObj,{ status: "Success", result: "Product Updated Successfully" });
            return responseObj;
        } catch (error) {
            throw error;
        }
    }

    async checkProductUncoatedStatus(req) {
        try {
            let responseObj = {};
            var checkProduct;
            if (req.intGenericName == 1) {
                checkProduct = await models.tbl_product_tablet.findAll({
                    where: {
                        ProductId: req.str_BFGCode.trim(),
                        ProductName: req.str_Prd.trim(),
                        ProductVersion:req.str_PV.trim(),
                        Version:req.str_V.trim(),
                        GenericName: req.str_GenericName,
                        SFOID:req.strOldSFOID
                    }
                });
            }
            else {
                checkProduct = await models.tbl_product_tablet.findAll({
                    where: {
                        ProductId: req.str_BFGCode.trim(),
                        ProductName: req.str_Prd.trim(),
                        ProductVersion: req.str_PV.trim(),
                        Version: req.str_V.trim(),
                        SFOID:req.strOldSFOID
                    }
                });
            }

            let result = checkProduct;
            if (result.length == 0) {
                Object.assign(responseObj, { status: 'success' }, { result: 'success' });
                return responseObj;
            }
            else {
                Object.assign(responseObj, { status: 'success' }, { result: 'Product Uncoated already exist' });
                return responseObj;
            }
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async updateProductCoated(req,t) {
        var checkProductCoated;
        if(req.auditObject.result.ProductDetail.result != "No Change" || (req.bln_TypeCoatPrd == false && req.wasCoated == true)){
          checkProductCoated =  { status: 'success' , result: 'success'};
        }else{
            checkProductCoated =  await this.checkProductCoatedStatus(req);
        }

        if (checkProductCoated.result == 'Product Coated already exist' && req.auditObject.result.Coated.result != "No Change") {
            const updateCoatedPro = await this.updateProductCoatedValue(req,t);
            return updateCoatedPro;
        }
        else if (checkProductCoated.result != 'Product Coated already exist') {
            const addCoatedPro = await this.insertProductCoatedValue(req,t);
            return addCoatedPro;
        }
    }

    async checkProductCoatedStatus(req) {
        try {
            let responseObj = {};
            var checkCoatPro;
            if (req.intGenericName == 1) {
                checkCoatPro = await models.tbl_product_tablet_coated.findAll({
                    where: {
                        ProductId: req.str_BFGCode.trim(),
                        ProductName: req.str_Prd.trim(),
                        ProductVersion: req.str_PV.trim(),
                        Version: req.str_V.trim(),
                        GenericName: req.str_GenericName
                    }
                });
            }
            else {
                checkCoatPro = await models.tbl_product_tablet_coated.findAll({
                    where: {
                        ProductId: req.str_BFGCode.trim(),
                        ProductName: req.str_Prd.trim(),
                        ProductVersion: req.str_PV.trim(),
                        Version: req.str_V.trim()
                    }
                });
            }

            let result = checkCoatPro;
            if (result.length != 0) {
                Object.assign(responseObj, { status: 'success' }, { result: 'Product Coated already exist' });
                return responseObj;
            }
            else {
                Object.assign(responseObj, { status: 'success' }, { result: 'success' });
                return responseObj;
            }
        } catch (error) {
            console.log(error);
            return error;
        }
    }

    //new function to updateProductCoated
    async updateProductCoatedValue(req,t) {
        try {

                var mainData = {};
                var whereConditionData = {
                    where: {
                        ProductId: req.str_BFGCode.trim(),
                        ProductName: req.str_Prd.trim(),
                        ProductVersion: req.str_PV.trim(),
                        Version: req.str_V.trim()
                    },
                    transaction: t
                };

                Object.assign(mainData, objUpdateProduct.getIndividualObject(req, true));//1
                Object.assign(mainData, objUpdateProduct.getGroupObject(req, true));//2
                Object.assign(mainData, objUpdateProduct.getThicknessObject(req, true));//3
                Object.assign(mainData, objUpdateProduct.getBreadthObject(req, true));//4
                Object.assign(mainData, objUpdateProduct.getLengthObject(req, true));//5
                Object.assign(mainData, objUpdateProduct.getDiameterObject(req, true));//6
                Object.assign(mainData, objUpdateProduct.getHardnessObject(req, true));//7
                Object.assign(mainData, objUpdateProduct.getFriabilityObject(req, true)); //8
                Object.assign(mainData, objUpdateProduct.getDTObject(req, true));//13
                Object.assign(mainData, objUpdateProduct.getMouistueObject(req, true));//16

                await models.tbl_product_tablet_coated.update
                (
                    mainData,
                    whereConditionData
                );

                now = new Date();
                var oldPrdVal = "", newPrdVal = "", OldData = "", NewData = "";
                (req.auditObject.result.ProductDetail.newData == undefined) ? newPrdVal = "NA" : newPrdVal = req.auditObject.result.ProductDetail.newData;
                (req.auditObject.result.ProductDetail.oldData == undefined) ? oldPrdVal = "NA" : oldPrdVal = req.auditObject.result.ProductDetail.oldData;
                (req.auditObject.result.Coated.newData == undefined) ? NewData = "NA" : NewData = req.auditObject.result.Coated.newData;
                (req.auditObject.result.Coated.oldData == undefined) ? OldData = "NA" : OldData = req.auditObject.result.Coated.oldData;
                
                if((req.auditObject.result.ProductDetail.newData == undefined) && (req.auditObject.result.Coated.newData != undefined)){
                    newPrdVal = req.auditObject.result.Coated.newData;
                } else if((req.auditObject.result.ProductDetail.newData != undefined) && (req.auditObject.result.Coated.newData == undefined)){
                    newPrdVal = req.auditObject.result.ProductDetail.newData;
                }

                if((req.auditObject.result.ProductDetail.oldData == undefined) && (req.auditObject.result.Coated.oldData != undefined)){
                    oldPrdVal = req.auditObject.result.Coated.oldData;
                } else if((req.auditObject.result.ProductDetail.oldData != undefined) && (req.auditObject.result.Coated.oldData == undefined)){
                    oldPrdVal = req.auditObject.result.ProductDetail.oldData;
                }

                var strGenericName = "";
                (req.intGenericName == 1) ? strGenericName = req.str_GenericName : strGenericName = "NA";

                await models.tbl_audit_product.create({
                    DT: date.format(now, 'YYYY-MM-DD'),
                    TM: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    ACT: req.action,
                    Remark: req.remark,
                    ProductId: req.str_BFGCode.trim(),
                    ProductName: req.str_Prd.trim(),
                    PrdVersion: req.str_PV.trim(),
                    Version: req.str_V.trim(),
                    GenericName: strGenericName,
                    ProductType: req.int_prdType,
                    OldValueComp: 'NA',
                    NewValueComp: 'NA',
                    OldValueGran: 'NA',
                    NewValueGran: 'NA',
                    OldValueCoat: OldData,
                    NewValueCoat: NewData,
                    type: 'Coated',
                    NewValue: newPrdVal,
                    OldValue: oldPrdVal
                },{
                    transaction: t
                });

                now = new Date();
                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    activity: "Product Updated", 
                },{
                    transaction: t
                });

            var responseObj = {};
            Object.assign(responseObj, { status: 'success' }, { result: 'ProductCoated Updated Successfully' });
            return responseObj;
        }
        catch (error) {
            console.log(error);
            throw error;
        }
    }

    async insertProductCoatedValue(req,t) {
        try {

                var mainData = {};
                if (req.intGenericName == 1) {
                    mainData = {
                        ProductId: req.str_BFGCode.trim(),
                        ProductName: req.str_Prd.trim(),
                        ProductVersion: req.str_PV.trim(),
                        Version: req.str_V.trim(),
                        GenericName: req.str_GenericName,
                        isBinWeighing: req.bln_IsBinWeiging,
                    };
                }
                else {
                    mainData = {
                        ProductId: req.str_BFGCode.trim(),
                        ProductName: req.str_Prd.trim(),
                        ProductVersion: req.str_PV.trim(),
                        Version: req.str_V.trim(),
                        isBinWeighing: req.bln_IsBinWeiging,
                    };
                }

                if(req.bln_TypeCoatPrd == true){
                    Object.assign(mainData, objProduct.getIndividualObject(req, true));//1
                    Object.assign(mainData, objProduct.getGroupObject(req, true));//2
                    Object.assign(mainData, objProduct.getThicknessObject(req, true));//3
                    Object.assign(mainData, objProduct.getBreadthObject(req, true));//4
                    Object.assign(mainData, objProduct.getLengthObject(req, true));//5
                    Object.assign(mainData, objProduct.getDiameterObject(req, true));//6
                    Object.assign(mainData, objProduct.getHardnessObject(req, true));//7
                    Object.assign(mainData, objProduct.getFriabilityObject(req, true)); //8
                    Object.assign(mainData, objProduct.getDTObject(req, true));//13
                    Object.assign(mainData, objProduct.getMouistueObject(req, true));//16

                    await models.tbl_product_tablet_coated.create
                    (
                        mainData,{
                            transaction: t
                        }
                    );
                }
                
                now = new Date();
                var oldPrdVal = "", newPrdVal = "", NewData = "", OldData = "";
                (req.auditObject.result.ProductDetail.newData == undefined) ? newPrdVal = "NA" : newPrdVal = req.auditObject.result.ProductDetail.newData;
                (req.auditObject.result.ProductDetail.oldData == undefined) ? oldPrdVal = "NA" : oldPrdVal = req.auditObject.result.ProductDetail.oldData;
                (req.auditObject.result.Coated.oldData == undefined) ? OldData = "NA" : OldData = req.auditObject.result.Coated.oldData;
                (req.auditObject.result.Coated.newData == undefined) ? NewData = "NA" : NewData = req.auditObject.result.Coated.newData;

                var strGenericName = "";
                (req.intGenericName == 1) ? strGenericName = req.str_GenericName : strGenericName = "NA";

                await models.tbl_audit_product.create({
                    DT: date.format(now, 'YYYY-MM-DD'),
                    TM: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    ACT: req.action,
                    Remark: req.remark,
                    ProductId: req.str_BFGCode.trim(),
                    ProductName: req.str_Prd.trim(),
                    PrdVersion: req.str_PV.trim(),
                    Version: req.str_V.trim(),
                    GenericName: strGenericName,
                    ProductType: req.int_prdType,
                    OldValueComp: 'NA',
                    NewValueComp: 'NA',
                    OldValueGran: 'NA',
                    NewValueGran: 'NA',
                    OldValueCoat: OldData,
                    NewValueCoat: NewData,
                    type: 'Coated',
                    NewValue: newPrdVal,
                    OldValue: oldPrdVal
                },{
                    transaction: t
                });

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    activity: "Product Updated", 
                },{
                    transaction: t
                });

            var responseObj = {};
            Object.assign(responseObj, { status: 'success' }, { result: 'ProductCoated Updated Successfully' });
            return responseObj;
        }
        catch (error) {
            console.log(error);
            throw error;
        }
    }

    async updateProductGranulation(req,t) {
        try {
            if ((req.bln_TypeGrannualPrd == true) && (req.bln_TypeCompressed == false) && 
                (req.bln_TypeCoatPrd == false) && (req.bln_TypeBiLayPrd == false) && 
                (req.bln_TypeTriLayPrd == false) && (req.bln_IsBinWeiging == false)) 
            {
                var checkGranulation;
                if(req.auditObject.result.ProductDetail.result != "No Change"){
                    checkGranulation = { status: 'success' , result: 'success'};
                }else{
                    checkGranulation = await this.checkGranulationPro(req);
                }
                if (checkGranulation.result == 'Product Granulation already exist' && req.auditObject.result.Grannual.result != "No Change") {
                    const updateGranulationDetail = await this.updateGranulationDetail(req,t);
                    return updateGranulationDetail;
                }
                else if (checkGranulation.result != 'Product Granulation already exist') {
                    const granulationDetail = await this.insertUpdateGranulationDetail(req,t);
                    return granulationDetail;
                }
            }
            else {
                var checkGranulation;
                if(req.auditObject.result.ProductDetail.result != "No Change" ||  (req.bln_TypeGrannualPrd == false && req.wasGrannual == true)){
                    checkGranulation = { status: 'success' , result: 'success'};
                }else{
                    checkGranulation = await this.checkGranulationPro(req);
                }
                if (checkGranulation.result == 'Product Granulation already exist' && req.auditObject.result.Grannual.result != "No Change") {
                    const updateGranulationPerticular = await this.updateGranulationPerticular(req,t);
                    return updateGranulationPerticular;
                }
                else if (checkGranulation.result != 'Product Granulation already exist') {
                    const granulationPerticular = await this.insertGranulationPerticularValue(req,t);
                    return granulationPerticular;
                }
            }
        } catch (err) {
            console.log(err);
            throw err;
        }
    }

    async checkGranulationPro(req) {
        try {
            let responseObj = {};
            var checkGranulation;

            if (req.intGenericName == 1) {
                checkGranulation = await models.tbl_product_gran.findAll({
                    where: {
                        ProductId: req.str_BFGCode.trim(),
                        ProductName: req.str_Prd.trim(),
                        ProductVersion: req.str_PV.trim(),
                        Version: req.str_V.trim(),
                        GenericName: req.str_GenericName
                    }
                });
            }
            else {
                checkGranulation = await models.tbl_product_gran.findAll({
                    where: {
                        ProductId: req.str_BFGCode.trim(),
                        ProductName: req.str_Prd.trim(),
                        ProductVersion: req.str_PV.trim(),
                        Version: req.str_V.trim()
                    }
                });
            }

            let result = checkGranulation;
            if (result.length != 0) {
                Object.assign(responseObj, { status: 'success' }, { result: 'Product Granulation already exist' });
                return responseObj;
            }
            else {
                Object.assign(responseObj, { status: 'success' }, { result: 'success' });
                return responseObj;
            }
        } catch (err) {
            return err;
        }

    }

    async checkGranulationCap(req) {
        try {
            let responseObj = {};
            let checkGranulation = {
                ProductId: req.str_BFGCode,
                ProductName: req.str_Prd,
                ProductVersion: req.str_PV,
                Version: req.str_V,
            };

            if (req.intGenericName == 1) {
                Object.assign(checkGranulation,{GenericName: str_GenericName})
            }

            let result = await models.tbl_product_gran_cap.findAll({where : checkGranulation});
            if (result.length != 0) {
                Object.assign(responseObj, { status: 'success' }, { result: 'Product Granulation already exist' });
                return responseObj;
            }
            else {
                Object.assign(responseObj, { status: 'success' }, { result: 'success' });
                return responseObj;
            }
        } catch (error) {
            console.log(error);
            throw error;
        }

    }

    async insertUpdateGranulationDetailCap(req,t) {
        try {
            let responseObj = {};
            var IsCoated, IsGrannulation, IsCompress;
            //IsBilayer = req.bln_TypeBiLayPrd == true ? 1 : 0;
            //IsTrilayer = req.bln_TypeTriLayPrd == true ? 1 : 0;
            IsCoated = req.bln_TypeCoatPrd == true ? 1 : 0;
            IsCompress = req.bln_TypeCompressed == true ? 1 : 0;
            IsGrannulation = req.bln_TypeGrannualPrd == true ? 1 : 0;
            var updateGranulationObj = {};
            var objInsertGranulationData = {};

            updateGranulationObj = {
                data: {
                    isBinWeighing: req.bln_IsBinWeiging,
                    BatchSize: req.flt_BatchSize,
                    BatchUnit: req.str_BatchUnit,
                    IsCoated: IsCoated,
                    IsGranulation: IsGrannulation,
                    IsCompress: IsCompress,
                    NominalNomenclature: "Standard",
                    userID: req.loggedUserId,
                    ProductName: req.str_Prd,
                    ProductId: req.str_BFGCode,
                    ProductVersion: req.str_PV,
                    Version: req.str_V,
                },
                condition: {
                    ProductId: req.strOldBFG,
                    ProductName: req.strOldPrd,
                    ProductVersion: req.strOldPV,
                    Version: req.strOldV,
                },
            }
            
            objInsertGranulationData = {
                data: {
                    ProductId: req.str_BFGCode,
                    ProductName: req.str_Prd,
                    ProductVersion: req.str_PV,
                    Version: req.str_V,
                    editCounter: 0,
                    locked: 0,
                }
            }
           
            if (req.intGenericName == 1) {
                Object.assign(updateGranulationObj.data,{GenericName: req.str_GenericName })
                Object.assign(updateGranulationObj.condition,{GenericName: req.strOldGName })

                Object.assign(objInsertGranulationData.data,{GenericName: req.str_GenericName })
                // updateGranulationObj.data.push( { str_colName: 'GenericName', value: req.str_GenericName });
                // updateGranulationObj.condition.push( { str_colName: 'GenericName', value: req.strOldGName, comp: 'eq' } );
                // objInsertGranulationData.data.push( { str_colName: 'GenericName', value: req.str_GenericName });
            }

            await models.tbl_product_master.update(updateGranulationObj.data,
                { 
                    where : updateGranulationObj.condition,
                    transaction:t
                });

            Object.assign(objInsertGranulationData.data,objProductGranulation.getLodDry(req));//1
            Object.assign(objInsertGranulationData.data,objProductGranulation.getLodLubricated(req));//2
            Object.assign(objInsertGranulationData.data,objProductGranulation.getLodLayer1Dry(req));//3
            Object.assign(objInsertGranulationData.data,objProductGranulation.getLodLayer1Lubricated(req));//4
            Object.assign(objInsertGranulationData.data,objProductGranulation.getLodLayer2Dry(req));//5
            Object.assign(objInsertGranulationData.data,objProductGranulation.getLodLayer2Lubricated(req));//6
            Object.assign(objInsertGranulationData.data,objProductGranulation.getTabDensity(req));//7
            Object.assign(objInsertGranulationData.data,objProductGranulation.getFine(req));//8
            Object.assign(objInsertGranulationData.data,objProductGranulation.getParticleSeizing(req));//9
            Object.assign(objInsertGranulationData.data,objProductGranulation.getBulkDensity(req));//16

            Object.assign(objInsertGranulationData.data, objProductGranulation.getParticleSizeDistribution(req));//50
            Object.assign(objInsertGranulationData.data, objProductGranulation.getParticleSizeDistribution_abv_20(req));//51
            Object.assign(objInsertGranulationData.data, objProductGranulation.getParticleSizeDistribution_abv_40(req));//52
            Object.assign(objInsertGranulationData.data, objProductGranulation.getParticleSizeDistribution_abv_60(req));//53
            Object.assign(objInsertGranulationData.data, objProductGranulation.getParticleSizeDistribution_abv_80(req));//54
            Object.assign(objInsertGranulationData.data, objProductGranulation.getParticleSizeDistribution_abv_100(req));//55
            Object.assign(objInsertGranulationData.data, objProductGranulation.getParticleSizeDistribution_blw_100(req));//56

            Object.assign(objInsertGranulationData.data, objProductGranulation.getParticleSizeDistribution_Lay_1(req));//57
            Object.assign(objInsertGranulationData.data, objProductGranulation.getParticleSizeDistribution_abv_20_Lay_1(req));//58
            Object.assign(objInsertGranulationData.data, objProductGranulation.getParticleSizeDistribution_abv_40_Lay_1(req));//59
            Object.assign(objInsertGranulationData.data, objProductGranulation.getParticleSizeDistribution_abv_60_Lay_1(req));//60
            Object.assign(objInsertGranulationData.data, objProductGranulation.getParticleSizeDistribution_abv_80_Lay_1(req));//61
            Object.assign(objInsertGranulationData.data, objProductGranulation.getParticleSizeDistribution_abv_100_Lay_1(req));//62
            Object.assign(objInsertGranulationData.data, objProductGranulation.getParticleSizeDistribution_blw_100_Lay_1(req));//63

            await models.tbl_product_gran_cap.create(objInsertGranulationData.data,{ transaction: t});

            now = new Date();
            var oldPrdVal = "", newPrdVal = "", newPrdValGran = "",oldPrdValGran = "";
            (req.auditObject.result.ProductDetail.newData == undefined) ? newPrdVal = "NA" : newPrdVal = req.auditObject.result.ProductDetail.newData;
            (req.auditObject.result.ProductDetail.oldData == undefined) ? oldPrdVal = "NA" : oldPrdVal = req.auditObject.result.ProductDetail.oldData;
            (req.auditObject.result.Grannual.newData == undefined) ? newPrdValGran = "NA" : newPrdValGran = req.auditObject.result.Grannual.newData;
            (req.auditObject.result.Grannual.oldData == undefined) ? oldPrdValGran = "NA" : oldPrdValGran = req.auditObject.result.Grannual.oldData;

            var strGenericName = "";
            (req.intGenericName == 1) ? strGenericName = req.str_GenericName : strGenericName = "NA";

            await models.tbl_audit_product_capsule.create({
                DT: date.format(now, 'YYYY-MM-DD'),
                TM: date.format(now, 'HH:mm:ss'),
                userid: req.loggedUserId,
                username: req.loggedUserName,
                ACT: req.action,
                Remark: req.remark,
                ProductId: req.str_BFGCode,
                ProductName: req.str_Prd,
                PrdVersion: req.str_PV,
                Version: req.str_V,
                GenericName: strGenericName,
                ProductType: req.int_prdType,
                OldValueComp: 'NA',
                NewValueComp: 'NA',
                OldValueGran: oldPrdValGran,
                NewValueGran: newPrdValGran,
                OldValueCoat: 'NA',
                NewValueCoat: 'NA',
                type: 'Granulation',
                NewValue: newPrdVal,
                OldValue: oldPrdVal
            });
           
            await models.tbl_activity_log.create({
                DT: date.format(now, 'YYYY-MM-DD') ,
                TM: date.format(now, 'HH:mm:ss') ,
                userid: req.loggedUserId ,
                username: req.loggedUserNae ,
                activity: "Capsule Updated" 
            });
            Object.assign(responseObj, { status: 'success' }, { result: 'ProductGranulation Updated Successfully' });
            return responseObj;
        } catch (error) {
            console.log(error);
            return error;
        }

    }

    async insertUpdateGranulationDetail(req,t) {
        try {
                
                var IsBilayer, IsTrilayer, IsCoated, IsGrannulation, IsCompress;
                IsBilayer = req.bln_TypeBiLayPrd == true ? 1 : 0;
                IsTrilayer = req.bln_TypeTriLayPrd == true ? 1 : 0;
                IsCoated = req.bln_TypeCoatPrd == true ? 1 : 0;
                IsCompress = req.bln_TypeCompressed == true ? 1 : 0;
                IsGrannulation = req.bln_TypeGrannualPrd == true ? 1 : 0;
                var str_query = {};

                if (req.intGenericName == 1) {
                    await models.tbl_product_master.update({
                        isBinWeighing: req.bln_IsBinWeiging,
                        BatchSize: req.flt_BatchSize,
                        BatchUnit: req.str_BatchUnit,
                        IsBilayer: IsBilayer,
                        IsBilayerLbl: req.biLayerLabel,
                        IsTrilayer: IsTrilayer,
                        IsTrilayerLbl: req.triLayerLabel,
                        IsCoated: IsCoated,
                        IsGranulation: IsGrannulation,
                        IsCompress: IsCompress,
                        NominalNomenclature: "Standard",
                        userID: req.loggedUserId,
                        ProductName: req.str_Prd.trim(),
                        ProductId: req.str_BFGCode.trim(),
                        ProductVersion: req.str_PV.trim(),
                        Version: req.str_V.trim(),
                        GenericName: req.str_GenericName,
                        Upper_Surface : req.str_UpperSurface,
                        Lower_Surface : req.str_LowerSurface,
                        Appearance_Desc : req.str_ApperanceDesc,
                        Appearance_Desc_Coat: req.str_ApperanceDesc_Coat
                    },{
                        where:{
                            ProductId: req.strOldBFG,
                            ProductName: req.strOldPrd,
                            ProductVersion: req.strOldPV,
                            Version: req.strOldV,
                            GenericName: req.strOldGName
                        },
                        transaction: t
                    });

                    str_query = {
                        ProductId: req.str_BFGCode.trim(),
                        ProductName: req.str_Prd.trim(),
                        ProductVersion: req.str_PV.trim(),
                        Version: req.str_V.trim(),
                        editCounter: 0,
                        locked: 0,
                        GenericName: req.str_GenericName
                    };

                }
                else {

                    await models.tbl_product_master.update({
                        isBinWeighing: req.bln_IsBinWeiging,
                        BatchSize: req.flt_BatchSize,
                        BatchUnit: req.str_BatchUnit,
                        IsBilayer: IsBilayer,
                        IsBilayerLbl: req.biLayerLabel,
                        IsTrilayer: IsTrilayer,
                        IsTrilayerLbl: req.triLayerLabel,
                        IsCoated: IsCoated,
                        IsGranulation: IsGrannulation,
                        IsCompress: IsCompress,
                        NominalNomenclature: "Standard",
                        userID: req.loggedUserId,
                        ProductName: req.str_Prd.trim(),
                        ProductId: req.str_BFGCode.trim(),
                        ProductVersion: req.str_PV.trim(),
                        Version: req.str_V.trim(),
                        Upper_Surface : req.str_UpperSurface,
                        Lower_Surface : req.str_LowerSurface,
                        Appearance_Desc : req.str_ApperanceDesc,
                        Appearance_Desc_Coat: req.str_ApperanceDesc_Coat
                    },{
                        where:{
                            ProductId: req.strOldBFG.trim(),
                            ProductName: req.strOldPrd.trim(),
                            ProductVersion: req.strOldPV.trim(),
                            Version: req.strOldV.trim()
                        },
                        transaction: t
                    });
                    
                    str_query = {
                        ProductId: req.str_BFGCode.trim(),
                        ProductName: req.str_Prd.trim(),
                        ProductVersion: req.str_PV.trim(),
                        Version: req.str_V.trim(),
                        editCounter: 0,
                        locked: 0
                    };
                }

                //Create only when there is granulation parameter 
                //This done for when user remove granulation parameter u cant read data from table, so for that time this function will
                //Execute and do just audit entry for delete
                if(IsGrannulation == 1){
                    Object.assign(str_query, {...objProductGranulation.getLodDry(req)});//1
                    Object.assign(str_query, {...objProductGranulation.getTabDensity(req)});//2
                    Object.assign(str_query, {...objProductGranulation.getBulkDensity(req)});//3
                    Object.assign(str_query, {...objProductGranulation.getLodLayer1Dry(req)});//4
                    Object.assign(str_query, {...objProductGranulation.getTabDensity_Lay_1(req)});//5
                    Object.assign(str_query, {...objProductGranulation.getBulkDensity_Lay_1(req)});//6
                    Object.assign(str_query, {...objProductGranulation.getLodLayer2Dry(req)});//7
                    Object.assign(str_query, {...objProductGranulation.getTabDensity_Lay_2(req)});//8
                    Object.assign(str_query, {...objProductGranulation.getBulkDensity_Lay_2(req)});//9
    
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_30(req)});//10
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_40(req)});//11
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_60(req)});//12
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_80(req)});//13
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_100(req)});//14
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_30(req)});//15
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_40(req)});//16
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_60(req)});//17
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_80(req)});//18
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_100(req)});//19
                    Object.assign(str_query, {...objProductGranulation.getFine_Pan(req)});//20
    
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_30_Lay_1(req)});//21
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_40_Lay_1(req)});//22
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_60_Lay_1(req)});//23
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_80_Lay_1(req)});//24
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_100_Lay_1(req)});//25
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_30_Lay_1(req)});//26
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_40_Lay_1(req)});//27
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_60_Lay_1(req)});//28
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_80_Lay_1(req)});//29
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_100_Lay_1(req)});//30
                    Object.assign(str_query, {...objProductGranulation.getFine_Pan_Lay_1(req)});//31
    
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_30_Lay_2(req)});//32
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_40_Lay_2(req)});//33
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_60_Lay_2(req)});//34
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_80_Lay_2(req)});//35
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_100_Lay_2(req)});//36
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_30_Lay_2(req)});//37
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_40_Lay_2(req)});//38
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_60_Lay_2(req)});//39
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_80_Lay_2(req)});//40
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_100_Lay_2(req)});//41
                    Object.assign(str_query, {...objProductGranulation.getFine_Pan_Lay_2(req)});//42
    
                    Object.assign(str_query, {...objProductGranulation.getLodLubricated(req)});//43
                    Object.assign(str_query, {...objProductGranulation.getLodLayer1Lubricated(req)});//44
                    Object.assign(str_query, {...objProductGranulation.getLodLayer2Lubricated(req)});//45
                    Object.assign(str_query, {...objProductGranulation.getFine(req)});//46
                    Object.assign(str_query, {...objProductGranulation.getParticleSeizing(req)});//47
                    Object.assign(str_query, {...objProductGranulation.getFine_Lay_1(req)});//48
                    Object.assign(str_query, {...objProductGranulation.getFine_Lay_2(req)});//49
    
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution(req)});//50
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_20(req)});//51
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_40(req)});//52
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_60(req)});//53
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_80(req)});//54
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_100(req)});//55
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_blw_100(req)});//56
    
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_Lay_1(req)});//57
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_20_Lay_1(req)});//58
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_40_Lay_1(req)});//59
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_60_Lay_1(req)});//60
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_80_Lay_1(req)});//61
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_100_Lay_1(req)});//62
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_blw_100_Lay_1(req)});//63
                    Object.assign(str_query, {...objProductGranulation.getParticleSeizing_Lay_1(req)});//64
                    Object.assign(str_query, {...objProductGranulation.getParticleSeizing_Lay_2(req)});//65
    
                    await models.tbl_product_gran.create(
                        str_query,{
                            transaction: t
                        }
                    );
                }

                now = new Date();
                var oldPrdVal = "", newPrdVal = "", oldPrdValGran = "", newPrdValGran = "";
                (req.auditObject.result.ProductDetail.newData == undefined) ? newPrdVal = "NA" : newPrdVal = req.auditObject.result.ProductDetail.newData;
                (req.auditObject.result.ProductDetail.oldData == undefined) ? oldPrdVal = "NA" : oldPrdVal = req.auditObject.result.ProductDetail.oldData;
                (req.auditObject.result.Grannual.oldData == undefined) ? oldPrdValGran = "NA" : oldPrdValGran = req.auditObject.result.Grannual.oldData;
                (req.auditObject.result.Grannual.newData == undefined) ? newPrdValGran = "NA" : newPrdValGran = req.auditObject.result.Grannual.newData;

                var strGenericName = "";
                (req.intGenericName == 1) ? strGenericName = req.str_GenericName : strGenericName = "NA";
                
                await models.tbl_audit_product.create({
                    DT: date.format(now, 'YYYY-MM-DD'),
                    TM: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    ACT: req.action,
                    Remark: req.remark,
                    ProductId: req.str_BFGCode.trim(),
                    ProductName: req.str_Prd.trim(),
                    PrdVersion: req.str_PV.trim(),
                    Version: req.str_V.trim(),
                    GenericName: strGenericName,
                    ProductType: req.int_prdType,
                    OldValueComp: 'NA',
                    NewValueComp: 'NA',
                    OldValueGran: oldPrdValGran,
                    NewValueGran: newPrdValGran,
                    OldValueCoat: 'NA',
                    NewValueCoat: 'NA',
                    type: 'Granulation',
                    NewValue: newPrdVal,
                    OldValue: oldPrdVal 
                },{
                    transaction: t
                });

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    activity: "Product Updated", 
                },{
                    transaction: t
                });

            var responseObj = {};
            Object.assign(responseObj, { status: 'success' }, { result: 'ProductGranulation Updated Successfully' });
            return responseObj;
        } catch (err) {
            console.log(err);
            throw err;
        }
    }

    async insertGranulationPerticularValue(req,t) {
        try {
            
                var str_query;

                if (req.intGenericName == 1) {
                    str_query = {
                        ProductId: req.str_BFGCode.trim(),
                        ProductName: req.str_Prd.trim(),
                        ProductVersion: req.str_PV.trim(),
                        Version: req.str_V.trim(),
                        editCounter: 0,
                        locked: 0,
                        GenericName: req.str_GenericName
                    };

                }
                else {
                    str_query = {
                        ProductId: req.str_BFGCode.trim(),
                        ProductName: req.str_Prd.trim(),
                        ProductVersion: req.str_PV.trim(),
                        Version: req.str_V.trim(),
                        editCounter: 0,
                        locked: 0,
                    };
                }

                if(req.bln_TypeGrannualPrd == true){
                    Object.assign(str_query, {...objProductGranulation.getLodDry(req)});//1
                    Object.assign(str_query, {...objProductGranulation.getTabDensity(req)});//2
                    Object.assign(str_query, {...objProductGranulation.getBulkDensity(req)});//3
                    Object.assign(str_query, {...objProductGranulation.getLodLayer1Dry(req)});//4
                    Object.assign(str_query, {...objProductGranulation.getTabDensity_Lay_1(req)});//5
                    Object.assign(str_query, {...objProductGranulation.getBulkDensity_Lay_1(req)});//6
                    Object.assign(str_query, {...objProductGranulation.getLodLayer2Dry(req)});//7
                    Object.assign(str_query, {...objProductGranulation.getTabDensity_Lay_2(req)});//8
                    Object.assign(str_query, {...objProductGranulation.getBulkDensity_Lay_2(req)});//9
    
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_30(req)});//10
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_40(req)});//11
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_60(req)});//12
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_80(req)});//13
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_100(req)});//14
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_30(req)});//15
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_40(req)});//16
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_60(req)});//17
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_80(req)});//18
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_100(req)});//19
                    Object.assign(str_query, {...objProductGranulation.getFine_Pan(req)});//20
    
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_30_Lay_1(req)});//21
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_40_Lay_1(req)});//22
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_60_Lay_1(req)});//23
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_80_Lay_1(req)});//24
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_100_Lay_1(req)});//25
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_30_Lay_1(req)});//26
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_40_Lay_1(req)});//27
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_60_Lay_1(req)});//28
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_80_Lay_1(req)});//29
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_100_Lay_1(req)});//30
                    Object.assign(str_query, {...objProductGranulation.getFine_Pan_Lay_1(req)});//31
    
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_30_Lay_2(req)});//32
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_40_Lay_2(req)});//33
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_60_Lay_2(req)});//34
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_80_Lay_2(req)});//35
                    Object.assign(str_query, {...objProductGranulation.getFine_blw_100_Lay_2(req)});//36
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_30_Lay_2(req)});//37
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_40_Lay_2(req)});//38
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_60_Lay_2(req)});//39
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_80_Lay_2(req)});//40
                    Object.assign(str_query, {...objProductGranulation.getFine_abv_100_Lay_2(req)});//41
                    Object.assign(str_query, {...objProductGranulation.getFine_Pan_Lay_2(req)});//42
    
                    Object.assign(str_query, {...objProductGranulation.getLodLubricated(req)});//43
                    Object.assign(str_query, {...objProductGranulation.getLodLayer1Lubricated(req)});//44
                    Object.assign(str_query, {...objProductGranulation.getLodLayer2Lubricated(req)});//45
                    Object.assign(str_query, {...objProductGranulation.getFine(req)});//46
                    Object.assign(str_query, {...objProductGranulation.getParticleSeizing(req)});//47
                    Object.assign(str_query, {...objProductGranulation.getFine_Lay_1(req)});//48
                    Object.assign(str_query, {...objProductGranulation.getFine_Lay_2(req)});//49
    
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution(req)});//50
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_20(req)});//51
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_40(req)});//52
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_60(req)});//53
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_80(req)});//54
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_100(req)});//55
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_blw_100(req)});//56
    
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_Lay_1(req)});//57
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_20_Lay_1(req)});//58
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_40_Lay_1(req)});//59
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_60_Lay_1(req)});//60
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_80_Lay_1(req)});//61
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_100_Lay_1(req)});//62
                    Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_blw_100_Lay_1(req)});//63
                    Object.assign(str_query, {...objProductGranulation.getParticleSeizing_Lay_1(req)});//64
                    Object.assign(str_query, {...objProductGranulation.getParticleSeizing_Lay_2(req)});//65
                    
                    await models.tbl_product_gran.create(
                        str_query,{
                            transaction: t
                        }
                    );
                }

                now = new Date();
                var oldPrdVal = "", newPrdVal = "", oldPrdValGran = "", newPrdValGran = "";
                (req.auditObject.result.ProductDetail.newData == undefined) ? newPrdVal = "NA" : newPrdVal = req.auditObject.result.ProductDetail.newData;
                (req.auditObject.result.ProductDetail.oldData == undefined) ? oldPrdVal = "NA" : oldPrdVal = req.auditObject.result.ProductDetail.oldData;
                (req.auditObject.result.Grannual.oldData == undefined) ? oldPrdValGran = "NA" : oldPrdValGran = req.auditObject.result.Grannual.oldData;
                (req.auditObject.result.Grannual.newData == undefined) ? newPrdValGran = "NA" : newPrdValGran = req.auditObject.result.Grannual.newData;

                var strGenericName = "";
                (req.intGenericName == 1) ? strGenericName = req.str_GenericName : strGenericName = "NA";

                await models.tbl_audit_product.create({
                    DT: date.format(now, 'YYYY-MM-DD'),
                    TM: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    ACT: req.action,
                    Remark: req.remark,
                    ProductId: req.str_BFGCode.trim(),
                    ProductName: req.str_Prd.trim(),
                    PrdVersion: req.str_PV.trim(),
                    Version: req.str_V.trim(),
                    GenericName: strGenericName,
                    ProductType: req.int_prdType,
                    OldValueComp: 'NA',
                    NewValueComp: 'NA',
                    OldValueGran: oldPrdValGran,
                    NewValueGran: newPrdValGran,
                    OldValueCoat: 'NA',
                    NewValueCoat: 'NA',
                    type:'Granulation',
                    NewValue: newPrdVal,
                    OldValue: oldPrdVal 
                },{
                    transaction: t
                });
                
                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    activity: "Product Updated", 
                },{
                    transaction: t
                });
            

            var responseObj = {};
            Object.assign(responseObj, { status: 'success' }, { result: 'ProductGranulation Update Successfully' });
            return responseObj;
        } catch (err) {
            console.log(err);
            throw err;
        }
    }

    async updateGranulationDetailCap(req,t) {
        try {
            var objUpdateGranulationData = {
                data: {},
                condition: {
                    ProductId: req.str_BFGCode,
                    ProductName: req.str_Prd,
                    ProductVersion: req.str_PV,
                    Version: req.str_V,
                    GenericName: req.str_GenericName
                }
            };

            var updateProductGranObj = {
                data: {
                    IsActive: 0
                },
                condition: {
                    ProductName: req.str_Prd,
                    ProductId: req.str_BFGCode,
                    ProductVersion: req.str_PV,
                    GenericName: req.str_GenericName,
                    Version: req.str_V,
            }
            }


            var oldPrdVal = "", newPrdVal = "", newPrdValGran = "", oldPrdValGran = "";
            if (req.bln_TypeGrannualPrd == true) {
                await models.tbl_product_master.update(updateProductGranObj.data,
                    {
                        where:updateProductGranObj.condition,
                        transaction:t
                    });

                Object.assign(objUpdateGranulationData.data,objProductGranulation.getLodDry(req));//1
                Object.assign(objUpdateGranulationData.data,objProductGranulation.getLodLubricated(req));//2

                Object.assign(objUpdateGranulationData.data,objProductGranulation.getLodLayer1Dry(req));//3
                Object.assign(objUpdateGranulationData.data,objProductGranulation.getLodLayer1Lubricated(req));//4

                Object.assign(objUpdateGranulationData.data,objProductGranulation.getLodLayer2Dry(req));//5
                Object.assign(objUpdateGranulationData.data,objProductGranulation.getLodLayer2Lubricated(req));//6

                Object.assign(objUpdateGranulationData.data,objProductGranulation.getTabDensity(req));//7
                Object.assign(objUpdateGranulationData.data,objProductGranulation.getFine(req));//8

                Object.assign(objUpdateGranulationData.data,objProductGranulation.getParticleSeizing(req));//9
                Object.assign(objUpdateGranulationData.data,objProductGranulation.getBulkDensity(req));//16

                Object.assign(objUpdateGranulationData.data,objProductGranulation.getParticleSizeDistribution(req));//50
                Object.assign(objUpdateGranulationData.data,objProductGranulation.getParticleSizeDistribution_abv_20(req));//51
                Object.assign(objUpdateGranulationData.data,objProductGranulation.getParticleSizeDistribution_abv_40(req));//52
                Object.assign(objUpdateGranulationData.data,objProductGranulation.getParticleSizeDistribution_abv_60(req));//53
                Object.assign(objUpdateGranulationData.data,objProductGranulation.getParticleSizeDistribution_abv_80(req));//54
                Object.assign(objUpdateGranulationData.data,objProductGranulation.getParticleSizeDistribution_abv_100(req));//55
                Object.assign(objUpdateGranulationData.data,objProductGranulation.getParticleSizeDistribution_blw_100(req));//56

                Object.assign(objUpdateGranulationData.data,objProductGranulation.getParticleSizeDistribution_Lay_1(req));//57
                Object.assign(objUpdateGranulationData.data,objProductGranulation.getParticleSizeDistribution_abv_20_Lay_1(req));//58
                Object.assign(objUpdateGranulationData.data,objProductGranulation.getParticleSizeDistribution_abv_40_Lay_1(req));//59
                Object.assign(objUpdateGranulationData.data,objProductGranulation.getParticleSizeDistribution_abv_60_Lay_1(req));//60
                Object.assign(objUpdateGranulationData.data,objProductGranulation.getParticleSizeDistribution_abv_80_Lay_1(req));//61
                Object.assign(objUpdateGranulationData.data,objProductGranulation.getParticleSizeDistribution_abv_100_Lay_1(req));//62
                Object.assign(objUpdateGranulationData.data,objProductGranulation.getParticleSizeDistribution_blw_100_Lay_1(req));//63

                await models.tbl_product_gran_cap.update(objUpdateGranulationData.data,{
                    where:objUpdateGranulationData.condition,
                    transaction:t
                });

            }else{
                //was granulation removed data
                await models.tbl_product_gran_cap.destroy({
                    where: objUpdateGranulationData.condition,
                    transaction: t
                });

                await models.tbl_product_master.update({ IsGranulation : 0},
                    {
                        where:updateProductGranObj.condition,
                        transaction:t
                    });
            }

            now = new Date();

            (req.auditObject.result.ProductDetail.newData == undefined) ? newPrdVal = "NA" : newPrdVal = req.auditObject.result.ProductDetail.newData;
            (req.auditObject.result.ProductDetail.oldData == undefined) ? oldPrdVal = "NA" : oldPrdVal = req.auditObject.result.ProductDetail.oldData;

            if((req.auditObject.result.ProductDetail.newData == undefined) && (req.auditObject.result.Grannual.newData != undefined)){
                newPrdVal = req.auditObject.result.Grannual.newData;
            }else if((req.auditObject.result.ProductDetail.newData != undefined) && (req.auditObject.result.Grannual.newData == undefined)){
                newPrdVal = req.auditObject.result.ProductDetail.newData;
            }else{
                newPrdVal = req.auditObject.result.ProductDetail.newData + ' | ' + req.auditObject.result.Grannual.newData;
            }

            if((req.auditObject.result.ProductDetail.oldData == undefined) && (req.auditObject.result.Grannual.oldData != undefined)){
                oldPrdVal = req.auditObject.result.Grannual.oldData;
            }else if((req.auditObject.result.ProductDetail.oldData != undefined) && (req.auditObject.result.Grannual.oldData == undefined)){
                oldPrdVal = req.auditObject.result.ProductDetail.oldData;
            }else{
                oldPrdVal = req.auditObject.result.ProductDetail.oldData + ' | ' + req.auditObject.result.Grannual.oldData;
            }
            oldPrdVal = oldPrdVal.slice(0, -1)
            /**
             * this cause just NA value in the old parameter when param is added for the first time
             */
            // var checkOldParameter = oldPrdVal.split(`|`);
            // if(checkOldParameter.length > 0){
            //     var arrOldParameter = [];
            //     for(var i = 0; i < checkOldParameter.length; i++){
            //         var oldParamVal = checkOldParameter[i].includes('NA');
            //         if(oldParamVal != true){
            //             var oldParam = checkOldParameter[i]+' |';
            //             arrOldParameter.push(oldParam);
            //         }
            //     }
            //     if(arrOldParameter.length > 0){
            //         oldPrdVal = arrOldParameter.toString();
            //         oldPrdVal = oldPrdVal.slice(0, -1)
            //     }else{
            //         oldPrdVal = "NA"; 
            //     }
                    
            // }else{
            //     oldPrdVal = "NA"; 
            // }

            await models.tbl_audit_product_capsule.create({
                DT: date.format(now, 'YYYY-MM-DD') ,
                TM: date.format(now, 'HH:mm:ss') ,
                userid: req.loggedUserId ,
                username: req.loggedUserName ,
                ProductId: req.str_BFGCode ,
                ProductName: req.str_Prd ,
                PrdVersion: req.str_PV ,
                Version: req.str_V ,
                GenericName: req.str_GenericName ,
                ProductType: 2 ,
                ACT: req.action ,
                Remark: req.remark ,
                OldValueComp: "NA" ,
                NewValueComp: "NA" ,
                NewValueGran: newPrdVal,
                OldValueGran: oldPrdVal,
                type: 'Granulation' ,
                NewValue: newPrdVal == undefined ? 'NA':newPrdVal,
                OldValue: oldPrdVal == undefined ? 'NA':oldPrdVal
            },{
                transaction:t
            });

            return { "status": "Success" };
        } catch (err) {
            throw err;
        }

    }

    async updateGranulationDetail(req,t) {
        try {

                var IsBilayer, IsTrilayer, IsCoated, IsGrannulation, IsCompress;
                IsBilayer = req.bln_TypeBiLayPrd == true ? 1 : 0;
                IsTrilayer = req.bln_TypeTriLayPrd == true ? 1 : 0;
                IsCoated = req.bln_TypeCoatPrd == true ? 1 : 0;
                IsCompress = req.bln_TypeCompressed == true ? 1 : 0;
                IsGrannulation = req.bln_TypeGrannualPrd == true ? 1 : 0;
                var str_query = {};
                var whereCond = {};

                if (req.intGenericName == 1) {
                    await models.tbl_product_master.update({
                        isBinWeighing: req.bln_IsBinWeiging,
                        BatchSize: req.flt_BatchSize,
                        BatchUnit: req.str_BatchUnit,
                        IsBilayer: IsBilayer,
                        IsBilayerLbl: req.biLayerLabel,
                        IsTrilayer: IsTrilayer,
                        IsTrilayerLbl: req.triLayerLabel,
                        IsCoated: IsCoated,
                        IsGranulation: IsGrannulation,
                        IsCompress: IsCompress,
                        NominalNomenclature: 'Standard', 
                        IsActive: 0,
                        Upper_Surface : req.str_UpperSurface,
                        Lower_Surface : req.str_LowerSurface,
                        Appearance_Desc : req.str_ApperanceDesc,
                        Appearance_Desc_Coat: req.str_ApperanceDesc_Coat
                    },{
                        where: {
                            ProductId: req.str_BFGCode.trim(),
                            ProductName: req.str_Prd.trim(),
                            ProductVersion: req.str_PV.trim(),
                            Version: req.str_V.trim(),
                            GenericName: req.str_GenericName
                        },
                        transaction: t
                    });

                    whereCond = {
                        where:{
                            ProductId: req.str_BFGCode.trim(),
                            ProductName: req.str_Prd.trim(),
                            ProductVersion: req.str_PV.trim(),
                            Version: req.str_V.trim(),
                            GenericName: req.str_GenericName 
                        },
                        transaction: t
                    };

                }
                else {

                    await models.tbl_product_master.update({
                        isBinWeighing: req.bln_IsBinWeiging,
                        BatchSize: req.flt_BatchSize,
                        BatchUnit: req.str_BatchUnit,
                        IsBilayer: IsBilayer,
                        IsBilayerLbl: req.biLayerLabel,
                        IsTrilayer: IsTrilayer,
                        IsTrilayerLbl: req.triLayerLabel,
                        IsCoated: IsCoated,
                        IsGranulation: IsGrannulation,
                        IsCompress: IsCompress,
                        NominalNomenclature: 'Standard',
                        userID: req.loggedUserId,
                        IsActive: 0,
                        Upper_Surface : req.str_UpperSurface,
                        Lower_Surface : req.str_LowerSurface,
                        Appearance_Desc : req.str_ApperanceDesc,
                        Appearance_Desc_Coat: req.str_ApperanceDesc_Coat
                    },{
                        where: {
                            ProductId: req.str_BFGCode.trim(),
                            ProductName: req.str_Prd.trim(),
                            ProductVersion: req.str_PV.trim(),
                            Version: req.str_V.trim() 
                        },
                        transaction: t
                    });

                    whereCond = {
                        where:{
                            ProductId: req.str_BFGCode.trim(),
                            ProductName: req.str_Prd.trim(),
                            ProductVersion: req.str_PV.trim(),
                            Version: req.str_V.trim()
                        },
                        transaction: t
                    };
                }

                Object.assign(str_query, {...objProductGranulation.getLodDry(req)});//1
                Object.assign(str_query, {...objProductGranulation.getTabDensity(req)});//2
                Object.assign(str_query, {...objProductGranulation.getBulkDensity(req)});//3
                Object.assign(str_query, {...objProductGranulation.getLodLayer1Dry(req)});//4
                Object.assign(str_query, {...objProductGranulation.getTabDensity_Lay_1(req)});//5
                Object.assign(str_query, {...objProductGranulation.getBulkDensity_Lay_1(req)});//6
                Object.assign(str_query, {...objProductGranulation.getLodLayer2Dry(req)});//7
                Object.assign(str_query, {...objProductGranulation.getTabDensity_Lay_2(req)});//8
                Object.assign(str_query, {...objProductGranulation.getBulkDensity_Lay_2(req)});//9

                Object.assign(str_query, {...objProductGranulation.getFine_blw_30(req)});//10
                Object.assign(str_query, {...objProductGranulation.getFine_blw_40(req)});//11
                Object.assign(str_query, {...objProductGranulation.getFine_blw_60(req)});//12
                Object.assign(str_query, {...objProductGranulation.getFine_blw_80(req)});//13
                Object.assign(str_query, {...objProductGranulation.getFine_blw_100(req)});//14
                Object.assign(str_query, {...objProductGranulation.getFine_abv_30(req)});//15
                Object.assign(str_query, {...objProductGranulation.getFine_abv_40(req)});//16
                Object.assign(str_query, {...objProductGranulation.getFine_abv_60(req)});//17
                Object.assign(str_query, {...objProductGranulation.getFine_abv_80(req)});//18
                Object.assign(str_query, {...objProductGranulation.getFine_abv_100(req)});//19
                Object.assign(str_query, {...objProductGranulation.getFine_Pan(req)});//20

                Object.assign(str_query, {...objProductGranulation.getFine_blw_30_Lay_1(req)});//21
                Object.assign(str_query, {...objProductGranulation.getFine_blw_40_Lay_1(req)});//22
                Object.assign(str_query, {...objProductGranulation.getFine_blw_60_Lay_1(req)});//23
                Object.assign(str_query, {...objProductGranulation.getFine_blw_80_Lay_1(req)});//24
                Object.assign(str_query, {...objProductGranulation.getFine_blw_100_Lay_1(req)});//25
                Object.assign(str_query, {...objProductGranulation.getFine_abv_30_Lay_1(req)});//26
                Object.assign(str_query, {...objProductGranulation.getFine_abv_40_Lay_1(req)});//27
                Object.assign(str_query, {...objProductGranulation.getFine_abv_60_Lay_1(req)});//28
                Object.assign(str_query, {...objProductGranulation.getFine_abv_80_Lay_1(req)});//29
                Object.assign(str_query, {...objProductGranulation.getFine_abv_100_Lay_1(req)});//30
                Object.assign(str_query, {...objProductGranulation.getFine_Pan_Lay_1(req)});//31

                Object.assign(str_query, {...objProductGranulation.getFine_blw_30_Lay_2(req)});//32
                Object.assign(str_query, {...objProductGranulation.getFine_blw_40_Lay_2(req)});//33
                Object.assign(str_query, {...objProductGranulation.getFine_blw_60_Lay_2(req)});//34
                Object.assign(str_query, {...objProductGranulation.getFine_blw_80_Lay_2(req)});//35
                Object.assign(str_query, {...objProductGranulation.getFine_blw_100_Lay_2(req)});//36
                Object.assign(str_query, {...objProductGranulation.getFine_abv_30_Lay_2(req)});//37
                Object.assign(str_query, {...objProductGranulation.getFine_abv_40_Lay_2(req)});//38
                Object.assign(str_query, {...objProductGranulation.getFine_abv_60_Lay_2(req)});//39
                Object.assign(str_query, {...objProductGranulation.getFine_abv_80_Lay_2(req)});//40
                Object.assign(str_query, {...objProductGranulation.getFine_abv_100_Lay_2(req)});//41
                Object.assign(str_query, {...objProductGranulation.getFine_Pan_Lay_2(req)});//42

                Object.assign(str_query, {...objProductGranulation.getLodLubricated(req)});//43
                Object.assign(str_query, {...objProductGranulation.getLodLayer1Lubricated(req)});//44
                Object.assign(str_query, {...objProductGranulation.getLodLayer2Lubricated(req)});//45
                Object.assign(str_query, {...objProductGranulation.getFine(req)});//46
                Object.assign(str_query, {...objProductGranulation.getParticleSeizing(req)});//47
                Object.assign(str_query, {...objProductGranulation.getFine_Lay_1(req)});//48
                Object.assign(str_query, {...objProductGranulation.getFine_Lay_2(req)});//49

                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution(req)});//50
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_20(req)});//51
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_40(req)});//52
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_60(req)});//53
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_80(req)});//54
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_100(req)});//55
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_blw_100(req)});//56

                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_Lay_1(req)});//57
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_20_Lay_1(req)});//58
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_40_Lay_1(req)});//59
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_60_Lay_1(req)});//60
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_80_Lay_1(req)});//61
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_100_Lay_1(req)});//62
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_blw_100_Lay_1(req)});//63
                Object.assign(str_query, {...objProductGranulation.getParticleSeizing_Lay_1(req)});//64
                Object.assign(str_query, {...objProductGranulation.getParticleSeizing_Lay_2(req)});//65

                await models.tbl_product_gran.update(
                    str_query,
                    whereCond
                );

                now = new Date();
                var oldPrdVal = "", newPrdVal = "", oldPrdValGran = "", newPrdValGran = "";

                if((req.auditObject.result.ProductDetail.newData == undefined) && (req.auditObject.result.Grannual.newData != undefined)){
                    newPrdVal = req.auditObject.result.Grannual.newData;
                } else if((req.auditObject.result.ProductDetail.newData != undefined) && (req.auditObject.result.Grannual.newData == undefined)){
                    newPrdVal = req.auditObject.result.ProductDetail.newData;
                }else{
                    newPrdVal = req.auditObject.result.ProductDetail.newData + ' | ' + req.auditObject.result.Grannual.newData;
                }

                if((req.auditObject.result.ProductDetail.oldData == undefined) && (req.auditObject.result.Grannual.oldData != undefined)){
                    oldPrdVal = req.auditObject.result.Grannual.oldData;
                } else if((req.auditObject.result.ProductDetail.oldData != undefined) && (req.auditObject.result.Grannual.oldData == undefined)){
                    oldPrdVal = req.auditObject.result.ProductDetail.oldData;
                }else{
                    oldPrdVal = req.auditObject.result.ProductDetail.oldData+ ' | ' + req.auditObject.result.Grannual.oldData;
                }

                if((req.auditObject.result.ProductDetail.newData != undefined) && (req.auditObject.result.Grannual.newData == undefined)){
                    newPrdValGran = req.auditObject.result.ProductDetail.newData;
                } else if((req.auditObject.result.ProductDetail.newData == undefined) && (req.auditObject.result.Grannual.newData != undefined)){
                    newPrdValGran = req.auditObject.result.Grannual.newData;
                }else{
                    newPrdValGran = req.auditObject.result.ProductDetail.newData + ' | ' + req.auditObject.result.Grannual.newData;
                }

                if((req.auditObject.result.ProductDetail.oldData != undefined) && (req.auditObject.result.Grannual.oldData == undefined)){
                    oldPrdValGran = req.auditObject.result.ProductDetail.oldData;
                } else if((req.auditObject.result.ProductDetail.oldData == undefined) && (req.auditObject.result.Grannual.oldData != undefined)){
                    oldPrdValGran = req.auditObject.result.Grannual.oldData;
                }else{
                    oldPrdValGran = req.auditObject.result.ProductDetail.oldData+ ' | ' + req.auditObject.result.Grannual.oldData;
                }

                var strGenericName = "";
                (req.intGenericName == 1) ? strGenericName = req.str_GenericName : strGenericName = "NA";

                await models.tbl_audit_product.create({
                    DT: date.format(now, 'YYYY-MM-DD'),
                    TM: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    ACT: req.action,
                    Remark: req.remark,
                    ProductId: req.str_BFGCode.trim(),
                    ProductName: req.str_Prd.trim(),
                    PrdVersion: req.str_PV.trim(),
                    Version: req.str_V.trim(),
                    GenericName: strGenericName,
                    ProductType: req.int_prdType,
                    OldValueComp: 'NA',
                    NewValueComp: 'NA',
                    OldValueGran: oldPrdValGran,
                    NewValueGran: newPrdValGran,
                    OldValueCoat: 'NA',
                    NewValueCoat: 'NA',
                    type: 'Granulation',
                    NewValue: newPrdVal,
                    OldValue: oldPrdVal
                },{
                    transaction: t
                });

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    activity: "Product Updated", 
                },{
                    transaction: t
                });
                

            var responseObj = {};
            Object.assign(responseObj, { status: 'success' }, { result: 'ProductGranulation Updated Successfully' });
            return responseObj;
        } catch (err) {
            console.log(err);
            throw err;
        }
    }

    async updateGranulationPerticular(req,t) {
        try {            

                var str_query = {};
                var whereCond = {};

                if (req.intGenericName == 1) {
                    whereCond = {
                        where:{
                            ProductId: req.str_BFGCode.trim(),
                            ProductName: req.str_Prd.trim(),
                            ProductVersion: req.str_PV.trim(),
                            Version: req.str_V.trim(),
                            GenericName: req.str_GenericName
                        },
                        transaction: t
                    };

                }
                else {
                    
                    whereCond = {
                        where:{
                            ProductId: req.str_BFGCode.trim(),
                            ProductName: req.str_Prd.trim(),
                            ProductVersion: req.str_PV.trim(),
                            Version: req.str_V.trim()
                        },
                        transaction: t
                    };
                }

                Object.assign(str_query, {...objProductGranulation.getLodDry(req)});//1
                Object.assign(str_query, {...objProductGranulation.getTabDensity(req)});//2
                Object.assign(str_query, {...objProductGranulation.getBulkDensity(req)});//3
                Object.assign(str_query, {...objProductGranulation.getLodLayer1Dry(req)});//4
                Object.assign(str_query, {...objProductGranulation.getTabDensity_Lay_1(req)});//5
                Object.assign(str_query, {...objProductGranulation.getBulkDensity_Lay_1(req)});//6
                Object.assign(str_query, {...objProductGranulation.getLodLayer2Dry(req)});//7
                Object.assign(str_query, {...objProductGranulation.getTabDensity_Lay_2(req)});//8
                Object.assign(str_query, {...objProductGranulation.getBulkDensity_Lay_2(req)});//9

                Object.assign(str_query, {...objProductGranulation.getFine_blw_30(req)});//10
                Object.assign(str_query, {...objProductGranulation.getFine_blw_40(req)});//11
                Object.assign(str_query, {...objProductGranulation.getFine_blw_60(req)});//12
                Object.assign(str_query, {...objProductGranulation.getFine_blw_80(req)});//13
                Object.assign(str_query, {...objProductGranulation.getFine_blw_100(req)});//14
                Object.assign(str_query, {...objProductGranulation.getFine_abv_30(req)});//15
                Object.assign(str_query, {...objProductGranulation.getFine_abv_40(req)});//16
                Object.assign(str_query, {...objProductGranulation.getFine_abv_60(req)});//17
                Object.assign(str_query, {...objProductGranulation.getFine_abv_80(req)});//18
                Object.assign(str_query, {...objProductGranulation.getFine_abv_100(req)});//19
                Object.assign(str_query, {...objProductGranulation.getFine_Pan(req)});//20

                Object.assign(str_query, {...objProductGranulation.getFine_blw_30_Lay_1(req)});//21
                Object.assign(str_query, {...objProductGranulation.getFine_blw_40_Lay_1(req)});//22
                Object.assign(str_query, {...objProductGranulation.getFine_blw_60_Lay_1(req)});//23
                Object.assign(str_query, {...objProductGranulation.getFine_blw_80_Lay_1(req)});//24
                Object.assign(str_query, {...objProductGranulation.getFine_blw_100_Lay_1(req)});//25
                Object.assign(str_query, {...objProductGranulation.getFine_abv_30_Lay_1(req)});//26
                Object.assign(str_query, {...objProductGranulation.getFine_abv_40_Lay_1(req)});//27
                Object.assign(str_query, {...objProductGranulation.getFine_abv_60_Lay_1(req)});//28
                Object.assign(str_query, {...objProductGranulation.getFine_abv_80_Lay_1(req)});//29
                Object.assign(str_query, {...objProductGranulation.getFine_abv_100_Lay_1(req)});//30
                Object.assign(str_query, {...objProductGranulation.getFine_Pan_Lay_1(req)});//31

                Object.assign(str_query, {...objProductGranulation.getFine_blw_30_Lay_2(req)});//32
                Object.assign(str_query, {...objProductGranulation.getFine_blw_40_Lay_2(req)});//33
                Object.assign(str_query, {...objProductGranulation.getFine_blw_60_Lay_2(req)});//34
                Object.assign(str_query, {...objProductGranulation.getFine_blw_80_Lay_2(req)});//35
                Object.assign(str_query, {...objProductGranulation.getFine_blw_100_Lay_2(req)});//36
                Object.assign(str_query, {...objProductGranulation.getFine_abv_30_Lay_2(req)});//37
                Object.assign(str_query, {...objProductGranulation.getFine_abv_40_Lay_2(req)});//38
                Object.assign(str_query, {...objProductGranulation.getFine_abv_60_Lay_2(req)});//39
                Object.assign(str_query, {...objProductGranulation.getFine_abv_80_Lay_2(req)});//40
                Object.assign(str_query, {...objProductGranulation.getFine_abv_100_Lay_2(req)});//41
                Object.assign(str_query, {...objProductGranulation.getFine_Pan_Lay_2(req)});//42

                Object.assign(str_query, {...objProductGranulation.getLodLubricated(req)});//43
                Object.assign(str_query, {...objProductGranulation.getLodLayer1Lubricated(req)});//44
                Object.assign(str_query, {...objProductGranulation.getLodLayer2Lubricated(req)});//45
                Object.assign(str_query, {...objProductGranulation.getFine(req)});//46
                Object.assign(str_query, {...objProductGranulation.getParticleSeizing(req)});//47
                Object.assign(str_query, {...objProductGranulation.getFine_Lay_1(req)});//48
                Object.assign(str_query, {...objProductGranulation.getFine_Lay_2(req)});//49

                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution(req)});//50
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_20(req)});//51
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_40(req)});//52
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_60(req)});//53
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_80(req)});//54
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_100(req)});//55
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_blw_100(req)});//56

                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_Lay_1(req)});//57
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_20_Lay_1(req)});//58
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_40_Lay_1(req)});//59
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_60_Lay_1(req)});//60
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_80_Lay_1(req)});//61
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_abv_100_Lay_1(req)});//62
                Object.assign(str_query, {...objProductGranulation.getParticleSizeDistribution_blw_100_Lay_1(req)});//63
                Object.assign(str_query, {...objProductGranulation.getParticleSeizing_Lay_1(req)});//64
                Object.assign(str_query, {...objProductGranulation.getParticleSeizing_Lay_2(req)});//65

                await models.tbl_product_gran.update(
                    str_query,
                    whereCond
                );

                now = new Date();
                var oldPrdVal = "", newPrdVal = "", oldPrdValGran = "", newPrdValGran = "";
                (req.auditObject.result.ProductDetail.newData == undefined) ? newPrdVal = "NA" : newPrdVal = req.auditObject.result.ProductDetail.newData;
                (req.auditObject.result.ProductDetail.oldData == undefined) ? oldPrdVal = "NA" : oldPrdVal = req.auditObject.result.ProductDetail.oldData;
                (req.auditObject.result.Grannual.oldData == undefined) ? oldPrdValGran = "NA" : oldPrdValGran = req.auditObject.result.Grannual.oldData;
                (req.auditObject.result.Grannual.newData == undefined) ? newPrdValGran = "NA" : newPrdValGran = req.auditObject.result.Grannual.newData;

                var strGenericName = "";
                (req.intGenericName == 1) ? strGenericName = req.str_GenericName : strGenericName = "NA";

                await models.tbl_audit_product.create({
                    DT: date.format(now, 'YYYY-MM-DD'),
                    TM: date.format(now, 'HH:mm:ss') ,
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    ACT: req.action,
                    Remark: req.remark,
                    ProductId: req.str_BFGCode.trim(),
                    ProductName: req.str_Prd.trim(),
                    PrdVersion: req.str_PV.trim(),
                    Version: req.str_V.trim(),
                    GenericName: strGenericName,
                    ProductType: req.int_prdType,
                    OldValueComp: 'NA',
                    NewValueComp: 'NA',
                    OldValueGran: oldPrdValGran,
                    NewValueGran: newPrdValGran,
                    OldValueCoat: 'NA',
                    NewValueCoat: 'NA',
                    type: 'Granulation',
                    NewValue: newPrdVal,
                    OldValue: oldPrdVal 
                },{
                    transaction: t
                });
                
                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    activity: "Product Updated", 
                },{
                    transaction: t
                });

            var responseObj = {};
            Object.assign(responseObj, { status: 'success' }, { result: 'ProductGranulation Updated Successfully' });
            return responseObj;
        } catch (err) {
            console.log(err);
            throw err;
        }
    }

    async checkWeighmentDone(value)
    {
        try {  
            const obj_checkweightDoneorNot = await models.tbl_product_master.findAll({
                where:
                {
                    ProductId:value.ProductId,
                    SFOID:value.SFOID,
                    ProductName:value.ProductName,
                    ProductVersion:value.ProductVersion,
                    Version:value.Version
                }    
              });

              return obj_checkweightDoneorNot[0];
            
        } catch (error) {
            return err;
        }
    }

    async checkProductExist(value)
    {
        try {
            
            const obj_getProduct = await models.tbl_product_master.count({
                where:
                {
                    ProductId:value.str_BFG.trim(),
                    ProductName:value.str_name.trim(),
                    SFOID:value.str_sfoid.trim(),
                    ProductVersion:value.str_pversion.trim(),
                    Version:value.str_version.trim()
                }    
            });
            return obj_getProduct.toString();
        } catch (error) {
            console.log(error);
            return error;
        }   
    }

    async addExcelData(value)
    {
        try {
            console.log(value);
            
        } catch (error) {
            console.log(error);
            throw error;
        }   
    }

    async updateProductUncoatedMES(body,t){
        try {
            let objUpdateProductTablet = {
                data: {},
                condition: {
                    // ProductId: body.productID,
                    MPN_Code: body.MPNCode,
                    // ProductName: body.productname,
                }
            }
            let result = await models.tbl_product_tablet_temp.findAll({ where: objUpdateProductTablet.condition});
            let newDatadb = result[0];
    
            Object.assign(objUpdateProductTablet.data, objUpdateProduct.getIndividualObjectMES(newDatadb));
            Object.assign(objUpdateProductTablet.data, objUpdateProduct.getGroupObjectMES(newDatadb));
            Object.assign(objUpdateProductTablet.data, objUpdateProduct.getThicknessObjectMES(newDatadb));
            Object.assign(objUpdateProductTablet.data, objUpdateProduct.getBreadthObjectMES(newDatadb));
            Object.assign(objUpdateProductTablet.data, objUpdateProduct.getDiameterObjectMES(newDatadb));
            Object.assign(objUpdateProductTablet.data, objUpdateProduct.getHardnessObjectMES(newDatadb));
            Object.assign(objUpdateProductTablet.data, objUpdateProduct.getFriabilityObjectMES(newDatadb));
            Object.assign(objUpdateProductTablet.data, objUpdateProduct.getMouistueObjectMES(newDatadb));
            Object.assign(objUpdateProductTablet.data, objUpdateProduct.getDTObjectMES(newDatadb));
            Object.assign(objUpdateProductTablet.data, objUpdateProduct.getIndividualLay1ObjectMES(newDatadb));
            Object.assign(objUpdateProductTablet.data, objUpdateProduct.getGroupLay1ObjectMES(newDatadb));
            let master={}
            Object.assign(master,
                { ProductId : newDatadb.ProductId  },
                { ProductName: newDatadb.ProductName },
                { ProductVersion: newDatadb.ProductVersion },
                { Version : newDatadb.Version  });
            Object.assign(objUpdateProductTablet.data, master);
            console.log(objUpdateProductTablet.data);
            await models.tbl_product_tablet.update(objUpdateProductTablet.data,{
                where: objUpdateProductTablet.condition,
                transaction : t
            });
            
            await models.tbl_product_master.update(master,{
                where: objUpdateProductTablet.condition,
                transaction : t
            });
            return { "status": "Success" };
        } catch (error) {
            throw error
        }

    }

    async updateProductCapsuleMES(body,t){
        try {
            let objUpdateProductCapsule = {
                data: {},
                condition: {
                    ProductId: body.productID,
                    ProductName: body.productname,
                }
            }
            let result = await models.tbl_product_capsule_temp.findAll({ where: objUpdateProductCapsule.condition});
            let newDatadb = result[0];
    
            Object.assign(objUpdateProductCapsule.data, objUpdateProduct.getIndividualObjectMES(newDatadb));
            Object.assign(objUpdateProductCapsule.data, objUpdateProduct.getGroupObjectMES(newDatadb));
            //Object.assign(objUpdateProductCapsule.data, objUpdateProduct.getEmptyObjectMES(newDatadb));
            Object.assign(objUpdateProductCapsule.data, objUpdateProduct.getNetObjectMES(newDatadb));
            Object.assign(objUpdateProductCapsule.data, objUpdateProduct.getLengthObjectMES(newDatadb));
            Object.assign(objUpdateProductCapsule.data, objUpdateProduct.getEmptyGroupObjectMES(newDatadb));
            Object.assign(objUpdateProductCapsule.data, objUpdateProduct.getDTObjectMES(newDatadb));
          
            await models.tbl_product_capsule.update(objUpdateProductCapsule.data,{
                where: objUpdateProductCapsule.condition,
                transaction : t
            });

            return { "status": "Success" };
        } catch (error) {
            throw error
        }

    }
}
module.exports = ProductModel;