const dbCon = require('../Utills/db')
const date = require('date-and-time')
let sha1 = require('sha1');
const Database = require('../database/clsQueryProcess');
const database = new Database();
const requestIp = require('request-ip');
const config = require('../global/serverConfig');
const fs = require('fs');
const jsonfile = require('jsonfile');
// var mysql = require('mysql2');
const models = require('./../dbConnection').models;
const sequelize = require('./../dbConnection').sequelize;
const { QueryTypes } = require('sequelize');
const { Op } = require("sequelize");
const seqTransaction = require("../dbConnection");
const tbl_cubical = require('../../../IncrencyV4_DRL_Model/models/Setting/System Setting/tbl_cubical');

class LoginModel {
  async unauthorizedUser() {
        try {
            var result = await models.tbl_audit_unauthorized_user.findAll({
                attributes: [
                    [sequelize.fn('DISTINCT', sequelize.col('userid')) ,'userid'],
                ]
            });
            return result;
        } catch (error) {
           return  error;
        }
    }

     async chkUserActive(value){
        try{
            const responseObj = {};
            var companyName = await this.getDeveloperFile();
            var file = companyName;
            var jsonData = jsonfile.readFileSync(file);
            var extension = jsonData.Ldap[1].Value;
            var value1 = (value.userId).search("@");
           var username = (value1 == -1) ?  value.userId+extension :  value.userId;
            var result = await models.tbl_users.findAll({
                where: {
                  [Op.or]: [{UserID: value.userId}, {UserName: username}]
                }
              });
            Object.assign(responseObj, { status: 'success' }, { result: result[0] });
        return responseObj;
        }catch(error){
            console.log("error",error);
            return error;
        }
     }

     async developerPannel(){
         try{
            var res = await models.tbl_rpt_path.findAll({
                logging : false,
                attributes: ['Comp_name']
            });

           return res[0].Comp_name;
            
         }catch(error){
             return error;
         }
     }

     async loginMain(userId, userPass, source, Ip,req){
        try{
            var responseObj = {};
            var now = new Date();
            var result;
            var ClientIp = Ip.split(':')[3]
            if (ClientIp === undefined) {
                ClientIp = '127.0.0.1';
            } else {
                ClientIp = ClientIp;
            }
            var ip = ClientIp;
            if(source == 'IDS') {
                ip = req.body.ip;
            }

            if(source == 'hardware') {
                console.log("1.source",source,"-req.body.hmi",req.body.hmi);
                ip = req.body.hmi;
            }

            console.log("2.source",source,"-ip",ip);

            //const checkactive = await dbCon.execute(`SELECT * FROM tbl_users WHERE upper(UserID) = ?`,[userId.toUpperCase()]);
            //result = checkactive;
            //const checkactive = await dbCon.execute(`SELECT * FROM tbl_users WHERE BINARY UserID = ?`,[userId]);
            //result = checkactive;
            const checkactive = await models.tbl_users.findAll({
                where: {
                UserID:userId
            }});
            if(Object.keys(checkactive).length === 0){
                Object.assign(responseObj, { status: 'success' }, { result: 'Incorrect Credentials' })
                console.log("0.ResponseIncorrect",responseObj);
                return responseObj;
            }else{
                const checkForUserIDPassword = await models.tbl_users.findAll({
                    where: {
                        UserID:userId,
                        realPassword:userPass
                    }
                });

                console.log("0.UserDetail",userId + userPass);
                if(Object.keys(checkForUserIDPassword).length > 0){
                    var addLoginAttampt = await this.addLoginAttamptValue(userId, userPass, source, ip);
                    if(addLoginAttampt.result == 'success'){
                        var getUserDetailsData = await this.checkIfUserDataExist(userId, userPass);
                        console.log("1.ResponseSuccess",getUserDetailsData);
                        return getUserDetailsData; 
                    }else if((addLoginAttampt.result === "Password Expired, Please Change Your Password") || (addLoginAttampt.result === "User Auto Disabled, Change Password") || 
                    (addLoginAttampt.result === "Please Change Your Password") || 
                    (addLoginAttampt.result.search(/Your Password Expire in/g) != -1)){
                        var getUserDetailsData1 = await this.checkIfUserDataExist(userId, userPass);
                        Object.assign(responseObj, { status: 'success' }, { result: addLoginAttampt.result },{ data: getUserDetailsData1.result},{userName: getUserDetailsData1.userName})
                        console.log("2.ResponseSuccess",responseObj);
                        return responseObj;
                    }
                    else{
                        Object.assign(responseObj, { status: 'success' }, { result: addLoginAttampt.result },{userName: addLoginAttampt.userName})
                        console.log("3.ResponseSuccess",responseObj);
                        return responseObj;
                    }
                }else{
                    var unauthorizedUser = await this.unauthorizedUserSaveData(userId,ip);
                    var addLoginAttampt = await this.addLoginAttamptValue(userId, userPass, source, ip);
                    if(addLoginAttampt.result == 'success'){
                        var getUserDetailsData = await this.checkIfUserDataExist(userId, userPass);
                        console.log("4.ResponseSuccess",getUserDetailsData);
                        return getUserDetailsData; 
                    }else if((addLoginAttampt.result === "Password Expired, Please Change Your Password") || (addLoginAttampt.result === "User Auto Disabled, Change Password") ||
                    (addLoginAttampt.result === "Please Change Your Password") || 
                    (addLoginAttampt.result.search(/Your Password Expire in/g) != -1)){
                        var getUserDetailsData1 = await this.checkIfUserDataExist(userId, userPass);
                        Object.assign(responseObj, { status: 'success' }, { result: addLoginAttampt.result },{ data: getUserDetailsData1.result},{userName: getUserDetailsData1.userName})
                        console.log("5.ResponseSuccess",responseObj);
                        return responseObj;
                    }
                    else{
                        Object.assign(responseObj, { status: 'success' }, { result: addLoginAttampt.result },{userName: addLoginAttampt.userName})
                        console.log("6.ResponseSuccess",responseObj);
                        return responseObj;
                    }
                }
            }
        }catch(error){
            return error;
        }
    }

    async addLoginAttamptValue(userId, userPass, source, ip){
        try{
            var responseObj = {};
            var now = new Date();
            //var userManagementData = await this.userManagement(userId, userPass, source, ip);
            console.log("SP.source",source,"-ip",ip);
            var userManagementData = await this.userManagement(userId, userPass, source, ip, date.format(now, 'HH:mm:ss'), date.format(now, 'YYYY-MM-DD'));
            var message = userManagementData[0]['message'];
            var userName = userManagementData[0]['userName'];
            Object.assign(responseObj, { status: 'success' }, { result: message }, {userName: userName})
            return responseObj;
            //return message;
        }catch(error){
            throw error;
        }
    }

    async userManagement(userId, userPass, source, ip, time,dates){
        try {
            let storedProcedureQuery = `DECLARE @message VARCHAR(500), @userName VARCHAR(50);EXEC userManagement '${userId}','${userPass}','${source}','${ip}','${time}','${dates}',@message = @message OUT,@userName = @userName OUT;SELECT @message as message,@userName as userName;`;    
            var result = await sequelize.query(storedProcedureQuery,{  type : QueryTypes.SELECT  });
            return result;
        } catch (error) {
            console.log("Error : ",error);
        }
    }

    async getParameterData(){
        try{
            // const parameterObj = {
            //     str_tableName: 'tbl_setallparameter',
            //     data: '*'
            // }
            // var result = await database.select(parameterObj);
            // if(result[0].length > 0){
            //     var data = result[0][0];
            //     return data;
            // }else{
            //     return false;
            // }
        }catch(error){
            return error;
        }
    }

    async checkIfUserDataExist(userId, userPass){
        try{
            var responseObj = {};
            const result = await models.tbl_users.findAll({
                where:{
                    UserID:userId,
                    realPassword:userPass
                }
            });
            if(Object.keys(result).length > 0){
                let data = [];
                data = result[0];
                const roleName = data.Role;
                var userName = data.UserName;
                let allRoleRights = [], allSplRights = [], allRemoveRights = [];
                var roleRights = await this.roleRight(roleName);
                var splRights = await this.splRight(userId);
                var removeRights = await this.removeRight(userId);
                for (let i = 0; i < roleRights.length; i++) {
                    allRoleRights.push(roleRights[i].role_rights)
                }
                for (let i = 0; i < splRights.length; i++) {
                    allSplRights.push(splRights[i].spl_right)
                }
                for (let i = 0; i < removeRights.length; i++) {
                    allRemoveRights.push(removeRights[i].removed_right)
                }
                Object.assign(data, { rights: allRoleRights }, { splRights: allSplRights }, { removeRights: allRemoveRights })
                Object.assign(responseObj, { status: 'success' }, { result: data },{ data: data },{userName: userName})
                return responseObj;
            }else{
                return false;
            }

        }catch(error){
            return error;
        }
    }

    async unauthorizedUserSaveData(userId,ClientIp){
        try{
            
            let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                let now = new Date();
                await models.tbl_audit_unauthorized_user.create({
                    dt:date.format(now, 'YYYY-MM-DD'),
                    tm:date.format(now, 'HH:mm:ss'),
                    userid:userId,
                    username:'NA',
                    Host:ClientIp
                },{
                    transaction: t
                });
                return true;
            });

        }catch(error){
            return error;
        }
    }

//Old login ////////////////////////
    validateUserModel(userId, userPassword, Ip) {
        return new Promise((resolve, reject) => {
            let responseObj = {};
            let now = new Date();
            let ClientIp = Ip.split(':')[3]
            if (ClientIp === undefined) {
                ClientIp = '127.0.0.1'
            } else {
                ClientIp = ClientIp
            }
            const selectUserObj = {
                str_tableName: 'tbl_users',
                data: '*',
                condition: [
                    { str_colName: 'UserID', value: userId, comp: 'eq' },
                    { str_colName: 'realPassword', value: userPassword, comp: 'eq' }
                ]
            }
            database.select(selectUserObj).then((result) => {
                if (result[0].length !== 0) {
                    let data = [];
                    data = result[0];
                    const roleName = data[0].Role;
                    let allRoleRights = [], allSplRights = [], allRemoveRights = [];
                    this.roleRight(roleName).then(roleRights => {
                        this.splRight(userId).then(splRights => {
                            this.removeRight(userId).then(removeRights => {
                                for (let i = 0; i < roleRights[0].length; i++) {
                                    allRoleRights.push(roleRights[0][i].role_rights)
                                }
                                for (let i = 0; i < splRights[0].length; i++) {
                                    allSplRights.push(splRights[0][i].spl_right)
                                }
                                for (let i = 0; i < removeRights[0].length; i++) {
                                    allRemoveRights.push(removeRights[0][i].removed_right)
                                }
                                Object.assign(data[0], { rights: allRoleRights }, { splRights: allSplRights }, { removeRights: allRemoveRights })
                                Object.assign(responseObj, { status: 'success' }, { result: data[0] })
                                resolve(responseObj)
                            })

                        })
                    })
                } else {
                    const parameterObj = {
                        str_tableName: 'tbl_setallparameter',
                        data: '*'
                    }
                    database.select(parameterObj).then((result1) => {
                        let configData = [];
                        configData = result1[0];
                        let disableTime = configData[0].tbl_config_DisabledTime;
                        let loginAttempts = configData[0].tbl_config_LoginAttempts;
                        let AutoEnableChances = configData[0].tbl_config_AutoEnableChances;
                        const userObj = {
                            str_tableName: 'tbl_users',
                            data: '*',
                            condition: [
                                { str_colName: 'UserID', value: userId, comp: 'eq' }
                            ]
                        }
                        database.select(userObj).then((result2) => {
                            if (result2[0].length != 0) {
                                if (result2[0][0].Status == 1 && result2[0][0].PREV_STATUS == 11) {
                                    Object.assign(responseObj, { status: 'success' }, { result: 'Suspicious Activity' })
                                    resolve(responseObj)
                                }
                                else {
                                    let userData = [];
                                    userData = result2[0];
                                    let loginatmpt = userData[0].loginatmpt;
                                    let autoEnbl = userData[0].autoEnbl;
                                    var username = userData[0].UserName;
                                    var role = userData[0].Role;
                                    var department = userData[0].Department;

                                    let dbDate = date.format(now, 'YYYY-MM-DD HH:mm:ss');

                                    const auditUnauthorizedUser = {
                                        str_tableName: 'tbl_audit_unauthorized_user',
                                        data: [
                                            { str_colName: 'dt', value: date.format(now, 'YYYY-MM-DD') },
                                            { str_colName: 'tm', value: date.format(now, 'HH:mm:ss') },
                                            { str_colName: 'userid', value: userData[0].UserID },
                                            { str_colName: 'username', value: userData[0].UserName },
                                            { str_colName: 'Host', value: ClientIp }
                                        ]
                                    }

                                    database.save(auditUnauthorizedUser).catch(err => console.log(err));

                                    if ((loginatmpt + 1 < loginAttempts) && (autoEnbl == 0)) {
                                        let logCount = loginatmpt + 1;
                                        dbCon.execute("UPDATE tbl_users SET loginatmpt = ? WHERE UserID = ?", [logCount, userId]);
                                        const updateUserLoginCount = {
                                            str_tableName: 'tbl_users',
                                            data: [
                                                { str_colName: 'loginatmpt', value: logCount }
                                            ],
                                            condition: [
                                                { str_colName: 'UserID', value: userId }
                                            ]
                                        }

                                        database.update(updateUserLoginCount).catch(err => console.log(err));
                                        Object.assign(responseObj, { status: 'success' }, { result: 'Wrong Password' })
                                        resolve(responseObj)
                                    } else {
                                        if ((loginatmpt + 1 <= loginAttempts) && (autoEnbl + 1 <= AutoEnableChances)) {
                                            let autoEnblCount = autoEnbl + 1;
                                            const autoenblObj = {
                                                str_tableName: 'tbl_users',
                                                data: [
                                                    { str_colName: 'loginatmpt', value: loginatmpt + 1 },
                                                    { str_colName: 'autoEnbl', value: autoEnblCount },
                                                    { str_colName: 'suspensionPeriod', value: date.format(now, 'YYYY-MM-DD HH:mm:ss') }
                                                ],
                                                condition: [
                                                    { str_colName: 'UserID', value: userId }
                                                ]
                                            }
                                            database.update(autoenblObj).then(res => {
                                                if (loginatmpt + 1 >= loginAttempts) {
                                                    const lockUser = {
                                                        str_tableName: 'tbl_audit_users',
                                                        data: [
                                                            { str_colName: 'dt', value: date.format(now, 'YYYY-MM-DD') },
                                                            { str_colName: 'tm', value: date.format(now, 'HH:mm:ss') },
                                                            { str_colName: 'userid', value: userId },
                                                            { str_colName: 'username', value: username },
                                                            { str_colName: 'OldRole', value: role },
                                                            { str_colName: 'NewRole', value: role },
                                                            { str_colName: 'ACT', value: 'User Locked' },
                                                            { str_colName: 'KeyCode', value: userId },
                                                            { str_colName: 'KeyValue', value: username },
                                                            { str_colName: 'Remark', value: 'Exceeded Max No.of Login Attempts.Locked' },
                                                            { str_colName: 'OldDepartment', value: department },
                                                            { str_colName: 'NewDepartment', value: department }
                                                        ]
                                                    }
                                                    database.save(lockUser).then(res => {
                                                        Object.assign(responseObj, { status: 'success' }, { result: 'Temporary Disable' }, { suspensiontime: dbDate })
                                                        resolve(responseObj);
                                                    }).catch(err => console.log(err));
                                                }
                                            }).catch(err => console.log(err));



                                        } else if ((loginatmpt + 1 >= loginAttempts) && (autoEnbl + 1 == AutoEnableChances)) {
                                            const suspiciousObj = {
                                                str_tableName: 'tbl_users',
                                                data: [
                                                    { str_colName: 'Status', value: 1 },
                                                    { str_colName: 'loginatmpt', value: 0 },
                                                    { str_colName: 'autoEnbl', value: 0 },
                                                    { str_colName: 'suspensionPeriod', value: 0 },
                                                    { str_colName: 'PREV_STATUS', value: 11 }
                                                ],
                                                condition: [
                                                    { str_colName: 'UserID', value: userId }
                                                ]
                                            }
                                            database.update(suspiciousObj).catch(err => console.log(err));
                                            Object.assign(responseObj, { status: 'success' }, { result: 'Suspicious Activity' })
                                            resolve(responseObj)
                                        }
                                    }
                                }

                            } else {
                                const auditUnauthorizedUser = {
                                    str_tableName: 'tbl_audit_unauthorized_user',
                                    data: [
                                        { str_colName: 'dt', value: date.format(now, 'YYYY-MM-DD') },
                                        { str_colName: 'tm', value: date.format(now, 'HH:mm:ss') },
                                        { str_colName: 'userid', value: userId },
                                        { str_colName: 'username', value: 'NA' },
                                        { str_colName: 'Host', value: ClientIp }
                                    ]
                                }
                                database.save(auditUnauthorizedUser).catch(err => console.log(err));
                                Object.assign(responseObj, { status: 'fail' }, { result: 'Invalild credential' })
                                resolve(responseObj)
                            }
                        }).catch(err => {
                            reject('error while checking user in login')
                        })
                    }).catch(err => {
                        reject('error while checking set all parameter in login')
                    })
                }
            }).catch(err => {
                reject('error while checking userid and password are correct')
            })
        })
    }

    async setUserActiveModel(userId, ip, source) {
        try{
            var responseObj = {};
            var now = new Date();
            // const userObj = {
            //     str_tableName: 'tbl_users',
            //     data: '*',
            //     condition: [
            //         { str_colName: 'UserID', value: userId, comp: 'eq' }
            //     ]
            // }
            // var result = await tbl_users.select(userObj);
            var result = await models.tbl_users.findAll({
                where: {
                    UserID: userId
                }
            });
            var data = {};
            data = result[0];
            var userid = data[0].UserID;
            var username = data[0].UserName;
            var ClientIp = ip.split(':')[3]
            if (ClientIp === undefined) {
                ClientIp = '127.0.0.1'
            } else {
                ClientIp = ClientIp
            }
            // const updateUserObj = {
            //     str_tableName: 'tbl_users',
            //     data: [
            //         { str_colName: 'Status', value: 0 },
            //         { str_colName: 'active', value: 1 },
            //         { str_colName: 'source', value: source },
            //         { str_colName: 'LastLoginDt', value: date.format(now, 'YYYY-MM-DD') },
            //         { str_colName: 'HostName', value: ClientIp },
            //         { str_colName: 'loginCounter', value: 0 },
            //         { str_colName: 'loginatmpt', value: 0 }
            //     ],
            //     condition: [
            //         { str_colName: 'UserID', value: userId },
            //     ]
            // }
            // var result1 = await database.update(updateUserObj);
            const onj_updateUser = await models.tbl_users.update({
                Status : 0,
                active : 1,
                source : source,
                LastLoginDt : date.format(now, 'YYYY-MM-DD'),
                HostName : ClientIp,
                loginCounter : 0,
                loginatmpt : 0
            },
            {
                where: {UserID:userId}
            });
            // const loginActivity = {
            //         str_tableName: 'tbl_activity_log',
            //         data: [
            //             { str_colName: 'dt', value: date.format(now, 'YYYY-MM-DD') },
            //             { str_colName: 'tm', value: date.format(now, 'HH:mm:ss') },
            //             { str_colName: 'userid', value: userid },
            //             { str_colName: 'username', value: username },
            //             { str_colName: 'activity', value: 'Login: ' + userId }
            //         ]
            //     }
            // var result2 = await database.save(loginActivity);
            const loginActivity = await models.tbl_activity_log.create({
                dt : date.format(now, 'YYYY-MM-DD'),
                tm : date.format(now, 'YYYY-MM-DD HH:mm:ss'),
                userid : userid,
                username : username,
                activity : 'Login: ' + userId});
            Object.assign(responseObj, { status: 'success' })
            return responseObj;
           
        }catch(error){
            return error;
        }
    }

    async checkuserstatusLds(req)
    {
        try{
            var companyName = await this.getDeveloperFile();
            var file = companyName;
            var jsonData = jsonfile.readFileSync(file);
            var ldpVal = jsonData.Ldap[0].Value;
            var extension = jsonData.Ldap[1].Value;
            var checkLdsUser = await this.checkLdsUserId(req);
            return checkLdsUser;
            // if(checkLdsUser != false){
            // }else{
            //     var checkLdsUserName = await this.checkLdsUserName(req,ldpVal,extension);
            //     return checkLdsUserName;
            // }
           
        }catch(error){
            return error;
        }   
    }

    async checkLdsUserId(req){
        try{
            var companyName = await this.getDeveloperFile();
            var file = companyName;
            var jsonData = jsonfile.readFileSync(file);
            var ldpVal = jsonData.Ldap[0].Value;

            var result = await models.tbl_users.findAll({
                where:{
                    UserID: req.body.user
                }
            });

            let responseObj = {};
           
            if(result.length > 0)
            {
                const roleName = result[0].Role;
                const userId = req.body.user;
                var userName;
                if(ldpVal == 1){
                    userName = result[0].UserInitials;
                }else{
                    userName = result[0].UserName;
                }
                let allRoleRights = [], allSplRights = [], allRemoveRights = [];
                var roleRights =  await this.roleRight(roleName);
                var splRights =   await this.splRight(userId);
                var removeRights = await this.removeRight(userId);
                for (let i = 0; i < roleRights.length; i++) {
                    allRoleRights.push(roleRights[i].role_rights)
                }
                for (let i = 0; i < splRights.length; i++) {
                    allSplRights.push(splRights[i].spl_right)
                }
                for (let i = 0; i < removeRights.length; i++) {
                    allRemoveRights.push(removeRights[i].removed_right)
                }
                result.push({rights: allRoleRights} );
                result.push({splRights: allSplRights} );
                result.push({removeRights: allRemoveRights} );
                Object.assign(responseObj, { status: 'success' },{ result :result },{ userName : userName});
                return responseObj;
            }else{
               return false;
            }

        }catch(error){
            console.log("error",error)
            return error;
        }
    }
    
    async checkLdsUserName(req,ldpVal,extension){
        try{
        var userName = req.body.user.match('@') != null ? req.body.user : req.body.user+extension;
        var result = await models.tbl_users.findAll({
            where:{
                UserName: userName
            }
        });
        // var result = await dbCon.execute(`SELECT * FROM tbl_users WHERE UserName = '${userName}'`);
        let responseObj = {};
            if(result.length > 0)
            {
                const roleName = result[0].Role;
                const userId = result[0].UserID;
                var userName;
                if(ldpVal == 1){
                    userName = result[0].UserInitials;
                }else{
                    userName = result[0].UserName;
                }
                let allRoleRights = [], allSplRights = [], allRemoveRights = [];
                var roleRights =  await this.roleRight(roleName);
                var splRights =   await this.splRight(userId);
                var removeRights = await this.removeRight(userId);
                for (let i = 0; i < roleRights.length; i++) {
                    allRoleRights.push(roleRights[i].role_rights)
                }
                for (let i = 0; i < splRights.length; i++) {
                    allSplRights.push(splRights[i].spl_right)
                }
                for (let i = 0; i < removeRights.length; i++) {
                    allRemoveRights.push(removeRights[i].removed_right)
                }
                result.push({rights: allRoleRights} );
                result.push({splRights: allSplRights} );
                result.push({removeRights: allRemoveRights} );
                Object.assign(responseObj, { status: 'success' },{ result :result },{ userName : userName });
                return responseObj;
            }else{
               return false;
            }

        }catch(error){
            return error;
        }
    }

    async validateUserDetails(req) {
        try {
            var transaction = await seqTransaction.sequelize.transaction(async (t) => {
            var responseObj = {};
            var clientIp = requestIp.getClientIp(req);
            var userId = req.body.userId;
            // var user = userName.trim();
            // var value = (user).search("@");
            // var userVal;
            // var userData = await models.tbl_users.findAll({
            //     where:
            //     {
            //         UserID: user
            //     }
            // });

            // if (userData.length > 0) {
            //     userVal = userData[0].UserName;
            // } else {
            //     var userData1;
            //     if (value != -1) {
            //         userData1 = await models.tbl_users.findAll({
            //             where:
            //             {
            //                 UserName: user
            //             }
            //         });
            //         if (userData1.length > 0) {
            //             userVal = userData1[0].UserName;
            //         }
            //     } else {

            //         let query = `select * from tbl_users WHERE SUBSTRING(UserName, 0,CHARINDEX('@',UserName)) = '${user}'`;
            //         userData1 = await sequelize.query(query, { type: QueryTypes.SELECT });

            //         if (userData1.length > 0) {
            //             userVal = userData1[0].UserName;
            //         }
            //     }

            // }

            var userdata = await models.tbl_users.findAll({
                where:
                {
                    UserID: userId
                }
            });

            var data = userdata[0];
            if (data.active == 1) {
                Object.assign(responseObj, { status: 'success' }, { result: 'User Active' });
                return responseObj;
            }
            else {
                await models.tbl_users.update({
                    active: 1,
                    realPassword: 'VALIDATED',
                    source: (req.body.source === 'hardware') ? 'TSH':'Software',
                    HostName: clientIp.split(':')[3]
                }, {
                    where:
                        { UserID: userId },
                        transaction:t
                });
                let now = new Date();
                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: req.body.userId,
                    username: req.body.strUserName,
                    activity:`Logged in on ${ req.body.source === 'hardware' ? 'TSH':'Software'}: ${req.body.source === 'hardware' ? req.body.hmi : req.body.userId}`
                },{
                    transaction:t
                });

                Object.assign(responseObj, { status: 'success' }, { result: 'User Validated Successfully' });
                return responseObj;

            }
        });
        return transaction;
        } catch (error) {
            console.log("error",error);
            return error;
        }
    }

    async logOutModel(userId,mode) {
        try {
            let now = new Date();
            let responseObj = {};
            var transaction =await  seqTransaction.sequelize.transaction(async (t) => {
            var message;
            if(mode == "Auto")
            {
                message = "Time out ! Logged out from Software";
            }
            else{
                message = 'Logged out from Software: ' + userId;
            }
            var companyName = await this.getDeveloperFile();
            var file = companyName;
            var jsonData = jsonfile.readFileSync(file);
            var ldapVal = jsonData.Ldap[0].Value;
                
            var result = await models.tbl_users.findAll({
                where: {
                    UserID: userId
                },
                transaction:t
            });
            var data = {};
            data = result[0];
            var userid = data.UserID;
            var username = "";
            if(ldapVal == 1){
                username = data.UserInitials;
            }else{
                username = data.UserName;
            }
                
            const obj_updateUser = await models.tbl_users.update({
                active : 0,
                source : 0,
                lstActvtyTime : date.format(now, 'YYYY-MM-DD HH:mm:ss')},
            {
                where: {UserID:userid},
                transaction:t
            });
                
                // Following query will check if this record is already inserted or not. 
                // if it is already inserted then mysql will not perform insert operation.
                // userid==username is checked bcoz if both are same then mysql will generate error dupicate column name
                // to avoid that [let usernameTemp = username + " ";] here additional space is added. 
                if(userid==username)
                {
                    let usernameTemp = username + " ";
                    // let checkRes  = await dbCon.execute(`INSERT INTO tbl_activity_log (dt,tm,userid,username,activity)
                    // SELECT * FROM (SELECT '${dt}','${tm}','${userid}','${usernameTemp}','${message}') AS tmp
                    // WHERE NOT EXISTS (SELECT dt,tm,userid,username,activity FROM tbl_activity_log WHERE dt='${dt}' AND tm='${tm}' AND userid='${userid}' AND username='${username}' AND activity='${message}'
                    // ) LIMIT 1`);
                }
                else
                {
                    // let checkRes  = await dbCon.execute(`INSERT INTO tbl_activity_log (dt,tm,userid,username,activity)
                    // SELECT * FROM (SELECT '${dt}','${tm}','${userid}','${username}','${message}') AS tmp
                    // WHERE NOT EXISTS (SELECT dt,tm,userid,username,activity FROM tbl_activity_log WHERE dt='${dt}' AND tm='${tm}' AND userid='${userid}' AND username='${username}' AND activity='${message}'
                    // ) LIMIT 1`);
                }
                const loginActivity = await models.tbl_activity_log.create({
                    dt : date.format(now, 'YYYY-MM-DD'),
                    tm : date.format(now, 'HH:mm:ss'),
                    userid : userid,
                    username : username,
                    activity : message},{
                        transaction:t
                    });
                    return "success"
            });

            if(transaction == 'success'){
                const lastRecord = await models.tbl_activity_log.findAll({where:{dt:date.format(now, 'YYYY-MM-DD')}});
                console.log(date.format(lastRecord[2].tm, 'HH:mm:ss'));
                Object.assign(responseObj, { status: 'success' }, { result: 'User logged out successfully' })
                return responseObj;
            }
            } catch(error) {
                //console.log(error)
                throw error;
            }
    }

  async updatepassword(value) {
        try{
        var responseObj = {};
        var now = new Date();
        var result = await models.tbl_users.findAll({
            where: {
                UserID: value.userId,
                realPassword:value.userOldPassword
            }
        });

           if(result.length != 0){
                const obj_User = await models.tbl_users.update({
                    Pwd : sha1(value.userPassword),
                    PwdChgDate : date.format(now, 'YYYY-MM-DD'),
                    Status : 0,
                    PwdChg : 0,
                    active : 0,
                    PwdExpStauts : 0,
                    realPassword : value.userPassword,
                    LastLoginDt : date.format(now, 'YYYY-MM-DD')
                    },{
                    where: {UserID:value.userId}
                });
                
                const obj_insertPassword = await models.tbl_pwd_history.create({
                    userid : value.userId,
                    password : value.userPassword,
                    pwdChgDate : date.format(now, 'YYYY-MM-DD'),
                    addedTime : date.format(now, 'YYYY-MM-DD HH:mm:ss'),
                    realPassword : value.userPassword
                });
                /******03042021*******/
                let DoneByUserID = value.userId;
                let DoneByUserName = value.userName;
                let AffectedUserID = value.userId;
                let AffectedUserName = value.userName;
                let OldValue = value.userOldPassword;
                let NewValue = value.userPassword;
                let Remark = value.remark;
                /*****03042021********/
                // req.body.status : 1 = Admin (SuperAdmin) | 2 = normal user
                if (value.status == 1) {
                    const obj_insertAuditAdminPassword = await models.tbl_audit_admin_password.create({
                        dt : date.format(now, 'YYYY-MM-DD'),
                        tm : date.format(now, 'YYYY-MM-DD HH:mm:ss'),
                        userid : value.userId,
                        username : value.userName,
                        oldValue : OldValue,
                        NewValue:NewValue,
                        Remark:value.remark
                    });
                    let Action = "Change Admin Password";
                   
                    const result1 = await models.tbl_audit_change_password.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'YYYY-MM-DD HH:mm:ss'),
                        DoneByUserID : DoneByUserID,
                        DoneByUserName : DoneByUserName,
                        AffectedUserID : AffectedUserID,
                        AffectedUserName : AffectedUserName,
                        OldValue : sha1(OldValue),
                        NewValue:sha1(NewValue),
                        // OldValue : OldValue,
                        // NewValue:NewValue,
                        ACTION:Action,
                        Remark:Remark

                    });
                    // Object.assign(responseObj, { status: 'success' }, { result: 'Password Changed Successfully' })
                    // return responseObj;
                } else {
                    const insertAuditPasswordObj = await models.tbl_audit_user_chgpwdown.create({
                        dt : date.format(now, 'YYYY-MM-DD'),
                        tm : date.format(now, 'YYYY-MM-DD HH:mm:ss'),
                        userid : value.userId,
                        username : value.userName,
                        oldValue : value.userOldPassword,
                        NewValue: value.userPassword,
                        Remark:value.remark

                    });
                    let Action = "Change Own Password";
                    const result1 = await models.tbl_audit_change_password.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'YYYY-MM-DD HH:mm:ss'),
                        DoneByUserID : DoneByUserID,
                        DoneByUserName : DoneByUserName,
                        AffectedUserID : AffectedUserID,
                        AffectedUserName : AffectedUserName,
                        OldValue : sha1(OldValue),
                        NewValue:sha1(NewValue),
                        ACTION:Action,
                        Remark:Remark

                    });
                }
                const passwordChangeActivity = await models.tbl_activity_log.create({
                    dt : date.format(now, 'YYYY-MM-DD'),
                    tm : date.format(now, 'YYYY-MM-DD HH:mm:ss'),
                    userid : value.userId,
                    username : value.userName,
                    activity : 'Password Change'});

                    const autoLogout = await models.tbl_activity_log.create({
                        dt : date.format(now, 'YYYY-MM-DD'),
                        tm : date.format(now, 'YYYY-MM-DD HH:mm:ss'),
                        userid : value.userId,
                        username : value.userName,
                        activity : 'Logout: ' + value.userId});

                        
                Object.assign(responseObj, { status: 'success' }, { result: 'Password Changed Successfully' })
                return responseObj;
               
           }else{
            Object.assign(responseObj, { status: 'success' }, { result: 'Old Password is Wrong' })
            return responseObj;
           }
        }catch(error){
            console.log(error);
            return(error);
        }
    }

  async passwordHistory(value) {
      try{
            //var responseObj = {};
            // var data = [];
            // var result = await dbCon.execute("SELECT * FROM tbl_setallparameter");
            // data = result[0];
            // var pwdCount = data[0].tbl_config_PwdHistoryCount;
            // var result1 = await dbCon.execute("SELECT * FROM tbl_pwd_history WHERE userid = ? ORDER BY pwdChgDate DESC LIMIT ?", [req.body.userId, pwdCount]);
            // return result1[0];
            
            var data = [];   
            //var result = await dbCon.execute("SELECT * FROM tbl_setallparameter");
            var result = await models.tbl_setallparameter.findAll();
            data = result[0];
            var pwdCount = data.tbl_config_PwdHistoryCount; 
            var result1 = await models.tbl_pwd_history.findAll({
                where:{userid:value.userId},
                limit: pwdCount,
                //order: [[sequelize.models.store, sequelize.col('pwdChgDate'), 'DESC']],
                order: [
                    ['pwdChgDate', 'DESC']
                ]
              });
              return result1;
      }catch(error){
          return error;
      }
    }

   async updateUserLock(req) {
        try{
            var responseObj = {};
            var now = new Date();
            const userObj = {
                str_tableName: 'tbl_users',
                data: '*',
                condition: [
                    { str_colName: 'UserID', value: req.body.userId },
                ]
            }
            var result = await database.select(userObj);
            var data = result[0][0];
            var editStatus = data.autoEnbl;
            const objUpdateUser = {
                str_tableName: 'tbl_users',
                data: [
                    { str_colName: 'Status', value: 6 },
                    //{ str_colName: 'autoEnbl', value: editStatus + 1 },
                ],
                condition: [
                    { str_colName: 'userid', value: req.body.userId },
                ]
            }
            var result1 = await database.update(objUpdateUser);
            const auditObj = {
                str_tableName: 'tbl_audit_users',
                data: [
                    { str_colName: 'dt', value: date.format(now, 'YYYY-MM-DD') },
                    { str_colName: 'tm', value: date.format(now, 'HH:mm:ss') },
                    { str_colName: 'userid', value: req.body.userId },
                    { str_colName: 'username', value: data.UserName },
                    { str_colName: 'OldRole', value: data.Role },
                    { str_colName: 'NewRole', value: data.Role },
                    { str_colName: 'ACT', value: req.body.ACT },
                    { str_colName: 'Remark', value: req.body.Remark },
                    { str_colName: 'OldDepartment', value: data.Department },
                    { str_colName: 'NewDepartment', value: data.Department },
                ]
            }
            var result2 = await database.save(auditObj);
            Object.assign(responseObj, { status: 'success' })
            return responseObj;
            
        }catch(error){
            return error;
        }
    }

    async roleRight(roleName) {
        try {
            let result = await models.tbl_role.findAll({
                attributes:['role_rights'], 
                where:{role_name:roleName}
            });
            return result;
        } catch (error) {
            return error;
        }
        
    }
    async splRight(userId) {
        try {
            let result = await models.tbl_rights_special.findAll(
                {
                    attributes:['spl_right'],    
                    where:{userid:userId}
                }
            );
            return result;
        } catch (error) {
            return error;
        }
    }
    async removeRight(userId) {
        try {
            let result = await models.tbl_rights_removed.findAll(
                {
                    attributes:['removed_right'],    
                    where:{userid:userId}
                }
            );
            return result;
        } catch (error) {
            return error;
        }
    }


   async truncateTableModel() {
        try{

            var str_allData = await models.tbl_cubicle_area.findAll();

            var res_cubicle = "", res_cubSample="", res_alert="", res_calbStatus="",res_recalbStatus="",res_sysStatus="",res_cubBin=""
            ,res_cub_calb_bin="",res_cub_recalb_bin="", res_cub_recalb_ver = "";
            
            for (let element of str_allData) 
            { 
                res_cubicle = await this.initTables(element.IDSNos, element.Area, "tbl_cubical");
                res_cubSample = await this.initTables(element.IDSNos, element.Area, "tbl_cubicle_product_sample");
                res_alert = await this.initTables(element.IDSNos, element.Area, "tbl_alert_param_duration");
                res_calbStatus = await this.initTables(element.IDSNos, element.Area, "tbl_calibration_status");
                res_recalbStatus = await this.initTables(element.IDSNos, element.Area, "tbl_recalibration_balance_status");
                res_sysStatus = await this.initTables(element.IDSNos, element.Area, "tbl_system_weighingstatus");
                res_cubBin = await this.initTables(element.IDSNos, element.Area, "tbl_cubicle_bin_setting");
                res_cub_calb_bin = await this.initTables(element.IDSNos, element.Area, "tbl_calibration_status_bin");
                res_cub_recalb_bin = await this.initTables(element.IDSNos, element.Area, "tbl_recalibration_balance_status_bin");
                res_cub_recalb_ver = await this.initTables(element.IDSNos, element.Area, "tbl_recalibration_vernier_status");
            }

            //udpate the default value for Sys_IDSNo
            await models.tbl_cubical.update({Sys_IDSNo: 'NA'},{where:{}},{multi:true});
            return "Success";
        }catch(error){
            throw error;
        }
    }

    async truncateTableAll() {
        try{

            await models.tbl_role.destroy({where:
                {role_name:{[Op.ne]:'SuperAdmin'}}
            });

            await models.tbl_users.destroy({where:
                {
                    Role:{[Op.ne]:'SuperAdmin'},
                    userType:{[Op.ne]:1}
                }
            });

            await sequelize.query(`EXEC TruncateAllTables;`)

            return "Success";
        }catch(error){
            console.log("error",error);
            throw error;
        }
    }

    async initTables(int_IDSNo,str_area,str_tableName)
    {
        try {
            let storedProcedureQuery = `EXEC Setting '${int_IDSNo}','${str_area}','${str_tableName}';`;    
            var result = await sequelize.query(storedProcedureQuery);
            return result;  
        } catch (error) {
            return error;
        }      
    }

    // async getDeveloperFile_old(){
    //     try{
    //         const developerFileObj = {
    //             str_tableName:'tbl_rpt_path',
    //             data:'proj_name'
    //         }
    //         var result = await database.select(developerFileObj);
    //         if(result[0].length > 0){
    //             var file;
    //             var projectName = result[0][0].proj_name;
    //             if(projectName == 'RB'){
    //                 file = 'DeveloperPanel-RB.json';
    //                 return file;
    //             }
    //             else if(projectName == 'SVP'){
    //                 file = 'DeveloperPanel-SunVapi.json';
    //                 return file;
    //             }
    //             else if(projectName == 'SH'){
    //                 file = 'DeveloperPanel-SunHalol.json';
    //                 return file;
    //             }
    //             else if(projectName == 'CP7G'){
    //                 file = 'DeveloperPanel-Cipla7Goa.json';
    //                 return file;
    //             }
    //             else if(projectName == 'CP7BG'){
    //                 file = 'DeveloperPanel-Cipla7BGoa.json';
    //                 return file;
    //             }
    //             else if(projectName == 'CP8'){
    //                 file = 'DeveloperPanel-Cipla8.json';
    //                 return file;
    //             }
    //             else if(projectName == 'MVL'){
    //                 file = 'DeveloperPanel-MicrolabsVeerasandra.json';
    //                 return file;
    //             }
    //             else if(projectName == 'MLH'){
    //                 file = 'DeveloperPanel-MicrolabsHosur.json';
    //                 return file;
    //             }
    //             else if(projectName == 'CK1'){
    //                 file = 'DeveloperPanel-Cipla1CompKurkumb.json';
    //                 return file;
    //             }
    //             else if(projectName == 'CK2'){
    //                 file = 'DeveloperPanel-Cipla1Kurkumb.json';
    //                 return file;
    //             }
    //             else if(projectName == 'CP2A'){
    //                 file = 'DeveloperPanel-Cipla2-Indore-Airosol.json';
    //                 return file;
    //             }
    //             else if(projectName == 'CSK1'){
    //                 file = 'DeveloperPanel-Cipla1-Sikkim.json';
    //                 return file;
    //             }
    //             else if(projectName == 'CSK2'){
    //                 file = 'DeveloperPanel-Cipla2-Sikkim.json';
    //                 return file;
    //             }
    //             else if(projectName == 'ZM'){
    //                 file = 'DeveloperPanel-Zydus-Moraiya.json';
    //                 return file;
    //             }
    //             else{
    //                 file = 'DeveloperPanel.json';
    //                 return file; 
    //             }
                
    //         }else{
    //             return false;
    //         }

    //     }catch(error){
    //         return error;
    //     }
    // }

    async getDeveloperFile(){ // used config.json file
        try{
           var str_configFileName = config.developerPanelFileName;
           return str_configFileName;
        }catch(error){
            return error;
        }
    }

    async getProjectName(){
        try{
            const developerFileObj = {
                str_tableName:'tbl_rpt_path',
                data:'proj_name'
            }
            var result = await database.select(developerFileObj);
            if(result[0].length > 0){
                var projectName = result[0][0].proj_name;
                return projectName;
            }else{
                return false;
            }

        }catch(error){
            return error;
        }
    }

    async unauthorizedUserLDAP(req, Ip)
    {
        try{
            var now = new Date();
            var ClientIp = Ip.split(':')[3]
            if (ClientIp === undefined) {
                ClientIp = '127.0.0.1';
            } else {
                ClientIp = ClientIp;
            }

        /**get userid from from user table */
            const getUserID = {
                str_tableName: "tbl_users",
                data: "distinct UserID",
                condition:[
                    {str_colName:"UserName", value: req.body.username}
                ]
            }

            let resUserId = await database.select(getUserID);

            const objAuditUnauthorized = {
                str_tableName: 'tbl_audit_unauthorized_user',
                data: [
                    { str_colName: 'dt', value: date.format(now, 'YYYY-MM-DD') },
                    { str_colName: 'tm', value: date.format(now, 'HH:mm:ss') },
                    { str_colName: 'userid', value: resUserId[0][0].UserID },
                    { str_colName: 'username', value: req.body.username },
                    { str_colName: 'Host', value: ClientIp },
                ]
            }

            let result = await database.save(objAuditUnauthorized);
            return "Unathorized User";
        }catch(error){
            return error;
            
        }
    }

 
    async verifyConfiguration(){
        try{
           var responseObj = {};
           const verifyObj = {
               str_tableName: 'tbl_rpt_path',
               data: '*'
           }
           var result = await database.select(verifyObj);
           if(result[0].length > 0){
            var projectPath = result[0][0].path;
            var fileName = "logo.jpg";
            var path = projectPath + fileName;
            var fileStatus = await this.checkFileExist(path);
            Object.assign(responseObj, { status: 'success' }, { result: fileStatus });
            return responseObj;
           }else{
            Object.assign(responseObj, { status: 'success' }, { result: 'Data Not Found' });
            return responseObj;
           }
           

        }catch(error){
            return error;
        }
    }

    
    checkFileExist(path) {
        return new Promise((resolve, reject) => {
            var fileStatus;
        fs.access(path, fs.F_OK, (err) => {
                if (err) {
                  //console.error(err)
                  fileStatus = false;
                 resolve(fileStatus);
                }else{
                     fileStatus = true;
                    resolve(fileStatus);
                }                
        })
        })
    }
}



module.exports = LoginModel