var ActiveDirectory = require('activedirectory');
const { authenticate } = require('ldap-authentication');
const userData = require('../ldapGlobal/ldap.json');
var globalData = require('../ldapGlobal/severConfig');
var configData = require('../global/serverConfig');
const requestIp = require('request-ip');
const date = require('date-and-time')
const models = require("../dbConnection").models;
const seqTransaction  = require("../dbConnection");
const { decoding } = require("../ldapGlobal/MulteServerConfig");

var config = {
    url: globalData.ldapServer,
    baseDN: globalData.baseDn
  }

var count = 0;

  class LDAP {
  
    //Old LDAP Login
    validateUser(strUserName,strPassword,req) {
      return new Promise((resolve, reject) => {
        var ad = new ActiveDirectory(config);
        let Ip = requestIp.getClientIp(req);
        if( req.body.source && req.body.source == 'IDS') {
            Ip = req.body.ip;
        }

        if( req.body.source && req.body.source == 'hardware') {
            console.log("1.source",source,"-req.body.hmi",req.body.hmi);
            Ip = req.body.hmi;
        }

        var username = strUserName;
        var password = strPassword;
        var byPassLDAP = configData.byPassLDAP;
  
        if(byPassLDAP == true)
        {
          resolve({ response: 'Authenticated' });
        }
        else
        {
          var $this = this;
          ad.authenticate(username, password, function (err, auth) {
            if (err) {
             
              resolve({ response: 'Authenticated failed' });
            
            }
    
            if (auth) {
              resolve({ response: 'Authenticated' });
            }
            else {
             
              $this.insertEntryInUnauthorizedUser(username,Ip).then(res => {
                resolve({ response: 'Authenticated failed' });
              })
            }
          });
        }

      })
  
    }

    async insertEntryInUnauthorizedUser(username,Ip,t)
    {
      try{
          let now = new Date();
          let splitIp = Ip.split(':');

          // when split length === 1 then it come from tsh than show directly IP
          let ClientIp = splitIp.length === 1 ? Ip : splitIp[3];
          if (ClientIp === undefined) {
              ClientIp = '127.0.0.1'
          } else {
              ClientIp = ClientIp
          }

          let resultGet = await models.tbl_users.findAll({where:
            { UserID: username }
          });

          if(t == ''){
            await models.tbl_audit_unauthorized_user.create({
              dt: date.format(now, 'YYYY-MM-DD'),
              tm: date.format(now, 'HH:mm:ss'),
              userid: resultGet[0].UserID,
              username: resultGet[0].UserInitials,
              Host: ClientIp
            });
          }
          else {
            await models.tbl_audit_unauthorized_user.create({
              dt: date.format(now, 'YYYY-MM-DD'),
              tm: date.format(now, 'HH:mm:ss'),
              userid: resultGet[0].UserID,
              username: resultGet[0].UserInitials,
              Host: ClientIp
            },{ transaction : t});
          }
      return "Success";
      }catch(error){
        return error;
      }
    }

    //New Multi-Server Login
    async  authenticateUser(strUserName,strPassword,req) {
      var Ip = requestIp.getClientIp(req);
        if( req.body.source && req.body.source == 'IDS') {
          Ip = req.body.ip;
        }

        if( req.body.source && req.body.source == 'hardware') {
          console.log("1.source",source,"-req.body.hmi",req.body.hmi);
          Ip = req.body.hmi;
        }
      try {
          let transactionRes = await seqTransaction.sequelize.transaction(async (t) =>{
            // let Ip = requestIp.getClientIp(req);
            // if( req.body.source && req.body.source == 'IDS') {
            //     Ip = req.body.ip;
            // }

            // if( req.body.source && req.body.source == 'hardware') {
            //     console.log("1.source",source,"-req.body.hmi",req.body.hmi);
            //     Ip = req.body.hmi;
            // }

            var username = strUserName;
            var password = strPassword;
            var byPassLDAP = configData.byPassLDAP;
            var user = {};

            let userSplit = username.split(' ')
            if((username.match(/initial user/gi) && password == 'lm@10') || (username.match(/production user/gi) && password == '1911hkud') || (username.match(/system admin/gi) && password == 'rm@15') || (username.match(/qa user/gi) && password == '1911drad')){
              Object.assign(user,userData,{employeeID:`${new Date().valueOf()}`,cn:username,sn:userSplit[1],displayName: username,mail: `${username.replaceAll(' ','').toLowerCase()}@${userData.mail.split('@')[1]}`})              
            }else if(byPassLDAP){
              Object.assign(user,userData,{employeeID:`${new Date().valueOf()}`,cn:username,sn:userSplit[1],displayName: username,mail: `${username.replaceAll(' ','').toLowerCase()}@${userData.mail.split('@')[1]}`})

            }else{
              user = await authenticate({...globalData.ldapSetUp,adminPassword : decoding(process.env.adminPassword),username:username,userPassword: password});
              console.log('Authenticated user:', user);
              if(user == undefined){
                this.insertEntryInUnauthorizedUser(username,Ip,t)
                return {response: 'Authenticated failed' };
              }
            }

            Object.assign(user,{EmpID:username,mail:undefined});
            
            let obj_user = await this.checkUserIdExist(user)
            if(obj_user.length == 0){
              return { status: 'fail',response:'Authentication failed'};
            }else if(['NULL',null].includes(obj_user[0].Role)){
              return { status: 'fail',message:'Role Not Assigned <br> Contact Admin'};
            }else{
              return { status: 'success' , response: 'Authenticated'};
            }
            // let result = await this.insertNewUser(user,t);
            return result

          })

          return transactionRes;
        } catch (err) {
          if(err.lde_message == 'Invalid Credentials'){
            this.insertEntryInUnauthorizedUser(strUserName,Ip,'')
          }
          console.error('Authentication failed:', err.message);
          throw err.message;
        }
    }

    async checkUserIdExist(ldapRes){
      // { userId: ldapRes.employeeID } real code will be based on ID for testing its name
      let condition = {}
      if(configData.byPassLDAP){
        if(ldapRes.mail){
          Object.assign(condition,{ username: ldapRes.mail})       
        }else{
          Object.assign(condition,{ UserID: ldapRes.EmpID})       
        }
      }else{
        Object.assign(condition,{ userId: ldapRes.EmpID })
      }
      let res = await models.tbl_users.findAll({where: condition});
      return res;
    }

    async insertNewUser(ldapRes){
      try {
        let obj_user = await this.checkUserIdExist(ldapRes);
        var now = new Date();
        if(obj_user.length < 1){
          await models.tbl_users.create({
            UserID: ldapRes.EmpID || ldapRes.employeeID,
            UserName: ldapRes.mail || ' ',
            UserInitials: ldapRes.name || ldapRes.displayName,
            userType: 2 ,
            realPassword:'VALIDATED',
            PwdChgDate: date.format(now, 'YYYY-MM-DD'),
            PwdExpStauts: 0,
            Status: 0,
            Reason: 0,
            PwdChg: 1,
            isadmin: 0,
            LastLoginDt: date.format(now, 'YYYY-MM-DD'),
            loginatmpt: 0,
            suspensionPeriod: null,
            autoEnbl: 0,
            active: 0,
            lstActvtyTime: 0,
            HostName: 0,
            locked: 0,
            editCounter: 0,
            loginCounter: 0,
            source: 0,
            PREV_STATUS: 0,
            Domain: 0,
            failedAtmpTime: 0
          });

          await models.tbl_audit_users.create({
            //var now = new Date();
            dt: date.format(now, 'YYYY-MM-DD'),
            tm: date.format(now, 'HH:mm:ss'),
            userid: ldapRes.employeeID || ldapRes.EmpID,
            username: ldapRes.displayName || ldapRes.name,
            NewRole: 'NA',
            ACT: 'New User Added',
            KeyCode: ldapRes.employeeID || ldapRes.EmpID,
            KeyValue: ldapRes.displayName || ldapRes.name,
            Remark: 'New User Added From LDAP Server',
            NewDepartment: 'NA'
          });
  
        await models.tbl_activity_log.create({
            dt: date.format(now, 'YYYY-MM-DD'),
            tm: date.format(now, 'HH:mm:ss'),
            userid: ldapRes.employeeID || ldapRes.EmpID,
            username: "",
            activity: 'New User Added From LDAP Server' 
        });
        count = 0;
        count+=1;

        return { status: 'success',message:'User Added <br> Assign Role',count :count +' Users Added'};

        }else{
          await models.tbl_users.update({
            PwdChg: 0,
            Status: 0
          },{
            where : { userId: ldapRes.EmpID }
          });
          if(['NULL',null].includes(obj_user[0].Role)){
            return { status: 'fail',message:'Role Not Assigned <br> Contact Admin'};
          }else{
            return { status: 'success' , response: 'Authenticated'};
          }
        }
      } catch (error) {
        throw error
      }
      
    }
  
  }
  
  module.exports = LDAP;