const date = require('date-and-time');
const models = require("../dbConnection").models;
const sequelize = require("../dbConnection").sequelize;
const { Op } = require("sequelize");
const seqTransaction = require("../dbConnection");

class CubicleModel {
    async getArea() {
        try {
            let result = await models.tbl_audit_cubicle.findAll({attributes: [
                    [sequelize.fn('DISTINCT', sequelize.col('AREA')) ,'AREA']
                ]
            });
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }
    
    async getMaxStatusForBatch(objBatchProductDetail) { 
        try {
           
            if(objBatchProductDetail.str_PrdID != "NULL")
            {
                let str_query;
                if(sequelize.options.dialect === 'mssql'){
                    str_query = "SELECT * FROM tbl_batches WHERE recno = (SELECT MAX(recno) FROM tbl_batches WHERE batch='"
                    + objBatchProductDetail.str_Batch + "' and Prod_ID='" + objBatchProductDetail.str_PrdID + "' and Prod_Name='" + objBatchProductDetail.str_PrdName 
                    + "' and Prod_Version='" + objBatchProductDetail.str_PrdVersion + "' and [Version]='" + objBatchProductDetail.str_version 
                    + "' and Status <> 'I') ORDER BY CubicNo";
                }else{
                str_query = 'SELECT * FROM tbl_batches WHERE recno = (SELECT MAX(recno) FROM tbl_batches WHERE batch="'
                + objBatchProductDetail.str_Batch + '" and Prod_ID="' + objBatchProductDetail.str_PrdID + '" and Prod_Name="' + objBatchProductDetail.str_PrdName 
                + '" and Prod_Version="' + objBatchProductDetail.str_PrdVersion + '" and `Version`="' + objBatchProductDetail.str_version 
                + '" and Status <> "I") ORDER BY CubicNo';
                }
                
    
                var result = await sequelize.query(str_query);
                return result[0][0]; 
            }
            else
            {
                var result = undefined;
                return result; 
            }
        
        } catch (error) {
            console.log(error); 
            throw error;
        }
    }


    async getCubicleInfo(cubicleno = "") {
        try {
            let result = await models.tbl_cubical.findAll();
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async getAllArea() {
        try {
            let result = await models.tbl_cubicle_area.findAll();
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async getBatches() {
        try {
            let result = await models.tbl_batches.findAll();
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async checkWeighmentStatus(int_cubicleNo = "") {
        try {
            var result;
            if (int_cubicleNo == "") {
                result = await models.tbl_system_weighingstatus.findAll();
            } else {
                result = await models.tbl_system_weighingstatus.findAll({where:
                    {CubicleNo: int_cubicleNo}
                });
            }

            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async getProductSamples(value) {
        try {
            let res = await models.tbl_cubicle_product_sample.findAll({where:
                {
                    Sys_CubicNo: value.intCubicleNo
                }
            });

            return res;
        } catch (error) {
            console.log(error);
            throw error;  
        }
    }

    async chkCalibSatus(req) {
        try {
            if (req.body.str_instrumentID == "") {
                return "Invalid ID";
            } else {
                if(req.body.instType == "IPC Balance")
                {
                    //"Sys_BinBalID"
                    var result = await models.tbl_cubical.findAll({
                        attributes: ['Sys_CalibInProcess'],
                        where:{
                            Sys_BinBalID: req.body.BalId
                        }
                    });
                }else if(req.body.instType == "Vernier"){
                    //"Sys_VernierID"
                    var result = await models.tbl_cubical.findAll({
                        attributes: ['Sys_CalibInProcess'],
                        where:{
                            Sys_VernierID:req.body.BalId
                        }
                    });
                }
                else{
                    //"Sys_BalID"
                    var result = await models.tbl_cubical.findAll({
                        attributes: ['Sys_CalibInProcess'],
                        where:{
                            Sys_BalID:req.body.BalId
                        }
                    });
                }

                return result;
            }  
        } catch (error) {
            console.log(error);
            throw error;
        }
    
    }

    async checkBatchStarted(strBatch,cubicleType, Sys_BFGCode, Sys_ProductName, Sys_PVersion, Sys_Version,t) {
        try {
            let result = await models.tbl_batches.findAll({where:
                {
                    Batch: strBatch,
                    cubicleType: cubicleType,
                    Status: {[Op.ne]:"E"},
                    Prod_ID: Sys_BFGCode,
                    Prod_Name: Sys_ProductName,
                    Prod_Version: Sys_PVersion,
                    Version: Sys_Version
                },
                transaction: t
            });

            return (result.length > 0) ? result : "";
               
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async getBatchObject(objCubicle,t) {
        try {
            // let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                var now = new Date();
                /** IPQC/IPQA = I and other = N */

                var obj_create = {
                    Batch: objCubicle.Sys_Batch,
                    CubicNo: objCubicle.Sys_CubicNo,
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    cubicleType: objCubicle.Sys_CubicType,
                    Prod_ID: objCubicle.Sys_BFGCode,
                    Prod_Name: objCubicle.Sys_ProductName,
                    Prod_Version: objCubicle.Sys_PVersion,
                    Version: objCubicle.Sys_Version 
                };

                var obj_update = {
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    Prod_ID: objCubicle.Sys_BFGCode,
                    Prod_Name: objCubicle.Sys_ProductName,
                    Prod_Version: objCubicle.Sys_PVersion,
                    Version: objCubicle.Sys_Version,
                    CubicNo: objCubicle.Sys_CubicNo
                };

                var obj_updateWhere = {
                    Batch: objCubicle.Sys_Batch,
                    CubicNo: (objCubicle.str_shiftOrPausedInSame != "Shift") ? objCubicle.Sys_CubicNo : objCubicle.int_shiftCubicNo,
                    Prod_ID: objCubicle.Sys_BFGCode,
                    Prod_Name: objCubicle.Sys_ProductName,
                    Prod_Version: objCubicle.Sys_PVersion,
                    Version: objCubicle.Sys_Version
                };

                if (objCubicle.Action == "Update") 
                {
                    if(objCubicle.Sys_ProductName == "None")
                    {
                        await models.tbl_batches.destroy({where:
                            {
                                CubicNo:  objCubicle.Sys_CubicNo,
                                cubicleType: objCubicle.Sys_CubicType,
                                batchStatusInCubicle: 'Assigned'
                            },
                            transaction: t
                        });
                    }
                    else
                    {
                        if (objCubicle.str_shiftOrPausedInSame == "Shift") 
                        { 
                            Object.assign(obj_update,{Status: 'R'});
                            Object.assign(obj_updateWhere,{Status: 'P'});
                            await models.tbl_batches.update(obj_update,{where:
                                obj_updateWhere,
                                transaction: t
                            });
                        }
    
                        if (objCubicle.Sys_Batch != "NULL" && objCubicle.str_shiftOrPausedInSame != "Shift") 
                        {
                            Object.assign(obj_create,{batchStatusInCubicle: 'Assigned'},{Status: objCubicle.Status});
                            await models.tbl_batches.create(obj_create,{
                                transaction: t
                            });
                        }
                        else
                        {
                            Object.assign(obj_updateWhere,{Status: 'I'});
                            delete obj_updateWhere.Batch;
    
                            await models.tbl_batches.update({
                                Status: "E",
                                dt: date.format(now, 'YYYY-MM-DD'),
                                tm: date.format(now, 'HH:mm:ss'),
                                batchStatusInCubicle: 'NA' 
                            },{where:
                                obj_updateWhere,
                                transaction: t
                            })
                        }
                    } 
                }//update
                else if(objCubicle.Action == "Start")
                {
                    if(objCubicle.Sys_ProductName == "None")
                    {
                        await models.tbl_batches.destroy({where:
                            {
                                CubicNo:  objCubicle.Sys_CubicNo,
                                cubicleType: objCubicle.Sys_CubicType,
                                batchStatusInCubicle: 'Assigned'
                            },
                            transaction: t
                        });
                    }
                    else
                    {
                        let result = await this.checkBatchStarted(objCubicle.Sys_Batch, objCubicle.Sys_CubicType, objCubicle.Sys_BFGCode, objCubicle.Sys_ProductName, objCubicle.Sys_PVersion,objCubicle.Sys_Version,t);
                        if (result.length > 0) 
                        {
                            if (objCubicle.str_shiftOrPausedInSame == "Shift") 
                            { 
                                 Object.assign(obj_update,{Status: 'R'});
                                 delete obj_updateWhere.Batch;
                                 Object.assign(obj_updateWhere,{Status: 'P'},{Batch: result[0].Batch});
    
                                await models.tbl_batches.update(obj_update,{where:
                                    obj_updateWhere,
                                    transaction: t
                                });
                            }
                            else
                            {
                                delete obj_updateWhere.Batch;
                                Object.assign(obj_updateWhere,{Status: {[Op.ne]:"E"}},{Batch: result[0].Batch},{cubicleType: objCubicle.Sys_CubicType});
    
                                await models.tbl_batches.update({
                                    Status: "S",
                                    dt: date.format(now, 'YYYY-MM-DD'),
                                    tm: date.format(now, 'HH:mm:ss'),
                                    BatchStartDTTM: date.format(now, 'YYYY-MM-DD'),
                                    BatchEndDTTM: date.format(now, 'YYYY-MM-DD'),
                                },{where:
                                    obj_updateWhere,
                                    transaction: t 
                                });
                            }
                        }
                        else
                        {
                            Object.assign(obj_create,{batchStatusInCubicle: 'Assigned'},{Status: 'S'},{
                                BatchStartDTTM: date.format(now, 'YYYY-MM-DD'),
                                BatchEndDTTM: date.format(now, 'YYYY-MM-DD')});
    
                            await models.tbl_batches.create(obj_create,{
                                transaction: t
                            });
                        }
                    }
                   
                }//Start
                else if (objCubicle.Action == "Resume") {
                    let res = await this.checkBatchStarted(objCubicle.Sys_Batch, objCubicle.Sys_CubicType, objCubicle.Sys_BFGCode, objCubicle.Sys_ProductName, objCubicle.Sys_PVersion,objCubicle.Sys_Version,t);

                        if(res.length > 0) // if record found then set Resume 
                        {
                            Object.assign(obj_update,{batchStatusInCubicle: 'Assigned'},{Status: 'R'});
                            await models.tbl_batches.update(obj_update,{where:
                                {
                                    Batch: objCubicle.Sys_Batch,
                                    Status: "P",
                                    cubicleType: objCubicle.Sys_CubicType,
                                    CubicNo: objCubicle.Sys_CubicNo
                                },
                                transaction: t
                            });
                        }
                        else // if not found then insert record
                        {
                            Object.assign(obj_create,{batchStatusInCubicle: 'Assigned'},{Status: 'R'});
                            await models.tbl_batches.create(obj_create,{
                                transaction: t
                            })
                        }
                }//Resume
                else
                {
                    /** same cubicle and change detail then insert else update */
                    if(objCubicle.str_shiftOrPausedInSame == "PauseInSameChangeData")
                    {
                        Object.assign(obj_create,{batchStatusInCubicle: 'Paused'},{Status: 'R'});
                        await models.tbl_batches.create(obj_create,{
                            transaction: t
                        });
                    }
                    else
                    {
                        Object.assign(obj_updateWhere,{cubicleType: objCubicle.Sys_CubicType},{Status: {[Op.ne]: "E"}});
                        await models.tbl_batches.update({
                            Status:"P",
                            batchStatusInCubicle:"Paused"
                        },{where:
                            obj_updateWhere,
                            transaction: t
                        });
                    }
                }//Pause
            // });

            return "Commit";
        } catch (error) {
            console.log("Batch",error);
            throw error;
        }

    }

    async updateCubicle(objCubicle) {
        try {
            let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                var now = new Date();
                var flagBlank = 0;

                //Fetching Shift related data only at the time of shifting cubicle
                var shiftCubicalData,resultAlertShift,binShift,notPerformBinData,str_binMasterTableName,obj_cubicalData;
                if(objCubicle.str_shiftOrPausedInSame == "Shift"){
                    //transferring group alert details only if flagAlert is set
                    shiftCubicalData = await models.tbl_cubical.findAll({
                        where: { Sys_CubicNo: objCubicle.int_shiftCubicNo }
                    });
    
                    //Fetching shifted cubicle group alert data
                    resultAlertShift = await models.tbl_alert_param_duration.findAll({
                        attributes:['Group'],
                        where:{ CubicNo: objCubicle.int_shiftCubicNo}
                    });
    
                    //Fetching shifted bin data.
                    binShift = await models.tbl_cubicle_bin_setting.findAll({
                        where:{ Sys_CubicNo: objCubicle.int_shiftCubicNo}
                    });

                    str_binMasterTableName = (shiftCubicalData[0].Sys_CubType == "Compression") ? "tbl_bin_master_comp" :  (shiftCubicalData[0].Sys_CubicType == "IPC") ? "tbl_bin_master_ipc" : (["Coating"].includes(shiftCubicalData[0].Sys_CubicType)) ? "tbl_bin_master_coat" :(shiftCubicalData[0].Sys_CubicType == "Granulation")  ? "tbl_bin_master_gran" : "tbl_bin_master_cap";
                    
                    //Shifting not performed BINS
                    notPerformBinData = await models[str_binMasterTableName].findAll({
                        where: {
                            Bin_ProductID: binShift[0].Sys_PrdID,
                            Bin_ProductName: binShift[0].Sys_PrdName,
                            Bin_ProductVersion: binShift[0].Sys_PrdVersion,
                            Bin_Version: binShift[0].Sys_Version,
                            Bin_BatchNo: binShift[0].Sys_BatchNo,
                            Bin_BatchComplete:0,
                            Bin_Status: {[Op.ne]:1}
                        }
                    });

                    //fetching cubical data where is batch is shifting (TO get IDSNo)

                    obj_cubicalData = await models.tbl_cubical.findAll({
                        where: { Sys_CubicNo: objCubicle.Sys_CubicNo }
                    })
                }

                /** update parent and child cubicle */
                await models.tbl_cubical.update({
                        Sys_Validation: objCubicle.Sys_Validation,
                        Sys_RptType: objCubicle.Sys_RptType,
                        Sys_RotaryType: objCubicle.Sys_RotaryType,
                        Sys_dept: objCubicle.Sys_dept,
                        Sys_IPQCType: objCubicle.Sys_IPQCType,
                        Sys_BFGCode: objCubicle.Sys_BFGCode,
                        Sys_ProductName: objCubicle.Sys_ProductName,
                        Sys_Version: objCubicle.Sys_Version,
                        Sys_PVersion: objCubicle.Sys_PVersion,
                        Sys_Batch: objCubicle.Sys_Batch,
                        Sys_BatchSize: objCubicle.Sys_BatchSize,
                        Sys_BatchSizeUnit: objCubicle.Sys_BatchSizeUnit,
                        Sys_Stage: objCubicle.Sys_Stage,
                        Sys_media: objCubicle.Sys_media,
                        Sys_PrinterName: objCubicle.Sys_PrinterName,
                        Sys_CubType: objCubicle.Sys_CubicType,
                        Sys_BatchReuse: objCubicle.int_batchReuseForDb,
                        Sys_MachineSpeed_Min: objCubicle.Sys_Machine_Min,
                        Sys_Batch_Status: objCubicle.Sys_Batch_Status,
                        Sys_MachineSpeed_Max: objCubicle.Sys_Machine_Max
                },{
                    where: { Sys_CubicNo: objCubicle.Sys_CubicNo },
                    transaction: t
                });

                /** update parent and child cubicle */
                await models.tbl_alert_param_duration.update({
                    ProductId: objCubicle.Sys_BFGCode,
                    ProductName: objCubicle.Sys_ProductName,
                    ProductVersion: objCubicle.Sys_PVersion,
                    Version: objCubicle.Sys_Version,
                    Batch: objCubicle.Sys_Batch
                },{where:
                    {
                        CubicNo: objCubicle.Sys_CubicNo
                    },
                    transaction: t
                });

                await models.tbl_audit_cubicle.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: objCubicle.userid,
                    username: objCubicle.username,
                    ACT: objCubicle.Action,
                    Remark: objCubicle.Remark,
                    CubicleNo: objCubicle.Sys_CubicNo,
                    OldData: objCubicle.OldData,
                    NewData: objCubicle.NewData,
                    Area: objCubicle.Sys_Area,
                    CubName: objCubicle.Sys_CubicName,
                },{
                    transaction: t
                });

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: objCubicle.userid,
                    username: objCubicle.username,
                    activity: objCubicle.activity
                },{
                    transaction: t
                });

                if (objCubicle.str_shiftOrPausedInSame == "Shift" && (objCubicle.Sys_CubicNo != objCubicle.int_shiftCubicNo)) {
                    /** Resetting shifted cubicle to NULL */
                    await models.tbl_cubical.update({
                            Sys_BFGCode: "NULL",
                            Sys_ProductName: "NULL",
                            Sys_Version: "NA",
                            Sys_PVersion: "NA",
                            Sys_media: "NA",
                            Sys_Batch: "NULL",
                            Sys_Stage: "NA",
                            Layer:'NULL',
                            Sys_BatchSize: 0,
                            Sys_BatchSizeUnit: "Unit",
                            Sys_dept: "NA",
                            Sys_IPQCType: "NA",
                            Sys_Validation: 0,
                            Sys_RptType: 0,
                            Sys_RotaryType: 'Single',
                            Sys_PrinterName: 'NA',
                            Sys_BatchReuse: 0,
                            Sys_MachineSpeed_Min:'NULL',
                            Sys_MachineSpeed_Max:'NULL'
                        },{
                            where: { Sys_CubicNo: objCubicle.int_shiftCubicNo },
                            transaction: t
                        });


                    // fetching sample record
                    // var cubical_sample = await models.tbl_cubicle_product_sample.findAll({
                    //     where:{ Sys_CubicNo: objCubicle.Sys_CubicNo }
                    // })

                     /** update parent and child cubicle */
                     await models.tbl_cubicle_product_sample.update({
                        Individual:  0,
                        Group: 0,
                        Hardness: 0,
                        Sys_BFGCode: "NULL",
                        Sys_ProductName: "NULL",
                        Sys_Version: "NA",
                        Sys_Batch : 'NULL',
                        Sys_PVersion: "NA"
                    },{
                        where: { Sys_CubicNo: objCubicle.int_shiftCubicNo },
                        transaction: t
                    });

                    if(shiftCubicalData[0].Sys_flagAlert == 1){
                        //Passing it to the shifting cubicle
                        await models.tbl_alert_param_duration.update({
                            Group:resultAlertShift[0]['Group']
                        },{
                            where: { CubicNo:  objCubicle.Sys_CubicNo },
                            transaction:t
                        })

                        //Resetting the previous cubicle alert setting
                        await models.tbl_alert_param_duration.update({
                            Batch: 'NULL',
                            ProductId: 'NULL',
                            ProductName: 'NULL',
                            ProductVersion: 'NULL',
                            Version: 'NULL',
                            Group: 0 
                        },{
                            where: { CubicNo:  objCubicle.int_shiftCubicNo },
                            transaction:t
                        })

                        //setting the alert flag
                        await models.tbl_cubical.update({
                            Sys_flagAlert:1
                        },{
                            where: { Sys_CubicNo: objCubicle.Sys_CubicNo},
                            transaction:t
                        })   
                    }
                    
                    
                }

                /** if batch different and product none set then record will be removed from Bin Setting
                 * When cubical is shifted back to it own cubical that is A -> B than B -> A it causing issue setting null value of in tbl bin list
                 */
                (objCubicle.Sys_ProductName == "None") ? flagBlank = 1 : (objCubicle.Sys_Batch != objCubicle.str_oldBatch || objCubicle.bln_changePrd) ? flagBlank = 1 : flagBlank = 0;
                if(flagBlank == 1 && objCubicle.str_shiftOrPausedInSame != "Shift")
                {
                    /** update parent and child cubicle */
                    await models.tbl_cubicle_bin_setting.update({
                        Sys_TotalBinSelected: 0 ,
                        Sys_BinID: null,
                        Sys_Lot: "NULL",
                        Sys_Printer: "NULL",
                        Layer:"NULL",
                        Sys_MfgDate: null,
                        Sys_ExpDate: null,
                        Sys_InitialStage: "NULL",
                        Sys_NextStage: "NULL",
                        Sys_LabelHeader: "NULL",
                        Sys_TotalBin: 0,
                        Sys_DateNA: 0 ,
                        Sys_BatchNo:objCubicle.Sys_Batch
                    },{
                        where: {
                            Sys_Area: objCubicle.Sys_Area,
                            Sys_CubicName: objCubicle.Sys_CubicName
                        },
                        transaction: t
                    });
                    
                    for(let str_tableName of ["tbl_bin_master_comp","tbl_bin_master_coat","tbl_bin_master_cap","tbl_bin_master_gran"]){
                        //for main table
                        await models[str_tableName].update({
                            Bin_BatchComplete:1
                        },{
                            where:{ 
                                [Op.or]:[
                                    { Bin_ShiftCubic: objCubicle.Sys_CubicNo },
                                    { Bin_CubicleNo: objCubicle.Sys_CubicNo }
                                    ],
                                    Bin_Status: 1
                                },
                            transaction: t
                        });

                        await models[str_tableName].destroy({
                            where:{
                                Bin_CubicleNo: objCubicle.Sys_CubicNo,
                                Bin_Status: 0
                            },
                            transaction: t
                        });

                    }
    
                    await models.tbl_bin_list.update({
                        cubicleType: "NULL",
                        BatchNo: "NULL",
                        binStatus: 2,
                        CubicleNo: 0,
                        Bin_CubicNo:0 //cubical number of cubical who set the bin
                    },{
                        where: { CubicleNo: objCubicle.Sys_CubicNo },
                        transaction: t
                    });
                }

                if(objCubicle.Sys_ProductName == "None")
                {
                    await models.tbl_cubical.update({
                        Sys_IPQCType: "NA"
                    }, {
                        where:
                        {
                            Sys_CubicNo: objCubicle.Sys_CubicNo
                        },
                        transaction: t
                    });


                    //Clearing product sample if none product is set
                    await models.tbl_cubicle_product_sample.update({
                        Sys_BFGCode:'NULL',
                        Sys_ProductName:'NULL',
                        Sys_Batch :'NULL',
                        Sys_PVersion:'NA',
                        Sys_Version:'NA',
                        Individual: 0,
                        Group: 0,
                        Hardness: 0,
                        DT:0,
                        Friability:0
                    },{where:
                        {
                            Sys_CubicNo: objCubicle.Sys_CubicNo
                        },
                        transaction: t
                    });
                }

                /** in IPQC if product change then set batchcomplete flag to 1 for parameters */
                var cnt = ["IPQC","IPQA","Granulation"].includes(objCubicle.Sys_CubicType) ? 1 : 0;
                if(objCubicle.Sys_Batch != objCubicle.str_oldBatch) // if batch change
                {
                    if(cnt == 1)
                    {
                        for (const i of [1,2,3,4,5,6,7,8,9,10,11,12,13,"htd","app"]) {
                            if([7,"htd"].includes(i)) //hardness
                            {

                                await models.tbl_tab_masterhtd.update({
                                    BatchComplete: 1
                                },{
                                    where: {
                                        BatchNo:objCubicle.str_oldBatch,
                                        //CubicleType: objCubicle.Sys_CubicType
                                    },
                                    transaction: t
                                }); 

                                await models.tbl_batchsummary_masterhtd.update({
                                    BatchCompleted: 1
                                },{
                                    where: {
                                        BatchNo:objCubicle.str_oldBatch,
                                        BatchCompleted: 0
                                    },
                                    transaction: t
                                });
                            }
                            else if(i == 8) //friability
                            {
                                await models.tbl_tab_friability.update({
                                    BatchComplete: 1
                                },{
                                    where:{
                                        BatchNo:objCubicle.str_oldBatch,
                                        //CubicleType: objCubicle.Sys_CubicType
                                    },
                                    transaction: t
                                });

                                await models.tbl_batchsummary_master8.update({
                                    BatchCompleted: 1
                                },{
                                    where:{
                                        BatchNo:objCubicle.str_oldBatch,
                                        BatchCompleted: 0
                                    },
                                    transaction: t
                                });
                            }
                            else
                            {

                                var tableName = 'tbl_tab_master' + i;
                                var tableName_summary = 'tbl_batchsummary_master' + i;

                                if(models[tableName] != undefined){
                                    await models[tableName].update({
                                        BatchComplete: 1
                                    },{
                                        where:{
                                            BatchNo:objCubicle.str_oldBatch,
                                            // CubicleType: objCubicle.Sys_CubicType
                                        },
                                        transaction: t
                                    });
                                }

                                if(models[tableName_summary] != undefined){
                                    await models[tableName_summary].update({
                                        BatchCompleted: 1
                                    },{
                                        where: {
                                            BatchNo:objCubicle.str_oldBatch,
                                            BatchCompleted: 0
                                        },
                                        transaction: t
                                    });
                                }
                            }
                        }
                    }
                }

                /** If batch is shifted than shift the IPC detail of cubical whose IPC setting is done */
                if(objCubicle.str_shiftOrPausedInSame == "Shift" && shiftCubicalData[0].Sys_CubicType != 'NULL'){ 

                    let arr_strBinId = binShift[0].Sys_BinID.split(',');
                    let arr_strNotDoneBinId = notPerformBinData.map( e =>  e.Bin_BinID );

                    //Past Cubical
                    let arr_newBinIdForShiftedCubical = arr_strBinId.filter( e => !arr_strNotDoneBinId.includes(e));

                    //updating data to the new Cubical
                    await models.tbl_cubicle_bin_setting.update({
                        Sys_Area: objCubicle.Sys_Area,
                        // Sys_CubicName: objCubicle.Sys_CubicName,
                        // Sys_CubicleType: objCubicle.Sys_CubicType,
                        Sys_LabelHeader: binShift[0].Sys_LabelHeader,
                        Sys_MfgDate: binShift[0].Sys_MfgDate,
                        Sys_ExpDate: binShift[0].Sys_ExpDate,
                        Sys_BeforeDate: binShift[0].Sys_BeforeDate,
                        Sys_InitialStage: binShift[0].Sys_InitialStage,
                        Sys_NextStage: binShift[0].Sys_NextStage,
                        Sys_Printer: binShift[0].Sys_Printer,
                        Sys_PrdID: objCubicle.Sys_BFGCode,
                        Sys_PrdName: objCubicle.Sys_ProductName,
                        Sys_Version: objCubicle.Sys_Version,
                        Sys_PrdVersion: objCubicle.Sys_PVersion,
                        Sys_BatchNo: objCubicle.Sys_Batch,
                        Sys_TotalBin: binShift[0].Sys_TotalBin,
                        Sys_Lot:binShift[0].Sys_Lot,
                        Layer: binShift[0].Layer,
                        Sys_TotalBinSelected: arr_strNotDoneBinId.length,
                        Sys_BinID: arr_strNotDoneBinId.join(',')                
                    },{
                        where:{ Sys_CubicNo : objCubicle.Sys_CubicNo},
                        transaction:t
                    });

                    //updating the shifted bin data

                    let updateForShiftedCubical = {
                        Sys_TotalBinSelected: arr_newBinIdForShiftedCubical.length,
                        Sys_BinID: arr_newBinIdForShiftedCubical.join(',')    ,
                    };

                    if(arr_newBinIdForShiftedCubical.length == 0){
                        //If all the assigned bin is getting transfer clear the total bin of shifted cubical else no
                        Object.assign(updateForShiftedCubical,{Sys_TotalBin:0});
                    }

                    await models.tbl_cubicle_bin_setting.update(updateForShiftedCubical,{
                        where:{ Sys_CubicNo : objCubicle.int_shiftCubicNo},
                        transaction:t
                    });

                    //Enterering reference to update in all the cubicle whose batch is not completed which having shifted cubic No. as 
                    //With the help of Bin_ShiftCubic Number we will update the batchcomplete flag for the Bin whose grosss weitht is done
                    await models[str_binMasterTableName].update({
                        Bin_ShiftCubic: objCubicle.Sys_CubicNo,
                        Bin_TotalSelected: arr_newBinIdForShiftedCubical.length
                    },{
                        where: {
                            [Op.or]:[
                                {
                                    [Op.and]: {
                                        Bin_ShiftCubic: objCubicle.int_shiftCubicNo,
                                        Bin_BatchComplete: 0,
                                    }
                                },{
                                    [Op.and]:{
                                        Bin_ProductID: binShift[0].Sys_PrdID,
                                        Bin_ProductName: binShift[0].Sys_PrdName,
                                        Bin_ProductVersion: binShift[0].Sys_PrdVersion,
                                        Bin_Version: binShift[0].Sys_Version,
                                        Bin_BatchNo: binShift[0].Sys_BatchNo,
                                        Bin_CubicleNo:binShift[0].Sys_CubicNo,
                                        Bin_BatchComplete: 0,
                                        Bin_Status: 1
                                    }
                                }
                            ]   
                        },
                        transaction:t
                    });


                    //updating not completed bin to new 
                    if(arr_strNotDoneBinId.length > 0){
                        //updating table only when not done bin is present for new cubical
                        await models[str_binMasterTableName].update({
                            Bin_CubicName:objCubicle.Sys_CubicName,
                            Bin_CubicleNo: objCubicle.Sys_CubicNo,
                            Bin_IDSNo: obj_cubicalData[0].Sys_IDSNo,
                            Bin_TotalSelected: arr_strNotDoneBinId.length
                        },{
                            where:{
                                Bin_ProductID: binShift[0].Sys_PrdID,
                                Bin_ProductName: binShift[0].Sys_PrdName,
                                Bin_ProductVersion: binShift[0].Sys_PrdVersion,
                                Bin_Version: binShift[0].Sys_Version,
                                Bin_BatchNo: binShift[0].Sys_BatchNo,
                                Bin_CubicleNo:binShift[0].Sys_CubicNo,
                                Bin_BatchComplete: 0,
                                Bin_Status: 0
                            },
                            transaction:t
                        })

                        //Updating not done Bin data
                        await models.tbl_bin_list.update({
                            CubicleNo: objCubicle.Sys_CubicNo,
                            Bin_CubicNo:objCubicle.Sys_CubicNo,
                        },{
                            where: { 
                                CubicleNo: binShift[0].Sys_CubicNo,
                                binID:{ [Op.in]: arr_strNotDoneBinId }
                            },
                            transaction:t
                        });

                        // setting new value cubical value to  Bin_CubicNo 
                        await models.tbl_bin_list.update({
                            // CubicleNo: 0,
                            // cubicleType: 'NULL',
                            // BatchNo: 'NULL',
                            // binStatus: 1,
                            Bin_CubicNo: objCubicle.Sys_CubicNo
                        },{
                            where: { 
                                [Op.or]:[
                                {
                                    [Op.and]:{
                                        CubicleNo: objCubicle.int_shiftCubicNo,
                                        binID:{ [Op.in]: arr_newBinIdForShiftedCubical },
                                    }
                                },
                                {  Bin_CubicNo: objCubicle.int_shiftCubicNo }
                            ],
                            },
                            transaction:t
                        })
                    }

                    var newdatasbin;
                    //Updating audit trail for bin
                    if(binShift[0].Layer === null){
                        newdatasbin = 'NA'
                    }else{
                        newdatasbin =  `Total Selected: ${arr_strNotDoneBinId.length},Total: ${binShift[0].Sys_TotalBin},`+
                        `IPC: ${arr_strNotDoneBinId.length == 0 ? '0' : arr_strNotDoneBinId.join(',')},Use Before Date: ${binShift[0].Sys_ExpDate},`+
                        `Layer: ${binShift[0].Layer},Lot: ${binShift[0].Sys_Lot},Product Detail: ${binShift[0].Sys_PrdID},${binShift[0].Sys_PrdName},${binShift[0].Sys_PrdVersion},${binShift[0].Sys_Version},`+
                        `Batch: ${binShift[0].Sys_BatchNo},Stage: ${binShift[0].Sys_InitialStage},Next Stage: ${binShift[0].Sys_NextStage},`+
                        `Label Header: ${binShift[0].Sys_LabelHeader}`;
                    }

                    await models.tbl_audit_bin_setting.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: objCubicle.userid,
                        username: objCubicle.username,
                        ACT: "Update",
                        Remark:( objCubicle.Sys_CubicName === 'NULL' || shiftCubicalData[0].Sys_CubicName === 'NULL' ?  'Data shifted' : `Data shifted From ${shiftCubicalData[0].Sys_CubicName} cubical to ${objCubicle.Sys_CubicName} cubical`),
                        CubicleNo: objCubicle.Sys_CubicNo,
                        OldData: "NA",
                        NewData: newdatasbin,
                        Area: objCubicle.Sys_Area,
                        CubName: objCubicle.Sys_CubicName,
                    },{
                        transaction:t
                    })
                }
             
                await this.getBatchObject(objCubicle,t); // update batch table
             
            });

            return "Update";
        } catch (error) {
            console.log("Update Cubicle",error);
            throw error;
        }
    }

    /**
     * This function will change the batch completed status in every weighment table 
     * for Only `Tablets` and only for those record whose `batchno` is matched
     * @param {*} objBatch Batch no for which `Batch completed` needs to be changed
     * @returns Promise Whether transaction is commited or not
     * @memberof CubicleModel
     */
    async changeBatchStatusForWgmtTabCap(objBatch,t) {
        try {
            // let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                 /** Tablet */
                for (const i of [1,2,3,4,5,6,7,9,10,11,12,13,"htd","app"]) {
                    // for (const i of [1,2,"htd"]) {
                    if(i == "htd")
                    {
                        await models.tbl_tab_masterhtd.update({
                            BatchComplete: 1
                        },{where:
                            {  
                                BatchNo: objBatch.Batch,
                                CubicleType: objBatch.Sys_CubicType
                            },
                            transaction: t
                        });
                    }
                    else
                    {
                        await models['tbl_tab_master'+i].update({
                            BatchComplete: 1
                        },{where:
                            {  
                                BatchNo: objBatch.Batch,
                                CubicleType: objBatch.Sys_CubicType
                            },
                            transaction: t
                        });
                    }
                   
                }

                /**Capsule */
                // for (const i of [1,2,3,4,5,6,9]) {
                //         await models['tbl_cap_master'+i].update({
                //             BatchComplete: true
                //         },{where:
                //             {  
                //                 BatchNo: objBatch.Batch,
                //                 CubicleType: objBatch.Sys_CubicType
                //             }
                //         },{
                //             transaction: t
                //         });
                // }
            // });

            return "Commit";
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    /**
     * Change Batch Complete to all batch summery tables 
     * `BatchSummery1 to 16`
     * @param {*} strBatch Batch Name for which batch summery needs to be change 
     * @returns Promise When all queries execued successfully.
     * @memberof CubicleModel
     */
    async changeBatchStatusForBatchSummery(strBatch,t) {
        try {
            // let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                // for (const i of [1,"hdlb"]) {
                for (const i of [1,2,3,4,5,6,7,8,9,10,11,12,13,"htd"]) {
                    if(i == "diff")
                    {
                        await models.tbl_batchsummary_masterdiff.update({
                            BatchCompleted: 1
                        },{
                            where:{ BatchNo: strBatch.Batch },
                            transaction: t
                        });
                    }
                    else if(i == "hdlb")
                    {
                        await models.tbl_batchsummary_master_hdlb.update({
                            BatchCompleted: 1
                        },{
                            where:{ BatchNo: strBatch.Batch },
                            transaction: t
                        });
                    }
                    else
                    {
                        await models['tbl_batchsummary_master'+i].update({
                            BatchCompleted: 1
                        },{
                            where: { BatchNo: strBatch.Batch },
                            transaction: t
                        });
                    }
                    
                }
            // });
            
           return "Commit"; 
        } catch (error) {
            console.log("error",error);
            throw error;
        }
    }

    /**
     * This function will Make audit entries and change the batch status in tables 
     * @param {*} objBatchInfo Object which is recived by Angular 
     * @returns return a transaction commited or not commited status.
     * @memberof CubicleModel
     */
    async endBatchOtherTables(objBatchInfo,t) {
        try {
            // let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                var now = new Date();
                await models.tbl_batches.update({
                    Status:  "E",
                    batchStatusInCubicle:  'NA',
                    BatchEndDTTM:  date.format(now, 'YYYY-MM-DD HH:mm:ss')
                },{where:
                    {
                        Status: {[Op.ne]:"E"},
                        Batch: objBatchInfo.Batch,
                        CubicNo: objBatchInfo.Sys_CubicNo,
                        cubicleType: objBatchInfo.Sys_CubicType,
                        Prod_ID: objBatchInfo.Sys_BFGCode,
                        Prod_Name: objBatchInfo.Sys_ProductName,
                        Prod_Version: objBatchInfo.Sys_PVersion,
                        Version: objBatchInfo.Sys_Version
                    },
                    transaction: t
                });

                // update parent and child cubicle
                await models.tbl_cubical.update({
                        Sys_RptType: 0,
                        Sys_RotaryType: "Single",
                        Sys_BFGCode: "NULL",
                        Sys_ProductName: "NULL",
                        Sys_Version: "NA",
                        Sys_PVersion: "NA",
                        Sys_media: "NA",
                        Sys_Batch: "NULL",
                        Sys_Stage: "NA",
                        Sys_BatchSize: 0,
                        Sys_BatchSizeUnit: "Unit",
                        Sys_dept: "NA",
                        Sys_IPQCType: "NA",
                        Sys_PrinterName: "NA",
                        Sys_Validation: 0,
                        Sys_BatchReuse: 0,
                        Sys_MachineSpeed_Min:'NULL',
                        Sys_MachineSpeed_Max:'NULL'
                },{where:
                    {
                        // Sys_CubicName: objBatchInfo.Sys_CubicName,
                        // Sys_Area: objBatchInfo.Sys_Area,
                        // Sys_CubType: objBatchInfo.Sys_CubicType
                        Sys_CubicNo: objBatchInfo.Sys_CubicNo
                    },
                    transaction: t
                });

                 // update parent and child cubicle
                 await models.tbl_alert_param_duration.update({
                    ProductId: 'NULL',
                    ProductName: 'NULL',
                    ProductVersion: 'NA',
                    Version: 'NA',
                    Batch: 'NULL',
                    Individual:0,
                    Group:0,
                    Thickness:0,
                    Breadth:0,
                    Diameter:0,
                    Length:0,
                    Hardness:0,
                    IndLay:0,
                    GrpLay:0,
                    IndLay1:0,
                    GrpLay1:0,
                    Differential:0
                    },{where:
                        {
                            // Sys_CubicName: objBatchInfo.Sys_CubicName,
                            // Sys_Area: objBatchInfo.Sys_Area
                            CubicNo: objBatchInfo.Sys_CubicNo
                        },
                        transaction: t
                    });

                     // update parent and child cubicle
                 await models.tbl_cubicle_product_sample.update({
                        Sys_BFGCode:'NULL',
                        Sys_ProductName:'NULL',
                        Sys_PVersion:'NA',
                        Sys_Version:'NA',
                        Sys_Batch : 'NULL',
                        Individual: 0,
                        Group: 0,
                        Hardness: 0,
                        DT:0,
                        Friability:0
                    },{where:
                        {
                            // Sys_CubicName: objBatchInfo.Sys_CubicName,
                            // Sys_Area: objBatchInfo.Sys_Area
                            Sys_CubicNo: objBatchInfo.Sys_CubicNo
                        },
                        transaction: t
                    });


                    await models.tbl_audit_cubicle.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: objBatchInfo.userid,
                        username: objBatchInfo.username,
                        ACT: objBatchInfo.Action,
                        Remark: objBatchInfo.Remark,
                        CubicleNo: objBatchInfo.Sys_CubicNo,
                        OldData: objBatchInfo.str_oldData,
                        NewData: "NA",
                        CubName: objBatchInfo.Sys_CubicName,
                        Area: objBatchInfo.Sys_Area
                    },{
                        transaction: t
                    });

                    await models.tbl_activity_log.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: objBatchInfo.userid,
                        username: objBatchInfo.username,
                        activity: objBatchInfo.activity
                    },{
                        transaction: t
                    });

            // });

            return "Commit";
        } catch (error) {
            console.log("error",error);
            throw error;
        }
    }

    /**
     * This function will Make audit entries and change to bin related tables 
     * @param {*} objBatchInfo Object which is recived by Angular 
     * @param {*} t transaction object
     * @returns 
     */
    async endBatchBinEntries(objBatchInfo,t) {
        try {

            var str_tableName = "",str_tableNameArchived = "";
            switch(objBatchInfo.Sys_CubicType){
                case "Compression":
                    str_tableName = "tbl_bin_master_comp";
                    str_tableNameArchived = "tbl_bin_master_comp_archived";
                    break;
                case "Coating":
                    str_tableName = "tbl_bin_master_coat";
                    str_tableNameArchived = "tbl_bin_master_coat_archived";
                    break;
                case "Capsule Filling":
                case "MIC":
                    str_tableName = "tbl_bin_master_cap";
                    str_tableNameArchived = "tbl_bin_master_cap_archived";
                    break;
                case "Granulation":
                    str_tableName = "tbl_bin_master_gran";
                    str_tableNameArchived = "tbl_bin_master_gran_archived";
                    break;
                default:
                    throw ("Cubicle Not Define");
            }
    

            //end the batch for both shifted bin also
            await models[str_tableName].update({
                Bin_BatchComplete : 1,
                Bin_ShiftCubic:0
            },{
                where: { 
                    [Op.or] : [
                        { Bin_CubicleNo: objBatchInfo.Sys_CubicNo},
                        {
                            [Op.and]:{ 
                                Bin_ShiftCubic: objBatchInfo.Sys_CubicNo,
                                Bin_BatchComplete: 0 
                            } 
                        }
                    ]
                   
                },
                transaction:t
            });

            //updating for all the bin whose bin cubicle no is current cubical number and whose shifted cubic bin no and batch complete is not equal to 1 
            await models[str_tableNameArchived].update({
                Bin_BatchComplete : 1,
                Bin_ShiftCubic:0
            },{
                where: { 
                    [Op.or] : [
                        { Bin_CubicleNo: objBatchInfo.Sys_CubicNo},
                        {
                            [Op.and]:{ 
                                Bin_ShiftCubic: objBatchInfo.Sys_CubicNo,
                                Bin_BatchComplete: 0 
                            }
                        }
                    ]
                },
                transaction:t
            });

            await models.tbl_cubicle_bin_setting.update({
                Sys_TotalBinSelected: 0 ,
                Sys_BinID: null,
                Sys_Lot: "NULL",
                Sys_Printer: "NULL",
                Sys_MfgDate: null,
                Sys_ExpDate: null,
                Sys_InitialStage: "NULL",
                Sys_NextStage: "NULL",
                Sys_LabelHeader: "NULL",
                Layer:'NULL',
                Sys_TotalBin: 0,
                Sys_DateNA: 0 ,
                Sys_PrdID: objBatchInfo.Sys_BFGCode,
                Sys_PrdName: objBatchInfo.Sys_ProductName,
                Sys_PrdVersion: objBatchInfo.Sys_PVersion,
                Sys_Version: objBatchInfo.Sys_Version,
                Sys_BatchNo:objBatchInfo.Sys_Batch
            },{
                where: {
                    Sys_CubicNo: objBatchInfo.Sys_CubicNo,
                },
                transaction: t
            });

            await models.tbl_bin_list.update({
                CubicleNo: 0,
                cubicleType: 'NULL',
                BatchNo: 'NULL',
                binStatus: 1,
                Bin_CubicNo: 0
            },{
                where: {
                    [Op.or]:[
                        { Bin_CubicNo: objBatchInfo.Sys_CubicNo },{
                        [Op.and]:{
                                BatchNo: objBatchInfo.Batch,
                                cubicleType: objBatchInfo.Sys_CubicType,
                                CubicleNo: objBatchInfo.Sys_CubicNo,
                                IsDiscarded: 0
                            }
                        }
                    ]
                },
                transaction:t
            });

            return "Commit";

        } catch (error) {
            console.log("Bin End",error);
            throw error;
        }
    }

    /**
     * For Ending Batch
     * @Table {`endBatchWithAuditEntries`} Make cubicle entry and audit entries 
     * @Table {`changeBatchStatusForWgmtTab`} Set Batch Completed to True for all Tablet report for that batch
     * @Table {`changeBatchStatusForWgmtCap`} Set Batch Completed to True for all Capsule report for that batch
     * @Table {`changeBatchStatusForBatchSummery`} set Batch Completed to True for all Batch Summery Report.
     * @param {*} objBatchInfo
     * @returns
     * @memberof CubicleModel
     */
    async endBatch(objBatchInfo) {
        try {
            let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                var resEnd = await this.endBatchOtherTables(objBatchInfo,t);
                var resBinUpdate = await this.endBatchBinEntries(objBatchInfo,t);
                var resFlag_TabletCapsule = await this.changeBatchStatusForWgmtTabCap(objBatchInfo,t);
                var resFlag_Summary = await this.changeBatchStatusForBatchSummery(objBatchInfo,t);

                if (resEnd == "Commit" && resFlag_TabletCapsule == "Commit" && resFlag_Summary == "Commit" && resBinUpdate == 'Commit') {
                    return "Batch End Successfully";
                }else{
                    return "Something went Wrong";
                }
            });

            return transaction;
        } catch (error) {
            console.log("Cubicle End",error);
            throw error;
        }
    }

    async getProductDetailIndNGrp(objProduct) {
        try {
            let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
            var strTableName = (objProduct.cubType == "Coating") ? "tbl_product_tablet_coated" : 
            (objProduct.cubType == "Capsule Filling") ? "tbl_product_capsule" : "tbl_product_tablet";
     
            let res = await models[strTableName].findAll({where:
                 {
                     ProductId: objProduct.prdId,
                     ProductName: objProduct.prdName,
                     ProductVersion: objProduct.prdVersion,
                     Version: objProduct.version
                 },
                 transaction: t
             });
     
             return res[0];
            })
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async getCubicleTypeFromArea(objCubicArea) {
        try {
            let result = await models.tbl_area_cubicletype.findAll({where:
                {Area: objCubicArea.strAreaName}
            });
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }


    async getDataOnSelectionOfCubicle(obj) {
        try {
            let obj_response = {};
            var cnt = 0;
            let res = await models.tbl_cubical.findAll({
                attributes:['Sys_Port1','Sys_Port2','Sys_Port3','Sys_Port4','Sys_IDSNo'],
                where:
                {Sys_CubicNo: obj.intCubicNo}
            });
            if(res[0].Sys_Port1 == "None") 
            {
                cnt = cnt + 1;
            }
            if(res[0].Sys_Port2 == "None") 
            {
                cnt = cnt + 1;
            }
            if(res[0].Sys_Port3 == "None") 
            {
                cnt = cnt + 1;
            }
            if(res[0].Sys_Port4 == "None") 
            {
                cnt = cnt + 1;
            }
            Object.assign(obj_response,{cnt:cnt,IDS:res[0].Sys_IDSNo});
            return obj_response;
        } catch (error) {
            console.log(error);
            throw error
        }
    }

    async getProductTypeFromDatabase(obj) { // get the area from tbl_area_cubicletype table
        try {
            let res = await models.tbl_area_cubicletype.findAll({
                attributes:[
                    [sequelize.fn('DISTINCT', sequelize.col('CubType'))],
                ],
                where:
                {
                    Area:obj.Area,
                    CubType:{[Op.ne]:'IPC'},
                    CubType:{[Op.ne]:'IPQC'}
                }
            });
            
            return res;
        } catch (error) {
            console.log(error);
            throw error;
        }

    }

    async getProductUnit(obj)
    {
        try {
            var res = await models.tbl_product_capsule.findAll({where:
                {
                    ProductId: obj.str_prdID,
                    ProductName: obj.str_prdName,
                    ProductVersion: obj.str_prdVersion,
                    Version: obj.str_version
                }
            });

            return res;
        } catch (error) {
            console.log(error);
            throw error;
        }

    }

    async saveSample(obj) { 
        try {
            var transactionRep = await seqTransaction.sequelize.transaction( async (t) => {
                await models.tbl_cubicle_product_sample.update({
                    Individual: obj.Individual,
                    Group: obj.Group,
                    Friability:obj.Friability,
                    DT:obj.DT,
                    Hardness: obj.Hardness,
                    Thickness:obj.Dim,
                    Breadth:obj.Dim,
                    Diameter:obj.Dim,
                    Length:obj.Dim,
                    Sys_BFGCode: obj.Sys_BFGCode,
                    Sys_ProductName: obj.Sys_ProductName,
                    Sys_Version: obj.Sys_Version,
                    Sys_PVersion: obj.Sys_PVersion,
                    Sys_Batch: obj.Sys_Batch
                },{
                    where: { Sys_CubicNo: obj.Sys_CubicNo },
                    transaction: t
                });

                var now = new Date();
            
                await models.tbl_audit_cubicle.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: obj.userid ,
                    username: obj.username ,
                    ACT: "Set Sample",
                    Remark: obj.Remark ,
                    OldData: obj.OldData ,
                    NewData: obj.NewData ,
                    Area: obj.Area ,
                    CubName: obj.Sys_CubicName
                },{
                    transaction:t
                })

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: obj.userid,
                    username: obj.username,
                    activity: obj.activity
                },{
                    transaction: t
                });

                let obj_res = {};
                Object.assign(obj_res,{result:"success"});
                return obj_res;
            })

            return transactionRep;            
        } catch (error) {
            console.log("error",error);
            throw error;
        }

    }

    async getSampleFromProductCubicle(obj) { 
        try {
        const obj_res = {};
        
        let res = await models.tbl_cubicle_product_sample.findAll({
            where:{
                Sys_CubicNo: obj.int_cubicle,
                Sys_BFGCode:obj.Sys_BFGCode,
                Sys_ProductName:obj.Sys_ProductName,
                Sys_Version:obj.Sys_Version,
                Sys_PVersion:obj.Sys_PVersion,
                Sys_Batch:obj.Sys_Batch
            }
        });
        
       if(res.length == 0)
       {
        Object.assign(obj_res,{"str":"Not Done","data":res[0]});
       }  
       else{
        Object.assign(obj_res,{"str":"Done","data":res[0]});
       }

       return obj_res;
    } catch (error) {
        console.log("error",error);
        throw error;
    }
       
    }

    async batchForCubical(obj) { 
        try {
            let obj_res = {};
            let res;


            //this object will come when api get hit from cubical setting
            if(obj.Sys_BFGCode != undefined){
                res = await models.tbl_batches.findAll({
                    where:{
                        CubicNo: obj.int_cubicle,
                        Prod_ID: obj.Sys_BFGCode,
                        Prod_Name: obj.Sys_ProductName,
                        Prod_Version: obj.Sys_PVersion,
                        Version: obj.Sys_Version,
                        Batch: obj.Sys_Batch
                    }
                });
            }else{
                // from port setting check start and resume status
                res = await models.tbl_batches.findAll({
                    where:{
                        CubicNo: obj.int_cubicle,
                        Batch: obj.Sys_Batch,
                        Status:{ [Op.in]:obj.Status }
                    }
                });
            }

            if(res.length == 0)
            {
                Object.assign(obj_res,{"str":"No Batch Data",data:[]});
            }  
            else{
                Object.assign(obj_res,{"str":"Done","data":res});
            }
            return obj_res;
        } catch (error) {
            console.log("error",error);
            throw error;
        }
    }
    
}

module.exports = CubicleModel;