class ProductCapsule {
    getIndividualObject(req, reqAuditObject = false) { 
        var indGraphOn, blnIndLimitOn, indGraphCoatedOn, blnIndCoatedLimitOn;
        indGraphOn = req.str_IndGraphOn == "Standard" ? 0 : 1;
        blnIndLimitOn = req.str_IndLimitOn == "Actual" ? 0 : 1; //Actual = false(0) , Percentage = True (1)
        indGraphCoatedOn = req.str_IndGraphOnCoat == "Standard" ? 0 : 1;
        blnIndCoatedLimitOn = req.str_IndLimitOnCoat == "Actual" ? 0 : 1;

        const objIndividual = { 
            Param1_Nom: req.flt_IndStd,
            Param1_T1Neg: req.flt_IndT1Neg,
            Param1_T1Pos: req.flt_IndT1Pos,
            Param1_T2Neg: req.flt_IndT2Neg,
            Param1_T2Pos: req.flt_IndT2Pos,
            Param1_DP: req.int_IndDP,
            Param1_IsOnStd: indGraphOn,
            Param1_LimitOn: blnIndLimitOn,
            Param1_NMTTab: req.int_IndNMTTabCnt,
            Param1_Unit: req.str_unit_Balance,
            Param1_Nomenclature: req.str_ind_nomNomnclature
        }

        const objIndividualAudit = {
            OldParam1_Nom: req.OldParam1_Nom,
            NewParam1_Nom: req.NewParam1_Nom,
            OldParam1_T1Neg: req.OldParam1_T1Neg,
            NewParam1_T1Neg: req.NewParam1_T1Neg,
            OldParam1_T1Pos: req.OldParam1_T1Pos,
            NewParam1_T1Pos: req.NewParam1_T1Pos,
            OldParam1_T2Neg: req.OldParam1_T2Neg,
            NewParam1_T2Neg: req.NewParam1_T2Neg,
            OldParam1_T2Pos: req.OldParam1_T2Pos,
            NewParam1_T2Pos: req.NewParam1_T2Pos,
            OldParam1_IsOnStd: req.OldParam1_IsOnStd,
            NewParam1_IsOnStd: req.NewParam1_IsOnStd,
            OldParam1_Nomenclature: req.old_ind_nomNomnclature,
            NewParam1_Nomenclature: req.str_ind_nomNomnclature
        }

        if (reqAuditObject == true) {
            return objIndividualAudit;
        } else {
            return objIndividual;

        }
    }
    getGroupObject(req, reqAuditObject = false) { 
        var grpGraphOn, blnGrpLimitOn, grpGraphCoatedOn, blnGrpCoatedLimitOn;
        grpGraphOn = req.str_GrpGraphOn == "Standard" ? 0 : 1;
        blnGrpLimitOn = req.str_GrpLimitOn == "Actual" ? 0 : 1; //Actual = false(0) , Percentage = True (1)
        grpGraphCoatedOn = req.str_GrpGraphOnCoat == "Standard" ? 0 : 1;
        blnGrpCoatedLimitOn = req.str_GrpLimitOnCoat == "Actual" ? 0 : 1;

        const objGroup = {
            Param2_Nom: req.flt_GrpStd,
            Param2_T1Neg: req.flt_GrpT1Neg,
            Param2_T1Pos: req.flt_GrpT1Pos,
            Param2_T2Neg: req.flt_GrpT2Neg,
            Param2_T2Pos: req.flt_GrpT2Pos,
            Param2_DP: req.int_Grpdp,
            Param2_IsOnStd: grpGraphOn,
            Param2_LimitOn: blnGrpLimitOn,
            Param2_NMTTab: req.int_GrpNMTTabCnt,
            Param2_Unit: req.str_unit_Group,
        }
        const objGroupAudit = {
            OldParam2_Nom: req.OldParam2_Nom,
            NewParam2_Nom: req.NewParam2_Nom,
            OldParam2_T1Neg: req.OldParam2_T1Neg,
            NewParam2_T1Neg: req.NewParam2_T1Neg,
            OldParam2_T1Pos: req.OldParam2_T1Pos,
            NewParam2_T1Pos: req.NewParam2_T1Pos,
            OldParam2_T2Neg: req.OldParam2_T2Neg,
            NewParam2_T2Neg: req.NewParam2_T2Neg,
            OldParam2_T2Pos: req.OldParam2_T2Pos,
            NewParam2_T2Pos: req.NewParam2_T2Pos,
            OldParam2_IsOnStd: req.OldParam2_IsOnStd,
            NewParam2_IsOnStd: req.NewParam2_IsOnStd,
        }
        if (reqAuditObject == true) {
            return objGroupAudit;
        } else {
            return objGroup;

        }
    }
    getLengthObject(req, reqAuditObject = false) { 
        var lenGraphOn;
        lenGraphOn = req.str_LenGraphOn == "Standard" ? 0 : 1;
        const objLength = {
            Param5_Nom: req.flt_LenStd,
            Param5_T1Neg: req.flt_LenT1Neg,
            Param5_T1Pos: req.flt_LenT1Pos,
            Param5_T2Neg: req.flt_LenT2Neg,
            Param5_T2Pos: req.flt_LenT2Pos,
            Param5_DP: req.int_LenDp,
            Param5_IsOnStd: lenGraphOn,
            Param5_NMTTab: req.int_LenNMTTabCnt,
            Param5_Unit: req.str_unit_Vernier,
        }

        const objLengthAudit = {
            OldParam5_Nom: req.OldParam5_Nom,
            NewParam5_Nom: req.NewParam5_Nom,
            OldParam5_T1Neg: req.OldParam5_T1Neg,
            NewParam5_T1Neg: req.NewParam5_T1Neg,
            OldParam5_T1Pos: req.OldParam5_T1Pos,
            NewParam5_T1Pos: req.NewParam5_T1Pos,
            OldParam5_T2Neg: req.OldParam5_T2Neg,
            NewParam5_T2Neg: req.NewParam5_T2Neg,
            OldParam5_T2Pos: req.OldParam5_T2Pos,
            NewParam5_T2Pos: req.NewParam5_T2Pos,
        }
        if (reqAuditObject == true) {
            return objLengthAudit;
        } else {
            return objLength;

        }
    }
    getEmptyObject(req, reqAuditObject = false) {
        var emtGraphOn, blnEmtLimitOn;
        emtGraphOn = req.flt_EmptyGraphOn == "Standard" ? 0 : 1;
        blnEmtLimitOn = req.flt_EmptyLimitOn == "Actual" ? 0 : 1; //Actual = false(0) , Percentage = True (1)

        const objEmpty = {
                Param0_Nom: req.flt_Emptystd,
                Param0_T1Neg: req.flt_EmptyT1Neg,
                Param0_T1Pos: req.flt_EmptyT1Pos,
                Param0_T2Neg: req.flt_EmptyT2Neg,
                Param0_T2Pos: req.flt_EmptyT2Pos,
                Param0_DP: req.int_EmptyDp,
                Param0_IsOnStd: emtGraphOn,
                Param0_LimitOn: blnEmtLimitOn,
                Param0_NMTTab: req.flt_EmptyNMTCnt,
                Param0_Unit: req.str_unit_Balance,
            }
        const objEmptyAudit = {
            OldParam0_Nom: req.OldParam0_Nom,
            NewParam0_Nom: req.NewParam0_Nom,
            OldParam0_T1Neg: req.OldParam0_T1Neg,
            NewParam0_T1Neg: req.NewParam0_T1Neg,
            OldParam0_T1Pos: req.OldParam0_T1Pos,
            NewParam0_T1Pos: req.NewParam0_T1Pos,
            OldParam0_T2Neg: req.OldParam0_T2Neg,
            NewParam0_T2Neg: req.NewParam0_T2Neg,
            OldParam0_T2Pos: req.OldParam0_T2Pos,
            NewParam0_T2Pos: req.NewParam0_T2Pos,
            OldParam0_IsOnStd: req.OldParam0_IsOnStd,
            NewParam0_IsOnStd: req.NewParam0_IsOnStd,
            // { str_colName: 'OldParam0_LimitOn', value: OldParam0_LimitOn },
            // {str_colName: 'NewParam0_LmtOn',value: blnEmtLimitOn},
        }

        if (reqAuditObject == true) {
            return objEmptyAudit;
        } else {
            return objEmpty;

        }
    }

    getNetObject(req, reqAuditObject = false) {
        var NetGraphOn, blnNetLimitOn;
        NetGraphOn = req.flt_DiffNetGraphOn == "Standard" ? 0 : 1;
        blnNetLimitOn = req.flt_DiffNetLimitOn == "Actual" ? 0 : 1; //Actual = false(0) , Percentage = True (1)


        const objNet = {
                Param3_Nom: req.flt_DiffNet,
                Param3_T1Neg: req.flt_DiffNetT1Neg,
                Param3_T1Pos: req.flt_DiffNetT1Pos,
                Param3_T2Neg: req.flt_DiffNetT2Neg,
                Param3_T2Pos: req.flt_DiffNetT2Pos,
                Param3_DP: req.int_NetDp,
                Param3_IsOnStd: NetGraphOn,
                Param3_LimitOn: blnNetLimitOn,
                Param3_NMTTab: req.flt_DiffNetNMTCnt,
                Param3_Unit: req.str_unit_Balance,
            }
        const objNetAudit = {
            OldParam3_Nom: req.OldParam3_Nom,
            NewParam3_Nom: req.NewParam3_Nom,
            OldParam3_T1Neg: req.OldParam3_T1Neg,
            NewParam3_T1Neg: req.NewParam3_T1Neg,
            OldParam3_T1Pos: req.OldParam3_T1Pos,
            NewParam3_T1Pos: req.NewParam3_T1Pos,
            OldParam3_T2Neg: req.OldParam3_T2Neg,
            NewParam3_T2Neg: req.NewParam3_T2Neg,
            NewParam3_T2Pos: req.OldParam3_T2Pos,
            NewParam3_T2Pos: req.NewParam3_T2Pos,
            OldParam3_IsOnStd: req.OldParam3_IsOnStd,
            NewParam3_IsOnStd: req.NewParam3_IsOnStd,
            OldParam3_LimitOn: req.OldParam3_LimitOn,
            NewParam3_LmtOn: req.NewParam3_LmtOn,
            // {str_colName: 'NewParam3_NMTTab',value: req.int_GrpNMTTabCnt},
        }

        if (reqAuditObject == true) {
            return objNetAudit;
        } else {
            return objNet;

        }
    }

    getDiameterObject(req, reqAuditObject = false) {
        var diaGraphOn;
        diaGraphOn = req.str_DiaGraphOn == "Standard" ? 0 : 1;
        const objDiameter = {
            Param4_Nom: req.flt_DiaStd,
            Param4_T1Neg: req.flt_DiaT1Neg,
            Param4_T1Pos: req.flt_DiaT1Pos,
            Param4_T2Neg: req.flt_DiaT2Neg,
            Param4_T2Pos: req.flt_DiaT2Pos,
            Param4_Dp: req.int_DiaDp,
            Param4_IsOnStd: diaGraphOn,
            Param4_NMTTab: req.int_DiaNMTTabCnt,
        }

        const objDiameterAudit = {
            OldParam4_Nom: req.OldParam4_Nom,
            NewParam4_Nom: req.NewParam4_Nom,
            OldParam4_T1Neg: req.OldParam4_T1Neg,
            NewParam4_T1Neg: req.NewParam4_T1Neg,
            OldParam4_T1Pos: req.OldParam4_T1Pos,
            NewParam4_T1Pos: req.NewParam4_T1Pos,
            OldParam4_T2Neg: req.OldParam4_T2Neg,
            NewParam4_T2Neg: req.NewParam4_T2Neg,
            OldParam4_T2Pos: req.OldParam4_T2Pos,
            NewParam4_T2Pos: req.NewParam4_T2Pos,
        // {str_colName: 'NewParam4_IsOnStd',value: diaGraphOn},
        // {str_colName: 'NewParam4_NMTTab',value: req.int_DiaNMTTabCnt},
        }


        if (reqAuditObject == true) {
            return objDiameterAudit;
        } else {
            return objDiameter;

        }
    }

    getDTObject(req, reqAuditObject = false) {
        var dtTime = req.int_DTHHTime + ':' + req.int_DTMMTime + ':' + req.int_DTSSTime;

        const objDT = {
            Param6_Nom: dtTime,
            Param6_T1Neg: req.flt_DTMinTemp,
            Param6_T1Pos: req.flt_DTMaxTemp,
            Param6_DP: req.int_DTDp
        }
        const objDTAudit = {
            OldParam6_DTTime: req.OldParam6_DTTime ,
            NewParam6_DTTime: req.NewParam6_DTTime ,
        }

        if (reqAuditObject) {
            return objDTAudit;
        } else {
            return objDT;
        }
    }

    getContent1Object(req) {
        var bln_content1_graphOn, bln_content1_limiton;
        bln_content1_graphOn = req.str_Content1GraphOn == "Standard" ? 0 : 1;
        bln_content1_limiton = req.str_Content1LimitOn == "Actual" ? 0 : 1; //Actual = false(0) , Percentage = True (1)

        const objContent1 = {
            Param9_Nom: req.flt_Content1Std,
            Param9_T1Neg: req.flt_Content1T1Neg,
            Param9_T1Pos: req.flt_Content1T1Pos,
            Param9_T2Neg: req.flt_Content1T2Neg,
            Param9_T2Pos: req.flt_Content1T2Pos,
            Param9_DP: req.int_Content1DP,
            Param9_IsOnStd: bln_content1_graphOn,
            Param9_LimitOn: bln_content1_limiton,
            Param9_NMTTab: req.int_Content1NMTTabCnt,
            Param9_ContentType: req.str_content1_type,
            Param9_ContentDesc: req.str_content1_Name,
            Param9_Unit: req.str_unit_Balance,
        }
        
        return objContent1;
    }

    getContent2Object(req) {
        var bln_content2_graphOn, bln_content2_limiton;
        bln_content2_graphOn = req.str_Content2GraphOn == "Standard" ? 0 : 1;
        bln_content2_limiton = req.str_Content2LimitOn == "Actual" ? 0 : 1; //Actual = false(0) , Percentage = True (1)

        const objContent2 = {
            Param10_Nom: req.flt_Content2Std,
            Param10_T1Neg: req.flt_Content2T1Neg,
            Param10_T1Pos: req.flt_Content2T1Pos,
            Param10_T2Neg: req.flt_Content2T2Neg,
            Param10_T2Pos: req.flt_Content2T2Pos,
            Param10_DP: req.int_Content2DP,
            Param10_IsOnStd: bln_content2_graphOn,
            Param10_LimitOn: bln_content2_limiton,
            Param10_NMTTab: req.int_Content2NMTTabCnt,
            Param10_ContentType: req.str_content2_type,
            Param10_ContentDesc: req.str_content2_Name,
            Param10_Unit: req.str_unit_Balance,
        }

        return objContent2;
    }

    getContent3Object(req) {
        var bln_content3_graphOn, bln_content3_limiton;
        bln_content3_graphOn = req.str_Content3GraphOn == "Standard" ? 0 : 1;
        bln_content3_limiton = req.str_Content3LimitOn == "Actual" ? 0 : 1; //Actual = false(0) , Percentage = True (1)

        const objContent3 = {
            Param11_Nom: req.flt_Content3Std,
            Param11_T1Neg: req.flt_Content3T1Neg,
            Param11_T1Pos: req.flt_Content3T1Pos,
            Param11_T2Neg: req.flt_Content3T2Neg,
            Param11_T2Pos: req.flt_Content3T2Pos,
            Param11_DP: req.int_Content3DP,
            Param11_IsOnStd: bln_content3_graphOn,
            Param11_LimitOn: bln_content3_limiton,
            Param11_NMTTab: req.int_Content3NMTTabCnt,
            Param11_ContentType: req.str_content3_type ,
            Param11_ContentDesc: req.str_content3_Name,
            Param11_Unit: req.str_unit_Balance,
        }

        return objContent3;

    }

    getContent4Object(req) {
        var bln_content4_graphOn, bln_content4_limiton;
        bln_content4_graphOn = req.str_Content4GraphOn == "Standard" ? 0 : 1;
        bln_content4_limiton = req.str_Content4LimitOn == "Actual" ? 0 : 1; //Actual = false(0) , Percentage = True (1)

        const objContent4 = {
            Param12_Nom: req.flt_Content4Std,
            Param12_T1Neg: req.flt_Content4T1Neg,
            Param12_T1Pos: req.flt_Content4T1Pos,
            Param12_T2Neg: req.flt_Content4T2Neg,
            Param12_T2Pos: req.flt_Content4T2Pos,
            Param12_DP: req.int_Content4DP,
            Param12_IsOnStd: bln_content4_graphOn,
            Param12_LimitOn: bln_content4_limiton,
            Param12_NMTTab: req.int_Content4NMTTabCnt,
            Param12_ContentType: req.str_content4_type,
            Param12_ContentDesc: req.str_content4_Name,
            Param12_Unit: req.str_unit_Balance,
        }

        return objContent4;
    }

}

module.exports = ProductCapsule;