const clsNewCompressed = require('./clsNewProductAuditComp.class');
const serverConfig = require('../../API/global/serverConfig');
const date = require('date-and-time');
const clsProduct = require('./clsProductTablet.class')
const {Op} = require("sequelize");
const models = require("../dbConnection").models;
const sequelize = require("../dbConnection").sequelize;
const seqTransaction = require("../dbConnection");
const clsValidateProduct = require('./validateProduct.class');

const WeightmentParam = {
    Individual: 1,
    Group: 2,
    Thickness: 3,
    Hardness: 7,
    Friability: 8,
    Disintegration: 13,
    LOD:16,
    Lock:5,
    Net:3,
    Leak:99
}

const WeightmentParamCapsule = {
    Individual: 1,
    Group: 2,
    Net: 3,
    // Locked: 5,
    Empty: 19,
    Height: 5,
    Disintegration: 6,
}

class ProductParse{
    accepted_keys_old =  ['tab_id', 'ProductId', 'ProductName', 'Individual_LowerLimit', 'Individual_UpperLimit','Individual_IniQty','Individual_RegQty', 'Individual_DP','Individual_Unit','Group_LowerLimit', 
    'Group_UpperLimit','Group_IniQty','Group_RegQty','Group_DP','Group_Unit','Thickness_LowerLimit', 'Thickness_UpperLimit', 'Group_IniQty','Thickness_RegQty','Thickness_DP','Thickness_Unit','Breadth_LowerLimit', 
    'Breadth_UpperLimit','Breadth_IniQty','Breadth_RegQty', 'Breadth_DP','Breadth_Unit','Length_LowerLimit', 'Length_UpperLimit','Length_IniQty','Length_RegQty','Length_DP','Length_Unit','Diameter_LowerLimit',
    'Diameter_UpperLimit','Diameter_IniQty','Diameter_RegQty','Diameter_DP','Diameter_Unit','Hardness_LowerLimit','Hardness_UpperLimit','Hardness_RegQty','Hardness_IniQty', 'Hardness_DP','Hardness_Unit','Friability_LowerLimit',
    'Friability_UpperLimit','Friability_DP','DT_LowerLimit','Friability_RPM','Friability_CNT','DT_UpperLimit','DT_DP','LOD_LowerLimit','LOD_UpperLimit','LOD_DP','SFOID']


    accepted_keys_old_2 =  ['Material no.', 'Material name', 'Material type', 'UOM', 'Standard use type','Durability','Shelf life UOM']
    accepted_keys =  ['MPR number', 'Set', 'T2Neg', 'T2Pos']

    column_ref = [
        { xl_columnName:'MPR number',db_columnName :'MPN_Code',isParamRelated:false},
        { xl_columnName:'Set',db_columnName :'Nom',isParamRelated:true}, 
        { xl_columnName:'Minimum',db_columnName :'T2Neg',isParamRelated:true},
        { xl_columnName:'Maximum',db_columnName :'T2Pos',isParamRelated:true}, 
        { xl_columnName:'Product Code',db_columnName :'ProductId',isParamRelated:false}, 
        { xl_columnName:'Stage',db_columnName :'Stage',isParamRelated:false}, 
        { xl_columnName:'Product Name',db_columnName :'ProductName',isParamRelated:false}, 
    ]

    column_ref_old_2 = [
        { xl_columnName:'Material no.',db_columnName :'ProductId'},
        { xl_columnName:'Material name',db_columnName :'ProductName'}, 
        { xl_columnName:'Material type',db_columnName :'ProducType'}, 
        { xl_columnName:'UOM',db_columnName :'Unit'},
        { xl_columnName:'Standard use type',db_columnName :'StdUseType'},
        { xl_columnName:'Durability',db_columnName :'Durability'}, 
        { xl_columnName:'Shelf life UOM',db_columnName :'DurabilityUnit'}, 
    ]

    column_ref_old = [
        // { xl_columnName:'tab_id',db_columnName :'tab_id'}, 
        { xl_columnName:'ProductId',db_columnName :'str_BFGCode'}, 
        { xl_columnName:'ProductName',db_columnName :'str_Prd'}, 
        { xl_columnName:'Individual_LowerLimit',db_columnName :'flt_IndT1Neg'}, 
        { xl_columnName:'Individual_UpperLimit',db_columnName :'flt_IndT1Pos'},
        { xl_columnName:'Individual_IniQty',db_columnName :'int_IndQtyInitial'},
        { xl_columnName:'Individual_RegQty',db_columnName :'int_IndQtyRegular'}, 
        // { xl_columnName:'Individual_DP',db_columnName :'Param1_DP'},
        // { xl_columnName:'Individual_Unit',db_columnName :'Param1_Unit'},
        { xl_columnName:'Group_LowerLimit',db_columnName :'flt_GrpT1Neg'}, 
        { xl_columnName:'Group_UpperLimit',db_columnName :'flt_GrpT1Pos'},
        { xl_columnName:'Group_IniQty',db_columnName :'int_GrpQtyInitial'},
        { xl_columnName:'Group_RegQty',db_columnName :'int_GrpQtyRegular'},
        // { xl_columnName:'Group_DP',db_columnName :'Param2_DP'},
        // { xl_columnName:'Group_Unit',db_columnName :'Param2_Unit'},
        { xl_columnName:'Thickness_LowerLimit',db_columnName :'flt_ThkT1Neg'}, 
        { xl_columnName:'Thickness_UpperLimit',db_columnName :'flt_ThkT1Pos'}, 
        { xl_columnName:'Thickness_IniQty',db_columnName :'int_ThkQtyInitial'},
        { xl_columnName:'Thickness_RegQty',db_columnName :'int_ThkQtyRegular'},
        // { xl_columnName:'Thickness_DP',db_columnName :'Param3_DP'},
        // { xl_columnName:'Thickness_Unit',db_columnName :'Param3_Unit'},
        { xl_columnName:'Breadth_LowerLimit',db_columnName :'flt_BrdT1Neg'}, 
        { xl_columnName:'Breadth_UpperLimit',db_columnName :'flt_BrdT1Pos'},
        { xl_columnName:'Breadth_IniQty',db_columnName :'int_BrdQtyInitial'},
        { xl_columnName:'Breadth_RegQty',db_columnName :'int_BrdQtyRegular'}, 
        // { xl_columnName:'Breadth_DP',db_columnName :'Param4_DP'},
        // { xl_columnName:'Breadth_Unit',db_columnName :'Param4_Unit'},
        { xl_columnName:'Length_LowerLimit',db_columnName :'flt_LenT1Neg'}, 
        { xl_columnName:'Length_UpperLimit',db_columnName :'flt_LenT1Pos'},
        { xl_columnName:'Length_IniQty',db_columnName :'int_LenQtyInitial'},
        { xl_columnName:'Length_RegQty',db_columnName :'int_LenQtyRegular'},
        // { xl_columnName:'Length_DP',db_columnName :'Param5_DP'},
        // { xl_columnName:'Length_Unit',db_columnName :'Param5_Unit'},
        { xl_columnName:'Diameter_LowerLimit',db_columnName :'flt_DiaT1Neg'},
        { xl_columnName:'Diameter_UpperLimit',db_columnName :'flt_DiaT1Pos'},
        { xl_columnName:'Diameter_IniQty',db_columnName :'int_DiaQtyInitial'},
        { xl_columnName:'Diameter_RegQty',db_columnName :'int_DiaQtyRegular'},
        // { xl_columnName:'Diameter_DP',db_columnName :'Param6_DP'},
        // { xl_columnName:'Diameter_Unit',db_columnName :'Param6_Unit'},
        { xl_columnName:'Hardness_LowerLimit',db_columnName :'flt_HrdT1'},
        { xl_columnName:'Hardness_UpperLimit',db_columnName :'flt_HrdT2'},
        { xl_columnName:'Hardness_RegQty',db_columnName :'int_HrdQtyRegular'},
        { xl_columnName:'Hardness_IniQty',db_columnName :'int_HrdQtyInitial'},
        // { xl_columnName:'Hardness_DP',db_columnName :'Param7_DP'},
        // { xl_columnName:'Hardness_Unit',db_columnName :'Param7_Unit'},
        { xl_columnName:'Friability_LowerLimit',db_columnName :'flt_FriT1Neg'},
        { xl_columnName:'Friability_UpperLimit',db_columnName :'flt_FriT1Pos'},
        // { xl_columnName:'Friability_DP',db_columnName :'Param8_DP'},
        { xl_columnName:'Friability_CNT',db_columnName :'int_FriSetCnt'},
        { xl_columnName:'Friability_RPM',db_columnName :'int_FriSetRPM'},
        { xl_columnName:'DT_LowerLimit',db_columnName :'flt_DTMinTemp'},
        { xl_columnName:'DT_UpperLimit',db_columnName :'flt_DTMaxTemp'},
        // { xl_columnName:'DT_DP',db_columnName :'Param13_DP'},
        { xl_columnName:'LOD_LowerLimit',db_columnName :'flt_MAT1'},
        { xl_columnName:'LOD_UpperLimit',db_columnName :'flt_MAT2'},
        // { xl_columnName:'LOD_DP',db_columnName :'Param16_DP'},
        { xl_columnName:'SFOID',db_columnName :'str_sfoid'}
    ]

    objClsNewCompressed = new clsNewCompressed();
    
    
    async productFormat(data, value) {
        try {
            let arr_excelRec = await this.sortHeadDetailsLatest(data, value);
            if(arr_excelRec=="Invalid Excel Format"){
                return {msg:"Invalid Excel Format"}
            }
            let distinct_excelPrd = await this.checkScanProductExist(arr_excelRec, 0);
            console.log("Insert Record", distinct_excelPrd);
            let update_excelPrd = await this.checkScanProductExist(arr_excelRec, 1);
            console.log("Update Record", update_excelPrd);
            // console.log(distinct_excelPrd, update_excelPrd);
            await this.insertPrdAndAuditEntry(value, distinct_excelPrd, update_excelPrd);
            
            return {msg:"Success", new: distinct_excelPrd.length, dublicate: arr_excelRec.length - distinct_excelPrd.length, total: arr_excelRec.length, updated: update_excelPrd.length }
        } catch (error) {
            throw error;
        }
    }

    async sortHeadDetailsLatest(data, value) {
        try {
            let arr_productDetail = [];
            let arr_comp = []
            let arr_compParam = []
            let paramNo;
            let testTypeInd = data[0].findIndex(k => k == 'Test name');
            let productType = data[0].findIndex(k => k.match(/product type/gi));
            for (let i = 1; i < data.length; i++) {
                let obj_comp = {};
                let obj_compParam = {};
                if (data[i][testTypeInd]) {
                    if(data[i][productType].match(/capsule/gi)){
                        paramNo = WeightmentParamCapsule[data[i][testTypeInd].split(' ')[0]];
                    }
                    else{
                        paramNo = WeightmentParam[data[i][testTypeInd].split(' ')[0]];
                    }
                    for (let j = 0; j < data[i].length; j++) {
                        let paramData = this.column_ref.filter(col => col.xl_columnName == data[0][j])
                        if (paramData.length > 0) {
                            if (data[0][j].match(/mpr number/gi)) {
                                let isExist = arr_productDetail.filter(e => e.MPN_Code == data[i][j])
                                if (isExist.length == 0) {
                                    arr_productDetail.push({ [`${paramData[0].db_columnName}`]: data[i][j] ? data[i][j].toString() : data[i][j] })
                                }
                            } else {
                                //Fetching the index of current data
                                // let prdIndex = arr_productDetail.map((v,index) => { 
                                //     if(v.MPN_Code == data[i][0]){
                                //         return index
                                //     } 
                                // })[0]     
                                // in the above code if the first element in arr_productDetail does not match data[i][0] then index returned will be undefined even if there are matches elsewhere in the array since we are accessing the first element[0] of the mapped array,this will result in error below while Object.assign because the index sent will be undefined.Hence used findIndex to rectify this issue.
                                let mprIndex = data[0].findIndex(k => k.match(/mpr number/gi));
                                let prdTypeIndex = data[0].findIndex(k => k.match(/product type/gi));
                                //Fetching the index of current data
                                let prdIndex = arr_productDetail.findIndex(v => v.MPN_Code == data[i][mprIndex]);
                                let paramValue = data[i][j]
                                let paramUnit = ''
                                if (paramData[0].isParamRelated) {
                                    paramValue = this.getValueAndUnit(data[i][j]).value;
                                    paramUnit = this.getValueAndUnit(data[i][j]).unit;
                                }
                                if ((!paramData[0].isParamRelated || (paramData[0].isParamRelated && (!isNaN(paramValue) || `Param${paramNo}_${paramData[0].db_columnName}` == 'Param13_Nom')) && arr_productDetail[prdIndex]['Stage']!='Coating' )) {
                                    Object.assign(arr_productDetail[prdIndex],
                                        { IsTablet: !isNaN(data[i][prdTypeIndex]) ? data[i][prdTypeIndex] : data[i][prdTypeIndex].match(/tab/ig) ? 1 : 0 },
                                        // (paramNo==16 && paramData[0].db_columnName=='T2Neg')?'T1Neg': // condition changed for Lod value is stored in T1 
                                        { [paramData[0].isParamRelated ? `Param${paramNo}_${(paramNo == 16 && paramData[0].db_columnName == 'T2Pos') ? 'T1Pos' : (paramNo == 16 && paramData[0].db_columnName == 'T2Neg') ? 'T1Neg' : paramData[0].db_columnName}` : `${paramData[0].db_columnName}`]: paramValue ? paramValue.toString() : paramValue }
                                    );
                                    if (paramUnit && paramUnit!='NA') {
                                        Object.assign(arr_productDetail[prdIndex], { [`Param${paramNo}_Unit`]: paramUnit })
                                    }
                                }
                            }
                        }
                        if (!paramData[0] || !paramData[0].isParamRelated) {
                            Object.assign(obj_comp, { [data[0][j]]: data[i][j] })
                        }else{
                            Object.assign(obj_compParam, { [data[0][j]]: data[i][j] })
                        }
                    }
                }
                arr_comp.push(obj_comp);
                arr_compParam.push(obj_compParam);
            }
            var requiredStages;
            if(serverConfig.plant == 'PUI')
            {
                requiredStages = ['granulation', 'coating', 'compression','packing','filling','capsule filling'];  //for PUI
            }
            else
            {
                requiredStages = ['granulation', 'coating', 'compression','wurster','capsule filling'];  //for fto3
            }
            const allStages = arr_comp.map(item => item['Stage'] || '');
            
            const missingStages = allStages.filter(stage =>
                !requiredStages.some(val => new RegExp(`\\b${stage}\\b`, 'i').test(val))
            );
          
            if (missingStages.length > 0) {
                console.log("Missing Stages:", missingStages.join(', '));
                return "Invalid Excel Format";
            }
            let missingValues = [];
            arr_comp.forEach((item, index) => {
                let ele = arr_compParam[index]
                let setUnit = 0; let minUnit = 0; let maxUnit = 0;
                if (!["Disintegration Test", "Leak Test"].includes(item['Test name']) && !["Coating"].includes(item['Stage'])){
                    setUnit = ele.Set ? ele.Set.toString().split('').findIndex(k => isNaN(k) && (![' ', '.', ':'].includes(k))) : 0;
                    minUnit = ele.Minimum ? ele.Minimum.toString().split('').findIndex(k => isNaN(k) && (![' ', '.', ':'].includes(k))) : 0;
                    maxUnit = ele.Maximum ? ele.Maximum.toString().split('').findIndex(k => isNaN(k) && (![' ', '.', ':'].includes(k))) : 0;
                }
                console.log(item);
                let skipPara=!["Leak Test"].includes(item['Test name']) && !["Coating"].includes(item['Stage'])
                if (!skipPara && !(ele.Set=='NA' && ele.Minimum=='NA' && ele.Maximum=='NA') ){
                    console.log([setUnit,minUnit,maxUnit].includes(-1)?"Unit missing":"Parameter Missing");
                    missingValues.push({ index });
                }else if (((!ele.Set && !ele.Minimum && !ele.Maximum) && skipPara) || [setUnit,minUnit,maxUnit].includes(-1)) {
                    console.log([setUnit,minUnit,maxUnit].includes(-1)?"Unit missing":"Parameter Missing");
                    missingValues.push({ index });
                } 

                if(item['Product Type(Tablet/Capsule)'].match(/capsule/gi)){
                    Object.entries(item).forEach(([key, value]) => {
                    if (value === null || value === undefined || value === '' ||!!(key.match(/Test/ig) && !WeightmentParamCapsule[value?.split(' ')[0]])) {
                    console.log(!!(key.match(/Test/ig) && !WeightmentParamCapsule[value?.split(' ')[0]])? value+" Test Name Incorrect":key +" Coloumn Data Missing");
                        missingValues.push({ index });
                    }
                });
                }
                else{
                    Object.entries(item).forEach(([key, value]) => {
                    if (value === null || value === undefined || value === '' ||!!(key.match(/Test/ig) && !WeightmentParam[value?.split(' ')[0]])) {
                    console.log(!!(key.match(/Test/ig) && !WeightmentParam[value?.split(' ')[0]])? value+" Test Name Incorrect":key +" Coloumn Data Missing");
                        missingValues.push({ index });
                    }
                });
                }
            });
            if (missingValues.length > 0) {
                return "Invalid Excel Format"
            }
            // }

            let currentStage = arr_productDetail[0].Stage;
            let additionalStages = allStages.filter(stage => stage !== currentStage);

            if(additionalStages.length > 0){
                arr_productDetail[0].Stage += '|' + additionalStages.join(' | ');
            }

            let newarr_productDetail = []
            newarr_productDetail = arr_productDetail.map(k => {
                let obj = { ...k };
                if (!obj.ProductId) {
                    Object.assign(obj, { ProductId: 'NA' });
                }
                if (!obj.ProductName) {
                    Object.assign(obj, { ProductName: 'NA' });
                }
                return obj;
            });
            return newarr_productDetail;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    getValueAndUnit(val) {
        try {
            if (!val) return { value: val == null ? '99999.00000' : val, unit: val == null ? 'NA' : val };
            let unitIndex = val.toString().split('').findIndex(k => isNaN(k) && (![' ', '.', ':'].includes(k)));
            if (unitIndex == -1) {
                console.log("Unit Not Found");
            }
            return {
                value: unitIndex != -1 ? val.substr(0, unitIndex).trim() : val,
                unit: unitIndex != -1 ? val.substr(unitIndex).trim() : null
            };
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async sortHeadDetails(data,value){
        try {
            let arr_productDetail = []
            for(let i=1;i < data.length;i++){
                let obj_productDetail = {};
                for(let j = 0;j < data[i].length; j++){
                    let paramData = this.column_ref.filter(col => col.xl_columnName == data[0][j])
                    if(paramData.length > 0){
                        // accepted_keys.includes(data[0][j])
                        Object.assign(obj_productDetail,{[`${paramData[0].db_columnName}`]:data[i][j] ? data[i][j].toString() :  data[i][j]});
                    }
                    // paramData[0].db_columnName.includes('T') ? `${data[i][j]}`: 
                }
                /*Insert Default value which are required ,bln_TypeCoatPrd:false,bln_TypeBiLayPrd:false,
                bln_TypeTriLayPrd:false,bln_TypeGrannualPrd:false,bln_TypeDosaDry:false bln_BFGCode:true,bln_PrdVersion:false,bln_Version:false*/
                // Object.assign(obj_productDetail,{ bln_TypeCompressed:true,str_PV:'NA', str_V:'NA',strProjectName:'NA',str_BatchUnit:'Lakh'},value)
                arr_productDetail.push(obj_productDetail)
            }
            return arr_productDetail;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async checkScanProductExist(arr_excelRec,isDistinct){
        // let arr_dbProductList = await models.tbl_product_master.findAll({
        //     attributes:[ [sequelize.fn('CONCAT',sequelize.col('ProductId'),' ',sequelize.col('ProductName')),'ProductDetails']]
        // });
        let arr_dbProductList = await models.tbl_product_master.findAll({
            attributes:['MPN_Code','IsActive']
        });
        if (isDistinct) {
            arr_dbProductList=arr_dbProductList.filter(e=>e.IsActive!=2);
            arr_dbProductList = arr_dbProductList.map(e => { return e.MPN_Code });
            let distinct_excelPrd = arr_excelRec.filter(e => arr_dbProductList.includes(e.MPN_Code));
            return distinct_excelPrd;
        } else {
            arr_dbProductList = arr_dbProductList.map(e => { return e.MPN_Code });
            let distinct_excelPrd = arr_excelRec.filter(e => !arr_dbProductList.includes(e.MPN_Code));
            return distinct_excelPrd;
        }
    }

    async insertPrdAndAuditEntry(req,arr_excelRec,arr_excelUpdateRec){
        try {
            const objValidateProduct = new clsValidateProduct();
            let now = new Date();
            var t = await sequelize.transaction();
            console.log("Inserting Product Details>>",arr_excelRec);
            for(let data of arr_excelRec){
                var flag_iscomp = (data.IsTablet == 1) ? 1 : 0;
                var flag_prdType = (data.IsTablet == 1) ? 1 : 2;

                let userData = await models.tbl_users.findAll({ attributes:['Role'], where : { UserID : req.loggedUserId }});

                if(data.Stage.match(/(granulation|Wurster)/gi) != null){
                    Object.assign(data,{'IsGranulation': 1});
                }
                if(data.Stage.match(/(coating)/gi) != null){
                    Object.assign(data,{'IsCoated': 1});
                }
                if (data.IsTablet == 0) {
                    // Do nothing
                }
                if(data.Stage.match(/(packing|filling)/gi) != null){
                    // Do nothing
                }
                if(data.Stage.match(/(compression|compress)/gi) != null) {
                    Object.assign(data,{'IsCompress': 1});
                }
                if(data.Stage.match(/(capsule filling)/gi) != null) {
                    Object.assign(data,{'IsCapsuleFilling': 1});
                }

                delete data['Stage'];
                
                await models.tbl_product_master.create({...data,isImport:1,ProductType:flag_prdType,userID:req.loggedUserId,RejectGroup: userData[0].Role},{transaction : t});

                if(data.IsTablet == 1)
                {
                    await models.tbl_product_tablet.create(data,{transaction : t});
                }
                else
                {
                    await models.tbl_product_capsule.create(data,{transaction : t});
                }
                let audit = await objValidateProduct.validateProductMes("", "", data.MPN_Code, data.IsTablet == 1?"Tablet":"Capsule", true,[{...data}])
                await models.tbl_audit_product.create({
                    DT: date.format(now, 'YYYY-MM-DD'),
                    TM: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    ProductId: 'NA',
                    ProductName: 'NA',
                    OldValueComp: "NA",
                    NewValueComp: audit[data.IsTablet == 1?'Compressed':'Capsule'].newData,
                    OldValueGran: 'NA',
                    NewValueGran: 'NA',
                    OldValueCoat: 'NA',
                    NewValueCoat: 'NA',
                    Remark: req.remark,
                    ACT: req.action,
                    ProductType: flag_prdType,
                    type: (data.IsTablet == 1) ? 'Compressed' : 'Capsule Filling',
                    SFOID: data.MPN_Code
                }, {
                    transaction: t
                });
            }
            await t.commit();
            if(arr_excelUpdateRec.length > 0) await this.updatePrdAndAuditEntry(req, arr_excelRec, arr_excelUpdateRec);
        } catch (error) {
            if(t?.finished!='commit') await t.rollback();
            console.log(error);
            throw error;
        }
        // arr_excelRec.map((e) => str_newData  = (str_newData == '' ? ''  : ' , ') + (`ProductCode: ${e.ProductId},ProductName: ${e.ProductName}`) );
    }

    async updatePrdAndAuditEntry(req,arr_excelRec,arr_excelUpdateRec){
        try {
            const objValidateProduct = new clsValidateProduct();
            console.log("Updating Product Details>>",arr_excelUpdateRec);
            let now = new Date();
            var t1 = await sequelize.transaction();
            let oldData=[]
            for(let data of arr_excelUpdateRec){
                let tbl_temp,tbl_type;
                
                if(data.IsTablet==1){
                    tbl_temp = 'tbl_product_tablet_temp';
                    tbl_type = 'tbl_product_tablet';
                }else{
                    tbl_temp = 'tbl_product_capsule_temp';
                    tbl_type = 'tbl_product_capsule';
                }
                await models[tbl_temp].destroy({where: { MPN_Code: data.MPN_Code }})
                let oldPrdDtls=await models[tbl_type].findAll({where: { MPN_Code: data.MPN_Code }})
                oldData.push(oldPrdDtls)
            }
            for(let index = 0; index < arr_excelUpdateRec.length; index++){
                const data = arr_excelUpdateRec[index];
                var flag_iscomp = (data.IsTablet == 1) ? 1 : 0;
                var flag_prdType = (data.IsTablet == 1) ? 1 : 2;

                if(data.Stage.match(/(granulation|Wruter)/gi) != null){
                    Object.assign(data,{'IsGranulation': 1});
                }
                if(data.Stage.match(/(coating)/gi) != null){
                    Object.assign(data,{'IsCoated': 1});
                }
                if(data.Stage.match(/(packing)/gi) != null){
                    // Do nothing
                }
                if (data.Stage.match(/(compression|compress)/gi) != null) {
                    Object.assign(data,{'IsCompress': 1});
                }
                if(data.Stage.match(/(capsule filling)/gi) != null) {
                    Object.assign(data,{'IsCapsuleFilling': 1});
                }

                delete data['Stage'];
                
                // await models.tbl_product_master.update({ isLimitChanged: 1,IsReject:0 }, { where: { MPN_Code: data.MPN_Code } }, { transaction: t1 });
                // await models.tbl_product_capsule_temp.destroy({where: { MPN_Code: data.MPN_Code }},{transaction : t})
                if(data.IsTablet == 1){
                    await models.tbl_product_tablet_temp.create(data,{transaction : t1});
                }
                else{
                    await models.tbl_product_capsule_temp.create(data,{transaction : t1});
                }

                let audit = await objValidateProduct.validateProductMes("", "", data.MPN_Code, data.IsTablet == 1?"Tablet":"Capsule", true,[{...data}],[...oldData[index]])

                if(data.IsTablet == 1){
                    if(audit.Compressed.oldData == '' && audit.Compressed.newData == '')
                    {
                    await models.tbl_product_master.update({ isLimitChanged: 0,IsReject:0 }, { where: { MPN_Code: data.MPN_Code } }, { transaction: t1 });
                    }
                    else{
                    await models.tbl_product_master.update({ isLimitChanged: 1,IsReject:0 }, { where: { MPN_Code: data.MPN_Code } }, { transaction: t1 });
                    }
                }
                else{
                    if(audit.Capsule.oldData == '' && audit.Capsule.newData == '')
                    {
                    await models.tbl_product_master.update({ isLimitChanged: 0,IsReject:0 }, { where: { MPN_Code: data.MPN_Code } }, { transaction: t1 });
                    }
                    else{
                    await models.tbl_product_master.update({ isLimitChanged: 1,IsReject:0 }, { where: { MPN_Code: data.MPN_Code } }, { transaction: t1 });
                    }
                }
                console.log("Update Audit",audit);
                await models.tbl_audit_product.create({
                    DT: date.format(now, 'YYYY-MM-DD'),
                    TM: date.format(now, 'HH:mm:ss'),
                    userid: req.loggedUserId,
                    username: req.loggedUserName,
                    ProductId: 'NA',
                    ProductName: 'NA',
                    OldValueComp: audit?.result=='No Change'?"NA":audit[data.IsTablet == 1?'Compressed':'Capsule'].oldData,
                    NewValueComp: audit?.result=='No Change'?"NA":audit[data.IsTablet == 1?'Compressed':'Capsule'].newData,
                    OldValueGran: 'NA',
                    NewValueGran: 'NA',
                    OldValueCoat: 'NA',
                    NewValueCoat: 'NA',
                    Remark: req.remark,
                    ACT: req.action,
                    ProductType: flag_prdType,
                    type: (data.IsTablet == 1) ? 'Compressed' : 'Capsule Filling',
                    SFOID: data.MPN_Code
                }, { transaction: t1 });
            }
            await t1.commit();
        } catch (error) {
            if(t1?.finished!='commit') await t1.rollback();
            console.log(error);
            throw error;       
        }
        // arr_excelRec.map((e) => str_newData  = (str_newData == '' ? ''  : ' , ') + (`ProductCode: ${e.ProductId},ProductName: ${e.ProductName}`) );
    }
   
}

module.exports = ProductParse;

// var sarr = Object.entries(data);
// for (var index = 0; index < sarr.length; index++) {
//     if(index > 1)
//     { 
//         var lbl = "";
//         switch (sarr[index][0]) {
//             case "Param1":
//                 lbl = sarr[index][0].replace("Param1","Individual")
//                 break;
//             case "Param2":
//                 lbl = sarr[index][0].replace("Param2","Group")
//                 break;
//             case "Param3":
//                 lbl = sarr[index][0].replace("Param3","Thickness")
//                 break;
//             case "Param13":
//                 lbl = sarr[index][0].replace("Param13","DT")
//                 break;
//             case "Param8":
//                 lbl = sarr[index][0].replace("Param8","Friability")
//             break;
//             case "Param7":
//                 lbl = sarr[index][0].replace("Param7","Hardness")
//             break;
//             default:
//                 break;
//         }
//         if(sarr[index][0].includes("T2Neg") == true)
//         {
//             lbl = sarr[index][0].replace("T2Neg","Lower Limit")
//         }
//         else if(sarr[index][0].includes("T2Pos") == true)
//         {
//             lbl = sarr[index][0].replace("T2Pos","Upper Limit")
//         }
       
//         sarr_data.push(lbl + ":" + sarr[index][1]);
//     }
// }