const clsProduct = require('./clsProductTablet.class');
const clsCapsule = require('./clsProductCapsule.class');
const objProduct = new clsProduct();
const objCapsule = new clsCapsule;
const requestIp = require('request-ip');
const Database = require('../database/clsQueryProcess');
const dbCon = require('../Utills/db');
const database = new Database();
const clsTabletModel = require('./clsTabletModel');
const clsTabletModelObj = new clsTabletModel;
const strDetailTableName = "tbl_product_capsule";
const clsStoredProcedure = require('./clsStoredProcedure');
const objStoredProcedure = new clsStoredProcedure();
const clsMathJS = require('./clsMathJS');
const math =  new clsMathJS();
const serverConfig = require('../global/serverConfig');

class CapsuleProduct {

    static get strDetailTableName() {
        return strDetailTableName;
    }



    pushParamDetailsCapsule(str_query, req) {
        Object.assign(str_query,objProduct.getIndividualObject(req, false, false, false));//1
        Object.assign(str_query,objProduct.getGroupObject(req, false, false, false));//2
        Object.assign(str_query,objCapsule.getEmptyObject(req, false));//3
        Object.assign(str_query,objCapsule.getNetObject(req, false));//4
        Object.assign(str_query,objProduct.getLengthObject(req, false, false, false));//5
        Object.assign(str_query,objCapsule.getDiameterObject(req, false));//6
        Object.assign(str_query,objCapsule.getDTObject(req, false));//13
        Object.assign(str_query,objCapsule.getContent1Object(req, false));//9
        Object.assign(str_query,objCapsule.getContent2Object(req, false));//10
        Object.assign(str_query,objCapsule.getContent3Object(req, false));//11
        Object.assign(str_query,objCapsule.getContent4Object(req, false));//12

        return str_query;
    }

    pushAuditParamsCapsule(auditProductObj, req) {
        auditProductObj.data.push(...objProduct.getIndividualObject(req, true, false, false));
        auditProductObj.data.push(...objProduct.getGroupObject(req, true, false, false));
        auditProductObj.data.push(...objCapsule.getEmptyObject(req, true));
        auditProductObj.data.push(...objCapsule.getNetObject(req, true));
        auditProductObj.data.push(...objProduct.getLengthObject(req, true, false, false));
        auditProductObj.data.push(...objCapsule.getDiameterObject(req, true));
        auditProductObj.data.push(...objCapsule.getDTObject(req, true));
        auditProductObj.data.push(...objCapsule.getContent1Object(req, true));
        auditProductObj.data.push(...objCapsule.getContent2Object(req, true));
        auditProductObj.data.push(...objCapsule.getContent3Object(req, true));
        auditProductObj.data.push(...objCapsule.getContent4Object(req, true));

        return auditProductObj
    }

    async calculationCapsuleLOD(value) {
        var strTblName = "", objResult = {},strRemark = "";
        (value.recordFrom =="Current") ? strTblName = "tbl_lodmaster" : strTblName = "tbl_lodmaster_archived";
        let res = await dbCon.execute(`Select ROUND(CAST((((DryWt-LossOnWt)/DryWt)*100) AS DECIMAL(20,15)),2) AS lodPer from `+ strTblName +` where RepSerNo=${value.RepSerNo}`);
        
        let resAll = await dbCon.execute(`Select * from `+ strTblName +` where RepSerNo=${value.RepSerNo}`);

        ((resAll[0][0].MinLimit < Number((resAll[0][0].DryWt-resAll[0][0].LossOnWt)*100/resAll[0][0].DryWt).toFixed(3))  
        && (Number((resAll[0][0].DryWt-resAll[0][0].LossOnWt)*100/resAll[0][0].DryWt).toFixed(3) <= resAll[0][0].MaxLimit)) ? strRemark = "Complies" : strRemark="Not Complies";

        Object.assign(objResult,{result:res[0][0]},{remark:strRemark},
            {minStdLimit:Number(resAll[0][0].MinLimit).toFixed(2) },{maxStdLimit:Number(resAll[0][0].MaxLimit).toFixed(3)},
            {setTemp:Number(resAll[0][0].SetTemp).toFixed(1)},{dryWt:Number(resAll[0][0].DryWt).toFixed(3) },{lossOnWt:Number(resAll[0][0].LossOnWt).toFixed(3)});
        return objResult;
    }

    async viewCapsuleReport(value, req) {
        let responseObj = {};
        var calRes = {};
        let clientIp = requestIp.getClientIp(req);
        let ip = clientIp.split(':')[3];
        if ((("idsNo" in value) == true)) {
            ip = `${serverConfig.strIpSeries}${value.idsNo}`;
        } else {
            if (ip === undefined) {
                ip = '127.0.0.1'
            } else {
                ip = ip
            }
        }
        
        const selectDetailRpt = {
            str_tableName: 'tbl_rpt_path',
            data: '*',
        }
        var result1 = await database.select(selectDetailRpt);
        var proj_name = result1[0][0]['proj_name'];

        // get NMt from nomenclature table - Applicable:1 (Not consider NMT) and NA:0 (consider NMT)
        var obj_getNMT = {
            str_tableName: 'tbl_nomenclature',
            data: 'IsNMT'
        }

        var str_resNMT = await database.select(obj_getNMT);
        
        var reportOption = value.reportOption;
        var testType = value.testType;
        var reportType = value.reportType;
        var recordFrom = value.recordFrom;
        var RepSerNo = value.RepSerNo;
        var responseObj1 = {};
        var masterTableName, detailTableName;
        if (testType == 'Regular') {
            testType = 0;
        } else {
            testType = 1;
        }
        var reciveObj = await this.commanFunctionForFindingOutTableName(reportOption, reportType, recordFrom);
        masterTableName = reciveObj.masterTableName;
        detailTableName = reciveObj.detailTableName;
        var selectObj = {
            str_tableName: masterTableName,
            data: '*',
            condition: [
                { str_colName: 'RepSerNo', value: RepSerNo }
            ]
        }
        let masterRes = await database.select(selectObj);
        var int_sideForReport =  serverConfig.developerPanelData.IncrencyCommon.find(x => x.Name === 'SideSingleText').Value;// Text :- 1: Single 0: NA
        if(int_sideForReport == '1')
        {
            masterRes[0][0].Side = (masterRes[0][0].Side== 'NA')? 'Single' : masterRes[0][0].Side;
        }
        var insertVal = masterRes[0][0];
        if(reportOption != "Tapped Density"){
        var selectObjRec = await dbCon.execute(`SELECT MAX(RecSeqNo) as RecSeqNo FROM ${detailTableName} where RepSerNo=${RepSerNo}`);
        }
        if (reportOption == 'Disintegration Tester') {
            var selectTempData = {
                str_tableName: 'tbl_temp_masterdt',
                data: '*',
                condition: [
                    { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                ]
            }
        }
        else if (reportOption == 'Differential') {
            var selectTempData = {
                str_tableName: 'tbl_temp_masterdiff',
                data: '*',
                condition: [
                    { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                ]
            }
        }
        else {
            var selectTempData = {
                str_tableName: 'tbl_temp_master',
                data: '*',
                condition: [
                    { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                ]
            }
        }

        let tempRes = await database.select(selectTempData);
        
        // Checking if there is entry for respected HMI or not
        if (tempRes[0].length > 0) {
            if (reportOption == 'Disintegration Tester') {
                var deleteTempMaster = {
                    str_tableName: 'tbl_temp_masterdt',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                var deleteTempDetail = {
                    str_tableName: 'tbl_temp_detaildt',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                let res1 = await database.delete(deleteTempMaster);
                let delete1 = await database.delete(deleteTempDetail);
                let res = await clsTabletModelObj.insertDTTempTables(insertVal, ip, detailTableName, RepSerNo);
                var calRes = await clsTabletModelObj.calculationDT(insertVal, RepSerNo, ip, value, recordFrom);
               
            }
            else if (reportOption == 'Tapped Density') {
                var calRes = await this.calculationCapDensity(RepSerNo, masterTableName, value, ip);
                return calRes;
            }
            else if (reportOption == 'Length' || reportOption == 'Locked Length' || reportOption == 'Diameter') {
                var deleteTempMaster = {
                    str_tableName: 'tbl_temp_master',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                var deleteTempDetail = {
                    str_tableName: 'tbl_temp_detail',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                let res1 = await database.delete(deleteTempMaster);
                let delete1 = await database.delete(deleteTempDetail);
                var res = await clsTabletModelObj.insertTempTables(insertVal, ip, detailTableName, RepSerNo, reportOption);
                var calRes = await clsTabletModelObj.calculationGroupVernier(str_resNMT[0][0]['IsNMT'],insertVal, RepSerNo, ip, value, reportType, detailTableName, 2);
            }
            else if (reportOption == 'Group') {

                var deleteTempMaster = {
                    str_tableName: 'tbl_temp_master',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                var deleteTempDetail = {
                    str_tableName: 'tbl_temp_detailgroup',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                let res1 = await database.delete(deleteTempMaster);
                let delete1 = await database.delete(deleteTempDetail);
                var res = await clsTabletModelObj.insertGroupTempTables(insertVal, ip, detailTableName, RepSerNo);
                var calRes = await clsTabletModelObj.calculationGroupVernier(str_resNMT[0][0]['IsNMT'],insertVal, RepSerNo, ip, value, reportType, detailTableName, 2);
               
            }
            else if (reportOption == 'Differential') {
                var deleteTempMaster = {
                    str_tableName: 'tbl_temp_masterdiff',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                var deleteTempDetail = {
                    str_tableName: 'tbl_temp_detaildiff',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
               
                let res1 = await database.delete(deleteTempMaster);
                let delete1 = await database.delete(deleteTempDetail);
                let res = await clsTabletModelObj.insertDiff(insertVal, ip, detailTableName, RepSerNo);
                var contentNumber = "";
                switch (insertVal.NoOfContent) {
                    case 1:
                        contentNumber = "ONE";
                        break;
                    case 2:
                        contentNumber = "TWO";
                        break;
                    case 3:
                        contentNumber = "THREE";
                        break;
                    case 4:
                        contentNumber = "FOUR";
                        break;        
                    default:
                        contentNumber = "";
                        break;
                }
                var str_mgDP = 0;

               /**
             *   This change is requested by client : SVP (CRF-40), ML 
             * If unit is "mg" then int_DP = From Developer Panel else as per balance DP
             */ 
               var int_dp = (insertVal.Unit == "mg") ? Number(str_mgDP) : Number(insertVal.DecimalPoint);

                var bln_multiComponent = (serverConfig.developerPanelData.MultiComponent.find(x => x.Name === 'Content1').Value == 1) ? true : false;
                if(bln_multiComponent)
                {
                    var calResMultiComponent = await objStoredProcedure.getCalculationMultiComponent(RepSerNo, value);
                    var calRes = {
                        'nomFilledCont': Number(calResMultiComponent[2][0]['@nomFilledCont']).toFixed(int_dp),
                        'stdLmt1TxtFilledCont': calResMultiComponent[2][0]['@stdLmt1TxtFilledCont'],
                        'stdLmt2TxtFilledCont': calResMultiComponent[2][0]['@stdLmt2TxtFilledCont'],
                        'lowT1FilledCont': Number(calResMultiComponent[2][0]['@lowT1FilledCont']).toFixed(int_dp),
                        'uppT1FilledCont': Number(calResMultiComponent[2][0]['@uppT1FilledCont']).toFixed(int_dp),
                        'lowT2FilledCont': Number(calResMultiComponent[2][0]['@lowT2FilledCont']).toFixed(int_dp),
                        'uppT2FilledCont': Number(calResMultiComponent[2][0]['@uppT2FilledCont']).toFixed(int_dp),
                        'AverageValueFilledCont': Number(calResMultiComponent[2][0]['@AverageValueFilledCont']).toFixed(int_dp + 1),
                        'minWeightFilledCont': Number(calResMultiComponent[2][0]['@minWeightFilledCont']).toFixed(int_dp),
                        'maxWeightFilledCont': Number(calResMultiComponent[2][0]['@maxWeightFilledCont']).toFixed(int_dp),
                        'minPercentageFilledCont': Number(calResMultiComponent[2][0]['@minPercentageFilledCont']).toFixed(2),
                        'maxPercentageFilledCont': Number(calResMultiComponent[2][0]['@maxPercentageFilledCont']).toFixed(2),
                        'CalStandDevFilledCont': Number(calResMultiComponent[2][0]['@CalStandDevFilledCont']).toFixed(int_dp + 1),
                        'AbvLmt1NoSideFilledCont': Number(calResMultiComponent[2][0]['@AbvLmt1NoSideFilledCont']),
                        'BlwLmt1NoSideFilledCont': Number(calResMultiComponent[2][0]['@BlwLmt1NoSideFilledCont']),
                        'AbvLmt2NoSideFilledCont': Number(calResMultiComponent[2][0]['@AbvLmt2NoSideFilledCont']),
                        'BlwLmt2NoSideFilledCont': Number(calResMultiComponent[2][0]['@BlwLmt2NoSideFilledCont']),
                        'nomTab1': Number(calResMultiComponent[2][0]['@nomTab1']).toFixed(int_dp),
                        'stdLmt1TxtTab1': calResMultiComponent[2][0]['@stdLmt1TxtTab1'],
                        'stdLmt2TxtTab1': calResMultiComponent[2][0]['@stdLmt2TxtTab1'],
                        'lowT1Tab1': Number(calResMultiComponent[2][0]['@lowT1Tab1']).toFixed(int_dp),
                        'uppT1Tab1': Number(calResMultiComponent[2][0]['@uppT1Tab1']).toFixed(int_dp),
                        'lowT2Tab1': Number(calResMultiComponent[2][0]['@lowT2Tab1']).toFixed(int_dp),
                        'uppT2Tab1': Number(calResMultiComponent[2][0]['@uppT2Tab1']).toFixed(int_dp),
                        'AverageValueTab1': Number(calResMultiComponent[2][0]['@AverageValueTab1']).toFixed(int_dp + 1),
                        'minWeightTab1': Number(calResMultiComponent[2][0]['@minWeightTab1']).toFixed(int_dp),
                        'maxWeightTab1': Number(calResMultiComponent[2][0]['@maxWeightTab1']).toFixed(int_dp),
                        'minPercentageTab1': Number(calResMultiComponent[2][0]['@minPercentageTab1']).toFixed(2),
                        'maxPercentageTab1': Number(calResMultiComponent[2][0]['@maxPercentageTab1']).toFixed(2),
                        'CalStandDevTab1': Number(calResMultiComponent[2][0]['@CalStandDevTab1']).toFixed(int_dp + 1),
                        'AbvLmt1NoSideTab1': Number(calResMultiComponent[2][0]['@AbvLmt1NoSideTab1']),
                        'BlwLmt1NoSideTab1': Number(calResMultiComponent[2][0]['@BlwLmt1NoSideTab1']),
                        'AbvLmt2NoSideTab1': Number(calResMultiComponent[2][0]['@AbvLmt2NoSideTab1']),
                        'BlwLmt2NoSideTab1': Number(calResMultiComponent[2][0]['@BlwLmt2NoSideTab1']),
                        'nomTab2': Number(calResMultiComponent[2][0]['@nomTab2']).toFixed(int_dp),
                        'stdLmt1TxtTab2': calResMultiComponent[2][0]['@stdLmt1TxtTab2'],
                        'stdLmt2TxtTab2': calResMultiComponent[2][0]['@stdLmt2TxtTab2'],
                        'lowT1Tab2': Number(calResMultiComponent[2][0]['@lowT1Tab2']).toFixed(int_dp),
                        'uppT1Tab2': Number(calResMultiComponent[2][0]['@uppT1Tab2']).toFixed(int_dp),
                        'lowT2Tab2': Number(calResMultiComponent[2][0]['@lowT2Tab2']).toFixed(int_dp),
                        'uppT2Tab2': Number(calResMultiComponent[2][0]['@uppT2Tab2']).toFixed(int_dp),
                        'AverageValueTab2': Number(calResMultiComponent[2][0]['@AverageValueTab2']).toFixed(int_dp + 1),
                        'minWeightTab2': Number(calResMultiComponent[2][0]['@minWeightTab2']).toFixed(int_dp),
                        'maxWeightTab2': Number(calResMultiComponent[2][0]['@maxWeightTab2']).toFixed(int_dp),
                        'minPercentageTab2': Number(calResMultiComponent[2][0]['@minPercentageTab2']).toFixed(2),
                        'maxPercentageTab2': Number(calResMultiComponent[2][0]['@maxPercentageTab2']).toFixed(2),
                        'CalStandDevTab2': Number(calResMultiComponent[2][0]['@CalStandDevTab2']).toFixed(int_dp + 1),
                        'AbvLmt1NoSideTab2': Number(calResMultiComponent[2][0]['@AbvLmt1NoSideTab2']),
                        'BlwLmt1NoSideTab2': Number(calResMultiComponent[2][0]['@BlwLmt1NoSideTab2']),
                        'AbvLmt2NoSideTab2': Number(calResMultiComponent[2][0]['@AbvLmt2NoSideTab2']),
                        'BlwLmt2NoSideTab2': Number(calResMultiComponent[2][0]['@BlwLmt2NoSideTab2']),
                        'nomTab3': Number(calResMultiComponent[2][0]['@nomTab3']).toFixed(int_dp),
                        'stdLmt1TxtTab3': calResMultiComponent[2][0]['@stdLmt1TxtTab3'],
                        'stdLmt2TxtTab3': calResMultiComponent[2][0]['@stdLmt2TxtTab3'],
                        'lowT1Tab3': Number(calResMultiComponent[2][0]['@lowT1Tab3']).toFixed(int_dp),
                        'uppT1Tab3': Number(calResMultiComponent[2][0]['@uppT1Tab3']).toFixed(int_dp),
                        'lowT2Tab3': Number(calResMultiComponent[2][0]['@lowT2Tab3']).toFixed(int_dp),
                        'uppT2Tab3': Number(calResMultiComponent[2][0]['@uppT2Tab3']).toFixed(int_dp),
                        'AverageValueTab3': Number(calResMultiComponent[2][0]['@AverageValueTab3']).toFixed(int_dp + 1),
                        'minWeightTab3': Number(calResMultiComponent[2][0]['@minWeightTab3']).toFixed(int_dp),
                        'maxWeightTab3': Number(calResMultiComponent[2][0]['@maxWeightTab3']).toFixed(int_dp),
                        'minPercentageTab3': Number(calResMultiComponent[2][0]['@minPercentageTab3']).toFixed(2),
                        'maxPercentageTab3': Number(calResMultiComponent[2][0]['@maxPercentageTab3']).toFixed(2),
                        'CalStandDevTab3': Number(calResMultiComponent[2][0]['@CalStandDevTab3']).toFixed(int_dp + 1),
                        'AbvLmt1NoSideTab3': Number(calResMultiComponent[2][0]['@AbvLmt1NoSideTab3']),
                        'BlwLmt1NoSideTab3': Number(calResMultiComponent[2][0]['@BlwLmt1NoSideTab3']),
                        'AbvLmt2NoSideTab3': Number(calResMultiComponent[2][0]['@AbvLmt2NoSideTab3']),
                        'BlwLmt2NoSideTab3': Number(calResMultiComponent[2][0]['@BlwLmt2NoSideTab3']),
                        'nomTab4': Number(calResMultiComponent[2][0]['@nomTab4']).toFixed(int_dp),
                        'stdLmt1TxtTab4': calResMultiComponent[2][0]['@stdLmt1TxtTab4'],
                        'stdLmt2TxtTab4': calResMultiComponent[2][0]['@stdLmt2TxtTab4'],
                        'lowT1Tab4': Number(calResMultiComponent[2][0]['@lowT1Tab4']).toFixed(int_dp),
                        'uppT1Tab4': Number(calResMultiComponent[2][0]['@uppT1Tab4']).toFixed(int_dp),
                        'lowT2Tab4': Number(calResMultiComponent[2][0]['@lowT2Tab4']).toFixed(int_dp),
                        'uppT2Tab4': Number(calResMultiComponent[2][0]['@uppT2Tab4']).toFixed(int_dp),
                        'AverageValueTab4': Number(calResMultiComponent[2][0]['@AverageValueTab4']).toFixed(int_dp + 1),
                        'minWeightTab4': Number(calResMultiComponent[2][0]['@minWeightTab4']).toFixed(int_dp),
                        'maxWeightTab4': Number(calResMultiComponent[2][0]['@maxWeightTab4']).toFixed(int_dp),
                        'minPercentageTab4': Number(calResMultiComponent[2][0]['@minPercentageTab4']).toFixed(2),
                        'maxPercentageTab4': Number(calResMultiComponent[2][0]['@maxPercentageTab4']).toFixed(2),
                        'CalStandDevTab4': Number(calResMultiComponent[2][0]['@CalStandDevTab4']).toFixed(int_dp + 1),
                        'AbvLmt1NoSideTab4': Number(calResMultiComponent[2][0]['@AbvLmt1NoSideTab4']),
                        'BlwLmt1NoSideTab4': Number(calResMultiComponent[2][0]['@BlwLmt1NoSideTab4']),
                        'AbvLmt2NoSideTab4': Number(calResMultiComponent[2][0]['@AbvLmt2NoSideTab4']),
                        'BlwLmt2NoSideTab4': Number(calResMultiComponent[2][0]['@BlwLmt2NoSideTab4']),
                        'ICReport': calResMultiComponent[2][0]['@ICReport'],
                        'Result': calResMultiComponent[2][0]['@Result'],
                        'UserId': insertVal.UserId,
                        'UserName': insertVal.UserName,
                        'waterMark': true,
                        'rptHeading': `DIFFERENTIAL WEIGHT VARIATION RECORD (${(contentNumber)} CONTENTS IN CAPSULE)`,
                        'HmiId': ip.split('.')[3],
                        'printNo':insertVal.PrintNo
                    };
                }
                else
                {
                    var calResDiff = await objStoredProcedure.getCalculationDiff(RepSerNo, value);
                    var calRes = {
                        'SelectedValue': RepSerNo,
                        'nom': Number(calResDiff[1][0]['@nominal']).toFixed(int_dp),
                        'minWeight': Number(calResDiff[1][0]['@minWeight']).toFixed(int_dp),
                        'maxWeight': Number(calResDiff[1][0]['@maxWeight']).toFixed(int_dp),
                        'minPercentage': calResDiff[1][0]['@minPercentage'],
                        'maxPercentage': calResDiff[1][0]['@maxPercentage'],
                        'AverageValue': math.roundUpPad(calResDiff[1][0]['@average'],int_dp+1),
                        'lowT1': Number(calResDiff[1][0]['@T1Neg']).toFixed(int_dp),
                        'uppT1': Number(calResDiff[1][0]['@T1Pos']).toFixed(int_dp),
                        'lowT2': Number(calResDiff[1][0]['@T2Neg']).toFixed(int_dp),
                        'uppT2': Number(calResDiff[1][0]['@T2Pos']).toFixed(int_dp),
                        'BlwLmt1NoSide': calResDiff[1][0]['@belowLimitT1Count'],
                        'AbvLmt1NoSide': calResDiff[1][0]['@aboveLimitT1Count'],
                        'BlwLmt2NoSide': calResDiff[1][0]['@belowLimitT2Count'],
                        'AbvLmt2NoSide': calResDiff[1][0]['@aboveLimitT2Count'],
                        'CalStandDev': math.roundUpPad(calResDiff[1][0]['@Stdev'],int_dp+1),
                        'Result': calResDiff[1][0]['@result'],
                        'stdLmt1Txt': calResDiff[1][0]['@labelT1'],
                        'stdLmt2Txt': calResDiff[1][0]['@labelT2'],
                        "rptHeading": "DIFFERENTIAL  WEIGHT VARIATION RECORD",
                        "ReqMenu": "",
                        "ToDate": "",
                        "UserId": insertVal.UserId,
                        "UserName": insertVal.UserName,
                        "waterMark": true,
                        "FromDate": "",
                        "HmiId": ip.split('.')[3],
                        "ICReport": reportType,
                        "ReqMenu": "",
                        "SelectedAction": "",
                        "RecSeqNo": selectObjRec[0][0]['RecSeqNo'],
                        "printNo":value.printNo
                    };
                }
            }
            else if (reportOption == 'Particle Size') {
                var deleteTempMaster = {
                    str_tableName: 'tbl_temp_master',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                var deleteTempDetail = {
                    str_tableName: 'tbl_temp_detail',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                let res1 = await database.delete(deleteTempMaster);
                let delete1 = await database.delete(deleteTempDetail);
                var res = await clsTabletModelObj.insertParticalSizeTempTables(insertVal, ip, detailTableName, RepSerNo, 1);
                var calRes = await clsTabletModelObj.calculationParticleSize(insertVal, RepSerNo, ip, value);
                return calRes;

            }else if (reportOption == '% Fine') {
                var deleteTempMaster = {
                    str_tableName: 'tbl_temp_master',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                var deleteTempDetail = {
                    str_tableName: 'tbl_temp_detail',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                let res1 = await database.delete(deleteTempMaster);
                let delete1 = await database.delete(deleteTempDetail);
                var res = await clsTabletModelObj.insertTempTables(insertVal, ip, detailTableName, RepSerNo, reportOption);
                var calRes = await clsTabletModelObj.calculationFinePer(insertVal, RepSerNo, ip, value, reportType);
                return calRes;

            }
            else {
                var deleteTempMaster = {
                    str_tableName: 'tbl_temp_master',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                var deleteTempDetail = {
                    str_tableName: 'tbl_temp_detail',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                let res1 = await database.delete(deleteTempMaster);
                let delete1 = await database.delete(deleteTempDetail);
                let res = await clsTabletModelObj.insertTempTables(insertVal, ip, detailTableName, RepSerNo, reportOption);
                var calRes = await clsTabletModelObj.calculation(str_resNMT[0][0]['IsNMT'],insertVal, RepSerNo, ip, value, reportType, 2);
              
            }
        }
        // Inserting data to temporary table
        else {
            if (reportOption == 'Differential') {
                var bln_multiComponent = (serverConfig.developerPanelData.MultiComponent.find(x => x.Name === 'Content1').Value == 1)?true:false;
                if(bln_multiComponent)
                {
                    let res = await clsTabletModelObj.insertDiff(insertVal, ip, detailTableName, RepSerNo);
                    var int_dp = insertVal.DecimalPoint;
                    var contentNumber = "";
                    switch (insertVal.NoOfContent) {
                        case 1:
                            contentNumber = "ONE";
                            break;
                        case 2:
                            contentNumber = "TWO";
                            break;
                        case 3:
                            contentNumber = "THREE";
                            break;
                        case 4:
                            contentNumber = "FOUR";
                            break;        
                        default:
                            contentNumber = "";
                            break;
                    }
                    var calResMultiComponent = await objStoredProcedure.getCalculationMultiComponent(RepSerNo, value);
                    var calRes = {
                        'nomFilledCont': Number(calResMultiComponent[2][0]['@nomFilledCont']).toFixed(int_dp),
                        'stdLmt1TxtFilledCont': calResMultiComponent[2][0]['@stdLmt1TxtFilledCont'],
                        'stdLmt2TxtFilledCont': calResMultiComponent[2][0]['@stdLmt2TxtFilledCont'],
                        'lowT1FilledCont': Number(calResMultiComponent[2][0]['@lowT1FilledCont']).toFixed(int_dp),
                        'uppT1FilledCont': Number(calResMultiComponent[2][0]['@uppT1FilledCont']).toFixed(int_dp),
                        'lowT2FilledCont': Number(calResMultiComponent[2][0]['@lowT2FilledCont']).toFixed(int_dp),
                        'uppT2FilledCont': Number(calResMultiComponent[2][0]['@uppT2FilledCont']).toFixed(int_dp),
                        'AverageValueFilledCont': Number(calResMultiComponent[2][0]['@AverageValueFilledCont']).toFixed(int_dp + 1),
                        'minWeightFilledCont': Number(calResMultiComponent[2][0]['@minWeightFilledCont']).toFixed(int_dp),
                        'maxWeightFilledCont': Number(calResMultiComponent[2][0]['@maxWeightFilledCont']).toFixed(int_dp),
                        'minPercentageFilledCont': Number(calResMultiComponent[2][0]['@minPercentageFilledCont']).toFixed(2),
                        'maxPercentageFilledCont': Number(calResMultiComponent[2][0]['@maxPercentageFilledCont']).toFixed(2),
                        'CalStandDevFilledCont': Number(calResMultiComponent[2][0]['@CalStandDevFilledCont']).toFixed(int_dp + 1),
                        'AbvLmt1NoSideFilledCont': Number(calResMultiComponent[2][0]['@AbvLmt1NoSideFilledCont']),
                        'BlwLmt1NoSideFilledCont': Number(calResMultiComponent[2][0]['@BlwLmt1NoSideFilledCont']),
                        'AbvLmt2NoSideFilledCont': Number(calResMultiComponent[2][0]['@AbvLmt2NoSideFilledCont']),
                        'BlwLmt2NoSideFilledCont': Number(calResMultiComponent[2][0]['@BlwLmt2NoSideFilledCont']),
                        'nomTab1': Number(calResMultiComponent[2][0]['@nomTab1']).toFixed(int_dp),
                        'stdLmt1TxtTab1': calResMultiComponent[2][0]['@stdLmt1TxtTab1'],
                        'stdLmt2TxtTab1': calResMultiComponent[2][0]['@stdLmt2TxtTab1'],
                        'lowT1Tab1': Number(calResMultiComponent[2][0]['@lowT1Tab1']).toFixed(int_dp),
                        'uppT1Tab1': Number(calResMultiComponent[2][0]['@uppT1Tab1']).toFixed(int_dp),
                        'lowT2Tab1': Number(calResMultiComponent[2][0]['@lowT2Tab1']).toFixed(int_dp),
                        'uppT2Tab1': Number(calResMultiComponent[2][0]['@uppT2Tab1']).toFixed(int_dp),
                        'AverageValueTab1': Number(calResMultiComponent[2][0]['@AverageValueTab1']).toFixed(int_dp + 1),
                        'minWeightTab1': Number(calResMultiComponent[2][0]['@minWeightTab1']).toFixed(int_dp),
                        'maxWeightTab1': Number(calResMultiComponent[2][0]['@maxWeightTab1']).toFixed(int_dp),
                        'minPercentageTab1': Number(calResMultiComponent[2][0]['@minPercentageTab1']).toFixed(2),
                        'maxPercentageTab1': Number(calResMultiComponent[2][0]['@maxPercentageTab1']).toFixed(2),
                        'CalStandDevTab1': Number(calResMultiComponent[2][0]['@CalStandDevTab1']).toFixed(int_dp + 1),
                        'AbvLmt1NoSideTab1': Number(calResMultiComponent[2][0]['@AbvLmt1NoSideTab1']),
                        'BlwLmt1NoSideTab1': Number(calResMultiComponent[2][0]['@BlwLmt1NoSideTab1']),
                        'AbvLmt2NoSideTab1': Number(calResMultiComponent[2][0]['@AbvLmt2NoSideTab1']),
                        'BlwLmt2NoSideTab1': Number(calResMultiComponent[2][0]['@BlwLmt2NoSideTab1']),
                        'nomTab2': Number(calResMultiComponent[2][0]['@nomTab2']).toFixed(int_dp),
                        'stdLmt1TxtTab2': calResMultiComponent[2][0]['@stdLmt1TxtTab2'],
                        'stdLmt2TxtTab2': calResMultiComponent[2][0]['@stdLmt2TxtTab2'],
                        'lowT1Tab2': Number(calResMultiComponent[2][0]['@lowT1Tab2']).toFixed(int_dp),
                        'uppT1Tab2': Number(calResMultiComponent[2][0]['@uppT1Tab2']).toFixed(int_dp),
                        'lowT2Tab2': Number(calResMultiComponent[2][0]['@lowT2Tab2']).toFixed(int_dp),
                        'uppT2Tab2': Number(calResMultiComponent[2][0]['@uppT2Tab2']).toFixed(int_dp),
                        'AverageValueTab2': Number(calResMultiComponent[2][0]['@AverageValueTab2']).toFixed(int_dp + 1),
                        'minWeightTab2': Number(calResMultiComponent[2][0]['@minWeightTab2']).toFixed(int_dp),
                        'maxWeightTab2': Number(calResMultiComponent[2][0]['@maxWeightTab2']).toFixed(int_dp),
                        'minPercentageTab2': Number(calResMultiComponent[2][0]['@minPercentageTab2']).toFixed(2),
                        'maxPercentageTab2': Number(calResMultiComponent[2][0]['@maxPercentageTab2']).toFixed(2),
                        'CalStandDevTab2': Number(calResMultiComponent[2][0]['@CalStandDevTab2']).toFixed(int_dp + 1),
                        'AbvLmt1NoSideTab2': Number(calResMultiComponent[2][0]['@AbvLmt1NoSideTab2']),
                        'BlwLmt1NoSideTab2': Number(calResMultiComponent[2][0]['@BlwLmt1NoSideTab2']),
                        'AbvLmt2NoSideTab2': Number(calResMultiComponent[2][0]['@AbvLmt2NoSideTab2']),
                        'BlwLmt2NoSideTab2': Number(calResMultiComponent[2][0]['@BlwLmt2NoSideTab2']),
                        'nomTab3': Number(calResMultiComponent[2][0]['@nomTab3']).toFixed(int_dp),
                        'stdLmt1TxtTab3': calResMultiComponent[2][0]['@stdLmt1TxtTab3'],
                        'stdLmt2TxtTab3': calResMultiComponent[2][0]['@stdLmt2TxtTab3'],
                        'lowT1Tab3': Number(calResMultiComponent[2][0]['@lowT1Tab3']).toFixed(int_dp),
                        'uppT1Tab3': Number(calResMultiComponent[2][0]['@uppT1Tab3']).toFixed(int_dp),
                        'lowT2Tab3': Number(calResMultiComponent[2][0]['@lowT2Tab3']).toFixed(int_dp),
                        'uppT2Tab3': Number(calResMultiComponent[2][0]['@uppT2Tab3']).toFixed(int_dp),
                        'AverageValueTab3': Number(calResMultiComponent[2][0]['@AverageValueTab3']).toFixed(int_dp + 1),
                        'minWeightTab3': Number(calResMultiComponent[2][0]['@minWeightTab3']).toFixed(int_dp),
                        'maxWeightTab3': Number(calResMultiComponent[2][0]['@maxWeightTab3']).toFixed(int_dp),
                        'minPercentageTab3': Number(calResMultiComponent[2][0]['@minPercentageTab3']).toFixed(2),
                        'maxPercentageTab3': Number(calResMultiComponent[2][0]['@maxPercentageTab3']).toFixed(2),
                        'CalStandDevTab3': Number(calResMultiComponent[2][0]['@CalStandDevTab3']).toFixed(int_dp + 1),
                        'AbvLmt1NoSideTab3': Number(calResMultiComponent[2][0]['@AbvLmt1NoSideTab3']),
                        'BlwLmt1NoSideTab3': Number(calResMultiComponent[2][0]['@BlwLmt1NoSideTab3']),
                        'AbvLmt2NoSideTab3': Number(calResMultiComponent[2][0]['@AbvLmt2NoSideTab3']),
                        'BlwLmt2NoSideTab3': Number(calResMultiComponent[2][0]['@BlwLmt2NoSideTab3']),
                        'nomTab4': Number(calResMultiComponent[2][0]['@nomTab4']).toFixed(int_dp),
                        'stdLmt1TxtTab4': calResMultiComponent[2][0]['@stdLmt1TxtTab4'],
                        'stdLmt2TxtTab4': calResMultiComponent[2][0]['@stdLmt2TxtTab4'],
                        'lowT1Tab4': Number(calResMultiComponent[2][0]['@lowT1Tab4']).toFixed(int_dp),
                        'uppT1Tab4': Number(calResMultiComponent[2][0]['@uppT1Tab4']).toFixed(int_dp),
                        'lowT2Tab4': Number(calResMultiComponent[2][0]['@lowT2Tab4']).toFixed(int_dp),
                        'uppT2Tab4': Number(calResMultiComponent[2][0]['@uppT2Tab4']).toFixed(int_dp),
                        'AverageValueTab4': Number(calResMultiComponent[2][0]['@AverageValueTab4']).toFixed(int_dp + 1),
                        'minWeightTab4': Number(calResMultiComponent[2][0]['@minWeightTab4']).toFixed(int_dp),
                        'maxWeightTab4': Number(calResMultiComponent[2][0]['@maxWeightTab4']).toFixed(int_dp),
                        'minPercentageTab4': Number(calResMultiComponent[2][0]['@minPercentageTab4']).toFixed(2),
                        'maxPercentageTab4': Number(calResMultiComponent[2][0]['@maxPercentageTab4']).toFixed(2),
                        'CalStandDevTab4': Number(calResMultiComponent[2][0]['@CalStandDevTab4']).toFixed(int_dp + 1),
                        'AbvLmt1NoSideTab4': Number(calResMultiComponent[2][0]['@AbvLmt1NoSideTab4']),
                        'BlwLmt1NoSideTab4': Number(calResMultiComponent[2][0]['@BlwLmt1NoSideTab4']),
                        'AbvLmt2NoSideTab4': Number(calResMultiComponent[2][0]['@AbvLmt2NoSideTab4']),
                        'BlwLmt2NoSideTab4': Number(calResMultiComponent[2][0]['@BlwLmt2NoSideTab4']),
                        'ICReport': calResMultiComponent[2][0]['@ICReport'],
                        'Result': calResMultiComponent[2][0]['@Result'],
                        'UserId': insertVal.UserId,
                        'UserName': insertVal.UserName,
                        'waterMark': true,
                        "rptHeading": `DIFFERENTIAL WEIGHT VARIATION RECORD (${(contentNumber)} CONTENTS IN CAPSULE)`,
                        "HmiId": ip.split('.')[3],
                        "printNo":insertVal.printNo
                    };
                }
                else
                {
                    let res = await clsTabletModelObj.insertDiff(insertVal, ip, detailTableName, RepSerNo);
                    var selectObjRec = await dbCon.execute(`SELECT MAX(RecSeqNo) as RecSeqNo FROM tbl_temp_detaildiff where RepSerNo=${RepSerNo}`);
                    var calResDiff = await objStoredProcedure.getCalculationDiff(RepSerNo, value);
                    var calRes = calResDiff[1][0];
                    var str_mgDP = 0;

                    /**
             *   This change is requested by client : SVP (CRF-40), ML 
             * If unit is "mg" then int_DP = From Developer Panel else as per balance DP
             */ 
                   var int_dp = (insertVal.Unit == "mg") ? Number(str_mgDP) : Number(insertVal.DecimalPoint);
                    
                    var calRes = {
                        'SelectedValue': RepSerNo,
                        'nom': Number(calResDiff[1][0]['@nominal']).toFixed(int_dp),
                        'minWeight': Number(calResDiff[1][0]['@minWeight']).toFixed(int_dp),
                        'maxWeight': Number(calResDiff[1][0]['@maxWeight']).toFixed(int_dp),
                        'minPercentage': calResDiff[1][0]['@minPercentage'],
                        'maxPercentage': calResDiff[1][0]['@maxPercentage'],
                        'AverageValue': math.roundUpPad(calResDiff[1][0]['@average'],int_dp+1),
                        'lowT1': Number(calResDiff[1][0]['@T1Neg']).toFixed(int_dp),
                        'uppT1': Number(calResDiff[1][0]['@T1Pos']).toFixed(int_dp),
                        'lowT2': Number(calResDiff[1][0]['@T2Neg']).toFixed(int_dp),
                        'uppT2': Number(calResDiff[1][0]['@T2Pos']).toFixed(int_dp),
                        'BlwLmt1NoSide': calResDiff[1][0]['@belowLimitT1Count'],
                        'AbvLmt1NoSide': calResDiff[1][0]['@aboveLimitT1Count'],
                        'BlwLmt2NoSide': calResDiff[1][0]['@belowLimitT2Count'],
                        'AbvLmt2NoSide': calResDiff[1][0]['@aboveLimitT2Count'],
                        'CalStandDev': math.roundUpPad(calResDiff[1][0]['@Stdev'],int_dp+1),
                        'Result': calResDiff[1][0]['@result'],
                        'stdLmt1Txt': calResDiff[1][0]['@labelT1'],
                        'stdLmt2Txt': calResDiff[1][0]['@labelT2'],
                        "rptHeading": "DIFFERENTIAL  WEIGHT VARIATION RECORD",
                        "ReqMenu": "",
                        "ToDate": "",
                        "UserId": insertVal.UserId,
                        "UserName": insertVal.UserName,
                        "waterMark": true,
                        "FromDate": "",
                        "HmiId": ip.split('.')[3],
                        "ICReport": reportType,
                        "ReqMenu": "",
                        "SelectedAction": "",
                        "RecSeqNo": selectObjRec[0][0]['RecSeqNo'],
                        "printNo":value.printNo
                    };
                }
            }
            if (reportOption == 'Disintegration Tester') {
                let res = await clsTabletModelObj.insertDTTempTables(insertVal, ip, detailTableName, RepSerNo);
                var calRes = await clsTabletModelObj.calculationDT(insertVal, RepSerNo, ip, value);
                
            }
            else if (reportOption == 'Tapped Density') {
                var calRes = await this.calculationCapDensity(RepSerNo, masterTableName, value, ip);
                return calRes;
            }
            else if (reportOption == 'Length' || reportOption == 'Locked Length' || reportOption == 'Diameter') {
                var res = await clsTabletModelObj.insertTempTables(insertVal, ip, detailTableName, RepSerNo, reportOption);
                var calRes = await clsTabletModelObj.calculationGroupVernier(str_resNMT[0][0]['IsNMT'],insertVal, RepSerNo, ip, value, reportType, detailTableName, 2);
               
             }
            else if (reportOption == 'Group') {
                var res = await clsTabletModelObj.insertGroupTempTables(insertVal, ip, detailTableName, RepSerNo);
                var calRes = await clsTabletModelObj.calculationGroupVernier(str_resNMT[0][0]['IsNMT'],insertVal, RepSerNo, ip, value, reportType, detailTableName, 2);
              
            }
            else if (reportOption == 'Particle Size') {
                var res = await clsTabletModelObj.insertParticalSizeTempTables(insertVal, ip, detailTableName, RepSerNo, 1);
                var calRes = await clsTabletModelObj.calculationParticleSize(insertVal, RepSerNo, ip, value);
                return calRes;

            }else if (reportOption == '% Fine') {
                var res = await clsTabletModelObj.insertTempTables(insertVal, ip, detailTableName, RepSerNo, reportOption);
                var calRes = await clsTabletModelObj.calculationFinePer(insertVal, RepSerNo, ip, value, reportType);
                return calRes;

            }
            else {
                let res = await clsTabletModelObj.insertTempTables(insertVal, ip, detailTableName, RepSerNo, reportOption);
                var calRes = await clsTabletModelObj.calculation(str_resNMT[0][0]['IsNMT'],insertVal, RepSerNo, ip, value, reportType, 2);
               
            }

        }
        Object.assign(calRes,{"RecSeqNo": selectObjRec[0][0]['RecSeqNo']});
        return calRes;

    }

    /**
     *
     * @param {*} RepSerNo Report serial number of Report
     * @param {*} ip Ip of requesting resource
     * @param {*} masterTableName table name
     * @description Calculation for TabDensity %
     */
    calculationCapDensity(RepSerNo, masterTableName, value, ip) {
        return new Promise((resolve, reject) => {
            const objData = {};
            var ipVal = ip.split('.')[3];
            objStoredProcedure.getTabDensity(RepSerNo, masterTableName).then((result) => {
                Object.assign(objData, { SelectedValue: RepSerNo },
                    { UserId: value.userId }, { UserName: value.username }, { result: result[1][0]['@remark'] },
                    { waterMark: true }, { stdLowLimit: result[1][0]['@stdNeg'] }, { stdUppLimit: result[1][0]['@stdPos'] },
                    { bulkStdLowLimit: result[1][0]['@bulkNegLimit'] }, { bulkStdUppLimit: result[1][0]['@bulkPosLimit'] },
                    { tapDensity: result[1][0]['@tapDensity'] }, { bulkDensity: result[1][0]['@bulkDensity'] }, { printNo: Number(value.printNo) });
                resolve(objData);
            }).catch(err => {
                reject(err);
            })
        })
    }

    async getProductDetails(reqObj) {

        var reportOption = reqObj.body.reportOption;
        var fromDate = reqObj.body.fromDate;
        var toDate = reqObj.body.toDate;
        var testType = reqObj.body.testType;
        var reportType = reqObj.body.reportType;
        var recordFrom = reqObj.body.recordFrom;
        var responseObj = {};
        var masterTableName, detailTableName;
        if (testType == 'Regular') {
            testType = 0;
        } else {
            testType = 1;
        }
        switch (reportOption) {
            case 'Individual':
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_cap_master1';
                        detailTableName = 'tbl_cap_detail1'
                    } else {  //archive Complete
                        masterTableName = 'tbl_cap_master1_archived';
                        detailTableName = 'tbl_cap_detail1_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_cap_master1_incomplete';
                        detailTableName = 'tbl_cap_detail1_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case 'Group':
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_cap_master2';
                        detailTableName = 'tbl_cap_detail2'
                    } else {  //archive Complete
                        masterTableName = 'tbl_cap_master2_archived';
                        detailTableName = 'tbl_cap_detail2_archived'
                    }
                }
                break;
            case 'Length':
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_cap_master5';
                        detailTableName = 'tbl_cap_detail5'
                    } else {  //archive Complete
                        masterTableName = 'tbl_cap_master5_archived';
                        detailTableName = 'tbl_cap_detail5_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_cap_master5_incomplete';
                        detailTableName = 'tbl_cap_detail5_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case 'Locked Length':
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_cap_master5';
                        detailTableName = 'tbl_cap_detail5'
                    } else {  //archive Complete
                        masterTableName = 'tbl_cap_master5_archived';
                        detailTableName = 'tbl_cap_detail5_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_cap_master5_incomplete';
                        detailTableName = 'tbl_cap_detail5_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case 'Differential':
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_cap_master3';
                        detailTableName = 'tbl_cap_detail3'
                    } else {  //archive Complete
                        masterTableName = 'tbl_cap_master3_archived';
                        detailTableName = 'tbl_cap_detail3_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_cap_master3_incomplete';
                        detailTableName = 'tbl_cap_detail3_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case 'Diameter':
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_cap_master4';
                        detailTableName = 'tbl_cap_detail4'
                    } else {  //archive Complete
                        masterTableName = 'tbl_cap_master4_archived';
                        detailTableName = 'tbl_cap_detail4_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_cap_master4_incomplete';
                        detailTableName = 'tbl_cap_detail4_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case 'Disintegration Tester':
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_cap_master6';
                        detailTableName = 'tbl_cap_detail6'
                    } else {  //archive Complete
                        masterTableName = 'tbl_cap_master6_archived';
                        detailTableName = 'tbl_cap_detail6_archived'
                    }
                }
                break;
            case 'Moisture Analyzer':
                    if (reportType == 'Complete') {
                        if (recordFrom == 'Current') { //current Complete
                            masterTableName = 'tbl_lodmaster';
                            detailTableName = ''
                        } else {  //archive Complete
                            masterTableName = 'tbl_lodmaster_archived';
                            detailTableName = ''
                        }
                    }
                    break;
            case 'Tapped Density':
                    if (reportType == 'Complete') {
                        if (recordFrom == 'Current') { //current Complete
                            masterTableName = 'tbl_tab_tapdensity';
                            detailTableName = ''
                        } else {  //archive Complete
                            masterTableName = 'tbl_tab_tapdensity_archived';
                            detailTableName = ''
                        }
                    }
                    break;   
            case 'Particle Size':
                        if (reportType == 'Complete') {
                            if (recordFrom == 'Current') { //current Complete
                                masterTableName = 'tbl_cap_master18';
                                detailTableName = 'tbl_cap_detail18'
                            } else {  //archive Complete
                                masterTableName = 'tbl_cap_master18_archived';
                                detailTableName = 'tbl_cap_detail18_archived'
                            }
                        }else {
                            if (recordFrom == 'Current') { // current Incomplete
                                masterTableName = 'tbl_cap_master18_incomplete';
                                detailTableName = 'tbl_cap_detail18_incomplete'
                            } else {
                                // TO - DO for incomplete archive
                            }
                        }
                        break; 
            case '% Fine':
                        if (reportType == 'Complete') {
                            if (recordFrom == 'Current') { //current Complete
                                masterTableName = 'tbl_cap_master17';
                                detailTableName = 'tbl_cap_detail17'
                            } else {  //archive Complete
                                masterTableName = 'tbl_cap_master17_archived';
                                detailTableName = 'tbl_cap_detail17_archived'
                            }
                        }else {
                            if (recordFrom == 'Current') { // current Incomplete
                                masterTableName = 'tbl_cap_master17_incomplete';
                                detailTableName = 'tbl_cap_detail17_incomplete'
                            } else {
                                // TO - DO for incomplete archive
                            }
                        }
                        break;               
        }
        const selectMaster = {
            str_tableName: masterTableName,
            data: '*',
            condition: [
                { str_colName: 'ReportType', value: testType, comp: 'eq' },
                { str_colName: 'ProductType', value: '2', comp: 'eq' },
                { str_colName: 'PrDate', value: fromDate, value1: toDate, comp: 'btn' }
            ]
        }
        const selectDetail = {
            str_tableName: detailTableName,
            data: '*',
        }
        let result = await database.select(selectMaster);
        let data = result[0]
        if(detailTableName != '')
        {
            let detailResult = await database.select(selectDetail);
            for (let i = 0; i < data.length; i++) {
            let RepSerNo = data[i].RepSerNo;
            let details = detailResult[0].find(k => k.RepSerNo == RepSerNo);
            let detailsObj = { 'detail': details };
            Object.assign(data[i], detailsObj);
            }
            Object.assign(responseObj, { status: 'success' }, { result: data });
        }
        else
        {
            Object.assign(responseObj, { status: 'success' }, { result: data });
        }
        
        return responseObj;



    }
    commanFunctionForFindingOutTableName(reportOption, reportType, recordFrom) {
        var masterTableName, detailTableName, strPrintTableName, intWeighmentSrNo;
        switch (reportOption) {
            case 'Individual':
                intWeighmentSrNo = 1;
                strPrintTableName = "tbl_cap_print1";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_cap_master1';
                        detailTableName = 'tbl_cap_detail1'
                    } else {  //archive Complete
                        masterTableName = 'tbl_cap_master1_archived';
                        detailTableName = 'tbl_cap_detail1_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_cap_master1_incomplete';
                        detailTableName = 'tbl_cap_detail1_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case 'Group':
                intWeighmentSrNo = 2;
                strPrintTableName = "tbl_cap_print2";
                
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_cap_master2';
                        detailTableName = 'tbl_cap_detail2'
                    } else {  //archive Complete
                        masterTableName = 'tbl_cap_master2_archived';
                        detailTableName = 'tbl_cap_detail2_archived'
                    }
                }
                break;
            case 'Length':
                intWeighmentSrNo = 5;
                strPrintTableName = "tbl_cap_print5";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_cap_master5';
                        detailTableName = 'tbl_cap_detail5'
                    } else {  //archive Complete
                        masterTableName = 'tbl_cap_master5_archived';
                        detailTableName = 'tbl_cap_detail5_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_cap_master5_incomplete';
                        detailTableName = 'tbl_cap_detail5_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case 'Locked Length':
                intWeighmentSrNo = 5;
                strPrintTableName = "tbl_cap_print5";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_cap_master5';
                        detailTableName = 'tbl_cap_detail5'
                    } else {  //archive Complete
                        masterTableName = 'tbl_cap_master5_archived';
                        detailTableName = 'tbl_cap_detail5_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_cap_master5_incomplete';
                        detailTableName = 'tbl_cap_detail5_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case 'Differential':
                intWeighmentSrNo = 'Differential';
                strPrintTableName = "tbl_cap_print3";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_cap_master3';
                        detailTableName = 'tbl_cap_detail3'
                    } else {  //archive Complete
                        masterTableName = 'tbl_cap_master3_archived';
                        detailTableName = 'tbl_cap_detail3_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_cap_master3_incomplete';
                        detailTableName = 'tbl_cap_detail3_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case 'Diameter':
               
                intWeighmentSrNo = 'Diameter';
                strPrintTableName = "tbl_cap_print4";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_cap_master4';
                        detailTableName = 'tbl_cap_detail4'
                    } else {  //archive Complete
                        masterTableName = 'tbl_cap_master4_archived';
                        detailTableName = 'tbl_cap_detail4_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_cap_master4_incomplete';
                        detailTableName = 'tbl_cap_detail4_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case 'Disintegration Tester':
              
            intWeighmentSrNo = 'DT';
            strPrintTableName = "tbl_cap_print6";
            if (reportType == 'Complete') {
                if (recordFrom == 'Current') { //current Complete
                    masterTableName = 'tbl_cap_master6';
                    detailTableName = 'tbl_cap_detail6'
                } else {  //archive Complete
                    masterTableName = 'tbl_cap_master6_archived';
                    detailTableName = 'tbl_cap_detail6_archived'
                }
            }
            break;
            case 'Moisture Analyzer':
                intWeighmentSrNo = 16;
                strPrintTableName = "tbl_tab_print16";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_lodmaster';
                        detailTableName = ''
                    } else {  //archive Complete
                        masterTableName = 'tbl_lodmaster_archived';
                        detailTableName = ''
                    }
                }
            break;
            case 'Tapped Density':
                intWeighmentSrNo = 15;
                strPrintTableName = "tbl_tab_print15";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_tab_tapdensity';
                        detailTableName = ''
                    } else {  //archive Complete
                        masterTableName = 'tbl_tab_tapdensity_archived';
                        detailTableName = ''
                    }
                }
                break;
            case 'Particle Size':
                intWeighmentSrNo = 18;
                strPrintTableName = "tbl_cap_print18";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_cap_master18';
                        detailTableName = 'tbl_cap_detail18'
                    } else {  //archive Complete
                        masterTableName = 'tbl_cap_master18_archived';
                        detailTableName = 'tbl_cap_detail18_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_cap_master18_incomplete';
                        detailTableName = 'tbl_cap_detail18_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case '% Fine':
                intWeighmentSrNo = 17;
                strPrintTableName = "tbl_cap_print17";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_cap_master17';
                        detailTableName = 'tbl_cap_detail17'
                    } else {  //archive Complete
                        masterTableName = 'tbl_cap_master17_archived';
                        detailTableName = 'tbl_cap_detail17_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_cap_master17_incomplete';
                        detailTableName = 'tbl_cap_detail17_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
        }
        return {
            masterTableName: masterTableName, detailTableName: detailTableName, strPrintTableName: strPrintTableName, intWeighmentSrNo: intWeighmentSrNo
        }

    }

}


module.exports = CapsuleProduct
