const PDFMerge = require('pdf-merge');
const fs = require('fs');
var path = require('path')
const process = require('process');
const Database = require('../database/clsQueryProcess');
const database = new Database();
const date = require('date-and-time')

class MergePDFModel {
    checkForPDFtk()
    {
        if(process.env.path.match(/PDFtk/g)==null)
        return false;
        else
        return true;
    }
    sanitizeInput(sarr_filesArray)
    {
        if(this.checkForPDFtk)
        {
            if(Array.isArray(sarr_filesArray))
            {
                let count = 0;
                sarr_filesArray.forEach(element => {
                    if (!path.extname(element)) {
                        return ("Argument 1 : File Name path is incorrect");
                    }else { count++; }
                });
                if(count==sarr_filesArray.length)
                {
                    return ("Success");
                }
            }
            else
            {
                return ("Argument 1 : File Name is not array");
            }
        }
        else
        {
            return ("PDFtk is NOT INSTALLED Correctly");
        }
    }

    async mergePDF(sarr_filesArray,str_outputPath)
    {
        try {
            if(this.sanitizeInput(sarr_filesArray)=="Success")
            {
                //Save as new file
                try {
                    const obj_getPath = {
                        str_tableName: 'tbl_rpt_path',
                        data: '*',
                    }
                    var result1 = await database.select(obj_getPath);
                    var proj_name = result1[0][0]['path'];
                    let str_path = proj_name.split("\\").slice(0,-7).join('\\');
                    var temp_arr=[];
                    sarr_filesArray.forEach(element => {
                        temp_arr.push(str_path+'\\reports\\\\'+element);
                    });
                    sarr_filesArray = temp_arr;
                    var now = new Date();
                    var dtTime = date.format(now, 'DD-MM-YYYY HH:mm:ss');

                    database.createTextFile('txtPathSummaryOutput.txt',str_path+"\\reports\\\\"+str_outputPath)
                  
                    fs.unlink(str_path+"\\reports\\\\"+str_outputPath, async (err) => {
                    if (!err) {
                        let result = await PDFMerge(sarr_filesArray, {output: str_path+"\\reports\\\\"+str_outputPath});
                        return "Success";
                    }
                    })

                   // fs.closeSync();
                    let result = await PDFMerge(sarr_filesArray, {output: str_path+"\\reports\\\\"+str_outputPath});
                    console.log("Success");
                    return "Success";
                } catch (error) {
                    console.log(error)
                    return "Error in Merging Files";
                }
            }
            else
            {
                console.log("Unable");
                return 'Unable to Merge Files..';
            }
        } catch (error) {
            console.log(error);
        }
        
    }
}
module.exports = MergePDFModel;