const math = require('mathjs');

class MathJS {

    /**
     * roundUp(x,y) is used to round up number upto decimal place provided
     * @param {any} inputNumber | Number to be roud up 
     * @param {any} decimalPoint | (Optional) Number of decimals to allow
     * @returns {Number} Rounded-Up number. If decimalPoint is not specified then returns the same number.
     */
    roundUp(inputNumber,decimalPoint = 999)
    {
        if(math.number(decimalPoint) != 999)
        {
            // decimalPoint passed to function
            return math.round(math.number(inputNumber),math.round(decimalPoint));
        }
        else
        {
            // No decimalPoint passed to function
            return math.number(inputNumber);
        }
    }

    /**
     * roundUpPad(x,y) is used to round up number to fixed decimal length. If decimalPoint is not specified then returns number with 1 decimal.
     * @param {any} inputNumber | Number to be roud up 
     * @param {any} decimalPoint (Optional) Number of decimals to allow
     * @returns {Number} Rounded-Up number with padding (If reqired)
     */
    roundUpPad(inputNumber,decimalPoint = 999)
    {
        if(math.number(decimalPoint) != 999)
        {
            // decimalPoint passed to function
            return math.format(math.number(inputNumber),{notation: 'fixed', precision: math.round(decimalPoint)});
        }
        else
        {
            // No decimalPoint passed to function
            return math.format(math.number(inputNumber),{notation: 'fixed', precision: 1});
        }
    }
    /**
     *  truncateDecimal(x,y) is used to truncate number at certain position. This function will not use any rouding function provided by Math.js
     * @param {*} inputNumber | Number to be trucated 
     * @param {*} decimalPoint (Optional) Number of decimals to show
     * @returns {Number} Truncated number with padding (If reqired)
     */
    truncateDecimal(inputNumber,decimalPoint = 999)
    {
        if(inputNumber.toString().indexOf(".") === -1)
        {
            return inputNumber;
        }
        else
        {
            if(decimalPoint != 999 || decimalPoint!=0)
            {
                if(inputNumber.toString().split(".")[1].length === Number(decimalPoint))
                {
                    return Number(inputNumber);
                }
                else if(inputNumber.toString().split(".")[1].length > Number(decimalPoint))
                {
                    return Number(inputNumber.toString().split(".")[0] + "." +inputNumber.toString().split(".")[1].slice(0,Number(decimalPoint)));
                }
                else
                {
                    return Number(inputNumber.toFixed(decimalPoint));
                }
            }
            else
            {
                return Number(inputNumber);
            }
        }
    }
}
module.exports = MathJS;