const date = require('date-and-time');
const models = require("../dbConnection").models;
const seqTransaction = require("../dbConnection");
const {Op} = require("sequelize");
const sequelize = require('./../dbConnection').sequelize;
const serverConfig = require('../global/serverConfig');

class AreaSetting {

    async getAuditArea() {
        try {
            let result = await models.tbl_audit_areasetting.findAll({attributes:['Area']});
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }
    
    /**
     * this function is used to get IDS No to show in dropdown list
     */
    async getIDS() {
        try {
            let result = await models.tbl_rpi.findAll();
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

     /**
     * this function is used to get Cubicle Name to show in dropdown list
     */
    async getCubicleName(str_area) {
        try {
            let result = await models.tbl_cubical.findAll({
                attributes: [sequelize.fn('DISTINCT', sequelize.col('Sys_CubicName'))],
                where: {
                    Sys_Area: str_area.Area,
                    Sys_CubicName: {[Op.ne]: 'NULL'}
                }
            });
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }
 
      /**
     * this function is used to update instrument detail in respective table
     */
    async updateAllAreaRef(res) {
        try {
            var obj_response = {};
            let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                let now = new Date();
                // update child cubicle if exist

                var getOldCubicleName = await models.tbl_cubical.findAll({
                    attributes: [sequelize.fn('DISTINCT', sequelize.col('Sys_CubicName'))],
                    where: {Sys_CubicNo:res.Sys_CubicNo},
                    transaction: t
                });
                let updateObj = {
                    Sys_Area: res.Sys_Area,
                    Sys_RptType: res.Sys_RptType,
                    Sys_Batch_Status: res.Sys_Batch_Status,
                    Sys_DSNumber: res.Sys_DSNumber,
                    Sys_CubicName: res.Sys_CubicName,
                    Sys_IDSNo: res.Sys_IDSNo,
                    Sys_MachineCode: res.Sys_MachineCode,
                    Sys_CubType: res.Sys_CubType,
                    Sys_cubTypes: res.Sys_cubTypes,
                    Sys_Batch: res.Sys_Batch.trim().length == 0 ? 'NULL' : res.Sys_Batch.trim(), //If user enter empty string for the batch store "NULL" in the database
                    Sys_rpi: (res.Sys_IDSNo == "NA") ? 'NULL' : res.Sys_rpi,
                    isPreStart: res.isPreStart,
                    ToggleSample: 0
                }
                if (serverConfig.plant == 'PUI' && res.Sys_Area.includes('Compression')) {
                    Object.assign(updateObj, { MesTestType: res.Sys_Batch_Status });
                }
                if (res.Sys_Area.match(/Nasal | Packing/gi)) Object.assign(updateObj, { MesTestType: res.Sys_Batch_Status });
                await models.tbl_cubical.update(updateObj, {
                    where: { Sys_CubicNo: res.Sys_CubicNo },
                    transaction: t
                });

                await models.tbl_cubicle_bin_setting.update({
                    Sys_CubicName: res.Sys_CubicName,
                    Sys_IDSNo: res.Sys_IDSNo,
                    Sys_CubicleType: res.Sys_CubType,
                },{
                    where: {Sys_CubicNo:res.Sys_CubicNo},
                    transaction: t
                });
                  
                await models.tbl_system_weighingstatus.update({
                    Sys_CubicName: res.Sys_CubicName
                },{
                    where: {CubicleNo: res.Sys_CubicNo},
                    transaction: t
                });

                await models.tbl_calibration_status.update({
                    Sys_Area: res.Sys_Area,
                    Sys_CubicName: res.Sys_CubicName
                },{
                    where: {Cubicle:res.Sys_CubicNo},
                    transaction: t
                });


                await models.tbl_calibration_status_bin.update({
                    Sys_Area: res.Sys_Area,
                    Sys_CubicName: res.Sys_CubicName
                },{
                    where: {Cubicle:res.Sys_CubicNo},
                    transaction: t
                });


                await models.tbl_cubicle_product_sample.update({
                    Sys_Area: res.Sys_Area,
                    Sys_CubicName: res.Sys_CubicName,
                    Sys_rpi: (res.Sys_IDSNo == "NA") ? 'NULL' :  res.Sys_rpi
                },{
                    where: {Sys_CubicNo:res.Sys_CubicNo},
                    transaction: t
                });


                await models.tbl_alert_param_duration.update({
                    Sys_Area: res.Sys_Area,
                    Sys_CubicName: res.Sys_CubicName
                },{
                    where: {CubicNo:res.Sys_CubicNo},
                    transaction: t
                });

                await models.tbl_recalibration_balance_status.update({
                    Sys_Area: res.Sys_Area,
                    Sys_CubicName: res.Sys_CubicName
                },{
                    where: {CubicNo:res.Sys_CubicNo},
                    transaction: t
                });


                await models.tbl_recalibration_balance_status_bin.update({
                    Sys_Area: res.Sys_Area,
                    Sys_CubicName: res.Sys_CubicName
                },{
                    where: {CubicNo:res.Sys_CubicNo},
                    transaction: t
                });

                

                await models.tbl_recalibration_vernier_status.update({
                    Sys_Area: res.Sys_Area,
                    Sys_CubicName: res.Sys_CubicName
                },{
                    where: {CubicNo:res.Sys_CubicNo},
                    transaction: t
                });

                if(res.isAreaNameChanged){
                    var BalID = await models.tbl_cubical.findOne({
                        attributes: ['Sys_BalID'],
                        where: { Sys_CubicNo: res.Sys_CubicNo },
                        transaction: t
                    });
                    if(BalID?.Sys_BalID && BalID?.Sys_BalID!='NULL' && BalID?.Sys_BalID!='None'){
                        await models.tbl_balance.update({
                            Bal_ChangeWt: 1,
                        }, {
                            where: { Bal_ID: BalID.Sys_BalID },
                            transaction: t
                        });
                    }
  
                }

                

                await models.tbl_audit_areasetting.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: res.userid,
                    username: res.username,
                    Remark: res.Remark,
                    Act: res.Act,
                    Area: res.Sys_Area,
                    OldData: res.OldData,
                    NewData: res.NewData,
                    ISIDSSetting: (res.Setting == "Area") ? 1 : 0
                },
                {
                    transaction: t
                });

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: res.userid,
                    username: res.username,
                    activity: res.activitylog
                },
                {
                    transaction: t
                });

                if(res.Sys_Batch != res.Sys_OldBatch){
                    await models.tbl_batch_log.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: res.userid,
                        BatchNo: res.Sys_Batch,
                        username: res.username,
                        activity: 'Area Setting - Batch Start'
                    },{ transaction: t})


                    //since use cant pause the batch directly creating new batch entry
                    await models.tbl_batches.create({
                        Batch: res.Sys_Batch,
                        CubicNo: res.Sys_CubicNo,
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        cubicleType: res.Sys_CubType,
                        batchStatusInCubicle: 'Assigned',Status: 'S',
                        BatchStartDTTM: date.format(now, 'YYYY-MM-DD HH:mm:ss')
                    },{
                        transaction : t
                    })
                }
            });

            Object.assign(obj_response, { status: 'success' }, { result: res.Setting + ' Setting Updated Successfully' });
            return obj_response;

        } catch (error) {
            console.log("Update Area",error);
            throw error;
        }
    }

    /**
     * For Ending Batch
     * @Table {`endBatchWithAuditEntries`} Make cubicle entry and audit entries 
     * @Table {`changeBatchStatusForWgmtTab`} Set Batch Completed to True for all Tablet report for that batch
     * @Table {`changeBatchStatusForWgmtCap`} Set Batch Completed to True for all Capsule report for that batch
     * @Table {`changeBatchStatusForBatchSummery`} set Batch Completed to True for all Batch Summery Report.
     * @param {*} objBatchInfo
     * @returns
     * @memberof CubicleModel
     */
    async endBatch(objBatchInfo) {
        try {
            let transaction = await seqTransaction.sequelize.transaction(async (t) =>{

                let cubicalData = await models.tbl_cubical.findAll({where : { Sys_CubicNo: objBatchInfo.Sys_CubicNo }})

                /** NOt remove tcondition
                 var checkEndStatus = await models.tbl_mes_data.findAll({where : {
                 BatchID : objBatchInfo.Batch
                        isSetInCubical: 0,
                        DS_Number : cubicalData[0].Sys_DSNumber
                    }});

                 if(checkEndStatus.length > 0){
                    // return `${checkEndStatus.length} MES Request is Pending.`
                    return 'Batch End Successfully';
                    }
                 */

                

                // await models.tbl_mes_data.destroy({where : {
                //     // isSetInCubical: 0,
                //     BatchID : objBatchInfo.Batch
                // }});


                var resEnd = await this.endBatchOtherTables(objBatchInfo,t,cubicalData);
                var resFlag_TabletCapsule = await this.changeBatchStatusForWgmtTabCap(objBatchInfo,t);
                var resFlag_Summary = await this.changeBatchStatusForBatchSummery(objBatchInfo,t);
                console.log(`BATCH ENDED ${objBatchInfo.Batch}`);


                if (resEnd == "Commit" && resFlag_TabletCapsule == "Commit" && resFlag_Summary == "Commit") {
                    return "Batch End Successfully";
                }else{
                    return "Something went Wrong";
                }
            });

            return transaction;
        } catch (error) {
            console.log("Cubicle End",error);
            throw error;
        }
    }

    /**
     * This function will Make audit entries and change the batch status in tables 
     * @param {*} objBatchInfo Object which is recived by Angular 
     * @returns return a transaction commited or not commited status.
     * @memberof CubicleModel
     */
    async endBatchOtherTables(objBatchInfo,t,cubicalData) {
        try {
            // let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                var now = new Date();
                await models.tbl_batches.update({
                    Status:  "E",
                    batchStatusInCubicle:  'NA',
                    BatchEndDTTM:  date.format(now, 'YYYY-MM-DD HH:mm:ss')
                },{where:
                    {
                        Status: {[Op.ne]:"E"},
                        Batch: objBatchInfo.Batch,
                        CubicNo: objBatchInfo.Sys_CubicNo,
                    },
                    transaction: t
                });

                // await models.tbl_mes_data.destroy({
                //     where:{
                //         BatchID: objBatchInfo.Batch
                //     },
                //     transaction: t
                // });

                // update parent and child cubicle
                await models.tbl_cubical.update({
                        Sys_RptType: 0,
                        Sys_RotaryType: "Single",
                        Sys_BFGCode: "NULL",
                        Sys_ProductName: "NULL",
                        Sys_Version: "NA",
                        Sys_PVersion: "NA",
                        Sys_media: "NA",
                        Sys_Batch: "NULL",
                        Sys_Stage: "NA",
                        Sys_BatchSize: 0,
                        Sys_BatchSizeUnit: "Unit",
                        Sys_dept: "NA",
                        Sys_IPQCType: "NA",
                        Sys_PrinterName: "NA",
                        Sys_Validation: 0,
                        Sys_BatchReuse: 0,
                        Sys_MachineSpeed_Min:'NULL',
                        Sys_MachineSpeed_Max:'NULL',
                        Sys_SFOID: 'NULL',
                        Sys_Repetition: 0 ,
                        Sys_MPNCode: 'NULL',
                        isManua1: false,
                        MesTestType: 'NULL',
                        MesSide: 'NULL',
                        Sys_Batch_Status: 'NULL'
                },{where:
                    {
                        // Sys_CubicName: objBatchInfo.Sys_CubicName,
                        // Sys_Area: objBatchInfo.Sys_Area,
                        // Sys_CubType: objBatchInfo.Sys_CubicType
                        Sys_CubicNo: objBatchInfo.Sys_CubicNo
                    },
                    transaction: t
                });

                 // update parent and child cubicle
                 await models.tbl_alert_param_duration.update({
                    ProductId: 'NULL',
                    ProductName: 'NULL',
                    ProductVersion: 'NA',
                    Version: 'NA',
                    Batch: 'NULL',
                    Individual:0,
                    Group:0,
                    Thickness:0,
                    Breadth:0,
                    Diameter:0,
                    Length:0,
                    Hardness:0,
                    IndLay:0,
                    GrpLay:0,
                    IndLay1:0,
                    GrpLay1:0,
                    Differential:0
                    },{where:
                        {
                            // Sys_CubicName: objBatchInfo.Sys_CubicName,
                            // Sys_Area: objBatchInfo.Sys_Area
                            CubicNo: objBatchInfo.Sys_CubicNo
                        },
                        transaction: t
                    });

                     // update parent and child cubicle
                 await models.tbl_cubicle_product_sample.update({
                        Sys_BFGCode:'NULL',
                        Sys_ProductName:'NULL',
                        Sys_PVersion:'NA',
                        Sys_Version:'NA',
                        Sys_Batch : 'NULL',
                        Individual: 0,
                        Group: 0,
                        Hardness: 0,
                        DT:0,
                        Friability:0
                    },{where:
                        {
                            // Sys_CubicName: objBatchInfo.Sys_CubicName,
                            // Sys_Area: objBatchInfo.Sys_Area
                            Sys_CubicNo: objBatchInfo.Sys_CubicNo
                        },
                        transaction: t
                    });
            
                        let mesRes=await models.tbl_mes_data.destroy({ 
                        where : { 
                            BatchID : objBatchInfo.Batch, 
                            // Repetition : cubicalData[0].Sys_Repetition,
                            // DS_Number: cubicalData[0].Sys_DSNumber,
                            // isSetInCubical: 1
                        },
                        transaction : t
                    });
                    console.log(`${mesRes} MES DATA DELETED FOR ${objBatchInfo.Batch}`);
                    
    
                    await models.tbl_menu_sequence.destroy({
                        where : {
                            DS_Number: cubicalData[0].Sys_DSNumber
                        },
                        transaction: t
                    })


                    await models.tbl_audit_cubicle.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: objBatchInfo.userid,
                        username: objBatchInfo.username,
                        ACT: objBatchInfo.Action,
                        Remark: objBatchInfo.Remark,
                        CubicleNo: objBatchInfo.Sys_CubicNo,
                        OldData: objBatchInfo.str_oldData,
                        NewData: "NA",
                        CubName: objBatchInfo.Sys_CubicName,
                        Area: objBatchInfo.Sys_Area
                    },{
                        transaction: t
                    });

                    await models.tbl_audit_areasetting.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: objBatchInfo.userid,
                        username: objBatchInfo.username,
                        Remark: objBatchInfo.Remark,
                        Act: objBatchInfo.Action,
                        Area: objBatchInfo.Sys_Area,
                        OldData: objBatchInfo.str_oldData,
                        NewData: "NA",
                        ISIDSSetting: (objBatchInfo.Setting == "Area") ? 1 : 0
                    },
                    {
                        transaction: t
                    });

                    await models.tbl_activity_log.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: objBatchInfo.userid,
                        username: objBatchInfo.username,
                        activity: objBatchInfo.activity
                    },{
                        transaction: t
                    });

                    //updating Batch End
                    await models.tbl_batch_log.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: objBatchInfo.userid,
                        BatchNo: objBatchInfo.Batch,
                        username: objBatchInfo.username,
                        activity: objBatchInfo.activity
                    },{ transaction: t})

            // });

            return "Commit";
        } catch (error) {
            console.log("error",error);
            throw error;
        }
    }

    /**
     * This function will change the batch completed status in every weighment table 
     * for Only `Tablets` and only for those record whose `batchno` is matched
     * @param {*} objBatch Batch no for which `Batch completed` needs to be changed
     * @returns Promise Whether transaction is commited or not
     * @memberof CubicleModel
     */
    async changeBatchStatusForWgmtTabCap(objBatch,t) {
        try {
            // let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                 /** Tablet */
                for (const i of [1,2,3,4,5,6,7,9,10,11,12,13,"htd","leak",'LOD',"initial"]) {
                    // for (const i of [1,2,"htd"]) {
                    if(i == "htd")
                    {
                        await models.tbl_tab_masterhtd.update({
                            BatchComplete: 1
                        },{where:
                            {  
                                BatchNo: objBatch.Batch,
                                CubicleType: objBatch.Sys_CubicType
                            },
                            transaction: t
                        });
                    }else if(i == "leak"){
                        await models.tbl_leakedtest_master.update({
                            BatchComplete: 1
                        },{where:
                            {  
                                BatchNo: objBatch.Batch,
                                CubicleType: objBatch.Sys_CubicType
                            },
                            transaction: t
                        });
                    }else if( i == "initial"){
                        await models.tbl_tab_initialmaster.update({
                            BatchComplete: 1
                        },{where:
                            {  
                                BatchNo: objBatch.Batch,
                                CubicleType: objBatch.Sys_CubicType
                            },
                            transaction: t
                        });
                    }else if( i == "LOD"){
                        await models.tbl_lodmaster.update({
                            BatchComplete: 1
                        },{where:
                            {  
                                BatchNo: objBatch.Batch,
                                CubicleType: objBatch.Sys_CubicType
                            },
                            transaction: t
                        });
                    }
                    else
                    {
                        await models['tbl_tab_master'+i].update({
                            BatchComplete: 1
                        },{where:
                            {  
                                BatchNo: objBatch.Batch,
                                CubicleType: objBatch.Sys_CubicType
                            },
                            transaction: t
                        });
                    }
                   
                }

                /**Capsule */
                for (const i of [1,2,3,4,5,6,"initial"]) {
                        if(i == "initial"){
                            await models.tbl_cap_initialmaster.update({
                            BatchComplete: 1
                        },{where:
                            {  
                                BatchNo: objBatch.Batch,
                                CubicleType: objBatch.Sys_CubicType
                            },
                            transaction: t
                        });
                        } else {
                            await models['tbl_cap_master'+i].update({
                            BatchComplete: true
                        },{where:
                            {  
                                BatchNo: objBatch.Batch,
                                CubicleType: objBatch.Sys_CubicType
                            }
                        },{
                            transaction: t
                        });
                        }
                }
            // });

            return "Commit";
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    /**
     * Change Batch Complete to all batch summery tables 
     * `BatchSummery1 to 16`
     * @param {*} strBatch Batch Name for which batch summery needs to be change 
     * @returns Promise When all queries execued successfully.
     * @memberof CubicleModel
     */
    async changeBatchStatusForBatchSummery(strBatch,t) {
        try {
            var now=new Date();
            // let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                // for (const i of [1,"hdlb"]) {
                for (const i of [1,2,3,4,5,6,7,8,9,10,11,12,13,19,"htd",'LOD',"2_Coating","diff"]) {
                    if(i == "diff")
                    {
                        await models.tbl_batchsummary_masterdiff.update({
                            EndDate: date.format(now, 'DD.MM.YYYY HH:mm:ss'),
                            BatchCompleted: 1
                        },{
                            where:{ BatchNo: strBatch.Batch },
                            transaction: t
                        });
                    }
                    else if(i == "hdlb")
                    {
                        await models.tbl_batchsummary_master_hdlb.update({
                            EndDate: date.format(now, 'DD.MM.YYYY HH:mm:ss'),
                            BatchCompleted: 1,
                        },{
                            where:{ BatchNo: strBatch.Batch },
                            transaction: t
                        });
                    }
                    else
                    {
                        await models['tbl_batchsummary_master' + i].update({
                            EndDate: date.format(now, 'DD.MM.YYYY HH:mm:ss'),
                            BatchCompleted: 1
                        },{
                            where: { BatchNo: strBatch.Batch },
                            transaction: t
                        });
                    }
                    
                }
                await models['tbl_batchsummary_master'].update({
                    EndDate: date.format(now, 'DD.MM.YYYY HH:mm:ss'),
                    BatchCompleted: 1
                },{
                    where: { BatchNo: strBatch.Batch },
                    transaction: t
                });
            // });
            
           return "Commit"; 
        } catch (error) {
            console.log("error",error);
            throw error;
        }
    }

}

module.exports = AreaSetting;