const date = require('date-and-time');
// const sequelize = require('sequelize');
const models = require("../dbConnection").models;
const sequelize = require("../dbConnection").sequelize;

class ActivityLog{
    async storeActivity(value){
        try {
            let obj_response = {};
            let now = new Date();
            let result = await models.tbl_activity_log.create({
                dt:date.format(now, 'YYYY-MM-DD'),
                tm:date.format(now, 'HH:mm:ss'),
                userid:value.userid,
                username:value.username,
                activity:value.activity
            });

            obj_response = { status: 'success' };
            return obj_response;
        } catch (error) {
            return error;
        }

   
    }

    async getBatchLogDetails() {
        try {
            let result = await models.tbl_batch_log.findAll({
                attributes: [
                    [sequelize.fn('DISTINCT', sequelize.col('BatchNo')), 'BatchNo']
                ]
            });
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }
}
module.exports = ActivityLog;