const util = require("util");
const multer = require("multer");
const maxSize = 10 * 1024 * 1024;
let storage = multer.diskStorage({

	destination: (req, file, cb) =>
	{
		let folder_name = file.mimetype == "application/pdf" ? 'instrument_certifcates' : 'Debug'
		cb(null, `${__basedir}/API/${folder_name}/`);
	},
	filename: (req, file, cb) =>
	{
		cb(null, file.originalname);
	},
});

let uploadFile = multer({
	storage: storage,
	limits: { fileSize: maxSize },
}).single("file");

let uploadFileMiddleware = util.promisify(uploadFile);
module.exports = uploadFileMiddleware;