const bcrypt = require('bcrypt');
const crypto = require('crypto');
const algorithm = "aes-192-cbc";
const keySh = 'TANTRA@123'

class Encrypter {
  
  constructor(encryptionKey) {
    this.algorithm = "aes-192-cbc";
    this.key = crypto.scryptSync(encryptionKey, "salt", 24);
  }
  
  encrypt(clearText) {
    const iv = crypto.randomBytes(16);
    console.log("key is", this.key)
    const cipher = crypto.createCipheriv(this.algorithm, this.key, iv);
    const encrypted = cipher.update(clearText, "utf8", "hex");
    return [
      encrypted + cipher.final("hex"),
      Buffer.from(iv).toString("hex"),
    ].join("|");
  }

  dencrypt(encryptedText) {
    const [encrypted, iv] = encryptedText.split("|");
    if (!iv) throw new Error("IV not found");
    const decipher = crypto.createDecipheriv(
      this.algorithm,
      this.key,
      Buffer.from(iv, "hex")
    );
    return decipher.update(encrypted, "hex", "utf8") + decipher.final("utf8");
  }
}
const saltRound = 10;
const encrypt = new Encrypter(keySh);


// Hash a password  For Future use
module.exports.hashing = async (key) =>
    new Promise((resolve,reject) => {
        bcrypt.genSalt(saltRound).then((salt) => {
            console.log(salt);
            bcrypt.hash(key,salt).then((value) => {
                console.log(value)
                resolve(value);
            }).catch(err => { 
                console.log(err);
                reject(err)
            })
        }).catch( err => { 
            console.log(err);
            reject(err)
        })  
    })

    //comparing hash witha value;
module.exports.comparing = async (password,hash) => new Promise((resolve,reject) => {
    // Compare a password with its hash
    bcrypt.compare(password, hash).then((value) => {
        console.log(value);
        resolve(value);
    }).catch(err => {
        console.log(err);
        reject(err);
    });
})
  

/**
 * 
 * @param {*} key Actual Value 
 * @returns chyper text
 */
module.exports.encoding = async (key) => encrypt.encrypt(key);
/**
 * 
 * @param {*} _chypertText chyper value
 * @returns original Text
 */
module.exports.decoding = (_chypertText) => encrypt.dencrypt(_chypertText);


  

  