const dbCon = require('../../API/Utills/db');
const fs = require('fs');
const date = require('date-and-time');
const { typeOf } = require('mathjs');

class QueryProcess {
    constructor() {
        this.arr_updateData;
    }

    /**
     * @param insertObj 
     * @description Function saves data in the database but object should be in the `Below` form
    * ```ts
    * { 
    *   str_tableName: String //Table Name
    *   data:Array<[ // Data to be save
    *   {str_colName:String, value:String},... //Column name followed by its value
    *   ]>
    * }
    * ```
    * @summary Function creates the dynamic query` for the saving data
    */
    save(insertObj, returnQry = false) {
        // console.log(insertObj)
        return new Promise((resolve, reject) => {
            // fetching columNames and data associated with them from object as from of array
            const data = insertObj.data;
            var columNames = "";
            // array for values to be inserted
            var arr_Values = [];
            // variable for hoding  ? (for prepared statement)
            var str_dummyVar = "";
            for (let i = 0; i < data.length; i++) {
                // concating columnames one by one
                columNames = columNames + data[i].str_colName + ",";
                str_dummyVar = str_dummyVar + "?,"
                arr_Values.push(data[i].value)
            }
            // removing last , from string 
            columNames = columNames.slice(0, -1);
            str_dummyVar = str_dummyVar.slice(0, -1);
            if (returnQry == true) {
                var Qry = `INSERT INTO ${insertObj.str_tableName} (${columNames}) VALUES (${str_dummyVar})`;
                var objReturn = {
                    Qry: Qry,
                    values: arr_Values
                }

                resolve(objReturn);
            }
            else {
                dbCon.execute(`INSERT INTO ${insertObj.str_tableName} (${columNames}) VALUES (${str_dummyVar})`, arr_Values).then(result => {
                    resolve(result)
                }).catch(err => {
                    console.log(err)
                    reject(err);
                })
            }

        })
    }

    async saveSP(insertObj) {
        const connection = await dbCon.getConnection();
        try {

            await connection.query('START TRANSACTION');
            var res1 = await connection.execute(insertObj.Query1, insertObj.Value1);
            insertObj.Value2[0] = res1[0].insertId;
            var res2 = await connection.execute(insertObj.Query2,insertObj.Value2);

            await connection.commit();
            await connection.release();

            return res2;
        } catch (e) {
            console.log(e);
            await connection.query('ROLLBACK');
            await connection.release();
        }
    }


    /**
     * @param selectPrecalibSelWtObj
     * @description Function select data from the database but object should be in the `Below` form
    * ```ts
    * {
    *   str_tableName: String //Table Name
    *   data:Array<[ // Data to be select
    *   {str_colName:String, value:String},... //Column name followed by its value
    *   ]> // If we want to select specific fields
    *   // OR
    *   data:'*', //If we want to select *
    *   condition:Array<[ //Where condition
    *   {str_colName:String, value:String, comp:String},... //Column name followed by 
    *   // its value
    *   ]>
    * }
    * ```
    * @summary Function creates the dynamic query` for the selecting data
    */
    select(selectPrecalibSelWtObj) {
        return new Promise((resolve, reject) => {
            // which parameter has to select like * or any field
            var data = selectPrecalibSelWtObj.data;
            // fetching tableName
            var str_tableName = selectPrecalibSelWtObj.str_tableName;
            var str_condition = "";
            var str_order = "";
            // If select statement has where condition
            if (selectPrecalibSelWtObj.hasOwnProperty('condition')) {
                str_condition = "WHERE "
                for (let i = 0; i < selectPrecalibSelWtObj.condition.length; i++) {
                    var operator = '=';
                    switch (selectPrecalibSelWtObj.condition[i].comp) {
                        case 'eq': operator = '='; break;
                        case 'ne': operator = '!='; break;
                        case 'lt': operator = '<'; break;
                        case 'lte': operator = '<='; break;
                        case 'gt': operator = '>'; break;
                        case 'gte': operator = '>='; break;
                        case 'btn': operator = 'BETWEEN'
                    }
                    if (operator == 'BETWEEN') {
                        str_condition = str_condition + `(${selectPrecalibSelWtObj.condition[i].str_colName} BETWEEN  '${selectPrecalibSelWtObj.condition[i].value}' AND '${selectPrecalibSelWtObj.condition[i].value1}')  AND `
                    } else {
                        str_condition = str_condition + selectPrecalibSelWtObj.condition[i].str_colName + " " + operator + " '" + selectPrecalibSelWtObj.condition[i].value + "' AND "
                    }
                }
                // removing last , OR  AND from string 
                str_condition = str_condition.slice(0, -5)
            }
            if (selectPrecalibSelWtObj.hasOwnProperty('order')) {
                str_order = `ORDER BY ${selectPrecalibSelWtObj.order[0].str_colName} ${selectPrecalibSelWtObj.order[0].value}`;
            }

            // console.log(`SELECT ${data} FROM ${str_tableName} ${str_condition} ${str_order}`)
            dbCon.execute(`SELECT ${data} FROM ${str_tableName} ${str_condition} ${str_order}`).then(result => {
                resolve(result)
            }).catch(err => {
                console.log(err)
                reject('Reject Promise while creating select query', err);
            })
        });
    }
    //********************************************************************************************************* */
    // Function for updating tables in database
    //********************************************************************************************************* */
    /**
    * @param updateObj
    * @description Function updates data to the database but object should be in the `Below` form
    * ```ts
    * {
    *   str_tableName: String //Table Name
    *   data:Array<[ // Data to be update
    *   {str_colName:String, value:String},... //Column name followed by its value
    *   ]> 
    *   condition:Array<[ //Where condition
    *   {str_colName:String, value:String},... //Column name followed by
    *   // its value
    *   ]>
    * }
    * ```
    * @summary Function creates the dynamic query` for the selecting data
    */
    update(updateObj) {
        return new Promise((resolve, reject) => {
            // fetching data which we want to update
            this.arr_updateData = updateObj.data;
            var str_columnNames = "";
            var strWhereColumnNames = "";
            var arr_values = [];
            // For loop for concatinating column names which supposed to update
            for (let i = 0; i < this.arr_updateData.length; i++) {
                str_columnNames = str_columnNames + this.arr_updateData[i].str_colName + "=?,";
                arr_values.push(this.arr_updateData[i].value)
            }
            // For loop for concatinating column names which appears in where clause
            for (let j = 0; j < updateObj.condition.length; j++) {
                var operator = '=';
                if (updateObj.condition[j].hasOwnProperty('comp')) {

                    switch (updateObj.condition[j].comp) {
                        case 'eq': operator = '='; break;
                        case 'ne': operator = '!='; break;
                        case 'lt': operator = '<'; break;
                        case 'lte': operator = '<='; break;
                        case 'gt': operator = '>'; break;
                        case 'gte': operator = '>='; break;
                        case 'btn': operator = 'BETWEEN';
                        default: operator = "=";
                    }
                }

                // strWhereColumnNames = strWhereColumnNames + updateObj.condition[j].str_colName + "=? AND ";
                strWhereColumnNames = strWhereColumnNames + updateObj.condition[j].str_colName + " " + operator + "? AND ";

                arr_values.push(updateObj.condition[j].value);
            }
            // removing last , OR  AND from string 
            str_columnNames = str_columnNames.slice(0, -1);
            strWhereColumnNames = strWhereColumnNames.slice(0, -4);
            // const query = `UPDATE ${updateObj.str_tableName} SET ${str_columnNames} WHERE ${strWhereColumnNames}, ${arr_values}`;
            //console.log(query, arr_values)
            dbCon.execute(`UPDATE ${updateObj.str_tableName} SET ${str_columnNames} WHERE ${strWhereColumnNames}`, arr_values).then(result => {
                resolve(result);
            }).catch(err => {
                console.log(err)
                reject('Reject Promise while creating update query', err);
            })
        })
    }
    //******************************************************************************************************** */
    // Function for updating tables in database
    //******************************************************************************************************** */
    /**
    * @param deleteObj
    * @description Function delets data from the database but object should be in the `Below` form
    * ```ts
    * {
    *   str_tableName: String //Table Name
    *   condition:Array<[ //Where condition
    *   {str_colName:String, value:String},... //Column name followed by
    *   // its value
    *   ]>
    * }
    * ```
    * @summary Function creates the dynamic query` for the selecting data
    */
    delete(deleteObj) {
        return new Promise((resolve, reject) => {
            var arr_values = [];
            var str_whereColumnName = "";
            for (let i = 0; i < deleteObj.condition.length; i++) {
                str_whereColumnName = str_whereColumnName + deleteObj.condition[i].str_colName + "=? AND ";
                arr_values.push(deleteObj.condition[i].value);
            }
            str_whereColumnName = str_whereColumnName.slice(0, -4)
            // const query = `DELETE FROM ${deleteObj.str_tableName} WHERE ${str_whereColumnName}`;
            dbCon.execute(`DELETE FROM ${deleteObj.str_tableName} WHERE ${str_whereColumnName}`, arr_values).then(result => {
                resolve(result)
            }).catch(err => {
                console.log(err)
                reject('Reject Promise while creating delete query')
            })
            //  console.log(query);
        })
    }
    //********************************************************************************************************* */

    //*************************************************************************************************** */
    // Function to select from one table and insert into another table.                                                        //
    //*************************************************************************************************** */
    copy(insertObj) {
        // console.log(insertObj)
        return new Promise((resolve, reject) => {
            // fetching columNames and data associated with them from object as from of array
            const data = insertObj.data;
            var columNames = "";
            // array for values to be inserted
            var arr_Values = [];
            // variable for hoding  ? (for prepared statement)
            var str_dummyVar = "";
            for (let i = 0; i < data.length; i++) {
                // concating columnames one by one
                columNames = columNames + data[i].str_colName + ",";
                str_dummyVar = str_dummyVar + "?,"
                arr_Values.push(data[i].value)
            }
            // removing last , from string 
            columNames = columNames.slice(0, -1);
            str_dummyVar = str_dummyVar.slice(0, -1);
            dbCon.execute(`INSERT INTO ${insertObj.str_tableName} (${columNames}) VALUES (${str_dummyVar})`, arr_Values).then(result => {
                resolve(result)
            }).catch(err => {
                console.log(err)
                reject('Reject Promise while creating copy query', err);
            })
        })
    }


    /**
     * 
     * @param {*} selectObj = {str_SPName : ' Procedure Name ', str_InParameter: 'inparam...,...', str_OutParameter : ''}
     */
    async selectSp(selectObj) {

        try {

            let strSPName = "CALL " + selectObj.str_SPName;
            let strInParameter = " (" + selectObj.str_InParameter + "," + selectObj.str_OutParameter + "); ";
            let strOutParameter = "SELECT " + selectObj.str_OutParameter + "; ";
            let strquery = strSPName + strInParameter + strOutParameter;

            var result = await dbCon.query(`${strquery}`);


            return result;
        } catch (error) {
            console.log(error)
            return error;
        }
    }

    async execute(query){
       
        try {
           
            return await dbCon.execute(query);
            
        } catch(err) {
            console.log(query,err)
            throw new Error(err)
        }
    }

    /**
     * 
     * @param {String} txtFileName :- "textfilename.txt" 
     */
    async createTextFile(txtFileName, data)
    {
        try {
            if(typeof data == 'object') data = JSON.stringify(data); 
            var now = new Date();
            var dtTime = date.format(now, 'DD-MM-YYYY HH:mm:ss');
            (fs.existsSync("./Log Files/" + txtFileName)) ? fs.appendFileSync("./Log Files/" + txtFileName,"\n" + dtTime + " : " + data) : 
            fs.writeFileSync("./Log Files/" + txtFileName,dtTime + " : " + data);
            console.log("Created");
        } catch (error) {
            console.log(error);
        }
        
    }
}




module.exports = QueryProcess;