const clsYieldModel = require('../model/yield.model');
const objYield = new clsYieldModel();
const clsYieldSchema = require('../Validation/Yield/Yield.schema');
const objYieldSchema = new clsYieldSchema();
const Joi = require('joi');

exports.getProductDetail = (req, res) => {
    Joi.validate(req.body, objYieldSchema.getProductDetail(), function (err, value) {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
            res.send(responseObj);
        } else {
            objYield.getProductDetail(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}

exports.getBatchDetail = (req, res) => {
    Joi.validate(req.body, objYieldSchema.getBatchDetail(), function (err, value) {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
            res.send(responseObj);
        } else {
            objYield.getBatchOfProduct(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}

exports.getYieldDetail = (req, res) => {
    Joi.validate(req.body, objYieldSchema.getYieldDetail(), function (err, value) {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
            res.send(responseObj);
        } else {
            objYield.getYieldData(value).then((result) => {
                res.statusCode = 200;
                //let responseObj = {}
                // Object.assign(responseObj, { result: result },{data : result.data});
                // res.send(responseObj);
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}

exports.saveYieldData = (req, res) => {
    Joi.validate(req.body, objYieldSchema.saveYieldData(), function (err, value) {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: err.details[0].message })
            res.send(responseObj);
        } else {
            objYield.saveYieldData(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}

exports.getProductsFromMaster = (req, res) => {
    Joi.validate(req.body, objYieldSchema.getProductDetail(), function (err, value) {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: err.details[0].message })
            res.send(responseObj);
        } else {
            objYield.getProductsFromMaster(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}

exports.checkYieldReportIsVerified = (req, res) => {
    objYield.checkYieldReportIsVerified(req).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}

exports.verifyReportYield = (req, res) => {
    objYield.verifyReportYield(req).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}

// exports.getBatchesFromMaster = (req, res) => {
//     Joi.validate(req.body, objYieldSchema.getBatchDetail(), function (err, value) {
//         if (err) {
//             res.statusCode = 400;
//             let responseObj = {}
//             Object.assign(responseObj, { status: 'fail' }, { result: err })
//             res.send(responseObj);
//         } else {
//             objYield.getBatchesFromMaster(value).then((result) => {
//                 res.statusCode = 200;
//                 res.send(result);
//             }).catch(err => {
//                 console.log(err)
//                 res.statusCode = 500;
//                 let responseObj = {}
//                 Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
//                 res.send(responseObj);
//             })
//         }
//     })
// }
exports.getBatchesFromMaster = (req, res) => {
    Joi.validate(req.body, objYieldSchema.getBatchFromMasterSchema(), function (err, value) {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: err })
            res.send(responseObj);
        } else {
            objYield.getBatchesFromMaster(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}

