const uploadFile = require("../middleware/upload");
const ProductParse = require('../model/clsProductParse');
const fs = require("fs");
const readXlsxFile = require('read-excel-file/node');

const upload = async (req, res) => {
  try {

    let productParse = new ProductParse();

    await uploadFile(req, res);
    let isInstrument = req.body.isInstrument ? true : false
    var currFileName = `${req.file.originalname.split('.')[0]}_${req.body.userid}_${(new Date()).toISOString().replaceAll(':', '_')}.${isInstrument ? 'pdf' : 'xlsx'}`;

    let folder_name = isInstrument ? 'instrument_certifcates' : 'Debug'
    await fs.promises.rename(`API/${folder_name}/${req.file.originalname}`, `API/${folder_name}/${currFileName}`);

    if (!isInstrument) {
      let rows=await readXlsxFile(`./API/Debug/${currFileName}`);
      let data=await productParse.productFormat(rows, req.body);
      console.log(data);
      res.status(200).send(data);
      // await readXlsxFile(`./API/Debug/${currFileName}`).then(async (rows) => {
      //   await productParse.productFormat(rows, req.body).then(data => {
      //     console.log(data);
      //     res.status(200).send(data);
      //   }).catch(err => {
      //     console.log(err)
      //     throw err
      //   })
      // });
    } else {
      res.status(200).send({ storeFileName: currFileName, status: 'success' });
    }
  } catch (err) {
    console.log(err);
    res.status(500).send({
      message: `Could not upload the file: ${req.file.originalname}. ${err}`,
    });
  }
};

module.exports = {
  upload
};