const SoftshellReportModel = require('../model/clsSoftShellReportModel');
const objSoftshellReport = new SoftshellReportModel();
const SoftshellReportSchema = require('../Validation/Softgel/SoftgelReport.schema');
const objSoftshellReportSchema = new SoftshellReportSchema()
const Joi = require('joi');

exports.getSoftshellDetails = (req,res) => {
    Joi.validate(req.body, objSoftshellReportSchema.getSoftshellSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else { 
            objSoftshellReport.getSoftshellDetails(value).then(result => {
                res.statusCode = 200;
                res.send(result);
            })
        }
    })
}

exports.viewSoftshellReport = (req,res) => {
    Joi.validate(req.body, objSoftshellReportSchema.viewSoftshellSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else { 
            objSoftshellReport.viewSoftshellReport(value,req).then(result => {
                res.statusCode = 200;
                res.send(result);
            })
        }
    })
}

exports.printReasonSoftshellReport = (req,res) => {
    Joi.validate(req.body, objSoftshellReportSchema.printoftshellSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else { 
            objSoftshellReport.printReasonSoftshellReport(value,req).then(result => {
                res.statusCode = 200;
                res.send(result);
            })
        }
    })
}

exports.insertprintReasonSoftshellReport = (req,res) => {
    Joi.validate(req.body, objSoftshellReportSchema.insertprintoftshellSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else { 
            objSoftshellReport.insertprintReasonSoftshellReport(value,req).then(result => {
                res.statusCode = 200;
                res.send(result);
            })
        }
    })
}

exports.checkReportIsVerified = (req, res) => {
    objSoftshellReport.checkReportIsVerified(req.body).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: result }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
  }

  exports.verifyReportSoftshell = (req, res) => {
    Joi.validate(req.body, objSoftshellReportSchema.VerifyReportSoftShell(), function (err, value) {
      if (err) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
          status: 'fail'
        }, { result: err })
        res.send(responseObj);
      } else {
        objSoftshellReport.verifyReportSoftshell(value).then(result => {
          res.statusCode = 200;
          let responseObj = {};
          Object.assign(
            responseObj, { status: "Success" }, { result: "Report Verification Successfull" }
          );
          res.send(responseObj);
        }).catch(err => {
          console.log(err);
          res.statusCode = 500;
          let responseObj = {};
          Object.assign(
            responseObj, { status: "fail" }, { result: "Internal server error" }
          );
          res.send(responseObj);
        })
      }
    })
  }