const clsReportModel = require("../model/clsReportModel");
const requestIp = require("request-ip");
const Joi = require('joi');
const ReportSchema = require('../validation/report/report.schema');
const LoginModel = require('../model/clsloginModel');
const objLogin = new LoginModel();
const config = require('../global/serverConfig');
const { models } = require("../dbConnection");
const path = require('path');
const fs = require('fs');
const moment = require('moment')
const date = require('date-and-time');


exports.generateReport = (req, res, next) => {
  //   let FullIp = requestIp.getClientIp(req);
  //   let ClientIp = FullIp.split(":")[3];
  //   var intLastIP;

  //   if ((("idsNo" in req.body.data) == true)) {
  //     intLastIP = `${req.body.data.idsNo}`;
  // } else {
  //   if (ClientIp === undefined) {
  //     ClientIp = "127.0.0.1";
  //   } else {
  //     ClientIp = ClientIp;
  //   }

  //   intLastIP = ClientIp.split(".")[3];
  // }

  // 

  let intLastIP = req.body.data.HmiId;
  if (intLastIP === undefined) {
    let FullIp = requestIp.getClientIp(req);
    let ClientIp = FullIp.split(":")[3];
    intLastIP = ClientIp;
  }
  // let Ip = requestIp.getClientIp(req);
  //           let ClIp = Ip.split(':')[3]
  //           var ClientIp;
  //           if (ClIp === undefined) {
  //               ClientIp = '127.0.0.1';
  //           } else {
  //               ClientIp = ClIp;
  //           }
  //           var intLastIP = ClientIp;
  console.log("lastip", intLastIP);
  // const objReportModel = new clsReportModel(req.body.FileName);
  const objReportModel = new clsReportModel(req.body.FileName, req.body.data); // print issue
  setTimeout(() => {

    objReportModel.makeReport(req.body.FileName, req.body.data, intLastIP).then(result => {
      if (req.body.data?.waterMark || req.body.data?.watermark) {
        res.statusCode = 200;
        res.send(result);
      } else {
        let PrDate = req.body.data?.PrDate;
        let PrTime = req.body.data.PrTime?.replace(/:/gi, '-');
        // if(req.body.data?.batchNo || req.body.data?.BatchNo){
        //   const filePath = result.filepath;
        //   const sharedFolderPath = config.developerPanelData.ReportPath[0].DestinationSrc
        //   const printerConfigured = config.developerPanelData.ReportPath[1].printerConfigured
        //   const sourcePath = path.normalize(process.cwd() + '/Reports/' + path.basename(filePath))
        //   const batchFolderPath = path.join(sharedFolderPath, (req.body.data?.batchNo || req.body.data?.BatchNo).trim());
        //   const destinationPath = path.join(batchFolderPath, `${req.body.data?.batchNo || req.body.data?.BatchNo}_${req.body.data?.Repetition}_${req.body.data?.PrintNo || req.body.data?.printNo}[${PrDate}][${PrTime}].pdf`);
        //   fs.mkdir(batchFolderPath, { recursive: true }, (err) => {
        //     if (err) {
        //       console.error('Error creating folder:', err);
        //       res.status(500).send({
        //         status: 'fail',
        //         result: 'File upload failed',
        //       });
        //     } else {
        //       fs.copyFile(sourcePath, destinationPath, (err) => {
        //         if (err) {
        //           console.error('Error copying file:', err);
        //           res.status(500).send({
        //             status: 'fail',
        //             result: 'File upload failed',
        //           });
        //         } else {
        //           console.log("result: 'Report generated and uploaded successfully'");
        //           res.statusCode = 200;
        //           res.send({...result,showPrinters:printerConfigured});
        //           // res.status(200).send({
        //           //   status: 'success',
        //           //   result: 'Report generated and uploaded successfully',
        //           // });
        //         }
        //       });
        //     }
        //   })
        // }
        // else
         if(req.body.data?.type){
          const type = (req.body.data?.type || '').trim();

          const filePath = result.filepath;
          const sharedFolderPath = config.developerPanelData.ReportPath[0].DestinationSrc
          const printerConfigured = config.developerPanelData.ReportPath[1].printerConfigured
          const sourcePath = path.normalize(process.cwd() + '/Reports/' + path.basename(filePath))

          let FolderPath;
          let destinationPath
          if(type.includes('Calib') && !type.includes('Audit')){
            const calibCategory = type.includes('Daily') ? 'Daily' : 'Periodic';
            FolderPath = path.join(sharedFolderPath, 'Calibration', calibCategory);
            destinationPath = path.join(FolderPath, `${req.body.data?.UserId}_${req.body.data?.
              reportType}.pdf`);
          }else if(type.includes('Activity')){
            const activityCategory = type.includes('IDS') ? 'IDS' : 'Software';
            FolderPath = path.join(sharedFolderPath, 'Activity Log', activityCategory);
            destinationPath = path.join(FolderPath, `${req.body.data?.UserId}_${type.includes('IDS') ? req.body.data.BatchNo : 'Software' }_[${req.body.data?.FromDate}][${req.body.data?.ToDate}].pdf`);
          }
          else if(type.includes('User Status')){
            FolderPath = path.join(sharedFolderPath, type);
            destinationPath = path.join(FolderPath, `${req.body.data?.UserId}_${req.body.data?.str_status1}.pdf`);
          }
          else if(type.includes('Role Log')){
            FolderPath = path.join(sharedFolderPath, type);
            destinationPath = path.join(FolderPath, `${req.body.data?.UserId}_${req.body.data?.str_role}.pdf`);
          }
          else if (type.includes('Instrument Usage')) {
            FolderPath = path.join(sharedFolderPath, type);
            destinationPath = path.join(FolderPath, `${req.body.data?.UserId}_${req.body.data?.SelectedValue}_${req.body.data?.SelectedAction}[${req.body.data?.FromDate}][${req.body.data?.ToDate}].pdf`);
          }
          else if (type.includes('Test Report')) {
            FolderPath = path.join(sharedFolderPath,type,req.body.data?.subType, (req.body.data?.batchNo || req.body.data?.BatchNo).trim());
            destinationPath = path.join(FolderPath, `${req.body.data?.batchNo || req.body.data?.BatchNo}_${req.body.data?.Repetition}_${req.body.data?.PrintNo || req.body.data?.printNo || 0}[${PrDate}][${PrTime}].pdf`);
            // FolderPath = path.join(sharedFolderPath, type,);
            // destinationPath = path.join(FolderPath, `${req.body.data?.UserId}_${req.body.data?.SelectedValue}_${req.body.data?.SelectedAction}[${req.body.data?.FromDate}][${req.body.data?.ToDate}].pdf`);
          }
          else{
            //Audit Trail
            let arr_value =  type.split(' ');
            FolderPath = path.join(sharedFolderPath,arr_value[0],arr_value[1]||'');
            destinationPath = path.join(FolderPath, `${req.body.data?.UserId}_${req.body.data?.SelectedAction!= '' ? req.body.data.SelectedAction : ''}_[${moment(req.body.data.FromDate).tz('Asia/Kolkata').format('YYYY-MM-DD')}][${moment(req.body.data.ToDate).tz('Asia/Kolkata').format('YYYY-MM-DD')}].pdf`);
          }
          
          fs.mkdir(FolderPath, { recursive: true }, (err) => {
            if (err) {
              console.error('Error creating folder:', err);
              res.status(500).send({
                status: 'fail',
                result: 'File upload failed',
              });
            } else {
              fs.copyFile(sourcePath, destinationPath, (err) => {
                if (err) {
                  console.error('Error copying file:', err);
                  res.status(500).send({
                    status: 'fail',
                    result: 'File upload failed',
                  });
                } else {
                  let now = new Date();
                  models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: req.body.data?.UserId,
                    username: req.body.data?.UserName,
                    activity: `${type != 'Test Report' ? `${type} Report` : type} Printed`
                  }).then((res1 => {
                    console.log("result: 'Report generated and uploaded successfully'");
                    res.statusCode = 200;
                    res.send({ ...result, showPrinters: printerConfigured, destinationPath: destinationPath });
                  }))
              // res.status(200).send({
                  //   status: 'success',
                  //   result: 'Report generated and uploaded successfully',
                  // });
                }
              });
            }
          })
        }
        else{
          res.statusCode = 200;
          res.send(result);
        }


      }
    }).catch(err => {
      console.log(err);
      //database.createTextFile("GenerateReport.txt",req.body.data);
      res.statusCode = 500;
      let responseObj = {};
      Object.assign(
        responseObj,
        { status: "fail" },
        { result: "Internal server error" }
      );
      res.send(responseObj);
    });
  }, 500)

};


exports.generateExceptionReport = (req, res, next) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  intLastIP = ClientIp;

  console.log("lastip", intLastIP);
  let tbl_name, obj_where, tblHtd_name;
  obj_where = {
    RepSerNo: req.body.SelectedValue,
    isTerminated: req.body.reportType,
    BatchNo:req.body.BatchNo
  }
  tbl_name = req.body.reportType == 1 ? 'tbl_exception_sample_failed' : 'tbl_exception_sample_initial';
  tblHtd_name = req.body.reportType == 1 ? 'tbl_exception_samplehtd_failed' : 'tbl_exception_samplehtd_initial';
  // }
  models[tbl_name].findAll({
    where: obj_where
  }).then(data => {
    if (data.length == 0) {
      models[tblHtd_name].findAll({
        where: obj_where
      }).then(resData => {
        if (resData.length == 0) {
          res.statusCode = 200;
          let responseObj = {};
          Object.assign(responseObj, { status: "fail" }, { result: "No Exception Record Found." });
          res.send(responseObj);
        } else {
          console.log('ABC');
          if(req.body.reportType == 1)
          {
            req.body.FileName = 'Repo_Tab_Exception_htd_incomplete'
          }
          else
          {
            req.body.FileName = 'Repo_Tab_Exception_htd'
          }
          exception_Rpt(req, res, intLastIP, resData);
        }
      })

    } else {
      exception_Rpt(req, res, intLastIP, data);
    }
  }).catch(err => {
    console.log(err);
    res.statusCode = 500;
    let responseObj = {};
    Object.assign(
      responseObj,
      {
        status: "fail"
      },
      {
        result: "Internal server error"
      }
    );
    res.send(responseObj);
  });

};

function exception_Rpt(req, res, intLastIP, data) {
  const objReportModel = new clsReportModel(req.body.FileName, req.body.data);
  objReportModel.makeReport(req.body.FileName, req.body, intLastIP)
    .then(result => {
      res.statusCode = 200;
      Object.assign(result, { status: 'success', result: data })
      res.send(result);
    })
    .catch(err => {
      console.log(err);
      res.statusCode = 500;
      let responseObj = {};
      Object.assign(
        responseObj,
        {
          status: "fail"
        },
        {
          result: "Internal server error"
        }
      );
      res.send(responseObj);
    });
}

//Audit trail Report controller for // Coding done for 'No record found OR return Report '
/**
 * @param req REquest object from requesting resource
 * @description Below Model function used for Admin name Audit 
 */
exports.auditAdminName = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.auditAdminNameSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.reptAdminName(value, ClientIp).then(result => {
        if (value.reportObj.data?.waterMark) {
          res.statusCode = 200;
          res.send(result);
        }else{
          let from=value.reportObj.data.FromDate.replace(/\//g, '-')
          let to=value.reportObj.data.ToDate.replace(/\//g, '-')
          objReportModel.saveAuditReport(res,result,'Change Profile',`[${from}]-[${to}]`)
        }
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object
 * @description Controller for Admin password Audit trail
 */
exports.auditAdminPassword = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.adminPassword(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptAdminPassword(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request Object
 * @description Controller for Set All Parameters Audit trail
 */
exports.auditSetAllParam = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptSetAllParameterSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptSetAllParam(value, ClientIp).then(result => {
        if (value.reportObj.data?.waterMark) {
          res.statusCode = 200;
          res.send(result);
        }else{
          let from=value.reportObj.data.FromDate.replace(/\//g, '-')
          let to=value.reportObj.data.ToDate.replace(/\//g, '-')
          objReportModel.saveAuditReport(res,result,'Set All Parameter',`${value.reportObj.data.SelectedValue}_[${from}]-[${to}]`)
        }
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request Object
 * @description Controller to print Audit trail for activity Log
 */
exports.rptActivityLog = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.reportActivityLogSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      console.log(`${(new Date())}`);
      objReportModel.reportActivityLog(value, ClientIp).then(result => {
        console.log(`${(new Date())}`);
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request Object form requesting resource
 * @description Controller for unauthorize login 
 */
exports.rptUnauthorizeLogin = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.unAuthoriseLogin(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptUnauthorizeLogin(value, ClientIp).then(result => {
        if (value.reportObj.data?.waterMark) {
          res.statusCode = 200;
          res.send(result);
        }else{
          let from=value.reportObj.data.FromDate.replace(/\//g, '-')
          let to=value.reportObj.data.ToDate.replace(/\//g, '-')
          objReportModel.saveAuditReport(res,result,'Unauthorized Login',`${value.reportObj.data.SelectedValue}_[${from}]-[${to}]`)
        }
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object
 * @description Cotroller for Pronting audit trail for Roles
 */
exports.rptAuditRoles = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.auditRolesSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptAuditRoles(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object from requested resource
 * @description Controller for rptAuditUser report
 */
exports.rptAuditUser = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptAuditUsers(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptAuditUsers(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
exports.rptDepartment = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptDeparmentSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptDeparment(value, ClientIp).then(result => {
        if (value.reportObj.data?.waterMark) {
          res.statusCode = 200;
          res.send(result);
        }else{
          let from=value.reportObj.data.FromDate.replace(/\//g, '-')
          let to=value.reportObj.data.ToDate.replace(/\//g, '-')
          objReportModel.saveAuditReport(res,result,'Department',`${value.reportObj.data.SelectedValue}_${value.reportObj.data.SelectedAction}_[${from}]-[${to}]`)
        }
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object 
 * @description Contrller for Calibration box
 */
exports.rptCalibBox = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptCalibBoxSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptCalibratiobBox(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object from requested resource
 * @description Controller for Balance audit report
 */
exports.rptAuditBalnce = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptBalanceSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptBalance(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object from requested resource
 * @description Controller for varnier audit report
 */
exports.rptAuditVernier = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptVarnier(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptVernier(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object from requested resource
 * @description Controller for other instrumnet audit report
 */
exports.rptAuditOther = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptOtherEquipment(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptOtherEquipment(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object from requested resource
 * @description Controller for other instrumnet audit report
 */
exports.rptAuditMachine = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptMachineSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptMachine(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object from requested resource
 * @description Controller for Media audit report
 */
exports.rptAuditMedia = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptAlertSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptMedia(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object from requested resource
 * @description Controller for Audit stage audit report
 */
exports.rptAuditStage = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptStageSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptStage(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object from requested resource
 * @description Controller for Audit stage audit report
 */
exports.rptAuditProduct = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptProductSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptProduct(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object from requested resource
 * @description Controller for Audit Area
 */
exports.rptAuditArea = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptAreaSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptArea(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @param req Request object from requested resource
 * @description Controller for Audit Port
 */
exports.rptAuditPort = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptPortSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptPort(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @param req Request object from requested resource
 * @description Controller for Audit cleaner
 */
exports.rptAuditCleaner = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptCleanerSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptAuditCleaner(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @param req Request object from requested resource
 * @description Controller for Audit container
 */
exports.rptAuditContainer = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptContainersSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptContainer(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @param req Request object from requested resource
 * @description Controller for Audit container
 */
exports.rptAuditBinStage = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptCleanerSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptAuditBinStage(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @param req Request object from requested resource
 * @description Controller for Audit Cubicle
 */
exports.rptAuditCubicle = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptCubicleSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptCubicle(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @param req Request object from requested resource
 * @description Controller for Audit cleaner
 */
exports.rptAuditCleaner = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(".")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptCleanerSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptAuditCleaner(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: err }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @param req Request object from requested resource
 * @description Controller for Audit Recalibration
 */
exports.rptAuditRecalib = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptRecalibSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptRecalib(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.increasePrintCountCapsule = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.PrintReportCount(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.increasePrintNoCapsule(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Operation Successfull" }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.increasePrintCountSummary = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.PrintReportCountSummary(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.increasePrintNoSummary(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Operation Successfull" }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.increasePrintCountBinSummary = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.increasePrintCountBinSummarySchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.increasePrintCountBinSummary(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Operation Successfull" }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.increasePrintCountUpBinLabel = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.printcountupBinLabelSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.increasePrintCountUpBinLabel(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Operation Successfull" }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @description Controller used to increase the count in the calibtation print tables
 */
exports.increasePrintCountCalibration = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.PrintCountCalibrationSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.increasePrintNoCalibration(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Operation Successfull" }
        );
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.printCountUpCalibrationVernier = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.PrintCountCalibrationSchemaVernier(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.printCountUpCalibrationVernier(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Operation Successfull" }
        );
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.verifyReport = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.VerifyReport(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.verifyReport(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Report Verification Successfull" }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
exports.verifyReportCapsule = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.VerifyReport(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.verifyReportCapsule(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Report Verification Successfull" }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.checkCapsuleReportIsVerified = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.checkReportIsVerified(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.checkCapsuleReportIsVerified(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: result }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}


exports.printReasonReportCapsule = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.printReasonReport(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.printReasonReportCapsule(value, req).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @description Controller for print reasons report for Calibration
 */
exports.printReasonReportCalibration = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.printReasonReportCalib(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.printReasonReportCalibration(value, req).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.printReasonReportVernierCalibration = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.printReasonReportCalibVernier(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.printReasonReportVernierCalibration(value, req).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @param req Request object from requested resource
 * @description Controller for Media audit report
 */
exports.rptAlertAudit = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptAlertSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptAlert(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @param req request object from requested resouce
 * @description controller for yield audit report  rptAuditYield
 */
exports.rptAuditYield = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptAuditYieldSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptAuditYield(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @param req Request object from requested resource
 * @description Controller for password complexity audit report
 */

exports.auditpasswordComplexity = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();


  Joi.validate(req.body, ReportSchema.passwordComplexitySchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.AdminPasswordComplexity(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })

}
/**
 * report for AuditPrecalibration
 */
exports.rptAuditPrecalibration = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptAuditPrecalibrationSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptAuditPrecalibration(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
exports.printcountupYield = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.printcountupYield(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.printcountupYield(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Operation Successfull" }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
exports.periodicCalibrationRemarkForFailed = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.periodicCalibrationRemarkForFailed(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.periodicCalibrationRemarkForFailed(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Remark Added Successfull" }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.periodicCalibrationRemarkForFailedVernier = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.periodicCalibrationRemarkForFailed(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.periodicCalibrationRemarkForFailedVernier(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Remark Added Successfull" }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.generateReportBatchSummaryAll = async (req, res, next) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  if (ClientIp === undefined) {
    ClientIp = "127.0.0.1";
  } else {
    ClientIp = ClientIp;
  }
  // 
  let intLastIP = ClientIp.split(".")[3];

  for (let i of req.body.arr_param) {

    var str_fileName = req.body.FileName + i;
    const objReportModel = new clsReportModel(str_fileName);
    //  let a = await setTimeout(() => {
    //   result =  objReportModel.makeReportSummary(str_fileName, req.body.data, intLastIP);
    //  }, 500); 

    var result = await objReportModel.makeReportSummary(str_fileName, req.body.data, intLastIP);
    //console.log("Result",result);
    var tmout = await delay(1000)
    //console.log(tmout);
  }

  res.statusCode = 200;
  let responseObj = {};
  Object.assign(responseObj, { status: "Success" }, { result: result });
  res.send(responseObj);

}

/**
 * @param req Request object from requested resource
 * @description Controller for Audit Content audit report
 */
exports.rptAuditContent = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptContentSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptContent(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.TestApi = (req, res) => {
  const objReportModel = new clsReportModel();
  res.statusCode = 200;
  res.send("Success");
  // objReportModel.TestApi(value, req).then(result => {
  //   res.statusCode = 200;
  //   res.send(result);
  // }).catch(err => {
  //   console.log(err);
  //   res.statusCode = 500;
  //   let responseObj = {};
  //   Object.assign(
  //     responseObj, { status: "fail" }, { result: "Internal server error" }
  //   );
  //   res.send(responseObj);
  // })
}

const delay = timeToWait => new Promise(resolve => setTimeout(resolve, timeToWait));

