const clsrecalibrationModel = require('../model/clsrecalibrationModel');
const clsRecalibrationSchema = require('../Validation/Recalibration/Recalibration.schema');
const objrecalibrationModel = new clsrecalibrationModel();
const objClsRecalibrationSchema = new clsRecalibrationSchema();
const Joi = require('joi');

exports.getRecalibration = (req, res) => {
    objrecalibrationModel.getRecalibration(req).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success' }, { result: result })
        res.send(responseObj)
    }).catch((err) => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}

exports.getCalibrationMasterData = (req, res) => {
    Joi.validate(req.body, objClsRecalibrationSchema.calibrationMasterDataSchema(), function (err, obj) {
        if (err){
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: err})
            res.send(responseObj);  
        } else {
            objrecalibrationModel.getCalibrationMasterData(obj).then((result) => {
                //console.log(result);
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    }) 
}

exports.recalibrationUpdateStatus = (req, res) => {
    Joi.validate(req.body, objClsRecalibrationSchema.addReCalibrationSchema(), function (err, value) {
        if (err){
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: err})
            res.send(responseObj);  
        } else {
            objrecalibrationModel.recalibrationUpdateStatus(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    }) 
}