var Joi = require('joi');
const clsProductSoftgelModel = require('../model/clsProductSoftgelModel');
const objclsProdSoftgelModel = new clsProductSoftgelModel();
const clsValidateSoftgel = require('../model/validateProductSoftGel.class');
const objValidateSoftgel = new clsValidateSoftgel();
const clsSoftGelSchema = require('../Validation/Softgel/Softgel.schema');
const SoftGelSchema = new clsSoftGelSchema();

exports.validateAddSoftgel = (req, res) => {
    var objProductNew = req.body.newData;
    if (objProductNew == "") {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: err
        })
        res.send(responseObj);
    } else {
        objValidateSoftgel.validateAddSoftgel(objProductNew).then((value) => {
                res.statusCode = 200;

                const result = {}
                Object.assign(result, {
                    status: 'Success'
                }, {
                    result: value
                })

                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            })

        
    }
}

exports.addProductSoftgel = (req,res) => {
    Joi.validate(req.body, SoftGelSchema.saveSoftgelSchema(), (err, value) => {
        if (err) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, { result: err })
        res.send(responseObj);
        } else {
            objclsProdSoftgelModel.addProductSoftgel(value).then(result => {
                res.statusCode = 200;
                res.send(result);
        }).catch(err => {
            console.log(err);
            res.statusCode = 500;
            let responseObj = {};
            Object.assign(
            responseObj, { status: "fail" }, { result: "Internal server error" }
            );
            res.send(responseObj);
        })
        }
    })    
}

exports.getProductSoftgel = (req, res) => {
    objclsProdSoftgelModel.getProductSoftgel().then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getProductDetailForCubicle = (req, res) => {
    objclsProdSoftgelModel.getProductDetailForCubicle(req).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.activateProductSoftgel = (req,res) => {
    Joi.validate(req.body, SoftGelSchema.activateSoftgelSchema(), (err, value) => {
        if (err) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, { result: err })
        res.send(responseObj);
        } else {
            objclsProdSoftgelModel.activateProductSoftgel(value).then(result => {
                res.statusCode = 200;
                res.send(result);
        }).catch(err => {
            console.log(err);
            res.statusCode = 500;
            let responseObj = {};
            Object.assign(
            responseObj, { status: "fail" }, { result: "Internal server error" }
            );
            res.send(responseObj);
        })
        }
    })
}