var Joi = require('joi');
const clsPortSetting = require('../model/clsPortSettingModel');
const clsPortSettingSchema = require('../Validation/PortSetting/PortSetting.schema');
const objPortSetting = new clsPortSetting();
const objPortSettingSchema = new clsPortSettingSchema();


exports.updatePortSetting = (req, res) => {
    Joi.validate(req.body, objPortSettingSchema.savePortSetSchema(), (err, obj) => {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {
            objPortSetting.savePortSettingDetails(obj).then((result) => {
                let responseObj = {};
                res.statusCode = 200;
                res.send(result)
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            })
        }

    })

}

exports.getAuditAreaPort = (req, res) => {
    objPortSetting.getAuditAreaPort().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}