const clsPeriodicCalibReport = require('../model/clsPeriodicCalibReport');
const obj_periodicCalibReport = new clsPeriodicCalibReport();
const ReportSchema = require('../Validation/Report/calibReport.schema');
const objReportSchema = new ReportSchema();
const Joi = require('joi');

exports.getDetailsForPeriodicCalibration = (req,res) => {
    if((req.body.reportType == '') || (req.body.reportType === undefined) || 
    (req.body.balanceCode == '') || (req.body.balanceCode === undefined) || 
    (req.body.fromDate == '') || (req.body.fromDate === undefined) || 
    (req.body.toDate == '') || (req.body.toDate === undefined)){
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj); 
    }
    else
    {
        obj_periodicCalibReport.getDetailsForPeriodicCalibration(req.body).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: err })
            res.send(responseObj);
        }) 
    }
}

exports.getBalanceID = (req,res) => {
    Joi.validate(req.body, objReportSchema.getBalanceIDSchema(), (err,value)=> {
        if(err)
        {
            res.statusCode = 400;
            let resposeObj = {};
            Object.assign(resposeObj,{status: 'fail', result:'Bad Request'});
            res.send(resposeObj); 
        }
        else
        {
            obj_periodicCalibReport.getBalanceID(value).then((result) => {
                res.statusCode = 200;
                res.send(result);   
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    }); 
}

exports.getVernierID = (req,res) => {
    if((req.body.toDate == '' || req.body.toDate == undefined) ||
    (req.body.fromDate == '' || req.body.fromDate == undefined) ||
    (req.body.reportType == '' || req.body.reportType == undefined))
    {
        res.statusCode = 400;
        let responseObj = {};
        Object.assign(responseObj, {status :'fail'}, {result:'Bad Request'});
        res.send(responseObj);
    }
    else
    {
        obj_periodicCalibReport.getVernierID(req).then((result)=>{
            res.statusCode = 200;
            res.send(result);
        }).catch(err =>{
            res.statusCode = 500;
            let responseObj = {};
            Object.assign(responseObj, {status:'fail'}, {result:'Internal Server Error'});
            res.send(responseObj);
        })
    }
}

exports.getVernierRecord = (req,res)=>{
    Joi.validate(req.body, objReportSchema.getVernierRecordSchema(), (err,value)=> {
        if(err)
        {
            res.statusCode = 400;
            let resposeObj = {};
            Object.assign(resposeObj,{status: 'fail', result:err.message});
            res.send(resposeObj); 
        }
        else
        {
            obj_periodicCalibReport.getVernierRecord(value).then((result)=>{
                res.statusCode = 200;
                res.send(result);
            })
        }
    })
}

exports.storeVerifyDetailForCalibration = (req, res) => {
    Joi.validate(req.body, objReportSchema.storeVerifyDetailForCalibSchema(), (err,value)=> {
        if(err)
        {
            res.statusCode = 400;
            let resposeObj = {};
            Object.assign(resposeObj,{status: 'fail', result:err.message});
            res.send(resposeObj); 
        }
        else
        {
            obj_periodicCalibReport.storeVerifyDetailForCalibration(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}

exports.storeVerifyDetailForVernierCalibration = (req, res) => {
    if ((req.body.reportType == '') || (req.body.reportType === undefined) 
        || (req.body.repSrNo == '') || (req.body.repSrNo === undefined)
        || (req.body.userId == '') || (req.body.userId === undefined)
        || (req.body.username == '') || (req.body.username === undefined)) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    } else {
        obj_periodicCalibReport.storeVerifyDetailForVernierCalibration(req).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
    }
}

exports.getCheckByForPeriodicCalibration = (req,res) => {
    Joi.validate(req.body, objReportSchema.getCheckByForPeriodicCalibSchema(), (err,value)=> {
        if(err)
        {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
            res.send(responseObj);  
        }
        else
        {
            obj_periodicCalibReport.getCheckByForPeriodicCalibration(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            }) 
        }
    })
}

exports.getCheckByForPeriodicVernierCalibration = (req,res) => {
    if((req.body.repSrNo == '') || (req.body.repSrNo === undefined)){
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj); 
    }
    else
    {
        obj_periodicCalibReport.getCheckByForPeriodicVernierCalibration(req).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        }) 
    }
}

exports.storeDataInTempTableForIncrency = (req, res) => {
    Joi.validate(req.body, objReportSchema.storeDataInTempTableIncrencySchema(), (err,value)=> {
        if(err)
        {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
            res.send(responseObj);  
        }
        else
        {
            obj_periodicCalibReport.storeDataInTempTableForIncrency(req,value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}

exports.storeDataInTempTableVernier = (req, res) => {
    if ((req.body.repSrNo == '') || (req.body.repSrNo === undefined) || 
        (req.body.reportType == '') || (req.body.reportType === undefined) || 
        (req.body.VernierCode == '') || (req.body.VernierCode === undefined) || 
        (req.body.userId == '') || (req.body.userId === undefined) || 
        (req.body.username == '') || (req.body.username === undefined)) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    } else {
        obj_periodicCalibReport.storeDataInTempTableVernier(req).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
    }
}


 