const Joi = require('joi');
const clsMultihalerReportModel = require('../model/clsMultihalerReportModel');
const objMultihalerReport = new clsMultihalerReportModel();
const MultihalerReportSchema = require('../Validation/Multihaler/Multihaler.schema');
const objMultihalerRptSchema = new MultihalerReportSchema()

exports.getMultihalerDetails = (req, res) => {
    Joi.validate(req.body, objMultihalerRptSchema.getMultihalerProductSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else { 
            objMultihalerReport.getMultihalerDetails(value).then(result => {
                res.statusCode = 200;
                res.send(result);
            })
        }
    })
 
}

exports.ViewMultihalerReport = (req, res) => {
    Joi.validate(req.body, objMultihalerRptSchema.viewMultihalerReportSchema(), (err, value) => {
        // ON ERROR
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else { // ON SUCCESS
            objMultihalerReport.ViewMultihalerReport(value, req).then(result => {
                res.statusCode = 200;
                res.send(result);
            })
        }
    });
}

exports.checkMultihalerReportIsVerified = (req,res) => {
    Joi.validate(req.body, objMultihalerRptSchema.checkMultihalerReportIsVerifiedSchema(), (err, value) => {
        // ON ERROR
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else { // ON SUCCESS
            objMultihalerReport.checkMultihalerReportIsVerified(value).then(result => {
                res.statusCode = 200;
                res.send(result);
            })
        }
    });  
}

exports.verifyMultihalerReport = (req,res) => {
    Joi.validate(req.body, objMultihalerRptSchema.verifyMultihalerReportSchema(), (err, value) => {
        // ON ERROR
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else { // ON SUCCESS
            objMultihalerReport.verifyMultihalerReport(value).then(result => {
                res.statusCode = 200;
                res.send(result);
            })
        }
    });     
}

exports.increasePrintCountMultihaler = (req,res) => {
    Joi.validate(req.body, objMultihalerRptSchema.increasePrintCountMultihalerSchema(), (err, value) => {
        // ON ERROR
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else { // ON SUCCESS
            objMultihalerReport.increasePrintCountMultihaler(value).then(result => {
                res.statusCode = 200;
                res.send(result);
            })
        }
    });     
}

exports.printReasonMultihalerReport = (req,res) => {
    Joi.validate(req.body, objMultihalerRptSchema.printReasonMultihalerReportSchema(), (err, value) => {
        // ON ERROR
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else { // ON SUCCESS
            objMultihalerReport.printReasonMultihalerReport(value,req).then(result => {
                res.statusCode = 200;
                res.send(result);
            })
        }
    });   
}