const clsmediaModel = require('../model/clsmediaModel');
const objClsMediaModel = new clsmediaModel();
var Joi = require('joi');
const clsMediaSchema = require('../Validation/Media/Media.schema');
const objClsMediaSchema = new clsMediaSchema();

exports.getMedia = (req, res) => {
    objClsMediaModel.getMedia().then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.storeMedia = (req, res) => {
    Joi.validate(req.body, objClsMediaSchema.saveSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objClsMediaModel.storeMedia(req).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }

    });
}