const Joi = require('joi');
const fs = require('fs');
const path = require('path');
const clsDeptModel = require('../model/clsdeptModel')
const serverConfig = require('../global/serverConfig')
const objclsDeptModel = new clsDeptModel();
const clsDepartmentSchema = require('../Validation/Department/Department.schema');
const objDepartmentSchema = new clsDepartmentSchema();

   
    jasper = require('node-jasper')({
        path: '../lib/jasperreports-5.6.0',
        reports: {
            hw: {
                jasper: '../jasperFiles/NodeIreportTest.jasper'
            }
        },
        drivers: {
            sqljdbc: {
                path:'../lib/sqljdbc4-2.0.jar',
                class:'com.microsoft.sqlserver.jdbc.SQLServerDriver',
                type:'sqljdbc'
            }
        },
        conns: {
            MS_SQL_SERVER: {
                host: serverConfig.dbHost,
                port: 1433,
                dbname: serverConfig.dbName,
                user: serverConfig.dbUser,
                pass: serverConfig.dbPass,
                driver: 'sqljdbc',
                jdbc:`jdbc:sqlserver://${serverConfig.dbHost}:1433;databaseName=${serverConfig.dbName}`,
                validationTimeout: 600
            }
        },
        defaultConn: 'MS_SQL_SERVER',
        java: ["-Djava.awt.headless=true"]//Array of java options, for example ["-Djava.awt.headless=true"]
    });

exports.getDepartments = (req, res) => {
    objclsDeptModel.getDepatments().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success' }, { result: result })
        res.send(responseObj)
    }).catch((err) => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })

}

exports.getDepartmentsForAuditTrail = (req, res) => {
    objclsDeptModel.getDepartmentsForAuditTrail().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success' }, { result: result })
        res.send(responseObj)
    }).catch((err) => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })

}

exports.jasperdemo = (req, res, next) => {
    //console.log(req.body)
    var report = {
        report: 'hw',
        data: {
             parameter1: req.body.parameter1,
             parameter2: req.body.parameter2
        }
    }
    
    var pdf = jasper.pdf(report);
   
    // res.set({
    //     'Content-type': 'application/pdf',
    //     'Content-Length': pdf.length
    // });
   
    res.statusCode = 200;
    var filepath = "./reports/Test.pdf"
    filepath = path.resolve(filepath);

    var filename = {
        "filepath": serverConfig.reporthost  + path.basename(filepath)
    };
    fs.unlink(filepath, (err) => {
        if (err) {
            //console.log(err);
        }
        else{
            //console.log('path/file.txt was deleted');
            fs.writeFile("./reports/Test.pdf",new Buffer(pdf, 'binary'), (err)=>{
                if (err) {
                   // console.log(err)
                }
                res.send(filename);
            });
        }
        
      });

}

exports.storeDepartment = (req, res) => {
    Joi.validate(req.body, objDepartmentSchema.saveDepartmentSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objclsDeptModel.storeDepartment(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }

    }); 
}

exports.updateDepartment = (req, res) => {
    Joi.validate(req.body, objDepartmentSchema.updateDepartmentSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objclsDeptModel.updateDepartment(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }

    });  
}

exports.updateDeptLockStatus = (req, res) => {
    Joi.validate(req.body, objDepartmentSchema.updateDeptLockStatusSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objclsDeptModel.updateDeptLockStatus(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }

    });  
}

exports.assignedToCubicleManageUSer = (req, res) => {
    objclsDeptModel.assignedToCubicleManageUSer(req.body.result).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    }) 
}

exports.getDepartmentsAudit = (req, res) => {
    objclsDeptModel.getDepartmentsAudit().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success' }, { result: result })
        res.send(responseObj)
    }).catch((err) => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: err })
        res.send(responseObj);
    })

}