const calibrationboxModel = require('../model/clscalibrationboxModel');
const objcalibrationboxModel = new calibrationboxModel();

var Joi = require('joi');
const clsCalibrationSchema = require('../Validation/Calibration/Calibration.schema');
const objClsCalibrationSchema = new clsCalibrationSchema();

exports.getCalibration = (req, res) => 
{
    objcalibrationboxModel.getCalibration().then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}

exports.getCalibrationData = (req, res) => 
{
    objcalibrationboxModel.getCalibrationData().then((result) => 
    {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => 
    {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    }) 
}

exports.storeCalibration = (req, res) => 
{
    Joi.validate(req.body, objClsCalibrationSchema.saveCalibrationSchema(), function (err, value) 
    {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        }
        else 
        {
            objcalibrationboxModel.storeCalibration(req).then((result) => 
            {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }  
    }); 
}

exports.updateCalibrationLock = (req, res) => {
    if((req.body.Eqp_Locked == '') || (req.body.Eqp_Locked === undefined) || 
    (req.body.Type == '') || (req.body.Type === undefined) || 
    (req.body.fieldName == '') || (req.body.fieldName === undefined) || 
    (req.body.selectedValue == '') || (req.body.selectedValue === undefined) || 
    (req.body.userID == '') || (req.body.userID === undefined)){
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    } else {
        objcalibrationboxModel.updateCalibrationLock(req).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
    }    
}

exports.updateCalibration = (req, res) => 
{
    Joi.validate(req.body, objClsCalibrationSchema.updateCalibrationSchema(), function (err, value) 
    {
        if(err)
        {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
            res.send(responseObj);
        } 
        else 
        {
            objcalibrationboxModel.updateCalibration(req).then((result) => 
            {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        } 
    });  
}

exports.getCalibrationForEdit = (req, res) => {
    Joi.validate(req.body,objClsCalibrationSchema.getCalibrationForEdit(),( err , value) => {
        if(err){
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        }else{
            objcalibrationboxModel.getCalibrationForEdit(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}
