const Joi = require('joi');
const clsAlertSetting = require('../model/clsAlertSettingModel');
const clsAlertValidation = require('../Validation/Alert/alert.schema');
const objAlertSetting = new clsAlertSetting();

exports.UpdateAlertSetting = (req, res) => {
    const alertObject = req.body;
    Joi.validate(alertObject, clsAlertValidation.getSaveSchema(), function (err, value) {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
            res.send(responseObj);
        } else {
            objAlertSetting.UpdateAlertSetting(value).then((result) => {
                res.statusCode = 200;
                let responseObj = {}
                Object.assign(responseObj, { status: 'success' }, { result: 'Alert Setting Updated Successfully.' })
                res.send(responseObj);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' }, { Description: err })
                res.send(responseObj);
            })

        }
    });

}

exports.SaveAlertSetting = (req, res) => {
    const alertObject = req.body;
    Joi.validate(alertObject, clsAlertValidation.getSaveSchema(), function (err, value) {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' }, { Description: err })
            res.send(responseObj);
        } else {
            objAlertSetting.saveAlertSetting(value).then((result) => {
                res.statusCode = 200;
                let responseObj = {}
                Object.assign(responseObj, { status: 'success' }, { result: 'Alert Setting Saved Successfully.' })
                res.send(responseObj);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}

exports.getAlertSetting = (req, res) => {
    const alertObject = req.body;
    objAlertSetting.getAlertSettingByCubicNo(alertObject).then((result) => {
        res.statusCode = 200;
        let responseObj = {}
        Object.assign(responseObj, { status: 'success' }, { result: result })
        res.send(responseObj);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })

}

exports.getAlertAuditData = (req, res) => {
    const alertObject = req.body ;
    objAlertSetting.getAlertAuditData(alertObject).then((result) => {
        res.statusCode = 200;
        let responseObj = {}
        Object.assign(responseObj, { status: 'success' }, { result: result })
        res.send(responseObj);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })


}