const clsadminModel = require('../model/clsadminModel');
const objclsadminModel = new clsadminModel();
var Joi = require('joi');
const clsAdminSchema = require('../Validation/Admin/Admin.schema');
const objClsAdminSchema = new clsAdminSchema();


exports.updateUserStatus = (req, res) => {
    Joi.validate(req.body, objClsAdminSchema.updateUserStatusSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objclsadminModel.updateUserStatus(req).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    });
}

exports.updateUserPassword = (req, res) => {
    objclsadminModel.updateUserPassword(req).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}

exports.changeAdminProfile = (req, res) => {

    Joi.validate(req.body, objClsAdminSchema.changeProfileSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objclsadminModel.changeAdminProfile(req).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }

    });
}

exports.authenticationChangeProfile = (req, res) => {
    objclsadminModel.authenticationChangeProfile(req).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}