const Joi = require('joi');
// const { join } = require('mysql2/lib/constants/charset_encodings');
class calibSchema{


    getVernierRecordSchema() {
        const getVernierRecordSchema = Joi.object().keys({
            toDate: Joi.string().required().not(['',null,'undefined']),
            fromDate: Joi.string().required().not(['',null,'undefined']),
            reportType: Joi.string().required().not(['',null,'undefined']),
            VernierCode: Joi.string().required().not(['',null,'undefined']),
            str_projectName:Joi.string().required().not(['',null,'undefined'])
        })
        return getVernierRecordSchema;
    }
    
    getBalanceIDSchema() {
        const getBalanceIDSchema = Joi.object().keys({
            toDate: Joi.string().required().not(['',null,'undefined']),
            fromDate: Joi.string().required().not(['',null,'undefined']),
            reportType: Joi.string().required().not(['',null,'undefined'])
        })
        return getBalanceIDSchema;
    }

    getDetailsForPeriodicMonthlySchema(){
        const getDetailsForPeriodicMonthlySchema = Joi.object().keys({
            fromDate: Joi.string().required().not(['',null,'undefined']),
            toDate: Joi.string().required().not(['',null,'undefined']),
            reportType: Joi.string().required().not(['',null,'undefined']),
            balanceCode: Joi.string().required().not(['',null,'undefined']),
            intFlagPeriodic: Joi.number().required().not(['',null,'undefined']),
            intFlagRepet: Joi.number().required().not(['',null,'undefined']),
            str_projectName:Joi.string().required().not(['',null,'undefined']),
            calibType:Joi.string().required().not(['',null,'undefined']),
        })
        return getDetailsForPeriodicMonthlySchema;  
    }

    getDetailsForPeriodicYearlySchema(){
        const getDetailsForPeriodicYearlySchema = Joi.object().keys({
            fromDate: Joi.string().required().not(['',null,'undefined']),
            toDate: Joi.string().required().not(['',null,'undefined']),
            reportType: Joi.string().required().not(['',null,'undefined']),
            balanceCode: Joi.string().required().not(['',null,'undefined']),
            intFlagEccent: Joi.number().required().not(['',null,'undefined']),
            intFlagLin: Joi.number().required().not(['',null,'undefined']),
            intFlagUncer: Joi.number().required().not(['',null,'undefined']),
            str_projectName:Joi.string().required().not(['',null,'undefined']),
            calibType:Joi.string().required().not(['',null,'undefined']),
        })
        return getDetailsForPeriodicYearlySchema;  
    }

    getCheckByForPeriodicCalibSchema(){
        const getCheckByForPeriodicCalibSchema = Joi.object().keys({
            repSrNo: Joi.number().required().not(['',null,'undefined']),
            reportType:Joi.string().required().not(['',null,'undefined']),
        })
        return getCheckByForPeriodicCalibSchema;   
    }

    storeVerifyDetailForCalibSchema(){
        const storeVerifyDetailForCalibSchema = Joi.object().keys({
            reportType: Joi.string().required().not(['',null,'undefined']),
            repSrNo:Joi.number().required().not(['',null,'undefined']),
            userId:Joi.string().required().not(['',null,'undefined']),
            username:Joi.string().required().not(['',null,'undefined']),
        })
        return storeVerifyDetailForCalibSchema; 
    }

    storeDataInTempTableIncrencySchema(){
        const storeDataInTempTableIncrencySchema = Joi.object().keys({
            reportType: Joi.string().required().not(['',null,'undefined']),
            repSrNo:Joi.number().required().not(['',null,'undefined']),
            userId:Joi.string().required().not(['',null,'undefined']),
            username:Joi.string().required().not(['',null,'undefined']),
            printNo:Joi.number().required().not(['',null,'undefined']),
            balId:Joi.string().required().not(['',null,'undefined'])
        })
        return storeDataInTempTableIncrencySchema; 
    }

}

module.exports = calibSchema;
