const Joi = require('joi');

class ReportSchema {

    printReasonReporteSchema() {
        const printReasonReporteSchema = Joi.object().keys({
            reportOption: Joi.string().required().not([null, 'undefined']),
            recordFrom: Joi.string().required().not([null, 'undefined']),
            reportType: Joi.string().required().not([null, 'undefined']),
            RepSrNo: Joi.number().required().not([null, 'undefined']),
            str_url: Joi.allow(),
            int_ReportFormat : Joi.number().required().not([null, 'undefined'])
        });
        return printReasonReporteSchema;
    }

    checkReportIsVerified() {
        const checkReportIsVerified = Joi.object().keys({
            intReportSerNo: Joi.number().required(),
            reportOption: Joi.string().required(),
            reportType: Joi.string().required(),
            recordFrom: Joi.string().required(),
            productType: Joi.number().required().not([null, 'undefined']),
            int_ReportFormat : Joi.number().required().not([null, 'undefined'])
        });
        return checkReportIsVerified;
    }

    VerifyReport() {
        const VerifyReport = Joi.object().keys({
            recordFrom: Joi.string().required(),
            reportOption: Joi.string().required(),
            reportType: Joi.string().required(),
            intReportSerNo: Joi.number().required(),
            strUserId: Joi.string().required(),
            strUserName: Joi.string().required(),
            strReason: Joi.string().allow([""]),
            outOfLimit: Joi.allow(),
            productType: Joi.number().required().not([null, 'undefined']),
            int_ReportFormat : Joi.number().required().not([null, 'undefined'])
        });
        return VerifyReport;
    }

    VerifyExceptionReport() {
        const VerifyReport = Joi.object().keys({
            reportOption: Joi.string().required(),
            reportType: Joi.string().required(),
            intReportSerNo: Joi.number().required(),
            strUserId: Joi.string().required(),
            strUserName: Joi.string().required(),
        });
        return VerifyReport;
    }

    PrintReportCount() {
        const PrintReportCount = Joi.object().keys({
            intReportSerNo: Joi.number().required(),
            intMasterSerNo: Joi.number().required(),
            reportOption: Joi.string().required(),
            reportType: Joi.string().required(),
            recordFrom: Joi.string().required(),
            strReason: Joi.string().allow([""]),
            intPrintCount: Joi.number().required(),
            strUserId: Joi.string().required(),
            strUserName: Joi.string().required(),
            str_url: Joi.string().required(),
            int_ReportFormat : Joi.number().required().not([null, 'undefined'])
        });
        return PrintReportCount;
    }

    getProductCapSchema() {
        const getProductCapSchema = Joi.object().keys({
            recordFrom: Joi.string().required().not(['', null, 'undefined']),
            reportOption: Joi.string().required().not(['', null, 'undefined']),
            reportType: Joi.string().required().not(['', null, 'undefined']),
            testType: Joi.string().required().not(['', null, 'undefined']),
            fromDate: Joi.string().required().not(['', null, 'undefined']),
            toDate: Joi.string().required().not(['', null, 'undefined'])
        });
        return getProductCapSchema;
    }

    viewCapRepSchema() {
        const viewCapsuleReportSchema = Joi.object().keys({
            recordFrom: Joi.string().required().not(['', null, 'undefined']),
            reportOption: Joi.string().required().not(['', null, 'undefined']),
            reportType: Joi.string().required().not(['', null, 'undefined']),
            testType: Joi.string().required().not(['', null, 'undefined']),
            RepSerNo: Joi.number().required().not(['', null, 'undefined']),
            userId: Joi.string().required().not(['', null, 'undefined']),
            username: Joi.string().required().not(['', null, 'undefined']),
            printNo: Joi.allow()

        });
        return viewCapsuleReportSchema;

    }
    
    viewCapRepSchemaMVLRegular() {
        const viewCapRepSchemaMVLRegular = Joi.object().keys({
            RepSerNo: Joi.number().required().not(['', null, 'undefined']),
            BFGCode: Joi.string().required().not(['', null, 'undefined']),
            ProductName: Joi.string().required().not(['', null, 'undefined']),
            PVersion: Joi.string().required().not(['', null, 'undefined']),
            Version: Joi.string().required().not(['', null, 'undefined']),
            batchNo: Joi.string().required().not(['', null, 'undefined']),
            cubicleType: Joi.string().required().not(['', null, 'undefined']),
            Side: Joi.string().required().not(['', null, 'undefined']),
            reportType: Joi.string().required().not(['', null, 'undefined']),
            cubicleSubType: Joi.string().required().not(['', null, 'undefined']),
            recordFrom: Joi.string().required().not(['', null, 'undefined']),
            reportOption: Joi.string().required().not(['', null, 'undefined']),
            testType: Joi.string().required().not(['', null, 'undefined']),
            userId: Joi.string().required().not(['', null, 'undefined']),
            username: Joi.string().required().not(['', null, 'undefined']),
            printNo: Joi.number().required().not(['', null, 'undefined'])
        });
        return viewCapRepSchemaMVLRegular;

    }

    viewCapRepSchemaForOther(){
        const viewCapRepSchemaForOther = Joi.object().keys({
            recordFrom: Joi.string().required().not(['', null, 'undefined']),
            reportOption: Joi.string().required().not(['', null, 'undefined']),
            reportType: Joi.string().required().not(['', null, 'undefined']),
            testType: Joi.string().required().not(['', null, 'undefined']),
            RepSerNo: Joi.number().required().not(['', null, 'undefined']),
            userId: Joi.string().required().not(['', null, 'undefined']),
            username: Joi.string().required().not(['', null, 'undefined']),
            printNo: Joi.allow(),
            idsNo:Joi.allow(),
            batchNo: Joi.allow(),
            cubicleType: Joi.allow(),
            cubicleSubType: Joi.allow(),
            Side: Joi.allow(),
        });
        return viewCapRepSchemaForOther;  
    }

    calculationLODSchema() {
        const getCalculationLODSchema = Joi.object().keys({
            recordFrom: Joi.string().required().not(['', null, 'undefined']),
            RepSerNo: Joi.number().required().not(['', null, 'undefined'])
        });
        return getCalculationLODSchema;
    }

    static auditAdminNameSchema() {
        const adminNameSchema = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return adminNameSchema;
    }
    /**
     * @description Schema for Audit Admin
     * @memberof ReportScema
     */
    static adminPassword() {
        const adminPasswordSchema = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return adminPasswordSchema;
    }

    /** 
     * 
     * 
    */
    static passwordComplexitySchema() {
        console.log("came to the passwordComplexitySchema");
        const adminComplexityPasswordSchema = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return adminComplexityPasswordSchema;
    }

    static rptSetAllParameterSchema() {
        const rptSetAllParameterSchema = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().required().not([null, 'undefined']).allow(""),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptSetAllParameterSchema;
    }
    /**
     * @description Schema for ActivityLog
     * @memberof ReportScema
     */
    static reportActivityLogSchema() {
        const reportActivityLogSchema = Joi.object().keys({
            strTableName: Joi.string().required().not([null, 'undefined']),
            reportObj: Joi.object().keys({
                FileName: Joi.string().required().not([null, 'undefined']),
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().allow("").required(),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                    ActivityType: Joi.string().required().not([null,'undefined']),
                    BatchNo: Joi.allow()
                })
            })
        });
        return reportActivityLogSchema;
    }
    static unAuthoriseLogin() {
        const unAuthoriseLogin = Joi.object().keys({
            strTableName: Joi.string().required().not([null, 'undefined']),
            reportObj: Joi.object().keys({
                FileName: Joi.string().required().not([null, 'undefined']),
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().allow("").required(),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                })
            })
        });
        return unAuthoriseLogin;
    }
    static auditRolesSchema() {
        const auditRoles = Joi.object().keys({
            strTableName: Joi.string().required().not([null, 'undefined']),
            reportObj: Joi.object().keys({
                FileName: Joi.string().required().not([null, 'undefined']),
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().allow("").required(),
                    SelectedAction: Joi.string().allow("").required(),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                })
            })
        });
        return auditRoles;
    }
    static rptAuditUsers() {
        const rptAuditUsers = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().required().not([null, 'undefined']).allow(""),
                    SelectedAction: Joi.string().required().not([null, 'undefined']).allow(""),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptAuditUsers;
    }
    static rptDeparmentSchema() {
        const rptAuditUsers = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().required().not([null, 'undefined']).allow(""),
                    SelectedAction: Joi.string().required().not([null, 'undefined']).allow(""),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptAuditUsers;
    }
    static rptCalibBoxSchema() {
        const rptAuditUsers = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().required().not([null, 'undefined']).allow(""),
                    SelectedAction: Joi.string().required().not([null, 'undefined']).allow(""),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    selectedBoxType: Joi.string().required().not([null, 'undefined']).allow(""),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptAuditUsers;
    }
    static rptBalanceSchema() {
        const rptBalanceSchema = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().required().not([null, 'undefined']).allow(""),
                    SelectedAction: Joi.string().required().not([null, 'undefined']).allow(""),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptBalanceSchema;
    }
    static rptVarnier() {
        const rptVarnier = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().required().not([null, 'undefined']).allow(""),
                    SelectedAction: Joi.string().required().not([null, 'undefined']).allow(""),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptVarnier;
    }
    static rptOtherEquipment() {
        const rptOtherEquipment = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().required().not([null, 'undefined']).allow(""),
                    SelectedAction: Joi.string().required().not([null, 'undefined']).allow(""),
                    SelectedType: Joi.string().required().not([null, 'undefined']).allow(""),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptOtherEquipment;
    }
    static rptMachineSchema() {
        const rptMachineSchema = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().required().not([null, 'undefined']).allow(""),
                    SelectedAction: Joi.string().required().not([null, 'undefined']).allow(""),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptMachineSchema;
    }
    static rptMediaSchema() {
        const rptVarnier = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().required().not([null, 'undefined']).allow(""),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptVarnier;
    }
    
    static rptStageSchema() {
        const rptStageSchema = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().required().not([null, 'undefined']).allow(""),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptStageSchema;
    }

    static rptProductSchema() {
        const rptVarnier = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().required().not([null, 'undefined']).allow(""),
                    SelectedAction: Joi.string().required().not([null, 'undefined']).allow(""),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    prdType: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptVarnier;
    }
    static rptAreaSchema() {
        const rptVarnier = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().required().not([null, 'undefined']).allow(""),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                   // waterMark: Joi.allow(),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptVarnier;
    }

    static rptPortSchema() {
        const rptVarnier = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().required().not([null, 'undefined']).allow(""),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptVarnier;
    }
    static rptCleanerSchema() {
        const rptCleaner = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().required().not([null, 'undefined']).allow(""),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptCleaner;
    }

    static rptContainersSchema() {
        const rptContainersSchema = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().not([null, 'undefined']).allow(""),
                    SelectedAction: Joi.string().not([null, 'undefined']).allow(""),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    tareWeight: Joi.number().required(),
                    lblReleaseIPC: Joi.allow(),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptContainersSchema;
    }

    static rptCubicleSchema() {
        const rptCubicleSchema = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().required().not([null, 'undefined']).allow(""),
                    SelectedAction: Joi.string().required().not([null, 'undefined']).allow(""),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptCubicleSchema;
    }

    static rptRecalibSchema() {
        const rptCubicleSchema = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().required().not([null, 'undefined']).allow(""),
                    SelectedAction: Joi.string().required().not([null, 'undefined']).allow(""),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptCubicleSchema;
    }



    static PrintReportCountMVL() {
        const prntReportCount = Joi.object().keys({
            intReportSerNo: Joi.number().required(),
            reportOption: Joi.string().required(),
            reportType: Joi.string().required(),
            recordFrom: Joi.string().required(),
            strReason: Joi.string().allow([""]),
            intPrintCount: Joi.number().required(),
            strUserId: Joi.string().required(),
            strUserName: Joi.string().required()
        });
        return prntReportCount;
    }

    static PrintReportCountDosaDry() {
        const PrintReportCountDosaDry = Joi.object().keys({
            intReportSerNo: Joi.array(),
            reportOption: Joi.string().required(),
            reportType: Joi.string().required(),
            recordFrom: Joi.string().required(),
            strReason: Joi.string().allow([""]),
            intPrintCount: Joi.number().required(),
            strUserId: Joi.string().required(),
            strUserName: Joi.string().required(),
            MasterNo:Joi.number().required()
        });
        return PrintReportCountDosaDry;
    }


    static PrintReportCountSummary() {
        const PrintReportCountSummary = Joi.object().keys({
            str_batchNo: Joi.string().required(),
            str_cubicname: Joi.string().required(),
            str_side: Joi.string().required(),
            str_cubType: Joi.string().required(),
            str_reportOption: Joi.string().required(),
            // str_prdID: Joi.string().required(),
            // str_prdName: Joi.string().required(),
            // str_prdVersion: Joi.string().required(),
            // str_version: Joi.string().required(),
            str_MPNCode: Joi.string().required(),
            int_printNo: Joi.number().required(),
            strUserId: Joi.string().required(),
            strUserName: Joi.string().required(),
            strReason: Joi.string().allow([""]),
            str_prdType: Joi.string().required()
        });
        return PrintReportCountSummary;
    }
    
    static increasePrintCountBinSummarySchema() {
        const increasePrintCountBinSummarySchema = Joi.object().keys({
            str_batchNo: Joi.string().required(),
            str_type: Joi.string().required(),
            str_ICReport: Joi.string().required(),
            str_prdID: Joi.string().required(),
            str_prdName: Joi.string().required(),
            str_prdVersion: Joi.string().required(),
            str_version: Joi.string().required(),
            int_printNo: Joi.allow(),
            strUserId: Joi.string().required(),
            strUserName: Joi.string().required(),
            strReason: Joi.string().allow([""]),
            lblBinText: Joi.string().required(),
            rptLabelForActivity: Joi.string().required(),
        });
        return increasePrintCountBinSummarySchema;
    }

    static printcountupBinLabelSchema() {
        const printcountupBinLabelSchema = Joi.object().keys({
            str_batchNo: Joi.string().required(),
            str_type: Joi.string().required(),
            str_ICReport: Joi.string().required(),
            int_printNo: Joi.allow(),
            intRecNo: Joi.number().required(),
            strUserId: Joi.string().required(),
            strUserName: Joi.string().required(),
            strReason: Joi.string().allow([""]),
            str_prdID: Joi.string().required(),
            str_prdName: Joi.string().required(),
            str_prdVersion: Joi.string().required(),
            str_version: Joi.string().required(),
            rptLabelForActivity: Joi.string().required(),
        });
        return printcountupBinLabelSchema;
    }

    static printReasonReportCalib() {
        const printReasonReport = Joi.object().keys({
            calibrationType: Joi.allow(),
            calibChange:Joi.allow(),
            reportType: Joi.string().required().not([null, 'undefined']),
            printNo: Joi.number().required().not([null, 'undefined']),
            BalanceID: Joi.string().required().not([null, 'undefined']),
            userId: Joi.string().required().not([null, 'undefined']),
            userName: Joi.string().required().not([null, 'undefined']),
            date: Joi.string().required().not([null, 'undefined']),
            repserno: Joi.number().required().not([null, 'undefined']).allow([""])
        });

        return printReasonReport;
    }

    static printReasonReportCalibVernier() {
        const printReasonReport = Joi.object().keys({
            calibrationType: Joi.string().required().not([null, 'undefined']),
            reportType: Joi.string().required().not([null, 'undefined']),
            printNo: Joi.number().required().not([null, 'undefined']),
            VernierCode: Joi.string().required().not([null, 'undefined']),
            userId: Joi.string().required().not([null, 'undefined']),
            userName: Joi.string().required().not([null, 'undefined']),
            date: Joi.string().required().not([null, 'undefined']),
            repserno: Joi.number().required().not([null, 'undefined']).allow([""])
        });

        return printReasonReport;
    }
    static PrintCountCalibrationSchema() {
        const PrintCountCalibrationSchema = Joi.object().keys({
            calibrationType: Joi.string().required().not([null, 'undefined']),
            date: Joi.string().required().not([null, 'undefined']),
            reportType: Joi.string().required().not([null, 'undefined']),
            printNo: Joi.number().required().not([null, 'undefined']),
            strReason: Joi.string().required().not([null, 'undefined']).allow([""]),
            BalanceID: Joi.string().required().not([null, 'undefined']),
            userID: Joi.string().required().not([null, 'undefined']),
            username: Joi.string().required().not([null, 'undefined']),
            repSrNo: Joi.number().required().not([null, 'undefined']).allow([""]),
            calibType: Joi.allow(),
            calibChange: Joi.allow()
        });
        return PrintCountCalibrationSchema;
    }

    static PrintCountCalibrationSchemaVernier() {
        const PrintCountCalibrationSchemaVernier = Joi.object().keys({
            calibrationType: Joi.string().required().not([null, 'undefined']),
            date: Joi.string().required().not([null, 'undefined']),
            reportType: Joi.string().required().not([null, 'undefined']),
            printNo: Joi.number().required().not([null, 'undefined']),
            strReason: Joi.string().required().not([null, 'undefined']).allow([""]),
            VernierCode: Joi.string().required().not([null, 'undefined']),
            userID: Joi.string().required().not([null, 'undefined']),
            username: Joi.string().required().not([null, 'undefined']),
            repSrNo: Joi.number().required().not([null, 'undefined']).allow([""]),
            eqpType: Joi.string().required().not([null, 'undefined'])
        });
        return PrintCountCalibrationSchemaVernier;
    }

    static rptAlertSchema() {
        const rptAlert = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().required().not([null, 'undefined']).allow(""),
                    SelectedAction: Joi.string().not([null, 'undefined']).allow(""),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptAlert;
    }

    static rptAuditYieldSchema() {
        const rptAuditYield = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().required().not([null, 'undefined']).allow(""),
                    SelectedAction: Joi.string().not([null, 'undefined']).allow(""),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    prdType: Joi.string().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptAuditYield;
    }
    
    static rptAuditPrecalibrationSchema() {
        const rptPrecalibrationSchema = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().required().not([null, 'undefined']).allow(""),
                    SelectedAction: Joi.string().required().not([null, 'undefined']).allow(""),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                    waterMark: Joi.boolean().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptPrecalibrationSchema;
    }

    static printcountupYield() {
        const printcountupYield = Joi.object().keys({
            RepSerNo: Joi.number().required(),
            str_batchNo: Joi.string().required(),
            str_type: Joi.string().required(),
            str_YieldType: Joi.string().required(),
            int_printNo: Joi.number().required(),
            strUserId: Joi.string().required(),
            strUserName: Joi.string().required(),
            strReason: Joi.string().allow([""]),
            str_prdID: Joi.string().required(),
            str_prdName: Joi.string().required(),
            str_prdVersion: Joi.string().required(),
            str_version: Joi.string().required()
        });
        return printcountupYield;
    }

    static periodicCalibrationRemarkForFailed() {
        const periodicCalibrationRemarkForFailed = Joi.object().keys({
            repSrNo: Joi.number().required(),
            strReason: Joi.string().allow([""]),
            strUserId: Joi.string().required().not([null, 'undefined']),
            strUserName: Joi.string().required().not([null, 'undefined']),
        });
        return periodicCalibrationRemarkForFailed;
    }

     calculationLODCapSchema(){
        const calculationLODCapSchema = Joi.object().keys({
            recordFrom: Joi.string().required().not(['', null, 'undefined']),
            RepSerNo: Joi.number().required().not(['', null, 'undefined'])
        });
        return calculationLODCapSchema;
    }

    static rptContentSchema() {
        const rptContent = Joi.object().keys({
            strTableName: Joi.string().required().not(['undefined', null]),
            reportObj: Joi.object().keys({
                data: Joi.object().keys({
                    UserName: Joi.string().required().not([null, 'undefined']),
                    UserId: Joi.string().required().not([null, 'undefined']),
                    SelectedValue: Joi.string().required().not([null, 'undefined']).allow(""),
                    FromDate: Joi.string().required().not([null, 'undefined']),
                    ToDate: Joi.string().required().not([null, 'undefined']),
                }),
                FileName: Joi.string().required().not([null, 'undefined']),
            })
        });
        return rptContent;
    }

    getWeighmentReportSchema() {
        const getWeighmentReportSchema = Joi.object().keys({
            fromDate: Joi.string().required().not(['', null, 'undefined']),
            toDate: Joi.string().required().not(['', null, 'undefined']),
            reportOption: Joi.string().max(30).required().not(['', null, 'undefined']),
            testType: Joi.string().required().not(['', null, 'undefined']),
            reportType: Joi.string().required().not(['', null, 'undefined']),
            recordFrom: Joi.string().required().not(['', null, 'undefined']),
            str_tabletCapsule: Joi.string().required().not(['', null, 'undefined']),
            int_ReportFormat : Joi.number().required().not([null, 'undefined'])
        });
        return getWeighmentReportSchema;
    } 

    viewReportSchema() {
        const viewReportSchema = Joi.object().keys({
            recordFrom : Joi.string().required().not(['',null,'undefined']),
            reportOption : Joi.string().required().not(['',null,'undefined']),
            reportType : Joi.string().required().not(['',null,'undefined']),
            testType : Joi.string().required().not(['', null, 'undefined']),
            RepSerNo : Joi.number().required().not(['', null, 'undefined']),
            userId : Joi.string().required().not(['', null, 'undefined']),
            username : Joi.string().required().not(['', null, 'undefined']),
            printNo : Joi.number().required().not(['', null, 'undefined']),
            str_url : Joi.string().required().not(['', null, 'undefined']),
            int_ReportFormat : Joi.number().required().not([null, 'undefined']),
            Side : Joi.string().required().not(['', null, 'undefined']),
            cubicleType : Joi.string().required().not(['', null, 'undefined']),
            batchNo : Joi.string().required().not(['', null, 'undefined']),
            str_hmi: Joi.allow(),
            str_source: Joi.allow()
        });
        return viewReportSchema;
    }
   
    getWeighmentReportConsolidatedSchema() {
        const getWeighmentReportConsolidatedSchema = Joi.object().keys({
            fromDate: Joi.string().required().not(['', null, 'undefined']),
            toDate: Joi.string().required().not(['', null, 'undefined']),
            reportOption: Joi.string().max(30).required().not(['', null, 'undefined']),
            testType: Joi.string().required().not(['', null, 'undefined']),
            reportType: Joi.string().required().not(['', null, 'undefined']),
            recordFrom: Joi.string().required().not(['', null, 'undefined']),
            str_tabletCapsule: Joi.string().required().not(['', null, 'undefined']),
            int_ReportFormat : Joi.number().required().not([null, 'undefined'])
        });
        return getWeighmentReportConsolidatedSchema;
    }

    viewConsolidateReportSchema() {
        const viewConsolidateReportSchema = Joi.object().keys({
            recordFrom : Joi.string().required().not(['',null,'undefined']),
            reportOption : Joi.string().required().not(['',null,'undefined']),
            reportType : Joi.string().required().not(['',null,'undefined']),
            testType : Joi.string().required().not(['', null, 'undefined']),
            RepSerNo : Joi.number().required().not(['', null, 'undefined']),
            userId : Joi.string().required().not(['', null, 'undefined']),
            username : Joi.string().required().not(['', null, 'undefined']),
            printNo : Joi.number().required().not(['', null, 'undefined']),
            str_url : Joi.string().required().not(['', null, 'undefined']),
            ProdID : Joi.string().required().not(['',null,'undefined']),
            ProdName : Joi.string().required().not(['',null,'undefined']),
            ProdVersion : Joi.string().required().not(['',null,'undefined']),
            Version : Joi.string().required().not(['',null,'undefined']),
            BatchNo : Joi.string().required().not(['',null,'undefined']),
            Side : Joi.string().required().not(['',null,'undefined']),
            CubicleType : Joi.string().required().not(['',null,'undefined']),
            MstSerNo : Joi.number().required().not(['', null, 'undefined']),
            int_ReportFormat : Joi.number().required().not([null, 'undefined'])
        });
        return viewConsolidateReportSchema;
    }

}
module.exports = ReportSchema;