const BaseJoi = require('joi');
const Extension = require('joi-date-extensions');
const Joi = BaseJoi.extend(Extension);

class Recalibraion {
    calibrationMasterDataSchema()
    { 
        const calibrationMasterDataSchema = Joi.object().keys({
            Type: Joi.string().max(100).required().not(['',null,'undefined']),
            dates: Joi.date().empty("").default('now').format('YYYY-MM-DD'),
            id: Joi.string().max(50).required().not(['',null,'undefined']),
            int_cubicNo: Joi.number().required().not([null, 'undefined']),
            strSelectedInstrumentType: Joi.string().max(100).required().not(['',null,'undefined']),
            strProjectName: Joi.string().allow(null),
            int_dailyPeriodic: Joi.allow()
        });
        
        return calibrationMasterDataSchema;
    }

    addReCalibrationSchema()
    { 
        const addReCalibrationSchema = Joi.object().keys({
            calibType: Joi.string().max(100).required().not(['',null,'undefined']),
            equipmentId: Joi.string().max(50).required().not(['',null,'undefined']),
            remark: Joi.string().max(500).required().not(['',null,'undefined']),
            strSelectedInstrumentType: Joi.string().max(100).required().not(['',null,'undefined']),
            act: Joi.string().allow(null),
            userID: Joi.string().max(100).required().not(['',null,'undefined']),
            userName: Joi.string().max(500).required().not(['',null,'undefined'])
        });
        
        return addReCalibrationSchema;
    }
}



module.exports = Recalibraion;