const Joi = require('joi');

class LoginSchema {
    LoginMainSchema()
    { 
        const LoginMainSchema = Joi.object().keys({
            userId: Joi.string().required().not(['',null,'undefined']),
            userPass: Joi.string().required().not(['',null,'undefined']),
            source: Joi.string().required().not(['',null,'undefined']),
            hmi:Joi.optional()
        });
        
        return LoginMainSchema;
    }

    chkUserActiveSchema()
    { 
        const chkUserActiveSchema = Joi.object().keys({
            userId: Joi.string().required().not(['',null,'undefined'])
        });
        
        return chkUserActiveSchema;
    }

    setUserActiveSchema(){
        const setUserActiveSchema = Joi.object().keys({
            userId: Joi.string().required().not(['',null,'undefined']),
            source: Joi.string().required().not(['',null,'undefined'])
        });
        
        return setUserActiveSchema;
    }

    logOutSchema(){
        const logOutSchema = Joi.object().keys({
            userId: Joi.string().required().not(['',null,'undefined']),
            mode: Joi.string().required().not(['',null,'undefined'])
        });
        
        return logOutSchema;
    }

    updatePasswordSchema(){
        const updatePasswordSchema = Joi.object().keys({
            status: Joi.number().required().not(['',null,'undefined']),
            userId: Joi.string().required().not(['',null,'undefined']),
            userName: Joi.string().required().not(['',null,'undefined']),
            userOldPassword: Joi.string().required().not(['',null,'undefined']),
            userPassword:Joi.string().required().not(['',null,'undefined']),
            remark:Joi.string().required().not(['',null,'undefined'])
        });
        
        return updatePasswordSchema;
    }

    
    passwordHistorySchema(){
        const passwordHistorySchema = Joi.object().keys({
            userId: Joi.string().required().not(['',null,'undefined'])
        });
        
        return passwordHistorySchema;
    }

    updateUserLockSchema(){
        const updateUserLockSchema = Joi.object().keys({
            userId: Joi.string().required().not(['',null,'undefined']),
            ACT:Joi.string().required().not(['',null,'undefined']),
            Remark:Joi.string().required().not(['',null,'undefined'])
        });
        
        return updateUserLockSchema;
    }
}




module.exports = LoginSchema;