const Joi = require('joi');
// const { join } = require('mysql2/lib/constants/charset_encodings');

class Cubicle {
    static updateSchema()
    { 
        const updateSchema = Joi.object().keys({
            Sys_Area: Joi.string().max(200).required().not(['', null, 'undefined']),
            Sys_CubicType: Joi.string().max(100).required().not(['', null, 'undefined']),
            Sys_CubicNo : Joi.number().required().not(['', null, 'undefined']),
            Sys_CubicName: Joi.string().max(100).required().not(['', null, 'undefined']),
            Sys_Validation: Joi.number().required(),
            Sys_RptType: Joi.number().required().default(1),
            Sys_RotaryType: Joi.string().max(50).required().not(['', null, 'undefined']),
            Sys_dept: Joi.string().max(200).required().not(['', null, 'undefined']),
            Sys_IPQCType: Joi.string().max(200).required().not(['', null, 'undefined']),
            Sys_BFGCode: Joi.string().max(100).required().not(['',null,'undefined']),
            Sys_ProductName: Joi.string().max(300).required().not(['',null,'undefined']),
            Sys_Version: Joi.string().max(50).required().not(['', null, 'undefined']),
            Sys_PVersion: Joi.string().max(50).required().not(['', null, 'undefined']),
            Sys_Batch: Joi.string().max(30).required().not(['',null,'undefined']),
            Sys_BatchSize : Joi.allow(),
            Sys_BatchSizeUnit : Joi.string().max(200).required().not(['',null,'undefined']),
            Sys_Stage: Joi.string().max(100).required().not(['', null, 'undefined']),
            Sys_media: Joi.string().max(50).required().not(['', null, 'undefined']),
            Sys_PrinterName: Joi.string().max(500).required().not(['', null, 'undefined']),
            Sys_Machine_Min: Joi.number().required(),
            Sys_Machine_Max: Joi.number().required(),
            int_shiftCubicNo: Joi.number().required(),
            str_shiftOrPausedInSame: Joi.string().required(),
            Status: Joi.string().max(50).required().not(['', null, 'undefined']),
            Action: Joi.string().max(50).required().not(['', null, 'undefined']),
            Remark: Joi.string().max(500).required().not(['', null, 'undefined']),
            NewData : Joi.string().required().not(['', null, 'undefined']),
            OldData: Joi.string().required().not(['', null, 'undefined']),
            username: Joi.string().max(255).required().not(['', null, 'undefined']),
            userid: Joi.string().max(50).required().not(['', null, 'undefined']),
            activity: Joi.string().max(50).required().not(['', null, 'undefined']),
            str_oldBatch: Joi.string().allow(""),
            Sys_Batch_Status: Joi.string().allow(""),
            bln_changePrd: Joi.boolean(),
            int_batchReuseForDb: Joi.allow()
        });
        
        return updateSchema;
    }

    static updateStausSchema() { 
        const objStatusUpdate = Joi.object().keys({
            Status: Joi.string().max(30).required().not(['', null, 'undefined']),
            Sys_CubicType: Joi.string().max(30).required().not(['', null, 'undefined']),
            Batch: Joi.string().max(30).required().not(['', null, 'undefined']),
            Sys_CubicNo : Joi.number().required().not(['', null, 'undefined']),
            Sys_CubicName : Joi.string().max(100).required().not(['', null, 'undefined']),
            Sys_Area: Joi.string().max(200).required().not(['', null, 'undefined']),
            Action: Joi.string().max(50).required().not(['', null, 'undefined']),
            Remark: Joi.string().max(500).required().not(['', null, 'undefined']),
            username: Joi.string().max(255).required().not(['', null, 'undefined']),
            userid: Joi.string().max(50).required().not(['', null, 'undefined']),
            activity: Joi.string().max(50).required().not(['', null, 'undefined']),
            Sys_BFGCode: Joi.string().max(100).required().not(['',null,'undefined']),
            Sys_ProductName: Joi.string().max(300).required().not(['',null,'undefined']),
            Sys_Version: Joi.string().max(50).required().not(['', null, 'undefined']),
            Sys_PVersion: Joi.string().max(50).required().not(['', null, 'undefined']),
            str_oldData:Joi.string().allow("")
        });
        
        return objStatusUpdate;
    }

    static saveLimitSchema()
    { 
        const saveLimitSchema = Joi.object().keys({
            Sys_Area: Joi.string().max(200).required().not(['', null, 'undefined']),
            Sys_CubicNo : Joi.number().required().not(['', null, 'undefined']),
            Sys_CubicName: Joi.string().max(100).required().not(['', null, 'undefined']),
            Sys_Batch: Joi.string().max(30).required().not(['',null,'undefined']),
            Remark: Joi.string().max(500).required().not(['', null, 'undefined']),
            NewData : Joi.string().required().not(['', null, 'undefined']),
            OldData: Joi.string().required().not(['', null, 'undefined']),
            username: Joi.string().max(255).required().not(['', null, 'undefined']),
            userid: Joi.string().max(50).required().not(['', null, 'undefined']),
            activity: Joi.string().max(50).required().not(['', null, 'undefined']),
            Sys_BFGCode: Joi.string().max(100).required().not(['',null,'undefined']),
            Sys_ProductName: Joi.string().max(300).required().not(['',null,'undefined']),
            Sys_Version: Joi.string().max(50).required().not(['', null, 'undefined']),
            Sys_PVersion: Joi.string().max(50).required().not(['', null, 'undefined']),
            Ind_Nom: Joi.number().required().not(['', null, 'undefined']),
            Ind_DP: Joi.number().required(),
            Grp_Nom: Joi.number().required().not(['', null, 'undefined']),
            Grp_DP: Joi.number().required(),
            Empty_Nom: Joi.number().required().not(['', null, 'undefined']),
            Empty_DP: Joi.number().required(),
            Net_Nom: Joi.number().required().not(['', null, 'undefined']),
            Net_DP: Joi.number().required(),
            Len_Nom: Joi.number().required().not(['', null, 'undefined']),
            str_productDetail:Joi.string().required().not(['', null, 'undefined'])
        });
        
        return saveLimitSchema;
    }

}

module.exports = Cubicle