/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintBookmark;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementJsonHandler;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JsonExporterContext;
import net.sf.jasperreports.engine.util.HyperlinkData;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.JsonExporterConfiguration;
import net.sf.jasperreports.export.JsonReportConfiguration;
import net.sf.jasperreports.export.WriterExporterOutput;
import net.sf.jasperreports.export.parameters.ParametersWriterExporterOutput;
import net.sf.jasperreports.web.util.JacksonUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonExporter
extends JRAbstractExporter<JsonReportConfiguration, JsonExporterConfiguration, WriterExporterOutput, JsonExporterContext> {
    private static final Log log = LogFactory.getLog(JsonExporter.class);
    public static final String JSON_EXPORTER_KEY = "net.sf.jasperreports.json";
    protected static final String JSON_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.json.";
    protected Writer writer;
    protected int reportIndex;
    protected int pageIndex;
    private boolean gotFirstJsonFragment;
    private JacksonUtil jacksonUtil;
    private List<HyperlinkData> hyperlinksData;

    public JsonExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JsonExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
        this.jacksonUtil = JacksonUtil.getInstance(jasperReportsContext);
        this.hyperlinksData = new ArrayList<HyperlinkData>();
    }

    @Override
    protected Class<JsonExporterConfiguration> getConfigurationInterface() {
        return JsonExporterConfiguration.class;
    }

    @Override
    protected Class<JsonReportConfiguration> getItemConfigurationInterface() {
        return JsonReportConfiguration.class;
    }

    @Override
    protected void ensureOutput() {
        if (this.exporterOutput == null) {
            this.exporterOutput = new ParametersWriterExporterOutput(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint());
        }
    }

    @Override
    public String getExporterKey() {
        return JSON_EXPORTER_KEY;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return JSON_EXPORTER_PROPERTIES_PREFIX;
    }

    @Override
    public void exportReport() throws JRException {
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.initExport();
        this.ensureOutput();
        this.writer = ((WriterExporterOutput)this.getExporterOutput()).getWriter();
        try {
            this.exportReportToWriter();
        }
        catch (IOException e) {
            throw new JRException("Error writing to output writer : " + this.jasperPrint.getName(), e);
        }
        finally {
            ((WriterExporterOutput)this.getExporterOutput()).close();
            this.resetExportContext();
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
    }

    @Override
    protected void initReport() {
        super.initReport();
    }

    protected void exportReportToWriter() throws JRException, IOException {
        this.writer.write("{\n");
        List<ExporterInputItem> items = this.exporterInput.getItems();
        this.reportIndex = 0;
        while (this.reportIndex < items.size()) {
            ExporterInputItem item = items.get(this.reportIndex);
            this.setCurrentExporterInputItem(item);
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                JRAbstractExporter.PageRange pageRange = this.getPageRange();
                int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                int endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
                JRPrintPage page = null;
                this.pageIndex = startPageIndex;
                while (this.pageIndex <= endPageIndex) {
                    if (Thread.interrupted()) {
                        throw new JRException("Current thread interrupted.");
                    }
                    page = pages.get(this.pageIndex);
                    this.exportPage(page);
                    if (this.reportIndex < items.size() - 1 || this.pageIndex < endPageIndex) {
                        this.writer.write("\n");
                    }
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        this.writer.write("\n}");
        boolean flushOutput = ((JsonExporterConfiguration)this.getCurrentConfiguration()).isFlushOutput();
        if (flushOutput) {
            this.writer.flush();
        }
    }

    protected void exportPage(JRPrintPage page) throws IOException {
        List<JRPrintElement> elements = page.getElements();
        this.exportElements(elements);
        this.exportBookmarks();
        this.exportWebFonts();
        this.exportHyperlinks();
        JRExportProgressMonitor progressMonitor = ((JsonReportConfiguration)this.getCurrentItemConfiguration()).getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(Collection<JRPrintElement> elements) throws IOException {
        if (elements != null && elements.size() > 0) {
            for (JRPrintElement element : elements) {
                if (this.filter != null && !this.filter.isToExport(element)) continue;
                if (element instanceof JRPrintFrame) {
                    this.exportFrame((JRPrintFrame)element);
                    continue;
                }
                if (!(element instanceof JRGenericPrintElement)) continue;
                this.exportGenericElement((JRGenericPrintElement)element);
            }
        }
    }

    protected void exportFrame(JRPrintFrame frame) throws IOException {
        this.exportElements(frame.getElements());
    }

    protected void exportBookmarks() throws IOException {
        List<PrintBookmark> bookmarks = this.jasperPrint.getBookmarks();
        if (bookmarks != null && bookmarks.size() > 0) {
            if (this.gotFirstJsonFragment) {
                this.writer.write(",\n");
            } else {
                this.gotFirstJsonFragment = true;
            }
            this.writer.write("\"bkmrk_" + (bookmarks.hashCode() & Integer.MAX_VALUE) + "\": {");
            this.writer.write("\"id\": \"bkmrk_" + (bookmarks.hashCode() & Integer.MAX_VALUE) + "\",");
            this.writer.write("\"type\": \"bookmarks\",");
            this.writer.write("\"bookmarks\": " + this.jacksonUtil.getJsonString(bookmarks));
            this.writer.write("}");
        }
    }

    protected void exportWebFonts() throws IOException {
        ReportContext reportContext = this.getReportContext();
        String webFontsParameter = "net.sf.jasperreports.html.webfonts";
        if (reportContext != null && reportContext.containsParameter(webFontsParameter)) {
            ArrayNode webFonts = (ArrayNode)reportContext.getParameterValue(webFontsParameter);
            if (this.gotFirstJsonFragment) {
                this.writer.write(",\n");
            } else {
                this.gotFirstJsonFragment = true;
            }
            this.writer.write("\"webfonts_" + (webFonts.hashCode() & Integer.MAX_VALUE) + "\": {");
            this.writer.write("\"id\": \"webfonts_" + (webFonts.hashCode() & Integer.MAX_VALUE) + "\",");
            this.writer.write("\"type\": \"webfonts\",");
            this.writer.write("\"webfonts\": " + this.jacksonUtil.getJsonString(webFonts));
            this.writer.write("}");
        }
    }

    protected void exportHyperlinks() throws IOException {
        ReportContext reportContext = this.getReportContext();
        String hyperlinksParameter = "net.sf.jasperreports.html.hyperlinks";
        if (reportContext != null && reportContext.containsParameter(hyperlinksParameter)) {
            List contextHyperlinksData = (List)reportContext.getParameterValue(hyperlinksParameter);
            this.hyperlinksData.addAll(contextHyperlinksData);
        }
        if (this.hyperlinksData.size() > 0) {
            String id = "hyperlinks_" + (this.hyperlinksData.hashCode() & Integer.MAX_VALUE);
            if (this.gotFirstJsonFragment) {
                this.writer.write(",\n");
            } else {
                this.gotFirstJsonFragment = true;
            }
            this.writer.write("\"" + id + "\": {");
            this.writer.write("\"id\": \"" + id + "\",");
            this.writer.write("\"type\": \"hyperlinks\",");
            this.writer.write("\"hyperlinks\": ");
            ObjectMapper mapper = new ObjectMapper();
            ArrayNode hyperlinkArray = mapper.createArrayNode();
            for (HyperlinkData hd : this.hyperlinksData) {
                JRPrintHyperlink hyperlink = hd.getHyperlink();
                ObjectNode hyperlinkNode = this.jacksonUtil.hyperlinkToJsonObject(hyperlink);
                this.jacksonUtil.addProperty(hyperlinkNode, "id", hd.getId());
                this.jacksonUtil.addProperty(hyperlinkNode, "href", hd.getHref());
                this.jacksonUtil.addProperty(hyperlinkNode, "selector", hd.getSelector());
                hyperlinkArray.add((JsonNode)hyperlinkNode);
            }
            this.writer.write(this.jacksonUtil.getJsonString(hyperlinkArray));
            this.writer.write("}");
        }
    }

    protected void exportGenericElement(JRGenericPrintElement element) throws IOException {
        GenericElementJsonHandler handler = (GenericElementJsonHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), JSON_EXPORTER_KEY);
        if (handler != null) {
            String fragment = handler.getJsonFragment((JsonExporterContext)this.exporterContext, element);
            if (fragment != null && !fragment.isEmpty()) {
                if (this.gotFirstJsonFragment) {
                    this.writer.write(",\n");
                } else {
                    this.gotFirstJsonFragment = true;
                }
                this.writer.write(fragment);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No JSON generic element handler for " + element.getGenericType()));
        }
    }

    protected String resolveHyperlinkURL(int reportIndex, JRPrintHyperlink link) {
        String href;
        block13: {
            JRHyperlinkProducer customHandler;
            block14: {
                href = null;
                Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink("net.sf.jasperreports.export.html.ignore.hyperlink", link);
                if (ignoreHyperlink == null) {
                    ignoreHyperlink = ((JsonReportConfiguration)this.getCurrentItemConfiguration()).isIgnoreHyperlink();
                }
                if (ignoreHyperlink.booleanValue()) break block13;
                customHandler = this.getHyperlinkProducer(link);
                if (customHandler != null) break block14;
                switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() != null) {
                            href = link.getHyperlinkReference();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_ANCHOR: {
                        if (link.getHyperlinkAnchor() != null) {
                            href = "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_PAGE: {
                        if (link.getHyperlinkPage() != null) {
                            href = "#JR_PAGE_ANCHOR_" + reportIndex + "_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_PAGE: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkPage() != null) {
                            href = link.getHyperlinkReference() + "#" + "JR_PAGE_ANCHOR_" + "0_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            href = customHandler.getHyperlink(link);
        }
        return href;
    }

    public void addHyperlinkData(HyperlinkData hyperlinkData) {
        this.hyperlinksData.add(hyperlinkData);
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JsonExporterContext {
        protected ExporterContext() {
        }

        @Override
        public String getHyperlinkURL(JRPrintHyperlink link) {
            return JsonExporter.this.resolveHyperlinkURL(JsonExporter.this.reportIndex, link);
        }
    }
}

