/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.chartData;

import java.util.HashMap;
import java.util.Iterator;
import org.jCharts.chartData.interfaces.IAxisChartDataSet;
import org.jCharts.chartData.interfaces.IAxisPlotDataSet;
import org.jCharts.chartData.interfaces.IDataSeries;
import org.jCharts.test.HTMLGenerator;
import org.jCharts.test.HTMLTestable;
import org.jCharts.types.ChartType;

public final class DataSeries
implements IDataSeries,
HTMLTestable {
    private String chartTitle;
    private String xAxisTitle;
    private String yAxisTitle;
    private String[] xAxisLabels;
    protected HashMap dataSets;
    private int totalNumberOfDataSets = 0;

    public DataSeries(String[] stringArray, String string, String string2, String string3) {
        this.xAxisLabels = stringArray;
        this.xAxisTitle = string;
        this.yAxisTitle = string2;
        this.chartTitle = string3;
        this.dataSets = new HashMap();
    }

    public int getNumberOfIAxisChartDataSets() {
        return this.dataSets.size();
    }

    public int getNumberOfIAxisPlotDataSets() {
        return this.dataSets.size();
    }

    public String getXAxisTitle() {
        return this.xAxisTitle;
    }

    public String getYAxisTitle() {
        return this.yAxisTitle;
    }

    public String getChartTitle() {
        return this.chartTitle;
    }

    public String getXAxisLabel(int n) {
        return this.xAxisLabels[n];
    }

    public int getNumberOfXAxisLabels() {
        return this.xAxisLabels.length;
    }

    public IAxisChartDataSet getIAxisChartDataSet(ChartType chartType) {
        return (IAxisChartDataSet)this.dataSets.get(chartType);
    }

    public IAxisPlotDataSet getIAxisPlotDataSet(ChartType chartType) {
        return (IAxisPlotDataSet)this.dataSets.get(chartType);
    }

    public Iterator getIAxisPlotDataSetIterator() {
        return this.dataSets.values().iterator();
    }

    public void addIAxisPlotDataSet(IAxisPlotDataSet iAxisPlotDataSet) {
        this.dataSets.put(iAxisPlotDataSet.getChartType(), iAxisPlotDataSet);
        this.totalNumberOfDataSets += iAxisPlotDataSet.getNumberOfDataSets();
    }

    public Iterator getIAxisChartDataSetIterator() {
        return this.dataSets.values().iterator();
    }

    public void addIAxisChartDataSet(IAxisChartDataSet iAxisChartDataSet) {
        this.dataSets.put(iAxisChartDataSet.getChartType(), iAxisChartDataSet);
        this.totalNumberOfDataSets += iAxisChartDataSet.getNumberOfDataSets();
    }

    public int getTotalNumberOfDataSets() {
        return this.totalNumberOfDataSets;
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.propertiesTableRowStart();
        hTMLGenerator.propertiesTableStart(this.getClass().getName());
        hTMLGenerator.addTableRow("xAxisLabels", HTMLGenerator.arrayToString(this.xAxisLabels));
        hTMLGenerator.addTableRow("xAxisTitle", this.xAxisTitle);
        hTMLGenerator.addTableRow("yAxisTitle", this.yAxisTitle);
        hTMLGenerator.addTableRow("totalNumberOfDataSets", Integer.toString(this.totalNumberOfDataSets));
        hTMLGenerator.propertiesTableEnd();
        hTMLGenerator.propertiesTableRowEnd();
        hTMLGenerator.propertiesTableRowStart();
        Iterator iterator = this.getIAxisPlotDataSetIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof HTMLTestable)) continue;
            ((HTMLTestable)e).toHTML(hTMLGenerator);
        }
        hTMLGenerator.propertiesTableRowEnd();
    }
}

